#include <util.h>


typedef union {
	struct {
		unsigned int tm_lowcmp_en:1;
		unsigned int tm_low_thr:7;
		unsigned int tm_highcmp_en:1;
		unsigned int tm_high_thr:7;
		unsigned int pwron_dly:16;
	} f;
	unsigned int v;
} THERMAL_CTRL_0_T;
#define THERMAL_CTRL_0rv (*((regval)0xbb000130))
#define RMOD_THERMAL_CTRL_0(...) rset(THERMAL_CTRL_0, THERMAL_CTRL_2rv, __VA_ARGS__)
#define RFLD_THERMAL_CTRL_0(fld) (*((const volatile THERMAL_CTRL_0_T *)0xbb000130)).f.fld

typedef union {
	struct {
		unsigned int no_use31_27:5;
		unsigned int cfg_int_tm_neg:1;
		unsigned int tm_high2cmp_en:1;
		unsigned int tm_high2_thr:7;
		unsigned int reverse_cmp_out:1;
		unsigned int tm_enable:1;
		unsigned int no_use15:1;
		unsigned int sbg:3;
		unsigned int sos:3;
		unsigned int sinl:2;
		unsigned int en_chop:1;
		unsigned int sw2_sw3_reverse:1;
		unsigned int chop_swcnt:5;
	} f;
	unsigned int v;
} THERMAL_CTRL_2_T;
#define THERMAL_CTRL_2rv (*((regval)0xbb000138))
#define RMOD_THERMAL_CTRL_2(...) rset(THERMAL_CTRL_2, THERMAL_CTRL_2rv, __VA_ARGS__)
#define RFLD_THERMAL_CTRL_2(fld) (*((const volatile THERMAL_CTRL_2_T *)0xbb000138)).f.fld

typedef union {
	struct {
		unsigned int no_use31_26:6;
		unsigned int data_sampled:1;
		unsigned int data_valid:1;
		unsigned int no_use23:1;
		unsigned int temp_out:7;
		unsigned int no_use15_7:9;
		unsigned int temp_out_por:7;
	} f;
	unsigned int v;
} THERMAL_STS_0_T;
#define THERMAL_STS_0rv (*((regval)0xbb00013C))
#define RMOD_THERMAL_STS_0(...) rset(THERMAL_STS_0, THERMAL_STS_0rv, __VA_ARGS__)
#define RFLD_THERMAL_STS_0(fld) (*((const volatile THERMAL_STS_0_T *)0xbb00013C)).f.fld


/*************************************
  * 2020/07/08
  * For prevent LDO 1.8V short issue.
  *************************************/
u32_t thermal_sensor_temp(void)
{
    THERMAL_STS_0_T thermal_sts0;
    THERMAL_CTRL_2rv = 0x34ad7;

    //Dummy read THERMAL_STS_0rv to active it
    thermal_sts0.v = THERMAL_STS_0rv;
    udelay(1000);
    thermal_sts0.v = THERMAL_STS_0rv;

    return thermal_sts0.f.temp_out;
}


void thermal_alarm_check(void)
{
    THERMAL_CTRL_0_T thermal_ctrl0;
    u32_t threshold = 0x6C;
    u32_t readval, temp_out;

    // Thermal detect function
    thermal_ctrl0.v = THERMAL_CTRL_0rv;
    thermal_ctrl0.f.tm_highcmp_en = 1;
    thermal_ctrl0.f.tm_high_thr = threshold;
    THERMAL_CTRL_0rv = thermal_ctrl0.v;

    temp_out = thermal_sensor_temp();
    if(temp_out > threshold){
        printf("II: Disable DRAM LDO output (0x%x) ...",temp_out);

        //Set GPIO 26, 28, 35, 36 to low
        REG32(0xBB000048) = 0x14000000; //REG32(0xB8003308)
        REG32(0xBB00004C) = 0x18;       //REG32(0xB8003324)


        REG32(0xB8003308) = (REG32(0xB8003308) | 0x14000000);
        REG32(0xB800330C) = (REG32(0xB800330C) & ~0x14000000);

        REG32(0xB8003324) = (REG32(0xB8003324) | 0x18);
        REG32(0xB8003328) = (REG32(0xB8003328) & ~0x18);


        // Disable DRAM LDO output
        REG32(0xbb000040) = 0x0001fdc9;
        udelay(1000);
        readval = REG32(0xbb000044) & ~(1<<7);
        REG32(0xbb00003C) = readval;
        udelay(1000);
        REG32(0xbb000040) = 0x0003fdc9;
        printf("done\n");

        while(1);
    }
}


REG_INIT_FUNC(thermal_alarm_check, 12);

