#define _lplr_soc_t  (*(soc_t*)(OTTO_LPLR_ENTRY+OTTO_HEADER_OFFSET))
#define _lplr_bios   (_lplr_soc_t.bios)
#define _lplr_header (_lplr_bios.header)


#define APRO_TESTC_N        (0x0787)
#define APRO_PRODUZIONE_N   (0x6537)
#define IS_PRODUZIONE       (1)

#define CID_GEN(year,week,soc_num)  ((year<<24)|(week<<16)|(soc_num))
#define LPLR_CID_TESTC              CID_GEN(17,3, APRO_TESTC_N)      //[31:25]:2017, [24:16]: Week03, [15:8]:RLE0787
#define LPLR_CID_PRODUZIONE         CID_GEN(17,38,APRO_PRODUZIONE_N) //[31:25]:2017, [24:16]: Week16, [15:8]:RL6537
#define LPLR_REL_DATE               CID_GEN(0x09, 0x22, 0x1500)
#define _soc_cid_sct    ((_soc.cid>>16)&0xFFFF)
#define _soc_cid_series (_soc.cid&0xFFFF)


/* sram init*/
#define SRAM_CTRL_INIT         \
sram_init:\
	li  t0, 0xB8001300; \
	lui t1, %hi(OTTO_SRAM_START); \
	lui t3, 0x1FFF; \
	and t1, t1, t3; \
	ori t1, t1, 0x1; /*Set (Un)mapping enable bit*/ \
	li  t3, 0xB8004000; \
	li  t2, 9; \
	sw  t1, 0(t3); /*mapping*/ \
	sw  t2, 4(t3); /*mapping*/ \
	lui t3, 0x1FFF; \
	and t1, t1, t3; \
	ori t1, t1, 0x1; /*Set (Un)mapping enable bit*/ \
	sw  t1, 0(t0); /*unmapping*/ \
	sw  t2, 4(t0); /*unmapping size of default sram controller setting*/
