#include <soc.h>
#include <uart/uart.h>
#include <cg/cg.h>

#ifndef SECTION_CG_CORE_INIT
    #define SECTION_CG_CORE_INIT
#endif

#ifndef SECTION_CG_MISC
    #define SECTION_CG_MISC
#endif

#ifndef SECTION_CG_MISC_DATA
    #define SECTION_CG_MISC_DATA
#endif


/*  Declaration of global parameter and functions */
cg_dev_freq_t cg_target_freq;
cg_dev_freq_t cg_cur_query;

void reg_to_mhz(void);


SECTION_CG_MISC
u32_t cg_query_freq(u32_t dev_type)
{
	if(0 == cg_cur_query.cpu0_mhz){
		reg_to_mhz();
	}
    return CG_QUERY_FREQUENCY(dev_type,(&cg_cur_query));
}

__attribute__((weak)) short console_auto_set(void) {return 0;}

SECTION_CG_MISC
void reg_to_mhz(void)
{
    memcpy((char *)&cg_cur_query, (const char *)&cg_ddr2_proj_freq, sizeof(cg_dev_freq_t));
	if (cg_cur_query.lx_mhz == 987) {
		cg_cur_query.lx_mhz = console_auto_set();
	}
}

#if defined (OTTO_FLASH_SPI_NAND) || defined (OTTO_FLASH_NOR)
extern clk_div_sel_info_t sclk_divisor[];

SECTION_CG_CORE_INIT 
void __cal_spi_ctrl_divisor(cg_sclk_info_t *info)
{
    u32_t target_sclk = cg_cur_query.spif_mhz;
    u32_t input_pll   = info->pll_freq_mhz;
    u32_t cur_sclk    = info->cal_sclk_mhz;
    int i = -1;
    u32_t cur_divisor;
    u32_t calc_sclk;

    while(1){
        cur_divisor = sclk_divisor[++i].divisor;
        
        if(END_OF_INFO == cur_divisor) break;

        calc_sclk = input_pll/cur_divisor;
        if((target_sclk >= calc_sclk) && (calc_sclk > cur_sclk)){
            cur_sclk = calc_sclk;
            info->cal_sclk_mhz  = calc_sclk;
            info->sclk_div2ctrl = sclk_divisor[i].div_to_ctrl;
        }
    }
    return;
}


SECTION_CG_CORE_INIT 
void cg_spif_clk_init(cg_register_set_t *rs)
{
    cg_sclk_info_t final = {0, 0, 0, 0};
    final.pll_freq_mhz    = cg_cur_query.lx_mhz;    

    __cal_spi_ctrl_divisor(&final);

    if(final.cal_sclk_mhz == 0){
        final.sclk_div2ctrl = 7;
    }

    rs->sclk_div2ctrl = final.sclk_div2ctrl;

    set_spi_ctrl_divisor(rs->sclk_div2ctrl, cg_cur_query.spif_mhz);
    return;
}
#endif //#elif defined (OTTO_FLASH_SPI_NAND)


SECTION_CG_MISC
void cg_result_decode(void)
{
    printf("II: Slow bit OC0/OC1 to MEM is fixed in bit-file\n");

    u32_t val = REG32(0xB8000308);
    if(cg_cur_query.lx_mhz > cg_cur_query.mem_mhz){
        REG32(0xB8000308) = (val & 0xFFFFFFF8);
    }else{
        REG32(0xB8000308) = (val | 0x7);
        printf("II: Slow bit LX to MEM REG32(0xB8000308)=0x%x\n",REG32(0xB8000308));
    }

    u32_t dmcr = DMCRrv;
    DMCRrv = dmcr;

	printf("II: OCP %dMHz, MEM %dMHz, LX %dMHz, SPIF %dMHz\n",
		cg_cur_query.cpu0_mhz,
		cg_cur_query.mem_mhz,
		cg_cur_query.lx_mhz,
		cg_cur_query.spif_mhz);
	return;
}

SECTION_CG_MISC
void cg_init(void)
{
    reg_to_mhz();
    #if defined (OTTO_FLASH_SPI_NAND) || defined (OTTO_FLASH_NOR)
    cg_register_set_t cg_rs;
    cg_spif_clk_init(&cg_rs);
    #endif
    uart_init(uart_baud_rate, cg_cur_query.lx_mhz);
    cg_result_decode();
}


REG_INIT_FUNC(cg_init, 13);

