#include <cpu/cpu.h>

#ifndef __ASSEMBLER__
#include <lplr_sections.h>
#include <lplr.h>
#include <inline_util.h>
#include <bios_io.h>
#include <plr_sections.h>
#include <util.h>
#include <cg/cg.h>
extern const cg_dev_freq_t cg_proj_freq __attribute__ ((section (".parameters")));
#endif

#define SECTION_SRAM_TEXT __attribute__ ((section (".sram_text")))
#define SECTION_FLASH_TEXT __attribute__ ((section (".flash_text")))

#define SECTION_CMD_NODE __attribute__ ((section (".cli_node")))
#define SECTION_CMD_MP_NODE __attribute__ ((section (".cli_mp_node")))
#define SECTION_CMD_TAIL __attribute__ ((section (".cli_tail")))
#define SECTION_AUTOK __attribute__ ((section (".flash_text")))

#define _soc (*(soc_t *)(OTTO_SRAM_START+OTTO_HEADER_OFFSET))

#define LPLR_VERSION 0x00000001

/* NOR SPI-F driver uses udelay. Putting it on flash causes MMIO/PIO conflicts. */
#define SECTION_SYS SECTION_SRAM_TEXT
#define SECTION_CG SECTION_SRAM_TEXT
#define SECTION_UART SECTION_SRAM_TEXT
#define SECTION_MT SECTION_SRAM_TEXT

/* For SPI-F driver. */
#define SECTION_NOR_SPIF_PROBE_FUNC    __attribute__ ((section (".nor_spif_probe_func")))
/* prevent SRAM-specific code to be inlined in FLASH-specific code. */
#define SECTION_NOR_SPIF_GEN2_CORE     __attribute__ ((section (".sram_text"), noinline, aligned(32)))
#define SECTION_NOR_SPIF_GEN2_COREDATA __attribute__ ((section (".data")))
#define SECTION_NOR_SPIF_GEN2_MISC     __attribute__ ((section (".text")))
#define SECTION_NOR_SPIF_GEN2_PARAM    __attribute__ ((section (".parameters")))

#define NORSF_CHIP_NUM     (1)
#define NORSF_MMIO_4B_EN   (1)
#define NORSF_XREAD_EN     (0)
#define NORSF_WBUF_LIM_B   (128)
#define NORSF_CFLASH_BASE  (0x94000000)
#define NORSF_UCFLASH_BASE (NORSF_CFLASH_BASE | 0x20000000)

#define UBOOT_TEXT_BASE    (0x81c00000)
#define NEW_STACK_AT_DRAM  (UBOOT_TEXT_BASE-32)

#define MC_ZQC_RETRY_LIM   8

#define TIMER_FREQ_MHZ     (OTTO_LX_RESET_DEFAULT_MHZ)
#define TIMER_STEP_PER_US  (4)
#define TIMER1_BASE        (0xb8003210)
#define UDELAY_TIMER_BASE  TIMER1_BASE

#define GSFUNC(symbol) GFUNC(symbol)
