#include <cpu/cpu.h>
#ifndef __ASSEMBLER__
#include <lplr_sections.h>
#include <lplr.h>
#include <inline_util.h>

#define _soc (*(soc_t *)(OTTO_SRAM_START+OTTO_HEADER_OFFSET))

#include <bios_io.h>

#define LPLR_VERSION           bismarck_ver
#define LPLR_CID               LPLR_CID_PRODUZIONE //refer to platform/APro_MP/arch.h
#define SECTION_SYS            __attribute__ ((section (".text.sys")))
#define SECTION_SPI_NAND       __attribute__ ((section (".spi_nand")))
#define SECTION_SPI_NAND_DATA  SECTION_RO
#define SECTION_ONFI           __attribute__ ((section (".onfi")))
#define SECTION_ONFI_DATA      SECTION_RO
#define SECTION_ECC_CTRL       __attribute__ ((section (".ecc_ctrl")))


#define TIMER_FREQ_MHZ     (200)
#define TIMER_STEP_PER_US  (4)
#define TIMER1_BASE        (0xb8003210)
#define UDELAY_TIMER_BASE  TIMER1_BASE

#endif //#ifndef __ASSEMBLER__

/* FUNC - declare global function */
#define GFUNC(symbol)  \
        .text;         \
        .globl symbol; \
        .align 4;      \
        .ent symbol;   \
symbol:

#define GSFUNC(symbol) GFUNC(symbol)

/* END - mark end of function */
#define END(symbol)    \
        .end symbol



