#include <init_define.h>
#include <uart/uart.h>
#include <util.h>
#include <lib/lzma/LzmaDec.h>
#include <lib/lzma/tlzma.h>


#define STACK_GUIDE     0xcafecafe

u32_t util_ms_accumulator SECTION_SDATA =0;
s8_t chip_ver[4] SECTION_SDATA = {0};

// message
char toolkitinfo[] SECTION_RECYCLE_DATA = TKINFO;
char proj_name[] SECTION_RECYCLE_DATA = name_of_project;
static char _banner_msg[] SECTION_RECYCLE_DATA = {"\n\n%s\nPRELOADER Bismarck%u.%u\n"};
static char _ver_msg[] SECTION_RECYCLE_DATA = {"II: LPLR:%04x, SVN:%x, Build_date:%x, Toolkit:%s\n"};

UTIL_FAR SECTION_UNS_TEXT void
puts(const char *s) {
	inline_puts(s);
}

SECTION_RECYCLE static void 
setting_timeout_monitor(void)
{
    u32_t keep_to = 0;
#ifdef KEEP_TIMEOUT_MONITOR
    keep_to = 1;
#endif

    //Disable OCP timeout monitor   
    RMOD_OCP0_TO_CTRL(to_ctrl_en, keep_to);
    RMOD_OCP1_TO_CTRL(to_ctrl_en, keep_to);   

    //Disable LX timeout monitor
    RMOD_LXP_TO_CTRL(to_ctrl_en, keep_to);

    RMOD_LX0_M_TO_CTRL(to_ctrl_en, keep_to);
    RMOD_LX0_S_TO_CTRL(to_ctrl_en, keep_to);

    RMOD_LX1_M_TO_CTRL(to_ctrl_en, keep_to);
    RMOD_LX1_S_TO_CTRL(to_ctrl_en, keep_to);

    RMOD_LX2_M_TO_CTRL(to_ctrl_en, keep_to);
    RMOD_LX2_S_TO_CTRL(to_ctrl_en, keep_to);

    RMOD_LX3_M_TO_CTRL(to_ctrl_en, keep_to);

    RMOD_LX_PBO_USW_TO_CTRL(to_ctrl_en, keep_to);
    RMOD_LX_PBO_USR_TO_CTRL(to_ctrl_en, keep_to);

    RMOD_LX_PBO_DSW_TO_CTRL(to_ctrl_en, keep_to);
    RMOD_LX_PBO_DSR_TO_CTRL(to_ctrl_en, keep_to);

    if(_soc.sid){
        RMOD_LX_PBO_EGW_TO_CTRL(to_ctrl_en, keep_to);
    }

    if(keep_to) puts("II: Enable OCP/LX Timeout Monitor\n");
    else puts("II: Disable OCP/LX Timeout Monitor\n");
}

SECTION_RECYCLE 
void plr_init_utility(void)
{
    //Step1. Binding from PLR symbol table
#ifdef HAS_LIB_LZMA
    _lzma_decode = LzmaDecode;
#endif

    //Step2. Set UART0 IO_Enable, Baud-rate, LX Timer
    UART_IO_EN();
	uart_init(uart_info.baud, lx_clk_dft);
	_bios.uart_putc=uart_putc;
	_bios.uart_getc=uart_getc;
	_bios.uart_tstc=uart_tstc;
    lx_timer_init(lx_clk_dft);

	//Step3. Read SoC ID & using printf showing the banner
    REG32(0xB8004080) = 0x1F020001;
    REG32(0xB8004084) = 0x8;
    #define lplr_soc  (*(soc_t*)(0x9F020000+OTTO_HEADER_OFFSET))
    ACQ_SOC_CID_FROM_REG();
    _soc.sid = ((lplr_soc.cid&0xffff)==APRO_PRODUZIONE_N)?IS_PRODUZIONE:0;
    printf(_banner_msg, proj_name, (_soc.bios.header.version >> 24), (_soc.bios.header.version >> 8) & 0xff);
    printf(_ver_msg, ((lplr_soc.cid>>16)&0xffff), VCS_VER, MAKE_DATE, toolkitinfo);
    REG32(0xB8004080) = 0;

	//Step6. disable timeout monitor
	setting_timeout_monitor();

	// 5. put stack guide words
	/* extern u32_t farthest_stack_position; */
	/* u32_t *cur_sp; */
	/* __asm__ __volatile__  ("addiu %0, $29, -4": "=r"(cur_sp)); */
	/* u32_t *sp_end=(u32_t *)(0x9f000000 + 16*1024); */
	/* while (cur_sp != sp_end)  */
	/*     *(cur_sp--)=STACK_GUIDE; */
}

REG_INIT_FUNC(plr_init_utility, 1);
