#ifdef OTTO_PROJECT_FPGA
    #include <dram/apro_fpga_dram_static_init.c>
#else
#include <init_define.h>
#include <plr_sections.h>

#define USE_OTTO_CG_FUNCTION
#define MEM_PLL_INFO_SECTION SECTION_RO

#undef CACHELINE_SIZE
#undef ICACHE_SIZE
#undef DCACHE_SIZE
#define puthex(h) printf("%x", h)
#include <misc/misc_setting.h>
#include <dram/memcntlr_util.h>
#include <dram/boot0412/autoconf.h>
#include <dram/boot0412/board_mem_diag.c>
#include <dram/boot0412/memctl.c>
#include <dram/boot0412/mips_cache_ops.c>
#include <dram/boot0412/memctl_cali_dram.c>
#include <dram/boot0412/memctl_utils.c>

u32_t get_dram_size(void)
{
    const unsigned char BNKCNTv[] = {1, 2, 3};
    const unsigned char BUSWIDv[] = {0, 1, 2};
    const unsigned char ROWCNTv[] = {11, 12, 13, 14, 15, 16};
    const unsigned char COLCNTv[] = {8, 9, 10, 11, 12};
    u32_t dcr = REG32(0xb8001004);
    u32_t size = 1 << (BNKCNTv[(dcr >> 28) & 0x3] +
                       BUSWIDv[(dcr >> 24) & 0x3] +
                       ROWCNTv[(dcr >> 20) & 0xF] +
                       COLCNTv[(dcr >> 16) & 0xF]);
    return (size/(1024*1024));
}
void dram_setup(void)
{
	memctlc_init_dram();
	ISTAT_SET(cal, MEM_CAL_OK);
	printf("II: DDR%d, %dMB\n",(RFLD_MCR(dram_type)+1), get_dram_size());
	
#ifdef STICKY_FREQ_XLAT
	volatile uint32 *dtr0 = (uint32 *)DTR0;
	volatile uint32 *dmcr = (uint32 *)DMCR;
	if(REG32(0xb800121c) == 3){
		/* Set refresh time to 7.68us for MCM model */
		*dtr0 = ((*dtr0 & ~(0xff << 4)) | (0x84 << 4));

		/* DMCR update */
		udelay(1);
		*dmcr = *dmcr;
		while(*dmcr & DMCR_MRS_BUSY);
		udelay(1);
    }
#endif
    return;
}
REG_INIT_FUNC(dram_setup, 26);
#endif

