#include <soc.h>
#include <util.h>
#include <cpu/tlb.h>
#include <cpu/mmu_drv.h>
#include <init_define.h>
#include <ecc/ecc_struct.h>
#include <onfi/onfi_ctrl.h>
#include <onfi/onfi_util.h>
#include <onfi/onfi_symb_func.h>
#include <register_map.h>

extern void plr_tlb_miss_tlb (void);

char _mmu_init_fail_msg[] SECTION_RECYCLE_DATA = {"EE: no physical page was added, system stops\n"};
char _ofu_table_init_fail_msg[] SECTION_RECYCLE_DATA = {"EE: plr mapping table init fail\n"};
char _ofu_probe_fail_msg[] SECTION_RECYCLE_DATA = {"EE: plr probe nand flash device fail\n"};

extern const onfi_probe_t *start_of_onfi_probe_func;
extern const onfi_probe_t *end_of_onfi_probe_func;


SECTION_RECYCLE s32_t
init_onfi_probe_both_list(void)
{
    if (onfi_probe(&onfi_plr_info, &start_of_onfi_probe_func, &end_of_onfi_probe_func)==0) return 0;

    const symbol_table_entry_t *s;  
    if((s=symb_retrive_lplr(ONFI_DEVICE_PROB_LIST_START))==VZERO) return -1;
    const onfi_probe_t **lplr_probe_func_start=s->v.pvalue;
    
    if((s=symb_retrive_lplr(ONFI_DEVICE_PROB_LIST_END))==VZERO) return -1;
    const onfi_probe_t **lplr_probe_func_end=s->v.pvalue;

    return onfi_probe(&onfi_plr_info, lplr_probe_func_start, lplr_probe_func_end);
}

SECTION_RECYCLE s32_t
use_raw_nand_info(void)
{
    s32_t readid = ofu_read_onfi_id();
    if(readid == -1) return -1;

    onfi_plr_info.id_code = readid;   

    /****** General DID Definition Table ******/
    #define DID_1Gb  (0xF1)
    #define DID_2Gb  (0xDA)
    #define DID_4Gb  (0xDC)
    #define DID_8Gb  (0xD3)

    u32_t did = (readid>>16)&0xFF;
    if(did == DID_8Gb){
        onfi_plr_info._num_block = ONFI_MODEL_NUM_BLK_8192;
    }else if(did == DID_4Gb){
            onfi_plr_info._num_block          = ONFI_MODEL_NUM_BLK_4096;
    }else if(did == DID_2Gb){
        onfi_plr_info._num_block = ONFI_MODEL_NUM_BLK_2048;
    }else if(did == DID_1Gb){
        onfi_plr_info._num_block = ONFI_MODEL_NUM_BLK_1024;
    }else{
        return -1;
        }

    //Assign default onfi_info for 2K-page
            onfi_plr_info._num_page_per_block = ONFI_MODEL_NUM_PAGE_64;
            onfi_plr_info._page_size   = ONFI_MODEL_PAGE_SIZE_2048B;
            onfi_plr_info._spare_size  = ONFI_MODEL_SPARE_SIZE_64B;
        onfi_plr_info._oob_size    = ONFI_MODEL_OOB_SIZE(24);
        onfi_plr_info._ecc_ability = ECC_MODEL_6T;        
        onfi_plr_info._ecc_encode  = _ecc_encode_ptr;
        onfi_plr_info._ecc_decode = _ecc_decode_ptr;
        onfi_plr_info._reset      = _ofu_reset_ptr;
    onfi_plr_info._model_info = &onfi_plr_model_info;  

    return 0;
}


SECTION_RECYCLE void
init_onfi_plr_info(void)
{
    if(init_onfi_probe_both_list()<0) {
        if(use_raw_nand_info() <0){
            puts(_ofu_probe_fail_msg);
            while(1);
    }
    }
    onfi_plr_info.bs_cmd_cycle  = ONFI_BS_CMD_CYCLE(RFLD_NACFR(nafc_rc));
    onfi_plr_info.bs_addr_cycle = ONFI_BS_ADDR_CYCLE(RFLD_NACFR(nafc_ac)); 
    
    // basic parallel-nand init and establish the plr_mapping_table
    if(onfi_util_init()<0){
        puts(_ofu_table_init_fail_msg);
        while(1);
    }
}
REG_INIT_FUNC(init_onfi_plr_info, 3);

#ifdef MMU_CHECK_INETRNAL_ERROR
SECTION_TEXT UTIL_FAR void
show_second_banner(void)  {
    inline_puts("    .text and .ro sections work!\n");
}
#endif

SECTION_RECYCLE void
_init_tlb(void) {
    // 1. clean up mmu driver
    u32_t end_of_mapping = OTTO_SRAM_START + OTTO_SRAM_SIZE;
    if (mmu_drv_init((u32_t)&mapped_physical_sram_start, end_of_mapping)==0) {
        puts(_mmu_init_fail_msg);
        while(1);
    }
    
    // 2. enable TLB and isr
    #if 0 // TODO: remove
    u32_t tr;
    __asm__ __volatile__ (
        "mfc0 %0, " TO_STR(CP0_STATUS) ASM_NL
        "ori %0, %0, 1" ASM_NL
        "mtc0 %0, " TO_STR(CP0_STATUS) ASM_NL
        : "=r" (tr)
    );
    #endif    
}

SECTION_UNS_TEXT void 
init_tlb(void) {
    _init_tlb();
    // 3. show message
    puts("II: TLB initial done:\n    .ro section works!\n");
    #ifdef MMU_CHECK_INETRNAL_ERROR
        show_second_banner();
    #endif
}

REG_INIT_FUNC(init_tlb, 10);


// --------------------------
//      export symbols
// --------------------------
