#include <util.h>
#include <spi_nand/spi_nand_ctrl.h>
#include <spi_nand/spi_nand_util.h>
#include <spi_nand/spi_nand_symb_func.h>

u16_t rdid_check[]={0xC8D1, 0xC8D2, 0xC8D4, 0xC811};

SECTION_RECYCLE spi_nand_flash_info_t *
patch_gd_nsu_probe(void)
{
    if(_lplr_soc_t.cid != 0x11266537) return VZERO;

    u32_t w_io_len = IO_WIDTH_LEN(SIO_WIDTH,CMR_LEN(2));
    u32_t r_io_len = IO_WIDTH_LEN(SIO_WIDTH,CMR_LEN(3));
    u16_t rdid = ((nsu_read_spi_nand_id(0, 0, w_io_len, r_io_len)>>16)&0xFFFF);

    u32_t i;
    for(i=0 ; i<sizeof(rdid_check)/sizeof(u16_t) ; i++){
        if(rdid==rdid_check[i]){
            return ((spi_nand_probe_t *)(0x9fc1d8ad))();
        }
    }
    return VZERO;
}
REG_SPI_NAND_PROBE_FUNC(patch_gd_nsu_probe);

