#include <cpu/cpu.h>

#ifndef __ASSEMBLER__
#define SECTION_UART        SECTION_UNS_TEXT
#define SECTION_CMD_NODE    __attribute__ ((section (".cli_node")))
#define SECTION_CMD_MP_NODE __attribute__ ((section (".cli_mp_node")))
#define SECTION_CMD_TAIL    __attribute__ ((section (".cli_tail")))

#include <plr_sections.h>
#include <util.h>
#include <register_map.h>

extern u8_t mapped_physical_sram_start;
#define OTTO_BIG_BUFFER_END   ((u32_t)(&mapped_physical_sram_start))

#ifndef DONT_DECLAIRE__SOC_SYMBOLS
    extern soc_t _soc SECTION_SDATA;
    #include <bios_io.h>
    #define _spi_nand_info (_soc.flash_info.spi_nand_info)

    // system parameters
    #include <cg/cg.h>
    #define SECTION_CG_CORE_INIT UTIL_FAR SECTION_UNS_TEXT
    #define SECTION_CG_MISC      SECTION_TEXT
    #define SECTION_CG_MISC_DATA SECTION_RO
#endif //DONT_DECLAIRE__SOC_SYMBOLS

extern int nsu_logical_page_read(void *data, u32_t page_num);
#define MMU_READ_PAGE_FROM_FLASH(buf, virtual_page_num) nsu_logical_page_read((buf), (virtual_page_num))

extern const char __msg_load_page_fail[] SECTION_SDATA;
#define MSG_FAIL_LOAD_PAGE __msg_load_page_fail

#define PLR_MAP_TABLE_SIZE 80

#else //__ASSEMBLER__

#define OTTO_BIG_BUFFER_END     (mapped_physical_sram_start)

#endif //!__ASSEMBLER__

#define OTTO_PLR_ECC_BUFFER     (OTTO_BIG_BUFFER_END - MAX_ECC_BUF_SIZE)
#define OTTO_PLR_OOB_BUFFER     (OTTO_PLR_ECC_BUFFER - MAX_OOB_BUF_SIZE)
#define OTTO_PLR_PAGE_BUFFER    (OTTO_PLR_OOB_BUFFER - MAX_PAGE_BUF_SIZE)
#define OTTO_PLR_STACK_DEF      (OTTO_PLR_PAGE_BUFFER-4)

/* FUNC - declare global function */
#define GSFUNC(symbol)  \
        .section .unswapable_text, "ax", @progbits;   \
        .globl symbol; \
        .align 4;      \
        .ent symbol;   \
symbol:

/* END - mark end of function */
#define END(symbol)    .end symbol
