#define OTTO_CPU_PRID 0xdc02

#include <config.h>
#include <asm/rtkasm.h>

#ifndef SECTION_CACHE_FUNC
	#define SECTION_CACHE_FUNC .text
#endif

#define GFUNC(fname, ...) \
	SECTION_CACHE_FUNC;\
	.global fname;\
	.ent fname;\
fname: \
	__VA_ARGS__ \
	.end fname;

GFUNC(disable_l23,
  mfc0 t8, CP0_CCTL;
	li   t9, (1<<25);
	not  t9, t9;
	and  t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	li   t9, (1<<25);
	or   t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	jr   ra;
	nop;
)

GFUNC(invalidate_icache_all,
  mfc0 t8, CP0_CCTL;
	li   t9, (1<<1);
	not  t9, t9;
	and  t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	li   t9, (1<<1);
	or   t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	jr   ra;
	nop;
)

GFUNC(invalidate_dcache_all,
	mfc0 t8, CP0_CCTL;
	li   t9, (1<<0);
	not  t9, t9;
	and  t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	li   t9, (1<<0);
	or   t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	jr   ra;
	nop;
)

GFUNC(writeback_invalidate_dcache_all,
	mfc0 t8, CP0_CCTL;
	li   t9, (1<<9);
	not  t9, t9;
	and  t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	li   t9, (1<<9);
	or   t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	jr   ra;
	nop;
)

GFUNC(writeback_dcache_all,
	mfc0 t8, CP0_CCTL;
	li   t9, (1<<8);
	not  t9, t9;
	and  t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	li   t9, (1<<8);
	or   t8, t8, t9;
	mtc0 t8, CP0_CCTL;
	jr   ra;
	nop;
)

GFUNC(invalidate_icache_range,
	move  t0, a0;
	move  t1, a1;
iir_loop:
	cache CACHE_OP_I_INV, 0(t0);
	addi  t0, CONFIG_SYS_CACHELINE_SIZE;
	blt   t0, t1, iir_loop;
	nop;
	jr    ra;
	nop;
)

GFUNC(invalidate_dcache_range,
	move  t0, a0;
	move  t1, a1;
idr_loop:
	cache CACHE_OP_D_INV, 0(t0);
	addi  t0, CONFIG_SYS_CACHELINE_SIZE;
	blt   t0, t1, idr_loop;
	nop;
	jr    ra;
	nop;
)

GFUNC(writeback_invalidate_dcache_range,
	move  t0, a0;
	move  t1, a1;
widr_loop:
	cache CACHE_OP_D_WB_INV, 0(t0);
	addi  t0, CONFIG_SYS_CACHELINE_SIZE;
	blt   t0, t1, widr_loop;
	nop;
	jr    ra;
	nop;
)

GFUNC(writeback_dcache_range,
	move  t0, a0;
	move  t1, a1;
wdr_loop:
	cache CACHE_OP_D_WB, 0(t0);
	addi  t0, CONFIG_SYS_CACHELINE_SIZE;
	blt   t0, t1, wdr_loop;
	nop;
	jr    ra;
	nop;
)
