#ifndef _MPCNTL_H_
#define _MPCNTL_H_ 1
#include <reg_map_util.h>

typedef unsigned int uint32_t;
typedef unsigned short uint116_t;
typedef int (mpf_t)(int, int, int, int);

typedef struct {
	uint32_t targcpu;
	uint32_t sp;
	mpf_t *function;
	uint32_t arg[4];
} mp_cmd_t;

typedef struct {
	void (*en)(void);
	/* int (*icache_inv)(int start, int size); */
	/* int (*dcache_inv)(int start, int size); */
	/* int (*dcache_wb_inv)(int start, int size); */
	int (*l2cache_inv)(int start, int size);
	int (*l2cache_wb_inv)(int start, int size);
	void (*kill)(void);
	volatile int slave_resp;
} mp_cpu_attr_t;

typedef struct {
	char *name;
	mpf_t *fptr;
} mp_func_str_ptr_t;

extern mp_cpu_attr_t mp_attr[];
extern int mp_printf(const char *format, ...);
extern void _start(void);
#define MPCNTL_CPU_START_ADDR UCADDR((unsigned int)_start)

#define MP_MAKE_FUNCNAME(x) {#x, (mpf_t *)x}

/* #define CADDR(addr) (addr & 0xdfffffff) */
#define UCADDR(addr) (addr | 0x20000000)
/* #define PADDR(addr) (addr & 0x1fffffff) */

/* SoC peripheral */
#define IPC_HWM_BASE (0xb8141000 + 0x80)

/* for Boot-MIPS */
#define GIC_CONFIG_ADDR (0xbfbc0000)
#define GCR_CONFIG_ADDR (0xbfbf8000)
#define CPC_CONFIG_ADDR (0xbfbf0000)

#define CORE_LOCAL_CONTROL_BLOCK 0x2000
#define CORE_OTHER_CONTROL_BLOCK 0x4000
#define CORE_LOCAL_CONTROL_ADDR (GCR_CONFIG_ADDR + CORE_LOCAL_CONTROL_BLOCK)
#define CORE_OTHER_CONTROL_ADDR (GCR_CONFIG_ADDR + CORE_OTHER_CONTROL_BLOCK)

#define CPC_CMD_CLKOFF 0x1
#define CPC_CMD_PWRDOWN 0x2
#define CPC_CMD_PWRUP 0x3
#define CPC_CMD_RESET 0x4
#define CPC_CORE_LOCAL_ADDR (CPC_CONFIG_ADDR + CORE_LOCAL_CONTROL_BLOCK)
#define CPC_CORE_OTHER_ADDR (CPC_CONFIG_ADDR + CORE_OTHER_CONTROL_BLOCK)

/* general purpose reg util */
#define a0 $4
#define a1 $5
#define a2 $6
#define a3 $7
#define sp $29
#define ra $31

#define TO_STR(str) #str

#define MTSET_GPR(_val, _REG)											\
	({ int val = _val;																\
		__asm__ __volatile__("mttgpr %0, " TO_STR(_REG) ";\n"	\
												 "ehb;\n"										\
		                     :: "r" (val));							\
	})

#define GET_GPR(_REG) \
	({ unsigned int __res; \
		__asm__ __volatile__("move %0, " TO_STR(_REG) ";\n" \
		                     : "=r" (__res)); \
		__res; \
	})

/* CP0 util */
#define C0_MVPCTL "$0, 1"
#define C0_MVPCONF0 "$0, 2"
#define C0_VPECTL "$1, 1"
#define C0_VPECONF0 "$1, 2"
#define C0_TCSTATUS "$2, 1"
#define C0_TCBIND "$2, 2"
#define C0_TCRESTART "$2, 3"
#define C0_TCHALT "$2, 4"
#define C0_STATUS "$12"
#define C0_CAUSE "$13"
#define C0_EPC "$14"
#define C0_PRID "$15"
#define C0_EBASE "$15, 1"
#define C0_CONFIG "$16"
#define C0_CONFIG3 "$16, 3"

#define _GET_CP0(_REG) \
	({ unsigned int __res; \
		__asm__ __volatile__("mfc0 %0, " _REG ";\n"	\
		                     : "=r" (__res));	\
		__res; \
	})

#define _SET_CP0(_val, _REG) \
	({ unsigned int val = _val; \
		__asm__ __volatile__("mtc0 %0, " _REG ";\n" \
												 "ehb;\n" \
		                     :: "r" (val)); \
	})

#define _MTGET_CP0(_REG) \
	({ unsigned int __res; \
		__asm__ __volatile__("mftc0 %0, " _REG ";\n" \
		                     : "=r" (__res)); \
		__res; \
	})

#define _MTSET_CP0(_val, _REG) \
	({ unsigned int val = _val; \
		__asm__ __volatile__("mttc0 %0, " _REG ";\n" \
												 "ehb;\n" \
		                     :: "r" (val)); \
	})

#define GET_CP0(_REG) _GET_CP0(_REG)
#define SET_CP0(_val, _REG) _SET_CP0(_val, _REG)
#define MTGET_CP0(_REG) _MTGET_CP0(_REG)
#define MTSET_CP0(_val, _REG) _MTSET_CP0(_val, _REG)

#define SET_CP0_F(_VAL, _REG, _FIELD) do {		\
		_REG ## _T _reg;														\
		_reg.v = GET_CP0(_REG);										\
		_reg.f._FIELD = _VAL;												\
		SET_CP0(_reg.v, _REG);										\
	} while (0)

#define MTSET_CP0_F(_VAL, _REG, _FIELD) do { \
		_REG ## _T _reg;												 \
		_reg.v = MTGET_CP0(_REG);								 \
		_reg.f._FIELD = _VAL;								 \
		MTSET_CP0(_reg.v, _REG);								 \
	} while (0)

/* reg. struct */
typedef union {
	struct {
		unsigned int mbz_0:28;
		unsigned int cpa:1;
		unsigned int stlb:1;
		unsigned int vpc:1;
		unsigned int evp:1;
	} f;
	unsigned int v;
} C0_MVPCTL_T;

typedef union {
	struct {
		unsigned int m:1;
		unsigned int mbz_0:1;
		unsigned int tlbs:1;
		unsigned int gs:1;
		unsigned int pcp:1;
		unsigned int mbz_1:1;
		unsigned int ptlbe:10;
		unsigned int tca:1;
		unsigned int mbz_2:1;
		unsigned int pvpe:4;
		unsigned int mbz_3:2;
		unsigned int ptc:8;
	} f;
	unsigned int v;
} C0_MVPCONF0_T;

typedef union {
	struct {
		unsigned int tcu:4;
		unsigned int tmx:1;
		unsigned int tfr:1;
		unsigned int ____mbz_0:1;
		unsigned int rnst:2;
		unsigned int ____mbz_1:1;
		unsigned int tds:1;
		unsigned int dt:1;
		unsigned int ____mbz_2:2;
		unsigned int tcee:1;
		unsigned int ____mbz_3:1;
		unsigned int da:1;
		unsigned int ____mbz_4:1;
		unsigned int a:1;
		unsigned int tksu:2;
		unsigned int ____mbz_5:2;
		unsigned int ixmt:1;
		unsigned int tasic:8;
	} f;
	unsigned int v;
} C0_TCSTATUS_T;

typedef union {
	struct {
		unsigned int mbz_0:3;
		unsigned int curtc:8;
		unsigned int mbz_1:3;
		unsigned int tbe:1;
		unsigned int mbz_2:13;
		unsigned int curvpe:4;
	} f;
	unsigned int v;
} C0_TCBIND_T;

typedef union {
	struct {
		unsigned int mbz_0:31;
		unsigned int h:1;
	} f;
	unsigned int v;
} C0_TCHALT_T;

typedef union {
	struct {
		unsigned int addr;
	} f;
	unsigned int v;
} C0_TCRESTART_T;

typedef union {
	struct {
		unsigned int mbz_0:10;
		unsigned int ysi:1;
		unsigned int gsi:1;
		unsigned int mbz_1:1;
		unsigned int excpt:3;
		unsigned int te:1;
		unsigned int mbz_2:7;
		unsigned int targtc:8;
	} f;
	unsigned int v;
} C0_VPECTL_T;

typedef union {
	struct {
		unsigned int m:1;
		unsigned int ____mbz_0:2;
		unsigned int xtc:8;
		unsigned int ____mbz_1:1;
		unsigned int tcs:1;
		unsigned int scs:1;
		unsigned int dcs:1;
		unsigned int ics:1;
		unsigned int ____mbz_2:14;
		unsigned int mvp:1;
		unsigned int vpa:1;
	} f;
	unsigned int v;
} C0_VPECONF0_T;

typedef union {
	struct {
		unsigned int mbz_0:12;
		unsigned int addr_regions:4;
		unsigned int mbz_1:4;
		unsigned int numiocu:4;
		unsigned int pcores:8;
	} f;
	unsigned int v;
} GCR_CONFIG_T;
#define GCR_CONFIGrv (*((regval)(GCR_CONFIG_ADDR)))
#define RMOD_GCR_CONFIG(...) rset(GCR_CONFIG, GCR_CONFIGrv, __VA_ARGS__)
#define RFLD_GCR_CONFIG(fld) (*((const volatile GCR_CONFIG_T *)(GCR_CONFIG_ADDR))).f.fld

typedef union {
	struct {
		unsigned int gcr_base:17;
		unsigned int mbz_0:7;
		unsigned int cca:3;
		unsigned int ccaen:1;
		unsigned int mbz_1:2;
		unsigned int cm2_default_target:2;
	} f;
	unsigned int v;
} GCR_BASE_T;
#define GCR_BASErv (*((regval)(GCR_CONFIG_ADDR + 0x8)))
#define RMOD_GCR_BASE(...) rset(GCR_BASE, GCR_BASErv, __VA_ARGS__)
#define RFLD_GCR_BASE(fld) (*((const volatile GCR_BASE_T *)(GCR_CONFIG_ADDR + 0x8))).f.fld

typedef union {
	struct {
		unsigned int mbz_0:24;
		unsigned int cm2_access_en:8;
	} f;
	unsigned int v;
} GCR_ACCESS_T;
#define GCR_ACCESSrv (*((regval)(GCR_CONFIG_ADDR + 0x20)))
#define RMOD_GCR_ACCESS(...) rset(GCR_ACCESS, GCR_ACCESSrv, __VA_ARGS__)
#define RFLD_GCR_ACCESS(fld) (*((volatile GCR_ACCESS_T *)(GCR_CONFIG_ADDR + 0x20))).f.fld

typedef union {
	struct {
		unsigned int gic_base_addr:15;
		unsigned int mbz_0:16;
		unsigned int gic_en:1;
	} f;
	unsigned int v;
} GCR_GIC_BASE_T;
#define GCR_GIC_BASErv (*((regval)(GCR_CONFIG_ADDR + 0x80)))
#define RMOD_GCR_GIC_BASE(...) rset(GCR_GIC_BASE, GCR_GIC_BASErv, __VA_ARGS__)
#define RFLD_GCR_GIC_BASE(fld) (*((const volatile GCR_GIC_BASE_T *)(GCR_CONFIG_ADDR + 0x80))).f.fld

typedef union {
	struct {
		unsigned int cpc_base_addr:17;
		unsigned int mbz_0:14;
		unsigned int cpc_en:1;
	} f;
	unsigned int v;
} GCR_CPC_BASE_T;
#define GCR_CPC_BASErv (*((regval)(GCR_CONFIG_ADDR + 0x88)))
#define RMOD_GCR_CPC_BASE(...) rset(GCR_CPC_BASE, GCR_CPC_BASErv, __VA_ARGS__)
#define RFLD_GCR_CPC_BASE(fld) (*((const volatile GCR_CPC_BASE_T *)(GCR_CONFIG_ADDR + 0x88))).f.fld

typedef union {
	struct {
		unsigned int cm2_region_base_addr:16;
		unsigned int mbz_0:16;
	} f;
	unsigned int v;
} GCR_REGn_BASE_T;
#define GCR_REG0_BASErv (*((regval)(GCR_CONFIG_ADDR + 0x90)))
#define GCR_REG1_BASErv (*((regval)(GCR_CONFIG_ADDR + 0xa0)))
#define GCR_REG2_BASErv (*((regval)(GCR_CONFIG_ADDR + 0xb0)))
#define GCR_REG3_BASErv (*((regval)(GCR_CONFIG_ADDR + 0xc0)))

typedef union {
	struct {
		unsigned int cm2_region_addr_mask:16;
		unsigned int mbz_0:8;
		unsigned int cca_override_value:3;
		unsigned int cca_override_enable:1;
		unsigned int mbz_1:1;
		unsigned int drop_l2:1;
		unsigned int cm2_target:2;
	} f;
	unsigned int v;
} GCR_REGn_MASK_T;
#define GCR_REG0_MASKrv (*((regval)(GCR_CONFIG_ADDR + 0x98)))
#define GCR_REG1_MASKrv (*((regval)(GCR_CONFIG_ADDR + 0xa8)))
#define GCR_REG2_MASKrv (*((regval)(GCR_CONFIG_ADDR + 0xb8)))
#define GCR_REG3_MASKrv (*((regval)(GCR_CONFIG_ADDR + 0xc8)))

typedef union {
	struct {
		unsigned int ____mbz_0:24;
		unsigned int coh_domain_en:8;
	} f;
	unsigned int v;
} GCR_CL_COHERENCE_T;
typedef GCR_CL_COHERENCE_T GCR_CO_COHERENCE_T;
#define GCR_CL_COHERENCErv (*((regval)(CORE_LOCAL_CONTROL_ADDR + 0x8)))
#define GCR_CO_COHERENCErv (*((regval)(CORE_OTHER_CONTROL_ADDR + 0x8)))
#define RMOD_GCR_CL_COHERENCE(...) rset(GCR_CL_COHERENCE, GCR_CL_COHERENCErv, __VA_ARGS__)
#define RFLD_GCR_CL_COHERENCE(fld) (*((const volatile GCR_CL_COHERENCE_T *)(CORE_LOCAL_CONTROL_ADDR + 0x8))).f.fld

typedef union {
	struct {
		unsigned int corenum:16;
		unsigned int ____mbz_0:16;
	} f;
	unsigned int v;
} GCR_CL_OTHER_T;
typedef GCR_CL_OTHER_T GCR_CO_OTHER_T;
#define GCR_CL_OTHERrv (*((regval)(CORE_LOCAL_CONTROL_ADDR + 0x18)))
#define GCR_CO_OTHERrv (*((regval)(CORE_OTHER_CONTROL_ADDR + 0x18)))
#define RMOD_GCR_CL_OTHER(...) rset(GCR_CL_OTHER, GCR_CL_OTHERrv, __VA_ARGS__)
#define RMOD_GCR_CO_OTHER(...) rset(GCR_CO_OTHER, GCR_CO_OTHERrv, __VA_ARGS__)
#define RFLD_GCR_CL_OTHER(fld) (*((const volatile GCR_CL_OTHER_T *)(CORE_LOCAL_CONTROL_ADDR + 0x18))).f.fld
#define RFLD_GCR_CO_OTHER(fld) (*((const volatile GCR_CO_OTHER_T *)(CORE_OTHER_CONTROL_ADDR + 0x18))).f.fld

typedef union {
	struct {
		unsigned int bevexcbase:20;
		unsigned int ____mbz_0:12;
	} f;
	unsigned int v;
} GCR_CL_RESET_BASE_T;
typedef GCR_CL_RESET_BASE_T GCR_CO_RESET_BASE_T;
#define GCR_CL_RESET_BASErv (*((regval)(CORE_LOCAL_CONTROL_ADDR + 0x20)))
#define GCR_CO_RESET_BASErv (*((regval)(CORE_OTHER_CONTROL_ADDR + 0x20)))
#define RMOD_GCR_CL_RESET_BASE(...) rset(GCR_CL_RESET_BASE, GCR_CL_RESET_BASErv, __VA_ARGS__)
#define RMOD_GCR_CO_RESET_BASE(...) rset(GCR_CO_RESET_BASE, GCR_CO_RESET_BASErv, __VA_ARGS__)
#define RFLD_GCR_CL_RESET_BASE(fld) (*((const volatile GCR_CL_OTHER_T *)(CORE_LOCAL_CONTROL_ADDR + 0x20))).f.fld
#define RFLD_GCR_CO_RESET_BASE(fld) (*((const volatile GCR_CO_OTHER_T *)(CORE_OTHER_CONTROL_ADDR + 0x20))).f.fld

typedef union {
	struct {
		unsigned int corenum:32;
	} f;
	unsigned int v;
} GCR_CL_ID_T;
#define GCR_CL_IDrv (*((regval)(CORE_LOCAL_CONTROL_ADDR + 0x28)))
#define RMOD_GCR_CL_ID(...) rset(GCR_CL_ID, GCR_CL_IDrv, __VA_ARGS__)
#define RFLD_GCR_CL_ID(fld) (*((const volatile GCR_CL_ID_T *)(CORE_LOCAL_CONTROL_ADDR + 0x28))).f.fld

typedef union {
	struct {
		unsigned int ____mbz_0:28;
		unsigned int cmd:4;
	} f;
	unsigned int v;
} CPC_CL_CMD_T;
typedef CPC_CL_CMD_T CPC_CO_CMD_T;
#define CPC_CL_CMDrv (*((regval)(CPC_CORE_LOCAL_ADDR + 0x0)))
#define CPC_CO_CMDrv (*((regval)(CPC_CORE_OTHER_ADDR + 0x0)))
#define RMOD_CPC_CL_CMD(...) rset(CPC_CL_CMD, CPC_CL_CMDrv, __VA_ARGS__)
#define RMOD_CPC_CO_CMD(...) rset(CPC_CO_CMD, CPC_CO_CMDrv, __VA_ARGS__)
#define RFLD_CPC_CL_CMD(fld) (*((const volatile CPC_CL_CMD_T *)(CPC_CORE_LOCAL_ADDR + 0x0))).f.fld
#define RFLD_CPC_CO_CMD(fld) (*((const volatile CPC_CO_CMD_T *)(CPC_CORE_OTHER_ADDR + 0x0))).f.fld

typedef union {
	struct {
		unsigned int ____mbz_0:8;
		unsigned int pwrup_event:1;
		unsigned int seq_state:4;
		unsigned int ____mbz_1:1;
		unsigned int clkgat_impl:1;
		unsigned int pwrdn_impl:1;
		unsigned int ejtag_probe:1;
		unsigned int ____mbz_2:5;
		unsigned int pwup_policy:2;
		unsigned int ____mbz_3:3;
		unsigned int io_trffc_en:1;
		unsigned int cmd:4;
	} f;
	unsigned int v;
} CPC_CL_STAT_CONF_T;
typedef CPC_CL_STAT_CONF_T CPC_CO_STAT_CONF_T;
#define CPC_CO_STAT_CONFrv (*((regval)(CPC_CORE_OTHER_ADDR + 0x8)))
#define RMOD_CPC_CO_STAT_CONF(...) rset(CPC_CO_STAT_CONF, CPC_CO_STAT_CONFrv, __VA_ARGS__)
#define RFLD_CPC_CO_STAT_CONF(fld) (*((const volatile CPC_CO_STAT_CONF_T *)(CPC_CORE_OTHER_ADDR + 0x8))).f.fld

typedef union {
	struct {
		unsigned int ____mbz_0:13;
		unsigned int corenum:3;
		unsigned int ____mbz_1:16;
	} f;
	unsigned int v;
} CPC_CL_OTHER_T;
typedef CPC_CL_OTHER_T CPC_CO_OTHER_T;
#define CPC_CL_OTHERrv (*((regval)(CPC_CORE_LOCAL_ADDR + 0x10)))
#define CPC_CO_OTHERrv (*((regval)(CPC_CORE_OTHER_ADDR + 0x10)))
#define RMOD_CPC_CL_OTHER(...) rset(CPC_CL_OTHER, CPC_CL_OTHERrv, __VA_ARGS__)
#define RMOD_CPC_CO_OTHER(...) rset(CPC_CO_OTHER, CPC_CO_OTHERrv, __VA_ARGS__)
#define RFLD_CPC_CL_OTHER(fld) (*((const volatile CPC_CL_OTHER_T *)(CPC_CORE_LOCAL_ADDR + 0x10))).f.fld
#define RFLD_CPC_CO_OTHER(fld) (*((const volatile CPC_CL_OTHER_T *)(CPC_CORE_OTHER_ADDR + 0x10))).f.fld

int mp_cpuid(void);

static inline void ipc_hwm_wait_lock(int lock_id) {
	int cpu_id = mp_cpuid();
	volatile int *wait = (volatile int *)(IPC_HWM_BASE + (lock_id * 0x40) + (cpu_id * 4) + 4);

	while (*wait) {
		;
	}
	return;
}

static inline void ipc_hwm_rlz_lock(int lock_id) {
	int cpu_id = mp_cpuid();
	volatile int *wait = (volatile int *)(IPC_HWM_BASE + (lock_id * 0x40) + (cpu_id * 4) + 4);

	*wait = 0;

	return;
}

#define MIPS_SYNC2() __asm__ __volatile__ ("sync  0x2" : : : "memory")

#endif
