#ifndef _RTKASM_H_
#define _RTKASM_H_ 1

#define CPU_5281 0xdc02
#define CPU_IA 0x01a1

#define CP0_INDEX $0
#define CP0_RANDOM $1
#define CP0_ENTRYLO0 $2
#define CP0_CONTEXT $4
#define CP0_WIRED $6
#define CP0_BADVADDR $8
#define CP0_COUNT $9
#define CP0_ENTRYHI $10
#define CP0_COMPARE $11
#define CP0_STATUS $12
#define CP0_CAUSE $13
#define CP0_EPC $14
#define CP0_PRID $15
#define CP0_WATCHLO $18
#define CP0_WATCHHI $19
#define CP0_DESAVE $31

#if (OTTO_CPU_PRID == CPU_5281) /* RLX5281 */
#define CP0_DREG $16
#define CP0_DEPC $17
#define CP0_CCTL $20
#define CP0_CONFIG $23
#define CP0_DATALO $28
#define CP0_DATAHI $29

#define CACHE_OP_I_INV (0x10)
#define CACHE_OP_D_INV (0x11)
#define CACHE_OP_D_WB_INV (0x15)
#define CACHE_OP_D_WB (0x19)

#elif (OTTO_CPU_PRID == CPU_IA) /* MIPS interAptiv */
#define CP0_ENTRYLO1 $3

#define CP0_MVPCTL "$0, 1"
#define CP0_MVPCONF0 "$0, 2"
#define CP0_VPECTL "$1, 1"
#define CP0_VPECONF0 "$1, 2"
#define CP0_TCSTATUS "$2, 1"
#define CP0_TCBIND "$2, 2"
#define CP0_TCRESTART "$2, 3"
#define CP0_TCHALT "$2, 4"
#define CP0_STATUS "$12"
#define CP0_CAUSE "$13"
#define CP0_EPC "$14"
#define CP0_PRID "$15"
#define CP0_EBASE "$15, 1"
#define CP0_CONFIG "$16"
#define CP0_CONFIG3 "$16, 3"
#endif

#define zero $0	/* wired zero */
#define AT $1	/* assembler temp  - uppercase because of ".set at" */
#define v0 $2	/* return value */
#define v1 $3
#define a0 $4	/* argument registers */
#define a1 $5
#define a2 $6
#define a3 $7
#define t0 $8	/* caller saved */
#define t1 $9
#define t2 $10
#define t3 $11
#define t4 $12
#define t5 $13
#define t6 $14
#define t7 $15
#define s0 $16	/* callee saved */
#define s1 $17
#define s2 $18
#define s3 $19
#define s4 $20
#define s5 $21
#define s6 $22
#define s7 $23
#define t8 $24	/* caller saved */
#define t9 $25
#define jp $25	/* PIC jump register */
#define k0 $26	/* kernel scratch */
#define k1 $27
#define gp $28	/* global pointer */
#define sp $29	/* stack pointer */
#define fp $30	/* frame pointer */
#define s8 $30	/* same like fp! */
#define ra $31	/* return address */

#endif
