#ifndef __RAMTEST_H__
#define __RAMTEST_H__

#include "soc.h"
#include "tlb.h"

#define MASK_ENT_MAX (5)
#define SEG_ENT_MAX (MASK_ENT_MAX+1)

/* Do not use flush all to prevent from D$ virtual tag conflict.
   Following comment is left as a WARNING! */
/* #define dcache_flush writeback_invalidate_dcache_all */

#define dcache_flush_range(base, end) writeback_invalidate_dcache_range(base, end)

#define VA2PA(a) ((a)&0x1FFFFFFF)
#define PA2VA(a) ((a)|0x80000000)

#ifndef REG32
#	define REG32(reg) (*(volatile uint32_t *)(reg))
#endif

typedef struct {
    unsigned int loop;
    unsigned int taddr;
    unsigned int tsize;
    unsigned int tunit;
    unsigned int maddr[MASK_ENT_MAX];
    unsigned int msize[MASK_ENT_MAX];
    unsigned int seg[SEG_ENT_MAX];
    unsigned int ssize[SEG_ENT_MAX];
    unsigned char stop;    // blocking
    unsigned char dbg;
    unsigned short sp_case;
} dramtest_info_t;

typedef int (dtest_func_ptr_t)(dramtest_info_t *, uint32_t , uint32_t);
typedef struct {
    dtest_func_ptr_t *ptr;
    char name[32];
} dtest_func_t;
#define DTEST_FUNC(n)                  { .ptr=n, .name=TO_STR(n) }

void *plat_dram_space_serialize(void *backup);
void plat_dram_space_restore(void *backup);
void plat_dram_space_mod_ca(dramtest_info_t *info, uint32_t ca);
uint32_t plat_dcache_size_b(void);

extern dtest_func_t dtest[];

#endif // __RAMTEST_H__
