#include <common.h>
#include "dramtest.h"

#define TLB_IDX (63)

__attribute__ ((unused))
static uint32_t get_mmu_last_entry(void) {
	unsigned int __ret;
	__asm__ __volatile__ (
		"mfc0 %0, $16, 1;\n\tsync;\n\t"
		: "=r" (__ret));
	return (__ret >> 25) & 0x3f;
}

__attribute__ ((unused))
static void set_cp0_index(uint32_t __val) {
	__asm__ __volatile__ (
		"mtc0 %0, $0;\n\tsync;\n\t"
		: : "r" (__val));
	return;
}

__attribute__ ((unused))
static void set_cp0_entryhi(uint32_t __val) {
	__asm__ __volatile__ (
		"mtc0 %0, $10;\n\tsync;\n\t"
		: : "r" (__val));
	return;
}

__attribute__ ((unused))
static void set_cp0_entrylo0(uint32_t __val) {
	__asm__ __volatile__ (
		"mtc0 %0, $2;\n\tsync;\n\t"
		: : "r" (__val));
	return;
}

__attribute__ ((unused))
static void set_cp0_entrylo1(uint32_t __val) {
	__asm__ __volatile__ (
		"mtc0 %0, $3;\n\tsync;\n\t"
		: : "r" (__val));
	return;
}

__attribute__ ((unused))
static void set_cp0_pagemask(uint32_t __val) {
	__asm__ __volatile__ (
		"mtc0 %0, $5;\n\tsync;\n\t"
		: : "r" (__val));
	return;
}

__attribute__ ((unused))
static uint32_t get_cp0_index(void) {
	unsigned int __ret;
	__asm__ __volatile__ (
		"mfc0 %0, $0;\n\tsync;\n\t"
		: "=r" (__ret));
	return __ret;
}

static uint32_t get_cp0_entryhi(void) {
	unsigned int __ret;
	__asm__ __volatile__ (
		"mfc0 %0, $10;\n\tsync;\n\t"
		: "=r" (__ret));
	return __ret;
}

static uint32_t get_cp0_entrylo0(void) {
	unsigned int __ret;
	__asm__ __volatile__ (
		"mfc0 %0, $2;\n\tsync;\n\t"
		: "=r" (__ret));
	return __ret;
}

static uint32_t get_cp0_entrylo1(void) {
	unsigned int __ret;
	__asm__ __volatile__ (
		"mfc0 %0, $3;\n\tsync;\n\t"
		: "=r" (__ret));
	return __ret;
}

static uint32_t get_cp0_pagemask(void) {
	unsigned int __ret;
	__asm__ __volatile__ (
		"mfc0 %0, $5;\n\tsync;\n\t"
		: "=r" (__ret));
	return __ret;
}

__attribute__ ((unused))
static void dump_tlb(void) {
	int i;
	int tlb_entry_num = get_mmu_last_entry() + 1;

	for (i=0; i<tlb_entry_num; i++) {
		set_cp0_index(i);
		__asm__ __volatile__("tlbr\n");
		printf("%03d: EHi: %08x, ELo0: %08x, ELo1: %08x, PM: %08x\n",
					 get_cp0_index(),
					 get_cp0_entryhi(),
					 get_cp0_entrylo0(),
					 get_cp0_entrylo1(),
					 get_cp0_pagemask());
	}
	return;
}

typedef struct {
	uint32_t cp0_index;
	uint32_t cp0_entryhi;
	uint32_t cp0_entrylo0;
	uint32_t cp0_entrylo1;
	uint32_t cp0_pagemask;
	uint32_t zone2;
	uint32_t dram_unmap;
	uint32_t sram_map;
} dram_space_ctx_t;

void *plat_dram_space_serialize(void *backup) {
	/* for MIPS IA MMU + Zone 2 reg. */
	dram_space_ctx_t *tlb_ctx = (dram_space_ctx_t *)backup;

	/* get original tlb entry and other reg. */
	tlb_ctx->cp0_index = get_mmu_last_entry();

	set_cp0_index(tlb_ctx->cp0_index);
	__asm__ __volatile__("tlbr\n");

	tlb_ctx->cp0_entryhi = get_cp0_entryhi();
	tlb_ctx->cp0_entrylo0 = get_cp0_entrylo0();
	tlb_ctx->cp0_entrylo1 = get_cp0_entrylo1();
	tlb_ctx->cp0_pagemask = get_cp0_pagemask();
	tlb_ctx->zone2 = REG32(0xb8004220);
	tlb_ctx->dram_unmap = REG32(0xb8001300);
	tlb_ctx->sram_map = REG32(0xb8004000);

	/* set new tlb entry */
	/* so VA --> Bus Addr. -> PA ==
	   0x00000000 -> 0x20000000 -> (0x20000000 + 0x60000000(zone2 off.)) & 0x1fffffff (512MB) == 0x0 */
	set_cp0_entryhi(0);
	set_cp0_entrylo0(0x800000 | (3 << 3) | 0x7);
	set_cp0_entrylo1(0xc00000 | (3 << 3) | 0x7);
	set_cp0_pagemask(0x1fffe000);
	__asm__ __volatile__("tlbwi\n");

	/* set other reg. */
	REG32(0xb8004220) = 0x60000000;
	REG32(0xb8001300) = 0x0;
	REG32(0xb8004000) = 0x0;

	return backup;
}

void plat_dram_space_restore(void *backup) {
	dram_space_ctx_t *tlb_ctx = (dram_space_ctx_t *)backup;

	set_cp0_index(tlb_ctx->cp0_index);
	set_cp0_entryhi(tlb_ctx->cp0_entryhi);
	set_cp0_entrylo0(tlb_ctx->cp0_entrylo0);
	set_cp0_entrylo1(tlb_ctx->cp0_entrylo1);
	set_cp0_pagemask(tlb_ctx->cp0_pagemask);
	__asm__ __volatile__("tlbwi;\n\r");

	REG32(0xb8004220) = tlb_ctx->zone2;
	REG32(0xb8001300) = tlb_ctx->dram_unmap;
	REG32(0xb8004000) = tlb_ctx->sram_map;

	return;
}

void plat_dram_space_mod_ca(
	dramtest_info_t *info __attribute__ ((unused)),
	uint32_t ca) {

	ca = ca & 0x7;

	set_cp0_index(get_mmu_last_entry());
	set_cp0_entryhi(0);
	set_cp0_entrylo0(0x800000 | (ca << 3) | 0x7);
	set_cp0_entrylo1(0xc00000 | (ca << 3) | 0x7);
	set_cp0_pagemask(0x1fffe000);

	__asm__ __volatile__("tlbwi;\n\r");

	return;
}

uint32_t plat_dcache_size_b(void) {
	uint32_t config = __asm_mfc0(CP0_CONFIG, 1);
	uint32_t ds = (config >> 13)&0x7;
	uint32_t dsize=0;
	if(ds<4) {
		dsize=(64<<ds)*4*32;
	}
	return dsize;
}
