#include <soc.h>
#include <command.h>
#include <common.h>

void mem_be_test(uint8_t *start, uint32_t len) {
	uint32_t i, j;
	uint8_t *buf, *end;
	uint8_t c[] = {'1', 0, '4', 0, '2', 0, '1', 0, '4', 0, '2', 0,
								 0, '2', 0, '1', 0, '4', 0, '2', 0, '1', 0, '4'};

	if (len % 0x38) {
		len -= (len % 0x38);
		printf("II: len shrinked to %d to align with 0x38\n", len);
	}
	printf("II: Testing byte enable: [%p ~ %p]\n", start, start+len-1);

	puts("Resetting... ");
	memset(start, 0, len);
	if ((((uint32_t)start) & 0x20000000) == 0) {
		writeback_invalidate_dcache_range(start, start+len);
	}

	i = 0;
	end = start + len;
	buf = start;
	puts("Writing... ");
	while (buf < end) {
		if (c[i%sizeof(c)]) {
			for (j=0; j<(1<<(i%3)); j++) {
				*buf++ = c[i%sizeof(c)];
			}
		} else {
			buf += (1<<(i%3));
		}
		i++;
	}
	if ((((uint32_t)start) & 0x20000000) == 0) {
		writeback_invalidate_dcache_range(start, start+len);
	}

	i = 0;
	buf = start;
	puts("Verifying... ");
	while (buf < end) {
		for (j=0; j<(1<<(i%3)); j++) {
			if (*buf != c[i%sizeof(c)]) {
				printf("EE: error found at %p\n", buf);
			}
			buf++;
		}
		i++;
	}
	puts("Done\n");
	return;
}

void ulw_usw_test(uint8_t *start, uint32_t len) {
	uint32_t *buf, *end;
	uint32_t res0, res1, res2, res3, off;

	end = (uint32_t *)(start + len);
	*start = 0x66;

	for (off=1; off<4; off++) {
		buf = (uint32_t *)(start + off);
		printf("II: Unaligned SW/LW test [%p ~ %p]: USW... ", buf, end);
		while (buf < end) {
			__asm__ __volatile__ ("usw %0, 0x0(%1);"
														"usw %0, 0x4(%1);"
														"usw %0, 0x8(%1);"
														"usw %0, 0xc(%1);"
		                        ::"r"(buf), "r"(buf));
			buf+=4;
		}
		if ((((uint32_t)start) & 0x20000000) == 0) {
			writeback_invalidate_dcache_range(start, start+len);
		}

		buf = (uint32_t *)(start + off);
		puts("ULW...\n");
		while (buf < end) {
			__asm__ __volatile__ ("ulw %0, 0x0(%4);"
														"ulw %1, 0x4(%4);"
														"ulw %2, 0x8(%4);"
														"ulw %3, 0xc(%4);"
		                        :"=r"(res0), "=r"(res1), "=r"(res2), "=r"(res3)
		                        :"r"(buf));
			if (((uint32_t)buf != res0) ||
					(res0 != res1) ||
					(res0 != res2) ||
					(res0 != res3)) {
				printf("EE: error found at %p\n", buf);
			}
			buf+=4;
		}
	}
	return;
}

void ulh_ush_test(uint8_t *start, uint32_t len) {
	uint16_t *buf, *end;
	uint16_t in_mem;
	uint16_t res0, res1, res2, res3, res4, res5, res6, res7;

	end = (uint16_t *)(start + len);
	*start = 0x99;

	buf = (uint16_t *)(start + 1);
	printf("II: Unaligned SH/LH test [%p ~ %p]: USH... ", buf, end);
	while (buf < end) {
		in_mem = ((uint32_t)buf & 0xffff);
		__asm__ __volatile__ ("ush %0, 0x0(%1);"
													"ush %0, 0x2(%1);"
													"ush %0, 0x4(%1);"
													"ush %0, 0x6(%1);"
													"ush %0, 0x8(%1);"
													"ush %0, 0xa(%1);"
													"ush %0, 0xc(%1);"
													"ush %0, 0xe(%1);"
		                      ::"r"(buf), "r"(in_mem));
		buf+=8;
	}
	if ((((uint32_t)start) & 0x20000000) == 0) {
		writeback_invalidate_dcache_range(start, start+len);
	}

	buf = (uint16_t *)(start + 1);
	puts("ULH...\n");
	while (buf < end) {
		__asm__ __volatile__ ("ulh %0, 0x0(%8);"
													"ulh %1, 0x2(%8);"
													"ulh %2, 0x4(%8);"
													"ulh %3, 0x6(%8);"
													"ulh %4, 0x8(%8);"
													"ulh %5, 0xa(%8);"
													"ulh %6, 0xc(%8);"
													"ulh %7, 0xe(%8);"
													:"=r"(res0), "=r"(res1), "=r"(res2), "=r"(res3),
													 "=r"(res4), "=r"(res5), "=r"(res6), "=r"(res7)
		                      :"r"(buf));
		if ((((uint32_t)buf & 0xffff) != res0) ||
				(res0 != res1) || (res2 != res3) || (res4 != res5) || (res6 != res7) ||
				(res0 != res2) || (res0 != res4) || (res0 != res6)) {
			printf("EE: error found at %p\n", buf);
		}
		buf+=8;
	}
	return;
}

int do_be_test (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]) {
	uint8_t *start_addr;
	uint32_t len;
	if (argc != 3) {
		return -1;
	}
	start_addr = (uint8_t *)simple_strtoul(argv[1], NULL, 16);
	len = simple_strtoul(argv[2], NULL, 16);
	mem_be_test(start_addr, len);

	ulw_usw_test(start_addr, len);
	ulh_ush_test(start_addr, len);

	return 0;
}

U_BOOT_CMD(
	mbe_test, 3, 1, do_be_test,
	"do byte-enable test",
	"start len"
	);
