#include <common.h>
#include <mpcntl.h>

uint32_t share_integer[32];

static void mp_cce_set(volatile uint32_t *sdata) {
	*sdata = 0;
	while (1) {
		*sdata = *sdata + 1;
	}

	return;
}

static void mp_cce_get(volatile uint32_t *sdata) {
	int i = 0;
	uint32_t last;
	const int cpuid = mp_cpuid();

	last = *sdata;
	while (1) {
		udelay(1);
		if ((int)(*sdata - last) <= 0) {
			mp_printf("II: CPU%d got rewind: x: %08x, y: %08x\n", cpuid, last, *sdata);
		}
		last= *sdata;
		if ((i++ % 0x800000) == 0) {
			mp_printf("II: CPU%d is still alive: %08x\n", cpuid, last);
		}
	}

	return;
}

void mp_cce_owner_shift(volatile uint32_t *sdata) {
	const int cpuid = mp_cpuid();
	const int cpu_num = 4;
	int i, cnt;

	cnt = 0;
	while (1) {
		if ((*sdata % cpu_num) == cpuid) {
			i = *(sdata+1);
			if (((i + 1) % cpu_num) != cpuid) {
				mp_printf("EE: CPU%d is triggered by CPU%d\n", cpuid, i);
			}

			if ((cnt++ % 0x100000) == 0) {
				mp_printf("II: CPU%d is still alive\n", cpuid);
			}

			*(sdata+1) = cpuid;
			*sdata = (cpuid + 1) % cpu_num;
		}
	}
}

void mp_cce_owner_shift_c0_c3(volatile uint32_t *sdata) {
	const int cpuid = mp_cpuid();
	int i, cnt, next;

	if (cpuid == 0) {
		next = 3;
	} else {
		next = 0;
	}

	cnt = 0;
	while (1) {
		if (*sdata == cpuid) {
			i = *(sdata+1);
			if (i != next) {
				mp_printf("EE: CPU%d is triggered by CPU%d\n", cpuid, i);
			}

			if ((cnt++ % 0x1000000) == 0) {
				mp_printf("II: CPU%d is still alive\n", cpuid);
			}

			*(sdata+1) = cpuid;
			*sdata = next;
		}
	}
}

/* Argument example: arg0: 81088208, arg1: 81070000, arg2: 00000000, arg3: 00000000
	 arg0:
	 CPU0 valid ([15:12]:0x8) for getting ([11:8]:0x2) offset([7:0]:0x8)
	 CPU1 valid ([31:28]:0x8) for setting ([27:24]:0x1) offset([7:0]:0x8)
	 arg1:
	 CPU2 does nothing (0)
	 CPU3 valid (8) fro setting (1) offset(7)
	 arg2:
	 CPU4 does nothing (0)
	 CPU5 does nothing (0)
	 arg3:
	 CPU6 does nothing (0)
	 CPU7 does nothing (0)
 */
void mp_cache_coherence_exp(uint32_t arg0, uint32_t arg1, uint32_t arg2, uint32_t arg3) {
	typedef union {
		struct {
			uint16_t v:4;
			uint16_t act:4;
			uint16_t offset:8;
		} f;
		uint16_t v;
	} cce_cfg_t;

	uint32_t i;
	uint32_t arg[] = {arg0, arg1, arg2, arg3};
	uint32_t cpuid = mp_cpuid();
	uint32_t *sdata = &share_integer[0];
	cce_cfg_t cce_cfg;
	char *act_str[] = {
		"IDLE",
		"SETTER",
		"GETTER",
		"OWNER_ROTATION",
		"IDLE"
	};

	i = cpuid / 2;
	cce_cfg.v = arg[i] >> (16 * (cpuid % 2));

	if (cce_cfg.f.v == 0x8) {
		mp_printf("II: CPU%d: V: %d, Act.: %s, IOffset: %d, CP0_CONFIG: %08x\n",
							cpuid, cce_cfg.f.v, act_str[cce_cfg.f.act], cce_cfg.f.offset,
		          GET_CP0(C0_CONFIG));

		if (cce_cfg.f.act == 1) {
			mp_cce_set(&sdata[cce_cfg.f.offset]);
		} else if (cce_cfg.f.act == 2) {
			mp_cce_get(&sdata[cce_cfg.f.offset]);
		} else if (cce_cfg.f.act == 3) {
			if (cpuid == 0) {
				*sdata = 0;
			} else {
				while (*sdata) {
					;
				}
			}
			/* mp_cce_owner_shift(&sdata[cce_cfg.f.offset]); */
			mp_cce_owner_shift_c0_c3(&sdata[cce_cfg.f.offset]);
		}
	}

	return;
}
