#include <common.h>
#include <mpcntl.h>

void hwmutex_test(int hid, int load_loop, int delay_loop) {
	int countdown;
	int cpu_id;
	int acc_lock_cnt;

	acc_lock_cnt = 0;
	while (1) {
		ipc_hwm_wait_lock(hid);

		acc_lock_cnt++;
		if ((acc_lock_cnt % 0x100) == 0) {
			cpu_id = mp_cpuid();
			REG32(0xb8002000) = (cpu_id + '0') << 24;
		}

		countdown = load_loop;
		while (countdown--) {
			asm volatile ("nop;\n");
		};

		ipc_hwm_rlz_lock(hid);

		countdown = delay_loop;
		while (countdown--) {
			asm volatile ("nop;\n");
		};
	}
	return;
}
