#include <asm/regdef.h>
#include <configs/autoconf.h>

	.globl mp_mem_engine_wr
	.set noreorder
	.text
	.ent 	mp_mem_engine_wr
	// a0: base addr
	// a1: data to write
	// a2: length
	// a3: type
mp_mem_engine_wr:
	move t0, a0

	add  t1, t0, a2
	addi t1, t1, -0x200

	li   t2, 1
	beq  a3, t2, _memwr_word_start
	nop

	li   t2, 2
	beq  a3, t2, _memwr_half_start
	nop

	li   t2, 3
	beq  a3, t2, _memwr_byte_start
	nop

// WORD test code starts
_memwr_word_start:
_memwr_word_wstart:
	sw   a1, 0x000(t0)
	sw   a1, 0x020(t0)
	sw   a1, 0x040(t0)
	sw   a1, 0x060(t0)
	sw   a1, 0x080(t0)
	sw   a1, 0x0a0(t0)
	sw   a1, 0x0c0(t0)
	sw   a1, 0x0e0(t0)
	sw   a1, 0x100(t0)
	sw   a1, 0x120(t0)
	sw   a1, 0x140(t0)
	sw   a1, 0x160(t0)
	sw   a1, 0x180(t0)
	sw   a1, 0x1a0(t0)
	sw   a1, 0x1c0(t0)
	sw   a1, 0x1e0(t0)
	sltu v0, t0, t1
	bnez v0, _memwr_word_wstart
	addi t0, 0x200

	move t0, a0
_memwr_word_rstart:
	lw   t2, 0x000(t0)
	lw   t3, 0x020(t0)
	lw   t4, 0x040(t0)
	lw   t5, 0x060(t0)
	lw   t6, 0x080(t0)
	lw   t7, 0x0a0(t0)
	lw   t8, 0x0c0(t0)
	lw   t9, 0x0e0(t0)
	lw   k0, 0x100(t0)
	lw   k1, 0x120(t0)
	or   v0, t2, t3
	and  v1, t2, t3
	lw   t2, 0x140(t0)
	lw   t3, 0x160(t0)
	or   v0, v0, t4
	and  v1, v1, t4
	or   v0, v0, t5
	and  v1, v1, t5
	lw   t4, 0x180(t0)
	lw   t5, 0x1a0(t0)
	or   v0, v0, t6
	and  v1, v1, t6
	or   v0, v0, t7
	and  v1, v1, t7
	lw   t6, 0x1c0(t0)
	lw   t7, 0x1e0(t0)
	or   v0, v0, t8
	and  v1, v1, t8
	or   v0, v0, t9
	and  v1, v1, t9
	or   v0, v0, t2
	and  v1, v1, t2
	or   v0, v0, t3
	and  v1, v1, t3
	or   v0, v0, t4
	and  v1, v1, t4
	or   v0, v0, t5
	and  v1, v1, t5
	or   v0, v0, t6
	and  v1, v1, t6
	or   v0, v0, t7

	bne  a1, v0, _memwr_fail
	and  v1, v1, t7

	bne  a1, v1, _memwr_fail
	sltu v0, t0, t1

	bnez v0, _memwr_word_rstart
	addi t0, 0x200

	jr   ra
	move v0, zero
// WORD test code ends

// HALF test code starts
_memwr_half_start:
	andi a1, a1, 0xffff

_memwr_half_wstart:
	sh   a1, 0x000(t0)
	sh   a1, 0x020(t0)
	sh   a1, 0x040(t0)
	sh   a1, 0x060(t0)
	sh   a1, 0x080(t0)
	sh   a1, 0x0a0(t0)
	sh   a1, 0x0c0(t0)
	sh   a1, 0x0e0(t0)
	sh   a1, 0x100(t0)
	sh   a1, 0x120(t0)
	sh   a1, 0x140(t0)
	sh   a1, 0x160(t0)
	sh   a1, 0x180(t0)
	sh   a1, 0x1a0(t0)
	sh   a1, 0x1c0(t0)
	sh   a1, 0x1e0(t0)
	sltu v0, t0, t1
	bnez v0, _memwr_half_wstart
	addi t0, 0x200

	move t0, a0
_memwr_half_rstart:
	lh   t2, 0x000(t0)
	lh   t3, 0x020(t0)
	lh   t4, 0x040(t0)
	lh   t5, 0x060(t0)
	lh   t6, 0x080(t0)
	lh   t7, 0x0a0(t0)
	lh   t8, 0x0c0(t0)
	lh   t9, 0x0e0(t0)
	lh   k0, 0x100(t0)
	lh   k1, 0x120(t0)
	or   v0, t2, t3
	and  v1, t2, t3
	lh   t2, 0x140(t0)
	lh   t3, 0x160(t0)
	or   v0, v0, t4
	and  v1, v1, t4
	or   v0, v0, t5
	and  v1, v1, t5
	lh   t4, 0x180(t0)
	lh   t5, 0x1a0(t0)
	or   v0, v0, t6
	and  v1, v1, t6
	or   v0, v0, t7
	and  v1, v1, t7
	lh   t6, 0x1c0(t0)
	lh   t7, 0x1e0(t0)
	or   v0, v0, t8
	and  v1, v1, t8
	or   v0, v0, t9
	and  v1, v1, t9
	or   v0, v0, t2
	and  v1, v1, t2
	or   v0, v0, t3
	and  v1, v1, t3
	or   v0, v0, t4
	and  v1, v1, t4
	or   v0, v0, t5
	and  v1, v1, t5
	or   v0, v0, t6
	and  v1, v1, t6
	or   v0, v0, t7

	bne  a1, v0, _memwr_fail
	and  v1, v1, t7

	bne  a1, v1, _memwr_fail
	sltu v0, t0, t1

	bnez v0, _memwr_half_rstart
	addi t0, 0x200

	jr   ra
	move v0, zero
// HALF test code starts

// BYTE test code starts
_memwr_byte_start:
	andi a1, a1, 0xff

_memwr_byte_wstart:
	sb   a1, 0x000(t0)
	sb   a1, 0x020(t0)
	sb   a1, 0x040(t0)
	sb   a1, 0x060(t0)
	sb   a1, 0x080(t0)
	sb   a1, 0x0a0(t0)
	sb   a1, 0x0c0(t0)
	sb   a1, 0x0e0(t0)
	sb   a1, 0x100(t0)
	sb   a1, 0x120(t0)
	sb   a1, 0x140(t0)
	sb   a1, 0x160(t0)
	sb   a1, 0x180(t0)
	sb   a1, 0x1a0(t0)
	sb   a1, 0x1c0(t0)
	sb   a1, 0x1e0(t0)
	sltu v0, t0, t1
	bnez v0, _memwr_byte_wstart
	addi t0, 0x200

	move t0, a0
_memwr_byte_rstart:
	lb   t2, 0x000(t0)
	lb   t3, 0x020(t0)
	lb   t4, 0x040(t0)
	lb   t5, 0x060(t0)
	lb   t6, 0x080(t0)
	lb   t7, 0x0a0(t0)
	lb   t8, 0x0c0(t0)
	lb   t9, 0x0e0(t0)
	lb   k0, 0x100(t0)
	lb   k1, 0x120(t0)
	or   v0, t2, t3
	and  v1, t2, t3
	lb   t2, 0x140(t0)
	lb   t3, 0x160(t0)
	or   v0, v0, t4
	and  v1, v1, t4
	or   v0, v0, t5
	and  v1, v1, t5
	lb   t4, 0x180(t0)
	lb   t5, 0x1a0(t0)
	or   v0, v0, t6
	and  v1, v1, t6
	or   v0, v0, t7
	and  v1, v1, t7
	lb   t6, 0x1c0(t0)
	lb   t7, 0x1e0(t0)
	or   v0, v0, t8
	and  v1, v1, t8
	or   v0, v0, t9
	and  v1, v1, t9
	or   v0, v0, t2
	and  v1, v1, t2
	or   v0, v0, t3
	and  v1, v1, t3
	or   v0, v0, t4
	and  v1, v1, t4
	or   v0, v0, t5
	and  v1, v1, t5
	or   v0, v0, t6
	and  v1, v1, t6
	or   v0, v0, t7

	bne  a1, v0, _memwr_fail
	and  v1, v1, t7

	bne  a1, v1, _memwr_fail
	sltu v0, t0, t1

	bnez v0, _memwr_byte_rstart
	addi t0, 0x200

	jr   ra
	move v0, zero
// BYTE test code starts

_memwr_fail:
	jr   ra
	move v0, t0
_mp_mem_engine_end:
.end mp_mem_engine_wr

	.global mp_mem_engine_size
	.data
mp_mem_engine_size:
	.int _mp_mem_engine_end - mp_mem_engine_wr
