#include <asm/regdef.h>
#include <configs/autoconf.h>

	.globl mp_mem_engine_byte_wr
	.set noreorder
	.text
	.ent 	mp_mem_engine_byte_wr
	// a0: base addr
	// a1: data to write
	// a2: block size in byte
mp_mem_engine_byte_wr:
	move t0, a0

	add  t1, t0, a2
	addi t1, t1, -0x200

	andi a1, a1, 0xff

_memwr_byte_wstart:
	sb   a1, 0x000(t0)
	sb   a1, 0x020(t0)
	sb   a1, 0x040(t0)
	sb   a1, 0x060(t0)
	sb   a1, 0x080(t0)
	sb   a1, 0x0a0(t0)
	sb   a1, 0x0c0(t0)
	sb   a1, 0x0e0(t0)
	sb   a1, 0x100(t0)
	sb   a1, 0x120(t0)
	sb   a1, 0x140(t0)
	sb   a1, 0x160(t0)
	sb   a1, 0x180(t0)
	sb   a1, 0x1a0(t0)
	sb   a1, 0x1c0(t0)
	sb   a1, 0x1e0(t0)
	sltu v0, t0, t1
	bnez v0, _memwr_byte_wstart
	addi t0, 0x200

	move t0, a0
_memwr_byte_rstart:
	lb   t2, 0x000(t0)
	lb   t3, 0x020(t0)
	lb   t4, 0x040(t0)
	lb   t5, 0x060(t0)
	lb   t6, 0x080(t0)
	lb   t7, 0x0a0(t0)
	lb   t8, 0x0c0(t0)
	lb   t9, 0x0e0(t0)
	lb   k0, 0x100(t0)
	lb   k1, 0x120(t0)
	or   v0, t2, t3
	and  v1, t2, t3
	lb   t2, 0x140(t0)
	lb   t3, 0x160(t0)
	or   v0, v0, t4
	and  v1, v1, t4
	or   v0, v0, t5
	and  v1, v1, t5
	lb   t4, 0x180(t0)
	lb   t5, 0x1a0(t0)
	or   v0, v0, t6
	and  v1, v1, t6
	or   v0, v0, t7
	and  v1, v1, t7
	lb   t6, 0x1c0(t0)
	lb   t7, 0x1e0(t0)
	or   v0, v0, t8
	and  v1, v1, t8
	or   v0, v0, t9
	and  v1, v1, t9
	or   v0, v0, t2
	and  v1, v1, t2
	or   v0, v0, t3
	and  v1, v1, t3
	or   v0, v0, t4
	and  v1, v1, t4
	or   v0, v0, t5
	and  v1, v1, t5
	or   v0, v0, t6
	and  v1, v1, t6
	or   v0, v0, t7

	bne  a1, v0, _memwr_byte_fail
	and  v1, v1, t7

	bne  a1, v1, _memwr_byte_fail
	sltu v0, t0, t1

	bnez v0, _memwr_byte_rstart
	addi t0, 0x200

	jr   ra
	move v0, zero

_memwr_byte_fail:
	jr   ra
	move v0, t0
_mp_mem_engine_byte_end:
.end mp_mem_engine_byte_wr

	.global mp_mem_engine_byte_size
	.data
mp_mem_engine_byte_size:
	.int _mp_mem_engine_byte_end - mp_mem_engine_byte_wr
