#include <autoconf.h>
#include <mpcntl.h>

extern int mp_printf(const char *format, ...);
extern int initdram(int);
extern int mp_mem_engine_wr(int, int, int, int);
extern int mp_mem_engine_size;
extern void *memcpy(void *dest, const void *src, int n);
typedef int (mem_engine_t)(int, int, int, int);

static int mp_bank_leap(int cur_addr, const int start, const int end) {
	int ret = cur_addr;

	if (ret > end) {
		ret = start;
	}
	return ret;
}

static void mp_mt_dump_error(const int cpuid, const uint32_t pat, const uint32_t *addr) {
	int i = 2;
	mp_printf("EE: CPU%d mem w/r [%08x] fail @ %08x:\n", cpuid, pat, addr);

	while (i--) {
		mp_printf("C%d: %08x %08x %08x %08x %08x %08x %08x %08x\n", cpuid,
		          &addr[0x00], &addr[0x08], &addr[0x10],
		          &addr[0x18], &addr[0x20], &addr[0x28],
		          &addr[0x30], &addr[0x38]);
		mp_printf("C%d: %08x %08x %08x %08x %08x %08x %08x %08x\n", cpuid,
		          addr[0x00], addr[0x08], addr[0x10],
		          addr[0x18], addr[0x20], addr[0x28],
		          addr[0x30], addr[0x38]);
		addr += 0x40;
	}

	while (1) {
		;
	}
	return;
}

void mp_mt_prep_iarea(const void *func, void *start, void *end, uint32_t size) {
	void *cur = 0;

	cur = start;
	mp_printf("II: CPU%d prepares iarea: %08x ~ %08x, %d B x %d\n",
	          mp_cpuid(), start, end, size, (end - start + size - 1)/size);
	while ((uint32_t)cur <= (uint32_t)end) {
		memcpy(cur, (const void *)func, size);
		cur += size;
	}

	return;
}

void mp_memtest(int d_start, int d_end_len, uint32_t i_start, uint32_t i_end_type) {
	const int dram_size_b = 128*1024*1024;
	const int bank_size_b = dram_size_b / 8;

	uint32_t i_type = i_end_type & 0xf;
	const uint32_t i_b = mp_mem_engine_size;
	const uint32_t i_end = (i_end_type & 0xfffffff0) - i_b;
	const uint32_t i_num = (i_end - i_start + i_b - 1) / i_b;
	const uint32_t i_bank_cnt = (i_end - i_start + (bank_size_b - 1)) / (bank_size_b);
	const uint32_t i_bank_unit_b = ((bank_size_b + i_b - 1) / i_b) * i_b;

	const uint32_t d_b = (d_end_len & 0xfff) * 1024;
	const uint32_t d_end = (d_end_len & 0xfffff000) - d_b;
	const uint32_t d_num = (d_end - d_start + d_b - 1) / d_b;
	const uint32_t d_bank_cnt = (d_end - d_start + (bank_size_b - 1)) / (bank_size_b);
	const uint32_t d_bank_unit_b = ((bank_size_b + d_b - 1) / d_b) * d_b;

	const char *i_name[] ={
		"Word",
		"Half",
		"Byte",
		"Dyanmic",
		"NA"
	};

	int i, next_i, next_d, cpuid, pat, res, i_soff, d_soff, i_dyn;
	mem_engine_t *mem_eng_func;

	cpuid = mp_cpuid();

	mp_mt_prep_iarea((const void *)mp_mem_engine_wr, (void *)i_start, (void *)i_end, i_b);

	d_start = d_start + (cpuid * 4);
	next_d = mp_bank_leap(d_start, d_start, d_end);
	next_i = mp_bank_leap(i_start + (cpuid * mp_mem_engine_size), i_start, i_end);

	for (i=1; i<cpuid; i++) {
		next_d = mp_bank_leap(next_d + d_bank_unit_b, d_start + ((i/d_bank_cnt) * d_b), d_end);
		next_i = mp_bank_leap(next_i + i_bank_unit_b, i_start + ((i/i_bank_cnt) * i_b), i_end);
	}

	if (i_type > 2) {
		i_dyn = 1;
		i_type += cpuid;
	} else {
		i_dyn = 0;
	}

	while (1) {
		i_type = ((i_type + i_dyn) % 3);

		d_soff = ((i % d_num) / d_bank_cnt) * d_b;
		i_soff = ((i % i_num) / i_bank_cnt) * i_b;
		next_d = mp_bank_leap(next_d + d_bank_unit_b, d_start + d_soff, d_end);
		next_i = mp_bank_leap(next_i + i_bank_unit_b, i_start + i_soff, i_end);

		mp_printf("DD: CPU%d I@%08x(%s, %d B), D@%08x\n",
		          cpuid, next_i, i_name[i_type], i_b, next_d);

		mem_eng_func = (mem_engine_t *)next_i;
		pat = cpuid;
		res = mem_eng_func(next_d, pat, d_b, i_type);

		if (res == 0) {
			pat = (next_d & 0x0fffffff) | (cpuid << 28);
			res = mem_eng_func(next_d, pat, d_b, i_type);
		}

		if (res) {
			mp_mt_dump_error(cpuid, pat, (uint32_t *)res);
		}

		i++;
	}

	return;
}
