#include <common.h>
#include <command.h>
#include <mpcntl.h>

__attribute__ ((noinline))

/* #define printf mp_printf */
#define printf xxx

void mpcntl_cmd_run_test(int a0, int a1, int a2, int a3);
void hwmutex_test(int hid, int load_loop, int delay_loop);
void mp_memtest(int start, int end, int data);
void mp_cache_coherence_exp(void);

char mp_stack[CONFIG_MP_CPU_NUM * CONFIG_MP_STACK_SZ_B];
volatile mp_cmd_t mpcmd;

int mp_alive[CONFIG_MP_CPU_NUM];

const mp_func_str_ptr_t mpfunc[] = {
	MP_MAKE_FUNCNAME(mp_memtest),
	MP_MAKE_FUNCNAME(mpcntl_cmd_run_test),
	MP_MAKE_FUNCNAME(hwmutex_test),
	MP_MAKE_FUNCNAME(mp_cache_coherence_exp),
};

int mp_get_sp(int cid) {
	return ((int)mp_stack + (cid + 1) * CONFIG_MP_STACK_SZ_B - 8);
}

void mpcntl_cmd_run_test(int a0, int a1, int a2, int a3) {
	mp_printf("II: CPU%d: %d, %d, %d, %d\n", mp_cpuid(), a0, a1, a2, a3);
	return;
}

static void mp_cpu_banner(int cpuid) {
	mp_printf("CPU%d ready, SP: %08x\n", cpuid, GET_GPR(sp));

	mp_alive[cpuid] = 1;

	return;
}

static void mp_trigger_dispatcher(int cpuid, mpf_t mpf, uint32_t arg0,
                                  uint32_t arg1, uint32_t arg2, uint32_t arg3) {
	if (mp_alive[cpuid]) {
		if (mpf) {
			mpcmd.function = mpf;
			mpcmd.arg[0] = arg0;
			mpcmd.arg[1] = arg1;
			mpcmd.arg[2] = arg2;
			mpcmd.arg[3] = arg3;
		}

		mpcmd.targcpu = cpuid;
		while (mpcmd.targcpu == cpuid) {
			MIPS_SYNC2();
		}
	} else {
		mp_printf("II: CPU%d is not alive\n", cpuid);
	}
	return;
}

void mpcntl_func_dispatcher(void) {
	const int cpuid = mp_cpuid();
	uint32_t arg[4];
	mpf_t *mpf;

	mp_cpu_banner(cpuid);

	while (1) {
		if (mpcmd.targcpu == cpuid) {
			mpf = mpcmd.function;
			arg[0] = mpcmd.arg[0];
			arg[1] = mpcmd.arg[1];
			arg[2] = mpcmd.arg[2];
			arg[3] = mpcmd.arg[3];
			mpcmd.targcpu = 0;
			mpf(arg[0], arg[1], arg[2], arg[3]);
			MIPS_SYNC2();
		} else {
			udelay(10*1000);
		}
	}

	return;
}

void mp_init_dummy(void) {
	mp_cpu_banner(mp_cpuid());
	return;
}

static void mpcntl_help(void) {
	int f;
	puts("mpcntl help:\n");
	puts("1. prepare environment:\n");
	puts("  mpcntl -s 0x80fffff8 -b 0xF -0 0xa0 -1 0xb1 -2 0xc2 -3 0xd3 -c 1\n");
	puts("3. stop execution:\n");
	puts("  mpcntl -c 1 -k\n");
	puts("4. dump multi-processing info:\n");
	puts("  mpcntl -i\n");
	puts("5. help:\n");
	puts("  mpcntl -h\n\n");
	puts("  -b: boot the rest of CPUs to cmd_handler()\n");
	puts("  -i: dump info.\n");
	puts("  -h: help.\n");
	puts("  -c: cpu id to kick off\n");
	puts("  -s: stack pointer\n");
	puts("  -f: function name\n");
	for (f=0; f<sizeof(mpfunc)/sizeof(mpfunc[0]); f++) {
		mp_printf("\t%s: %08x\n", mpfunc[f].name, mpfunc[f].fptr);
	}
	puts("  -0: arguments 0\n");
	puts("  -1: arguments 1\n");
	puts("  -2: arguments 2\n");
	puts("  -3: arguments 3\n");

	puts("  ----TODO----\n");
	puts("  -k: kill\n");
	return;
}

static void mpcntl_init_mpenv(const int en_bitmask) {
	int i, timeout;

	mp_printf("Stack Region of MP env.: %08x ~ %08x\n",
	           mp_stack, sizeof(mp_stack) + mp_stack - 1);

  for (i=0; i<CONFIG_MP_CPU_NUM; i++) {
		mp_alive[i] = 0;
	}

	for (i=0; i<CONFIG_MP_CPU_NUM; i++) {
		if (((1<<i) & en_bitmask) &&
		    (mp_attr[i].en)) {
			mp_attr[i].en();

			timeout = 100;
			while ((mp_alive[i] == 0) && (--timeout)) {
				udelay(1000);
			}
			if (timeout == 0) {
				mp_printf("WW: CPU%d is enabled but doesn't respond\n", i);
			}
		}
	}

	for (i=0; i<CONFIG_MP_CPU_NUM; i++) {
		if (mp_attr[i].kill &&
		    mp_alive[i] &&
		    (((1<<i) & en_bitmask) == 0)) {
			mp_trigger_dispatcher(i, (mpf_t *)mp_attr[i].kill, 0, 0, 0, 0);
			mp_alive[i] = 0;
		}
	}

	return;
}

#define inline_ascii_value(c, base) ({char __ascii_c=c; int __ascii_base=base; int __ascii_r;	\
			if ((__ascii_c<='9') && (__ascii_c>='0')) {__ascii_r=__ascii_c-'0';} \
			else {__ascii_c|=32;__ascii_r=((__ascii_base==16)&&(__ascii_c<='f')&&(__ascii_c>='a'))?(__ascii_c-'a'+10):-1;} \
			__ascii_r;})
static int atoi(const char *v) {
	int base=10, d, r=0;
	if (*v=='\0') return 0;
	if ((v[0]=='0') && ((v[1]&~32)=='X')) {
		v+=2;
		base=16;
	}
	while ((d=inline_ascii_value(*(v++), base))>=0) {
		r *= base;
		r += d;
	}
	return r;
}

static mpf_t *mp_fname_2_fptr(const char *needle) {
	int i;

	for (i=0; i<sizeof(mpfunc)/sizeof(mp_func_str_ptr_t); i++) {
		if (strcmp(needle, mpfunc[i].name) == 0) {
			return mpfunc[i].fptr;
		}
	}
	mp_printf("EE: MP func.: %s does not exist\n", needle);
	return (mpf_t *)NULL;
}

static int do_mpcntl(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]) {
	int argi, i;

	if (argc < 2) {
		goto call_for_help;
	}

	mpcmd.targcpu = 0;
	mpcmd.sp = 0;

	flush_cache(0, 0);

	argi = 1;
	while (argi < argc) {
		if (argv[argi][0] != '-') {
			mp_printf("EE: unknown option %s\n", argv[argi]);
			goto call_for_help;
		}

		switch(argv[argi][1]) {
		case 'i':
			/* mpcntl_info(); */
			break;
		case 'b':
			argi++;
			mpcntl_init_mpenv(atoi(argv[argi]));
			break;
		case 'c':
			argi++;
			mp_trigger_dispatcher(atoi(argv[argi]), NULL, 0, 0, 0, 0);
			break;
		case 's':
			argi++;
			mpcmd.sp = atoi(argv[argi]);
			break;
		case 'f':
			argi++;
			mpcmd.function = mp_fname_2_fptr(argv[argi]);
			break;
		case '0':
		case '1':
		case '2':
		case '3':
			mpcmd.arg[argv[argi][1] - '0'] = atoi(argv[argi+1]);
			argi++;
			break;
		case 'a':
			mpcmd.sp = 0;
			for (i=1; i<CONFIG_MP_CPU_NUM; i++) {
				mp_trigger_dispatcher(i, NULL, 0, 0, 0, 0);
			}
			if (mp_alive[0]) {
				mpcmd.function(mpcmd.arg[0], mpcmd.arg[1], mpcmd.arg[2], mpcmd.arg[3]);
			}
			break;
		default:
			mp_printf("EE: unknown option %s\n", argv[argi]);
			goto call_for_help;
		}
		argi++;
	}

	return 0;

call_for_help:
	mpcntl_help();

	return 0;
}
U_BOOT_CMD(
  mpcntl, 32, 0, do_mpcntl,
  "mpcntl - MIPS multi-processing control",
  "");

#define MP_SIMPLE_TEST
#ifdef MP_SIMPLE_TEST 
extern void mp_init_mipsia(void);
static void mpcntl_activate_mpenv(const int en_bitmask) {
	int i, timeout;

	mp_printf("Stack Region of MP env.: %08x ~ %08x\n",
	           mp_stack, sizeof(mp_stack) + mp_stack - 1);

	for (i=0; i<CONFIG_MP_CPU_NUM; i++) {
		mp_alive[i] = 0;
	}
	mp_init_mipsia();
	for (i=1; i<CONFIG_MP_CPU_NUM; i++) {
		if (((1<<i) & en_bitmask)) {

			timeout = 100;
			while ((mp_alive[i] == 0) && (--timeout)) {
				udelay(1000);
				MIPS_SYNC2();
			}
			if (timeout == 0) {
				mp_printf("WW: CPU%d is enabled but doesn't respond\n", i);
			}
		}
	}

	for (i=0; i<CONFIG_MP_CPU_NUM; i++) {
		MIPS_SYNC2();
		if (mp_attr[i].kill &&
		    mp_alive[i] &&
		    (((1<<i) & en_bitmask) == 0)) {
			mp_trigger_dispatcher(i, (mpf_t *)mp_attr[i].kill, 0, 0, 0, 0);
			mp_alive[i] = 0;
		}
	}

	return;
}

 
int simple_test_result[8];
static int mp_get_vpe_count(void){
#define GCR_CONF_ADDR (0xbfbf8000)	
	  return ((REG32(GCR_CONF_ADDR) & 0xff) + 1)*2;	
}

static int mp_get_vpe_bitmap(void){
  int vpe_bitmap = 0;
  int i;
  int vpe_cnt = mp_get_vpe_count();	
  for (i=0; i< vpe_cnt; i++){
	  vpe_bitmap |= (1<<i);
  }
  
  return vpe_bitmap;
 
} 
/* Fibonacci function */
static void simple_test(int n){
    int N;
    int i, Y=0, X=1, Fn = 0, Z=0;
	N = n;
    if (N == 1) {
        Fn = 1;
    } else {
        for(i = 2; i <= N; i++) {
            Z = X + Y;
            Fn = Z;
            Y = X;
            X = Z;
        }
    }

	simple_test_result[mp_cpuid()] = Fn;
	MIPS_SYNC2();
 	return;// Fn	
}

int mp_simple_test(int arg0){
	int cpus = mp_get_vpe_count();
	int en_bitmask = mp_get_vpe_bitmap();
    int timeout = 10000;	
	int i;
	memset(simple_test_result, '\0', sizeof(simple_test_result));

	for(i=1; i< cpus; i++){
      if( ((1<<i) & en_bitmask) &&  (mp_alive[i] ==0)   ){
		mpcntl_activate_mpenv(en_bitmask);
		break;
	  }
    }
	flush_cache(0, 0);
	MIPS_SYNC2();
	
	udelay(10*1000);
    for(i=1; i< cpus; i++){
     mp_trigger_dispatcher(i, (mpf_t *)simple_test, arg0, 0, 0 ,0); 
	 MIPS_SYNC2();
    }

//	mp_printf("[370][CPU%d] CONFIG=0x%x , GCR_CL_COHERENCErv=0x%x\n", mp_cpuid(),  GET_CP0(C0_CONFIG) , GCR_CL_COHERENCErv);
    while(timeout--){
		MIPS_SYNC2();
		for(i=1; i< cpus; i++){
			//mp_printf("## %d, timeout=%d\n", simple_test_result[i] , timeout);
			if(simple_test_result[i] == 0){
					break;
			}
		}
		if(i == cpus){
			goto CHECK_RESULT;
		}
		udelay(1000);
	}
	
    if(timeout <=1 ){
		mp_printf("Timeout --> Fail\n");
		return 1;
	}
	
CHECK_RESULT:

	for(i=1; i< (cpus - 1); i++){
		MIPS_SYNC2();
		if( simple_test_result[i] !=  simple_test_result[(i+1)] ){
			mp_printf("simple_test_result, Fail, i(%d), %d, %d\n", i, simple_test_result[i] , simple_test_result[ (i+1 ) ]);
			return 1;
		}
	}
	//mp_printf("SUCC\n");
	return 0;
}


static int do_mp_test(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]) {
	int arg0 = 10000;
	
	if(argc == 2){
		arg0 = atoi(argv[1]);
	}
	if(mp_simple_test(arg0)){
        mp_printf("mp_test: FAIL\n");
		return 1;
	}
	mp_printf("mp_test: PASS\n");
     return 0;
}

U_BOOT_CMD(
  mp_test, 2, 0, do_mp_test,
  "mp_test - MIPS CPUs Simple Test",
  "mp_test [parameter0]");
 
#endif 