#include <asm/regdef.h>
#include <configs/autoconf.h>

#define MP_CMD_BASER s0
#define CPUIDR s1
#define MP_CMD_TARGCPU 0
#define MP_CMD_CMD 4
#define MP_CMD_SP 8
#define MP_CMD_FUNCTION 12
#define MP_CMD_ARG0 16
#define MP_CMD_ARG1 20
#define MP_CMD_ARG2 24
#define MP_CMD_ARG3 28

	.global _mpcntl_func_dispatcher
	.text
_mpcntl_func_dispatcher:
	la   MP_CMD_BASER, mpcmd

	jal  mp_cpuid
	nop

	move CPUIDR, v0

	move a0, CPUIDR
	jal  mp_cpu_banner
	nop

	_poll_for_command:
	lw   t3, MP_CMD_TARGCPU(MP_CMD_BASER)
	nop

	bne  t3, CPUIDR, _poll_for_command
	nop

	lw   t4, MP_CMD_FUNCTION(MP_CMD_BASER)
	lw   a0, MP_CMD_ARG0(MP_CMD_BASER)
	lw   a1, MP_CMD_ARG1(MP_CMD_BASER)
	lw   a2, MP_CMD_ARG2(MP_CMD_BASER)
	lw   a3, MP_CMD_ARG3(MP_CMD_BASER)

	lw   t0, MP_CMD_SP(MP_CMD_BASER)
	nop
	beqz t0, _keep_current_sp
	nop
	move sp, t0

	_keep_current_sp:
	sw   zero, MP_CMD_TARGCPU(MP_CMD_BASER)

	jalr t4
	nop

	j	_poll_for_command
	nop

	//s0 ~ s8 were destroied, this function should NEVER RETURN!
