#include <common.h>
#include <command.h>

static void
info_idx(int idx) {
	int item_left = 16;

	puts(" # ");
	while (item_left--) {
		printf("%02d ", idx--);
	}
	putc('\n');
	return;
}

static void
info_int_en(int idx, uint32_t reg) {
	int item_left = 16;

	puts("EN ");
	while (item_left--) {
		printf(" %c ", ((reg>>idx) & 1) == 1? 'E':' ');
		idx--;
	}
	putc('\n');
	return;
}

static void
info_int_status(int idx, uint32_t reg) {
	int item_left = 16;

	puts(" T ");
	while (item_left--) {
		printf(" %c ", ((reg>>idx) & 1) == 1? 'T':' ');
		idx--;
	}
	putc('\n');
	return;
}

static void
info_int_rs(int idx) {
	return;
}

int otto_rtk_int_mon(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]) {
	const int int_max = 31;
	int grp_idx, i;
	uint32_t gimr, gisr, gimr_last, gisr_last;

	gimr_last = REG32(0xb8003000);
	gisr_last = REG32(0xb8003004);

	i = 0;
	while (1) {
		printf("Int. Mon. #%d ----------------\n", i++);
		for (grp_idx = int_max; grp_idx > 0; grp_idx -= 16) {
			info_idx(grp_idx);
			info_int_en(grp_idx, gimr_last);
			info_int_status(grp_idx, gisr_last);
			info_int_rs(grp_idx);
			putc('\n');
		}

		while (1) {
			udelay(100);
			gimr = REG32(0xb8003000);
			gisr = REG32(0xb8003004);
			if ((gimr != gimr_last) ||
					(gisr != gisr_last)) {
				gimr_last = gimr;
				gisr_last = gisr;
				break;
			}
		}
	}

	return 0;
}

U_BOOT_CMD(
	int_mon, 1, 0, otto_rtk_int_mon,
	"Monitor Interrupt Cntlr. Status",
	""
	);
