#include <common.h>

uint32_t
dram_psize_b(void) {
	const uint8_t BNKCNTv[] = {1, 2, 3};
	const uint8_t BUSWIDv[] = {0, 1, 2};
	const uint8_t ROWCNTv[] = {11, 12, 13, 14, 15, 16};
	const uint8_t COLCNTv[] = {8, 9, 10, 11, 12};

	const uint32_t dcr = REG32(0xb8001004);
	uint32_t size = 1 << (BNKCNTv[(dcr >> 28) & 0x3] +
	                      BUSWIDv[(dcr >> 24) & 0x3] +
	                      ROWCNTv[(dcr >> 20) & 0xF] +
	                      COLCNTv[(dcr >> 16) & 0xF]);
	return size;
}

uint32_t
dram_vsize_b(void) {
	const uint32_t max_dram_vsize_b = 256*1024*1024;
	return (dram_psize_b() > max_dram_vsize_b) ? max_dram_vsize_b : dram_psize_b();
}

uint32_t
dram_type(void) {
	uint32_t mcr = REG32(0xb8001000);
	return ((mcr >> 28) + 1);
}

char *
dram_size_notation(char *str) {
	char *cur = str;
#if (OTTO_BYPASS_DRAM_SZ_DET == 1)
	switch (dram_psize_b() / 1024 / 1024) {
	default:
		*cur++ = '~'; break;
	case 0x400:
		*cur++ = '!';
	case 0x200:
		*cur++ = '!';
	case 0x100:
		*cur++ = '!';
	case 0x80:
		*cur++ = '!'; break;
	case 0x40:
		*cur++ = '.';
	case 0x20:
		*cur++ = '.';
	case 0x10:
		*cur++ = '.'; break;
	}
#endif
	*cur = 0;
	return str;
}
