#include <common.h>
#include <asm/otto_pll.h>
#include <misc_setting.h>
#define OTTO_CID ((*(soc_t *)(0x9F000020)).cid)&0xFFFF

//#define PROCESSOR_ID_RLX5281 (0xdc02)

extern u32 board_CPU_freq_hz(void);
extern u32 board_LX_freq_hz(void);

phys_size_t initdram(int board_type __attribute__((unused))) {
	const unsigned char BNKCNTv[] = {1, 2, 3};
	const unsigned char BUSWIDv[] = {0, 1, 2};
	const unsigned char ROWCNTv[] = {11, 12, 13, 14, 15, 16};
	const unsigned char COLCNTv[] = {8, 9, 10, 11, 12};
	uint32_t dcr = *((volatile int *)(0xb8001004));
	uint32_t size = 1 << (BNKCNTv[(dcr >> 28) & 0x3] +
		             BUSWIDv[(dcr >> 24) & 0x3] +
		             ROWCNTv[(dcr >> 20) & 0xF] +
	        	     COLCNTv[(dcr >> 16) & 0xF]);
	return (size>0x10000000)?0x10000000:size;
}

inline static uint32_t dram_type(void) {
	uint32_t mcr = *((volatile uint32_t *)0xb8001000);
	return ((mcr >> 28) + 1);
}

int checkboard (void) {
	switch(OTTO_CID){
        case ST_RTL9603C:
            puts("Board:RTL9603C, ");
            break;        
        case ST_RTL9603CP:            
            puts("Board:RTL9603CP, ");            
            break;        
        case ST_RTL9603CW:            
            puts("Board:RTL9603CW, ");            
            break;        
        case ST_RTL9603CE:
            puts("Board:RTL9603CE, ");
            break;
        case ST_RTL9607C:            
            puts("Board:RTL9607C, ");            
            break;        
        case ST_RTL9607CP:            
            puts("Board:RTL9607CP, ");            
            break;        
        case ST_RTL9607E:            
            puts("Board:RTL9607E, ");            
            break;
        case ST_RTL9607EP:            
            puts("Board:RTL9607EP, ");            
            break;
        default:             
            puts("Board:RTL9607C/RTL9603C, ");
            break;                
    }


    printf("CPU:%dMHz, LX:%dMHz, MEM:%dMHz",
       board_CPU_freq_mhz(),
       board_LX_freq_mhz(),
       board_DRAM_freq_mhz());
    uint32_t mcr = *((volatile int *)(0xb8001000));
    uint32_t is_onfi = (((mcr>>24)&0x3)==3)?1:0;
    if(!is_onfi) printf(", SPIF:%dMHz", board_SCLK_freq_mhz());
    printf(", Type:DDR%d\n", dram_type());

    return 0;
}
