#include <common.h>
#include <command.h>
#include <soc.h>

#ifdef CONFIG_CMD_DRAM_TEST
extern int dram_test (int flag, int argc, char * const argv[]);
/*
 * Do DRAM test.
 */
int do_dram_test (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	return dram_test(flag, argc, argv);
}

U_BOOT_CMD(
        mdram_test,    10,    1,     do_dram_test,
        "mdram_test   - do DRAM test.",
        "[-l/-loops <test loops>] [-r/-range <star address> <test size>] [-b/-block_e] [-reset <all>] [-pstr <pass msg>] [-fstr <fail msg>]\n"
        "    - do DRAM test."
);
#endif
#ifdef CONFIG_CMD_FLASH_TEST
extern int flash_test (int flag, int argc, char * const argv[]);
/*
 * Do flash test.
 */
int do_flash_test (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	return flash_test(flag, argc, argv);
}

U_BOOT_CMD(
        mflash_test,    6,    1,     do_flash_test,
        "mflash_test   - do spi-nor flash test.",
        "[-l/-loops <test loops>] [-b/-block_e] [-reset <all>]\n"
        "    - do flash test."
);
#endif

/*
 * Do "whole system reset" that depens on different project.
 */
int do_reset_all(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]) {
	SYSTEM_RESET();
	return 0;
}

U_BOOT_CMD(
        reset_all, 1, 0,    do_reset_all,
        "Perform whole chip RESET of the CPU",
        ""
);
