/*************************************************
 * This is for dram waveform measurement
 * From Aaron Chu
 *************************************************/
#include <common.h>
#include <soc.h>
#define dcache_flush                    (((soc_t *)(0x9f000020))->bios).dcache_writeback_invalidate_all

void dram_write_pattern(uint32_t dram_start,uint32_t write_loop) 
{
    int i,j;
    //uint32_t start_value;
    volatile uint32_t *start;

    const uint32_t mp_dram_patterns[] = 
    {
        0x5f702d12,0x4a2b8a41,0x58cd3b26,0x95f9ca8b,
        0xd8a39473,0x9e50f51d,0x70a2f75d,0x799b8763,
        0x8e8c6cae,0xc7841f38,0x27da3f14,0xd14cae5f,
        0x1e213097,0xef5db56c,0xd18f7775,0xbd84b292,
        0xe436de4c,0x8988fea9,0xb5eeda8f,0xe17d1d7d,
        0xc088d667,0xcfb29b50,0x3013f231,0xfa660681,
        0x1568036c,0x779a76cc,0xf2d8967e,0xd3773d61,
        0x0d728dff,0xf086177d,0x4d66b22c,0x8977ae71,
        0x400a5bb1,0x922f7502,0x30730a9f,0x849347ee,
        0x191763a1,0xee886c17,0x6e933d90,0x3ebfb10a,
        0xe41add67,0x5810fd1e,0x0baabb9a,0x4544a5e0,
        0xbe0b0670,0x3284e2e8,0xc477d1dd,0xb6ef4343,
        0x8f27bcbe,0x2e7c3096,0xdba82956,0x88d47e5d,
        0xa91e9f80,0x43ed1c43,0x1cbdf31c,0x3ea1d07e,
        0x047d7a9c,0x34b8460b,0xe2f0c34e,0x2e66e4ae,
        0x0251b4a2,0x2c7d1dc0,0x15665d86,0x6602681d,
        0x6ecb2978,0x2b3be3b9,0xf8a25b31,0x7fe98177,
        0xd3d95dcc,0x147cbde9,0xc77e2d8c,0xd04847c6,
        0x145e4893,0x8c83f48a,0x31e6bd83,0xe8243da5,
        0xfab1efec,0x12d06bad,0x1676233b,0x812d59a4,
        0xec25a615,0x67d700a2,0xa42bf834,0x0f84f5d9,
        0xe4d75377,0x18023256,0x8c08e616,0x3bbd2fa3,
        0x0c0ed720,0xe7651af4,0xc65f8db7,0x2de326c5,
        0xc8673112,0x8403c70b,0x64eca900,0xd845a4c9,
        0xb332ff6e,0xa0ca14ac,0x9cae2fc1,0x0b7d6356,
        0x38337533,0xbc1f97c8,0x5c2da452,0xc40885a4,
        0x84eb2547,0xb0a3dd4f,0x00df7044,0x066a9033,
        0xc0f00747,0x09efbbcc,0x0bda3343,0xe956eb2d,
        0xdaa575e4,0x9d9755da,0x45277c7a,0xfd16abfe,
        0x009ea460,0x9e404bc9,0x2085c22f,0x3e7718f1,
        0x3c039132,0x96aff4a0,0x38c74b69,0x055f0e12,
        0x0950a632,0x408a14da,0xa57f4f61,0x241a27b7
    };

    //Cache flush
    dcache_flush();
    for (i=0;i<write_loop;i++){
        printf("DRAM Write Pattern: %08d\r", i+1);
        /* write pattern*/
        start = (uint32_t *)(dram_start);
        for (j=0; j<(32768/4); j++, start++) {    // cache size is 32Kbyte(32768 byte)
            *start = mp_dram_patterns[i % (sizeof(mp_dram_patterns) / sizeof(uint32_t))];    //repeat "mp_dram_patterns" and fill scan_size
    //      puts("address("); puthex(start); puts(") = 0x"); puthex(mp_dram_patterns[i % (sizeof(mp_dram_patterns) / sizeof(uint32_t))]); puts("\n\r");
        }
        //Cache flush
        dcache_flush();
        if (ctrlc()) { putc ('\n'); return; }
    }
    
    return;
}

int do_dram_wp (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    if(argc<3) {
        printf("Incomplete Command\n");
        return 1;
    }
    uint32_t addr=0x80000000, loop=1, i=1;
    while(i<argc) {
        if('-' == *argv[i]) {
            switch(*(argv[i]+1)) {
                case 's':
                    addr = simple_strtoul(argv[i+1], NULL, 10);
                    i+=2;
                    break;
                case 'l':
                    loop = simple_strtoul(argv[i+1], NULL, 10);
                    i+=2;
                    break;
                default:
                    i++;
                    break;
            }
        }
    }
    dram_write_pattern(addr, loop);
    puts("\ndone\n");
    return 0;
}


U_BOOT_CMD(
        dram_wp, 6, 1, do_dram_wp,
        "- do dram write pattern. ",
        "-s <start addr> [-l <test loops>]\n"\
);
