#include <common.h>
#include <cpu.h>
#include <asm/otto_pll.h>
#include <swcore_reg.h>
#include <misc_setting.h>

#define OTTO_CID ((*(soc_t *)(0x9F000020)).cid)&0xFFFF

#define ST_RTL9602CVD5CG (5)

extern u32 board_CPU_freq_hz(void);
extern u32 board_LX_freq_hz(void);
extern char * dram_size_notation(char *str);
extern uint32_t dram_type(void);
extern uint32_t dram_vsize_b(void);

enum {
	_9607c_string = 0,
	_9603c_string = 1,
	_9603cvd_string = 2,
	_9602cvd_string = 3,
	_default_string = 4,
};
char *board_string[] = {
	[_9607c_string] = "9607C\0 \0",
	[_9603c_string] = "9603C\0 \0",
	[_9603cvd_string] = "9603CVD\0 \0",
	[_9602cvd_string] = "9602CVD\0 \0",
	[_default_string] = "9607C/03C/03CVD\0 \0",
};

char *board_prompt;

int otto_is_apro(void) {
	return (RFLD(MODEL_NAME_INFO, rtl_id) == 0x9607);
}

phys_size_t initdram(int board_type __attribute__((unused))) {
	return dram_vsize_b();
}

static char *board_prompt_get(void) {
	char *prompt;

	if (otto_is_apro()) {
		switch (OTTO_CID) {
		case ST_RTL9603CT:
		case ST_RTL9603C:
		case ST_RTL9603CP:
		case ST_RTL9603CW:
		case ST_RTL9603CE:
			prompt = board_string[_9603c_string];
			break;
		case ST_RTL9607C:
		case ST_RTL9607CP:
		case ST_RTL9607E:
		case ST_RTL9607EP:
			prompt = board_string[_9607c_string];
			break;
		default:
			prompt = board_string[_default_string];
			break;
		}
	} else if ((RFLD(MODEL_NAME_INFO, rtl_id) == 0x9603)) {
		if ((OTTO_CID & 0xffff) == ST_RTL9602CVD5CG) {
			prompt = board_string[_9602cvd_string];
		} else {
			prompt = board_string[_9603cvd_string];
		}
	} else {
		prompt = board_string[_default_string];
	}
	return prompt;
}

static char *board_prompt_add_pound(char *str) {
	int i = 0;

	while (str[++i]) {
		;
	}
	str[i] = '#';

	return str;
}

int checkboard (void) {
	char ds_note[8] = {0};

	board_prompt = board_prompt_get();

	printf("Board: RTL%s %s:%dMHz LX:%dMHz DDR%d:%dMHz%s\n",
				 board_prompt,
	       otto_cpu_name(),
	       board_CPU_freq_mhz(),
	       board_LX_freq_mhz(),
	       dram_type(),
	       board_DRAM_freq_mhz(),
	       dram_size_notation(ds_note));
	otto_cache_dump_info();

	board_prompt_add_pound(board_prompt);

	return 0;
}

#ifdef CONFIG_SPI_NOR_FLASH
#include <nor_spi/nor_spif_register.h>
/* fix me: lazy method to get spi_clk_div from snaf cntlr. */
#define RFLD_SNAFCFR(x) ((REG32(0xb801a400) >> 4) & 0x7)
static void sw_set_spif_div(void) {
	RMOD_SFCR(spi_clk_div, RFLD_SNAFCFR(spi_clk_div));
	return;
}
PATCH_REG(sw_set_spif_div, 2);
#endif
