#include <common.h>
#include <command.h>
#include "ipc_g2.h"

int cmp_cpuid(void);

static int ipc_lockn_test(int n) {
	volatile L0OR_T *lnor = (L0OR_T *)(0xb8141080 + (n * 0x40));
	volatile L0RR_T *lnrr = (L0RR_T *)(lnor+1);
	int i, j, clearm, val;

	printf("II: IPC Lock %d (LnOR: %p, LnRR: %p)\n", n, lnor, lnrr);

	if (lnor->v) {
		printf("EE: LnOR reset default != 0\n");
	}

	clearm = 0;
	while (clearm < 2) {
		i = 0;
		while (i < 7) {
			printf("II: testing LnR%d with clearing with %d...\n", i, clearm);
			if (lnor->v) {
				printf("EE: LnOR is not init to 0\n");
			}
			val = lnrr[i].v;
			if (val) {
				printf("EE: LnRR[%d](%08x@%p) != 0\n", i, val, &lnrr[i]);
			}
			if (lnor->v != (1 << i)) {
				printf("EE: LnOR own bit error\n");
			}
			j = 0;
			while (j < 7) {
				if (lnrr[j].v != 1) {
					printf("EE: LnRR[%d] != 1\n", j);
				}
				j++;
			}

			/* test clearance method */
			lnrr[i].v = clearm;
			if (lnor->v) {
				printf("EE: LnOR is not clear to 0\n");
			}
			i++;
		}
		clearm++;
	}

	return 0;
}

static int cpi_to_5281(void) {
	puts("II: CPI check...\n");
	/* Reset default check. */
	if (CPITrv) {
		puts("EE: CPIT != 0\n");
	}
	if (CPICrv) {
		puts("EE: CPIC != 0\n");
	}
	if (CPISrv) {
		puts("EE: CPIS != 0\n");
	}

	/* CPI to 5281 @ 0xb8003108[1] of 0822 ASIC */
	if (REG32(0xb8003108) & 0x00000002) {
		puts("EE: CPI is already triggered on 5281 side\n");
	}

	/* Trigger Int. to 5281 */
	RMOD_CPIT(p0_trigger, 1);
	if (!RFLD_CPIS(p0_status)) {
		puts("EE: CPI is not triggered on CPI\n");
	}
	if ((REG32(0xb8003108) & 0x00000002) != 0x00000002) {
		puts("EE: CPI is not triggered on 5281\n");
	}

	/* Clear Int. to 5281 */
	RMOD_CPIC(p0_clear, 1);
	if (RFLD_CPIS(p0_status)) {
		puts("EE: CPI is not cleared on CPI\n");
	}
	if (REG32(0xb8003108) & 0x00000002) {
		puts("EE: CPI is not cleared on 5281\n");
	}
	return 0;
}

int mp_ipc_test(int ipc_num, int delay_us) {
	volatile L0OR_T *lnor = (L0OR_T *)(0xb8141080 + (ipc_num * 0x40));
	volatile L0RR_T *lnrr = (L0RR_T *)(lnor+1);
	int cpuid = cmp_cpuid();

	while (1) {
		while (lnrr[cpuid].v) {
			;
		}

		serial_putc(cpuid + '0');

		lnrr[cpuid].v = 1;

		udelay(delay_us);
	}

	return 0;
}


int do_ipc_test(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]) {
	/* IA side test. */
	ipc_lockn_test(0);
	ipc_lockn_test(1);

	/* IA issues int. to 5281 */
	cpi_to_5281();

	return 0;
}
U_BOOT_CMD(ipc_test, 1, 0, do_ipc_test,
           "ipc_test - do IPC test",
           "");
