#include <common.h>
#include <mpcntl.h>

extern void mp_init_mipsia(void);
extern int _slave_init_start_uncached_set_by_master;
extern void ucbasic_init(void);
extern void slave_boot_from_bir(void);

void mp_init_slave_fpga(void);
void mp_init_dummy(void);
void mp_kill_mipsia(void);

mp_cpu_attr_t mp_attr[CONFIG_MP_CPU_NUM] = {
	{mp_init_dummy, NULL, NULL, NULL, 0}, /* CPU0 already runs. */
	{mp_init_mipsia, NULL, NULL, mp_kill_mipsia, 0}, /* CPU1 */
	{mp_init_mipsia, NULL, NULL, mp_kill_mipsia, 0},
	{mp_init_mipsia, NULL, NULL, mp_kill_mipsia, 0},
	{mp_init_slave_fpga, NULL, NULL, NULL, 0}, /* CPU4, 5281 */
};

int mp_cpuid(void) {
	int prid;
	prid = GET_CP0(C0_PRID);
	if ((prid & 0xffff) == 0xdc02) {
		return 4;
	} else {
		return GET_CP0(C0_EBASE) & 0x3ff;
	}
}

void mp_init_slave_fpga(void) {
	int r_temp;

	_slave_init_start_uncached_set_by_master = UCADDR(((int)ucbasic_init));

	memcpy((void *)0xb8004100, slave_boot_from_bir, 64);
	r_temp = REG32(0xb8000308);
	r_temp |= 1 << 5;
	REG32(0xb8000308) = r_temp;

	r_temp = REG32(0xb8000108);
	r_temp &= (~(1 << 2));
	REG32(0xb8000108) = r_temp;

	return;
}
