;; #include <asm/mipsregs.h>
#define OTTO_CPU_PRID 0xdc02
#include <asm/rtkasm.h>

#define CP0_STATUS_IE 1

	.section .text, "ax", @progbits
	.align  4
	.set    noreorder
	.global ucbasic_init
	.ent    ucbasic_init
ucbasic_init:
	mtc0 zero, CP0_WATCHLO
	mtc0 zero, CP0_WATCHHI
	mtc0 zero, CP0_CAUSE
	mtc0 zero, CP0_COUNT
	mtc0 zero, CP0_COMPARE
	mfc0 k0, CP0_STATUS
	li   k1, ~CP0_STATUS_IE
	and  k0, k1
	mtc0 k0, CP0_STATUS
	nop

	//I-Cache Inv
	mfc0 t0, CP0_CCTL
	li   t1, (1<<1)
	not  t1, t1
	and  t0, t0, t1
	mtc0 t0, CP0_CCTL
	li   t1, (1<<1)
	or   t0, t0, t1
	mtc0 t1, CP0_CCTL

	//D-Cache Inv
	mfc0 t0, CP0_CCTL
	li   t1, 0x1
	not  t1, t1
	and  t0, t0, t1
	mtc0 t0, CP0_CCTL
	li   t1, 0x1
	or   t0, t0, t1
	mtc0 t1, CP0_CCTL

	//L2 Cache off
	mfc0 t0, CP0_CCTL, 1
	li   t1, (1<<25)
	not  t1, t1
	and  t0, t0, t1
	mtc0 t0, CP0_CCTL, 1
	li   t1, (1<<25)
	or   t0, t0, t1
	mtc0 t1, CP0_CCTL, 1

	//Clear write buffer
	li   t0, 0xa0000000
	lw   t1, 0(t0)

	lui  t2, %hi(c_start)
	addi t2, %lo(c_start)
	jr   t2
	nop
	.end ucbasic_init

	.section .text, "ax", @progbits
	.align  4
	.set    noreorder
	.ent    c_start
c_start:
	jal  mp_cpuid
	nop
	jal  mp_get_sp
	move a0, v0
	move sp, v0
	la   ra, mpcntl_func_dispatcher
	jr   ra
	nop
	.end c_start

	.section .text, "ax", @progbits
	.align  4
	.set    noreorder
	.global slave_boot_from_bir
	.ent    slave_boot_from_bir
slave_boot_from_bir:
	lui  t0, 0xbfc0
	addi t0, t0, (_slave_init_start_uncached_set_by_master - slave_boot_from_bir)
	lw   t0, 0(t0)
	nop
	jr   t0
	nop

	.global _slave_init_start_uncached_set_by_master
_slave_init_start_uncached_set_by_master:
	.int 0xffffffff
	.end slave_boot_from_bir
