#include <common.h>
#include <net.h>

extern gd_t *gd;

void set_disable(void)
{
	//Disable SDS mode
	*(volatile unsigned int*)(0xbb000214)=0x1f;

	//Disable MAC force for port 0
	*(volatile unsigned int*)(0xbb0001b4)=0x0;

}

void set_sgmii(void)
{
	//eth init
	eth_initialize(gd->bd);
	
	*(volatile unsigned int*)(0xbb000214)=0x1f;
	*(volatile unsigned int*)(0xbb021680)=0x0;
	*(volatile unsigned int*)(0xbb02168C)=0x3001;
	*(volatile unsigned int*)(0xbb021698)=0x68;
	*(volatile unsigned int*)(0xbb0215B8)=0x98C5;
	*(volatile unsigned int*)(0xbb0215b4)=0x1264;
	*(volatile unsigned int*)(0xbb0215bc)=0x400f;
	*(volatile unsigned int*)(0xbb0215E4)=0xFC00;
	*(volatile unsigned int*)(0xbb000214)=0x2;
	*(volatile unsigned int*)(0xbb000180)=0x16;
	*(volatile unsigned int*)(0xbb0001b4)=0xfff;
	*(volatile unsigned int*)(0xbb021500)=0x10;
	*(volatile unsigned int*)(0xbb021500)=0x30;
	*(volatile unsigned int*)(0xbb021500)=0x0;
	*(volatile unsigned int*)(0xbb02d8b8)=0x4ffff;

}

void set_hisgmii(void)
{
	//eth init
	eth_initialize(gd->bd);
	
	*(volatile unsigned int*)(0xbb000214)=0x1f;
	*(volatile unsigned int*)(0xbb021700)=0x1800;
	*(volatile unsigned int*)(0xbb02170C)=0x7b01;
	*(volatile unsigned int*)(0xbb021718)=0x168;
	*(volatile unsigned int*)(0xbb0215B8)=0x98C5;
	*(volatile unsigned int*)(0xbb0215b4)=0x1564;
	*(volatile unsigned int*)(0xbb0215bc)=0x400f;
	*(volatile unsigned int*)(0xbb0215E4)=0xFC00;
	*(volatile unsigned int*)(0xbb000214)=0x12;
	*(volatile unsigned int*)(0xbb000180)=0x16;
	*(volatile unsigned int*)(0xbb0001b4)=0xfff;
	*(volatile unsigned int*)(0xbb021500)=0x10;
	*(volatile unsigned int*)(0xbb021500)=0x30;
	*(volatile unsigned int*)(0xbb021500)=0x0;
	*(volatile unsigned int*)(0xbb02d8b8)=0xa8000;
}

int do_sds (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	uint32_t mode;
	
	if (argc != 2) return cmd_usage(cmdtp);
	
	mode = simple_strtoul(argv[1], NULL, 10);
	switch(mode){
		case 0: //disable
			set_disable();
		break;	
		case 1: //SGMII
			set_sgmii();
		break;
		case 2: //HISGMII
			set_hisgmii();
		break;
		
		default:
			cmd_usage(cmdtp);
	}	
	return 0;
}

U_BOOT_CMD(
	sdsmode,  2,      1,      do_sds,
	"Set serdes mode",
	"[mode]\n"
	"0: Disable, 1: SGMII, 2: HISGMII"
);


