#include <common.h>
//#include <soc.h>


#define PATCH_REG(x, lvl) \
	void_func * __swp_##x __attribute__ ((section (".soft_patch." #lvl))) = x


unsigned int SWP_GPIO_DATA = 0xB800330C;
unsigned int SWP_GPIO_DIR = 0xB8003308;
#define SWP_GPIO_INPUT         0x0000  /*data input*/
#define SWP_GPIO_OUTPUT        0x0001  /*data output*/
#define SWP_SOC_GPIO_REG_OFFSET_BASE (0x1C)
#define SWP_SWCORE_GPIO_EN (0xbb000038)

void swp_gpioMode (int gpio_num, int gpio_func)
{
        unsigned int mask;
        unsigned int reg_num = ((gpio_num>>5)<<2); 

        if (gpio_num <= 63) { /* Only 64 GPIO in SOC GPIO */
                //enable
                mask = 1 << (gpio_num%32);
                REG32((SWP_SWCORE_GPIO_EN + reg_num)) |= mask; //enable gpio, gpio 0~31 reg SWCORE_GPIO_EN, gpio >31 reg SWCORE_GPIO_EN+4

                reg_num >>= 2; 
                reg_num *= SWP_SOC_GPIO_REG_OFFSET_BASE; //if gpio > 32, register+0x1c
                //select mode
                if (SWP_GPIO_INPUT == gpio_func)
                        REG32((SWP_GPIO_DIR + reg_num)) &= ~mask;
                else
                        REG32((SWP_GPIO_DIR + reg_num)) |= mask;
        }
        else if (gpio_num <= 71) {
                printf("ERROR: GPIO %d (between 64~71) is not supported!!!\n", gpio_num);
        }       
}

/*set GPIO pins on/off*/
void swp_gpioData(int gpio_num, int onoff)
{
unsigned int pins;
        unsigned int reg_num = ((gpio_num>>5)<<2);

        if (gpio_num <= 63) {
                reg_num >>= 2;
                reg_num *= SWP_SOC_GPIO_REG_OFFSET_BASE;
                pins = 1 << (gpio_num%32);
                //write out
                if(onoff==0)
                        REG32((SWP_GPIO_DATA + reg_num)) |= pins;
                else
                        REG32((SWP_GPIO_DATA + reg_num)) &= ~pins;

        }
        else if (gpio_num <= 71) {
                printf("ERROR: GPIO %d (between 64~71) is not supported!!!\n", gpio_num);
        }
}
	

void led_power_on(void) {

		printf("POWER LED ON\n");
		swp_gpioMode(39, SWP_GPIO_OUTPUT);
		swp_gpioData(39,1);
       
}

void led_power_off(void) {

		printf("POWER LED OFF\n");
		swp_gpioMode(39, SWP_GPIO_OUTPUT);
		swp_gpioData(39,0);
       
}

#if 0
//#ifdef CONFIG_MULTICAST_UPGRADE	
void led_blink(void)
{

	//swp_gpioMode(2, SWP_GPIO_OUTPUT);
	//swp_gpioMode(3, SWP_GPIO_OUTPUT); 
	//gpioMode(5, GPIO_OUTPUT);
	//swp_gpioMode(6, SWP_GPIO_OUTPUT);

	while(1)
	{
		//swp_gpioData(2,1);
		//swp_gpioData(3,1);
		//swp_gpioData(6,1);
		//udelay (1000000);
		//swp_gpioData(2,0);
		//swp_gpioData(3,0);
		//swp_gpioData(6,0);
		//udelay (1000000);
	};
}
#endif

PATCH_REG(led_power_on, 0);
