#include <common.h>
//#include <soc.h>
#include <misc_setting.h>
#include <asm/mipsregs.h>

#define OTTO_CID (((*(soc_t *)(0x9F000020)).cid) & 0xFFFF)

unsigned int SWP_GPIO_DATA =	0xB800330C;
unsigned int SWP_GPIO_DIR =	0xB8003308;

#define SWP_GPIO_INPUT			0x0000		/*data input*/
#define SWP_GPIO_OUTPUT			0x0001		/*data output*/
#define SWP_SOC_GPIO_REG_OFFSET_BASE	(0x1C)
#define SWP_SWCORE_GPIO_EN		(0xbb000038)

#define POWER_LED_GPIO_HIGH_ACTIVE	1
#define POWER_LED_BLINK			0

void swp_gpioMode (int gpio_num, int gpio_dir)
{
	unsigned int mask;
	unsigned int reg_num = ((gpio_num >> 5) << 2);

	if (gpio_num <= 63) { /* Only 64 GPIO in SOC GPIO */
		/* enable gpio, gpio 0~31 reg SWCORE_GPIO_EN, gpio >31 reg SWCORE_GPIO_EN+4 */
		mask = 1 << (gpio_num % 32);
		REG32((SWP_SWCORE_GPIO_EN + reg_num)) |= mask;

		reg_num >>= 2; 
		reg_num *= SWP_SOC_GPIO_REG_OFFSET_BASE;	/* if gpio > 32, register+0x1c */

		/* Select mode */
		if (SWP_GPIO_INPUT == gpio_dir)
			REG32((SWP_GPIO_DIR + reg_num)) &= ~mask;
		else
			REG32((SWP_GPIO_DIR + reg_num)) |= mask;
		}
	else if (gpio_num <= 71) {
		printf("ERROR: GPIO %d (between 64~71) is not supported!!!\n", gpio_num);
	}
}

void swp_gpioData(int gpio_num, int gpio_data)
{
	unsigned int pins;
	unsigned int reg_num = ((gpio_num>>5)<<2);

	if (gpio_num <= 63) {
		reg_num >>= 2;
		reg_num *= SWP_SOC_GPIO_REG_OFFSET_BASE;
		pins = 1 << (gpio_num % 32);

		/* write out (LED Low Active) */
		if(gpio_data == 0)
			REG32((SWP_GPIO_DATA + reg_num)) &= ~pins;
		else
			REG32((SWP_GPIO_DATA + reg_num)) |= pins;
	}
	else if (gpio_num <= 71) {
		printf("ERROR: GPIO %d (between 64~71) is not supported!!!\n", gpio_num);
	}
}

static int gpio_led_power = 0;
static int gpio_led_power_2 = 0;
static int gpio_led_los = 0;
static int gpio_led_pon = 0;

#ifdef CONFIG_MULTICAST_UPGRADE
void led_multicastUP_rx_data(void) {
	static int cnt = 0;
	static int check_gpio_set = 0;
	static int op = 0;

	if(cnt++ >= 10) {
		if(check_gpio_set == 0) {
			swp_gpioMode(gpio_led_pon, SWP_GPIO_OUTPUT);
			check_gpio_set = 1;
		}
		if(op == 0)
			swp_gpioData(gpio_led_pon, 1);
		else	
			swp_gpioData(gpio_led_pon, 0);
		op = !op;
		cnt = 0;
	}
}

void led_multicastUP_rx_drop(void) {
	static int cnt = 0;
	static int check_gpio_set = 0;
	static int op = 0;

	if(cnt++ >= 50) {
		if(check_gpio_set == 0) {
			swp_gpioMode(gpio_led_pon, SWP_GPIO_OUTPUT);
			check_gpio_set = 1;
		}
		if(op == 0)
			swp_gpioData(gpio_led_pon, 1);
		else	
			swp_gpioData(gpio_led_pon, 0);
		op = !op;
		cnt = 0;
	}
}

void led_multicastUP_updating(void) {
	swp_gpioData(gpio_led_pon, 0);
}

void led_multicastUP_error_hang(void) {
	swp_gpioData(gpio_led_pon, 1);
	swp_gpioMode(gpio_led_los, SWP_GPIO_OUTPUT);

	while(1) {
		swp_gpioData(gpio_led_los, 0);
		udelay (1000000);
		swp_gpioData(gpio_led_los, 1);
		udelay (1000000);
	};
}

void led_multicastUP_done(void) {
	swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
	swp_gpioMode(gpio_led_los, SWP_GPIO_OUTPUT);
	swp_gpioMode(gpio_led_pon, SWP_GPIO_OUTPUT);

	while(1) {
		(POWER_LED_GPIO_HIGH_ACTIVE) ? swp_gpioData(gpio_led_power, 1) : swp_gpioData(gpio_led_power, 0);
		swp_gpioData(gpio_led_power_2, 0);
		swp_gpioData(gpio_led_los, 0);
		swp_gpioData(gpio_led_pon, 0);
		udelay (1000000);
		(POWER_LED_GPIO_HIGH_ACTIVE) ? swp_gpioData(gpio_led_power,0) : swp_gpioData(gpio_led_power,1);
		swp_gpioData(gpio_led_power_2, 1);
		swp_gpioData(gpio_led_los, 1);
		swp_gpioData(gpio_led_pon, 1);
		udelay (1000000);
	};
}

#endif

void led_power_blink(void) {

	unsigned int status;

	/* Setup Trap */
	trap_init(0);
	
	/* Enable IP7 */
	status = read_c0_status() & ~0xff00;
	status |= 0x8001;
	write_c0_status(status);
}

void led_power_on(void) {

	switch(OTTO_CID) {
	case ST_RTL9603C:
	case ST_RTL9607C:
		(POWER_LED_GPIO_HIGH_ACTIVE) ? swp_gpioData(gpio_led_power, 1) : swp_gpioData(gpio_led_power, 0);
		swp_gpioData(gpio_led_power_2, 0);
		break;
	case ST_RTL9603CP:
		break;
	case ST_RTL9607CP:
		swp_gpioData(gpio_led_power, 0);
		break;
	case ST_RTL9607E:
		break;
	case ST_RTL9607EP:
		break;
	case ST_RTL8198D:
		swp_gpioData(gpio_led_power, 0);
	default:
		break;            
	}
}

void led_power_off(void) {
	
	switch(OTTO_CID) {
	case ST_RTL9603C:
	case ST_RTL9607C:
		(POWER_LED_GPIO_HIGH_ACTIVE) ? swp_gpioData(gpio_led_power, 0) : swp_gpioData(gpio_led_power, 1);
		swp_gpioData(gpio_led_power_2, 1);
		break;
	case ST_RTL9603CP:
		break;
	case ST_RTL9607CP:
		swp_gpioData(gpio_led_power, 1);
		break;
	case ST_RTL9607E:
		break;
	case ST_RTL9607EP:
		break;
	case ST_RTL8198D:
		swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
		swp_gpioData(gpio_led_power, 0);
	default: 
		break;            
	}
}

void led_power_init(void) {

	switch(OTTO_CID) {
	case ST_RTL9603C:
	case ST_RTL9607C:
		gpio_led_power = 60;
		gpio_led_power_2 = 15;
		gpio_led_los = 21;
		gpio_led_pon = 10;
		swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
		swp_gpioMode(gpio_led_power_2, SWP_GPIO_OUTPUT);
		break;
	case ST_RTL9603CP:
		break;
	case ST_RTL9607CP:
		gpio_led_power = 39;
		gpio_led_los = 21;
		gpio_led_pon = 10;
		swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
		break;
	case ST_RTL9607E:
		break;
	case ST_RTL9607EP:
		break;
	case ST_RTL8198D:
		gpio_led_power = 6;
		swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
	default:
		break;            
	}

	if (POWER_LED_BLINK)
		led_power_blink();
	else
		led_power_on();
}

PATCH_REG(led_power_init, 0);

