#include <common.h>
#include <spi_flash.h>

#define CONFIG_SF_DEFAULT_BUS		0
#define CONFIG_SF_DEFAULT_CS		0
#define CONFIG_SF_DEFAULT_SPEED		1000000
#define CONFIG_SF_DEFAULT_MODE		SPI_MODE_3

#define ENV_BOOTLOADER_SZ_NAME		"fl_boot_sz"
#define ENV_BOOTLOADER_CRC_NAME		"bootloader_crc"

#define LOADER_FLASH_ADDR_BASE		(0x0)
#define LOADER_MEM_ADDR_BASE		(CONFIG_SYS_SDRAM_BASE)

void swp_bootloader_crc32(void){
	const int bufsz = 32;
	char c[bufsz];
	ulong ret, crc = 0, boot_sz = 0;
	struct spi_flash *flash;

	boot_sz = getenv_ulong(ENV_BOOTLOADER_SZ_NAME, 16, boot_sz);
	if (boot_sz == 0) {
		printf("Loader size is 0\n");
		return;
	}

	flash = spi_flash_probe(CONFIG_SF_DEFAULT_BUS, CONFIG_SF_DEFAULT_CS, CONFIG_SF_DEFAULT_SPEED, CONFIG_SF_DEFAULT_MODE);
	if (!flash) {
		printf("Failed to initialize SPI flash at %u:%u\n", CONFIG_SF_DEFAULT_BUS, CONFIG_SF_DEFAULT_CS);
		return;
	}

	ret = spi_flash_read(flash, LOADER_FLASH_ADDR_BASE, boot_sz, (u_char *)LOADER_MEM_ADDR_BASE);
	if (ret) {
		printf("SPI flash read failed\n");
		return;
	}

	/* Do bootloader CRC32 */
	crc = crc32_wd (0, (const uchar *)LOADER_MEM_ADDR_BASE, boot_sz, CHUNKSZ_CRC32);
	//printf ("CRC32 for %08lx ... %08lx ==> %08lx\n",(ulong)LOADER_MEM_ADDR_BASE , (ulong)(LOADER_MEM_ADDR_BASE + boot_sz - 1), crc);

	char *s = getenv(ENV_BOOTLOADER_CRC_NAME);
	sprintf(c, "%08lx", crc);

	if(s == NULL){
		printf(ENV_BOOTLOADER_CRC_NAME " is empty, set %s\n", c);
		setenv(ENV_BOOTLOADER_CRC_NAME, c);
		saveenv();
	} else {
		if(strcmp(s,c)!=0){
			printf("old " ENV_BOOTLOADER_CRC_NAME " [%s] is different to new [%s], set new crc\n", s, c);
			setenv(ENV_BOOTLOADER_CRC_NAME, c);
			saveenv();
		} //else
			//old and new crc are the same, don't save env!
	}
}

PATCH_REG(swp_bootloader_crc32, 16);
