#include <common.h>


typedef union {
	struct {
		unsigned int wdt_e:1; //0
		unsigned int wdt_clk_sc:2; //0
		unsigned int mbz_0:2; //0
		unsigned int ph1_to:5; //0
		unsigned int mbz_1:2; //0
		unsigned int ph2_to:5; //0
		unsigned int mbz_2:13; //0
		unsigned int wdt_reset_mode:2; //0
	} f;
	unsigned int v;
} WDT_CTRL_T;
#define WDT_CTRLrv (*((volatile unsigned int *)0xb8003268))

void otto_bootm_error_handler(void)
{
    WDT_CTRL_T wdt_ctrl;
    wdt_ctrl.v = 0;

    /* Set Timeout threshold
          * wdt_clk_sc=3:  2^28
          * ph1_to=0:     1.34 sec
          * ph1_to=5:     8.04 sec
          * ph1_to=17: 24.12 sec
          * ph1_to=18: 25.46 sec
          */
    wdt_ctrl.f.wdt_e = 1;
    wdt_ctrl.f.wdt_clk_sc = 3;
    wdt_ctrl.f.wdt_reset_mode = 0;
    wdt_ctrl.f.ph1_to = 5;
    wdt_ctrl.f.ph2_to = 5;

    //Enable WDOG
    WDT_CTRLrv = 0;
    WDT_CTRLrv = wdt_ctrl.v;
    printf("WW: Enabling WDOG to 8.04 sec\r");
}


