#include <common.h>
//#include <soc.h>
#include <misc_setting.h>

#define OTTO_CID (((*(soc_t *)(0x9F000020)).cid) & 0xFFFF)

/***************************************************************************
 * GPIO Function 
 ***************************************************************************/
//#define DEBUG_GPIO
#define GPIO_MAX_NUM			(95)

#define SWP_GPIO_INPUT			(0)
#define SWP_GPIO_OUTPUT			(1)

#define SWCORE_GPIO_EN			(0xBB000038)

#define SOC_GPIO_BASE			(0xB8003300)
#define SOC_GPIO_PABCD_DIR_OFFSET	(0x08)
#define SOC_GPIO_PABCD_DAT_OFFSET	(0x0C)
#define SOC_GPIO_PEFGH_DIR_OFFSET	(0x24)
#define SOC_GPIO_PEFGH_DAT_OFFSET	(0x28)
#define SOC_GPIO_PJKMN_DIR_OFFSET	(0x48)
#define SOC_GPIO_PJKMN_DAT_OFFSET	(0x4C)

void swp_gpioMode (int gpio_num, int gpio_dir)
{
	int regGroup, regAddr, regMask;

#ifdef DEBUG_GPIO  
	printf("Set GPIO #%d dir. as %s\n", gpio_num, (gpio_dir?"Output":"Input"));
#endif

	if ((gpio_num <= GPIO_MAX_NUM) && (gpio_num >= 0)) {
		regGroup = gpio_num >> 5;
		regMask = 1 << (gpio_num % 32);

		/* Swicth Core */
		REG32((SWCORE_GPIO_EN + (regGroup << 2))) |= regMask;

		if (regGroup == 0)
			regAddr = SOC_GPIO_BASE + SOC_GPIO_PABCD_DIR_OFFSET;
		else if (regGroup == 1)
			regAddr = SOC_GPIO_BASE + SOC_GPIO_PEFGH_DIR_OFFSET;
		else if (regGroup == 2)
			regAddr = SOC_GPIO_BASE + SOC_GPIO_PJKMN_DIR_OFFSET;

#ifdef DEBUG_GPIO 
		printf("GPIO: Addr: 0x%08x; Bit: 0x%08x\n", regAddr, regMask);
#endif

		/* Select mode */
		if (SWP_GPIO_INPUT == gpio_dir)
			REG32(regAddr) &= ~regMask;
		else
			REG32(regAddr) |= regMask;
	}
	else {
		printf("ERROR: GPIO %d is not supported!!!\n", gpio_num);
	}
}

void swp_gpioData(int gpio_num, int gpio_data)
{
	int regGroup, regAddr, regMask;

#ifdef DEBUG_GPIO  
	printf("Set GPIO #%d data as %d\n", gpio_num, gpio_data);
#endif

	if ((gpio_num <= GPIO_MAX_NUM) && (gpio_num >= 0)) {
		regGroup = gpio_num >> 5;
		regMask = 1 << (gpio_num % 32);

		if (regGroup == 0)
			regAddr = SOC_GPIO_BASE + SOC_GPIO_PABCD_DAT_OFFSET;
		else if (regGroup == 1)
			regAddr = SOC_GPIO_BASE + SOC_GPIO_PEFGH_DAT_OFFSET;
		else if (regGroup == 2)
			regAddr = SOC_GPIO_BASE + SOC_GPIO_PJKMN_DAT_OFFSET;

#ifdef DEBUG_GPIO 
		printf("GPIO: Addr: 0x%08x; Bit: 0x%08x\n", regAddr, regMask);
#endif

		if(gpio_data == 0)
			REG32(regAddr) &= ~regMask;
		else
			REG32(regAddr) |= regMask;
	}
	else {
		printf("ERROR: GPIO %d is not supported!!!\n", gpio_num);
	}
}

/***************************************************************************
 * LED Function 
 ***************************************************************************/
#define POWER_LED_GPIO_HIGH_ACTIVE	0

static int gpio_led_power = 0;
static int gpio_led_los = 0;
static int gpio_led_pon = 0;

#ifdef CONFIG_MULTICAST_UPGRADE
void led_multicastUP_rx_data(void) {
	static int cnt = 0;
	static int check_gpio_set = 0;
	static int op = 0;

	if(cnt++ >= 10) {
		if(check_gpio_set == 0) {
			swp_gpioMode(gpio_led_pon, SWP_GPIO_OUTPUT);
			check_gpio_set = 1;
		}
		if(op == 0)
			swp_gpioData(gpio_led_pon, 1);
		else	
			swp_gpioData(gpio_led_pon, 0);
		op = !op;
		cnt = 0;
	}
}

void led_multicastUP_rx_drop(void) {
	static int cnt = 0;
	static int check_gpio_set = 0;
	static int op = 0;

	if(cnt++ >= 50) {
		if(check_gpio_set == 0) {
			swp_gpioMode(gpio_led_pon, SWP_GPIO_OUTPUT);
			check_gpio_set = 1;
		}
		if(op == 0)
			swp_gpioData(gpio_led_pon, 1);
		else	
			swp_gpioData(gpio_led_pon, 0);
		op = !op;
		cnt = 0;
	}
}

void led_multicastUP_updating(void) {
	swp_gpioData(gpio_led_pon, 0);
}

void led_multicastUP_error_hang(void) {
	swp_gpioData(gpio_led_pon, 1);
	swp_gpioMode(gpio_led_los, SWP_GPIO_OUTPUT);

	while(1) {
		swp_gpioData(gpio_led_los, 0);
		udelay (1000000);
		swp_gpioData(gpio_led_los, 1);
		udelay (1000000);
	};
}

void led_multicastUP_done(void) {
	swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
	swp_gpioMode(gpio_led_los, SWP_GPIO_OUTPUT);
	swp_gpioMode(gpio_led_pon, SWP_GPIO_OUTPUT);

	while(1) {
		(POWER_LED_GPIO_HIGH_ACTIVE) ? swp_gpioData(gpio_led_power, 1) : swp_gpioData(gpio_led_power, 0);
		swp_gpioData(gpio_led_los, 0);
		swp_gpioData(gpio_led_pon, 0);
		udelay (1000000);
		(POWER_LED_GPIO_HIGH_ACTIVE) ? swp_gpioData(gpio_led_power,0) : swp_gpioData(gpio_led_power,1);
		swp_gpioData(gpio_led_los, 1);
		swp_gpioData(gpio_led_pon, 1);
		udelay (1000000);
	};
}

#endif

void led_pwr_func(void)
{
	int val;
	/*
	0xbb01e000[0] = 0x0
	0xbb01e0a0[17] = 0x1
	0xbb01e094[14:12] = 0x3
	0xbb01e090[1:0] = 0x2
	0xbb01e044[20:0] = 0x1b1000
	0xbb023014[21] = 0x1
	0xbb023014[16] = 0x1

0xbb01e000[0] = 0x0
0xbb01e068[9] = 0x1
0xbb01e05c[5:3] = 0x3
0xbb01e054[17:16] = 0x2
0xbb01e024[20:0] = 0x1b4000
0xbb023010[8] = 0x1


	*/

	val = REG32(0xbb01e000);
	val &= ~(1 << 0);
	val = REG32(0xbb01e000);
	
	val = REG32(0xbb01e068);
	val |= (1 << 9);
	REG32(0xbb01e068) = val;

	val = REG32(0xbb01e05c);
	val |= (1 << 3);
	val |= (1 << 4);
	val &= ~(1 << 5);
	REG32(0xbb01e05c) = val;

	val = REG32(0xbb01e054);
	val &= ~(1 << 16);
	val |= (1 << 17);
	REG32(0xbb01e054) = val;

	val = REG32(0xbb01e024);
	val = val >> 20;
	val = val << 20;
	val |= 0x1b4000;
	REG32(0xbb01e024) = val;

	val = REG32(0xbb023010);
	val |= (1 << 8);
	REG32(0xbb023010) = val;
}

void led_pwr_func2(void)
{

        int val;
        /*
0xbb01e000[0] = 0x0
0xbb01e068[1] = 0x1
0xbb01e05c[5:3] = 0x3
0xbb01e054[1:0] = 0x2
0xbb01e004[20:0] = 0x1b4000
0xbb023010[0] = 0x1
        */

        val = REG32(0xbb01e000);
        val &= ~(1 << 0);
        val = REG32(0xbb01e000);

        val = REG32(0xbb01e068);
        val |= (1 << 1);
        REG32(0xbb01e068) = val;

        val = REG32(0xbb01e05c);
        val |= (1 << 3);
        val |= (1 << 4);
        val &= ~(1 << 5);
        REG32(0xbb01e05c) = val;
	
        val = REG32(0xbb01e054);
        val &= ~(1 << 0);
        val |= (1 << 1);
        REG32(0xbb01e054) = val;

        val = REG32(0xbb01e004);
        val = val >> 20;
        val = val << 20;
        val |= 0x1b4000;
        REG32(0xbb01e004) = val;

        val = REG32(0xbb023010);
        val |= (1 << 0);
        REG32(0xbb023010) = val;
}

void led_power_on(void) {
	
	switch(OTTO_CID){
	case ST_RTL9603C:
		gpio_led_power = 15;
		gpio_led_los = 21;
		gpio_led_pon = 10;
		led_pwr_func();
		break;
	case ST_RTL9603CP:
		break;
	case ST_RTL9607C:
		gpio_led_power = 6;
		gpio_led_los = 21;
		gpio_led_pon = 10;
		led_pwr_func2();
		break;
        case ST_RTL9607CP:
		gpio_led_power = 19;
		gpio_led_los = 21;
		gpio_led_pon = 10;
		swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
		swp_gpioData(gpio_led_power, 0);
		break;
	case ST_RTL9607E:
		break;
	case ST_RTL9607EP:
		break;
	default:
		break;            
	}
}

void led_power_off(void) {
	
	switch(OTTO_CID) {
	case ST_RTL9603C:
	case ST_RTL9607C:
		swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
		(POWER_LED_GPIO_HIGH_ACTIVE) ? swp_gpioData(gpio_led_power, 0) : swp_gpioData(gpio_led_power, 1);
		break;
	case ST_RTL9603CP:
		break;
	case ST_RTL9607CP:
		swp_gpioMode(gpio_led_power, SWP_GPIO_OUTPUT);
		swp_gpioData(gpio_led_power, 1);
		break;
	case ST_RTL9607E:
		break;
	case ST_RTL9607EP:
		break;
	default: 
		break;            
	}
}	

PATCH_REG(led_power_on, 0);

