#include <common.h>
#include <soc.h>


#define PATCH_REG(x, lvl) \
	void_func * __swp_##x __attribute__ ((section (".soft_patch." #lvl))) = x


/* SPI flash setting */
#ifdef CONFIG_CMD_SF
	/****** SPI NOR flash ******/
	#define SWP_CONFIG_SPINOR_FLASH 1
	#define SWP_CONFIG_SYS_NO_FLASH
	#define SWP_CONFIG_SYS_FLASH_BASE (0xb4000000)
	#define SWP_CONFIG_ENV_IS_IN_SPI_FLASH
	#define SWP_CONFIG_ENV_OFFSET     (256 * 1024)
	#define SWP_CONFIG_ENV_SIZE       (8 * 1024)
	#define SWP_CONFIG_ENV_SECT_SIZE  (0x1000) /* size of one complete sector */
	#define SWP_CONFIG_ENV_OFFSET_REDUND (264 * 1024)
	#define SWP_CONFIG_SYS_REDUNDAND_ENVIRONMENT	1
#elif defined (CONFIG_CMD_SPI_NAND)
	/****** SPI NAND flash ******/
	#define SWP_CONFIG_ENV_OFFSET     (0xC0000) //(6 * 64 * 2048)
	#define SWP_CONFIG_SYS_NO_FLASH
	#define SWP_CONFIG_ENV_IS_IN_SPI_NAND
	#define SWP_CONFIG_ENV_SIZE       (0x4000) //(16 * 1024)
	#define SWP_CONFIG_ENV_SECT_SIZE  (0x1000)  /* size of one complete sector */
	#define SWP_CONFIG_ENV_OFFSET_REDUND (0xE0000)
	#define SWP_CONFIG_SYS_REDUNDAND_ENVIRONMENT	1
#elif defined (CONFIG_CMD_ONFI)
        /****** ONFI flash ******/
        #define SWP_CONFIG_ENV_OFFSET     (0xC0000) //(6 * 64 * 2048)
        #define SWP_CONFIG_SYS_NO_FLASH
        #define SWP_CONFIG_ENV_IS_IN_ONFI
        #define SWP_CONFIG_ENV_SIZE       (0x4000) //(16 * 1024)
        #define SWP_CONFIG_ENV_SECT_SIZE  (0x1000)  /* size of one complete sector */
        #define SWP_CONFIG_ENV_OFFSET_REDUND (0xE0000)
        #define SWP_CONFIG_SYS_REDUNDAND_ENVIRONMENT        1
#endif

#ifdef CONFIG_OTTO_FLASH_LAYOUT
#ifdef CONFIG_CMD_SF
    /****** SPI NOR flash ******/
    #define SWP_FL_8MB  (8*1024*1024)
    #define SWP_FL_8MB_CFGFS_BASE (272 *1024)
    #define SWP_FL_8MB_K0_BASE    (512 *1024)
    #define SWP_FL_8MB_K_SIZE     (1408*1024)
    #define SWP_FL_8MB_R0_BASE    (SWP_FL_8MB_K0_BASE+SWP_FL_8MB_K_SIZE)
    #define SWP_FL_8MB_R_SIZE     (((SWP_FL_8MB-SWP_FL_8MB_K0_BASE)>>1)-SWP_FL_8MB_K_SIZE)
    #define SWP_FL_8MB_K1_BASE    (SWP_FL_8MB_R0_BASE+SWP_FL_8MB_R_SIZE)
    #define SWP_FL_8MB_R1_BASE    (SWP_FL_8MB_K1_BASE+SWP_FL_8MB_K_SIZE)

    #define SWP_FL_16MB (16*1024*1024)
    #define SWP_FL_16MB_CFGFS_BASE SWP_FL_8MB_CFGFS_BASE
    #define SWP_FL_16MB_K0_BASE    SWP_FL_8MB_K0_BASE
    #define SWP_FL_16MB_K_SIZE     (3*1024*1024)
    #define SWP_FL_16MB_R0_BASE    (SWP_FL_16MB_K0_BASE+SWP_FL_16MB_K_SIZE)
    #define SWP_FL_16MB_R_SIZE     (((SWP_FL_16MB-SWP_FL_16MB_K0_BASE)>>1)-SWP_FL_16MB_K_SIZE)
    #define SWP_FL_16MB_K1_BASE    (SWP_FL_16MB_R0_BASE+SWP_FL_16MB_R_SIZE)
    #define SWP_FL_16MB_R1_BASE    (SWP_FL_16MB_K1_BASE+SWP_FL_16MB_K_SIZE)
    
    #define SWP_FL_32MB (32*1024*1024)
    #define SWP_FL_32MB_CFGFS_BASE SWP_FL_8MB_CFGFS_BASE
    #define SWP_FL_32MB_K0_BASE    SWP_FL_8MB_K0_BASE
    #define SWP_FL_32MB_K_SIZE     (6*1024*1024)
    #define SWP_FL_32MB_R0_BASE    (SWP_FL_32MB_K0_BASE+SWP_FL_32MB_K_SIZE)
    #define SWP_FL_32MB_R_SIZE     (((SWP_FL_32MB-SWP_FL_32MB_K0_BASE)>>1)-SWP_FL_32MB_K_SIZE)
    #define SWP_FL_32MB_K1_BASE    (SWP_FL_32MB_R0_BASE+SWP_FL_32MB_R_SIZE)
    #define SWP_FL_32MB_R1_BASE    (SWP_FL_32MB_K1_BASE+SWP_FL_32MB_K_SIZE)
#elif defined (CONFIG_CMD_SPI_NAND)
    /****** SPI NAND flash ******/
    #define SWP_FL_64MB (64*1024*1024)
    #define SWP_FL_MAX_USE_64MB (SWP_FL_64MB-(1280*1024)) //reserve 1280KB(10 blocks) for 512Mbit NAND flash
    #define SWP_FL_64MB_CFGFS_BASE (1*1024*1024)
#ifdef CONFIG_STATIC_CONFIG
    #define SWP_FL_64MB_CFG_ST_BASE    (11*1024*1024)
    #define SWP_FL_64MB_CFG_ST_SIZE    (256*1024)
#endif
#ifdef CONFIG_STATIC_CONFIG
    #define SWP_FL_64MB_K0_BASE    (11*1024*1024+SWP_FL_64MB_CFG_ST_SIZE)
    #define SWP_FL_64MB_K_SIZE     (7*1024*1024 - (128*1024))
#else
    #define SWP_FL_64MB_K0_BASE    (11*1024*1024)
    #define SWP_FL_64MB_K_SIZE     (7*1024*1024)
#endif
    #define SWP_FL_64MB_R0_BASE    (SWP_FL_64MB_K0_BASE+SWP_FL_64MB_K_SIZE)
    #define SWP_FL_64MB_R_SIZE     (((SWP_FL_MAX_USE_64MB-SWP_FL_64MB_K0_BASE)>>1)-SWP_FL_64MB_K_SIZE)
    #define SWP_FL_64MB_K1_BASE    (SWP_FL_64MB_R0_BASE+SWP_FL_64MB_R_SIZE)
    #define SWP_FL_64MB_R1_BASE    (SWP_FL_64MB_K1_BASE+SWP_FL_64MB_K_SIZE)
    #define SWP_FL_64MB_OPT_BASE   (1*1024*1024)
    #define SWP_FL_64MB_OPT3_BASE    (SWP_FL_64MB_R1_BASE+SWP_FL_64MB_OPT_BASE)
    #define SWP_FL_64MB_OPT4_BASE    (SWP_FL_64MB_OPT3_BASE+SWP_FL_64MB_OPT_BASE)

    #define SWP_FL_128MB (128*1024*1024)
    #define SWP_FL_MAX_USE_128MB (SWP_FL_128MB-(2560*1024)) //reserve 2560KB(20 blocks) for 1Gbit NAND flash
    #define SWP_FL_128MB_CFGFS_BASE (1*1024*1024)
#ifdef CONFIG_STATIC_CONFIG
    #define SWP_FL_128MB_CFG_ST_BASE   (4096*1024)
    #define SWP_FL_128MB_CFG_ST_SIZE   (256*1024)
#endif
#ifdef CONFIG_STATIC_CONFIG
    #define SWP_FL_128MB_K0_BASE    (4096*1024+SWP_FL_128MB_CFG_ST_SIZE)
    #define SWP_FL_128MB_K_SIZE     (5376*1024-128*1024)
#else
    #define SWP_FL_128MB_K0_BASE    (4096*1024)
    #define SWP_FL_128MB_K_SIZE     (5376*1024)
#endif
    #define SWP_FL_128MB_R0_BASE    (SWP_FL_128MB_K0_BASE+SWP_FL_128MB_K_SIZE)
    #define SWP_FL_128MB_R_SIZE     (15*1024*1024)
    #define SWP_FL_128MB_K1_BASE    (SWP_FL_128MB_R0_BASE+SWP_FL_128MB_R_SIZE)
    #define SWP_FL_128MB_R1_BASE    (SWP_FL_128MB_K1_BASE+SWP_FL_128MB_K_SIZE)
    #define SWP_FL_128MB_OPT_SIZE   (8*1024*1024)
    #define SWP_FL_128MB_OPT3_BASE    (SWP_FL_128MB_R1_BASE+SWP_FL_128MB_R_SIZE)
    #define SWP_FL_128MB_OPT4_BASE    (SWP_FL_128MB_OPT3_BASE+SWP_FL_128MB_OPT_SIZE)
    #define SWP_FL_128MB_APP_SIZE    (65*1024*1024)
    #define SWP_FL_128MB_APP_BASE    (SWP_FL_128MB_OPT4_BASE+SWP_FL_128MB_OPT_SIZE)
    
    #define SWP_FL_256MB (256*1024*1024)
    #define SWP_FL_MAX_USE_256MB (SWP_FL_256MB-(2560*1024)) //reserve 2560KB(20 blocks) for 2Gbit NAND flash
    #define SWP_FL_256MB_CFGFS_BASE (1*1024*1024)
#ifdef CONFIG_STATIC_CONFIG
    #define SWP_FL_256MB_CFG_ST_BASE   (12288*1024)
    #define SWP_FL_256MB_CFG_ST_SIZE   (256*1024)
#endif
#ifdef CONFIG_STATIC_CONFIG
    #define SWP_FL_256MB_K0_BASE    (12288*1024+SWP_FL_256MB_CFG_ST_SIZE)
    #define SWP_FL_256MB_K_SIZE     (8*1024*1024-(128*1024))
#else
    #define SWP_FL_256MB_K0_BASE    (12288*1024)
    #define SWP_FL_256MB_K_SIZE     (8*1024*1024)
#endif
    #define SWP_FL_256MB_R0_BASE    (SWP_FL_256MB_K0_BASE+SWP_FL_256MB_K_SIZE)
    #define SWP_FL_256MB_R_SIZE     (48640*1024+1280*1024)
    #define SWP_FL_256MB_K1_BASE    (SWP_FL_256MB_R0_BASE+SWP_FL_256MB_R_SIZE)
    #define SWP_FL_256MB_R1_BASE    (SWP_FL_256MB_K1_BASE+SWP_FL_256MB_K_SIZE)
    #define SWP_FL_256MB_OPT_SIZE   (16*1024*1024)
    #define SWP_FL_256MB_OPT3_BASE    (SWP_FL_256MB_R1_BASE+SWP_FL_256MB_R_SIZE)
    #define SWP_FL_256MB_OPT4_BASE    (SWP_FL_256MB_OPT3_BASE+SWP_FL_256MB_OPT_SIZE)
    #define SWP_FL_256MB_APP_SIZE   (96*1024*1024)
    #define SWP_FL_256MB_APP_BASE    (SWP_FL_256MB_OPT4_BASE+SWP_FL_256MB_OPT_SIZE)

    #define SWP_FL_512MB (512*1024*1024)
    #define SWP_FL_MAX_USE_512MB (SWP_FL_512MB-(2560*1024)) //reserve 2560KB(20 blocks)  for 4Gbit NAND flash
    #define SWP_FL_512MB_CFGFS_BASE (1*1024*1024)
#ifdef CONFIG_STATIC_CONFIG
    #define SWP_FL_512MB_CFG_ST_BASE    (12288*1024)
    #define SWP_FL_512MB_CFG_ST_SIZE    (256*1024)
#endif
#ifdef CONFIG_STATIC_CONFIG
    #define SWP_FL_512MB_K0_BASE    (12288*1024+SWP_FL_512MB_CFG_ST_SIZE)
    #define SWP_FL_512MB_K_SIZE     (8*1024*1024-(256*1024))
#else
    #define SWP_FL_512MB_K0_BASE    (12288*1024)
    #define SWP_FL_512MB_K_SIZE     (8*1024*1024)
#endif
    #define SWP_FL_512MB_R0_BASE    (SWP_FL_512MB_K0_BASE+SWP_FL_512MB_K_SIZE)
    #define SWP_FL_512MB_R_SIZE     (173*1024*1024+3840*1024)
    #define SWP_FL_512MB_K1_BASE    (SWP_FL_512MB_R0_BASE+SWP_FL_512MB_R_SIZE)
    #define SWP_FL_512MB_R1_BASE    (SWP_FL_512MB_K1_BASE+SWP_FL_512MB_K_SIZE)
    #define SWP_FL_512MB_APP_SIZE   (128*1024*1024)
    #define SWP_FL_512MB_APP_BASE    (SWP_FL_512MB_R1_BASE+SWP_FL_512MB_R_SIZE)
    
#elif defined (CONFIG_CMD_ONFI)
    /****** SPI NAND flash ******/
    #define SWP_FL_64MB (64*1024*1024)
    #define SWP_FL_MAX_USE_64MB (SWP_FL_64MB-(1280*1024)) //reserve 1280KB(10 blocks) for 512Mbit NAND flash
    #define SWP_FL_64MB_CFGFS_BASE (1*1024*1024)
    #define SWP_FL_64MB_K0_BASE    (11*1024*1024)
    #define SWP_FL_64MB_K_SIZE     (8*1024*1024)
    #define SWP_FL_64MB_R0_BASE    (SWP_FL_64MB_K0_BASE+SWP_FL_64MB_K_SIZE)
    #define SWP_FL_64MB_R_SIZE     (((SWP_FL_MAX_USE_64MB-SWP_FL_64MB_K0_BASE)>>1)-SWP_FL_64MB_K_SIZE)
    #define SWP_FL_64MB_K1_BASE    (SWP_FL_64MB_R0_BASE+SWP_FL_64MB_R_SIZE)
    #define SWP_FL_64MB_R1_BASE    (SWP_FL_64MB_K1_BASE+SWP_FL_64MB_K_SIZE)

    #define SWP_FL_128MB (128*1024*1024)
    #define SWP_FL_MAX_USE_128MB (SWP_FL_128MB-(2560*1024)) //reserve 2560KB(20 blocks) for 1Gbit NAND flash
    #define SWP_FL_128MB_CFGFS_BASE (768*1024)
    #define SWP_FL_128MB_K0_BASE    (25*1024*1024)
    #define SWP_FL_128MB_K_SIZE     (8*1024*1024)
    #define SWP_FL_128MB_R0_BASE    (SWP_FL_128MB_K0_BASE+SWP_FL_128MB_K_SIZE)
    #define SWP_FL_128MB_R_SIZE     (((SWP_FL_MAX_USE_128MB-SWP_FL_128MB_K0_BASE)>>1)-SWP_FL_128MB_K_SIZE)
    #define SWP_FL_128MB_K1_BASE    (SWP_FL_128MB_R0_BASE+SWP_FL_128MB_R_SIZE)
    #define SWP_FL_128MB_R1_BASE    (SWP_FL_128MB_K1_BASE+SWP_FL_128MB_K_SIZE)
#else
#error "Error!!! One of CONFIG_CMD_SF or CONFIG_CMD_NAND must be defined"
#endif
#endif


//#define FL_DEBUG
#ifdef FL_DEBUG
#define DEBUG(format, args...) printf(format, ##args)
#else
#define DEBUG(args...)
#endif

#ifndef CONFIG_BOOT_IMG_RO
#define CONFIG_BOOT_IMG_RO 1
#endif

#ifndef CONFIG_ENABLE_BLOCK_ALIGNMEMT
#define CONFIG_ENABLE_BLOCK_ALIGNMEMT 1
#endif


#ifdef CONFIG_CMD_SF
	#define SWP_RTK_MTD_DEV_NAME "rtk_spi_nor_mtd"
	#include <spi_flash.h>
	#include "nor_spi_gen3/nor_spif_core.h"
#elif defined CONFIG_CMD_SPI_NAND
	#define SWP_RTK_MTD_DEV_NAME "spinand"
#elif defined CONFIG_CMD_ONFI
        #define SWP_RTK_MTD_DEV_NAME "onfi"
#else
	#error "Error!!! One of CONFIG_CMD_SF or CONFIG_CMD_SPI_NAND or CONFIG_CMD_ONFI must be defined"
#endif

#define SWP_GB_BITS (30)
#define SWP_MB_BITS (20)
#define SWP_KB_BITS (10)
#define SWP_GB_MASK ((0x1<<SWP_GB_BITS)-1)
#define SWP_MB_MASK ((0x1<<SWP_MB_BITS)-1)
#define SWP_KB_MASK ((0x1<<SWP_KB_BITS)-1)

#define SWP_BOOT_KERNEL "linux"
#define SWP_BOOT_ROOTFS "rootfs"

typedef struct {
	char* name;
	u32 base;
	u32 size;
} swp_part_info_t;

/* Move the following to different setting */
static swp_part_info_t part_info[] = {
	{"config",    0                       , 0}, /* CFGFS    */
	{"env2",      SWP_CONFIG_ENV_OFFSET_REDUND, 0}, /* ENV2    */
	{"framework1",      0                       , 0}, /* opt3    */
	{"framework2",      0                       , 0}, /* opt4    */
	{"k0",        0                       , 0}, /* kernel1 */
	{"k1",        0                       , 0}, /* kernel2    */
	{"r0",        0                       , 0}, /* rootfs1 */
	{"r1",        0                       , 0}, /* rootfs2 */
	{"END",       0                       , 0}, /* end     */
	{"env",       SWP_CONFIG_ENV_OFFSET       , 0}, /* U-Boot environment partition */
    {"apps",       0       , 0}, /* app */
	{"static_conf", 0, 0}, /* static_conf for static config  */
	{"boot",      0                       , 0}, /* BOOTLOADER partition, must be the last entity in this array */
};
/* Should be consistent with part_info defined above */
#define SWP_FL_CFGFS 0
#define SWP_FL_ENV2 1
#define SWP_FL_OPT3 2
#define SWP_FL_OPT4 3
#define SWP_FL_KERNEL1 4
#define SWP_FL_KERNEL2 5
#define SWP_FL_ROOTFS1 6
#define SWP_FL_ROOTFS2 7
#define SWP_FL_END 8
#define SWP_FL_ENV 9
#define SWP_FL_APP 10
#define SWP_FL_CFG_ST 11
#define SWP_FL_BOOT 12

static swp_part_info_t *pi_ptr[ARRAY_SIZE(part_info)];

#ifdef CONFIG_OTTO_FL_TO_MTDPARTS
char * swp_to_KMGB(u32 val, char *output_p, u32 output_size) {
	if((val & SWP_GB_MASK) == 0) { /* To GB */
		sprintf(output_p, "%uG", (val >> SWP_GB_BITS));
	} else if((val & SWP_MB_MASK) == 0) {/* To MB */
		sprintf(output_p, "%uM", (val >> SWP_MB_BITS));
	} else if((val & SWP_KB_MASK) == 0) { /* To KB */
		sprintf(output_p, "%uK", (val >> SWP_KB_BITS));
	} else {
		sprintf(output_p, "%u", (val));
	}
	return output_p;

}

#if CONFIG_BOOT_IMG_RO
#ifdef CONFIG_LUNA_MULTI_BOOT
#define PROTECT_SUFFIX "ro"
#else
#define PROTECT_SUFFIX ""
#endif
#endif

#define SWP_TS_SIZE (64) /* Magic number temp string size */
#define SWP_VIRTUAL_MTD_START 12
const u32 SWP_FL_KERNEL_ID[] = {SWP_FL_KERNEL1, SWP_FL_KERNEL2};
const u32 SWP_FL_ROOTFS_ID[] = {SWP_FL_ROOTFS1, SWP_FL_ROOTFS2};
//Generate mtdparts (root=31:? is also included)
static void swp_flash_layout_to_mtdparts(char *mtdparts_output, u32 img_id, u32 mtdparts_default) {
	char tmp_str0[SWP_TS_SIZE] = {0};
	char tmp_str1[SWP_TS_SIZE] = {0};
	u32 i, j, rootfs_partition;
	char *p;

	p = mtdparts_output;
	rootfs_partition = ARRAY_SIZE(part_info);

	p += sprintf(p, "mtdparts=%s:", SWP_RTK_MTD_DEV_NAME);
	for(i = 0, j = 0; i < ARRAY_SIZE(part_info); i++) {
		if(pi_ptr[i]->size != 0) {
#if !CONFIG_BOOT_IMG_RO
			p += sprintf(p, "%s(%s),", swp_to_KMGB(pi_ptr[i]->size, tmp_str0, SWP_TS_SIZE), pi_ptr[i]->name);
			//p += sprintf(p, "%s@%s(%s),", to_KMGB(pi_ptr[i]->size, tmp_str0, SWP_TS_SIZE), to_KMGB(pi_ptr[i]->base, tmp_str1, SWP_TS_SIZE), pi_ptr[i]->name);
#else
			if(pi_ptr[i]->name == part_info[SWP_FL_ROOTFS_ID[img_id]].name ||
					pi_ptr[i]->name == part_info[SWP_FL_KERNEL_ID[img_id]].name
					) {
			p += sprintf(p, "%s(%s)" PROTECT_SUFFIX ",", swp_to_KMGB(pi_ptr[i]->size, tmp_str0, SWP_TS_SIZE), pi_ptr[i]->name);
} else {
			p += sprintf(p, "%s(%s),", swp_to_KMGB(pi_ptr[i]->size, tmp_str0, SWP_TS_SIZE), pi_ptr[i]->name);
}
#endif

			/* Record rootfs partition */
			if(pi_ptr[i]->name == part_info[SWP_FL_ROOTFS_ID[img_id]].name) {
				DEBUG("pi_ptr[i]->name=%s, part_info[SWP_FL_ROOTFS_ID[img_id]].name=%s,i=%d,j=%d\n", pi_ptr[i]->name, part_info[SWP_FL_ROOTFS_ID[img_id]].name, i, j);
				rootfs_partition = j;
#if (OTTO_NAND_FLASH==1)
				rootfs_partition--; /* Magic number handling for NAND platform */
				DEBUG("rootfs_partition-- for NAND platform\n");
#endif /* (OTTO_NAND_FLASH==1) */
			}
			j++;
		}
	}

	/* Generate default mtdparts for uboot/MTD, partition layout string only */
	if (mtdparts_default)		return;

#ifdef CONFIG_LUNA_MULTI_BOOT
	/* Fill padding mtd partition */
	for(;j<SWP_VIRTUAL_MTD_START;j++) {
		p += sprintf(p, "4K@0ro,");
		//p += sprintf(p, "4K@%s(m)ro,", to_KMGB(part_info[FL_END].size, tmp_str0, SWP_TS_SIZE));
	}
	/* Create alias partition for booting linux & kernel */
	p += sprintf(p, "%s@%s(%s),", swp_to_KMGB(part_info[SWP_FL_KERNEL_ID[img_id]].size, tmp_str0, SWP_TS_SIZE), swp_to_KMGB(part_info[SWP_FL_KERNEL_ID[img_id]].base, tmp_str1, SWP_TS_SIZE), SWP_BOOT_KERNEL);
	p += sprintf(p, "%s@%s(%s),", swp_to_KMGB(part_info[SWP_FL_ROOTFS_ID[img_id]].size, tmp_str0, SWP_TS_SIZE), swp_to_KMGB(part_info[SWP_FL_ROOTFS_ID[img_id]].base, tmp_str1, SWP_TS_SIZE), SWP_BOOT_ROOTFS);
#endif

	/* Replace the last ',' (comma sign) by a null character '\0' */
	if(mtdparts_output[strlen(mtdparts_output) - 1] == ',') {
		mtdparts_output[strlen(mtdparts_output) - 1] = '\0';
	}

	if(rootfs_partition == ARRAY_SIZE(part_info)) {
		printf("Error: Cannot find rootfs partition\n");
	} else {
		DEBUG("rootfs_partition=%d\n", rootfs_partition);
		p = mtdparts_output + strlen(mtdparts_output);
		p += sprintf(p, " root=31:%d", rootfs_partition);
	}

}

#endif /* #ifdef CONFIG_OTTO_FL_TO_MTDPARTS */

void swp_sort_part_info(swp_part_info_t *input_pi_ptr[], u32 num) {
	u32 i, j;
	swp_part_info_t *item_p;

	/* Use insertion sort as the number of elements in the array is not huge */
	for(i=1; i<num; i++) {
		j = i;
		item_p = input_pi_ptr[j];
		while( (j > 0) && (item_p->base < input_pi_ptr[j-1]->base) ) {
			input_pi_ptr[j] = input_pi_ptr[j - 1];
			j--;
		}
		input_pi_ptr[j]= item_p;
	}
}

#define SWP_FLASHI                   (norsf_info)
u32 swp_otto_get_flash_size(void) {
	u32 ret_val;
#if defined (CONFIG_CMD_SPI_NAND)
	extern uint32_t spi_nand_chip_size(uint32_t idx);
	ret_val=spi_nand_chip_size(0);
	/* ToDo , multiple chip to be considered */
#elif defined (CONFIG_CMD_ONFI)
        extern uint32_t onfi_chip_size(uint32_t idx);
        ret_val=onfi_chip_size(0);
        /* ToDo , multiple chip to be considered */
#else
	ret_val = SWP_FLASHI.num_chips * SWP_FLASHI.size_per_chip_b;
#endif
	return ret_val;
}


#if CONFIG_ENABLE_BLOCK_ALIGNMEMT
u32 otto_get_nand_flash_block_size(void);
// if a partition has more than MAGIC_BLOCK_NUMBER blocks, than don't make adjust to next partition
#define MAGIC_BLOCK_NUMBER (5)
void
swp_adjust_parts_alignment(swp_part_info_t *input_pi_ptr[], u32 num)
{
	u32 i;
	uint32_t adjust_len = 0;
	uint32_t block_len = otto_get_nand_flash_block_size();
	uint32_t is_first_adjust = 1;
	for (i = 1; i < num; ++i) {
		uint32_t adjust_base = input_pi_ptr[i]->base + adjust_len;
		DEBUG("BASE of %i is %x and adjust len is %x\n", i, input_pi_ptr[i]->base, adjust_len);
		if (adjust_base % block_len != 0) {
			adjust_base = ((adjust_base / block_len)+1)*block_len;
			adjust_len = adjust_base - input_pi_ptr[i]->base;
		}
		if (i+1 < num) {
			if ((input_pi_ptr[i+1]->base - adjust_base)/block_len > MAGIC_BLOCK_NUMBER ) {
				adjust_len = 0;
			}
		}
		if (input_pi_ptr[i]->base != adjust_base) {
			if (is_first_adjust) {
				printf("Adjust for block size 0x%x\n", block_len);
				is_first_adjust = 0;
			}
			printf("Adjust layout position of %s from 0x%04X to 0x%04X\n", input_pi_ptr[i]->name, input_pi_ptr[i]->base, adjust_base);
		}
		input_pi_ptr[i]->base = adjust_base;
		DEBUG("After adjustment is %x\n", input_pi_ptr[i]->base);
	}
}
#endif

void swp_part_info_init(void) {
	u32 i, j;

	i =  swp_otto_get_flash_size();
#ifdef CONFIG_CMD_SF
	j =  getenv_ulong("fl_size", 10, 0);
	if( (j != 0) && (j != i) ){
		if( (j < i) && ((j == FL_8MB) || (j == FL_16MB))){
			printf("INFO: flash size=%dMB, but %dMB layout is used.\n", (i >> 20), (j >> 20));
			i = j;
		} else {
			printf("ERROR: flash size=%dMB, %dMB layout unsupported.\n", (i >> 20), (j >> 20));
		}
	}
#elif defined (CONFIG_CMD_SPI_NAND)
	j =  getenv_ulong("fl_size", 10, 0);
	if( (j != 0) && (j != i) ){
		if( (j < i) && (j == FL_64MB)){
			printf("INFO: flash size=%dMB, but %dMB layout is used.\n", (i >> 20), (j >> 20));
			i = j;
		} else {
			printf("ERROR: flash size=%dMB, %dMB layout unsupported.\n", (i >> 20), (j >> 20));
		}
	}
#elif defined (CONFIG_CMD_ONFI)
        j =  getenv_ulong("fl_size", 10, 0);
        if( (j != 0) && (j != i) ){
            if( (j < i) && (j == FL_64MB)){
                printf("INFO: flash size=%dMB, but %dMB layout is used.\n", (i >> 20), (j >> 20));
                i = j;
            } else {
                printf("ERROR: flash size=%dMB, %dMB layout unsupported.\n", (i >> 20), (j >> 20));
            }
        }
#endif
	switch(i) {
#ifdef CONFIG_CMD_SF
	case SWP_FL_32MB:
		part_info[SWP_FL_CFGFS].base   = SWP_FL_32MB_CFGFS_BASE;
		part_info[SWP_FL_KERNEL1].base = SWP_FL_32MB_K0_BASE;
		part_info[SWP_FL_ROOTFS1].base = SWP_FL_32MB_R0_BASE;
		part_info[SWP_FL_KERNEL2].base = SWP_FL_32MB_K1_BASE;
		part_info[SWP_FL_ROOTFS2].base = SWP_FL_32MB_R1_BASE;
		part_info[SWP_FL_END].base = SWP_FL_32MB;
	break;

	case SWP_FL_16MB:
		part_info[SWP_FL_CFGFS].base   = SWP_FL_16MB_CFGFS_BASE;
		part_info[SWP_FL_KERNEL1].base = SWP_FL_16MB_K0_BASE;
		part_info[SWP_FL_ROOTFS1].base = SWP_FL_16MB_R0_BASE;
		part_info[SWP_FL_KERNEL2].base = SWP_FL_16MB_K1_BASE;
		part_info[SWP_FL_ROOTFS2].base = SWP_FL_16MB_R1_BASE;
		part_info[SWP_FL_END].base = SWP_FL_16MB;
	break;

	case SWP_FL_8MB:
		part_info[SWP_FL_CFGFS].base   = SWP_FL_8MB_CFGFS_BASE;
		part_info[SWP_FL_KERNEL1].base = SWP_FL_8MB_K0_BASE;
		part_info[SWP_FL_ROOTFS1].base = SWP_FL_8MB_R0_BASE;
		part_info[SWP_FL_KERNEL2].base = SWP_FL_8MB_K1_BASE;
		part_info[SWP_FL_ROOTFS2].base = SWP_FL_8MB_R1_BASE;
		part_info[SWP_FL_END].base = SWP_FL_8MB;
	break;

	default:
		printf("INFO: layout for flash size=%dMB is not defined, %dMB layout is used.\n", (i >> 20), (SWP_FL_8MB >> 20));
		part_info[SWP_FL_CFGFS].base   = SWP_FL_8MB_CFGFS_BASE;
		part_info[SWP_FL_KERNEL1].base = SWP_FL_8MB_K0_BASE;
		part_info[SWP_FL_ROOTFS1].base = SWP_FL_8MB_R0_BASE;
		part_info[SWP_FL_KERNEL2].base = SWP_FL_8MB_K1_BASE;
		part_info[SWP_FL_ROOTFS2].base = SWP_FL_8MB_R1_BASE;
		part_info[SWP_FL_END].base = SWP_FL_8MB;
	break;
#elif defined (CONFIG_CMD_SPI_NAND)
	case SWP_FL_64MB:
		part_info[SWP_FL_CFGFS].base   = SWP_FL_64MB_CFGFS_BASE;
		part_info[SWP_FL_KERNEL1].base = SWP_FL_64MB_K0_BASE;
		part_info[SWP_FL_ROOTFS1].base = SWP_FL_64MB_R0_BASE;
		part_info[SWP_FL_KERNEL2].base = SWP_FL_64MB_K1_BASE;
		part_info[SWP_FL_ROOTFS2].base = SWP_FL_64MB_R1_BASE;
#ifdef CONFIG_STATIC_CONFIG
		part_info[SWP_FL_CFG_ST].base = SWP_FL_64MB_CFG_ST_BASE;
#endif
        part_info[SWP_FL_OPT3].base = SWP_FL_64MB_OPT3_BASE;
        part_info[SWP_FL_OPT4].base = SWP_FL_64MB_OPT4_BASE;
		part_info[SWP_FL_END].base = SWP_FL_MAX_USE_64MB;
	break;

	case SWP_FL_128MB:
	case SWP_FL_256MB:
		part_info[SWP_FL_CFGFS].base   = SWP_FL_128MB_CFGFS_BASE;
		part_info[SWP_FL_KERNEL1].base = SWP_FL_128MB_K0_BASE;
		part_info[SWP_FL_ROOTFS1].base = SWP_FL_128MB_R0_BASE;
		part_info[SWP_FL_KERNEL2].base = SWP_FL_128MB_K1_BASE;
		part_info[SWP_FL_ROOTFS2].base = SWP_FL_128MB_R1_BASE;
        part_info[SWP_FL_OPT3].base = SWP_FL_128MB_OPT3_BASE;
        part_info[SWP_FL_OPT4].base = SWP_FL_128MB_OPT4_BASE;
        part_info[SWP_FL_APP].base = SWP_FL_128MB_APP_BASE;
#ifdef CONFIG_STATIC_CONFIG
        part_info[SWP_FL_CFG_ST].base = SWP_FL_128MB_CFG_ST_BASE;
#endif
		part_info[SWP_FL_END].base = SWP_FL_MAX_USE_128MB;
	break;
/* force 256M flash use 128M layout
    case SWP_FL_256MB:
                part_info[SWP_FL_CFGFS].base   = SWP_FL_256MB_CFGFS_BASE;
                part_info[SWP_FL_KERNEL1].base = SWP_FL_256MB_K0_BASE;
                part_info[SWP_FL_ROOTFS1].base = SWP_FL_256MB_R0_BASE;
                part_info[SWP_FL_KERNEL2].base = SWP_FL_256MB_K1_BASE;
                part_info[SWP_FL_ROOTFS2].base = SWP_FL_256MB_R1_BASE;
                part_info[SWP_FL_OPT3].base = SWP_FL_256MB_OPT3_BASE;
                part_info[SWP_FL_OPT4].base = SWP_FL_256MB_OPT4_BASE;
                part_info[SWP_FL_APP].base = SWP_FL_256MB_APP_BASE;
#ifdef CONFIG_STATIC_CONFIG
                part_info[SWP_FL_CFG_ST].base = SWP_FL_256MB_CFG_ST_BASE;
#endif
                part_info[SWP_FL_END].base = SWP_FL_MAX_USE_256MB;

	break;
*/
    case SWP_FL_512MB:
		part_info[SWP_FL_CFGFS].base   = SWP_FL_512MB_CFGFS_BASE;
		part_info[SWP_FL_KERNEL1].base = SWP_FL_512MB_K0_BASE;
		part_info[SWP_FL_ROOTFS1].base = SWP_FL_512MB_R0_BASE;
		part_info[SWP_FL_KERNEL2].base = SWP_FL_512MB_K1_BASE;
		part_info[SWP_FL_ROOTFS2].base = SWP_FL_512MB_R1_BASE;
        part_info[SWP_FL_APP].base = SWP_FL_512MB_APP_BASE;
#ifdef CONFIG_STATIC_CONFIG
        part_info[SWP_FL_CFG_ST].base = SWP_FL_512MB_CFG_ST_BASE;
#endif
		part_info[SWP_FL_END].base = SWP_FL_MAX_USE_512MB;
	break;


	default:
		printf("INFO: [APro] layout for flash size=%dMB is not defined, %dMB layout is used.\n", (i >> 20), (SWP_FL_128MB >> 20));
		part_info[SWP_FL_CFGFS].base   = SWP_FL_128MB_CFGFS_BASE;
		part_info[SWP_FL_KERNEL1].base = SWP_FL_128MB_K0_BASE;
		part_info[SWP_FL_ROOTFS1].base = SWP_FL_128MB_R0_BASE;
		part_info[SWP_FL_KERNEL2].base = SWP_FL_128MB_K1_BASE;
		part_info[SWP_FL_ROOTFS2].base = SWP_FL_128MB_R1_BASE;
		part_info[SWP_FL_OPT3].base = SWP_FL_128MB_OPT3_BASE;
		part_info[SWP_FL_OPT4].base = SWP_FL_128MB_OPT4_BASE;
		part_info[SWP_FL_APP].base = SWP_FL_128MB_APP_BASE;
#ifdef CONFIG_STATIC_CONFIG
		part_info[SWP_FL_CFG_ST].base = SWP_FL_128MB_CFG_ST_BASE;
#endif
		part_info[SWP_FL_END].base = SWP_FL_MAX_USE_128MB;
	break;
#elif defined (CONFIG_CMD_ONFI)
        case SWP_FL_64MB:
            part_info[SWP_FL_CFGFS].base   = SWP_FL_64MB_CFGFS_BASE;
            part_info[SWP_FL_KERNEL1].base = SWP_FL_64MB_K0_BASE;
            part_info[SWP_FL_ROOTFS1].base = SWP_FL_64MB_R0_BASE;
            part_info[SWP_FL_KERNEL2].base = SWP_FL_64MB_K1_BASE;
            part_info[SWP_FL_ROOTFS2].base = SWP_FL_64MB_R1_BASE;
            part_info[SWP_FL_END].base = SWP_FL_MAX_USE_64MB;
        break;

        case SWP_FL_128MB:
            part_info[SWP_FL_CFGFS].base   = SWP_FL_128MB_CFGFS_BASE;
            part_info[SWP_FL_KERNEL1].base = SWP_FL_128MB_K0_BASE;
            part_info[SWP_FL_ROOTFS1].base = SWP_FL_128MB_R0_BASE;
            part_info[SWP_FL_KERNEL2].base = SWP_FL_128MB_K1_BASE;
            part_info[SWP_FL_ROOTFS2].base = SWP_FL_128MB_R1_BASE;
            part_info[SWP_FL_END].base = SWP_FL_MAX_USE_128MB;
        break;

        default:
            printf("INFO: layout for flash size=%dMB is not defined, %dMB layout is used.\n", (i >> 20), (SWP_FL_128MB >> 20));
            part_info[SWP_FL_CFGFS].base   = SWP_FL_128MB_CFGFS_BASE;
            part_info[SWP_FL_KERNEL1].base = SWP_FL_128MB_K0_BASE;
            part_info[SWP_FL_ROOTFS1].base = SWP_FL_128MB_R0_BASE;
            part_info[SWP_FL_KERNEL2].base = SWP_FL_128MB_K1_BASE;
            part_info[SWP_FL_ROOTFS2].base = SWP_FL_128MB_R1_BASE;
            part_info[SWP_FL_END].base = SWP_FL_MAX_USE_128MB;
        break;
#endif
	}

	for(i=0; i<ARRAY_SIZE(part_info); i++) {
		pi_ptr[i] = &part_info[i];
	}
	DEBUG("Original setting\n");
	DEBUG("pi_ptr: name\tbase\tsize\n");
	for(i=0; i<ARRAY_SIZE(part_info); i++) {
		DEBUG("[%d]: %s\t0x%08x\t0x%08x\n", i, pi_ptr[i]->name, pi_ptr[i]->base, pi_ptr[i]->size);
	}

	swp_sort_part_info(pi_ptr, ARRAY_SIZE(part_info));
	DEBUG("After sorting\n");
	DEBUG("pi_ptr: name\tbase\tsize\n");
	for(i=0; i<ARRAY_SIZE(part_info); i++) {
		DEBUG("[%d]: %s\t0x%08x\t0x%08x\n", i, pi_ptr[i]->name, pi_ptr[i]->base, pi_ptr[i]->size);
	}

#if CONFIG_ENABLE_BLOCK_ALIGNMEMT
#if defined (CONFIG_CMD_SPI_NAND) || defined (CONFIG_CMD_ONFI)
	swp_adjust_parts_alignment(pi_ptr, ARRAY_SIZE(part_info));
	DEBUG("After Adjustment\n");
	DEBUG("pi_ptr: name\tbase\tsize\n");
	for(i=0; i<ARRAY_SIZE(part_info); i++) {
		DEBUG("[%d]: %s\t0x%08x\t0x%08x\n", i, pi_ptr[i]->name, pi_ptr[i]->base, pi_ptr[i]->size);
	}
#endif
#endif

	/* Fill size */
	for(i=0; i<(ARRAY_SIZE(part_info)-1); i++) {
		pi_ptr[i]->size = pi_ptr[i+1]->base - pi_ptr[i]->base;
	}
	DEBUG("After filling size\n");
	DEBUG("pi_ptr: name\tbase\tsize\n");
	for(i=0; i<ARRAY_SIZE(part_info); i++) {
		DEBUG("[%d]: %s\t0x%08x\t0x%08x\n", i, pi_ptr[i]->name, pi_ptr[i]->base, pi_ptr[i]->size);
	}

	DEBUG("Valid partitions\n");
	DEBUG("part_info: name\tbase\tsize\n");
	for(i=0; i<ARRAY_SIZE(part_info); i++) {
		if(pi_ptr[i]->size !=0) {
			DEBUG("[%d]: %s\t0x%08x\t0x%08x\n", i, pi_ptr[i]->name, pi_ptr[i]->base, pi_ptr[i]->size);
		}
	}
}


void swp_otto_flash_layout_init(void) {
    char str_tmp[256] = {0};

    swp_part_info_init();

    setenv_addr("fl_boot_sz",    (void *)part_info[SWP_FL_BOOT].size);
	setenv_addr("fl_env",        (void *)part_info[SWP_FL_ENV].base);
	setenv_addr("fl_env_sz",     (void *)part_info[SWP_FL_ENV].size);
	setenv_addr("fl_env2",       (void *)part_info[SWP_FL_ENV2].base);
	setenv_addr("fl_cfgfs",      (void *)part_info[SWP_FL_CFGFS].base);
	setenv_addr("fl_cfgfs_sz",   (void *)part_info[SWP_FL_CFGFS].size);
	setenv_addr("fl_kernel1",    (void *)part_info[SWP_FL_KERNEL1].base);
	setenv_addr("fl_kernel1_sz", (void *)part_info[SWP_FL_KERNEL1].size);
	setenv_addr("fl_rootfs1",    (void *)part_info[SWP_FL_ROOTFS1].base);
	setenv_addr("fl_rootfs1_sz", (void *)part_info[SWP_FL_ROOTFS1].size);
#ifdef CONFIG_LUNA_MULTI_BOOT
	setenv_addr("fl_kernel2",    (void *)part_info[SWP_FL_KERNEL2].base);
	setenv_addr("fl_kernel2_sz", (void *)part_info[SWP_FL_KERNEL2].size);
	setenv_addr("fl_rootfs2",    (void *)part_info[SWP_FL_ROOTFS2].base);
	setenv_addr("fl_rootfs2_sz", (void *)part_info[SWP_FL_ROOTFS2].size);
#endif /* #ifdef CONFIG_LUNA_MULTI_BOOT */
#ifdef CONFIG_CMD_SF
	setenv_addr("img0_kernel",    (void *)(NORSF_CFLASH_BASE + part_info[SWP_FL_KERNEL1].base));

#ifdef CONFIG_LUNA_MULTI_BOOT
	setenv_addr("img1_kernel",    (void *)(NORSF_CFLASH_BASE + part_info[SWP_FL_KERNEL2].base));
#endif /* #ifdef CONFIG_LUNA_MULTI_BOOT */
#endif /* #ifdef CONFIG_SPINOR_FLASH */

#if defined (CONFIG_STATIC_CONFIG)
	setenv_addr("fl_cfg_st",    (void *)part_info[SWP_FL_CFG_ST].base);
	setenv_addr("fl_cfg_st_sz", (void *)part_info[SWP_FL_CFG_ST].size);
#if defined (CONFIG_CMD_SPI_NAND)
	setenv("erase_cfg_st", "spi_nand erase ${fl_cfg_st} ${fl_cfg_st_sz}");
#elif defined (CONFIG_CMD_ONFI)
	setenv("erase_cfg_st", "onfi erase ${fl_cfg_st} ${fl_cfg_st_sz}");
#endif
#endif

#ifdef CONFIG_OTTO_FL_TO_MTDPARTS
#ifdef CONFIG_CMD_MTDPARTS
	sprintf(str_tmp, "nand0=%s", SWP_RTK_MTD_DEV_NAME);
	setenv("mtdids", str_tmp);
	swp_flash_layout_to_mtdparts(str_tmp, 0, 1);
	//printf("mtdparts=%s\n", str_tmp);
	setenv("mtdparts", str_tmp);
#endif /* #ifdef CONFIG_CMD_MTDPARTS */
	swp_flash_layout_to_mtdparts(str_tmp, 0, 0);
	//printf("mtdparts0=%s\n", str_tmp);
	setenv("mtdparts0", str_tmp);
#ifdef CONFIG_LUNA_MULTI_BOOT
	swp_flash_layout_to_mtdparts(str_tmp, 1, 0);
	//printf("mtdparts1=%s\n", str_tmp);
	setenv("mtdparts1", str_tmp);
#endif /* #ifdef CONFIG_LUNA_MULTI_BOOT */
#endif /* #ifdef CONFIG_OTTO_FL_TO_MTDPARTS */
#ifdef CONFIG_CMD_SPI_NAND
        if((part_info[SWP_FL_OPT3].base != 0) && (part_info[SWP_FL_OPT3].size !=0)){
                setenv_addr("fl_framework1", (void *)part_info[SWP_FL_OPT3].base);
                setenv_addr("fl_framework1_sz", (void *)part_info[SWP_FL_OPT3].size);
                setenv("erase_framework1" , "spi_nand erase ${fl_framework1} ${fl_framework1_sz}");
        } else {
                setenv("erase_framework1", "echo fl_framework1 is invalid");
        }
        if((part_info[SWP_FL_OPT4].base != 0) && (part_info[SWP_FL_OPT4].size !=0)){
                setenv_addr("fl_framework2", (void *)part_info[SWP_FL_OPT4].base);
                setenv_addr("fl_framework2_sz", (void *)part_info[SWP_FL_OPT4].size);
                setenv("erase_framework2" , "spi_nand erase ${fl_framework2} ${fl_framework2_sz}");
        } else {
                setenv("erase_framework2", "echo fl_framework2 is invalid");
        }

        if((part_info[SWP_FL_APP].base != 0) && (part_info[SWP_FL_APP].size !=0)){
                setenv_addr("fl_apps", (void *)part_info[SWP_FL_APP].base);
                setenv_addr("fl_apps_sz", (void *)part_info[SWP_FL_APP].size);
                setenv("erase_apps" , "spi_nand erase ${fl_apps} ${fl_apps_sz}");
        } else {
                setenv("erase_apps", "echo fl_apps is invalid");
        }
#endif /* #ifdef CONFIG_CMD_NAND */

}

PATCH_REG(swp_otto_flash_layout_init, 6);
