/*
 * REGISTERS.h
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED BY ./rdb2tt.pl
 * -config rdb2h.yml -db reg.db
 *
 */
#ifndef _CA8277_REGISTERS_H_
#define _CA8277_REGISTERS_H_

#include "ca_types.h"
 
/* work around DEBUG being defined in the build overriding 
 * registers named DEBUG in structures below 
 * 
 */ 
#ifdef DEBUG 
#define CA_DEBUG_WORKAROUND DEBUG 
#undef DEBUG 
#endif /* DEBUG */

/******************************************************************
 *
 * Each register in the map is defined as a struct with bitfields.
 *
 ******************************************************************/

/*
 * APB1
 */
  
/*
 * PE0_ATU
 */
        
#define PE0_ATU_CTL                              0x90300000
#define PE0_ATU_CTL_dft                          0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA0                            0x90300004
#define PE0_ATU_DATA0_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA1                            0x90300008
#define PE0_ATU_DATA1_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA2                            0x9030000c
#define PE0_ATU_DATA2_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA3                            0x90300010
#define PE0_ATU_DATA3_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA4                            0x90300014
#define PE0_ATU_DATA4_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA5                            0x90300018
#define PE0_ATU_DATA5_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_UPPER                            0x9030001c
#define PE0_ATU_UPPER_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PE1_ATU
 */
        
#define PE1_ATU_CTL                              0x90300100
#define PE1_ATU_CTL_dft                          0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA0                            0x90300104
#define PE1_ATU_DATA0_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA1                            0x90300108
#define PE1_ATU_DATA1_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA2                            0x9030010c
#define PE1_ATU_DATA2_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA3                            0x90300110
#define PE1_ATU_DATA3_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA4                            0x90300114
#define PE1_ATU_DATA4_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA5                            0x90300118
#define PE1_ATU_DATA5_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_UPPER                            0x9030011c
#define PE1_ATU_UPPER_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * CRYPTO0_ATU
 */
        
#define CRYPTO0_ATU_CTL                          0x90300200
#define CRYPTO0_ATU_CTL_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA0                        0x90300204
#define CRYPTO0_ATU_DATA0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA1                        0x90300208
#define CRYPTO0_ATU_DATA1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA2                        0x9030020c
#define CRYPTO0_ATU_DATA2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA3                        0x90300210
#define CRYPTO0_ATU_DATA3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA4                        0x90300214
#define CRYPTO0_ATU_DATA4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA5                        0x90300218
#define CRYPTO0_ATU_DATA5_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_UPPER                        0x9030021c
#define CRYPTO0_ATU_UPPER_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * CRYPTO1_ATU
 */
        
#define CRYPTO1_ATU_CTL                          0x90300400
#define CRYPTO1_ATU_CTL_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA0                        0x90300404
#define CRYPTO1_ATU_DATA0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA1                        0x90300408
#define CRYPTO1_ATU_DATA1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA2                        0x9030040c
#define CRYPTO1_ATU_DATA2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA3                        0x90300410
#define CRYPTO1_ATU_DATA3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA4                        0x90300414
#define CRYPTO1_ATU_DATA4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA5                        0x90300418
#define CRYPTO1_ATU_DATA5_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_UPPER                        0x9030041c
#define CRYPTO1_ATU_UPPER_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * DOE_ATU
 */
        
#define DOE_ATU_CTL                              0x90300500
#define DOE_ATU_CTL_dft                          0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} DOE_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define DOE_ATU_DATA0                            0x90300504
#define DOE_ATU_DATA0_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} DOE_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define DOE_ATU_DATA1                            0x90300508
#define DOE_ATU_DATA1_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} DOE_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define DOE_ATU_DATA2                            0x9030050c
#define DOE_ATU_DATA2_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} DOE_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define DOE_ATU_DATA3                            0x90300510
#define DOE_ATU_DATA3_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} DOE_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define DOE_ATU_DATA4                            0x90300514
#define DOE_ATU_DATA4_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} DOE_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define DOE_ATU_DATA5                            0x90300518
#define DOE_ATU_DATA5_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} DOE_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define DOE_ATU_UPPER                            0x9030051c
#define DOE_ATU_UPPER_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} DOE_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * FBM
 */
  
/*
 * GLOBAL
 */
        
#define FBM_GLOBAL_GLB_CTRL                      0x90300800
#define FBM_GLOBAL_GLB_CTRL_dft                  0x01010100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pool_enable          :  8 ; /* bits 7:0 */
    ca_uint32_t ecc_en               :  1 ; /* bits 8:8 */
    ca_uint32_t release_mode         :  1 ; /* bits 9:9 */
    ca_uint32_t lpae                 :  1 ; /* bits 10:10 */
    ca_uint32_t rl_poll_mode         :  1 ; /* bits 11:11 */
    ca_uint32_t fastreg_en           :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t exs_burst_size       :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t fbm_qm_ack_mode      :  1 ; /* bits 19:19 */
    ca_uint32_t fbm_qm_ack_dly       :  4 ; /* bits 23:20 */
    ca_uint32_t cnt_burst_size       :  2 ; /* bits 25:24 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t fbm_dma_ack_mode     :  1 ; /* bits 27:27 */
    ca_uint32_t fbm_dma_ack_dly      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_AXI_CTRL                      0x90300804
#define FBM_GLOBAL_AXI_CTRL_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_user_pid_en      :  8 ; /* bits 7:0 */
    ca_uint32_t ace_cmd_en           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t mset_usr_pat         :  2 ; /* bits 17:16 */
    ca_uint32_t minv_usr_pat         :  2 ; /* bits 19:18 */
    ca_uint32_t pool_rd_usr_pat      :  2 ; /* bits 21:20 */
    ca_uint32_t pool_wr_usr_pat      :  2 ; /* bits 23:22 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_AXI_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_AXI_USR_PAT0                  0x90300808
#define FBM_GLOBAL_AXI_USR_PAT0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t usr_pat_0            : 25 ; /* bits 24:0 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_AXI_USR_PAT0_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_AXI_USR_PAT1                  0x9030080c
#define FBM_GLOBAL_AXI_USR_PAT1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t usr_pat_1            : 25 ; /* bits 24:0 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_AXI_USR_PAT1_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_AXI_USR_PAT2                  0x90300810
#define FBM_GLOBAL_AXI_USR_PAT2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t usr_pat_2            : 25 ; /* bits 24:0 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_AXI_USR_PAT2_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_AXI_USR_PAT3                  0x90300814
#define FBM_GLOBAL_AXI_USR_PAT3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t usr_pat_3            : 25 ; /* bits 24:0 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_AXI_USR_PAT3_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_MEM_SET_PAT0                  0x90300818
#define FBM_GLOBAL_MEM_SET_PAT0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mset_pat_0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_MEM_SET_PAT0_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_MEM_SET_PAT1                  0x9030081c
#define FBM_GLOBAL_MEM_SET_PAT1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mset_pat_1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_MEM_SET_PAT1_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTERRUPT0                    0x90300820
#define FBM_GLOBAL_INTERRUPT0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error     :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_address_check_drop :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop     :  1 ; /* bits 4:4 */
    ca_uint32_t dma_address_check_drop :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt       :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow       :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTERRUPT0_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTENABLE0                    0x90300824
#define FBM_GLOBAL_INTENABLE0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error_en  :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error_en    :  1 ; /* bits 1:1 */
    ca_uint32_t sw_addr_check_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t dma_addr_check_drop_en :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop_en :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt_en    :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt_en     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow_en    :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow_en   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTENABLE0_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTERRUPT1                    0x90300828
#define FBM_GLOBAL_INTERRUPT1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error     :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_address_check_drop :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop     :  1 ; /* bits 4:4 */
    ca_uint32_t dma_address_check_drop :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt       :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow       :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTERRUPT1_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTENABLE1                    0x9030082c
#define FBM_GLOBAL_INTENABLE1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error_en  :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error_en    :  1 ; /* bits 1:1 */
    ca_uint32_t sw_addr_check_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t dma_addr_check_drop_en :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop_en :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt_en    :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt_en     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow_en    :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow_en   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTENABLE1_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTERRUPT2                    0x90300830
#define FBM_GLOBAL_INTERRUPT2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error     :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_address_check_drop :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop     :  1 ; /* bits 4:4 */
    ca_uint32_t dma_address_check_drop :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt       :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow       :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTERRUPT2_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTENABLE2                    0x90300834
#define FBM_GLOBAL_INTENABLE2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error_en  :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error_en    :  1 ; /* bits 1:1 */
    ca_uint32_t sw_addr_check_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t dma_addr_check_drop_en :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop_en :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt_en    :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt_en     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow_en    :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow_en   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTENABLE2_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTERRUPT3                    0x90300838
#define FBM_GLOBAL_INTERRUPT3_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error     :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_address_check_drop :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop     :  1 ; /* bits 4:4 */
    ca_uint32_t dma_address_check_drop :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt       :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow       :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTERRUPT3_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTENABLE3                    0x9030083c
#define FBM_GLOBAL_INTENABLE3_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error_en  :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error_en    :  1 ; /* bits 1:1 */
    ca_uint32_t sw_addr_check_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t dma_addr_check_drop_en :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop_en :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt_en    :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt_en     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow_en    :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow_en   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTENABLE3_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTERRUPT4                    0x90300840
#define FBM_GLOBAL_INTERRUPT4_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error     :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_address_check_drop :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop     :  1 ; /* bits 4:4 */
    ca_uint32_t dma_address_check_drop :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt       :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow       :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTERRUPT4_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTENABLE4                    0x90300844
#define FBM_GLOBAL_INTENABLE4_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error_en  :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error_en    :  1 ; /* bits 1:1 */
    ca_uint32_t sw_addr_check_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t dma_addr_check_drop_en :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop_en :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt_en    :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt_en     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow_en    :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow_en   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTENABLE4_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTERRUPT5                    0x90300848
#define FBM_GLOBAL_INTERRUPT5_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error     :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_address_check_drop :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop     :  1 ; /* bits 4:4 */
    ca_uint32_t dma_address_check_drop :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt       :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow       :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTERRUPT5_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTENABLE5                    0x9030084c
#define FBM_GLOBAL_INTENABLE5_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error_en  :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error_en    :  1 ; /* bits 1:1 */
    ca_uint32_t sw_addr_check_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t dma_addr_check_drop_en :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop_en :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt_en    :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt_en     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow_en    :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow_en   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTENABLE5_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTERRUPT6                    0x90300850
#define FBM_GLOBAL_INTERRUPT6_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error     :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_address_check_drop :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop     :  1 ; /* bits 4:4 */
    ca_uint32_t dma_address_check_drop :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt       :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow       :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTERRUPT6_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTENABLE6                    0x90300854
#define FBM_GLOBAL_INTENABLE6_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error_en  :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error_en    :  1 ; /* bits 1:1 */
    ca_uint32_t sw_addr_check_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t dma_addr_check_drop_en :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop_en :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt_en    :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt_en     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow_en    :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow_en   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTENABLE6_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTERRUPT7                    0x90300858
#define FBM_GLOBAL_INTERRUPT7_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error     :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_address_check_drop :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop     :  1 ; /* bits 4:4 */
    ca_uint32_t dma_address_check_drop :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt       :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow       :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTERRUPT7_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INTENABLE7                    0x9030085c
#define FBM_GLOBAL_INTENABLE7_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t single_ecc_error_en  :  1 ; /* bits 0:0 */
    ca_uint32_t dual_ecc_error_en    :  1 ; /* bits 1:1 */
    ca_uint32_t sw_addr_check_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t sw_enable_check_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t sw_stack_of_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t dma_addr_check_drop_en :  1 ; /* bits 5:5 */
    ca_uint32_t dma_enable_check_drop_en :  1 ; /* bits 6:6 */
    ca_uint32_t axim_interrupt_en    :  1 ; /* bits 7:7 */
    ca_uint32_t ins_interrupt_en     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t stack_overflow_en    :  8 ; /* bits 23:16 */
    ca_uint32_t stack_underflow_en   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INTENABLE7_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_CECC_CNTR                     0x90300860
#define FBM_GLOBAL_CECC_CNTR_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t c_ecc_cntr           :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_CECC_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_UCECC_CNTR                    0x90300864
#define FBM_GLOBAL_UCECC_CNTR_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t uc_ecc_cntr          :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_UCECC_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_DEC_DROP_CNTR                 0x90300868
#define FBM_GLOBAL_DEC_DROP_CNTR_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dec_drop_cntr        :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_DEC_DROP_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_CNT_QUEUE_DEPTH               0x9030086c
#define FBM_GLOBAL_CNT_QUEUE_DEPTH_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_queue_depth      :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_CNT_QUEUE_DEPTH_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_CONFIG_CPU_RELEASE_STACK_FULL 0x90300870
#define FBM_GLOBAL_CONFIG_CPU_RELEASE_STACK_FULL_dft 0xe0c04025

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rl_wait_apb_when_stack_full :  1 ; /* bits 0:0 */
    ca_uint32_t rl_err_apb_when_stack_full :  1 ; /* bits 1:1 */
    ca_uint32_t rl_wait_apb_when_ins_full :  1 ; /* bits 2:2 */
    ca_uint32_t rl_err_apb_when_ins_full :  1 ; /* bits 3:3 */
    ca_uint32_t rl_polling_hold_access_when_ins_full :  1 ; /* bits 4:4 */
    ca_uint32_t al_hold_apb_when_only_ins_empty :  1 ; /* bits 5:5 */
    ca_uint32_t rl_spare             :  2 ; /* bits 7:6 */
    ca_uint32_t rl_apb_wr_timer_thresh :  8 ; /* bits 15:8 */
    ca_uint32_t rl_ins_can_push_thresh :  8 ; /* bits 23:16 */
    ca_uint32_t rl_ins_almost_full_thresh :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_CONFIG_CPU_RELEASE_STACK_FULL_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_STC_SPSRAM_mbist_fbm          0x90300874
#define FBM_GLOBAL_STC_SPSRAM_mbist_fbm_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_STC_SPSRAM_mbist_fbm_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTERRUPT0                0x90300878
#define FBM_GLOBAL_INS_INTERRUPT0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop     :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full             :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full      :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push         :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTERRUPT0_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTENABLE0                0x9030087c
#define FBM_GLOBAL_INS_INTENABLE0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop_en  :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check_en :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full_en          :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full_en   :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push_en      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTENABLE0_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTERRUPT1                0x90300880
#define FBM_GLOBAL_INS_INTERRUPT1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop     :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full             :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full      :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push         :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTERRUPT1_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTENABLE1                0x90300884
#define FBM_GLOBAL_INS_INTENABLE1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop_en  :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check_en :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full_en          :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full_en   :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push_en      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTENABLE1_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTERRUPT2                0x90300888
#define FBM_GLOBAL_INS_INTERRUPT2_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop     :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full             :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full      :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push         :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTERRUPT2_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTENABLE2                0x9030088c
#define FBM_GLOBAL_INS_INTENABLE2_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop_en  :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check_en :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full_en          :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full_en   :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push_en      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTENABLE2_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTERRUPT3                0x90300890
#define FBM_GLOBAL_INS_INTERRUPT3_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop     :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full             :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full      :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push         :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTERRUPT3_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTENABLE3                0x90300894
#define FBM_GLOBAL_INS_INTENABLE3_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop_en  :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check_en :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full_en          :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full_en   :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push_en      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTENABLE3_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTERRUPT4                0x90300898
#define FBM_GLOBAL_INS_INTERRUPT4_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop     :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full             :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full      :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push         :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTERRUPT4_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTENABLE4                0x9030089c
#define FBM_GLOBAL_INS_INTENABLE4_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop_en  :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check_en :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full_en          :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full_en   :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push_en      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTENABLE4_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTERRUPT5                0x903008a0
#define FBM_GLOBAL_INS_INTERRUPT5_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop     :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full             :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full      :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push         :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTERRUPT5_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTENABLE5                0x903008a4
#define FBM_GLOBAL_INS_INTENABLE5_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop_en  :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check_en :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full_en          :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full_en   :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push_en      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTENABLE5_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTERRUPT6                0x903008a8
#define FBM_GLOBAL_INS_INTERRUPT6_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop     :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full             :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full      :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push         :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTERRUPT6_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTENABLE6                0x903008ac
#define FBM_GLOBAL_INS_INTENABLE6_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop_en  :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check_en :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full_en          :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full_en   :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push_en      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTENABLE6_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTERRUPT7                0x903008b0
#define FBM_GLOBAL_INS_INTERRUPT7_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop     :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full             :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full      :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push         :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTERRUPT7_t;
#endif /* !__ASSEMBLER__ */


#define FBM_GLOBAL_INS_INTENABLE7                0x903008b4
#define FBM_GLOBAL_INS_INTENABLE7_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_ins_full_drop_en  :  1 ; /* bits 0:0 */
    ca_uint32_t sw_ins_almost_full_check_en :  1 ; /* bits 1:1 */
    ca_uint32_t sw_ins_can_push_check_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ins_full_en          :  8 ; /* bits 15:8 */
    ca_uint32_t ins_almost_full_en   :  8 ; /* bits 23:16 */
    ca_uint32_t ins_can_push_en      :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_GLOBAL_INS_INTENABLE7_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * AXIM2
 */
        
#define FBM_AXIM2_CONFIG                         0x90300900
#define FBM_AXIM2_CONFIG_dft                     0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_write_outtrans_num :  4 ; /* bits 3:0 */
    ca_uint32_t axi_read_outtrans_num :  4 ; /* bits 7:4 */
    ca_uint32_t axi_xbus_len         :  3 ; /* bits 10:8 */
    ca_uint32_t write_cacheline_trans_en :  1 ; /* bits 11:11 */
    ca_uint32_t write_cacheline_trans_size :  1 ; /* bits 12:12 */
    ca_uint32_t read_cacheline_trans_en :  1 ; /* bits 13:13 */
    ca_uint32_t read_cacheline_trans_size :  1 ; /* bits 14:14 */
    ca_uint32_t arcache_eos_en       :  1 ; /* bits 15:15 */
    ca_uint32_t awcache_eos_en       :  1 ; /* bits 16:16 */
    ca_uint32_t reserved             : 15 ; /* bits 31:17 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_AXIM2_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define FBM_AXIM2_TIMEOUT_THRESHOLD              0x90300904
#define FBM_AXIM2_TIMEOUT_THRESHOLD_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_channel_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t write_channel_threshold :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_AXIM2_TIMEOUT_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */


#define FBM_AXIM2_INTERRUPT_STATUS               0x90300908
#define FBM_AXIM2_INTERRUPT_STATUS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_AXIM2_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define FBM_AXIM2_INTERRUPT_ENABLE               0x9030090c
#define FBM_AXIM2_INTERRUPT_ENABLE_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int_en :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int_en :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int_en :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int_en :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_AXIM2_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * CPU[0..7]
 */
        
#define FBM_CPU_SW_ACCESS                        0x90300a00
#define FBM_CPU_SW_ACCESS_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t POOLID               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_CPU_SW_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define FBM_CPU_SW_DATA1                         0x90300a04
#define FBM_CPU_SW_DATA1_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t DATA                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_CPU_SW_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define FBM_CPU_SW_DATA0                         0x90300a08
#define FBM_CPU_SW_DATA0_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t DATA                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_CPU_SW_DATA0_t;
#endif /* !__ASSEMBLER__ */

    
#define APB1_FBM_CPU_STRIDE                      32
#define APB1_FBM_CPU_COUNT                       8
  
    
      

/*
 * POOL[0..7]
 */
        
#define FBM_POOL_POOL_CONTROL                    0x90300b00
#define FBM_POOL_POOL_CONTROL_dft                0xc0400300

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pool_mset            :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t pool_cainv           :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t pool_oscntr_en       :  1 ; /* bits 8:8 */
    ca_uint32_t pool_oscntr_dbg      :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               :  6 ;
    ca_uint32_t ins_lo_thresh        :  8 ; /* bits 23:16 */
    ca_uint32_t ins_hi_thresh        :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_POOL_CONTROL_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_EXSTACK_BAR                     0x90300b04
#define FBM_POOL_EXSTACK_BAR_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t exs_bar              : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_EXSTACK_BAR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_EXSTACK_DEPTH                   0x90300b08
#define FBM_POOL_EXSTACK_DEPTH_dft               0x00010000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t exs_full_thresh      : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_EXSTACK_DEPTH_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_BUFFER_SIZE                     0x90300b0c
#define FBM_POOL_BUFFER_SIZE_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t buff_size            :  8 ; /* bits 13:6 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_BUFFER_SIZE_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SEG_CONTROL                     0x90300b10
#define FBM_POOL_SEG_CONTROL_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t se0_size             :  3 ; /* bits 2:0 */
    ca_uint32_t se0_enable           :  1 ; /* bits 3:3 */
    ca_uint32_t se1_size             :  3 ; /* bits 6:4 */
    ca_uint32_t se1_enable           :  1 ; /* bits 7:7 */
    ca_uint32_t se2_size             :  3 ; /* bits 10:8 */
    ca_uint32_t se2_enable           :  1 ; /* bits 11:11 */
    ca_uint32_t se3_size             :  3 ; /* bits 14:12 */
    ca_uint32_t se3_enable           :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SEG_CONTROL_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SE0_BAR                         0x90300b14
#define FBM_POOL_SE0_BAR_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t se0_bar              : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SE0_BAR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SE1_BAR                         0x90300b18
#define FBM_POOL_SE1_BAR_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t se1_bar              : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SE1_BAR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SE2_BAR                         0x90300b1c
#define FBM_POOL_SE2_BAR_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t se2_bar              : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SE2_BAR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SE3_BAR                         0x90300b20
#define FBM_POOL_SE3_BAR_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t se3_bar              : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SE3_BAR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_DEBUG_INS_PTR                   0x90300b24
#define FBM_POOL_DEBUG_INS_PTR_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ins_bptr             :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t ins_tptr             :  8 ; /* bits 23:16 */
    ca_uint32_t ins_ptr_distance     :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_DEBUG_INS_PTR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_DEBUG_EXS_PTR                   0x90300b28
#define FBM_POOL_DEBUG_EXS_PTR_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t exs_ptr              : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_DEBUG_EXS_PTR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_DEBUG_OUT_STND_CNTR             0x90300b2c
#define FBM_POOL_DEBUG_OUT_STND_CNTR_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t os_cntr              : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_DEBUG_OUT_STND_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SIMPLE_ACCESS                   0x90300b30
#define FBM_POOL_SIMPLE_ACCESS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t poolid_wr            :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t simple_wr            :  1 ; /* bits 15:15 */
    ca_uint32_t poolid_rd            :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t preload_rd           :  1 ; /* bits 30:30 */
    ca_uint32_t simple_rd            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SIMPLE_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SIMPLE_DATA1_RD                 0x90300b34
#define FBM_POOL_SIMPLE_DATA1_RD_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data1_rd             :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SIMPLE_DATA1_RD_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SIMPLE_DATA0_RD                 0x90300b38
#define FBM_POOL_SIMPLE_DATA0_RD_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data0_rd             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SIMPLE_DATA0_RD_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SIMPLE_DATA1_WR                 0x90300b3c
#define FBM_POOL_SIMPLE_DATA1_WR_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data1_wr             :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SIMPLE_DATA1_WR_t;
#endif /* !__ASSEMBLER__ */


#define FBM_POOL_SIMPLE_DATA0_WR                 0x90300b40
#define FBM_POOL_SIMPLE_DATA0_WR_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data0_wr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FBM_POOL_SIMPLE_DATA0_WR_t;
#endif /* !__ASSEMBLER__ */

    
#define APB1_FBM_POOL_STRIDE                     128
#define APB1_FBM_POOL_COUNT                      8
  
    
      
    
  
        

/*
 * LDMA
 */
  
/*
 * LDMA_GLB
 */
        
#define LDMA_LDMA_GLB_LDMA_CONTROL               0x90301000
#define LDMA_LDMA_GLB_LDMA_CONTROL_dft           0x00000080

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t aruser_idx           :  3 ; /* bits 6:4 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 7:7 */
    ca_uint32_t buf_depth_sel        :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t lpae_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_CONTROL_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER          0x90301004
#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_dft      0x00800400

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t period               : 16 ; /* bits 15:0 */
    ca_uint32_t credit               : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_RATE_LIMITER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB       0x90301008
#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_dft   0x00000fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upperbound           : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_LDMA_BKT0_DWRR             0x9030100c
#define LDMA_LDMA_GLB_LDMA_BKT0_DWRR_dft         0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_BKT0_DWRR_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_LDMA_BKT1_DWRR             0x90301010
#define LDMA_LDMA_GLB_LDMA_BKT1_DWRR_dft         0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_BKT1_DWRR_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0       0x90301014
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0         0x90301018
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1       0x9030101c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1         0x90301020
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2       0x90301024
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2         0x90301028
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3       0x9030102c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3         0x90301030
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4       0x90301034
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4         0x90301038
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5       0x9030103c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5         0x90301040
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6       0x90301044
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6         0x90301048
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7       0x9030104c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7         0x90301050
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_0                 0x90301054
#define LDMA_LDMA_GLB_AXPATTEN_0_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_1                 0x90301058
#define LDMA_LDMA_GLB_AXPATTEN_1_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_2                 0x9030105c
#define LDMA_LDMA_GLB_AXPATTEN_2_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_3                 0x90301060
#define LDMA_LDMA_GLB_AXPATTEN_3_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_3_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_4                 0x90301064
#define LDMA_LDMA_GLB_AXPATTEN_4_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_4_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_5                 0x90301068
#define LDMA_LDMA_GLB_AXPATTEN_5_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_5_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_6                 0x9030106c
#define LDMA_LDMA_GLB_AXPATTEN_6_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_6_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_7                 0x90301070
#define LDMA_LDMA_GLB_AXPATTEN_7_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_7_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER      0x90301074
#define LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_dft  0x0000ff00

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t q0_sel               :  1 ; /* bits 0:0 */
    ca_uint32_t q1_sel               :  1 ; /* bits 1:1 */
    ca_uint32_t q2_sel               :  1 ; /* bits 2:2 */
    ca_uint32_t q3_sel               :  1 ; /* bits 3:3 */
    ca_uint32_t q4_sel               :  1 ; /* bits 4:4 */
    ca_uint32_t q5_sel               :  1 ; /* bits 5:5 */
    ca_uint32_t q6_sel               :  1 ; /* bits 6:6 */
    ca_uint32_t q7_sel               :  1 ; /* bits 7:7 */
    ca_uint32_t q8_sel               :  1 ; /* bits 8:8 */
    ca_uint32_t q9_sel               :  1 ; /* bits 9:9 */
    ca_uint32_t q10_sel              :  1 ; /* bits 10:10 */
    ca_uint32_t q11_sel              :  1 ; /* bits 11:11 */
    ca_uint32_t q12_sel              :  1 ; /* bits 12:12 */
    ca_uint32_t q13_sel              :  1 ; /* bits 13:13 */
    ca_uint32_t q14_sel              :  1 ; /* bits 14:14 */
    ca_uint32_t q15_sel              :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER     0x90301078
#define LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t PE0_QA               :  4 ; /* bits 3:0 */
    ca_uint32_t PE0_QA_en            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t PE0_QB               :  4 ; /* bits 11:8 */
    ca_uint32_t PE0_QB_en            :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t PE1_QA               :  4 ; /* bits 19:16 */
    ca_uint32_t PE1_QA_en            :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t PE1_QB               :  4 ; /* bits 27:24 */
    ca_uint32_t PE1_QB_en            :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER 0x9030107c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER 0x90301080
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER 0x90301084
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER 0x90301088
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER 0x9030108c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER 0x90301090
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER 0x90301094
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER 0x90301098
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER 0x9030109c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER 0x903010a0
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER 0x903010a4
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER 0x903010a8
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER 0x903010ac
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER 0x903010b0
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER 0x903010b4
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER 0x903010b8
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER 0x903010bc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER 0x903010c0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER 0x903010c4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER 0x903010c8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER 0x903010cc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER 0x903010d0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER 0x903010d4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER 0x903010d8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER 0x903010dc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER 0x903010e0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER 0x903010e4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER 0x903010e8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER 0x903010ec
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER 0x903010f0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER 0x903010f4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER 0x903010f8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER 0x903010fc
#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER 0x90301100
#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_STC_SPSRAM_mbist_ldma      0x90301104
#define LDMA_LDMA_GLB_STC_SPSRAM_mbist_ldma_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_STC_SPSRAM_mbist_ldma_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * AXIM2
 */
        
#define LDMA_AXIM2_CONFIG                        0x903011a0
#define LDMA_AXIM2_CONFIG_dft                    0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_write_outtrans_num :  4 ; /* bits 3:0 */
    ca_uint32_t axi_read_outtrans_num :  4 ; /* bits 7:4 */
    ca_uint32_t axi_xbus_len         :  3 ; /* bits 10:8 */
    ca_uint32_t write_cacheline_trans_en :  1 ; /* bits 11:11 */
    ca_uint32_t write_cacheline_trans_size :  1 ; /* bits 12:12 */
    ca_uint32_t read_cacheline_trans_en :  1 ; /* bits 13:13 */
    ca_uint32_t read_cacheline_trans_size :  1 ; /* bits 14:14 */
    ca_uint32_t arcache_eos_en       :  1 ; /* bits 15:15 */
    ca_uint32_t awcache_eos_en       :  1 ; /* bits 16:16 */
    ca_uint32_t reserved             : 15 ; /* bits 31:17 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_AXIM2_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_AXIM2_TIMEOUT_THRESHOLD             0x903011a4
#define LDMA_AXIM2_TIMEOUT_THRESHOLD_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_channel_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t write_channel_threshold :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_AXIM2_TIMEOUT_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_AXIM2_INTERRUPT_STATUS              0x903011a8
#define LDMA_AXIM2_INTERRUPT_STATUS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_AXIM2_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_AXIM2_INTERRUPT_ENABLE              0x903011ac
#define LDMA_AXIM2_INTERRUPT_ENABLE_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int_en :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int_en :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int_en :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int_en :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_AXIM2_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * LDMA_QUEUE[0..15]
 */
        
#define LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS        0x90301200
#define LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t desc_idx             :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t debug_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 21 ;
    ca_uint32_t wrd_n                :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2         0x90301204
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t length               : 12 ; /* bits 11:0 */
    ca_uint32_t rd_cmd_only          :  1 ; /* bits 12:12 */
    ca_uint32_t rd_trn_only          :  1 ; /* bits 13:13 */
    ca_uint32_t wr_zero_trn          :  1 ; /* bits 14:14 */
    ca_uint32_t ioc                  :  1 ; /* bits 15:15 */
    ca_uint32_t dst_addr_lpae        :  8 ; /* bits 23:16 */
    ca_uint32_t src_addr_lpae        :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1         0x90301208
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dst_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0         0x9030120c
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t src_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_CONTROL_REGISTER         0x90301210
#define LDMA_LDMA_QUEUE_CONTROL_REGISTER_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clsc_timer           : 16 ; /* bits 15:0 */
    ca_uint32_t clsc_threshold       :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t wch_axi_error        :  1 ; /* bits 24:24 */
    ca_uint32_t rch_axi_error        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t reset                :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t en                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_CONTROL_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_DWRR_REGISTER            0x90301214
#define LDMA_LDMA_QUEUE_DWRR_REGISTER_dft        0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DWRR_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_INTERRUPT_ENABLE         0x90301218
#define LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dd_en                :  1 ; /* bits 0:0 */
    ca_uint32_t fov_en               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_INTERRUPT_STATUS         0x9030121c
#define LDMA_LDMA_QUEUE_INTERRUPT_STATUS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t descriptor_done      :  1 ; /* bits 0:0 */
    ca_uint32_t fifo_overflow        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_POINTER_REGISTER         0x90301220
#define LDMA_LDMA_QUEUE_POINTER_REGISTER_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  4 ; /* bits 3:0 */
    ca_uint32_t rd_trans_rdptr       :  4 ; /* bits 7:4 */
    ca_uint32_t rd_trans_wrptr       :  4 ; /* bits 11:8 */
    ca_uint32_t wr_trans_rdptr       :  4 ; /* bits 15:12 */
    ca_uint32_t rd_ptr               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t desc_depth           :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_POINTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

    
#define APB1_LDMA_LDMA_QUEUE_STRIDE              64
#define APB1_LDMA_LDMA_QUEUE_COUNT               16
  
    
      

/*
 * LDMA_INTERRUPT_MUX
 */
        
#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE      0x90301600
#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS      0x90301604
#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE      0x90301608
#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS      0x9030160c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE      0x90301610
#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS      0x90301614
#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE      0x90301618
#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS      0x9030161c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE      0x90301620
#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS      0x90301624
#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE      0x90301628
#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS      0x9030162c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE      0x90301630
#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS      0x90301634
#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE      0x90301638
#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS      0x9030163c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      
    
  
        

/*
 * LDMA_RCPU
 */
  
/*
 * LDMA_QUEUE[0..15]
 */
        
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS   0x90302200
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t desc_idx             :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t debug_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 21 ;
    ca_uint32_t wrd_n                :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2    0x90302204
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t length               : 12 ; /* bits 11:0 */
    ca_uint32_t rd_cmd_only          :  1 ; /* bits 12:12 */
    ca_uint32_t rd_trn_only          :  1 ; /* bits 13:13 */
    ca_uint32_t wr_zero_trn          :  1 ; /* bits 14:14 */
    ca_uint32_t ioc                  :  1 ; /* bits 15:15 */
    ca_uint32_t dst_addr_lpae        :  8 ; /* bits 23:16 */
    ca_uint32_t src_addr_lpae        :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1    0x90302208
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dst_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0    0x9030220c
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t src_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER    0x90302210
#define LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clsc_timer           : 16 ; /* bits 15:0 */
    ca_uint32_t clsc_threshold       :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t wch_axi_error        :  1 ; /* bits 24:24 */
    ca_uint32_t rch_axi_error        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t reset                :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t en                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER       0x90302214
#define LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_dft   0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE    0x90302218
#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dd_en                :  1 ; /* bits 0:0 */
    ca_uint32_t fov_en               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS    0x9030221c
#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t descriptor_done      :  1 ; /* bits 0:0 */
    ca_uint32_t fifo_overflow        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER    0x90302220
#define LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  4 ; /* bits 3:0 */
    ca_uint32_t rd_trans_rdptr       :  4 ; /* bits 7:4 */
    ca_uint32_t rd_trans_wrptr       :  4 ; /* bits 11:8 */
    ca_uint32_t wr_trans_rdptr       :  4 ; /* bits 15:12 */
    ca_uint32_t rd_ptr               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t desc_depth           :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

    
#define APB1_LDMA_RCPU_LDMA_QUEUE_STRIDE         64
#define APB1_LDMA_RCPU_LDMA_QUEUE_COUNT          16
  
    
      

/*
 * LDMA_INTERRUPT_MUX
 */
        
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE 0x90302600
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS 0x90302604
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE 0x90302608
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS 0x9030260c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE 0x90302610
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS 0x90302614
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE 0x90302618
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS 0x9030261c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE 0x90302620
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS 0x90302624
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE 0x90302628
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS 0x9030262c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE 0x90302630
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS 0x90302634
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE 0x90302638
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS 0x9030263c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      
    
  
        

/*
 * PE_CTRL
 */
        
#define PE_CTRL_PES_ADDR_MASTER_CONFIG           0x90303000
#define PE_CTRL_PES_ADDR_MASTER_CONFIG_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pe0s_shift_en        :  1 ; /* bits 0:0 */
    ca_uint32_t pe1s_shift_en        :  1 ; /* bits 1:1 */
    ca_uint32_t pe0s_slave_prot      :  1 ; /* bits 2:2 */
    ca_uint32_t pe1s_slave_prot      :  1 ; /* bits 3:3 */
    ca_uint32_t pe0_isolation_en     :  1 ; /* bits 4:4 */
    ca_uint32_t pe1_isolation_en     :  1 ; /* bits 5:5 */
    ca_uint32_t pe0_powercut_ctrl    :  1 ; /* bits 6:6 */
    ca_uint32_t pe1_powercut_ctrl    :  1 ; /* bits 7:7 */
    ca_uint32_t does_shift_en        :  1 ; /* bits 8:8 */
    ca_uint32_t does_slave_prot      :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t doe_fix_dma_range    :  1 ; /* bits 16:16 */
    ca_uint32_t pe0_fix_dma_range    :  1 ; /* bits 17:17 */
    ca_uint32_t pe1_fix_dma_range    :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PES_ADDR_MASTER_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE0S_ADDR_CONFIG                 0x90303004
#define PE_CTRL_PE0S_ADDR_CONFIG_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pe0s_addr_val        : 16 ; /* bits 15:0 */
    ca_uint32_t pe0s_addr_mask       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE0S_ADDR_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE1S_ADDR_CONFIG                 0x90303008
#define PE_CTRL_PE1S_ADDR_CONFIG_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pe1s_addr_val        : 16 ; /* bits 15:0 */
    ca_uint32_t pe1s_addr_mask       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE1S_ADDR_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL_PE0                     0x9030300c
#define PE_CTRL_AXI_CTRL_PE0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arqos_pe             :  4 ; /* bits 3:0 */
    ca_uint32_t awqos_pe             :  4 ; /* bits 7:4 */
    ca_uint32_t ruser_pe             :  4 ; /* bits 11:8 */
    ca_uint32_t buser_pe             :  4 ; /* bits 15:12 */
    ca_uint32_t aruser_pes           :  4 ; /* bits 19:16 */
    ca_uint32_t awuser_pes           :  4 ; /* bits 23:20 */
    ca_uint32_t wuser_pes            :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL_PE0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL1_PE0                    0x90303010
#define PE_CTRL_AXI_CTRL1_PE0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_pe            : 14 ; /* bits 13:0 */
    ca_uint32_t awuser_pe            : 14 ; /* bits 27:14 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL1_PE0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL_PE1                     0x90303014
#define PE_CTRL_AXI_CTRL_PE1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arqos_pe             :  4 ; /* bits 3:0 */
    ca_uint32_t awqos_pe             :  4 ; /* bits 7:4 */
    ca_uint32_t ruser_pe             :  4 ; /* bits 11:8 */
    ca_uint32_t buser_pe             :  4 ; /* bits 15:12 */
    ca_uint32_t aruser_pes           :  4 ; /* bits 19:16 */
    ca_uint32_t awuser_pes           :  4 ; /* bits 23:20 */
    ca_uint32_t wuser_pes            :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL_PE1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL1_PE1                    0x90303018
#define PE_CTRL_AXI_CTRL1_PE1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_pe            : 14 ; /* bits 13:0 */
    ca_uint32_t awuser_pe            : 14 ; /* bits 27:14 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL1_PE1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTERRUPT_0            0x9030301c
#define PE_CTRL_PE_QM_AGG_INTERRUPT_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8i    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9i    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10i   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11i   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12i   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13i   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIi :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOi :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTERRUPT_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTENABLE_0            0x90303020
#define PE_CTRL_PE_QM_AGG_INTENABLE_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8e    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9e    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10e   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11e   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12e   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13e   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIe :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOe :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTENABLE_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTERRUPT_0               0x90303024
#define PE_CTRL_PE_AGG_INTERRUPT_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1i     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1i     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1i     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1i     :  1 ; /* bits 7:7 */
    ca_uint32_t ipc_int_pe2i         :  1 ; /* bits 8:8 */
    ca_uint32_t XFI0_INTERRUPTi      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTi      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_10i :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTi       :  1 ; /* bits 12:12 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_11i :  1 ; /* bits 13:13 */
    ca_uint32_t IRQ_soft2iSeti       :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTERRUPT_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTENABLE_0               0x90303028
#define PE_CTRL_PE_AGG_INTENABLE_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1e     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1e     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1e     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1e     :  1 ; /* bits 7:7 */
    ca_uint32_t ipc_int_pe2e         :  1 ; /* bits 8:8 */
    ca_uint32_t XFI0_INTERRUPTe      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTe      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_10e :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTe       :  1 ; /* bits 12:12 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_11e :  1 ; /* bits 13:13 */
    ca_uint32_t IRQ_soft2iSete       :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTENABLE_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTERRUPT_1            0x9030302c
#define PE_CTRL_PE_QM_AGG_INTERRUPT_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8i    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9i    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10i   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11i   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12i   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13i   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIi :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOi :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTERRUPT_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTENABLE_1            0x90303030
#define PE_CTRL_PE_QM_AGG_INTENABLE_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8e    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9e    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10e   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11e   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12e   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13e   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIe :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOe :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTENABLE_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTERRUPT_1               0x90303034
#define PE_CTRL_PE_AGG_INTERRUPT_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1i     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1i     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1i     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1i     :  1 ; /* bits 7:7 */
    ca_uint32_t ipc_int_pe2i         :  1 ; /* bits 8:8 */
    ca_uint32_t XFI0_INTERRUPTi      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTi      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_10i :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTi       :  1 ; /* bits 12:12 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_11i :  1 ; /* bits 13:13 */
    ca_uint32_t IRQ_soft2iSeti       :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTERRUPT_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTENABLE_1               0x90303038
#define PE_CTRL_PE_AGG_INTENABLE_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1e     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1e     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1e     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1e     :  1 ; /* bits 7:7 */
    ca_uint32_t ipc_int_pe2e         :  1 ; /* bits 8:8 */
    ca_uint32_t XFI0_INTERRUPTe      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTe      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_10e :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTe       :  1 ; /* bits 12:12 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_11e :  1 ; /* bits 13:13 */
    ca_uint32_t IRQ_soft2iSete       :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTENABLE_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTERRUPT_2            0x9030303c
#define PE_CTRL_PE_QM_AGG_INTERRUPT_2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8i    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9i    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10i   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11i   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12i   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13i   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIi :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOi :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTERRUPT_2_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTENABLE_2            0x90303040
#define PE_CTRL_PE_QM_AGG_INTENABLE_2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8e    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9e    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10e   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11e   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12e   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13e   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIe :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOe :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTENABLE_2_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTERRUPT_2               0x90303044
#define PE_CTRL_PE_AGG_INTERRUPT_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1i     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1i     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1i     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1i     :  1 ; /* bits 7:7 */
    ca_uint32_t ipc_int_pe2i         :  1 ; /* bits 8:8 */
    ca_uint32_t XFI0_INTERRUPTi      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTi      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_10i :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTi       :  1 ; /* bits 12:12 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_11i :  1 ; /* bits 13:13 */
    ca_uint32_t IRQ_soft2iSeti       :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTERRUPT_2_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTENABLE_2               0x90303048
#define PE_CTRL_PE_AGG_INTENABLE_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1e     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1e     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1e     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1e     :  1 ; /* bits 7:7 */
    ca_uint32_t ipc_int_pe2e         :  1 ; /* bits 8:8 */
    ca_uint32_t XFI0_INTERRUPTe      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTe      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_10e :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTe       :  1 ; /* bits 12:12 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_11e :  1 ; /* bits 13:13 */
    ca_uint32_t IRQ_soft2iSete       :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTENABLE_2_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_DSS_CONFIG_0                  0x9030304c
#define PE_CTRL_PE_DSS_CONFIG_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dss_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t ro_sel               :  3 ; /* bits 3:1 */
    ca_uint32_t wire_sel             :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t speed_en             :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_DSS_CONFIG_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_DSS_STATUS_0                  0x90303050
#define PE_CTRL_PE_DSS_STATUS_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ready                :  1 ; /* bits 0:0 */
    ca_uint32_t count_out            : 20 ; /* bits 20:1 */
    ca_uint32_t wsort_go             :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_DSS_STATUS_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_DSS_CONFIG_1                  0x90303054
#define PE_CTRL_PE_DSS_CONFIG_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dss_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t ro_sel               :  3 ; /* bits 3:1 */
    ca_uint32_t wire_sel             :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t speed_en             :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_DSS_CONFIG_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_DSS_STATUS_1                  0x90303058
#define PE_CTRL_PE_DSS_STATUS_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ready                :  1 ; /* bits 0:0 */
    ca_uint32_t count_out            : 20 ; /* bits 20:1 */
    ca_uint32_t wsort_go             :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_DSS_STATUS_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPTO_PROT                      0x9030305c
#define PE_CTRL_CRYPTO_PROT_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t override_c0m         :  2 ; /* bits 1:0 */
    ca_uint32_t override_c1m         :  2 ; /* bits 3:2 */
    ca_uint32_t override_c0s         :  2 ; /* bits 5:4 */
    ca_uint32_t override_c1s         :  2 ; /* bits 7:6 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPTO_PROT_t;
#endif /* !__ASSEMBLER__ */

#define     override_c1s_PASS                             0x0
#define     override_c1s_OVSEC                            0x1
#define     override_c1s_OVNS                             0x2
#define     override_c0s_PASS                             0x0
#define     override_c0s_OVSEC                            0x1
#define     override_c0s_OVNS                             0x2
#define     override_c1m_PASS                             0x0
#define     override_c1m_OVSEC                            0x1
#define     override_c1m_OVNS                             0x2
#define     override_c0m_PASS                             0x0
#define     override_c0m_OVSEC                            0x1
#define     override_c0m_OVNS                             0x2

#define PE_CTRL_PE_BUS_DEBUG_CTRL                0x90303060
#define PE_CTRL_PE_BUS_DEBUG_CTRL_dft            0x0000fffc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cfg_timeout_axi      : 16 ; /* bits 15:0 */
    ca_uint32_t cfg_clr_fail_t_axi   :  1 ; /* bits 16:16 */
    ca_uint32_t cfg_clr_fail_r_axi   :  1 ; /* bits 17:17 */
    ca_uint32_t cfg_clr_debug_axi    :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cfg_debug_sel_axi    :  5 ; /* bits 24:20 */
    ca_uint32_t cfg_debug_sel_pe     :  4 ; /* bits 28:25 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_BUS_DEBUG_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_BUS_DEBUG_STATUS              0x90303064
#define PE_CTRL_PE_BUS_DEBUG_STATUS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_dbg_out          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_BUS_DEBUG_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPT1_SLV_ID                    0x90303068
#define PE_CTRL_CRYPT1_SLV_ID_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry0        :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry1        :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry2        :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry3        :  6 ; /* bits 23:18 */
    ca_uint32_t reg_id_en0           :  1 ; /* bits 24:24 */
    ca_uint32_t reg_id_en1           :  1 ; /* bits 25:25 */
    ca_uint32_t reg_id_en2           :  1 ; /* bits 26:26 */
    ca_uint32_t reg_id_en3           :  1 ; /* bits 27:27 */
    ca_uint32_t reg_enabled          :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPT1_SLV_ID_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPT1_SLV_ID_MASK               0x9030306c
#define PE_CTRL_CRYPT1_SLV_ID_MASK_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry_mask0   :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry_mask1   :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry_mask2   :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry_mask3   :  6 ; /* bits 23:18 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPT1_SLV_ID_MASK_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_SADB_SLV_ID                      0x90303070
#define PE_CTRL_SADB_SLV_ID_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry0        :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry1        :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry2        :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry3        :  6 ; /* bits 23:18 */
    ca_uint32_t reg_id_en0           :  1 ; /* bits 24:24 */
    ca_uint32_t reg_id_en1           :  1 ; /* bits 25:25 */
    ca_uint32_t reg_id_en2           :  1 ; /* bits 26:26 */
    ca_uint32_t reg_id_en3           :  1 ; /* bits 27:27 */
    ca_uint32_t reg_enabled          :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_SADB_SLV_ID_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_SADB_SLV_ID_MASK                 0x90303074
#define PE_CTRL_SADB_SLV_ID_MASK_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry_mask0   :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry_mask1   :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry_mask2   :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry_mask3   :  6 ; /* bits 23:18 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_SADB_SLV_ID_MASK_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE0_RM_0                         0x90303078
#define PE_CTRL_PE0_RM_0_dft                     0x00040810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IW0_LS_0             :  1 ; /* bits 0:0 */
    ca_uint32_t IW0_TEST1_0          :  1 ; /* bits 1:1 */
    ca_uint32_t IW0_RME_0            :  1 ; /* bits 2:2 */
    ca_uint32_t IW0_RM_0             :  4 ; /* bits 6:3 */
    ca_uint32_t DW1_DATA_LS_5        :  1 ; /* bits 7:7 */
    ca_uint32_t DW1_DATA_TEST1_5     :  1 ; /* bits 8:8 */
    ca_uint32_t DW1_DATA_RME_5       :  1 ; /* bits 9:9 */
    ca_uint32_t DW1_DATA_RM_5        :  4 ; /* bits 13:10 */
    ca_uint32_t DW0_LS_0             :  1 ; /* bits 14:14 */
    ca_uint32_t DW0_TEST1_0          :  1 ; /* bits 15:15 */
    ca_uint32_t DW0_RME_0            :  1 ; /* bits 16:16 */
    ca_uint32_t DW0_RM_0             :  4 ; /* bits 20:17 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE0_RM_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE0_RM_1                         0x9030307c
#define PE_CTRL_PE0_RM_1_dft                     0x00040810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t PHT_DATA_LS_8        :  1 ; /* bits 0:0 */
    ca_uint32_t PHT_DATA_TEST1_8     :  1 ; /* bits 1:1 */
    ca_uint32_t PHT_DATA_RME_8       :  1 ; /* bits 2:2 */
    ca_uint32_t PHT_DATA_RM_8        :  4 ; /* bits 6:3 */
    ca_uint32_t BTB_TAG_LS_1         :  1 ; /* bits 7:7 */
    ca_uint32_t BTB_TAG_TEST1_1      :  1 ; /* bits 8:8 */
    ca_uint32_t BTB_TAG_RME_1        :  1 ; /* bits 9:9 */
    ca_uint32_t BTB_TAG_RM_1         :  4 ; /* bits 13:10 */
    ca_uint32_t BTB_DATA_LS_0        :  1 ; /* bits 14:14 */
    ca_uint32_t BTB_DATA_TEST1_0     :  1 ; /* bits 15:15 */
    ca_uint32_t BTB_DATA_RME_0       :  1 ; /* bits 16:16 */
    ca_uint32_t BTB_DATA_RM_0        :  4 ; /* bits 20:17 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE0_RM_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE0_RM_2                         0x90303080
#define PE_CTRL_PE0_RM_2_dft                     0x00040810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IC_DATA_LS_3         :  1 ; /* bits 0:0 */
    ca_uint32_t IC_DATA_TEST1_3      :  1 ; /* bits 1:1 */
    ca_uint32_t IC_DATA_RME_3        :  1 ; /* bits 2:2 */
    ca_uint32_t IC_DATA_RM_3         :  4 ; /* bits 6:3 */
    ca_uint32_t IC_TAG_LS_7          :  1 ; /* bits 7:7 */
    ca_uint32_t IC_TAG_TEST1_7       :  1 ; /* bits 8:8 */
    ca_uint32_t IC_TAG_RME_7         :  1 ; /* bits 9:9 */
    ca_uint32_t IC_TAG_RM_7          :  4 ; /* bits 13:10 */
    ca_uint32_t IC_LRU_LS_6          :  1 ; /* bits 14:14 */
    ca_uint32_t IC_LRU_TEST1_6       :  1 ; /* bits 15:15 */
    ca_uint32_t IC_LRU_RME_6         :  1 ; /* bits 16:16 */
    ca_uint32_t IC_LRU_RM_6          :  4 ; /* bits 20:17 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE0_RM_2_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE0_RM_3                         0x90303084
#define PE_CTRL_PE0_RM_3_dft                     0x00000810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t DC_DATA_LS_2         :  1 ; /* bits 0:0 */
    ca_uint32_t DC_DATA_TEST1_2      :  1 ; /* bits 1:1 */
    ca_uint32_t DC_DATA_RME_2        :  1 ; /* bits 2:2 */
    ca_uint32_t DC_DATA_RM_2         :  4 ; /* bits 6:3 */
    ca_uint32_t DC_TAG_LS_4          :  1 ; /* bits 7:7 */
    ca_uint32_t DC_TAG_TEST1_4       :  1 ; /* bits 8:8 */
    ca_uint32_t DC_TAG_RME_4         :  1 ; /* bits 9:9 */
    ca_uint32_t DC_TAG_RM_4          :  4 ; /* bits 13:10 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE0_RM_3_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_SADB_RM                          0x90303088
#define PE_CTRL_SADB_RM_dft                      0x00022222

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sadb_sramtest        : 16 ; /* bits 15:0 */
    ca_uint32_t pel2_sramtest        :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_SADB_RM_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPTO1_RM1                      0x9030308c
#define PE_CTRL_CRYPTO1_RM1_dft                  0x00002222

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crypto1_sramtest1    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPTO1_RM1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPTO1_RM0                      0x90303090
#define PE_CTRL_CRYPTO1_RM0_dft                  0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crypto1_sramtest0    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPTO1_RM0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPTO2_RM                       0x90303094
#define PE_CTRL_CRYPTO2_RM_dft                   0x00000022

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crypto2_sramtest     :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPTO2_RM_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_LS                            0x90303098
#define PE_CTRL_PE_LS_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t capsram_repair_sramls :  4 ; /* bits 3:0 */
    ca_uint32_t crypto0_1_sramls     :  6 ; /* bits 9:4 */
    ca_uint32_t crypto1_1_sramls     :  6 ; /* bits 15:10 */
    ca_uint32_t crypto0_2_sramls     :  2 ; /* bits 17:16 */
    ca_uint32_t crypto1_2_sramls     :  2 ; /* bits 19:18 */
    ca_uint32_t ldma_sramls          :  2 ; /* bits 21:20 */
    ca_uint32_t sadb_sramls          :  2 ; /* bits 23:22 */
    ca_uint32_t pel2_sramls          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_LS_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_DOES_ADDR_CONFIG                 0x9030309c
#define PE_CTRL_DOES_ADDR_CONFIG_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t does_addr_val        : 16 ; /* bits 15:0 */
    ca_uint32_t does_addr_mask       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_DOES_ADDR_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL_DOE                     0x903030a0
#define PE_CTRL_AXI_CTRL_DOE_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arqos_pe             :  4 ; /* bits 3:0 */
    ca_uint32_t awqos_pe             :  4 ; /* bits 7:4 */
    ca_uint32_t ruser_pe             :  4 ; /* bits 11:8 */
    ca_uint32_t buser_pe             :  4 ; /* bits 15:12 */
    ca_uint32_t aruser_pes           :  4 ; /* bits 19:16 */
    ca_uint32_t awuser_pes           :  4 ; /* bits 23:20 */
    ca_uint32_t wuser_pes            :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL_DOE_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL1_DOE                    0x903030a4
#define PE_CTRL_AXI_CTRL1_DOE_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_pe            : 14 ; /* bits 13:0 */
    ca_uint32_t awuser_pe            : 14 ; /* bits 27:14 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL1_DOE_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE1_RM_0                         0x903030a8
#define PE_CTRL_PE1_RM_0_dft                     0x00040810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IW0_LS_0             :  1 ; /* bits 0:0 */
    ca_uint32_t IW0_TEST1_0          :  1 ; /* bits 1:1 */
    ca_uint32_t IW0_RME_0            :  1 ; /* bits 2:2 */
    ca_uint32_t IW0_RM_0             :  4 ; /* bits 6:3 */
    ca_uint32_t DW1_DATA_LS_5        :  1 ; /* bits 7:7 */
    ca_uint32_t DW1_DATA_TEST1_5     :  1 ; /* bits 8:8 */
    ca_uint32_t DW1_DATA_RME_5       :  1 ; /* bits 9:9 */
    ca_uint32_t DW1_DATA_RM_5        :  4 ; /* bits 13:10 */
    ca_uint32_t DW0_LS_0             :  1 ; /* bits 14:14 */
    ca_uint32_t DW0_TEST1_0          :  1 ; /* bits 15:15 */
    ca_uint32_t DW0_RME_0            :  1 ; /* bits 16:16 */
    ca_uint32_t DW0_RM_0             :  4 ; /* bits 20:17 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE1_RM_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE1_RM_1                         0x903030ac
#define PE_CTRL_PE1_RM_1_dft                     0x00040810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t PHT_DATA_LS_8        :  1 ; /* bits 0:0 */
    ca_uint32_t PHT_DATA_TEST1_8     :  1 ; /* bits 1:1 */
    ca_uint32_t PHT_DATA_RME_8       :  1 ; /* bits 2:2 */
    ca_uint32_t PHT_DATA_RM_8        :  4 ; /* bits 6:3 */
    ca_uint32_t BTB_TAG_LS_1         :  1 ; /* bits 7:7 */
    ca_uint32_t BTB_TAG_TEST1_1      :  1 ; /* bits 8:8 */
    ca_uint32_t BTB_TAG_RME_1        :  1 ; /* bits 9:9 */
    ca_uint32_t BTB_TAG_RM_1         :  4 ; /* bits 13:10 */
    ca_uint32_t BTB_DATA_LS_0        :  1 ; /* bits 14:14 */
    ca_uint32_t BTB_DATA_TEST1_0     :  1 ; /* bits 15:15 */
    ca_uint32_t BTB_DATA_RME_0       :  1 ; /* bits 16:16 */
    ca_uint32_t BTB_DATA_RM_0        :  4 ; /* bits 20:17 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE1_RM_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE1_RM_2                         0x903030b0
#define PE_CTRL_PE1_RM_2_dft                     0x00040810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IC_DATA_LS_3         :  1 ; /* bits 0:0 */
    ca_uint32_t IC_DATA_TEST1_3      :  1 ; /* bits 1:1 */
    ca_uint32_t IC_DATA_RME_3        :  1 ; /* bits 2:2 */
    ca_uint32_t IC_DATA_RM_3         :  4 ; /* bits 6:3 */
    ca_uint32_t IC_TAG_LS_7          :  1 ; /* bits 7:7 */
    ca_uint32_t IC_TAG_TEST1_7       :  1 ; /* bits 8:8 */
    ca_uint32_t IC_TAG_RME_7         :  1 ; /* bits 9:9 */
    ca_uint32_t IC_TAG_RM_7          :  4 ; /* bits 13:10 */
    ca_uint32_t IC_LRU_LS_6          :  1 ; /* bits 14:14 */
    ca_uint32_t IC_LRU_TEST1_6       :  1 ; /* bits 15:15 */
    ca_uint32_t IC_LRU_RME_6         :  1 ; /* bits 16:16 */
    ca_uint32_t IC_LRU_RM_6          :  4 ; /* bits 20:17 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE1_RM_2_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE1_RM_3                         0x903030b4
#define PE_CTRL_PE1_RM_3_dft                     0x00000810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t DC_DATA_LS_2         :  1 ; /* bits 0:0 */
    ca_uint32_t DC_DATA_TEST1_2      :  1 ; /* bits 1:1 */
    ca_uint32_t DC_DATA_RME_2        :  1 ; /* bits 2:2 */
    ca_uint32_t DC_DATA_RM_2         :  4 ; /* bits 6:3 */
    ca_uint32_t DC_TAG_LS_4          :  1 ; /* bits 7:7 */
    ca_uint32_t DC_TAG_TEST1_4       :  1 ; /* bits 8:8 */
    ca_uint32_t DC_TAG_RME_4         :  1 ; /* bits 9:9 */
    ca_uint32_t DC_TAG_RM_4          :  4 ; /* bits 13:10 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE1_RM_3_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_DOE_RM_0                         0x903030b8
#define PE_CTRL_DOE_RM_0_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IW0_DATA_LS_3        :  1 ; /* bits 0:0 */
    ca_uint32_t IW0_DATA_TEST1_3     :  1 ; /* bits 1:1 */
    ca_uint32_t IW0_DATA_RME_3       :  1 ; /* bits 2:2 */
    ca_uint32_t IW0_DATA_RM_3        :  4 ; /* bits 6:3 */
    ca_uint32_t DW0_DATA_LS_2        :  1 ; /* bits 7:7 */
    ca_uint32_t DW0_DATA_TEST1_2     :  1 ; /* bits 8:8 */
    ca_uint32_t DW0_DATA_RME_2       :  1 ; /* bits 9:9 */
    ca_uint32_t DW0_DATA_RM_2        :  4 ; /* bits 13:10 */
    ca_uint32_t IW0_DATA_LS_1        :  1 ; /* bits 14:14 */
    ca_uint32_t IW0_DATA_TEST1_1     :  1 ; /* bits 15:15 */
    ca_uint32_t IW0_DATA_RME_1       :  1 ; /* bits 16:16 */
    ca_uint32_t IW0_DATA_RM_1        :  4 ; /* bits 20:17 */
    ca_uint32_t DW0_DATA_LS_0        :  1 ; /* bits 21:21 */
    ca_uint32_t DW0_DATA_TEST1_0     :  1 ; /* bits 22:22 */
    ca_uint32_t DW0_DATA_RME_0       :  1 ; /* bits 23:23 */
    ca_uint32_t DW0_DATA_RM_0        :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_DOE_RM_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_DOE_RM_1                         0x903030bc
#define PE_CTRL_DOE_RM_1_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t PHT_DATA_LS_11       :  1 ; /* bits 0:0 */
    ca_uint32_t PHT_DATA_TEST1_11    :  1 ; /* bits 1:1 */
    ca_uint32_t PHT_DATA_RME_11      :  1 ; /* bits 2:2 */
    ca_uint32_t PHT_DATA_RM_11       :  4 ; /* bits 6:3 */
    ca_uint32_t BTB_DATA_LS_7        :  1 ; /* bits 7:7 */
    ca_uint32_t BTB_DATA_TEST1_7     :  1 ; /* bits 8:8 */
    ca_uint32_t BTB_DATA_RME_7       :  1 ; /* bits 9:9 */
    ca_uint32_t BTB_DATA_RM_7        :  4 ; /* bits 13:10 */
    ca_uint32_t BTB_TAG_LS_4         :  1 ; /* bits 14:14 */
    ca_uint32_t BTB_TAG_TEST1_4      :  1 ; /* bits 15:15 */
    ca_uint32_t BTB_TAG_RME_4        :  1 ; /* bits 16:16 */
    ca_uint32_t BTB_TAG_RM_4         :  4 ; /* bits 20:17 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_DOE_RM_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_DOE_RM_2                         0x903030c0
#define PE_CTRL_DOE_RM_2_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IC_LRU_LS_10         :  1 ; /* bits 0:0 */
    ca_uint32_t IC_LRU_TEST1_10      :  1 ; /* bits 1:1 */
    ca_uint32_t IC_LRU_RME_10        :  1 ; /* bits 2:2 */
    ca_uint32_t IC_LRU_RM_10         :  4 ; /* bits 6:3 */
    ca_uint32_t IC_TAG_LS_9          :  1 ; /* bits 7:7 */
    ca_uint32_t IC_TAG_TEST1_9       :  1 ; /* bits 8:8 */
    ca_uint32_t IC_TAG_RME_9         :  1 ; /* bits 9:9 */
    ca_uint32_t IC_TAG_RM_9          :  4 ; /* bits 13:10 */
    ca_uint32_t IC_DATA_LS_6         :  1 ; /* bits 14:14 */
    ca_uint32_t IC_DATA_TEST1_6      :  1 ; /* bits 15:15 */
    ca_uint32_t IC_DATA_RME_6        :  1 ; /* bits 16:16 */
    ca_uint32_t IC_DATA_RM_6         :  4 ; /* bits 20:17 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_DOE_RM_2_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_DOE_RM_3                         0x903030c4
#define PE_CTRL_DOE_RM_3_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t DC_TAG_LS_8          :  1 ; /* bits 0:0 */
    ca_uint32_t DC_TAG_TEST1_8       :  1 ; /* bits 1:1 */
    ca_uint32_t DC_TAG_RME_8         :  1 ; /* bits 2:2 */
    ca_uint32_t DC_TAG_RM_8          :  4 ; /* bits 6:3 */
    ca_uint32_t DC_DATA_LS_5         :  1 ; /* bits 7:7 */
    ca_uint32_t DC_DATA_TEST1_5      :  1 ; /* bits 8:8 */
    ca_uint32_t DC_DATA_RME_5        :  1 ; /* bits 9:9 */
    ca_uint32_t DC_DATA_RM_5         :  4 ; /* bits 13:10 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_DOE_RM_3_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      
    
  
        

/*
 * APB0
 */
  
/*
 * NE_L23
 */
  
/*
 * L2FE
 */
  
/*
 * GLB
 */
        
#define L2FE_GLB_VER_CTRL                        0xf4301000
#define L2FE_GLB_VER_CTRL_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rev_id               : 16 ; /* bits 15:0 */
    ca_uint32_t ver_id               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_VER_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_CTRL                            0xf4301004
#define L2FE_GLB_CTRL_dft                        0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t soft_reset           :  1 ; /* bits 0:0 */
    ca_uint32_t pipeline_clk_num     :  5 ; /* bits 5:1 */
    ca_uint32_t change_ip_if_pop_en  :  1 ; /* bits 6:6 */
    ca_uint32_t qos_enhance_mode     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_INTERRUPT                       0xf4301008
#define L2FE_GLB_INTERRUPT_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lf_overflow_intI     :  1 ; /* bits 1:1 */
    ca_uint32_t ple_hd_ff_overflow_intI :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t port_mac_lmt_excd_intI :  1 ; /* bits 8:8 */
    ca_uint32_t l2e_hash_collision_intI :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_INTERRUPTE                      0xf430100c
#define L2FE_GLB_INTERRUPTE_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lf_overflow_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t ple_hd_ff_overflow_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t port_mac_lmt_excd_intIE :  1 ; /* bits 8:8 */
    ca_uint32_t l2e_hash_collision_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_STTS                            0xf4301010
#define L2FE_GLB_STTS_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2fe_init_done       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_STTS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_CFG_SPARE                  0xf4301014
#define L2FE_GLB_L2FE_CFG_SPARE_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bit                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_CFG_SPARE_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_STTS_SPARE                 0xf4301018
#define L2FE_GLB_L2FE_STTS_SPARE_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bit                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_STTS_SPARE_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_0             0xf430101c
#define L2FE_GLB_SRAM_TEST_CONTROL_0_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_1             0xf4301020
#define L2FE_GLB_SRAM_TEST_CONTROL_1_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_2             0xf4301024
#define L2FE_GLB_SRAM_TEST_CONTROL_2_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_3             0xf4301028
#define L2FE_GLB_SRAM_TEST_CONTROL_3_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_4             0xf430102c
#define L2FE_GLB_SRAM_TEST_CONTROL_4_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_5             0xf4301030
#define L2FE_GLB_SRAM_TEST_CONTROL_5_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_6             0xf4301034
#define L2FE_GLB_SRAM_TEST_CONTROL_6_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_7             0xf4301038
#define L2FE_GLB_SRAM_TEST_CONTROL_7_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_8             0xf430103c
#define L2FE_GLB_SRAM_TEST_CONTROL_8_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_8_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_9             0xf4301040
#define L2FE_GLB_SRAM_TEST_CONTROL_9_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_9_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_10            0xf4301044
#define L2FE_GLB_SRAM_TEST_CONTROL_10_dft        0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_10_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_11            0xf4301048
#define L2FE_GLB_SRAM_TEST_CONTROL_11_dft        0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_11_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_12            0xf430104c
#define L2FE_GLB_SRAM_TEST_CONTROL_12_dft        0x00020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t reserved3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_12_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_LS_CONTROL_1               0xf4301050
#define L2FE_GLB_SRAM_LS_CONTROL_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2fe4_sramls         :  7 ; /* bits 6:0 */
    ca_uint32_t l2fe5_sramls         :  9 ; /* bits 15:7 */
    ca_uint32_t l2fe6_sramls         :  6 ; /* bits 21:16 */
    ca_uint32_t l2fe7_sramls         :  2 ; /* bits 23:22 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_LS_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_LS_CONTROL_0               0xf4301054
#define L2FE_GLB_SRAM_LS_CONTROL_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2fe1_sramls         : 12 ; /* bits 11:0 */
    ca_uint32_t l2fe2_sramls         :  1 ; /* bits 12:12 */
    ca_uint32_t l2fe2_tcam_sramls    :  2 ; /* bits 14:13 */
    ca_uint32_t l2fe3_sramls         : 12 ; /* bits 26:15 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_LS_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_MONITOR_TRIG               0xf4301058
#define L2FE_GLB_L2FE_MONITOR_TRIG_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_MONITOR_TRIG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_MONITOR_CTRL               0xf430105c
#define L2FE_GLB_L2FE_MONITOR_CTRL_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_MONITOR_RETURN             0xf4301060
#define L2FE_GLB_L2FE_MONITOR_RETURN_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_DEBUG                           0xf4301064
#define L2FE_GLB_DEBUG_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t plx_bus_sel          :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_DEBUG_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PP
 */
        
#define L2FE_PP_PPID_ATTR_CFG                    0xf4301100
#define L2FE_PP_PPID_ATTR_CFG_dft                0x009d0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ppid0                :  2 ; /* bits 1:0 */
    ca_uint32_t ppid1                :  2 ; /* bits 3:2 */
    ca_uint32_t ppid2                :  2 ; /* bits 5:4 */
    ca_uint32_t ppid3                :  2 ; /* bits 7:6 */
    ca_uint32_t ppid4                :  2 ; /* bits 9:8 */
    ca_uint32_t ppid5                :  2 ; /* bits 11:10 */
    ca_uint32_t ppid6                :  2 ; /* bits 13:12 */
    ca_uint32_t ppid7                :  2 ; /* bits 15:14 */
    ca_uint32_t ppid8                :  2 ; /* bits 17:16 */
    ca_uint32_t ppid9                :  2 ; /* bits 19:18 */
    ca_uint32_t ppid10               :  2 ; /* bits 21:20 */
    ca_uint32_t ppid11               :  2 ; /* bits 23:22 */
    ca_uint32_t ppid12               :  2 ; /* bits 25:24 */
    ca_uint32_t ppid13               :  2 ; /* bits 27:26 */
    ca_uint32_t ppid14               :  2 ; /* bits 29:28 */
    ca_uint32_t ppid15               :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PPID_ATTR_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DPB_CTRL                         0xf4301104
#define L2FE_PP_DPB_CTRL_dft                     0x00000003

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_pattern        :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_TPID_CMP_S                       0xf4301108
#define L2FE_PP_TPID_CMP_S_dft                   0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_S_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_TPID_CMP_C                       0xf430110c
#define L2FE_PP_TPID_CMP_C_dft                   0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_C_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_TPID_CMP_O                       0xf4301110
#define L2FE_PP_TPID_CMP_O_dft                   0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_O_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_TPID_CMP_USER                    0xf4301114
#define L2FE_PP_TPID_CMP_USER_dft                0x00009100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_USER_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HELLO_PKT_ENABLE_DA_LOW          0xf4301118
#define L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_dft      0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HELLO_PKT_ENABLE_DA_HI           0xf430111c
#define L2FE_PP_HELLO_PKT_ENABLE_DA_HI_dft       0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HELLO_PKT_DA_LOW                 0xf4301120
#define L2FE_PP_HELLO_PKT_DA_LOW_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_DA_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HELLO_PKT_DA_HI                  0xf4301124
#define L2FE_PP_HELLO_PKT_DA_HI_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_DA_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_ENABLE_DA_0_LOW          0xf4301128
#define L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_dft      0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_ENABLE_DA_0_HI           0xf430112c
#define L2FE_PP_SPECIAL_ENABLE_DA_0_HI_dft       0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_DA_0_LOW                 0xf4301130
#define L2FE_PP_SPECIAL_DA_0_LOW_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_0_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_DA_0_HI                  0xf4301134
#define L2FE_PP_SPECIAL_DA_0_HI_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_0_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_EV2PT                    0xf4301138
#define L2FE_PP_SPECIAL_EV2PT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ev2pt                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_EV2PT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_ENABLE_DA_1_LOW          0xf430113c
#define L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_dft      0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_ENABLE_DA_1_HI           0xf4301140
#define L2FE_PP_SPECIAL_ENABLE_DA_1_HI_dft       0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_DA_1_LOW                 0xf4301144
#define L2FE_PP_SPECIAL_DA_1_LOW_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_1_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_DA_1_HI                  0xf4301148
#define L2FE_PP_SPECIAL_DA_1_HI_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_1_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_VLAN                     0xf430114c
#define L2FE_PP_SPECIAL_VLAN_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vlan                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_VLAN_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_LOW                       0xf4301150
#define L2FE_PP_MY_MAC_LOW_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_HI                        0xf4301154
#define L2FE_PP_MY_MAC_HI_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_ENABLE_LOW                0xf4301158
#define L2FE_PP_MY_MAC_ENABLE_LOW_dft            0x00ffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_ENABLE_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_LOW_1                     0xf430115c
#define L2FE_PP_MY_MAC_LOW_1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_LOW_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_HI_1                      0xf4301160
#define L2FE_PP_MY_MAC_HI_1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_HI_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_ENABLE_LOW_1              0xf4301164
#define L2FE_PP_MY_MAC_ENABLE_LOW_1_dft          0x00ffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_ENABLE_LOW_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_MAC_MC_LOW                   0xf4301168
#define L2FE_PP_RSV_MAC_MC_LOW_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_MAC_MC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_MAC_MC_HI                    0xf430116c
#define L2FE_PP_RSV_MAC_MC_HI_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_MAC_MC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_ENABLE_MC_LOW                0xf4301170
#define L2FE_PP_RSV_ENABLE_MC_LOW_dft            0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_ENABLE_MC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_ENABLE_MC_HI                 0xf4301174
#define L2FE_PP_RSV_ENABLE_MC_HI_dft             0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_ENABLE_MC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_GROUP_MAC_LOW                0xf4301178
#define L2FE_PP_RSV_GROUP_MAC_LOW_dft            0xc2000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_GROUP_MAC_HI                 0xf430117c
#define L2FE_PP_RSV_GROUP_MAC_HI_dft             0x00000180

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_MAC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_GROUP_ENABLE_LOW             0xf4301180
#define L2FE_PP_RSV_GROUP_ENABLE_LOW_dft         0xfffffff0

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_ENABLE_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_GROUP_ENABLE_HI              0xf4301184
#define L2FE_PP_RSV_GROUP_ENABLE_HI_dft          0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_ENABLE_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_MAC_0_LOW                0xf4301188
#define L2FE_PP_MEF_OAM_MAC_0_LOW_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_0_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_MAC_0_HI                 0xf430118c
#define L2FE_PP_MEF_OAM_MAC_0_HI_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_0_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_TYPE_0                   0xf4301190
#define L2FE_PP_MEF_OAM_TYPE_0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_TYPE_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_MAC_1_LOW                0xf4301194
#define L2FE_PP_MEF_OAM_MAC_1_LOW_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_1_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_MAC_1_HI                 0xf4301198
#define L2FE_PP_MEF_OAM_MAC_1_HI_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_1_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_TYPE_1                   0xf430119c
#define L2FE_PP_MEF_OAM_TYPE_1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_TYPE_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_L7_OFFSET                        0xf43011a0
#define L2FE_PP_L7_OFFSET_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t offset               :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_L7_OFFSET_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_ERR_STTS_0               0xf43011a4
#define L2FE_PP_NI_INTF_ERR_STTS_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sop_eop_mismatch_0   :  1 ; /* bits 0:0 */
    ca_uint32_t sop_eop_mismatch_1   :  1 ; /* bits 1:1 */
    ca_uint32_t sop_eop_mismatch_2   :  1 ; /* bits 2:2 */
    ca_uint32_t sop_eop_mismatch_3   :  1 ; /* bits 3:3 */
    ca_uint32_t sop_eop_mismatch_4   :  1 ; /* bits 4:4 */
    ca_uint32_t sop_eop_mismatch_5   :  1 ; /* bits 5:5 */
    ca_uint32_t sop_eop_mismatch_6   :  1 ; /* bits 6:6 */
    ca_uint32_t sop_eop_mismatch_7   :  1 ; /* bits 7:7 */
    ca_uint32_t sop_eop_mismatch_8   :  1 ; /* bits 8:8 */
    ca_uint32_t sop_eop_mismatch_9   :  1 ; /* bits 9:9 */
    ca_uint32_t sop_eop_mismatch_10  :  1 ; /* bits 10:10 */
    ca_uint32_t sop_eop_mismatch_11  :  1 ; /* bits 11:11 */
    ca_uint32_t sop_eop_mismatch_12  :  1 ; /* bits 12:12 */
    ca_uint32_t sop_eop_mismatch_13  :  1 ; /* bits 13:13 */
    ca_uint32_t sop_eop_mismatch_14  :  1 ; /* bits 14:14 */
    ca_uint32_t sop_eop_mismatch_15  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_ERR_STTS_1               0xf43011a8
#define L2FE_PP_NI_INTF_ERR_STTS_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t runt_l2_pkt_0        :  1 ; /* bits 0:0 */
    ca_uint32_t runt_l2_pkt_1        :  1 ; /* bits 1:1 */
    ca_uint32_t runt_l2_pkt_2        :  1 ; /* bits 2:2 */
    ca_uint32_t runt_l2_pkt_3        :  1 ; /* bits 3:3 */
    ca_uint32_t runt_l2_pkt_4        :  1 ; /* bits 4:4 */
    ca_uint32_t runt_l2_pkt_5        :  1 ; /* bits 5:5 */
    ca_uint32_t runt_l2_pkt_6        :  1 ; /* bits 6:6 */
    ca_uint32_t runt_l2_pkt_7        :  1 ; /* bits 7:7 */
    ca_uint32_t runt_l2_pkt_8        :  1 ; /* bits 8:8 */
    ca_uint32_t runt_l2_pkt_9        :  1 ; /* bits 9:9 */
    ca_uint32_t runt_l2_pkt_10       :  1 ; /* bits 10:10 */
    ca_uint32_t runt_l2_pkt_11       :  1 ; /* bits 11:11 */
    ca_uint32_t runt_l2_pkt_12       :  1 ; /* bits 12:12 */
    ca_uint32_t runt_l2_pkt_13       :  1 ; /* bits 13:13 */
    ca_uint32_t runt_l2_pkt_14       :  1 ; /* bits 14:14 */
    ca_uint32_t runt_l2_pkt_15       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_ERR_STTS_2               0xf43011ac
#define L2FE_PP_NI_INTF_ERR_STTS_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sob_eob_mismatch_0   :  1 ; /* bits 0:0 */
    ca_uint32_t sob_eob_mismatch_1   :  1 ; /* bits 1:1 */
    ca_uint32_t sob_eob_mismatch_2   :  1 ; /* bits 2:2 */
    ca_uint32_t sob_eob_mismatch_3   :  1 ; /* bits 3:3 */
    ca_uint32_t sob_eob_mismatch_4   :  1 ; /* bits 4:4 */
    ca_uint32_t sob_eob_mismatch_5   :  1 ; /* bits 5:5 */
    ca_uint32_t sob_eob_mismatch_6   :  1 ; /* bits 6:6 */
    ca_uint32_t sob_eob_mismatch_7   :  1 ; /* bits 7:7 */
    ca_uint32_t sob_eob_mismatch_8   :  1 ; /* bits 8:8 */
    ca_uint32_t sob_eob_mismatch_9   :  1 ; /* bits 9:9 */
    ca_uint32_t sob_eob_mismatch_10  :  1 ; /* bits 10:10 */
    ca_uint32_t sob_eob_mismatch_11  :  1 ; /* bits 11:11 */
    ca_uint32_t sob_eob_mismatch_12  :  1 ; /* bits 12:12 */
    ca_uint32_t sob_eob_mismatch_13  :  1 ; /* bits 13:13 */
    ca_uint32_t sob_eob_mismatch_14  :  1 ; /* bits 14:14 */
    ca_uint32_t sob_eob_mismatch_15  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_ERR_STTS_3               0xf43011b0
#define L2FE_PP_NI_INTF_ERR_STTS_3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sop_2_sop_gap        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_PINGPONG_STS                     0xf43011b4
#define L2FE_PP_PINGPONG_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_STS                      0xf43011b8
#define L2FE_PP_NI_INTF_STS_dft                  0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdy                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_DROP_CNT                 0xf43011bc
#define L2FE_PP_NI_INTF_DROP_CNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t drop                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_DROP_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_PKT_CNT                  0xf43011c0
#define L2FE_PP_NI_INTF_PKT_CNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eop                  : 16 ; /* bits 15:0 */
    ca_uint32_t sop                  : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HEADER_A_LOW                     0xf43011c4
#define L2FE_PP_HEADER_A_LOW_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HEADER_A_MID                     0xf43011c8
#define L2FE_PP_HEADER_A_MID_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_MID_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HEADER_A_HI                      0xf43011cc
#define L2FE_PP_HEADER_A_HI_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_PARSER_CTRL                      0xf43011d0
#define L2FE_PP_PARSER_CTRL_dft                  0xa03b0400

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t arp_ipv6_en          :  1 ; /* bits 10:10 */
    ca_uint32_t vlan_ext_mode        :  1 ; /* bits 11:11 */
    ca_uint32_t my_mac_det_range_mode :  1 ; /* bits 12:12 */
    ca_uint32_t arp_op_filter_dis    :  1 ; /* bits 13:13 */
    ca_uint32_t use_ip_addr_mc       :  1 ; /* bits 14:14 */
    ca_uint32_t l3fe_to_l2fe_lrn_ctrl :  1 ; /* bits 15:15 */
    ca_uint32_t egr_ptp_pkt_no_drop_set :  1 ; /* bits 16:16 */
    ca_uint32_t ipv4_checksum_check_enable :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t detect_oam_subtype   :  1 ; /* bits 19:19 */
    ca_uint32_t oam_subtype          :  8 ; /* bits 27:20 */
    ca_uint32_t udf0_det_en          :  1 ; /* bits 28:28 */
    ca_uint32_t udf0_det_type_en     :  1 ; /* bits 29:29 */
    ca_uint32_t udf1_det_en          :  1 ; /* bits 30:30 */
    ca_uint32_t udf1_det_vlan_en     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PARSER_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_PKT                      0xf43011d4
#define L2FE_PP_SPECIAL_PKT_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_PKT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DEBUG_BUS                        0xf43011d8
#define L2FE_PP_DEBUG_BUS_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t ni2fe_pkt_cnt_wrap_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_IPPB_ACCESS                      0xf43011dc
#define L2FE_PP_IPPB_ACCESS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_IPPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_IPPB_DATA                        0xf43011e0
#define L2FE_PP_IPPB_DATA_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_IPPB_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_ACCESS                      0xf43011e4
#define L2FE_PP_ILPB_ACCESS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA4                       0xf43011e8
#define L2FE_PP_ILPB_DATA4_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_unkwn_pol_mode  :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_well_known_mc_idx :  5 ; /* bits 5:1 */
    ca_uint32_t ilpb_well_known_mc_det_en :  1 ; /* bits 6:6 */
    ca_uint32_t ilpb_rxqos_idx       :  3 ; /* bits 9:7 */
    ca_uint32_t ilpb_wan_ind         :  1 ; /* bits 10:10 */
    ca_uint32_t ilpb_cp_port         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA3                       0xf43011ec
#define L2FE_PP_ILPB_DATA3_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_vlan_cmd_sel_bm :  2 ; /* bits 1:0 */
    ca_uint32_t ilpb_sc_ind          :  1 ; /* bits 2:2 */
    ca_uint32_t ilpb_default_vlanid  : 12 ; /* bits 14:3 */
    ca_uint32_t ilpb_unkwn_pol_idx   :  3 ; /* bits 17:15 */
    ca_uint32_t ilpb_flowid_as_gemid :  1 ; /* bits 18:18 */
    ca_uint32_t ilpb_gemid_dynamic_mode :  1 ; /* bits 19:19 */
    ca_uint32_t ilpb_sa_miss_fwd     :  1 ; /* bits 20:20 */
    ca_uint32_t ilpb_sa_lmt_excd_drop :  1 ; /* bits 21:21 */
    ca_uint32_t ilpb_reserved_1      : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA2                       0xf43011f0
#define L2FE_PP_ILPB_DATA2_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_stp_mode        :  2 ; /* bits 1:0 */
    ca_uint32_t ilpb_other_tpid_match :  4 ; /* bits 5:2 */
    ca_uint32_t ilpb_inner_c_tpid_enable :  1 ; /* bits 6:6 */
    ca_uint32_t ilpb_inner_s_tpid_enable :  1 ; /* bits 7:7 */
    ca_uint32_t ilpb_top_c_tpid_enable :  1 ; /* bits 8:8 */
    ca_uint32_t ilpb_top_s_tpid_enable :  1 ; /* bits 9:9 */
    ca_uint32_t ilpb_c_tpid_match    :  4 ; /* bits 13:10 */
    ca_uint32_t ilpb_s_tpid_match    :  4 ; /* bits 17:14 */
    ca_uint32_t ilpb_drop_doubletagged_packet :  1 ; /* bits 18:18 */
    ca_uint32_t ilpb_drop_prytagged_packet :  1 ; /* bits 19:19 */
    ca_uint32_t ilpb_drop_untagged_packet :  1 ; /* bits 20:20 */
    ca_uint32_t ilpb_drop_ctag_packet :  1 ; /* bits 21:21 */
    ca_uint32_t ilpb_drop_stag_packet :  1 ; /* bits 22:22 */
    ca_uint32_t ilpb_drop_singletagged_packet :  1 ; /* bits 23:23 */
    ca_uint32_t ilpb_default_noninnertag_cmd :  1 ; /* bits 24:24 */
    ca_uint32_t ilpb_inner_vlan_cmd  :  2 ; /* bits 26:25 */
    ca_uint32_t ilpb_inner_vid_sel_bm :  2 ; /* bits 28:27 */
    ca_uint32_t ilpb_default_untag_cmd :  1 ; /* bits 29:29 */
    ca_uint32_t ilpb_default_top_vlan_cmd :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA1                       0xf43011f4
#define L2FE_PP_ILPB_DATA1_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_802_1p_mark_control_bm :  3 ; /* bits 2:0 */
    ca_uint32_t ilpb_change_1p_if_pop :  1 ; /* bits 3:3 */
    ca_uint32_t ilpb_top_802_1p_mode_sel :  2 ; /* bits 5:4 */
    ca_uint32_t ilpb_flowid_sel_bm   :  3 ; /* bits 8:6 */
    ca_uint32_t ilpb_cls_length      :  6 ; /* bits 14:9 */
    ca_uint32_t ilpb_cls_start       :  8 ; /* bits 22:15 */
    ca_uint32_t ilpb_igr_cls_lookup_en :  1 ; /* bits 23:23 */
    ca_uint32_t ilpb_spcl_pkt_idx    :  4 ; /* bits 27:24 */
    ca_uint32_t ilpb_da_sa_swap_en   :  1 ; /* bits 28:28 */
    ca_uint32_t ilpb_loop_enable     :  1 ; /* bits 29:29 */
    ca_uint32_t ilpb_sa_move_dis_fwd :  1 ; /* bits 30:30 */
    ca_uint32_t ilpb_station_move_en :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA0                       0xf43011f8
#define L2FE_PP_ILPB_DATA0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_dflt_premark    :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_color_src_sel   :  2 ; /* bits 2:1 */
    ca_uint32_t ilpb_ing_fltr_ena    :  1 ; /* bits 3:3 */
    ca_uint32_t ilpb_default_cos     :  3 ; /* bits 6:4 */
    ca_uint32_t ilpb_cos_control_bm  :  3 ; /* bits 9:7 */
    ca_uint32_t ilpb_cos_mode_sel    :  3 ; /* bits 12:10 */
    ca_uint32_t ilpb_default_dscp    :  6 ; /* bits 18:13 */
    ca_uint32_t ilpb_dscp_mark_control_bm :  4 ; /* bits 22:19 */
    ca_uint32_t ilpb_dscp_mode_sel   :  2 ; /* bits 24:23 */
    ca_uint32_t ilpb_dscp_markdown_en :  1 ; /* bits 25:25 */
    ca_uint32_t ilpb_default_802_1p  :  3 ; /* bits 28:26 */
    ca_uint32_t ilpb_inner_802_1p_mode_sel :  2 ; /* bits 30:29 */
    ca_uint32_t ilpb_802_1p_mark_control_bm :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DPB_ACCESS                       0xf43011fc
#define L2FE_PP_DPB_ACCESS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DPB_DATA                         0xf4301200
#define L2FE_PP_DPB_DATA_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t bypass               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPKTP_ACCESS                     0xf4301204
#define L2FE_PP_SPKTP_ACCESS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPKTP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPKTP_DATA                       0xf4301208
#define L2FE_PP_SPKTP_DATA_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t encode               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPKTP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HTTP_LINK_0                      0xf430120c
#define L2FE_PP_HTTP_LINK_0_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HTTP_LINK_1                      0xf4301210
#define L2FE_PP_HTTP_LINK_1_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HTTP_LINK_2                      0xf4301214
#define L2FE_PP_HTTP_LINK_2_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ARP_FILTER_ADDR                  0xf4301218
#define L2FE_PP_ARP_FILTER_ADDR_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tip                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ARP_FILTER_ADDR_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ARP_FILTER_MSK                   0xf430121c
#define L2FE_PP_ARP_FILTER_MSK_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ARP_FILTER_MSK_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_0                        0xf4301220
#define L2FE_PP_DOS_ATK_0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_1                        0xf4301224
#define L2FE_PP_DOS_ATK_1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_2                        0xf4301228
#define L2FE_PP_DOS_ATK_2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_3                        0xf430122c
#define L2FE_PP_DOS_ATK_3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_4                        0xf4301230
#define L2FE_PP_DOS_ATK_4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_FLOOD_CNT                0xf4301234
#define L2FE_PP_DOS_ATK_FLOOD_CNT_dft            0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_FLOOD_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_EVENT_TRAP               0xf4301238
#define L2FE_PP_DOS_ATK_EVENT_TRAP_dft           0x00000210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_EVENT_TRAP_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PLA
 */
        
#define L2FE_PLA_DEBUG_BUS                       0xf4301300
#define L2FE_PLA_DEBUG_BUS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_EV2_PT_CNVT_ACCESS              0xf4301304
#define L2FE_PLA_EV2_PT_CNVT_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_EV2_PT_CNVT_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_EV2_PT_CNVT_DATA                0xf4301308
#define L2FE_PLA_EV2_PT_CNVT_DATA_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ev2_pt_cnvt_encoded_value :  5 ; /* bits 4:0 */
    ca_uint32_t ev2_pt_cnvt_ethertype : 16 ; /* bits 20:5 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_EV2_PT_CNVT_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_SPB_ACCESS                      0xf430130c
#define L2FE_PLA_SPB_ACCESS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_SPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_SPB_DATA                        0xf4301310
#define L2FE_PLA_SPB_DATA_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spb_pkt_no_edit      :  1 ; /* bits 0:0 */
    ca_uint32_t spb_keep_ts          :  1 ; /* bits 1:1 */
    ca_uint32_t spb_bypass_sa_lrn_chk :  1 ; /* bits 2:2 */
    ca_uint32_t spb_limit_fwd_permit :  1 ; /* bits 3:3 */
    ca_uint32_t spb_learn_dis        :  1 ; /* bits 4:4 */
    ca_uint32_t spb_grpid_en         :  1 ; /* bits 5:5 */
    ca_uint32_t spb_flowid           : 12 ; /* bits 17:6 */
    ca_uint32_t spb_flow_en          :  1 ; /* bits 18:18 */
    ca_uint32_t spb_rate_limit_bypass :  1 ; /* bits 19:19 */
    ca_uint32_t spb_cos              :  3 ; /* bits 22:20 */
    ca_uint32_t spb_ldpid            :  6 ; /* bits 28:23 */
    ca_uint32_t spb_spcl_fwd         :  1 ; /* bits 29:29 */
    ca_uint32_t spb_pkt_no_drop      :  1 ; /* bits 30:30 */
    ca_uint32_t spb_hash_cllsn_fwd_permit :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_SPB_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_DOT1P_MAP_ACCESS                0xf4301314
#define L2FE_PLA_DOT1P_MAP_ACCESS_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DOT1P_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_DOT1P_MAP_DATA                  0xf4301318
#define L2FE_PLA_DOT1P_MAP_DATA_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p_map_mapped_premark :  1 ; /* bits 0:0 */
    ca_uint32_t dot1p_map_mapped_cos :  3 ; /* bits 3:1 */
    ca_uint32_t dot1p_map_mapped_1p  :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DOT1P_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_DSCP_MAP_ACCESS                 0xf430131c
#define L2FE_PLA_DSCP_MAP_ACCESS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DSCP_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_DSCP_MAP_DATA                   0xf4301320
#define L2FE_PLA_DSCP_MAP_DATA_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mapped_premark       :  1 ; /* bits 0:0 */
    ca_uint32_t dscp_map_mapped_cos  :  3 ; /* bits 3:1 */
    ca_uint32_t dscp_map_marked_flag :  1 ; /* bits 4:4 */
    ca_uint32_t dscp_map_mapped_dscp :  6 ; /* bits 10:5 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DSCP_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PLC
 */
        
#define L2FE_PLC_HASH_CTRL                       0xf4301400
#define L2FE_PLC_HASH_CTRL_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lan_sa_hashing_vid_sel :  1 ; /* bits 0:0 */
    ca_uint32_t lan_da_hashing_vid_sel :  1 ; /* bits 1:1 */
    ca_uint32_t lan_sa_learning_vid_sel :  1 ; /* bits 2:2 */
    ca_uint32_t wan_sa_hashing_vid_sel :  1 ; /* bits 3:3 */
    ca_uint32_t wan_da_hashing_vid_sel :  1 ; /* bits 4:4 */
    ca_uint32_t wan_sa_learning_vid_sel :  1 ; /* bits 5:5 */
    ca_uint32_t use_dot1p_l2e        :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_HASH_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_DPID_FWD_CTRL                   0xf4301404
#define L2FE_PLC_DPID_FWD_CTRL_dft               0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vid_fff_fwd          :  1 ; /* bits 0:0 */
    ca_uint32_t unkvlan_fwd          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_DPID_FWD_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_LRN_FWD_CTRL_0                  0xf4301408
#define L2FE_PLC_LRN_FWD_CTRL_0_dft              0x02000210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2_mac_sw_lrn_ldpid  :  6 ; /* bits 5:0 */
    ca_uint32_t l2_mac_sw_lrn_cos    :  3 ; /* bits 8:6 */
    ca_uint32_t l2_mac_sw_lrn_keep_old_wan :  1 ; /* bits 9:9 */
    ca_uint32_t l2_mac_sw_lrn_keep_old_lan :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t sa_miss_fwd          :  1 ; /* bits 25:25 */
    ca_uint32_t nonstd_sa_all_zero_fwd :  1 ; /* bits 26:26 */
    ca_uint32_t nonstd_sa_all_one_fwd :  1 ; /* bits 27:27 */
    ca_uint32_t nonstd_sa_b40_is_one_fwd :  1 ; /* bits 28:28 */
    ca_uint32_t sm_static_entry_fwd  :  1 ; /* bits 29:29 */
    ca_uint32_t sm_tmp_entry_fwd     :  1 ; /* bits 30:30 */
    ca_uint32_t sm_sm_entry_fwd      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_LRN_FWD_CTRL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_LRN_FWD_CTRL_1                  0xf430140c
#define L2FE_PLC_LRN_FWD_CTRL_1_dft              0x08100810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sa_limit_excd_ldpid  :  6 ; /* bits 5:0 */
    ca_uint32_t sa_limit_excd_cos    :  3 ; /* bits 8:6 */
    ca_uint32_t sa_limit_excd_fwd_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t sa_limit_excd_keep_old_wan :  1 ; /* bits 11:11 */
    ca_uint32_t sa_limit_excd_keep_old_lan :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t sa_hash_cllsn_ldpid  :  6 ; /* bits 21:16 */
    ca_uint32_t sa_hash_cllsn_cos    :  3 ; /* bits 24:22 */
    ca_uint32_t sa_hash_cllsn_fwd_ctrl :  2 ; /* bits 26:25 */
    ca_uint32_t sa_hash_cllsn_keep_old_wan :  1 ; /* bits 27:27 */
    ca_uint32_t sa_hash_cllsn_keep_old_lan :  1 ; /* bits 28:28 */
    ca_uint32_t swlrn_othr_pkt_fwd   :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_LRN_FWD_CTRL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_L2_LEARNING_CTRL                0xf4301410
#define L2FE_PLC_L2_LEARNING_CTRL_dft            0x00000046

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unkvlan_learn        :  1 ; /* bits 0:0 */
    ca_uint32_t unk_ethtype_no_learn :  1 ; /* bits 1:1 */
    ca_uint32_t igr_dropped_pkt_no_learn :  1 ; /* bits 2:2 */
    ca_uint32_t non_std_sa_all_zero_learn :  1 ; /* bits 3:3 */
    ca_uint32_t non_std_sa_all_one_learn :  1 ; /* bits 4:4 */
    ca_uint32_t non_std_sa_b40_is_one_learn :  1 ; /* bits 5:5 */
    ca_uint32_t loop_pkt_no_learn    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_L2_LEARNING_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_VLAN_MODE_CTRL                  0xf4301414
#define L2FE_PLC_VLAN_MODE_CTRL_dft              0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2e_glb_vlan_mode    :  1 ; /* bits 0:0 */
    ca_uint32_t en_fdb_vlan_pre_rslt :  1 ; /* bits 1:1 */
    ca_uint32_t en_egr_ptag_lkup_egr_ve :  1 ; /* bits 2:2 */
    ca_uint32_t en_mc_pkt_lkup_elpb  :  1 ; /* bits 3:3 */
    ca_uint32_t lan_src_usel2_vlan   :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_VLAN_MODE_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_SA_CHK_CTL                      0xf4301418
#define L2FE_PLC_SA_CHK_CTL_dft                  0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t skip_sa_chk          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_SA_CHK_CTL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_DEBUG                           0xf430141c
#define L2FE_PLC_DEBUG_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_DEBUG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_ELPB_ACCESS                     0xf4301420
#define L2FE_PLC_ELPB_ACCESS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_ELPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_ELPB_DATA1                      0xf4301424
#define L2FE_PLC_ELPB_DATA1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t elpb_802_1p_mark_control_bm :  3 ; /* bits 2:0 */
    ca_uint32_t elpb_change_1p_if_pop :  1 ; /* bits 3:3 */
    ca_uint32_t elpb_top_802_1p_mode_sel :  2 ; /* bits 5:4 */
    ca_uint32_t elpb_802_1p_ctrl_sel :  1 ; /* bits 6:6 */
    ca_uint32_t elpb_use_tx_vlan_lkup_acl :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_ELPB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_ELPB_DATA0                      0xf4301428
#define L2FE_PLC_ELPB_DATA0_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t elpb_egr_vlan_aware_mode :  1 ; /* bits 0:0 */
    ca_uint32_t elpb_egr_port_stp_status :  1 ; /* bits 1:1 */
    ca_uint32_t elpb_egr_ve_srch_en  :  1 ; /* bits 2:2 */
    ca_uint32_t elpb_egr_dest_wan    :  1 ; /* bits 3:3 */
    ca_uint32_t elpb_egr_cls_length  :  6 ; /* bits 9:4 */
    ca_uint32_t elpb_egr_cls_start   :  8 ; /* bits 17:10 */
    ca_uint32_t elpb_egr_cls_lookup_en :  1 ; /* bits 18:18 */
    ca_uint32_t elpb_egr_cls_flowid_sel :  1 ; /* bits 19:19 */
    ca_uint32_t elpb_egr_cls_cos_sel :  1 ; /* bits 20:20 */
    ca_uint32_t elpb_dscp_mark_control_bm :  4 ; /* bits 24:21 */
    ca_uint32_t elpb_dscp_mode_sel   :  2 ; /* bits 26:25 */
    ca_uint32_t elpb_dscp_ctrl_sel   :  1 ; /* bits 27:27 */
    ca_uint32_t elpb_dscp_markdown_en :  1 ; /* bits 28:28 */
    ca_uint32_t elpb_inner_802_1p_mode_sel :  2 ; /* bits 30:29 */
    ca_uint32_t elpb_802_1p_mark_control_bm :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_ELPB_DATA0_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PLE
 */
        
#define L2FE_PLE_CTL_REG                         0xf4301500
#define L2FE_PLE_CTL_REG_dft                     0x00000260

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t txvlan_membshp_chk_en_lan :  1 ; /* bits 0:0 */
    ca_uint32_t txvlan_membshp_chk_en_wan :  1 ; /* bits 1:1 */
    ca_uint32_t cos_l3_only          :  1 ; /* bits 2:2 */
    ca_uint32_t skip_port_lpbk_chk   :  1 ; /* bits 3:3 */
    ca_uint32_t pon_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t igr_fltr_chk_ldpid   :  1 ; /* bits 5:5 */
    ca_uint32_t egr_fltr_chk_lspid   :  1 ; /* bits 6:6 */
    ca_uint32_t use_gemid_mapped_from_txdot1p :  1 ; /* bits 7:7 */
    ca_uint32_t wan_dst_acl_vlan_en  :  1 ; /* bits 8:8 */
    ca_uint32_t use_rx_dscp_map_cos  :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_CTL_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_DEFAULT_REG                     0xf4301504
#define L2FE_PLE_DEFAULT_REG_dft                 0x001b0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dflt_flow_en         :  1 ; /* bits 0:0 */
    ca_uint32_t dflt_flowid          : 12 ; /* bits 12:1 */
    ca_uint32_t dflt_markdown_en     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t dflt_mc_pid          :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DEFAULT_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_RX_UNKWN_VLAN_DFT               0xf4301508
#define L2FE_PLE_RX_UNKWN_VLAN_DFT_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t memshp_bm            : 16 ; /* bits 15:0 */
    ca_uint32_t vl_grp_id            : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_RX_UNKWN_VLAN_DFT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_UNKWN_VLAN_DFT_1             0xf430150c
#define L2FE_PLE_TX_UNKWN_VLAN_DFT_1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stp_mode             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_UNKWN_VLAN_DFT_2             0xf4301510
#define L2FE_PLE_TX_UNKWN_VLAN_DFT_2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t memshp_bm            : 16 ; /* bits 15:0 */
    ca_uint32_t untag_bm             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_CTRL_0                0xf4301514
#define L2FE_PLE_TRUNK_GRP_CTRL_0_dft            0x00000012

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t trunk_hash_field_sel_mac_sa :  1 ; /* bits 0:0 */
    ca_uint32_t trunk_hash_field_sel_mac_da :  1 ; /* bits 1:1 */
    ca_uint32_t trunk_hash_field_sel_tx_top_vid :  1 ; /* bits 2:2 */
    ca_uint32_t trunk_hash_field_sel_ip_sa :  1 ; /* bits 3:3 */
    ca_uint32_t trunk_hash_field_sel_ip_da :  1 ; /* bits 4:4 */
    ca_uint32_t trunk_hash_field_sel_l4_sp :  1 ; /* bits 5:5 */
    ca_uint32_t trunk_hash_field_sel_l4_dp :  1 ; /* bits 6:6 */
    ca_uint32_t trunk_hash_field_sel_cos :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_CTRL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_0_MEMBER_0            0xf4301518
#define L2FE_PLE_TRUNK_GRP_0_MEMBER_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_0_MEMBER_1            0xf430151c
#define L2FE_PLE_TRUNK_GRP_0_MEMBER_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_CTRL_1                0xf4301520
#define L2FE_PLE_TRUNK_GRP_CTRL_1_dft            0x00000012

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t trunk_hash_field_sel_mac_sa :  1 ; /* bits 0:0 */
    ca_uint32_t trunk_hash_field_sel_mac_da :  1 ; /* bits 1:1 */
    ca_uint32_t trunk_hash_field_sel_tx_top_vid :  1 ; /* bits 2:2 */
    ca_uint32_t trunk_hash_field_sel_ip_sa :  1 ; /* bits 3:3 */
    ca_uint32_t trunk_hash_field_sel_ip_da :  1 ; /* bits 4:4 */
    ca_uint32_t trunk_hash_field_sel_l4_sp :  1 ; /* bits 5:5 */
    ca_uint32_t trunk_hash_field_sel_l4_dp :  1 ; /* bits 6:6 */
    ca_uint32_t trunk_hash_field_sel_cos :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_CTRL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_1_MEMBER_0            0xf4301524
#define L2FE_PLE_TRUNK_GRP_1_MEMBER_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_1_MEMBER_1            0xf4301528
#define L2FE_PLE_TRUNK_GRP_1_MEMBER_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_HD_FF_CTL_REG                   0xf430152c
#define L2FE_PLE_HD_FF_CTL_REG_dft               0x00000610

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_thr              :  6 ; /* bits 5:0 */
    ca_uint32_t high_thr             :  6 ; /* bits 11:6 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_HD_FF_STS_REG                   0xf4301530
#define L2FE_PLE_HD_FF_STS_REG_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_HD_FF_HDR_CNT                   0xf4301534
#define L2FE_PLE_HD_FF_HDR_CNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_HDR_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IP_CTRL           0xf4301538
#define L2FE_PLE_MC_WELL_KNOWN_IP_CTRL_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ipv6_sub_mask        :  8 ; /* bits 7:0 */
    ca_uint32_t ipv6_prog_addr_vld   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ipv4_sub_mask        :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ipv4_prog_addr_vld   :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IP_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV4              0xf430153c
#define L2FE_PLE_MC_WELL_KNOWN_IPV4_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV6_3            0xf4301540
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV6_2            0xf4301544
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV6_1            0xf4301548
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV6_0            0xf430154c
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_DEBUG_BUS                       0xf4301550
#define L2FE_PLE_DEBUG_BUS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_DSCP_MAP_ACCESS              0xf4301554
#define L2FE_PLE_TX_DSCP_MAP_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DSCP_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_DSCP_MAP_DATA                0xf4301558
#define L2FE_PLE_TX_DSCP_MAP_DATA_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t txdscp_map_mapped_cos :  3 ; /* bits 2:0 */
    ca_uint32_t txdscp_map_mapped_1p :  3 ; /* bits 5:3 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DSCP_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_DOT1P_MAP_ACCESS             0xf430155c
#define L2FE_PLE_TX_DOT1P_MAP_ACCESS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DOT1P_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_DOT1P_MAP_DATA               0xf4301560
#define L2FE_PLE_TX_DOT1P_MAP_DATA_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t txdot1p_map_mapped_cos :  3 ; /* bits 2:0 */
    ca_uint32_t txdot1p_map_mapped_cos_wan :  3 ; /* bits 5:3 */
    ca_uint32_t gem_id_vld_wan       :  1 ; /* bits 6:6 */
    ca_uint32_t gem_id_wan           :  7 ; /* bits 13:7 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DOT1P_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_DFT_FWD_ACCESS                  0xf4301564
#define L2FE_PLE_DFT_FWD_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DFT_FWD_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_DFT_FWD_DATA                    0xf4301568
#define L2FE_PLE_DFT_FWD_DATA_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dft_fwd_deny         :  1 ; /* bits 0:0 */
    ca_uint32_t dft_fwd_mc_group_id  : 10 ; /* bits 10:1 */
    ca_uint32_t dft_fwd_redir_en     :  1 ; /* bits 11:11 */
    ca_uint32_t dft_fwd_mc_group_id_valid :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DFT_FWD_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS         0xf430156c
#define L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MMSHP_CHK_ID_MAP_DATA           0xf4301570
#define L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mmshp_chk_id_map_chk_id :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_PORT_MMSHP_CHK_ACCESS           0xf4301574
#define L2FE_PLE_PORT_MMSHP_CHK_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_PORT_MMSHP_CHK_DATA1            0xf4301578
#define L2FE_PLE_PORT_MMSHP_CHK_DATA1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_bm             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_PORT_MMSHP_CHK_DATA0            0xf430157c
#define L2FE_PLE_PORT_MMSHP_CHK_DATA0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_bm             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS       0xf4301580
#define L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA         0xf4301584
#define L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * ARB
 */
        
#define L2FE_ARB_ARB_CTRL                        0xf4301600
#define L2FE_ARB_ARB_CTRL_dft                    0x09c71d80

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t drop_redir_keep_old  :  1 ; /* bits 0:0 */
    ca_uint32_t dbuf_sel             :  1 ; /* bits 1:1 */
    ca_uint32_t ip_ecn_en            :  1 ; /* bits 2:2 */
    ca_uint32_t mc_idx_copy_en       :  1 ; /* bits 3:3 */
    ca_uint32_t dbuf_dpid            :  4 ; /* bits 7:4 */
    ca_uint32_t use_hdr_a_dbuf_en    :  1 ; /* bits 8:8 */
    ca_uint32_t dst_wan_dync_buf_sel :  1 ; /* bits 9:9 */
    ca_uint32_t wan_lpid             :  6 ; /* bits 15:10 */
    ca_uint32_t wan_ext_lpid         :  6 ; /* bits 21:16 */
    ca_uint32_t tm_wan_dpid          :  4 ; /* bits 25:22 */
    ca_uint32_t tqm_port7_empty_wait_cnt_h :  5 ; /* bits 30:26 */
    ca_uint32_t keep_o_lspid_en_for_mc :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PER_COS_DONT_MARK_CTRL          0xf4301604
#define L2FE_ARB_PER_COS_DONT_MARK_CTRL_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bitmap_dst_lan       :  8 ; /* bits 7:0 */
    ca_uint32_t bitmap_dst_wan       :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PER_COS_DONT_MARK_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_TTL_TRAP                    0xf4301608
#define L2FE_ARB_ARB_TTL_TRAP_dft                0x00000280

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t keep_old             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_TTL_TRAP_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_CTRL_EXT                    0xf430160c
#define L2FE_ARB_ARB_CTRL_EXT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mc_pkt_port_mmshp_chk_en :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_CTRL_EXT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_DEBUG                       0xf4301610
#define L2FE_ARB_ARB_DEBUG_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_DEBUG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_MC_MTU_0                    0xf4301614
#define L2FE_ARB_ARB_MC_MTU_0_dft                0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mc_mtu_idx_0         : 16 ; /* bits 15:0 */
    ca_uint32_t mc_mtu_idx_1         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_MC_MTU_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_MC_MTU_1                    0xf4301618
#define L2FE_ARB_ARB_MC_MTU_1_dft                0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mc_mtu_idx_2         : 16 ; /* bits 15:0 */
    ca_uint32_t mc_mtu_idx_3         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_MC_MTU_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_MC_MTU_2                    0xf430161c
#define L2FE_ARB_ARB_MC_MTU_2_dft                0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mc_mtu_idx_4         : 16 ; /* bits 15:0 */
    ca_uint32_t mc_mtu_idx_5         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_MC_MTU_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_MC_MTU_3                    0xf4301620
#define L2FE_ARB_ARB_MC_MTU_3_dft                0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mc_mtu_idx_6         : 16 ; /* bits 15:0 */
    ca_uint32_t mc_mtu_idx_7         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_MC_MTU_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS   0xf4301624
#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA     0xf4301628
#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_cos_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 9:4 */
    ca_uint32_t rdir_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rdir_wan_dst         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS 0xf430162c
#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA  0xf4301630
#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_cos_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 9:4 */
    ca_uint32_t rdir_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rdir_wan_dst         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS    0xf4301634
#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA      0xf4301638
#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flooding_pol_id      :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS         0xf430163c
#define L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_DSCP_TE_MARK_TBL_DATA           0xf4301640
#define L2FE_ARB_DSCP_TE_MARK_TBL_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mark_value           :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_ACCESS               0xf4301644
#define L2FE_ARB_MC_FIB_TBL_ACCESS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_DATA4                0xf4301648
#define L2FE_ARB_MC_FIB_TBL_DATA4_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac_da_cmd           :  2 ; /* bits 1:0 */
    ca_uint32_t mtu_chk_en           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_DATA3                0xf430164c
#define L2FE_ARB_MC_FIB_TBL_DATA3_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac_da               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_DATA2                0xf4301650
#define L2FE_ARB_MC_FIB_TBL_DATA2_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t permit_spid_en       :  1 ; /* bits 0:0 */
    ca_uint32_t mac_sa_cmd           :  1 ; /* bits 1:1 */
    ca_uint32_t mac_sa_sel           :  3 ; /* bits 4:2 */
    ca_uint32_t cos                  :  3 ; /* bits 7:5 */
    ca_uint32_t ip_ttl_zero_fwd_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t ip_ttl_dec_cmd       :  1 ; /* bits 10:10 */
    ca_uint32_t keep_o_lspid         :  1 ; /* bits 11:11 */
    ca_uint32_t mtu_chk_ctrl         :  1 ; /* bits 12:12 */
    ca_uint32_t mtu_chk_idx          :  3 ; /* bits 15:13 */
    ca_uint32_t mac_da               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_DATA1                0xf4301654
#define L2FE_ARB_MC_FIB_TBL_DATA1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t s_vlan_cmd           :  2 ; /* bits 1:0 */
    ca_uint32_t s_vid                : 12 ; /* bits 13:2 */
    ca_uint32_t s_tpid_cmd           :  1 ; /* bits 14:14 */
    ca_uint32_t s_tpid_sel           :  2 ; /* bits 16:15 */
    ca_uint32_t dot1p_cmd            :  2 ; /* bits 18:17 */
    ca_uint32_t dot1p                :  3 ; /* bits 21:19 */
    ca_uint32_t dei_cmd              :  1 ; /* bits 22:22 */
    ca_uint32_t dei                  :  1 ; /* bits 23:23 */
    ca_uint32_t ldpid                :  6 ; /* bits 29:24 */
    ca_uint32_t cos_cmd              :  1 ; /* bits 30:30 */
    ca_uint32_t wan_dst              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_DATA0                0xf4301658
#define L2FE_ARB_MC_FIB_TBL_DATA0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t c_vlan_cmd           :  2 ; /* bits 1:0 */
    ca_uint32_t c_vid                : 12 ; /* bits 13:2 */
    ca_uint32_t c_tpid_cmd           :  1 ; /* bits 14:14 */
    ca_uint32_t c_tpid_sel           :  1 ; /* bits 15:15 */
    ca_uint32_t c_dot1p_cmd          :  2 ; /* bits 17:16 */
    ca_uint32_t c_dot1p              :  3 ; /* bits 20:18 */
    ca_uint32_t c_dei_cmd            :  1 ; /* bits 21:21 */
    ca_uint32_t c_dei                :  1 ; /* bits 22:22 */
    ca_uint32_t pol_id               :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_FLOW_DBUF_TBL_ACCESS            0xf430165c
#define L2FE_ARB_FLOW_DBUF_TBL_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_FLOW_DBUF_TBL_DATA              0xf4301660
#define L2FE_ARB_FLOW_DBUF_TBL_DATA_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dbuf_flg_0           :  1 ; /* bits 0:0 */
    ca_uint32_t dbuf_flg_1           :  1 ; /* bits 1:1 */
    ca_uint32_t dbuf_flg_2           :  1 ; /* bits 2:2 */
    ca_uint32_t dbuf_flg_3           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_FLOW_DBUF_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PORT_DBUF_TBL_ACCESS            0xf4301664
#define L2FE_ARB_PORT_DBUF_TBL_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PORT_DBUF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PORT_DBUF_TBL_DATA              0xf4301668
#define L2FE_ARB_PORT_DBUF_TBL_DATA_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dbuf_flg             :  1 ; /* bits 0:0 */
    ca_uint32_t ldpid_vld            :  1 ; /* bits 1:1 */
    ca_uint32_t ldpid                :  6 ; /* bits 7:2 */
    ca_uint32_t lspid_vld            :  1 ; /* bits 8:8 */
    ca_uint32_t lspid                :  6 ; /* bits 14:9 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PORT_DBUF_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PDPID_MAP_TBL_ACCESS            0xf430166c
#define L2FE_ARB_PDPID_MAP_TBL_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PDPID_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PDPID_MAP_TBL_DATA              0xf4301670
#define L2FE_ARB_PDPID_MAP_TBL_DATA_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pdpid                :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PDPID_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PE
 */
        
#define L2FE_PE_CTRL                             0xf4301700
#define L2FE_PE_CTRL_dft                         0x000000f0

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2_padding_dis       :  1 ; /* bits 0:0 */
    ca_uint32_t use_rx_bypass        :  1 ; /* bits 1:1 */
    ca_uint32_t mod_orig_tag         :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t wan_top_dei_keep_old :  1 ; /* bits 4:4 */
    ca_uint32_t lan_top_dei_keep_old :  1 ; /* bits 5:5 */
    ca_uint32_t wan_inner_dei_keep_old :  1 ; /* bits 6:6 */
    ca_uint32_t lan_inner_dei_keep_old :  1 ; /* bits 7:7 */
    ca_uint32_t enhance_tpid_mode    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CFG_VLAN_TPID_A                  0xf4301704
#define L2FE_PE_CFG_VLAN_TPID_A_dft              0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_A_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CFG_VLAN_TPID_B                  0xf4301708
#define L2FE_PE_CFG_VLAN_TPID_B_dft              0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_B_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CFG_VLAN_TPID_C                  0xf430170c
#define L2FE_PE_CFG_VLAN_TPID_C_dft              0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_C_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CFG_VLAN_TPID_D                  0xf4301710
#define L2FE_PE_CFG_VLAN_TPID_D_dft              0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_D_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_0                     0xf4301714
#define L2FE_PE_MY_MAC_LOW_0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_0                    0xf4301718
#define L2FE_PE_MY_MAC_HIGH_0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_1                     0xf430171c
#define L2FE_PE_MY_MAC_LOW_1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_1                    0xf4301720
#define L2FE_PE_MY_MAC_HIGH_1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_2                     0xf4301724
#define L2FE_PE_MY_MAC_LOW_2_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_2                    0xf4301728
#define L2FE_PE_MY_MAC_HIGH_2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_3                     0xf430172c
#define L2FE_PE_MY_MAC_LOW_3_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_3                    0xf4301730
#define L2FE_PE_MY_MAC_HIGH_3_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_4                     0xf4301734
#define L2FE_PE_MY_MAC_LOW_4_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_4                    0xf4301738
#define L2FE_PE_MY_MAC_HIGH_4_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_5                     0xf430173c
#define L2FE_PE_MY_MAC_LOW_5_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_5                    0xf4301740
#define L2FE_PE_MY_MAC_HIGH_5_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_6                     0xf4301744
#define L2FE_PE_MY_MAC_LOW_6_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_6                    0xf4301748
#define L2FE_PE_MY_MAC_HIGH_6_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_7                     0xf430174c
#define L2FE_PE_MY_MAC_LOW_7_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_7                    0xf4301750
#define L2FE_PE_MY_MAC_HIGH_7_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CMD_FF_CTL_REG                   0xf4301754
#define L2FE_PE_CMD_FF_CTL_REG_dft               0x00004343

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_thr_mir          :  4 ; /* bits 3:0 */
    ca_uint32_t high_thr_mir         :  4 ; /* bits 7:4 */
    ca_uint32_t low_thr_ppl          :  4 ; /* bits 11:8 */
    ca_uint32_t high_thr_ppl         :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CMD_FF_STS_REG                   0xf4301758
#define L2FE_PE_CMD_FF_STS_REG_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t overflow_ind_mir     :  1 ; /* bits 0:0 */
    ca_uint32_t overflow_ind_ppl     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CMD_FF_CMD_CNT                   0xf430175c
#define L2FE_PE_CMD_FF_CMD_CNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num_mir              :  4 ; /* bits 3:0 */
    ca_uint32_t num_ppl              :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_CMD_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_TM_INTERFACE_PKT_CNT             0xf4301760
#define L2FE_PE_TM_INTERFACE_PKT_CNT_dft         0x80000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TM_INTERFACE_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_CNT_TBL_CLR                 0xf4301764
#define L2FE_PE_DROP_CNT_TBL_CLR_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t set                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_TBL_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_HEADER_A_LOW                     0xf4301768
#define L2FE_PE_HEADER_A_LOW_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_HEADER_A_MID                     0xf430176c
#define L2FE_PE_HEADER_A_MID_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_MID_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_HEADER_A_HI                      0xf4301770
#define L2FE_PE_HEADER_A_HI_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_CNT_GEAR_FF_CNT             0xf4301774
#define L2FE_PE_DROP_CNT_GEAR_FF_CNT_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_GEAR_FF_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_CNT_GEAR_FF_STS             0xf4301778
#define L2FE_PE_DROP_CNT_GEAR_FF_STS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_GEAR_FF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DEBUG                            0xf430177c
#define L2FE_PE_DEBUG_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t fe2tm_pkt_cnt_wrap_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DEBUG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_STTS_ACCESS                 0xf4301780
#define L2FE_PE_DROP_STTS_ACCESS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_STTS_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_STTS_DATA                   0xf4301784
#define L2FE_PE_DROP_STTS_DATA_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_STTS_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS       0xf4301788
#define L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_TPID_SEL_CONFIG_TBL_DATA         0xf430178c
#define L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctag                 :  2 ; /* bits 1:0 */
    ca_uint32_t stag                 :  2 ; /* bits 3:2 */
    ca_uint32_t inner_ctag           :  2 ; /* bits 5:4 */
    ca_uint32_t inner_stag           :  2 ; /* bits 7:6 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * LF
 */
        
#define L2FE_LF_THRESHOLD                        0xf4301900
#define L2FE_LF_THRESHOLD_dft                    0x0001d8b4

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low                  :  9 ; /* bits 8:0 */
    ca_uint32_t high                 :  9 ; /* bits 17:9 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_LF_CNT                              0xf4301904
#define L2FE_LF_CNT_dft                          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t entry_cnt            :  9 ; /* bits 8:0 */
    ca_uint32_t seg_cnt              :  7 ; /* bits 15:9 */
    ca_uint32_t extra_store_cnt      :  2 ; /* bits 17:16 */
    ca_uint32_t data_ltched          :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_LF_STS                              0xf4301908
#define L2FE_LF_STS_dft                          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_LF_DEBUG                            0xf430190c
#define L2FE_LF_DEBUG_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_DEBUG_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * VE
 */
        
#define L2FE_VE_DEBUG_BUS                        0xf4301a00
#define L2FE_VE_DEBUG_BUS_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_WAN_SVL_IDX_ACCESS               0xf4301a04
#define L2FE_VE_WAN_SVL_IDX_ACCESS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_WAN_SVL_IDX_DATA                 0xf4301a08
#define L2FE_VE_WAN_SVL_IDX_DATA_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wan_svl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t wan_svl_idx_fib_idx  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_VL_FIB_ACCESS                    0xf4301a0c
#define L2FE_VE_VL_FIB_ACCESS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_VL_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_VL_FIB_DATA1                     0xf4301a10
#define L2FE_VE_VL_FIB_DATA1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_vl_group_id : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_VL_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_VL_FIB_DATA0                     0xf4301a14
#define L2FE_VE_VL_FIB_DATA0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_egress_top_untag_bm : 16 ; /* bits 15:0 */
    ca_uint32_t wan_svl_fib_membership_bm : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_VL_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_WAN_CVL_IDX_ACCESS               0xf4301a18
#define L2FE_VE_WAN_CVL_IDX_ACCESS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_WAN_CVL_IDX_DATA                 0xf4301a1c
#define L2FE_VE_WAN_CVL_IDX_DATA_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t wan_cvl_idx_fib_idx  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_LAN_VL_IDX_ACCESS                0xf4301a20
#define L2FE_VE_LAN_VL_IDX_ACCESS_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_LAN_VL_IDX_DATA                  0xf4301a24
#define L2FE_VE_LAN_VL_IDX_DATA_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lan_vl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t lan_vl_idx_fib_idx   :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * CLE
 */
        
#define L2FE_CLE_CTRL                            0xf4301b00
#define L2FE_CLE_CTRL_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t igr_use_frst_hit     :  1 ; /* bits 0:0 */
    ca_uint32_t egr_use_frst_hit     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_CONFG_STTS1                     0xf4301b04
#define L2FE_CLE_CONFG_STTS1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t igr_configured_length_over_size :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_CONFG_STTS1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_DEBUG                           0xf4301b08
#define L2FE_CLE_DEBUG_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t igr_cls_bus_sel      :  2 ; /* bits 1:0 */
    ca_uint32_t egr_cls_bus_sel      :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_DEBUG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_ACCESS                  0xf4301b0c
#define L2FE_CLE_IGR_KEY_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA12                  0xf4301b10
#define L2FE_CLE_IGR_KEY_DATA12_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_reserved :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv6_valid :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_entry_type    :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_valid         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_l4_ext_flags :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_orhr_ipv6e_tos_mask_l :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_orhr_ipv6e_reserved :  3 ; /* bits 7:5 */
    ca_uint32_t cl_key_orhr_ipv6e_idle_field :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_reserved :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_rule_type_1 :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_rule_type_0 :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_rule_hinge :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_tre_rule_idle_field :  3 ; /* bits 11:9 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_reserved :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rl3r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_reserved :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ext_flags :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_l3rl2r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ext_flags :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_l3rl3r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ext_flags :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_l3rcmr_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_tos_mask_l :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_cmrl2r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_tos_mask_l :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_cmrl3r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_tos_mask_l :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_cmrcmr_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_rule15_valid :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_stre_rule1_0_ctrl :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_stre_rule3_2_ctrl :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_stre_rule5_4_ctrl :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_stre_rule7_6_ctrl :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_stre_rule9_8_ctrl :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_stre_rule11_10_ctrl :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_stre_rule13_12_ctrl :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_stre_rule15_14_ctrl :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_stre_idle_field :  3 ; /* bits 11:9 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA12_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA11                  0xf4301b14
#define L2FE_CLE_IGR_KEY_DATA11_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn_mask :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_orhr_ipv4e_pol_id_abbr_mask :  1 ; /* bits 11:11 */
    ca_uint32_t cl_key_orhr_ipv4e_pol_id_abbr :  9 ; /* bits 20:12 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_dei_mask :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_dei :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_orhr_ipv4e_top_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_orhr_ipv4e_top_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_flags_op :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_ext_flags :  3 ; /* bits 28:26 */
    ca_uint32_t cl_key_orhr_ipv4e_tos_mask_l :  3 ; /* bits 31:29 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_flags_op :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_ext_flags :  1 ; /* bits 31:31 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_pol_id_use_inner_vid :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_dei_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_dei :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl2r_1_reserved :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_pol_id_use_inner_vid :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_dei_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_dei :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl3r_1_reserved :  3 ; /* bits 31:29 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_pol_id_use_inner_vid :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_dei_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_dei :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rcmr_1_reserved :  3 ; /* bits 31:29 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl2r_1_pol_id_use_inner_vid :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_dei_mask :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_dei :  1 ; /* bits 29:29 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags_op :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ext_flags :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_pol_id_use_inner_vid :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_dei_mask :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_dei :  1 ; /* bits 29:29 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags_op :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ext_flags :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_pol_id_use_inner_vid :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_dei_mask :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_dei :  1 ; /* bits 29:29 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags_op :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ext_flags :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags_op :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_ext_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_tos_mask_l :  1 ; /* bits 31:31 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags_op :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_ext_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_tos_mask_l :  1 ; /* bits 31:31 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags_op :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_ext_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_tos_mask_l :  1 ; /* bits 31:31 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_14_sc_ind :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_stre_vlanid_14 : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_stre_rule14_valid :  1 ; /* bits 13:13 */
    ca_uint32_t cl_key_stre_mask_15  :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_stre_dot1p_15 :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_stre_vlanid_15_sc_ind :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_stre_vlanid_15 : 12 ; /* bits 31:20 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA11_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA10                  0xf4301b18
#define L2FE_CLE_IGR_KEY_DATA10_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da : 32 ; /* bits 31:0 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 24 ; /* bits 31:8 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 24 ; /* bits 31:8 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 24 ; /* bits 31:8 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 10 ; /* bits 31:22 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 10 ; /* bits 31:22 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 26 ; /* bits 31:6 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 26 ; /* bits 31:6 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_12 :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_stre_rule12_valid :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_stre_mask_13  :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_stre_dot1p_13 :  3 ; /* bits 12:10 */
    ca_uint32_t cl_key_stre_vlanid_13_sc_ind :  1 ; /* bits 13:13 */
    ca_uint32_t cl_key_stre_vlanid_13 : 12 ; /* bits 25:14 */
    ca_uint32_t cl_key_stre_rule13_valid :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_stre_mask_14  :  2 ; /* bits 28:27 */
    ca_uint32_t cl_key_stre_dot1p_14 :  3 ; /* bits 31:29 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA10_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA9                   0xf4301b1c
#define L2FE_CLE_IGR_KEY_DATA9_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 31:24 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 32 ; /* bits 31:0 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_fragment :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_option :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_tos :  6 ; /* bits 13:8 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_pt :  8 ; /* bits 21:14 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_fragment :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_option :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_tos :  6 ; /* bits 13:8 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_pt :  8 ; /* bits 21:14 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 10 ; /* bits 31:22 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_fragment :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_option :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_tos :  6 ; /* bits 13:8 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_pt :  8 ; /* bits 21:14 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 10 ; /* bits 31:22 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 26 ; /* bits 31:6 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 26 ; /* bits 31:6 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_10 :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_stre_rule10_valid :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_stre_mask_11  :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_stre_dot1p_11 :  3 ; /* bits 6:4 */
    ca_uint32_t cl_key_stre_vlanid_11_sc_ind :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_stre_vlanid_11 : 12 ; /* bits 19:8 */
    ca_uint32_t cl_key_stre_rule11_valid :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_stre_mask_12  :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_stre_dot1p_12 :  3 ; /* bits 25:23 */
    ca_uint32_t cl_key_stre_vlanid_12_sc_ind :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_stre_vlanid_12 :  5 ; /* bits 31:27 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA9_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA8                   0xf4301b20
#define L2FE_CLE_IGR_KEY_DATA8_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 31:8 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid : 11 ; /* bits 10:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_sc_ind :  1 ; /* bits 11:11 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_vid : 12 ; /* bits 23:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa :  8 ; /* bits 31:24 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid : 11 ; /* bits 10:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_sc_ind :  1 ; /* bits 11:11 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_vid : 12 ; /* bits 23:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa :  8 ; /* bits 31:24 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid : 11 ; /* bits 10:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_sc_ind :  1 ; /* bits 11:11 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_vid : 12 ; /* bits 23:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa :  8 ; /* bits 31:24 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_802_1p :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_sc_ind :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_vid : 12 ; /* bits 16:5 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_sc_ind :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_vid : 12 ; /* bits 29:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code :  2 ; /* bits 31:30 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_802_1p :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_sc_ind :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_vid : 12 ; /* bits 16:5 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_sc_ind :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_vid : 12 ; /* bits 29:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code :  2 ; /* bits 31:30 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_802_1p :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_sc_ind :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_vid : 12 ; /* bits 16:5 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_sc_ind :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_vid : 12 ; /* bits 29:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code :  2 ; /* bits 31:30 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_sc_ind :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid : 12 ; /* bits 13:2 */
    ca_uint32_t cl_key_tre_cmrl2r_1_special_pkt_code :  5 ; /* bits 18:14 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_fragment :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_option :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_tos :  6 ; /* bits 29:24 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  2 ; /* bits 31:30 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_sc_ind :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid : 12 ; /* bits 13:2 */
    ca_uint32_t cl_key_tre_cmrl3r_1_special_pkt_code :  5 ; /* bits 18:14 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_fragment :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_option :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_tos :  6 ; /* bits 29:24 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  2 ; /* bits 31:30 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_sc_ind :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid : 12 ; /* bits 13:2 */
    ca_uint32_t cl_key_tre_cmrcmr_1_special_pkt_code :  5 ; /* bits 18:14 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_fragment :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_option :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_tos :  6 ; /* bits 29:24 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  2 ; /* bits 31:30 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_dot1p_9  :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_stre_vlanid_9_sc_ind :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_stre_vlanid_9 : 12 ; /* bits 13:2 */
    ca_uint32_t cl_key_stre_rule9_valid :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_stre_mask_10  :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_stre_dot1p_10 :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_stre_vlanid_10_sc_ind :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_stre_vlanid_10 : 11 ; /* bits 31:21 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA7                   0xf4301b24
#define L2FE_CLE_IGR_KEY_DATA7_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ev2_pt :  5 ; /* bits 5:1 */
    ca_uint32_t cl_key_orhr_ipv4e_tag_num :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_802_1p :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_orhr_ipv4e_top_802_1p :  3 ; /* bits 13:11 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_sc_ind :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_vid : 12 ; /* bits 26:15 */
    ca_uint32_t cl_key_orhr_ipv4e_top_sc_ind :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  4 ; /* bits 31:28 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_tre_l2rl2r_1_ev2_pt :  5 ; /* bits 21:17 */
    ca_uint32_t cl_key_tre_l2rl2r_1_tag_num :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_802_1p :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_802_1p :  3 ; /* bits 29:27 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_sc_ind :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  1 ; /* bits 31:31 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_tre_l2rl3r_1_ev2_pt :  5 ; /* bits 21:17 */
    ca_uint32_t cl_key_tre_l2rl3r_1_tag_num :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_802_1p :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_802_1p :  3 ; /* bits 29:27 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_sc_ind :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  1 ; /* bits 31:31 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_tre_l2rcmr_1_ev2_pt :  5 ; /* bits 21:17 */
    ca_uint32_t cl_key_tre_l2rcmr_1_tag_num :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_802_1p :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_802_1p :  3 ; /* bits 29:27 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_sc_ind :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  1 ; /* bits 31:31 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_l3rl2r_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p :  2 ; /* bits 31:30 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p :  2 ; /* bits 31:30 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p :  2 ; /* bits 31:30 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p :  2 ; /* bits 31:30 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p :  2 ; /* bits 31:30 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p :  2 ; /* bits 31:30 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_7 :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_stre_rule7_valid :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_stre_mask_8   :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_stre_dot1p_8  :  3 ; /* bits 13:11 */
    ca_uint32_t cl_key_stre_vlanid_8_sc_ind :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_stre_vlanid_8 : 12 ; /* bits 26:15 */
    ca_uint32_t cl_key_stre_rule8_valid :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_stre_mask_9   :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_stre_dot1p_9  :  2 ; /* bits 31:30 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA6                   0xf4301b28
#define L2FE_CLE_IGR_KEY_DATA6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l2rl2r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mask :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_ctrl :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_tre_l2rl2r_1_dot1p_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl2r_1_vid_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 15 ; /* bits 31:17 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l2rl3r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mask :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_ctrl :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_tre_l2rl3r_1_dot1p_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl3r_1_vid_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 15 ; /* bits 31:17 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l2rcmr_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mask :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_ctrl :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_tre_l2rcmr_1_dot1p_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rcmr_1_vid_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 15 ; /* bits 31:17 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl2r_1_mask :  8 ; /* bits 13:6 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ctrl :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_l3rl2r_1_dot1p_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl2r_1_vid_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_ctrl :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp :  9 ; /* bits 31:23 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl3r_1_mask :  8 ; /* bits 13:6 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ctrl :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_l3rl3r_1_dot1p_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl3r_1_vid_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_ctrl :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp :  9 ; /* bits 31:23 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rcmr_1_mask :  8 ; /* bits 13:6 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ctrl :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_l3rcmr_1_dot1p_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rcmr_1_vid_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_ctrl :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp :  9 ; /* bits 31:23 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_cmrl2r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mask : 12 ; /* bits 17:6 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_ctrl :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr_sel :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr_sel :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp :  9 ; /* bits 31:23 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_cmrl3r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mask : 12 ; /* bits 17:6 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_ctrl :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr_sel :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr_sel :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp :  9 ; /* bits 31:23 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_cmrcmr_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mask : 12 ; /* bits 17:6 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_ctrl :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr_sel :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr_sel :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp :  9 ; /* bits 31:23 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_5 :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_stre_rule5_valid :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_stre_mask_6   :  2 ; /* bits 4:3 */
    ca_uint32_t cl_key_stre_dot1p_6  :  3 ; /* bits 7:5 */
    ca_uint32_t cl_key_stre_vlanid_6_sc_ind :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_stre_vlanid_6 : 12 ; /* bits 20:9 */
    ca_uint32_t cl_key_stre_rule6_valid :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_stre_mask_7   :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_stre_dot1p_7  :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_stre_vlanid_7_sc_ind :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_stre_vlanid_7 :  4 ; /* bits 31:28 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA5                   0xf4301b2c
#define L2FE_CLE_IGR_KEY_DATA5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_pol_id_use_inner_vid :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rl2r_2_reserved :  5 ; /* bits 31:27 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_pol_id_use_inner_vid :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_dei_mask :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_dei :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags_op :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_ext_flags :  3 ; /* bits 31:29 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags_op :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_ext_flags :  3 ; /* bits 28:26 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_tos_mask_l :  3 ; /* bits 31:29 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_pol_id_use_inner_vid :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rl2r_2_reserved :  5 ; /* bits 31:27 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_pol_id_use_inner_vid :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_dei_mask :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_dei :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags_op :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_ext_flags :  3 ; /* bits 31:29 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags_op :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_ext_flags :  3 ; /* bits 28:26 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_tos_mask_l :  3 ; /* bits 31:29 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_pol_id_use_inner_vid :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrl2r_2_reserved :  5 ; /* bits 31:27 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_pol_id_use_inner_vid :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_dei_mask :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_dei :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags_op :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_ext_flags :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags_op :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_ext_flags :  3 ; /* bits 28:26 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_tos_mask_l :  3 ; /* bits 31:29 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_dot1p_4  :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_stre_vlanid_4_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_stre_vlanid_4 : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_stre_rule4_valid :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_stre_mask_5   :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_stre_dot1p_5  :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_stre_vlanid_5_sc_ind :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_stre_vlanid_5 : 10 ; /* bits 31:22 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA4                   0xf4301b30
#define L2FE_CLE_IGR_KEY_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  7 ; /* bits 31:25 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_2 :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_stre_rule2_valid :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_stre_mask_3   :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_stre_dot1p_3  :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_stre_vlanid_3_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_stre_vlanid_3 : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_stre_rule3_valid :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_stre_mask_4   :  2 ; /* bits 30:29 */
    ca_uint32_t cl_key_stre_dot1p_4  :  1 ; /* bits 31:31 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA3                   0xf4301b34
#define L2FE_CLE_IGR_KEY_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_pt :  8 ; /* bits 12:5 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_mask : 14 ; /* bits 26:13 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_0 :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_stre_rule0_valid :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_stre_mask_1   :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_stre_dot1p_1  :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_stre_vlanid_1_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_stre_vlanid_1 : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_stre_rule1_valid :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_stre_mask_2   :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_stre_dot1p_2  :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_stre_vlanid_2_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_stre_vlanid_2 :  3 ; /* bits 31:29 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA2                   0xf4301b38
#define L2FE_CLE_IGR_KEY_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_global_key :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_orhr_ipv4e_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_tag_num :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv6e_top_802_1p :  3 ; /* bits 9:7 */
    ca_uint32_t cl_key_orhr_ipv6e_top_sc_ind :  1 ; /* bits 10:10 */
    ca_uint32_t cl_key_orhr_ipv6e_top_vid : 12 ; /* bits 22:11 */
    ca_uint32_t cl_key_orhr_ipv6e_special_pkt_code :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  1 ; /* bits 31:31 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_reserved :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_stre_grp_1_prcd :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_stre_grp_0_prcd :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_stre_grp_1_dscp_mode :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_stre_grp_0_dscp_mode :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_stre_mask_0   :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_stre_dot1p_0  :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_stre_vlanid_0_sc_ind :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_stre_vlanid_0 :  9 ; /* bits 31:23 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA1                   0xf4301b3c
#define L2FE_CLE_IGR_KEY_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_ctrl :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_dot1p_ctrl :  2 ; /* bits 4:3 */
    ca_uint32_t cl_key_orhr_ipv4e_vid_ctrl :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_ctrl :  2 ; /* bits 8:7 */
    ca_uint32_t cl_key_orhr_ipv4e_global_key : 23 ; /* bits 31:9 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_flow_label :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_sp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 11 ; /* bits 31:21 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_reserved : 32 ; /* bits 31:0 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA0                   0xf4301b40
#define L2FE_CLE_IGR_KEY_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv4e_mask : 22 ; /* bits 25:4 */
    ca_uint32_t cl_key_orhr_ipv4e_l7_ctrl :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_ctrl :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_ctrl :  2 ; /* bits 31:30 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv6e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv6e_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_orhr_ipv6e_flow_label : 15 ; /* bits 31:17 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l2rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l3rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_cmrl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_reserved : 32 ; /* bits 31:0 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_ACCESS                  0xf4301b44
#define L2FE_CLE_IGR_FIB_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA4                   0xf4301b48
#define L2FE_CLE_IGR_FIB_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_inner_vid_0 : 10 ; /* bits 9:0 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_0 :  1 ; /* bits 10:10 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_0 :  2 ; /* bits 12:11 */
    ca_uint32_t cl_fib_xr_top_sc_ind_0 :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_top_vid_0  : 12 ; /* bits 25:14 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_0 :  1 ; /* bits 26:26 */
    ca_uint32_t cl_fib_xr_reserved_0 :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA3                   0xf4301b4c
#define L2FE_CLE_IGR_FIB_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_flowid_0   :  1 ; /* bits 0:0 */
    ca_uint32_t cl_fib_xr_dp_valid_0 :  1 ; /* bits 1:1 */
    ca_uint32_t cl_fib_xr_ldpid_0    :  9 ; /* bits 10:2 */
    ca_uint32_t cl_fib_xr_cos_valid_0 :  1 ; /* bits 11:11 */
    ca_uint32_t cl_fib_xr_dscp_valid_0 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_802_1p_valid_0 :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_cos_0      :  3 ; /* bits 16:14 */
    ca_uint32_t cl_fib_xr_dscp_0     :  6 ; /* bits 22:17 */
    ca_uint32_t cl_fib_xr_802_1p_0   :  3 ; /* bits 25:23 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_0 :  1 ; /* bits 26:26 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_0 :  2 ; /* bits 28:27 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_0 :  1 ; /* bits 29:29 */
    ca_uint32_t cl_fib_xr_inner_vid_0 :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA2                   0xf4301b50
#define L2FE_CLE_IGR_FIB_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_top_vid_1  : 12 ; /* bits 11:0 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_1 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_reserved_1 :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_stp_mode_0 :  2 ; /* bits 15:14 */
    ca_uint32_t cl_fib_xr_permit_valid_0 :  1 ; /* bits 16:16 */
    ca_uint32_t cl_fib_xr_permit_0   :  1 ; /* bits 17:17 */
    ca_uint32_t cl_fib_xr_premarked_0 :  1 ; /* bits 18:18 */
    ca_uint32_t cl_fib_xr_grpid_vld_0 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_flowid_vld_0 :  1 ; /* bits 20:20 */
    ca_uint32_t cl_fib_xr_flowid_0   : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA1                   0xf4301b54
#define L2FE_CLE_IGR_FIB_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_cos_1      :  3 ; /* bits 2:0 */
    ca_uint32_t cl_fib_xr_dscp_1     :  6 ; /* bits 8:3 */
    ca_uint32_t cl_fib_xr_802_1p_1   :  3 ; /* bits 11:9 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_1 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_1 :  2 ; /* bits 14:13 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_1 :  1 ; /* bits 15:15 */
    ca_uint32_t cl_fib_xr_inner_vid_1 : 12 ; /* bits 27:16 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_1 :  2 ; /* bits 30:29 */
    ca_uint32_t cl_fib_xr_top_sc_ind_1 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA0                   0xf4301b58
#define L2FE_CLE_IGR_FIB_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_stp_mode_1 :  2 ; /* bits 1:0 */
    ca_uint32_t cl_fib_xr_permit_valid_1 :  1 ; /* bits 2:2 */
    ca_uint32_t cl_fib_xr_permit_1   :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_premarked_1 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_grpid_vld_1 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_flowid_vld_1 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_flowid_1   : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_dp_valid_1 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_ldpid_1    :  9 ; /* bits 28:20 */
    ca_uint32_t cl_fib_xr_cos_valid_1 :  1 ; /* bits 29:29 */
    ca_uint32_t cl_fib_xr_dscp_valid_1 :  1 ; /* bits 30:30 */
    ca_uint32_t cl_fib_xr_802_1p_valid_1 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * L2E
 */
        
#define L2FE_L2E_CTRL                            0xf4301c00
#define L2FE_L2E_CTRL_dft                        0x1ca00ff9

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aging_en             :  1 ; /* bits 0:0 */
    ca_uint32_t tmp_entry_aging_dis  :  1 ; /* bits 1:1 */
    ca_uint32_t aging_mode           :  1 ; /* bits 2:2 */
    ca_uint32_t aging_start_val      :  8 ; /* bits 10:3 */
    ca_uint32_t st_move_en           :  1 ; /* bits 11:11 */
    ca_uint32_t sw_age_entry_scan    :  1 ; /* bits 12:12 */
    ca_uint32_t st_mv_window         :  9 ; /* bits 21:13 */
    ca_uint32_t lrn_dis              :  1 ; /* bits 22:22 */
    ca_uint32_t lrn_mode             :  2 ; /* bits 24:23 */
    ca_uint32_t hash_collision_overwrite :  1 ; /* bits 25:25 */
    ca_uint32_t hashing_mode         :  2 ; /* bits 27:26 */
    ca_uint32_t da_deny_dnt_lrn      :  1 ; /* bits 28:28 */
    ca_uint32_t ovfl_entries_rcyc_en :  1 ; /* bits 29:29 */
    ca_uint32_t info_ff_init         :  1 ; /* bits 30:30 */
    ca_uint32_t cpu_opt_mode         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_AGING_CTRL                      0xf4301c04
#define L2FE_L2E_AGING_CTRL_dft                  0x77b0012c

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aging_out_time       : 19 ; /* bits 18:0 */
    ca_uint32_t cnt_to_1s            : 13 ; /* bits 31:19 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_AGING_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_CPT_ENTRY_3            0xf4301c08
#define L2FE_L2E_SW_AGING_CPT_ENTRY_3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_CPT_ENTRY_2            0xf4301c0c
#define L2FE_L2E_SW_AGING_CPT_ENTRY_2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_CPT_ENTRY_1            0xf4301c10
#define L2FE_L2E_SW_AGING_CPT_ENTRY_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_CPT_ENTRY_0            0xf4301c14
#define L2FE_L2E_SW_AGING_CPT_ENTRY_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD4               0xf4301c18
#define L2FE_L2E_FDB_CPU_CMD_WORD4_dft           0x00007fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD3               0xf4301c1c
#define L2FE_L2E_FDB_CPU_CMD_WORD3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD2               0xf4301c20
#define L2FE_L2E_FDB_CPU_CMD_WORD2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD1               0xf4301c24
#define L2FE_L2E_FDB_CPU_CMD_WORD1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 27 ; /* bits 26:0 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD0               0xf4301c28
#define L2FE_L2E_FDB_CPU_CMD_WORD0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 27 ; /* bits 26:0 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CMD_RETURN                  0xf4301c2c
#define L2FE_L2E_FDB_CMD_RETURN_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               :  4 ; /* bits 3:0 */
    ca_uint32_t ext_status           : 13 ; /* bits 16:4 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CMD_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_CNT_CMD_RETURN                  0xf4301c30
#define L2FE_L2E_CNT_CMD_RETURN_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_CNT_CMD_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_CNT_STTS_0             0xf4301c34
#define L2FE_L2E_PORT_MAC_CNT_STTS_0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t underflow_0          :  1 ; /* bits 0:0 */
    ca_uint32_t underflow_1          :  1 ; /* bits 1:1 */
    ca_uint32_t underflow_2          :  1 ; /* bits 2:2 */
    ca_uint32_t underflow_3          :  1 ; /* bits 3:3 */
    ca_uint32_t underflow_4          :  1 ; /* bits 4:4 */
    ca_uint32_t underflow_5          :  1 ; /* bits 5:5 */
    ca_uint32_t underflow_6          :  1 ; /* bits 6:6 */
    ca_uint32_t underflow_7          :  1 ; /* bits 7:7 */
    ca_uint32_t underflow_8          :  1 ; /* bits 8:8 */
    ca_uint32_t underflow_9          :  1 ; /* bits 9:9 */
    ca_uint32_t underflow_10         :  1 ; /* bits 10:10 */
    ca_uint32_t underflow_11         :  1 ; /* bits 11:11 */
    ca_uint32_t underflow_12         :  1 ; /* bits 12:12 */
    ca_uint32_t underflow_13         :  1 ; /* bits 13:13 */
    ca_uint32_t underflow_14         :  1 ; /* bits 14:14 */
    ca_uint32_t underflow_15         :  1 ; /* bits 15:15 */
    ca_uint32_t underflow_16         :  1 ; /* bits 16:16 */
    ca_uint32_t underflow_17         :  1 ; /* bits 17:17 */
    ca_uint32_t underflow_18         :  1 ; /* bits 18:18 */
    ca_uint32_t underflow_19         :  1 ; /* bits 19:19 */
    ca_uint32_t underflow_20         :  1 ; /* bits 20:20 */
    ca_uint32_t underflow_21         :  1 ; /* bits 21:21 */
    ca_uint32_t underflow_22         :  1 ; /* bits 22:22 */
    ca_uint32_t underflow_23         :  1 ; /* bits 23:23 */
    ca_uint32_t underflow_24         :  1 ; /* bits 24:24 */
    ca_uint32_t underflow_25         :  1 ; /* bits 25:25 */
    ca_uint32_t underflow_26         :  1 ; /* bits 26:26 */
    ca_uint32_t underflow_27         :  1 ; /* bits 27:27 */
    ca_uint32_t underflow_28         :  1 ; /* bits 28:28 */
    ca_uint32_t underflow_29         :  1 ; /* bits 29:29 */
    ca_uint32_t underflow_30         :  1 ; /* bits 30:30 */
    ca_uint32_t underflow_31         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_CNT_STTS_1             0xf4301c38
#define L2FE_L2E_PORT_MAC_CNT_STTS_1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t underflow_0          :  1 ; /* bits 0:0 */
    ca_uint32_t underflow_1          :  1 ; /* bits 1:1 */
    ca_uint32_t underflow_2          :  1 ; /* bits 2:2 */
    ca_uint32_t underflow_3          :  1 ; /* bits 3:3 */
    ca_uint32_t underflow_4          :  1 ; /* bits 4:4 */
    ca_uint32_t underflow_5          :  1 ; /* bits 5:5 */
    ca_uint32_t underflow_6          :  1 ; /* bits 6:6 */
    ca_uint32_t underflow_7          :  1 ; /* bits 7:7 */
    ca_uint32_t underflow_8          :  1 ; /* bits 8:8 */
    ca_uint32_t underflow_9          :  1 ; /* bits 9:9 */
    ca_uint32_t underflow_10         :  1 ; /* bits 10:10 */
    ca_uint32_t underflow_11         :  1 ; /* bits 11:11 */
    ca_uint32_t underflow_12         :  1 ; /* bits 12:12 */
    ca_uint32_t underflow_13         :  1 ; /* bits 13:13 */
    ca_uint32_t underflow_14         :  1 ; /* bits 14:14 */
    ca_uint32_t underflow_15         :  1 ; /* bits 15:15 */
    ca_uint32_t underflow_16         :  1 ; /* bits 16:16 */
    ca_uint32_t underflow_17         :  1 ; /* bits 17:17 */
    ca_uint32_t underflow_18         :  1 ; /* bits 18:18 */
    ca_uint32_t underflow_19         :  1 ; /* bits 19:19 */
    ca_uint32_t underflow_20         :  1 ; /* bits 20:20 */
    ca_uint32_t underflow_21         :  1 ; /* bits 21:21 */
    ca_uint32_t underflow_22         :  1 ; /* bits 22:22 */
    ca_uint32_t underflow_23         :  1 ; /* bits 23:23 */
    ca_uint32_t underflow_24         :  1 ; /* bits 24:24 */
    ca_uint32_t underflow_25         :  1 ; /* bits 25:25 */
    ca_uint32_t underflow_26         :  1 ; /* bits 26:26 */
    ca_uint32_t underflow_27         :  1 ; /* bits 27:27 */
    ca_uint32_t underflow_28         :  1 ; /* bits 28:28 */
    ca_uint32_t underflow_29         :  1 ; /* bits 29:29 */
    ca_uint32_t underflow_30         :  1 ; /* bits 30:30 */
    ca_uint32_t underflow_31         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0         0xf4301c3c
#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t excd_0               :  1 ; /* bits 0:0 */
    ca_uint32_t excd_1               :  1 ; /* bits 1:1 */
    ca_uint32_t excd_2               :  1 ; /* bits 2:2 */
    ca_uint32_t excd_3               :  1 ; /* bits 3:3 */
    ca_uint32_t excd_4               :  1 ; /* bits 4:4 */
    ca_uint32_t excd_5               :  1 ; /* bits 5:5 */
    ca_uint32_t excd_6               :  1 ; /* bits 6:6 */
    ca_uint32_t excd_7               :  1 ; /* bits 7:7 */
    ca_uint32_t excd_8               :  1 ; /* bits 8:8 */
    ca_uint32_t excd_9               :  1 ; /* bits 9:9 */
    ca_uint32_t excd_10              :  1 ; /* bits 10:10 */
    ca_uint32_t excd_11              :  1 ; /* bits 11:11 */
    ca_uint32_t excd_12              :  1 ; /* bits 12:12 */
    ca_uint32_t excd_13              :  1 ; /* bits 13:13 */
    ca_uint32_t excd_14              :  1 ; /* bits 14:14 */
    ca_uint32_t excd_15              :  1 ; /* bits 15:15 */
    ca_uint32_t excd_16              :  1 ; /* bits 16:16 */
    ca_uint32_t excd_17              :  1 ; /* bits 17:17 */
    ca_uint32_t excd_18              :  1 ; /* bits 18:18 */
    ca_uint32_t excd_19              :  1 ; /* bits 19:19 */
    ca_uint32_t excd_20              :  1 ; /* bits 20:20 */
    ca_uint32_t excd_21              :  1 ; /* bits 21:21 */
    ca_uint32_t excd_22              :  1 ; /* bits 22:22 */
    ca_uint32_t excd_23              :  1 ; /* bits 23:23 */
    ca_uint32_t excd_24              :  1 ; /* bits 24:24 */
    ca_uint32_t excd_25              :  1 ; /* bits 25:25 */
    ca_uint32_t excd_26              :  1 ; /* bits 26:26 */
    ca_uint32_t excd_27              :  1 ; /* bits 27:27 */
    ca_uint32_t excd_28              :  1 ; /* bits 28:28 */
    ca_uint32_t excd_29              :  1 ; /* bits 29:29 */
    ca_uint32_t excd_30              :  1 ; /* bits 30:30 */
    ca_uint32_t excd_31              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1         0xf4301c40
#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t excd_0               :  1 ; /* bits 0:0 */
    ca_uint32_t excd_1               :  1 ; /* bits 1:1 */
    ca_uint32_t excd_2               :  1 ; /* bits 2:2 */
    ca_uint32_t excd_3               :  1 ; /* bits 3:3 */
    ca_uint32_t excd_4               :  1 ; /* bits 4:4 */
    ca_uint32_t excd_5               :  1 ; /* bits 5:5 */
    ca_uint32_t excd_6               :  1 ; /* bits 6:6 */
    ca_uint32_t excd_7               :  1 ; /* bits 7:7 */
    ca_uint32_t excd_8               :  1 ; /* bits 8:8 */
    ca_uint32_t excd_9               :  1 ; /* bits 9:9 */
    ca_uint32_t excd_10              :  1 ; /* bits 10:10 */
    ca_uint32_t excd_11              :  1 ; /* bits 11:11 */
    ca_uint32_t excd_12              :  1 ; /* bits 12:12 */
    ca_uint32_t excd_13              :  1 ; /* bits 13:13 */
    ca_uint32_t excd_14              :  1 ; /* bits 14:14 */
    ca_uint32_t excd_15              :  1 ; /* bits 15:15 */
    ca_uint32_t excd_16              :  1 ; /* bits 16:16 */
    ca_uint32_t excd_17              :  1 ; /* bits 17:17 */
    ca_uint32_t excd_18              :  1 ; /* bits 18:18 */
    ca_uint32_t excd_19              :  1 ; /* bits 19:19 */
    ca_uint32_t excd_20              :  1 ; /* bits 20:20 */
    ca_uint32_t excd_21              :  1 ; /* bits 21:21 */
    ca_uint32_t excd_22              :  1 ; /* bits 22:22 */
    ca_uint32_t excd_23              :  1 ; /* bits 23:23 */
    ca_uint32_t excd_24              :  1 ; /* bits 24:24 */
    ca_uint32_t excd_25              :  1 ; /* bits 25:25 */
    ca_uint32_t excd_26              :  1 ; /* bits 26:26 */
    ca_uint32_t excd_27              :  1 ; /* bits 27:27 */
    ca_uint32_t excd_28              :  1 ; /* bits 28:28 */
    ca_uint32_t excd_29              :  1 ; /* bits 29:29 */
    ca_uint32_t excd_30              :  1 ; /* bits 30:30 */
    ca_uint32_t excd_31              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_HASH_CLLSN_STTS                 0xf4301c44
#define L2FE_L2E_HASH_CLLSN_STTS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cllsn_det            :  1 ; /* bits 0:0 */
    ca_uint32_t cllsn_addr           :  9 ; /* bits 9:1 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_HASH_CLLSN_STTS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_L2E_LRN_STS                     0xf4301c48
#define L2FE_L2E_L2E_LRN_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t loop_det             :  1 ; /* bits 0:0 */
    ca_uint32_t hit_tmp_entry_sm     :  1 ; /* bits 1:1 */
    ca_uint32_t hit_static_entry_sm  :  1 ; /* bits 2:2 */
    ca_uint32_t hit_sm_entry_sm      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_L2E_LRN_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_REPORT_FIFO_STTS       0xf4301c4c
#define L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cpt_entry_flg        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t cnt                  :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_POINTER_FF_STS_REG              0xf4301c50
#define L2FE_L2E_POINTER_FF_STS_REG_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_POINTER_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_POINTER_FF_CNT                  0xf4301c54
#define L2FE_L2E_POINTER_FF_CNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_POINTER_FF_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_STS_REG                 0xf4301c58
#define L2FE_L2E_INFO_FF_STS_REG_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_0                   0xf4301c5c
#define L2FE_L2E_INFO_FF_CNT_0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_1                   0xf4301c60
#define L2FE_L2E_INFO_FF_CNT_1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_2                   0xf4301c64
#define L2FE_L2E_INFO_FF_CNT_2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_3                   0xf4301c68
#define L2FE_L2E_INFO_FF_CNT_3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_4                   0xf4301c6c
#define L2FE_L2E_INFO_FF_CNT_4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_5                   0xf4301c70
#define L2FE_L2E_INFO_FF_CNT_5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_6                   0xf4301c74
#define L2FE_L2E_INFO_FF_CNT_6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_7                   0xf4301c78
#define L2FE_L2E_INFO_FF_CNT_7_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_8                   0xf4301c7c
#define L2FE_L2E_INFO_FF_CNT_8_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_8_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_9                   0xf4301c80
#define L2FE_L2E_INFO_FF_CNT_9_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_9_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_10                  0xf4301c84
#define L2FE_L2E_INFO_FF_CNT_10_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_10_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_11                  0xf4301c88
#define L2FE_L2E_INFO_FF_CNT_11_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_11_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_12                  0xf4301c8c
#define L2FE_L2E_INFO_FF_CNT_12_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_12_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_13                  0xf4301c90
#define L2FE_L2E_INFO_FF_CNT_13_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_13_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_14                  0xf4301c94
#define L2FE_L2E_INFO_FF_CNT_14_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_14_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_15                  0xf4301c98
#define L2FE_L2E_INFO_FF_CNT_15_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_15_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_DEBUG_BUS                       0xf4301c9c
#define L2FE_L2E_DEBUG_BUS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_ACCESS                      0xf4301ca0
#define L2FE_L2E_FDB_ACCESS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_DATA3                       0xf4301ca4
#define L2FE_L2E_FDB_DATA3_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac_addr             :  3 ; /* bits 2:0 */
    ca_uint32_t lrned_untag_vld      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_DATA2                       0xf4301ca8
#define L2FE_L2E_FDB_DATA2_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_DATA1                       0xf4301cac
#define L2FE_L2E_FDB_DATA1_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lrned_vid            :  3 ; /* bits 2:0 */
    ca_uint32_t key_dot1p            :  3 ; /* bits 5:3 */
    ca_uint32_t key_scind            :  1 ; /* bits 6:6 */
    ca_uint32_t key_vid              : 12 ; /* bits 18:7 */
    ca_uint32_t mac_addr             : 13 ; /* bits 31:19 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_DATA0                       0xf4301cb0
#define L2FE_L2E_FDB_DATA0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mcgid                : 10 ; /* bits 9:0 */
    ca_uint32_t mc_flag              :  1 ; /* bits 10:10 */
    ca_uint32_t aging_sts            :  8 ; /* bits 18:11 */
    ca_uint32_t is_static            :  1 ; /* bits 19:19 */
    ca_uint32_t da_permit            :  1 ; /* bits 20:20 */
    ca_uint32_t sa_permit            :  1 ; /* bits 21:21 */
    ca_uint32_t lrned_scind          :  1 ; /* bits 22:22 */
    ca_uint32_t lrned_vid            :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS         0xf4301cb4
#define L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_CNT_LMT_DATA           0xf4301cb8
#define L2FE_L2E_PORT_MAC_CNT_LMT_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_AGING_CTRL_EXT                  0xf4301cbc
#define L2FE_L2E_AGING_CTRL_EXT_dft              0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_lrn_aging_start_val :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_AGING_CTRL_EXT_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * VLAN_CNT
 */
        
#define L2FE_VLAN_CNT_KEY_TCAM_ACCESS            0xf4301d00
#define L2FE_VLAN_CNT_KEY_TCAM_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_KEY_TCAM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_KEY_TCAM_DATA1             0xf4301d04
#define L2FE_VLAN_CNT_KEY_TCAM_DATA1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vid                  :  2 ; /* bits 1:0 */
    ca_uint32_t pri                  :  3 ; /* bits 4:2 */
    ca_uint32_t pkt_type             :  2 ; /* bits 6:5 */
    ca_uint32_t l3fe                 :  1 ; /* bits 7:7 */
    ca_uint32_t mask                 :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_KEY_TCAM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_KEY_TCAM_DATA0             0xf4301d08
#define L2FE_VLAN_CNT_KEY_TCAM_DATA0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                :  1 ; /* bits 0:0 */
    ca_uint32_t lspid                :  6 ; /* bits 6:1 */
    ca_uint32_t ldpid                :  6 ; /* bits 12:7 */
    ca_uint32_t gem_id               :  8 ; /* bits 20:13 */
    ca_uint32_t egr_wan_dst          :  1 ; /* bits 21:21 */
    ca_uint32_t vid                  : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_KEY_TCAM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_ACCESS                 0xf4301d0c
#define L2FE_VLAN_CNT_TBL_ACCESS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA11                 0xf4301d10
#define L2FE_VLAN_CNT_TBL_DATA11_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt1518_1024_cnt     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA11_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA10                 0xf4301d14
#define L2FE_VLAN_CNT_TBL_DATA10_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt512_1023_cnt      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA10_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA9                  0xf4301d18
#define L2FE_VLAN_CNT_TBL_DATA9_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt256_511_cnt       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA9_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA8                  0xf4301d1c
#define L2FE_VLAN_CNT_TBL_DATA8_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt128_255_cnt       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA7                  0xf4301d20
#define L2FE_VLAN_CNT_TBL_DATA7_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt65_127_cnt        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA6                  0xf4301d24
#define L2FE_VLAN_CNT_TBL_DATA6_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt64_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA5                  0xf4301d28
#define L2FE_VLAN_CNT_TBL_DATA5_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t oversize_cnt         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA4                  0xf4301d2c
#define L2FE_VLAN_CNT_TBL_DATA4_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bcast_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA3                  0xf4301d30
#define L2FE_VLAN_CNT_TBL_DATA3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mcast_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA2                  0xf4301d34
#define L2FE_VLAN_CNT_TBL_DATA2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ucast_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA1                  0xf4301d38
#define L2FE_VLAN_CNT_TBL_DATA1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t octet_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VLAN_CNT_TBL_DATA0                  0xf4301d3c
#define L2FE_VLAN_CNT_TBL_DATA0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t octet_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VLAN_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PONCLE
 */
        
#define L2FE_PONCLE_TCAM_CTRL                    0xf4301e00
#define L2FE_PONCLE_TCAM_CTRL_dft                0x0870e1c3

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mds0                 :  3 ; /* bits 2:0 */
    ca_uint32_t rds0                 :  4 ; /* bits 6:3 */
    ca_uint32_t mds1                 :  3 ; /* bits 9:7 */
    ca_uint32_t rds1                 :  4 ; /* bits 13:10 */
    ca_uint32_t mds2                 :  3 ; /* bits 16:14 */
    ca_uint32_t rds2                 :  4 ; /* bits 20:17 */
    ca_uint32_t mds3                 :  3 ; /* bits 23:21 */
    ca_uint32_t rds3                 :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_TCAM_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_KEY_ACCESS                   0xf4301e04
#define L2FE_PONCLE_KEY_ACCESS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_KEY_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_KEY_DATA2                    0xf4301e08
#define L2FE_PONCLE_KEY_DATA2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tos                  :  8 ; /* bits 7:0 */
    ca_uint32_t reserved             :  3 ; /* bits 10:8 */
    ca_uint32_t ether_type           :  5 ; /* bits 15:11 */
    ca_uint32_t valid                :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_KEY_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_KEY_DATA1                    0xf4301e0c
#define L2FE_PONCLE_KEY_DATA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctag                 : 16 ; /* bits 15:0 */
    ca_uint32_t outer_tag            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_KEY_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_KEY_DATA0                    0xf4301e10
#define L2FE_PONCLE_KEY_DATA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t lspid                :  6 ; /* bits 11:6 */
    ca_uint32_t stag_pkt             :  1 ; /* bits 12:12 */
    ca_uint32_t ctag_pkt             :  1 ; /* bits 13:13 */
    ca_uint32_t stag_tpid_code       :  2 ; /* bits 15:14 */
    ca_uint32_t pkt_type             :  3 ; /* bits 18:16 */
    ca_uint32_t ipv4_pkt             :  1 ; /* bits 19:19 */
    ca_uint32_t ipv6_pkt             :  1 ; /* bits 20:20 */
    ca_uint32_t igmp_pkt             :  1 ; /* bits 21:21 */
    ca_uint32_t pol_id               :  9 ; /* bits 30:22 */
    ca_uint32_t stream               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_KEY_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_FIB_ACCESS                   0xf4301e14
#define L2FE_PONCLE_FIB_ACCESS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_FIB_DATA2                    0xf4301e18
#define L2FE_PONCLE_FIB_DATA2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cpri                 :  1 ; /* bits 0:0 */
    ca_uint32_t cvid_act             :  2 ; /* bits 2:1 */
    ca_uint32_t cpri_act             :  2 ; /* bits 4:3 */
    ca_uint32_t ccfi_keep            :  1 ; /* bits 5:5 */
    ca_uint32_t cf_cos_act           :  1 ; /* bits 6:6 */
    ca_uint32_t cf_cos               :  3 ; /* bits 9:7 */
    ca_uint32_t rsv                  :  2 ; /* bits 11:10 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_FIB_DATA1                    0xf4301e1c
#define L2FE_PONCLE_FIB_DATA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cf_flowid            :  5 ; /* bits 4:0 */
    ca_uint32_t forward_act          :  3 ; /* bits 7:5 */
    ca_uint32_t cf_fwd_id            :  8 ; /* bits 15:8 */
    ca_uint32_t cact                 :  2 ; /* bits 17:16 */
    ca_uint32_t cvid                 : 12 ; /* bits 29:18 */
    ca_uint32_t cpri                 :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_FIB_DATA0                    0xf4301e20
#define L2FE_PONCLE_FIB_DATA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t csact                :  3 ; /* bits 2:0 */
    ca_uint32_t cs_vid               : 12 ; /* bits 14:3 */
    ca_uint32_t cs_pri               :  3 ; /* bits 17:15 */
    ca_uint32_t cspri_act            :  2 ; /* bits 19:18 */
    ca_uint32_t csvid_act            :  2 ; /* bits 21:20 */
    ca_uint32_t cscfi_keep           :  1 ; /* bits 22:22 */
    ca_uint32_t grpid_act            :  1 ; /* bits 23:23 */
    ca_uint32_t flowid_act           :  1 ; /* bits 24:24 */
    ca_uint32_t cf_flowid            :  7 ; /* bits 31:25 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * MIRE
 */
        
#define L2FE_MIRE_MIR_CTRL                       0xf4301f00
#define L2FE_MIRE_MIR_CTRL_dft                   0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt_drop_src_mir_en  :  1 ; /* bits 0:0 */
    ca_uint32_t pkt_keep_old         :  1 ; /* bits 1:1 */
    ca_uint32_t lspid_remap          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_RULE_SSID_0                0xf4301f04
#define L2FE_MIRE_MIR_RULE_SSID_0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_RULE_SSID_1                0xf4301f08
#define L2FE_MIRE_MIR_RULE_SSID_1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_RULE_SSID_2                0xf4301f0c
#define L2FE_MIRE_MIR_RULE_SSID_2_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_RULE_SSID_3                0xf4301f10
#define L2FE_MIRE_MIR_RULE_SSID_3_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_0_SSID_0               0xf4301f14
#define L2FE_MIRE_MIR_ACT_0_SSID_0_dft           0x0000433a

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_0_SSID_1               0xf4301f18
#define L2FE_MIRE_MIR_ACT_0_SSID_1_dft           0x0000437b

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_0_SSID_2               0xf4301f1c
#define L2FE_MIRE_MIR_ACT_0_SSID_2_dft           0x000043bc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_0_SSID_3               0xf4301f20
#define L2FE_MIRE_MIR_ACT_0_SSID_3_dft           0x000043fd

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_1_SSID_0               0xf4301f24
#define L2FE_MIRE_MIR_ACT_1_SSID_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rx_mirror            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_1_SSID_1               0xf4301f28
#define L2FE_MIRE_MIR_ACT_1_SSID_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rx_mirror            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_1_SSID_2               0xf4301f2c
#define L2FE_MIRE_MIR_ACT_1_SSID_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rx_mirror            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_1_SSID_3               0xf4301f30
#define L2FE_MIRE_MIR_ACT_1_SSID_3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rx_mirror            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_STTS_0                     0xf4301f34
#define L2FE_MIRE_MIR_STTS_0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_STTS_1                     0xf4301f38
#define L2FE_MIRE_MIR_STTS_1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_STTS_2                     0xf4301f3c
#define L2FE_MIRE_MIR_STTS_2_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_STTS_3                     0xf4301f40
#define L2FE_MIRE_MIR_STTS_3_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_PINGPONG_STS                   0xf4301f44
#define L2FE_MIRE_PINGPONG_STS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_DATA_FIFO_CNT                  0xf4301f48
#define L2FE_MIRE_DATA_FIFO_CNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t entry_cnt            :  7 ; /* bits 6:0 */
    ca_uint32_t seg_cnt              :  4 ; /* bits 10:7 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t extra_store_cnt      :  2 ; /* bits 17:16 */
    ca_uint32_t data_ltched          :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DATA_FIFO_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_DATA_FIFO_STTS                 0xf4301f4c
#define L2FE_MIRE_DATA_FIFO_STTS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DATA_FIFO_STTS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_DEBUG                          0xf4301f50
#define L2FE_MIRE_DEBUG_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DEBUG_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      
    
  
        

/*
 * L2TM
 */
  
/*
 * l2tm_glb
 */
        
#define L2TM_L2TM_GLB_REV_ID                     0xf4302000
#define L2TM_L2TM_GLB_REV_ID_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_REV_ID_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_INT                        0xf4302004
#define L2TM_L2TM_GLB_INT_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bm                   :  1 ; /* bits 0:0 */
    ca_uint32_t qm                   :  1 ; /* bits 1:1 */
    ca_uint32_t bm1                  :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_INTE                       0xf4302008
#define L2TM_L2TM_GLB_INTE_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bmE                  :  1 ; /* bits 0:0 */
    ca_uint32_t qmE                  :  1 ; /* bits 1:1 */
    ca_uint32_t bm1E                 :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_STS                        0xf430200c
#define L2TM_L2TM_GLB_STS_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t voqinfo_ram_init_done :  1 ; /* bits 14:14 */
    ca_uint32_t freeq_ram_init_done  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 14 ;
    ca_uint32_t idle                 :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_CTRL                       0xf4302010
#define L2TM_L2TM_GLB_CTRL_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t cntrcfg_clear_on_read :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_SPARE_CFG                  0xf4302014
#define L2TM_L2TM_GLB_SPARE_CFG_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_SPARE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_SPARE_STS                  0xf4302018
#define L2TM_L2TM_GLB_SPARE_STS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_SPARE_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_STC_SPSRAM_mbist_l2tm2a    0xf430201c
#define L2TM_L2TM_GLB_STC_SPSRAM_mbist_l2tm2a_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_STC_SPSRAM_mbist_l2tm2a_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_STC_SPSRAM_mbisr_l2tm_repair1 0xf4302020
#define L2TM_L2TM_GLB_STC_SPSRAM_mbisr_l2tm_repair1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_STC_SPSRAM_mbisr_l2tm_repair1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_FPGA_REV_ID                0xf4302024
#define L2TM_L2TM_GLB_FPGA_REV_ID_dft            0x00000084

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t FPGA_ver             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_FPGA_REV_ID_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2tm_bm
 */
        
#define L2TM_L2TM_BM_INT                         0xf4302100
#define L2TM_L2TM_BM_INT_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sb_drop              :  1 ; /* bits 0:0 */
    ca_uint32_t hdr_drop             :  1 ; /* bits 1:1 */
    ca_uint32_t te_drop              :  1 ; /* bits 2:2 */
    ca_uint32_t wvoqid               :  1 ; /* bits 3:3 */
    ca_uint32_t szerr                :  1 ; /* bits 4:4 */
    ca_uint32_t seglenerr            :  1 ; /* bits 5:5 */
    ca_uint32_t seq_err              :  1 ; /* bits 6:6 */
    ca_uint32_t fc_mirror_drop       :  1 ; /* bits 7:7 */
    ca_uint32_t dq_sb_drop           :  1 ; /* bits 8:8 */
    ca_uint32_t dq_hdr_drop          :  1 ; /* bits 9:9 */
    ca_uint32_t dq_wvoqid            :  1 ; /* bits 10:10 */
    ca_uint32_t dq_szerr             :  1 ; /* bits 11:11 */
    ca_uint32_t dq_seglenerr         :  1 ; /* bits 12:12 */
    ca_uint32_t dq_seq_err           :  1 ; /* bits 13:13 */
    ca_uint32_t dq_ff_undrflo        :  1 ; /* bits 14:14 */
    ca_uint32_t dq_ff_ovrflo         :  1 ; /* bits 15:15 */
    ca_uint32_t dq_pack_ff_undrflo   :  1 ; /* bits 16:16 */
    ca_uint32_t dq_pack_ff_ovrflo    :  1 ; /* bits 17:17 */
    ca_uint32_t fe_ff_undrflo        :  1 ; /* bits 18:18 */
    ca_uint32_t fe_ff_ovrflo         :  1 ; /* bits 19:19 */
    ca_uint32_t pack_ff_undrflo      :  1 ; /* bits 20:20 */
    ca_uint32_t pack_ff_ovrflo       :  1 ; /* bits 21:21 */
    ca_uint32_t wdat_ff_undrflo      :  1 ; /* bits 22:22 */
    ca_uint32_t wdat_ff_ovrflo       :  1 ; /* bits 23:23 */
    ca_uint32_t wcmd_ff_undrflo      :  1 ; /* bits 24:24 */
    ca_uint32_t wcmd_ff_ovrflo       :  1 ; /* bits 25:25 */
    ca_uint32_t rdat_ff_undrflo      :  1 ; /* bits 26:26 */
    ca_uint32_t rdat_ff_ovrflo       :  1 ; /* bits 27:27 */
    ca_uint32_t rcmd_ff_undrflo      :  1 ; /* bits 28:28 */
    ca_uint32_t rcmd_ff_ovrflo       :  1 ; /* bits 29:29 */
    ca_uint32_t rcyc_ff_undrflo      :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_ovrflo       :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_INTE                        0xf4302104
#define L2TM_L2TM_BM_INTE_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sb_dropE             :  1 ; /* bits 0:0 */
    ca_uint32_t hdr_dropE            :  1 ; /* bits 1:1 */
    ca_uint32_t te_dropE             :  1 ; /* bits 2:2 */
    ca_uint32_t wvoqidE              :  1 ; /* bits 3:3 */
    ca_uint32_t szerrE               :  1 ; /* bits 4:4 */
    ca_uint32_t seglenerrE           :  1 ; /* bits 5:5 */
    ca_uint32_t seq_errE             :  1 ; /* bits 6:6 */
    ca_uint32_t fc_mirror_dropE      :  1 ; /* bits 7:7 */
    ca_uint32_t dq_sb_dropE          :  1 ; /* bits 8:8 */
    ca_uint32_t dq_hdr_dropE         :  1 ; /* bits 9:9 */
    ca_uint32_t dq_wvoqidE           :  1 ; /* bits 10:10 */
    ca_uint32_t dq_szerrE            :  1 ; /* bits 11:11 */
    ca_uint32_t dq_seglenerrE        :  1 ; /* bits 12:12 */
    ca_uint32_t dq_seq_errE          :  1 ; /* bits 13:13 */
    ca_uint32_t dq_ff_undrfloE       :  1 ; /* bits 14:14 */
    ca_uint32_t dq_ff_ovrfloE        :  1 ; /* bits 15:15 */
    ca_uint32_t dq_pack_ff_undrfloE  :  1 ; /* bits 16:16 */
    ca_uint32_t dq_pack_ff_ovrfloE   :  1 ; /* bits 17:17 */
    ca_uint32_t fe_ff_undrfloE       :  1 ; /* bits 18:18 */
    ca_uint32_t fe_ff_ovrfloE        :  1 ; /* bits 19:19 */
    ca_uint32_t pack_ff_undrfloE     :  1 ; /* bits 20:20 */
    ca_uint32_t pack_ff_ovrfloE      :  1 ; /* bits 21:21 */
    ca_uint32_t wdat_ff_undrfloE     :  1 ; /* bits 22:22 */
    ca_uint32_t wdat_ff_ovrfloE      :  1 ; /* bits 23:23 */
    ca_uint32_t wcmd_ff_undrfloE     :  1 ; /* bits 24:24 */
    ca_uint32_t wcmd_ff_ovrfloE      :  1 ; /* bits 25:25 */
    ca_uint32_t rdat_ff_undrfloE     :  1 ; /* bits 26:26 */
    ca_uint32_t rdat_ff_ovrfloE      :  1 ; /* bits 27:27 */
    ca_uint32_t rcmd_ff_undrfloE     :  1 ; /* bits 28:28 */
    ca_uint32_t rcmd_ff_ovrfloE      :  1 ; /* bits 29:29 */
    ca_uint32_t rcyc_ff_undrfloE     :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_ovrfloE      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_INT1                        0xf4302108
#define L2TM_L2TM_BM_INT1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t abr_flush_cos0       :  1 ; /* bits 0:0 */
    ca_uint32_t abr_flush_cos1       :  1 ; /* bits 1:1 */
    ca_uint32_t abr_flush_cos2       :  1 ; /* bits 2:2 */
    ca_uint32_t abr_flush_cos3       :  1 ; /* bits 3:3 */
    ca_uint32_t abr_flush_cos4       :  1 ; /* bits 4:4 */
    ca_uint32_t abr_flush_cos5       :  1 ; /* bits 5:5 */
    ca_uint32_t abr_flush_cos6       :  1 ; /* bits 6:6 */
    ca_uint32_t abr_flush_cos7       :  1 ; /* bits 7:7 */
    ca_uint32_t abr_drop_cos0        :  1 ; /* bits 8:8 */
    ca_uint32_t abr_drop_cos1        :  1 ; /* bits 9:9 */
    ca_uint32_t abr_drop_cos2        :  1 ; /* bits 10:10 */
    ca_uint32_t abr_drop_cos3        :  1 ; /* bits 11:11 */
    ca_uint32_t abr_drop_cos4        :  1 ; /* bits 12:12 */
    ca_uint32_t abr_drop_cos5        :  1 ; /* bits 13:13 */
    ca_uint32_t abr_drop_cos6        :  1 ; /* bits 14:14 */
    ca_uint32_t abr_drop_cos7        :  1 ; /* bits 15:15 */
    ca_uint32_t dq_abr_drop_cos0     :  1 ; /* bits 16:16 */
    ca_uint32_t dq_abr_drop_cos1     :  1 ; /* bits 17:17 */
    ca_uint32_t dq_abr_drop_cos2     :  1 ; /* bits 18:18 */
    ca_uint32_t dq_abr_drop_cos3     :  1 ; /* bits 19:19 */
    ca_uint32_t dq_abr_drop_cos4     :  1 ; /* bits 20:20 */
    ca_uint32_t dq_abr_drop_cos5     :  1 ; /* bits 21:21 */
    ca_uint32_t dq_abr_drop_cos6     :  1 ; /* bits 22:22 */
    ca_uint32_t dq_abr_drop_cos7     :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INT1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_INT1E                       0xf430210c
#define L2TM_L2TM_BM_INT1E_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t abr_flush_cos0E      :  1 ; /* bits 0:0 */
    ca_uint32_t abr_flush_cos1E      :  1 ; /* bits 1:1 */
    ca_uint32_t abr_flush_cos2E      :  1 ; /* bits 2:2 */
    ca_uint32_t abr_flush_cos3E      :  1 ; /* bits 3:3 */
    ca_uint32_t abr_flush_cos4E      :  1 ; /* bits 4:4 */
    ca_uint32_t abr_flush_cos5E      :  1 ; /* bits 5:5 */
    ca_uint32_t abr_flush_cos6E      :  1 ; /* bits 6:6 */
    ca_uint32_t abr_flush_cos7E      :  1 ; /* bits 7:7 */
    ca_uint32_t abr_drop_cos0E       :  1 ; /* bits 8:8 */
    ca_uint32_t abr_drop_cos1E       :  1 ; /* bits 9:9 */
    ca_uint32_t abr_drop_cos2E       :  1 ; /* bits 10:10 */
    ca_uint32_t abr_drop_cos3E       :  1 ; /* bits 11:11 */
    ca_uint32_t abr_drop_cos4E       :  1 ; /* bits 12:12 */
    ca_uint32_t abr_drop_cos5E       :  1 ; /* bits 13:13 */
    ca_uint32_t abr_drop_cos6E       :  1 ; /* bits 14:14 */
    ca_uint32_t abr_drop_cos7E       :  1 ; /* bits 15:15 */
    ca_uint32_t dq_abr_drop_cos0E    :  1 ; /* bits 16:16 */
    ca_uint32_t dq_abr_drop_cos1E    :  1 ; /* bits 17:17 */
    ca_uint32_t dq_abr_drop_cos2E    :  1 ; /* bits 18:18 */
    ca_uint32_t dq_abr_drop_cos3E    :  1 ; /* bits 19:19 */
    ca_uint32_t dq_abr_drop_cos4E    :  1 ; /* bits 20:20 */
    ca_uint32_t dq_abr_drop_cos5E    :  1 ; /* bits 21:21 */
    ca_uint32_t dq_abr_drop_cos6E    :  1 ; /* bits 22:22 */
    ca_uint32_t dq_abr_drop_cos7E    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INT1E_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_CTRL                        0xf4302110
#define L2TM_L2TM_BM_CTRL_dft                    0xc0000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rx_drop_cos          :  3 ; /* bits 2:0 */
    ca_uint32_t rx_drop_pid          :  4 ; /* bits 6:3 */
    ca_uint32_t rx_drop_en           :  2 ; /* bits 8:7 */
    ca_uint32_t sb_drop_dis          :  1 ; /* bits 9:9 */
    ca_uint32_t hdr_drop_code_upd_en :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t min_pktlen           :  7 ; /* bits 30:24 */
    ca_uint32_t rx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP        0xf4302114
#define L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_dft    0xfedcba98

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP        0xf4302118
#define L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_dft    0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP     0xf430211c
#define L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_dft 0x00000076

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t rxpfc_0              :  1 ; /* bits 8:8 */
    ca_uint32_t rxpfc_1              :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP          0xf4302120
#define L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_dft      0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_LANL3FE_QUEUE_MAP     0xf4302124
#define L2TM_L2TM_BM_TM_TO_LANL3FE_QUEUE_MAP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd5               :  3 ;
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd6               :  3 ;
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd7               :  3 ;
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd8               :  3 ;
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_LANL3FE_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP          0xf4302128
#define L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_dft      0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP           0xf430212c
#define L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_dft       0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tm_dpid_sel_0        :  4 ; /* bits 3:0 */
    ca_uint32_t tm_dpid_sel_1        :  4 ; /* bits 7:4 */
    ca_uint32_t tm_dpid_sel_2        :  4 ; /* bits 11:8 */
    ca_uint32_t tm_dpid_sel_3        :  4 ; /* bits 15:12 */
    ca_uint32_t tm_dpid_sel_4        :  4 ; /* bits 19:16 */
    ca_uint32_t tm_dpid_sel_5        :  4 ; /* bits 23:20 */
    ca_uint32_t tm_dpid_sel_6        :  4 ; /* bits 27:24 */
    ca_uint32_t tm_dpid_sel_7        :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_DQ_PCNT                  0xf4302130
#define L2TM_L2TM_BM_RX_DQ_PCNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DQ_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_DQ_DPCNT                 0xf4302134
#define L2TM_L2TM_BM_RX_DQ_DPCNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DQ_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_DQ_ABR_DPCNT             0xf4302138
#define L2TM_L2TM_BM_RX_DQ_ABR_DPCNT_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DQ_ABR_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_PCNT                     0xf430213c
#define L2TM_L2TM_BM_RX_PCNT_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TX_PCNT                     0xf4302140
#define L2TM_L2TM_BM_TX_PCNT_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_SB_DPCNT                    0xf4302144
#define L2TM_L2TM_BM_SB_DPCNT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_SB_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_HDR_DPCNT                   0xf4302148
#define L2TM_L2TM_BM_HDR_DPCNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_HDR_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TE_DPCNT                    0xf430214c
#define L2TM_L2TM_BM_TE_DPCNT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TE_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_ERR_DPCNT                   0xf4302150
#define L2TM_L2TM_BM_ERR_DPCNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_ERR_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_FC_MIRROR0_DPCNT            0xf4302154
#define L2TM_L2TM_BM_FC_MIRROR0_DPCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_FC_MIRROR1_DPCNT            0xf4302158
#define L2TM_L2TM_BM_FC_MIRROR1_DPCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_FC_MIRROR2_DPCNT            0xf430215c
#define L2TM_L2TM_BM_FC_MIRROR2_DPCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_FC_MIRROR3_DPCNT            0xf4302160
#define L2TM_L2TM_BM_FC_MIRROR3_DPCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_DPCNT                    0xf4302164
#define L2TM_L2TM_BM_RX_DPCNT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_ABR_DPCNT                0xf4302168
#define L2TM_L2TM_BM_RX_ABR_DPCNT_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_ABR_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_NOBUF_DPCNT                 0xf430216c
#define L2TM_L2TM_BM_NOBUF_DPCNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_NOBUF_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_FE_HEADER_31_0           0xf4302170
#define L2TM_L2TM_BM_RX_FE_HEADER_31_0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_FE_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_FE_HEADER_63_32          0xf4302174
#define L2TM_L2TM_BM_RX_FE_HEADER_63_32_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_FE_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_NI_HEADER_31_0           0xf4302178
#define L2TM_L2TM_BM_RX_NI_HEADER_31_0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_NI_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_NI_HEADER_63_32          0xf430217c
#define L2TM_L2TM_BM_RX_NI_HEADER_63_32_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_NI_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TX_NI_HEADER_31_0           0xf4302180
#define L2TM_L2TM_BM_TX_NI_HEADER_31_0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_NI_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TX_NI_HEADER_63_32          0xf4302184
#define L2TM_L2TM_BM_TX_NI_HEADER_63_32_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_NI_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_STS                         0xf4302188
#define L2TM_L2TM_BM_STS_dft                     0xff80000a

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fe_tm_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t tm_fe_rdy            :  1 ; /* bits 1:1 */
    ca_uint32_t ni_tm_vld            :  1 ; /* bits 2:2 */
    ca_uint32_t tm_ni_rdy            :  1 ; /* bits 3:3 */
    ca_uint32_t tm_ni_vld            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t dq_ff_empty          :  1 ; /* bits 23:23 */
    ca_uint32_t dq_pack_ff_empty     :  1 ; /* bits 24:24 */
    ca_uint32_t fe_ff_empty          :  1 ; /* bits 25:25 */
    ca_uint32_t pack_ff_empty        :  1 ; /* bits 26:26 */
    ca_uint32_t wdat_ff_empty        :  1 ; /* bits 27:27 */
    ca_uint32_t wcmd_ff_empty        :  1 ; /* bits 28:28 */
    ca_uint32_t rdat_ff_empty        :  1 ; /* bits 29:29 */
    ca_uint32_t rcmd_ff_empty        :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_empty        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_ACCESS              0xf430218c
#define L2TM_L2TM_BM_PKT_MEM_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA7               0xf4302190
#define L2TM_L2TM_BM_PKT_MEM_DATA7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA6               0xf4302194
#define L2TM_L2TM_BM_PKT_MEM_DATA6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA5               0xf4302198
#define L2TM_L2TM_BM_PKT_MEM_DATA5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA4               0xf430219c
#define L2TM_L2TM_BM_PKT_MEM_DATA4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA3               0xf43021a0
#define L2TM_L2TM_BM_PKT_MEM_DATA3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA2               0xf43021a4
#define L2TM_L2TM_BM_PKT_MEM_DATA2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA1               0xf43021a8
#define L2TM_L2TM_BM_PKT_MEM_DATA1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA0               0xf43021ac
#define L2TM_L2TM_BM_PKT_MEM_DATA0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_OD_DBG0                     0xf43021b0
#define L2TM_L2TM_BM_OD_DBG0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t od_dbg0              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_OD_DBG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_OD_DBG1                     0xf43021b4
#define L2TM_L2TM_BM_OD_DBG1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t od_dbg1              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_OD_DBG1_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2tm_qm
 */
        
#define L2TM_L2TM_QM_INT                         0xf4302200
#define L2TM_L2TM_QM_INT_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t freeq_ecc_correctederr :  1 ; /* bits 0:0 */
    ca_uint32_t freeq_ecc_err        :  1 ; /* bits 1:1 */
    ca_uint32_t voqinfo_cnt_dec_with_novalid :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t nobuf_drop           :  1 ; /* bits 4:4 */
    ca_uint32_t bid_out_of_range     :  1 ; /* bits 5:5 */
    ca_uint32_t wr_race_err          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eq0_stack_err        :  1 ; /* bits 16:16 */
    ca_uint32_t eq1_stack_err        :  1 ; /* bits 17:17 */
    ca_uint32_t enq_ff_undrflo       :  1 ; /* bits 18:18 */
    ca_uint32_t enq_ff_ovrflo        :  1 ; /* bits 19:19 */
    ca_uint32_t deq_ff_undrflo       :  1 ; /* bits 20:20 */
    ca_uint32_t deq_ff_ovrflo        :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_INTE                        0xf4302204
#define L2TM_L2TM_QM_INTE_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t freeq_ecc_correctederrE :  1 ; /* bits 0:0 */
    ca_uint32_t freeq_ecc_errE       :  1 ; /* bits 1:1 */
    ca_uint32_t voqinfo_cnt_dec_with_novalidE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t nobuf_dropE          :  1 ; /* bits 4:4 */
    ca_uint32_t bid_out_of_rangeE    :  1 ; /* bits 5:5 */
    ca_uint32_t wr_race_errE         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eq0_stack_errE       :  1 ; /* bits 16:16 */
    ca_uint32_t eq1_stack_errE       :  1 ; /* bits 17:17 */
    ca_uint32_t enq_ff_undrfloE      :  1 ; /* bits 18:18 */
    ca_uint32_t enq_ff_ovrfloE       :  1 ; /* bits 19:19 */
    ca_uint32_t deq_ff_undrfloE      :  1 ; /* bits 20:20 */
    ca_uint32_t deq_ff_ovrfloE       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_CFG                      0xf4302208
#define L2TM_L2TM_QM_EQ_CFG_dft                  0x00040008

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq0_bufnum           :  5 ; /* bits 4:0 */
    ca_uint32_t eq0_prvt             : 11 ; /* bits 15:5 */
    ca_uint32_t eq1_bufnum           :  4 ; /* bits 19:16 */
    ca_uint32_t eq1_prvt             : 10 ; /* bits 29:20 */
    ca_uint32_t eq0_en               :  1 ; /* bits 30:30 */
    ca_uint32_t eq1_en               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_CFG1                     0xf430220c
#define L2TM_L2TM_QM_EQ_CFG1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq0_buffer_weight    :  1 ; /* bits 0:0 */
    ca_uint32_t eq1_buffer_weight    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_CFG1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_GLOB_BUF_CFG                0xf4302210
#define L2TM_L2TM_QM_GLOB_BUF_CFG_dft            0x90000020

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t nodrop               : 15 ; /* bits 14:0 */
    ca_uint32_t drop_en              :  1 ; /* bits 15:15 */
    ca_uint32_t noncong              : 15 ; /* bits 30:16 */
    ca_uint32_t fe_bp_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_GLOB_BUF_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_GLOB_BUF_CFG1               0xf4302214
#define L2TM_L2TM_QM_GLOB_BUF_CFG1_dft           0x00000010

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fe_bp_th             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_GLOB_BUF_CFG1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE0          0xf4302218
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE0_dft      0x00100000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE1          0xf430221c
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE1_dft      0x00400020

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE2          0xf4302220
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE2_dft      0x00c00080

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE3          0xf4302224
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE3_dft      0x01400100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_SELECT0           0xf4302228
#define L2TM_L2TM_QM_PORT_PRVT_SELECT0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port0                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t port1                :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t port2                :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t port3                :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t port4                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t port5                :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t port6                :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t port7                :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_SELECT0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_SELECT1           0xf430222c
#define L2TM_L2TM_QM_PORT_PRVT_SELECT1_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port0                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t port1                :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t port2                :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t port3                :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t port4                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t port5                :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t port6                :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t port7                :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_SELECT1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_NO_PRVT_STS            0xf4302230
#define L2TM_L2TM_QM_PORT_NO_PRVT_STS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pid                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_NO_PRVT_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_GLB_FREECNT              0xf4302234
#define L2TM_L2TM_QM_EQ_GLB_FREECNT_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sum_of_eqcnt         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_GLB_FREECNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_COS0_BUFCNT              0xf4302238
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_STRIDE       4
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_COUNT        8
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sum_of_eqcnt         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_COS0_BUFCNT_t;
#endif /* !__ASSEMBLER__ */

                            
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS 0xf4302258
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA   0xf430225c
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_FREECNT                  0xf4302260
#define L2TM_L2TM_QM_EQ_FREECNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eq1                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_FREECNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_HEAD                     0xf4302264
#define L2TM_L2TM_QM_EQ_HEAD_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eq1                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_HEAD_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ0_STACK_CFG               0xf4302268
#define L2TM_L2TM_QM_EQ0_STACK_CFG_dft           0x00302010

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mid_ths              :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t high_ths             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ0_STACK_CTRL              0xf430226c
#define L2TM_L2TM_QM_EQ0_STACK_CTRL_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ0_STACK_STS               0xf4302270
#define L2TM_L2TM_QM_EQ0_STACK_STS_dft           0x00000007

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill_done    :  1 ; /* bits 0:0 */
    ca_uint32_t stack_idle           :  1 ; /* bits 1:1 */
    ca_uint32_t stack_empty          :  1 ; /* bits 2:2 */
    ca_uint32_t stack_full           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t stack_cntr           :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ1_STACK_CFG               0xf4302274
#define L2TM_L2TM_QM_EQ1_STACK_CFG_dft           0x00302010

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mid_ths              :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t high_ths             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ1_STACK_CTRL              0xf4302278
#define L2TM_L2TM_QM_EQ1_STACK_CTRL_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ1_STACK_STS               0xf430227c
#define L2TM_L2TM_QM_EQ1_STACK_STS_dft           0x00000007

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill_done    :  1 ; /* bits 0:0 */
    ca_uint32_t stack_idle           :  1 ; /* bits 1:1 */
    ca_uint32_t stack_empty          :  1 ; /* bits 2:2 */
    ca_uint32_t stack_full           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t stack_cntr           :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_CTRL                        0xf4302280
#define L2TM_L2TM_QM_CTRL_dft                    0x0000000a

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pcnt_dec_with_novalid_allow :  1 ; /* bits 0:0 */
    ca_uint32_t ack_upd_at_same_time :  1 ; /* bits 1:1 */
    ca_uint32_t l3fe_dpid_delay      :  1 ; /* bits 2:2 */
    ca_uint32_t same_dpid_delay      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_STS                         0xf4302284
#define L2TM_L2TM_QM_STS_dft                     0x000c0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t plm_nempty           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t enq_ff_empty         :  1 ; /* bits 18:18 */
    ca_uint32_t deq_ff_empty         :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_STS1                        0xf4302288
#define L2TM_L2TM_QM_STS1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t init_adr             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t init_data            :  8 ; /* bits 23:16 */
    ca_uint32_t freeq_cs             :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t sm_reset             :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_STS1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_FREEQ_MEM_ACCESS            0xf430228c
#define L2TM_L2TM_QM_FREEQ_MEM_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_FREEQ_MEM_DATA1             0xf4302290
#define L2TM_L2TM_QM_FREEQ_MEM_DATA1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ecc                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_FREEQ_MEM_DATA0             0xf4302294
#define L2TM_L2TM_QM_FREEQ_MEM_DATA0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t blen                 :  7 ; /* bits 6:0 */
    ca_uint32_t eqid                 :  1 ; /* bits 7:7 */
    ca_uint32_t eop                  :  1 ; /* bits 8:8 */
    ca_uint32_t sop                  :  1 ; /* bits 9:9 */
    ca_uint32_t cpu                  :  1 ; /* bits 10:10 */
    ca_uint32_t prvt                 :  1 ; /* bits 11:11 */
    ca_uint32_t nxt_ptr              : 15 ; /* bits 26:12 */
    ca_uint32_t ecc                  :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQINFO_MEM_ACCESS          0xf4302298
#define L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQINFO_MEM_DATA1           0xf430229c
#define L2TM_L2TM_QM_VOQINFO_MEM_DATA1_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tail_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t vallid               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQINFO_MEM_DATA0           0xf43022a0
#define L2TM_L2TM_QM_VOQINFO_MEM_DATA0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t blen                 :  7 ; /* bits 6:0 */
    ca_uint32_t eqid                 :  1 ; /* bits 7:7 */
    ca_uint32_t eop                  :  1 ; /* bits 8:8 */
    ca_uint32_t sop                  :  1 ; /* bits 9:9 */
    ca_uint32_t cpu                  :  1 ; /* bits 10:10 */
    ca_uint32_t prvt                 :  1 ; /* bits 11:11 */
    ca_uint32_t head_ptr             : 15 ; /* bits 26:12 */
    ca_uint32_t tail_ptr             :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS         0xf43022a4
#define L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA           0xf43022a8
#define L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2tm_es
 */
        
#define L2TM_L2TM_ES_CTRL                        0xf4302300
#define L2TM_L2TM_ES_CTRL_dft                    0x24000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tx_port0_en          :  1 ; /* bits 0:0 */
    ca_uint32_t tx_port1_en          :  1 ; /* bits 1:1 */
    ca_uint32_t tx_port2_en          :  1 ; /* bits 2:2 */
    ca_uint32_t tx_port3_en          :  1 ; /* bits 3:3 */
    ca_uint32_t tx_port4_en          :  1 ; /* bits 4:4 */
    ca_uint32_t tx_port5_en          :  1 ; /* bits 5:5 */
    ca_uint32_t tx_port6_en          :  1 ; /* bits 6:6 */
    ca_uint32_t tx_port7_en          :  1 ; /* bits 7:7 */
    ca_uint32_t tx_port8_en          :  1 ; /* bits 8:8 */
    ca_uint32_t tx_port9_en          :  1 ; /* bits 9:9 */
    ca_uint32_t tx_port10_en         :  1 ; /* bits 10:10 */
    ca_uint32_t tx_port11_en         :  1 ; /* bits 11:11 */
    ca_uint32_t tx_port12_en         :  1 ; /* bits 12:12 */
    ca_uint32_t tx_port13_en         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tx_port15_en         :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 10 ;
    ca_uint32_t ni_port_rdy_10_deglitch :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t ni_port_rdy_13_deglitch :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t tx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_SCH_CFG0                    0xf4302304
#define L2TM_L2TM_ES_SCH_CFG0_STRIDE             12
#define L2TM_L2TM_ES_SCH_CFG0_COUNT              15
#define L2TM_L2TM_ES_SCH_CFG0_dft                0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_en               :  8 ; /* bits 7:0 */
    ca_uint32_t flush_voqid          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t flush_en             :  1 ; /* bits 15:15 */
    ca_uint32_t speed                :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_SCH_CFG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0    0xf4302308
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_STRIDE 12
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_COUNT 15
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq0                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq1                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq2                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq3                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0    0xf430230c
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_STRIDE 12
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_COUNT 15
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq4                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq5                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq6                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq7                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t;
#endif /* !__ASSEMBLER__ */

                                                                                                                                                                        
#define L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG    0xf43023b8
#define L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port0                :  8 ; /* bits 7:0 */
    ca_uint32_t port1                :  8 ; /* bits 15:8 */
    ca_uint32_t port2                :  8 ; /* bits 23:16 */
    ca_uint32_t port3                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG    0xf43023bc
#define L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port4                :  8 ; /* bits 7:0 */
    ca_uint32_t port5                :  8 ; /* bits 15:8 */
    ca_uint32_t port6                :  8 ; /* bits 23:16 */
    ca_uint32_t port7                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG   0xf43023c0
#define L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port8                :  8 ; /* bits 7:0 */
    ca_uint32_t port9                :  8 ; /* bits 15:8 */
    ca_uint32_t port10               :  8 ; /* bits 23:16 */
    ca_uint32_t port11               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG  0xf43023c4
#define L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_dft 0x01000101

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port12               :  8 ; /* bits 7:0 */
    ca_uint32_t port13               :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t port15               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_DRR_WEIGHT_BASE             0xf43023c8
#define L2TM_L2TM_ES_DRR_WEIGHT_BASE_dft         0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t w_rate               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t base_select          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t dwrr_unit            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_DRR_WEIGHT_BASE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_CFG                         0xf43023cc
#define L2TM_L2TM_ES_CFG_dft                     0x00000740

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sch_ack_len          :  8 ; /* bits 7:0 */
    ca_uint32_t sch_sync_upd         :  1 ; /* bits 8:8 */
    ca_uint32_t sch_rr_grant         :  1 ; /* bits 9:9 */
    ca_uint32_t sch_ack_solo         :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t sch_port_mod         :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_STS                         0xf43023d0
#define L2TM_L2TM_ES_STS_dft                     0x00003fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ni_port_rdy          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_STS0                    0xf43023d4
#define L2TM_L2TM_ES_VOQ_STS0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_STS1                    0xf43023d8
#define L2TM_L2TM_ES_VOQ_STS1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_STS2                    0xf43023dc
#define L2TM_L2TM_ES_VOQ_STS2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_STS3                    0xf43023e0
#define L2TM_L2TM_ES_VOQ_STS3_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_OK_STS0                 0xf43023e4
#define L2TM_L2TM_ES_VOQ_OK_STS0_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_OK_STS1                 0xf43023e8
#define L2TM_L2TM_ES_VOQ_OK_STS1_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_OK_STS2                 0xf43023ec
#define L2TM_L2TM_ES_VOQ_OK_STS2_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_OK_STS3                 0xf43023f0
#define L2TM_L2TM_ES_VOQ_OK_STS3_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT_OK_STS                 0xf43023f4
#define L2TM_L2TM_ES_PORT_OK_STS_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pid                  : 16 ; /* bits 15:0 */
    ca_uint32_t voq_grp              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT_OK_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_ABR_STS                     0xf43023f8
#define L2TM_L2TM_ES_ABR_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port7_voq_abr_drop_sts :  8 ; /* bits 7:0 */
    ca_uint32_t port7_abr_ovthrsh    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_ABR_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_ABR_FLUSH_PCNT              0xf43023fc
#define L2TM_L2TM_ES_ABR_FLUSH_PCNT_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_ABR_FLUSH_PCNT_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2te_glb
 */
        
#define L2TM_L2TE_GLB_REV_ID                     0xf4302400
#define L2TM_L2TE_GLB_REV_ID_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_REV_ID_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_CTRL                       0xf4302404
#define L2TM_L2TE_GLB_CTRL_dft                   0x07000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_en               :  1 ; /* bits 0:0 */
    ca_uint32_t shp_en               :  1 ; /* bits 1:1 */
    ca_uint32_t taildrop_en          :  1 ; /* bits 2:2 */
    ca_uint32_t wred_en              :  1 ; /* bits 3:3 */
    ca_uint32_t mark_ecn_en          :  1 ; /* bits 4:4 */
    ca_uint32_t pol_ecn_en           :  1 ; /* bits 5:5 */
    ca_uint32_t wred_ecn_en          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t port8_empty_sel      :  1 ; /* bits 14:14 */
    ca_uint32_t snoop_l3_voq_taildrop_dis :  1 ; /* bits 15:15 */
    ca_uint32_t glb_deepq_port_rdy_en :  8 ; /* bits 23:16 */
    ca_uint32_t glb_deepq_port_rdy_id :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t puc_tqm_voqbp_7_0_dis :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_INT                        0xf4302408
#define L2TM_L2TE_GLB_INT_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_mark             :  1 ; /* bits 0:0 */
    ca_uint32_t pol_drop             :  1 ; /* bits 1:1 */
    ca_uint32_t tail_drop            :  1 ; /* bits 2:2 */
    ca_uint32_t wred_y_drop          :  1 ; /* bits 3:3 */
    ca_uint32_t wred_g_drop          :  1 ; /* bits 4:4 */
    ca_uint32_t ecn                  :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t feio                 :  1 ; /* bits 14:14 */
    ca_uint32_t tmio                 :  1 ; /* bits 15:15 */
    ca_uint32_t cb                   :  1 ; /* bits 16:16 */
    ca_uint32_t fc                   :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_INTE                       0xf430240c
#define L2TM_L2TE_GLB_INTE_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_markE            :  1 ; /* bits 0:0 */
    ca_uint32_t pol_dropE            :  1 ; /* bits 1:1 */
    ca_uint32_t tail_dropE           :  1 ; /* bits 2:2 */
    ca_uint32_t wred_y_dropE         :  1 ; /* bits 3:3 */
    ca_uint32_t wred_g_dropE         :  1 ; /* bits 4:4 */
    ca_uint32_t ecnE                 :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t feioE                :  1 ; /* bits 14:14 */
    ca_uint32_t tmioE                :  1 ; /* bits 15:15 */
    ca_uint32_t cbE                  :  1 ; /* bits 16:16 */
    ca_uint32_t fcE                  :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_STS                        0xf4302410
#define L2TM_L2TE_GLB_STS_dft                    0x07000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_fifo_ovrn        :  1 ; /* bits 0:0 */
    ca_uint32_t l2io_fifo_ovrn       :  1 ; /* bits 1:1 */
    ca_uint32_t qmio_enq_ovrn        :  1 ; /* bits 2:2 */
    ca_uint32_t qmio_deq_ovrn        :  1 ; /* bits 3:3 */
    ca_uint32_t qmio_shp_ovrn        :  1 ; /* bits 4:4 */
    ca_uint32_t te_qm_nrdy           :  1 ; /* bits 5:5 */
    ca_uint32_t ptp_fifo_err         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t pol_init_done        :  1 ; /* bits 12:12 */
    ca_uint32_t shp_init_done        :  1 ; /* bits 13:13 */
    ca_uint32_t cb_init_done         :  1 ; /* bits 14:14 */
    ca_uint32_t wred_init_done       :  1 ; /* bits 15:15 */
    ca_uint32_t feio_sm              :  4 ; /* bits 19:16 */
    ca_uint32_t fe_te_req            :  1 ; /* bits 20:20 */
    ca_uint32_t te_fe_ack            :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t l2io_idle            :  1 ; /* bits 24:24 */
    ca_uint32_t qmio_idle            :  1 ; /* bits 25:25 */
    ca_uint32_t ptp_fifo_idle        :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_PTP_CFG                    0xf4302414
#define L2TM_L2TE_GLB_PTP_CFG_dft                0x000007ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_id               :  8 ; /* bits 7:0 */
    ca_uint32_t pol_grp_id           :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pol_en               :  1 ; /* bits 12:12 */
    ca_uint32_t pol_grp_en           :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_PTP_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SPARE_CFG                  0xf4302418
#define L2TM_L2TE_GLB_SPARE_CFG_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SPARE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SPARE_STS                  0xf430241c
#define L2TM_L2TE_GLB_SPARE_STS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SPARE_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te1     0xf4302420
#define L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te2     0xf4302424
#define L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te3     0xf4302428
#define L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_STC_SPSRAM_mbist_l2te3_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2te_pol
 */
        
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0             0xf4302500
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_STRIDE      4
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_COUNT       16
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_dft         0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_CTRL0_t;
#endif /* !__ASSEMBLER__ */

                                                            
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS 0xf4302540
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2 0xf4302544
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1 0xf4302548
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0 0xf430254c
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS 0xf4302550
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1 0xf4302554
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0 0xf4302558
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_CTRL0                 0xf430255c
#define L2TM_L2TE_POL_PORT_CTRL0_STRIDE          4
#define L2TM_L2TE_POL_PORT_CTRL0_COUNT           16
#define L2TM_L2TE_POL_PORT_CTRL0_dft             0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_CTRL0_t;
#endif /* !__ASSEMBLER__ */

                                                            
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS    0xf430259c
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2     0xf43025a0
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1     0xf43025a4
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0     0xf43025a8
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS    0xf43025ac
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1     0xf43025b0
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0     0xf43025b4
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_CTRL0              0xf43025b8
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_STRIDE       4
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_COUNT        8
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_dft          0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_CTRL0_t;
#endif /* !__ASSEMBLER__ */

                            
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS 0xf43025d8
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2  0xf43025dc
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1  0xf43025e0
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0  0xf43025e4
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS 0xf43025e8
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1  0xf43025ec
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0  0xf43025f0
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_TB_CTRL                    0xf43025f4
#define L2TM_L2TE_POL_TB_CTRL_dft                0x2ff3e723

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addtok_en            :  1 ; /* bits 0:0 */
    ca_uint32_t subtok_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t upd_cnt_lmt          :  4 ; /* bits 7:4 */
    ca_uint32_t cyc_cnt_lmt          : 12 ; /* bits 19:8 */
    ca_uint32_t last_upd_cyc         : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_TB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_TB_CTRL1                   0xf43025f8
#define L2TM_L2TE_POL_TB_CTRL1_dft               0x000001f3

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t k_cnt_lmt            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_TB_CTRL1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_fpga_debug_data0           0xf43025fc
#define L2TM_L2TE_POL_fpga_debug_data0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_fpga_debug_data0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_fpga_debug_data1           0xf4302600
#define L2TM_L2TE_POL_fpga_debug_data1_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_fpga_debug_data1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_fpga_debug_data2           0xf4302604
#define L2TM_L2TE_POL_fpga_debug_data2_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_fpga_debug_data2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_fpga_debug_data3           0xf4302608
#define L2TM_L2TE_POL_fpga_debug_data3_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_fpga_debug_data3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_fpga_debug_data4           0xf430260c
#define L2TM_L2TE_POL_fpga_debug_data4_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_fpga_debug_data4_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2te_shp
 */
        
#define L2TM_L2TE_SHP_IPG_PROFILE                0xf4302700
#define L2TM_L2TE_SHP_IPG_PROFILE_dft            0x14141414

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ipg0                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t ipg1                 :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ipg2                 :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t ipg3                 :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_IPG_PROFILE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_PORT_IPG_SELECT0           0xf4302704
#define L2TM_L2TE_SHP_PORT_IPG_SELECT0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pid0                 :  2 ; /* bits 1:0 */
    ca_uint32_t pid1                 :  2 ; /* bits 3:2 */
    ca_uint32_t pid2                 :  2 ; /* bits 5:4 */
    ca_uint32_t pid3                 :  2 ; /* bits 7:6 */
    ca_uint32_t pid4                 :  2 ; /* bits 9:8 */
    ca_uint32_t pid5                 :  2 ; /* bits 11:10 */
    ca_uint32_t pid6                 :  2 ; /* bits 13:12 */
    ca_uint32_t pid7                 :  2 ; /* bits 15:14 */
    ca_uint32_t pid8                 :  2 ; /* bits 17:16 */
    ca_uint32_t pid9                 :  2 ; /* bits 19:18 */
    ca_uint32_t pid10                :  2 ; /* bits 21:20 */
    ca_uint32_t pid11                :  2 ; /* bits 23:22 */
    ca_uint32_t pid12                :  2 ; /* bits 25:24 */
    ca_uint32_t pid13                :  2 ; /* bits 27:26 */
    ca_uint32_t pid14                :  2 ; /* bits 29:28 */
    ca_uint32_t pid15                :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_IPG_SELECT0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_SRP_CONFIG0                0xf4302708
#define L2TM_L2TE_SHP_SRP_CONFIG0_STRIDE         4
#define L2TM_L2TE_SHP_SRP_CONFIG0_COUNT          2
#define L2TM_L2TE_SHP_SRP_CONFIG0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cfg0_enb             :  1 ; /* bits 0:0 */
    ca_uint32_t cfg0_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t cfg0_class_b         :  1 ; /* bits 15:15 */
    ca_uint32_t cfg1_enb             :  1 ; /* bits 16:16 */
    ca_uint32_t cfg1_cos             :  3 ; /* bits 19:17 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t cfg1_class_b         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_SRP_CONFIG0_t;
#endif /* !__ASSEMBLER__ */

    
#define L2TM_L2TE_SHP_SRP_CONFIG_EN              0xf4302710
#define L2TM_L2TE_SHP_SRP_CONFIG_EN_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pid0                 :  4 ; /* bits 3:0 */
    ca_uint32_t pid1                 :  4 ; /* bits 7:4 */
    ca_uint32_t pid2                 :  4 ; /* bits 11:8 */
    ca_uint32_t pid3                 :  4 ; /* bits 15:12 */
    ca_uint32_t pid4                 :  4 ; /* bits 19:16 */
    ca_uint32_t pid5                 :  4 ; /* bits 23:20 */
    ca_uint32_t pid6                 :  4 ; /* bits 27:24 */
    ca_uint32_t pid7                 :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_SRP_CONFIG_EN_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_CTRL                       0xf4302714
#define L2TM_L2TE_SHP_CTRL_dft                   0x0000007c

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt_mode_class0_cnt  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pkt_mode_class1_cnt  :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS        0xf4302718
#define L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1         0xf430271c
#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0         0xf4302720
#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS       0xf4302724
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1        0xf4302728
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0        0xf430272c
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS         0xf4302730
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1          0xf4302734
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0          0xf4302738
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_AGR_SHP_CFG                0xf430273c
#define L2TM_L2TE_SHP_AGR_SHP_CFG_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port_agr_bitmap      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_AGR_SHP_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_AGR_SHP_CTRL1              0xf4302740
#define L2TM_L2TE_SHP_AGR_SHP_CTRL1_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cbs                  : 10 ; /* bits 9:0 */
    ca_uint32_t enb                  :  2 ; /* bits 11:10 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_AGR_SHP_CTRL1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_AGR_SHP_CTRL0              0xf4302744
#define L2TM_L2TE_SHP_AGR_SHP_CTRL0_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_AGR_SHP_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_AGR_SHP_STS                0xf4302748
#define L2TM_L2TE_SHP_AGR_SHP_STS_dft            0x00100000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tbc                  : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_AGR_SHP_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_TB_CTRL                    0xf430274c
#define L2TM_L2TE_SHP_TB_CTRL_dft                0x2ff3e723

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addtok_en            :  1 ; /* bits 0:0 */
    ca_uint32_t subtok_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t upd_cnt_lmt          :  4 ; /* bits 7:4 */
    ca_uint32_t cyc_cnt_lmt          : 12 ; /* bits 19:8 */
    ca_uint32_t last_upd_cyc         : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_TB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_TB_CTRL1                   0xf4302750
#define L2TM_L2TE_SHP_TB_CTRL1_dft               0x000001f3

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t k_cnt_lmt            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_TB_CTRL1_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2te_wred
 */
        
#define L2TM_L2TE_WRED_CTRL                      0xf4302800
#define L2TM_L2TE_WRED_CTRL_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t fast_decay           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t afgs_weight          :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_AFGS_MEM_ACCESS           0xf4302804
#define L2TM_L2TE_WRED_AFGS_MEM_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 29 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_AFGS_MEM_DATA             0xf4302808
#define L2TM_L2TE_WRED_AFGS_MEM_DATA_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t depth                : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_AFGS_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_ACCESS        0xf430280c
#define L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA7         0xf4302810
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA7_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data_rsvd            :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA6         0xf4302814
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA6_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unmark_idx           :  4 ; /* bits 3:0 */
    ca_uint32_t mark_idx             :  4 ; /* bits 7:4 */
    ca_uint32_t data_rsvd            : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA5         0xf4302818
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA5_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA4         0xf430281c
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA4_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA3         0xf4302820
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA3_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA2         0xf4302824
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA2_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA1         0xf4302828
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA0         0xf430282c
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS 0xf4302830
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1  0xf4302834
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel6                 :  3 ; /* bits 2:0 */
    ca_uint32_t sel7                 :  5 ; /* bits 7:3 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0  0xf4302838
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel0                 :  5 ; /* bits 4:0 */
    ca_uint32_t sel1                 :  5 ; /* bits 9:5 */
    ca_uint32_t sel2                 :  5 ; /* bits 14:10 */
    ca_uint32_t sel3                 :  5 ; /* bits 19:15 */
    ca_uint32_t sel4                 :  5 ; /* bits 24:20 */
    ca_uint32_t sel5                 :  5 ; /* bits 29:25 */
    ca_uint32_t sel6                 :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2te_fc_glb
 */
        
#define L2TM_L2TE_FC_GLB_INT                     0xf4302900
#define L2TM_L2TE_FC_GLB_INT_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rxflowcntl0          :  1 ; /* bits 0:0 */
    ca_uint32_t rxflowcntl1          :  1 ; /* bits 1:1 */
    ca_uint32_t rxflowcntl2          :  1 ; /* bits 2:2 */
    ca_uint32_t rxflowcntl3          :  1 ; /* bits 3:3 */
    ca_uint32_t rxflowcntl4          :  1 ; /* bits 4:4 */
    ca_uint32_t rxflowcntl5          :  1 ; /* bits 5:5 */
    ca_uint32_t rxflowcntl6          :  1 ; /* bits 6:6 */
    ca_uint32_t rxflowcntl7          :  1 ; /* bits 7:7 */
    ca_uint32_t rxflowcntl8          :  1 ; /* bits 8:8 */
    ca_uint32_t rxflowcntl9          :  1 ; /* bits 9:9 */
    ca_uint32_t rxflowcntl10         :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rxflowcntl13         :  1 ; /* bits 13:13 */
    ca_uint32_t rxflowcntl13_qm      :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t txflowcntl0          :  1 ; /* bits 16:16 */
    ca_uint32_t txflowcntl1          :  1 ; /* bits 17:17 */
    ca_uint32_t txflowcntl2          :  1 ; /* bits 18:18 */
    ca_uint32_t txflowcntl3          :  1 ; /* bits 19:19 */
    ca_uint32_t txflowcntl4          :  1 ; /* bits 20:20 */
    ca_uint32_t txflowcntl5          :  1 ; /* bits 21:21 */
    ca_uint32_t txflowcntl6          :  1 ; /* bits 22:22 */
    ca_uint32_t txflowcntl7          :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t txflowcntl9          :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t txflowcntl11         :  1 ; /* bits 27:27 */
    ca_uint32_t txflowcntl12         :  1 ; /* bits 28:28 */
    ca_uint32_t txflowcntl13         :  1 ; /* bits 29:29 */
    ca_uint32_t txflowcntl14         :  1 ; /* bits 30:30 */
    ca_uint32_t txflowcntl15         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_INTE                    0xf4302904
#define L2TM_L2TE_FC_GLB_INTE_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rxflowcntl0E         :  1 ; /* bits 0:0 */
    ca_uint32_t rxflowcntl1E         :  1 ; /* bits 1:1 */
    ca_uint32_t rxflowcntl2E         :  1 ; /* bits 2:2 */
    ca_uint32_t rxflowcntl3E         :  1 ; /* bits 3:3 */
    ca_uint32_t rxflowcntl4E         :  1 ; /* bits 4:4 */
    ca_uint32_t rxflowcntl5E         :  1 ; /* bits 5:5 */
    ca_uint32_t rxflowcntl6E         :  1 ; /* bits 6:6 */
    ca_uint32_t rxflowcntl7E         :  1 ; /* bits 7:7 */
    ca_uint32_t rxflowcntl8E         :  1 ; /* bits 8:8 */
    ca_uint32_t rxflowcntl9E         :  1 ; /* bits 9:9 */
    ca_uint32_t rxflowcntl10E        :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rxflowcntl13E        :  1 ; /* bits 13:13 */
    ca_uint32_t rxflowcntl13_qmE     :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t txflowcntl0E         :  1 ; /* bits 16:16 */
    ca_uint32_t txflowcntl1E         :  1 ; /* bits 17:17 */
    ca_uint32_t txflowcntl2E         :  1 ; /* bits 18:18 */
    ca_uint32_t txflowcntl3E         :  1 ; /* bits 19:19 */
    ca_uint32_t txflowcntl4E         :  1 ; /* bits 20:20 */
    ca_uint32_t txflowcntl5E         :  1 ; /* bits 21:21 */
    ca_uint32_t txflowcntl6E         :  1 ; /* bits 22:22 */
    ca_uint32_t txflowcntl7E         :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t txflowcntl9E         :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t txflowcntl11E        :  1 ; /* bits 27:27 */
    ca_uint32_t txflowcntl12E        :  1 ; /* bits 28:28 */
    ca_uint32_t txflowcntl13E        :  1 ; /* bits 29:29 */
    ca_uint32_t txflowcntl14E        :  1 ; /* bits 30:30 */
    ca_uint32_t txflowcntl15E        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_CTRL                    0xf4302908
#define L2TM_L2TE_FC_GLB_CTRL_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t deepq_rxpfc_en       :  8 ; /* bits 7:0 */
    ca_uint32_t cpu_rxpfc_en         :  8 ; /* bits 15:8 */
    ca_uint32_t l3fewan_rxpfc_en     :  8 ; /* bits 23:16 */
    ca_uint32_t l3felan_rxpfc_en     :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_CTRL_LANL3FE            0xf430290c
#define L2TM_L2TE_FC_GLB_CTRL_LANL3FE_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lanl3fe_rxpfc_en     :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_CTRL_LANL3FE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_STS                     0xf4302910
#define L2TM_L2TE_FC_GLB_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t deepq_rxpfc          :  8 ; /* bits 7:0 */
    ca_uint32_t cpu_rxpfc            :  8 ; /* bits 15:8 */
    ca_uint32_t lanl3fe_rxpfc        :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd1               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_TIMER                   0xf4302914
#define L2TM_L2TE_FC_GLB_TIMER_dft               0x000073ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num_of_cycles        : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t cycle_unit           :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd2               : 16 ;
    ca_uint32_t enable               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_TIMER_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_PFC_CTRL0               0xf4302918
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_STRIDE        8
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_COUNT         2
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cos_bmap             :  8 ; /* bits 7:0 */
    ca_uint32_t port_bmap            :  8 ; /* bits 15:8 */
    ca_uint32_t rxpfc_en             :  1 ; /* bits 16:16 */
    ca_uint32_t txpfc_en             :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_PFC_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_PFC_CNT0                0xf430291c
#define L2TM_L2TE_FC_GLB_PFC_CNT0_STRIDE         8
#define L2TM_L2TE_FC_GLB_PFC_CNT0_COUNT          2
#define L2TM_L2TE_FC_GLB_PFC_CNT0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_PFC_CNT0_t;
#endif /* !__ASSEMBLER__ */

            
  
    
      

/*
 * l2te_fc[0..13]
 */
        
#define L2TM_L2TE_FC_CTRL                        0xf4302980
#define L2TM_L2TE_FC_CTRL_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rx_en                :  1 ; /* bits 0:0 */
    ca_uint32_t tx_en                :  1 ; /* bits 1:1 */
    ca_uint32_t src_rate_enforce     :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t stat_pri_sel         :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_STS                         0xf4302984
#define L2TM_L2TE_FC_STS_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rxpfc                :  8 ; /* bits 7:0 */
    ca_uint32_t txpfc                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_STAT                        0xf4302988
#define L2TM_L2TE_FC_STAT_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_num             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t voq                  :  7 ; /* bits 10:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t qm_voq               :  9 ; /* bits 20:12 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t txpfc                :  1 ; /* bits 30:30 */
    ca_uint32_t rxpfc                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_STAT_t;
#endif /* !__ASSEMBLER__ */

    
#define APB0_L2TM_L2TE_FC_STRIDE          64
#define APB0_L2TM_L2TE_FC_COUNT           14
  
    
      

/*
 * l2te_cb
 */
        
#define L2TM_L2TE_CB_INT                         0xf4302d00
#define L2TM_L2TE_CB_INT_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_bufcnt_udfl      :  1 ; /* bits 0:0 */
    ca_uint32_t voq_bufcnt_ovfl      :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t port_freecnt_udfl    :  1 ; /* bits 4:4 */
    ca_uint32_t port_freecnt_ovfl    :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_INTE                        0xf4302d04
#define L2TM_L2TE_CB_INTE_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_bufcnt_udflE     :  1 ; /* bits 0:0 */
    ca_uint32_t voq_bufcnt_ovflE     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t port_freecnt_udflE   :  1 ; /* bits 4:4 */
    ca_uint32_t port_freecnt_ovflE   :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_ERR_INFO                    0xf4302d08
#define L2TM_L2TE_CB_ERR_INFO_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_of_buferr        :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_ERR_INFO_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_CTRL                        0xf4302d0c
#define L2TM_L2TE_CB_CTRL_dft                    0x0003ff03

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t scan_cycle_per_run   :  8 ; /* bits 7:0 */
    ca_uint32_t scan_cycle_unit      : 10 ; /* bits 17:8 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t cnt_udfl_allow       :  1 ; /* bits 30:30 */
    ca_uint32_t scan_enable          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0        0xf4302d10
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_STRIDE 4
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_COUNT  2
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dqid                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t;
#endif /* !__ASSEMBLER__ */

    
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0       0xf4302d18
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_STRIDE 4
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_COUNT 2
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dqid                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t;
#endif /* !__ASSEMBLER__ */

    
#define L2TM_L2TE_CB_TM_TAILDROP_STS0            0xf4302d20
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_STRIDE     4
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_COUNT      4
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_TAILDROP_STS0_t;
#endif /* !__ASSEMBLER__ */

            
#define L2TM_L2TE_CB_QM_TAILDROP_STS0            0xf4302d30
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_STRIDE     4
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_COUNT      12
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_QM_TAILDROP_STS0_t;
#endif /* !__ASSEMBLER__ */

                                            
#define L2TM_L2TE_CB_GLOB_TD_STS                 0xf4302d60
#define L2TM_L2TE_CB_GLOB_TD_STS_dft             0x0020ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t per_port_prvt_avl    : 16 ; /* bits 15:0 */
    ca_uint32_t noncong_buf_avl      :  1 ; /* bits 16:16 */
    ca_uint32_t common_buf_avl       :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fc_buf_usg_l         :  1 ; /* bits 21:21 */
    ca_uint32_t fc_buf_usg_m         :  1 ; /* bits 22:22 */
    ca_uint32_t fc_buf_usg_h         :  1 ; /* bits 23:23 */
    ca_uint32_t pfc                  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLOB_TD_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_TD_STS                 0xf4302d64
#define L2TM_L2TE_CB_PORT_TD_STS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port                 : 16 ; /* bits 15:0 */
    ca_uint32_t src_port             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_TD_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_TD_STS0                 0xf4302d68
#define L2TM_L2TE_CB_VOQ_TD_STS0_STRIDE          4
#define L2TM_L2TE_CB_VOQ_TD_STS0_COUNT           4
#define L2TM_L2TE_CB_VOQ_TD_STS0_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_TD_STS0_t;
#endif /* !__ASSEMBLER__ */

            
#define L2TM_L2TE_CB_SRC_PRI_TD_STS              0xf4302d78
#define L2TM_L2TE_CB_SRC_PRI_TD_STS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t src_pri              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_TD_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0         0xf4302d7c
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_STRIDE  8
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_COUNT   4
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_dft     0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0      0xf4302d80
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_STRIDE 8
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_dft  0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t grplth               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t grphth               : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */

                        
#define L2TM_L2TE_CB_PORT_THRSH_SELECT           0xf4302d9c
#define L2TM_L2TE_CB_PORT_THRSH_SELECT_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS 0xf4302da0
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1 0xf4302da4
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t grplth               : 13 ; /* bits 12:0 */
    ca_uint32_t grphth               : 15 ; /* bits 27:13 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0 0xf4302da8
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t hth                  : 15 ; /* bits 29:15 */
    ca_uint32_t grplth               :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS 0xf4302dac
#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA   0xf4302db0
#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS     0xf4302db4
#define L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA       0xf4302db8
#define L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t cnt0_msb             :  1 ; /* bits 15:15 */
    ca_uint32_t cnt1                 : 15 ; /* bits 30:16 */
    ca_uint32_t cnt1_msb             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS       0xf4302dbc
#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA         0xf4302dc0
#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t cnt0_rsvd            :  1 ; /* bits 15:15 */
    ca_uint32_t cnt1                 : 15 ; /* bits 30:16 */
    ca_uint32_t cnt1_rsvd            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS   0xf4302dc4
#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA     0xf4302dc8
#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_GLB_THRSH                   0xf4302dcc
#define L2TM_L2TE_CB_GLB_THRSH_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLB_THRSH_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_GLB_PRI_THRSH0              0xf4302dd0
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_STRIDE       4
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_COUNT        8
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_dft          0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLB_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */

                            
#define L2TM_L2TE_CB_SRC_CTRL                    0xf4302df0
#define L2TM_L2TE_CB_SRC_CTRL_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t src0_pri_nspid       :  3 ; /* bits 2:0 */
    ca_uint32_t src0_pri_en          :  1 ; /* bits 3:3 */
    ca_uint32_t src1_pri_nspid       :  3 ; /* bits 6:4 */
    ca_uint32_t src1_pri_en          :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0     0xf4302df4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_STRIDE 4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */

            
#define L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT       0xf4302e04
#define L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC0_PRI_THRSH0             0xf4302e08
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_STRIDE      4
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_COUNT       8
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_dft         0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC0_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */

                            
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0             0xf4302e28
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_STRIDE      4
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_COUNT       8
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_dft         0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC1_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */

                            
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS  0xf4302e48
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA    0xf4302e4c
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS   0xf4302e50
#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA     0xf4302e54
#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0     0xf4302e58
#define L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_dft 0x00007fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t th0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0   0xf4302e5c
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_STRIDE 4
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */

            
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT     0xf4302e6c
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS 0xf4302e70
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA 0xf4302e74
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t hth                  : 15 ; /* bits 29:15 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS 0xf4302e78
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA 0xf4302e7c
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_CTRL                   0xf4302e80
#define L2TM_L2TE_CB_WIFI_CTRL_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wred_taildrop_dis    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t backpressure_en      :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 13 ;
    ca_uint32_t febypass_msk         :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_STS                    0xf4302e84
#define L2TM_L2TE_CB_WIFI_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq_profile_ov_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t buffer_ov_threshold  :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t wifi_backpressure_on : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_BUFCNT0                0xf4302e88
#define L2TM_L2TE_CB_WIFI_BUFCNT0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t g0                   : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t g1                   : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_BUFCNT0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_BUFCNT1                0xf4302e8c
#define L2TM_L2TE_CB_WIFI_BUFCNT1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t g2                   : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t g3                   : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_BUFCNT1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_BUFCNT2                0xf4302e90
#define L2TM_L2TE_CB_WIFI_BUFCNT2_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t g4                   : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t g5                   : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_BUFCNT2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_BUFCNT3                0xf4302e94
#define L2TM_L2TE_CB_WIFI_BUFCNT3_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t g6                   : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t g7                   : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_BUFCNT3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL0          0xf4302e98
#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL0_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid0_bp_map        :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lspid1_bp_map        :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t lspid2_bp_map        :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t lspid3_bp_map        :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t lspid4_bp_map        :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t lspid5_bp_map        :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t lspid6_bp_map        :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t lspid7_bp_map        :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_BACK_PRES_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL1          0xf4302e9c
#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL1_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid8_bp_map        :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lspid9_bp_map        :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t lspid10_bp_map       :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t lspid11_bp_map       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t lspid12_bp_map       :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t lspid13_bp_map       :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t lspid14_bp_map       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t lspid15_bp_map       :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_BACK_PRES_CTRL1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL2          0xf4302ea0
#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL2_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid16_bp_map       :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lspid17_bp_map       :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t lspid18_bp_map       :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t lspid19_bp_map       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t lspid20_bp_map       :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t lspid21_bp_map       :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t lspid22_bp_map       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t lspid23_bp_map       :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_BACK_PRES_CTRL2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL3          0xf4302ea4
#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL3_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid24_bp_map       :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lspid25_bp_map       :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t lspid26_bp_map       :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t lspid27_bp_map       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t lspid28_bp_map       :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t lspid29_bp_map       :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t lspid30_bp_map       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t lspid31_bp_map       :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_BACK_PRES_CTRL3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL4          0xf4302ea8
#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL4_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid32_bp_map       :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lspid33_bp_map       :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t lspid34_bp_map       :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t lspid35_bp_map       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t lspid36_bp_map       :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t lspid37_bp_map       :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t lspid38_bp_map       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t lspid39_bp_map       :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_BACK_PRES_CTRL4_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL5          0xf4302eac
#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL5_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid40_bp_map       :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lspid41_bp_map       :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t lspid42_bp_map       :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t lspid43_bp_map       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t lspid44_bp_map       :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t lspid45_bp_map       :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t lspid46_bp_map       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t lspid47_bp_map       :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_BACK_PRES_CTRL5_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL6          0xf4302eb0
#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL6_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid48_bp_map       :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lspid49_bp_map       :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t lspid50_bp_map       :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t lspid51_bp_map       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t lspid52_bp_map       :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t lspid53_bp_map       :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t lspid54_bp_map       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t lspid55_bp_map       :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_BACK_PRES_CTRL6_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL7          0xf4302eb4
#define L2TM_L2TE_CB_VP_BACK_PRES_CTRL7_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid56_bp_map       :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lspid57_bp_map       :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t lspid58_bp_map       :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t lspid59_bp_map       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t lspid60_bp_map       :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t lspid61_bp_map       :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t lspid62_bp_map       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t lspid63_bp_map       :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_BACK_PRES_CTRL7_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_MAP0                     0xf4302eb8
#define L2TM_L2TE_CB_VP_MAP0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t g0                   : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t g1                   : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_MAP0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_MAP1                     0xf4302ebc
#define L2TM_L2TE_CB_VP_MAP1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t g2                   : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t g3                   : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_MAP1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_MAP2                     0xf4302ec0
#define L2TM_L2TE_CB_VP_MAP2_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t g4                   : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t g5                   : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_MAP2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VP_MAP3                     0xf4302ec4
#define L2TM_L2TE_CB_VP_MAP3_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t g6                   : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t g7                   : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VP_MAP3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_BUF_THRSH_G0           0xf4302ec8
#define L2TM_L2TE_CB_WIFI_BUF_THRSH_G0_STRIDE    4
#define L2TM_L2TE_CB_WIFI_BUF_THRSH_G0_COUNT     8
#define L2TM_L2TE_CB_WIFI_BUF_THRSH_G0_dft       0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_BUF_THRSH_G0_t;
#endif /* !__ASSEMBLER__ */

                            
#define L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH       0xf4302ee8
#define L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH_dft   0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_ABR_CTRL                    0xf4302eec
#define L2TM_L2TE_CB_ABR_CTRL_dft                0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t drop_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_ABR_CTRL_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * l2te_pm
 */
        
#define L2TM_L2TE_PM_CTRL                        0xf4302f00
#define L2TM_L2TE_PM_CTRL_dft                    0x000000a0

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_saturate         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mem_saturate         :  1 ; /* bits 4:4 */
    ca_uint32_t mem_auto_clr_on_read :  1 ; /* bits 5:5 */
    ca_uint32_t mem_init             :  1 ; /* bits 6:6 */
    ca_uint32_t mem_disable          :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_EVENT_CFG_0                 0xf4302f04
#define L2TM_L2TE_PM_EVENT_CFG_0_dft             0x33445550

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0_lo              :  4 ; /* bits 3:0 */
    ca_uint32_t cnt0_hi              :  4 ; /* bits 7:4 */
    ca_uint32_t cnt1_lo              :  4 ; /* bits 11:8 */
    ca_uint32_t cnt1_hi              :  4 ; /* bits 15:12 */
    ca_uint32_t cnt2_lo              :  4 ; /* bits 19:16 */
    ca_uint32_t cnt2_hi              :  4 ; /* bits 23:20 */
    ca_uint32_t cnt3_lo              :  4 ; /* bits 27:24 */
    ca_uint32_t cnt3_hi              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_EVENT_CFG_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_STS                         0xf4302f08
#define L2TM_L2TE_PM_STS_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pcnt0_init_done      :  1 ; /* bits 0:0 */
    ca_uint32_t pcnt1_init_done      :  1 ; /* bits 1:1 */
    ca_uint32_t bcnt0_init_done      :  1 ; /* bits 2:2 */
    ca_uint32_t bcnt1_init_done      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_PCNT                        0xf4302f0c
#define L2TM_L2TE_PM_PCNT_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_PRE_MARK_PCNT               0xf4302f10
#define L2TM_L2TE_PM_PRE_MARK_PCNT_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_PRE_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_POL_DROP_PCNT               0xf4302f14
#define L2TM_L2TE_PM_POL_DROP_PCNT_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_POL_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_TAIL_DROP_PCNT              0xf4302f18
#define L2TM_L2TE_PM_TAIL_DROP_PCNT_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_TAIL_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_WRED_Y_DROP_PCNT            0xf4302f1c
#define L2TM_L2TE_PM_WRED_Y_DROP_PCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_WRED_G_DROP_PCNT            0xf4302f20
#define L2TM_L2TE_PM_WRED_G_DROP_PCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_WRED_G_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_MARK_PCNT                   0xf4302f24
#define L2TM_L2TE_PM_MARK_PCNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_POL_MARK_PCNT               0xf4302f28
#define L2TM_L2TE_PM_POL_MARK_PCNT_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_POL_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_BYPASS_PCNT                 0xf4302f2c
#define L2TM_L2TE_PM_BYPASS_PCNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_BYPASS_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_BYPASS_FLOW_PCNT            0xf4302f30
#define L2TM_L2TE_PM_BYPASS_FLOW_PCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CE_PCNT                     0xf4302f34
#define L2TM_L2TE_PM_CE_PCNT_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CE_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_ACCESS              0xf4302f38
#define L2TM_L2TE_PM_CNT_MEM_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA8               0xf4302f3c
#define L2TM_L2TE_PM_CNT_MEM_DATA8_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt7                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA7               0xf4302f40
#define L2TM_L2TE_PM_CNT_MEM_DATA7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt6                 : 12 ; /* bits 11:0 */
    ca_uint32_t cnt7                 : 20 ; /* bits 31:12 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA6               0xf4302f44
#define L2TM_L2TE_PM_CNT_MEM_DATA6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt5                 :  8 ; /* bits 7:0 */
    ca_uint32_t cnt6                 : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA5               0xf4302f48
#define L2TM_L2TE_PM_CNT_MEM_DATA5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt4                 :  4 ; /* bits 3:0 */
    ca_uint32_t cnt5                 : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA4               0xf4302f4c
#define L2TM_L2TE_PM_CNT_MEM_DATA4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt4                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA3               0xf4302f50
#define L2TM_L2TE_PM_CNT_MEM_DATA3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA2               0xf4302f54
#define L2TM_L2TE_PM_CNT_MEM_DATA2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA1               0xf4302f58
#define L2TM_L2TE_PM_CNT_MEM_DATA1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA0               0xf4302f5c
#define L2TM_L2TE_PM_CNT_MEM_DATA0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      
    
  
        

/*
 * L3FE
 */
  
/*
 * GLB
 */
        
#define L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS         0xf4303000
#define L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA           0xf4303004
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t PPPOE_SET            :  1 ; /* bits 0:0 */
    ca_uint32_t PPPOE_VLD            :  1 ; /* bits 1:1 */
    ca_uint32_t PPPOE_SESSION_ID     : 16 ; /* bits 17:2 */
    ca_uint32_t MAC_SA_VLD           :  1 ; /* bits 18:18 */
    ca_uint32_t MAC_SA_AN_SEL        :  4 ; /* bits 22:19 */
    ca_uint32_t PPPoE_LEN_CTRL       :  1 ; /* bits 23:23 */
    ca_uint32_t SNAP_LEN_BRI         :  1 ; /* bits 24:24 */
    ca_uint32_t SNAP_LEN_TRA         :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DSCP_MAP_TBL_ACCESS             0xf4303008
#define L3FE_GLB_DSCP_MAP_TBL_ACCESS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DSCP_MAP_TBL_DATA1              0xf430300c
#define L3FE_GLB_DSCP_MAP_TBL_DATA1_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dscp_2_pf1_dscp      :  2 ; /* bits 1:0 */
    ca_uint32_t dscp_2_pf1_cos       :  4 ; /* bits 5:2 */
    ca_uint32_t dscp_2_pf1_pol_id    :  9 ; /* bits 14:6 */
    ca_uint32_t dscp_2_pf1_pol_grp_id :  3 ; /* bits 17:15 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DSCP_MAP_TBL_DATA0              0xf4303010
#define L3FE_GLB_DSCP_MAP_TBL_DATA0_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dscp_2_pf0_dot1p     :  3 ; /* bits 2:0 */
    ca_uint32_t dscp_2_pf0_dscp      :  6 ; /* bits 8:3 */
    ca_uint32_t dscp_2_pf0_cos       :  4 ; /* bits 12:9 */
    ca_uint32_t dscp_2_pf0_pol_id    :  9 ; /* bits 21:13 */
    ca_uint32_t dscp_2_pf0_pol_grp_id :  3 ; /* bits 24:22 */
    ca_uint32_t dscp_2_pf1_dot1p     :  3 ; /* bits 27:25 */
    ca_uint32_t dscp_2_pf1_dscp      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_0               0xf4303014
#define L3FE_GLB_DOT1P_MAPPING_0_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_0               0xf4303018
#define L3FE_GLB_DOT1P_MAPPING_1_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_1               0xf430301c
#define L3FE_GLB_DOT1P_MAPPING_0_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_1               0xf4303020
#define L3FE_GLB_DOT1P_MAPPING_1_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_2               0xf4303024
#define L3FE_GLB_DOT1P_MAPPING_0_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_2               0xf4303028
#define L3FE_GLB_DOT1P_MAPPING_1_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_3               0xf430302c
#define L3FE_GLB_DOT1P_MAPPING_0_3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_3               0xf4303030
#define L3FE_GLB_DOT1P_MAPPING_1_3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_4               0xf4303034
#define L3FE_GLB_DOT1P_MAPPING_0_4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_4               0xf4303038
#define L3FE_GLB_DOT1P_MAPPING_1_4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_5               0xf430303c
#define L3FE_GLB_DOT1P_MAPPING_0_5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_5               0xf4303040
#define L3FE_GLB_DOT1P_MAPPING_1_5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_6               0xf4303044
#define L3FE_GLB_DOT1P_MAPPING_0_6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_6               0xf4303048
#define L3FE_GLB_DOT1P_MAPPING_1_6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_7               0xf430304c
#define L3FE_GLB_DOT1P_MAPPING_0_7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_7               0xf4303050
#define L3FE_GLB_DOT1P_MAPPING_1_7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_0                 0xf4303054
#define L3FE_GLB_COS_MAPPING_0_0_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_0                 0xf4303058
#define L3FE_GLB_COS_MAPPING_1_0_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_1                 0xf430305c
#define L3FE_GLB_COS_MAPPING_0_1_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_1                 0xf4303060
#define L3FE_GLB_COS_MAPPING_1_1_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_2                 0xf4303064
#define L3FE_GLB_COS_MAPPING_0_2_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_2                 0xf4303068
#define L3FE_GLB_COS_MAPPING_1_2_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_3                 0xf430306c
#define L3FE_GLB_COS_MAPPING_0_3_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_3                 0xf4303070
#define L3FE_GLB_COS_MAPPING_1_3_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_4                 0xf4303074
#define L3FE_GLB_COS_MAPPING_0_4_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_4                 0xf4303078
#define L3FE_GLB_COS_MAPPING_1_4_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_5                 0xf430307c
#define L3FE_GLB_COS_MAPPING_0_5_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_5                 0xf4303080
#define L3FE_GLB_COS_MAPPING_1_5_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_6                 0xf4303084
#define L3FE_GLB_COS_MAPPING_0_6_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_6                 0xf4303088
#define L3FE_GLB_COS_MAPPING_1_6_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_7                 0xf430308c
#define L3FE_GLB_COS_MAPPING_0_7_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_7                 0xf4303090
#define L3FE_GLB_COS_MAPPING_1_7_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_FWD_CTRL_0                      0xf4303094
#define L3FE_GLB_FWD_CTRL_0_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_FWD_CTRL_1                      0xf4303098
#define L3FE_GLB_FWD_CTRL_1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_FWD_CTRL_2                      0xf430309c
#define L3FE_GLB_FWD_CTRL_2_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_FWD_CTRL_3                      0xf43030a0
#define L3FE_GLB_FWD_CTRL_3_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_GLB_CFG                         0xf43030a4
#define L3FE_GLB_GLB_CFG_dft                     0x0001b000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l3fe_port_mmship_chk_en :  1 ; /* bits 0:0 */
    ca_uint32_t use_o_lspid_for_mmshp_chk :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t mc_port              :  6 ; /* bits 17:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ni_fe_12_bv          :  1 ; /* bits 21:21 */
    ca_uint32_t pl_mode              :  2 ; /* bits 23:22 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t l3fe_pon_mode        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_GLB_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LF_CFG                          0xf43030a8
#define L3FE_GLB_LF_CFG_dft                      0x004641f4

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t hi_threshold         : 10 ; /* bits 9:0 */
    ca_uint32_t low_threshold        : 10 ; /* bits 19:10 */
    ca_uint32_t wr_fifo_threshold    :  4 ; /* bits 23:20 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LF_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TE_OPTION                       0xf43030ac
#define L3FE_GLB_TE_OPTION_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bits                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TE_OPTION_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_CLS_STG_MONITOR_CTRL            0xf43030b0
#define L3FE_GLB_CLS_STG_MONITOR_CTRL_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  8 ; /* bits 7:0 */
    ca_uint32_t enable               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_CLS_STG_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_CLS_STG_MONITOR_RETURN          0xf43030b4
#define L3FE_GLB_CLS_STG_MONITOR_RETURN_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_CLS_STG_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DBG_IDX                         0xf43030b8
#define L3FE_GLB_DBG_IDX_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t idx                  : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DBG_IDX_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DBG_DAT                         0xf43030bc
#define L3FE_GLB_DBG_DAT_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dat                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DBG_DAT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_L3FE_MONITOR_TRIG               0xf43030c0
#define L3FE_GLB_L3FE_MONITOR_TRIG_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   :  1 ; /* bits 0:0 */
    ca_uint32_t mode                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_L3FE_MONITOR_TRIG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_L3FE_MONITOR_CTRL               0xf43030c4
#define L3FE_GLB_L3FE_MONITOR_CTRL_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_L3FE_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_L3FE_MONITOR_RETURN             0xf43030c8
#define L3FE_GLB_L3FE_MONITOR_RETURN_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_L3FE_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_RES_CTRL                        0xf43030cc
#define L3FE_GLB_RES_CTRL_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ttl_0_cpu_en         :  1 ; /* bits 0:0 */
    ca_uint32_t ttl_0_cpu_ldpid      :  6 ; /* bits 6:1 */
    ca_uint32_t ttl_0_cpu_deepq      :  1 ; /* bits 7:7 */
    ca_uint32_t ttl_0_cpu_deepq_vld  :  1 ; /* bits 8:8 */
    ca_uint32_t ttl_0_cpu_keep_org_pkt :  1 ; /* bits 9:9 */
    ca_uint32_t ttl_0_cpu_keep_org_pkt_vld :  1 ; /* bits 10:10 */
    ca_uint32_t ttl_0_cpu_ctrl_bypass :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_RES_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TCP_COS_MOD_0                   0xf43030d0
#define L3FE_GLB_TCP_COS_MOD_0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_val             :  6 ; /* bits 5:0 */
    ca_uint32_t cls_hit_en           :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t flag_msk             :  6 ; /* bits 13:8 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 14:14 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 15:15 */
    ca_uint32_t pkt_len              : 10 ; /* bits 25:16 */
    ca_uint32_t hit_cos_val          :  3 ; /* bits 28:26 */
    ca_uint32_t mis_cos_val          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TCP_COS_MOD_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TCP_COS_MOD_1                   0xf43030d4
#define L3FE_GLB_TCP_COS_MOD_1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_val             :  6 ; /* bits 5:0 */
    ca_uint32_t cls_hit_en           :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t flag_msk             :  6 ; /* bits 13:8 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 14:14 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 15:15 */
    ca_uint32_t pkt_len              : 10 ; /* bits 25:16 */
    ca_uint32_t hit_cos_val          :  3 ; /* bits 28:26 */
    ca_uint32_t mis_cos_val          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TCP_COS_MOD_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TCP_COS_MOD_2                   0xf43030d8
#define L3FE_GLB_TCP_COS_MOD_2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_val             :  6 ; /* bits 5:0 */
    ca_uint32_t cls_hit_en           :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t flag_msk             :  6 ; /* bits 13:8 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 14:14 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 15:15 */
    ca_uint32_t pkt_len              : 10 ; /* bits 25:16 */
    ca_uint32_t hit_cos_val          :  3 ; /* bits 28:26 */
    ca_uint32_t mis_cos_val          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TCP_COS_MOD_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TCP_COS_MOD_3                   0xf43030dc
#define L3FE_GLB_TCP_COS_MOD_3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_val             :  6 ; /* bits 5:0 */
    ca_uint32_t cls_hit_en           :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t flag_msk             :  6 ; /* bits 13:8 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 14:14 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 15:15 */
    ca_uint32_t pkt_len              : 10 ; /* bits 25:16 */
    ca_uint32_t hit_cos_val          :  3 ; /* bits 28:26 */
    ca_uint32_t mis_cos_val          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TCP_COS_MOD_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_CTRL                0xf43030e0
#define L3FE_GLB_LDPID_REMAP_CTRL_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_mask           :  8 ; /* bits 7:0 */
    ca_uint32_t ldpid_tuple_mask     :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cls_hit_en           :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t flw_hit_en           :  1 ; /* bits 18:18 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd3               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_SMAC_PRO            0xf43030e4
#define L3FE_GLB_LDPID_REMAP_SMAC_PRO_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_SMAC_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_DMAC_PRO            0xf43030e8
#define L3FE_GLB_LDPID_REMAP_DMAC_PRO_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_DMAC_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_SIP_PRO             0xf43030ec
#define L3FE_GLB_LDPID_REMAP_SIP_PRO_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_SIP_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_DIP_PRO             0xf43030f0
#define L3FE_GLB_LDPID_REMAP_DIP_PRO_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_DIP_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_SPORT_PRO           0xf43030f4
#define L3FE_GLB_LDPID_REMAP_SPORT_PRO_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_SPORT_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_DPORT_PRO           0xf43030f8
#define L3FE_GLB_LDPID_REMAP_DPORT_PRO_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_DPORT_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_VAL0                0xf43030fc
#define L3FE_GLB_LDPID_REMAP_VAL0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_idx0           :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid_idx1           :  3 ; /* bits 5:3 */
    ca_uint32_t ldpid_idx2           :  3 ; /* bits 8:6 */
    ca_uint32_t ldpid_idx3           :  3 ; /* bits 11:9 */
    ca_uint32_t ldpid_idx4           :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid_idx5           :  3 ; /* bits 18:16 */
    ca_uint32_t ldpid_idx6           :  3 ; /* bits 21:19 */
    ca_uint32_t ldpid_idx7           :  3 ; /* bits 24:22 */
    ca_uint32_t ldpid_idx8           :  3 ; /* bits 27:25 */
    ca_uint32_t ldpid_idx9           :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_VAL0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_VAL1                0xf4303100
#define L3FE_GLB_LDPID_REMAP_VAL1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_idx10          :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid_idx11          :  3 ; /* bits 5:3 */
    ca_uint32_t ldpid_idx12          :  3 ; /* bits 8:6 */
    ca_uint32_t ldpid_idx13          :  3 ; /* bits 11:9 */
    ca_uint32_t ldpid_idx14          :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid_idx15          :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_VAL1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_STC_SPSRAM_mbist_l3fe1          0xf4303104
#define L3FE_GLB_STC_SPSRAM_mbist_l3fe1_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_STC_SPSRAM_mbist_l3fe1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_STC_SPSRAM_mbist_l3fe2a         0xf4303108
#define L3FE_GLB_STC_SPSRAM_mbist_l3fe2a_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_STC_SPSRAM_mbist_l3fe2a_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_STC_SPSRAM_mbist_l3fe2b         0xf430310c
#define L3FE_GLB_STC_SPSRAM_mbist_l3fe2b_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_STC_SPSRAM_mbist_l3fe2b_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_STC_SPSRAM_mbist_l3fe3          0xf4303110
#define L3FE_GLB_STC_SPSRAM_mbist_l3fe3_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_STC_SPSRAM_mbist_l3fe3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_STC_SPSRAM_mbist_l3fe_nat       0xf4303114
#define L3FE_GLB_STC_SPSRAM_mbist_l3fe_nat_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_STC_SPSRAM_mbist_l3fe_nat_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_STC_SPSRAM_mbist_l3fe_cache_fib 0xf4303118
#define L3FE_GLB_STC_SPSRAM_mbist_l3fe_cache_fib_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t testpin              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_STC_SPSRAM_mbist_l3fe_cache_fib_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PP
 */
        
#define L3FE_PP_FIELD_CAM_ACCESS                 0xf4303200
#define L3FE_PP_FIELD_CAM_ACCESS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA4                  0xf4303204
#define L3FE_PP_FIELD_CAM_DATA4_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA3                  0xf4303208
#define L3FE_PP_FIELD_CAM_DATA3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA2                  0xf430320c
#define L3FE_PP_FIELD_CAM_DATA2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA1                  0xf4303210
#define L3FE_PP_FIELD_CAM_DATA1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA0                  0xf4303214
#define L3FE_PP_FIELD_CAM_DATA0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_SPCL_PKT_DETECTION_CFG           0xf4303218
#define L3FE_PP_SPCL_PKT_DETECTION_CFG_dft       0x0739dc24

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t check_arp_target_ip  :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_opcode_en       :  1 ; /* bits 1:1 */
    ca_uint32_t my_mac_enable        :  1 ; /* bits 2:2 */
    ca_uint32_t type_0_en            :  1 ; /* bits 3:3 */
    ca_uint32_t type_1_en            :  1 ; /* bits 4:4 */
    ca_uint32_t udp_lite_enable      :  1 ; /* bits 5:5 */
    ca_uint32_t user_def_spcl_0_en   :  1 ; /* bits 6:6 */
    ca_uint32_t user_def_spcl_1_en   :  1 ; /* bits 7:7 */
    ca_uint32_t user_def_spcl_2_en   :  1 ; /* bits 8:8 */
    ca_uint32_t user_def_spcl_3_en   :  1 ; /* bits 9:9 */
    ca_uint32_t l2_spcl_hdr_en       :  1 ; /* bits 10:10 */
    ca_uint32_t l3_spcl_hdr_en       :  1 ; /* bits 11:11 */
    ca_uint32_t l4_spcl_hdr_en       :  1 ; /* bits 12:12 */
    ca_uint32_t user_define_hi_pri   :  1 ; /* bits 13:13 */
    ca_uint32_t rdp_v1_detection_en  :  1 ; /* bits 14:14 */
    ca_uint32_t ipv4_chksum_chk_enable :  1 ; /* bits 15:15 */
    ca_uint32_t l4_chksum_chk_enable :  1 ; /* bits 16:16 */
    ca_uint32_t l4_chksum_rh_chk_enable :  1 ; /* bits 17:17 */
    ca_uint32_t chksum_err_drop      :  6 ; /* bits 23:18 */
    ca_uint32_t bpdu_mac_08_en       :  1 ; /* bits 24:24 */
    ca_uint32_t subtype_en           :  1 ; /* bits 25:25 */
    ca_uint32_t rdp_l4_msgs_det_en   :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t drop_udp_ov_ip6_cs_zero_en :  1 ; /* bits 28:28 */
    ca_uint32_t ni2fe_pkt_cnt_wrap_en :  1 ; /* bits 29:29 */
    ca_uint32_t use_mdata_high_6bits_as_spcl_enc :  1 ; /* bits 30:30 */
    ca_uint32_t arp_ipv6_en          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_SPCL_PKT_DETECTION_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_IPNIP_SPCL_PKT_DET_EN            0xf430321c
#define L3FE_PP_IPNIP_SPCL_PKT_DET_EN_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dhcpv4               :  1 ; /* bits 0:0 */
    ca_uint32_t dhcpv6               :  1 ; /* bits 1:1 */
    ca_uint32_t l4ptp                :  1 ; /* bits 2:2 */
    ca_uint32_t dns                  :  1 ; /* bits 3:3 */
    ca_uint32_t rip                  :  1 ; /* bits 4:4 */
    ca_uint32_t ssdp                 :  1 ; /* bits 5:5 */
    ca_uint32_t l4_msgs              :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_OFFSET_HDR                       0xf4303220
#define L3FE_PP_OFFSET_HDR_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t offset               :  9 ; /* bits 8:0 */
    ca_uint32_t l2_prog_offset       :  9 ; /* bits 17:9 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t l3_prog_offset       :  9 ; /* bits 28:20 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_OFFSET_HDR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L7_PROG_OFFSET_HDR_0             0xf4303224
#define L3FE_PP_L7_PROG_OFFSET_HDR_0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l7_prog_offset       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L7_PROG_OFFSET_HDR_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L7_PROG_OFFSET_HDR_1             0xf4303228
#define L3FE_PP_L7_PROG_OFFSET_HDR_1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l7_prog_offset       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L7_PROG_OFFSET_HDR_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L7_PROG_OFFSET_HDR_2             0xf430322c
#define L3FE_PP_L7_PROG_OFFSET_HDR_2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l7_prog_offset       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L7_PROG_OFFSET_HDR_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L7_PROG_OFFSET_HDR_3             0xf4303230
#define L3FE_PP_L7_PROG_OFFSET_HDR_3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l7_prog_offset       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L7_PROG_OFFSET_HDR_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_LMT                      0xf4303234
#define L3FE_PP_PARSING_LMT_dft                  0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t offset               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_LMT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_STTS_0                   0xf4303238
#define L3FE_PP_PARSING_STTS_0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t parsing_err          :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_STTS_1                   0xf430323c
#define L3FE_PP_PARSING_STTS_1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t parsing_err          : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_ERR_FWD_0                0xf4303240
#define L3FE_PP_PARSING_ERR_FWD_0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t ipv4_hdr_cs_err      :  2 ; /* bits 11:10 */
    ca_uint32_t pkt_l2_size_err      :  2 ; /* bits 13:12 */
    ca_uint32_t pkt_l3_total_len_err :  2 ; /* bits 15:14 */
    ca_uint32_t ip_hdr_err           :  2 ; /* bits 17:16 */
    ca_uint32_t ipv4_total_len_err   :  2 ; /* bits 19:18 */
    ca_uint32_t tcp_data_offset_err  :  2 ; /* bits 21:20 */
    ca_uint32_t udp_total_len_err    :  2 ; /* bits 23:22 */
    ca_uint32_t udp_lite_cs_cvrg_err :  2 ; /* bits 25:24 */
    ca_uint32_t rdp_hdr_len_err      :  2 ; /* bits 27:26 */
    ca_uint32_t offset_l3_excd_255_err :  2 ; /* bits 29:28 */
    ca_uint32_t offset_l4_excd_255_err :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_FWD_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_ERR_FWD_1                0xf4303244
#define L3FE_PP_PARSING_ERR_FWD_1_dft            0x00005000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dsl_inner_ip_hdr_cs_err :  2 ; /* bits 1:0 */
    ca_uint32_t pkt_inner_l3_total_len_err :  2 ; /* bits 3:2 */
    ca_uint32_t inner_ip_hdr_err     :  2 ; /* bits 5:4 */
    ca_uint32_t dsl_inner_ipv4_total_len_err :  2 ; /* bits 7:6 */
    ca_uint32_t offset_l3_inner_excd_255_err :  2 ; /* bits 9:8 */
    ca_uint32_t udp_zero_chksum_err  :  2 ; /* bits 11:10 */
    ca_uint32_t more_than_2_vlan_tags_flg :  2 ; /* bits 13:12 */
    ca_uint32_t l2tp_hdr_err         :  2 ; /* bits 15:14 */
    ca_uint32_t rdp_ver_err          :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t parsing_err_trap_pol_id :  9 ; /* bits 27:19 */
    ca_uint32_t parsing_err_trap_pol_grp_id :  3 ; /* bits 30:28 */
    ca_uint32_t parsing_err_trap_pol_en :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_FWD_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_ERR_TRAP                 0xf4303248
#define L3FE_PP_PARSING_ERR_TRAP_dft             0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_TRAP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_OVER_VLAN_FWD_CTL        0xf430324c
#define L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_dft    0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_TYPE_0                      0xf4303250
#define L3FE_PP_USER_TYPE_0_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_type_0          : 16 ; /* bits 15:0 */
    ca_uint32_t user_type_1          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_TYPE_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_TYPE_1                      0xf4303254
#define L3FE_PP_USER_TYPE_1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_type_2          : 16 ; /* bits 15:0 */
    ca_uint32_t user_type_3          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_TYPE_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_0_LOW                   0xf4303258
#define L3FE_PP_USER_MAC_0_LOW_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_0_HI                    0xf430325c
#define L3FE_PP_USER_MAC_0_HI_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_0           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_1_LOW                   0xf4303260
#define L3FE_PP_USER_MAC_1_LOW_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_1_HI                    0xf4303264
#define L3FE_PP_USER_MAC_1_HI_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_1           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_0_MASK_LOW              0xf4303268
#define L3FE_PP_USER_MAC_0_MASK_LOW_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_0      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_MASK_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_0_MASK_HI               0xf430326c
#define L3FE_PP_USER_MAC_0_MASK_HI_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_0      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_MASK_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_1_MASK_LOW              0xf4303270
#define L3FE_PP_USER_MAC_1_MASK_LOW_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_1      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_MASK_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_1_MASK_HI               0xf4303274
#define L3FE_PP_USER_MAC_1_MASK_HI_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_1      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_MASK_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_TPID_0                           0xf4303278
#define L3FE_PP_TPID_0_dft                       0x88a88100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid_0               : 16 ; /* bits 15:0 */
    ca_uint32_t tpid_1               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_TPID_1                           0xf430327c
#define L3FE_PP_TPID_1_dft                       0x92009100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid_2               : 16 ; /* bits 15:0 */
    ca_uint32_t tpid_3               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_TPID_CTRL                        0xf4303280
#define L3FE_PP_TPID_CTRL_dft                    0x00000077

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t top_vlan_en          :  4 ; /* bits 3:0 */
    ca_uint32_t inner_vlan_en        :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_ARP_TARGET_IP                    0xf4303284
#define L3FE_PP_ARP_TARGET_IP_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t target_ip            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_ARP_TARGET_IP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_OAM                              0xf4303288
#define L3FE_PP_OAM_dft                          0x00000803

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t subtype              :  8 ; /* bits 7:0 */
    ca_uint32_t mymdlvl              :  3 ; /* bits 10:8 */
    ca_uint32_t mymdlvl_det_en       :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_OAM_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HELLO_MAC_LOW                    0xf430328c
#define L3FE_PP_HELLO_MAC_LOW_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HELLO_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HELLO_MAC_HI                     0xf4303290
#define L3FE_PP_HELLO_MAC_HI_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HELLO_MAC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MY_MAC_LOW                       0xf4303294
#define L3FE_PP_MY_MAC_LOW_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mymac                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MY_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MY_MAC_HI                        0xf4303298
#define L3FE_PP_MY_MAC_HI_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mymac                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MY_MAC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MC_MAC_HI_RNG                    0xf430329c
#define L3FE_PP_MC_MAC_HI_RNG_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t hi_rng_mac_low       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_HI_RNG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MC_MAC_LOW_RNG                   0xf43032a0
#define L3FE_PP_MC_MAC_LOW_RNG_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_rng_mac_low      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_LOW_RNG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MC_MAC_RNG                       0xf43032a4
#define L3FE_PP_MC_MAC_RNG_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_rng_mac_hi       : 16 ; /* bits 15:0 */
    ca_uint32_t hi_rng_mac_hi        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_RNG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HTTP_LINK_0                      0xf43032a8
#define L3FE_PP_HTTP_LINK_0_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HTTP_LINK_1                      0xf43032ac
#define L3FE_PP_HTTP_LINK_1_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HTTP_LINK_2                      0xf43032b0
#define L3FE_PP_HTTP_LINK_2_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HTTP_LINK_3                      0xf43032b4
#define L3FE_PP_HTTP_LINK_3_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PINGPONG_STS                     0xf43032b8
#define L3FE_PP_PINGPONG_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_ERR_STTS_0               0xf43032bc
#define L3FE_PP_NI_INTF_ERR_STTS_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sop_eop_mismatch     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_ERR_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_ERR_STTS_1               0xf43032c0
#define L3FE_PP_NI_INTF_ERR_STTS_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t runt_l2_pkt          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_ERR_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_STS                      0xf43032c4
#define L3FE_PP_NI_INTF_STS_dft                  0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdy                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_PKT_CNT0                 0xf43032c8
#define L3FE_PP_NI_INTF_PKT_CNT0_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sop                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_PKT_CNT0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_PKT_CNT1                 0xf43032cc
#define L3FE_PP_NI_INTF_PKT_CNT1_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eop                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_PKT_CNT1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L4_CS_ERR                        0xf43032d0
#define L3FE_PP_L4_CS_ERR_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L4_CS_ERR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HEADER_A_LOW                     0xf43032d4
#define L3FE_PP_HEADER_A_LOW_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HEADER_A_HI                      0xf43032d8
#define L3FE_PP_HEADER_A_HI_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HEADER_CPU_LOW                   0xf43032dc
#define L3FE_PP_HEADER_CPU_LOW_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_CPU_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HEADER_CPU_HI                    0xf43032e0
#define L3FE_PP_HEADER_CPU_HI_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_CPU_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI2FE_INTF_FF_STS                0xf43032e4
#define L3FE_PP_NI2FE_INTF_FF_STS_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI2FE_INTF_FF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_ARP_FILTER_MSK                   0xf43032e8
#define L3FE_PP_ARP_FILTER_MSK_dft               0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_ARP_FILTER_MSK_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_0                        0xf43032ec
#define L3FE_PP_DOS_ATK_0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_1                        0xf43032f0
#define L3FE_PP_DOS_ATK_1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_2                        0xf43032f4
#define L3FE_PP_DOS_ATK_2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_3                        0xf43032f8
#define L3FE_PP_DOS_ATK_3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_4                        0xf43032fc
#define L3FE_PP_DOS_ATK_4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_5                        0xf4303300
#define L3FE_PP_DOS_ATK_5_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_6                        0xf4303304
#define L3FE_PP_DOS_ATK_6_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_7                        0xf4303308
#define L3FE_PP_DOS_ATK_7_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_8                        0xf430330c
#define L3FE_PP_DOS_ATK_8_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_FLOOD_CNT                0xf4303310
#define L3FE_PP_DOS_ATK_FLOOD_CNT_dft            0x000003fa

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_FLOOD_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_EVENT_TRAP               0xf4303314
#define L3FE_PP_DOS_ATK_EVENT_TRAP_dft           0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_EVENT_TRAP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_EVENT_DROP               0xf4303318
#define L3FE_PP_DOS_ATK_EVENT_DROP_dft           0xfffffa1f

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_EVENT_DROP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_01                   0xf430331c
#define L3FE_PP_vxlan_dport_01_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat0                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat1                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_01_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_23                   0xf4303320
#define L3FE_PP_vxlan_dport_23_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat2                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat3                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_23_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_45                   0xf4303324
#define L3FE_PP_vxlan_dport_45_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat4                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat5                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_45_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_67                   0xf4303328
#define L3FE_PP_vxlan_dport_67_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat6                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat7                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_67_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_89                   0xf430332c
#define L3FE_PP_vxlan_dport_89_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat8                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat9                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_89_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_l2tp_sport                       0xf4303330
#define L3FE_PP_l2tp_sport_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat0                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat1                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_l2tp_sport_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_fpga_debug_sel                   0xf4303334
#define L3FE_PP_fpga_debug_sel_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t index                :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_fpga_debug_sel_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_fpga_debug_data                  0xf4303338
#define L3FE_PP_fpga_debug_data_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_fpga_debug_data_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_SPKTP_ACCESS                     0xf430333c
#define L3FE_PP_SPKTP_ACCESS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_SPKTP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_SPKTP_DATA                       0xf4303340
#define L3FE_PP_SPKTP_DATA_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t encode               :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_SPKTP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PADDING_ERR_CNT                  0xf4303344
#define L3FE_PP_PADDING_ERR_CNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t outer_cnt            : 16 ; /* bits 15:0 */
    ca_uint32_t inner_cnt            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PADDING_ERR_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_dual_dos_en                      0xf4303348
#define L3FE_PP_dual_dos_en_dft                  0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_dual_dos_en_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_srv6_l3_prot                     0xf430334c
#define L3FE_PP_srv6_l3_prot_dft                 0x0000008f

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_srv6_l3_prot_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * CLS
 */
        
#define L3FE_CLS_KEY_TBL_ACCESS                  0xf4303380
#define L3FE_CLS_KEY_TBL_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA10                  0xf4303384
#define L3FE_CLS_KEY_TBL_DATA10_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 17 ; /* bits 16:0 */
    ca_uint32_t cl_entry_mode        :  1 ; /* bits 17:17 */
    ca_uint32_t cl_pri               :  4 ; /* bits 21:18 */
    ca_uint32_t cl_rslt_type         :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_type          :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_valid         :  4 ; /* bits 30:27 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA9                   0xf4303388
#define L3FE_CLS_KEY_TBL_DATA9_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA8                   0xf430338c
#define L3FE_CLS_KEY_TBL_DATA8_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA7                   0xf4303390
#define L3FE_CLS_KEY_TBL_DATA7_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA6                   0xf4303394
#define L3FE_CLS_KEY_TBL_DATA6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA5                   0xf4303398
#define L3FE_CLS_KEY_TBL_DATA5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA4                   0xf430339c
#define L3FE_CLS_KEY_TBL_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA3                   0xf43033a0
#define L3FE_CLS_KEY_TBL_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA2                   0xf43033a4
#define L3FE_CLS_KEY_TBL_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA1                   0xf43033a8
#define L3FE_CLS_KEY_TBL_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA0                   0xf43033ac
#define L3FE_CLS_KEY_TBL_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_ACCESS                  0xf43033b0
#define L3FE_CLS_FIB_TBL_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA6                   0xf43033b4
#define L3FE_CLS_FIB_TBL_DATA6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA5                   0xf43033b8
#define L3FE_CLS_FIB_TBL_DATA5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA4                   0xf43033bc
#define L3FE_CLS_FIB_TBL_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA3                   0xf43033c0
#define L3FE_CLS_FIB_TBL_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA2                   0xf43033c4
#define L3FE_CLS_FIB_TBL_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA1                   0xf43033c8
#define L3FE_CLS_FIB_TBL_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA0                   0xf43033cc
#define L3FE_CLS_FIB_TBL_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * STG0
 */
        
#define L3FE_STG0_CTRL                           0xf4303400
#define L3FE_STG0_CTRL_dft                       0x00147c7e

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lpb_idx_mode         :  1 ; /* bits 0:0 */
    ca_uint32_t mac_fltr_fail_pkt_mru_chk_en :  1 ; /* bits 1:1 */
    ca_uint32_t mru_chk_fail_pkt_l2_lkup_dis :  1 ; /* bits 2:2 */
    ca_uint32_t other_mac_pkt_keep_lspid_en :  1 ; /* bits 3:3 */
    ca_uint32_t wan_lspid            :  6 ; /* bits 9:4 */
    ca_uint32_t use_lspid_ovwr_o_lspid :  1 ; /* bits 10:10 */
    ca_uint32_t spcl_pkt_keep_old    :  1 ; /* bits 11:11 */
    ca_uint32_t wan_lspid_1          :  6 ; /* bits 17:12 */
    ca_uint32_t msk_my_mac_match_en_for_lspid_upd :  1 ; /* bits 18:18 */
    ca_uint32_t keep_lspid_unchange  :  1 ; /* bits 19:19 */
    ca_uint32_t my_mac_fail_pkt_bypass_cls :  1 ; /* bits 20:20 */
    ca_uint32_t chk_mymac_for_lan    :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LDPID_MAP                      0xf4303404
#define L3FE_STG0_LDPID_MAP_dft                  0x03591807

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_0               :  6 ; /* bits 5:0 */
    ca_uint32_t lpb_idx_0            :  2 ; /* bits 7:6 */
    ca_uint32_t rule_1               :  6 ; /* bits 13:8 */
    ca_uint32_t lpb_idx_1            :  2 ; /* bits 15:14 */
    ca_uint32_t rule_2               :  6 ; /* bits 21:16 */
    ca_uint32_t lpb_idx_2            :  2 ; /* bits 23:22 */
    ca_uint32_t lpb_idx_3            :  2 ; /* bits 25:24 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LDPID_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_LOW_0                  0xf4303408
#define L3FE_STG0_LPB_TBL_LOW_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_MID_0                  0xf430340c
#define L3FE_STG0_LPB_TBL_MID_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_HIGH_0                 0xf4303410
#define L3FE_STG0_LPB_TBL_HIGH_0_dft             0x18000190

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_LOW_1                  0xf4303414
#define L3FE_STG0_LPB_TBL_LOW_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_MID_1                  0xf4303418
#define L3FE_STG0_LPB_TBL_MID_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_HIGH_1                 0xf430341c
#define L3FE_STG0_LPB_TBL_HIGH_1_dft             0x19000070

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_LOW_2                  0xf4303420
#define L3FE_STG0_LPB_TBL_LOW_2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_MID_2                  0xf4303424
#define L3FE_STG0_LPB_TBL_MID_2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_HIGH_2                 0xf4303428
#define L3FE_STG0_LPB_TBL_HIGH_2_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_LOW_3                  0xf430342c
#define L3FE_STG0_LPB_TBL_LOW_3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_MID_3                  0xf4303430
#define L3FE_STG0_LPB_TBL_MID_3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_HIGH_3                 0xf4303434
#define L3FE_STG0_LPB_TBL_HIGH_3_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_IDX_TBL_ACCESS             0xf4303438
#define L3FE_STG0_LPB_IDX_TBL_ACCESS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_IDX_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_IDX_TBL_DATA               0xf430343c
#define L3FE_STG0_LPB_IDX_TBL_DATA_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t idx                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_IDX_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * STG1
 */
        
#define L3FE_STG1_INTF_FF_CTL_REG                0xf4303480
#define L3FE_STG1_INTF_FF_CTL_REG_dft            0x00000032

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_thr              :  4 ; /* bits 3:0 */
    ca_uint32_t high_thr             :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG1_INTF_FF_STS_REG                0xf4303484
#define L3FE_STG1_INTF_FF_STS_REG_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl_ind             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG1_INTF_FF_HDR_CNT                0xf4303488
#define L3FE_STG1_INTF_FF_HDR_CNT_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_HDR_CNT_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * PE
 */
        
#define L3FE_PE_PPPOE_CFG                        0xf4303500
#define L3FE_PE_PPPOE_CFG_dft                    0x00000011

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sess_ver_type        :  8 ; /* bits 7:0 */
    ca_uint32_t pppoe_code           :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PPPOE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_PPPOE_PROT_CFG                   0xf4303504
#define L3FE_PE_PPPOE_PROT_CFG_dft               0x00570021

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ipv4_protocol        : 16 ; /* bits 15:0 */
    ca_uint32_t ipv6_protocol        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PPPOE_PROT_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MIB_CFG                          0xf4303508
#define L3FE_PE_MIB_CFG_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t counter_wrap_around  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIB_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_PKT_CLR                 0xf430350c
#define L3FE_PE_DROP_SRC_PKT_CLR_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_BYTE_CLR                0xf4303510
#define L3FE_PE_DROP_SRC_BYTE_CLR_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CLR                      0xf4303514
#define L3FE_PE_RX_IFID_CLR_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CLR                      0xf4303518
#define L3FE_PE_TX_IFID_CLR_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_PE_CFG                           0xf430351c
#define L3FE_PE_PE_CFG_dft                       0x80100202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stomp_crc            :  1 ; /* bits 0:0 */
    ca_uint32_t bypass_crc_update    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ignore_tqm_fe_rdy    :  1 ; /* bits 3:3 */
    ca_uint32_t ldpid_base           :  6 ; /* bits 9:4 */
    ca_uint32_t gemid_map            :  1 ; /* bits 10:10 */
    ca_uint32_t dis_rd_add1          :  1 ; /* bits 11:11 */
    ca_uint32_t pad_ctrl             :  1 ; /* bits 12:12 */
    ca_uint32_t snap_fmt_bri         :  1 ; /* bits 13:13 */
    ca_uint32_t snap_fmt_tra         :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mtu_fail_ldpid       :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t mtu_fail_cos         :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd4               :  4 ;
    ca_uint32_t mtu_chk_en           :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_0                       0xf4303520
#define L3FE_PE_MTU_SIZE_0_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_0                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_1                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_1                       0xf4303524
#define L3FE_PE_MTU_SIZE_1_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_2                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_3                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_2                       0xf4303528
#define L3FE_PE_MTU_SIZE_2_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_4                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_5                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_3                       0xf430352c
#define L3FE_PE_MTU_SIZE_3_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_6                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_7                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_4                       0xf4303530
#define L3FE_PE_MTU_SIZE_4_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_8                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_9                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_5                       0xf4303534
#define L3FE_PE_MTU_SIZE_5_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_10               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_11               : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_6                       0xf4303538
#define L3FE_PE_MTU_SIZE_6_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_12               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_13               : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_7                       0xf430353c
#define L3FE_PE_MTU_SIZE_7_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_14               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_15               : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MIRROR_CFG                       0xf4303540
#define L3FE_PE_MIRROR_CFG_dft                   0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mirr_fifo_high_threshold :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t mirr_cos             :  3 ; /* bits 18:16 */
    ca_uint32_t mirr_ldpid           :  6 ; /* bits 24:19 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIRROR_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MIRROR_LEN_CFG                   0xf4303544
#define L3FE_PE_MIRROR_LEN_CFG_dft               0x00000080

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mirr_len             : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIRROR_LEN_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_ACCESS                  0xf4303548
#define L3FE_PE_DUAL_TBL_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA15                  0xf430354c
#define L3FE_PE_DUAL_TBL_DATA15_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA15_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA14                  0xf4303550
#define L3FE_PE_DUAL_TBL_DATA14_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA14_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA13                  0xf4303554
#define L3FE_PE_DUAL_TBL_DATA13_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA13_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA12                  0xf4303558
#define L3FE_PE_DUAL_TBL_DATA12_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA12_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA11                  0xf430355c
#define L3FE_PE_DUAL_TBL_DATA11_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA11_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA10                  0xf4303560
#define L3FE_PE_DUAL_TBL_DATA10_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA9                   0xf4303564
#define L3FE_PE_DUAL_TBL_DATA9_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA8                   0xf4303568
#define L3FE_PE_DUAL_TBL_DATA8_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA7                   0xf430356c
#define L3FE_PE_DUAL_TBL_DATA7_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA6                   0xf4303570
#define L3FE_PE_DUAL_TBL_DATA6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA5                   0xf4303574
#define L3FE_PE_DUAL_TBL_DATA5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA4                   0xf4303578
#define L3FE_PE_DUAL_TBL_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA3                   0xf430357c
#define L3FE_PE_DUAL_TBL_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA2                   0xf4303580
#define L3FE_PE_DUAL_TBL_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA1                   0xf4303584
#define L3FE_PE_DUAL_TBL_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA0                   0xf4303588
#define L3FE_PE_DUAL_TBL_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS      0xf430358c
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1       0xf4303590
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0       0xf4303594
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS     0xf4303598
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1      0xf430359c
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0      0xf43035a0
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_ACCESS           0xf43035a4
#define L3FE_PE_RX_IFID_CNT_TBL_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA7            0xf43035a8
#define L3FE_PE_RX_IFID_CNT_TBL_DATA7_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA6            0xf43035ac
#define L3FE_PE_RX_IFID_CNT_TBL_DATA6_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA5            0xf43035b0
#define L3FE_PE_RX_IFID_CNT_TBL_DATA5_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA4            0xf43035b4
#define L3FE_PE_RX_IFID_CNT_TBL_DATA4_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA3            0xf43035b8
#define L3FE_PE_RX_IFID_CNT_TBL_DATA3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA2            0xf43035bc
#define L3FE_PE_RX_IFID_CNT_TBL_DATA2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA1            0xf43035c0
#define L3FE_PE_RX_IFID_CNT_TBL_DATA1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA0            0xf43035c4
#define L3FE_PE_RX_IFID_CNT_TBL_DATA0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_ACCESS           0xf43035c8
#define L3FE_PE_TX_IFID_CNT_TBL_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA6            0xf43035cc
#define L3FE_PE_TX_IFID_CNT_TBL_DATA6_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA5            0xf43035d0
#define L3FE_PE_TX_IFID_CNT_TBL_DATA5_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA4            0xf43035d4
#define L3FE_PE_TX_IFID_CNT_TBL_DATA4_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA3            0xf43035d8
#define L3FE_PE_TX_IFID_CNT_TBL_DATA3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA2            0xf43035dc
#define L3FE_PE_TX_IFID_CNT_TBL_DATA2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA1            0xf43035e0
#define L3FE_PE_TX_IFID_CNT_TBL_DATA1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA0            0xf43035e4
#define L3FE_PE_TX_IFID_CNT_TBL_DATA0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH1                      0xf43035e8
#define L3FE_PE_VXLAN_HASH1_dft                  0xffff0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t min_sport            : 16 ; /* bits 15:0 */
    ca_uint32_t max_sport            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH2_SPORT                0xf43035ec
#define L3FE_PE_VXLAN_HASH2_SPORT_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ptn                  : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH2_SPORT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH2_DPORT                0xf43035f0
#define L3FE_PE_VXLAN_HASH2_DPORT_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ptn                  : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH2_DPORT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH2_SIP                  0xf43035f4
#define L3FE_PE_VXLAN_HASH2_SIP_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ptn                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH2_SIP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH2_DIP                  0xf43035f8
#define L3FE_PE_VXLAN_HASH2_DIP_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ptn                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH2_DIP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK0_                        0xf43035fc
#define L3FE_PE_GRE_ACK0__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK0__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK1_                        0xf4303600
#define L3FE_PE_GRE_ACK1__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK1__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK2_                        0xf4303604
#define L3FE_PE_GRE_ACK2__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK2__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK3_                        0xf4303608
#define L3FE_PE_GRE_ACK3__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK3__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK4_                        0xf430360c
#define L3FE_PE_GRE_ACK4__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK4__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK5_                        0xf4303610
#define L3FE_PE_GRE_ACK5__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK5__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK6_                        0xf4303614
#define L3FE_PE_GRE_ACK6__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK6__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK7_                        0xf4303618
#define L3FE_PE_GRE_ACK7__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK7__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK8_                        0xf430361c
#define L3FE_PE_GRE_ACK8__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK8__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK9_                        0xf4303620
#define L3FE_PE_GRE_ACK9__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK9__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK10_                       0xf4303624
#define L3FE_PE_GRE_ACK10__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK10__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK11_                       0xf4303628
#define L3FE_PE_GRE_ACK11__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK11__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK12_                       0xf430362c
#define L3FE_PE_GRE_ACK12__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK12__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK13_                       0xf4303630
#define L3FE_PE_GRE_ACK13__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK13__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK14_                       0xf4303634
#define L3FE_PE_GRE_ACK14__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK14__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK15_                       0xf4303638
#define L3FE_PE_GRE_ACK15__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK15__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ0_                        0xf430363c
#define L3FE_PE_GRE_SEQ0__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ0__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ1_                        0xf4303640
#define L3FE_PE_GRE_SEQ1__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ1__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ2_                        0xf4303644
#define L3FE_PE_GRE_SEQ2__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ2__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ3_                        0xf4303648
#define L3FE_PE_GRE_SEQ3__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ3__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ4_                        0xf430364c
#define L3FE_PE_GRE_SEQ4__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ4__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ5_                        0xf4303650
#define L3FE_PE_GRE_SEQ5__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ5__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ6_                        0xf4303654
#define L3FE_PE_GRE_SEQ6__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ6__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ7_                        0xf4303658
#define L3FE_PE_GRE_SEQ7__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ7__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ8_                        0xf430365c
#define L3FE_PE_GRE_SEQ8__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ8__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ9_                        0xf4303660
#define L3FE_PE_GRE_SEQ9__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ9__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ10_                       0xf4303664
#define L3FE_PE_GRE_SEQ10__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ10__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ11_                       0xf4303668
#define L3FE_PE_GRE_SEQ11__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ11__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ12_                       0xf430366c
#define L3FE_PE_GRE_SEQ12__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ12__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ13_                       0xf4303670
#define L3FE_PE_GRE_SEQ13__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ13__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ14_                       0xf4303674
#define L3FE_PE_GRE_SEQ14__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ14__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ15_                       0xf4303678
#define L3FE_PE_GRE_SEQ15__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ15__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID0_                         0xf430367c
#define L3FE_PE_IP4_ID0__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID0__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID1_                         0xf4303680
#define L3FE_PE_IP4_ID1__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID1__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID2_                         0xf4303684
#define L3FE_PE_IP4_ID2__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID2__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID3_                         0xf4303688
#define L3FE_PE_IP4_ID3__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID3__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID4_                         0xf430368c
#define L3FE_PE_IP4_ID4__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID4__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID5_                         0xf4303690
#define L3FE_PE_IP4_ID5__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID5__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID6_                         0xf4303694
#define L3FE_PE_IP4_ID6__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID6__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID7_                         0xf4303698
#define L3FE_PE_IP4_ID7__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID7__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID8_                         0xf430369c
#define L3FE_PE_IP4_ID8__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID8__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID9_                         0xf43036a0
#define L3FE_PE_IP4_ID9__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID9__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID10_                        0xf43036a4
#define L3FE_PE_IP4_ID10__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID10__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID11_                        0xf43036a8
#define L3FE_PE_IP4_ID11__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID11__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID12_                        0xf43036ac
#define L3FE_PE_IP4_ID12__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID12__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID13_                        0xf43036b0
#define L3FE_PE_IP4_ID13__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID13__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID14_                        0xf43036b4
#define L3FE_PE_IP4_ID14__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID14__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID15_                        0xf43036b8
#define L3FE_PE_IP4_ID15__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID15__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_SOP_CNT                          0xf43036bc
#define L3FE_PE_SOP_CNT_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SOP_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_EOP_CNT                          0xf43036c0
#define L3FE_PE_EOP_CNT_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_EOP_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_BYTE_CNT1                        0xf43036c4
#define L3FE_PE_BYTE_CNT1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_BYTE_CNT1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_BYTE_CNT0                        0xf43036c8
#define L3FE_PE_BYTE_CNT0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_BYTE_CNT0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_ERR_CNT                          0xf43036cc
#define L3FE_PE_ERR_CNT_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t len_err              :  8 ; /* bits 7:0 */
    ca_uint32_t sop_eop_err          :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_ERR_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_PE_CFG2                          0xf43036d0
#define L3FE_PE_PE_CFG2_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pe_prot_ldpid        :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PE_CFG2_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * FE_L3E_HS
 */
        
#define L3FE_FE_L3E_HS_PROFILE0_INI              0xf4303700
#define L3FE_FE_L3E_HS_PROFILE0_INI_STRIDE       44
#define L3FE_FE_L3E_HS_PROFILE0_INI_COUNT        7
#define L3FE_FE_L3E_HS_PROFILE0_INI_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpl_num              :  4 ; /* bits 3:0 */
    ca_uint32_t default_sel_0e       :  5 ; /* bits 8:4 */
    ca_uint32_t default_sel_0a       :  5 ; /* bits 13:9 */
    ca_uint32_t default_sel_1e       :  5 ; /* bits 18:14 */
    ca_uint32_t default_sel_1a       :  5 ; /* bits 23:19 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0           0xf4303704
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_STRIDE    44
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_COUNT     7
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t maskptr              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t pri                  :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t type                 :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_TUPLE0_t;
#endif /* !__ASSEMBLER__ */

                            
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION     0xf4303724
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_STRIDE 44
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_COUNT 7
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t a_mask               : 25 ; /* bits 24:0 */
    ca_uint32_t fetch_sz             :  3 ; /* bits 27:25 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_t;
#endif /* !__ASSEMBLER__ */

                                                                                                                                                                                                                                                                            
#define L3FE_FE_L3E_HS_HASH_INI                  0xf4303834
#define L3FE_FE_L3E_HS_HASH_INI_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t hb_size              :  2 ; /* bits 1:0 */
    ca_uint32_t ht_size              :  3 ; /* bits 4:2 */
    ca_uint32_t ha_width             :  3 ; /* bits 7:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t def_reg              :  1 ; /* bits 16:16 */
    ca_uint32_t crc_ntfy_en          :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_MH1                    0xf4303838
#define L3FE_FE_L3E_HS_BA_MH1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MH1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_MH0                    0xf430383c
#define L3FE_FE_L3E_HS_BA_MH0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MH0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_MA1                    0xf4303840
#define L3FE_FE_L3E_HS_BA_MA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_MA0                    0xf4303844
#define L3FE_FE_L3E_HS_BA_MA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OVERFLOW_INI              0xf4303848
#define L3FE_FE_L3E_HS_OVERFLOW_INI_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t oa_width             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_OA1                    0xf430384c
#define L3FE_FE_L3E_HS_BA_OA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_OA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_OA0                    0xf4303850
#define L3FE_FE_L3E_HS_BA_OA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_OA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEFAULT_INI               0xf4303854
#define L3FE_FE_L3E_HS_DEFAULT_INI_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t da_width             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEFAULT_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_DA1                    0xf4303858
#define L3FE_FE_L3E_HS_BA_DA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_DA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_DA0                    0xf430385c
#define L3FE_FE_L3E_HS_BA_DA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_DA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0          0xf4303860
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_STRIDE   4
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_COUNT    16
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t a_mask               : 25 ; /* bits 24:0 */
    ca_uint32_t fetch_sz             :  3 ; /* bits 27:25 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEFAULT_ACTION_0_t;
#endif /* !__ASSEMBLER__ */

                                                            
#define L3FE_FE_L3E_HS_CACHE_INI                 0xf43038a0
#define L3FE_FE_L3E_HS_CACHE_INI_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ct_size              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ca_width             :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t fib_sram             :  1 ; /* bits 16:16 */
    ca_uint32_t cache_half           :  1 ; /* bits 17:17 */
    ca_uint32_t cache_age0_hit       :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_CA1                    0xf43038a4
#define L3FE_FE_L3E_HS_BA_CA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_CA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_CA0                    0xf43038a8
#define L3FE_FE_L3E_HS_BA_CA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_CA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_CTRL                0xf43038ac
#define L3FE_FE_L3E_HS_CACHE_CTRL_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t slot                 :  5 ; /* bits 4:0 */
    ca_uint32_t crc16                : 16 ; /* bits 20:5 */
    ca_uint32_t aqm_prot             :  2 ; /* bits 22:21 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t loc                  :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t age                  :  2 ; /* bits 27:26 */
    ca_uint32_t pri                  :  2 ; /* bits 29:28 */
    ca_uint32_t cmd                  :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_CTRL_REQ            0xf43038b0
#define L3FE_FE_L3E_HS_CACHE_CTRL_REQ_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t req_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_REQ_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_CTRL_STS            0xf43038b4
#define L3FE_FE_L3E_HS_CACHE_CTRL_STS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bsy                  :  1 ; /* bits 0:0 */
    ca_uint32_t err_hash             :  1 ; /* bits 1:1 */
    ca_uint32_t err_free             :  1 ; /* bits 2:2 */
    ca_uint32_t err_nch              :  1 ; /* bits 3:3 */
    ca_uint32_t sts_match            :  1 ; /* bits 4:4 */
    ca_uint32_t sts_match_loc        :  1 ; /* bits 5:5 */
    ca_uint32_t sts_evict            :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_STS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_AGE10               0xf43038b8
#define L3FE_FE_L3E_HS_CACHE_AGE10_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ut_t0                : 16 ; /* bits 15:0 */
    ca_uint32_t ut_t1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_AGE10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_AGE32               0xf43038bc
#define L3FE_FE_L3E_HS_CACHE_AGE32_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ut_t2                : 16 ; /* bits 15:0 */
    ca_uint32_t ut_t3                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_AGE32_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_CNT                 0xf43038c0
#define L3FE_FE_L3E_HS_CACHE_CNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ut_cnt               : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_MISC                0xf43038c4
#define L3FE_FE_L3E_HS_CACHE_MISC_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t s2_ra_en             :  1 ; /* bits 26:26 */
    ca_uint32_t s2_ra_pri            :  2 ; /* bits 28:27 */
    ca_uint32_t crep_en              :  1 ; /* bits 29:29 */
    ca_uint32_t s3_loc_n             :  1 ; /* bits 30:30 */
    ca_uint32_t s3_ra_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_MISC_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AXI_CTRL_1                0xf43038c8
#define L3FE_FE_L3E_HS_AXI_CTRL_1_STRIDE         4
#define L3FE_FE_L3E_HS_AXI_CTRL_1_COUNT          4
#define L3FE_FE_L3E_HS_AXI_CTRL_1_dft            0x02000f00

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user                 : 25 ; /* bits 24:0 */
    ca_uint32_t id                   :  4 ; /* bits 28:25 */
    ca_uint32_t ace                  :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AXI_CTRL_1_t;
#endif /* !__ASSEMBLER__ */

            
#define L3FE_FE_L3E_HS_SWO_IDX                   0xf43038d8
#define L3FE_FE_L3E_HS_SWO_IDX_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t idx                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_IDX_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_SWO_DAT                   0xf43038dc
#define L3FE_FE_L3E_HS_SWO_DAT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dat                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_DAT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_SWO_CTRL                  0xf43038e0
#define L3FE_FE_L3E_HS_SWO_CTRL_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cmd_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_ACCESS         0xf43038e4
#define L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 17 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA6          0xf43038e8
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA6_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA5          0xf43038ec
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA5_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA4          0xf43038f0
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA4_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA3          0xf43038f4
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA3_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA2          0xf43038f8
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA2_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA1          0xf43038fc
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA1_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crc16                : 13 ; /* bits 12:0 */
    ca_uint32_t slot                 :  5 ; /* bits 17:13 */
    ca_uint32_t location             :  1 ; /* bits 18:18 */
    ca_uint32_t pri                  :  2 ; /* bits 20:19 */
    ca_uint32_t age                  :  2 ; /* bits 22:21 */
    ca_uint32_t fib                  :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA0          0xf4303900
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA0_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crc32                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS      0xf4303904
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1       0xf4303908
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crc16                : 16 ; /* bits 15:0 */
    ca_uint32_t profile              :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0       0xf430390c
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crc32                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_ACCESS           0xf4303910
#define L3FE_FE_L3E_HS_MASK_MEM_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_MASK3            0xf4303914
#define L3FE_FE_L3E_HS_MASK_MEM_MASK3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_MASK2            0xf4303918
#define L3FE_FE_L3E_HS_MASK_MEM_MASK2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_MASK1            0xf430391c
#define L3FE_FE_L3E_HS_MASK_MEM_MASK1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_MASK0            0xf4303920
#define L3FE_FE_L3E_HS_MASK_MEM_MASK0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AGING_GRANULARITY         0xf4303924
#define L3FE_FE_L3E_HS_AGING_GRANULARITY_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t timer                : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AGING_GRANULARITY_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS       0xf4303928
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t age                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3        0xf430392c
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2        0xf4303930
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1        0xf4303934
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0        0xf4303938
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MEM_INI                   0xf430393c
#define L3FE_FE_L3E_HS_MEM_INI_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t req_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MEM_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CHK_FAIL_CTRL             0xf4303940
#define L3FE_FE_L3E_HS_CHK_FAIL_CTRL_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type0                :  8 ; /* bits 7:0 */
    ca_uint32_t type1                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CHK_FAIL_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_RSV0                      0xf4303944
#define L3FE_FE_L3E_HS_RSV0_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsv                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_RSV0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_RSV1                      0xf4303948
#define L3FE_FE_L3E_HS_RSV1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsv                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_RSV1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_KEY                  0xf430394c
#define L3FE_FE_L3E_HS_PF_0_KEY_STRIDE           20
#define L3FE_FE_L3E_HS_PF_0_KEY_COUNT            7
#define L3FE_FE_L3E_HS_PF_0_KEY_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  6 ; /* bits 5:0 */
    ca_uint32_t crc32_sel            :  2 ; /* bits 7:6 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_KEY_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_TPL_SP               0xf4303950
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_STRIDE        20
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_COUNT         7
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_TPL_SP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_TPL_DP               0xf4303954
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_STRIDE        20
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_COUNT         7
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_TPL_DP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_TPL_SIP              0xf4303958
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_STRIDE       20
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_COUNT        7
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_TPL_SIP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_TPL_DIP              0xf430395c
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_STRIDE       20
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_COUNT        7
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_TPL_DIP_t;
#endif /* !__ASSEMBLER__ */

                                                                                                                        
#define L3FE_FE_L3E_HS_INV_MAC                   0xf43039d8
#define L3FE_FE_L3E_HS_INV_MAC_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t deepq                :  1 ; /* bits 6:6 */
    ca_uint32_t deepq_vld            :  1 ; /* bits 7:7 */
    ca_uint32_t keep_ori             :  1 ; /* bits 8:8 */
    ca_uint32_t keep_ori_vld         :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_INV_MAC_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY0             0xf43039dc
#define L3FE_FE_L3E_HS_DEF_REG0_ETY0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY0             0xf43039e0
#define L3FE_FE_L3E_HS_DEF_REG1_ETY0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY0             0xf43039e4
#define L3FE_FE_L3E_HS_DEF_REG2_ETY0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY1             0xf43039e8
#define L3FE_FE_L3E_HS_DEF_REG0_ETY1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY1             0xf43039ec
#define L3FE_FE_L3E_HS_DEF_REG1_ETY1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY1             0xf43039f0
#define L3FE_FE_L3E_HS_DEF_REG2_ETY1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY2             0xf43039f4
#define L3FE_FE_L3E_HS_DEF_REG0_ETY2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY2             0xf43039f8
#define L3FE_FE_L3E_HS_DEF_REG1_ETY2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY2             0xf43039fc
#define L3FE_FE_L3E_HS_DEF_REG2_ETY2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY3             0xf4303a00
#define L3FE_FE_L3E_HS_DEF_REG0_ETY3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY3             0xf4303a04
#define L3FE_FE_L3E_HS_DEF_REG1_ETY3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY3             0xf4303a08
#define L3FE_FE_L3E_HS_DEF_REG2_ETY3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY4             0xf4303a0c
#define L3FE_FE_L3E_HS_DEF_REG0_ETY4_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY4             0xf4303a10
#define L3FE_FE_L3E_HS_DEF_REG1_ETY4_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY4             0xf4303a14
#define L3FE_FE_L3E_HS_DEF_REG2_ETY4_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY5             0xf4303a18
#define L3FE_FE_L3E_HS_DEF_REG0_ETY5_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY5             0xf4303a1c
#define L3FE_FE_L3E_HS_DEF_REG1_ETY5_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY5             0xf4303a20
#define L3FE_FE_L3E_HS_DEF_REG2_ETY5_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY0            0xf4303a24
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY0            0xf4303a28
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY1            0xf4303a2c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY1            0xf4303a30
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY2            0xf4303a34
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY2            0xf4303a38
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY3            0xf4303a3c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY3            0xf4303a40
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY4            0xf4303a44
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY4_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY4            0xf4303a48
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY4_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY5            0xf4303a4c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY5_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY5            0xf4303a50
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY5_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY6            0xf4303a54
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY6_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY6            0xf4303a58
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY6_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY7            0xf4303a5c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY7_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY7            0xf4303a60
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY7_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY8            0xf4303a64
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY8_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY8            0xf4303a68
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY8_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY9            0xf4303a6c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY9_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY9            0xf4303a70
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY9_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY10           0xf4303a74
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY10_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY10           0xf4303a78
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY10_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY11           0xf4303a7c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY11_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY11_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY11           0xf4303a80
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY11_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY11_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY12           0xf4303a84
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY12_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY12_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY12           0xf4303a88
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY12_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY12_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY13           0xf4303a8c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY13_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY13_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY13           0xf4303a90
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY13_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY13_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY14           0xf4303a94
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY14_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY14_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY14           0xf4303a98
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY14_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY14_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY15           0xf4303a9c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY15_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY15_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY15           0xf4303aa0
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY15_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY15_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AQM_SET                   0xf4303aa4
#define L3FE_FE_L3E_HS_AQM_SET_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   :  1 ; /* bits 0:0 */
    ca_uint32_t cnt_md               :  1 ; /* bits 1:1 */
    ca_uint32_t act_tp               :  1 ; /* bits 2:2 */
    ca_uint32_t cos_en               :  3 ; /* bits 5:3 */
    ca_uint32_t sml_cos              :  3 ; /* bits 8:6 */
    ca_uint32_t mid_cos              :  3 ; /* bits 11:9 */
    ca_uint32_t big_cos              :  3 ; /* bits 14:12 */
    ca_uint32_t mid_on_prot          :  3 ; /* bits 17:15 */
    ca_uint32_t big_on_prot          :  3 ; /* bits 20:18 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AQM_SET_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AQM_INTER                 0xf4303aa8
#define L3FE_FE_L3E_HS_AQM_INTER_dft             0x9000a2d0

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt_sft              :  5 ; /* bits 4:0 */
    ca_uint32_t entry                : 23 ; /* bits 27:5 */
    ca_uint32_t bcnt_sft             :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AQM_INTER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AQM_MID                   0xf4303aac
#define L3FE_FE_L3E_HS_AQM_MID_dft               0x00001fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t on_thr               : 13 ; /* bits 12:0 */
    ca_uint32_t off_thr              : 13 ; /* bits 25:13 */
    ca_uint32_t on_thr_size          :  4 ; /* bits 29:26 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AQM_MID_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AQM_BIG                   0xf4303ab0
#define L3FE_FE_L3E_HS_AQM_BIG_dft               0x00001fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t on_thr               : 13 ; /* bits 12:0 */
    ca_uint32_t off_thr              : 13 ; /* bits 25:13 */
    ca_uint32_t on_thr_size          :  4 ; /* bits 29:26 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AQM_BIG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE0_OTHER            0xf4303ab4
#define L3FE_FE_L3E_HS_PROFILE0_OTHER_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_mask        :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_OTHER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE1_OTHER            0xf4303ab8
#define L3FE_FE_L3E_HS_PROFILE1_OTHER_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_mask        :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE1_OTHER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE2_OTHER            0xf4303abc
#define L3FE_FE_L3E_HS_PROFILE2_OTHER_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_mask        :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE2_OTHER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE3_OTHER            0xf4303ac0
#define L3FE_FE_L3E_HS_PROFILE3_OTHER_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_mask        :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE3_OTHER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE4_OTHER            0xf4303ac4
#define L3FE_FE_L3E_HS_PROFILE4_OTHER_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_mask        :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE4_OTHER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE5_OTHER            0xf4303ac8
#define L3FE_FE_L3E_HS_PROFILE5_OTHER_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_mask        :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE5_OTHER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE6_OTHER            0xf4303acc
#define L3FE_FE_L3E_HS_PROFILE6_OTHER_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_mask        :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE6_OTHER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE7_OTHER            0xf4303ad0
#define L3FE_FE_L3E_HS_PROFILE7_OTHER_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_mask        :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE7_OTHER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OTEHR_FAIL                0xf4303ad4
#define L3FE_FE_L3E_HS_OTEHR_FAIL_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tcp_flag_act         : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OTEHR_FAIL_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * AXIM2
 */
        
#define L3FE_AXIM2_CONFIG                        0xf4303c80
#define L3FE_AXIM2_CONFIG_dft                    0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_write_outtrans_num :  4 ; /* bits 3:0 */
    ca_uint32_t axi_read_outtrans_num :  4 ; /* bits 7:4 */
    ca_uint32_t axi_xbus_len         :  3 ; /* bits 10:8 */
    ca_uint32_t write_cacheline_trans_en :  1 ; /* bits 11:11 */
    ca_uint32_t write_cacheline_trans_size :  1 ; /* bits 12:12 */
    ca_uint32_t read_cacheline_trans_en :  1 ; /* bits 13:13 */
    ca_uint32_t read_cacheline_trans_size :  1 ; /* bits 14:14 */
    ca_uint32_t arcache_eos_en       :  1 ; /* bits 15:15 */
    ca_uint32_t awcache_eos_en       :  1 ; /* bits 16:16 */
    ca_uint32_t reserved             : 15 ; /* bits 31:17 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_AXIM2_TIMEOUT_THRESHOLD             0xf4303c84
#define L3FE_AXIM2_TIMEOUT_THRESHOLD_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_channel_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t write_channel_threshold :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_TIMEOUT_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_AXIM2_INTERRUPT_STATUS              0xf4303c88
#define L3FE_AXIM2_INTERRUPT_STATUS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_AXIM2_INTERRUPT_ENABLE              0xf4303c8c
#define L3FE_AXIM2_INTERRUPT_ENABLE_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int_en :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int_en :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int_en :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int_en :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */

    
  
    
      

/*
 * TRAFFIC
 */
        
#define L3FE_TRAFFIC_TBL_entry0                  0xf4304000
#define L3FE_TRAFFIC_TBL_entry0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry1                  0xf4304004
#define L3FE_TRAFFIC_TBL_entry1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry2                  0xf4304008
#define L3FE_TRAFFIC_TBL_entry2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry3                  0xf430400c
#define L3FE_TRAFFIC_TBL_entry3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry4                  0xf4304010
#define L3FE_TRAFFIC_TBL_entry4_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry5                  0xf4304014
#define L3FE_TRAFFIC_TBL_entry5_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry6                  0xf4304018
#define L3FE_TRAFFIC_TBL_entry6_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry7                  0xf430401c
#define L3FE_TRAFFIC_TBL_entry7_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry8                  0xf4304020
#define L3FE_TRAFFIC_TBL_entry8_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry9                  0xf4304024
#define L3FE_TRAFFIC_TBL_entry9_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry10                 0xf4304028
#define L3FE_TRAFFIC_TBL_entry10_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry11                 0xf430402c
#define L3FE_TRAFFIC_TBL_entry11_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry11_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry12                 0xf4304030
#define L3FE_TRAFFIC_TBL_entry12_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry12_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry13                 0xf4304034
#define L3FE_TRAFFIC_TBL_entry13_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry13_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry14                 0xf4304038
#define L3FE_TRAFFIC_TBL_entry14_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry14_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry15                 0xf430403c
#define L3FE_TRAFFIC_TBL_entry15_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry15_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry16                 0xf4304040
#define L3FE_TRAFFIC_TBL_entry16_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry16_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry17                 0xf4304044
#define L3FE_TRAFFIC_TBL_entry17_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry17_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry18                 0xf4304048
#define L3FE_TRAFFIC_TBL_entry18_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry18_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry19                 0xf430404c
#define L3FE_TRAFFIC_TBL_entry19_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry19_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry20                 0xf4304050
#define L3FE_TRAFFIC_TBL_entry20_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry20_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry21                 0xf4304054
#define L3FE_TRAFFIC_TBL_entry21_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry21_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry22                 0xf4304058
#define L3FE_TRAFFIC_TBL_entry22_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry22_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry23                 0xf430405c
#define L3FE_TRAFFIC_TBL_entry23_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry23_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry24                 0xf4304060
#define L3FE_TRAFFIC_TBL_entry24_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry24_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry25                 0xf4304064
#define L3FE_TRAFFIC_TBL_entry25_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry25_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry26                 0xf4304068
#define L3FE_TRAFFIC_TBL_entry26_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry26_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry27                 0xf430406c
#define L3FE_TRAFFIC_TBL_entry27_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry27_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry28                 0xf4304070
#define L3FE_TRAFFIC_TBL_entry28_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry28_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry29                 0xf4304074
#define L3FE_TRAFFIC_TBL_entry29_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry29_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry30                 0xf4304078
#define L3FE_TRAFFIC_TBL_entry30_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry30_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry31                 0xf430407c
#define L3FE_TRAFFIC_TBL_entry31_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry31_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry32                 0xf4304080
#define L3FE_TRAFFIC_TBL_entry32_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry32_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry33                 0xf4304084
#define L3FE_TRAFFIC_TBL_entry33_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry33_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry34                 0xf4304088
#define L3FE_TRAFFIC_TBL_entry34_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry34_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry35                 0xf430408c
#define L3FE_TRAFFIC_TBL_entry35_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry35_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry36                 0xf4304090
#define L3FE_TRAFFIC_TBL_entry36_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry36_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry37                 0xf4304094
#define L3FE_TRAFFIC_TBL_entry37_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry37_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry38                 0xf4304098
#define L3FE_TRAFFIC_TBL_entry38_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry38_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry39                 0xf430409c
#define L3FE_TRAFFIC_TBL_entry39_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry39_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry40                 0xf43040a0
#define L3FE_TRAFFIC_TBL_entry40_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry40_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry41                 0xf43040a4
#define L3FE_TRAFFIC_TBL_entry41_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry41_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry42                 0xf43040a8
#define L3FE_TRAFFIC_TBL_entry42_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry42_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry43                 0xf43040ac
#define L3FE_TRAFFIC_TBL_entry43_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry43_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry44                 0xf43040b0
#define L3FE_TRAFFIC_TBL_entry44_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry44_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry45                 0xf43040b4
#define L3FE_TRAFFIC_TBL_entry45_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry45_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry46                 0xf43040b8
#define L3FE_TRAFFIC_TBL_entry46_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry46_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry47                 0xf43040bc
#define L3FE_TRAFFIC_TBL_entry47_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry47_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry48                 0xf43040c0
#define L3FE_TRAFFIC_TBL_entry48_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry48_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry49                 0xf43040c4
#define L3FE_TRAFFIC_TBL_entry49_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry49_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry50                 0xf43040c8
#define L3FE_TRAFFIC_TBL_entry50_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry50_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry51                 0xf43040cc
#define L3FE_TRAFFIC_TBL_entry51_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry51_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry52                 0xf43040d0
#define L3FE_TRAFFIC_TBL_entry52_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry52_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry53                 0xf43040d4
#define L3FE_TRAFFIC_TBL_entry53_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry53_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry54                 0xf43040d8
#define L3FE_TRAFFIC_TBL_entry54_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry54_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry55                 0xf43040dc
#define L3FE_TRAFFIC_TBL_entry55_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry55_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry56                 0xf43040e0
#define L3FE_TRAFFIC_TBL_entry56_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry56_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry57                 0xf43040e4
#define L3FE_TRAFFIC_TBL_entry57_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry57_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry58                 0xf43040e8
#define L3FE_TRAFFIC_TBL_entry58_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry58_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry59                 0xf43040ec
#define L3FE_TRAFFIC_TBL_entry59_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry59_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry60                 0xf43040f0
#define L3FE_TRAFFIC_TBL_entry60_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry60_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry61                 0xf43040f4
#define L3FE_TRAFFIC_TBL_entry61_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry61_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry62                 0xf43040f8
#define L3FE_TRAFFIC_TBL_entry62_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry62_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry63                 0xf43040fc
#define L3FE_TRAFFIC_TBL_entry63_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry63_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry64                 0xf4304100
#define L3FE_TRAFFIC_TBL_entry64_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry64_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry65                 0xf4304104
#define L3FE_TRAFFIC_TBL_entry65_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry65_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry66                 0xf4304108
#define L3FE_TRAFFIC_TBL_entry66_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry66_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry67                 0xf430410c
#define L3FE_TRAFFIC_TBL_entry67_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry67_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry68                 0xf4304110
#define L3FE_TRAFFIC_TBL_entry68_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry68_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry69                 0xf4304114
#define L3FE_TRAFFIC_TBL_entry69_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry69_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry70                 0xf4304118
#define L3FE_TRAFFIC_TBL_entry70_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry70_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry71                 0xf430411c
#define L3FE_TRAFFIC_TBL_entry71_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry71_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry72                 0xf4304120
#define L3FE_TRAFFIC_TBL_entry72_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry72_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry73                 0xf4304124
#define L3FE_TRAFFIC_TBL_entry73_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry73_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry74                 0xf4304128
#define L3FE_TRAFFIC_TBL_entry74_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry74_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry75                 0xf430412c
#define L3FE_TRAFFIC_TBL_entry75_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry75_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry76                 0xf4304130
#define L3FE_TRAFFIC_TBL_entry76_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry76_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry77                 0xf4304134
#define L3FE_TRAFFIC_TBL_entry77_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry77_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry78                 0xf4304138
#define L3FE_TRAFFIC_TBL_entry78_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry78_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry79                 0xf430413c
#define L3FE_TRAFFIC_TBL_entry79_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry79_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry80                 0xf4304140
#define L3FE_TRAFFIC_TBL_entry80_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry80_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry81                 0xf4304144
#define L3FE_TRAFFIC_TBL_entry81_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry81_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry82                 0xf4304148
#define L3FE_TRAFFIC_TBL_entry82_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry82_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry83                 0xf430414c
#define L3FE_TRAFFIC_TBL_entry83_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry83_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry84                 0xf4304150
#define L3FE_TRAFFIC_TBL_entry84_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry84_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry85                 0xf4304154
#define L3FE_TRAFFIC_TBL_entry85_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry85_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry86                 0xf4304158
#define L3FE_TRAFFIC_TBL_entry86_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry86_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry87                 0xf430415c
#define L3FE_TRAFFIC_TBL_entry87_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry87_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry88                 0xf4304160
#define L3FE_TRAFFIC_TBL_entry88_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry88_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry89                 0xf4304164
#define L3FE_TRAFFIC_TBL_entry89_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry89_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry90                 0xf4304168
#define L3FE_TRAFFIC_TBL_entry90_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry90_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry91                 0xf430416c
#define L3FE_TRAFFIC_TBL_entry91_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry91_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry92                 0xf4304170
#define L3FE_TRAFFIC_TBL_entry92_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry92_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry93                 0xf4304174
#define L3FE_TRAFFIC_TBL_entry93_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry93_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry94                 0xf4304178
#define L3FE_TRAFFIC_TBL_entry94_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry94_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry95                 0xf430417c
#define L3FE_TRAFFIC_TBL_entry95_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry95_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry96                 0xf4304180
#define L3FE_TRAFFIC_TBL_entry96_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry96_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry97                 0xf4304184
#define L3FE_TRAFFIC_TBL_entry97_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry97_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry98                 0xf4304188
#define L3FE_TRAFFIC_TBL_entry98_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry98_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry99                 0xf430418c
#define L3FE_TRAFFIC_TBL_entry99_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry99_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry100                0xf4304190
#define L3FE_TRAFFIC_TBL_entry100_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry100_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry101                0xf4304194
#define L3FE_TRAFFIC_TBL_entry101_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry101_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry102                0xf4304198
#define L3FE_TRAFFIC_TBL_entry102_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry102_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry103                0xf430419c
#define L3FE_TRAFFIC_TBL_entry103_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry103_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry104                0xf43041a0
#define L3FE_TRAFFIC_TBL_entry104_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry104_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry105                0xf43041a4
#define L3FE_TRAFFIC_TBL_entry105_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry105_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry106                0xf43041a8
#define L3FE_TRAFFIC_TBL_entry106_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry106_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry107                0xf43041ac
#define L3FE_TRAFFIC_TBL_entry107_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry107_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry108                0xf43041b0
#define L3FE_TRAFFIC_TBL_entry108_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry108_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry109                0xf43041b4
#define L3FE_TRAFFIC_TBL_entry109_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry109_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry110                0xf43041b8
#define L3FE_TRAFFIC_TBL_entry110_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry110_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry111                0xf43041bc
#define L3FE_TRAFFIC_TBL_entry111_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry111_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry112                0xf43041c0
#define L3FE_TRAFFIC_TBL_entry112_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry112_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry113                0xf43041c4
#define L3FE_TRAFFIC_TBL_entry113_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry113_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry114                0xf43041c8
#define L3FE_TRAFFIC_TBL_entry114_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry114_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry115                0xf43041cc
#define L3FE_TRAFFIC_TBL_entry115_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry115_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry116                0xf43041d0
#define L3FE_TRAFFIC_TBL_entry116_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry116_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry117                0xf43041d4
#define L3FE_TRAFFIC_TBL_entry117_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry117_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry118                0xf43041d8
#define L3FE_TRAFFIC_TBL_entry118_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry118_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry119                0xf43041dc
#define L3FE_TRAFFIC_TBL_entry119_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry119_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry120                0xf43041e0
#define L3FE_TRAFFIC_TBL_entry120_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry120_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry121                0xf43041e4
#define L3FE_TRAFFIC_TBL_entry121_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry121_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry122                0xf43041e8
#define L3FE_TRAFFIC_TBL_entry122_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry122_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry123                0xf43041ec
#define L3FE_TRAFFIC_TBL_entry123_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry123_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry124                0xf43041f0
#define L3FE_TRAFFIC_TBL_entry124_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry124_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry125                0xf43041f4
#define L3FE_TRAFFIC_TBL_entry125_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry125_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry126                0xf43041f8
#define L3FE_TRAFFIC_TBL_entry126_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry126_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry127                0xf43041fc
#define L3FE_TRAFFIC_TBL_entry127_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry127_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry128                0xf4304200
#define L3FE_TRAFFIC_TBL_entry128_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry128_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry129                0xf4304204
#define L3FE_TRAFFIC_TBL_entry129_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry129_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry130                0xf4304208
#define L3FE_TRAFFIC_TBL_entry130_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry130_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry131                0xf430420c
#define L3FE_TRAFFIC_TBL_entry131_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry131_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry132                0xf4304210
#define L3FE_TRAFFIC_TBL_entry132_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry132_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry133                0xf4304214
#define L3FE_TRAFFIC_TBL_entry133_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry133_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry134                0xf4304218
#define L3FE_TRAFFIC_TBL_entry134_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry134_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry135                0xf430421c
#define L3FE_TRAFFIC_TBL_entry135_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry135_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry136                0xf4304220
#define L3FE_TRAFFIC_TBL_entry136_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry136_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry137                0xf4304224
#define L3FE_TRAFFIC_TBL_entry137_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry137_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry138                0xf4304228
#define L3FE_TRAFFIC_TBL_entry138_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry138_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry139                0xf430422c
#define L3FE_TRAFFIC_TBL_entry139_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry139_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry140                0xf4304230
#define L3FE_TRAFFIC_TBL_entry140_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry140_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry141                0xf4304234
#define L3FE_TRAFFIC_TBL_entry141_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry141_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry142                0xf4304238
#define L3FE_TRAFFIC_TBL_entry142_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry142_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry143                0xf430423c
#define L3FE_TRAFFIC_TBL_entry143_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry143_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry144                0xf4304240
#define L3FE_TRAFFIC_TBL_entry144_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry144_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry145                0xf4304244
#define L3FE_TRAFFIC_TBL_entry145_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry145_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry146                0xf4304248
#define L3FE_TRAFFIC_TBL_entry146_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry146_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry147                0xf430424c
#define L3FE_TRAFFIC_TBL_entry147_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry147_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry148                0xf4304250
#define L3FE_TRAFFIC_TBL_entry148_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry148_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry149                0xf4304254
#define L3FE_TRAFFIC_TBL_entry149_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry149_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry150                0xf4304258
#define L3FE_TRAFFIC_TBL_entry150_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry150_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry151                0xf430425c
#define L3FE_TRAFFIC_TBL_entry151_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry151_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry152                0xf4304260
#define L3FE_TRAFFIC_TBL_entry152_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry152_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry153                0xf4304264
#define L3FE_TRAFFIC_TBL_entry153_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry153_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry154                0xf4304268
#define L3FE_TRAFFIC_TBL_entry154_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry154_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry155                0xf430426c
#define L3FE_TRAFFIC_TBL_entry155_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry155_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry156                0xf4304270
#define L3FE_TRAFFIC_TBL_entry156_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry156_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry157                0xf4304274
#define L3FE_TRAFFIC_TBL_entry157_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry157_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry158                0xf4304278
#define L3FE_TRAFFIC_TBL_entry158_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry158_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry159                0xf430427c
#define L3FE_TRAFFIC_TBL_entry159_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry159_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry160                0xf4304280
#define L3FE_TRAFFIC_TBL_entry160_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry160_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry161                0xf4304284
#define L3FE_TRAFFIC_TBL_entry161_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry161_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry162                0xf4304288
#define L3FE_TRAFFIC_TBL_entry162_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry162_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry163                0xf430428c
#define L3FE_TRAFFIC_TBL_entry163_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry163_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry164                0xf4304290
#define L3FE_TRAFFIC_TBL_entry164_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry164_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry165                0xf4304294
#define L3FE_TRAFFIC_TBL_entry165_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry165_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry166                0xf4304298
#define L3FE_TRAFFIC_TBL_entry166_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry166_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry167                0xf430429c
#define L3FE_TRAFFIC_TBL_entry167_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry167_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry168                0xf43042a0
#define L3FE_TRAFFIC_TBL_entry168_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry168_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry169                0xf43042a4
#define L3FE_TRAFFIC_TBL_entry169_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry169_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry170                0xf43042a8
#define L3FE_TRAFFIC_TBL_entry170_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry170_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry171                0xf43042ac
#define L3FE_TRAFFIC_TBL_entry171_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry171_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry172                0xf43042b0
#define L3FE_TRAFFIC_TBL_entry172_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry172_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry173                0xf43042b4
#define L3FE_TRAFFIC_TBL_entry173_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry173_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry174                0xf43042b8
#define L3FE_TRAFFIC_TBL_entry174_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry174_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry175                0xf43042bc
#define L3FE_TRAFFIC_TBL_entry175_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry175_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry176                0xf43042c0
#define L3FE_TRAFFIC_TBL_entry176_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry176_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry177                0xf43042c4
#define L3FE_TRAFFIC_TBL_entry177_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry177_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry178                0xf43042c8
#define L3FE_TRAFFIC_TBL_entry178_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry178_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry179                0xf43042cc
#define L3FE_TRAFFIC_TBL_entry179_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry179_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry180                0xf43042d0
#define L3FE_TRAFFIC_TBL_entry180_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry180_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry181                0xf43042d4
#define L3FE_TRAFFIC_TBL_entry181_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry181_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry182                0xf43042d8
#define L3FE_TRAFFIC_TBL_entry182_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry182_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry183                0xf43042dc
#define L3FE_TRAFFIC_TBL_entry183_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry183_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry184                0xf43042e0
#define L3FE_TRAFFIC_TBL_entry184_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry184_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry185                0xf43042e4
#define L3FE_TRAFFIC_TBL_entry185_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry185_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry186                0xf43042e8
#define L3FE_TRAFFIC_TBL_entry186_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry186_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry187                0xf43042ec
#define L3FE_TRAFFIC_TBL_entry187_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry187_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry188                0xf43042f0
#define L3FE_TRAFFIC_TBL_entry188_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry188_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry189                0xf43042f4
#define L3FE_TRAFFIC_TBL_entry189_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry189_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry190                0xf43042f8
#define L3FE_TRAFFIC_TBL_entry190_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry190_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry191                0xf43042fc
#define L3FE_TRAFFIC_TBL_entry191_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry191_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry192                0xf4304300
#define L3FE_TRAFFIC_TBL_entry192_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry192_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry193                0xf4304304
#define L3FE_TRAFFIC_TBL_entry193_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry193_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry194                0xf4304308
#define L3FE_TRAFFIC_TBL_entry194_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry194_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry195                0xf430430c
#define L3FE_TRAFFIC_TBL_entry195_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry195_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry196                0xf4304310
#define L3FE_TRAFFIC_TBL_entry196_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry196_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry197                0xf4304314
#define L3FE_TRAFFIC_TBL_entry197_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry197_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry198                0xf4304318
#define L3FE_TRAFFIC_TBL_entry198_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry198_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry199                0xf430431c
#define L3FE_TRAFFIC_TBL_entry199_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry199_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry200                0xf4304320
#define L3FE_TRAFFIC_TBL_entry200_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry200_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry201                0xf4304324
#define L3FE_TRAFFIC_TBL_entry201_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry201_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry202                0xf4304328
#define L3FE_TRAFFIC_TBL_entry202_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry202_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry203                0xf430432c
#define L3FE_TRAFFIC_TBL_entry203_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry203_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry204                0xf4304330
#define L3FE_TRAFFIC_TBL_entry204_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry204_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry205                0xf4304334
#define L3FE_TRAFFIC_TBL_entry205_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry205_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry206                0xf4304338
#define L3FE_TRAFFIC_TBL_entry206_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry206_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry207                0xf430433c
#define L3FE_TRAFFIC_TBL_entry207_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry207_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry208                0xf4304340
#define L3FE_TRAFFIC_TBL_entry208_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry208_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry209                0xf4304344
#define L3FE_TRAFFIC_TBL_entry209_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry209_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry210                0xf4304348
#define L3FE_TRAFFIC_TBL_entry210_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry210_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry211                0xf430434c
#define L3FE_TRAFFIC_TBL_entry211_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry211_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry212                0xf4304350
#define L3FE_TRAFFIC_TBL_entry212_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry212_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry213                0xf4304354
#define L3FE_TRAFFIC_TBL_entry213_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry213_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry214                0xf4304358
#define L3FE_TRAFFIC_TBL_entry214_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry214_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry215                0xf430435c
#define L3FE_TRAFFIC_TBL_entry215_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry215_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry216                0xf4304360
#define L3FE_TRAFFIC_TBL_entry216_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry216_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry217                0xf4304364
#define L3FE_TRAFFIC_TBL_entry217_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry217_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry218                0xf4304368
#define L3FE_TRAFFIC_TBL_entry218_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry218_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry219                0xf430436c
#define L3FE_TRAFFIC_TBL_entry219_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry219_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry220                0xf4304370
#define L3FE_TRAFFIC_TBL_entry220_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry220_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry221                0xf4304374
#define L3FE_TRAFFIC_TBL_entry221_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry221_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry222                0xf4304378
#define L3FE_TRAFFIC_TBL_entry222_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry222_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry223                0xf430437c
#define L3FE_TRAFFIC_TBL_entry223_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry223_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry224                0xf4304380
#define L3FE_TRAFFIC_TBL_entry224_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry224_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry225                0xf4304384
#define L3FE_TRAFFIC_TBL_entry225_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry225_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry226                0xf4304388
#define L3FE_TRAFFIC_TBL_entry226_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry226_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry227                0xf430438c
#define L3FE_TRAFFIC_TBL_entry227_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry227_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry228                0xf4304390
#define L3FE_TRAFFIC_TBL_entry228_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry228_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry229                0xf4304394
#define L3FE_TRAFFIC_TBL_entry229_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry229_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry230                0xf4304398
#define L3FE_TRAFFIC_TBL_entry230_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry230_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry231                0xf430439c
#define L3FE_TRAFFIC_TBL_entry231_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry231_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry232                0xf43043a0
#define L3FE_TRAFFIC_TBL_entry232_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry232_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry233                0xf43043a4
#define L3FE_TRAFFIC_TBL_entry233_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry233_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry234                0xf43043a8
#define L3FE_TRAFFIC_TBL_entry234_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry234_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry235                0xf43043ac
#define L3FE_TRAFFIC_TBL_entry235_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry235_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry236                0xf43043b0
#define L3FE_TRAFFIC_TBL_entry236_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry236_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry237                0xf43043b4
#define L3FE_TRAFFIC_TBL_entry237_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry237_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry238                0xf43043b8
#define L3FE_TRAFFIC_TBL_entry238_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry238_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry239                0xf43043bc
#define L3FE_TRAFFIC_TBL_entry239_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry239_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry240                0xf43043c0
#define L3FE_TRAFFIC_TBL_entry240_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry240_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry241                0xf43043c4
#define L3FE_TRAFFIC_TBL_entry241_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry241_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry242                0xf43043c8
#define L3FE_TRAFFIC_TBL_entry242_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry242_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry243                0xf43043cc
#define L3FE_TRAFFIC_TBL_entry243_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry243_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry244                0xf43043d0
#define L3FE_TRAFFIC_TBL_entry244_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry244_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry245                0xf43043d4
#define L3FE_TRAFFIC_TBL_entry245_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry245_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry246                0xf43043d8
#define L3FE_TRAFFIC_TBL_entry246_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry246_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry247                0xf43043dc
#define L3FE_TRAFFIC_TBL_entry247_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry247_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry248                0xf43043e0
#define L3FE_TRAFFIC_TBL_entry248_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry248_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry249                0xf43043e4
#define L3FE_TRAFFIC_TBL_entry249_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry249_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry250                0xf43043e8
#define L3FE_TRAFFIC_TBL_entry250_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry250_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry251                0xf43043ec
#define L3FE_TRAFFIC_TBL_entry251_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry251_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry252                0xf43043f0
#define L3FE_TRAFFIC_TBL_entry252_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry252_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry253                0xf43043f4
#define L3FE_TRAFFIC_TBL_entry253_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry253_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry254                0xf43043f8
#define L3FE_TRAFFIC_TBL_entry254_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry254_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry255                0xf43043fc
#define L3FE_TRAFFIC_TBL_entry255_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry255_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry256                0xf4304400
#define L3FE_TRAFFIC_TBL_entry256_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry256_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry257                0xf4304404
#define L3FE_TRAFFIC_TBL_entry257_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry257_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry258                0xf4304408
#define L3FE_TRAFFIC_TBL_entry258_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry258_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry259                0xf430440c
#define L3FE_TRAFFIC_TBL_entry259_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry259_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry260                0xf4304410
#define L3FE_TRAFFIC_TBL_entry260_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry260_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry261                0xf4304414
#define L3FE_TRAFFIC_TBL_entry261_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry261_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry262                0xf4304418
#define L3FE_TRAFFIC_TBL_entry262_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry262_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry263                0xf430441c
#define L3FE_TRAFFIC_TBL_entry263_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry263_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry264                0xf4304420
#define L3FE_TRAFFIC_TBL_entry264_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry264_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry265                0xf4304424
#define L3FE_TRAFFIC_TBL_entry265_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry265_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry266                0xf4304428
#define L3FE_TRAFFIC_TBL_entry266_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry266_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry267                0xf430442c
#define L3FE_TRAFFIC_TBL_entry267_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry267_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry268                0xf4304430
#define L3FE_TRAFFIC_TBL_entry268_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry268_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry269                0xf4304434
#define L3FE_TRAFFIC_TBL_entry269_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry269_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry270                0xf4304438
#define L3FE_TRAFFIC_TBL_entry270_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry270_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry271                0xf430443c
#define L3FE_TRAFFIC_TBL_entry271_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry271_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry272                0xf4304440
#define L3FE_TRAFFIC_TBL_entry272_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry272_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry273                0xf4304444
#define L3FE_TRAFFIC_TBL_entry273_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry273_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry274                0xf4304448
#define L3FE_TRAFFIC_TBL_entry274_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry274_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry275                0xf430444c
#define L3FE_TRAFFIC_TBL_entry275_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry275_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry276                0xf4304450
#define L3FE_TRAFFIC_TBL_entry276_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry276_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry277                0xf4304454
#define L3FE_TRAFFIC_TBL_entry277_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry277_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry278                0xf4304458
#define L3FE_TRAFFIC_TBL_entry278_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry278_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry279                0xf430445c
#define L3FE_TRAFFIC_TBL_entry279_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry279_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry280                0xf4304460
#define L3FE_TRAFFIC_TBL_entry280_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry280_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry281                0xf4304464
#define L3FE_TRAFFIC_TBL_entry281_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry281_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry282                0xf4304468
#define L3FE_TRAFFIC_TBL_entry282_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry282_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry283                0xf430446c
#define L3FE_TRAFFIC_TBL_entry283_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry283_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry284                0xf4304470
#define L3FE_TRAFFIC_TBL_entry284_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry284_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry285                0xf4304474
#define L3FE_TRAFFIC_TBL_entry285_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry285_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry286                0xf4304478
#define L3FE_TRAFFIC_TBL_entry286_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry286_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry287                0xf430447c
#define L3FE_TRAFFIC_TBL_entry287_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry287_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry288                0xf4304480
#define L3FE_TRAFFIC_TBL_entry288_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry288_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry289                0xf4304484
#define L3FE_TRAFFIC_TBL_entry289_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry289_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry290                0xf4304488
#define L3FE_TRAFFIC_TBL_entry290_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry290_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry291                0xf430448c
#define L3FE_TRAFFIC_TBL_entry291_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry291_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry292                0xf4304490
#define L3FE_TRAFFIC_TBL_entry292_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry292_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry293                0xf4304494
#define L3FE_TRAFFIC_TBL_entry293_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry293_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry294                0xf4304498
#define L3FE_TRAFFIC_TBL_entry294_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry294_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry295                0xf430449c
#define L3FE_TRAFFIC_TBL_entry295_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry295_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry296                0xf43044a0
#define L3FE_TRAFFIC_TBL_entry296_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry296_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry297                0xf43044a4
#define L3FE_TRAFFIC_TBL_entry297_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry297_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry298                0xf43044a8
#define L3FE_TRAFFIC_TBL_entry298_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry298_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry299                0xf43044ac
#define L3FE_TRAFFIC_TBL_entry299_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry299_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry300                0xf43044b0
#define L3FE_TRAFFIC_TBL_entry300_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry300_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry301                0xf43044b4
#define L3FE_TRAFFIC_TBL_entry301_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry301_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry302                0xf43044b8
#define L3FE_TRAFFIC_TBL_entry302_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry302_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry303                0xf43044bc
#define L3FE_TRAFFIC_TBL_entry303_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry303_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry304                0xf43044c0
#define L3FE_TRAFFIC_TBL_entry304_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry304_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry305                0xf43044c4
#define L3FE_TRAFFIC_TBL_entry305_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry305_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry306                0xf43044c8
#define L3FE_TRAFFIC_TBL_entry306_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry306_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry307                0xf43044cc
#define L3FE_TRAFFIC_TBL_entry307_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry307_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry308                0xf43044d0
#define L3FE_TRAFFIC_TBL_entry308_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry308_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry309                0xf43044d4
#define L3FE_TRAFFIC_TBL_entry309_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry309_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry310                0xf43044d8
#define L3FE_TRAFFIC_TBL_entry310_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry310_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry311                0xf43044dc
#define L3FE_TRAFFIC_TBL_entry311_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry311_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry312                0xf43044e0
#define L3FE_TRAFFIC_TBL_entry312_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry312_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry313                0xf43044e4
#define L3FE_TRAFFIC_TBL_entry313_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry313_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry314                0xf43044e8
#define L3FE_TRAFFIC_TBL_entry314_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry314_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry315                0xf43044ec
#define L3FE_TRAFFIC_TBL_entry315_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry315_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry316                0xf43044f0
#define L3FE_TRAFFIC_TBL_entry316_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry316_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry317                0xf43044f4
#define L3FE_TRAFFIC_TBL_entry317_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry317_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry318                0xf43044f8
#define L3FE_TRAFFIC_TBL_entry318_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry318_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry319                0xf43044fc
#define L3FE_TRAFFIC_TBL_entry319_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry319_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry320                0xf4304500
#define L3FE_TRAFFIC_TBL_entry320_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry320_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry321                0xf4304504
#define L3FE_TRAFFIC_TBL_entry321_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry321_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry322                0xf4304508
#define L3FE_TRAFFIC_TBL_entry322_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry322_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry323                0xf430450c
#define L3FE_TRAFFIC_TBL_entry323_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry323_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry324                0xf4304510
#define L3FE_TRAFFIC_TBL_entry324_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry324_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry325                0xf4304514
#define L3FE_TRAFFIC_TBL_entry325_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry325_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry326                0xf4304518
#define L3FE_TRAFFIC_TBL_entry326_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry326_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry327                0xf430451c
#define L3FE_TRAFFIC_TBL_entry327_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry327_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry328                0xf4304520
#define L3FE_TRAFFIC_TBL_entry328_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry328_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry329                0xf4304524
#define L3FE_TRAFFIC_TBL_entry329_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry329_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry330                0xf4304528
#define L3FE_TRAFFIC_TBL_entry330_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry330_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry331                0xf430452c
#define L3FE_TRAFFIC_TBL_entry331_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry331_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry332                0xf4304530
#define L3FE_TRAFFIC_TBL_entry332_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry332_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry333                0xf4304534
#define L3FE_TRAFFIC_TBL_entry333_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry333_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry334                0xf4304538
#define L3FE_TRAFFIC_TBL_entry334_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry334_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry335                0xf430453c
#define L3FE_TRAFFIC_TBL_entry335_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry335_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry336                0xf4304540
#define L3FE_TRAFFIC_TBL_entry336_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry336_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry337                0xf4304544
#define L3FE_TRAFFIC_TBL_entry337_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry337_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry338                0xf4304548
#define L3FE_TRAFFIC_TBL_entry338_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry338_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry339                0xf430454c
#define L3FE_TRAFFIC_TBL_entry339_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry339_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry340                0xf4304550
#define L3FE_TRAFFIC_TBL_entry340_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry340_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry341                0xf4304554
#define L3FE_TRAFFIC_TBL_entry341_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry341_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry342                0xf4304558
#define L3FE_TRAFFIC_TBL_entry342_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry342_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry343                0xf430455c
#define L3FE_TRAFFIC_TBL_entry343_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry343_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry344                0xf4304560
#define L3FE_TRAFFIC_TBL_entry344_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry344_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry345                0xf4304564
#define L3FE_TRAFFIC_TBL_entry345_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry345_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry346                0xf4304568
#define L3FE_TRAFFIC_TBL_entry346_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry346_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry347                0xf430456c
#define L3FE_TRAFFIC_TBL_entry347_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry347_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry348                0xf4304570
#define L3FE_TRAFFIC_TBL_entry348_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry348_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry349                0xf4304574
#define L3FE_TRAFFIC_TBL_entry349_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry349_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry350                0xf4304578
#define L3FE_TRAFFIC_TBL_entry350_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry350_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry351                0xf430457c
#define L3FE_TRAFFIC_TBL_entry351_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry351_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry352                0xf4304580
#define L3FE_TRAFFIC_TBL_entry352_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry352_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry353                0xf4304584
#define L3FE_TRAFFIC_TBL_entry353_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry353_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry354                0xf4304588
#define L3FE_TRAFFIC_TBL_entry354_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry354_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry355                0xf430458c
#define L3FE_TRAFFIC_TBL_entry355_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry355_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry356                0xf4304590
#define L3FE_TRAFFIC_TBL_entry356_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry356_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry357                0xf4304594
#define L3FE_TRAFFIC_TBL_entry357_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry357_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry358                0xf4304598
#define L3FE_TRAFFIC_TBL_entry358_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry358_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry359                0xf430459c
#define L3FE_TRAFFIC_TBL_entry359_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry359_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry360                0xf43045a0
#define L3FE_TRAFFIC_TBL_entry360_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry360_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry361                0xf43045a4
#define L3FE_TRAFFIC_TBL_entry361_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry361_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry362                0xf43045a8
#define L3FE_TRAFFIC_TBL_entry362_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry362_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry363                0xf43045ac
#define L3FE_TRAFFIC_TBL_entry363_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry363_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry364                0xf43045b0
#define L3FE_TRAFFIC_TBL_entry364_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry364_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry365                0xf43045b4
#define L3FE_TRAFFIC_TBL_entry365_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry365_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry366                0xf43045b8
#define L3FE_TRAFFIC_TBL_entry366_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry366_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry367                0xf43045bc
#define L3FE_TRAFFIC_TBL_entry367_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry367_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry368                0xf43045c0
#define L3FE_TRAFFIC_TBL_entry368_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry368_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry369                0xf43045c4
#define L3FE_TRAFFIC_TBL_entry369_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry369_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry370                0xf43045c8
#define L3FE_TRAFFIC_TBL_entry370_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry370_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry371                0xf43045cc
#define L3FE_TRAFFIC_TBL_entry371_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry371_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry372                0xf43045d0
#define L3FE_TRAFFIC_TBL_entry372_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry372_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry373                0xf43045d4
#define L3FE_TRAFFIC_TBL_entry373_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry373_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry374                0xf43045d8
#define L3FE_TRAFFIC_TBL_entry374_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry374_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry375                0xf43045dc
#define L3FE_TRAFFIC_TBL_entry375_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry375_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry376                0xf43045e0
#define L3FE_TRAFFIC_TBL_entry376_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry376_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry377                0xf43045e4
#define L3FE_TRAFFIC_TBL_entry377_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry377_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry378                0xf43045e8
#define L3FE_TRAFFIC_TBL_entry378_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry378_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry379                0xf43045ec
#define L3FE_TRAFFIC_TBL_entry379_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry379_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry380                0xf43045f0
#define L3FE_TRAFFIC_TBL_entry380_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry380_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry381                0xf43045f4
#define L3FE_TRAFFIC_TBL_entry381_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry381_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry382                0xf43045f8
#define L3FE_TRAFFIC_TBL_entry382_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry382_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry383                0xf43045fc
#define L3FE_TRAFFIC_TBL_entry383_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry383_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry384                0xf4304600
#define L3FE_TRAFFIC_TBL_entry384_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry384_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry385                0xf4304604
#define L3FE_TRAFFIC_TBL_entry385_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry385_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry386                0xf4304608
#define L3FE_TRAFFIC_TBL_entry386_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry386_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry387                0xf430460c
#define L3FE_TRAFFIC_TBL_entry387_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry387_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry388                0xf4304610
#define L3FE_TRAFFIC_TBL_entry388_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry388_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry389                0xf4304614
#define L3FE_TRAFFIC_TBL_entry389_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry389_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry390                0xf4304618
#define L3FE_TRAFFIC_TBL_entry390_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry390_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry391                0xf430461c
#define L3FE_TRAFFIC_TBL_entry391_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry391_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry392                0xf4304620
#define L3FE_TRAFFIC_TBL_entry392_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry392_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry393                0xf4304624
#define L3FE_TRAFFIC_TBL_entry393_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry393_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry394                0xf4304628
#define L3FE_TRAFFIC_TBL_entry394_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry394_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry395                0xf430462c
#define L3FE_TRAFFIC_TBL_entry395_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry395_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry396                0xf4304630
#define L3FE_TRAFFIC_TBL_entry396_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry396_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry397                0xf4304634
#define L3FE_TRAFFIC_TBL_entry397_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry397_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry398                0xf4304638
#define L3FE_TRAFFIC_TBL_entry398_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry398_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry399                0xf430463c
#define L3FE_TRAFFIC_TBL_entry399_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry399_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry400                0xf4304640
#define L3FE_TRAFFIC_TBL_entry400_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry400_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry401                0xf4304644
#define L3FE_TRAFFIC_TBL_entry401_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry401_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry402                0xf4304648
#define L3FE_TRAFFIC_TBL_entry402_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry402_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry403                0xf430464c
#define L3FE_TRAFFIC_TBL_entry403_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry403_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry404                0xf4304650
#define L3FE_TRAFFIC_TBL_entry404_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry404_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry405                0xf4304654
#define L3FE_TRAFFIC_TBL_entry405_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry405_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry406                0xf4304658
#define L3FE_TRAFFIC_TBL_entry406_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry406_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry407                0xf430465c
#define L3FE_TRAFFIC_TBL_entry407_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry407_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry408                0xf4304660
#define L3FE_TRAFFIC_TBL_entry408_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry408_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry409                0xf4304664
#define L3FE_TRAFFIC_TBL_entry409_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry409_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry410                0xf4304668
#define L3FE_TRAFFIC_TBL_entry410_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry410_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry411                0xf430466c
#define L3FE_TRAFFIC_TBL_entry411_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry411_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry412                0xf4304670
#define L3FE_TRAFFIC_TBL_entry412_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry412_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry413                0xf4304674
#define L3FE_TRAFFIC_TBL_entry413_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry413_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry414                0xf4304678
#define L3FE_TRAFFIC_TBL_entry414_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry414_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry415                0xf430467c
#define L3FE_TRAFFIC_TBL_entry415_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry415_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry416                0xf4304680
#define L3FE_TRAFFIC_TBL_entry416_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry416_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry417                0xf4304684
#define L3FE_TRAFFIC_TBL_entry417_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry417_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry418                0xf4304688
#define L3FE_TRAFFIC_TBL_entry418_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry418_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry419                0xf430468c
#define L3FE_TRAFFIC_TBL_entry419_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry419_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry420                0xf4304690
#define L3FE_TRAFFIC_TBL_entry420_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry420_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry421                0xf4304694
#define L3FE_TRAFFIC_TBL_entry421_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry421_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry422                0xf4304698
#define L3FE_TRAFFIC_TBL_entry422_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry422_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry423                0xf430469c
#define L3FE_TRAFFIC_TBL_entry423_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry423_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry424                0xf43046a0
#define L3FE_TRAFFIC_TBL_entry424_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry424_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry425                0xf43046a4
#define L3FE_TRAFFIC_TBL_entry425_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry425_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry426                0xf43046a8
#define L3FE_TRAFFIC_TBL_entry426_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry426_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry427                0xf43046ac
#define L3FE_TRAFFIC_TBL_entry427_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry427_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry428                0xf43046b0
#define L3FE_TRAFFIC_TBL_entry428_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry428_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry429                0xf43046b4
#define L3FE_TRAFFIC_TBL_entry429_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry429_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry430                0xf43046b8
#define L3FE_TRAFFIC_TBL_entry430_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry430_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry431                0xf43046bc
#define L3FE_TRAFFIC_TBL_entry431_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry431_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry432                0xf43046c0
#define L3FE_TRAFFIC_TBL_entry432_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry432_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry433                0xf43046c4
#define L3FE_TRAFFIC_TBL_entry433_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry433_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry434                0xf43046c8
#define L3FE_TRAFFIC_TBL_entry434_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry434_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry435                0xf43046cc
#define L3FE_TRAFFIC_TBL_entry435_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry435_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry436                0xf43046d0
#define L3FE_TRAFFIC_TBL_entry436_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry436_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry437                0xf43046d4
#define L3FE_TRAFFIC_TBL_entry437_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry437_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry438                0xf43046d8
#define L3FE_TRAFFIC_TBL_entry438_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry438_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry439                0xf43046dc
#define L3FE_TRAFFIC_TBL_entry439_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry439_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry440                0xf43046e0
#define L3FE_TRAFFIC_TBL_entry440_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry440_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry441                0xf43046e4
#define L3FE_TRAFFIC_TBL_entry441_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry441_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry442                0xf43046e8
#define L3FE_TRAFFIC_TBL_entry442_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry442_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry443                0xf43046ec
#define L3FE_TRAFFIC_TBL_entry443_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry443_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry444                0xf43046f0
#define L3FE_TRAFFIC_TBL_entry444_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry444_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry445                0xf43046f4
#define L3FE_TRAFFIC_TBL_entry445_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry445_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry446                0xf43046f8
#define L3FE_TRAFFIC_TBL_entry446_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry446_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry447                0xf43046fc
#define L3FE_TRAFFIC_TBL_entry447_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry447_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry448                0xf4304700
#define L3FE_TRAFFIC_TBL_entry448_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry448_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry449                0xf4304704
#define L3FE_TRAFFIC_TBL_entry449_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry449_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry450                0xf4304708
#define L3FE_TRAFFIC_TBL_entry450_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry450_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry451                0xf430470c
#define L3FE_TRAFFIC_TBL_entry451_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry451_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry452                0xf4304710
#define L3FE_TRAFFIC_TBL_entry452_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry452_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry453                0xf4304714
#define L3FE_TRAFFIC_TBL_entry453_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry453_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry454                0xf4304718
#define L3FE_TRAFFIC_TBL_entry454_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry454_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry455                0xf430471c
#define L3FE_TRAFFIC_TBL_entry455_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry455_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry456                0xf4304720
#define L3FE_TRAFFIC_TBL_entry456_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry456_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry457                0xf4304724
#define L3FE_TRAFFIC_TBL_entry457_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry457_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry458                0xf4304728
#define L3FE_TRAFFIC_TBL_entry458_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry458_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry459                0xf430472c
#define L3FE_TRAFFIC_TBL_entry459_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry459_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry460                0xf4304730
#define L3FE_TRAFFIC_TBL_entry460_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry460_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry461                0xf4304734
#define L3FE_TRAFFIC_TBL_entry461_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry461_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry462                0xf4304738
#define L3FE_TRAFFIC_TBL_entry462_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry462_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry463                0xf430473c
#define L3FE_TRAFFIC_TBL_entry463_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry463_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry464                0xf4304740
#define L3FE_TRAFFIC_TBL_entry464_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry464_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry465                0xf4304744
#define L3FE_TRAFFIC_TBL_entry465_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry465_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry466                0xf4304748
#define L3FE_TRAFFIC_TBL_entry466_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry466_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry467                0xf430474c
#define L3FE_TRAFFIC_TBL_entry467_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry467_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry468                0xf4304750
#define L3FE_TRAFFIC_TBL_entry468_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry468_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry469                0xf4304754
#define L3FE_TRAFFIC_TBL_entry469_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry469_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry470                0xf4304758
#define L3FE_TRAFFIC_TBL_entry470_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry470_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry471                0xf430475c
#define L3FE_TRAFFIC_TBL_entry471_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry471_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry472                0xf4304760
#define L3FE_TRAFFIC_TBL_entry472_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry472_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry473                0xf4304764
#define L3FE_TRAFFIC_TBL_entry473_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry473_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry474                0xf4304768
#define L3FE_TRAFFIC_TBL_entry474_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry474_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry475                0xf430476c
#define L3FE_TRAFFIC_TBL_entry475_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry475_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry476                0xf4304770
#define L3FE_TRAFFIC_TBL_entry476_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry476_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry477                0xf4304774
#define L3FE_TRAFFIC_TBL_entry477_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry477_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry478                0xf4304778
#define L3FE_TRAFFIC_TBL_entry478_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry478_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry479                0xf430477c
#define L3FE_TRAFFIC_TBL_entry479_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry479_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry480                0xf4304780
#define L3FE_TRAFFIC_TBL_entry480_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry480_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry481                0xf4304784
#define L3FE_TRAFFIC_TBL_entry481_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry481_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry482                0xf4304788
#define L3FE_TRAFFIC_TBL_entry482_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry482_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry483                0xf430478c
#define L3FE_TRAFFIC_TBL_entry483_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry483_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry484                0xf4304790
#define L3FE_TRAFFIC_TBL_entry484_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry484_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry485                0xf4304794
#define L3FE_TRAFFIC_TBL_entry485_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry485_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry486                0xf4304798
#define L3FE_TRAFFIC_TBL_entry486_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry486_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry487                0xf430479c
#define L3FE_TRAFFIC_TBL_entry487_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry487_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry488                0xf43047a0
#define L3FE_TRAFFIC_TBL_entry488_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry488_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry489                0xf43047a4
#define L3FE_TRAFFIC_TBL_entry489_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry489_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry490                0xf43047a8
#define L3FE_TRAFFIC_TBL_entry490_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry490_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry491                0xf43047ac
#define L3FE_TRAFFIC_TBL_entry491_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry491_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry492                0xf43047b0
#define L3FE_TRAFFIC_TBL_entry492_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry492_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry493                0xf43047b4
#define L3FE_TRAFFIC_TBL_entry493_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry493_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry494                0xf43047b8
#define L3FE_TRAFFIC_TBL_entry494_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry494_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry495                0xf43047bc
#define L3FE_TRAFFIC_TBL_entry495_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry495_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry496                0xf43047c0
#define L3FE_TRAFFIC_TBL_entry496_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry496_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry497                0xf43047c4
#define L3FE_TRAFFIC_TBL_entry497_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry497_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry498                0xf43047c8
#define L3FE_TRAFFIC_TBL_entry498_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry498_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry499                0xf43047cc
#define L3FE_TRAFFIC_TBL_entry499_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry499_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry500                0xf43047d0
#define L3FE_TRAFFIC_TBL_entry500_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry500_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry501                0xf43047d4
#define L3FE_TRAFFIC_TBL_entry501_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry501_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry502                0xf43047d8
#define L3FE_TRAFFIC_TBL_entry502_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry502_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry503                0xf43047dc
#define L3FE_TRAFFIC_TBL_entry503_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry503_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry504                0xf43047e0
#define L3FE_TRAFFIC_TBL_entry504_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry504_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry505                0xf43047e4
#define L3FE_TRAFFIC_TBL_entry505_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry505_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry506                0xf43047e8
#define L3FE_TRAFFIC_TBL_entry506_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry506_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry507                0xf43047ec
#define L3FE_TRAFFIC_TBL_entry507_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry507_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry508                0xf43047f0
#define L3FE_TRAFFIC_TBL_entry508_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry508_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry509                0xf43047f4
#define L3FE_TRAFFIC_TBL_entry509_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry509_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry510                0xf43047f8
#define L3FE_TRAFFIC_TBL_entry510_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry510_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry511                0xf43047fc
#define L3FE_TRAFFIC_TBL_entry511_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry511_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry512                0xf4304800
#define L3FE_TRAFFIC_TBL_entry512_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry512_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry513                0xf4304804
#define L3FE_TRAFFIC_TBL_entry513_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry513_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry514                0xf4304808
#define L3FE_TRAFFIC_TBL_entry514_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry514_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry515                0xf430480c
#define L3FE_TRAFFIC_TBL_entry515_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry515_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry516                0xf4304810
#define L3FE_TRAFFIC_TBL_entry516_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry516_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry517                0xf4304814
#define L3FE_TRAFFIC_TBL_entry517_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry517_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry518                0xf4304818
#define L3FE_TRAFFIC_TBL_entry518_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry518_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry519                0xf430481c
#define L3FE_TRAFFIC_TBL_entry519_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry519_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry520                0xf4304820
#define L3FE_TRAFFIC_TBL_entry520_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry520_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry521                0xf4304824
#define L3FE_TRAFFIC_TBL_entry521_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry521_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry522                0xf4304828
#define L3FE_TRAFFIC_TBL_entry522_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry522_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry523                0xf430482c
#define L3FE_TRAFFIC_TBL_entry523_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry523_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry524                0xf4304830
#define L3FE_TRAFFIC_TBL_entry524_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry524_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry525                0xf4304834
#define L3FE_TRAFFIC_TBL_entry525_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry525_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry526                0xf4304838
#define L3FE_TRAFFIC_TBL_entry526_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry526_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry527                0xf430483c
#define L3FE_TRAFFIC_TBL_entry527_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry527_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry528                0xf4304840
#define L3FE_TRAFFIC_TBL_entry528_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry528_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry529                0xf4304844
#define L3FE_TRAFFIC_TBL_entry529_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry529_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry530                0xf4304848
#define L3FE_TRAFFIC_TBL_entry530_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry530_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry531                0xf430484c
#define L3FE_TRAFFIC_TBL_entry531_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry531_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry532                0xf4304850
#define L3FE_TRAFFIC_TBL_entry532_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry532_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry533                0xf4304854
#define L3FE_TRAFFIC_TBL_entry533_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry533_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry534                0xf4304858
#define L3FE_TRAFFIC_TBL_entry534_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry534_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry535                0xf430485c
#define L3FE_TRAFFIC_TBL_entry535_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry535_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry536                0xf4304860
#define L3FE_TRAFFIC_TBL_entry536_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry536_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry537                0xf4304864
#define L3FE_TRAFFIC_TBL_entry537_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry537_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry538                0xf4304868
#define L3FE_TRAFFIC_TBL_entry538_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry538_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry539                0xf430486c
#define L3FE_TRAFFIC_TBL_entry539_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry539_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry540                0xf4304870
#define L3FE_TRAFFIC_TBL_entry540_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry540_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry541                0xf4304874
#define L3FE_TRAFFIC_TBL_entry541_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry541_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry542                0xf4304878
#define L3FE_TRAFFIC_TBL_entry542_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry542_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry543                0xf430487c
#define L3FE_TRAFFIC_TBL_entry543_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry543_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry544                0xf4304880
#define L3FE_TRAFFIC_TBL_entry544_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry544_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry545                0xf4304884
#define L3FE_TRAFFIC_TBL_entry545_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry545_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry546                0xf4304888
#define L3FE_TRAFFIC_TBL_entry546_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry546_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry547                0xf430488c
#define L3FE_TRAFFIC_TBL_entry547_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry547_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry548                0xf4304890
#define L3FE_TRAFFIC_TBL_entry548_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry548_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry549                0xf4304894
#define L3FE_TRAFFIC_TBL_entry549_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry549_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry550                0xf4304898
#define L3FE_TRAFFIC_TBL_entry550_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry550_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry551                0xf430489c
#define L3FE_TRAFFIC_TBL_entry551_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry551_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry552                0xf43048a0
#define L3FE_TRAFFIC_TBL_entry552_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry552_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry553                0xf43048a4
#define L3FE_TRAFFIC_TBL_entry553_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry553_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry554                0xf43048a8
#define L3FE_TRAFFIC_TBL_entry554_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry554_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry555                0xf43048ac
#define L3FE_TRAFFIC_TBL_entry555_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry555_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry556                0xf43048b0
#define L3FE_TRAFFIC_TBL_entry556_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry556_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry557                0xf43048b4
#define L3FE_TRAFFIC_TBL_entry557_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry557_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry558                0xf43048b8
#define L3FE_TRAFFIC_TBL_entry558_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry558_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry559                0xf43048bc
#define L3FE_TRAFFIC_TBL_entry559_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry559_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry560                0xf43048c0
#define L3FE_TRAFFIC_TBL_entry560_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry560_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry561                0xf43048c4
#define L3FE_TRAFFIC_TBL_entry561_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry561_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry562                0xf43048c8
#define L3FE_TRAFFIC_TBL_entry562_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry562_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry563                0xf43048cc
#define L3FE_TRAFFIC_TBL_entry563_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry563_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry564                0xf43048d0
#define L3FE_TRAFFIC_TBL_entry564_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry564_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry565                0xf43048d4
#define L3FE_TRAFFIC_TBL_entry565_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry565_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry566                0xf43048d8
#define L3FE_TRAFFIC_TBL_entry566_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry566_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry567                0xf43048dc
#define L3FE_TRAFFIC_TBL_entry567_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry567_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry568                0xf43048e0
#define L3FE_TRAFFIC_TBL_entry568_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry568_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry569                0xf43048e4
#define L3FE_TRAFFIC_TBL_entry569_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry569_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry570                0xf43048e8
#define L3FE_TRAFFIC_TBL_entry570_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry570_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry571                0xf43048ec
#define L3FE_TRAFFIC_TBL_entry571_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry571_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry572                0xf43048f0
#define L3FE_TRAFFIC_TBL_entry572_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry572_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry573                0xf43048f4
#define L3FE_TRAFFIC_TBL_entry573_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry573_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry574                0xf43048f8
#define L3FE_TRAFFIC_TBL_entry574_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry574_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry575                0xf43048fc
#define L3FE_TRAFFIC_TBL_entry575_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry575_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry576                0xf4304900
#define L3FE_TRAFFIC_TBL_entry576_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry576_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry577                0xf4304904
#define L3FE_TRAFFIC_TBL_entry577_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry577_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry578                0xf4304908
#define L3FE_TRAFFIC_TBL_entry578_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry578_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry579                0xf430490c
#define L3FE_TRAFFIC_TBL_entry579_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry579_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry580                0xf4304910
#define L3FE_TRAFFIC_TBL_entry580_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry580_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry581                0xf4304914
#define L3FE_TRAFFIC_TBL_entry581_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry581_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry582                0xf4304918
#define L3FE_TRAFFIC_TBL_entry582_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry582_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry583                0xf430491c
#define L3FE_TRAFFIC_TBL_entry583_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry583_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry584                0xf4304920
#define L3FE_TRAFFIC_TBL_entry584_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry584_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry585                0xf4304924
#define L3FE_TRAFFIC_TBL_entry585_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry585_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry586                0xf4304928
#define L3FE_TRAFFIC_TBL_entry586_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry586_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry587                0xf430492c
#define L3FE_TRAFFIC_TBL_entry587_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry587_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry588                0xf4304930
#define L3FE_TRAFFIC_TBL_entry588_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry588_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry589                0xf4304934
#define L3FE_TRAFFIC_TBL_entry589_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry589_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry590                0xf4304938
#define L3FE_TRAFFIC_TBL_entry590_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry590_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry591                0xf430493c
#define L3FE_TRAFFIC_TBL_entry591_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry591_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry592                0xf4304940
#define L3FE_TRAFFIC_TBL_entry592_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry592_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry593                0xf4304944
#define L3FE_TRAFFIC_TBL_entry593_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry593_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry594                0xf4304948
#define L3FE_TRAFFIC_TBL_entry594_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry594_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry595                0xf430494c
#define L3FE_TRAFFIC_TBL_entry595_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry595_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry596                0xf4304950
#define L3FE_TRAFFIC_TBL_entry596_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry596_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry597                0xf4304954
#define L3FE_TRAFFIC_TBL_entry597_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry597_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry598                0xf4304958
#define L3FE_TRAFFIC_TBL_entry598_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry598_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry599                0xf430495c
#define L3FE_TRAFFIC_TBL_entry599_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry599_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry600                0xf4304960
#define L3FE_TRAFFIC_TBL_entry600_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry600_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry601                0xf4304964
#define L3FE_TRAFFIC_TBL_entry601_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry601_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry602                0xf4304968
#define L3FE_TRAFFIC_TBL_entry602_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry602_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry603                0xf430496c
#define L3FE_TRAFFIC_TBL_entry603_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry603_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry604                0xf4304970
#define L3FE_TRAFFIC_TBL_entry604_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry604_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry605                0xf4304974
#define L3FE_TRAFFIC_TBL_entry605_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry605_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry606                0xf4304978
#define L3FE_TRAFFIC_TBL_entry606_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry606_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry607                0xf430497c
#define L3FE_TRAFFIC_TBL_entry607_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry607_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry608                0xf4304980
#define L3FE_TRAFFIC_TBL_entry608_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry608_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry609                0xf4304984
#define L3FE_TRAFFIC_TBL_entry609_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry609_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry610                0xf4304988
#define L3FE_TRAFFIC_TBL_entry610_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry610_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry611                0xf430498c
#define L3FE_TRAFFIC_TBL_entry611_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry611_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry612                0xf4304990
#define L3FE_TRAFFIC_TBL_entry612_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry612_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry613                0xf4304994
#define L3FE_TRAFFIC_TBL_entry613_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry613_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry614                0xf4304998
#define L3FE_TRAFFIC_TBL_entry614_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry614_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry615                0xf430499c
#define L3FE_TRAFFIC_TBL_entry615_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry615_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry616                0xf43049a0
#define L3FE_TRAFFIC_TBL_entry616_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry616_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry617                0xf43049a4
#define L3FE_TRAFFIC_TBL_entry617_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry617_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry618                0xf43049a8
#define L3FE_TRAFFIC_TBL_entry618_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry618_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry619                0xf43049ac
#define L3FE_TRAFFIC_TBL_entry619_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_TRAFFIC_TBL_entry619_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_TRAFFIC_TBL_entry620                0xf43049b0
#define L3