/*
 * REGISTERS.h
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED BY ./rdb2tt.pl
 * -config rdb2h.yml -db reg.db
 *
 */
#ifndef _CA8277_REGISTERS_H_
#define _CA8277_REGISTERS_H_

#include "ca_types.h"

/* work around DEBUG being defined in the build overriding
 * registers named DEBUG in structures below
 *
 */
#ifdef DEBUG
#define CA_DEBUG_WORKAROUND DEBUG
#undef DEBUG
#endif /* DEBUG */

/******************************************************************
 *
 * Each register in the map is defined as a struct with bitfields.
 *
 ******************************************************************/

/*
 * APB1
 */

/*
 * PE0_ATU
 */

#define PE0_ATU_CTL                              0x90300000
#define PE0_ATU_CTL_dft                          0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA0                            0x90300004
#define PE0_ATU_DATA0_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA1                            0x90300008
#define PE0_ATU_DATA1_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA2                            0x9030000c
#define PE0_ATU_DATA2_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA3                            0x90300010
#define PE0_ATU_DATA3_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA4                            0x90300014
#define PE0_ATU_DATA4_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_DATA5                            0x90300018
#define PE0_ATU_DATA5_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define PE0_ATU_UPPER                            0x9030001c
#define PE0_ATU_UPPER_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE0_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE0_ATU */
#ifndef __ASSEMBLER__
typedef struct {
  PE0_ATU_CTL_t                            CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  PE0_ATU_DATA0_t                          DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  PE0_ATU_DATA1_t                          DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  PE0_ATU_DATA2_t                          DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  PE0_ATU_DATA3_t                          DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  PE0_ATU_DATA4_t                          DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  PE0_ATU_DATA5_t                          DATA5;                         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  PE0_ATU_UPPER_t                          UPPER;                         /* addr: 0x0000001c */
} APB1_PE0_ATU_t;
#endif /* !__ASSEMBLER__ */


/*
 * PE1_ATU
 */

#define PE1_ATU_CTL                              0x90300100
#define PE1_ATU_CTL_dft                          0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA0                            0x90300104
#define PE1_ATU_DATA0_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA1                            0x90300108
#define PE1_ATU_DATA1_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA2                            0x9030010c
#define PE1_ATU_DATA2_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA3                            0x90300110
#define PE1_ATU_DATA3_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA4                            0x90300114
#define PE1_ATU_DATA4_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_DATA5                            0x90300118
#define PE1_ATU_DATA5_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define PE1_ATU_UPPER                            0x9030011c
#define PE1_ATU_UPPER_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE1_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE1_ATU */
#ifndef __ASSEMBLER__
typedef struct {
  PE1_ATU_CTL_t                            CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  PE1_ATU_DATA0_t                          DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  PE1_ATU_DATA1_t                          DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  PE1_ATU_DATA2_t                          DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  PE1_ATU_DATA3_t                          DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  PE1_ATU_DATA4_t                          DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  PE1_ATU_DATA5_t                          DATA5;                         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  PE1_ATU_UPPER_t                          UPPER;                         /* addr: 0x0000001c */
} APB1_PE1_ATU_t;
#endif /* !__ASSEMBLER__ */


/*
 * CRYPTO0_ATU
 */

#define CRYPTO0_ATU_CTL                          0x90300200
#define CRYPTO0_ATU_CTL_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA0                        0x90300204
#define CRYPTO0_ATU_DATA0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA1                        0x90300208
#define CRYPTO0_ATU_DATA1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA2                        0x9030020c
#define CRYPTO0_ATU_DATA2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA3                        0x90300210
#define CRYPTO0_ATU_DATA3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA4                        0x90300214
#define CRYPTO0_ATU_DATA4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_DATA5                        0x90300218
#define CRYPTO0_ATU_DATA5_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO0_ATU_UPPER                        0x9030021c
#define CRYPTO0_ATU_UPPER_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO0_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CRYPTO0_ATU */
#ifndef __ASSEMBLER__
typedef struct {
  CRYPTO0_ATU_CTL_t                        CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  CRYPTO0_ATU_DATA0_t                      DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  CRYPTO0_ATU_DATA1_t                      DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  CRYPTO0_ATU_DATA2_t                      DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  CRYPTO0_ATU_DATA3_t                      DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  CRYPTO0_ATU_DATA4_t                      DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  CRYPTO0_ATU_DATA5_t                      DATA5;                         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  CRYPTO0_ATU_UPPER_t                      UPPER;                         /* addr: 0x0000001c */
} APB1_CRYPTO0_ATU_t;
#endif /* !__ASSEMBLER__ */


/*
 * CRYPTO1_ATU
 */

#define CRYPTO1_ATU_CTL                          0x90300400
#define CRYPTO1_ATU_CTL_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA0                        0x90300404
#define CRYPTO1_ATU_DATA0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA1                        0x90300408
#define CRYPTO1_ATU_DATA1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA2                        0x9030040c
#define CRYPTO1_ATU_DATA2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA3                        0x90300410
#define CRYPTO1_ATU_DATA3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA4                        0x90300414
#define CRYPTO1_ATU_DATA4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_DATA5                        0x90300418
#define CRYPTO1_ATU_DATA5_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define CRYPTO1_ATU_UPPER                        0x9030041c
#define CRYPTO1_ATU_UPPER_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upper_bits           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} CRYPTO1_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CRYPTO1_ATU */
#ifndef __ASSEMBLER__
typedef struct {
  CRYPTO1_ATU_CTL_t                        CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  CRYPTO1_ATU_DATA0_t                      DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  CRYPTO1_ATU_DATA1_t                      DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  CRYPTO1_ATU_DATA2_t                      DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  CRYPTO1_ATU_DATA3_t                      DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  CRYPTO1_ATU_DATA4_t                      DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  CRYPTO1_ATU_DATA5_t                      DATA5;                         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  CRYPTO1_ATU_UPPER_t                      UPPER;                         /* addr: 0x0000001c */
} APB1_CRYPTO1_ATU_t;
#endif /* !__ASSEMBLER__ */


/*
 * LDMA
 */

/*
 * LDMA_GLB
 */

#define LDMA_LDMA_GLB_LDMA_CONTROL               0x90301000
#define LDMA_LDMA_GLB_LDMA_CONTROL_dft           0x00000080

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t aruser_idx           :  3 ; /* bits 6:4 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 7:7 */
    ca_uint32_t buf_depth_sel        :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t lpae_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_CONTROL_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER          0x90301004
#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_dft      0x00800400

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t period               : 16 ; /* bits 15:0 */
    ca_uint32_t credit               : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_RATE_LIMITER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB       0x90301008
#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_dft   0x00000fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t upperbound           : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_LDMA_BKT0_DWRR             0x9030100c
#define LDMA_LDMA_GLB_LDMA_BKT0_DWRR_dft         0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_BKT0_DWRR_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_LDMA_BKT1_DWRR             0x90301010
#define LDMA_LDMA_GLB_LDMA_BKT1_DWRR_dft         0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_LDMA_BKT1_DWRR_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0       0x90301014
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0         0x90301018
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1       0x9030101c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1         0x90301020
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2       0x90301024
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2         0x90301028
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3       0x9030102c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3         0x90301030
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4       0x90301034
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4         0x90301038
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5       0x9030103c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5         0x90301040
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6       0x90301044
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6         0x90301048
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7       0x9030104c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7         0x90301050
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_0                 0x90301054
#define LDMA_LDMA_GLB_AXPATTEN_0_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_1                 0x90301058
#define LDMA_LDMA_GLB_AXPATTEN_1_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_2                 0x9030105c
#define LDMA_LDMA_GLB_AXPATTEN_2_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_3                 0x90301060
#define LDMA_LDMA_GLB_AXPATTEN_3_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_3_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_4                 0x90301064
#define LDMA_LDMA_GLB_AXPATTEN_4_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_4_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_5                 0x90301068
#define LDMA_LDMA_GLB_AXPATTEN_5_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_5_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_6                 0x9030106c
#define LDMA_LDMA_GLB_AXPATTEN_6_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_6_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_AXPATTEN_7                 0x90301070
#define LDMA_LDMA_GLB_AXPATTEN_7_dft             0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_AXPATTEN_7_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER      0x90301074
#define LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_dft  0x0000ff00

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t q0_sel               :  1 ; /* bits 0:0 */
    ca_uint32_t q1_sel               :  1 ; /* bits 1:1 */
    ca_uint32_t q2_sel               :  1 ; /* bits 2:2 */
    ca_uint32_t q3_sel               :  1 ; /* bits 3:3 */
    ca_uint32_t q4_sel               :  1 ; /* bits 4:4 */
    ca_uint32_t q5_sel               :  1 ; /* bits 5:5 */
    ca_uint32_t q6_sel               :  1 ; /* bits 6:6 */
    ca_uint32_t q7_sel               :  1 ; /* bits 7:7 */
    ca_uint32_t q8_sel               :  1 ; /* bits 8:8 */
    ca_uint32_t q9_sel               :  1 ; /* bits 9:9 */
    ca_uint32_t q10_sel              :  1 ; /* bits 10:10 */
    ca_uint32_t q11_sel              :  1 ; /* bits 11:11 */
    ca_uint32_t q12_sel              :  1 ; /* bits 12:12 */
    ca_uint32_t q13_sel              :  1 ; /* bits 13:13 */
    ca_uint32_t q14_sel              :  1 ; /* bits 14:14 */
    ca_uint32_t q15_sel              :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER     0x90301078
#define LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t PE0_QA               :  4 ; /* bits 3:0 */
    ca_uint32_t PE0_QA_en            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t PE0_QB               :  4 ; /* bits 11:8 */
    ca_uint32_t PE0_QB_en            :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t PE1_QA               :  4 ; /* bits 19:16 */
    ca_uint32_t PE1_QA_en            :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t PE1_QB               :  4 ; /* bits 27:24 */
    ca_uint32_t PE1_QB_en            :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER 0x9030107c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER 0x90301080
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER 0x90301084
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER 0x90301088
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER 0x9030108c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER 0x90301090
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER 0x90301094
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER 0x90301098
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER 0x9030109c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER 0x903010a0
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER 0x903010a4
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER 0x903010a8
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER 0x903010ac
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER 0x903010b0
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER 0x903010b4
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER 0x903010b8
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER 0x903010bc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER 0x903010c0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER 0x903010c4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER 0x903010c8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER 0x903010cc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER 0x903010d0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER 0x903010d4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER 0x903010d8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER 0x903010dc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER 0x903010e0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER 0x903010e4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER 0x903010e8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER 0x903010ec
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER 0x903010f0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER 0x903010f4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER 0x903010f8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER 0x903010fc
#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER 0x90301100
#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_GLB_SRAM_TEST_CONTROL          0x90301104
#define LDMA_LDMA_GLB_SRAM_TEST_CONTROL_dft      0x00000202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sram0_rm             :  2 ; /* bits 1:0 */
    ca_uint32_t sram0_rme            :  1 ; /* bits 2:2 */
    ca_uint32_t sram0_test1          :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t sram1_rm             :  2 ; /* bits 9:8 */
    ca_uint32_t sram1_rme            :  1 ; /* bits 10:10 */
    ca_uint32_t sram1_test1          :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_GLB_SRAM_TEST_CONTROL_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_GLB */
#ifndef __ASSEMBLER__
typedef struct {
  LDMA_LDMA_GLB_LDMA_CONTROL_t             LDMA_CONTROL;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  LDMA_LDMA_GLB_LDMA_RATE_LIMITER_t        LDMA_RATE_LIMITER;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_t     LDMA_RATE_LIMITER_UB;          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  LDMA_LDMA_GLB_LDMA_BKT0_DWRR_t           LDMA_BKT0_DWRR;                /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  LDMA_LDMA_GLB_LDMA_BKT1_DWRR_t           LDMA_BKT1_DWRR;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_t     MEM_START_ADDR_SEG_0;          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_t       MEM_END_ADDR_SEG_0;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_t     MEM_START_ADDR_SEG_1;          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_t       MEM_END_ADDR_SEG_1;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_t     MEM_START_ADDR_SEG_2;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_t       MEM_END_ADDR_SEG_2;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_t     MEM_START_ADDR_SEG_3;          /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_t       MEM_END_ADDR_SEG_3;            /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_t     MEM_START_ADDR_SEG_4;          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_t       MEM_END_ADDR_SEG_4;            /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_t     MEM_START_ADDR_SEG_5;          /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_t       MEM_END_ADDR_SEG_5;            /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_t     MEM_START_ADDR_SEG_6;          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_t       MEM_END_ADDR_SEG_6;            /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_t     MEM_START_ADDR_SEG_7;          /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_t       MEM_END_ADDR_SEG_7;            /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  LDMA_LDMA_GLB_AXPATTEN_0_t               AXPATTEN_0;                    /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  LDMA_LDMA_GLB_AXPATTEN_1_t               AXPATTEN_1;                    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  LDMA_LDMA_GLB_AXPATTEN_2_t               AXPATTEN_2;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  LDMA_LDMA_GLB_AXPATTEN_3_t               AXPATTEN_3;                    /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  LDMA_LDMA_GLB_AXPATTEN_4_t               AXPATTEN_4;                    /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  LDMA_LDMA_GLB_AXPATTEN_5_t               AXPATTEN_5;                    /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  LDMA_LDMA_GLB_AXPATTEN_6_t               AXPATTEN_6;                    /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  LDMA_LDMA_GLB_AXPATTEN_7_t               AXPATTEN_7;                    /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_t    QUEUE_ASSIGN_REGISTER;         /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_t   FAST_Q_ASSIGN_REGISTER;        /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];
  LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];
  LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];
  LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_t DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];
  LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_t DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];
  LDMA_LDMA_GLB_SRAM_TEST_CONTROL_t        SRAM_TEST_CONTROL;             /* addr: 0x00000104 */
} APB1_LDMA_LDMA_GLB_t;
#endif /* !__ASSEMBLER__ */


/*
 * AXIM2
 */

#define LDMA_AXIM2_CONFIG                        0x903011a0
#define LDMA_AXIM2_CONFIG_dft                    0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_write_outtrans_num :  4 ; /* bits 3:0 */
    ca_uint32_t axi_read_outtrans_num :  4 ; /* bits 7:4 */
    ca_uint32_t axi_xbus_len         :  3 ; /* bits 10:8 */
    ca_uint32_t write_cacheline_trans_en :  1 ; /* bits 11:11 */
    ca_uint32_t write_cacheline_trans_size :  1 ; /* bits 12:12 */
    ca_uint32_t read_cacheline_trans_en :  1 ; /* bits 13:13 */
    ca_uint32_t read_cacheline_trans_size :  1 ; /* bits 14:14 */
    ca_uint32_t arcache_eos_en       :  1 ; /* bits 15:15 */
    ca_uint32_t awcache_eos_en       :  1 ; /* bits 16:16 */
    ca_uint32_t reserved             : 15 ; /* bits 31:17 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_AXIM2_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_AXIM2_TIMEOUT_THRESHOLD             0x903011a4
#define LDMA_AXIM2_TIMEOUT_THRESHOLD_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_channel_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t write_channel_threshold :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_AXIM2_TIMEOUT_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_AXIM2_INTERRUPT_STATUS              0x903011a8
#define LDMA_AXIM2_INTERRUPT_STATUS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_AXIM2_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_AXIM2_INTERRUPT_ENABLE              0x903011ac
#define LDMA_AXIM2_INTERRUPT_ENABLE_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int_en :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int_en :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int_en :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int_en :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_AXIM2_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* AXIM2 */
#ifndef __ASSEMBLER__
typedef struct {
  LDMA_AXIM2_CONFIG_t                      CONFIG;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  LDMA_AXIM2_TIMEOUT_THRESHOLD_t           TIMEOUT_THRESHOLD;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  LDMA_AXIM2_INTERRUPT_STATUS_t            INTERRUPT_STATUS;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  LDMA_AXIM2_INTERRUPT_ENABLE_t            INTERRUPT_ENABLE;              /* addr: 0x0000000c */
} APB1_LDMA_AXIM2_t;
#endif /* !__ASSEMBLER__ */


/*
 * LDMA_QUEUE[0..15]
 */

#define LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS        0x90301200
#define LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t desc_idx             :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t debug_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 21 ;
    ca_uint32_t wrd_n                :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2         0x90301204
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t length               : 12 ; /* bits 11:0 */
    ca_uint32_t rd_cmd_only          :  1 ; /* bits 12:12 */
    ca_uint32_t rd_trn_only          :  1 ; /* bits 13:13 */
    ca_uint32_t wr_zero_trn          :  1 ; /* bits 14:14 */
    ca_uint32_t ioc                  :  1 ; /* bits 15:15 */
    ca_uint32_t dst_addr_lpae        :  8 ; /* bits 23:16 */
    ca_uint32_t src_addr_lpae        :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1         0x90301208
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dst_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0         0x9030120c
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t src_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_CONTROL_REGISTER         0x90301210
#define LDMA_LDMA_QUEUE_CONTROL_REGISTER_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clsc_timer           : 16 ; /* bits 15:0 */
    ca_uint32_t clsc_threshold       :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t wch_axi_error        :  1 ; /* bits 24:24 */
    ca_uint32_t rch_axi_error        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t reset                :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t en                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_CONTROL_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_DWRR_REGISTER            0x90301214
#define LDMA_LDMA_QUEUE_DWRR_REGISTER_dft        0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_DWRR_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_INTERRUPT_ENABLE         0x90301218
#define LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dd_en                :  1 ; /* bits 0:0 */
    ca_uint32_t fov_en               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_INTERRUPT_STATUS         0x9030121c
#define LDMA_LDMA_QUEUE_INTERRUPT_STATUS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t descriptor_done      :  1 ; /* bits 0:0 */
    ca_uint32_t fifo_overflow        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_QUEUE_POINTER_REGISTER         0x90301220
#define LDMA_LDMA_QUEUE_POINTER_REGISTER_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  4 ; /* bits 3:0 */
    ca_uint32_t rd_trans_rdptr       :  4 ; /* bits 7:4 */
    ca_uint32_t rd_trans_wrptr       :  4 ; /* bits 11:8 */
    ca_uint32_t wr_trans_rdptr       :  4 ; /* bits 15:12 */
    ca_uint32_t rd_ptr               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t desc_depth           :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_QUEUE_POINTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define APB1_LDMA_LDMA_QUEUE_STRIDE              64
#define APB1_LDMA_LDMA_QUEUE_COUNT               16



/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_QUEUE */
#ifndef __ASSEMBLER__
typedef struct {
  LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_t      DESCRIPTOR_ACCESS;             /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_t       DESCRIPTOR_DATA2;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_t       DESCRIPTOR_DATA1;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_t       DESCRIPTOR_DATA0;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  LDMA_LDMA_QUEUE_CONTROL_REGISTER_t       CONTROL_REGISTER;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  LDMA_LDMA_QUEUE_DWRR_REGISTER_t          DWRR_REGISTER;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_t       INTERRUPT_ENABLE;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  LDMA_LDMA_QUEUE_INTERRUPT_STATUS_t       INTERRUPT_STATUS;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  LDMA_LDMA_QUEUE_POINTER_REGISTER_t       POINTER_REGISTER;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[31];
} APB1_LDMA_LDMA_QUEUE_t;
#endif /* !__ASSEMBLER__ */


/*
 * LDMA_INTERRUPT_MUX
 */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE      0x90301600
#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS      0x90301604
#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE      0x90301608
#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS      0x9030160c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE      0x90301610
#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS      0x90301614
#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE      0x90301618
#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS      0x9030161c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE      0x90301620
#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS      0x90301624
#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE      0x90301628
#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS      0x9030162c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE      0x90301630
#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS      0x90301634
#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE      0x90301638
#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS      0x9030163c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_INTERRUPT_MUX */
#ifndef __ASSEMBLER__
typedef struct {
  LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t    IRQ0_ENABLE;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t    IRQ0_STATUS;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t    IRQ1_ENABLE;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t    IRQ1_STATUS;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t    IRQ2_ENABLE;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t    IRQ2_STATUS;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t    IRQ3_ENABLE;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t    IRQ3_STATUS;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t    IRQ4_ENABLE;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t    IRQ4_STATUS;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t    IRQ5_ENABLE;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t    IRQ5_STATUS;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t    IRQ6_ENABLE;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t    IRQ6_STATUS;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t    IRQ7_ENABLE;                   /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t    IRQ7_STATUS;                   /* addr: 0x0000003c */
} APB1_LDMA_LDMA_INTERRUPT_MUX_t;
#endif /* !__ASSEMBLER__ */




/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA */

#ifndef __ASSEMBLER__
typedef struct {
  APB1_LDMA_LDMA_GLB_t                     LDMA_GLB;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[285];
  APB1_LDMA_AXIM2_t                        AXIM2;                         /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd2[89];
  APB1_LDMA_LDMA_QUEUE_t                   LDMA_QUEUE[16];                /* addr: 0x00000200 */
  APB1_LDMA_LDMA_INTERRUPT_MUX_t           LDMA_INTERRUPT_MUX;            /* addr: 0x00000600 */
} APB1_LDMA_t;
#endif /* !__ASSEMBLER__ */


/*
 * LDMA_RCPU
 */

/*
 * LDMA_QUEUE[0..15]
 */

#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS   0x90302200
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t desc_idx             :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t debug_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 21 ;
    ca_uint32_t wrd_n                :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2    0x90302204
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t length               : 12 ; /* bits 11:0 */
    ca_uint32_t rd_cmd_only          :  1 ; /* bits 12:12 */
    ca_uint32_t rd_trn_only          :  1 ; /* bits 13:13 */
    ca_uint32_t wr_zero_trn          :  1 ; /* bits 14:14 */
    ca_uint32_t ioc                  :  1 ; /* bits 15:15 */
    ca_uint32_t dst_addr_lpae        :  8 ; /* bits 23:16 */
    ca_uint32_t src_addr_lpae        :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1    0x90302208
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dst_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0    0x9030220c
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t src_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER    0x90302210
#define LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clsc_timer           : 16 ; /* bits 15:0 */
    ca_uint32_t clsc_threshold       :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t wch_axi_error        :  1 ; /* bits 24:24 */
    ca_uint32_t rch_axi_error        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t reset                :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t en                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER       0x90302214
#define LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_dft   0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE    0x90302218
#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dd_en                :  1 ; /* bits 0:0 */
    ca_uint32_t fov_en               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS    0x9030221c
#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t descriptor_done      :  1 ; /* bits 0:0 */
    ca_uint32_t fifo_overflow        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER    0x90302220
#define LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  4 ; /* bits 3:0 */
    ca_uint32_t rd_trans_rdptr       :  4 ; /* bits 7:4 */
    ca_uint32_t rd_trans_wrptr       :  4 ; /* bits 11:8 */
    ca_uint32_t wr_trans_rdptr       :  4 ; /* bits 15:12 */
    ca_uint32_t rd_ptr               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t desc_depth           :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */


#define APB1_LDMA_RCPU_LDMA_QUEUE_STRIDE         64
#define APB1_LDMA_RCPU_LDMA_QUEUE_COUNT          16



/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_QUEUE */
#ifndef __ASSEMBLER__
typedef struct {
  LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_t DESCRIPTOR_ACCESS;             /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_t  DESCRIPTOR_DATA2;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_t  DESCRIPTOR_DATA1;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_t  DESCRIPTOR_DATA0;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_t  CONTROL_REGISTER;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_t     DWRR_REGISTER;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_t  INTERRUPT_ENABLE;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_t  INTERRUPT_STATUS;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_t  POINTER_REGISTER;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[31];
} APB1_LDMA_RCPU_LDMA_QUEUE_t;
#endif /* !__ASSEMBLER__ */


/*
 * LDMA_INTERRUPT_MUX
 */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE 0x90302600
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS 0x90302604
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE 0x90302608
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS 0x9030260c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE 0x90302610
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS 0x90302614
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE 0x90302618
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS 0x9030261c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE 0x90302620
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS 0x90302624
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE 0x90302628
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS 0x9030262c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE 0x90302630
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS 0x90302634
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE 0x90302638
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t;
#endif /* !__ASSEMBLER__ */


#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS 0x9030263c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_INTERRUPT_MUX */
#ifndef __ASSEMBLER__
typedef struct {
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t IRQ0_ENABLE;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t IRQ0_STATUS;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t IRQ1_ENABLE;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t IRQ1_STATUS;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t IRQ2_ENABLE;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t IRQ2_STATUS;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t IRQ3_ENABLE;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t IRQ3_STATUS;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t IRQ4_ENABLE;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t IRQ4_STATUS;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t IRQ5_ENABLE;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t IRQ5_STATUS;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t IRQ6_ENABLE;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t IRQ6_STATUS;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t IRQ7_ENABLE;                   /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t IRQ7_STATUS;                   /* addr: 0x0000003c */
} APB1_LDMA_RCPU_LDMA_INTERRUPT_MUX_t;
#endif /* !__ASSEMBLER__ */




/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_RCPU */

#ifndef __ASSEMBLER__
typedef struct {
  ca_uint32_t                              rsrvd1[512];
  APB1_LDMA_RCPU_LDMA_QUEUE_t              LDMA_QUEUE[16];                /* addr: 0x00000200 */
  APB1_LDMA_RCPU_LDMA_INTERRUPT_MUX_t      LDMA_INTERRUPT_MUX;            /* addr: 0x00000600 */
} APB1_LDMA_RCPU_t;
#endif /* !__ASSEMBLER__ */


/*
 * PE_CTRL
 */

#define PE_CTRL_PES_ADDR_MASTER_CONFIG           0x90303000
#define PE_CTRL_PES_ADDR_MASTER_CONFIG_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pe0s_shift_en        :  1 ; /* bits 0:0 */
    ca_uint32_t pe1s_shift_en        :  1 ; /* bits 1:1 */
    ca_uint32_t pe0s_slave_prot      :  1 ; /* bits 2:2 */
    ca_uint32_t pe1s_slave_prot      :  1 ; /* bits 3:3 */
    ca_uint32_t pe0_isolation_en     :  1 ; /* bits 4:4 */
    ca_uint32_t pe1_isolation_en     :  1 ; /* bits 5:5 */
    ca_uint32_t pe0_powercut_ctrl    :  1 ; /* bits 6:6 */
    ca_uint32_t pe1_powercut_ctrl    :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PES_ADDR_MASTER_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE0S_ADDR_CONFIG                 0x90303004
#define PE_CTRL_PE0S_ADDR_CONFIG_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pe0s_addr_val        : 16 ; /* bits 15:0 */
    ca_uint32_t pe0s_addr_mask       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE0S_ADDR_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE1S_ADDR_CONFIG                 0x90303008
#define PE_CTRL_PE1S_ADDR_CONFIG_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pe1s_addr_val        : 16 ; /* bits 15:0 */
    ca_uint32_t pe1s_addr_mask       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE1S_ADDR_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL_PE0                     0x9030300c
#define PE_CTRL_AXI_CTRL_PE0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arqos_pe             :  4 ; /* bits 3:0 */
    ca_uint32_t awqos_pe             :  4 ; /* bits 7:4 */
    ca_uint32_t ruser_pe             :  4 ; /* bits 11:8 */
    ca_uint32_t buser_pe             :  4 ; /* bits 15:12 */
    ca_uint32_t aruser_pes           :  4 ; /* bits 19:16 */
    ca_uint32_t awuser_pes           :  4 ; /* bits 23:20 */
    ca_uint32_t wuser_pes            :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL_PE0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL1_PE0                    0x90303010
#define PE_CTRL_AXI_CTRL1_PE0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_pe            : 14 ; /* bits 13:0 */
    ca_uint32_t awuser_pe            : 14 ; /* bits 27:14 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL1_PE0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL_PE1                     0x90303014
#define PE_CTRL_AXI_CTRL_PE1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t arqos_pe             :  4 ; /* bits 3:0 */
    ca_uint32_t awqos_pe             :  4 ; /* bits 7:4 */
    ca_uint32_t ruser_pe             :  4 ; /* bits 11:8 */
    ca_uint32_t buser_pe             :  4 ; /* bits 15:12 */
    ca_uint32_t aruser_pes           :  4 ; /* bits 19:16 */
    ca_uint32_t awuser_pes           :  4 ; /* bits 23:20 */
    ca_uint32_t wuser_pes            :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL_PE1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_AXI_CTRL1_PE1                    0x90303018
#define PE_CTRL_AXI_CTRL1_PE1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aruser_pe            : 14 ; /* bits 13:0 */
    ca_uint32_t awuser_pe            : 14 ; /* bits 27:14 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_AXI_CTRL1_PE1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTERRUPT_0            0x9030301c
#define PE_CTRL_PE_QM_AGG_INTERRUPT_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8i    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9i    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10i   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11i   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12i   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13i   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIi :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOi :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTERRUPT_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTENABLE_0            0x90303020
#define PE_CTRL_PE_QM_AGG_INTENABLE_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8e    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9e    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10e   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11e   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12e   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13e   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIe :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOe :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTENABLE_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTERRUPT_0               0x90303024
#define PE_CTRL_PE_AGG_INTERRUPT_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1i     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1i     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1i     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1i     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t XFI0_INTERRUPTi      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTi      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_1i :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTi       :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTERRUPT_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTENABLE_0               0x90303028
#define PE_CTRL_PE_AGG_INTENABLE_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1e     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1e     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1e     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1e     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t XFI0_INTERRUPTe      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTe      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_1e :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTe       :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTENABLE_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTERRUPT_1            0x9030302c
#define PE_CTRL_PE_QM_AGG_INTERRUPT_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8i    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9i    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10i   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11i   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12i   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13i   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIi :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOi :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTERRUPT_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_QM_AGG_INTENABLE_1            0x90303030
#define PE_CTRL_PE_QM_AGG_INTENABLE_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 0:0 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 1:1 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 2:2 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 3:3 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 4:4 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 5:5 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 6:6 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 7:7 */
    ca_uint32_t CPU_REFILL_REQ_8e    :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_REFILL_REQ_9e    :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_REFILL_REQ_10e   :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_REFILL_REQ_11e   :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_REFILL_REQ_12e   :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_REFILL_REQ_13e   :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_256_FIFO_HIe :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_256_FIFO_LOe :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_QM_AGG_INTENABLE_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTERRUPT_1               0x90303034
#define PE_CTRL_PE_AGG_INTERRUPT_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1i     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1i     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1i     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1i     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t XFI0_INTERRUPTi      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTi      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_1i :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTi       :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTERRUPT_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_AGG_INTENABLE_1               0x90303038
#define PE_CTRL_PE_AGG_INTENABLE_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t PER_UART0_INT_1e     :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INT_1e     :  1 ; /* bits 5:5 */
    ca_uint32_t PER_UART2_INT_1e     :  1 ; /* bits 6:6 */
    ca_uint32_t PER_UART3_INT_1e     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t XFI0_INTERRUPTe      :  1 ; /* bits 9:9 */
    ca_uint32_t XFI1_INTERRUPTe      :  1 ; /* bits 10:10 */
    ca_uint32_t PER_PERIPHERAL_INTERRUPT_1e :  1 ; /* bits 11:11 */
    ca_uint32_t WOL_INTERRUPTe       :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_AGG_INTENABLE_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_DSS_CONFIG_0                  0x9030303c
#define PE_CTRL_PE_DSS_CONFIG_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dss_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t ro_sel               :  3 ; /* bits 3:1 */
    ca_uint32_t wire_sel             :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t speed_en             :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_DSS_CONFIG_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_DSS_STATUS_0                  0x90303040
#define PE_CTRL_PE_DSS_STATUS_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ready                :  1 ; /* bits 0:0 */
    ca_uint32_t count_out            : 20 ; /* bits 20:1 */
    ca_uint32_t wsort_go             :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_DSS_STATUS_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_DSS_CONFIG_1                  0x90303044
#define PE_CTRL_PE_DSS_CONFIG_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dss_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t ro_sel               :  3 ; /* bits 3:1 */
    ca_uint32_t wire_sel             :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t speed_en             :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_DSS_CONFIG_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_DSS_STATUS_1                  0x90303048
#define PE_CTRL_PE_DSS_STATUS_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ready                :  1 ; /* bits 0:0 */
    ca_uint32_t count_out            : 20 ; /* bits 20:1 */
    ca_uint32_t wsort_go             :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_DSS_STATUS_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPTO_PROT                      0x9030304c
#define PE_CTRL_CRYPTO_PROT_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t override_c0m         :  2 ; /* bits 1:0 */
    ca_uint32_t override_c1m         :  2 ; /* bits 3:2 */
    ca_uint32_t override_c0s         :  2 ; /* bits 5:4 */
    ca_uint32_t override_c1s         :  2 ; /* bits 7:6 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPTO_PROT_t;
#endif /* !__ASSEMBLER__ */

#define     override_c1s_PASS                             0x0
#define     override_c1s_OVSEC                            0x1
#define     override_c1s_OVNS                             0x2
#define     override_c0s_PASS                             0x0
#define     override_c0s_OVSEC                            0x1
#define     override_c0s_OVNS                             0x2
#define     override_c1m_PASS                             0x0
#define     override_c1m_OVSEC                            0x1
#define     override_c1m_OVNS                             0x2
#define     override_c0m_PASS                             0x0
#define     override_c0m_OVSEC                            0x1
#define     override_c0m_OVNS                             0x2

#define PE_CTRL_PE_BUS_DEBUG_CTRL                0x90303050
#define PE_CTRL_PE_BUS_DEBUG_CTRL_dft            0x0000fffc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cfg_timeout_axi      : 16 ; /* bits 15:0 */
    ca_uint32_t cfg_clr_fail_t_axi   :  1 ; /* bits 16:16 */
    ca_uint32_t cfg_clr_fail_r_axi   :  1 ; /* bits 17:17 */
    ca_uint32_t cfg_clr_debug_axi    :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cfg_debug_sel_axi    :  5 ; /* bits 24:20 */
    ca_uint32_t cfg_debug_sel_pe     :  3 ; /* bits 27:25 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_BUS_DEBUG_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_BUS_DEBUG_STATUS              0x90303054
#define PE_CTRL_PE_BUS_DEBUG_STATUS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_dbg_out          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_BUS_DEBUG_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPT1_SLV_ID                    0x90303058
#define PE_CTRL_CRYPT1_SLV_ID_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry0        :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry1        :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry2        :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry3        :  6 ; /* bits 23:18 */
    ca_uint32_t reg_id_en0           :  1 ; /* bits 24:24 */
    ca_uint32_t reg_id_en1           :  1 ; /* bits 25:25 */
    ca_uint32_t reg_id_en2           :  1 ; /* bits 26:26 */
    ca_uint32_t reg_id_en3           :  1 ; /* bits 27:27 */
    ca_uint32_t reg_enabled          :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPT1_SLV_ID_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPT1_SLV_ID_MASK               0x9030305c
#define PE_CTRL_CRYPT1_SLV_ID_MASK_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry_mask0   :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry_mask1   :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry_mask2   :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry_mask3   :  6 ; /* bits 23:18 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPT1_SLV_ID_MASK_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_SADB_SLV_ID                      0x90303060
#define PE_CTRL_SADB_SLV_ID_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry0        :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry1        :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry2        :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry3        :  6 ; /* bits 23:18 */
    ca_uint32_t reg_id_en0           :  1 ; /* bits 24:24 */
    ca_uint32_t reg_id_en1           :  1 ; /* bits 25:25 */
    ca_uint32_t reg_id_en2           :  1 ; /* bits 26:26 */
    ca_uint32_t reg_id_en3           :  1 ; /* bits 27:27 */
    ca_uint32_t reg_enabled          :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_SADB_SLV_ID_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_SADB_SLV_ID_MASK                 0x90303064
#define PE_CTRL_SADB_SLV_ID_MASK_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry_mask0   :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry_mask1   :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry_mask2   :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry_mask3   :  6 ; /* bits 23:18 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_SADB_SLV_ID_MASK_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_TAROKO0_RM_0                     0x90303068
#define PE_CTRL_TAROKO0_RM_0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2c_RM10_L2CACHE_DATA3 :  2 ; /* bits 1:0 */
    ca_uint32_t l2c_RM10_L2CACHE_DATA2 :  2 ; /* bits 3:2 */
    ca_uint32_t l2c_RM10_L2CACHE_DATA1 :  2 ; /* bits 5:4 */
    ca_uint32_t l2c_RM10_L2CACHE_DATA0 :  2 ; /* bits 7:6 */
    ca_uint32_t l2c_RM10_L2CACHE_TAG :  2 ; /* bits 9:8 */
    ca_uint32_t l2c_RM10_L2CACHE_LRU :  2 ; /* bits 11:10 */
    ca_uint32_t RM10_i_pht_sram      :  2 ; /* bits 13:12 */
    ca_uint32_t RM10_i_btb_tag_sram  :  2 ; /* bits 15:14 */
    ca_uint32_t RM10_i_btb_data_sram :  2 ; /* bits 17:16 */
    ca_uint32_t RM10_IRAM0           :  2 ; /* bits 19:18 */
    ca_uint32_t RM10_ICACHE_TAG      :  2 ; /* bits 21:20 */
    ca_uint32_t RM10_ICACHE_LRU      :  2 ; /* bits 23:22 */
    ca_uint32_t RM10_ICACHE_DATA     :  2 ; /* bits 25:24 */
    ca_uint32_t RM10_DRAM1           :  2 ; /* bits 27:26 */
    ca_uint32_t RM10_DRAM0           :  2 ; /* bits 29:28 */
    ca_uint32_t RM10_DCACHE_TAG      :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_TAROKO0_RM_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_TAROKO0_RM_1                     0x9030306c
#define PE_CTRL_TAROKO0_RM_1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t RM10_DCACHE_DATA     :  2 ; /* bits 1:0 */
    ca_uint32_t ALL_RM32             :  2 ; /* bits 3:2 */
    ca_uint32_t ALL_TEST1            :  1 ; /* bits 4:4 */
    ca_uint32_t ALL_SD               :  1 ; /* bits 5:5 */
    ca_uint32_t ALL_RME              :  1 ; /* bits 6:6 */
    ca_uint32_t ALL_LS               :  1 ; /* bits 7:7 */
    ca_uint32_t ALL_DS               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_TAROKO0_RM_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_TAROKO1_RM_0                     0x90303070
#define PE_CTRL_TAROKO1_RM_0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2c_RM10_L2CACHE_DATA3 :  2 ; /* bits 1:0 */
    ca_uint32_t l2c_RM10_L2CACHE_DATA2 :  2 ; /* bits 3:2 */
    ca_uint32_t l2c_RM10_L2CACHE_DATA1 :  2 ; /* bits 5:4 */
    ca_uint32_t l2c_RM10_L2CACHE_DATA0 :  2 ; /* bits 7:6 */
    ca_uint32_t l2c_RM10_L2CACHE_TAG :  2 ; /* bits 9:8 */
    ca_uint32_t l2c_RM10_L2CACHE_LRU :  2 ; /* bits 11:10 */
    ca_uint32_t RM10_i_pht_sram      :  2 ; /* bits 13:12 */
    ca_uint32_t RM10_i_btb_tag_sram  :  2 ; /* bits 15:14 */
    ca_uint32_t RM10_i_btb_data_sram :  2 ; /* bits 17:16 */
    ca_uint32_t RM10_IRAM0           :  2 ; /* bits 19:18 */
    ca_uint32_t RM10_ICACHE_TAG      :  2 ; /* bits 21:20 */
    ca_uint32_t RM10_ICACHE_LRU      :  2 ; /* bits 23:22 */
    ca_uint32_t RM10_ICACHE_DATA     :  2 ; /* bits 25:24 */
    ca_uint32_t RM10_DRAM1           :  2 ; /* bits 27:26 */
    ca_uint32_t RM10_DRAM0           :  2 ; /* bits 29:28 */
    ca_uint32_t RM10_DCACHE_TAG      :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_TAROKO1_RM_0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_TAROKO1_RM_1                     0x90303074
#define PE_CTRL_TAROKO1_RM_1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t RM10_DCACHE_DATA     :  2 ; /* bits 1:0 */
    ca_uint32_t ALL_RM32             :  2 ; /* bits 3:2 */
    ca_uint32_t ALL_TEST1            :  1 ; /* bits 4:4 */
    ca_uint32_t ALL_SD               :  1 ; /* bits 5:5 */
    ca_uint32_t ALL_RME              :  1 ; /* bits 6:6 */
    ca_uint32_t ALL_LS               :  1 ; /* bits 7:7 */
    ca_uint32_t ALL_DS               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_TAROKO1_RM_1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_SADB_RM                          0x90303078
#define PE_CTRL_SADB_RM_dft                      0x00022222

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sadb_sramtest        : 16 ; /* bits 15:0 */
    ca_uint32_t pel2_sramtest        :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_SADB_RM_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPTO1_RM1                      0x9030307c
#define PE_CTRL_CRYPTO1_RM1_dft                  0x00002222

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crypto1_sramtest1    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPTO1_RM1_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPTO1_RM0                      0x90303080
#define PE_CTRL_CRYPTO1_RM0_dft                  0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crypto1_sramtest0    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPTO1_RM0_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_CRYPTO2_RM                       0x90303084
#define PE_CTRL_CRYPTO2_RM_dft                   0x00000022

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crypto2_sramtest     :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_CRYPTO2_RM_t;
#endif /* !__ASSEMBLER__ */


#define PE_CTRL_PE_LS                            0x90303088
#define PE_CTRL_PE_LS_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t capsram_repair_sramls :  4 ; /* bits 3:0 */
    ca_uint32_t crypto0_1_sramls     :  6 ; /* bits 9:4 */
    ca_uint32_t crypto1_1_sramls     :  6 ; /* bits 15:10 */
    ca_uint32_t crypto0_2_sramls     :  2 ; /* bits 17:16 */
    ca_uint32_t crypto1_2_sramls     :  2 ; /* bits 19:18 */
    ca_uint32_t ldma_sramls          :  2 ; /* bits 21:20 */
    ca_uint32_t sadb_sramls          :  2 ; /* bits 23:22 */
    ca_uint32_t pel2_sramls          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_CTRL_PE_LS_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE_CTRL */
#ifndef __ASSEMBLER__
typedef struct {
  PE_CTRL_PES_ADDR_MASTER_CONFIG_t         PES_ADDR_MASTER_CONFIG;        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  PE_CTRL_PE0S_ADDR_CONFIG_t               PE0S_ADDR_CONFIG;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  PE_CTRL_PE1S_ADDR_CONFIG_t               PE1S_ADDR_CONFIG;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  PE_CTRL_AXI_CTRL_PE0_t                   AXI_CTRL_PE0;                  /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  PE_CTRL_AXI_CTRL1_PE0_t                  AXI_CTRL1_PE0;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  PE_CTRL_AXI_CTRL_PE1_t                   AXI_CTRL_PE1;                  /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  PE_CTRL_AXI_CTRL1_PE1_t                  AXI_CTRL1_PE1;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  PE_CTRL_PE_QM_AGG_INTERRUPT_0_t          PE_QM_AGG_INTERRUPT_0;         /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  PE_CTRL_PE_QM_AGG_INTENABLE_0_t          PE_QM_AGG_INTENABLE_0;         /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  PE_CTRL_PE_AGG_INTERRUPT_0_t             PE_AGG_INTERRUPT_0;            /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  PE_CTRL_PE_AGG_INTENABLE_0_t             PE_AGG_INTENABLE_0;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  PE_CTRL_PE_QM_AGG_INTERRUPT_1_t          PE_QM_AGG_INTERRUPT_1;         /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  PE_CTRL_PE_QM_AGG_INTENABLE_1_t          PE_QM_AGG_INTENABLE_1;         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  PE_CTRL_PE_AGG_INTERRUPT_1_t             PE_AGG_INTERRUPT_1;            /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  PE_CTRL_PE_AGG_INTENABLE_1_t             PE_AGG_INTENABLE_1;            /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  PE_CTRL_PE_DSS_CONFIG_0_t                PE_DSS_CONFIG_0;               /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  PE_CTRL_PE_DSS_STATUS_0_t                PE_DSS_STATUS_0;               /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  PE_CTRL_PE_DSS_CONFIG_1_t                PE_DSS_CONFIG_1;               /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  PE_CTRL_PE_DSS_STATUS_1_t                PE_DSS_STATUS_1;               /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  PE_CTRL_CRYPTO_PROT_t                    CRYPTO_PROT;                   /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  PE_CTRL_PE_BUS_DEBUG_CTRL_t              PE_BUS_DEBUG_CTRL;             /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  PE_CTRL_PE_BUS_DEBUG_STATUS_t            PE_BUS_DEBUG_STATUS;           /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  PE_CTRL_CRYPT1_SLV_ID_t                  CRYPT1_SLV_ID;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  PE_CTRL_CRYPT1_SLV_ID_MASK_t             CRYPT1_SLV_ID_MASK;            /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  PE_CTRL_SADB_SLV_ID_t                    SADB_SLV_ID;                   /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  PE_CTRL_SADB_SLV_ID_MASK_t               SADB_SLV_ID_MASK;              /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  PE_CTRL_TAROKO0_RM_0_t                   TAROKO0_RM_0;                  /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  PE_CTRL_TAROKO0_RM_1_t                   TAROKO0_RM_1;                  /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  PE_CTRL_TAROKO1_RM_0_t                   TAROKO1_RM_0;                  /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  PE_CTRL_TAROKO1_RM_1_t                   TAROKO1_RM_1;                  /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  PE_CTRL_SADB_RM_t                        SADB_RM;                       /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  PE_CTRL_CRYPTO1_RM1_t                    CRYPTO1_RM1;                   /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  PE_CTRL_CRYPTO1_RM0_t                    CRYPTO1_RM0;                   /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  PE_CTRL_CRYPTO2_RM_t                     CRYPTO2_RM;                    /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  PE_CTRL_PE_LS_t                          PE_LS;                         /* addr: 0x00000088 */
} APB1_PE_CTRL_t;
#endif /* !__ASSEMBLER__ */




/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* APB1 */

#ifndef __ASSEMBLER__
typedef struct {
  APB1_PE0_ATU_t                           PE0_ATU;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[241];
  APB1_PE1_ATU_t                           PE1_ATU;                       /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[241];
  APB1_CRYPTO0_ATU_t                       CRYPTO0_ATU;                   /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd3[497];
  APB1_CRYPTO1_ATU_t                       CRYPTO1_ATU;                   /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd4[3057];
  APB1_LDMA_t                              LDMA;                          /* addr: 0x00001000 */
  ca_uint32_t                              rsrvd5[2529];
  APB1_LDMA_RCPU_t                         LDMA_RCPU;                     /* addr: 0x00002000 */
  ca_uint32_t                              rsrvd6[2529];
  APB1_PE_CTRL_t                           PE_CTRL;                       /* addr: 0x00003000 */
} APB1_t;
#endif /* !__ASSEMBLER__ */


/*
 * APB0
 */

/*
 * NE_L23
 */

/*
 * L2FE
 */

/*
 * GLB
 */

#define L2FE_GLB_VER_CTRL                        0xf4301000
#define L2FE_GLB_VER_CTRL_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rev_id               : 16 ; /* bits 15:0 */
    ca_uint32_t ver_id               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_VER_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_CTRL                            0xf4301004
#define L2FE_GLB_CTRL_dft                        0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t soft_reset           :  1 ; /* bits 0:0 */
    ca_uint32_t pipeline_clk_num     :  5 ; /* bits 5:1 */
    ca_uint32_t change_ip_if_pop_en  :  1 ; /* bits 6:6 */
    ca_uint32_t qos_enhance_mode     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_INTERRUPT                       0xf4301008
#define L2FE_GLB_INTERRUPT_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lf_overflow_intI     :  1 ; /* bits 1:1 */
    ca_uint32_t ple_hd_ff_overflow_intI :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t port_mac_lmt_excd_intI :  1 ; /* bits 8:8 */
    ca_uint32_t l2e_hash_collision_intI :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_INTERRUPTE                      0xf430100c
#define L2FE_GLB_INTERRUPTE_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lf_overflow_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t ple_hd_ff_overflow_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t port_mac_lmt_excd_intIE :  1 ; /* bits 8:8 */
    ca_uint32_t l2e_hash_collision_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_STTS                            0xf4301010
#define L2FE_GLB_STTS_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2fe_init_done       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_STTS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_CFG_SPARE                  0xf4301014
#define L2FE_GLB_L2FE_CFG_SPARE_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bit                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_CFG_SPARE_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_STTS_SPARE                 0xf4301018
#define L2FE_GLB_L2FE_STTS_SPARE_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bit                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_STTS_SPARE_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_0             0xf430101c
#define L2FE_GLB_SRAM_TEST_CONTROL_0_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_1             0xf4301020
#define L2FE_GLB_SRAM_TEST_CONTROL_1_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_2             0xf4301024
#define L2FE_GLB_SRAM_TEST_CONTROL_2_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_3             0xf4301028
#define L2FE_GLB_SRAM_TEST_CONTROL_3_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_4             0xf430102c
#define L2FE_GLB_SRAM_TEST_CONTROL_4_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_5             0xf4301030
#define L2FE_GLB_SRAM_TEST_CONTROL_5_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_6             0xf4301034
#define L2FE_GLB_SRAM_TEST_CONTROL_6_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_7             0xf4301038
#define L2FE_GLB_SRAM_TEST_CONTROL_7_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_8             0xf430103c
#define L2FE_GLB_SRAM_TEST_CONTROL_8_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_8_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_9             0xf4301040
#define L2FE_GLB_SRAM_TEST_CONTROL_9_dft         0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_9_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_10            0xf4301044
#define L2FE_GLB_SRAM_TEST_CONTROL_10_dft        0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_10_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_11            0xf4301048
#define L2FE_GLB_SRAM_TEST_CONTROL_11_dft        0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t rm3                  :  4 ; /* bits 27:24 */
    ca_uint32_t rme3                 :  1 ; /* bits 28:28 */
    ca_uint32_t test1_3              :  1 ; /* bits 29:29 */
    ca_uint32_t test0_3              :  1 ; /* bits 30:30 */
    ca_uint32_t reserved3            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_11_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_TEST_CONTROL_12            0xf430104c
#define L2FE_GLB_SRAM_TEST_CONTROL_12_dft        0x00020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rm0                  :  4 ; /* bits 3:0 */
    ca_uint32_t rme0                 :  1 ; /* bits 4:4 */
    ca_uint32_t test1_0              :  1 ; /* bits 5:5 */
    ca_uint32_t test0_0              :  1 ; /* bits 6:6 */
    ca_uint32_t reserved0            :  1 ; /* bits 7:7 */
    ca_uint32_t rm1                  :  4 ; /* bits 11:8 */
    ca_uint32_t rme1                 :  1 ; /* bits 12:12 */
    ca_uint32_t test1_1              :  1 ; /* bits 13:13 */
    ca_uint32_t test0_1              :  1 ; /* bits 14:14 */
    ca_uint32_t reserved1            :  1 ; /* bits 15:15 */
    ca_uint32_t rm2                  :  4 ; /* bits 19:16 */
    ca_uint32_t rme2                 :  1 ; /* bits 20:20 */
    ca_uint32_t test1_2              :  1 ; /* bits 21:21 */
    ca_uint32_t test0_2              :  1 ; /* bits 22:22 */
    ca_uint32_t reserved2            :  1 ; /* bits 23:23 */
    ca_uint32_t reserved3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_TEST_CONTROL_12_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_LS_CONTROL_1               0xf4301050
#define L2FE_GLB_SRAM_LS_CONTROL_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2fe4_sramls         :  7 ; /* bits 6:0 */
    ca_uint32_t l2fe5_sramls         :  9 ; /* bits 15:7 */
    ca_uint32_t l2fe6_sramls         :  6 ; /* bits 21:16 */
    ca_uint32_t l2fe7_sramls         :  2 ; /* bits 23:22 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_LS_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_SRAM_LS_CONTROL_0               0xf4301054
#define L2FE_GLB_SRAM_LS_CONTROL_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2fe1_sramls         : 12 ; /* bits 11:0 */
    ca_uint32_t l2fe2_sramls         :  1 ; /* bits 12:12 */
    ca_uint32_t l2fe2_tcam_sramls    :  2 ; /* bits 14:13 */
    ca_uint32_t l2fe3_sramls         : 12 ; /* bits 26:15 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_SRAM_LS_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_MONITOR_TRIG               0xf4301058
#define L2FE_GLB_L2FE_MONITOR_TRIG_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_MONITOR_TRIG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_MONITOR_CTRL               0xf430105c
#define L2FE_GLB_L2FE_MONITOR_CTRL_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_L2FE_MONITOR_RETURN             0xf4301060
#define L2FE_GLB_L2FE_MONITOR_RETURN_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_GLB_DEBUG                           0xf4301064
#define L2FE_GLB_DEBUG_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t plx_bus_sel          :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_DEBUG_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_GLB_VER_CTRL_t                      VER_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_GLB_CTRL_t                          CTRL;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_GLB_INTERRUPT_t                     INTERRUPT;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_GLB_INTERRUPTE_t                    INTERRUPTE;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_GLB_STTS_t                          STTS;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_GLB_L2FE_CFG_SPARE_t                L2FE_CFG_SPARE;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_GLB_L2FE_STTS_SPARE_t               L2FE_STTS_SPARE;               /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_GLB_SRAM_TEST_CONTROL_0_t           SRAM_TEST_CONTROL_0;           /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_GLB_SRAM_TEST_CONTROL_1_t           SRAM_TEST_CONTROL_1;           /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_GLB_SRAM_TEST_CONTROL_2_t           SRAM_TEST_CONTROL_2;           /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_GLB_SRAM_TEST_CONTROL_3_t           SRAM_TEST_CONTROL_3;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2FE_GLB_SRAM_TEST_CONTROL_4_t           SRAM_TEST_CONTROL_4;           /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2FE_GLB_SRAM_TEST_CONTROL_5_t           SRAM_TEST_CONTROL_5;           /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2FE_GLB_SRAM_TEST_CONTROL_6_t           SRAM_TEST_CONTROL_6;           /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2FE_GLB_SRAM_TEST_CONTROL_7_t           SRAM_TEST_CONTROL_7;           /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2FE_GLB_SRAM_TEST_CONTROL_8_t           SRAM_TEST_CONTROL_8;           /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2FE_GLB_SRAM_TEST_CONTROL_9_t           SRAM_TEST_CONTROL_9;           /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2FE_GLB_SRAM_TEST_CONTROL_10_t          SRAM_TEST_CONTROL_10;          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2FE_GLB_SRAM_TEST_CONTROL_11_t          SRAM_TEST_CONTROL_11;          /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2FE_GLB_SRAM_TEST_CONTROL_12_t          SRAM_TEST_CONTROL_12;          /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2FE_GLB_SRAM_LS_CONTROL_1_t             SRAM_LS_CONTROL_1;             /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2FE_GLB_SRAM_LS_CONTROL_0_t             SRAM_LS_CONTROL_0;             /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2FE_GLB_L2FE_MONITOR_TRIG_t             L2FE_MONITOR_TRIG;             /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L2FE_GLB_L2FE_MONITOR_CTRL_t             L2FE_MONITOR_CTRL;             /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L2FE_GLB_L2FE_MONITOR_RETURN_t           L2FE_MONITOR_RETURN;           /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L2FE_GLB_DEBUG_t                         DEBUG;                         /* addr: 0x00000064 */
} APB0_L2FE_GLB_t;
#endif /* !__ASSEMBLER__ */


/*
 * PP
 */

#define L2FE_PP_PPID_ATTR_CFG                    0xf4301100
#define L2FE_PP_PPID_ATTR_CFG_dft                0x009d0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ppid0                :  2 ; /* bits 1:0 */
    ca_uint32_t ppid1                :  2 ; /* bits 3:2 */
    ca_uint32_t ppid2                :  2 ; /* bits 5:4 */
    ca_uint32_t ppid3                :  2 ; /* bits 7:6 */
    ca_uint32_t ppid4                :  2 ; /* bits 9:8 */
    ca_uint32_t ppid5                :  2 ; /* bits 11:10 */
    ca_uint32_t ppid6                :  2 ; /* bits 13:12 */
    ca_uint32_t ppid7                :  2 ; /* bits 15:14 */
    ca_uint32_t ppid8                :  2 ; /* bits 17:16 */
    ca_uint32_t ppid9                :  2 ; /* bits 19:18 */
    ca_uint32_t ppid10               :  2 ; /* bits 21:20 */
    ca_uint32_t ppid11               :  2 ; /* bits 23:22 */
    ca_uint32_t ppid12               :  2 ; /* bits 25:24 */
    ca_uint32_t ppid13               :  2 ; /* bits 27:26 */
    ca_uint32_t ppid14               :  2 ; /* bits 29:28 */
    ca_uint32_t ppid15               :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PPID_ATTR_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DPB_CTRL                         0xf4301104
#define L2FE_PP_DPB_CTRL_dft                     0x00000003

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_pattern        :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_TPID_CMP_S                       0xf4301108
#define L2FE_PP_TPID_CMP_S_dft                   0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_S_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_TPID_CMP_C                       0xf430110c
#define L2FE_PP_TPID_CMP_C_dft                   0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_C_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_TPID_CMP_O                       0xf4301110
#define L2FE_PP_TPID_CMP_O_dft                   0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_O_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_TPID_CMP_USER                    0xf4301114
#define L2FE_PP_TPID_CMP_USER_dft                0x00009100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_USER_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HELLO_PKT_ENABLE_DA_LOW          0xf4301118
#define L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_dft      0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HELLO_PKT_ENABLE_DA_HI           0xf430111c
#define L2FE_PP_HELLO_PKT_ENABLE_DA_HI_dft       0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HELLO_PKT_DA_LOW                 0xf4301120
#define L2FE_PP_HELLO_PKT_DA_LOW_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_DA_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HELLO_PKT_DA_HI                  0xf4301124
#define L2FE_PP_HELLO_PKT_DA_HI_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_DA_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_ENABLE_DA_0_LOW          0xf4301128
#define L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_dft      0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_ENABLE_DA_0_HI           0xf430112c
#define L2FE_PP_SPECIAL_ENABLE_DA_0_HI_dft       0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_DA_0_LOW                 0xf4301130
#define L2FE_PP_SPECIAL_DA_0_LOW_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_0_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_DA_0_HI                  0xf4301134
#define L2FE_PP_SPECIAL_DA_0_HI_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_0_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_EV2PT                    0xf4301138
#define L2FE_PP_SPECIAL_EV2PT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ev2pt                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_EV2PT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_ENABLE_DA_1_LOW          0xf430113c
#define L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_dft      0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_ENABLE_DA_1_HI           0xf4301140
#define L2FE_PP_SPECIAL_ENABLE_DA_1_HI_dft       0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_DA_1_LOW                 0xf4301144
#define L2FE_PP_SPECIAL_DA_1_LOW_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_1_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_DA_1_HI                  0xf4301148
#define L2FE_PP_SPECIAL_DA_1_HI_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_1_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_VLAN                     0xf430114c
#define L2FE_PP_SPECIAL_VLAN_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vlan                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_VLAN_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_LOW                       0xf4301150
#define L2FE_PP_MY_MAC_LOW_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_HI                        0xf4301154
#define L2FE_PP_MY_MAC_HI_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_ENABLE_LOW                0xf4301158
#define L2FE_PP_MY_MAC_ENABLE_LOW_dft            0x00ffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_ENABLE_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_LOW_1                     0xf430115c
#define L2FE_PP_MY_MAC_LOW_1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_LOW_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_HI_1                      0xf4301160
#define L2FE_PP_MY_MAC_HI_1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_HI_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MY_MAC_ENABLE_LOW_1              0xf4301164
#define L2FE_PP_MY_MAC_ENABLE_LOW_1_dft          0x00ffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_ENABLE_LOW_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_MAC_MC_LOW                   0xf4301168
#define L2FE_PP_RSV_MAC_MC_LOW_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_MAC_MC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_MAC_MC_HI                    0xf430116c
#define L2FE_PP_RSV_MAC_MC_HI_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_MAC_MC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_ENABLE_MC_LOW                0xf4301170
#define L2FE_PP_RSV_ENABLE_MC_LOW_dft            0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_ENABLE_MC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_ENABLE_MC_HI                 0xf4301174
#define L2FE_PP_RSV_ENABLE_MC_HI_dft             0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_ENABLE_MC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_GROUP_MAC_LOW                0xf4301178
#define L2FE_PP_RSV_GROUP_MAC_LOW_dft            0xc2000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_GROUP_MAC_HI                 0xf430117c
#define L2FE_PP_RSV_GROUP_MAC_HI_dft             0x00000180

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_MAC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_GROUP_ENABLE_LOW             0xf4301180
#define L2FE_PP_RSV_GROUP_ENABLE_LOW_dft         0xfffffff0

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_ENABLE_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_RSV_GROUP_ENABLE_HI              0xf4301184
#define L2FE_PP_RSV_GROUP_ENABLE_HI_dft          0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_ENABLE_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_MAC_0_LOW                0xf4301188
#define L2FE_PP_MEF_OAM_MAC_0_LOW_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_0_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_MAC_0_HI                 0xf430118c
#define L2FE_PP_MEF_OAM_MAC_0_HI_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_0_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_TYPE_0                   0xf4301190
#define L2FE_PP_MEF_OAM_TYPE_0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_TYPE_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_MAC_1_LOW                0xf4301194
#define L2FE_PP_MEF_OAM_MAC_1_LOW_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_1_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_MAC_1_HI                 0xf4301198
#define L2FE_PP_MEF_OAM_MAC_1_HI_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_1_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_MEF_OAM_TYPE_1                   0xf430119c
#define L2FE_PP_MEF_OAM_TYPE_1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_TYPE_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_L7_OFFSET                        0xf43011a0
#define L2FE_PP_L7_OFFSET_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t offset               :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_L7_OFFSET_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_ERR_STTS_0               0xf43011a4
#define L2FE_PP_NI_INTF_ERR_STTS_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sop_eop_mismatch_0   :  1 ; /* bits 0:0 */
    ca_uint32_t sop_eop_mismatch_1   :  1 ; /* bits 1:1 */
    ca_uint32_t sop_eop_mismatch_2   :  1 ; /* bits 2:2 */
    ca_uint32_t sop_eop_mismatch_3   :  1 ; /* bits 3:3 */
    ca_uint32_t sop_eop_mismatch_4   :  1 ; /* bits 4:4 */
    ca_uint32_t sop_eop_mismatch_5   :  1 ; /* bits 5:5 */
    ca_uint32_t sop_eop_mismatch_6   :  1 ; /* bits 6:6 */
    ca_uint32_t sop_eop_mismatch_7   :  1 ; /* bits 7:7 */
    ca_uint32_t sop_eop_mismatch_8   :  1 ; /* bits 8:8 */
    ca_uint32_t sop_eop_mismatch_9   :  1 ; /* bits 9:9 */
    ca_uint32_t sop_eop_mismatch_10  :  1 ; /* bits 10:10 */
    ca_uint32_t sop_eop_mismatch_11  :  1 ; /* bits 11:11 */
    ca_uint32_t sop_eop_mismatch_12  :  1 ; /* bits 12:12 */
    ca_uint32_t sop_eop_mismatch_13  :  1 ; /* bits 13:13 */
    ca_uint32_t sop_eop_mismatch_14  :  1 ; /* bits 14:14 */
    ca_uint32_t sop_eop_mismatch_15  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_ERR_STTS_1               0xf43011a8
#define L2FE_PP_NI_INTF_ERR_STTS_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t runt_l2_pkt_0        :  1 ; /* bits 0:0 */
    ca_uint32_t runt_l2_pkt_1        :  1 ; /* bits 1:1 */
    ca_uint32_t runt_l2_pkt_2        :  1 ; /* bits 2:2 */
    ca_uint32_t runt_l2_pkt_3        :  1 ; /* bits 3:3 */
    ca_uint32_t runt_l2_pkt_4        :  1 ; /* bits 4:4 */
    ca_uint32_t runt_l2_pkt_5        :  1 ; /* bits 5:5 */
    ca_uint32_t runt_l2_pkt_6        :  1 ; /* bits 6:6 */
    ca_uint32_t runt_l2_pkt_7        :  1 ; /* bits 7:7 */
    ca_uint32_t runt_l2_pkt_8        :  1 ; /* bits 8:8 */
    ca_uint32_t runt_l2_pkt_9        :  1 ; /* bits 9:9 */
    ca_uint32_t runt_l2_pkt_10       :  1 ; /* bits 10:10 */
    ca_uint32_t runt_l2_pkt_11       :  1 ; /* bits 11:11 */
    ca_uint32_t runt_l2_pkt_12       :  1 ; /* bits 12:12 */
    ca_uint32_t runt_l2_pkt_13       :  1 ; /* bits 13:13 */
    ca_uint32_t runt_l2_pkt_14       :  1 ; /* bits 14:14 */
    ca_uint32_t runt_l2_pkt_15       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_ERR_STTS_2               0xf43011ac
#define L2FE_PP_NI_INTF_ERR_STTS_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sob_eob_mismatch_0   :  1 ; /* bits 0:0 */
    ca_uint32_t sob_eob_mismatch_1   :  1 ; /* bits 1:1 */
    ca_uint32_t sob_eob_mismatch_2   :  1 ; /* bits 2:2 */
    ca_uint32_t sob_eob_mismatch_3   :  1 ; /* bits 3:3 */
    ca_uint32_t sob_eob_mismatch_4   :  1 ; /* bits 4:4 */
    ca_uint32_t sob_eob_mismatch_5   :  1 ; /* bits 5:5 */
    ca_uint32_t sob_eob_mismatch_6   :  1 ; /* bits 6:6 */
    ca_uint32_t sob_eob_mismatch_7   :  1 ; /* bits 7:7 */
    ca_uint32_t sob_eob_mismatch_8   :  1 ; /* bits 8:8 */
    ca_uint32_t sob_eob_mismatch_9   :  1 ; /* bits 9:9 */
    ca_uint32_t sob_eob_mismatch_10  :  1 ; /* bits 10:10 */
    ca_uint32_t sob_eob_mismatch_11  :  1 ; /* bits 11:11 */
    ca_uint32_t sob_eob_mismatch_12  :  1 ; /* bits 12:12 */
    ca_uint32_t sob_eob_mismatch_13  :  1 ; /* bits 13:13 */
    ca_uint32_t sob_eob_mismatch_14  :  1 ; /* bits 14:14 */
    ca_uint32_t sob_eob_mismatch_15  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_ERR_STTS_3               0xf43011b0
#define L2FE_PP_NI_INTF_ERR_STTS_3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sop_2_sop_gap        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_PINGPONG_STS                     0xf43011b4
#define L2FE_PP_PINGPONG_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_STS                      0xf43011b8
#define L2FE_PP_NI_INTF_STS_dft                  0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdy                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_DROP_CNT                 0xf43011bc
#define L2FE_PP_NI_INTF_DROP_CNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t drop                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_DROP_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_NI_INTF_PKT_CNT                  0xf43011c0
#define L2FE_PP_NI_INTF_PKT_CNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eop                  : 16 ; /* bits 15:0 */
    ca_uint32_t sop                  : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HEADER_A_LOW                     0xf43011c4
#define L2FE_PP_HEADER_A_LOW_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HEADER_A_MID                     0xf43011c8
#define L2FE_PP_HEADER_A_MID_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_MID_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HEADER_A_HI                      0xf43011cc
#define L2FE_PP_HEADER_A_HI_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_PARSER_CTRL                      0xf43011d0
#define L2FE_PP_PARSER_CTRL_dft                  0xa03b0400

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t arp_ipv6_en          :  1 ; /* bits 10:10 */
    ca_uint32_t vlan_ext_mode        :  1 ; /* bits 11:11 */
    ca_uint32_t my_mac_det_range_mode :  1 ; /* bits 12:12 */
    ca_uint32_t arp_op_filter_dis    :  1 ; /* bits 13:13 */
    ca_uint32_t use_ip_addr_mc       :  1 ; /* bits 14:14 */
    ca_uint32_t l3fe_to_l2fe_lrn_ctrl :  1 ; /* bits 15:15 */
    ca_uint32_t egr_ptp_pkt_no_drop_set :  1 ; /* bits 16:16 */
    ca_uint32_t ipv4_checksum_check_enable :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t detect_oam_subtype   :  1 ; /* bits 19:19 */
    ca_uint32_t oam_subtype          :  8 ; /* bits 27:20 */
    ca_uint32_t udf0_det_en          :  1 ; /* bits 28:28 */
    ca_uint32_t udf0_det_type_en     :  1 ; /* bits 29:29 */
    ca_uint32_t udf1_det_en          :  1 ; /* bits 30:30 */
    ca_uint32_t udf1_det_vlan_en     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PARSER_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPECIAL_PKT                      0xf43011d4
#define L2FE_PP_SPECIAL_PKT_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_PKT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DEBUG_BUS                        0xf43011d8
#define L2FE_PP_DEBUG_BUS_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t ni2fe_pkt_cnt_wrap_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_IPPB_ACCESS                      0xf43011dc
#define L2FE_PP_IPPB_ACCESS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_IPPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_IPPB_DATA                        0xf43011e0
#define L2FE_PP_IPPB_DATA_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_IPPB_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_ACCESS                      0xf43011e4
#define L2FE_PP_ILPB_ACCESS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA4                       0xf43011e8
#define L2FE_PP_ILPB_DATA4_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_unkwn_pol_mode  :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_well_known_mc_idx :  5 ; /* bits 5:1 */
    ca_uint32_t ilpb_well_known_mc_det_en :  1 ; /* bits 6:6 */
    ca_uint32_t ilpb_rxqos_idx       :  3 ; /* bits 9:7 */
    ca_uint32_t ilpb_wan_ind         :  1 ; /* bits 10:10 */
    ca_uint32_t ilpb_cp_port         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA3                       0xf43011ec
#define L2FE_PP_ILPB_DATA3_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_vlan_cmd_sel_bm :  2 ; /* bits 1:0 */
    ca_uint32_t ilpb_sc_ind          :  1 ; /* bits 2:2 */
    ca_uint32_t ilpb_default_vlanid  : 12 ; /* bits 14:3 */
    ca_uint32_t ilpb_unkwn_pol_idx   :  3 ; /* bits 17:15 */
    ca_uint32_t ilpb_flowid_as_gemid :  1 ; /* bits 18:18 */
    ca_uint32_t ilpb_gemid_dynamic_mode :  1 ; /* bits 19:19 */
    ca_uint32_t ilpb_sa_miss_fwd     :  1 ; /* bits 20:20 */
    ca_uint32_t ilpb_sa_lmt_excd_drop :  1 ; /* bits 21:21 */
    ca_uint32_t ilpb_reserved_1      : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA2                       0xf43011f0
#define L2FE_PP_ILPB_DATA2_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_stp_mode        :  2 ; /* bits 1:0 */
    ca_uint32_t ilpb_other_tpid_match :  4 ; /* bits 5:2 */
    ca_uint32_t ilpb_inner_c_tpid_enable :  1 ; /* bits 6:6 */
    ca_uint32_t ilpb_inner_s_tpid_enable :  1 ; /* bits 7:7 */
    ca_uint32_t ilpb_top_c_tpid_enable :  1 ; /* bits 8:8 */
    ca_uint32_t ilpb_top_s_tpid_enable :  1 ; /* bits 9:9 */
    ca_uint32_t ilpb_c_tpid_match    :  4 ; /* bits 13:10 */
    ca_uint32_t ilpb_s_tpid_match    :  4 ; /* bits 17:14 */
    ca_uint32_t ilpb_drop_doubletagged_packet :  1 ; /* bits 18:18 */
    ca_uint32_t ilpb_drop_prytagged_packet :  1 ; /* bits 19:19 */
    ca_uint32_t ilpb_drop_untagged_packet :  1 ; /* bits 20:20 */
    ca_uint32_t ilpb_drop_ctag_packet :  1 ; /* bits 21:21 */
    ca_uint32_t ilpb_drop_stag_packet :  1 ; /* bits 22:22 */
    ca_uint32_t ilpb_drop_singletagged_packet :  1 ; /* bits 23:23 */
    ca_uint32_t ilpb_default_noninnertag_cmd :  1 ; /* bits 24:24 */
    ca_uint32_t ilpb_inner_vlan_cmd  :  2 ; /* bits 26:25 */
    ca_uint32_t ilpb_inner_vid_sel_bm :  2 ; /* bits 28:27 */
    ca_uint32_t ilpb_default_untag_cmd :  1 ; /* bits 29:29 */
    ca_uint32_t ilpb_default_top_vlan_cmd :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA1                       0xf43011f4
#define L2FE_PP_ILPB_DATA1_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_802_1p_mark_control_bm :  3 ; /* bits 2:0 */
    ca_uint32_t ilpb_change_1p_if_pop :  1 ; /* bits 3:3 */
    ca_uint32_t ilpb_top_802_1p_mode_sel :  2 ; /* bits 5:4 */
    ca_uint32_t ilpb_flowid_sel_bm   :  3 ; /* bits 8:6 */
    ca_uint32_t ilpb_cls_length      :  6 ; /* bits 14:9 */
    ca_uint32_t ilpb_cls_start       :  8 ; /* bits 22:15 */
    ca_uint32_t ilpb_igr_cls_lookup_en :  1 ; /* bits 23:23 */
    ca_uint32_t ilpb_spcl_pkt_idx    :  4 ; /* bits 27:24 */
    ca_uint32_t ilpb_da_sa_swap_en   :  1 ; /* bits 28:28 */
    ca_uint32_t ilpb_loop_enable     :  1 ; /* bits 29:29 */
    ca_uint32_t ilpb_sa_move_dis_fwd :  1 ; /* bits 30:30 */
    ca_uint32_t ilpb_station_move_en :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ILPB_DATA0                       0xf43011f8
#define L2FE_PP_ILPB_DATA0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ilpb_dflt_premark    :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_color_src_sel   :  2 ; /* bits 2:1 */
    ca_uint32_t ilpb_ing_fltr_ena    :  1 ; /* bits 3:3 */
    ca_uint32_t ilpb_default_cos     :  3 ; /* bits 6:4 */
    ca_uint32_t ilpb_cos_control_bm  :  3 ; /* bits 9:7 */
    ca_uint32_t ilpb_cos_mode_sel    :  3 ; /* bits 12:10 */
    ca_uint32_t ilpb_default_dscp    :  6 ; /* bits 18:13 */
    ca_uint32_t ilpb_dscp_mark_control_bm :  4 ; /* bits 22:19 */
    ca_uint32_t ilpb_dscp_mode_sel   :  2 ; /* bits 24:23 */
    ca_uint32_t ilpb_dscp_markdown_en :  1 ; /* bits 25:25 */
    ca_uint32_t ilpb_default_802_1p  :  3 ; /* bits 28:26 */
    ca_uint32_t ilpb_inner_802_1p_mode_sel :  2 ; /* bits 30:29 */
    ca_uint32_t ilpb_802_1p_mark_control_bm :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DPB_ACCESS                       0xf43011fc
#define L2FE_PP_DPB_ACCESS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DPB_DATA                         0xf4301200
#define L2FE_PP_DPB_DATA_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t bypass               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPKTP_ACCESS                     0xf4301204
#define L2FE_PP_SPKTP_ACCESS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPKTP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_SPKTP_DATA                       0xf4301208
#define L2FE_PP_SPKTP_DATA_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t encode               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPKTP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HTTP_LINK_0                      0xf430120c
#define L2FE_PP_HTTP_LINK_0_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HTTP_LINK_1                      0xf4301210
#define L2FE_PP_HTTP_LINK_1_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_HTTP_LINK_2                      0xf4301214
#define L2FE_PP_HTTP_LINK_2_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ARP_FILTER_ADDR                  0xf4301218
#define L2FE_PP_ARP_FILTER_ADDR_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tip                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ARP_FILTER_ADDR_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_ARP_FILTER_MSK                   0xf430121c
#define L2FE_PP_ARP_FILTER_MSK_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ARP_FILTER_MSK_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_0                        0xf4301220
#define L2FE_PP_DOS_ATK_0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_1                        0xf4301224
#define L2FE_PP_DOS_ATK_1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_2                        0xf4301228
#define L2FE_PP_DOS_ATK_2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_3                        0xf430122c
#define L2FE_PP_DOS_ATK_3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_4                        0xf4301230
#define L2FE_PP_DOS_ATK_4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_FLOOD_CNT                0xf4301234
#define L2FE_PP_DOS_ATK_FLOOD_CNT_dft            0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_FLOOD_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PP_DOS_ATK_EVENT_TRAP               0xf4301238
#define L2FE_PP_DOS_ATK_EVENT_TRAP_dft           0x00000210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DOS_ATK_EVENT_TRAP_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PP */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_PP_PPID_ATTR_CFG_t                  PPID_ATTR_CFG;                 /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_PP_DPB_CTRL_t                       DPB_CTRL;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_PP_TPID_CMP_S_t                     TPID_CMP_S;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_PP_TPID_CMP_C_t                     TPID_CMP_C;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_PP_TPID_CMP_O_t                     TPID_CMP_O;                    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_PP_TPID_CMP_USER_t                  TPID_CMP_USER;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t        HELLO_PKT_ENABLE_DA_LOW;       /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t         HELLO_PKT_ENABLE_DA_HI;        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_PP_HELLO_PKT_DA_LOW_t               HELLO_PKT_DA_LOW;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_PP_HELLO_PKT_DA_HI_t                HELLO_PKT_DA_HI;               /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t        SPECIAL_ENABLE_DA_0_LOW;       /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t         SPECIAL_ENABLE_DA_0_HI;        /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2FE_PP_SPECIAL_DA_0_LOW_t               SPECIAL_DA_0_LOW;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2FE_PP_SPECIAL_DA_0_HI_t                SPECIAL_DA_0_HI;               /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2FE_PP_SPECIAL_EV2PT_t                  SPECIAL_EV2PT;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t        SPECIAL_ENABLE_DA_1_LOW;       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t         SPECIAL_ENABLE_DA_1_HI;        /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2FE_PP_SPECIAL_DA_1_LOW_t               SPECIAL_DA_1_LOW;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2FE_PP_SPECIAL_DA_1_HI_t                SPECIAL_DA_1_HI;               /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2FE_PP_SPECIAL_VLAN_t                   SPECIAL_VLAN;                  /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2FE_PP_MY_MAC_LOW_t                     MY_MAC_LOW;                    /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2FE_PP_MY_MAC_HI_t                      MY_MAC_HI;                     /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2FE_PP_MY_MAC_ENABLE_LOW_t              MY_MAC_ENABLE_LOW;             /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L2FE_PP_MY_MAC_LOW_1_t                   MY_MAC_LOW_1;                  /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L2FE_PP_MY_MAC_HI_1_t                    MY_MAC_HI_1;                   /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L2FE_PP_MY_MAC_ENABLE_LOW_1_t            MY_MAC_ENABLE_LOW_1;           /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  L2FE_PP_RSV_MAC_MC_LOW_t                 RSV_MAC_MC_LOW;                /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  L2FE_PP_RSV_MAC_MC_HI_t                  RSV_MAC_MC_HI;                 /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  L2FE_PP_RSV_ENABLE_MC_LOW_t              RSV_ENABLE_MC_LOW;             /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  L2FE_PP_RSV_ENABLE_MC_HI_t               RSV_ENABLE_MC_HI;              /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  L2FE_PP_RSV_GROUP_MAC_LOW_t              RSV_GROUP_MAC_LOW;             /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  L2FE_PP_RSV_GROUP_MAC_HI_t               RSV_GROUP_MAC_HI;              /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  L2FE_PP_RSV_GROUP_ENABLE_LOW_t           RSV_GROUP_ENABLE_LOW;          /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  L2FE_PP_RSV_GROUP_ENABLE_HI_t            RSV_GROUP_ENABLE_HI;           /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  L2FE_PP_MEF_OAM_MAC_0_LOW_t              MEF_OAM_MAC_0_LOW;             /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];
  L2FE_PP_MEF_OAM_MAC_0_HI_t               MEF_OAM_MAC_0_HI;              /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];
  L2FE_PP_MEF_OAM_TYPE_0_t                 MEF_OAM_TYPE_0;                /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];
  L2FE_PP_MEF_OAM_MAC_1_LOW_t              MEF_OAM_MAC_1_LOW;             /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];
  L2FE_PP_MEF_OAM_MAC_1_HI_t               MEF_OAM_MAC_1_HI;              /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];
  L2FE_PP_MEF_OAM_TYPE_1_t                 MEF_OAM_TYPE_1;                /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];
  L2FE_PP_L7_OFFSET_t                      L7_OFFSET;                     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];
  L2FE_PP_NI_INTF_ERR_STTS_0_t             NI_INTF_ERR_STTS_0;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];
  L2FE_PP_NI_INTF_ERR_STTS_1_t             NI_INTF_ERR_STTS_1;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];
  L2FE_PP_NI_INTF_ERR_STTS_2_t             NI_INTF_ERR_STTS_2;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];
  L2FE_PP_NI_INTF_ERR_STTS_3_t             NI_INTF_ERR_STTS_3;            /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];
  L2FE_PP_PINGPONG_STS_t                   PINGPONG_STS;                  /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];
  L2FE_PP_NI_INTF_STS_t                    NI_INTF_STS;                   /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];
  L2FE_PP_NI_INTF_DROP_CNT_t               NI_INTF_DROP_CNT;              /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];
  L2FE_PP_NI_INTF_PKT_CNT_t                NI_INTF_PKT_CNT;               /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];
  L2FE_PP_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];
  L2FE_PP_HEADER_A_MID_t                   HEADER_A_MID;                  /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];
  L2FE_PP_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];
  L2FE_PP_PARSER_CTRL_t                    PARSER_CTRL;                   /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];
  L2FE_PP_SPECIAL_PKT_t                    SPECIAL_PKT;                   /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];
  L2FE_PP_DEBUG_BUS_t                      DEBUG_BUS;                     /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];
  L2FE_PP_IPPB_ACCESS_t                    IPPB_ACCESS;                   /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];
  L2FE_PP_IPPB_DATA_t                      IPPB_DATA;                     /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];
  L2FE_PP_ILPB_ACCESS_t                    ILPB_ACCESS;                   /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];
  L2FE_PP_ILPB_DATA4_t                     ILPB_DATA4;                    /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];
  L2FE_PP_ILPB_DATA3_t                     ILPB_DATA3;                    /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];
  L2FE_PP_ILPB_DATA2_t                     ILPB_DATA2;                    /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];
  L2FE_PP_ILPB_DATA1_t                     ILPB_DATA1;                    /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];
  L2FE_PP_ILPB_DATA0_t                     ILPB_DATA0;                    /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];
  L2FE_PP_DPB_ACCESS_t                     DPB_ACCESS;                    /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];
  L2FE_PP_DPB_DATA_t                       DPB_DATA;                      /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];
  L2FE_PP_SPKTP_ACCESS_t                   SPKTP_ACCESS;                  /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];
  L2FE_PP_SPKTP_DATA_t                     SPKTP_DATA;                    /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];
  L2FE_PP_HTTP_LINK_0_t                    HTTP_LINK_0;                   /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];
  L2FE_PP_HTTP_LINK_1_t                    HTTP_LINK_1;                   /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];
  L2FE_PP_HTTP_LINK_2_t                    HTTP_LINK_2;                   /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];
  L2FE_PP_ARP_FILTER_ADDR_t                ARP_FILTER_ADDR;               /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];
  L2FE_PP_ARP_FILTER_MSK_t                 ARP_FILTER_MSK;                /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];
  L2FE_PP_DOS_ATK_0_t                      DOS_ATK_0;                     /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];
  L2FE_PP_DOS_ATK_1_t                      DOS_ATK_1;                     /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];
  L2FE_PP_DOS_ATK_2_t                      DOS_ATK_2;                     /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];
  L2FE_PP_DOS_ATK_3_t                      DOS_ATK_3;                     /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];
  L2FE_PP_DOS_ATK_4_t                      DOS_ATK_4;                     /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];
  L2FE_PP_DOS_ATK_FLOOD_CNT_t              DOS_ATK_FLOOD_CNT;             /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];
  L2FE_PP_DOS_ATK_EVENT_TRAP_t             DOS_ATK_EVENT_TRAP;            /* addr: 0x00000138 */
} APB0_L2FE_PP_t;
#endif /* !__ASSEMBLER__ */


/*
 * PLA
 */

#define L2FE_PLA_DEBUG_BUS                       0xf4301300
#define L2FE_PLA_DEBUG_BUS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_EV2_PT_CNVT_ACCESS              0xf4301304
#define L2FE_PLA_EV2_PT_CNVT_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_EV2_PT_CNVT_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_EV2_PT_CNVT_DATA                0xf4301308
#define L2FE_PLA_EV2_PT_CNVT_DATA_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ev2_pt_cnvt_encoded_value :  5 ; /* bits 4:0 */
    ca_uint32_t ev2_pt_cnvt_ethertype : 16 ; /* bits 20:5 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_EV2_PT_CNVT_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_SPB_ACCESS                      0xf430130c
#define L2FE_PLA_SPB_ACCESS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_SPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_SPB_DATA                        0xf4301310
#define L2FE_PLA_SPB_DATA_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spb_pkt_no_edit      :  1 ; /* bits 0:0 */
    ca_uint32_t spb_keep_ts          :  1 ; /* bits 1:1 */
    ca_uint32_t spb_bypass_sa_lrn_chk :  1 ; /* bits 2:2 */
    ca_uint32_t spb_limit_fwd_permit :  1 ; /* bits 3:3 */
    ca_uint32_t spb_learn_dis        :  1 ; /* bits 4:4 */
    ca_uint32_t spb_grpid_en         :  1 ; /* bits 5:5 */
    ca_uint32_t spb_flowid           : 12 ; /* bits 17:6 */
    ca_uint32_t spb_flow_en          :  1 ; /* bits 18:18 */
    ca_uint32_t spb_rate_limit_bypass :  1 ; /* bits 19:19 */
    ca_uint32_t spb_cos              :  3 ; /* bits 22:20 */
    ca_uint32_t spb_ldpid            :  6 ; /* bits 28:23 */
    ca_uint32_t spb_spcl_fwd         :  1 ; /* bits 29:29 */
    ca_uint32_t spb_pkt_no_drop      :  1 ; /* bits 30:30 */
    ca_uint32_t spb_hash_cllsn_fwd_permit :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_SPB_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_DOT1P_MAP_ACCESS                0xf4301314
#define L2FE_PLA_DOT1P_MAP_ACCESS_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DOT1P_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_DOT1P_MAP_DATA                  0xf4301318
#define L2FE_PLA_DOT1P_MAP_DATA_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p_map_mapped_premark :  1 ; /* bits 0:0 */
    ca_uint32_t dot1p_map_mapped_cos :  3 ; /* bits 3:1 */
    ca_uint32_t dot1p_map_mapped_1p  :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DOT1P_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_DSCP_MAP_ACCESS                 0xf430131c
#define L2FE_PLA_DSCP_MAP_ACCESS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DSCP_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLA_DSCP_MAP_DATA                   0xf4301320
#define L2FE_PLA_DSCP_MAP_DATA_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mapped_premark       :  1 ; /* bits 0:0 */
    ca_uint32_t dscp_map_mapped_cos  :  3 ; /* bits 3:1 */
    ca_uint32_t dscp_map_marked_flag :  1 ; /* bits 4:4 */
    ca_uint32_t dscp_map_mapped_dscp :  6 ; /* bits 10:5 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DSCP_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLA */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_PLA_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_PLA_EV2_PT_CNVT_ACCESS_t            EV2_PT_CNVT_ACCESS;            /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_PLA_EV2_PT_CNVT_DATA_t              EV2_PT_CNVT_DATA;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_PLA_SPB_ACCESS_t                    SPB_ACCESS;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_PLA_SPB_DATA_t                      SPB_DATA;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_PLA_DOT1P_MAP_ACCESS_t              DOT1P_MAP_ACCESS;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_PLA_DOT1P_MAP_DATA_t                DOT1P_MAP_DATA;                /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_PLA_DSCP_MAP_ACCESS_t               DSCP_MAP_ACCESS;               /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_PLA_DSCP_MAP_DATA_t                 DSCP_MAP_DATA;                 /* addr: 0x00000020 */
} APB0_L2FE_PLA_t;
#endif /* !__ASSEMBLER__ */


/*
 * PLC
 */

#define L2FE_PLC_HASH_CTRL                       0xf4301400
#define L2FE_PLC_HASH_CTRL_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lan_sa_hashing_vid_sel :  1 ; /* bits 0:0 */
    ca_uint32_t lan_da_hashing_vid_sel :  1 ; /* bits 1:1 */
    ca_uint32_t lan_sa_learning_vid_sel :  1 ; /* bits 2:2 */
    ca_uint32_t wan_sa_hashing_vid_sel :  1 ; /* bits 3:3 */
    ca_uint32_t wan_da_hashing_vid_sel :  1 ; /* bits 4:4 */
    ca_uint32_t wan_sa_learning_vid_sel :  1 ; /* bits 5:5 */
    ca_uint32_t use_dot1p_l2e        :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_HASH_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_DPID_FWD_CTRL                   0xf4301404
#define L2FE_PLC_DPID_FWD_CTRL_dft               0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vid_fff_fwd          :  1 ; /* bits 0:0 */
    ca_uint32_t unkvlan_fwd          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_DPID_FWD_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_LRN_FWD_CTRL_0                  0xf4301408
#define L2FE_PLC_LRN_FWD_CTRL_0_dft              0x02000210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2_mac_sw_lrn_ldpid  :  6 ; /* bits 5:0 */
    ca_uint32_t l2_mac_sw_lrn_cos    :  3 ; /* bits 8:6 */
    ca_uint32_t l2_mac_sw_lrn_keep_old_wan :  1 ; /* bits 9:9 */
    ca_uint32_t l2_mac_sw_lrn_keep_old_lan :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t sa_miss_fwd          :  1 ; /* bits 25:25 */
    ca_uint32_t nonstd_sa_all_zero_fwd :  1 ; /* bits 26:26 */
    ca_uint32_t nonstd_sa_all_one_fwd :  1 ; /* bits 27:27 */
    ca_uint32_t nonstd_sa_b40_is_one_fwd :  1 ; /* bits 28:28 */
    ca_uint32_t sm_static_entry_fwd  :  1 ; /* bits 29:29 */
    ca_uint32_t sm_tmp_entry_fwd     :  1 ; /* bits 30:30 */
    ca_uint32_t sm_sm_entry_fwd      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_LRN_FWD_CTRL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_LRN_FWD_CTRL_1                  0xf430140c
#define L2FE_PLC_LRN_FWD_CTRL_1_dft              0x08100810

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sa_limit_excd_ldpid  :  6 ; /* bits 5:0 */
    ca_uint32_t sa_limit_excd_cos    :  3 ; /* bits 8:6 */
    ca_uint32_t sa_limit_excd_fwd_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t sa_limit_excd_keep_old_wan :  1 ; /* bits 11:11 */
    ca_uint32_t sa_limit_excd_keep_old_lan :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t sa_hash_cllsn_ldpid  :  6 ; /* bits 21:16 */
    ca_uint32_t sa_hash_cllsn_cos    :  3 ; /* bits 24:22 */
    ca_uint32_t sa_hash_cllsn_fwd_ctrl :  2 ; /* bits 26:25 */
    ca_uint32_t sa_hash_cllsn_keep_old_wan :  1 ; /* bits 27:27 */
    ca_uint32_t sa_hash_cllsn_keep_old_lan :  1 ; /* bits 28:28 */
    ca_uint32_t swlrn_othr_pkt_fwd   :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_LRN_FWD_CTRL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_L2_LEARNING_CTRL                0xf4301410
#define L2FE_PLC_L2_LEARNING_CTRL_dft            0x00000046

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unkvlan_learn        :  1 ; /* bits 0:0 */
    ca_uint32_t unk_ethtype_no_learn :  1 ; /* bits 1:1 */
    ca_uint32_t igr_dropped_pkt_no_learn :  1 ; /* bits 2:2 */
    ca_uint32_t non_std_sa_all_zero_learn :  1 ; /* bits 3:3 */
    ca_uint32_t non_std_sa_all_one_learn :  1 ; /* bits 4:4 */
    ca_uint32_t non_std_sa_b40_is_one_learn :  1 ; /* bits 5:5 */
    ca_uint32_t loop_pkt_no_learn    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_L2_LEARNING_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_VLAN_MODE_CTRL                  0xf4301414
#define L2FE_PLC_VLAN_MODE_CTRL_dft              0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2e_glb_vlan_mode    :  1 ; /* bits 0:0 */
    ca_uint32_t en_fdb_vlan_pre_rslt :  1 ; /* bits 1:1 */
    ca_uint32_t en_egr_ptag_lkup_egr_ve :  1 ; /* bits 2:2 */
    ca_uint32_t en_mc_pkt_lkup_elpb  :  1 ; /* bits 3:3 */
    ca_uint32_t lan_src_usel2_vlan   :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_VLAN_MODE_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_SA_CHK_CTL                      0xf4301418
#define L2FE_PLC_SA_CHK_CTL_dft                  0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t skip_sa_chk          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_SA_CHK_CTL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_DEBUG                           0xf430141c
#define L2FE_PLC_DEBUG_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_DEBUG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_ELPB_ACCESS                     0xf4301420
#define L2FE_PLC_ELPB_ACCESS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_ELPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_ELPB_DATA1                      0xf4301424
#define L2FE_PLC_ELPB_DATA1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t elpb_802_1p_mark_control_bm :  3 ; /* bits 2:0 */
    ca_uint32_t elpb_change_1p_if_pop :  1 ; /* bits 3:3 */
    ca_uint32_t elpb_top_802_1p_mode_sel :  2 ; /* bits 5:4 */
    ca_uint32_t elpb_802_1p_ctrl_sel :  1 ; /* bits 6:6 */
    ca_uint32_t elpb_use_tx_vlan_lkup_acl :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_ELPB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLC_ELPB_DATA0                      0xf4301428
#define L2FE_PLC_ELPB_DATA0_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t elpb_egr_vlan_aware_mode :  1 ; /* bits 0:0 */
    ca_uint32_t elpb_egr_port_stp_status :  1 ; /* bits 1:1 */
    ca_uint32_t elpb_egr_ve_srch_en  :  1 ; /* bits 2:2 */
    ca_uint32_t elpb_egr_dest_wan    :  1 ; /* bits 3:3 */
    ca_uint32_t elpb_egr_cls_length  :  6 ; /* bits 9:4 */
    ca_uint32_t elpb_egr_cls_start   :  8 ; /* bits 17:10 */
    ca_uint32_t elpb_egr_cls_lookup_en :  1 ; /* bits 18:18 */
    ca_uint32_t elpb_egr_cls_flowid_sel :  1 ; /* bits 19:19 */
    ca_uint32_t elpb_egr_cls_cos_sel :  1 ; /* bits 20:20 */
    ca_uint32_t elpb_dscp_mark_control_bm :  4 ; /* bits 24:21 */
    ca_uint32_t elpb_dscp_mode_sel   :  2 ; /* bits 26:25 */
    ca_uint32_t elpb_dscp_ctrl_sel   :  1 ; /* bits 27:27 */
    ca_uint32_t elpb_dscp_markdown_en :  1 ; /* bits 28:28 */
    ca_uint32_t elpb_inner_802_1p_mode_sel :  2 ; /* bits 30:29 */
    ca_uint32_t elpb_802_1p_mark_control_bm :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_ELPB_DATA0_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLC */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_PLC_HASH_CTRL_t                     HASH_CTRL;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_PLC_DPID_FWD_CTRL_t                 DPID_FWD_CTRL;                 /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_PLC_LRN_FWD_CTRL_0_t                LRN_FWD_CTRL_0;                /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_PLC_LRN_FWD_CTRL_1_t                LRN_FWD_CTRL_1;                /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_PLC_L2_LEARNING_CTRL_t              L2_LEARNING_CTRL;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_PLC_VLAN_MODE_CTRL_t                VLAN_MODE_CTRL;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_PLC_SA_CHK_CTL_t                    SA_CHK_CTL;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_PLC_DEBUG_t                         DEBUG;                         /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_PLC_ELPB_ACCESS_t                   ELPB_ACCESS;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_PLC_ELPB_DATA1_t                    ELPB_DATA1;                    /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_PLC_ELPB_DATA0_t                    ELPB_DATA0;                    /* addr: 0x00000028 */
} APB0_L2FE_PLC_t;
#endif /* !__ASSEMBLER__ */


/*
 * PLE
 */

#define L2FE_PLE_CTL_REG                         0xf4301500
#define L2FE_PLE_CTL_REG_dft                     0x00000260

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t txvlan_membshp_chk_en_lan :  1 ; /* bits 0:0 */
    ca_uint32_t txvlan_membshp_chk_en_wan :  1 ; /* bits 1:1 */
    ca_uint32_t cos_l3_only          :  1 ; /* bits 2:2 */
    ca_uint32_t skip_port_lpbk_chk   :  1 ; /* bits 3:3 */
    ca_uint32_t pon_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t igr_fltr_chk_ldpid   :  1 ; /* bits 5:5 */
    ca_uint32_t egr_fltr_chk_lspid   :  1 ; /* bits 6:6 */
    ca_uint32_t use_gemid_mapped_from_txdot1p :  1 ; /* bits 7:7 */
    ca_uint32_t wan_dst_acl_vlan_en  :  1 ; /* bits 8:8 */
    ca_uint32_t use_rx_dscp_map_cos  :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_CTL_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_DEFAULT_REG                     0xf4301504
#define L2FE_PLE_DEFAULT_REG_dft                 0x001b0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dflt_flow_en         :  1 ; /* bits 0:0 */
    ca_uint32_t dflt_flowid          : 12 ; /* bits 12:1 */
    ca_uint32_t dflt_markdown_en     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t dflt_mc_pid          :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DEFAULT_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_RX_UNKWN_VLAN_DFT               0xf4301508
#define L2FE_PLE_RX_UNKWN_VLAN_DFT_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t memshp_bm            : 16 ; /* bits 15:0 */
    ca_uint32_t vl_grp_id            : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_RX_UNKWN_VLAN_DFT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_UNKWN_VLAN_DFT_1             0xf430150c
#define L2FE_PLE_TX_UNKWN_VLAN_DFT_1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stp_mode             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_UNKWN_VLAN_DFT_2             0xf4301510
#define L2FE_PLE_TX_UNKWN_VLAN_DFT_2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t memshp_bm            : 16 ; /* bits 15:0 */
    ca_uint32_t untag_bm             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_CTRL_0                0xf4301514
#define L2FE_PLE_TRUNK_GRP_CTRL_0_dft            0x00000012

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t trunk_hash_field_sel_mac_sa :  1 ; /* bits 0:0 */
    ca_uint32_t trunk_hash_field_sel_mac_da :  1 ; /* bits 1:1 */
    ca_uint32_t trunk_hash_field_sel_tx_top_vid :  1 ; /* bits 2:2 */
    ca_uint32_t trunk_hash_field_sel_ip_sa :  1 ; /* bits 3:3 */
    ca_uint32_t trunk_hash_field_sel_ip_da :  1 ; /* bits 4:4 */
    ca_uint32_t trunk_hash_field_sel_l4_sp :  1 ; /* bits 5:5 */
    ca_uint32_t trunk_hash_field_sel_l4_dp :  1 ; /* bits 6:6 */
    ca_uint32_t trunk_hash_field_sel_cos :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_CTRL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_0_MEMBER_0            0xf4301518
#define L2FE_PLE_TRUNK_GRP_0_MEMBER_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_0_MEMBER_1            0xf430151c
#define L2FE_PLE_TRUNK_GRP_0_MEMBER_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_CTRL_1                0xf4301520
#define L2FE_PLE_TRUNK_GRP_CTRL_1_dft            0x00000012

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t trunk_hash_field_sel_mac_sa :  1 ; /* bits 0:0 */
    ca_uint32_t trunk_hash_field_sel_mac_da :  1 ; /* bits 1:1 */
    ca_uint32_t trunk_hash_field_sel_tx_top_vid :  1 ; /* bits 2:2 */
    ca_uint32_t trunk_hash_field_sel_ip_sa :  1 ; /* bits 3:3 */
    ca_uint32_t trunk_hash_field_sel_ip_da :  1 ; /* bits 4:4 */
    ca_uint32_t trunk_hash_field_sel_l4_sp :  1 ; /* bits 5:5 */
    ca_uint32_t trunk_hash_field_sel_l4_dp :  1 ; /* bits 6:6 */
    ca_uint32_t trunk_hash_field_sel_cos :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_CTRL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_1_MEMBER_0            0xf4301524
#define L2FE_PLE_TRUNK_GRP_1_MEMBER_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_GRP_1_MEMBER_1            0xf4301528
#define L2FE_PLE_TRUNK_GRP_1_MEMBER_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_HD_FF_CTL_REG                   0xf430152c
#define L2FE_PLE_HD_FF_CTL_REG_dft               0x00000610

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_thr              :  6 ; /* bits 5:0 */
    ca_uint32_t high_thr             :  6 ; /* bits 11:6 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_HD_FF_STS_REG                   0xf4301530
#define L2FE_PLE_HD_FF_STS_REG_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_HD_FF_HDR_CNT                   0xf4301534
#define L2FE_PLE_HD_FF_HDR_CNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_HDR_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IP_CTRL           0xf4301538
#define L2FE_PLE_MC_WELL_KNOWN_IP_CTRL_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ipv6_sub_mask        :  8 ; /* bits 7:0 */
    ca_uint32_t ipv6_prog_addr_vld   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ipv4_sub_mask        :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ipv4_prog_addr_vld   :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IP_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV4              0xf430153c
#define L2FE_PLE_MC_WELL_KNOWN_IPV4_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV6_3            0xf4301540
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV6_2            0xf4301544
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV6_1            0xf4301548
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MC_WELL_KNOWN_IPV6_0            0xf430154c
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_DEBUG_BUS                       0xf4301550
#define L2FE_PLE_DEBUG_BUS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_DSCP_MAP_ACCESS              0xf4301554
#define L2FE_PLE_TX_DSCP_MAP_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DSCP_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_DSCP_MAP_DATA                0xf4301558
#define L2FE_PLE_TX_DSCP_MAP_DATA_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t txdscp_map_mapped_cos :  3 ; /* bits 2:0 */
    ca_uint32_t txdscp_map_mapped_1p :  3 ; /* bits 5:3 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DSCP_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_DOT1P_MAP_ACCESS             0xf430155c
#define L2FE_PLE_TX_DOT1P_MAP_ACCESS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DOT1P_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TX_DOT1P_MAP_DATA               0xf4301560
#define L2FE_PLE_TX_DOT1P_MAP_DATA_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t txdot1p_map_mapped_cos :  3 ; /* bits 2:0 */
    ca_uint32_t txdot1p_map_mapped_cos_wan :  3 ; /* bits 5:3 */
    ca_uint32_t gem_id_vld_wan       :  1 ; /* bits 6:6 */
    ca_uint32_t gem_id_wan           :  7 ; /* bits 13:7 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DOT1P_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_DFT_FWD_ACCESS                  0xf4301564
#define L2FE_PLE_DFT_FWD_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DFT_FWD_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_DFT_FWD_DATA                    0xf4301568
#define L2FE_PLE_DFT_FWD_DATA_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dft_fwd_deny         :  1 ; /* bits 0:0 */
    ca_uint32_t dft_fwd_mc_group_id  : 10 ; /* bits 10:1 */
    ca_uint32_t dft_fwd_redir_en     :  1 ; /* bits 11:11 */
    ca_uint32_t dft_fwd_mc_group_id_valid :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DFT_FWD_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS         0xf430156c
#define L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_MMSHP_CHK_ID_MAP_DATA           0xf4301570
#define L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mmshp_chk_id_map_chk_id :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_PORT_MMSHP_CHK_ACCESS           0xf4301574
#define L2FE_PLE_PORT_MMSHP_CHK_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_PORT_MMSHP_CHK_DATA1            0xf4301578
#define L2FE_PLE_PORT_MMSHP_CHK_DATA1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_bm             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_PORT_MMSHP_CHK_DATA0            0xf430157c
#define L2FE_PLE_PORT_MMSHP_CHK_DATA0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_bm             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS       0xf4301580
#define L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA         0xf4301584
#define L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLE */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_PLE_CTL_REG_t                       CTL_REG;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_PLE_DEFAULT_REG_t                   DEFAULT_REG;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_PLE_RX_UNKWN_VLAN_DFT_t             RX_UNKWN_VLAN_DFT;             /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t           TX_UNKWN_VLAN_DFT_1;           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t           TX_UNKWN_VLAN_DFT_2;           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_PLE_TRUNK_GRP_CTRL_0_t              TRUNK_GRP_CTRL_0;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t          TRUNK_GRP_0_MEMBER_0;          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t          TRUNK_GRP_0_MEMBER_1;          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_PLE_TRUNK_GRP_CTRL_1_t              TRUNK_GRP_CTRL_1;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t          TRUNK_GRP_1_MEMBER_0;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t          TRUNK_GRP_1_MEMBER_1;          /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2FE_PLE_HD_FF_CTL_REG_t                 HD_FF_CTL_REG;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2FE_PLE_HD_FF_STS_REG_t                 HD_FF_STS_REG;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2FE_PLE_HD_FF_HDR_CNT_t                 HD_FF_HDR_CNT;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2FE_PLE_MC_WELL_KNOWN_IP_CTRL_t         MC_WELL_KNOWN_IP_CTRL;         /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2FE_PLE_MC_WELL_KNOWN_IPV4_t            MC_WELL_KNOWN_IPV4;            /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2FE_PLE_MC_WELL_KNOWN_IPV6_3_t          MC_WELL_KNOWN_IPV6_3;          /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2FE_PLE_MC_WELL_KNOWN_IPV6_2_t          MC_WELL_KNOWN_IPV6_2;          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2FE_PLE_MC_WELL_KNOWN_IPV6_1_t          MC_WELL_KNOWN_IPV6_1;          /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2FE_PLE_MC_WELL_KNOWN_IPV6_0_t          MC_WELL_KNOWN_IPV6_0;          /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2FE_PLE_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2FE_PLE_TX_DSCP_MAP_ACCESS_t            TX_DSCP_MAP_ACCESS;            /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2FE_PLE_TX_DSCP_MAP_DATA_t              TX_DSCP_MAP_DATA;              /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L2FE_PLE_TX_DOT1P_MAP_ACCESS_t           TX_DOT1P_MAP_ACCESS;           /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L2FE_PLE_TX_DOT1P_MAP_DATA_t             TX_DOT1P_MAP_DATA;             /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L2FE_PLE_DFT_FWD_ACCESS_t                DFT_FWD_ACCESS;                /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  L2FE_PLE_DFT_FWD_DATA_t                  DFT_FWD_DATA;                  /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t       MMSHP_CHK_ID_MAP_ACCESS;       /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t         MMSHP_CHK_ID_MAP_DATA;         /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t         PORT_MMSHP_CHK_ACCESS;         /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  L2FE_PLE_PORT_MMSHP_CHK_DATA1_t          PORT_MMSHP_CHK_DATA1;          /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  L2FE_PLE_PORT_MMSHP_CHK_DATA0_t          PORT_MMSHP_CHK_DATA0;          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t     TRUNK_DEST_MAP_TBL_ACCESS;     /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t       TRUNK_DEST_MAP_TBL_DATA;       /* addr: 0x00000084 */
} APB0_L2FE_PLE_t;
#endif /* !__ASSEMBLER__ */


/*
 * ARB
 */

#define L2FE_ARB_ARB_CTRL                        0xf4301600
#define L2FE_ARB_ARB_CTRL_dft                    0x09c71d80

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t drop_redir_keep_old  :  1 ; /* bits 0:0 */
    ca_uint32_t dbuf_sel             :  1 ; /* bits 1:1 */
    ca_uint32_t ip_ecn_en            :  1 ; /* bits 2:2 */
    ca_uint32_t mc_idx_copy_en       :  1 ; /* bits 3:3 */
    ca_uint32_t dbuf_dpid            :  4 ; /* bits 7:4 */
    ca_uint32_t use_hdr_a_dbuf_en    :  1 ; /* bits 8:8 */
    ca_uint32_t dst_wan_dync_buf_sel :  1 ; /* bits 9:9 */
    ca_uint32_t wan_lpid             :  6 ; /* bits 15:10 */
    ca_uint32_t wan_ext_lpid         :  6 ; /* bits 21:16 */
    ca_uint32_t tm_wan_dpid          :  4 ; /* bits 25:22 */
    ca_uint32_t tqm_port7_empty_wait_cnt_h :  5 ; /* bits 30:26 */
    ca_uint32_t keep_o_lspid_en_for_mc :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PER_COS_DONT_MARK_CTRL          0xf4301604
#define L2FE_ARB_PER_COS_DONT_MARK_CTRL_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bitmap_dst_lan       :  8 ; /* bits 7:0 */
    ca_uint32_t bitmap_dst_wan       :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PER_COS_DONT_MARK_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_TTL_TRAP                    0xf4301608
#define L2FE_ARB_ARB_TTL_TRAP_dft                0x00000280

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t keep_old             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_TTL_TRAP_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_CTRL_EXT                    0xf430160c
#define L2FE_ARB_ARB_CTRL_EXT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mc_pkt_port_mmshp_chk_en :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_CTRL_EXT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_ARB_DEBUG                       0xf4301610
#define L2FE_ARB_ARB_DEBUG_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_DEBUG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS   0xf4301614
#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA     0xf4301618
#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_cos_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 9:4 */
    ca_uint32_t rdir_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rdir_wan_dst         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS 0xf430161c
#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA  0xf4301620
#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_cos_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 9:4 */
    ca_uint32_t rdir_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rdir_wan_dst         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS    0xf4301624
#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA      0xf4301628
#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flooding_pol_id      :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS         0xf430162c
#define L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_DSCP_TE_MARK_TBL_DATA           0xf4301630
#define L2FE_ARB_DSCP_TE_MARK_TBL_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mark_value           :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_ACCESS               0xf4301634
#define L2FE_ARB_MC_FIB_TBL_ACCESS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_DATA2                0xf4301638
#define L2FE_ARB_MC_FIB_TBL_DATA2_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t permit_spid_en       :  1 ; /* bits 0:0 */
    ca_uint32_t mac_sa_cmd           :  1 ; /* bits 1:1 */
    ca_uint32_t mac_sa_sel           :  3 ; /* bits 4:2 */
    ca_uint32_t cos                  :  3 ; /* bits 7:5 */
    ca_uint32_t ip_ttl_zero_fwd_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t ip_ttl_dec_cmd       :  1 ; /* bits 10:10 */
    ca_uint32_t keep_o_lspid         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_DATA1                0xf430163c
#define L2FE_ARB_MC_FIB_TBL_DATA1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t s_vlan_cmd           :  2 ; /* bits 1:0 */
    ca_uint32_t s_vid                : 12 ; /* bits 13:2 */
    ca_uint32_t s_tpid_cmd           :  1 ; /* bits 14:14 */
    ca_uint32_t s_tpid_sel           :  2 ; /* bits 16:15 */
    ca_uint32_t dot1p_cmd            :  2 ; /* bits 18:17 */
    ca_uint32_t dot1p                :  3 ; /* bits 21:19 */
    ca_uint32_t dei_cmd              :  1 ; /* bits 22:22 */
    ca_uint32_t dei                  :  1 ; /* bits 23:23 */
    ca_uint32_t ldpid                :  6 ; /* bits 29:24 */
    ca_uint32_t cos_cmd              :  1 ; /* bits 30:30 */
    ca_uint32_t wan_dst              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_MC_FIB_TBL_DATA0                0xf4301640
#define L2FE_ARB_MC_FIB_TBL_DATA0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t c_vlan_cmd           :  2 ; /* bits 1:0 */
    ca_uint32_t c_vid                : 12 ; /* bits 13:2 */
    ca_uint32_t c_tpid_cmd           :  1 ; /* bits 14:14 */
    ca_uint32_t c_tpid_sel           :  1 ; /* bits 15:15 */
    ca_uint32_t c_dot1p_cmd          :  2 ; /* bits 17:16 */
    ca_uint32_t c_dot1p              :  3 ; /* bits 20:18 */
    ca_uint32_t c_dei_cmd            :  1 ; /* bits 21:21 */
    ca_uint32_t c_dei                :  1 ; /* bits 22:22 */
    ca_uint32_t pol_id               :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_FLOW_DBUF_TBL_ACCESS            0xf4301644
#define L2FE_ARB_FLOW_DBUF_TBL_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_FLOW_DBUF_TBL_DATA              0xf4301648
#define L2FE_ARB_FLOW_DBUF_TBL_DATA_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dbuf_flg_0           :  1 ; /* bits 0:0 */
    ca_uint32_t dbuf_flg_1           :  1 ; /* bits 1:1 */
    ca_uint32_t dbuf_flg_2           :  1 ; /* bits 2:2 */
    ca_uint32_t dbuf_flg_3           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_FLOW_DBUF_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PORT_DBUF_TBL_ACCESS            0xf430164c
#define L2FE_ARB_PORT_DBUF_TBL_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PORT_DBUF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PORT_DBUF_TBL_DATA              0xf4301650
#define L2FE_ARB_PORT_DBUF_TBL_DATA_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dbuf_flg             :  1 ; /* bits 0:0 */
    ca_uint32_t ldpid_vld            :  1 ; /* bits 1:1 */
    ca_uint32_t ldpid                :  6 ; /* bits 7:2 */
    ca_uint32_t lspid_vld            :  1 ; /* bits 8:8 */
    ca_uint32_t lspid                :  6 ; /* bits 14:9 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PORT_DBUF_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PDPID_MAP_TBL_ACCESS            0xf4301654
#define L2FE_ARB_PDPID_MAP_TBL_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PDPID_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_ARB_PDPID_MAP_TBL_DATA              0xf4301658
#define L2FE_ARB_PDPID_MAP_TBL_DATA_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pdpid                :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PDPID_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ARB */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_ARB_ARB_CTRL_t                      ARB_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_ARB_PER_COS_DONT_MARK_CTRL_t        PER_COS_DONT_MARK_CTRL;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_ARB_ARB_TTL_TRAP_t                  ARB_TTL_TRAP;                  /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_ARB_ARB_CTRL_EXT_t                  ARB_CTRL_EXT;                  /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_ARB_ARB_DEBUG_t                     ARB_DEBUG;                     /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t REDIR_LDPID_CONFIG_TBL_ACCESS; /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t   REDIR_LDPID_CONFIG_TBL_DATA;   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t REDIR_DROP_SRC_CONFIG_TBL_ACCESS; /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t REDIR_DROP_SRC_CONFIG_TBL_DATA; /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t  NON_KNOWN_POL_MAP_TBL_ACCESS;  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t    NON_KNOWN_POL_MAP_TBL_DATA;    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t       DSCP_TE_MARK_TBL_ACCESS;       /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t         DSCP_TE_MARK_TBL_DATA;         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2FE_ARB_MC_FIB_TBL_ACCESS_t             MC_FIB_TBL_ACCESS;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2FE_ARB_MC_FIB_TBL_DATA2_t              MC_FIB_TBL_DATA2;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2FE_ARB_MC_FIB_TBL_DATA1_t              MC_FIB_TBL_DATA1;              /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2FE_ARB_MC_FIB_TBL_DATA0_t              MC_FIB_TBL_DATA0;              /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t          FLOW_DBUF_TBL_ACCESS;          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2FE_ARB_FLOW_DBUF_TBL_DATA_t            FLOW_DBUF_TBL_DATA;            /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2FE_ARB_PORT_DBUF_TBL_ACCESS_t          PORT_DBUF_TBL_ACCESS;          /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2FE_ARB_PORT_DBUF_TBL_DATA_t            PORT_DBUF_TBL_DATA;            /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2FE_ARB_PDPID_MAP_TBL_ACCESS_t          PDPID_MAP_TBL_ACCESS;          /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2FE_ARB_PDPID_MAP_TBL_DATA_t            PDPID_MAP_TBL_DATA;            /* addr: 0x00000058 */
} APB0_L2FE_ARB_t;
#endif /* !__ASSEMBLER__ */


/*
 * PE
 */

#define L2FE_PE_CTRL                             0xf4301700
#define L2FE_PE_CTRL_dft                         0x000000f0

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2_padding_dis       :  1 ; /* bits 0:0 */
    ca_uint32_t use_rx_bypass        :  1 ; /* bits 1:1 */
    ca_uint32_t mod_orig_tag         :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t wan_top_dei_keep_old :  1 ; /* bits 4:4 */
    ca_uint32_t lan_top_dei_keep_old :  1 ; /* bits 5:5 */
    ca_uint32_t wan_inner_dei_keep_old :  1 ; /* bits 6:6 */
    ca_uint32_t lan_inner_dei_keep_old :  1 ; /* bits 7:7 */
    ca_uint32_t enhance_tpid_mode    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CFG_VLAN_TPID_A                  0xf4301704
#define L2FE_PE_CFG_VLAN_TPID_A_dft              0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_A_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CFG_VLAN_TPID_B                  0xf4301708
#define L2FE_PE_CFG_VLAN_TPID_B_dft              0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_B_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CFG_VLAN_TPID_C                  0xf430170c
#define L2FE_PE_CFG_VLAN_TPID_C_dft              0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_C_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CFG_VLAN_TPID_D                  0xf4301710
#define L2FE_PE_CFG_VLAN_TPID_D_dft              0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_D_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_0                     0xf4301714
#define L2FE_PE_MY_MAC_LOW_0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_0                    0xf4301718
#define L2FE_PE_MY_MAC_HIGH_0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_1                     0xf430171c
#define L2FE_PE_MY_MAC_LOW_1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_1                    0xf4301720
#define L2FE_PE_MY_MAC_HIGH_1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_2                     0xf4301724
#define L2FE_PE_MY_MAC_LOW_2_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_2                    0xf4301728
#define L2FE_PE_MY_MAC_HIGH_2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_3                     0xf430172c
#define L2FE_PE_MY_MAC_LOW_3_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_3                    0xf4301730
#define L2FE_PE_MY_MAC_HIGH_3_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_4                     0xf4301734
#define L2FE_PE_MY_MAC_LOW_4_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_4                    0xf4301738
#define L2FE_PE_MY_MAC_HIGH_4_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_5                     0xf430173c
#define L2FE_PE_MY_MAC_LOW_5_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_5                    0xf4301740
#define L2FE_PE_MY_MAC_HIGH_5_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_6                     0xf4301744
#define L2FE_PE_MY_MAC_LOW_6_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_6                    0xf4301748
#define L2FE_PE_MY_MAC_HIGH_6_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_LOW_7                     0xf430174c
#define L2FE_PE_MY_MAC_LOW_7_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_MY_MAC_HIGH_7                    0xf4301750
#define L2FE_PE_MY_MAC_HIGH_7_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CMD_FF_CTL_REG                   0xf4301754
#define L2FE_PE_CMD_FF_CTL_REG_dft               0x00004343

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_thr_mir          :  4 ; /* bits 3:0 */
    ca_uint32_t high_thr_mir         :  4 ; /* bits 7:4 */
    ca_uint32_t low_thr_ppl          :  4 ; /* bits 11:8 */
    ca_uint32_t high_thr_ppl         :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CMD_FF_STS_REG                   0xf4301758
#define L2FE_PE_CMD_FF_STS_REG_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t overflow_ind_mir     :  1 ; /* bits 0:0 */
    ca_uint32_t overflow_ind_ppl     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_CMD_FF_CMD_CNT                   0xf430175c
#define L2FE_PE_CMD_FF_CMD_CNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num_mir              :  4 ; /* bits 3:0 */
    ca_uint32_t num_ppl              :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_CMD_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_TM_INTERFACE_PKT_CNT             0xf4301760
#define L2FE_PE_TM_INTERFACE_PKT_CNT_dft         0x80000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TM_INTERFACE_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_CNT_TBL_CLR                 0xf4301764
#define L2FE_PE_DROP_CNT_TBL_CLR_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t set                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_TBL_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_HEADER_A_LOW                     0xf4301768
#define L2FE_PE_HEADER_A_LOW_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_HEADER_A_MID                     0xf430176c
#define L2FE_PE_HEADER_A_MID_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_MID_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_HEADER_A_HI                      0xf4301770
#define L2FE_PE_HEADER_A_HI_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_CNT_GEAR_FF_CNT             0xf4301774
#define L2FE_PE_DROP_CNT_GEAR_FF_CNT_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_GEAR_FF_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_CNT_GEAR_FF_STS             0xf4301778
#define L2FE_PE_DROP_CNT_GEAR_FF_STS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_GEAR_FF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DEBUG                            0xf430177c
#define L2FE_PE_DEBUG_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t fe2tm_pkt_cnt_wrap_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DEBUG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_STTS_ACCESS                 0xf4301780
#define L2FE_PE_DROP_STTS_ACCESS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_STTS_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_DROP_STTS_DATA                   0xf4301784
#define L2FE_PE_DROP_STTS_DATA_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_STTS_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS       0xf4301788
#define L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PE_TPID_SEL_CONFIG_TBL_DATA         0xf430178c
#define L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctag                 :  2 ; /* bits 1:0 */
    ca_uint32_t stag                 :  2 ; /* bits 3:2 */
    ca_uint32_t inner_ctag           :  2 ; /* bits 5:4 */
    ca_uint32_t inner_stag           :  2 ; /* bits 7:6 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_PE_CTRL_t                           CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_PE_CFG_VLAN_TPID_A_t                CFG_VLAN_TPID_A;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_PE_CFG_VLAN_TPID_B_t                CFG_VLAN_TPID_B;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_PE_CFG_VLAN_TPID_C_t                CFG_VLAN_TPID_C;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_PE_CFG_VLAN_TPID_D_t                CFG_VLAN_TPID_D;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_PE_MY_MAC_LOW_0_t                   MY_MAC_LOW_0;                  /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_PE_MY_MAC_HIGH_0_t                  MY_MAC_HIGH_0;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_PE_MY_MAC_LOW_1_t                   MY_MAC_LOW_1;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_PE_MY_MAC_HIGH_1_t                  MY_MAC_HIGH_1;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_PE_MY_MAC_LOW_2_t                   MY_MAC_LOW_2;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_PE_MY_MAC_HIGH_2_t                  MY_MAC_HIGH_2;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2FE_PE_MY_MAC_LOW_3_t                   MY_MAC_LOW_3;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2FE_PE_MY_MAC_HIGH_3_t                  MY_MAC_HIGH_3;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2FE_PE_MY_MAC_LOW_4_t                   MY_MAC_LOW_4;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2FE_PE_MY_MAC_HIGH_4_t                  MY_MAC_HIGH_4;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2FE_PE_MY_MAC_LOW_5_t                   MY_MAC_LOW_5;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2FE_PE_MY_MAC_HIGH_5_t                  MY_MAC_HIGH_5;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2FE_PE_MY_MAC_LOW_6_t                   MY_MAC_LOW_6;                  /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2FE_PE_MY_MAC_HIGH_6_t                  MY_MAC_HIGH_6;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2FE_PE_MY_MAC_LOW_7_t                   MY_MAC_LOW_7;                  /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2FE_PE_MY_MAC_HIGH_7_t                  MY_MAC_HIGH_7;                 /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2FE_PE_CMD_FF_CTL_REG_t                 CMD_FF_CTL_REG;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2FE_PE_CMD_FF_STS_REG_t                 CMD_FF_STS_REG;                /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L2FE_PE_CMD_FF_CMD_CNT_t                 CMD_FF_CMD_CNT;                /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L2FE_PE_TM_INTERFACE_PKT_CNT_t           TM_INTERFACE_PKT_CNT;          /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L2FE_PE_DROP_CNT_TBL_CLR_t               DROP_CNT_TBL_CLR;              /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  L2FE_PE_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  L2FE_PE_HEADER_A_MID_t                   HEADER_A_MID;                  /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  L2FE_PE_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  L2FE_PE_DROP_CNT_GEAR_FF_CNT_t           DROP_CNT_GEAR_FF_CNT;          /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  L2FE_PE_DROP_CNT_GEAR_FF_STS_t           DROP_CNT_GEAR_FF_STS;          /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  L2FE_PE_DEBUG_t                          DEBUG;                         /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  L2FE_PE_DROP_STTS_ACCESS_t               DROP_STTS_ACCESS;              /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  L2FE_PE_DROP_STTS_DATA_t                 DROP_STTS_DATA;                /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t     TPID_SEL_CONFIG_TBL_ACCESS;    /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];
  L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t       TPID_SEL_CONFIG_TBL_DATA;      /* addr: 0x0000008c */
} APB0_L2FE_PE_t;
#endif /* !__ASSEMBLER__ */


/*
 * LF
 */

#define L2FE_LF_THRESHOLD                        0xf4301900
#define L2FE_LF_THRESHOLD_dft                    0x0001d8b4

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low                  :  9 ; /* bits 8:0 */
    ca_uint32_t high                 :  9 ; /* bits 17:9 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_LF_CNT                              0xf4301904
#define L2FE_LF_CNT_dft                          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t entry_cnt            :  9 ; /* bits 8:0 */
    ca_uint32_t seg_cnt              :  7 ; /* bits 15:9 */
    ca_uint32_t extra_store_cnt      :  2 ; /* bits 17:16 */
    ca_uint32_t data_ltched          :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_LF_STS                              0xf4301908
#define L2FE_LF_STS_dft                          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_LF_DEBUG                            0xf430190c
#define L2FE_LF_DEBUG_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_DEBUG_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LF */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_LF_THRESHOLD_t                      THRESHOLD;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_LF_CNT_t                            CNT;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_LF_STS_t                            STS;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_LF_DEBUG_t                          DEBUG;                         /* addr: 0x0000000c */
} APB0_L2FE_LF_t;
#endif /* !__ASSEMBLER__ */


/*
 * VE
 */

#define L2FE_VE_DEBUG_BUS                        0xf4301a00
#define L2FE_VE_DEBUG_BUS_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_WAN_SVL_IDX_ACCESS               0xf4301a04
#define L2FE_VE_WAN_SVL_IDX_ACCESS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_WAN_SVL_IDX_DATA                 0xf4301a08
#define L2FE_VE_WAN_SVL_IDX_DATA_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wan_svl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t wan_svl_idx_fib_idx  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_VL_FIB_ACCESS                    0xf4301a0c
#define L2FE_VE_VL_FIB_ACCESS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_VL_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_VL_FIB_DATA1                     0xf4301a10
#define L2FE_VE_VL_FIB_DATA1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_vl_group_id : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_VL_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_VL_FIB_DATA0                     0xf4301a14
#define L2FE_VE_VL_FIB_DATA0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_egress_top_untag_bm : 16 ; /* bits 15:0 */
    ca_uint32_t wan_svl_fib_membership_bm : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_VL_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_WAN_CVL_IDX_ACCESS               0xf4301a18
#define L2FE_VE_WAN_CVL_IDX_ACCESS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_WAN_CVL_IDX_DATA                 0xf4301a1c
#define L2FE_VE_WAN_CVL_IDX_DATA_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t wan_cvl_idx_fib_idx  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_LAN_VL_IDX_ACCESS                0xf4301a20
#define L2FE_VE_LAN_VL_IDX_ACCESS_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_VE_LAN_VL_IDX_DATA                  0xf4301a24
#define L2FE_VE_LAN_VL_IDX_DATA_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lan_vl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t lan_vl_idx_fib_idx   :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* VE */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_VE_DEBUG_BUS_t                      DEBUG_BUS;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_VE_WAN_SVL_IDX_ACCESS_t             WAN_SVL_IDX_ACCESS;            /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_VE_WAN_SVL_IDX_DATA_t               WAN_SVL_IDX_DATA;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_VE_VL_FIB_ACCESS_t                  VL_FIB_ACCESS;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_VE_VL_FIB_DATA1_t                   VL_FIB_DATA1;                  /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_VE_VL_FIB_DATA0_t                   VL_FIB_DATA0;                  /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_VE_WAN_CVL_IDX_ACCESS_t             WAN_CVL_IDX_ACCESS;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_VE_WAN_CVL_IDX_DATA_t               WAN_CVL_IDX_DATA;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_VE_LAN_VL_IDX_ACCESS_t              LAN_VL_IDX_ACCESS;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_VE_LAN_VL_IDX_DATA_t                LAN_VL_IDX_DATA;               /* addr: 0x00000024 */
} APB0_L2FE_VE_t;
#endif /* !__ASSEMBLER__ */


/*
 * CLE
 */

#define L2FE_CLE_CTRL                            0xf4301b00
#define L2FE_CLE_CTRL_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t igr_use_frst_hit     :  1 ; /* bits 0:0 */
    ca_uint32_t egr_use_frst_hit     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_CONFG_STTS1                     0xf4301b04
#define L2FE_CLE_CONFG_STTS1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t igr_configured_length_over_size :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_CONFG_STTS1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_DEBUG                           0xf4301b08
#define L2FE_CLE_DEBUG_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t igr_cls_bus_sel      :  2 ; /* bits 1:0 */
    ca_uint32_t egr_cls_bus_sel      :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_DEBUG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_ACCESS                  0xf4301b0c
#define L2FE_CLE_IGR_KEY_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA12                  0xf4301b10
#define L2FE_CLE_IGR_KEY_DATA12_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_reserved :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv6_valid :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_entry_type    :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_valid         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_l4_ext_flags :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_orhr_ipv6e_tos_mask_l :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_orhr_ipv6e_reserved :  3 ; /* bits 7:5 */
    ca_uint32_t cl_key_orhr_ipv6e_idle_field :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_reserved :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_rule_type_1 :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_rule_type_0 :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_rule_hinge :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_tre_rule_idle_field :  3 ; /* bits 11:9 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_reserved :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rl3r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_reserved :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ext_flags :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_l3rl2r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ext_flags :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_l3rl3r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ext_flags :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_l3rcmr_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_tos_mask_l :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_cmrl2r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_tos_mask_l :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_cmrl3r_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_tos_mask_l :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_reserved :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_tre_cmrcmr_idle_field :  8 ; /* bits 11:4 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_rule15_valid :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_stre_rule1_0_ctrl :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_stre_rule3_2_ctrl :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_stre_rule5_4_ctrl :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_stre_rule7_6_ctrl :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_stre_rule9_8_ctrl :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_stre_rule11_10_ctrl :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_stre_rule13_12_ctrl :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_stre_rule15_14_ctrl :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_stre_idle_field :  3 ; /* bits 11:9 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA12_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA11                  0xf4301b14
#define L2FE_CLE_IGR_KEY_DATA11_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn_mask :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_orhr_ipv4e_pol_id_abbr_mask :  1 ; /* bits 11:11 */
    ca_uint32_t cl_key_orhr_ipv4e_pol_id_abbr :  9 ; /* bits 20:12 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_dei_mask :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_dei :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_orhr_ipv4e_top_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_orhr_ipv4e_top_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_flags_op :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_ext_flags :  3 ; /* bits 28:26 */
    ca_uint32_t cl_key_orhr_ipv4e_tos_mask_l :  3 ; /* bits 31:29 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_flags_op :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_ext_flags :  1 ; /* bits 31:31 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_pol_id_use_inner_vid :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_dei_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_dei :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl2r_1_reserved :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_pol_id_use_inner_vid :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_dei_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_dei :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl3r_1_reserved :  3 ; /* bits 31:29 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_pol_id_use_inner_vid :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_dei_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_dei :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rcmr_1_reserved :  3 ; /* bits 31:29 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl2r_1_pol_id_use_inner_vid :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_dei_mask :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_dei :  1 ; /* bits 29:29 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags_op :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ext_flags :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_pol_id_use_inner_vid :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_dei_mask :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_dei :  1 ; /* bits 29:29 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags_op :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ext_flags :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_pol_id_use_inner_vid :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_dei_mask :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_dei :  1 ; /* bits 29:29 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags_op :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ext_flags :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags_op :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_ext_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_tos_mask_l :  1 ; /* bits 31:31 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags_op :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_ext_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_tos_mask_l :  1 ; /* bits 31:31 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn_mask :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags_op :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_ext_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_tos_mask_l :  1 ; /* bits 31:31 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_14_sc_ind :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_stre_vlanid_14 : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_stre_rule14_valid :  1 ; /* bits 13:13 */
    ca_uint32_t cl_key_stre_mask_15  :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_stre_dot1p_15 :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_stre_vlanid_15_sc_ind :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_stre_vlanid_15 : 12 ; /* bits 31:20 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA11_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA10                  0xf4301b18
#define L2FE_CLE_IGR_KEY_DATA10_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da : 32 ; /* bits 31:0 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 24 ; /* bits 31:8 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 24 ; /* bits 31:8 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 24 ; /* bits 31:8 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 10 ; /* bits 31:22 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 10 ; /* bits 31:22 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 26 ; /* bits 31:6 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 26 ; /* bits 31:6 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_12 :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_stre_rule12_valid :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_stre_mask_13  :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_stre_dot1p_13 :  3 ; /* bits 12:10 */
    ca_uint32_t cl_key_stre_vlanid_13_sc_ind :  1 ; /* bits 13:13 */
    ca_uint32_t cl_key_stre_vlanid_13 : 12 ; /* bits 25:14 */
    ca_uint32_t cl_key_stre_rule13_valid :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_stre_mask_14  :  2 ; /* bits 28:27 */
    ca_uint32_t cl_key_stre_dot1p_14 :  3 ; /* bits 31:29 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA10_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA9                   0xf4301b1c
#define L2FE_CLE_IGR_KEY_DATA9_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 31:24 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 32 ; /* bits 31:0 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_fragment :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_option :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_tos :  6 ; /* bits 13:8 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_pt :  8 ; /* bits 21:14 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_fragment :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_option :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_tos :  6 ; /* bits 13:8 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_pt :  8 ; /* bits 21:14 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 10 ; /* bits 31:22 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_fragment :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_option :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_tos :  6 ; /* bits 13:8 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_pt :  8 ; /* bits 21:14 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 10 ; /* bits 31:22 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 26 ; /* bits 31:6 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 26 ; /* bits 31:6 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_10 :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_stre_rule10_valid :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_stre_mask_11  :  2 ; /* bits 3:2 */
    ca_uint32_t cl_key_stre_dot1p_11 :  3 ; /* bits 6:4 */
    ca_uint32_t cl_key_stre_vlanid_11_sc_ind :  1 ; /* bits 7:7 */
    ca_uint32_t cl_key_stre_vlanid_11 : 12 ; /* bits 19:8 */
    ca_uint32_t cl_key_stre_rule11_valid :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_stre_mask_12  :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_stre_dot1p_12 :  3 ; /* bits 25:23 */
    ca_uint32_t cl_key_stre_vlanid_12_sc_ind :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_stre_vlanid_12 :  5 ; /* bits 31:27 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA9_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA8                   0xf4301b20
#define L2FE_CLE_IGR_KEY_DATA8_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 31:8 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid : 11 ; /* bits 10:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_sc_ind :  1 ; /* bits 11:11 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_vid : 12 ; /* bits 23:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa :  8 ; /* bits 31:24 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid : 11 ; /* bits 10:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_sc_ind :  1 ; /* bits 11:11 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_vid : 12 ; /* bits 23:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa :  8 ; /* bits 31:24 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid : 11 ; /* bits 10:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_sc_ind :  1 ; /* bits 11:11 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_vid : 12 ; /* bits 23:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa :  8 ; /* bits 31:24 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_802_1p :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_sc_ind :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_vid : 12 ; /* bits 16:5 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_sc_ind :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_vid : 12 ; /* bits 29:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code :  2 ; /* bits 31:30 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_802_1p :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_sc_ind :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_vid : 12 ; /* bits 16:5 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_sc_ind :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_vid : 12 ; /* bits 29:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code :  2 ; /* bits 31:30 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_802_1p :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_sc_ind :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_vid : 12 ; /* bits 16:5 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_sc_ind :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_vid : 12 ; /* bits 29:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code :  2 ; /* bits 31:30 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_sc_ind :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid : 12 ; /* bits 13:2 */
    ca_uint32_t cl_key_tre_cmrl2r_1_special_pkt_code :  5 ; /* bits 18:14 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_fragment :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_option :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_tos :  6 ; /* bits 29:24 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  2 ; /* bits 31:30 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_sc_ind :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid : 12 ; /* bits 13:2 */
    ca_uint32_t cl_key_tre_cmrl3r_1_special_pkt_code :  5 ; /* bits 18:14 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_fragment :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_option :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_tos :  6 ; /* bits 29:24 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  2 ; /* bits 31:30 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_sc_ind :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid : 12 ; /* bits 13:2 */
    ca_uint32_t cl_key_tre_cmrcmr_1_special_pkt_code :  5 ; /* bits 18:14 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_fragment :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_option :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_tos :  6 ; /* bits 29:24 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  2 ; /* bits 31:30 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_dot1p_9  :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_stre_vlanid_9_sc_ind :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_stre_vlanid_9 : 12 ; /* bits 13:2 */
    ca_uint32_t cl_key_stre_rule9_valid :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_stre_mask_10  :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_stre_dot1p_10 :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_stre_vlanid_10_sc_ind :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_stre_vlanid_10 : 11 ; /* bits 31:21 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA7                   0xf4301b24
#define L2FE_CLE_IGR_KEY_DATA7_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ev2_pt :  5 ; /* bits 5:1 */
    ca_uint32_t cl_key_orhr_ipv4e_tag_num :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_802_1p :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_orhr_ipv4e_top_802_1p :  3 ; /* bits 13:11 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_sc_ind :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_vid : 12 ; /* bits 26:15 */
    ca_uint32_t cl_key_orhr_ipv4e_top_sc_ind :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  4 ; /* bits 31:28 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_tre_l2rl2r_1_ev2_pt :  5 ; /* bits 21:17 */
    ca_uint32_t cl_key_tre_l2rl2r_1_tag_num :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_802_1p :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_802_1p :  3 ; /* bits 29:27 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_sc_ind :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  1 ; /* bits 31:31 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_tre_l2rl3r_1_ev2_pt :  5 ; /* bits 21:17 */
    ca_uint32_t cl_key_tre_l2rl3r_1_tag_num :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_802_1p :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_802_1p :  3 ; /* bits 29:27 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_sc_ind :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  1 ; /* bits 31:31 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_tre_l2rcmr_1_ev2_pt :  5 ; /* bits 21:17 */
    ca_uint32_t cl_key_tre_l2rcmr_1_tag_num :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_802_1p :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_802_1p :  3 ; /* bits 29:27 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_sc_ind :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  1 ; /* bits 31:31 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_l3rl2r_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p :  2 ; /* bits 31:30 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p :  2 ; /* bits 31:30 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p :  2 ; /* bits 31:30 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p :  2 ; /* bits 31:30 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p :  2 ; /* bits 31:30 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp :  7 ; /* bits 6:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_dp : 16 ; /* bits 22:7 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ev2_pt :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_tag_num :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p :  2 ; /* bits 31:30 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_7 :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_stre_rule7_valid :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_stre_mask_8   :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_stre_dot1p_8  :  3 ; /* bits 13:11 */
    ca_uint32_t cl_key_stre_vlanid_8_sc_ind :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_stre_vlanid_8 : 12 ; /* bits 26:15 */
    ca_uint32_t cl_key_stre_rule8_valid :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_stre_mask_9   :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_stre_dot1p_9  :  2 ; /* bits 31:30 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA6                   0xf4301b28
#define L2FE_CLE_IGR_KEY_DATA6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l2rl2r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mask :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_ctrl :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_tre_l2rl2r_1_dot1p_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl2r_1_vid_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 15 ; /* bits 31:17 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l2rl3r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mask :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_ctrl :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_tre_l2rl3r_1_dot1p_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl3r_1_vid_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 15 ; /* bits 31:17 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l2rcmr_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mask :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_ctrl :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_tre_l2rcmr_1_dot1p_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rcmr_1_vid_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 15 ; /* bits 31:17 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl2r_1_mask :  8 ; /* bits 13:6 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ctrl :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_l3rl2r_1_dot1p_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl2r_1_vid_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_ctrl :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp :  9 ; /* bits 31:23 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl3r_1_mask :  8 ; /* bits 13:6 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ctrl :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_l3rl3r_1_dot1p_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl3r_1_vid_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_ctrl :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp :  9 ; /* bits 31:23 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rcmr_1_mask :  8 ; /* bits 13:6 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ctrl :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_l3rcmr_1_dot1p_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rcmr_1_vid_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_ctrl :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp :  9 ; /* bits 31:23 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_cmrl2r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mask : 12 ; /* bits 17:6 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_ctrl :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr_sel :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr_sel :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp :  9 ; /* bits 31:23 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_cmrl3r_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mask : 12 ; /* bits 17:6 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_ctrl :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr_sel :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr_sel :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp :  9 ; /* bits 31:23 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_reserved :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_prcd :  3 ; /* bits 4:2 */
    ca_uint32_t cl_key_tre_cmrcmr_1_fields_operator :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mask : 12 ; /* bits 17:6 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_ctrl :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr_sel :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr_sel :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp :  9 ; /* bits 31:23 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_5 :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_stre_rule5_valid :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_stre_mask_6   :  2 ; /* bits 4:3 */
    ca_uint32_t cl_key_stre_dot1p_6  :  3 ; /* bits 7:5 */
    ca_uint32_t cl_key_stre_vlanid_6_sc_ind :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_stre_vlanid_6 : 12 ; /* bits 20:9 */
    ca_uint32_t cl_key_stre_rule6_valid :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_stre_mask_7   :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_stre_dot1p_7  :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_stre_vlanid_7_sc_ind :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_stre_vlanid_7 :  4 ; /* bits 31:28 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA5                   0xf4301b2c
#define L2FE_CLE_IGR_KEY_DATA5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_pol_id_use_inner_vid :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rl2r_2_reserved :  5 ; /* bits 31:27 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_pol_id_use_inner_vid :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_dei_mask :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_dei :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags_op :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_ext_flags :  3 ; /* bits 31:29 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags_op :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_ext_flags :  3 ; /* bits 28:26 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_tos_mask_l :  3 ; /* bits 31:29 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_pol_id_use_inner_vid :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rl2r_2_reserved :  5 ; /* bits 31:27 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_pol_id_use_inner_vid :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_dei_mask :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_dei :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags_op :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_ext_flags :  3 ; /* bits 31:29 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags_op :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_ext_flags :  3 ; /* bits 28:26 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_tos_mask_l :  3 ; /* bits 31:29 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_pol_id_use_inner_vid :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_dei_mask :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_dei :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrl2r_2_reserved :  5 ; /* bits 31:27 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_pol_id_use_inner_vid :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_dei_mask :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_dei :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_dei_mask :  1 ; /* bits 26:26 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_dei :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags_op :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_ext_flags :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_dei_mask :  1 ; /* bits 23:23 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_dei :  1 ; /* bits 24:24 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags_op :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_ext_flags :  3 ; /* bits 28:26 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_tos_mask_l :  3 ; /* bits 31:29 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_dot1p_4  :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_stre_vlanid_4_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_stre_vlanid_4 : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_stre_rule4_valid :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_stre_mask_5   :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_stre_dot1p_5  :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_stre_vlanid_5_sc_ind :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_stre_vlanid_5 : 10 ; /* bits 31:22 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA4                   0xf4301b30
#define L2FE_CLE_IGR_KEY_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  7 ; /* bits 31:25 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_2 :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_stre_rule2_valid :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_stre_mask_3   :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_stre_dot1p_3  :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_stre_vlanid_3_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_stre_vlanid_3 : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_stre_rule3_valid :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_stre_mask_4   :  2 ; /* bits 30:29 */
    ca_uint32_t cl_key_stre_dot1p_4  :  1 ; /* bits 31:31 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA3                   0xf4301b34
#define L2FE_CLE_IGR_KEY_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_pt :  8 ; /* bits 12:5 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_mask : 14 ; /* bits 26:13 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_vlanid_0 :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_stre_rule0_valid :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_stre_mask_1   :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_stre_dot1p_1  :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_stre_vlanid_1_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_stre_vlanid_1 : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_stre_rule1_valid :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_stre_mask_2   :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_stre_dot1p_2  :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_stre_vlanid_2_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_stre_vlanid_2 :  3 ; /* bits 31:29 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA2                   0xf4301b38
#define L2FE_CLE_IGR_KEY_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_global_key :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_orhr_ipv4e_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_tag_num :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv6e_top_802_1p :  3 ; /* bits 9:7 */
    ca_uint32_t cl_key_orhr_ipv6e_top_sc_ind :  1 ; /* bits 10:10 */
    ca_uint32_t cl_key_orhr_ipv6e_top_vid : 12 ; /* bits 22:11 */
    ca_uint32_t cl_key_orhr_ipv6e_special_pkt_code :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  1 ; /* bits 31:31 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_reserved :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_stre_grp_1_prcd :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_stre_grp_0_prcd :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_stre_grp_1_dscp_mode :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_stre_grp_0_dscp_mode :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_stre_mask_0   :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_stre_dot1p_0  :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_stre_vlanid_0_sc_ind :  1 ; /* bits 22:22 */
    ca_uint32_t cl_key_stre_vlanid_0 :  9 ; /* bits 31:23 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA1                   0xf4301b3c
#define L2FE_CLE_IGR_KEY_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_ctrl :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_dot1p_ctrl :  2 ; /* bits 4:3 */
    ca_uint32_t cl_key_orhr_ipv4e_vid_ctrl :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_ctrl :  2 ; /* bits 8:7 */
    ca_uint32_t cl_key_orhr_ipv4e_global_key : 23 ; /* bits 31:9 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_flow_label :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_sp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 11 ; /* bits 31:21 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_reserved : 32 ; /* bits 31:0 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_KEY_DATA0                   0xf4301b40
#define L2FE_CLE_IGR_KEY_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv4e_mask : 22 ; /* bits 25:4 */
    ca_uint32_t cl_key_orhr_ipv4e_l7_ctrl :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_ctrl :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_ctrl :  2 ; /* bits 31:30 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv6e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv6e_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_orhr_ipv6e_flow_label : 15 ; /* bits 31:17 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l2rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l3rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_cmrl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf10 ;
  struct {
    ca_uint32_t cl_key_stre_reserved : 32 ; /* bits 31:0 */
  } bf11 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_ACCESS                  0xf4301b44
#define L2FE_CLE_IGR_FIB_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA4                   0xf4301b48
#define L2FE_CLE_IGR_FIB_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_inner_vid_0 : 10 ; /* bits 9:0 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_0 :  1 ; /* bits 10:10 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_0 :  2 ; /* bits 12:11 */
    ca_uint32_t cl_fib_xr_top_sc_ind_0 :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_top_vid_0  : 12 ; /* bits 25:14 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_0 :  1 ; /* bits 26:26 */
    ca_uint32_t cl_fib_xr_reserved_0 :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA3                   0xf4301b4c
#define L2FE_CLE_IGR_FIB_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_flowid_0   :  1 ; /* bits 0:0 */
    ca_uint32_t cl_fib_xr_dp_valid_0 :  1 ; /* bits 1:1 */
    ca_uint32_t cl_fib_xr_ldpid_0    :  9 ; /* bits 10:2 */
    ca_uint32_t cl_fib_xr_cos_valid_0 :  1 ; /* bits 11:11 */
    ca_uint32_t cl_fib_xr_dscp_valid_0 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_802_1p_valid_0 :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_cos_0      :  3 ; /* bits 16:14 */
    ca_uint32_t cl_fib_xr_dscp_0     :  6 ; /* bits 22:17 */
    ca_uint32_t cl_fib_xr_802_1p_0   :  3 ; /* bits 25:23 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_0 :  1 ; /* bits 26:26 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_0 :  2 ; /* bits 28:27 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_0 :  1 ; /* bits 29:29 */
    ca_uint32_t cl_fib_xr_inner_vid_0 :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA2                   0xf4301b50
#define L2FE_CLE_IGR_FIB_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_top_vid_1  : 12 ; /* bits 11:0 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_1 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_reserved_1 :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_stp_mode_0 :  2 ; /* bits 15:14 */
    ca_uint32_t cl_fib_xr_permit_valid_0 :  1 ; /* bits 16:16 */
    ca_uint32_t cl_fib_xr_permit_0   :  1 ; /* bits 17:17 */
    ca_uint32_t cl_fib_xr_premarked_0 :  1 ; /* bits 18:18 */
    ca_uint32_t cl_fib_xr_grpid_vld_0 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_flowid_vld_0 :  1 ; /* bits 20:20 */
    ca_uint32_t cl_fib_xr_flowid_0   : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA1                   0xf4301b54
#define L2FE_CLE_IGR_FIB_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_cos_1      :  3 ; /* bits 2:0 */
    ca_uint32_t cl_fib_xr_dscp_1     :  6 ; /* bits 8:3 */
    ca_uint32_t cl_fib_xr_802_1p_1   :  3 ; /* bits 11:9 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_1 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_1 :  2 ; /* bits 14:13 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_1 :  1 ; /* bits 15:15 */
    ca_uint32_t cl_fib_xr_inner_vid_1 : 12 ; /* bits 27:16 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_1 :  2 ; /* bits 30:29 */
    ca_uint32_t cl_fib_xr_top_sc_ind_1 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_CLE_IGR_FIB_DATA0                   0xf4301b58
#define L2FE_CLE_IGR_FIB_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_stp_mode_1 :  2 ; /* bits 1:0 */
    ca_uint32_t cl_fib_xr_permit_valid_1 :  1 ; /* bits 2:2 */
    ca_uint32_t cl_fib_xr_permit_1   :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_premarked_1 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_grpid_vld_1 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_flowid_vld_1 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_flowid_1   : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_dp_valid_1 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_ldpid_1    :  9 ; /* bits 28:20 */
    ca_uint32_t cl_fib_xr_cos_valid_1 :  1 ; /* bits 29:29 */
    ca_uint32_t cl_fib_xr_dscp_valid_1 :  1 ; /* bits 30:30 */
    ca_uint32_t cl_fib_xr_802_1p_valid_1 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLE */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_CLE_CTRL_t                          CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_CLE_CONFG_STTS1_t                   CONFG_STTS1;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_CLE_DEBUG_t                         DEBUG;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_CLE_IGR_KEY_ACCESS_t                IGR_KEY_ACCESS;                /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_CLE_IGR_KEY_DATA12_t                IGR_KEY_DATA12;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_CLE_IGR_KEY_DATA11_t                IGR_KEY_DATA11;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_CLE_IGR_KEY_DATA10_t                IGR_KEY_DATA10;                /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_CLE_IGR_KEY_DATA9_t                 IGR_KEY_DATA9;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_CLE_IGR_KEY_DATA8_t                 IGR_KEY_DATA8;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_CLE_IGR_KEY_DATA7_t                 IGR_KEY_DATA7;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_CLE_IGR_KEY_DATA6_t                 IGR_KEY_DATA6;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2FE_CLE_IGR_KEY_DATA5_t                 IGR_KEY_DATA5;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2FE_CLE_IGR_KEY_DATA4_t                 IGR_KEY_DATA4;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2FE_CLE_IGR_KEY_DATA3_t                 IGR_KEY_DATA3;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2FE_CLE_IGR_KEY_DATA2_t                 IGR_KEY_DATA2;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2FE_CLE_IGR_KEY_DATA1_t                 IGR_KEY_DATA1;                 /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2FE_CLE_IGR_KEY_DATA0_t                 IGR_KEY_DATA0;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2FE_CLE_IGR_FIB_ACCESS_t                IGR_FIB_ACCESS;                /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2FE_CLE_IGR_FIB_DATA4_t                 IGR_FIB_DATA4;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2FE_CLE_IGR_FIB_DATA3_t                 IGR_FIB_DATA3;                 /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2FE_CLE_IGR_FIB_DATA2_t                 IGR_FIB_DATA2;                 /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2FE_CLE_IGR_FIB_DATA1_t                 IGR_FIB_DATA1;                 /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2FE_CLE_IGR_FIB_DATA0_t                 IGR_FIB_DATA0;                 /* addr: 0x00000058 */
} APB0_L2FE_CLE_t;
#endif /* !__ASSEMBLER__ */


/*
 * L2E
 */

#define L2FE_L2E_CTRL                            0xf4301c00
#define L2FE_L2E_CTRL_dft                        0x1ca00ff9

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aging_en             :  1 ; /* bits 0:0 */
    ca_uint32_t tmp_entry_aging_dis  :  1 ; /* bits 1:1 */
    ca_uint32_t aging_mode           :  1 ; /* bits 2:2 */
    ca_uint32_t aging_start_val      :  8 ; /* bits 10:3 */
    ca_uint32_t st_move_en           :  1 ; /* bits 11:11 */
    ca_uint32_t sw_age_entry_scan    :  1 ; /* bits 12:12 */
    ca_uint32_t st_mv_window         :  9 ; /* bits 21:13 */
    ca_uint32_t lrn_dis              :  1 ; /* bits 22:22 */
    ca_uint32_t lrn_mode             :  2 ; /* bits 24:23 */
    ca_uint32_t hash_collision_overwrite :  1 ; /* bits 25:25 */
    ca_uint32_t hashing_mode         :  2 ; /* bits 27:26 */
    ca_uint32_t da_deny_dnt_lrn      :  1 ; /* bits 28:28 */
    ca_uint32_t ovfl_entries_rcyc_en :  1 ; /* bits 29:29 */
    ca_uint32_t info_ff_init         :  1 ; /* bits 30:30 */
    ca_uint32_t cpu_opt_mode         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_AGING_CTRL                      0xf4301c04
#define L2FE_L2E_AGING_CTRL_dft                  0x77b0012c

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t aging_out_time       : 19 ; /* bits 18:0 */
    ca_uint32_t cnt_to_1s            : 13 ; /* bits 31:19 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_AGING_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_CPT_ENTRY_3            0xf4301c08
#define L2FE_L2E_SW_AGING_CPT_ENTRY_3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_CPT_ENTRY_2            0xf4301c0c
#define L2FE_L2E_SW_AGING_CPT_ENTRY_2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_CPT_ENTRY_1            0xf4301c10
#define L2FE_L2E_SW_AGING_CPT_ENTRY_1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_CPT_ENTRY_0            0xf4301c14
#define L2FE_L2E_SW_AGING_CPT_ENTRY_0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD4               0xf4301c18
#define L2FE_L2E_FDB_CPU_CMD_WORD4_dft           0x00007fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD3               0xf4301c1c
#define L2FE_L2E_FDB_CPU_CMD_WORD3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD2               0xf4301c20
#define L2FE_L2E_FDB_CPU_CMD_WORD2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD1               0xf4301c24
#define L2FE_L2E_FDB_CPU_CMD_WORD1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 27 ; /* bits 26:0 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CPU_CMD_WORD0               0xf4301c28
#define L2FE_L2E_FDB_CPU_CMD_WORD0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t word                 : 27 ; /* bits 26:0 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_CMD_RETURN                  0xf4301c2c
#define L2FE_L2E_FDB_CMD_RETURN_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               :  4 ; /* bits 3:0 */
    ca_uint32_t ext_status           : 13 ; /* bits 16:4 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CMD_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_CNT_CMD_RETURN                  0xf4301c30
#define L2FE_L2E_CNT_CMD_RETURN_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_CNT_CMD_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_CNT_STTS_0             0xf4301c34
#define L2FE_L2E_PORT_MAC_CNT_STTS_0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t underflow_0          :  1 ; /* bits 0:0 */
    ca_uint32_t underflow_1          :  1 ; /* bits 1:1 */
    ca_uint32_t underflow_2          :  1 ; /* bits 2:2 */
    ca_uint32_t underflow_3          :  1 ; /* bits 3:3 */
    ca_uint32_t underflow_4          :  1 ; /* bits 4:4 */
    ca_uint32_t underflow_5          :  1 ; /* bits 5:5 */
    ca_uint32_t underflow_6          :  1 ; /* bits 6:6 */
    ca_uint32_t underflow_7          :  1 ; /* bits 7:7 */
    ca_uint32_t underflow_8          :  1 ; /* bits 8:8 */
    ca_uint32_t underflow_9          :  1 ; /* bits 9:9 */
    ca_uint32_t underflow_10         :  1 ; /* bits 10:10 */
    ca_uint32_t underflow_11         :  1 ; /* bits 11:11 */
    ca_uint32_t underflow_12         :  1 ; /* bits 12:12 */
    ca_uint32_t underflow_13         :  1 ; /* bits 13:13 */
    ca_uint32_t underflow_14         :  1 ; /* bits 14:14 */
    ca_uint32_t underflow_15         :  1 ; /* bits 15:15 */
    ca_uint32_t underflow_16         :  1 ; /* bits 16:16 */
    ca_uint32_t underflow_17         :  1 ; /* bits 17:17 */
    ca_uint32_t underflow_18         :  1 ; /* bits 18:18 */
    ca_uint32_t underflow_19         :  1 ; /* bits 19:19 */
    ca_uint32_t underflow_20         :  1 ; /* bits 20:20 */
    ca_uint32_t underflow_21         :  1 ; /* bits 21:21 */
    ca_uint32_t underflow_22         :  1 ; /* bits 22:22 */
    ca_uint32_t underflow_23         :  1 ; /* bits 23:23 */
    ca_uint32_t underflow_24         :  1 ; /* bits 24:24 */
    ca_uint32_t underflow_25         :  1 ; /* bits 25:25 */
    ca_uint32_t underflow_26         :  1 ; /* bits 26:26 */
    ca_uint32_t underflow_27         :  1 ; /* bits 27:27 */
    ca_uint32_t underflow_28         :  1 ; /* bits 28:28 */
    ca_uint32_t underflow_29         :  1 ; /* bits 29:29 */
    ca_uint32_t underflow_30         :  1 ; /* bits 30:30 */
    ca_uint32_t underflow_31         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_CNT_STTS_1             0xf4301c38
#define L2FE_L2E_PORT_MAC_CNT_STTS_1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t underflow_0          :  1 ; /* bits 0:0 */
    ca_uint32_t underflow_1          :  1 ; /* bits 1:1 */
    ca_uint32_t underflow_2          :  1 ; /* bits 2:2 */
    ca_uint32_t underflow_3          :  1 ; /* bits 3:3 */
    ca_uint32_t underflow_4          :  1 ; /* bits 4:4 */
    ca_uint32_t underflow_5          :  1 ; /* bits 5:5 */
    ca_uint32_t underflow_6          :  1 ; /* bits 6:6 */
    ca_uint32_t underflow_7          :  1 ; /* bits 7:7 */
    ca_uint32_t underflow_8          :  1 ; /* bits 8:8 */
    ca_uint32_t underflow_9          :  1 ; /* bits 9:9 */
    ca_uint32_t underflow_10         :  1 ; /* bits 10:10 */
    ca_uint32_t underflow_11         :  1 ; /* bits 11:11 */
    ca_uint32_t underflow_12         :  1 ; /* bits 12:12 */
    ca_uint32_t underflow_13         :  1 ; /* bits 13:13 */
    ca_uint32_t underflow_14         :  1 ; /* bits 14:14 */
    ca_uint32_t underflow_15         :  1 ; /* bits 15:15 */
    ca_uint32_t underflow_16         :  1 ; /* bits 16:16 */
    ca_uint32_t underflow_17         :  1 ; /* bits 17:17 */
    ca_uint32_t underflow_18         :  1 ; /* bits 18:18 */
    ca_uint32_t underflow_19         :  1 ; /* bits 19:19 */
    ca_uint32_t underflow_20         :  1 ; /* bits 20:20 */
    ca_uint32_t underflow_21         :  1 ; /* bits 21:21 */
    ca_uint32_t underflow_22         :  1 ; /* bits 22:22 */
    ca_uint32_t underflow_23         :  1 ; /* bits 23:23 */
    ca_uint32_t underflow_24         :  1 ; /* bits 24:24 */
    ca_uint32_t underflow_25         :  1 ; /* bits 25:25 */
    ca_uint32_t underflow_26         :  1 ; /* bits 26:26 */
    ca_uint32_t underflow_27         :  1 ; /* bits 27:27 */
    ca_uint32_t underflow_28         :  1 ; /* bits 28:28 */
    ca_uint32_t underflow_29         :  1 ; /* bits 29:29 */
    ca_uint32_t underflow_30         :  1 ; /* bits 30:30 */
    ca_uint32_t underflow_31         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0         0xf4301c3c
#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t excd_0               :  1 ; /* bits 0:0 */
    ca_uint32_t excd_1               :  1 ; /* bits 1:1 */
    ca_uint32_t excd_2               :  1 ; /* bits 2:2 */
    ca_uint32_t excd_3               :  1 ; /* bits 3:3 */
    ca_uint32_t excd_4               :  1 ; /* bits 4:4 */
    ca_uint32_t excd_5               :  1 ; /* bits 5:5 */
    ca_uint32_t excd_6               :  1 ; /* bits 6:6 */
    ca_uint32_t excd_7               :  1 ; /* bits 7:7 */
    ca_uint32_t excd_8               :  1 ; /* bits 8:8 */
    ca_uint32_t excd_9               :  1 ; /* bits 9:9 */
    ca_uint32_t excd_10              :  1 ; /* bits 10:10 */
    ca_uint32_t excd_11              :  1 ; /* bits 11:11 */
    ca_uint32_t excd_12              :  1 ; /* bits 12:12 */
    ca_uint32_t excd_13              :  1 ; /* bits 13:13 */
    ca_uint32_t excd_14              :  1 ; /* bits 14:14 */
    ca_uint32_t excd_15              :  1 ; /* bits 15:15 */
    ca_uint32_t excd_16              :  1 ; /* bits 16:16 */
    ca_uint32_t excd_17              :  1 ; /* bits 17:17 */
    ca_uint32_t excd_18              :  1 ; /* bits 18:18 */
    ca_uint32_t excd_19              :  1 ; /* bits 19:19 */
    ca_uint32_t excd_20              :  1 ; /* bits 20:20 */
    ca_uint32_t excd_21              :  1 ; /* bits 21:21 */
    ca_uint32_t excd_22              :  1 ; /* bits 22:22 */
    ca_uint32_t excd_23              :  1 ; /* bits 23:23 */
    ca_uint32_t excd_24              :  1 ; /* bits 24:24 */
    ca_uint32_t excd_25              :  1 ; /* bits 25:25 */
    ca_uint32_t excd_26              :  1 ; /* bits 26:26 */
    ca_uint32_t excd_27              :  1 ; /* bits 27:27 */
    ca_uint32_t excd_28              :  1 ; /* bits 28:28 */
    ca_uint32_t excd_29              :  1 ; /* bits 29:29 */
    ca_uint32_t excd_30              :  1 ; /* bits 30:30 */
    ca_uint32_t excd_31              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1         0xf4301c40
#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t excd_0               :  1 ; /* bits 0:0 */
    ca_uint32_t excd_1               :  1 ; /* bits 1:1 */
    ca_uint32_t excd_2               :  1 ; /* bits 2:2 */
    ca_uint32_t excd_3               :  1 ; /* bits 3:3 */
    ca_uint32_t excd_4               :  1 ; /* bits 4:4 */
    ca_uint32_t excd_5               :  1 ; /* bits 5:5 */
    ca_uint32_t excd_6               :  1 ; /* bits 6:6 */
    ca_uint32_t excd_7               :  1 ; /* bits 7:7 */
    ca_uint32_t excd_8               :  1 ; /* bits 8:8 */
    ca_uint32_t excd_9               :  1 ; /* bits 9:9 */
    ca_uint32_t excd_10              :  1 ; /* bits 10:10 */
    ca_uint32_t excd_11              :  1 ; /* bits 11:11 */
    ca_uint32_t excd_12              :  1 ; /* bits 12:12 */
    ca_uint32_t excd_13              :  1 ; /* bits 13:13 */
    ca_uint32_t excd_14              :  1 ; /* bits 14:14 */
    ca_uint32_t excd_15              :  1 ; /* bits 15:15 */
    ca_uint32_t excd_16              :  1 ; /* bits 16:16 */
    ca_uint32_t excd_17              :  1 ; /* bits 17:17 */
    ca_uint32_t excd_18              :  1 ; /* bits 18:18 */
    ca_uint32_t excd_19              :  1 ; /* bits 19:19 */
    ca_uint32_t excd_20              :  1 ; /* bits 20:20 */
    ca_uint32_t excd_21              :  1 ; /* bits 21:21 */
    ca_uint32_t excd_22              :  1 ; /* bits 22:22 */
    ca_uint32_t excd_23              :  1 ; /* bits 23:23 */
    ca_uint32_t excd_24              :  1 ; /* bits 24:24 */
    ca_uint32_t excd_25              :  1 ; /* bits 25:25 */
    ca_uint32_t excd_26              :  1 ; /* bits 26:26 */
    ca_uint32_t excd_27              :  1 ; /* bits 27:27 */
    ca_uint32_t excd_28              :  1 ; /* bits 28:28 */
    ca_uint32_t excd_29              :  1 ; /* bits 29:29 */
    ca_uint32_t excd_30              :  1 ; /* bits 30:30 */
    ca_uint32_t excd_31              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_HASH_CLLSN_STTS                 0xf4301c44
#define L2FE_L2E_HASH_CLLSN_STTS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cllsn_det            :  1 ; /* bits 0:0 */
    ca_uint32_t cllsn_addr           :  9 ; /* bits 9:1 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_HASH_CLLSN_STTS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_L2E_LRN_STS                     0xf4301c48
#define L2FE_L2E_L2E_LRN_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t loop_det             :  1 ; /* bits 0:0 */
    ca_uint32_t hit_tmp_entry_sm     :  1 ; /* bits 1:1 */
    ca_uint32_t hit_static_entry_sm  :  1 ; /* bits 2:2 */
    ca_uint32_t hit_sm_entry_sm      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_L2E_LRN_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_SW_AGING_REPORT_FIFO_STTS       0xf4301c4c
#define L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cpt_entry_flg        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t cnt                  :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_POINTER_FF_STS_REG              0xf4301c50
#define L2FE_L2E_POINTER_FF_STS_REG_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_POINTER_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_POINTER_FF_CNT                  0xf4301c54
#define L2FE_L2E_POINTER_FF_CNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_POINTER_FF_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_STS_REG                 0xf4301c58
#define L2FE_L2E_INFO_FF_STS_REG_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_0                   0xf4301c5c
#define L2FE_L2E_INFO_FF_CNT_0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_1                   0xf4301c60
#define L2FE_L2E_INFO_FF_CNT_1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_2                   0xf4301c64
#define L2FE_L2E_INFO_FF_CNT_2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_3                   0xf4301c68
#define L2FE_L2E_INFO_FF_CNT_3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_4                   0xf4301c6c
#define L2FE_L2E_INFO_FF_CNT_4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_4_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_5                   0xf4301c70
#define L2FE_L2E_INFO_FF_CNT_5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_5_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_6                   0xf4301c74
#define L2FE_L2E_INFO_FF_CNT_6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_6_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_7                   0xf4301c78
#define L2FE_L2E_INFO_FF_CNT_7_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_7_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_8                   0xf4301c7c
#define L2FE_L2E_INFO_FF_CNT_8_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_8_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_9                   0xf4301c80
#define L2FE_L2E_INFO_FF_CNT_9_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_9_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_10                  0xf4301c84
#define L2FE_L2E_INFO_FF_CNT_10_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_10_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_11                  0xf4301c88
#define L2FE_L2E_INFO_FF_CNT_11_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_11_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_12                  0xf4301c8c
#define L2FE_L2E_INFO_FF_CNT_12_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_12_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_13                  0xf4301c90
#define L2FE_L2E_INFO_FF_CNT_13_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_13_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_14                  0xf4301c94
#define L2FE_L2E_INFO_FF_CNT_14_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_14_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_INFO_FF_CNT_15                  0xf4301c98
#define L2FE_L2E_INFO_FF_CNT_15_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_15_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_DEBUG_BUS                       0xf4301c9c
#define L2FE_L2E_DEBUG_BUS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_ACCESS                      0xf4301ca0
#define L2FE_L2E_FDB_ACCESS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_DATA3                       0xf4301ca4
#define L2FE_L2E_FDB_DATA3_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac_addr             :  3 ; /* bits 2:0 */
    ca_uint32_t lrned_untag_vld      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_DATA2                       0xf4301ca8
#define L2FE_L2E_FDB_DATA2_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_DATA1                       0xf4301cac
#define L2FE_L2E_FDB_DATA1_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lrned_vid            :  3 ; /* bits 2:0 */
    ca_uint32_t key_dot1p            :  3 ; /* bits 5:3 */
    ca_uint32_t key_scind            :  1 ; /* bits 6:6 */
    ca_uint32_t key_vid              : 12 ; /* bits 18:7 */
    ca_uint32_t mac_addr             : 13 ; /* bits 31:19 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_FDB_DATA0                       0xf4301cb0
#define L2FE_L2E_FDB_DATA0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mcgid                : 10 ; /* bits 9:0 */
    ca_uint32_t mc_flag              :  1 ; /* bits 10:10 */
    ca_uint32_t aging_sts            :  8 ; /* bits 18:11 */
    ca_uint32_t is_static            :  1 ; /* bits 19:19 */
    ca_uint32_t da_permit            :  1 ; /* bits 20:20 */
    ca_uint32_t sa_permit            :  1 ; /* bits 21:21 */
    ca_uint32_t lrned_scind          :  1 ; /* bits 22:22 */
    ca_uint32_t lrned_vid            :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS         0xf4301cb4
#define L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_PORT_MAC_CNT_LMT_DATA           0xf4301cb8
#define L2FE_L2E_PORT_MAC_CNT_LMT_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_L2E_AGING_CTRL_EXT                  0xf4301cbc
#define L2FE_L2E_AGING_CTRL_EXT_dft              0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sw_lrn_aging_start_val :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_AGING_CTRL_EXT_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2E */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_L2E_CTRL_t                          CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_L2E_AGING_CTRL_t                    AGING_CTRL;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_L2E_SW_AGING_CPT_ENTRY_3_t          SW_AGING_CPT_ENTRY_3;          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_L2E_SW_AGING_CPT_ENTRY_2_t          SW_AGING_CPT_ENTRY_2;          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_L2E_SW_AGING_CPT_ENTRY_1_t          SW_AGING_CPT_ENTRY_1;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_L2E_SW_AGING_CPT_ENTRY_0_t          SW_AGING_CPT_ENTRY_0;          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_L2E_FDB_CPU_CMD_WORD4_t             FDB_CPU_CMD_WORD4;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_L2E_FDB_CPU_CMD_WORD3_t             FDB_CPU_CMD_WORD3;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_L2E_FDB_CPU_CMD_WORD2_t             FDB_CPU_CMD_WORD2;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_L2E_FDB_CPU_CMD_WORD1_t             FDB_CPU_CMD_WORD1;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_L2E_FDB_CPU_CMD_WORD0_t             FDB_CPU_CMD_WORD0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2FE_L2E_FDB_CMD_RETURN_t                FDB_CMD_RETURN;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2FE_L2E_CNT_CMD_RETURN_t                CNT_CMD_RETURN;                /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2FE_L2E_PORT_MAC_CNT_STTS_0_t           PORT_MAC_CNT_STTS_0;           /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2FE_L2E_PORT_MAC_CNT_STTS_1_t           PORT_MAC_CNT_STTS_1;           /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t       PORT_MAC_LMT_CHK_STTS_0;       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t       PORT_MAC_LMT_CHK_STTS_1;       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2FE_L2E_HASH_CLLSN_STTS_t               HASH_CLLSN_STTS;               /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2FE_L2E_L2E_LRN_STS_t                   L2E_LRN_STS;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t     SW_AGING_REPORT_FIFO_STTS;     /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2FE_L2E_POINTER_FF_STS_REG_t            POINTER_FF_STS_REG;            /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2FE_L2E_POINTER_FF_CNT_t                POINTER_FF_CNT;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2FE_L2E_INFO_FF_STS_REG_t               INFO_FF_STS_REG;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L2FE_L2E_INFO_FF_CNT_0_t                 INFO_FF_CNT_0;                 /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L2FE_L2E_INFO_FF_CNT_1_t                 INFO_FF_CNT_1;                 /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L2FE_L2E_INFO_FF_CNT_2_t                 INFO_FF_CNT_2;                 /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  L2FE_L2E_INFO_FF_CNT_3_t                 INFO_FF_CNT_3;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  L2FE_L2E_INFO_FF_CNT_4_t                 INFO_FF_CNT_4;                 /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  L2FE_L2E_INFO_FF_CNT_5_t                 INFO_FF_CNT_5;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  L2FE_L2E_INFO_FF_CNT_6_t                 INFO_FF_CNT_6;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  L2FE_L2E_INFO_FF_CNT_7_t                 INFO_FF_CNT_7;                 /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  L2FE_L2E_INFO_FF_CNT_8_t                 INFO_FF_CNT_8;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  L2FE_L2E_INFO_FF_CNT_9_t                 INFO_FF_CNT_9;                 /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  L2FE_L2E_INFO_FF_CNT_10_t                INFO_FF_CNT_10;                /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  L2FE_L2E_INFO_FF_CNT_11_t                INFO_FF_CNT_11;                /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];
  L2FE_L2E_INFO_FF_CNT_12_t                INFO_FF_CNT_12;                /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];
  L2FE_L2E_INFO_FF_CNT_13_t                INFO_FF_CNT_13;                /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];
  L2FE_L2E_INFO_FF_CNT_14_t                INFO_FF_CNT_14;                /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];
  L2FE_L2E_INFO_FF_CNT_15_t                INFO_FF_CNT_15;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];
  L2FE_L2E_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];
  L2FE_L2E_FDB_ACCESS_t                    FDB_ACCESS;                    /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];
  L2FE_L2E_FDB_DATA3_t                     FDB_DATA3;                     /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];
  L2FE_L2E_FDB_DATA2_t                     FDB_DATA2;                     /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];
  L2FE_L2E_FDB_DATA1_t                     FDB_DATA1;                     /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];
  L2FE_L2E_FDB_DATA0_t                     FDB_DATA0;                     /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];
  L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t       PORT_MAC_CNT_LMT_ACCESS;       /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];
  L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t         PORT_MAC_CNT_LMT_DATA;         /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];
  L2FE_L2E_AGING_CTRL_EXT_t                AGING_CTRL_EXT;                /* addr: 0x000000bc */
} APB0_L2FE_L2E_t;
#endif /* !__ASSEMBLER__ */


/*
 * PONCLE
 */

#define L2FE_PONCLE_TCAM_CTRL                    0xf4301e00
#define L2FE_PONCLE_TCAM_CTRL_dft                0x000021c3

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mds0                 :  3 ; /* bits 2:0 */
    ca_uint32_t rds0                 :  4 ; /* bits 6:3 */
    ca_uint32_t mds1                 :  3 ; /* bits 9:7 */
    ca_uint32_t rds1                 :  4 ; /* bits 13:10 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_TCAM_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_KEY_ACCESS                   0xf4301e04
#define L2FE_PONCLE_KEY_ACCESS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_KEY_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_KEY_DATA2                    0xf4301e08
#define L2FE_PONCLE_KEY_DATA2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tos                  :  8 ; /* bits 7:0 */
    ca_uint32_t reserved             :  3 ; /* bits 10:8 */
    ca_uint32_t ether_type           :  5 ; /* bits 15:11 */
    ca_uint32_t valid                :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_KEY_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_KEY_DATA1                    0xf4301e0c
#define L2FE_PONCLE_KEY_DATA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctag                 : 16 ; /* bits 15:0 */
    ca_uint32_t outer_tag            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_KEY_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_KEY_DATA0                    0xf4301e10
#define L2FE_PONCLE_KEY_DATA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t lspid                :  6 ; /* bits 11:6 */
    ca_uint32_t stag_pkt             :  1 ; /* bits 12:12 */
    ca_uint32_t ctag_pkt             :  1 ; /* bits 13:13 */
    ca_uint32_t stag_tpid_code       :  2 ; /* bits 15:14 */
    ca_uint32_t pkt_type             :  3 ; /* bits 18:16 */
    ca_uint32_t ipv4_pkt             :  1 ; /* bits 19:19 */
    ca_uint32_t ipv6_pkt             :  1 ; /* bits 20:20 */
    ca_uint32_t igmp_pkt             :  1 ; /* bits 21:21 */
    ca_uint32_t pol_id               :  9 ; /* bits 30:22 */
    ca_uint32_t stream               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_KEY_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_FIB_ACCESS                   0xf4301e14
#define L2FE_PONCLE_FIB_ACCESS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_FIB_DATA2                    0xf4301e18
#define L2FE_PONCLE_FIB_DATA2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cpri                 :  1 ; /* bits 0:0 */
    ca_uint32_t cvid_act             :  2 ; /* bits 2:1 */
    ca_uint32_t cpri_act             :  2 ; /* bits 4:3 */
    ca_uint32_t ccfi_keep            :  1 ; /* bits 5:5 */
    ca_uint32_t cf_cos_act           :  1 ; /* bits 6:6 */
    ca_uint32_t cf_cos               :  3 ; /* bits 9:7 */
    ca_uint32_t rsv                  :  2 ; /* bits 11:10 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_FIB_DATA1                    0xf4301e1c
#define L2FE_PONCLE_FIB_DATA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cf_flowid            :  5 ; /* bits 4:0 */
    ca_uint32_t forward_act          :  3 ; /* bits 7:5 */
    ca_uint32_t cf_fwd_id            :  8 ; /* bits 15:8 */
    ca_uint32_t cact                 :  2 ; /* bits 17:16 */
    ca_uint32_t cvid                 : 12 ; /* bits 29:18 */
    ca_uint32_t cpri                 :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_PONCLE_FIB_DATA0                    0xf4301e20
#define L2FE_PONCLE_FIB_DATA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t csact                :  3 ; /* bits 2:0 */
    ca_uint32_t cs_vid               : 12 ; /* bits 14:3 */
    ca_uint32_t cs_pri               :  3 ; /* bits 17:15 */
    ca_uint32_t cspri_act            :  2 ; /* bits 19:18 */
    ca_uint32_t csvid_act            :  2 ; /* bits 21:20 */
    ca_uint32_t cscfi_keep           :  1 ; /* bits 22:22 */
    ca_uint32_t grpid_act            :  1 ; /* bits 23:23 */
    ca_uint32_t flowid_act           :  1 ; /* bits 24:24 */
    ca_uint32_t cf_flowid            :  7 ; /* bits 31:25 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PONCLE_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PONCLE */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_PONCLE_TCAM_CTRL_t                  TCAM_CTRL;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_PONCLE_KEY_ACCESS_t                 KEY_ACCESS;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_PONCLE_KEY_DATA2_t                  KEY_DATA2;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_PONCLE_KEY_DATA1_t                  KEY_DATA1;                     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_PONCLE_KEY_DATA0_t                  KEY_DATA0;                     /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_PONCLE_FIB_ACCESS_t                 FIB_ACCESS;                    /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_PONCLE_FIB_DATA2_t                  FIB_DATA2;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_PONCLE_FIB_DATA1_t                  FIB_DATA1;                     /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_PONCLE_FIB_DATA0_t                  FIB_DATA0;                     /* addr: 0x00000020 */
} APB0_L2FE_PONCLE_t;
#endif /* !__ASSEMBLER__ */


/*
 * MIRE
 */

#define L2FE_MIRE_MIR_CTRL                       0xf4301f00
#define L2FE_MIRE_MIR_CTRL_dft                   0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt_drop_src_mir_en  :  1 ; /* bits 0:0 */
    ca_uint32_t pkt_keep_old         :  1 ; /* bits 1:1 */
    ca_uint32_t lspid_remap          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_RULE_SSID_0                0xf4301f04
#define L2FE_MIRE_MIR_RULE_SSID_0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_RULE_SSID_1                0xf4301f08
#define L2FE_MIRE_MIR_RULE_SSID_1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_RULE_SSID_2                0xf4301f0c
#define L2FE_MIRE_MIR_RULE_SSID_2_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_RULE_SSID_3                0xf4301f10
#define L2FE_MIRE_MIR_RULE_SSID_3_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_0_SSID_0               0xf4301f14
#define L2FE_MIRE_MIR_ACT_0_SSID_0_dft           0x0000433a

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_0_SSID_1               0xf4301f18
#define L2FE_MIRE_MIR_ACT_0_SSID_1_dft           0x0000437b

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_0_SSID_2               0xf4301f1c
#define L2FE_MIRE_MIR_ACT_0_SSID_2_dft           0x000043bc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_0_SSID_3               0xf4301f20
#define L2FE_MIRE_MIR_ACT_0_SSID_3_dft           0x000043fd

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_1_SSID_0               0xf4301f24
#define L2FE_MIRE_MIR_ACT_1_SSID_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rx_mirror            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_1_SSID_1               0xf4301f28
#define L2FE_MIRE_MIR_ACT_1_SSID_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rx_mirror            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_1_SSID_2               0xf4301f2c
#define L2FE_MIRE_MIR_ACT_1_SSID_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rx_mirror            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_ACT_1_SSID_3               0xf4301f30
#define L2FE_MIRE_MIR_ACT_1_SSID_3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rx_mirror            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_STTS_0                     0xf4301f34
#define L2FE_MIRE_MIR_STTS_0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_STTS_1                     0xf4301f38
#define L2FE_MIRE_MIR_STTS_1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_STTS_2                     0xf4301f3c
#define L2FE_MIRE_MIR_STTS_2_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_2_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_MIR_STTS_3                     0xf4301f40
#define L2FE_MIRE_MIR_STTS_3_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_3_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_PINGPONG_STS                   0xf4301f44
#define L2FE_MIRE_PINGPONG_STS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_DATA_FIFO_CNT                  0xf4301f48
#define L2FE_MIRE_DATA_FIFO_CNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t entry_cnt            :  7 ; /* bits 6:0 */
    ca_uint32_t seg_cnt              :  4 ; /* bits 10:7 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t extra_store_cnt      :  2 ; /* bits 17:16 */
    ca_uint32_t data_ltched          :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DATA_FIFO_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_DATA_FIFO_STTS                 0xf4301f4c
#define L2FE_MIRE_DATA_FIFO_STTS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DATA_FIFO_STTS_t;
#endif /* !__ASSEMBLER__ */


#define L2FE_MIRE_DEBUG                          0xf4301f50
#define L2FE_MIRE_DEBUG_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DEBUG_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* MIRE */
#ifndef __ASSEMBLER__
typedef struct {
  L2FE_MIRE_MIR_CTRL_t                     MIR_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2FE_MIRE_MIR_RULE_SSID_0_t              MIR_RULE_SSID_0;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2FE_MIRE_MIR_RULE_SSID_1_t              MIR_RULE_SSID_1;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2FE_MIRE_MIR_RULE_SSID_2_t              MIR_RULE_SSID_2;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2FE_MIRE_MIR_RULE_SSID_3_t              MIR_RULE_SSID_3;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2FE_MIRE_MIR_ACT_0_SSID_0_t             MIR_ACT_0_SSID_0;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2FE_MIRE_MIR_ACT_0_SSID_1_t             MIR_ACT_0_SSID_1;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2FE_MIRE_MIR_ACT_0_SSID_2_t             MIR_ACT_0_SSID_2;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2FE_MIRE_MIR_ACT_0_SSID_3_t             MIR_ACT_0_SSID_3;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2FE_MIRE_MIR_ACT_1_SSID_0_t             MIR_ACT_1_SSID_0;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2FE_MIRE_MIR_ACT_1_SSID_1_t             MIR_ACT_1_SSID_1;              /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2FE_MIRE_MIR_ACT_1_SSID_2_t             MIR_ACT_1_SSID_2;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2FE_MIRE_MIR_ACT_1_SSID_3_t             MIR_ACT_1_SSID_3;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2FE_MIRE_MIR_STTS_0_t                   MIR_STTS_0;                    /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2FE_MIRE_MIR_STTS_1_t                   MIR_STTS_1;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2FE_MIRE_MIR_STTS_2_t                   MIR_STTS_2;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2FE_MIRE_MIR_STTS_3_t                   MIR_STTS_3;                    /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2FE_MIRE_PINGPONG_STS_t                 PINGPONG_STS;                  /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2FE_MIRE_DATA_FIFO_CNT_t                DATA_FIFO_CNT;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2FE_MIRE_DATA_FIFO_STTS_t               DATA_FIFO_STTS;                /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2FE_MIRE_DEBUG_t                        DEBUG;                         /* addr: 0x00000050 */
} APB0_L2FE_MIRE_t;
#endif /* !__ASSEMBLER__ */




/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2FE */

#ifndef __ASSEMBLER__
typedef struct {
  APB0_L2FE_GLB_t                   GLB;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[205];
  APB0_L2FE_PP_t                    PP;                            /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[355];
  APB0_L2FE_PLA_t                   PLA;                           /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd3[239];
  APB0_L2FE_PLC_t                   PLC;                           /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd4[235];
  APB0_L2FE_PLE_t                   PLE;                           /* addr: 0x00000500 */
  ca_uint32_t                              rsrvd5[189];
  APB0_L2FE_ARB_t                   ARB;                           /* addr: 0x00000600 */
  ca_uint32_t                              rsrvd6[211];
  APB0_L2FE_PE_t                    PE;                            /* addr: 0x00000700 */
  ca_uint32_t                              rsrvd7[441];
  APB0_L2FE_LF_t                    LF;                            /* addr: 0x00000900 */
  ca_uint32_t                              rsrvd8[249];
  APB0_L2FE_VE_t                    VE;                            /* addr: 0x00000a00 */
  ca_uint32_t                              rsrvd9[237];
  APB0_L2FE_CLE_t                   CLE;                           /* addr: 0x00000b00 */
  ca_uint32_t                              rsrvd10[211];
  APB0_L2FE_L2E_t                   L2E;                           /* addr: 0x00000c00 */
  ca_uint32_t                              rsrvd11[417];
  APB0_L2FE_PONCLE_t                PONCLE;                        /* addr: 0x00000e00 */
  ca_uint32_t                              rsrvd12[239];
  APB0_L2FE_MIRE_t                  MIRE;                          /* addr: 0x00000f00 */
} APB0_L2FE_t;
#endif /* !__ASSEMBLER__ */


/*
 * L2TM
 */

/*
 * l2tm_glb
 */

#define L2TM_L2TM_GLB_REV_ID                     0xf4302000
#define L2TM_L2TM_GLB_REV_ID_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_REV_ID_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_INT                        0xf4302004
#define L2TM_L2TM_GLB_INT_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bm                   :  1 ; /* bits 0:0 */
    ca_uint32_t qm                   :  1 ; /* bits 1:1 */
    ca_uint32_t bm1                  :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_INTE                       0xf4302008
#define L2TM_L2TM_GLB_INTE_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bmE                  :  1 ; /* bits 0:0 */
    ca_uint32_t qmE                  :  1 ; /* bits 1:1 */
    ca_uint32_t bm1E                 :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_STS                        0xf430200c
#define L2TM_L2TM_GLB_STS_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t voqinfo_ram_init_done :  1 ; /* bits 14:14 */
    ca_uint32_t freeq_ram_init_done  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 14 ;
    ca_uint32_t idle                 :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_CTRL                       0xf4302010
#define L2TM_L2TM_GLB_CTRL_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t cntrcfg_clear_on_read :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_SPARE_CFG                  0xf4302014
#define L2TM_L2TM_GLB_SPARE_CFG_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_SPARE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_SPARE_STS                  0xf4302018
#define L2TM_L2TM_GLB_SPARE_STS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_SPARE_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_SRAM_TEST_CONTROL_0        0xf430201c
#define L2TM_L2TM_GLB_SRAM_TEST_CONTROL_0_dft    0x00000202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_SRAM_TEST_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_SRAM_LS_CONTROL            0xf4302020
#define L2TM_L2TM_GLB_SRAM_LS_CONTROL_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l2te1_sramls         :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t l2te2_sramls         :  6 ; /* bits 13:8 */
    ca_uint32_t l2te3_sramls         :  8 ; /* bits 21:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t l2tm2a_sramls        :  1 ; /* bits 23:23 */
    ca_uint32_t l2tm_repair1_sramls  :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd3               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_SRAM_LS_CONTROL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_GLB_FPGA_REV_ID                0xf4302024
#define L2TM_L2TM_GLB_FPGA_REV_ID_dft            0x00000084

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t FPGA_ver             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_FPGA_REV_ID_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_glb */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TM_GLB_REV_ID_t                   REV_ID;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TM_GLB_INT_t                      INT;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TM_GLB_INTE_t                     INTE;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TM_GLB_STS_t                      STS;                           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TM_GLB_CTRL_t                     CTRL;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TM_GLB_SPARE_CFG_t                SPARE_CFG;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TM_GLB_SPARE_STS_t                SPARE_STS;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TM_GLB_SRAM_TEST_CONTROL_0_t      SRAM_TEST_CONTROL_0;           /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TM_GLB_SRAM_LS_CONTROL_t          SRAM_LS_CONTROL;               /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TM_GLB_FPGA_REV_ID_t              FPGA_REV_ID;                   /* addr: 0x00000024 */
} APB0_L2TM_L2TM_GLB_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2tm_bm
 */

#define L2TM_L2TM_BM_INT                         0xf4302100
#define L2TM_L2TM_BM_INT_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sb_drop              :  1 ; /* bits 0:0 */
    ca_uint32_t hdr_drop             :  1 ; /* bits 1:1 */
    ca_uint32_t te_drop              :  1 ; /* bits 2:2 */
    ca_uint32_t wvoqid               :  1 ; /* bits 3:3 */
    ca_uint32_t szerr                :  1 ; /* bits 4:4 */
    ca_uint32_t seglenerr            :  1 ; /* bits 5:5 */
    ca_uint32_t seq_err              :  1 ; /* bits 6:6 */
    ca_uint32_t fc_mirror_drop       :  1 ; /* bits 7:7 */
    ca_uint32_t dq_sb_drop           :  1 ; /* bits 8:8 */
    ca_uint32_t dq_hdr_drop          :  1 ; /* bits 9:9 */
    ca_uint32_t dq_wvoqid            :  1 ; /* bits 10:10 */
    ca_uint32_t dq_szerr             :  1 ; /* bits 11:11 */
    ca_uint32_t dq_seglenerr         :  1 ; /* bits 12:12 */
    ca_uint32_t dq_seq_err           :  1 ; /* bits 13:13 */
    ca_uint32_t dq_ff_undrflo        :  1 ; /* bits 14:14 */
    ca_uint32_t dq_ff_ovrflo         :  1 ; /* bits 15:15 */
    ca_uint32_t dq_pack_ff_undrflo   :  1 ; /* bits 16:16 */
    ca_uint32_t dq_pack_ff_ovrflo    :  1 ; /* bits 17:17 */
    ca_uint32_t fe_ff_undrflo        :  1 ; /* bits 18:18 */
    ca_uint32_t fe_ff_ovrflo         :  1 ; /* bits 19:19 */
    ca_uint32_t pack_ff_undrflo      :  1 ; /* bits 20:20 */
    ca_uint32_t pack_ff_ovrflo       :  1 ; /* bits 21:21 */
    ca_uint32_t wdat_ff_undrflo      :  1 ; /* bits 22:22 */
    ca_uint32_t wdat_ff_ovrflo       :  1 ; /* bits 23:23 */
    ca_uint32_t wcmd_ff_undrflo      :  1 ; /* bits 24:24 */
    ca_uint32_t wcmd_ff_ovrflo       :  1 ; /* bits 25:25 */
    ca_uint32_t rdat_ff_undrflo      :  1 ; /* bits 26:26 */
    ca_uint32_t rdat_ff_ovrflo       :  1 ; /* bits 27:27 */
    ca_uint32_t rcmd_ff_undrflo      :  1 ; /* bits 28:28 */
    ca_uint32_t rcmd_ff_ovrflo       :  1 ; /* bits 29:29 */
    ca_uint32_t rcyc_ff_undrflo      :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_ovrflo       :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_INTE                        0xf4302104
#define L2TM_L2TM_BM_INTE_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sb_dropE             :  1 ; /* bits 0:0 */
    ca_uint32_t hdr_dropE            :  1 ; /* bits 1:1 */
    ca_uint32_t te_dropE             :  1 ; /* bits 2:2 */
    ca_uint32_t wvoqidE              :  1 ; /* bits 3:3 */
    ca_uint32_t szerrE               :  1 ; /* bits 4:4 */
    ca_uint32_t seglenerrE           :  1 ; /* bits 5:5 */
    ca_uint32_t seq_errE             :  1 ; /* bits 6:6 */
    ca_uint32_t fc_mirror_dropE      :  1 ; /* bits 7:7 */
    ca_uint32_t dq_sb_dropE          :  1 ; /* bits 8:8 */
    ca_uint32_t dq_hdr_dropE         :  1 ; /* bits 9:9 */
    ca_uint32_t dq_wvoqidE           :  1 ; /* bits 10:10 */
    ca_uint32_t dq_szerrE            :  1 ; /* bits 11:11 */
    ca_uint32_t dq_seglenerrE        :  1 ; /* bits 12:12 */
    ca_uint32_t dq_seq_errE          :  1 ; /* bits 13:13 */
    ca_uint32_t dq_ff_undrfloE       :  1 ; /* bits 14:14 */
    ca_uint32_t dq_ff_ovrfloE        :  1 ; /* bits 15:15 */
    ca_uint32_t dq_pack_ff_undrfloE  :  1 ; /* bits 16:16 */
    ca_uint32_t dq_pack_ff_ovrfloE   :  1 ; /* bits 17:17 */
    ca_uint32_t fe_ff_undrfloE       :  1 ; /* bits 18:18 */
    ca_uint32_t fe_ff_ovrfloE        :  1 ; /* bits 19:19 */
    ca_uint32_t pack_ff_undrfloE     :  1 ; /* bits 20:20 */
    ca_uint32_t pack_ff_ovrfloE      :  1 ; /* bits 21:21 */
    ca_uint32_t wdat_ff_undrfloE     :  1 ; /* bits 22:22 */
    ca_uint32_t wdat_ff_ovrfloE      :  1 ; /* bits 23:23 */
    ca_uint32_t wcmd_ff_undrfloE     :  1 ; /* bits 24:24 */
    ca_uint32_t wcmd_ff_ovrfloE      :  1 ; /* bits 25:25 */
    ca_uint32_t rdat_ff_undrfloE     :  1 ; /* bits 26:26 */
    ca_uint32_t rdat_ff_ovrfloE      :  1 ; /* bits 27:27 */
    ca_uint32_t rcmd_ff_undrfloE     :  1 ; /* bits 28:28 */
    ca_uint32_t rcmd_ff_ovrfloE      :  1 ; /* bits 29:29 */
    ca_uint32_t rcyc_ff_undrfloE     :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_ovrfloE      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_INT1                        0xf4302108
#define L2TM_L2TM_BM_INT1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t abr_flush_cos0       :  1 ; /* bits 0:0 */
    ca_uint32_t abr_flush_cos1       :  1 ; /* bits 1:1 */
    ca_uint32_t abr_flush_cos2       :  1 ; /* bits 2:2 */
    ca_uint32_t abr_flush_cos3       :  1 ; /* bits 3:3 */
    ca_uint32_t abr_flush_cos4       :  1 ; /* bits 4:4 */
    ca_uint32_t abr_flush_cos5       :  1 ; /* bits 5:5 */
    ca_uint32_t abr_flush_cos6       :  1 ; /* bits 6:6 */
    ca_uint32_t abr_flush_cos7       :  1 ; /* bits 7:7 */
    ca_uint32_t abr_drop_cos0        :  1 ; /* bits 8:8 */
    ca_uint32_t abr_drop_cos1        :  1 ; /* bits 9:9 */
    ca_uint32_t abr_drop_cos2        :  1 ; /* bits 10:10 */
    ca_uint32_t abr_drop_cos3        :  1 ; /* bits 11:11 */
    ca_uint32_t abr_drop_cos4        :  1 ; /* bits 12:12 */
    ca_uint32_t abr_drop_cos5        :  1 ; /* bits 13:13 */
    ca_uint32_t abr_drop_cos6        :  1 ; /* bits 14:14 */
    ca_uint32_t abr_drop_cos7        :  1 ; /* bits 15:15 */
    ca_uint32_t dq_abr_drop_cos0     :  1 ; /* bits 16:16 */
    ca_uint32_t dq_abr_drop_cos1     :  1 ; /* bits 17:17 */
    ca_uint32_t dq_abr_drop_cos2     :  1 ; /* bits 18:18 */
    ca_uint32_t dq_abr_drop_cos3     :  1 ; /* bits 19:19 */
    ca_uint32_t dq_abr_drop_cos4     :  1 ; /* bits 20:20 */
    ca_uint32_t dq_abr_drop_cos5     :  1 ; /* bits 21:21 */
    ca_uint32_t dq_abr_drop_cos6     :  1 ; /* bits 22:22 */
    ca_uint32_t dq_abr_drop_cos7     :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INT1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_INT1E                       0xf430210c
#define L2TM_L2TM_BM_INT1E_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t abr_flush_cos0E      :  1 ; /* bits 0:0 */
    ca_uint32_t abr_flush_cos1E      :  1 ; /* bits 1:1 */
    ca_uint32_t abr_flush_cos2E      :  1 ; /* bits 2:2 */
    ca_uint32_t abr_flush_cos3E      :  1 ; /* bits 3:3 */
    ca_uint32_t abr_flush_cos4E      :  1 ; /* bits 4:4 */
    ca_uint32_t abr_flush_cos5E      :  1 ; /* bits 5:5 */
    ca_uint32_t abr_flush_cos6E      :  1 ; /* bits 6:6 */
    ca_uint32_t abr_flush_cos7E      :  1 ; /* bits 7:7 */
    ca_uint32_t abr_drop_cos0E       :  1 ; /* bits 8:8 */
    ca_uint32_t abr_drop_cos1E       :  1 ; /* bits 9:9 */
    ca_uint32_t abr_drop_cos2E       :  1 ; /* bits 10:10 */
    ca_uint32_t abr_drop_cos3E       :  1 ; /* bits 11:11 */
    ca_uint32_t abr_drop_cos4E       :  1 ; /* bits 12:12 */
    ca_uint32_t abr_drop_cos5E       :  1 ; /* bits 13:13 */
    ca_uint32_t abr_drop_cos6E       :  1 ; /* bits 14:14 */
    ca_uint32_t abr_drop_cos7E       :  1 ; /* bits 15:15 */
    ca_uint32_t dq_abr_drop_cos0E    :  1 ; /* bits 16:16 */
    ca_uint32_t dq_abr_drop_cos1E    :  1 ; /* bits 17:17 */
    ca_uint32_t dq_abr_drop_cos2E    :  1 ; /* bits 18:18 */
    ca_uint32_t dq_abr_drop_cos3E    :  1 ; /* bits 19:19 */
    ca_uint32_t dq_abr_drop_cos4E    :  1 ; /* bits 20:20 */
    ca_uint32_t dq_abr_drop_cos5E    :  1 ; /* bits 21:21 */
    ca_uint32_t dq_abr_drop_cos6E    :  1 ; /* bits 22:22 */
    ca_uint32_t dq_abr_drop_cos7E    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INT1E_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_CTRL                        0xf4302110
#define L2TM_L2TM_BM_CTRL_dft                    0xc0000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rx_drop_cos          :  3 ; /* bits 2:0 */
    ca_uint32_t rx_drop_pid          :  4 ; /* bits 6:3 */
    ca_uint32_t rx_drop_en           :  2 ; /* bits 8:7 */
    ca_uint32_t sb_drop_dis          :  1 ; /* bits 9:9 */
    ca_uint32_t hdr_drop_code_upd_en :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t min_pktlen           :  7 ; /* bits 30:24 */
    ca_uint32_t rx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP        0xf4302114
#define L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_dft    0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP        0xf4302118
#define L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_dft    0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP     0xf430211c
#define L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_dft 0x00000076

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t rxpfc_0              :  1 ; /* bits 8:8 */
    ca_uint32_t rxpfc_1              :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP          0xf4302120
#define L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_dft      0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TM_TO_LANL3FE_QUEUE_MAP     0xf4302124
#define L2TM_L2TM_BM_TM_TO_LANL3FE_QUEUE_MAP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd5               :  3 ;
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd6               :  3 ;
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd7               :  3 ;
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd8               :  3 ;
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_LANL3FE_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP          0xf4302128
#define L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_dft      0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP           0xf430212c
#define L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_dft       0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tm_dpid_sel_0        :  4 ; /* bits 3:0 */
    ca_uint32_t tm_dpid_sel_1        :  4 ; /* bits 7:4 */
    ca_uint32_t tm_dpid_sel_2        :  4 ; /* bits 11:8 */
    ca_uint32_t tm_dpid_sel_3        :  4 ; /* bits 15:12 */
    ca_uint32_t tm_dpid_sel_4        :  4 ; /* bits 19:16 */
    ca_uint32_t tm_dpid_sel_5        :  4 ; /* bits 23:20 */
    ca_uint32_t tm_dpid_sel_6        :  4 ; /* bits 27:24 */
    ca_uint32_t tm_dpid_sel_7        :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_DQ_PCNT                  0xf4302130
#define L2TM_L2TM_BM_RX_DQ_PCNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DQ_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_DQ_DPCNT                 0xf4302134
#define L2TM_L2TM_BM_RX_DQ_DPCNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DQ_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_DQ_ABR_DPCNT             0xf4302138
#define L2TM_L2TM_BM_RX_DQ_ABR_DPCNT_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DQ_ABR_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_PCNT                     0xf430213c
#define L2TM_L2TM_BM_RX_PCNT_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TX_PCNT                     0xf4302140
#define L2TM_L2TM_BM_TX_PCNT_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_SB_DPCNT                    0xf4302144
#define L2TM_L2TM_BM_SB_DPCNT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_SB_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_HDR_DPCNT                   0xf4302148
#define L2TM_L2TM_BM_HDR_DPCNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_HDR_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TE_DPCNT                    0xf430214c
#define L2TM_L2TM_BM_TE_DPCNT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TE_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_ERR_DPCNT                   0xf4302150
#define L2TM_L2TM_BM_ERR_DPCNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_ERR_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_FC_MIRROR0_DPCNT            0xf4302154
#define L2TM_L2TM_BM_FC_MIRROR0_DPCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_FC_MIRROR1_DPCNT            0xf4302158
#define L2TM_L2TM_BM_FC_MIRROR1_DPCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_FC_MIRROR2_DPCNT            0xf430215c
#define L2TM_L2TM_BM_FC_MIRROR2_DPCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_FC_MIRROR3_DPCNT            0xf4302160
#define L2TM_L2TM_BM_FC_MIRROR3_DPCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_DPCNT                    0xf4302164
#define L2TM_L2TM_BM_RX_DPCNT_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_ABR_DPCNT                0xf4302168
#define L2TM_L2TM_BM_RX_ABR_DPCNT_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_ABR_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_NOBUF_DPCNT                 0xf430216c
#define L2TM_L2TM_BM_NOBUF_DPCNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_NOBUF_DPCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_FE_HEADER_31_0           0xf4302170
#define L2TM_L2TM_BM_RX_FE_HEADER_31_0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_FE_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_FE_HEADER_63_32          0xf4302174
#define L2TM_L2TM_BM_RX_FE_HEADER_63_32_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_FE_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_NI_HEADER_31_0           0xf4302178
#define L2TM_L2TM_BM_RX_NI_HEADER_31_0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_NI_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_RX_NI_HEADER_63_32          0xf430217c
#define L2TM_L2TM_BM_RX_NI_HEADER_63_32_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_NI_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TX_NI_HEADER_31_0           0xf4302180
#define L2TM_L2TM_BM_TX_NI_HEADER_31_0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_NI_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_TX_NI_HEADER_63_32          0xf4302184
#define L2TM_L2TM_BM_TX_NI_HEADER_63_32_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_NI_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_STS                         0xf4302188
#define L2TM_L2TM_BM_STS_dft                     0xff80000a

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fe_tm_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t tm_fe_rdy            :  1 ; /* bits 1:1 */
    ca_uint32_t ni_tm_vld            :  1 ; /* bits 2:2 */
    ca_uint32_t tm_ni_rdy            :  1 ; /* bits 3:3 */
    ca_uint32_t tm_ni_vld            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t dq_ff_empty          :  1 ; /* bits 23:23 */
    ca_uint32_t dq_pack_ff_empty     :  1 ; /* bits 24:24 */
    ca_uint32_t fe_ff_empty          :  1 ; /* bits 25:25 */
    ca_uint32_t pack_ff_empty        :  1 ; /* bits 26:26 */
    ca_uint32_t wdat_ff_empty        :  1 ; /* bits 27:27 */
    ca_uint32_t wcmd_ff_empty        :  1 ; /* bits 28:28 */
    ca_uint32_t rdat_ff_empty        :  1 ; /* bits 29:29 */
    ca_uint32_t rcmd_ff_empty        :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_empty        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_ACCESS              0xf430218c
#define L2TM_L2TM_BM_PKT_MEM_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA7               0xf4302190
#define L2TM_L2TM_BM_PKT_MEM_DATA7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA6               0xf4302194
#define L2TM_L2TM_BM_PKT_MEM_DATA6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA5               0xf4302198
#define L2TM_L2TM_BM_PKT_MEM_DATA5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA4               0xf430219c
#define L2TM_L2TM_BM_PKT_MEM_DATA4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA3               0xf43021a0
#define L2TM_L2TM_BM_PKT_MEM_DATA3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA2               0xf43021a4
#define L2TM_L2TM_BM_PKT_MEM_DATA2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA1               0xf43021a8
#define L2TM_L2TM_BM_PKT_MEM_DATA1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_PKT_MEM_DATA0               0xf43021ac
#define L2TM_L2TM_BM_PKT_MEM_DATA0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_OD_DBG0                     0xf43021b0
#define L2TM_L2TM_BM_OD_DBG0_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t od_dbg0              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_OD_DBG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_BM_OD_DBG1                     0xf43021b4
#define L2TM_L2TM_BM_OD_DBG1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t od_dbg1              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_OD_DBG1_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_bm */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TM_BM_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TM_BM_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TM_BM_INT1_t                      INT1;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TM_BM_INT1E_t                     INT1E;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TM_BM_CTRL_t                      CTRL;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t      TM_TO_9THQ_QUEUE_MAP;          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t      TM_TO_CPUQ_QUEUE_MAP;          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t   TM_TO_CPU256Q_QUEUE_MAP;       /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t        TM_TO_DQ_QUEUE_MAP;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TM_BM_TM_TO_LANL3FE_QUEUE_MAP_t   TM_TO_LANL3FE_QUEUE_MAP;       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t        DQ_TO_TM_QUEUE_MAP;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t         DQ_TO_TM_PORT_MAP;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TM_BM_RX_DQ_PCNT_t                RX_DQ_PCNT;                    /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2TM_L2TM_BM_RX_DQ_DPCNT_t               RX_DQ_DPCNT;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2TM_L2TM_BM_RX_DQ_ABR_DPCNT_t           RX_DQ_ABR_DPCNT;               /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2TM_L2TM_BM_RX_PCNT_t                   RX_PCNT;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2TM_L2TM_BM_TX_PCNT_t                   TX_PCNT;                       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2TM_L2TM_BM_SB_DPCNT_t                  SB_DPCNT;                      /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2TM_L2TM_BM_HDR_DPCNT_t                 HDR_DPCNT;                     /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2TM_L2TM_BM_TE_DPCNT_t                  TE_DPCNT;                      /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2TM_L2TM_BM_ERR_DPCNT_t                 ERR_DPCNT;                     /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t          FC_MIRROR0_DPCNT;              /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t          FC_MIRROR1_DPCNT;              /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t          FC_MIRROR2_DPCNT;              /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t          FC_MIRROR3_DPCNT;              /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L2TM_L2TM_BM_RX_DPCNT_t                  RX_DPCNT;                      /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  L2TM_L2TM_BM_RX_ABR_DPCNT_t              RX_ABR_DPCNT;                  /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  L2TM_L2TM_BM_NOBUF_DPCNT_t               NOBUF_DPCNT;                   /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  L2TM_L2TM_BM_RX_FE_HEADER_31_0_t         RX_FE_HEADER_31_0;             /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  L2TM_L2TM_BM_RX_FE_HEADER_63_32_t        RX_FE_HEADER_63_32;            /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  L2TM_L2TM_BM_RX_NI_HEADER_31_0_t         RX_NI_HEADER_31_0;             /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  L2TM_L2TM_BM_RX_NI_HEADER_63_32_t        RX_NI_HEADER_63_32;            /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  L2TM_L2TM_BM_TX_NI_HEADER_31_0_t         TX_NI_HEADER_31_0;             /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  L2TM_L2TM_BM_TX_NI_HEADER_63_32_t        TX_NI_HEADER_63_32;            /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  L2TM_L2TM_BM_STS_t                       STS;                           /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];
  L2TM_L2TM_BM_PKT_MEM_ACCESS_t            PKT_MEM_ACCESS;                /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];
  L2TM_L2TM_BM_PKT_MEM_DATA7_t             PKT_MEM_DATA7;                 /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];
  L2TM_L2TM_BM_PKT_MEM_DATA6_t             PKT_MEM_DATA6;                 /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];
  L2TM_L2TM_BM_PKT_MEM_DATA5_t             PKT_MEM_DATA5;                 /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];
  L2TM_L2TM_BM_PKT_MEM_DATA4_t             PKT_MEM_DATA4;                 /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];
  L2TM_L2TM_BM_PKT_MEM_DATA3_t             PKT_MEM_DATA3;                 /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];
  L2TM_L2TM_BM_PKT_MEM_DATA2_t             PKT_MEM_DATA2;                 /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];
  L2TM_L2TM_BM_PKT_MEM_DATA1_t             PKT_MEM_DATA1;                 /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];
  L2TM_L2TM_BM_PKT_MEM_DATA0_t             PKT_MEM_DATA0;                 /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];
  L2TM_L2TM_BM_OD_DBG0_t                   OD_DBG0;                       /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];
  L2TM_L2TM_BM_OD_DBG1_t                   OD_DBG1;                       /* addr: 0x000000b4 */
} APB0_L2TM_L2TM_BM_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2tm_qm
 */

#define L2TM_L2TM_QM_INT                         0xf4302200
#define L2TM_L2TM_QM_INT_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t freeq_ecc_correctederr :  1 ; /* bits 0:0 */
    ca_uint32_t freeq_ecc_err        :  1 ; /* bits 1:1 */
    ca_uint32_t voqinfo_cnt_dec_with_novalid :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t nobuf_drop           :  1 ; /* bits 4:4 */
    ca_uint32_t bid_out_of_range     :  1 ; /* bits 5:5 */
    ca_uint32_t wr_race_err          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eq0_stack_err        :  1 ; /* bits 16:16 */
    ca_uint32_t eq1_stack_err        :  1 ; /* bits 17:17 */
    ca_uint32_t enq_ff_undrflo       :  1 ; /* bits 18:18 */
    ca_uint32_t enq_ff_ovrflo        :  1 ; /* bits 19:19 */
    ca_uint32_t deq_ff_undrflo       :  1 ; /* bits 20:20 */
    ca_uint32_t deq_ff_ovrflo        :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_INTE                        0xf4302204
#define L2TM_L2TM_QM_INTE_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t freeq_ecc_correctederrE :  1 ; /* bits 0:0 */
    ca_uint32_t freeq_ecc_errE       :  1 ; /* bits 1:1 */
    ca_uint32_t voqinfo_cnt_dec_with_novalidE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t nobuf_dropE          :  1 ; /* bits 4:4 */
    ca_uint32_t bid_out_of_rangeE    :  1 ; /* bits 5:5 */
    ca_uint32_t wr_race_errE         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eq0_stack_errE       :  1 ; /* bits 16:16 */
    ca_uint32_t eq1_stack_errE       :  1 ; /* bits 17:17 */
    ca_uint32_t enq_ff_undrfloE      :  1 ; /* bits 18:18 */
    ca_uint32_t enq_ff_ovrfloE       :  1 ; /* bits 19:19 */
    ca_uint32_t deq_ff_undrfloE      :  1 ; /* bits 20:20 */
    ca_uint32_t deq_ff_ovrfloE       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_CFG                      0xf4302208
#define L2TM_L2TM_QM_EQ_CFG_dft                  0x00040008

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq0_bufnum           :  5 ; /* bits 4:0 */
    ca_uint32_t eq0_prvt             : 11 ; /* bits 15:5 */
    ca_uint32_t eq1_bufnum           :  4 ; /* bits 19:16 */
    ca_uint32_t eq1_prvt             : 10 ; /* bits 29:20 */
    ca_uint32_t eq0_en               :  1 ; /* bits 30:30 */
    ca_uint32_t eq1_en               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_CFG1                     0xf430220c
#define L2TM_L2TM_QM_EQ_CFG1_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq0_buffer_weight    :  1 ; /* bits 0:0 */
    ca_uint32_t eq1_buffer_weight    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_CFG1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_GLOB_BUF_CFG                0xf4302210
#define L2TM_L2TM_QM_GLOB_BUF_CFG_dft            0x90000020

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t nodrop               : 15 ; /* bits 14:0 */
    ca_uint32_t drop_en              :  1 ; /* bits 15:15 */
    ca_uint32_t noncong              : 15 ; /* bits 30:16 */
    ca_uint32_t fe_bp_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_GLOB_BUF_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_GLOB_BUF_CFG1               0xf4302214
#define L2TM_L2TM_QM_GLOB_BUF_CFG1_dft           0x00000010

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fe_bp_th             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_GLOB_BUF_CFG1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE0          0xf4302218
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE0_dft      0x00100000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE1          0xf430221c
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE1_dft      0x00400020

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE2          0xf4302220
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE2_dft      0x00c00080

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE3          0xf4302224
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE3_dft      0x01400100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_SELECT0           0xf4302228
#define L2TM_L2TM_QM_PORT_PRVT_SELECT0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port0                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t port1                :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t port2                :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t port3                :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t port4                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t port5                :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t port6                :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t port7                :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_SELECT0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_SELECT1           0xf430222c
#define L2TM_L2TM_QM_PORT_PRVT_SELECT1_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port0                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t port1                :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t port2                :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t port3                :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t port4                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t port5                :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t port6                :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t port7                :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_SELECT1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_NO_PRVT_STS            0xf4302230
#define L2TM_L2TM_QM_PORT_NO_PRVT_STS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pid                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_NO_PRVT_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_GLB_FREECNT              0xf4302234
#define L2TM_L2TM_QM_EQ_GLB_FREECNT_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sum_of_eqcnt         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_GLB_FREECNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_COS0_BUFCNT              0xf4302238
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_STRIDE       4
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_COUNT        8
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sum_of_eqcnt         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_COS0_BUFCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS 0xf4302258
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA   0xf430225c
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_FREECNT                  0xf4302260
#define L2TM_L2TM_QM_EQ_FREECNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eq1                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_FREECNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ_HEAD                     0xf4302264
#define L2TM_L2TM_QM_EQ_HEAD_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eq1                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_HEAD_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ0_STACK_CFG               0xf4302268
#define L2TM_L2TM_QM_EQ0_STACK_CFG_dft           0x00302010

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mid_ths              :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t high_ths             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ0_STACK_CTRL              0xf430226c
#define L2TM_L2TM_QM_EQ0_STACK_CTRL_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ0_STACK_STS               0xf4302270
#define L2TM_L2TM_QM_EQ0_STACK_STS_dft           0x00000007

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill_done    :  1 ; /* bits 0:0 */
    ca_uint32_t stack_idle           :  1 ; /* bits 1:1 */
    ca_uint32_t stack_empty          :  1 ; /* bits 2:2 */
    ca_uint32_t stack_full           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t stack_cntr           :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ1_STACK_CFG               0xf4302274
#define L2TM_L2TM_QM_EQ1_STACK_CFG_dft           0x00302010

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mid_ths              :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t high_ths             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ1_STACK_CTRL              0xf4302278
#define L2TM_L2TM_QM_EQ1_STACK_CTRL_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_EQ1_STACK_STS               0xf430227c
#define L2TM_L2TM_QM_EQ1_STACK_STS_dft           0x00000007

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill_done    :  1 ; /* bits 0:0 */
    ca_uint32_t stack_idle           :  1 ; /* bits 1:1 */
    ca_uint32_t stack_empty          :  1 ; /* bits 2:2 */
    ca_uint32_t stack_full           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t stack_cntr           :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_CTRL                        0xf4302280
#define L2TM_L2TM_QM_CTRL_dft                    0x0000000a

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pcnt_dec_with_novalid_allow :  1 ; /* bits 0:0 */
    ca_uint32_t ack_upd_at_same_time :  1 ; /* bits 1:1 */
    ca_uint32_t l3fe_dpid_delay      :  1 ; /* bits 2:2 */
    ca_uint32_t same_dpid_delay      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_STS                         0xf4302284
#define L2TM_L2TM_QM_STS_dft                     0x000c0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t plm_nempty           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t enq_ff_empty         :  1 ; /* bits 18:18 */
    ca_uint32_t deq_ff_empty         :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_STS1                        0xf4302288
#define L2TM_L2TM_QM_STS1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t init_adr             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t init_data            :  8 ; /* bits 23:16 */
    ca_uint32_t freeq_cs             :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t sm_reset             :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_STS1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_FREEQ_MEM_ACCESS            0xf430228c
#define L2TM_L2TM_QM_FREEQ_MEM_ACCESS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_FREEQ_MEM_DATA1             0xf4302290
#define L2TM_L2TM_QM_FREEQ_MEM_DATA1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ecc                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_FREEQ_MEM_DATA0             0xf4302294
#define L2TM_L2TM_QM_FREEQ_MEM_DATA0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t blen                 :  7 ; /* bits 6:0 */
    ca_uint32_t eqid                 :  1 ; /* bits 7:7 */
    ca_uint32_t eop                  :  1 ; /* bits 8:8 */
    ca_uint32_t sop                  :  1 ; /* bits 9:9 */
    ca_uint32_t cpu                  :  1 ; /* bits 10:10 */
    ca_uint32_t prvt                 :  1 ; /* bits 11:11 */
    ca_uint32_t nxt_ptr              : 15 ; /* bits 26:12 */
    ca_uint32_t ecc                  :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQINFO_MEM_ACCESS          0xf4302298
#define L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQINFO_MEM_DATA1           0xf430229c
#define L2TM_L2TM_QM_VOQINFO_MEM_DATA1_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tail_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t vallid               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQINFO_MEM_DATA0           0xf43022a0
#define L2TM_L2TM_QM_VOQINFO_MEM_DATA0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t blen                 :  7 ; /* bits 6:0 */
    ca_uint32_t eqid                 :  1 ; /* bits 7:7 */
    ca_uint32_t eop                  :  1 ; /* bits 8:8 */
    ca_uint32_t sop                  :  1 ; /* bits 9:9 */
    ca_uint32_t cpu                  :  1 ; /* bits 10:10 */
    ca_uint32_t prvt                 :  1 ; /* bits 11:11 */
    ca_uint32_t head_ptr             : 15 ; /* bits 26:12 */
    ca_uint32_t tail_ptr             :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS         0xf43022a4
#define L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA           0xf43022a8
#define L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_qm */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TM_QM_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TM_QM_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TM_QM_EQ_CFG_t                    EQ_CFG;                        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TM_QM_EQ_CFG1_t                   EQ_CFG1;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TM_QM_GLOB_BUF_CFG_t              GLOB_BUF_CFG;                  /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TM_QM_GLOB_BUF_CFG1_t             GLOB_BUF_CFG1;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t        PORT_PRVT_PROFILE0;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t        PORT_PRVT_PROFILE1;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t        PORT_PRVT_PROFILE2;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t        PORT_PRVT_PROFILE3;            /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TM_QM_PORT_PRVT_SELECT0_t         PORT_PRVT_SELECT0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2TM_L2TM_QM_PORT_PRVT_SELECT1_t         PORT_PRVT_SELECT1;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TM_QM_PORT_NO_PRVT_STS_t          PORT_NO_PRVT_STS;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2TM_L2TM_QM_EQ_GLB_FREECNT_t            EQ_GLB_FREECNT;                /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2TM_L2TM_QM_EQ_COS0_BUFCNT_t            EQ_COS0_BUFCNT;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[31];
  L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t PORT_PRVT_BUFCNT_MEM_ACCESS;   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd16[3];
  L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t PORT_PRVT_BUFCNT_MEM_DATA;     /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd17[3];
  L2TM_L2TM_QM_EQ_FREECNT_t                EQ_FREECNT;                    /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd18[3];
  L2TM_L2TM_QM_EQ_HEAD_t                   EQ_HEAD;                       /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd19[3];
  L2TM_L2TM_QM_EQ0_STACK_CFG_t             EQ0_STACK_CFG;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd20[3];
  L2TM_L2TM_QM_EQ0_STACK_CTRL_t            EQ0_STACK_CTRL;                /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd21[3];
  L2TM_L2TM_QM_EQ0_STACK_STS_t             EQ0_STACK_STS;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd22[3];
  L2TM_L2TM_QM_EQ1_STACK_CFG_t             EQ1_STACK_CFG;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd23[3];
  L2TM_L2TM_QM_EQ1_STACK_CTRL_t            EQ1_STACK_CTRL;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd24[3];
  L2TM_L2TM_QM_EQ1_STACK_STS_t             EQ1_STACK_STS;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd25[3];
  L2TM_L2TM_QM_CTRL_t                      CTRL;                          /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd26[3];
  L2TM_L2TM_QM_STS_t                       STS;                           /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd27[3];
  L2TM_L2TM_QM_STS1_t                      STS1;                          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd28[3];
  L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t          FREEQ_MEM_ACCESS;              /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd29[3];
  L2TM_L2TM_QM_FREEQ_MEM_DATA1_t           FREEQ_MEM_DATA1;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd30[3];
  L2TM_L2TM_QM_FREEQ_MEM_DATA0_t           FREEQ_MEM_DATA0;               /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd31[3];
  L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t        VOQINFO_MEM_ACCESS;            /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd32[3];
  L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t         VOQINFO_MEM_DATA1;             /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd33[3];
  L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t         VOQINFO_MEM_DATA0;             /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd34[3];
  L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t       VOQ_PCNT_MEM_ACCESS;           /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd35[3];
  L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t         VOQ_PCNT_MEM_DATA;             /* addr: 0x000000a8 */
} APB0_L2TM_L2TM_QM_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2tm_es
 */

#define L2TM_L2TM_ES_CTRL                        0xf4302300
#define L2TM_L2TM_ES_CTRL_dft                    0x24000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tx_port0_en          :  1 ; /* bits 0:0 */
    ca_uint32_t tx_port1_en          :  1 ; /* bits 1:1 */
    ca_uint32_t tx_port2_en          :  1 ; /* bits 2:2 */
    ca_uint32_t tx_port3_en          :  1 ; /* bits 3:3 */
    ca_uint32_t tx_port4_en          :  1 ; /* bits 4:4 */
    ca_uint32_t tx_port5_en          :  1 ; /* bits 5:5 */
    ca_uint32_t tx_port6_en          :  1 ; /* bits 6:6 */
    ca_uint32_t tx_port7_en          :  1 ; /* bits 7:7 */
    ca_uint32_t tx_port8_en          :  1 ; /* bits 8:8 */
    ca_uint32_t tx_port9_en          :  1 ; /* bits 9:9 */
    ca_uint32_t tx_port10_en         :  1 ; /* bits 10:10 */
    ca_uint32_t tx_port11_en         :  1 ; /* bits 11:11 */
    ca_uint32_t tx_port12_en         :  1 ; /* bits 12:12 */
    ca_uint32_t tx_port13_en         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tx_port15_en         :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 10 ;
    ca_uint32_t ni_port_rdy_10_deglitch :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t ni_port_rdy_13_deglitch :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t tx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_SCH_CFG0                    0xf4302304
#define L2TM_L2TM_ES_SCH_CFG0_STRIDE             12
#define L2TM_L2TM_ES_SCH_CFG0_COUNT              15
#define L2TM_L2TM_ES_SCH_CFG0_dft                0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_en               :  8 ; /* bits 7:0 */
    ca_uint32_t flush_voqid          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t flush_en             :  1 ; /* bits 15:15 */
    ca_uint32_t speed                :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_SCH_CFG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0    0xf4302308
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_STRIDE 12
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_COUNT 15
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq0                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq1                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq2                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq3                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0    0xf430230c
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_STRIDE 12
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_COUNT 15
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq4                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq5                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq6                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq7                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG    0xf43023b8
#define L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port0                :  8 ; /* bits 7:0 */
    ca_uint32_t port1                :  8 ; /* bits 15:8 */
    ca_uint32_t port2                :  8 ; /* bits 23:16 */
    ca_uint32_t port3                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG    0xf43023bc
#define L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port4                :  8 ; /* bits 7:0 */
    ca_uint32_t port5                :  8 ; /* bits 15:8 */
    ca_uint32_t port6                :  8 ; /* bits 23:16 */
    ca_uint32_t port7                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG   0xf43023c0
#define L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port8                :  8 ; /* bits 7:0 */
    ca_uint32_t port9                :  8 ; /* bits 15:8 */
    ca_uint32_t port10               :  8 ; /* bits 23:16 */
    ca_uint32_t port11               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG  0xf43023c4
#define L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_dft 0x01000101

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port12               :  8 ; /* bits 7:0 */
    ca_uint32_t port13               :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t port15               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_DRR_WEIGHT_BASE             0xf43023c8
#define L2TM_L2TM_ES_DRR_WEIGHT_BASE_dft         0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t w_rate               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t base_select          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t dwrr_unit            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_DRR_WEIGHT_BASE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_CFG                         0xf43023cc
#define L2TM_L2TM_ES_CFG_dft                     0x00000740

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sch_ack_len          :  8 ; /* bits 7:0 */
    ca_uint32_t sch_sync_upd         :  1 ; /* bits 8:8 */
    ca_uint32_t sch_rr_grant         :  1 ; /* bits 9:9 */
    ca_uint32_t sch_ack_solo         :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_STS                         0xf43023d0
#define L2TM_L2TM_ES_STS_dft                     0x00003fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ni_port_rdy          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_STS0                    0xf43023d4
#define L2TM_L2TM_ES_VOQ_STS0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_STS1                    0xf43023d8
#define L2TM_L2TM_ES_VOQ_STS1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_STS2                    0xf43023dc
#define L2TM_L2TM_ES_VOQ_STS2_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_STS3                    0xf43023e0
#define L2TM_L2TM_ES_VOQ_STS3_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_OK_STS0                 0xf43023e4
#define L2TM_L2TM_ES_VOQ_OK_STS0_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_OK_STS1                 0xf43023e8
#define L2TM_L2TM_ES_VOQ_OK_STS1_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_OK_STS2                 0xf43023ec
#define L2TM_L2TM_ES_VOQ_OK_STS2_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_VOQ_OK_STS3                 0xf43023f0
#define L2TM_L2TM_ES_VOQ_OK_STS3_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_PORT_OK_STS                 0xf43023f4
#define L2TM_L2TM_ES_PORT_OK_STS_dft             0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pid                  : 16 ; /* bits 15:0 */
    ca_uint32_t voq_grp              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT_OK_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_ABR_STS                     0xf43023f8
#define L2TM_L2TM_ES_ABR_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port7_voq_abr_drop_sts :  8 ; /* bits 7:0 */
    ca_uint32_t port7_abr_ovthrsh    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_ABR_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TM_ES_ABR_FLUSH_PCNT              0xf43023fc
#define L2TM_L2TM_ES_ABR_FLUSH_PCNT_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_ABR_FLUSH_PCNT_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_es */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TM_ES_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TM_ES_SCH_CFG0_t                  SCH_CFG0;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t  VOQ3_0_WEIGHT_RATIO_CFG0;      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t  VOQ7_4_WEIGHT_RATIO_CFG0;      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[171];
  L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t  PORT3_0_WEIGHT_RATIO_CFG;      /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t  PORT7_4_WEIGHT_RATIO_CFG;      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t PORT11_8_WEIGHT_RATIO_CFG;     /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t PORT15_12_WEIGHT_RATIO_CFG;    /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TM_ES_DRR_WEIGHT_BASE_t           DRR_WEIGHT_BASE;               /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TM_ES_CFG_t                       CFG;                           /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TM_ES_STS_t                       STS;                           /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd11[3];
  L2TM_L2TM_ES_VOQ_STS0_t                  VOQ_STS0;                      /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TM_ES_VOQ_STS1_t                  VOQ_STS1;                      /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd13[3];
  L2TM_L2TM_ES_VOQ_STS2_t                  VOQ_STS2;                      /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd14[3];
  L2TM_L2TM_ES_VOQ_STS3_t                  VOQ_STS3;                      /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd15[3];
  L2TM_L2TM_ES_VOQ_OK_STS0_t               VOQ_OK_STS0;                   /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd16[3];
  L2TM_L2TM_ES_VOQ_OK_STS1_t               VOQ_OK_STS1;                   /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd17[3];
  L2TM_L2TM_ES_VOQ_OK_STS2_t               VOQ_OK_STS2;                   /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd18[3];
  L2TM_L2TM_ES_VOQ_OK_STS3_t               VOQ_OK_STS3;                   /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd19[3];
  L2TM_L2TM_ES_PORT_OK_STS_t               PORT_OK_STS;                   /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd20[3];
  L2TM_L2TM_ES_ABR_STS_t                   ABR_STS;                       /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd21[3];
  L2TM_L2TM_ES_ABR_FLUSH_PCNT_t            ABR_FLUSH_PCNT;                /* addr: 0x000000fc */
} APB0_L2TM_L2TM_ES_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2te_glb
 */

#define L2TM_L2TE_GLB_REV_ID                     0xf4302400
#define L2TM_L2TE_GLB_REV_ID_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_REV_ID_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_CTRL                       0xf4302404
#define L2TM_L2TE_GLB_CTRL_dft                   0x07000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_en               :  1 ; /* bits 0:0 */
    ca_uint32_t shp_en               :  1 ; /* bits 1:1 */
    ca_uint32_t taildrop_en          :  1 ; /* bits 2:2 */
    ca_uint32_t wred_en              :  1 ; /* bits 3:3 */
    ca_uint32_t mark_ecn_en          :  1 ; /* bits 4:4 */
    ca_uint32_t pol_ecn_en           :  1 ; /* bits 5:5 */
    ca_uint32_t wred_ecn_en          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t port8_empty_sel      :  1 ; /* bits 14:14 */
    ca_uint32_t snoop_l3_voq_taildrop_dis :  1 ; /* bits 15:15 */
    ca_uint32_t glb_deepq_port_rdy_en :  8 ; /* bits 23:16 */
    ca_uint32_t glb_deepq_port_rdy_id :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t puc_tqm_voqbp_7_0_dis :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_INT                        0xf4302408
#define L2TM_L2TE_GLB_INT_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_mark             :  1 ; /* bits 0:0 */
    ca_uint32_t pol_drop             :  1 ; /* bits 1:1 */
    ca_uint32_t tail_drop            :  1 ; /* bits 2:2 */
    ca_uint32_t wred_y_drop          :  1 ; /* bits 3:3 */
    ca_uint32_t wred_g_drop          :  1 ; /* bits 4:4 */
    ca_uint32_t ecn                  :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t feio                 :  1 ; /* bits 14:14 */
    ca_uint32_t tmio                 :  1 ; /* bits 15:15 */
    ca_uint32_t cb                   :  1 ; /* bits 16:16 */
    ca_uint32_t fc                   :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_INTE                       0xf430240c
#define L2TM_L2TE_GLB_INTE_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_markE            :  1 ; /* bits 0:0 */
    ca_uint32_t pol_dropE            :  1 ; /* bits 1:1 */
    ca_uint32_t tail_dropE           :  1 ; /* bits 2:2 */
    ca_uint32_t wred_y_dropE         :  1 ; /* bits 3:3 */
    ca_uint32_t wred_g_dropE         :  1 ; /* bits 4:4 */
    ca_uint32_t ecnE                 :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t feioE                :  1 ; /* bits 14:14 */
    ca_uint32_t tmioE                :  1 ; /* bits 15:15 */
    ca_uint32_t cbE                  :  1 ; /* bits 16:16 */
    ca_uint32_t fcE                  :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_STS                        0xf4302410
#define L2TM_L2TE_GLB_STS_dft                    0x07000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_fifo_ovrn        :  1 ; /* bits 0:0 */
    ca_uint32_t l2io_fifo_ovrn       :  1 ; /* bits 1:1 */
    ca_uint32_t qmio_enq_ovrn        :  1 ; /* bits 2:2 */
    ca_uint32_t qmio_deq_ovrn        :  1 ; /* bits 3:3 */
    ca_uint32_t qmio_shp_ovrn        :  1 ; /* bits 4:4 */
    ca_uint32_t te_qm_nrdy           :  1 ; /* bits 5:5 */
    ca_uint32_t ptp_fifo_err         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t pol_init_done        :  1 ; /* bits 12:12 */
    ca_uint32_t shp_init_done        :  1 ; /* bits 13:13 */
    ca_uint32_t cb_init_done         :  1 ; /* bits 14:14 */
    ca_uint32_t wred_init_done       :  1 ; /* bits 15:15 */
    ca_uint32_t feio_sm              :  4 ; /* bits 19:16 */
    ca_uint32_t fe_te_req            :  1 ; /* bits 20:20 */
    ca_uint32_t te_fe_ack            :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t l2io_idle            :  1 ; /* bits 24:24 */
    ca_uint32_t qmio_idle            :  1 ; /* bits 25:25 */
    ca_uint32_t ptp_fifo_idle        :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_PTP_CFG                    0xf4302414
#define L2TM_L2TE_GLB_PTP_CFG_dft                0x000007ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pol_id               :  8 ; /* bits 7:0 */
    ca_uint32_t pol_grp_id           :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pol_en               :  1 ; /* bits 12:12 */
    ca_uint32_t pol_grp_en           :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_PTP_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SPARE_CFG                  0xf4302418
#define L2TM_L2TE_GLB_SPARE_CFG_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SPARE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SPARE_STS                  0xf430241c
#define L2TM_L2TE_GLB_SPARE_STS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SPARE_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_0        0xf4302420
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_0_dft    0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t test_cfg2            :  8 ; /* bits 23:16 */
    ca_uint32_t test_cfg3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_1        0xf4302424
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_1_dft    0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t test_cfg2            :  8 ; /* bits 23:16 */
    ca_uint32_t test_cfg3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_2        0xf4302428
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_2_dft    0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t test_cfg2            :  8 ; /* bits 23:16 */
    ca_uint32_t test_cfg3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_3        0xf430242c
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_3_dft    0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t test_cfg2            :  8 ; /* bits 23:16 */
    ca_uint32_t test_cfg3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_4        0xf4302430
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_4_dft    0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t test_cfg2            :  8 ; /* bits 23:16 */
    ca_uint32_t test_cfg3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_4_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_glb */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TE_GLB_REV_ID_t                   REV_ID;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TE_GLB_CTRL_t                     CTRL;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TE_GLB_INT_t                      INT;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TE_GLB_INTE_t                     INTE;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TE_GLB_STS_t                      STS;                           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TE_GLB_PTP_CFG_t                  PTP_CFG;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TE_GLB_SPARE_CFG_t                SPARE_CFG;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TE_GLB_SPARE_STS_t                SPARE_STS;                     /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TE_GLB_SRAM_TEST_CONTROL_0_t      SRAM_TEST_CONTROL_0;           /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TE_GLB_SRAM_TEST_CONTROL_1_t      SRAM_TEST_CONTROL_1;           /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TE_GLB_SRAM_TEST_CONTROL_2_t      SRAM_TEST_CONTROL_2;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2TM_L2TE_GLB_SRAM_TEST_CONTROL_3_t      SRAM_TEST_CONTROL_3;           /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TE_GLB_SRAM_TEST_CONTROL_4_t      SRAM_TEST_CONTROL_4;           /* addr: 0x00000030 */
} APB0_L2TM_L2TE_GLB_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2te_pol
 */

#define L2TM_L2TE_POL_PKT_TYPE_CTRL0             0xf4302500
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_STRIDE      4
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_COUNT       16
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_dft         0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS 0xf4302540
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2 0xf4302544
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1 0xf4302548
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0 0xf430254c
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS 0xf4302550
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1 0xf4302554
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0 0xf4302558
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_CTRL0                 0xf430255c
#define L2TM_L2TE_POL_PORT_CTRL0_STRIDE          4
#define L2TM_L2TE_POL_PORT_CTRL0_COUNT           16
#define L2TM_L2TE_POL_PORT_CTRL0_dft             0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS    0xf430259c
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2     0xf43025a0
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1     0xf43025a4
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0     0xf43025a8
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS    0xf43025ac
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1     0xf43025b0
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0     0xf43025b4
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_CTRL0              0xf43025b8
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_STRIDE       4
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_COUNT        8
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_dft          0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS 0xf43025d8
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2  0xf43025dc
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1  0xf43025e0
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0  0xf43025e4
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS 0xf43025e8
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1  0xf43025ec
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0  0xf43025f0
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_TB_CTRL                    0xf43025f4
#define L2TM_L2TE_POL_TB_CTRL_dft                0x2ff3e723

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addtok_en            :  1 ; /* bits 0:0 */
    ca_uint32_t subtok_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t upd_cnt_lmt          :  4 ; /* bits 7:4 */
    ca_uint32_t cyc_cnt_lmt          : 12 ; /* bits 19:8 */
    ca_uint32_t last_upd_cyc         : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_TB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_POL_TB_CTRL1                   0xf43025f8
#define L2TM_L2TE_POL_TB_CTRL1_dft               0x000001f3

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t k_cnt_lmt            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_TB_CTRL1_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_pol */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TE_POL_PKT_TYPE_CTRL0_t           PKT_TYPE_CTRL0;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[63];
  L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t PKT_TYPE_PROFILE_MEM_ACCESS;   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t PKT_TYPE_PROFILE_MEM_DATA2;    /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t PKT_TYPE_PROFILE_MEM_DATA1;    /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t PKT_TYPE_PROFILE_MEM_DATA0;    /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t PKT_TYPE_COUNTER_MEM_ACCESS;   /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t PKT_TYPE_COUNTER_MEM_DATA1;    /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t PKT_TYPE_COUNTER_MEM_DATA0;    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TE_POL_PORT_CTRL0_t               PORT_CTRL0;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd9[63];
  L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t  PORT_PROFILE_MEM_ACCESS;       /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t   PORT_PROFILE_MEM_DATA2;        /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd11[3];
  L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t   PORT_PROFILE_MEM_DATA1;        /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t   PORT_PROFILE_MEM_DATA0;        /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd13[3];
  L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t  PORT_COUNTER_MEM_ACCESS;       /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd14[3];
  L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t   PORT_COUNTER_MEM_DATA1;        /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd15[3];
  L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t   PORT_COUNTER_MEM_DATA0;        /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd16[3];
  L2TM_L2TE_POL_AGRFLOW_CTRL0_t            AGRFLOW_CTRL0;                 /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd17[31];
  L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t AGRFLOW_PROFILE_MEM_ACCESS;    /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd18[3];
  L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t AGRFLOW_PROFILE_MEM_DATA2;     /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd19[3];
  L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t AGRFLOW_PROFILE_MEM_DATA1;     /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd20[3];
  L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t AGRFLOW_PROFILE_MEM_DATA0;     /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd21[3];
  L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t AGRFLOW_COUNTER_MEM_ACCESS;    /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd22[3];
  L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t AGRFLOW_COUNTER_MEM_DATA1;     /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd23[3];
  L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t AGRFLOW_COUNTER_MEM_DATA0;     /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd24[3];
  L2TM_L2TE_POL_TB_CTRL_t                  TB_CTRL;                       /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd25[3];
  L2TM_L2TE_POL_TB_CTRL1_t                 TB_CTRL1;                      /* addr: 0x000000f8 */
} APB0_L2TM_L2TE_POL_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2te_shp
 */

#define L2TM_L2TE_SHP_IPG_PROFILE                0xf4302700
#define L2TM_L2TE_SHP_IPG_PROFILE_dft            0x14141414

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ipg0                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t ipg1                 :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ipg2                 :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t ipg3                 :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_IPG_PROFILE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_PORT_IPG_SELECT0           0xf4302704
#define L2TM_L2TE_SHP_PORT_IPG_SELECT0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pid0                 :  2 ; /* bits 1:0 */
    ca_uint32_t pid1                 :  2 ; /* bits 3:2 */
    ca_uint32_t pid2                 :  2 ; /* bits 5:4 */
    ca_uint32_t pid3                 :  2 ; /* bits 7:6 */
    ca_uint32_t pid4                 :  2 ; /* bits 9:8 */
    ca_uint32_t pid5                 :  2 ; /* bits 11:10 */
    ca_uint32_t pid6                 :  2 ; /* bits 13:12 */
    ca_uint32_t pid7                 :  2 ; /* bits 15:14 */
    ca_uint32_t pid8                 :  2 ; /* bits 17:16 */
    ca_uint32_t pid9                 :  2 ; /* bits 19:18 */
    ca_uint32_t pid10                :  2 ; /* bits 21:20 */
    ca_uint32_t pid11                :  2 ; /* bits 23:22 */
    ca_uint32_t pid12                :  2 ; /* bits 25:24 */
    ca_uint32_t pid13                :  2 ; /* bits 27:26 */
    ca_uint32_t pid14                :  2 ; /* bits 29:28 */
    ca_uint32_t pid15                :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_IPG_SELECT0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_SRP_CONFIG0                0xf4302708
#define L2TM_L2TE_SHP_SRP_CONFIG0_STRIDE         4
#define L2TM_L2TE_SHP_SRP_CONFIG0_COUNT          2
#define L2TM_L2TE_SHP_SRP_CONFIG0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cfg0_enb             :  1 ; /* bits 0:0 */
    ca_uint32_t cfg0_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t cfg0_class_b         :  1 ; /* bits 15:15 */
    ca_uint32_t cfg1_enb             :  1 ; /* bits 16:16 */
    ca_uint32_t cfg1_cos             :  3 ; /* bits 19:17 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t cfg1_class_b         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_SRP_CONFIG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_SRP_CONFIG_EN              0xf4302710
#define L2TM_L2TE_SHP_SRP_CONFIG_EN_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pid0                 :  4 ; /* bits 3:0 */
    ca_uint32_t pid1                 :  4 ; /* bits 7:4 */
    ca_uint32_t pid2                 :  4 ; /* bits 11:8 */
    ca_uint32_t pid3                 :  4 ; /* bits 15:12 */
    ca_uint32_t pid4                 :  4 ; /* bits 19:16 */
    ca_uint32_t pid5                 :  4 ; /* bits 23:20 */
    ca_uint32_t pid6                 :  4 ; /* bits 27:24 */
    ca_uint32_t pid7                 :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_SRP_CONFIG_EN_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_CTRL                       0xf4302714
#define L2TM_L2TE_SHP_CTRL_dft                   0x0000007c

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt_mode_class0_cnt  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pkt_mode_class1_cnt  :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS        0xf4302718
#define L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1         0xf430271c
#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0         0xf4302720
#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS       0xf4302724
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1        0xf4302728
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0        0xf430272c
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS         0xf4302730
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1          0xf4302734
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0          0xf4302738
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_AGR_SHP_CFG                0xf430273c
#define L2TM_L2TE_SHP_AGR_SHP_CFG_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port_agr_bitmap      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_AGR_SHP_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_AGR_SHP_CTRL1              0xf4302740
#define L2TM_L2TE_SHP_AGR_SHP_CTRL1_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cbs                  : 10 ; /* bits 9:0 */
    ca_uint32_t enb                  :  2 ; /* bits 11:10 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_AGR_SHP_CTRL1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_AGR_SHP_CTRL0              0xf4302744
#define L2TM_L2TE_SHP_AGR_SHP_CTRL0_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_AGR_SHP_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_AGR_SHP_STS                0xf4302748
#define L2TM_L2TE_SHP_AGR_SHP_STS_dft            0x00100000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tbc                  : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_AGR_SHP_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_TB_CTRL                    0xf430274c
#define L2TM_L2TE_SHP_TB_CTRL_dft                0x2ff3e723

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addtok_en            :  1 ; /* bits 0:0 */
    ca_uint32_t subtok_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t upd_cnt_lmt          :  4 ; /* bits 7:4 */
    ca_uint32_t cyc_cnt_lmt          : 12 ; /* bits 19:8 */
    ca_uint32_t last_upd_cyc         : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_TB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_SHP_TB_CTRL1                   0xf4302750
#define L2TM_L2TE_SHP_TB_CTRL1_dft               0x000001f3

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t k_cnt_lmt            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_TB_CTRL1_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_shp */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TE_SHP_IPG_PROFILE_t              IPG_PROFILE;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TE_SHP_PORT_IPG_SELECT0_t         PORT_IPG_SELECT0;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TE_SHP_SRP_CONFIG0_t              SRP_CONFIG0;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[7];
  L2TM_L2TE_SHP_SRP_CONFIG_EN_t            SRP_CONFIG_EN;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TE_SHP_CTRL_t                     CTRL;                          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t      PORT_TBC_MEM_ACCESS;           /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t       PORT_TBC_MEM_DATA1;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t       PORT_TBC_MEM_DATA0;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t     GROUP_TBC_MEM_ACCESS;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t      GROUP_TBC_MEM_DATA1;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t      GROUP_TBC_MEM_DATA0;           /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd11[3];
  L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t       VOQ_TBC_MEM_ACCESS;            /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t        VOQ_TBC_MEM_DATA1;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd13[3];
  L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t        VOQ_TBC_MEM_DATA0;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd14[3];
  L2TM_L2TE_SHP_AGR_SHP_CFG_t              AGR_SHP_CFG;                   /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd15[3];
  L2TM_L2TE_SHP_AGR_SHP_CTRL1_t            AGR_SHP_CTRL1;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd16[3];
  L2TM_L2TE_SHP_AGR_SHP_CTRL0_t            AGR_SHP_CTRL0;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd17[3];
  L2TM_L2TE_SHP_AGR_SHP_STS_t              AGR_SHP_STS;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd18[3];
  L2TM_L2TE_SHP_TB_CTRL_t                  TB_CTRL;                       /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd19[3];
  L2TM_L2TE_SHP_TB_CTRL1_t                 TB_CTRL1;                      /* addr: 0x00000050 */
} APB0_L2TM_L2TE_SHP_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2te_wred
 */

#define L2TM_L2TE_WRED_CTRL                      0xf4302800
#define L2TM_L2TE_WRED_CTRL_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t fast_decay           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t afgs_weight          :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_AFGS_MEM_ACCESS           0xf4302804
#define L2TM_L2TE_WRED_AFGS_MEM_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 29 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_AFGS_MEM_DATA             0xf4302808
#define L2TM_L2TE_WRED_AFGS_MEM_DATA_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t depth                : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_AFGS_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_ACCESS        0xf430280c
#define L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA7         0xf4302810
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA7_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data_rsvd            :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA6         0xf4302814
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA6_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unmark_idx           :  4 ; /* bits 3:0 */
    ca_uint32_t mark_idx             :  4 ; /* bits 7:4 */
    ca_uint32_t data_rsvd            : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA5         0xf4302818
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA5_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA4         0xf430281c
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA4_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA3         0xf4302820
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA3_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA2         0xf4302824
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA2_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA1         0xf4302828
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA1_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA0         0xf430282c
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA0_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS 0xf4302830
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1  0xf4302834
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel6                 :  3 ; /* bits 2:0 */
    ca_uint32_t sel7                 :  5 ; /* bits 7:3 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0  0xf4302838
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel0                 :  5 ; /* bits 4:0 */
    ca_uint32_t sel1                 :  5 ; /* bits 9:5 */
    ca_uint32_t sel2                 :  5 ; /* bits 14:10 */
    ca_uint32_t sel3                 :  5 ; /* bits 19:15 */
    ca_uint32_t sel4                 :  5 ; /* bits 24:20 */
    ca_uint32_t sel5                 :  5 ; /* bits 29:25 */
    ca_uint32_t sel6                 :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_wred */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TE_WRED_CTRL_t                    CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t         AFGS_MEM_ACCESS;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TE_WRED_AFGS_MEM_DATA_t           AFGS_MEM_DATA;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t      PROFILE_MEM_ACCESS;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t       PROFILE_MEM_DATA7;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t       PROFILE_MEM_DATA6;             /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t       PROFILE_MEM_DATA5;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t       PROFILE_MEM_DATA4;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t       PROFILE_MEM_DATA3;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t       PROFILE_MEM_DATA2;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t       PROFILE_MEM_DATA1;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t       PROFILE_MEM_DATA0;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t PROFILE_SELECT_MEM_ACCESS;     /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t PROFILE_SELECT_MEM_DATA1;      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t PROFILE_SELECT_MEM_DATA0;      /* addr: 0x00000038 */
} APB0_L2TM_L2TE_WRED_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2te_fc_glb
 */

#define L2TM_L2TE_FC_GLB_INT                     0xf4302900
#define L2TM_L2TE_FC_GLB_INT_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rxflowcntl0          :  1 ; /* bits 0:0 */
    ca_uint32_t rxflowcntl1          :  1 ; /* bits 1:1 */
    ca_uint32_t rxflowcntl2          :  1 ; /* bits 2:2 */
    ca_uint32_t rxflowcntl3          :  1 ; /* bits 3:3 */
    ca_uint32_t rxflowcntl4          :  1 ; /* bits 4:4 */
    ca_uint32_t rxflowcntl5          :  1 ; /* bits 5:5 */
    ca_uint32_t rxflowcntl6          :  1 ; /* bits 6:6 */
    ca_uint32_t rxflowcntl7          :  1 ; /* bits 7:7 */
    ca_uint32_t rxflowcntl8          :  1 ; /* bits 8:8 */
    ca_uint32_t rxflowcntl9          :  1 ; /* bits 9:9 */
    ca_uint32_t rxflowcntl10         :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rxflowcntl13         :  1 ; /* bits 13:13 */
    ca_uint32_t rxflowcntl13_qm      :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t txflowcntl0          :  1 ; /* bits 16:16 */
    ca_uint32_t txflowcntl1          :  1 ; /* bits 17:17 */
    ca_uint32_t txflowcntl2          :  1 ; /* bits 18:18 */
    ca_uint32_t txflowcntl3          :  1 ; /* bits 19:19 */
    ca_uint32_t txflowcntl4          :  1 ; /* bits 20:20 */
    ca_uint32_t txflowcntl5          :  1 ; /* bits 21:21 */
    ca_uint32_t txflowcntl6          :  1 ; /* bits 22:22 */
    ca_uint32_t txflowcntl7          :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t txflowcntl9          :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t txflowcntl11         :  1 ; /* bits 27:27 */
    ca_uint32_t txflowcntl12         :  1 ; /* bits 28:28 */
    ca_uint32_t txflowcntl13         :  1 ; /* bits 29:29 */
    ca_uint32_t txflowcntl14         :  1 ; /* bits 30:30 */
    ca_uint32_t txflowcntl15         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_INTE                    0xf4302904
#define L2TM_L2TE_FC_GLB_INTE_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rxflowcntl0E         :  1 ; /* bits 0:0 */
    ca_uint32_t rxflowcntl1E         :  1 ; /* bits 1:1 */
    ca_uint32_t rxflowcntl2E         :  1 ; /* bits 2:2 */
    ca_uint32_t rxflowcntl3E         :  1 ; /* bits 3:3 */
    ca_uint32_t rxflowcntl4E         :  1 ; /* bits 4:4 */
    ca_uint32_t rxflowcntl5E         :  1 ; /* bits 5:5 */
    ca_uint32_t rxflowcntl6E         :  1 ; /* bits 6:6 */
    ca_uint32_t rxflowcntl7E         :  1 ; /* bits 7:7 */
    ca_uint32_t rxflowcntl8E         :  1 ; /* bits 8:8 */
    ca_uint32_t rxflowcntl9E         :  1 ; /* bits 9:9 */
    ca_uint32_t rxflowcntl10E        :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rxflowcntl13E        :  1 ; /* bits 13:13 */
    ca_uint32_t rxflowcntl13_qmE     :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t txflowcntl0E         :  1 ; /* bits 16:16 */
    ca_uint32_t txflowcntl1E         :  1 ; /* bits 17:17 */
    ca_uint32_t txflowcntl2E         :  1 ; /* bits 18:18 */
    ca_uint32_t txflowcntl3E         :  1 ; /* bits 19:19 */
    ca_uint32_t txflowcntl4E         :  1 ; /* bits 20:20 */
    ca_uint32_t txflowcntl5E         :  1 ; /* bits 21:21 */
    ca_uint32_t txflowcntl6E         :  1 ; /* bits 22:22 */
    ca_uint32_t txflowcntl7E         :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t txflowcntl9E         :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t txflowcntl11E        :  1 ; /* bits 27:27 */
    ca_uint32_t txflowcntl12E        :  1 ; /* bits 28:28 */
    ca_uint32_t txflowcntl13E        :  1 ; /* bits 29:29 */
    ca_uint32_t txflowcntl14E        :  1 ; /* bits 30:30 */
    ca_uint32_t txflowcntl15E        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_CTRL                    0xf4302908
#define L2TM_L2TE_FC_GLB_CTRL_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t deepq_rxpfc_en       :  8 ; /* bits 7:0 */
    ca_uint32_t cpu_rxpfc_en         :  8 ; /* bits 15:8 */
    ca_uint32_t l3fewan_rxpfc_en     :  8 ; /* bits 23:16 */
    ca_uint32_t l3felan_rxpfc_en     :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_CTRL_LANL3FE            0xf430290c
#define L2TM_L2TE_FC_GLB_CTRL_LANL3FE_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lanl3fe_rxpfc_en     :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_CTRL_LANL3FE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_STS                     0xf4302910
#define L2TM_L2TE_FC_GLB_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t deepq_rxpfc          :  8 ; /* bits 7:0 */
    ca_uint32_t cpu_rxpfc            :  8 ; /* bits 15:8 */
    ca_uint32_t lanl3fe_rxpfc        :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd1               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_TIMER                   0xf4302914
#define L2TM_L2TE_FC_GLB_TIMER_dft               0x000073ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num_of_cycles        : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t cycle_unit           :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd2               : 16 ;
    ca_uint32_t enable               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_TIMER_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_PFC_CTRL0               0xf4302918
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_STRIDE        8
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_COUNT         2
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cos_bmap             :  8 ; /* bits 7:0 */
    ca_uint32_t port_bmap            :  8 ; /* bits 15:8 */
    ca_uint32_t rxpfc_en             :  1 ; /* bits 16:16 */
    ca_uint32_t txpfc_en             :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_PFC_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_GLB_PFC_CNT0                0xf430291c
#define L2TM_L2TE_FC_GLB_PFC_CNT0_STRIDE         8
#define L2TM_L2TE_FC_GLB_PFC_CNT0_COUNT          2
#define L2TM_L2TE_FC_GLB_PFC_CNT0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_PFC_CNT0_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_fc_glb */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TE_FC_GLB_INT_t                   INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TE_FC_GLB_INTE_t                  INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TE_FC_GLB_CTRL_t                  CTRL;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TE_FC_GLB_CTRL_LANL3FE_t          CTRL_LANL3FE;                  /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TE_FC_GLB_STS_t                   STS;                           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TE_FC_GLB_TIMER_t                 TIMER;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TE_FC_GLB_PFC_CTRL0_t             PFC_CTRL0;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TE_FC_GLB_PFC_CNT0_t              PFC_CNT0;                      /* addr: 0x0000001c */
} APB0_L2TM_L2TE_FC_GLB_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2te_fc[0..13]
 */

#define L2TM_L2TE_FC_CTRL                        0xf4302980
#define L2TM_L2TE_FC_CTRL_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rx_en                :  1 ; /* bits 0:0 */
    ca_uint32_t tx_en                :  1 ; /* bits 1:1 */
    ca_uint32_t src_rate_enforce     :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t stat_pri_sel         :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_STS                         0xf4302984
#define L2TM_L2TE_FC_STS_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rxpfc                :  8 ; /* bits 7:0 */
    ca_uint32_t txpfc                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_FC_STAT                        0xf4302988
#define L2TM_L2TE_FC_STAT_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_num             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t voq                  :  7 ; /* bits 10:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t qm_voq               :  9 ; /* bits 20:12 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t txpfc                :  1 ; /* bits 30:30 */
    ca_uint32_t rxpfc                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_STAT_t;
#endif /* !__ASSEMBLER__ */


#define APB0_L2TM_L2TE_FC_STRIDE          64
#define APB0_L2TM_L2TE_FC_COUNT           14



/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_fc */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TE_FC_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TE_FC_STS_t                       STS;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TE_FC_STAT_t                      STAT;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[55];
} APB0_L2TM_L2TE_FC_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2te_cb
 */

#define L2TM_L2TE_CB_INT                         0xf4302d00
#define L2TM_L2TE_CB_INT_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_bufcnt_udfl      :  1 ; /* bits 0:0 */
    ca_uint32_t voq_bufcnt_ovfl      :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t port_freecnt_udfl    :  1 ; /* bits 4:4 */
    ca_uint32_t port_freecnt_ovfl    :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_INT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_INTE                        0xf4302d04
#define L2TM_L2TE_CB_INTE_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_bufcnt_udflE     :  1 ; /* bits 0:0 */
    ca_uint32_t voq_bufcnt_ovflE     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t port_freecnt_udflE   :  1 ; /* bits 4:4 */
    ca_uint32_t port_freecnt_ovflE   :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_INTE_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_ERR_INFO                    0xf4302d08
#define L2TM_L2TE_CB_ERR_INFO_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_of_buferr        :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_ERR_INFO_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_CTRL                        0xf4302d0c
#define L2TM_L2TE_CB_CTRL_dft                    0x0003ff03

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t scan_cycle_per_run   :  8 ; /* bits 7:0 */
    ca_uint32_t scan_cycle_unit      : 10 ; /* bits 17:8 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t cnt_udfl_allow       :  1 ; /* bits 30:30 */
    ca_uint32_t scan_enable          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0        0xf4302d10
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_STRIDE 4
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_COUNT  2
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dqid                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0       0xf4302d18
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_STRIDE 4
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_COUNT 2
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dqid                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_TM_TAILDROP_STS0            0xf4302d20
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_STRIDE     4
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_COUNT      4
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_TAILDROP_STS0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_QM_TAILDROP_STS0            0xf4302d30
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_STRIDE     4
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_COUNT      12
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_QM_TAILDROP_STS0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_GLOB_TD_STS                 0xf4302d60
#define L2TM_L2TE_CB_GLOB_TD_STS_dft             0x0020ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t per_port_prvt_avl    : 16 ; /* bits 15:0 */
    ca_uint32_t noncong_buf_avl      :  1 ; /* bits 16:16 */
    ca_uint32_t common_buf_avl       :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fc_buf_usg_l         :  1 ; /* bits 21:21 */
    ca_uint32_t fc_buf_usg_m         :  1 ; /* bits 22:22 */
    ca_uint32_t fc_buf_usg_h         :  1 ; /* bits 23:23 */
    ca_uint32_t pfc                  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLOB_TD_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_TD_STS                 0xf4302d64
#define L2TM_L2TE_CB_PORT_TD_STS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port                 : 16 ; /* bits 15:0 */
    ca_uint32_t src_port             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_TD_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_TD_STS0                 0xf4302d68
#define L2TM_L2TE_CB_VOQ_TD_STS0_STRIDE          4
#define L2TM_L2TE_CB_VOQ_TD_STS0_COUNT           4
#define L2TM_L2TE_CB_VOQ_TD_STS0_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_TD_STS0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PRI_TD_STS              0xf4302d78
#define L2TM_L2TE_CB_SRC_PRI_TD_STS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t src_pri              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_TD_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0         0xf4302d7c
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_STRIDE  8
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_COUNT   4
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_dft     0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0      0xf4302d80
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_STRIDE 8
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_dft  0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t grplth               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t grphth               : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_THRSH_SELECT           0xf4302d9c
#define L2TM_L2TE_CB_PORT_THRSH_SELECT_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS 0xf4302da0
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1 0xf4302da4
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t grplth               : 13 ; /* bits 12:0 */
    ca_uint32_t grphth               : 15 ; /* bits 27:13 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0 0xf4302da8
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t hth                  : 15 ; /* bits 29:15 */
    ca_uint32_t grplth               :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS 0xf4302dac
#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA   0xf4302db0
#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS     0xf4302db4
#define L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA       0xf4302db8
#define L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t cnt0_msb             :  1 ; /* bits 15:15 */
    ca_uint32_t cnt1                 : 15 ; /* bits 30:16 */
    ca_uint32_t cnt1_msb             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS       0xf4302dbc
#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA         0xf4302dc0
#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t cnt0_rsvd            :  1 ; /* bits 15:15 */
    ca_uint32_t cnt1                 : 15 ; /* bits 30:16 */
    ca_uint32_t cnt1_rsvd            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS   0xf4302dc4
#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA     0xf4302dc8
#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_GLB_THRSH                   0xf4302dcc
#define L2TM_L2TE_CB_GLB_THRSH_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLB_THRSH_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_GLB_PRI_THRSH0              0xf4302dd0
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_STRIDE       4
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_COUNT        8
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_dft          0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLB_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_CTRL                    0xf4302df0
#define L2TM_L2TE_CB_SRC_CTRL_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t src0_pri_nspid       :  3 ; /* bits 2:0 */
    ca_uint32_t src0_pri_en          :  1 ; /* bits 3:3 */
    ca_uint32_t src1_pri_nspid       :  3 ; /* bits 6:4 */
    ca_uint32_t src1_pri_en          :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0     0xf4302df4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_STRIDE 4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT       0xf4302e04
#define L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC0_PRI_THRSH0             0xf4302e08
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_STRIDE      4
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_COUNT       8
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_dft         0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC0_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC1_PRI_THRSH0             0xf4302e28
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_STRIDE      4
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_COUNT       8
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_dft         0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC1_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS  0xf4302e48
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA    0xf4302e4c
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS   0xf4302e50
#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA     0xf4302e54
#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0     0xf4302e58
#define L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_dft 0x00007fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t th0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0   0xf4302e5c
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_STRIDE 4
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT     0xf4302e6c
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS 0xf4302e70
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA 0xf4302e74
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t hth                  : 15 ; /* bits 29:15 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS 0xf4302e78
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA 0xf4302e7c
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_CTRL                   0xf4302e80
#define L2TM_L2TE_CB_WIFI_CTRL_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t wred_taildrop_dis    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t backpressure_en      : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t febypass_msk         :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_STS                    0xf4302e84
#define L2TM_L2TE_CB_WIFI_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq_profile_ov_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t buffer_ov_threshold  : 12 ; /* bits 19:8 */
    ca_uint32_t wifi_backpressure_on : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_VP0_BUFCNT             0xf4302e88
#define L2TM_L2TE_CB_WIFI_VP0_BUFCNT_STRIDE      4
#define L2TM_L2TE_CB_WIFI_VP0_BUFCNT_COUNT       12
#define L2TM_L2TE_CB_WIFI_VP0_BUFCNT_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_VP0_BUFCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_VP0_BUF_THRSH          0xf4302eb8
#define L2TM_L2TE_CB_WIFI_VP0_BUF_THRSH_STRIDE   4
#define L2TM_L2TE_CB_WIFI_VP0_BUF_THRSH_COUNT    12
#define L2TM_L2TE_CB_WIFI_VP0_BUF_THRSH_dft      0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_VP0_BUF_THRSH_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH       0xf4302ee8
#define L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH_dft   0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_CB_ABR_CTRL                    0xf4302eec
#define L2TM_L2TE_CB_ABR_CTRL_dft                0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t drop_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_ABR_CTRL_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_cb */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TE_CB_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TE_CB_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TE_CB_ERR_INFO_t                  ERR_INFO;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TE_CB_CTRL_t                      CTRL;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t      TM_DQSCH_HI_BUF_USG0;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[7];
  L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t     TM_DQSCH_MID_BUF_USG0;         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd6[7];
  L2TM_L2TE_CB_TM_TAILDROP_STS0_t          TM_TAILDROP_STS0;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd7[15];
  L2TM_L2TE_CB_QM_TAILDROP_STS0_t          QM_TAILDROP_STS0;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd8[47];
  L2TM_L2TE_CB_GLOB_TD_STS_t               GLOB_TD_STS;                   /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TE_CB_PORT_TD_STS_t               PORT_TD_STS;                   /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TE_CB_VOQ_TD_STS0_t               VOQ_TD_STS0;                   /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd11[15];
  L2TM_L2TE_CB_SRC_PRI_TD_STS_t            SRC_PRI_TD_STS;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t       PORT_THRSH_PROFILE0;           /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd13[3];
  L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t    PORT_GRPTHRSH_PROFILE0;        /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd14[27];
  L2TM_L2TE_CB_PORT_THRSH_SELECT_t         PORT_THRSH_SELECT;             /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd15[3];
  L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t VOQ_THRSH_PROFILE_MEM_ACCESS;  /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd16[3];
  L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t VOQ_THRSH_PROFILE_MEM_DATA1;   /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd17[3];
  L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t VOQ_THRSH_PROFILE_MEM_DATA0;   /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd18[3];
  L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t VOQ_THRSH_SELECT_MEM_ACCESS;   /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd19[3];
  L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t VOQ_THRSH_SELECT_MEM_DATA;     /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd20[3];
  L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t   PORT_FREECNT_MEM_ACCESS;       /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd21[3];
  L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t     PORT_FREECNT_MEM_DATA;         /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd22[3];
  L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t     VOQ_BUFCNT_MEM_ACCESS;         /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd23[3];
  L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t       VOQ_BUFCNT_MEM_DATA;           /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd24[3];
  L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t VOQ_MAX_BUFCNT_MEM_ACCESS;     /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd25[3];
  L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t   VOQ_MAX_BUFCNT_MEM_DATA;       /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd26[3];
  L2TM_L2TE_CB_GLB_THRSH_t                 GLB_THRSH;                     /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd27[3];
  L2TM_L2TE_CB_GLB_PRI_THRSH0_t            GLB_PRI_THRSH0;                /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd28[31];
  L2TM_L2TE_CB_SRC_CTRL_t                  SRC_CTRL;                      /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd29[3];
  L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t   SRC_PORT_THRSH_PROFILE0;       /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd30[15];
  L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t     SRC_PORT_THRSH_SELECT;         /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd31[3];
  L2TM_L2TE_CB_SRC0_PRI_THRSH0_t           SRC0_PRI_THRSH0;               /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd32[31];
  L2TM_L2TE_CB_SRC1_PRI_THRSH0_t           SRC1_PRI_THRSH0;               /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd33[31];
  L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t SRC_PORT_BUFCNT_MEM_ACCESS;    /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd34[3];
  L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t  SRC_PORT_BUFCNT_MEM_DATA;      /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd35[3];
  L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t SRC_PRI_BUFCNT_MEM_ACCESS;     /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd36[3];
  L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t   SRC_PRI_BUFCNT_MEM_DATA;       /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd37[3];
  L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t   DQSCH_EQ_PROFILE_THRSH0;       /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd38[3];
  L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t DQSCH_PORT_THRSH_PROFILE0;     /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd39[15];
  L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t   DQSCH_PORT_THRSH_SELECT;       /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd40[3];
  L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS; /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd41[3];
  L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t DQSCH_VOQ_THRSH_PROFILE_MEM_DATA; /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd42[3];
  L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS; /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd43[3];
  L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t DQSCH_VOQ_THRSH_SELECT_MEM_DATA; /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd44[3];
  L2TM_L2TE_CB_WIFI_CTRL_t                 WIFI_CTRL;                     /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd45[3];
  L2TM_L2TE_CB_WIFI_STS_t                  WIFI_STS;                      /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd46[3];
  L2TM_L2TE_CB_WIFI_VP0_BUFCNT_t           WIFI_VP0_BUFCNT;               /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd47[47];
  L2TM_L2TE_CB_WIFI_VP0_BUF_THRSH_t        WIFI_VP0_BUF_THRSH;            /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd48[47];
  L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH_t     WIFI_EQ_PROFILE_THRSH;         /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd49[3];
  L2TM_L2TE_CB_ABR_CTRL_t                  ABR_CTRL;                      /* addr: 0x000001ec */
} APB0_L2TM_L2TE_CB_t;
#endif /* !__ASSEMBLER__ */


/*
 * l2te_pm
 */

#define L2TM_L2TE_PM_CTRL                        0xf4302f00
#define L2TM_L2TE_PM_CTRL_dft                    0x000000a0

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_saturate         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mem_saturate         :  1 ; /* bits 4:4 */
    ca_uint32_t mem_auto_clr_on_read :  1 ; /* bits 5:5 */
    ca_uint32_t mem_init             :  1 ; /* bits 6:6 */
    ca_uint32_t mem_disable          :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_EVENT_CFG_0                 0xf4302f04
#define L2TM_L2TE_PM_EVENT_CFG_0_dft             0x33445550

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0_lo              :  4 ; /* bits 3:0 */
    ca_uint32_t cnt0_hi              :  4 ; /* bits 7:4 */
    ca_uint32_t cnt1_lo              :  4 ; /* bits 11:8 */
    ca_uint32_t cnt1_hi              :  4 ; /* bits 15:12 */
    ca_uint32_t cnt2_lo              :  4 ; /* bits 19:16 */
    ca_uint32_t cnt2_hi              :  4 ; /* bits 23:20 */
    ca_uint32_t cnt3_lo              :  4 ; /* bits 27:24 */
    ca_uint32_t cnt3_hi              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_EVENT_CFG_0_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_STS                         0xf4302f08
#define L2TM_L2TE_PM_STS_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pcnt0_init_done      :  1 ; /* bits 0:0 */
    ca_uint32_t pcnt1_init_done      :  1 ; /* bits 1:1 */
    ca_uint32_t bcnt0_init_done      :  1 ; /* bits 2:2 */
    ca_uint32_t bcnt1_init_done      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_STS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_PCNT                        0xf4302f0c
#define L2TM_L2TE_PM_PCNT_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_PRE_MARK_PCNT               0xf4302f10
#define L2TM_L2TE_PM_PRE_MARK_PCNT_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_PRE_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_POL_DROP_PCNT               0xf4302f14
#define L2TM_L2TE_PM_POL_DROP_PCNT_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_POL_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_TAIL_DROP_PCNT              0xf4302f18
#define L2TM_L2TE_PM_TAIL_DROP_PCNT_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_TAIL_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_WRED_Y_DROP_PCNT            0xf4302f1c
#define L2TM_L2TE_PM_WRED_Y_DROP_PCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_WRED_G_DROP_PCNT            0xf4302f20
#define L2TM_L2TE_PM_WRED_G_DROP_PCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_WRED_G_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_MARK_PCNT                   0xf4302f24
#define L2TM_L2TE_PM_MARK_PCNT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_POL_MARK_PCNT               0xf4302f28
#define L2TM_L2TE_PM_POL_MARK_PCNT_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_POL_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_BYPASS_PCNT                 0xf4302f2c
#define L2TM_L2TE_PM_BYPASS_PCNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_BYPASS_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_BYPASS_FLOW_PCNT            0xf4302f30
#define L2TM_L2TE_PM_BYPASS_FLOW_PCNT_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CE_PCNT                     0xf4302f34
#define L2TM_L2TE_PM_CE_PCNT_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CE_PCNT_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_ACCESS              0xf4302f38
#define L2TM_L2TE_PM_CNT_MEM_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA8               0xf4302f3c
#define L2TM_L2TE_PM_CNT_MEM_DATA8_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt7                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA7               0xf4302f40
#define L2TM_L2TE_PM_CNT_MEM_DATA7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt6                 : 12 ; /* bits 11:0 */
    ca_uint32_t cnt7                 : 20 ; /* bits 31:12 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA6               0xf4302f44
#define L2TM_L2TE_PM_CNT_MEM_DATA6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt5                 :  8 ; /* bits 7:0 */
    ca_uint32_t cnt6                 : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA5               0xf4302f48
#define L2TM_L2TE_PM_CNT_MEM_DATA5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt4                 :  4 ; /* bits 3:0 */
    ca_uint32_t cnt5                 : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA4               0xf4302f4c
#define L2TM_L2TE_PM_CNT_MEM_DATA4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt4                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA3               0xf4302f50
#define L2TM_L2TE_PM_CNT_MEM_DATA3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA2               0xf4302f54
#define L2TM_L2TE_PM_CNT_MEM_DATA2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA1               0xf4302f58
#define L2TM_L2TE_PM_CNT_MEM_DATA1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L2TM_L2TE_PM_CNT_MEM_DATA0               0xf4302f5c
#define L2TM_L2TE_PM_CNT_MEM_DATA0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_pm */
#ifndef __ASSEMBLER__
typedef struct {
  L2TM_L2TE_PM_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L2TM_L2TE_PM_EVENT_CFG_0_t               EVENT_CFG_0;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L2TM_L2TE_PM_STS_t                       STS;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L2TM_L2TE_PM_PCNT_t                      PCNT;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L2TM_L2TE_PM_PRE_MARK_PCNT_t             PRE_MARK_PCNT;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L2TM_L2TE_PM_POL_DROP_PCNT_t             POL_DROP_PCNT;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L2TM_L2TE_PM_TAIL_DROP_PCNT_t            TAIL_DROP_PCNT;                /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t          WRED_Y_DROP_PCNT;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L2TM_L2TE_PM_WRED_G_DROP_PCNT_t          WRED_G_DROP_PCNT;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L2TM_L2TE_PM_MARK_PCNT_t                 MARK_PCNT;                     /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L2TM_L2TE_PM_POL_MARK_PCNT_t             POL_MARK_PCNT;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L2TM_L2TE_PM_BYPASS_PCNT_t               BYPASS_PCNT;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t          BYPASS_FLOW_PCNT;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L2TM_L2TE_PM_CE_PCNT_t                   CE_PCNT;                       /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L2TM_L2TE_PM_CNT_MEM_ACCESS_t            CNT_MEM_ACCESS;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L2TM_L2TE_PM_CNT_MEM_DATA8_t             CNT_MEM_DATA8;                 /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L2TM_L2TE_PM_CNT_MEM_DATA7_t             CNT_MEM_DATA7;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L2TM_L2TE_PM_CNT_MEM_DATA6_t             CNT_MEM_DATA6;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L2TM_L2TE_PM_CNT_MEM_DATA5_t             CNT_MEM_DATA5;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L2TM_L2TE_PM_CNT_MEM_DATA4_t             CNT_MEM_DATA4;                 /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L2TM_L2TE_PM_CNT_MEM_DATA3_t             CNT_MEM_DATA3;                 /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L2TM_L2TE_PM_CNT_MEM_DATA2_t             CNT_MEM_DATA2;                 /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L2TM_L2TE_PM_CNT_MEM_DATA1_t             CNT_MEM_DATA1;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L2TM_L2TE_PM_CNT_MEM_DATA0_t             CNT_MEM_DATA0;                 /* addr: 0x0000005c */
} APB0_L2TM_L2TE_PM_t;
#endif /* !__ASSEMBLER__ */




/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2TM */

#ifndef __ASSEMBLER__
typedef struct {
  APB0_L2TM_L2TM_GLB_t              l2tm_glb;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[237];
  APB0_L2TM_L2TM_BM_t               l2tm_bm;                       /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[165];
  APB0_L2TM_L2TM_QM_t               l2tm_qm;                       /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd3[171];
  APB0_L2TM_L2TM_ES_t               l2tm_es;                       /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd4[129];
  APB0_L2TM_L2TE_GLB_t              l2te_glb;                      /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd5[231];
  APB0_L2TM_L2TE_POL_t              l2te_pol;                      /* addr: 0x00000500 */
  ca_uint32_t                              rsrvd6[387];
  APB0_L2TM_L2TE_SHP_t              l2te_shp;                      /* addr: 0x00000700 */
  ca_uint32_t                              rsrvd7[215];
  APB0_L2TM_L2TE_WRED_t             l2te_wred;                     /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd8[227];
  APB0_L2TM_L2TE_FC_GLB_t           l2te_fc_glb;                   /* addr: 0x00000900 */
  ca_uint32_t                              rsrvd9[109];
  APB0_L2TM_L2TE_FC_t               l2te_fc[14];                   /* addr: 0x00000980 */
  APB0_L2TM_L2TE_CB_t               l2te_cb;                       /* addr: 0x00000d00 */
  ca_uint32_t                              rsrvd10[265];
  APB0_L2TM_L2TE_PM_t               l2te_pm;                       /* addr: 0x00000f00 */
} APB0_L2TM_t;
#endif /* !__ASSEMBLER__ */


/*
 * L3FE
 */

/*
 * GLB
 */

#define L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS         0xf4303000
#define L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA           0xf4303004
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t PPPOE_SET            :  1 ; /* bits 0:0 */
    ca_uint32_t PPPOE_VLD            :  1 ; /* bits 1:1 */
    ca_uint32_t PPPOE_SESSION_ID     : 16 ; /* bits 17:2 */
    ca_uint32_t MAC_SA_VLD           :  1 ; /* bits 18:18 */
    ca_uint32_t MAC_SA_AN_SEL        :  4 ; /* bits 22:19 */
    ca_uint32_t PAD_CTRL             :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DSCP_MAP_TBL_ACCESS             0xf4303008
#define L3FE_GLB_DSCP_MAP_TBL_ACCESS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DSCP_MAP_TBL_DATA1              0xf430300c
#define L3FE_GLB_DSCP_MAP_TBL_DATA1_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dscp_2_pf1_dscp      :  2 ; /* bits 1:0 */
    ca_uint32_t dscp_2_pf1_cos       :  4 ; /* bits 5:2 */
    ca_uint32_t dscp_2_pf1_pol_id    :  9 ; /* bits 14:6 */
    ca_uint32_t dscp_2_pf1_pol_grp_id :  3 ; /* bits 17:15 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DSCP_MAP_TBL_DATA0              0xf4303010
#define L3FE_GLB_DSCP_MAP_TBL_DATA0_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dscp_2_pf0_dot1p     :  3 ; /* bits 2:0 */
    ca_uint32_t dscp_2_pf0_dscp      :  6 ; /* bits 8:3 */
    ca_uint32_t dscp_2_pf0_cos       :  4 ; /* bits 12:9 */
    ca_uint32_t dscp_2_pf0_pol_id    :  9 ; /* bits 21:13 */
    ca_uint32_t dscp_2_pf0_pol_grp_id :  3 ; /* bits 24:22 */
    ca_uint32_t dscp_2_pf1_dot1p     :  3 ; /* bits 27:25 */
    ca_uint32_t dscp_2_pf1_dscp      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_0               0xf4303014
#define L3FE_GLB_DOT1P_MAPPING_0_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_0               0xf4303018
#define L3FE_GLB_DOT1P_MAPPING_1_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_1               0xf430301c
#define L3FE_GLB_DOT1P_MAPPING_0_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_1               0xf4303020
#define L3FE_GLB_DOT1P_MAPPING_1_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_2               0xf4303024
#define L3FE_GLB_DOT1P_MAPPING_0_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_2               0xf4303028
#define L3FE_GLB_DOT1P_MAPPING_1_2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_3               0xf430302c
#define L3FE_GLB_DOT1P_MAPPING_0_3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_3               0xf4303030
#define L3FE_GLB_DOT1P_MAPPING_1_3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_4               0xf4303034
#define L3FE_GLB_DOT1P_MAPPING_0_4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_4               0xf4303038
#define L3FE_GLB_DOT1P_MAPPING_1_4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_5               0xf430303c
#define L3FE_GLB_DOT1P_MAPPING_0_5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_5               0xf4303040
#define L3FE_GLB_DOT1P_MAPPING_1_5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_6               0xf4303044
#define L3FE_GLB_DOT1P_MAPPING_0_6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_6               0xf4303048
#define L3FE_GLB_DOT1P_MAPPING_1_6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_0_7               0xf430304c
#define L3FE_GLB_DOT1P_MAPPING_0_7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DOT1P_MAPPING_1_7               0xf4303050
#define L3FE_GLB_DOT1P_MAPPING_1_7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_0                 0xf4303054
#define L3FE_GLB_COS_MAPPING_0_0_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_0                 0xf4303058
#define L3FE_GLB_COS_MAPPING_1_0_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_1                 0xf430305c
#define L3FE_GLB_COS_MAPPING_0_1_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_1                 0xf4303060
#define L3FE_GLB_COS_MAPPING_1_1_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_2                 0xf4303064
#define L3FE_GLB_COS_MAPPING_0_2_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_2                 0xf4303068
#define L3FE_GLB_COS_MAPPING_1_2_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_3                 0xf430306c
#define L3FE_GLB_COS_MAPPING_0_3_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_3                 0xf4303070
#define L3FE_GLB_COS_MAPPING_1_3_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_4                 0xf4303074
#define L3FE_GLB_COS_MAPPING_0_4_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_4                 0xf4303078
#define L3FE_GLB_COS_MAPPING_1_4_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_5                 0xf430307c
#define L3FE_GLB_COS_MAPPING_0_5_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_5                 0xf4303080
#define L3FE_GLB_COS_MAPPING_1_5_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_6                 0xf4303084
#define L3FE_GLB_COS_MAPPING_0_6_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_6                 0xf4303088
#define L3FE_GLB_COS_MAPPING_1_6_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_0_7                 0xf430308c
#define L3FE_GLB_COS_MAPPING_0_7_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_COS_MAPPING_1_7                 0xf4303090
#define L3FE_GLB_COS_MAPPING_1_7_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_FWD_CTRL_0                      0xf4303094
#define L3FE_GLB_FWD_CTRL_0_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_FWD_CTRL_1                      0xf4303098
#define L3FE_GLB_FWD_CTRL_1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_FWD_CTRL_2                      0xf430309c
#define L3FE_GLB_FWD_CTRL_2_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_FWD_CTRL_3                      0xf43030a0
#define L3FE_GLB_FWD_CTRL_3_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_GLB_CFG                         0xf43030a4
#define L3FE_GLB_GLB_CFG_dft                     0x0001b000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l3fe_port_mmship_chk_en :  1 ; /* bits 0:0 */
    ca_uint32_t use_o_lspid_for_mmshp_chk :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t mc_port              :  6 ; /* bits 17:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ni_fe_12_bv          :  1 ; /* bits 21:21 */
    ca_uint32_t pl_mode              :  2 ; /* bits 23:22 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t l3fe_pon_mode        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_GLB_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LF_CFG                          0xf43030a8
#define L3FE_GLB_LF_CFG_dft                      0x004641f4

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t hi_threshold         : 10 ; /* bits 9:0 */
    ca_uint32_t low_threshold        : 10 ; /* bits 19:10 */
    ca_uint32_t wr_fifo_threshold    :  4 ; /* bits 23:20 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LF_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TE_OPTION                       0xf43030ac
#define L3FE_GLB_TE_OPTION_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bits                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TE_OPTION_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_CLS_STG_MONITOR_CTRL            0xf43030b0
#define L3FE_GLB_CLS_STG_MONITOR_CTRL_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  8 ; /* bits 7:0 */
    ca_uint32_t enable               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_CLS_STG_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_CLS_STG_MONITOR_RETURN          0xf43030b4
#define L3FE_GLB_CLS_STG_MONITOR_RETURN_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_CLS_STG_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DBG_IDX                         0xf43030b8
#define L3FE_GLB_DBG_IDX_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t idx                  : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DBG_IDX_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_DBG_DAT                         0xf43030bc
#define L3FE_GLB_DBG_DAT_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dat                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DBG_DAT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_L3FE_MONITOR_TRIG               0xf43030c0
#define L3FE_GLB_L3FE_MONITOR_TRIG_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   :  1 ; /* bits 0:0 */
    ca_uint32_t mode                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_L3FE_MONITOR_TRIG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_L3FE_MONITOR_CTRL               0xf43030c4
#define L3FE_GLB_L3FE_MONITOR_CTRL_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_L3FE_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_L3FE_MONITOR_RETURN             0xf43030c8
#define L3FE_GLB_L3FE_MONITOR_RETURN_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_L3FE_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_RES_CTRL                        0xf43030cc
#define L3FE_GLB_RES_CTRL_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ttl_0_cpu_en         :  1 ; /* bits 0:0 */
    ca_uint32_t ttl_0_cpu_ldpid      :  6 ; /* bits 6:1 */
    ca_uint32_t ttl_0_cpu_deepq      :  1 ; /* bits 7:7 */
    ca_uint32_t ttl_0_cpu_deepq_vld  :  1 ; /* bits 8:8 */
    ca_uint32_t ttl_0_cpu_keep_org_pkt :  1 ; /* bits 9:9 */
    ca_uint32_t ttl_0_cpu_keep_org_pkt_vld :  1 ; /* bits 10:10 */
    ca_uint32_t ttl_0_cpu_ctrl_bypass :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_RES_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty15          0xf43030d0
#define L3FE_GLB_SRAM_TEST_l3fe_empty15_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest15           :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty15_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty14          0xf43030d4
#define L3FE_GLB_SRAM_TEST_l3fe_empty14_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest14           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty14_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty13          0xf43030d8
#define L3FE_GLB_SRAM_TEST_l3fe_empty13_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest13           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty13_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty12          0xf43030dc
#define L3FE_GLB_SRAM_TEST_l3fe_empty12_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest12           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty12_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty11          0xf43030e0
#define L3FE_GLB_SRAM_TEST_l3fe_empty11_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest11           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty11_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty10          0xf43030e4
#define L3FE_GLB_SRAM_TEST_l3fe_empty10_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest10           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty9           0xf43030e8
#define L3FE_GLB_SRAM_TEST_l3fe_empty9_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest9            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty8           0xf43030ec
#define L3FE_GLB_SRAM_TEST_l3fe_empty8_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest8            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty7           0xf43030f0
#define L3FE_GLB_SRAM_TEST_l3fe_empty7_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest7            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty6           0xf43030f4
#define L3FE_GLB_SRAM_TEST_l3fe_empty6_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest6            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty5           0xf43030f8
#define L3FE_GLB_SRAM_TEST_l3fe_empty5_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest5            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty4           0xf43030fc
#define L3FE_GLB_SRAM_TEST_l3fe_empty4_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest4            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty3           0xf4303100
#define L3FE_GLB_SRAM_TEST_l3fe_empty3_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest3            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty2           0xf4303104
#define L3FE_GLB_SRAM_TEST_l3fe_empty2_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest2            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty1           0xf4303108
#define L3FE_GLB_SRAM_TEST_l3fe_empty1_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest1            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_empty0           0xf430310c
#define L3FE_GLB_SRAM_TEST_l3fe_empty0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest0            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_empty0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_LS_l3fe_empty1             0xf4303110
#define L3FE_GLB_SRAM_LS_l3fe_empty1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramls1              : 29 ; /* bits 28:0 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_LS_l3fe_empty1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_LS_l3fe_empty0             0xf4303114
#define L3FE_GLB_SRAM_LS_l3fe_empty0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramls0              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_LS_l3fe_empty0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_mem3             0xf4303118
#define L3FE_GLB_SRAM_TEST_l3fe_mem3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest3            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_mem3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_mem2             0xf430311c
#define L3FE_GLB_SRAM_TEST_l3fe_mem2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest2            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_mem2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_mem1             0xf4303120
#define L3FE_GLB_SRAM_TEST_l3fe_mem1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest1            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_mem1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_TEST_l3fe_mem0             0xf4303124
#define L3FE_GLB_SRAM_TEST_l3fe_mem0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramtest0            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_TEST_l3fe_mem0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_SRAM_LS_l3fe_mem                0xf4303128
#define L3FE_GLB_SRAM_LS_l3fe_mem_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sramls               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_SRAM_LS_l3fe_mem_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TCP_COS_MOD_0                   0xf430312c
#define L3FE_GLB_TCP_COS_MOD_0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_val             :  6 ; /* bits 5:0 */
    ca_uint32_t cls_hit_en           :  1 ; /* bits 6:6 */
    ca_uint32_t cls_mis_en           :  1 ; /* bits 7:7 */
    ca_uint32_t flag_msk             :  6 ; /* bits 13:8 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 14:14 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 15:15 */
    ca_uint32_t pkt_len              : 10 ; /* bits 25:16 */
    ca_uint32_t hit_cos_val          :  3 ; /* bits 28:26 */
    ca_uint32_t mis_cos_val          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TCP_COS_MOD_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TCP_COS_MOD_1                   0xf4303130
#define L3FE_GLB_TCP_COS_MOD_1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_val             :  6 ; /* bits 5:0 */
    ca_uint32_t cls_hit_en           :  1 ; /* bits 6:6 */
    ca_uint32_t cls_mis_en           :  1 ; /* bits 7:7 */
    ca_uint32_t flag_msk             :  6 ; /* bits 13:8 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 14:14 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 15:15 */
    ca_uint32_t pkt_len              : 10 ; /* bits 25:16 */
    ca_uint32_t hit_cos_val          :  3 ; /* bits 28:26 */
    ca_uint32_t mis_cos_val          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TCP_COS_MOD_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TCP_COS_MOD_2                   0xf4303134
#define L3FE_GLB_TCP_COS_MOD_2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_val             :  6 ; /* bits 5:0 */
    ca_uint32_t cls_hit_en           :  1 ; /* bits 6:6 */
    ca_uint32_t cls_mis_en           :  1 ; /* bits 7:7 */
    ca_uint32_t flag_msk             :  6 ; /* bits 13:8 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 14:14 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 15:15 */
    ca_uint32_t pkt_len              : 10 ; /* bits 25:16 */
    ca_uint32_t hit_cos_val          :  3 ; /* bits 28:26 */
    ca_uint32_t mis_cos_val          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TCP_COS_MOD_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_TCP_COS_MOD_3                   0xf4303138
#define L3FE_GLB_TCP_COS_MOD_3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t flag_val             :  6 ; /* bits 5:0 */
    ca_uint32_t cls_hit_en           :  1 ; /* bits 6:6 */
    ca_uint32_t cls_mis_en           :  1 ; /* bits 7:7 */
    ca_uint32_t flag_msk             :  6 ; /* bits 13:8 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 14:14 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 15:15 */
    ca_uint32_t pkt_len              : 10 ; /* bits 25:16 */
    ca_uint32_t hit_cos_val          :  3 ; /* bits 28:26 */
    ca_uint32_t mis_cos_val          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TCP_COS_MOD_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_CTRL                0xf430313c
#define L3FE_GLB_LDPID_REMAP_CTRL_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_mask           :  8 ; /* bits 7:0 */
    ca_uint32_t ldpid_tuple_mask     :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cls_hit_en           :  1 ; /* bits 16:16 */
    ca_uint32_t cls_mis_en           :  1 ; /* bits 17:17 */
    ca_uint32_t flw_hit_en           :  1 ; /* bits 18:18 */
    ca_uint32_t flw_mis_en           :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_SMAC_PRO            0xf4303140
#define L3FE_GLB_LDPID_REMAP_SMAC_PRO_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_SMAC_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_DMAC_PRO            0xf4303144
#define L3FE_GLB_LDPID_REMAP_DMAC_PRO_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_DMAC_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_SIP_PRO             0xf4303148
#define L3FE_GLB_LDPID_REMAP_SIP_PRO_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_SIP_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_DIP_PRO             0xf430314c
#define L3FE_GLB_LDPID_REMAP_DIP_PRO_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_DIP_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_SPORT_PRO           0xf4303150
#define L3FE_GLB_LDPID_REMAP_SPORT_PRO_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_SPORT_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_DPORT_PRO           0xf4303154
#define L3FE_GLB_LDPID_REMAP_DPORT_PRO_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_DPORT_PRO_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_VAL0                0xf4303158
#define L3FE_GLB_LDPID_REMAP_VAL0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_idx0           :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid_idx1           :  3 ; /* bits 5:3 */
    ca_uint32_t ldpid_idx2           :  3 ; /* bits 8:6 */
    ca_uint32_t ldpid_idx3           :  3 ; /* bits 11:9 */
    ca_uint32_t ldpid_idx4           :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid_idx5           :  3 ; /* bits 18:16 */
    ca_uint32_t ldpid_idx6           :  3 ; /* bits 21:19 */
    ca_uint32_t ldpid_idx7           :  3 ; /* bits 24:22 */
    ca_uint32_t ldpid_idx8           :  3 ; /* bits 27:25 */
    ca_uint32_t ldpid_idx9           :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_VAL0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_GLB_LDPID_REMAP_VAL1                0xf430315c
#define L3FE_GLB_LDPID_REMAP_VAL1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid_idx10          :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid_idx11          :  3 ; /* bits 5:3 */
    ca_uint32_t ldpid_idx12          :  3 ; /* bits 8:6 */
    ca_uint32_t ldpid_idx13          :  3 ; /* bits 11:9 */
    ca_uint32_t ldpid_idx14          :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid_idx15          :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LDPID_REMAP_VAL1_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
#ifndef __ASSEMBLER__
typedef struct {
  L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t       EGRESS_L3_IF_TBL_ACCESS;       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L3FE_GLB_EGRESS_L3_IF_TBL_DATA_t         EGRESS_L3_IF_TBL_DATA;         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L3FE_GLB_DSCP_MAP_TBL_ACCESS_t           DSCP_MAP_TBL_ACCESS;           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L3FE_GLB_DSCP_MAP_TBL_DATA1_t            DSCP_MAP_TBL_DATA1;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L3FE_GLB_DSCP_MAP_TBL_DATA0_t            DSCP_MAP_TBL_DATA0;            /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L3FE_GLB_DOT1P_MAPPING_0_0_t             DOT1P_MAPPING_0_0;             /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L3FE_GLB_DOT1P_MAPPING_1_0_t             DOT1P_MAPPING_1_0;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L3FE_GLB_DOT1P_MAPPING_0_1_t             DOT1P_MAPPING_0_1;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L3FE_GLB_DOT1P_MAPPING_1_1_t             DOT1P_MAPPING_1_1;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L3FE_GLB_DOT1P_MAPPING_0_2_t             DOT1P_MAPPING_0_2;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L3FE_GLB_DOT1P_MAPPING_1_2_t             DOT1P_MAPPING_1_2;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L3FE_GLB_DOT1P_MAPPING_0_3_t             DOT1P_MAPPING_0_3;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L3FE_GLB_DOT1P_MAPPING_1_3_t             DOT1P_MAPPING_1_3;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L3FE_GLB_DOT1P_MAPPING_0_4_t             DOT1P_MAPPING_0_4;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L3FE_GLB_DOT1P_MAPPING_1_4_t             DOT1P_MAPPING_1_4;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L3FE_GLB_DOT1P_MAPPING_0_5_t             DOT1P_MAPPING_0_5;             /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L3FE_GLB_DOT1P_MAPPING_1_5_t             DOT1P_MAPPING_1_5;             /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L3FE_GLB_DOT1P_MAPPING_0_6_t             DOT1P_MAPPING_0_6;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L3FE_GLB_DOT1P_MAPPING_1_6_t             DOT1P_MAPPING_1_6;             /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L3FE_GLB_DOT1P_MAPPING_0_7_t             DOT1P_MAPPING_0_7;             /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L3FE_GLB_DOT1P_MAPPING_1_7_t             DOT1P_MAPPING_1_7;             /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L3FE_GLB_COS_MAPPING_0_0_t               COS_MAPPING_0_0;               /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L3FE_GLB_COS_MAPPING_1_0_t               COS_MAPPING_1_0;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L3FE_GLB_COS_MAPPING_0_1_t               COS_MAPPING_0_1;               /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L3FE_GLB_COS_MAPPING_1_1_t               COS_MAPPING_1_1;               /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L3FE_GLB_COS_MAPPING_0_2_t               COS_MAPPING_0_2;               /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  L3FE_GLB_COS_MAPPING_1_2_t               COS_MAPPING_1_2;               /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  L3FE_GLB_COS_MAPPING_0_3_t               COS_MAPPING_0_3;               /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  L3FE_GLB_COS_MAPPING_1_3_t               COS_MAPPING_1_3;               /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  L3FE_GLB_COS_MAPPING_0_4_t               COS_MAPPING_0_4;               /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  L3FE_GLB_COS_MAPPING_1_4_t               COS_MAPPING_1_4;               /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  L3FE_GLB_COS_MAPPING_0_5_t               COS_MAPPING_0_5;               /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  L3FE_GLB_COS_MAPPING_1_5_t               COS_MAPPING_1_5;               /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  L3FE_GLB_COS_MAPPING_0_6_t               COS_MAPPING_0_6;               /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  L3FE_GLB_COS_MAPPING_1_6_t               COS_MAPPING_1_6;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];
  L3FE_GLB_COS_MAPPING_0_7_t               COS_MAPPING_0_7;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];
  L3FE_GLB_COS_MAPPING_1_7_t               COS_MAPPING_1_7;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];
  L3FE_GLB_FWD_CTRL_0_t                    FWD_CTRL_0;                    /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];
  L3FE_GLB_FWD_CTRL_1_t                    FWD_CTRL_1;                    /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];
  L3FE_GLB_FWD_CTRL_2_t                    FWD_CTRL_2;                    /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];
  L3FE_GLB_FWD_CTRL_3_t                    FWD_CTRL_3;                    /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];
  L3FE_GLB_GLB_CFG_t                       GLB_CFG;                       /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];
  L3FE_GLB_LF_CFG_t                        LF_CFG;                        /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];
  L3FE_GLB_TE_OPTION_t                     TE_OPTION;                     /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];
  L3FE_GLB_CLS_STG_MONITOR_CTRL_t          CLS_STG_MONITOR_CTRL;          /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];
  L3FE_GLB_CLS_STG_MONITOR_RETURN_t        CLS_STG_MONITOR_RETURN;        /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];
  L3FE_GLB_DBG_IDX_t                       DBG_IDX;                       /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];
  L3FE_GLB_DBG_DAT_t                       DBG_DAT;                       /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];
  L3FE_GLB_L3FE_MONITOR_TRIG_t             L3FE_MONITOR_TRIG;             /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];
  L3FE_GLB_L3FE_MONITOR_CTRL_t             L3FE_MONITOR_CTRL;             /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];
  L3FE_GLB_L3FE_MONITOR_RETURN_t           L3FE_MONITOR_RETURN;           /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];
  L3FE_GLB_RES_CTRL_t                      RES_CTRL;                      /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty15_t        SRAM_TEST_l3fe_empty15;        /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty14_t        SRAM_TEST_l3fe_empty14;        /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty13_t        SRAM_TEST_l3fe_empty13;        /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty12_t        SRAM_TEST_l3fe_empty12;        /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty11_t        SRAM_TEST_l3fe_empty11;        /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty10_t        SRAM_TEST_l3fe_empty10;        /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty9_t         SRAM_TEST_l3fe_empty9;         /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty8_t         SRAM_TEST_l3fe_empty8;         /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty7_t         SRAM_TEST_l3fe_empty7;         /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty6_t         SRAM_TEST_l3fe_empty6;         /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty5_t         SRAM_TEST_l3fe_empty5;         /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty4_t         SRAM_TEST_l3fe_empty4;         /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty3_t         SRAM_TEST_l3fe_empty3;         /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty2_t         SRAM_TEST_l3fe_empty2;         /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty1_t         SRAM_TEST_l3fe_empty1;         /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];
  L3FE_GLB_SRAM_TEST_l3fe_empty0_t         SRAM_TEST_l3fe_empty0;         /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];
  L3FE_GLB_SRAM_LS_l3fe_empty1_t           SRAM_LS_l3fe_empty1;           /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];
  L3FE_GLB_SRAM_LS_l3fe_empty0_t           SRAM_LS_l3fe_empty0;           /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];
  L3FE_GLB_SRAM_TEST_l3fe_mem3_t           SRAM_TEST_l3fe_mem3;           /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];
  L3FE_GLB_SRAM_TEST_l3fe_mem2_t           SRAM_TEST_l3fe_mem2;           /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];
  L3FE_GLB_SRAM_TEST_l3fe_mem1_t           SRAM_TEST_l3fe_mem1;           /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];
  L3FE_GLB_SRAM_TEST_l3fe_mem0_t           SRAM_TEST_l3fe_mem0;           /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];
  L3FE_GLB_SRAM_LS_l3fe_mem_t              SRAM_LS_l3fe_mem;              /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];
  L3FE_GLB_TCP_COS_MOD_0_t                 TCP_COS_MOD_0;                 /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];
  L3FE_GLB_TCP_COS_MOD_1_t                 TCP_COS_MOD_1;                 /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];
  L3FE_GLB_TCP_COS_MOD_2_t                 TCP_COS_MOD_2;                 /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];
  L3FE_GLB_TCP_COS_MOD_3_t                 TCP_COS_MOD_3;                 /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];
  L3FE_GLB_LDPID_REMAP_CTRL_t              LDPID_REMAP_CTRL;              /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];
  L3FE_GLB_LDPID_REMAP_SMAC_PRO_t          LDPID_REMAP_SMAC_PRO;          /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];
  L3FE_GLB_LDPID_REMAP_DMAC_PRO_t          LDPID_REMAP_DMAC_PRO;          /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];
  L3FE_GLB_LDPID_REMAP_SIP_PRO_t           LDPID_REMAP_SIP_PRO;           /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];
  L3FE_GLB_LDPID_REMAP_DIP_PRO_t           LDPID_REMAP_DIP_PRO;           /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];
  L3FE_GLB_LDPID_REMAP_SPORT_PRO_t         LDPID_REMAP_SPORT_PRO;         /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];
  L3FE_GLB_LDPID_REMAP_DPORT_PRO_t         LDPID_REMAP_DPORT_PRO;         /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];
  L3FE_GLB_LDPID_REMAP_VAL0_t              LDPID_REMAP_VAL0;              /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];
  L3FE_GLB_LDPID_REMAP_VAL1_t              LDPID_REMAP_VAL1;              /* addr: 0x0000015c */
} APB0_L3FE_GLB_t;
#endif /* !__ASSEMBLER__ */


/*
 * PP
 */

#define L3FE_PP_FIELD_CAM_ACCESS                 0xf4303200
#define L3FE_PP_FIELD_CAM_ACCESS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA4                  0xf4303204
#define L3FE_PP_FIELD_CAM_DATA4_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA3                  0xf4303208
#define L3FE_PP_FIELD_CAM_DATA3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA2                  0xf430320c
#define L3FE_PP_FIELD_CAM_DATA2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA1                  0xf4303210
#define L3FE_PP_FIELD_CAM_DATA1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_FIELD_CAM_DATA0                  0xf4303214
#define L3FE_PP_FIELD_CAM_DATA0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_SPCL_PKT_DETECTION_CFG           0xf4303218
#define L3FE_PP_SPCL_PKT_DETECTION_CFG_dft       0x0739dc24

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t check_arp_target_ip  :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_opcode_en       :  1 ; /* bits 1:1 */
    ca_uint32_t my_mac_enable        :  1 ; /* bits 2:2 */
    ca_uint32_t type_0_en            :  1 ; /* bits 3:3 */
    ca_uint32_t type_1_en            :  1 ; /* bits 4:4 */
    ca_uint32_t udp_lite_enable      :  1 ; /* bits 5:5 */
    ca_uint32_t user_def_spcl_0_en   :  1 ; /* bits 6:6 */
    ca_uint32_t user_def_spcl_1_en   :  1 ; /* bits 7:7 */
    ca_uint32_t user_def_spcl_2_en   :  1 ; /* bits 8:8 */
    ca_uint32_t user_def_spcl_3_en   :  1 ; /* bits 9:9 */
    ca_uint32_t l2_spcl_hdr_en       :  1 ; /* bits 10:10 */
    ca_uint32_t l3_spcl_hdr_en       :  1 ; /* bits 11:11 */
    ca_uint32_t l4_spcl_hdr_en       :  1 ; /* bits 12:12 */
    ca_uint32_t user_define_hi_pri   :  1 ; /* bits 13:13 */
    ca_uint32_t rdp_v1_detection_en  :  1 ; /* bits 14:14 */
    ca_uint32_t ipv4_chksum_chk_enable :  1 ; /* bits 15:15 */
    ca_uint32_t l4_chksum_chk_enable :  1 ; /* bits 16:16 */
    ca_uint32_t l4_chksum_rh_chk_enable :  1 ; /* bits 17:17 */
    ca_uint32_t chksum_err_drop      :  6 ; /* bits 23:18 */
    ca_uint32_t bpdu_mac_08_en       :  1 ; /* bits 24:24 */
    ca_uint32_t subtype_en           :  1 ; /* bits 25:25 */
    ca_uint32_t rdp_l4_msgs_det_en   :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t drop_udp_ov_ip6_cs_zero_en :  1 ; /* bits 28:28 */
    ca_uint32_t ni2fe_pkt_cnt_wrap_en :  1 ; /* bits 29:29 */
    ca_uint32_t use_mdata_high_6bits_as_spcl_enc :  1 ; /* bits 30:30 */
    ca_uint32_t arp_ipv6_en          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_SPCL_PKT_DETECTION_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_IPNIP_SPCL_PKT_DET_EN            0xf430321c
#define L3FE_PP_IPNIP_SPCL_PKT_DET_EN_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dhcpv4               :  1 ; /* bits 0:0 */
    ca_uint32_t dhcpv6               :  1 ; /* bits 1:1 */
    ca_uint32_t l4ptp                :  1 ; /* bits 2:2 */
    ca_uint32_t dns                  :  1 ; /* bits 3:3 */
    ca_uint32_t rip                  :  1 ; /* bits 4:4 */
    ca_uint32_t ssdp                 :  1 ; /* bits 5:5 */
    ca_uint32_t l4_msgs              :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_OFFSET_HDR                       0xf4303220
#define L3FE_PP_OFFSET_HDR_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t offset               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t l3_prog_offset       :  9 ; /* bits 24:16 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_OFFSET_HDR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L7_PROG_OFFSET_HDR_0             0xf4303224
#define L3FE_PP_L7_PROG_OFFSET_HDR_0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l7_prog_offset       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L7_PROG_OFFSET_HDR_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L7_PROG_OFFSET_HDR_1             0xf4303228
#define L3FE_PP_L7_PROG_OFFSET_HDR_1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l7_prog_offset       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L7_PROG_OFFSET_HDR_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L7_PROG_OFFSET_HDR_2             0xf430322c
#define L3FE_PP_L7_PROG_OFFSET_HDR_2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l7_prog_offset       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L7_PROG_OFFSET_HDR_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L7_PROG_OFFSET_HDR_3             0xf4303230
#define L3FE_PP_L7_PROG_OFFSET_HDR_3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l7_prog_offset       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L7_PROG_OFFSET_HDR_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_LMT                      0xf4303234
#define L3FE_PP_PARSING_LMT_dft                  0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t offset               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_LMT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_STTS_0                   0xf4303238
#define L3FE_PP_PARSING_STTS_0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t parsing_err          :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_STTS_1                   0xf430323c
#define L3FE_PP_PARSING_STTS_1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t parsing_err          : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_ERR_FWD_0                0xf4303240
#define L3FE_PP_PARSING_ERR_FWD_0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t ipv4_hdr_cs_err      :  2 ; /* bits 11:10 */
    ca_uint32_t pkt_l2_size_err      :  2 ; /* bits 13:12 */
    ca_uint32_t pkt_l3_total_len_err :  2 ; /* bits 15:14 */
    ca_uint32_t ip_hdr_err           :  2 ; /* bits 17:16 */
    ca_uint32_t ipv4_total_len_err   :  2 ; /* bits 19:18 */
    ca_uint32_t tcp_data_offset_err  :  2 ; /* bits 21:20 */
    ca_uint32_t udp_total_len_err    :  2 ; /* bits 23:22 */
    ca_uint32_t udp_lite_cs_cvrg_err :  2 ; /* bits 25:24 */
    ca_uint32_t rdp_hdr_len_err      :  2 ; /* bits 27:26 */
    ca_uint32_t offset_l3_excd_255_err :  2 ; /* bits 29:28 */
    ca_uint32_t offset_l4_excd_255_err :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_FWD_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_ERR_FWD_1                0xf4303244
#define L3FE_PP_PARSING_ERR_FWD_1_dft            0x00005000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dsl_inner_ip_hdr_cs_err :  2 ; /* bits 1:0 */
    ca_uint32_t pkt_inner_l3_total_len_err :  2 ; /* bits 3:2 */
    ca_uint32_t inner_ip_hdr_err     :  2 ; /* bits 5:4 */
    ca_uint32_t dsl_inner_ipv4_total_len_err :  2 ; /* bits 7:6 */
    ca_uint32_t offset_l3_inner_excd_255_err :  2 ; /* bits 9:8 */
    ca_uint32_t udp_zero_chksum_err  :  2 ; /* bits 11:10 */
    ca_uint32_t more_than_2_vlan_tags_flg :  2 ; /* bits 13:12 */
    ca_uint32_t l2tp_hdr_err         :  2 ; /* bits 15:14 */
    ca_uint32_t rdp_ver_err          :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t parsing_err_trap_pol_id :  9 ; /* bits 27:19 */
    ca_uint32_t parsing_err_trap_pol_grp_id :  3 ; /* bits 30:28 */
    ca_uint32_t parsing_err_trap_pol_en :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_FWD_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_ERR_TRAP                 0xf4303248
#define L3FE_PP_PARSING_ERR_TRAP_dft             0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_TRAP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PARSING_OVER_VLAN_FWD_CTL        0xf430324c
#define L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_dft    0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_TYPE_0                      0xf4303250
#define L3FE_PP_USER_TYPE_0_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_type_0          : 16 ; /* bits 15:0 */
    ca_uint32_t user_type_1          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_TYPE_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_TYPE_1                      0xf4303254
#define L3FE_PP_USER_TYPE_1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_type_2          : 16 ; /* bits 15:0 */
    ca_uint32_t user_type_3          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_TYPE_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_0_LOW                   0xf4303258
#define L3FE_PP_USER_MAC_0_LOW_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_0_HI                    0xf430325c
#define L3FE_PP_USER_MAC_0_HI_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_0           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_1_LOW                   0xf4303260
#define L3FE_PP_USER_MAC_1_LOW_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_1_HI                    0xf4303264
#define L3FE_PP_USER_MAC_1_HI_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_1           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_0_MASK_LOW              0xf4303268
#define L3FE_PP_USER_MAC_0_MASK_LOW_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_0      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_MASK_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_0_MASK_HI               0xf430326c
#define L3FE_PP_USER_MAC_0_MASK_HI_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_0      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_MASK_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_1_MASK_LOW              0xf4303270
#define L3FE_PP_USER_MAC_1_MASK_LOW_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_1      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_MASK_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_USER_MAC_1_MASK_HI               0xf4303274
#define L3FE_PP_USER_MAC_1_MASK_HI_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_1      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_MASK_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_TPID_0                           0xf4303278
#define L3FE_PP_TPID_0_dft                       0x88a88100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid_0               : 16 ; /* bits 15:0 */
    ca_uint32_t tpid_1               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_TPID_1                           0xf430327c
#define L3FE_PP_TPID_1_dft                       0x92009100

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpid_2               : 16 ; /* bits 15:0 */
    ca_uint32_t tpid_3               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_TPID_CTRL                        0xf4303280
#define L3FE_PP_TPID_CTRL_dft                    0x00000077

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t top_vlan_en          :  4 ; /* bits 3:0 */
    ca_uint32_t inner_vlan_en        :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_ARP_TARGET_IP                    0xf4303284
#define L3FE_PP_ARP_TARGET_IP_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t target_ip            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_ARP_TARGET_IP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_OAM                              0xf4303288
#define L3FE_PP_OAM_dft                          0x00000803

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t subtype              :  8 ; /* bits 7:0 */
    ca_uint32_t mymdlvl              :  3 ; /* bits 10:8 */
    ca_uint32_t mymdlvl_det_en       :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_OAM_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HELLO_MAC_LOW                    0xf430328c
#define L3FE_PP_HELLO_MAC_LOW_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HELLO_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HELLO_MAC_HI                     0xf4303290
#define L3FE_PP_HELLO_MAC_HI_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HELLO_MAC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MY_MAC_LOW                       0xf4303294
#define L3FE_PP_MY_MAC_LOW_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mymac                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MY_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MY_MAC_HI                        0xf4303298
#define L3FE_PP_MY_MAC_HI_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mymac                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MY_MAC_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MC_MAC_HI_RNG                    0xf430329c
#define L3FE_PP_MC_MAC_HI_RNG_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t hi_rng_mac_low       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_HI_RNG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MC_MAC_LOW_RNG                   0xf43032a0
#define L3FE_PP_MC_MAC_LOW_RNG_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_rng_mac_low      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_LOW_RNG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_MC_MAC_RNG                       0xf43032a4
#define L3FE_PP_MC_MAC_RNG_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_rng_mac_hi       : 16 ; /* bits 15:0 */
    ca_uint32_t hi_rng_mac_hi        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_RNG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HTTP_LINK_0                      0xf43032a8
#define L3FE_PP_HTTP_LINK_0_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HTTP_LINK_1                      0xf43032ac
#define L3FE_PP_HTTP_LINK_1_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HTTP_LINK_2                      0xf43032b0
#define L3FE_PP_HTTP_LINK_2_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HTTP_LINK_3                      0xf43032b4
#define L3FE_PP_HTTP_LINK_3_dft                  0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PINGPONG_STS                     0xf43032b8
#define L3FE_PP_PINGPONG_STS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_ERR_STTS_0               0xf43032bc
#define L3FE_PP_NI_INTF_ERR_STTS_0_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sop_eop_mismatch     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_ERR_STTS_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_ERR_STTS_1               0xf43032c0
#define L3FE_PP_NI_INTF_ERR_STTS_1_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t runt_l2_pkt          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_ERR_STTS_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_STS                      0xf43032c4
#define L3FE_PP_NI_INTF_STS_dft                  0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdy                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_PKT_CNT0                 0xf43032c8
#define L3FE_PP_NI_INTF_PKT_CNT0_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sop                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_PKT_CNT0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI_INTF_PKT_CNT1                 0xf43032cc
#define L3FE_PP_NI_INTF_PKT_CNT1_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eop                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_PKT_CNT1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_L4_CS_ERR                        0xf43032d0
#define L3FE_PP_L4_CS_ERR_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L4_CS_ERR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HEADER_A_LOW                     0xf43032d4
#define L3FE_PP_HEADER_A_LOW_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HEADER_A_HI                      0xf43032d8
#define L3FE_PP_HEADER_A_HI_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HEADER_CPU_LOW                   0xf43032dc
#define L3FE_PP_HEADER_CPU_LOW_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_CPU_LOW_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_HEADER_CPU_HI                    0xf43032e0
#define L3FE_PP_HEADER_CPU_HI_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_CPU_HI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_NI2FE_INTF_FF_STS                0xf43032e4
#define L3FE_PP_NI2FE_INTF_FF_STS_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI2FE_INTF_FF_STS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_ARP_FILTER_MSK                   0xf43032e8
#define L3FE_PP_ARP_FILTER_MSK_dft               0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_ARP_FILTER_MSK_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_0                        0xf43032ec
#define L3FE_PP_DOS_ATK_0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_1                        0xf43032f0
#define L3FE_PP_DOS_ATK_1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_2                        0xf43032f4
#define L3FE_PP_DOS_ATK_2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_3                        0xf43032f8
#define L3FE_PP_DOS_ATK_3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_4                        0xf43032fc
#define L3FE_PP_DOS_ATK_4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_5                        0xf4303300
#define L3FE_PP_DOS_ATK_5_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_6                        0xf4303304
#define L3FE_PP_DOS_ATK_6_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_7                        0xf4303308
#define L3FE_PP_DOS_ATK_7_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_8                        0xf430330c
#define L3FE_PP_DOS_ATK_8_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_FLOOD_CNT                0xf4303310
#define L3FE_PP_DOS_ATK_FLOOD_CNT_dft            0x000003fa

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_FLOOD_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_EVENT_TRAP               0xf4303314
#define L3FE_PP_DOS_ATK_EVENT_TRAP_dft           0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_EVENT_TRAP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_DOS_ATK_EVENT_DROP               0xf4303318
#define L3FE_PP_DOS_ATK_EVENT_DROP_dft           0xfffffa1f

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_DOS_ATK_EVENT_DROP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_01                   0xf430331c
#define L3FE_PP_vxlan_dport_01_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat0                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat1                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_01_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_23                   0xf4303320
#define L3FE_PP_vxlan_dport_23_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat2                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat3                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_23_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_45                   0xf4303324
#define L3FE_PP_vxlan_dport_45_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat4                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat5                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_45_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_67                   0xf4303328
#define L3FE_PP_vxlan_dport_67_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat6                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat7                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_67_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_vxlan_dport_89                   0xf430332c
#define L3FE_PP_vxlan_dport_89_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat8                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat9                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_vxlan_dport_89_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_l2tp_sport                       0xf4303330
#define L3FE_PP_l2tp_sport_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pat0                 : 16 ; /* bits 15:0 */
    ca_uint32_t pat1                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_l2tp_sport_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_fpga_debug_sel                   0xf4303334
#define L3FE_PP_fpga_debug_sel_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t index                :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_fpga_debug_sel_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_fpga_debug_data                  0xf4303338
#define L3FE_PP_fpga_debug_data_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_fpga_debug_data_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_SPKTP_ACCESS                     0xf430333c
#define L3FE_PP_SPKTP_ACCESS_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_SPKTP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_SPKTP_DATA                       0xf4303340
#define L3FE_PP_SPKTP_DATA_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t encode               :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_SPKTP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_PADDING_ERR_CNT                  0xf4303344
#define L3FE_PP_PADDING_ERR_CNT_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t outer_cnt            : 16 ; /* bits 15:0 */
    ca_uint32_t inner_cnt            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PADDING_ERR_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PP_dual_dos_en                      0xf4303348
#define L3FE_PP_dual_dos_en_dft                  0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_dual_dos_en_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PP */
#ifndef __ASSEMBLER__
typedef struct {
  L3FE_PP_FIELD_CAM_ACCESS_t               FIELD_CAM_ACCESS;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L3FE_PP_FIELD_CAM_DATA4_t                FIELD_CAM_DATA4;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L3FE_PP_FIELD_CAM_DATA3_t                FIELD_CAM_DATA3;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L3FE_PP_FIELD_CAM_DATA2_t                FIELD_CAM_DATA2;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L3FE_PP_FIELD_CAM_DATA1_t                FIELD_CAM_DATA1;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L3FE_PP_FIELD_CAM_DATA0_t                FIELD_CAM_DATA0;               /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L3FE_PP_SPCL_PKT_DETECTION_CFG_t         SPCL_PKT_DETECTION_CFG;        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t          IPNIP_SPCL_PKT_DET_EN;         /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L3FE_PP_OFFSET_HDR_t                     OFFSET_HDR;                    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L3FE_PP_L7_PROG_OFFSET_HDR_0_t           L7_PROG_OFFSET_HDR_0;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L3FE_PP_L7_PROG_OFFSET_HDR_1_t           L7_PROG_OFFSET_HDR_1;          /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L3FE_PP_L7_PROG_OFFSET_HDR_2_t           L7_PROG_OFFSET_HDR_2;          /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L3FE_PP_L7_PROG_OFFSET_HDR_3_t           L7_PROG_OFFSET_HDR_3;          /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L3FE_PP_PARSING_LMT_t                    PARSING_LMT;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L3FE_PP_PARSING_STTS_0_t                 PARSING_STTS_0;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L3FE_PP_PARSING_STTS_1_t                 PARSING_STTS_1;                /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L3FE_PP_PARSING_ERR_FWD_0_t              PARSING_ERR_FWD_0;             /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L3FE_PP_PARSING_ERR_FWD_1_t              PARSING_ERR_FWD_1;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L3FE_PP_PARSING_ERR_TRAP_t               PARSING_ERR_TRAP;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t      PARSING_OVER_VLAN_FWD_CTL;     /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L3FE_PP_USER_TYPE_0_t                    USER_TYPE_0;                   /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L3FE_PP_USER_TYPE_1_t                    USER_TYPE_1;                   /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L3FE_PP_USER_MAC_0_LOW_t                 USER_MAC_0_LOW;                /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L3FE_PP_USER_MAC_0_HI_t                  USER_MAC_0_HI;                 /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L3FE_PP_USER_MAC_1_LOW_t                 USER_MAC_1_LOW;                /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L3FE_PP_USER_MAC_1_HI_t                  USER_MAC_1_HI;                 /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  L3FE_PP_USER_MAC_0_MASK_LOW_t            USER_MAC_0_MASK_LOW;           /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  L3FE_PP_USER_MAC_0_MASK_HI_t             USER_MAC_0_MASK_HI;            /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  L3FE_PP_USER_MAC_1_MASK_LOW_t            USER_MAC_1_MASK_LOW;           /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  L3FE_PP_USER_MAC_1_MASK_HI_t             USER_MAC_1_MASK_HI;            /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  L3FE_PP_TPID_0_t                         TPID_0;                        /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  L3FE_PP_TPID_1_t                         TPID_1;                        /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  L3FE_PP_TPID_CTRL_t                      TPID_CTRL;                     /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  L3FE_PP_ARP_TARGET_IP_t                  ARP_TARGET_IP;                 /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  L3FE_PP_OAM_t                            OAM;                           /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];
  L3FE_PP_HELLO_MAC_LOW_t                  HELLO_MAC_LOW;                 /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];
  L3FE_PP_HELLO_MAC_HI_t                   HELLO_MAC_HI;                  /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];
  L3FE_PP_MY_MAC_LOW_t                     MY_MAC_LOW;                    /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];
  L3FE_PP_MY_MAC_HI_t                      MY_MAC_HI;                     /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];
  L3FE_PP_MC_MAC_HI_RNG_t                  MC_MAC_HI_RNG;                 /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];
  L3FE_PP_MC_MAC_LOW_RNG_t                 MC_MAC_LOW_RNG;                /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];
  L3FE_PP_MC_MAC_RNG_t                     MC_MAC_RNG;                    /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];
  L3FE_PP_HTTP_LINK_0_t                    HTTP_LINK_0;                   /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];
  L3FE_PP_HTTP_LINK_1_t                    HTTP_LINK_1;                   /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];
  L3FE_PP_HTTP_LINK_2_t                    HTTP_LINK_2;                   /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];
  L3FE_PP_HTTP_LINK_3_t                    HTTP_LINK_3;                   /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];
  L3FE_PP_PINGPONG_STS_t                   PINGPONG_STS;                  /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];
  L3FE_PP_NI_INTF_ERR_STTS_0_t             NI_INTF_ERR_STTS_0;            /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];
  L3FE_PP_NI_INTF_ERR_STTS_1_t             NI_INTF_ERR_STTS_1;            /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];
  L3FE_PP_NI_INTF_STS_t                    NI_INTF_STS;                   /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];
  L3FE_PP_NI_INTF_PKT_CNT0_t               NI_INTF_PKT_CNT0;              /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];
  L3FE_PP_NI_INTF_PKT_CNT1_t               NI_INTF_PKT_CNT1;              /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];
  L3FE_PP_L4_CS_ERR_t                      L4_CS_ERR;                     /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];
  L3FE_PP_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];
  L3FE_PP_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];
  L3FE_PP_HEADER_CPU_LOW_t                 HEADER_CPU_LOW;                /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];
  L3FE_PP_HEADER_CPU_HI_t                  HEADER_CPU_HI;                 /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];
  L3FE_PP_NI2FE_INTF_FF_STS_t              NI2FE_INTF_FF_STS;             /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];
  L3FE_PP_ARP_FILTER_MSK_t                 ARP_FILTER_MSK;                /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];
  L3FE_PP_DOS_ATK_0_t                      DOS_ATK_0;                     /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];
  L3FE_PP_DOS_ATK_1_t                      DOS_ATK_1;                     /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];
  L3FE_PP_DOS_ATK_2_t                      DOS_ATK_2;                     /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];
  L3FE_PP_DOS_ATK_3_t                      DOS_ATK_3;                     /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];
  L3FE_PP_DOS_ATK_4_t                      DOS_ATK_4;                     /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];
  L3FE_PP_DOS_ATK_5_t                      DOS_ATK_5;                     /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];
  L3FE_PP_DOS_ATK_6_t                      DOS_ATK_6;                     /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];
  L3FE_PP_DOS_ATK_7_t                      DOS_ATK_7;                     /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];
  L3FE_PP_DOS_ATK_8_t                      DOS_ATK_8;                     /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];
  L3FE_PP_DOS_ATK_FLOOD_CNT_t              DOS_ATK_FLOOD_CNT;             /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];
  L3FE_PP_DOS_ATK_EVENT_TRAP_t             DOS_ATK_EVENT_TRAP;            /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];
  L3FE_PP_DOS_ATK_EVENT_DROP_t             DOS_ATK_EVENT_DROP;            /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];
  L3FE_PP_vxlan_dport_01_t                 vxlan_dport_01;                /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];
  L3FE_PP_vxlan_dport_23_t                 vxlan_dport_23;                /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];
  L3FE_PP_vxlan_dport_45_t                 vxlan_dport_45;                /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];
  L3FE_PP_vxlan_dport_67_t                 vxlan_dport_67;                /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];
  L3FE_PP_vxlan_dport_89_t                 vxlan_dport_89;                /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];
  L3FE_PP_l2tp_sport_t                     l2tp_sport;                    /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];
  L3FE_PP_fpga_debug_sel_t                 fpga_debug_sel;                /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];
  L3FE_PP_fpga_debug_data_t                fpga_debug_data;               /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];
  L3FE_PP_SPKTP_ACCESS_t                   SPKTP_ACCESS;                  /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];
  L3FE_PP_SPKTP_DATA_t                     SPKTP_DATA;                    /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];
  L3FE_PP_PADDING_ERR_CNT_t                PADDING_ERR_CNT;               /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];
  L3FE_PP_dual_dos_en_t                    dual_dos_en;                   /* addr: 0x00000148 */
} APB0_L3FE_PP_t;
#endif /* !__ASSEMBLER__ */


/*
 * CLS
 */

#define L3FE_CLS_KEY_TBL_ACCESS                  0xf4303380
#define L3FE_CLS_KEY_TBL_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA10                  0xf4303384
#define L3FE_CLS_KEY_TBL_DATA10_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 17 ; /* bits 16:0 */
    ca_uint32_t cl_entry_mode        :  1 ; /* bits 17:17 */
    ca_uint32_t cl_pri               :  4 ; /* bits 21:18 */
    ca_uint32_t cl_rslt_type         :  2 ; /* bits 23:22 */
    ca_uint32_t cl_key_type          :  3 ; /* bits 26:24 */
    ca_uint32_t cl_key_valid         :  4 ; /* bits 30:27 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA9                   0xf4303388
#define L3FE_CLS_KEY_TBL_DATA9_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA8                   0xf430338c
#define L3FE_CLS_KEY_TBL_DATA8_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA7                   0xf4303390
#define L3FE_CLS_KEY_TBL_DATA7_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA6                   0xf4303394
#define L3FE_CLS_KEY_TBL_DATA6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA5                   0xf4303398
#define L3FE_CLS_KEY_TBL_DATA5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA4                   0xf430339c
#define L3FE_CLS_KEY_TBL_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA3                   0xf43033a0
#define L3FE_CLS_KEY_TBL_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA2                   0xf43033a4
#define L3FE_CLS_KEY_TBL_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA1                   0xf43033a8
#define L3FE_CLS_KEY_TBL_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_KEY_TBL_DATA0                   0xf43033ac
#define L3FE_CLS_KEY_TBL_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_ACCESS                  0xf43033b0
#define L3FE_CLS_FIB_TBL_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA6                   0xf43033b4
#define L3FE_CLS_FIB_TBL_DATA6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA5                   0xf43033b8
#define L3FE_CLS_FIB_TBL_DATA5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA4                   0xf43033bc
#define L3FE_CLS_FIB_TBL_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA3                   0xf43033c0
#define L3FE_CLS_FIB_TBL_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA2                   0xf43033c4
#define L3FE_CLS_FIB_TBL_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA1                   0xf43033c8
#define L3FE_CLS_FIB_TBL_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_CLS_FIB_TBL_DATA0                   0xf43033cc
#define L3FE_CLS_FIB_TBL_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLS */
#ifndef __ASSEMBLER__
typedef struct {
  L3FE_CLS_KEY_TBL_ACCESS_t                KEY_TBL_ACCESS;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L3FE_CLS_KEY_TBL_DATA10_t                KEY_TBL_DATA10;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L3FE_CLS_KEY_TBL_DATA9_t                 KEY_TBL_DATA9;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L3FE_CLS_KEY_TBL_DATA8_t                 KEY_TBL_DATA8;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L3FE_CLS_KEY_TBL_DATA7_t                 KEY_TBL_DATA7;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L3FE_CLS_KEY_TBL_DATA6_t                 KEY_TBL_DATA6;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L3FE_CLS_KEY_TBL_DATA5_t                 KEY_TBL_DATA5;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L3FE_CLS_KEY_TBL_DATA4_t                 KEY_TBL_DATA4;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L3FE_CLS_KEY_TBL_DATA3_t                 KEY_TBL_DATA3;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L3FE_CLS_KEY_TBL_DATA2_t                 KEY_TBL_DATA2;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L3FE_CLS_KEY_TBL_DATA1_t                 KEY_TBL_DATA1;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L3FE_CLS_KEY_TBL_DATA0_t                 KEY_TBL_DATA0;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L3FE_CLS_FIB_TBL_ACCESS_t                FIB_TBL_ACCESS;                /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L3FE_CLS_FIB_TBL_DATA6_t                 FIB_TBL_DATA6;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L3FE_CLS_FIB_TBL_DATA5_t                 FIB_TBL_DATA5;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L3FE_CLS_FIB_TBL_DATA4_t                 FIB_TBL_DATA4;                 /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L3FE_CLS_FIB_TBL_DATA3_t                 FIB_TBL_DATA3;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L3FE_CLS_FIB_TBL_DATA2_t                 FIB_TBL_DATA2;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L3FE_CLS_FIB_TBL_DATA1_t                 FIB_TBL_DATA1;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L3FE_CLS_FIB_TBL_DATA0_t                 FIB_TBL_DATA0;                 /* addr: 0x0000004c */
} APB0_L3FE_CLS_t;
#endif /* !__ASSEMBLER__ */


/*
 * STG0
 */

#define L3FE_STG0_CTRL                           0xf4303400
#define L3FE_STG0_CTRL_dft                       0x00147c7e

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t lpb_idx_mode         :  1 ; /* bits 0:0 */
    ca_uint32_t mac_fltr_fail_pkt_mru_chk_en :  1 ; /* bits 1:1 */
    ca_uint32_t mru_chk_fail_pkt_l2_lkup_dis :  1 ; /* bits 2:2 */
    ca_uint32_t other_mac_pkt_keep_lspid_en :  1 ; /* bits 3:3 */
    ca_uint32_t wan_lspid            :  6 ; /* bits 9:4 */
    ca_uint32_t use_lspid_ovwr_o_lspid :  1 ; /* bits 10:10 */
    ca_uint32_t spcl_pkt_keep_old    :  1 ; /* bits 11:11 */
    ca_uint32_t wan_lspid_1          :  6 ; /* bits 17:12 */
    ca_uint32_t msk_my_mac_match_en_for_lspid_upd :  1 ; /* bits 18:18 */
    ca_uint32_t keep_lspid_unchange  :  1 ; /* bits 19:19 */
    ca_uint32_t my_mac_fail_pkt_bypass_cls :  1 ; /* bits 20:20 */
    ca_uint32_t chk_mymac_for_lan    :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LDPID_MAP                      0xf4303404
#define L3FE_STG0_LDPID_MAP_dft                  0x03591807

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rule_0               :  6 ; /* bits 5:0 */
    ca_uint32_t lpb_idx_0            :  2 ; /* bits 7:6 */
    ca_uint32_t rule_1               :  6 ; /* bits 13:8 */
    ca_uint32_t lpb_idx_1            :  2 ; /* bits 15:14 */
    ca_uint32_t rule_2               :  6 ; /* bits 21:16 */
    ca_uint32_t lpb_idx_2            :  2 ; /* bits 23:22 */
    ca_uint32_t lpb_idx_3            :  2 ; /* bits 25:24 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LDPID_MAP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_LOW_0                  0xf4303408
#define L3FE_STG0_LPB_TBL_LOW_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_MID_0                  0xf430340c
#define L3FE_STG0_LPB_TBL_MID_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_HIGH_0                 0xf4303410
#define L3FE_STG0_LPB_TBL_HIGH_0_dft             0x18000190

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_LOW_1                  0xf4303414
#define L3FE_STG0_LPB_TBL_LOW_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_MID_1                  0xf4303418
#define L3FE_STG0_LPB_TBL_MID_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_HIGH_1                 0xf430341c
#define L3FE_STG0_LPB_TBL_HIGH_1_dft             0x19000070

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_LOW_2                  0xf4303420
#define L3FE_STG0_LPB_TBL_LOW_2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_MID_2                  0xf4303424
#define L3FE_STG0_LPB_TBL_MID_2_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_HIGH_2                 0xf4303428
#define L3FE_STG0_LPB_TBL_HIGH_2_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_LOW_3                  0xf430342c
#define L3FE_STG0_LPB_TBL_LOW_3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_MID_3                  0xf4303430
#define L3FE_STG0_LPB_TBL_MID_3_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_TBL_HIGH_3                 0xf4303434
#define L3FE_STG0_LPB_TBL_HIGH_3_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_IDX_TBL_ACCESS             0xf4303438
#define L3FE_STG0_LPB_IDX_TBL_ACCESS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_IDX_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_LPB_IDX_TBL_DATA               0xf430343c
#define L3FE_STG0_LPB_IDX_TBL_DATA_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t idx                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_IDX_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_SPB_TBL_ACCESS                 0xf4303440
#define L3FE_STG0_SPB_TBL_ACCESS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_SPB_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG0_SPB_TBL_DATA                   0xf4303444
#define L3FE_STG0_SPB_TBL_DATA_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t vct                  : 28 ; /* bits 27:0 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_SPB_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* STG0 */
#ifndef __ASSEMBLER__
typedef struct {
  L3FE_STG0_CTRL_t                         CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L3FE_STG0_LDPID_MAP_t                    LDPID_MAP;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L3FE_STG0_LPB_TBL_LOW_0_t                LPB_TBL_LOW_0;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L3FE_STG0_LPB_TBL_MID_0_t                LPB_TBL_MID_0;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L3FE_STG0_LPB_TBL_HIGH_0_t               LPB_TBL_HIGH_0;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L3FE_STG0_LPB_TBL_LOW_1_t                LPB_TBL_LOW_1;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L3FE_STG0_LPB_TBL_MID_1_t                LPB_TBL_MID_1;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L3FE_STG0_LPB_TBL_HIGH_1_t               LPB_TBL_HIGH_1;                /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L3FE_STG0_LPB_TBL_LOW_2_t                LPB_TBL_LOW_2;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L3FE_STG0_LPB_TBL_MID_2_t                LPB_TBL_MID_2;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L3FE_STG0_LPB_TBL_HIGH_2_t               LPB_TBL_HIGH_2;                /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L3FE_STG0_LPB_TBL_LOW_3_t                LPB_TBL_LOW_3;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L3FE_STG0_LPB_TBL_MID_3_t                LPB_TBL_MID_3;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L3FE_STG0_LPB_TBL_HIGH_3_t               LPB_TBL_HIGH_3;                /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L3FE_STG0_LPB_IDX_TBL_ACCESS_t           LPB_IDX_TBL_ACCESS;            /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L3FE_STG0_LPB_IDX_TBL_DATA_t             LPB_IDX_TBL_DATA;              /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L3FE_STG0_SPB_TBL_ACCESS_t               SPB_TBL_ACCESS;                /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L3FE_STG0_SPB_TBL_DATA_t                 SPB_TBL_DATA;                  /* addr: 0x00000044 */
} APB0_L3FE_STG0_t;
#endif /* !__ASSEMBLER__ */


/*
 * STG1
 */

#define L3FE_STG1_INTF_FF_CTL_REG                0xf4303480
#define L3FE_STG1_INTF_FF_CTL_REG_dft            0x00000032

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_thr              :  4 ; /* bits 3:0 */
    ca_uint32_t high_thr             :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG1_INTF_FF_STS_REG                0xf4303484
#define L3FE_STG1_INTF_FF_STS_REG_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ovfl_ind             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_STG1_INTF_FF_HDR_CNT                0xf4303488
#define L3FE_STG1_INTF_FF_HDR_CNT_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t num                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_HDR_CNT_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* STG1 */
#ifndef __ASSEMBLER__
typedef struct {
  L3FE_STG1_INTF_FF_CTL_REG_t              INTF_FF_CTL_REG;               /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L3FE_STG1_INTF_FF_STS_REG_t              INTF_FF_STS_REG;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L3FE_STG1_INTF_FF_HDR_CNT_t              INTF_FF_HDR_CNT;               /* addr: 0x00000008 */
} APB0_L3FE_STG1_t;
#endif /* !__ASSEMBLER__ */


/*
 * PE
 */

#define L3FE_PE_PPPOE_CFG                        0xf4303500
#define L3FE_PE_PPPOE_CFG_dft                    0x00000011

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sess_ver_type        :  8 ; /* bits 7:0 */
    ca_uint32_t pppoe_code           :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PPPOE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_PPPOE_PROT_CFG                   0xf4303504
#define L3FE_PE_PPPOE_PROT_CFG_dft               0x00570021

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ipv4_protocol        : 16 ; /* bits 15:0 */
    ca_uint32_t ipv6_protocol        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PPPOE_PROT_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MIB_CFG                          0xf4303508
#define L3FE_PE_MIB_CFG_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t counter_wrap_around  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIB_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_PKT_CLR                 0xf430350c
#define L3FE_PE_DROP_SRC_PKT_CLR_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_BYTE_CLR                0xf4303510
#define L3FE_PE_DROP_SRC_BYTE_CLR_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CLR                      0xf4303514
#define L3FE_PE_RX_IFID_CLR_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CLR                      0xf4303518
#define L3FE_PE_TX_IFID_CLR_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CLR_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_PE_CFG                           0xf430351c
#define L3FE_PE_PE_CFG_dft                       0x80100202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stomp_crc            :  1 ; /* bits 0:0 */
    ca_uint32_t bypass_crc_update    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ignore_tqm_fe_rdy    :  1 ; /* bits 3:3 */
    ca_uint32_t ldpid_base           :  6 ; /* bits 9:4 */
    ca_uint32_t gemid_map            :  1 ; /* bits 10:10 */
    ca_uint32_t dis_rd_add1          :  1 ; /* bits 11:11 */
    ca_uint32_t pad_ctrl             :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t mtu_fail_ldpid       :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t mtu_fail_cos         :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd4               :  4 ;
    ca_uint32_t mtu_chk_en           :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_0                       0xf4303520
#define L3FE_PE_MTU_SIZE_0_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_0                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_1                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_1                       0xf4303524
#define L3FE_PE_MTU_SIZE_1_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_2                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_3                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_2                       0xf4303528
#define L3FE_PE_MTU_SIZE_2_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_4                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_5                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_3                       0xf430352c
#define L3FE_PE_MTU_SIZE_3_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_6                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_7                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_4                       0xf4303530
#define L3FE_PE_MTU_SIZE_4_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_8                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_9                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_5                       0xf4303534
#define L3FE_PE_MTU_SIZE_5_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_10               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_11               : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_6                       0xf4303538
#define L3FE_PE_MTU_SIZE_6_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_12               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_13               : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MTU_SIZE_7                       0xf430353c
#define L3FE_PE_MTU_SIZE_7_dft                   0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mtu_14               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_15               : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MIRROR_CFG                       0xf4303540
#define L3FE_PE_MIRROR_CFG_dft                   0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mirr_fifo_high_threshold :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t mirr_cos             :  3 ; /* bits 18:16 */
    ca_uint32_t mirr_ldpid           :  6 ; /* bits 24:19 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIRROR_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_MIRROR_LEN_CFG                   0xf4303544
#define L3FE_PE_MIRROR_LEN_CFG_dft               0x00000080

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t mirr_len             : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIRROR_LEN_CFG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_ACCESS                  0xf4303548
#define L3FE_PE_DUAL_TBL_ACCESS_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA15                  0xf430354c
#define L3FE_PE_DUAL_TBL_DATA15_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA15_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA14                  0xf4303550
#define L3FE_PE_DUAL_TBL_DATA14_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA14_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA13                  0xf4303554
#define L3FE_PE_DUAL_TBL_DATA13_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA13_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA12                  0xf4303558
#define L3FE_PE_DUAL_TBL_DATA12_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA12_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA11                  0xf430355c
#define L3FE_PE_DUAL_TBL_DATA11_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA11_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA10                  0xf4303560
#define L3FE_PE_DUAL_TBL_DATA10_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA9                   0xf4303564
#define L3FE_PE_DUAL_TBL_DATA9_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA8                   0xf4303568
#define L3FE_PE_DUAL_TBL_DATA8_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA7                   0xf430356c
#define L3FE_PE_DUAL_TBL_DATA7_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA6                   0xf4303570
#define L3FE_PE_DUAL_TBL_DATA6_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA5                   0xf4303574
#define L3FE_PE_DUAL_TBL_DATA5_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA4                   0xf4303578
#define L3FE_PE_DUAL_TBL_DATA4_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA3                   0xf430357c
#define L3FE_PE_DUAL_TBL_DATA3_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA2                   0xf4303580
#define L3FE_PE_DUAL_TBL_DATA2_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA1                   0xf4303584
#define L3FE_PE_DUAL_TBL_DATA1_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DUAL_TBL_DATA0                   0xf4303588
#define L3FE_PE_DUAL_TBL_DATA0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DUAL_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS      0xf430358c
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1       0xf4303590
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0       0xf4303594
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS     0xf4303598
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1      0xf430359c
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0      0xf43035a0
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_ACCESS           0xf43035a4
#define L3FE_PE_RX_IFID_CNT_TBL_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA7            0xf43035a8
#define L3FE_PE_RX_IFID_CNT_TBL_DATA7_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA6            0xf43035ac
#define L3FE_PE_RX_IFID_CNT_TBL_DATA6_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA5            0xf43035b0
#define L3FE_PE_RX_IFID_CNT_TBL_DATA5_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA4            0xf43035b4
#define L3FE_PE_RX_IFID_CNT_TBL_DATA4_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA3            0xf43035b8
#define L3FE_PE_RX_IFID_CNT_TBL_DATA3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA2            0xf43035bc
#define L3FE_PE_RX_IFID_CNT_TBL_DATA2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA1            0xf43035c0
#define L3FE_PE_RX_IFID_CNT_TBL_DATA1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_RX_IFID_CNT_TBL_DATA0            0xf43035c4
#define L3FE_PE_RX_IFID_CNT_TBL_DATA0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_ACCESS           0xf43035c8
#define L3FE_PE_TX_IFID_CNT_TBL_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA6            0xf43035cc
#define L3FE_PE_TX_IFID_CNT_TBL_DATA6_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA5            0xf43035d0
#define L3FE_PE_TX_IFID_CNT_TBL_DATA5_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA4            0xf43035d4
#define L3FE_PE_TX_IFID_CNT_TBL_DATA4_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA3            0xf43035d8
#define L3FE_PE_TX_IFID_CNT_TBL_DATA3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA2            0xf43035dc
#define L3FE_PE_TX_IFID_CNT_TBL_DATA2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA1            0xf43035e0
#define L3FE_PE_TX_IFID_CNT_TBL_DATA1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_TX_IFID_CNT_TBL_DATA0            0xf43035e4
#define L3FE_PE_TX_IFID_CNT_TBL_DATA0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH1                      0xf43035e8
#define L3FE_PE_VXLAN_HASH1_dft                  0xffff0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t min_sport            : 16 ; /* bits 15:0 */
    ca_uint32_t max_sport            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH2_SPORT                0xf43035ec
#define L3FE_PE_VXLAN_HASH2_SPORT_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ptn                  : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH2_SPORT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH2_DPORT                0xf43035f0
#define L3FE_PE_VXLAN_HASH2_DPORT_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ptn                  : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH2_DPORT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH2_SIP                  0xf43035f4
#define L3FE_PE_VXLAN_HASH2_SIP_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ptn                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH2_SIP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_VXLAN_HASH2_DIP                  0xf43035f8
#define L3FE_PE_VXLAN_HASH2_DIP_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ptn                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_VXLAN_HASH2_DIP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK0_                        0xf43035fc
#define L3FE_PE_GRE_ACK0__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK0__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK1_                        0xf4303600
#define L3FE_PE_GRE_ACK1__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK1__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK2_                        0xf4303604
#define L3FE_PE_GRE_ACK2__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK2__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK3_                        0xf4303608
#define L3FE_PE_GRE_ACK3__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK3__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK4_                        0xf430360c
#define L3FE_PE_GRE_ACK4__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK4__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK5_                        0xf4303610
#define L3FE_PE_GRE_ACK5__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK5__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK6_                        0xf4303614
#define L3FE_PE_GRE_ACK6__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK6__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK7_                        0xf4303618
#define L3FE_PE_GRE_ACK7__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK7__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK8_                        0xf430361c
#define L3FE_PE_GRE_ACK8__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK8__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK9_                        0xf4303620
#define L3FE_PE_GRE_ACK9__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK9__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK10_                       0xf4303624
#define L3FE_PE_GRE_ACK10__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK10__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK11_                       0xf4303628
#define L3FE_PE_GRE_ACK11__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK11__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK12_                       0xf430362c
#define L3FE_PE_GRE_ACK12__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK12__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK13_                       0xf4303630
#define L3FE_PE_GRE_ACK13__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK13__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK14_                       0xf4303634
#define L3FE_PE_GRE_ACK14__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK14__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_ACK15_                       0xf4303638
#define L3FE_PE_GRE_ACK15__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_ACK15__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ0_                        0xf430363c
#define L3FE_PE_GRE_SEQ0__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ0__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ1_                        0xf4303640
#define L3FE_PE_GRE_SEQ1__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ1__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ2_                        0xf4303644
#define L3FE_PE_GRE_SEQ2__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ2__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ3_                        0xf4303648
#define L3FE_PE_GRE_SEQ3__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ3__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ4_                        0xf430364c
#define L3FE_PE_GRE_SEQ4__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ4__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ5_                        0xf4303650
#define L3FE_PE_GRE_SEQ5__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ5__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ6_                        0xf4303654
#define L3FE_PE_GRE_SEQ6__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ6__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ7_                        0xf4303658
#define L3FE_PE_GRE_SEQ7__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ7__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ8_                        0xf430365c
#define L3FE_PE_GRE_SEQ8__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ8__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ9_                        0xf4303660
#define L3FE_PE_GRE_SEQ9__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ9__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ10_                       0xf4303664
#define L3FE_PE_GRE_SEQ10__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ10__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ11_                       0xf4303668
#define L3FE_PE_GRE_SEQ11__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ11__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ12_                       0xf430366c
#define L3FE_PE_GRE_SEQ12__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ12__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ13_                       0xf4303670
#define L3FE_PE_GRE_SEQ13__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ13__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ14_                       0xf4303674
#define L3FE_PE_GRE_SEQ14__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ14__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_GRE_SEQ15_                       0xf4303678
#define L3FE_PE_GRE_SEQ15__dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_GRE_SEQ15__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID0_                         0xf430367c
#define L3FE_PE_IP4_ID0__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID0__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID1_                         0xf4303680
#define L3FE_PE_IP4_ID1__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID1__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID2_                         0xf4303684
#define L3FE_PE_IP4_ID2__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID2__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID3_                         0xf4303688
#define L3FE_PE_IP4_ID3__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID3__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID4_                         0xf430368c
#define L3FE_PE_IP4_ID4__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID4__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID5_                         0xf4303690
#define L3FE_PE_IP4_ID5__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID5__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID6_                         0xf4303694
#define L3FE_PE_IP4_ID6__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID6__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID7_                         0xf4303698
#define L3FE_PE_IP4_ID7__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID7__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID8_                         0xf430369c
#define L3FE_PE_IP4_ID8__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID8__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID9_                         0xf43036a0
#define L3FE_PE_IP4_ID9__dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID9__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID10_                        0xf43036a4
#define L3FE_PE_IP4_ID10__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID10__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID11_                        0xf43036a8
#define L3FE_PE_IP4_ID11__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID11__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID12_                        0xf43036ac
#define L3FE_PE_IP4_ID12__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID12__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID13_                        0xf43036b0
#define L3FE_PE_IP4_ID13__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID13__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID14_                        0xf43036b4
#define L3FE_PE_IP4_ID14__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID14__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_IP4_ID15_                        0xf43036b8
#define L3FE_PE_IP4_ID15__dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_IP4_ID15__t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_SOP_CNT                          0xf43036bc
#define L3FE_PE_SOP_CNT_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SOP_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_EOP_CNT                          0xf43036c0
#define L3FE_PE_EOP_CNT_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_EOP_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_BYTE_CNT1                        0xf43036c4
#define L3FE_PE_BYTE_CNT1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_BYTE_CNT1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_BYTE_CNT0                        0xf43036c8
#define L3FE_PE_BYTE_CNT0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t val0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_BYTE_CNT0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_PE_ERR_CNT                          0xf43036cc
#define L3FE_PE_ERR_CNT_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t len_err              :  8 ; /* bits 7:0 */
    ca_uint32_t sop_eop_err          :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_ERR_CNT_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE */
#ifndef __ASSEMBLER__
typedef struct {
  L3FE_PE_PPPOE_CFG_t                      PPPOE_CFG;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L3FE_PE_PPPOE_PROT_CFG_t                 PPPOE_PROT_CFG;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L3FE_PE_MIB_CFG_t                        MIB_CFG;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L3FE_PE_DROP_SRC_PKT_CLR_t               DROP_SRC_PKT_CLR;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];
  L3FE_PE_DROP_SRC_BYTE_CLR_t              DROP_SRC_BYTE_CLR;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];
  L3FE_PE_RX_IFID_CLR_t                    RX_IFID_CLR;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];
  L3FE_PE_TX_IFID_CLR_t                    TX_IFID_CLR;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];
  L3FE_PE_PE_CFG_t                         PE_CFG;                        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];
  L3FE_PE_MTU_SIZE_0_t                     MTU_SIZE_0;                    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];
  L3FE_PE_MTU_SIZE_1_t                     MTU_SIZE_1;                    /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];
  L3FE_PE_MTU_SIZE_2_t                     MTU_SIZE_2;                    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];
  L3FE_PE_MTU_SIZE_3_t                     MTU_SIZE_3;                    /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];
  L3FE_PE_MTU_SIZE_4_t                     MTU_SIZE_4;                    /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];
  L3FE_PE_MTU_SIZE_5_t                     MTU_SIZE_5;                    /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];
  L3FE_PE_MTU_SIZE_6_t                     MTU_SIZE_6;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];
  L3FE_PE_MTU_SIZE_7_t                     MTU_SIZE_7;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];
  L3FE_PE_MIRROR_CFG_t                     MIRROR_CFG;                    /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];
  L3FE_PE_MIRROR_LEN_CFG_t                 MIRROR_LEN_CFG;                /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];
  L3FE_PE_DUAL_TBL_ACCESS_t                DUAL_TBL_ACCESS;               /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];
  L3FE_PE_DUAL_TBL_DATA15_t                DUAL_TBL_DATA15;               /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];
  L3FE_PE_DUAL_TBL_DATA14_t                DUAL_TBL_DATA14;               /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];
  L3FE_PE_DUAL_TBL_DATA13_t                DUAL_TBL_DATA13;               /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];
  L3FE_PE_DUAL_TBL_DATA12_t                DUAL_TBL_DATA12;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];
  L3FE_PE_DUAL_TBL_DATA11_t                DUAL_TBL_DATA11;               /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];
  L3FE_PE_DUAL_TBL_DATA10_t                DUAL_TBL_DATA10;               /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];
  L3FE_PE_DUAL_TBL_DATA9_t                 DUAL_TBL_DATA9;                /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];
  L3FE_PE_DUAL_TBL_DATA8_t                 DUAL_TBL_DATA8;                /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];
  L3FE_PE_DUAL_TBL_DATA7_t                 DUAL_TBL_DATA7;                /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];
  L3FE_PE_DUAL_TBL_DATA6_t                 DUAL_TBL_DATA6;                /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];
  L3FE_PE_DUAL_TBL_DATA5_t                 DUAL_TBL_DATA5;                /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];
  L3FE_PE_DUAL_TBL_DATA4_t                 DUAL_TBL_DATA4;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];
  L3FE_PE_DUAL_TBL_DATA3_t                 DUAL_TBL_DATA3;                /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];
  L3FE_PE_DUAL_TBL_DATA2_t                 DUAL_TBL_DATA2;                /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];
  L3FE_PE_DUAL_TBL_DATA1_t                 DUAL_TBL_DATA1;                /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];
  L3FE_PE_DUAL_TBL_DATA0_t                 DUAL_TBL_DATA0;                /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];
  L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_t    DROP_SRC_PKT_CNT_TBL_ACCESS;   /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];
  L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_t     DROP_SRC_PKT_CNT_TBL_DATA1;    /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];
  L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_t     DROP_SRC_PKT_CNT_TBL_DATA0;    /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];
  L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_t   DROP_SRC_BYTE_CNT_TBL_ACCESS;  /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];
  L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_t    DROP_SRC_BYTE_CNT_TBL_DATA1;   /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];
  L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_t    DROP_SRC_BYTE_CNT_TBL_DATA0;   /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];
  L3FE_PE_RX_IFID_CNT_TBL_ACCESS_t         RX_IFID_CNT_TBL_ACCESS;        /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];
  L3FE_PE_RX_IFID_CNT_TBL_DATA7_t          RX_IFID_CNT_TBL_DATA7;         /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];
  L3FE_PE_RX_IFID_CNT_TBL_DATA6_t          RX_IFID_CNT_TBL_DATA6;         /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];
  L3FE_PE_RX_IFID_CNT_TBL_DATA5_t          RX_IFID_CNT_TBL_DATA5;         /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];
  L3FE_PE_RX_IFID_CNT_TBL_DATA4_t          RX_IFID_CNT_TBL_DATA4;         /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];
  L3FE_PE_RX_IFID_CNT_TBL_DATA3_t          RX_IFID_CNT_TBL_DATA3;         /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];
  L3FE_PE_RX_IFID_CNT_TBL_DATA2_t          RX_IFID_CNT_TBL_DATA2;         /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];
  L3FE_PE_RX_IFID_CNT_TBL_DATA1_t          RX_IFID_CNT_TBL_DATA1;         /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];
  L3FE_PE_RX_IFID_CNT_TBL_DATA0_t          RX_IFID_CNT_TBL_DATA0;         /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];
  L3FE_PE_TX_IFID_CNT_TBL_ACCESS_t         TX_IFID_CNT_TBL_ACCESS;        /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];
  L3FE_PE_TX_IFID_CNT_TBL_DATA6_t          TX_IFID_CNT_TBL_DATA6;         /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];
  L3FE_PE_TX_IFID_CNT_TBL_DATA5_t          TX_IFID_CNT_TBL_DATA5;         /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];
  L3FE_PE_TX_IFID_CNT_TBL_DATA4_t          TX_IFID_CNT_TBL_DATA4;         /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];
  L3FE_PE_TX_IFID_CNT_TBL_DATA3_t          TX_IFID_CNT_TBL_DATA3;         /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];
  L3FE_PE_TX_IFID_CNT_TBL_DATA2_t          TX_IFID_CNT_TBL_DATA2;         /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];
  L3FE_PE_TX_IFID_CNT_TBL_DATA1_t          TX_IFID_CNT_TBL_DATA1;         /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];
  L3FE_PE_TX_IFID_CNT_TBL_DATA0_t          TX_IFID_CNT_TBL_DATA0;         /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];
  L3FE_PE_VXLAN_HASH1_t                    VXLAN_HASH1;                   /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];
  L3FE_PE_VXLAN_HASH2_SPORT_t              VXLAN_HASH2_SPORT;             /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];
  L3FE_PE_VXLAN_HASH2_DPORT_t              VXLAN_HASH2_DPORT;             /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];
  L3FE_PE_VXLAN_HASH2_SIP_t                VXLAN_HASH2_SIP;               /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];
  L3FE_PE_VXLAN_HASH2_DIP_t                VXLAN_HASH2_DIP;               /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];
  L3FE_PE_GRE_ACK0__t                      GRE_ACK0_;                     /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];
  L3FE_PE_GRE_ACK1__t                      GRE_ACK1_;                     /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];
  L3FE_PE_GRE_ACK2__t                      GRE_ACK2_;                     /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];
  L3FE_PE_GRE_ACK3__t                      GRE_ACK3_;                     /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];
  L3FE_PE_GRE_ACK4__t                      GRE_ACK4_;                     /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];
  L3FE_PE_GRE_ACK5__t                      GRE_ACK5_;                     /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];
  L3FE_PE_GRE_ACK6__t                      GRE_ACK6_;                     /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];
  L3FE_PE_GRE_ACK7__t                      GRE_ACK7_;                     /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];
  L3FE_PE_GRE_ACK8__t                      GRE_ACK8_;                     /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];
  L3FE_PE_GRE_ACK9__t                      GRE_ACK9_;                     /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];
  L3FE_PE_GRE_ACK10__t                     GRE_ACK10_;                    /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];
  L3FE_PE_GRE_ACK11__t                     GRE_ACK11_;                    /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];
  L3FE_PE_GRE_ACK12__t                     GRE_ACK12_;                    /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];
  L3FE_PE_GRE_ACK13__t                     GRE_ACK13_;                    /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];
  L3FE_PE_GRE_ACK14__t                     GRE_ACK14_;                    /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];
  L3FE_PE_GRE_ACK15__t                     GRE_ACK15_;                    /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];
  L3FE_PE_GRE_SEQ0__t                      GRE_SEQ0_;                     /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];
  L3FE_PE_GRE_SEQ1__t                      GRE_SEQ1_;                     /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];
  L3FE_PE_GRE_SEQ2__t                      GRE_SEQ2_;                     /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];
  L3FE_PE_GRE_SEQ3__t                      GRE_SEQ3_;                     /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];
  L3FE_PE_GRE_SEQ4__t                      GRE_SEQ4_;                     /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];
  L3FE_PE_GRE_SEQ5__t                      GRE_SEQ5_;                     /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];
  L3FE_PE_GRE_SEQ6__t                      GRE_SEQ6_;                     /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];
  L3FE_PE_GRE_SEQ7__t                      GRE_SEQ7_;                     /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];
  L3FE_PE_GRE_SEQ8__t                      GRE_SEQ8_;                     /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];
  L3FE_PE_GRE_SEQ9__t                      GRE_SEQ9_;                     /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];
  L3FE_PE_GRE_SEQ10__t                     GRE_SEQ10_;                    /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];
  L3FE_PE_GRE_SEQ11__t                     GRE_SEQ11_;                    /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];
  L3FE_PE_GRE_SEQ12__t                     GRE_SEQ12_;                    /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];
  L3FE_PE_GRE_SEQ13__t                     GRE_SEQ13_;                    /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];
  L3FE_PE_GRE_SEQ14__t                     GRE_SEQ14_;                    /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];
  L3FE_PE_GRE_SEQ15__t                     GRE_SEQ15_;                    /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];
  L3FE_PE_IP4_ID0__t                       IP4_ID0_;                      /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];
  L3FE_PE_IP4_ID1__t                       IP4_ID1_;                      /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];
  L3FE_PE_IP4_ID2__t                       IP4_ID2_;                      /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];
  L3FE_PE_IP4_ID3__t                       IP4_ID3_;                      /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];
  L3FE_PE_IP4_ID4__t                       IP4_ID4_;                      /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];
  L3FE_PE_IP4_ID5__t                       IP4_ID5_;                      /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];
  L3FE_PE_IP4_ID6__t                       IP4_ID6_;                      /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];
  L3FE_PE_IP4_ID7__t                       IP4_ID7_;                      /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];
  L3FE_PE_IP4_ID8__t                       IP4_ID8_;                      /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];
  L3FE_PE_IP4_ID9__t                       IP4_ID9_;                      /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];
  L3FE_PE_IP4_ID10__t                      IP4_ID10_;                     /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];
  L3FE_PE_IP4_ID11__t                      IP4_ID11_;                     /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];
  L3FE_PE_IP4_ID12__t                      IP4_ID12_;                     /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];
  L3FE_PE_IP4_ID13__t                      IP4_ID13_;                     /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];
  L3FE_PE_IP4_ID14__t                      IP4_ID14_;                     /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];
  L3FE_PE_IP4_ID15__t                      IP4_ID15_;                     /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];
  L3FE_PE_SOP_CNT_t                        SOP_CNT;                       /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];
  L3FE_PE_EOP_CNT_t                        EOP_CNT;                       /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];
  L3FE_PE_BYTE_CNT1_t                      BYTE_CNT1;                     /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];
  L3FE_PE_BYTE_CNT0_t                      BYTE_CNT0;                     /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];
  L3FE_PE_ERR_CNT_t                        ERR_CNT;                       /* addr: 0x000001cc */
} APB0_L3FE_PE_t;
#endif /* !__ASSEMBLER__ */


/*
 * FE_L3E_HS
 */

#define L3FE_FE_L3E_HS_PROFILE0_INI              0xf4303700
#define L3FE_FE_L3E_HS_PROFILE0_INI_STRIDE       44
#define L3FE_FE_L3E_HS_PROFILE0_INI_COUNT        7
#define L3FE_FE_L3E_HS_PROFILE0_INI_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tpl_num              :  4 ; /* bits 3:0 */
    ca_uint32_t default_sel_0e       :  5 ; /* bits 8:4 */
    ca_uint32_t default_sel_0a       :  5 ; /* bits 13:9 */
    ca_uint32_t default_sel_1e       :  5 ; /* bits 18:14 */
    ca_uint32_t default_sel_1a       :  5 ; /* bits 23:19 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0           0xf4303704
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_STRIDE    44
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_COUNT     7
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t maskptr              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t pri                  :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t type                 :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_TUPLE0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION     0xf4303724
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_STRIDE 44
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_COUNT 7
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t a_mask               : 25 ; /* bits 24:0 */
    ca_uint32_t fetch_sz             :  3 ; /* bits 27:25 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_INI                  0xf4303834
#define L3FE_FE_L3E_HS_HASH_INI_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t hb_size              :  2 ; /* bits 1:0 */
    ca_uint32_t ht_size              :  3 ; /* bits 4:2 */
    ca_uint32_t ha_width             :  3 ; /* bits 7:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t def_reg              :  1 ; /* bits 16:16 */
    ca_uint32_t crc_ntfy_en          :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_MH1                    0xf4303838
#define L3FE_FE_L3E_HS_BA_MH1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MH1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_MH0                    0xf430383c
#define L3FE_FE_L3E_HS_BA_MH0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MH0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_MA1                    0xf4303840
#define L3FE_FE_L3E_HS_BA_MA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_MA0                    0xf4303844
#define L3FE_FE_L3E_HS_BA_MA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OVERFLOW_INI              0xf4303848
#define L3FE_FE_L3E_HS_OVERFLOW_INI_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t oa_width             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_OA1                    0xf430384c
#define L3FE_FE_L3E_HS_BA_OA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_OA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_OA0                    0xf4303850
#define L3FE_FE_L3E_HS_BA_OA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_OA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEFAULT_INI               0xf4303854
#define L3FE_FE_L3E_HS_DEFAULT_INI_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t da_width             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEFAULT_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_DA1                    0xf4303858
#define L3FE_FE_L3E_HS_BA_DA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_DA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_DA0                    0xf430385c
#define L3FE_FE_L3E_HS_BA_DA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_DA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0          0xf4303860
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_STRIDE   4
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_COUNT    16
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t a_mask               : 25 ; /* bits 24:0 */
    ca_uint32_t fetch_sz             :  3 ; /* bits 27:25 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEFAULT_ACTION_0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_INI                 0xf43038a0
#define L3FE_FE_L3E_HS_CACHE_INI_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ct_size              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ca_width             :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t fib_sram             :  1 ; /* bits 16:16 */
    ca_uint32_t cache_half           :  1 ; /* bits 17:17 */
    ca_uint32_t cache_age0_hit       :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_CA1                    0xf43038a4
#define L3FE_FE_L3E_HS_BA_CA1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_CA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_BA_CA0                    0xf43038a8
#define L3FE_FE_L3E_HS_BA_CA0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_CA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_CTRL                0xf43038ac
#define L3FE_FE_L3E_HS_CACHE_CTRL_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t slot                 :  5 ; /* bits 4:0 */
    ca_uint32_t crc16                : 16 ; /* bits 20:5 */
    ca_uint32_t aqm_prot             :  2 ; /* bits 22:21 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t loc                  :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t age                  :  2 ; /* bits 27:26 */
    ca_uint32_t pri                  :  2 ; /* bits 29:28 */
    ca_uint32_t cmd                  :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_CTRL_REQ            0xf43038b0
#define L3FE_FE_L3E_HS_CACHE_CTRL_REQ_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t req_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_REQ_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_CTRL_STS            0xf43038b4
#define L3FE_FE_L3E_HS_CACHE_CTRL_STS_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bsy                  :  1 ; /* bits 0:0 */
    ca_uint32_t err_hash             :  1 ; /* bits 1:1 */
    ca_uint32_t err_free             :  1 ; /* bits 2:2 */
    ca_uint32_t err_nch              :  1 ; /* bits 3:3 */
    ca_uint32_t sts_match            :  1 ; /* bits 4:4 */
    ca_uint32_t sts_match_loc        :  1 ; /* bits 5:5 */
    ca_uint32_t sts_evict            :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_STS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_AGE10               0xf43038b8
#define L3FE_FE_L3E_HS_CACHE_AGE10_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ut_t0                : 16 ; /* bits 15:0 */
    ca_uint32_t ut_t1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_AGE10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_AGE32               0xf43038bc
#define L3FE_FE_L3E_HS_CACHE_AGE32_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ut_t2                : 16 ; /* bits 15:0 */
    ca_uint32_t ut_t3                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_AGE32_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_CNT                 0xf43038c0
#define L3FE_FE_L3E_HS_CACHE_CNT_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ut_cnt               : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CNT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_MISC                0xf43038c4
#define L3FE_FE_L3E_HS_CACHE_MISC_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t s2_ra_en             :  1 ; /* bits 26:26 */
    ca_uint32_t s2_ra_pri            :  2 ; /* bits 28:27 */
    ca_uint32_t crep_en              :  1 ; /* bits 29:29 */
    ca_uint32_t s3_loc_n             :  1 ; /* bits 30:30 */
    ca_uint32_t s3_ra_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_MISC_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AXI_CTRL_1                0xf43038c8
#define L3FE_FE_L3E_HS_AXI_CTRL_1_STRIDE         4
#define L3FE_FE_L3E_HS_AXI_CTRL_1_COUNT          4
#define L3FE_FE_L3E_HS_AXI_CTRL_1_dft            0x02000f00

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t user                 : 25 ; /* bits 24:0 */
    ca_uint32_t id                   :  4 ; /* bits 28:25 */
    ca_uint32_t ace                  :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AXI_CTRL_1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_SWO_IDX                   0xf43038d8
#define L3FE_FE_L3E_HS_SWO_IDX_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t idx                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_IDX_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_SWO_DAT                   0xf43038dc
#define L3FE_FE_L3E_HS_SWO_DAT_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dat                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_DAT_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_SWO_CTRL                  0xf43038e0
#define L3FE_FE_L3E_HS_SWO_CTRL_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cmd_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_ACCESS         0xf43038e4
#define L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 17 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA6          0xf43038e8
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA6_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA5          0xf43038ec
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA5_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA4          0xf43038f0
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA4_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA3          0xf43038f4
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA3_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA2          0xf43038f8
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA2_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA1          0xf43038fc
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA1_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crc16                : 13 ; /* bits 12:0 */
    ca_uint32_t slot                 :  5 ; /* bits 17:13 */
    ca_uint32_t location             :  1 ; /* bits 18:18 */
    ca_uint32_t pri                  :  2 ; /* bits 20:19 */
    ca_uint32_t age                  :  2 ; /* bits 22:21 */
    ca_uint32_t fib                  :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA0          0xf4303900
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA0_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crc32                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS      0xf4303904
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_dft  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1       0xf4303908
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crc16                : 16 ; /* bits 15:0 */
    ca_uint32_t profile              :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0       0xf430390c
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t crc32                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_ACCESS           0xf4303910
#define L3FE_FE_L3E_HS_MASK_MEM_ACCESS_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_MASK3            0xf4303914
#define L3FE_FE_L3E_HS_MASK_MEM_MASK3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_MASK2            0xf4303918
#define L3FE_FE_L3E_HS_MASK_MEM_MASK2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_MASK1            0xf430391c
#define L3FE_FE_L3E_HS_MASK_MEM_MASK1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MASK_MEM_MASK0            0xf4303920
#define L3FE_FE_L3E_HS_MASK_MEM_MASK0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AGING_GRANULARITY         0xf4303924
#define L3FE_FE_L3E_HS_AGING_GRANULARITY_dft     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t timer                : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AGING_GRANULARITY_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS       0xf4303928
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_dft   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t address              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t age                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3        0xf430392c
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2        0xf4303930
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1        0xf4303934
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0        0xf4303938
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_MEM_INI                   0xf430393c
#define L3FE_FE_L3E_HS_MEM_INI_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t req_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MEM_INI_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_CHK_FAIL_CTRL             0xf4303940
#define L3FE_FE_L3E_HS_CHK_FAIL_CTRL_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t type0                :  8 ; /* bits 7:0 */
    ca_uint32_t type1                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CHK_FAIL_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_RSV0                      0xf4303944
#define L3FE_FE_L3E_HS_RSV0_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsv                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_RSV0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_RSV1                      0xf4303948
#define L3FE_FE_L3E_HS_RSV1_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsv                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_RSV1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_KEY                  0xf430394c
#define L3FE_FE_L3E_HS_PF_0_KEY_STRIDE           20
#define L3FE_FE_L3E_HS_PF_0_KEY_COUNT            7
#define L3FE_FE_L3E_HS_PF_0_KEY_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t sel                  :  6 ; /* bits 5:0 */
    ca_uint32_t crc32_sel            :  2 ; /* bits 7:6 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_KEY_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_TPL_SP               0xf4303950
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_STRIDE        20
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_COUNT         7
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_TPL_SP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_TPL_DP               0xf4303954
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_STRIDE        20
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_COUNT         7
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_TPL_DP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_TPL_SIP              0xf4303958
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_STRIDE       20
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_COUNT        7
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_TPL_SIP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_PF_0_TPL_DIP              0xf430395c
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_STRIDE       20
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_COUNT        7
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ctrl                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PF_0_TPL_DIP_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_INV_MAC                   0xf43039d8
#define L3FE_FE_L3E_HS_INV_MAC_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t deepq                :  1 ; /* bits 6:6 */
    ca_uint32_t deepq_vld            :  1 ; /* bits 7:7 */
    ca_uint32_t keep_ori             :  1 ; /* bits 8:8 */
    ca_uint32_t keep_ori_vld         :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_INV_MAC_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY0             0xf43039dc
#define L3FE_FE_L3E_HS_DEF_REG0_ETY0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY0             0xf43039e0
#define L3FE_FE_L3E_HS_DEF_REG1_ETY0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY0             0xf43039e4
#define L3FE_FE_L3E_HS_DEF_REG2_ETY0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY1             0xf43039e8
#define L3FE_FE_L3E_HS_DEF_REG0_ETY1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY1             0xf43039ec
#define L3FE_FE_L3E_HS_DEF_REG1_ETY1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY1             0xf43039f0
#define L3FE_FE_L3E_HS_DEF_REG2_ETY1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY2             0xf43039f4
#define L3FE_FE_L3E_HS_DEF_REG0_ETY2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY2             0xf43039f8
#define L3FE_FE_L3E_HS_DEF_REG1_ETY2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY2             0xf43039fc
#define L3FE_FE_L3E_HS_DEF_REG2_ETY2_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY3             0xf4303a00
#define L3FE_FE_L3E_HS_DEF_REG0_ETY3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY3             0xf4303a04
#define L3FE_FE_L3E_HS_DEF_REG1_ETY3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY3             0xf4303a08
#define L3FE_FE_L3E_HS_DEF_REG2_ETY3_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY4             0xf4303a0c
#define L3FE_FE_L3E_HS_DEF_REG0_ETY4_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY4             0xf4303a10
#define L3FE_FE_L3E_HS_DEF_REG1_ETY4_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY4             0xf4303a14
#define L3FE_FE_L3E_HS_DEF_REG2_ETY4_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG0_ETY5             0xf4303a18
#define L3FE_FE_L3E_HS_DEF_REG0_ETY5_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG0_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG1_ETY5             0xf4303a1c
#define L3FE_FE_L3E_HS_DEF_REG1_ETY5_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG1_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_DEF_REG2_ETY5             0xf4303a20
#define L3FE_FE_L3E_HS_DEF_REG2_ETY5_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fib2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEF_REG2_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY0            0xf4303a24
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY0            0xf4303a28
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY0_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY0_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY1            0xf4303a2c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY1            0xf4303a30
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY1_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY1_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY2            0xf4303a34
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY2            0xf4303a38
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY2_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY2_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY3            0xf4303a3c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY3            0xf4303a40
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY3_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY3_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY4            0xf4303a44
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY4_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY4            0xf4303a48
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY4_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY4_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY5            0xf4303a4c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY5_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY5            0xf4303a50
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY5_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY5_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY6            0xf4303a54
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY6_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY6            0xf4303a58
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY6_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY6_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY7            0xf4303a5c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY7_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY7            0xf4303a60
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY7_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY7_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY8            0xf4303a64
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY8_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY8            0xf4303a68
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY8_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY8_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY9            0xf4303a6c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY9_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY9            0xf4303a70
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY9_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY9_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY10           0xf4303a74
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY10_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY10           0xf4303a78
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY10_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY10_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY11           0xf4303a7c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY11_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY11_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY11           0xf4303a80
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY11_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY11_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY12           0xf4303a84
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY12_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY12_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY12           0xf4303a88
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY12_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY12_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY13           0xf4303a8c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY13_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY13_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY13           0xf4303a90
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY13_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY13_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY14           0xf4303a94
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY14_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY14_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY14           0xf4303a98
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY14_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY14_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG0_ETY15           0xf4303a9c
#define L3FE_FE_L3E_HS_NPT6_REG0_ETY15_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG0_ETY15_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_NPT6_REG1_ETY15           0xf4303aa0
#define L3FE_FE_L3E_HS_NPT6_REG1_ETY15_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t npt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_NPT6_REG1_ETY15_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AQM_SET                   0xf4303aa4
#define L3FE_FE_L3E_HS_AQM_SET_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t en                   :  1 ; /* bits 0:0 */
    ca_uint32_t cnt_md               :  1 ; /* bits 1:1 */
    ca_uint32_t act_tp               :  1 ; /* bits 2:2 */
    ca_uint32_t cos_en               :  3 ; /* bits 5:3 */
    ca_uint32_t sml_cos              :  3 ; /* bits 8:6 */
    ca_uint32_t mid_cos              :  3 ; /* bits 11:9 */
    ca_uint32_t big_cos              :  3 ; /* bits 14:12 */
    ca_uint32_t mid_on_prot          :  3 ; /* bits 17:15 */
    ca_uint32_t big_on_prot          :  3 ; /* bits 20:18 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AQM_SET_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AQM_INTER                 0xf4303aa8
#define L3FE_FE_L3E_HS_AQM_INTER_dft             0x9000a2d0

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt_sft              :  5 ; /* bits 4:0 */
    ca_uint32_t entry                : 23 ; /* bits 27:5 */
    ca_uint32_t bcnt_sft             :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AQM_INTER_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AQM_MID                   0xf4303aac
#define L3FE_FE_L3E_HS_AQM_MID_dft               0x00001fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t on_thr               : 13 ; /* bits 12:0 */
    ca_uint32_t off_thr              : 13 ; /* bits 25:13 */
    ca_uint32_t on_thr_size          :  4 ; /* bits 29:26 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AQM_MID_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_FE_L3E_HS_AQM_BIG                   0xf4303ab0
#define L3FE_FE_L3E_HS_AQM_BIG_dft               0x00001fff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t on_thr               : 13 ; /* bits 12:0 */
    ca_uint32_t off_thr              : 13 ; /* bits 25:13 */
    ca_uint32_t on_thr_size          :  4 ; /* bits 29:26 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AQM_BIG_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FE_L3E_HS */
#ifndef __ASSEMBLER__
typedef struct {
  L3FE_FE_L3E_HS_PROFILE0_INI_t            PROFILE0_INI;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L3FE_FE_L3E_HS_PROFILE0_TUPLE0_t         PROFILE0_TUPLE0;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[31];
  L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_t   PROFILE0_TYPE0_ACTION;         /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd3[271];
  L3FE_FE_L3E_HS_HASH_INI_t                HASH_INI;                      /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd4[3];
  L3FE_FE_L3E_HS_BA_MH1_t                  BA_MH1;                        /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd5[3];
  L3FE_FE_L3E_HS_BA_MH0_t                  BA_MH0;                        /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd6[3];
  L3FE_FE_L3E_HS_BA_MA1_t                  BA_MA1;                        /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd7[3];
  L3FE_FE_L3E_HS_BA_MA0_t                  BA_MA0;                        /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd8[3];
  L3FE_FE_L3E_HS_OVERFLOW_INI_t            OVERFLOW_INI;                  /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd9[3];
  L3FE_FE_L3E_HS_BA_OA1_t                  BA_OA1;                        /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd10[3];
  L3FE_FE_L3E_HS_BA_OA0_t                  BA_OA0;                        /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd11[3];
  L3FE_FE_L3E_HS_DEFAULT_INI_t             DEFAULT_INI;                   /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd12[3];
  L3FE_FE_L3E_HS_BA_DA1_t                  BA_DA1;                        /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd13[3];
  L3FE_FE_L3E_HS_BA_DA0_t                  BA_DA0;                        /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd14[3];
  L3FE_FE_L3E_HS_DEFAULT_ACTION_0_t        DEFAULT_ACTION_0;              /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd15[63];
  L3FE_FE_L3E_HS_CACHE_INI_t               CACHE_INI;                     /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd16[3];
  L3FE_FE_L3E_HS_BA_CA1_t                  BA_CA1;                        /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd17[3];
  L3FE_FE_L3E_HS_BA_CA0_t                  BA_CA0;                        /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd18[3];
  L3FE_FE_L3E_HS_CACHE_CTRL_t              CACHE_CTRL;                    /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd19[3];
  L3FE_FE_L3E_HS_CACHE_CTRL_REQ_t          CACHE_CTRL_REQ;                /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd20[3];
  L3FE_FE_L3E_HS_CACHE_CTRL_STS_t          CACHE_CTRL_STS;                /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd21[3];
  L3FE_FE_L3E_HS_CACHE_AGE10_t             CACHE_AGE10;                   /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd22[3];
  L3FE_FE_L3E_HS_CACHE_AGE32_t             CACHE_AGE32;                   /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd23[3];
  L3FE_FE_L3E_HS_CACHE_CNT_t               CACHE_CNT;                     /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd24[3];
  L3FE_FE_L3E_HS_CACHE_MISC_t              CACHE_MISC;                    /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd25[3];
  L3FE_FE_L3E_HS_AXI_CTRL_1_t              AXI_CTRL_1;                    /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd26[15];
  L3FE_FE_L3E_HS_SWO_IDX_t                 SWO_IDX;                       /* addr: 0x000001d8 */
  ca_uint32_t                              rsrvd27[3];
  L3FE_FE_L3E_HS_SWO_DAT_t                 SWO_DAT;                       /* addr: 0x000001dc */
  ca_uint32_t                              rsrvd28[3];
  L3FE_FE_L3E_HS_SWO_CTRL_t                SWO_CTRL;                      /* addr: 0x000001e0 */
  ca_uint32_t                              rsrvd29[3];
  L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_t       CACHE_HASH_ACCESS;             /* addr: 0x000001e4 */
  ca_uint32_t                              rsrvd30[3];
  L3FE_FE_L3E_HS_CACHE_HASH_DATA6_t        CACHE_HASH_DATA6;              /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd31[3];
  L3FE_FE_L3E_HS_CACHE_HASH_DATA5_t        CACHE_HASH_DATA5;              /* addr: 0x000001ec */
  ca_uint32_t                              rsrvd32[3];
  L3FE_FE_L3E_HS_CACHE_HASH_DATA4_t        CACHE_HASH_DATA4;              /* addr: 0x000001f0 */
  ca_uint32_t                              rsrvd33[3];
  L3FE_FE_L3E_HS_CACHE_HASH_DATA3_t        CACHE_HASH_DATA3;              /* addr: 0x000001f4 */
  ca_uint32_t                              rsrvd34[3];
  L3FE_FE_L3E_HS_CACHE_HASH_DATA2_t        CACHE_HASH_DATA2;              /* addr: 0x000001f8 */
  ca_uint32_t                              rsrvd35[3];
  L3FE_FE_L3E_HS_CACHE_HASH_DATA1_t        CACHE_HASH_DATA1;              /* addr: 0x000001fc */
  ca_uint32_t                              rsrvd36[3];
  L3FE_FE_L3E_HS_CACHE_HASH_DATA0_t        CACHE_HASH_DATA0;              /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd37[3];
  L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_t    OVERFLOW_HASH_ACCESS;          /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd38[3];
  L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_t     OVERFLOW_HASH_DATA1;           /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd39[3];
  L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_t     OVERFLOW_HASH_DATA0;           /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd40[3];
  L3FE_FE_L3E_HS_MASK_MEM_ACCESS_t         MASK_MEM_ACCESS;               /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd41[3];
  L3FE_FE_L3E_HS_MASK_MEM_MASK3_t          MASK_MEM_MASK3;                /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd42[3];
  L3FE_FE_L3E_HS_MASK_MEM_MASK2_t          MASK_MEM_MASK2;                /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd43[3];
  L3FE_FE_L3E_HS_MASK_MEM_MASK1_t          MASK_MEM_MASK1;                /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd44[3];
  L3FE_FE_L3E_HS_MASK_MEM_MASK0_t          MASK_MEM_MASK0;                /* addr: 0x00000220 */
  ca_uint32_t                              rsrvd45[3];
  L3FE_FE_L3E_HS_AGING_GRANULARITY_t       AGING_GRANULARITY;             /* addr: 0x00000224 */
  ca_uint32_t                              rsrvd46[3];
  L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_t     HASH_AGE_MEM_ACCESS;           /* addr: 0x00000228 */
  ca_uint32_t                              rsrvd47[3];
  L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_t      HASH_AGE_MEM_DATA3;            /* addr: 0x0000022c */
  ca_uint32_t                              rsrvd48[3];
  L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_t      HASH_AGE_MEM_DATA2;            /* addr: 0x00000230 */
  ca_uint32_t                              rsrvd49[3];
  L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_t      HASH_AGE_MEM_DATA1;            /* addr: 0x00000234 */
  ca_uint32_t                              rsrvd50[3];
  L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_t      HASH_AGE_MEM_DATA0;            /* addr: 0x00000238 */
  ca_uint32_t                              rsrvd51[3];
  L3FE_FE_L3E_HS_MEM_INI_t                 MEM_INI;                       /* addr: 0x0000023c */
  ca_uint32_t                              rsrvd52[3];
  L3FE_FE_L3E_HS_CHK_FAIL_CTRL_t           CHK_FAIL_CTRL;                 /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd53[3];
  L3FE_FE_L3E_HS_RSV0_t                    RSV0;                          /* addr: 0x00000244 */
  ca_uint32_t                              rsrvd54[3];
  L3FE_FE_L3E_HS_RSV1_t                    RSV1;                          /* addr: 0x00000248 */
  ca_uint32_t                              rsrvd55[3];
  L3FE_FE_L3E_HS_PF_0_KEY_t                PF_0_KEY;                      /* addr: 0x0000024c */
  ca_uint32_t                              rsrvd56[3];
  L3FE_FE_L3E_HS_PF_0_TPL_SP_t             PF_0_TPL_SP;                   /* addr: 0x00000250 */
  ca_uint32_t                              rsrvd57[3];
  L3FE_FE_L3E_HS_PF_0_TPL_DP_t             PF_0_TPL_DP;                   /* addr: 0x00000254 */
  ca_uint32_t                              rsrvd58[3];
  L3FE_FE_L3E_HS_PF_0_TPL_SIP_t            PF_0_TPL_SIP;                  /* addr: 0x00000258 */
  ca_uint32_t                              rsrvd59[3];
  L3FE_FE_L3E_HS_PF_0_TPL_DIP_t            PF_0_TPL_DIP;                  /* addr: 0x0000025c */
  ca_uint32_t                              rsrvd60[123];
  L3FE_FE_L3E_HS_INV_MAC_t                 INV_MAC;                       /* addr: 0x000002d8 */
  ca_uint32_t                              rsrvd61[3];
  L3FE_FE_L3E_HS_DEF_REG0_ETY0_t           DEF_REG0_ETY0;                 /* addr: 0x000002dc */
  ca_uint32_t                              rsrvd62[3];
  L3FE_FE_L3E_HS_DEF_REG1_ETY0_t           DEF_REG1_ETY0;                 /* addr: 0x000002e0 */
  ca_uint32_t                              rsrvd63[3];
  L3FE_FE_L3E_HS_DEF_REG2_ETY0_t           DEF_REG2_ETY0;                 /* addr: 0x000002e4 */
  ca_uint32_t                              rsrvd64[3];
  L3FE_FE_L3E_HS_DEF_REG0_ETY1_t           DEF_REG0_ETY1;                 /* addr: 0x000002e8 */
  ca_uint32_t                              rsrvd65[3];
  L3FE_FE_L3E_HS_DEF_REG1_ETY1_t           DEF_REG1_ETY1;                 /* addr: 0x000002ec */
  ca_uint32_t                              rsrvd66[3];
  L3FE_FE_L3E_HS_DEF_REG2_ETY1_t           DEF_REG2_ETY1;                 /* addr: 0x000002f0 */
  ca_uint32_t                              rsrvd67[3];
  L3FE_FE_L3E_HS_DEF_REG0_ETY2_t           DEF_REG0_ETY2;                 /* addr: 0x000002f4 */
  ca_uint32_t                              rsrvd68[3];
  L3FE_FE_L3E_HS_DEF_REG1_ETY2_t           DEF_REG1_ETY2;                 /* addr: 0x000002f8 */
  ca_uint32_t                              rsrvd69[3];
  L3FE_FE_L3E_HS_DEF_REG2_ETY2_t           DEF_REG2_ETY2;                 /* addr: 0x000002fc */
  ca_uint32_t                              rsrvd70[3];
  L3FE_FE_L3E_HS_DEF_REG0_ETY3_t           DEF_REG0_ETY3;                 /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd71[3];
  L3FE_FE_L3E_HS_DEF_REG1_ETY3_t           DEF_REG1_ETY3;                 /* addr: 0x00000304 */
  ca_uint32_t                              rsrvd72[3];
  L3FE_FE_L3E_HS_DEF_REG2_ETY3_t           DEF_REG2_ETY3;                 /* addr: 0x00000308 */
  ca_uint32_t                              rsrvd73[3];
  L3FE_FE_L3E_HS_DEF_REG0_ETY4_t           DEF_REG0_ETY4;                 /* addr: 0x0000030c */
  ca_uint32_t                              rsrvd74[3];
  L3FE_FE_L3E_HS_DEF_REG1_ETY4_t           DEF_REG1_ETY4;                 /* addr: 0x00000310 */
  ca_uint32_t                              rsrvd75[3];
  L3FE_FE_L3E_HS_DEF_REG2_ETY4_t           DEF_REG2_ETY4;                 /* addr: 0x00000314 */
  ca_uint32_t                              rsrvd76[3];
  L3FE_FE_L3E_HS_DEF_REG0_ETY5_t           DEF_REG0_ETY5;                 /* addr: 0x00000318 */
  ca_uint32_t                              rsrvd77[3];
  L3FE_FE_L3E_HS_DEF_REG1_ETY5_t           DEF_REG1_ETY5;                 /* addr: 0x0000031c */
  ca_uint32_t                              rsrvd78[3];
  L3FE_FE_L3E_HS_DEF_REG2_ETY5_t           DEF_REG2_ETY5;                 /* addr: 0x00000320 */
  ca_uint32_t                              rsrvd79[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY0_t          NPT6_REG0_ETY0;                /* addr: 0x00000324 */
  ca_uint32_t                              rsrvd80[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY0_t          NPT6_REG1_ETY0;                /* addr: 0x00000328 */
  ca_uint32_t                              rsrvd81[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY1_t          NPT6_REG0_ETY1;                /* addr: 0x0000032c */
  ca_uint32_t                              rsrvd82[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY1_t          NPT6_REG1_ETY1;                /* addr: 0x00000330 */
  ca_uint32_t                              rsrvd83[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY2_t          NPT6_REG0_ETY2;                /* addr: 0x00000334 */
  ca_uint32_t                              rsrvd84[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY2_t          NPT6_REG1_ETY2;                /* addr: 0x00000338 */
  ca_uint32_t                              rsrvd85[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY3_t          NPT6_REG0_ETY3;                /* addr: 0x0000033c */
  ca_uint32_t                              rsrvd86[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY3_t          NPT6_REG1_ETY3;                /* addr: 0x00000340 */
  ca_uint32_t                              rsrvd87[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY4_t          NPT6_REG0_ETY4;                /* addr: 0x00000344 */
  ca_uint32_t                              rsrvd88[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY4_t          NPT6_REG1_ETY4;                /* addr: 0x00000348 */
  ca_uint32_t                              rsrvd89[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY5_t          NPT6_REG0_ETY5;                /* addr: 0x0000034c */
  ca_uint32_t                              rsrvd90[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY5_t          NPT6_REG1_ETY5;                /* addr: 0x00000350 */
  ca_uint32_t                              rsrvd91[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY6_t          NPT6_REG0_ETY6;                /* addr: 0x00000354 */
  ca_uint32_t                              rsrvd92[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY6_t          NPT6_REG1_ETY6;                /* addr: 0x00000358 */
  ca_uint32_t                              rsrvd93[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY7_t          NPT6_REG0_ETY7;                /* addr: 0x0000035c */
  ca_uint32_t                              rsrvd94[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY7_t          NPT6_REG1_ETY7;                /* addr: 0x00000360 */
  ca_uint32_t                              rsrvd95[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY8_t          NPT6_REG0_ETY8;                /* addr: 0x00000364 */
  ca_uint32_t                              rsrvd96[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY8_t          NPT6_REG1_ETY8;                /* addr: 0x00000368 */
  ca_uint32_t                              rsrvd97[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY9_t          NPT6_REG0_ETY9;                /* addr: 0x0000036c */
  ca_uint32_t                              rsrvd98[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY9_t          NPT6_REG1_ETY9;                /* addr: 0x00000370 */
  ca_uint32_t                              rsrvd99[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY10_t         NPT6_REG0_ETY10;               /* addr: 0x00000374 */
  ca_uint32_t                              rsrvd100[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY10_t         NPT6_REG1_ETY10;               /* addr: 0x00000378 */
  ca_uint32_t                              rsrvd101[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY11_t         NPT6_REG0_ETY11;               /* addr: 0x0000037c */
  ca_uint32_t                              rsrvd102[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY11_t         NPT6_REG1_ETY11;               /* addr: 0x00000380 */
  ca_uint32_t                              rsrvd103[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY12_t         NPT6_REG0_ETY12;               /* addr: 0x00000384 */
  ca_uint32_t                              rsrvd104[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY12_t         NPT6_REG1_ETY12;               /* addr: 0x00000388 */
  ca_uint32_t                              rsrvd105[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY13_t         NPT6_REG0_ETY13;               /* addr: 0x0000038c */
  ca_uint32_t                              rsrvd106[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY13_t         NPT6_REG1_ETY13;               /* addr: 0x00000390 */
  ca_uint32_t                              rsrvd107[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY14_t         NPT6_REG0_ETY14;               /* addr: 0x00000394 */
  ca_uint32_t                              rsrvd108[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY14_t         NPT6_REG1_ETY14;               /* addr: 0x00000398 */
  ca_uint32_t                              rsrvd109[3];
  L3FE_FE_L3E_HS_NPT6_REG0_ETY15_t         NPT6_REG0_ETY15;               /* addr: 0x0000039c */
  ca_uint32_t                              rsrvd110[3];
  L3FE_FE_L3E_HS_NPT6_REG1_ETY15_t         NPT6_REG1_ETY15;               /* addr: 0x000003a0 */
  ca_uint32_t                              rsrvd111[3];
  L3FE_FE_L3E_HS_AQM_SET_t                 AQM_SET;                       /* addr: 0x000003a4 */
  ca_uint32_t                              rsrvd112[3];
  L3FE_FE_L3E_HS_AQM_INTER_t               AQM_INTER;                     /* addr: 0x000003a8 */
  ca_uint32_t                              rsrvd113[3];
  L3FE_FE_L3E_HS_AQM_MID_t                 AQM_MID;                       /* addr: 0x000003ac */
  ca_uint32_t                              rsrvd114[3];
  L3FE_FE_L3E_HS_AQM_BIG_t                 AQM_BIG;                       /* addr: 0x000003b0 */
} APB0_L3FE_FE_L3E_HS_t;
#endif /* !__ASSEMBLER__ */


/*
 * AXIM2
 */

#define L3FE_AXIM2_CONFIG                        0xf4303c80
#define L3FE_AXIM2_CONFIG_dft                    0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_write_outtrans_num :  4 ; /* bits 3:0 */
    ca_uint32_t axi_read_outtrans_num :  4 ; /* bits 7:4 */
    ca_uint32_t axi_xbus_len         :  3 ; /* bits 10:8 */
    ca_uint32_t write_cacheline_trans_en :  1 ; /* bits 11:11 */
    ca_uint32_t write_cacheline_trans_size :  1 ; /* bits 12:12 */
    ca_uint32_t read_cacheline_trans_en :  1 ; /* bits 13:13 */
    ca_uint32_t read_cacheline_trans_size :  1 ; /* bits 14:14 */
    ca_uint32_t arcache_eos_en       :  1 ; /* bits 15:15 */
    ca_uint32_t awcache_eos_en       :  1 ; /* bits 16:16 */
    ca_uint32_t reserved             : 15 ; /* bits 31:17 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_AXIM2_TIMEOUT_THRESHOLD             0xf4303c84
#define L3FE_AXIM2_TIMEOUT_THRESHOLD_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_channel_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t write_channel_threshold :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_TIMEOUT_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_AXIM2_INTERRUPT_STATUS              0xf4303c88
#define L3FE_AXIM2_INTERRUPT_STATUS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define L3FE_AXIM2_INTERRUPT_ENABLE              0xf4303c8c
#define L3FE_AXIM2_INTERRUPT_ENABLE_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int_en :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int_en :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int_en :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int_en :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* AXIM2 */
#ifndef __ASSEMBLER__
typedef struct {
  L3FE_AXIM2_CONFIG_t                      CONFIG;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  L3FE_AXIM2_TIMEOUT_THRESHOLD_t           TIMEOUT_THRESHOLD;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  L3FE_AXIM2_INTERRUPT_STATUS_t            INTERRUPT_STATUS;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  L3FE_AXIM2_INTERRUPT_ENABLE_t            INTERRUPT_ENABLE;              /* addr: 0x0000000c */
} APB0_L3FE_AXIM2_t;
#endif /* !__ASSEMBLER__ */




/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L3FE */

#ifndef __ASSEMBLER__
typedef struct {
  APB0_L3FE_GLB_t                   GLB;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[337];
  APB0_L3FE_PP_t                    PP;                            /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd2[219];
  APB0_L3FE_CLS_t                   CLS;                           /* addr: 0x00000380 */
  ca_uint32_t                              rsrvd3[89];
  APB0_L3FE_STG0_t                  STG0;                          /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd4[93];
  APB0_L3FE_STG1_t                  STG1;                          /* addr: 0x00000480 */
  ca_uint32_t                              rsrvd5[123];
  APB0_L3FE_PE_t                    PE;                            /* addr: 0x00000500 */
  ca_uint32_t                              rsrvd6[281];
  APB0_L3FE_FE_L3E_HS_t             FE_L3E_HS;                     /* addr: 0x00000700 */
  ca_uint32_t                              rsrvd7[935];
  APB0_L3FE_AXIM2_t                 AXIM2;                         /* addr: 0x00000c80 */
} APB0_L3FE_t;
#endif /* !__ASSEMBLER__ */


/*
 * QM
 */

/*
 * AXIM2
 */

#define QM_AXIM2_CONFIG                          0xf4306000
#define QM_AXIM2_CONFIG_dft                      0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_write_outtrans_num :  4 ; /* bits 3:0 */
    ca_uint32_t axi_read_outtrans_num :  4 ; /* bits 7:4 */
    ca_uint32_t axi_xbus_len         :  3 ; /* bits 10:8 */
    ca_uint32_t write_cacheline_trans_en :  1 ; /* bits 11:11 */
    ca_uint32_t write_cacheline_trans_size :  1 ; /* bits 12:12 */
    ca_uint32_t read_cacheline_trans_en :  1 ; /* bits 13:13 */
    ca_uint32_t read_cacheline_trans_size :  1 ; /* bits 14:14 */
    ca_uint32_t arcache_eos_en       :  1 ; /* bits 15:15 */
    ca_uint32_t awcache_eos_en       :  1 ; /* bits 16:16 */
    ca_uint32_t reserved             : 15 ; /* bits 31:17 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_AXIM2_CONFIG_t;
#endif /* !__ASSEMBLER__ */


#define QM_AXIM2_TIMEOUT_THRESHOLD               0xf4306004
#define QM_AXIM2_TIMEOUT_THRESHOLD_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_channel_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t write_channel_threshold :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_AXIM2_TIMEOUT_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */


#define QM_AXIM2_INTERRUPT_STATUS                0xf4306008
#define QM_AXIM2_INTERRUPT_STATUS_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_AXIM2_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define QM_AXIM2_INTERRUPT_ENABLE                0xf430600c
#define QM_AXIM2_INTERRUPT_ENABLE_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int_en :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int_en :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int_en :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int_en :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_AXIM2_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* AXIM2 */
#ifndef __ASSEMBLER__
typedef struct {
  QM_AXIM2_CONFIG_t                        CONFIG;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  QM_AXIM2_TIMEOUT_THRESHOLD_t             TIMEOUT_THRESHOLD;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  QM_AXIM2_INTERRUPT_STATUS_t              INTERRUPT_STATUS;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];
  QM_AXIM2_INTERRUPT_ENABLE_t              INTERRUPT_ENABLE;              /* addr: 0x0000000c */
} APB0_QM_AXIM2_t;
#endif /* !__ASSEMBLER__ */


/*
 * qm
 */

#define QM_QM_REVISION                           0xf4306100
#define QM_QM_REVISION_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_REVISION_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_CTRL                          0xf4306104
#define QM_QM_RMU0_CTRL_dft                      0x80000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_drop_voqid       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t voq_drop_en          :  2 ; /* bits 11:10 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t no_buf_drop_prevention_ths :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t no_buf_drop_prevention_en :  1 ; /* bits 19:19 */
    ca_uint32_t rx_performance_tuning_timeout_ths :  2 ; /* bits 21:20 */
    ca_uint32_t rsrvd4               :  2 ;
    ca_uint32_t febypass_msk         :  2 ; /* bits 25:24 */
    ca_uint32_t rsrvd5               :  3 ;
    ca_uint32_t rx_performance_tuning_en :  1 ; /* bits 29:29 */
    ca_uint32_t stop_rx_en           :  1 ; /* bits 30:30 */
    ca_uint32_t rx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_ES_CTRL                            0xf4306108
#define QM_QM_ES_CTRL_dft                        0x0664ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cpu_en               :  8 ; /* bits 7:0 */
    ca_uint32_t ni_en                :  8 ; /* bits 15:8 */
    ca_uint32_t inccfg_for_pkt_cntrs :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t inccfg_for_err_cntrs :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t crc_err_bypass       :  1 ; /* bits 24:24 */
    ca_uint32_t crc_en               :  1 ; /* bits 25:25 */
    ca_uint32_t cpuepp_wait_timer_max :  2 ; /* bits 27:26 */
    ca_uint32_t bw_relocation_en     :  1 ; /* bits 28:28 */
    ca_uint32_t bw_relocation_cpu_en :  1 ; /* bits 29:29 */
    ca_uint32_t tx_performance_tuning_en :  1 ; /* bits 30:30 */
    ca_uint32_t tx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_ES_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_ES_CTRL1                           0xf430610c
#define QM_QM_ES_CTRL1_dft                       0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t puc_en               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_ES_CTRL1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EPP64_P3_0_INTERRUPT_EN            0xf4306110
#define QM_QM_EPP64_P3_0_INTERRUPT_EN_dft        0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t p0_int_en            :  8 ; /* bits 7:0 */
    ca_uint32_t p1_int_en            :  8 ; /* bits 15:8 */
    ca_uint32_t p2_int_en            :  8 ; /* bits 23:16 */
    ca_uint32_t p3_int_en            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EPP64_P3_0_INTERRUPT_EN_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EPP64_P7_4_INTERRUPT_EN            0xf4306114
#define QM_QM_EPP64_P7_4_INTERRUPT_EN_dft        0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t p4_int_en            :  8 ; /* bits 7:0 */
    ca_uint32_t p5_int_en            :  8 ; /* bits 15:8 */
    ca_uint32_t p6_int_en            :  8 ; /* bits 23:16 */
    ca_uint32_t p7_int_en            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EPP64_P7_4_INTERRUPT_EN_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_REFILL_INTERRUPT_EN             0xf4306118
#define QM_QM_EQ_REFILL_INTERRUPT_EN_dft         0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq_refill_en         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_REFILL_INTERRUPT_EN_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_INT_SRC                            0xf430611c
#define QM_QM_INT_SRC_dft                        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header_ecc_error_int_src :  2 ; /* bits 1:0 */
    ca_uint32_t voqinfo_ecc_error_int_src :  2 ; /* bits 3:2 */
    ca_uint32_t mmu_ecc_error_int_src :  2 ; /* bits 5:4 */
    ca_uint32_t sop_eop_error_int_src :  1 ; /* bits 6:6 */
    ca_uint32_t pkt_lenght_error_int_src :  1 ; /* bits 7:7 */
    ca_uint32_t rmu0_no_buffer_drop_int_src :  1 ; /* bits 8:8 */
    ca_uint32_t rmu0_check_error_int_src :  1 ; /* bits 9:9 */
    ca_uint32_t rmu0_fifo_error_int_src :  1 ; /* bits 10:10 */
    ca_uint32_t axiarb_fifo_error_int_src :  1 ; /* bits 11:11 */
    ca_uint32_t dqm_no_buffer_drop_int_src :  1 ; /* bits 12:12 */
    ca_uint32_t dqm_fe_drop_int_src  :  1 ; /* bits 13:13 */
    ca_uint32_t dqm_fifo_error_int_src :  1 ; /* bits 14:14 */
    ca_uint32_t eq_load_error_int_src :  1 ; /* bits 15:15 */
    ca_uint32_t eqm_fifo_error_int_src :  1 ; /* bits 16:16 */
    ca_uint32_t eqm_stack_error_int_src :  1 ; /* bits 17:17 */
    ca_uint32_t tmu_fifo_error_int_src :  1 ; /* bits 18:18 */
    ca_uint32_t tmu_header_error_int_src :  1 ; /* bits 19:19 */
    ca_uint32_t cpuepp_fifo_error_int_src :  1 ; /* bits 20:20 */
    ca_uint32_t eqm_buf_size_error_int_src :  1 ; /* bits 21:21 */
    ca_uint32_t eqm_cfg_error_int_src :  1 ; /* bits 22:22 */
    ca_uint32_t ni_bridge_fifo_error_int_src :  1 ; /* bits 23:23 */
    ca_uint32_t tmu_cfg_error_int_src :  1 ; /* bits 24:24 */
    ca_uint32_t mmu_lkup_bid_out_of_range_int_src :  1 ; /* bits 25:25 */
    ca_uint32_t eq_overflow_int_src  :  1 ; /* bits 26:26 */
    ca_uint32_t cpu_push_invalid_eq_int_src :  1 ; /* bits 27:27 */
    ca_uint32_t fbm_returns_no_buffer_int_src :  1 ; /* bits 28:28 */
    ca_uint32_t axim_rmu0_resp_error_int_src :  1 ; /* bits 29:29 */
    ca_uint32_t axim_cpuepp_resp_error_int_src :  1 ; /* bits 30:30 */
    ca_uint32_t axim_qm_int_src      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_INT_SRC_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_INT_SRCE                           0xf4306120
#define QM_QM_INT_SRCE_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t header_ecc_error_int_srcE :  2 ; /* bits 1:0 */
    ca_uint32_t voqinfo_ecc_error_int_srcE :  2 ; /* bits 3:2 */
    ca_uint32_t mmu_ecc_error_int_srcE :  2 ; /* bits 5:4 */
    ca_uint32_t sop_eop_error_int_srcE :  1 ; /* bits 6:6 */
    ca_uint32_t pkt_lenght_error_int_srcE :  1 ; /* bits 7:7 */
    ca_uint32_t rmu0_no_buffer_drop_int_srcE :  1 ; /* bits 8:8 */
    ca_uint32_t rmu0_check_error_int_srcE :  1 ; /* bits 9:9 */
    ca_uint32_t rmu0_fifo_error_int_srcE :  1 ; /* bits 10:10 */
    ca_uint32_t axiarb_fifo_error_int_srcE :  1 ; /* bits 11:11 */
    ca_uint32_t dqm_no_buffer_drop_int_srcE :  1 ; /* bits 12:12 */
    ca_uint32_t dqm_fe_drop_int_srcE :  1 ; /* bits 13:13 */
    ca_uint32_t dqm_fifo_error_int_srcE :  1 ; /* bits 14:14 */
    ca_uint32_t eq_load_error_int_srcE :  1 ; /* bits 15:15 */
    ca_uint32_t eqm_fifo_error_int_srcE :  1 ; /* bits 16:16 */
    ca_uint32_t eqm_stack_error_int_srcE :  1 ; /* bits 17:17 */
    ca_uint32_t tmu_fifo_error_int_srcE :  1 ; /* bits 18:18 */
    ca_uint32_t tmu_header_error_int_srcE :  1 ; /* bits 19:19 */
    ca_uint32_t cpuepp_fifo_error_int_srcE :  1 ; /* bits 20:20 */
    ca_uint32_t eqm_buf_size_error_int_srcE :  1 ; /* bits 21:21 */
    ca_uint32_t eqm_cfg_error_int_srcE :  1 ; /* bits 22:22 */
    ca_uint32_t ni_bridge_fifo_error_int_srcE :  1 ; /* bits 23:23 */
    ca_uint32_t tmu_cfg_error_int_srcE :  1 ; /* bits 24:24 */
    ca_uint32_t mmu_lkup_bid_out_of_range_int_srcE :  1 ; /* bits 25:25 */
    ca_uint32_t eq_overflow_int_srcE :  1 ; /* bits 26:26 */
    ca_uint32_t cpu_push_invalid_eq_int_srcE :  1 ; /* bits 27:27 */
    ca_uint32_t fbm_returns_no_buffer_int_srcE :  1 ; /* bits 28:28 */
    ca_uint32_t axim_rmu0_resp_error_int_srcE :  1 ; /* bits 29:29 */
    ca_uint32_t axim_cpuepp_resp_error_int_srcE :  1 ; /* bits 30:30 */
    ca_uint32_t axim_qm_int_srcE     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_INT_SRCE_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_AXI_QOS_CFG                        0xf4306124
#define QM_QM_AXI_QOS_CFG_dft                    0x0f240000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t axi_id_rmu           :  4 ; /* bits 19:16 */
    ca_uint32_t axi_id_cpuepp        :  4 ; /* bits 23:20 */
    ca_uint32_t axi_id_tmu           :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_AXI_QOS_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_PROFILE0                        0xf4306128
#define QM_QM_EQ_PROFILE0_STRIDE                 4
#define QM_QM_EQ_PROFILE0_COUNT                  8
#define QM_QM_EQ_PROFILE0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eqp0                 :  4 ; /* bits 3:0 */
    ca_uint32_t eqp1                 :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rule                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_PROFILE0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEST_PORT0_EQ_CFG                  0xf4306148
#define QM_QM_DEST_PORT0_EQ_CFG_STRIDE           4
#define QM_QM_DEST_PORT0_EQ_CFG_COUNT            32
#define QM_QM_DEST_PORT0_EQ_CFG_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t profile_sel          :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEST_PORT0_EQ_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEST_PORT0_PKT_BUF_CFG             0xf43061c8
#define QM_QM_DEST_PORT0_PKT_BUF_CFG_STRIDE      4
#define QM_QM_DEST_PORT0_PKT_BUF_CFG_COUNT       8
#define QM_QM_DEST_PORT0_PKT_BUF_CFG_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t head_room_first      :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tail_room_first      :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t head_room_rest       :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t tail_room_rest       :  6 ; /* bits 29:24 */
    ca_uint32_t rsrvd4               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEST_PORT0_PKT_BUF_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CFG0_EQ0                           0xf43061e8
#define QM_QM_CFG0_EQ0_STRIDE                    20
#define QM_QM_CFG0_EQ0_COUNT                     16
#define QM_QM_CFG0_EQ0_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq_en                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t phy_addr_start       : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CFG0_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CFG1_EQ0                           0xf43061ec
#define QM_QM_CFG1_EQ0_STRIDE                    20
#define QM_QM_CFG1_EQ0_COUNT                     16
#define QM_QM_CFG1_EQ0_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bid_start            : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t total_buffer_num     : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CFG1_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CFG2_EQ0                           0xf43061f0
#define QM_QM_CFG2_EQ0_STRIDE                    20
#define QM_QM_CFG2_EQ0_COUNT                     16
#define QM_QM_CFG2_EQ0_dft                       0x0000ff01

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t buffer_size          :  3 ; /* bits 2:0 */
    ca_uint32_t cpu_eq               :  1 ; /* bits 3:3 */
    ca_uint32_t refill_fbm_eqid      :  3 ; /* bits 6:4 */
    ca_uint32_t refill_en            :  1 ; /* bits 7:7 */
    ca_uint32_t refill_ths           :  8 ; /* bits 15:8 */
    ca_uint32_t buffer_weight        :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CFG2_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CFG3_EQ0                           0xf43061f4
#define QM_QM_CFG3_EQ0_STRIDE                    20
#define QM_QM_CFG3_EQ0_COUNT                     16
#define QM_QM_CFG3_EQ0_dft                       0x10000010

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qos                  :  4 ; /* bits 3:0 */
    ca_uint32_t cache                :  4 ; /* bits 7:4 */
    ca_uint32_t snoop                :  4 ; /* bits 11:8 */
    ca_uint32_t bar                  :  2 ; /* bits 13:12 */
    ca_uint32_t domain               :  2 ; /* bits 15:14 */
    ca_uint32_t user                 :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t acd_cmd              :  1 ; /* bits 24:24 */
    ca_uint32_t cache_line_split     :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cache_eos            :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CFG3_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CFG4_EQ0                           0xf43061f8
#define QM_QM_CFG4_EQ0_STRIDE                    20
#define QM_QM_CFG4_EQ0_COUNT                     16
#define QM_QM_CFG4_EQ0_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_top_bit          :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CFG4_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQM_PA_REQ0                        0xf4306328
#define QM_QM_EQM_PA_REQ0_STRIDE                 4
#define QM_QM_EQM_PA_REQ0_COUNT                  16
#define QM_QM_EQM_PA_REQ0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t inactive_bid_cntr    : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 17 ;
    ca_uint32_t req                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQM_PA_REQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPU_PUSH_RDY0                      0xf4306368
#define QM_QM_CPU_PUSH_RDY0_STRIDE               8
#define QM_QM_CPU_PUSH_RDY0_COUNT                8
#define QM_QM_CPU_PUSH_RDY0_dft                  0x80000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t rdy                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPU_PUSH_RDY0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPU_PUSH_PADDR0                    0xf430636c
#define QM_QM_CPU_PUSH_PADDR0_STRIDE             8
#define QM_QM_CPU_PUSH_PADDR0_COUNT              8
#define QM_QM_CPU_PUSH_PADDR0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eqid                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t addr                 : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPU_PUSH_PADDR0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_CFG_LOAD                        0xf43063a8
#define QM_QM_EQ_CFG_LOAD_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t load                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_CFG_LOAD_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_PHY_ADDR_RETURN_CTRL            0xf43063ac
#define QM_QM_EQ_PHY_ADDR_RETURN_CTRL_dft        0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq_id                :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t phy_addr_retrieval_en :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_PHY_ADDR_RETURN_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_RETURN_PHY_ADDR                 0xf43063b0
#define QM_QM_EQ_RETURN_PHY_ADDR_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eq_id                :  4 ; /* bits 3:0 */
    ca_uint32_t valid                :  1 ; /* bits 4:4 */
    ca_uint32_t retrieval_done       :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t phy_addr             : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_RETURN_PHY_ADDR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_ACTIVE_STACK_CFG                   0xf43063b4
#define QM_QM_ACTIVE_STACK_CFG_dft               0x001a1410

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mid_ths              :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t high_ths             :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_ACTIVE_STACK_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_INACTIVE_STACK_CFG                 0xf43063b8
#define QM_QM_INACTIVE_STACK_CFG_dft             0x001a1410

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mid_ths              :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t high_ths             :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_INACTIVE_STACK_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_STACK_CTRL                      0xf43063bc
#define QM_QM_EQ_STACK_CTRL_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_STACK_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_STACK_UNFILL_STS                0xf43063c0
#define QM_QM_EQ_STACK_UNFILL_STS_dft            0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t done                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_STACK_UNFILL_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SCH_CFG0                           0xf43063c4
#define QM_QM_SCH_CFG0_STRIDE                    4
#define QM_QM_SCH_CFG0_COUNT                     32
#define QM_QM_SCH_CFG0_dft                       0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_en               :  8 ; /* bits 7:0 */
    ca_uint32_t flush_voqid          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t flush_en             :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SCH_CFG0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ3_0_WEIGHT_RATIO_CFG0           0xf4306444
#define QM_QM_VOQ3_0_WEIGHT_RATIO_CFG0_STRIDE    8
#define QM_QM_VOQ3_0_WEIGHT_RATIO_CFG0_COUNT     32
#define QM_QM_VOQ3_0_WEIGHT_RATIO_CFG0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq0                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq1                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq2                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq3                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ3_0_WEIGHT_RATIO_CFG0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ7_4_WEIGHT_RATIO_CFG0           0xf4306448
#define QM_QM_VOQ7_4_WEIGHT_RATIO_CFG0_STRIDE    8
#define QM_QM_VOQ7_4_WEIGHT_RATIO_CFG0_COUNT     32
#define QM_QM_VOQ7_4_WEIGHT_RATIO_CFG0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq4                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq5                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq6                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq7                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ7_4_WEIGHT_RATIO_CFG0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_PORT7_0_WEIGHT_RATIO_CFG           0xf4306544
#define QM_QM_PORT7_0_WEIGHT_RATIO_CFG_dft       0x11111111

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port0                :  4 ; /* bits 3:0 */
    ca_uint32_t port1                :  4 ; /* bits 7:4 */
    ca_uint32_t port2                :  4 ; /* bits 11:8 */
    ca_uint32_t port3                :  4 ; /* bits 15:12 */
    ca_uint32_t port4                :  4 ; /* bits 19:16 */
    ca_uint32_t port5                :  4 ; /* bits 23:20 */
    ca_uint32_t port6                :  4 ; /* bits 27:24 */
    ca_uint32_t port7                :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_PORT7_0_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_PORT15_8_WEIGHT_RATIO_CFG          0xf4306548
#define QM_QM_PORT15_8_WEIGHT_RATIO_CFG_dft      0x11111111

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port8                :  4 ; /* bits 3:0 */
    ca_uint32_t port9                :  4 ; /* bits 7:4 */
    ca_uint32_t port10               :  4 ; /* bits 11:8 */
    ca_uint32_t port11               :  4 ; /* bits 15:12 */
    ca_uint32_t port12               :  4 ; /* bits 19:16 */
    ca_uint32_t port13               :  4 ; /* bits 23:20 */
    ca_uint32_t port14               :  4 ; /* bits 27:24 */
    ca_uint32_t port15               :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_PORT15_8_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_PORT23_16_WEIGHT_RATIO_CFG         0xf430654c
#define QM_QM_PORT23_16_WEIGHT_RATIO_CFG_dft     0x11111111

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port16               :  4 ; /* bits 3:0 */
    ca_uint32_t port17               :  4 ; /* bits 7:4 */
    ca_uint32_t port18               :  4 ; /* bits 11:8 */
    ca_uint32_t port19               :  4 ; /* bits 15:12 */
    ca_uint32_t port20               :  4 ; /* bits 19:16 */
    ca_uint32_t port21               :  4 ; /* bits 23:20 */
    ca_uint32_t port22               :  4 ; /* bits 27:24 */
    ca_uint32_t port23               :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_PORT23_16_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_PORT31_24_WEIGHT_RATIO_CFG         0xf4306550
#define QM_QM_PORT31_24_WEIGHT_RATIO_CFG_dft     0x11111111

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port24               :  4 ; /* bits 3:0 */
    ca_uint32_t port25               :  4 ; /* bits 7:4 */
    ca_uint32_t port26               :  4 ; /* bits 11:8 */
    ca_uint32_t port27               :  4 ; /* bits 15:12 */
    ca_uint32_t port28               :  4 ; /* bits 19:16 */
    ca_uint32_t port29               :  4 ; /* bits 23:20 */
    ca_uint32_t port30               :  4 ; /* bits 27:24 */
    ca_uint32_t port31               :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_PORT31_24_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DRR_WEIGHT_BASE                    0xf4306554
#define QM_QM_DRR_WEIGHT_BASE_dft                0x00040114

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t w_rate               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t base_select          :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t cpu_dwrr_unit        :  1 ; /* bits 16:16 */
    ca_uint32_t ni_dwrr_unit         :  1 ; /* bits 17:17 */
    ca_uint32_t cpu_epp256_dwrr_unit :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DRR_WEIGHT_BASE_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPU_EPP0_CFG                       0xf4306558
#define QM_QM_CPU_EPP0_CFG_STRIDE                4
#define QM_QM_CPU_EPP0_CFG_COUNT                 8
#define QM_QM_CPU_EPP0_CFG_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t map_mode             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPU_EPP0_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPU_EPP_CT_CFG                     0xf4306578
#define QM_QM_CPU_EPP_CT_CFG_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t timer_base           :  2 ; /* bits 1:0 */
    ca_uint32_t timer_base_256       :  2 ; /* bits 3:2 */
    ca_uint32_t axi_req_accu         :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPU_EPP_CT_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPU_EPP_FIFO_CFG_profile0          0xf430657c
#define QM_QM_CPU_EPP_FIFO_CFG_profile0_STRIDE   4
#define QM_QM_CPU_EPP_FIFO_CFG_profile0_COUNT    8
#define QM_QM_CPU_EPP_FIFO_CFG_profile0_dft      0xe0008001

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t high_ths             :  4 ; /* bits 3:0 */
    ca_uint32_t timer_ths            :  4 ; /* bits 7:4 */
    ca_uint32_t size                 : 21 ; /* bits 28:8 */
    ca_uint32_t max_buf_cnt_per_pkt  :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPU_EPP_FIFO_CFG_profile0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPU_EPP_STATUS0                    0xf430659c
#define QM_QM_CPU_EPP_STATUS0_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPU_EPP_STATUS0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPU_EPP_STATUS1                    0xf43065a0
#define QM_QM_CPU_EPP_STATUS1_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPU_EPP_STATUS1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPU_EPP_FIFO0_0_CFG                0xf43065a4
#define QM_QM_CPU_EPP_FIFO0_0_CFG_STRIDE         32
#define QM_QM_CPU_EPP_FIFO0_0_CFG_COUNT          8
#define QM_QM_CPU_EPP_FIFO0_0_CFG_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t profile_sel          :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPU_EPP_FIFO0_0_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_AXI_ATTRIBUTE_ACCESS               0xf43066a4
#define QM_QM_AXI_ATTRIBUTE_ACCESS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_AXI_ATTRIBUTE_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_AXI_ATTRIBUTE_DATA1                0xf43066a8
#define QM_QM_AXI_ATTRIBUTE_DATA1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t axi_top_bit          :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_AXI_ATTRIBUTE_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_AXI_ATTRIBUTE_DATA0                0xf43066ac
#define QM_QM_AXI_ATTRIBUTE_DATA0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qos                  :  4 ; /* bits 3:0 */
    ca_uint32_t cache                :  4 ; /* bits 7:4 */
    ca_uint32_t snoop                :  4 ; /* bits 11:8 */
    ca_uint32_t bar                  :  2 ; /* bits 13:12 */
    ca_uint32_t domain               :  2 ; /* bits 15:14 */
    ca_uint32_t user                 :  6 ; /* bits 21:16 */
    ca_uint32_t prot                 :  3 ; /* bits 24:22 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 25:25 */
    ca_uint32_t axi_top_bit          :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_AXI_ATTRIBUTE_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BID_PADDR_LKUP_ACCESS              0xf43066b0
#define QM_QM_BID_PADDR_LKUP_ACCESS_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ADDR                 : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 17 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BID_PADDR_LKUP_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BID_PADDR_LKUP_DATA                0xf43066b4
#define QM_QM_BID_PADDR_LKUP_DATA_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ecc                  :  6 ; /* bits 5:0 */
    ca_uint32_t Reserved             :  1 ; /* bits 6:6 */
    ca_uint32_t phy_addr             : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BID_PADDR_LKUP_DATA_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_INFO_MEMORY_ACCESS             0xf43066b8
#define QM_QM_VOQ_INFO_MEMORY_ACCESS_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_INFO_MEMORY_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_INFO_MEMORY_DATA2              0xf43066bc
#define QM_QM_VOQ_INFO_MEMORY_DATA2_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t bcntr                : 11 ; /* bits 10:0 */
    ca_uint32_t ecc                  :  9 ; /* bits 19:11 */
    ca_uint32_t sw_id                :  6 ; /* bits 25:20 */
    ca_uint32_t lspid_bp             :  3 ; /* bits 28:26 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_INFO_MEMORY_DATA2_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_INFO_MEMORY_DATA1              0xf43066c0
#define QM_QM_VOQ_INFO_MEMORY_DATA1_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_header           :  1 ; /* bits 0:0 */
    ca_uint32_t voq_tail             : 14 ; /* bits 14:1 */
    ca_uint32_t voq_head             : 14 ; /* bits 28:15 */
    ca_uint32_t bcntr                :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_INFO_MEMORY_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_INFO_MEMORY_DATA0              0xf43066c4
#define QM_QM_VOQ_INFO_MEMORY_DATA0_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t voq_header           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_INFO_MEMORY_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_HEADER_MEMORY_ACCESS               0xf43066c8
#define QM_QM_HEADER_MEMORY_ACCESS_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ADDR                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_HEADER_MEMORY_ACCESS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_HEADER_MEMORY_DATA1                0xf43066cc
#define QM_QM_HEADER_MEMORY_DATA1_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt_type_ptp         :  1 ; /* bits 0:0 */
    ca_uint32_t sw_id                :  6 ; /* bits 6:1 */
    ca_uint32_t lspid_sp             :  3 ; /* bits 9:7 */
    ca_uint32_t ecc                  :  7 ; /* bits 16:10 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_HEADER_MEMORY_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_HEADER_MEMORY_DATA0                0xf43066d0
#define QM_QM_HEADER_MEMORY_DATA0_dft            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pkt_length           : 14 ; /* bits 13:0 */
    ca_uint32_t eop                  :  1 ; /* bits 14:14 */
    ca_uint32_t sop                  :  1 ; /* bits 15:15 */
    ca_uint32_t next_buffer_ptr      : 14 ; /* bits 29:16 */
    ca_uint32_t l4err                :  1 ; /* bits 30:30 */
    ca_uint32_t pkt_type_cpu         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_HEADER_MEMORY_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_HDM_WRITE_PROTECTION               0xf43066d4
#define QM_QM_HDM_WRITE_PROTECTION_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t passwd               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_HDM_WRITE_PROTECTION_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_MONITOR0_EQ0                       0xf43066d8
#define QM_QM_MONITOR0_EQ0_STRIDE                16
#define QM_QM_MONITOR0_EQ0_COUNT                 16
#define QM_QM_MONITOR0_EQ0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tail                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t head                 : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_MONITOR0_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_MONITOR1_EQ0                       0xf43066dc
#define QM_QM_MONITOR1_EQ0_STRIDE                16
#define QM_QM_MONITOR1_EQ0_COUNT                 16
#define QM_QM_MONITOR1_EQ0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t inactive_head        : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_MONITOR1_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_MONITOR2_EQ0                       0xf43066e0
#define QM_QM_MONITOR2_EQ0_STRIDE                16
#define QM_QM_MONITOR2_EQ0_COUNT                 16
#define QM_QM_MONITOR2_EQ0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t inactive_cntr        : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t inactive_tail        : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_MONITOR2_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_MONITOR3_EQ0                       0xf43066e4
#define QM_QM_MONITOR3_EQ0_STRIDE                16
#define QM_QM_MONITOR3_EQ0_COUNT                 16
#define QM_QM_MONITOR3_EQ0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t inactive_stack_cntr  :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t stack_cntr           :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd2               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_MONITOR3_EQ0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_RX_PKT_CNTR                   0xf43067d8
#define QM_QM_RMU0_RX_PKT_CNTR_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_RX_PKT_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_RX_PACKET_HEADER_INFO1        0xf43067dc
#define QM_QM_RMU0_RX_PACKET_HEADER_INFO1_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t info1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_RX_PACKET_HEADER_INFO1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_RX_PACKET_HEADER_INFO0        0xf43067e0
#define QM_QM_RMU0_RX_PACKET_HEADER_INFO0_dft    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t info0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_RX_PACKET_HEADER_INFO0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_TX_PKT_CNTR                        0xf43067e4
#define QM_QM_TX_PKT_CNTR_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_TX_PKT_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_TX_PKT_CNTR_ALL_NI                 0xf43067e8
#define QM_QM_TX_PKT_CNTR_ALL_NI_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_TX_PKT_CNTR_ALL_NI_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_TX_PKT_CNTR_CPU0                   0xf43067ec
#define QM_QM_TX_PKT_CNTR_CPU0_STRIDE            4
#define QM_QM_TX_PKT_CNTR_CPU0_COUNT             8
#define QM_QM_TX_PKT_CNTR_CPU0_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_TX_PKT_CNTR_CPU0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_TX_PACKET_HEADER_INFO1             0xf430680c
#define QM_QM_TX_PACKET_HEADER_INFO1_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t info1                : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_TX_PACKET_HEADER_INFO1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_TX_PACKET_HEADER_INFO0             0xf4306810
#define QM_QM_TX_PACKET_HEADER_INFO0_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t info0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_TX_PACKET_HEADER_INFO0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_NO_BUF_DROP_PKT_INFO          0xf4306814
#define QM_QM_RMU0_NO_BUF_DROP_PKT_INFO_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t eqid                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t voqid                :  9 ; /* bits 24:16 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_NO_BUF_DROP_PKT_INFO_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_NO_BUF_DROP_PKT_CNTR          0xf4306818
#define QM_QM_RMU0_NO_BUF_DROP_PKT_CNTR_dft      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_NO_BUF_DROP_PKT_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_FE_DROP_PKT_CNTR              0xf430681c
#define QM_QM_RMU0_FE_DROP_PKT_CNTR_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_FE_DROP_PKT_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RX_EOP_DROP_CNTR                   0xf4306820
#define QM_QM_RX_EOP_DROP_CNTR_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RX_EOP_DROP_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RX_LEN_CHK_ERROR_CNTR              0xf4306824
#define QM_QM_RX_LEN_CHK_ERROR_CNTR_dft          0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RX_LEN_CHK_ERROR_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RX_L2TE_TAIL_DROP_CNTR             0xf4306828
#define QM_QM_RX_L2TE_TAIL_DROP_CNTR_dft         0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RX_L2TE_TAIL_DROP_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_TX_CRC_ERROR_NI_CNTR               0xf430682c
#define QM_QM_TX_CRC_ERROR_NI_CNTR_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_TX_CRC_ERROR_NI_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_STATUS0                        0xf4306830
#define QM_QM_VOQ_STATUS0_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_STATUS0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_STATUS1                        0xf4306834
#define QM_QM_VOQ_STATUS1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_STATUS1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_STATUS2                        0xf4306838
#define QM_QM_VOQ_STATUS2_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_STATUS2_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_STATUS3                        0xf430683c
#define QM_QM_VOQ_STATUS3_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_STATUS3_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_STATUS4                        0xf4306840
#define QM_QM_VOQ_STATUS4_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_STATUS4_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_STATUS5                        0xf4306844
#define QM_QM_VOQ_STATUS5_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_STATUS5_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_STATUS6                        0xf4306848
#define QM_QM_VOQ_STATUS6_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_STATUS6_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_STATUS7                        0xf430684c
#define QM_QM_VOQ_STATUS7_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_STATUS7_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_PHY_PORT_STS                       0xf4306850
#define QM_QM_PHY_PORT_STS_dft                   0xa5ffffff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t nirx_qm_port_rdy     :  8 ; /* bits 7:0 */
    ca_uint32_t te_qm_es_ni_ok       :  8 ; /* bits 15:8 */
    ca_uint32_t te_qm_es_cpu_ok      :  8 ; /* bits 23:16 */
    ca_uint32_t qm_nitx_rdy          :  1 ; /* bits 24:24 */
    ca_uint32_t nitx_qm_vld          :  1 ; /* bits 25:25 */
    ca_uint32_t nirx_qm_rdy          :  1 ; /* bits 26:26 */
    ca_uint32_t qm_nirx_vld          :  1 ; /* bits 27:27 */
    ca_uint32_t axi_write_rdy        :  1 ; /* bits 28:28 */
    ca_uint32_t axi_read_rdy         :  1 ; /* bits 29:29 */
    ca_uint32_t qm_init_done         :  1 ; /* bits 30:30 */
    ca_uint32_t qm_idle              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_PHY_PORT_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SUB_MODULE_STS                     0xf4306854
#define QM_QM_SUB_MODULE_STS_dft                 0x00f0bfff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qm_axi_att_idle      :  1 ; /* bits 0:0 */
    ca_uint32_t qm_intf_idle         :  1 ; /* bits 1:1 */
    ca_uint32_t qm_eqm_idle          :  1 ; /* bits 2:2 */
    ca_uint32_t qm_rmu_idle          :  1 ; /* bits 3:3 */
    ca_uint32_t qm_tmu_idle          :  1 ; /* bits 4:4 */
    ca_uint32_t qm_cpuepp_idle       :  1 ; /* bits 5:5 */
    ca_uint32_t qm_dqm_idle          :  1 ; /* bits 6:6 */
    ca_uint32_t qm_hdm_idle          :  1 ; /* bits 7:7 */
    ca_uint32_t qm_mmu_idle          :  1 ; /* bits 8:8 */
    ca_uint32_t qm_ni_bridge_idle    :  1 ; /* bits 9:9 */
    ca_uint32_t tmu_sch_rdy          :  1 ; /* bits 10:10 */
    ca_uint32_t epp_sch_rdy          :  1 ; /* bits 11:11 */
    ca_uint32_t eqm_rmu_rdy          :  1 ; /* bits 12:12 */
    ca_uint32_t dqm_rmu_rdy          :  1 ; /* bits 13:13 */
    ca_uint32_t sch_dqm_outstd_req   :  1 ; /* bits 14:14 */
    ca_uint32_t sch_idle             :  1 ; /* bits 15:15 */
    ca_uint32_t fsm_dqm_hdm          :  4 ; /* bits 19:16 */
    ca_uint32_t fsm_dqm_voq_info     :  4 ; /* bits 23:20 */
    ca_uint32_t qm_tmu_fsm_axi_rd    :  4 ; /* bits 27:24 */
    ca_uint32_t qm_rmu_fsm_axi_wr    :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SUB_MODULE_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_FIFO_STS                      0xf4306858
#define QM_QM_RMU0_FIFO_STS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data_fifo_depth      :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t cmd_fifo_depth       :  4 ; /* bits 15:12 */
    ca_uint32_t cmd_resp_fifo_depth  :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t axi_fifo_depth       :  3 ; /* bits 26:24 */
    ca_uint32_t header_fifo_depth    :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_FIFO_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPUEPP_STS                         0xf430685c
#define QM_QM_CPUEPP_STS_dft                     0x80082020

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t epp_ptr_resp_fifo_depth :  5 ; /* bits 4:0 */
    ca_uint32_t epp_ptr_resp_fifo_empty :  1 ; /* bits 5:5 */
    ca_uint32_t epp_ptr_resp_fifo_full :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eppresp_fifo_depth   :  5 ; /* bits 12:8 */
    ca_uint32_t eppresp_fifo_empty   :  1 ; /* bits 13:13 */
    ca_uint32_t eppresp_fifo_full    :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t eppcmd_fifo_depth    :  3 ; /* bits 18:16 */
    ca_uint32_t eppcmd_fifo_empty    :  1 ; /* bits 19:19 */
    ca_uint32_t eppcmd_fifo_full     :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t axi_write_state      :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd4               :  2 ;
    ca_uint32_t axi_write_req_wait   :  1 ; /* bits 29:29 */
    ca_uint32_t axi_write_req        :  1 ; /* bits 30:30 */
    ca_uint32_t epp_sch_rdy          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPUEPP_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPUEPP_SM_STS                      0xf4306860
#define QM_QM_CPUEPP_SM_STS_dft                  0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t paddr_mem_ctrl_state :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t rwptr_mem_ctrl_state :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPUEPP_SM_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_CPUEPP_AXI_CNT_STS                 0xf4306864
#define QM_QM_CPUEPP_AXI_CNT_STS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t gnt_cnt              : 16 ; /* bits 15:0 */
    ca_uint32_t resp_cnt             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_CPUEPP_AXI_CNT_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DQM_FIFO_STS                       0xf4306868
#define QM_QM_DQM_FIFO_STS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t dqm_rmureq_fifo_depth :  4 ; /* bits 3:0 */
    ca_uint32_t dqm_nbrcy_fifo_depth :  4 ; /* bits 7:4 */
    ca_uint32_t dqmreq_fifo_depth    :  5 ; /* bits 12:8 */
    ca_uint32_t dqm_fercy_fifo_depth :  3 ; /* bits 15:13 */
    ca_uint32_t dqmlnk_fifo_depth    :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t dqmresp_fifo_depth   :  6 ; /* bits 29:24 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DQM_FIFO_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_TMU_FIFO_STS                       0xf430686c
#define QM_QM_TMU_FIFO_STS_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tmu_rcy_fifo_depth   :  4 ; /* bits 3:0 */
    ca_uint32_t txcmd_fifo_depth     :  5 ; /* bits 8:4 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tmu_axi_beat_add     : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_TMU_FIFO_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_NI_BRIDGE_FIFO_STS                 0xf4306870
#define QM_QM_NI_BRIDGE_FIFO_STS_dft             0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t beat                 :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t ni_eop_fifo_depth    :  3 ; /* bits 14:12 */
    ca_uint32_t ni_wr_pkt            :  1 ; /* bits 15:15 */
    ca_uint32_t entry                :  8 ; /* bits 23:16 */
    ca_uint32_t pkt                  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_NI_BRIDGE_FIFO_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SPARE_CFG                          0xf4306874
#define QM_QM_SPARE_CFG_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SPARE_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SPARE_STS                          0xf4306878
#define QM_QM_SPARE_STS_dft                      0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SPARE_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_DATA1                        0xf430687c
#define QM_QM_DEBUG_DATA1_dft                    0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_DATA1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_DATA0                        0xf4306880
#define QM_QM_DEBUG_DATA0_dft                    0x80000008

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t data0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_DATA0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS0                         0xf4306884
#define QM_QM_DEBUG_STS0_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rmu_eqm_ack_cntr     :  8 ; /* bits 7:0 */
    ca_uint32_t rmu_lkup_ack_cntr    :  8 ; /* bits 15:8 */
    ca_uint32_t rmu_hdr_fifo_rd_cntr :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rmu_axi_fifo_wr_cntr :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS1                         0xf4306888
#define QM_QM_DEBUG_STS1_dft                     0x00112300

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fsm_rmu_eqm_req      :  4 ; /* bits 3:0 */
    ca_uint32_t fsm_axi_wr           :  4 ; /* bits 7:4 */
    ca_uint32_t eqm_rmu_rdy          :  1 ; /* bits 8:8 */
    ca_uint32_t dqm_rmu_rdy          :  1 ; /* bits 9:9 */
    ca_uint32_t rmuhdr_fifo_dout_vld :  1 ; /* bits 10:10 */
    ca_uint32_t rmuhdr_fifo_rd       :  1 ; /* bits 11:11 */
    ca_uint32_t rmudata_fifo_dout_vld :  1 ; /* bits 12:12 */
    ca_uint32_t rmu_fifo_data_rdy    :  1 ; /* bits 13:13 */
    ca_uint32_t rx_axi_fifo_almost_full :  1 ; /* bits 14:14 */
    ca_uint32_t rmu_lkup_flag        :  1 ; /* bits 15:15 */
    ca_uint32_t rx_axi_fifo_empty    :  1 ; /* bits 16:16 */
    ca_uint32_t lkup_axi_start       :  1 ; /* bits 17:17 */
    ca_uint32_t rmu_axi_write_rdy    :  1 ; /* bits 18:18 */
    ca_uint32_t rmu_lkup_pending     :  1 ; /* bits 19:19 */
    ca_uint32_t qm_fe_rdy            :  1 ; /* bits 20:20 */
    ca_uint32_t rmudata_fifo_almost_full :  1 ; /* bits 21:21 */
    ca_uint32_t rmuhdr_fifo_almost_full :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t outstd_axi_cmd_cntr  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS2                         0xf430688c
#define QM_QM_DEBUG_STS2_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rmu_lkup_bid         : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t ncpu_rmu_rd          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS2_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS3                         0xf4306890
#define QM_QM_DEBUG_STS3_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rmu_lkup_cur_bid     : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t cpu_rmu_rd           : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS3_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS4                         0xf4306894
#define QM_QM_DEBUG_STS4_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rmu_lkup_paddr       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS4_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS5                         0xf4306898
#define QM_QM_DEBUG_STS5_dft                     0x08000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t ni_bridge_eop_cntr   : 16 ; /* bits 15:0 */
    ca_uint32_t eqm_stack15_cntr     :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t axiatt_tmu_lkup_ack  :  1 ; /* bits 24:24 */
    ca_uint32_t tmu_axiatt_lkup_req  :  1 ; /* bits 25:25 */
    ca_uint32_t tmu_axi_strt         :  1 ; /* bits 26:26 */
    ca_uint32_t qm_ni_bridge_fifo_wr_rdy :  1 ; /* bits 27:27 */
    ca_uint32_t sch_dqm_req          :  1 ; /* bits 28:28 */
    ca_uint32_t tmu_tx_vld           :  1 ; /* bits 29:29 */
    ca_uint32_t axi_att_lkup_ack_flag :  1 ; /* bits 30:30 */
    ca_uint32_t tmu_eqm_done         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS5_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS6                         0xf430689c
#define QM_QM_DEBUG_STS6_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tmu_axi_gnt_cntr     : 16 ; /* bits 15:0 */
    ca_uint32_t dqm_tmu_ack_cntr     : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS6_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS7                         0xf43068a0
#define QM_QM_DEBUG_STS7_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tmu_axi_eof_cntr     : 16 ; /* bits 15:0 */
    ca_uint32_t ni_fifo_eop_cntr     : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS7_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS8                         0xf43068a4
#define QM_QM_DEBUG_STS8_dft                     0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tmu_axi_wr_ths       : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t ni_bridge_drain_pid  :  3 ; /* bits 30:28 */
    ca_uint32_t ni_bridge_drain_en   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS8_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS9                         0xf43068a8
#define QM_QM_DEBUG_STS9_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t tmu_axi_beat_add_max : 16 ; /* bits 15:0 */
    ca_uint32_t tmu_axi_beat_add     : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS9_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_STS10                        0xf43068ac
#define QM_QM_DEBUG_STS10_dft                    0xdead0419

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rmu_test             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_STS10_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BUFFER_CNTL                        0xf43068b0
#define QM_QM_BUFFER_CNTL_dft                    0x1034b2ff

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t port_speed_select    :  8 ; /* bits 7:0 */
    ca_uint32_t occupied_buffer_ths  :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t minimum_bytes        :  3 ; /* bits 14:12 */
    ca_uint32_t low_latency_en       :  1 ; /* bits 15:15 */
    ca_uint32_t eq_profile_rule0_eqp0_limit :  4 ; /* bits 19:16 */
    ca_uint32_t timer_divider_constant :  6 ; /* bits 25:20 */
    ca_uint32_t multi_axi_wr_id_en   :  1 ; /* bits 26:26 */
    ca_uint32_t alternate_eq_en      :  1 ; /* bits 27:27 */
    ca_uint32_t tmu_burst_size       :  2 ; /* bits 29:28 */
    ca_uint32_t jumbo_buffer_en      :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BUFFER_CNTL_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_LATENCY_TIMER_CFG                  0xf43068b4
#define QM_QM_LATENCY_TIMER_CFG_dft              0x3f3f0000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t timer_profile_sel_ni0 :  1 ; /* bits 0:0 */
    ca_uint32_t timer_profile_sel_ni1 :  1 ; /* bits 1:1 */
    ca_uint32_t timer_profile_sel_ni2 :  1 ; /* bits 2:2 */
    ca_uint32_t timer_profile_sel_ni3 :  1 ; /* bits 3:3 */
    ca_uint32_t timer_profile_sel_ni4 :  1 ; /* bits 4:4 */
    ca_uint32_t timer_profile_sel_ni5 :  1 ; /* bits 5:5 */
    ca_uint32_t timer_profile_sel_ni6 :  1 ; /* bits 6:6 */
    ca_uint32_t timer_profile_sel_ni7 :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t ths0                 :  8 ; /* bits 23:16 */
    ca_uint32_t ths1                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_LATENCY_TIMER_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BUFFER_INT_SRC                     0xf43068b8
#define QM_QM_BUFFER_INT_SRC_dft                 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t burst_fifo_error_int_src :  1 ; /* bits 0:0 */
    ca_uint32_t ni_pp_pkt_error_int_src :  1 ; /* bits 1:1 */
    ca_uint32_t sta_fifo_error_int_src :  1 ; /* bits 2:2 */
    ca_uint32_t qm_rmu_buf_error_int_src :  1 ; /* bits 3:3 */
    ca_uint32_t qm_te_rmu_error_int_src :  1 ; /* bits 4:4 */
    ca_uint32_t qm_te_tmu_error_int_src :  1 ; /* bits 5:5 */
    ca_uint32_t qm_te_es_error_int_src :  1 ; /* bits 6:6 */
    ca_uint32_t axi_id_cfg_error_int_src :  1 ; /* bits 7:7 */
    ca_uint32_t axi_wr_reorder_resp_error_int_src :  1 ; /* bits 8:8 */
    ca_uint32_t axi_wr_reorder_fifo_error_int_src :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 17 ;
    ca_uint32_t qm_eqm_eq_load_cfg_error_int_src :  1 ; /* bits 27:27 */
    ca_uint32_t qm_eqm_no_buf_error_int_src :  1 ; /* bits 28:28 */
    ca_uint32_t qm_configuration_error_int_src :  1 ; /* bits 29:29 */
    ca_uint32_t qm_bb_wptr_empty_int_src :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BUFFER_INT_SRC_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BUFFER_INT_SRCE                    0xf43068bc
#define QM_QM_BUFFER_INT_SRCE_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t burst_fifo_error_int_srcE :  1 ; /* bits 0:0 */
    ca_uint32_t ni_pp_pkt_error_int_srcE :  1 ; /* bits 1:1 */
    ca_uint32_t sta_fifo_error_int_srcE :  1 ; /* bits 2:2 */
    ca_uint32_t qm_rmu_buf_error_int_srcE :  1 ; /* bits 3:3 */
    ca_uint32_t qm_te_rmu_error_int_srcE :  1 ; /* bits 4:4 */
    ca_uint32_t qm_te_tmu_error_int_srcE :  1 ; /* bits 5:5 */
    ca_uint32_t qm_te_es_error_int_srcE :  1 ; /* bits 6:6 */
    ca_uint32_t axi_id_cfg_error_int_srcE :  1 ; /* bits 7:7 */
    ca_uint32_t axi_wr_reorder_resp_error_int_srcE :  1 ; /* bits 8:8 */
    ca_uint32_t axi_wr_reorder_fifo_error_int_srcE :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 17 ;
    ca_uint32_t qm_eqm_eq_load_cfg_error_int_srcE :  1 ; /* bits 27:27 */
    ca_uint32_t qm_eqm_no_buf_error_int_srcE :  1 ; /* bits 28:28 */
    ca_uint32_t qm_configuration_error_int_srcE :  1 ; /* bits 29:29 */
    ca_uint32_t qm_bb_wptr_empty_int_srcE :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BUFFER_INT_SRCE_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_OVER_THS_STATUS2               0xf43068c0
#define QM_QM_VOQ_OVER_THS_STATUS2_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_OVER_THS_STATUS2_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_OVER_THS_STATUS3               0xf43068c4
#define QM_QM_VOQ_OVER_THS_STATUS3_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_OVER_THS_STATUS3_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_OVER_THS_STATUS4               0xf43068c8
#define QM_QM_VOQ_OVER_THS_STATUS4_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_OVER_THS_STATUS4_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_OVER_THS_STATUS5               0xf43068cc
#define QM_QM_VOQ_OVER_THS_STATUS5_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_OVER_THS_STATUS5_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_OVER_THS_STATUS6               0xf43068d0
#define QM_QM_VOQ_OVER_THS_STATUS6_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_OVER_THS_STATUS6_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_VOQ_OVER_THS_STATUS7               0xf43068d4
#define QM_QM_VOQ_OVER_THS_STATUS7_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_VOQ_OVER_THS_STATUS7_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BURST_BUF_DEBUG_STATUS             0xf43068d8
#define QM_QM_BURST_BUF_DEBUG_STATUS_dft         0x0000ff7f

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t fifo_empty           :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rmu_fifo_empty       :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BURST_BUF_DEBUG_STATUS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BURST_BUF_V_FIFO_STATUS0           0xf43068dc
#define QM_QM_BURST_BUF_V_FIFO_STATUS0_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BURST_BUF_V_FIFO_STATUS0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BURST_BUF_V_FIFO_STATUS1           0xf43068e0
#define QM_QM_BURST_BUF_V_FIFO_STATUS1_dft       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t status               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BURST_BUF_V_FIFO_STATUS1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BURST_BUF_DEBUG_CNTR               0xf43068e4
#define QM_QM_BURST_BUF_DEBUG_CNTR_dft           0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t close_buf_cmd_cntr   : 16 ; /* bits 15:0 */
    ca_uint32_t close_buf_cmd_proc_cntr : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BURST_BUF_DEBUG_CNTR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BURST_BUF_DEBUG_SEG_ID             0xf43068e8
#define QM_QM_BURST_BUF_DEBUG_SEG_ID_dft         0x0000000a

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t seg_id               :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BURST_BUF_DEBUG_SEG_ID_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BURST_BUF_SEG_ID_MONITOR           0xf43068ec
#define QM_QM_BURST_BUF_SEG_ID_MONITOR_dft       0x00010000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rptr_fifo_cntr       :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t wptr_fifo_cntr       :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BURST_BUF_SEG_ID_MONITOR_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DEBUG_CFG                          0xf43068f0
#define QM_QM_DEBUG_CFG_dft                      0x000000bb

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t te_report            :  1 ; /* bits 0:0 */
    ca_uint32_t te_report_1          :  1 ; /* bits 1:1 */
    ca_uint32_t eq_sel               :  1 ; /* bits 2:2 */
    ca_uint32_t bug_51590_fix_en     :  1 ; /* bits 3:3 */
    ca_uint32_t te_report_fifo_en    :  1 ; /* bits 4:4 */
    ca_uint32_t te_report_timer_constant :  3 ; /* bits 7:5 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DEBUG_CFG_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EPP                                0xf43068f4
#define QM_QM_EPP_dft                            0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t map                  :  1 ; /* bits 0:0 */
    ca_uint32_t aggr_mode            :  1 ; /* bits 1:1 */
    ca_uint32_t cmd_mode             :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EPP_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_UPPER_LDPID_MAP                    0xf43068f8
#define QM_QM_UPPER_LDPID_MAP_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t pon_offset           :  3 ; /* bits 2:0 */
    ca_uint32_t pon_en               :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_UPPER_LDPID_MAP_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SRAM_TEST_CONTROL_l3qm_bb          0xf43068fc
#define QM_QM_SRAM_TEST_CONTROL_l3qm_bb_dft      0x00000202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SRAM_TEST_CONTROL_l3qm_bb_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SRAM_TEST_CONTROL_l3qm2_0          0xf4306900
#define QM_QM_SRAM_TEST_CONTROL_l3qm2_0_dft      0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t test_cfg2            :  8 ; /* bits 23:16 */
    ca_uint32_t test_cfg3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SRAM_TEST_CONTROL_l3qm2_0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SRAM_TEST_CONTROL_l3qm2_1          0xf4306904
#define QM_QM_SRAM_TEST_CONTROL_l3qm2_1_dft      0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t test_cfg2            :  8 ; /* bits 23:16 */
    ca_uint32_t test_cfg3            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SRAM_TEST_CONTROL_l3qm2_1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SRAM_TEST_CONTROL_l3qm2_2          0xf4306908
#define QM_QM_SRAM_TEST_CONTROL_l3qm2_2_dft      0x00000202

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t test_cfg1            :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SRAM_TEST_CONTROL_l3qm2_2_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SRAM_TEST_CONTROL_l3qm_repair      0xf430690c
#define QM_QM_SRAM_TEST_CONTROL_l3qm_repair_dft  0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SRAM_TEST_CONTROL_l3qm_repair_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SRAM_TEST_CONTROL_l3qm_repair2     0xf4306910
#define QM_QM_SRAM_TEST_CONTROL_l3qm_repair2_dft 0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t test_cfg0            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SRAM_TEST_CONTROL_l3qm_repair2_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SRAM_LS_CONTROL_0                  0xf4306914
#define QM_QM_SRAM_LS_CONTROL_0_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l3qm2_sramls         : 10 ; /* bits 9:0 */
    ca_uint32_t l3qm_bb_sramls       :  2 ; /* bits 11:10 */
    ca_uint32_t l3qm_repair2_sramls  :  1 ; /* bits 12:12 */
    ca_uint32_t l3qm_sramls          :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SRAM_LS_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_SRAM_LS_CONTROL_1                  0xf4306918
#define QM_QM_SRAM_LS_CONTROL_1_dft              0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t l3te1_sramls         :  9 ; /* bits 8:0 */
    ca_uint32_t l3te2_sramls         :  6 ; /* bits 14:9 */
    ca_uint32_t l3te3_sramls         : 10 ; /* bits 24:15 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_SRAM_LS_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_BACK_PRES_CTRL                     0xf430691c
#define QM_QM_BACK_PRES_CTRL_dft                 0x0000007f

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qm_bp_ctrl           : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_BACK_PRES_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_USG_CTRL0                       0xf4306920
#define QM_QM_EQ_USG_CTRL0_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_en               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_USG_CTRL0_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ_USG_CTRL1                       0xf4306924
#define QM_QM_EQ_USG_CTRL1_dft                   0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt_clr              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ_USG_CTRL1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ0_BUF_USG_STS                    0xf4306928
#define QM_QM_EQ0_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ0_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ1_BUF_USG_STS                    0xf430692c
#define QM_QM_EQ1_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ1_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ2_BUF_USG_STS                    0xf4306930
#define QM_QM_EQ2_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ2_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ3_BUF_USG_STS                    0xf4306934
#define QM_QM_EQ3_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ3_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ4_BUF_USG_STS                    0xf4306938
#define QM_QM_EQ4_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ4_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ5_BUF_USG_STS                    0xf430693c
#define QM_QM_EQ5_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ5_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ6_BUF_USG_STS                    0xf4306940
#define QM_QM_EQ6_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ6_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ7_BUF_USG_STS                    0xf4306944
#define QM_QM_EQ7_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ7_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ8_BUF_USG_STS                    0xf4306948
#define QM_QM_EQ8_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ8_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ9_BUF_USG_STS                    0xf430694c
#define QM_QM_EQ9_BUF_USG_STS_dft                0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ9_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ10_BUF_USG_STS                   0xf4306950
#define QM_QM_EQ10_BUF_USG_STS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ10_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ11_BUF_USG_STS                   0xf4306954
#define QM_QM_EQ11_BUF_USG_STS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ11_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ12_BUF_USG_STS                   0xf4306958
#define QM_QM_EQ12_BUF_USG_STS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ12_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ13_BUF_USG_STS                   0xf430695c
#define QM_QM_EQ13_BUF_USG_STS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ13_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ14_BUF_USG_STS                   0xf4306960
#define QM_QM_EQ14_BUF_USG_STS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ14_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_EQ15_BUF_USG_STS                   0xf4306964
#define QM_QM_EQ15_BUF_USG_STS_dft               0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_EQ15_BUF_USG_STS_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_ES_CTRL2                           0xf4306968
#define QM_QM_ES_CTRL2_dft                       0x00040300

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qm_ni_es_pkt_ctrl    :  1 ; /* bits 0:0 */
    ca_uint32_t ni_qm_hol_pkt_ctrl   :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t qm_ni_bridge_fifo_rd_thr :  7 ; /* bits 10:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t qm_ni_bridge_fifo_wr_thr :  8 ; /* bits 19:12 */
    ca_uint32_t rsrvd3               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_ES_CTRL2_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_RMU0_CTRL1                         0xf430696c
#define QM_QM_RMU0_CTRL1_dft                     0x0322d380

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t rmudata_fifo_bp_ctrl :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t qm_bb_bp_thr_on      :  7 ; /* bits 10:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t qm_bb_bp_thr_off     :  7 ; /* bits 18:12 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t rmudata_almost_full_thr :  7 ; /* bits 26:20 */
    ca_uint32_t rsrvd4               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_RMU0_CTRL1_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DBG_CTRL                           0xf4306970
#define QM_QM_DBG_CTRL_dft                       0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t qm_dbg_en            :  1 ; /* bits 0:0 */
    ca_uint32_t qm_dbg_clr           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t qm_dbg_sel           :  4 ; /* bits 11:8 */
    ca_uint32_t force_qm_nitx_rdy    :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DBG_CTRL_t;
#endif /* !__ASSEMBLER__ */


#define QM_QM_DBG_STATUS                         0xf4306974
#define QM_QM_DBG_STATUS_dft                     0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} QM_QM_DBG_STATUS_t;
#endif /* !__ASSEMBLER__ */





/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* qm */
#ifndef __ASSEMBLER__
typedef struct {
  QM_QM_REVISION_t                         REVISION;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];
  QM_QM_RMU0_CTRL_t                        RMU0_CTRL;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];
  QM_QM_ES_CTRL_t                          ES_CTRL;                       /* addr