/*
 * REGISTERS.h
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED BY /auto/project/bin/rdb2tt.pl
 * -config /home/jason/reg/reg_generator/rdb2h.yml -db ./reg.db
 *
 */
#ifndef _CA8277_REGISTERS_H_
#define _CA8277_REGISTERS_H_

#include "ca_types.h"

/* work around DEBUG being defined in the build overriding
 * registers named DEBUG in structures below
 *
 */
#ifdef DEBUG
#	define CA_DEBUG_WORKAROUND DEBUG
#	undef DEBUG
#endif /* DEBUG */

/******************************************************************
 *
 * Each register in the map is defined as a struct with bitfields.
 *
 ******************************************************************/

/*
 * APB1
 */

/*
 * PE0_ATU
 */

#define PE0_ATU_CTL 0x90300000
#define PE0_ATU_CTL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 16;
		ca_uint32_t idx : 6; /* bits 29:24 */
		ca_uint32_t r : 1; /* bits 30:30 */
		ca_uint32_t w : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} PE0_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */

#define PE0_ATU_DATA0 0x90300004
#define PE0_ATU_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_input_comp : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} PE0_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define PE0_ATU_DATA1 0x90300008
#define PE0_ATU_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_input_mask : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} PE0_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define PE0_ATU_DATA2 0x9030000c
#define PE0_ATU_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_output_value : 19; /* bits 18:0 */
		ca_uint32_t rsrvd1 : 13;
	} bf;
	ca_uint32_t wrd;
} PE0_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define PE0_ATU_DATA3 0x90300010
#define PE0_ATU_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t arprot : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t awprot : 3; /* bits 6:4 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t arqos : 4; /* bits 11:8 */
		ca_uint32_t awqos : 4; /* bits 15:12 */
		ca_uint32_t arcache : 4; /* bits 19:16 */
		ca_uint32_t awcache : 4; /* bits 23:20 */
		ca_uint32_t user_en : 1; /* bits 24:24 */
		ca_uint32_t prot_en : 1; /* bits 25:25 */
		ca_uint32_t cache_en : 1; /* bits 26:26 */
		ca_uint32_t qos_en : 1; /* bits 27:27 */
		ca_uint32_t rsrvd3 : 4;
	} bf;
	ca_uint32_t wrd;
} PE0_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define PE0_ATU_DATA4 0x90300014
#define PE0_ATU_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} PE0_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define PE0_ATU_DATA5 0x90300018
#define PE0_ATU_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} PE0_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define PE0_ATU_UPPER 0x9030001c
#define PE0_ATU_UPPER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t upper_bits : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} PE0_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE0_ATU */
#ifndef __ASSEMBLER__
typedef struct {
	PE0_ATU_CTL_t CTL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	PE0_ATU_DATA0_t DATA0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	PE0_ATU_DATA1_t DATA1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	PE0_ATU_DATA2_t DATA2; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	PE0_ATU_DATA3_t DATA3; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	PE0_ATU_DATA4_t DATA4; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	PE0_ATU_DATA5_t DATA5; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	PE0_ATU_UPPER_t UPPER; /* addr: 0x0000001c */
} APB1_PE0_ATU_t;
#endif /* !__ASSEMBLER__ */

/*
 * PE1_ATU
 */

#define PE1_ATU_CTL 0x90300100
#define PE1_ATU_CTL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 16;
		ca_uint32_t idx : 6; /* bits 29:24 */
		ca_uint32_t r : 1; /* bits 30:30 */
		ca_uint32_t w : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} PE1_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */

#define PE1_ATU_DATA0 0x90300104
#define PE1_ATU_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_input_comp : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} PE1_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define PE1_ATU_DATA1 0x90300108
#define PE1_ATU_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_input_mask : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} PE1_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define PE1_ATU_DATA2 0x9030010c
#define PE1_ATU_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_output_value : 19; /* bits 18:0 */
		ca_uint32_t rsrvd1 : 13;
	} bf;
	ca_uint32_t wrd;
} PE1_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define PE1_ATU_DATA3 0x90300110
#define PE1_ATU_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t arprot : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t awprot : 3; /* bits 6:4 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t arqos : 4; /* bits 11:8 */
		ca_uint32_t awqos : 4; /* bits 15:12 */
		ca_uint32_t arcache : 4; /* bits 19:16 */
		ca_uint32_t awcache : 4; /* bits 23:20 */
		ca_uint32_t user_en : 1; /* bits 24:24 */
		ca_uint32_t prot_en : 1; /* bits 25:25 */
		ca_uint32_t cache_en : 1; /* bits 26:26 */
		ca_uint32_t qos_en : 1; /* bits 27:27 */
		ca_uint32_t rsrvd3 : 4;
	} bf;
	ca_uint32_t wrd;
} PE1_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define PE1_ATU_DATA4 0x90300114
#define PE1_ATU_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} PE1_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define PE1_ATU_DATA5 0x90300118
#define PE1_ATU_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} PE1_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define PE1_ATU_UPPER 0x9030011c
#define PE1_ATU_UPPER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t upper_bits : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} PE1_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE1_ATU */
#ifndef __ASSEMBLER__
typedef struct {
	PE1_ATU_CTL_t CTL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	PE1_ATU_DATA0_t DATA0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	PE1_ATU_DATA1_t DATA1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	PE1_ATU_DATA2_t DATA2; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	PE1_ATU_DATA3_t DATA3; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	PE1_ATU_DATA4_t DATA4; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	PE1_ATU_DATA5_t DATA5; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	PE1_ATU_UPPER_t UPPER; /* addr: 0x0000001c */
} APB1_PE1_ATU_t;
#endif /* !__ASSEMBLER__ */

/*
 * CRYPTO0_ATU
 */

#define CRYPTO0_ATU_CTL 0x90300200
#define CRYPTO0_ATU_CTL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 16;
		ca_uint32_t idx : 6; /* bits 29:24 */
		ca_uint32_t r : 1; /* bits 30:30 */
		ca_uint32_t w : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} CRYPTO0_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO0_ATU_DATA0 0x90300204
#define CRYPTO0_ATU_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_input_comp : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} CRYPTO0_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO0_ATU_DATA1 0x90300208
#define CRYPTO0_ATU_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_input_mask : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} CRYPTO0_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO0_ATU_DATA2 0x9030020c
#define CRYPTO0_ATU_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_output_value : 19; /* bits 18:0 */
		ca_uint32_t rsrvd1 : 13;
	} bf;
	ca_uint32_t wrd;
} CRYPTO0_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO0_ATU_DATA3 0x90300210
#define CRYPTO0_ATU_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t arprot : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t awprot : 3; /* bits 6:4 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t arqos : 4; /* bits 11:8 */
		ca_uint32_t awqos : 4; /* bits 15:12 */
		ca_uint32_t arcache : 4; /* bits 19:16 */
		ca_uint32_t awcache : 4; /* bits 23:20 */
		ca_uint32_t user_en : 1; /* bits 24:24 */
		ca_uint32_t prot_en : 1; /* bits 25:25 */
		ca_uint32_t cache_en : 1; /* bits 26:26 */
		ca_uint32_t qos_en : 1; /* bits 27:27 */
		ca_uint32_t rsrvd3 : 4;
	} bf;
	ca_uint32_t wrd;
} CRYPTO0_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO0_ATU_DATA4 0x90300214
#define CRYPTO0_ATU_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} CRYPTO0_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO0_ATU_DATA5 0x90300218
#define CRYPTO0_ATU_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} CRYPTO0_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO0_ATU_UPPER 0x9030021c
#define CRYPTO0_ATU_UPPER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t upper_bits : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} CRYPTO0_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CRYPTO0_ATU */
#ifndef __ASSEMBLER__
typedef struct {
	CRYPTO0_ATU_CTL_t CTL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	CRYPTO0_ATU_DATA0_t DATA0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	CRYPTO0_ATU_DATA1_t DATA1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	CRYPTO0_ATU_DATA2_t DATA2; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	CRYPTO0_ATU_DATA3_t DATA3; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	CRYPTO0_ATU_DATA4_t DATA4; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	CRYPTO0_ATU_DATA5_t DATA5; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	CRYPTO0_ATU_UPPER_t UPPER; /* addr: 0x0000001c */
} APB1_CRYPTO0_ATU_t;
#endif /* !__ASSEMBLER__ */

/*
 * CRYPTO1_ATU
 */

#define CRYPTO1_ATU_CTL 0x90300400
#define CRYPTO1_ATU_CTL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 16;
		ca_uint32_t idx : 6; /* bits 29:24 */
		ca_uint32_t r : 1; /* bits 30:30 */
		ca_uint32_t w : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} CRYPTO1_ATU_CTL_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO1_ATU_DATA0 0x90300404
#define CRYPTO1_ATU_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_input_comp : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} CRYPTO1_ATU_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO1_ATU_DATA1 0x90300408
#define CRYPTO1_ATU_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_input_mask : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} CRYPTO1_ATU_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO1_ATU_DATA2 0x9030040c
#define CRYPTO1_ATU_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_output_value : 19; /* bits 18:0 */
		ca_uint32_t rsrvd1 : 13;
	} bf;
	ca_uint32_t wrd;
} CRYPTO1_ATU_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO1_ATU_DATA3 0x90300410
#define CRYPTO1_ATU_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t arprot : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t awprot : 3; /* bits 6:4 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t arqos : 4; /* bits 11:8 */
		ca_uint32_t awqos : 4; /* bits 15:12 */
		ca_uint32_t arcache : 4; /* bits 19:16 */
		ca_uint32_t awcache : 4; /* bits 23:20 */
		ca_uint32_t user_en : 1; /* bits 24:24 */
		ca_uint32_t prot_en : 1; /* bits 25:25 */
		ca_uint32_t cache_en : 1; /* bits 26:26 */
		ca_uint32_t qos_en : 1; /* bits 27:27 */
		ca_uint32_t rsrvd3 : 4;
	} bf;
	ca_uint32_t wrd;
} CRYPTO1_ATU_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO1_ATU_DATA4 0x90300414
#define CRYPTO1_ATU_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} CRYPTO1_ATU_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO1_ATU_DATA5 0x90300418
#define CRYPTO1_ATU_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} CRYPTO1_ATU_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define CRYPTO1_ATU_UPPER 0x9030041c
#define CRYPTO1_ATU_UPPER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t upper_bits : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} CRYPTO1_ATU_UPPER_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CRYPTO1_ATU */
#ifndef __ASSEMBLER__
typedef struct {
	CRYPTO1_ATU_CTL_t CTL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	CRYPTO1_ATU_DATA0_t DATA0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	CRYPTO1_ATU_DATA1_t DATA1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	CRYPTO1_ATU_DATA2_t DATA2; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	CRYPTO1_ATU_DATA3_t DATA3; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	CRYPTO1_ATU_DATA4_t DATA4; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	CRYPTO1_ATU_DATA5_t DATA5; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	CRYPTO1_ATU_UPPER_t UPPER; /* addr: 0x0000001c */
} APB1_CRYPTO1_ATU_t;
#endif /* !__ASSEMBLER__ */

/*
 * LDMA
 */

/*
 * LDMA_GLB
 */

#define LDMA_LDMA_GLB_LDMA_CONTROL 0x90301000
#define LDMA_LDMA_GLB_LDMA_CONTROL_dft 0x00000080

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t aruser_idx : 3; /* bits 6:4 */
		ca_uint32_t bkt_sel : 1; /* bits 7:7 */
		ca_uint32_t buf_depth_sel : 2; /* bits 9:8 */
		ca_uint32_t rsrvd1 : 21;
		ca_uint32_t lpae_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_LDMA_CONTROL_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER 0x90301004
#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_dft 0x00800400

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t period : 16; /* bits 15:0 */
		ca_uint32_t credit : 12; /* bits 27:16 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_LDMA_RATE_LIMITER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB 0x90301008
#define LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_dft 0x00000fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t upperbound : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_LDMA_BKT0_DWRR 0x9030100c
#define LDMA_LDMA_GLB_LDMA_BKT0_DWRR_dft 0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t quantum_size : 16; /* bits 15:0 */
		ca_uint32_t dc_upperbound : 15; /* bits 30:16 */
		ca_uint32_t rsrvd1 : 1;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_LDMA_BKT0_DWRR_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_LDMA_BKT1_DWRR 0x90301010
#define LDMA_LDMA_GLB_LDMA_BKT1_DWRR_dft 0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t quantum_size : 16; /* bits 15:0 */
		ca_uint32_t dc_upperbound : 15; /* bits 30:16 */
		ca_uint32_t rsrvd1 : 1;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_LDMA_BKT1_DWRR_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0 0x90301014
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_idx : 3; /* bits 2:0 */
		ca_uint32_t bkt_sel : 1; /* bits 3:3 */
		ca_uint32_t seg_start_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_start_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0 0x90301018
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t seg_end_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_end_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1 0x9030101c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_idx : 3; /* bits 2:0 */
		ca_uint32_t bkt_sel : 1; /* bits 3:3 */
		ca_uint32_t seg_start_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_start_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1 0x90301020
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t seg_end_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_end_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2 0x90301024
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_idx : 3; /* bits 2:0 */
		ca_uint32_t bkt_sel : 1; /* bits 3:3 */
		ca_uint32_t seg_start_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_start_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2 0x90301028
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t seg_end_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_end_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3 0x9030102c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_idx : 3; /* bits 2:0 */
		ca_uint32_t bkt_sel : 1; /* bits 3:3 */
		ca_uint32_t seg_start_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_start_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3 0x90301030
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t seg_end_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_end_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4 0x90301034
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_idx : 3; /* bits 2:0 */
		ca_uint32_t bkt_sel : 1; /* bits 3:3 */
		ca_uint32_t seg_start_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_start_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4 0x90301038
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t seg_end_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_end_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5 0x9030103c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_idx : 3; /* bits 2:0 */
		ca_uint32_t bkt_sel : 1; /* bits 3:3 */
		ca_uint32_t seg_start_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_start_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5 0x90301040
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t seg_end_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_end_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6 0x90301044
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_idx : 3; /* bits 2:0 */
		ca_uint32_t bkt_sel : 1; /* bits 3:3 */
		ca_uint32_t seg_start_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_start_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6 0x90301048
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t seg_end_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_end_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7 0x9030104c
#define LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_idx : 3; /* bits 2:0 */
		ca_uint32_t bkt_sel : 1; /* bits 3:3 */
		ca_uint32_t seg_start_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_start_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7 0x90301050
#define LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t awuser_idx : 3; /* bits 2:0 */
		ca_uint32_t ace_cmd : 1; /* bits 3:3 */
		ca_uint32_t seg_end_addr : 20; /* bits 23:4 */
		ca_uint32_t seg_end_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_AXPATTEN_0 0x90301054
#define LDMA_LDMA_GLB_AXPATTEN_0_dft 0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ax_user : 14; /* bits 13:0 */
		ca_uint32_t ax_cache : 4; /* bits 17:14 */
		ca_uint32_t ax_qos : 4; /* bits 21:18 */
		ca_uint32_t ax_prot : 3; /* bits 24:22 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_AXPATTEN_0_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_AXPATTEN_1 0x90301058
#define LDMA_LDMA_GLB_AXPATTEN_1_dft 0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ax_user : 14; /* bits 13:0 */
		ca_uint32_t ax_cache : 4; /* bits 17:14 */
		ca_uint32_t ax_qos : 4; /* bits 21:18 */
		ca_uint32_t ax_prot : 3; /* bits 24:22 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_AXPATTEN_1_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_AXPATTEN_2 0x9030105c
#define LDMA_LDMA_GLB_AXPATTEN_2_dft 0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ax_user : 14; /* bits 13:0 */
		ca_uint32_t ax_cache : 4; /* bits 17:14 */
		ca_uint32_t ax_qos : 4; /* bits 21:18 */
		ca_uint32_t ax_prot : 3; /* bits 24:22 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_AXPATTEN_2_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_AXPATTEN_3 0x90301060
#define LDMA_LDMA_GLB_AXPATTEN_3_dft 0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ax_user : 14; /* bits 13:0 */
		ca_uint32_t ax_cache : 4; /* bits 17:14 */
		ca_uint32_t ax_qos : 4; /* bits 21:18 */
		ca_uint32_t ax_prot : 3; /* bits 24:22 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_AXPATTEN_3_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_AXPATTEN_4 0x90301064
#define LDMA_LDMA_GLB_AXPATTEN_4_dft 0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ax_user : 14; /* bits 13:0 */
		ca_uint32_t ax_cache : 4; /* bits 17:14 */
		ca_uint32_t ax_qos : 4; /* bits 21:18 */
		ca_uint32_t ax_prot : 3; /* bits 24:22 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_AXPATTEN_4_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_AXPATTEN_5 0x90301068
#define LDMA_LDMA_GLB_AXPATTEN_5_dft 0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ax_user : 14; /* bits 13:0 */
		ca_uint32_t ax_cache : 4; /* bits 17:14 */
		ca_uint32_t ax_qos : 4; /* bits 21:18 */
		ca_uint32_t ax_prot : 3; /* bits 24:22 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_AXPATTEN_5_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_AXPATTEN_6 0x9030106c
#define LDMA_LDMA_GLB_AXPATTEN_6_dft 0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ax_user : 14; /* bits 13:0 */
		ca_uint32_t ax_cache : 4; /* bits 17:14 */
		ca_uint32_t ax_qos : 4; /* bits 21:18 */
		ca_uint32_t ax_prot : 3; /* bits 24:22 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_AXPATTEN_6_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_AXPATTEN_7 0x90301070
#define LDMA_LDMA_GLB_AXPATTEN_7_dft 0x00800000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ax_user : 14; /* bits 13:0 */
		ca_uint32_t ax_cache : 4; /* bits 17:14 */
		ca_uint32_t ax_qos : 4; /* bits 21:18 */
		ca_uint32_t ax_prot : 3; /* bits 24:22 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_AXPATTEN_7_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER 0x90301074
#define LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_dft 0x0000ff00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t q0_sel : 1; /* bits 0:0 */
		ca_uint32_t q1_sel : 1; /* bits 1:1 */
		ca_uint32_t q2_sel : 1; /* bits 2:2 */
		ca_uint32_t q3_sel : 1; /* bits 3:3 */
		ca_uint32_t q4_sel : 1; /* bits 4:4 */
		ca_uint32_t q5_sel : 1; /* bits 5:5 */
		ca_uint32_t q6_sel : 1; /* bits 6:6 */
		ca_uint32_t q7_sel : 1; /* bits 7:7 */
		ca_uint32_t q8_sel : 1; /* bits 8:8 */
		ca_uint32_t q9_sel : 1; /* bits 9:9 */
		ca_uint32_t q10_sel : 1; /* bits 10:10 */
		ca_uint32_t q11_sel : 1; /* bits 11:11 */
		ca_uint32_t q12_sel : 1; /* bits 12:12 */
		ca_uint32_t q13_sel : 1; /* bits 13:13 */
		ca_uint32_t q14_sel : 1; /* bits 14:14 */
		ca_uint32_t q15_sel : 1; /* bits 15:15 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER 0x90301078
#define LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t PE0_QA : 4; /* bits 3:0 */
		ca_uint32_t PE0_QA_en : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t PE0_QB : 4; /* bits 11:8 */
		ca_uint32_t PE0_QB_en : 1; /* bits 12:12 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t PE1_QA : 4; /* bits 19:16 */
		ca_uint32_t PE1_QA_en : 1; /* bits 20:20 */
		ca_uint32_t rsrvd3 : 3;
		ca_uint32_t PE1_QB : 4; /* bits 27:24 */
		ca_uint32_t PE1_QB_en : 1; /* bits 28:28 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER 0x9030107c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER 0x90301080
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER 0x90301084
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER 0x90301088
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER 0x9030108c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER 0x90301090
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER 0x90301094
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER 0x90301098
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER 0x9030109c
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER 0x903010a0
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER 0x903010a4
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER 0x903010a8
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER 0x903010ac
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER 0x903010b0
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER 0x903010b4
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER 0x903010b8
#define LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER 0x903010bc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER 0x903010c0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER 0x903010c4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER 0x903010c8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER 0x903010cc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER 0x903010d0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER 0x903010d4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER 0x903010d8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER 0x903010dc
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER 0x903010e0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER 0x903010e4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER 0x903010e8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER 0x903010ec
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER 0x903010f0
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER 0x903010f4
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER 0x903010f8
#define LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER 0x903010fc
#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER 0x90301100
#define LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_dft \
	0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wch_dc : 16; /* bits 15:0 */
		ca_uint32_t rch_dc : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_GLB_SRAM_TEST_CONTROL 0x90301104
#define LDMA_LDMA_GLB_SRAM_TEST_CONTROL_dft 0x00000202

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sram0_rm : 2; /* bits 1:0 */
		ca_uint32_t sram0_rme : 1; /* bits 2:2 */
		ca_uint32_t sram0_test1 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t sram1_rm : 2; /* bits 9:8 */
		ca_uint32_t sram1_rme : 1; /* bits 10:10 */
		ca_uint32_t sram1_test1 : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 20;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_GLB_SRAM_TEST_CONTROL_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_GLB */
#ifndef __ASSEMBLER__
typedef struct {
	LDMA_LDMA_GLB_LDMA_CONTROL_t LDMA_CONTROL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	LDMA_LDMA_GLB_LDMA_RATE_LIMITER_t LDMA_RATE_LIMITER; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_t
	  LDMA_RATE_LIMITER_UB; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	LDMA_LDMA_GLB_LDMA_BKT0_DWRR_t LDMA_BKT0_DWRR; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	LDMA_LDMA_GLB_LDMA_BKT1_DWRR_t LDMA_BKT1_DWRR; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_t
	  MEM_START_ADDR_SEG_0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_t MEM_END_ADDR_SEG_0; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_t
	  MEM_START_ADDR_SEG_1; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_t MEM_END_ADDR_SEG_1; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_t
	  MEM_START_ADDR_SEG_2; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_t MEM_END_ADDR_SEG_2; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_t
	  MEM_START_ADDR_SEG_3; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_t MEM_END_ADDR_SEG_3; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_t
	  MEM_START_ADDR_SEG_4; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_t MEM_END_ADDR_SEG_4; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_t
	  MEM_START_ADDR_SEG_5; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_t MEM_END_ADDR_SEG_5; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_t
	  MEM_START_ADDR_SEG_6; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_t MEM_END_ADDR_SEG_6; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_t
	  MEM_START_ADDR_SEG_7; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_t MEM_END_ADDR_SEG_7; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	LDMA_LDMA_GLB_AXPATTEN_0_t AXPATTEN_0; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	LDMA_LDMA_GLB_AXPATTEN_1_t AXPATTEN_1; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	LDMA_LDMA_GLB_AXPATTEN_2_t AXPATTEN_2; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	LDMA_LDMA_GLB_AXPATTEN_3_t AXPATTEN_3; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	LDMA_LDMA_GLB_AXPATTEN_4_t AXPATTEN_4; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	LDMA_LDMA_GLB_AXPATTEN_5_t AXPATTEN_5; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	LDMA_LDMA_GLB_AXPATTEN_6_t AXPATTEN_6; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	LDMA_LDMA_GLB_AXPATTEN_7_t AXPATTEN_7; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_t
	  QUEUE_ASSIGN_REGISTER; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_t
	  FAST_Q_ASSIGN_REGISTER; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd43[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000ac */
	ca_uint32_t rsrvd44[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b0 */
	ca_uint32_t rsrvd45[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b4 */
	ca_uint32_t rsrvd46[3];
	LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd47[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000bc */
	ca_uint32_t rsrvd48[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c0 */
	ca_uint32_t rsrvd49[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c4 */
	ca_uint32_t rsrvd50[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c8 */
	ca_uint32_t rsrvd51[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000cc */
	ca_uint32_t rsrvd52[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d0 */
	ca_uint32_t rsrvd53[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d4 */
	ca_uint32_t rsrvd54[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd55[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000dc */
	ca_uint32_t rsrvd56[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd57[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd58[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e8 */
	ca_uint32_t rsrvd59[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000ec */
	ca_uint32_t rsrvd60[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd61[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd62[3];
	LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_t
	  DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f8 */
	ca_uint32_t rsrvd63[3];
	LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_t
	  DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000fc */
	ca_uint32_t rsrvd64[3];
	LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_t
	  DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000100 */
	ca_uint32_t rsrvd65[3];
	LDMA_LDMA_GLB_SRAM_TEST_CONTROL_t SRAM_TEST_CONTROL; /* addr: 0x00000104 */
} APB1_LDMA_LDMA_GLB_t;
#endif /* !__ASSEMBLER__ */

/*
 * AXIM2
 */

#define LDMA_AXIM2_CONFIG 0x903011a0
#define LDMA_AXIM2_CONFIG_dft 0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t axi_write_outtrans_num : 4; /* bits 3:0 */
		ca_uint32_t axi_read_outtrans_num : 4; /* bits 7:4 */
		ca_uint32_t axi_xbus_len : 3; /* bits 10:8 */
		ca_uint32_t write_cacheline_trans_en : 1; /* bits 11:11 */
		ca_uint32_t write_cacheline_trans_size : 1; /* bits 12:12 */
		ca_uint32_t read_cacheline_trans_en : 1; /* bits 13:13 */
		ca_uint32_t read_cacheline_trans_size : 1; /* bits 14:14 */
		ca_uint32_t arcache_eos_en : 1; /* bits 15:15 */
		ca_uint32_t awcache_eos_en : 1; /* bits 16:16 */
		ca_uint32_t reserved : 15; /* bits 31:17 */
	} bf;
	ca_uint32_t wrd;
} LDMA_AXIM2_CONFIG_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_AXIM2_TIMEOUT_THRESHOLD 0x903011a4
#define LDMA_AXIM2_TIMEOUT_THRESHOLD_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t read_channel_threshold : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t write_channel_threshold : 1; /* bits 4:4 */
		ca_uint32_t rsrvd2 : 27;
	} bf;
	ca_uint32_t wrd;
} LDMA_AXIM2_TIMEOUT_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_AXIM2_INTERRUPT_STATUS 0x903011a8
#define LDMA_AXIM2_INTERRUPT_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t read_trans_resp_timeout_int : 1; /* bits 0:0 */
		ca_uint32_t read_trans_resp_err_int : 1; /* bits 1:1 */
		ca_uint32_t write_trans_resp_timeout_int : 1; /* bits 2:2 */
		ca_uint32_t write_trans_resp_err_int : 1; /* bits 3:3 */
		ca_uint32_t read_trans_resp_ace_err_int : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} LDMA_AXIM2_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_AXIM2_INTERRUPT_ENABLE 0x903011ac
#define LDMA_AXIM2_INTERRUPT_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t read_trans_resp_timeout_int_en : 1; /* bits 0:0 */
		ca_uint32_t read_trans_resp_err_int_en : 1; /* bits 1:1 */
		ca_uint32_t write_trans_resp_timeout_int_en : 1; /* bits 2:2 */
		ca_uint32_t write_trans_resp_err_int_en : 1; /* bits 3:3 */
		ca_uint32_t read_trans_resp_ace_err_int_en : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} LDMA_AXIM2_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* AXIM2 */
#ifndef __ASSEMBLER__
typedef struct {
	LDMA_AXIM2_CONFIG_t CONFIG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	LDMA_AXIM2_TIMEOUT_THRESHOLD_t TIMEOUT_THRESHOLD; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	LDMA_AXIM2_INTERRUPT_STATUS_t INTERRUPT_STATUS; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	LDMA_AXIM2_INTERRUPT_ENABLE_t INTERRUPT_ENABLE; /* addr: 0x0000000c */
} APB1_LDMA_AXIM2_t;
#endif /* !__ASSEMBLER__ */

/*
 * LDMA_QUEUE[0..15]
 */

#define LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS 0x90301200
#define LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t desc_idx : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t debug_mode : 1; /* bits 8:8 */
		ca_uint32_t rsrvd2 : 21;
		ca_uint32_t wrd_n : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2 0x90301204
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t length : 12; /* bits 11:0 */
		ca_uint32_t rd_cmd_only : 1; /* bits 12:12 */
		ca_uint32_t rd_trn_only : 1; /* bits 13:13 */
		ca_uint32_t wr_zero_trn : 1; /* bits 14:14 */
		ca_uint32_t ioc : 1; /* bits 15:15 */
		ca_uint32_t dst_addr_lpae : 8; /* bits 23:16 */
		ca_uint32_t src_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1 0x90301208
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dst_addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0 0x9030120c
#define LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t src_addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_QUEUE_CONTROL_REGISTER 0x90301210
#define LDMA_LDMA_QUEUE_CONTROL_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clsc_timer : 16; /* bits 15:0 */
		ca_uint32_t clsc_threshold : 4; /* bits 19:16 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t wch_axi_error : 1; /* bits 24:24 */
		ca_uint32_t rch_axi_error : 1; /* bits 25:25 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t reset : 1; /* bits 28:28 */
		ca_uint32_t rsrvd3 : 2;
		ca_uint32_t en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_CONTROL_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_QUEUE_DWRR_REGISTER 0x90301214
#define LDMA_LDMA_QUEUE_DWRR_REGISTER_dft 0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t quantum_size : 16; /* bits 15:0 */
		ca_uint32_t dc_upperbound : 15; /* bits 30:16 */
		ca_uint32_t rsrvd1 : 1;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_DWRR_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_QUEUE_INTERRUPT_ENABLE 0x90301218
#define LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dd_en : 1; /* bits 0:0 */
		ca_uint32_t fov_en : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_QUEUE_INTERRUPT_STATUS 0x9030121c
#define LDMA_LDMA_QUEUE_INTERRUPT_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t descriptor_done : 1; /* bits 0:0 */
		ca_uint32_t fifo_overflow : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_QUEUE_POINTER_REGISTER 0x90301220
#define LDMA_LDMA_QUEUE_POINTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wr_ptr : 4; /* bits 3:0 */
		ca_uint32_t rd_trans_rdptr : 4; /* bits 7:4 */
		ca_uint32_t rd_trans_wrptr : 4; /* bits 11:8 */
		ca_uint32_t wr_trans_rdptr : 4; /* bits 15:12 */
		ca_uint32_t rd_ptr : 4; /* bits 19:16 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t desc_depth : 5; /* bits 28:24 */
		ca_uint32_t rsrvd2 : 3;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_QUEUE_POINTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define APB1_LDMA_LDMA_QUEUE_STRIDE 64
#define APB1_LDMA_LDMA_QUEUE_COUNT 16

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_QUEUE */
#ifndef __ASSEMBLER__
typedef struct {
	LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_t DESCRIPTOR_ACCESS; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_t DESCRIPTOR_DATA2; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_t DESCRIPTOR_DATA1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_t DESCRIPTOR_DATA0; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	LDMA_LDMA_QUEUE_CONTROL_REGISTER_t CONTROL_REGISTER; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	LDMA_LDMA_QUEUE_DWRR_REGISTER_t DWRR_REGISTER; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_t INTERRUPT_ENABLE; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	LDMA_LDMA_QUEUE_INTERRUPT_STATUS_t INTERRUPT_STATUS; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	LDMA_LDMA_QUEUE_POINTER_REGISTER_t POINTER_REGISTER; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[31];
} APB1_LDMA_LDMA_QUEUE_t;
#endif /* !__ASSEMBLER__ */

/*
 * LDMA_INTERRUPT_MUX
 */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE 0x90301600
#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS 0x90301604
#define LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE 0x90301608
#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS 0x9030160c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE 0x90301610
#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS 0x90301614
#define LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE 0x90301618
#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS 0x9030161c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE 0x90301620
#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS 0x90301624
#define LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE 0x90301628
#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS 0x9030162c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE 0x90301630
#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS 0x90301634
#define LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE 0x90301638
#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS 0x9030163c
#define LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_INTERRUPT_MUX */
#ifndef __ASSEMBLER__
typedef struct {
	LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t IRQ0_ENABLE; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t IRQ0_STATUS; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t IRQ1_ENABLE; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t IRQ1_STATUS; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t IRQ2_ENABLE; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t IRQ2_STATUS; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t IRQ3_ENABLE; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t IRQ3_STATUS; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t IRQ4_ENABLE; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t IRQ4_STATUS; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t IRQ5_ENABLE; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t IRQ5_STATUS; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t IRQ6_ENABLE; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t IRQ6_STATUS; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t IRQ7_ENABLE; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t IRQ7_STATUS; /* addr: 0x0000003c */
} APB1_LDMA_LDMA_INTERRUPT_MUX_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA */

#ifndef __ASSEMBLER__
typedef struct {
	APB1_LDMA_LDMA_GLB_t LDMA_GLB; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[285];
	APB1_LDMA_AXIM2_t AXIM2; /* addr: 0x000001a0 */
	ca_uint32_t rsrvd2[89];
	APB1_LDMA_LDMA_QUEUE_t LDMA_QUEUE[16]; /* addr: 0x00000200 */
	APB1_LDMA_LDMA_INTERRUPT_MUX_t LDMA_INTERRUPT_MUX; /* addr: 0x00000600 */
} APB1_LDMA_t;
#endif /* !__ASSEMBLER__ */

/*
 * LDMA_RCPU
 */

/*
 * LDMA_QUEUE[0..15]
 */

#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS 0x90302200
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t desc_idx : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t debug_mode : 1; /* bits 8:8 */
		ca_uint32_t rsrvd2 : 21;
		ca_uint32_t wrd_n : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2 0x90302204
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t length : 12; /* bits 11:0 */
		ca_uint32_t rd_cmd_only : 1; /* bits 12:12 */
		ca_uint32_t rd_trn_only : 1; /* bits 13:13 */
		ca_uint32_t wr_zero_trn : 1; /* bits 14:14 */
		ca_uint32_t ioc : 1; /* bits 15:15 */
		ca_uint32_t dst_addr_lpae : 8; /* bits 23:16 */
		ca_uint32_t src_addr_lpae : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1 0x90302208
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dst_addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0 0x9030220c
#define LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t src_addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER 0x90302210
#define LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clsc_timer : 16; /* bits 15:0 */
		ca_uint32_t clsc_threshold : 4; /* bits 19:16 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t wch_axi_error : 1; /* bits 24:24 */
		ca_uint32_t rch_axi_error : 1; /* bits 25:25 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t reset : 1; /* bits 28:28 */
		ca_uint32_t rsrvd3 : 2;
		ca_uint32_t en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER 0x90302214
#define LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_dft 0x7fff1000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t quantum_size : 16; /* bits 15:0 */
		ca_uint32_t dc_upperbound : 15; /* bits 30:16 */
		ca_uint32_t rsrvd1 : 1;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE 0x90302218
#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dd_en : 1; /* bits 0:0 */
		ca_uint32_t fov_en : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS 0x9030221c
#define LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t descriptor_done : 1; /* bits 0:0 */
		ca_uint32_t fifo_overflow : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER 0x90302220
#define LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wr_ptr : 4; /* bits 3:0 */
		ca_uint32_t rd_trans_rdptr : 4; /* bits 7:4 */
		ca_uint32_t rd_trans_wrptr : 4; /* bits 11:8 */
		ca_uint32_t wr_trans_rdptr : 4; /* bits 15:12 */
		ca_uint32_t rd_ptr : 4; /* bits 19:16 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t desc_depth : 5; /* bits 28:24 */
		ca_uint32_t rsrvd2 : 3;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_t;
#endif /* !__ASSEMBLER__ */

#define APB1_LDMA_RCPU_LDMA_QUEUE_STRIDE 64
#define APB1_LDMA_RCPU_LDMA_QUEUE_COUNT 16

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_QUEUE */
#ifndef __ASSEMBLER__
typedef struct {
	LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_t
	  DESCRIPTOR_ACCESS; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_t
	  DESCRIPTOR_DATA2; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_t
	  DESCRIPTOR_DATA1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_t
	  DESCRIPTOR_DATA0; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_t
	  CONTROL_REGISTER; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_t DWRR_REGISTER; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_t
	  INTERRUPT_ENABLE; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_t
	  INTERRUPT_STATUS; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_t
	  POINTER_REGISTER; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[31];
} APB1_LDMA_RCPU_LDMA_QUEUE_t;
#endif /* !__ASSEMBLER__ */

/*
 * LDMA_INTERRUPT_MUX
 */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE 0x90302600
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS 0x90302604
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE 0x90302608
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS 0x9030260c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE 0x90302610
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS 0x90302614
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE 0x90302618
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS 0x9030261c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE 0x90302620
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS 0x90302624
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE 0x90302628
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS 0x9030262c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE 0x90302630
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS 0x90302634
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE 0x90302638
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_en : 1; /* bits 0:0 */
		ca_uint32_t Q1_en : 1; /* bits 1:1 */
		ca_uint32_t Q2_en : 1; /* bits 2:2 */
		ca_uint32_t Q3_en : 1; /* bits 3:3 */
		ca_uint32_t Q4_en : 1; /* bits 4:4 */
		ca_uint32_t Q5_en : 1; /* bits 5:5 */
		ca_uint32_t Q6_en : 1; /* bits 6:6 */
		ca_uint32_t Q7_en : 1; /* bits 7:7 */
		ca_uint32_t Q8_en : 1; /* bits 8:8 */
		ca_uint32_t Q9_en : 1; /* bits 9:9 */
		ca_uint32_t Q10_en : 1; /* bits 10:10 */
		ca_uint32_t Q11_en : 1; /* bits 11:11 */
		ca_uint32_t Q12_en : 1; /* bits 12:12 */
		ca_uint32_t Q13_en : 1; /* bits 13:13 */
		ca_uint32_t Q14_en : 1; /* bits 14:14 */
		ca_uint32_t Q15_en : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t;
#endif /* !__ASSEMBLER__ */

#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS 0x9030263c
#define LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Q0_status : 1; /* bits 0:0 */
		ca_uint32_t Q1_status : 1; /* bits 1:1 */
		ca_uint32_t Q2_status : 1; /* bits 2:2 */
		ca_uint32_t Q3_status : 1; /* bits 3:3 */
		ca_uint32_t Q4_status : 1; /* bits 4:4 */
		ca_uint32_t Q5_status : 1; /* bits 5:5 */
		ca_uint32_t Q6_status : 1; /* bits 6:6 */
		ca_uint32_t Q7_status : 1; /* bits 7:7 */
		ca_uint32_t Q8_status : 1; /* bits 8:8 */
		ca_uint32_t Q9_status : 1; /* bits 9:9 */
		ca_uint32_t Q10_status : 1; /* bits 10:10 */
		ca_uint32_t Q11_status : 1; /* bits 11:11 */
		ca_uint32_t Q12_status : 1; /* bits 12:12 */
		ca_uint32_t Q13_status : 1; /* bits 13:13 */
		ca_uint32_t Q14_status : 1; /* bits 14:14 */
		ca_uint32_t Q15_status : 1; /* bits 15:15 */
		ca_uint32_t axi_master_irq_status : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_INTERRUPT_MUX */
#ifndef __ASSEMBLER__
typedef struct {
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t IRQ0_ENABLE; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t IRQ0_STATUS; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t IRQ1_ENABLE; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t IRQ1_STATUS; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t IRQ2_ENABLE; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t IRQ2_STATUS; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t IRQ3_ENABLE; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t IRQ3_STATUS; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t IRQ4_ENABLE; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t IRQ4_STATUS; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t IRQ5_ENABLE; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t IRQ5_STATUS; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t IRQ6_ENABLE; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t IRQ6_STATUS; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t IRQ7_ENABLE; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t IRQ7_STATUS; /* addr: 0x0000003c */
} APB1_LDMA_RCPU_LDMA_INTERRUPT_MUX_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_RCPU */

#ifndef __ASSEMBLER__
typedef struct {
	ca_uint32_t rsrvd1[512];
	APB1_LDMA_RCPU_LDMA_QUEUE_t LDMA_QUEUE[16]; /* addr: 0x00000200 */
	APB1_LDMA_RCPU_LDMA_INTERRUPT_MUX_t LDMA_INTERRUPT_MUX; /* addr: 0x00000600 */
} APB1_LDMA_RCPU_t;
#endif /* !__ASSEMBLER__ */

/*
 * PE_CTRL
 */

#define PE_CTRL_PES_ADDR_MASTER_CONFIG 0x90303000
#define PE_CTRL_PES_ADDR_MASTER_CONFIG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pe0s_shift_en : 1; /* bits 0:0 */
		ca_uint32_t pe1s_shift_en : 1; /* bits 1:1 */
		ca_uint32_t pe0s_slave_prot : 1; /* bits 2:2 */
		ca_uint32_t pe1s_slave_prot : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PES_ADDR_MASTER_CONFIG_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE0S_ADDR_CONFIG 0x90303004
#define PE_CTRL_PE0S_ADDR_CONFIG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pe0s_addr_val : 16; /* bits 15:0 */
		ca_uint32_t pe0s_addr_mask : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE0S_ADDR_CONFIG_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE1S_ADDR_CONFIG 0x90303008
#define PE_CTRL_PE1S_ADDR_CONFIG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pe1s_addr_val : 16; /* bits 15:0 */
		ca_uint32_t pe1s_addr_mask : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE1S_ADDR_CONFIG_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_AXI_CTRL_PE0 0x9030300c
#define PE_CTRL_AXI_CTRL_PE0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t arqos_pe : 4; /* bits 3:0 */
		ca_uint32_t awqos_pe : 4; /* bits 7:4 */
		ca_uint32_t ruser_pe : 4; /* bits 11:8 */
		ca_uint32_t buser_pe : 4; /* bits 15:12 */
		ca_uint32_t aruser_pes : 4; /* bits 19:16 */
		ca_uint32_t awuser_pes : 4; /* bits 23:20 */
		ca_uint32_t wuser_pes : 4; /* bits 27:24 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_AXI_CTRL_PE0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_AXI_CTRL1_PE0 0x90303010
#define PE_CTRL_AXI_CTRL1_PE0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_pe : 14; /* bits 13:0 */
		ca_uint32_t awuser_pe : 14; /* bits 27:14 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_AXI_CTRL1_PE0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_AXI_CTRL_PE1 0x90303014
#define PE_CTRL_AXI_CTRL_PE1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t arqos_pe : 4; /* bits 3:0 */
		ca_uint32_t awqos_pe : 4; /* bits 7:4 */
		ca_uint32_t ruser_pe : 4; /* bits 11:8 */
		ca_uint32_t buser_pe : 4; /* bits 15:12 */
		ca_uint32_t aruser_pes : 4; /* bits 19:16 */
		ca_uint32_t awuser_pes : 4; /* bits 23:20 */
		ca_uint32_t wuser_pes : 4; /* bits 27:24 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_AXI_CTRL_PE1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_AXI_CTRL1_PE1 0x90303018
#define PE_CTRL_AXI_CTRL1_PE1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aruser_pe : 14; /* bits 13:0 */
		ca_uint32_t awuser_pe : 14; /* bits 27:14 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_AXI_CTRL1_PE1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_QM_AGG_INTERRUPT_0 0x9030301c
#define PE_CTRL_PE_QM_AGG_INTERRUPT_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t CPU_REFILL_REQ_0i : 1; /* bits 0:0 */
		ca_uint32_t CPU_REFILL_REQ_1i : 1; /* bits 1:1 */
		ca_uint32_t CPU_REFILL_REQ_2i : 1; /* bits 2:2 */
		ca_uint32_t CPU_REFILL_REQ_3i : 1; /* bits 3:3 */
		ca_uint32_t CPU_REFILL_REQ_4i : 1; /* bits 4:4 */
		ca_uint32_t CPU_REFILL_REQ_5i : 1; /* bits 5:5 */
		ca_uint32_t CPU_REFILL_REQ_6i : 1; /* bits 6:6 */
		ca_uint32_t CPU_REFILL_REQ_7i : 1; /* bits 7:7 */
		ca_uint32_t CPU_REFILL_REQ_8i : 1; /* bits 8:8 */
		ca_uint32_t CPU_REFILL_REQ_9i : 1; /* bits 9:9 */
		ca_uint32_t CPU_REFILL_REQ_10i : 1; /* bits 10:10 */
		ca_uint32_t CPU_REFILL_REQ_11i : 1; /* bits 11:11 */
		ca_uint32_t CPU_REFILL_REQ_12i : 1; /* bits 12:12 */
		ca_uint32_t CPU_REFILL_REQ_13i : 1; /* bits 13:13 */
		ca_uint32_t CPU_EPP_256_FIFO_HIi : 1; /* bits 14:14 */
		ca_uint32_t CPU_EPP_256_FIFO_LOi : 1; /* bits 15:15 */
		ca_uint32_t CPU_EPP_FIFO_0i : 1; /* bits 16:16 */
		ca_uint32_t CPU_EPP_FIFO_1i : 1; /* bits 17:17 */
		ca_uint32_t CPU_EPP_FIFO_2i : 1; /* bits 18:18 */
		ca_uint32_t CPU_EPP_FIFO_3i : 1; /* bits 19:19 */
		ca_uint32_t CPU_EPP_FIFO_4i : 1; /* bits 20:20 */
		ca_uint32_t CPU_EPP_FIFO_5i : 1; /* bits 21:21 */
		ca_uint32_t CPU_EPP_FIFO_6i : 1; /* bits 22:22 */
		ca_uint32_t CPU_EPP_FIFO_7i : 1; /* bits 23:23 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_QM_AGG_INTERRUPT_0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_QM_AGG_INTENABLE_0 0x90303020
#define PE_CTRL_PE_QM_AGG_INTENABLE_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t CPU_REFILL_REQ_0e : 1; /* bits 0:0 */
		ca_uint32_t CPU_REFILL_REQ_1e : 1; /* bits 1:1 */
		ca_uint32_t CPU_REFILL_REQ_2e : 1; /* bits 2:2 */
		ca_uint32_t CPU_REFILL_REQ_3e : 1; /* bits 3:3 */
		ca_uint32_t CPU_REFILL_REQ_4e : 1; /* bits 4:4 */
		ca_uint32_t CPU_REFILL_REQ_5e : 1; /* bits 5:5 */
		ca_uint32_t CPU_REFILL_REQ_6e : 1; /* bits 6:6 */
		ca_uint32_t CPU_REFILL_REQ_7e : 1; /* bits 7:7 */
		ca_uint32_t CPU_REFILL_REQ_8e : 1; /* bits 8:8 */
		ca_uint32_t CPU_REFILL_REQ_9e : 1; /* bits 9:9 */
		ca_uint32_t CPU_REFILL_REQ_10e : 1; /* bits 10:10 */
		ca_uint32_t CPU_REFILL_REQ_11e : 1; /* bits 11:11 */
		ca_uint32_t CPU_REFILL_REQ_12e : 1; /* bits 12:12 */
		ca_uint32_t CPU_REFILL_REQ_13e : 1; /* bits 13:13 */
		ca_uint32_t CPU_EPP_256_FIFO_HIe : 1; /* bits 14:14 */
		ca_uint32_t CPU_EPP_256_FIFO_LOe : 1; /* bits 15:15 */
		ca_uint32_t CPU_EPP_FIFO_0e : 1; /* bits 16:16 */
		ca_uint32_t CPU_EPP_FIFO_1e : 1; /* bits 17:17 */
		ca_uint32_t CPU_EPP_FIFO_2e : 1; /* bits 18:18 */
		ca_uint32_t CPU_EPP_FIFO_3e : 1; /* bits 19:19 */
		ca_uint32_t CPU_EPP_FIFO_4e : 1; /* bits 20:20 */
		ca_uint32_t CPU_EPP_FIFO_5e : 1; /* bits 21:21 */
		ca_uint32_t CPU_EPP_FIFO_6e : 1; /* bits 22:22 */
		ca_uint32_t CPU_EPP_FIFO_7e : 1; /* bits 23:23 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_QM_AGG_INTENABLE_0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_AGG_INTERRUPT_0 0x90303024
#define PE_CTRL_PE_AGG_INTERRUPT_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t IRQ_soft0iSeti : 1; /* bits 0:0 */
		ca_uint32_t IRQ_soft1iSeti : 1; /* bits 1:1 */
		ca_uint32_t ipc_int_pe0i : 1; /* bits 2:2 */
		ca_uint32_t ipc_int_pe1i : 1; /* bits 3:3 */
		ca_uint32_t PER_UART0_INT_1i : 1; /* bits 4:4 */
		ca_uint32_t PER_UART1_INT_1i : 1; /* bits 5:5 */
		ca_uint32_t PER_UART2_INT_1i : 1; /* bits 6:6 */
		ca_uint32_t PER_UART3_INT_1i : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t XFI0_INTERRUPTi : 1; /* bits 9:9 */
		ca_uint32_t XFI1_INTERRUPTi : 1; /* bits 10:10 */
		ca_uint32_t PER_PERIPHERAL_INTERRUPT_1i : 1; /* bits 11:11 */
		ca_uint32_t WOL_INTERRUPTi : 1; /* bits 12:12 */
		ca_uint32_t rsrvd2 : 19;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_AGG_INTERRUPT_0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_AGG_INTENABLE_0 0x90303028
#define PE_CTRL_PE_AGG_INTENABLE_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t IRQ_soft0iSete : 1; /* bits 0:0 */
		ca_uint32_t IRQ_soft1iSete : 1; /* bits 1:1 */
		ca_uint32_t ipc_int_pe0e : 1; /* bits 2:2 */
		ca_uint32_t ipc_int_pe1e : 1; /* bits 3:3 */
		ca_uint32_t PER_UART0_INT_1e : 1; /* bits 4:4 */
		ca_uint32_t PER_UART1_INT_1e : 1; /* bits 5:5 */
		ca_uint32_t PER_UART2_INT_1e : 1; /* bits 6:6 */
		ca_uint32_t PER_UART3_INT_1e : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t XFI0_INTERRUPTe : 1; /* bits 9:9 */
		ca_uint32_t XFI1_INTERRUPTe : 1; /* bits 10:10 */
		ca_uint32_t PER_PERIPHERAL_INTERRUPT_1e : 1; /* bits 11:11 */
		ca_uint32_t WOL_INTERRUPTe : 1; /* bits 12:12 */
		ca_uint32_t rsrvd2 : 19;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_AGG_INTENABLE_0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_QM_AGG_INTERRUPT_1 0x9030302c
#define PE_CTRL_PE_QM_AGG_INTERRUPT_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t CPU_REFILL_REQ_0i : 1; /* bits 0:0 */
		ca_uint32_t CPU_REFILL_REQ_1i : 1; /* bits 1:1 */
		ca_uint32_t CPU_REFILL_REQ_2i : 1; /* bits 2:2 */
		ca_uint32_t CPU_REFILL_REQ_3i : 1; /* bits 3:3 */
		ca_uint32_t CPU_REFILL_REQ_4i : 1; /* bits 4:4 */
		ca_uint32_t CPU_REFILL_REQ_5i : 1; /* bits 5:5 */
		ca_uint32_t CPU_REFILL_REQ_6i : 1; /* bits 6:6 */
		ca_uint32_t CPU_REFILL_REQ_7i : 1; /* bits 7:7 */
		ca_uint32_t CPU_REFILL_REQ_8i : 1; /* bits 8:8 */
		ca_uint32_t CPU_REFILL_REQ_9i : 1; /* bits 9:9 */
		ca_uint32_t CPU_REFILL_REQ_10i : 1; /* bits 10:10 */
		ca_uint32_t CPU_REFILL_REQ_11i : 1; /* bits 11:11 */
		ca_uint32_t CPU_REFILL_REQ_12i : 1; /* bits 12:12 */
		ca_uint32_t CPU_REFILL_REQ_13i : 1; /* bits 13:13 */
		ca_uint32_t CPU_EPP_256_FIFO_HIi : 1; /* bits 14:14 */
		ca_uint32_t CPU_EPP_256_FIFO_LOi : 1; /* bits 15:15 */
		ca_uint32_t CPU_EPP_FIFO_0i : 1; /* bits 16:16 */
		ca_uint32_t CPU_EPP_FIFO_1i : 1; /* bits 17:17 */
		ca_uint32_t CPU_EPP_FIFO_2i : 1; /* bits 18:18 */
		ca_uint32_t CPU_EPP_FIFO_3i : 1; /* bits 19:19 */
		ca_uint32_t CPU_EPP_FIFO_4i : 1; /* bits 20:20 */
		ca_uint32_t CPU_EPP_FIFO_5i : 1; /* bits 21:21 */
		ca_uint32_t CPU_EPP_FIFO_6i : 1; /* bits 22:22 */
		ca_uint32_t CPU_EPP_FIFO_7i : 1; /* bits 23:23 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_QM_AGG_INTERRUPT_1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_QM_AGG_INTENABLE_1 0x90303030
#define PE_CTRL_PE_QM_AGG_INTENABLE_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t CPU_REFILL_REQ_0e : 1; /* bits 0:0 */
		ca_uint32_t CPU_REFILL_REQ_1e : 1; /* bits 1:1 */
		ca_uint32_t CPU_REFILL_REQ_2e : 1; /* bits 2:2 */
		ca_uint32_t CPU_REFILL_REQ_3e : 1; /* bits 3:3 */
		ca_uint32_t CPU_REFILL_REQ_4e : 1; /* bits 4:4 */
		ca_uint32_t CPU_REFILL_REQ_5e : 1; /* bits 5:5 */
		ca_uint32_t CPU_REFILL_REQ_6e : 1; /* bits 6:6 */
		ca_uint32_t CPU_REFILL_REQ_7e : 1; /* bits 7:7 */
		ca_uint32_t CPU_REFILL_REQ_8e : 1; /* bits 8:8 */
		ca_uint32_t CPU_REFILL_REQ_9e : 1; /* bits 9:9 */
		ca_uint32_t CPU_REFILL_REQ_10e : 1; /* bits 10:10 */
		ca_uint32_t CPU_REFILL_REQ_11e : 1; /* bits 11:11 */
		ca_uint32_t CPU_REFILL_REQ_12e : 1; /* bits 12:12 */
		ca_uint32_t CPU_REFILL_REQ_13e : 1; /* bits 13:13 */
		ca_uint32_t CPU_EPP_256_FIFO_HIe : 1; /* bits 14:14 */
		ca_uint32_t CPU_EPP_256_FIFO_LOe : 1; /* bits 15:15 */
		ca_uint32_t CPU_EPP_FIFO_0e : 1; /* bits 16:16 */
		ca_uint32_t CPU_EPP_FIFO_1e : 1; /* bits 17:17 */
		ca_uint32_t CPU_EPP_FIFO_2e : 1; /* bits 18:18 */
		ca_uint32_t CPU_EPP_FIFO_3e : 1; /* bits 19:19 */
		ca_uint32_t CPU_EPP_FIFO_4e : 1; /* bits 20:20 */
		ca_uint32_t CPU_EPP_FIFO_5e : 1; /* bits 21:21 */
		ca_uint32_t CPU_EPP_FIFO_6e : 1; /* bits 22:22 */
		ca_uint32_t CPU_EPP_FIFO_7e : 1; /* bits 23:23 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_QM_AGG_INTENABLE_1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_AGG_INTERRUPT_1 0x90303034
#define PE_CTRL_PE_AGG_INTERRUPT_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t IRQ_soft0iSeti : 1; /* bits 0:0 */
		ca_uint32_t IRQ_soft1iSeti : 1; /* bits 1:1 */
		ca_uint32_t ipc_int_pe0i : 1; /* bits 2:2 */
		ca_uint32_t ipc_int_pe1i : 1; /* bits 3:3 */
		ca_uint32_t PER_UART0_INT_1i : 1; /* bits 4:4 */
		ca_uint32_t PER_UART1_INT_1i : 1; /* bits 5:5 */
		ca_uint32_t PER_UART2_INT_1i : 1; /* bits 6:6 */
		ca_uint32_t PER_UART3_INT_1i : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t XFI0_INTERRUPTi : 1; /* bits 9:9 */
		ca_uint32_t XFI1_INTERRUPTi : 1; /* bits 10:10 */
		ca_uint32_t PER_PERIPHERAL_INTERRUPT_1i : 1; /* bits 11:11 */
		ca_uint32_t WOL_INTERRUPTi : 1; /* bits 12:12 */
		ca_uint32_t rsrvd2 : 19;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_AGG_INTERRUPT_1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_AGG_INTENABLE_1 0x90303038
#define PE_CTRL_PE_AGG_INTENABLE_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t IRQ_soft0iSete : 1; /* bits 0:0 */
		ca_uint32_t IRQ_soft1iSete : 1; /* bits 1:1 */
		ca_uint32_t ipc_int_pe0e : 1; /* bits 2:2 */
		ca_uint32_t ipc_int_pe1e : 1; /* bits 3:3 */
		ca_uint32_t PER_UART0_INT_1e : 1; /* bits 4:4 */
		ca_uint32_t PER_UART1_INT_1e : 1; /* bits 5:5 */
		ca_uint32_t PER_UART2_INT_1e : 1; /* bits 6:6 */
		ca_uint32_t PER_UART3_INT_1e : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t XFI0_INTERRUPTe : 1; /* bits 9:9 */
		ca_uint32_t XFI1_INTERRUPTe : 1; /* bits 10:10 */
		ca_uint32_t PER_PERIPHERAL_INTERRUPT_1e : 1; /* bits 11:11 */
		ca_uint32_t WOL_INTERRUPTe : 1; /* bits 12:12 */
		ca_uint32_t rsrvd2 : 19;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_AGG_INTENABLE_1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_DSS_CONFIG_0 0x9030303c
#define PE_CTRL_PE_DSS_CONFIG_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dss_rst_n : 1; /* bits 0:0 */
		ca_uint32_t ro_sel : 3; /* bits 3:1 */
		ca_uint32_t wire_sel : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t speed_en : 1; /* bits 25:25 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_DSS_CONFIG_0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_DSS_STATUS_0 0x90303040
#define PE_CTRL_PE_DSS_STATUS_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ready : 1; /* bits 0:0 */
		ca_uint32_t count_out : 20; /* bits 20:1 */
		ca_uint32_t wsort_go : 1; /* bits 21:21 */
		ca_uint32_t rsrvd1 : 10;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_DSS_STATUS_0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_DSS_CONFIG_1 0x90303044
#define PE_CTRL_PE_DSS_CONFIG_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dss_rst_n : 1; /* bits 0:0 */
		ca_uint32_t ro_sel : 3; /* bits 3:1 */
		ca_uint32_t wire_sel : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t speed_en : 1; /* bits 25:25 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_DSS_CONFIG_1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_DSS_STATUS_1 0x90303048
#define PE_CTRL_PE_DSS_STATUS_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ready : 1; /* bits 0:0 */
		ca_uint32_t count_out : 20; /* bits 20:1 */
		ca_uint32_t wsort_go : 1; /* bits 21:21 */
		ca_uint32_t rsrvd1 : 10;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_DSS_STATUS_1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_CRYPTO_PROT 0x9030304c
#define PE_CTRL_CRYPTO_PROT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t override_c0m : 2; /* bits 1:0 */
		ca_uint32_t override_c1m : 2; /* bits 3:2 */
		ca_uint32_t override_c0s : 2; /* bits 5:4 */
		ca_uint32_t override_c1s : 2; /* bits 7:6 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_CRYPTO_PROT_t;
#endif /* !__ASSEMBLER__ */

#define override_c1s_PASS 0x0
#define override_c1s_OVSEC 0x1
#define override_c1s_OVNS 0x2
#define override_c0s_PASS 0x0
#define override_c0s_OVSEC 0x1
#define override_c0s_OVNS 0x2
#define override_c1m_PASS 0x0
#define override_c1m_OVSEC 0x1
#define override_c1m_OVNS 0x2
#define override_c0m_PASS 0x0
#define override_c0m_OVSEC 0x1
#define override_c0m_OVNS 0x2

#define PE_CTRL_CRYPT0_SLV_ID 0x90303050
#define PE_CTRL_CRYPT0_SLV_ID_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t reg_id_entry0 : 6; /* bits 5:0 */
		ca_uint32_t reg_id_entry1 : 6; /* bits 11:6 */
		ca_uint32_t reg_id_entry2 : 6; /* bits 17:12 */
		ca_uint32_t reg_id_entry3 : 6; /* bits 23:18 */
		ca_uint32_t reg_id_en0 : 1; /* bits 24:24 */
		ca_uint32_t reg_id_en1 : 1; /* bits 25:25 */
		ca_uint32_t reg_id_en2 : 1; /* bits 26:26 */
		ca_uint32_t reg_id_en3 : 1; /* bits 27:27 */
		ca_uint32_t reg_enabled : 1; /* bits 28:28 */
		ca_uint32_t rsrvd1 : 3;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_CRYPT0_SLV_ID_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_CRYPT0_SLV_ID_MASK 0x90303054
#define PE_CTRL_CRYPT0_SLV_ID_MASK_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t reg_id_entry_mask0 : 6; /* bits 5:0 */
		ca_uint32_t reg_id_entry_mask1 : 6; /* bits 11:6 */
		ca_uint32_t reg_id_entry_mask2 : 6; /* bits 17:12 */
		ca_uint32_t reg_id_entry_mask3 : 6; /* bits 23:18 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_CRYPT0_SLV_ID_MASK_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_CRYPT1_SLV_ID 0x90303058
#define PE_CTRL_CRYPT1_SLV_ID_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t reg_id_entry0 : 6; /* bits 5:0 */
		ca_uint32_t reg_id_entry1 : 6; /* bits 11:6 */
		ca_uint32_t reg_id_entry2 : 6; /* bits 17:12 */
		ca_uint32_t reg_id_entry3 : 6; /* bits 23:18 */
		ca_uint32_t reg_id_en0 : 1; /* bits 24:24 */
		ca_uint32_t reg_id_en1 : 1; /* bits 25:25 */
		ca_uint32_t reg_id_en2 : 1; /* bits 26:26 */
		ca_uint32_t reg_id_en3 : 1; /* bits 27:27 */
		ca_uint32_t reg_enabled : 1; /* bits 28:28 */
		ca_uint32_t rsrvd1 : 3;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_CRYPT1_SLV_ID_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_CRYPT1_SLV_ID_MASK 0x9030305c
#define PE_CTRL_CRYPT1_SLV_ID_MASK_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t reg_id_entry_mask0 : 6; /* bits 5:0 */
		ca_uint32_t reg_id_entry_mask1 : 6; /* bits 11:6 */
		ca_uint32_t reg_id_entry_mask2 : 6; /* bits 17:12 */
		ca_uint32_t reg_id_entry_mask3 : 6; /* bits 23:18 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_CRYPT1_SLV_ID_MASK_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_SADB_SLV_ID 0x90303060
#define PE_CTRL_SADB_SLV_ID_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t reg_id_entry0 : 6; /* bits 5:0 */
		ca_uint32_t reg_id_entry1 : 6; /* bits 11:6 */
		ca_uint32_t reg_id_entry2 : 6; /* bits 17:12 */
		ca_uint32_t reg_id_entry3 : 6; /* bits 23:18 */
		ca_uint32_t reg_id_en0 : 1; /* bits 24:24 */
		ca_uint32_t reg_id_en1 : 1; /* bits 25:25 */
		ca_uint32_t reg_id_en2 : 1; /* bits 26:26 */
		ca_uint32_t reg_id_en3 : 1; /* bits 27:27 */
		ca_uint32_t reg_enabled : 1; /* bits 28:28 */
		ca_uint32_t rsrvd1 : 3;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_SADB_SLV_ID_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_SADB_SLV_ID_MASK 0x90303064
#define PE_CTRL_SADB_SLV_ID_MASK_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t reg_id_entry_mask0 : 6; /* bits 5:0 */
		ca_uint32_t reg_id_entry_mask1 : 6; /* bits 11:6 */
		ca_uint32_t reg_id_entry_mask2 : 6; /* bits 17:12 */
		ca_uint32_t reg_id_entry_mask3 : 6; /* bits 23:18 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_SADB_SLV_ID_MASK_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_TAROKO0_RM_0 0x90303068
#define PE_CTRL_TAROKO0_RM_0_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t RM_i_pht_sram_taroko : 4; /* bits 3:0 */
		ca_uint32_t RM_i_btb_tag_sram_taroko : 4; /* bits 7:4 */
		ca_uint32_t RM_i_btb_data_sram_taroko : 4; /* bits 11:8 */
		ca_uint32_t RM_IRAM1_taroko : 4; /* bits 15:12 */
		ca_uint32_t RM_IRAM0_taroko : 4; /* bits 19:16 */
		ca_uint32_t RM_ICACHE_TAG_taroko : 4; /* bits 23:20 */
		ca_uint32_t RM_ICACHE_LRU_taroko : 4; /* bits 27:24 */
		ca_uint32_t RM_ICACHE_DATA_taroko : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_TAROKO0_RM_0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_TAROKO0_RM_1 0x9030306c
#define PE_CTRL_TAROKO0_RM_1_dft 0x00002222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t RM_DRAM1_taroko : 4; /* bits 3:0 */
		ca_uint32_t RM_DRAM0_taroko : 4; /* bits 7:4 */
		ca_uint32_t RM_DCACHE_TAG_taroko : 4; /* bits 11:8 */
		ca_uint32_t RM_DCACHE_DATA_taroko : 4; /* bits 15:12 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t RME_taroko : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_TAROKO0_RM_1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_TAROKO1_RM_0 0x90303070
#define PE_CTRL_TAROKO1_RM_0_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t RM_i_pht_sram_taroko : 4; /* bits 3:0 */
		ca_uint32_t RM_i_btb_tag_sram_taroko : 4; /* bits 7:4 */
		ca_uint32_t RM_i_btb_data_sram_taroko : 4; /* bits 11:8 */
		ca_uint32_t RM_IRAM1_taroko : 4; /* bits 15:12 */
		ca_uint32_t RM_IRAM0_taroko : 4; /* bits 19:16 */
		ca_uint32_t RM_ICACHE_TAG_taroko : 4; /* bits 23:20 */
		ca_uint32_t RM_ICACHE_LRU_taroko : 4; /* bits 27:24 */
		ca_uint32_t RM_ICACHE_DATA_taroko : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_TAROKO1_RM_0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_TAROKO1_RM_1 0x90303074
#define PE_CTRL_TAROKO1_RM_1_dft 0x00002222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t RM_DRAM1_taroko : 4; /* bits 3:0 */
		ca_uint32_t RM_DRAM0_taroko : 4; /* bits 7:4 */
		ca_uint32_t RM_DCACHE_TAG_taroko : 4; /* bits 11:8 */
		ca_uint32_t RM_DCACHE_DATA_taroko : 4; /* bits 15:12 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t RME_taroko : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_TAROKO1_RM_1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_SADB_RM 0x90303078
#define PE_CTRL_SADB_RM_dft 0x00022222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sadb_sramtest : 16; /* bits 15:0 */
		ca_uint32_t pel2_sramtest : 4; /* bits 19:16 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_SADB_RM_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_CRYPTO1_RM1 0x9030307c
#define PE_CTRL_CRYPTO1_RM1_dft 0x00002222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t crypto1_sramtest1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_CRYPTO1_RM1_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_CRYPTO1_RM0 0x90303080
#define PE_CTRL_CRYPTO1_RM0_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t crypto1_sramtest0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_CRYPTO1_RM0_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_CRYPTO2_RM 0x90303084
#define PE_CTRL_CRYPTO2_RM_dft 0x00000022

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t crypto2_sramtest : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_CRYPTO2_RM_t;
#endif /* !__ASSEMBLER__ */

#define PE_CTRL_PE_LS 0x90303088
#define PE_CTRL_PE_LS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t capsram_repair_sramls : 4; /* bits 3:0 */
		ca_uint32_t crypto0_1_sramls : 6; /* bits 9:4 */
		ca_uint32_t crypto1_1_sramls : 6; /* bits 15:10 */
		ca_uint32_t crypto0_2_sramls : 2; /* bits 17:16 */
		ca_uint32_t crypto1_2_sramls : 2; /* bits 19:18 */
		ca_uint32_t ldma_sramls : 2; /* bits 21:20 */
		ca_uint32_t sadb_sramls : 2; /* bits 23:22 */
		ca_uint32_t pel2_sramls : 1; /* bits 24:24 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} PE_CTRL_PE_LS_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE_CTRL */
#ifndef __ASSEMBLER__
typedef struct {
	PE_CTRL_PES_ADDR_MASTER_CONFIG_t
	  PES_ADDR_MASTER_CONFIG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	PE_CTRL_PE0S_ADDR_CONFIG_t PE0S_ADDR_CONFIG; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	PE_CTRL_PE1S_ADDR_CONFIG_t PE1S_ADDR_CONFIG; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	PE_CTRL_AXI_CTRL_PE0_t AXI_CTRL_PE0; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	PE_CTRL_AXI_CTRL1_PE0_t AXI_CTRL1_PE0; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	PE_CTRL_AXI_CTRL_PE1_t AXI_CTRL_PE1; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	PE_CTRL_AXI_CTRL1_PE1_t AXI_CTRL1_PE1; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	PE_CTRL_PE_QM_AGG_INTERRUPT_0_t PE_QM_AGG_INTERRUPT_0; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	PE_CTRL_PE_QM_AGG_INTENABLE_0_t PE_QM_AGG_INTENABLE_0; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	PE_CTRL_PE_AGG_INTERRUPT_0_t PE_AGG_INTERRUPT_0; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	PE_CTRL_PE_AGG_INTENABLE_0_t PE_AGG_INTENABLE_0; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	PE_CTRL_PE_QM_AGG_INTERRUPT_1_t PE_QM_AGG_INTERRUPT_1; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	PE_CTRL_PE_QM_AGG_INTENABLE_1_t PE_QM_AGG_INTENABLE_1; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	PE_CTRL_PE_AGG_INTERRUPT_1_t PE_AGG_INTERRUPT_1; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	PE_CTRL_PE_AGG_INTENABLE_1_t PE_AGG_INTENABLE_1; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	PE_CTRL_PE_DSS_CONFIG_0_t PE_DSS_CONFIG_0; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	PE_CTRL_PE_DSS_STATUS_0_t PE_DSS_STATUS_0; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	PE_CTRL_PE_DSS_CONFIG_1_t PE_DSS_CONFIG_1; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	PE_CTRL_PE_DSS_STATUS_1_t PE_DSS_STATUS_1; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	PE_CTRL_CRYPTO_PROT_t CRYPTO_PROT; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	PE_CTRL_CRYPT0_SLV_ID_t CRYPT0_SLV_ID; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	PE_CTRL_CRYPT0_SLV_ID_MASK_t CRYPT0_SLV_ID_MASK; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	PE_CTRL_CRYPT1_SLV_ID_t CRYPT1_SLV_ID; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	PE_CTRL_CRYPT1_SLV_ID_MASK_t CRYPT1_SLV_ID_MASK; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	PE_CTRL_SADB_SLV_ID_t SADB_SLV_ID; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	PE_CTRL_SADB_SLV_ID_MASK_t SADB_SLV_ID_MASK; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	PE_CTRL_TAROKO0_RM_0_t TAROKO0_RM_0; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	PE_CTRL_TAROKO0_RM_1_t TAROKO0_RM_1; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	PE_CTRL_TAROKO1_RM_0_t TAROKO1_RM_0; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	PE_CTRL_TAROKO1_RM_1_t TAROKO1_RM_1; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	PE_CTRL_SADB_RM_t SADB_RM; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	PE_CTRL_CRYPTO1_RM1_t CRYPTO1_RM1; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	PE_CTRL_CRYPTO1_RM0_t CRYPTO1_RM0; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	PE_CTRL_CRYPTO2_RM_t CRYPTO2_RM; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	PE_CTRL_PE_LS_t PE_LS; /* addr: 0x00000088 */
} APB1_PE_CTRL_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* APB1 */

#ifndef __ASSEMBLER__
typedef struct {
	APB1_PE0_ATU_t PE0_ATU; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[241];
	APB1_PE1_ATU_t PE1_ATU; /* addr: 0x00000100 */
	ca_uint32_t rsrvd2[241];
	APB1_CRYPTO0_ATU_t CRYPTO0_ATU; /* addr: 0x00000200 */
	ca_uint32_t rsrvd3[497];
	APB1_CRYPTO1_ATU_t CRYPTO1_ATU; /* addr: 0x00000400 */
	ca_uint32_t rsrvd4[3057];
	APB1_LDMA_t LDMA; /* addr: 0x00001000 */
	ca_uint32_t rsrvd5[2529];
	APB1_LDMA_RCPU_t LDMA_RCPU; /* addr: 0x00002000 */
	ca_uint32_t rsrvd6[2529];
	APB1_PE_CTRL_t PE_CTRL; /* addr: 0x00003000 */
} APB1_t;
#endif /* !__ASSEMBLER__ */

/*
 * APB0
 */

/*
 * L2FE
 */

/*
 * GLB
 */

#define L2FE_GLB_VER_CTRL 0xf4301000
#define L2FE_GLB_VER_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rev_id : 16; /* bits 15:0 */
		ca_uint32_t ver_id : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_VER_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_CTRL 0xf4301004
#define L2FE_GLB_CTRL_dft 0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t soft_reset : 1; /* bits 0:0 */
		ca_uint32_t pipeline_clk_num : 5; /* bits 5:1 */
		ca_uint32_t change_ip_if_pop_en : 1; /* bits 6:6 */
		ca_uint32_t qos_enhance_mode : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_INTERRUPT 0xf4301008
#define L2FE_GLB_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t lf_overflow_intI : 1; /* bits 1:1 */
		ca_uint32_t ple_hd_ff_overflow_intI : 1; /* bits 2:2 */
		ca_uint32_t rsrvd2 : 5;
		ca_uint32_t port_mac_lmt_excd_intI : 1; /* bits 8:8 */
		ca_uint32_t l2e_hash_collision_intI : 1; /* bits 9:9 */
		ca_uint32_t rsrvd3 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_INTERRUPTE 0xf430100c
#define L2FE_GLB_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t lf_overflow_intIE : 1; /* bits 1:1 */
		ca_uint32_t ple_hd_ff_overflow_intIE : 1; /* bits 2:2 */
		ca_uint32_t rsrvd2 : 5;
		ca_uint32_t port_mac_lmt_excd_intIE : 1; /* bits 8:8 */
		ca_uint32_t l2e_hash_collision_intIE : 1; /* bits 9:9 */
		ca_uint32_t rsrvd3 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_STTS 0xf4301010
#define L2FE_GLB_STTS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2fe_init_done : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_STTS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_L2FE_CFG_SPARE 0xf4301014
#define L2FE_GLB_L2FE_CFG_SPARE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bit : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_L2FE_CFG_SPARE_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_L2FE_STTS_SPARE 0xf4301018
#define L2FE_GLB_L2FE_STTS_SPARE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bit : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_L2FE_STTS_SPARE_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_0 0xf430101c
#define L2FE_GLB_SRAM_TEST_CONTROL_0_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_1 0xf4301020
#define L2FE_GLB_SRAM_TEST_CONTROL_1_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_2 0xf4301024
#define L2FE_GLB_SRAM_TEST_CONTROL_2_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_3 0xf4301028
#define L2FE_GLB_SRAM_TEST_CONTROL_3_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_4 0xf430102c
#define L2FE_GLB_SRAM_TEST_CONTROL_4_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_5 0xf4301030
#define L2FE_GLB_SRAM_TEST_CONTROL_5_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_5_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_6 0xf4301034
#define L2FE_GLB_SRAM_TEST_CONTROL_6_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_6_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_7 0xf4301038
#define L2FE_GLB_SRAM_TEST_CONTROL_7_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_7_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_TEST_CONTROL_8 0xf430103c
#define L2FE_GLB_SRAM_TEST_CONTROL_8_dft 0x22222200

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_TEST_CONTROL_8_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_LS_CONTROL_0 0xf4301040
#define L2FE_GLB_SRAM_LS_CONTROL_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2fe1_sramls : 12; /* bits 11:0 */
		ca_uint32_t l2fe2_sramls : 12; /* bits 23:12 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_LS_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_LS_CONTROL_1 0xf4301044
#define L2FE_GLB_SRAM_LS_CONTROL_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2fe3_sramls : 12; /* bits 11:0 */
		ca_uint32_t l2fe4_sramls : 11; /* bits 22:12 */
		ca_uint32_t rsrvd1 : 9;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_LS_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_SRAM_LS_CONTROL_2 0xf4301048
#define L2FE_GLB_SRAM_LS_CONTROL_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2fe5_sramls : 11; /* bits 10:0 */
		ca_uint32_t l2fe6_sramls : 8; /* bits 18:11 */
		ca_uint32_t l2fe7_sramls : 2; /* bits 20:19 */
		ca_uint32_t rsrvd1 : 11;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_SRAM_LS_CONTROL_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_L2FE_MONITOR_TRIG 0xf430104c
#define L2FE_GLB_L2FE_MONITOR_TRIG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t en : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 30;
		ca_uint32_t mode : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_L2FE_MONITOR_TRIG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_L2FE_MONITOR_CTRL 0xf4301050
#define L2FE_GLB_L2FE_MONITOR_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bus_sel : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_L2FE_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_L2FE_MONITOR_RETURN 0xf4301054
#define L2FE_GLB_L2FE_MONITOR_RETURN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_L2FE_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_GLB_DEBUG 0xf4301058
#define L2FE_GLB_DEBUG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bus_sel : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_GLB_DEBUG_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_GLB_VER_CTRL_t VER_CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_GLB_CTRL_t CTRL; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_GLB_INTERRUPT_t INTERRUPT; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_GLB_INTERRUPTE_t INTERRUPTE; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_GLB_STTS_t STTS; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_GLB_L2FE_CFG_SPARE_t L2FE_CFG_SPARE; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_GLB_L2FE_STTS_SPARE_t L2FE_STTS_SPARE; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_GLB_SRAM_TEST_CONTROL_0_t SRAM_TEST_CONTROL_0; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_GLB_SRAM_TEST_CONTROL_1_t SRAM_TEST_CONTROL_1; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_GLB_SRAM_TEST_CONTROL_2_t SRAM_TEST_CONTROL_2; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_GLB_SRAM_TEST_CONTROL_3_t SRAM_TEST_CONTROL_3; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_GLB_SRAM_TEST_CONTROL_4_t SRAM_TEST_CONTROL_4; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_GLB_SRAM_TEST_CONTROL_5_t SRAM_TEST_CONTROL_5; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_GLB_SRAM_TEST_CONTROL_6_t SRAM_TEST_CONTROL_6; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_GLB_SRAM_TEST_CONTROL_7_t SRAM_TEST_CONTROL_7; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_GLB_SRAM_TEST_CONTROL_8_t SRAM_TEST_CONTROL_8; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_GLB_SRAM_LS_CONTROL_0_t SRAM_LS_CONTROL_0; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_GLB_SRAM_LS_CONTROL_1_t SRAM_LS_CONTROL_1; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_GLB_SRAM_LS_CONTROL_2_t SRAM_LS_CONTROL_2; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_GLB_L2FE_MONITOR_TRIG_t L2FE_MONITOR_TRIG; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_GLB_L2FE_MONITOR_CTRL_t L2FE_MONITOR_CTRL; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2FE_GLB_L2FE_MONITOR_RETURN_t L2FE_MONITOR_RETURN; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2FE_GLB_DEBUG_t DEBUG; /* addr: 0x00000058 */
} APB0_L2FE_GLB_t;
#endif /* !__ASSEMBLER__ */

/*
 * PP
 */

#define L2FE_PP_PPID_ATTR_CFG 0xf4301100
#define L2FE_PP_PPID_ATTR_CFG_dft 0x009d0000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ppid0 : 2; /* bits 1:0 */
		ca_uint32_t ppid1 : 2; /* bits 3:2 */
		ca_uint32_t ppid2 : 2; /* bits 5:4 */
		ca_uint32_t ppid3 : 2; /* bits 7:6 */
		ca_uint32_t ppid4 : 2; /* bits 9:8 */
		ca_uint32_t ppid5 : 2; /* bits 11:10 */
		ca_uint32_t ppid6 : 2; /* bits 13:12 */
		ca_uint32_t ppid7 : 2; /* bits 15:14 */
		ca_uint32_t ppid8 : 2; /* bits 17:16 */
		ca_uint32_t ppid9 : 2; /* bits 19:18 */
		ca_uint32_t ppid10 : 2; /* bits 21:20 */
		ca_uint32_t ppid11 : 2; /* bits 23:22 */
		ca_uint32_t ppid12 : 2; /* bits 25:24 */
		ca_uint32_t ppid13 : 2; /* bits 27:26 */
		ca_uint32_t ppid14 : 2; /* bits 29:28 */
		ca_uint32_t ppid15 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_PPID_ATTR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_DPB_CTRL 0xf4301104
#define L2FE_PP_DPB_CTRL_dft 0x00000003

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid_pattern : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_DPB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_TPID_CMP_S 0xf4301108
#define L2FE_PP_TPID_CMP_S_dft 0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_TPID_CMP_S_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_TPID_CMP_C 0xf430110c
#define L2FE_PP_TPID_CMP_C_dft 0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_TPID_CMP_C_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_TPID_CMP_O 0xf4301110
#define L2FE_PP_TPID_CMP_O_dft 0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_TPID_CMP_O_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_TPID_CMP_USER 0xf4301114
#define L2FE_PP_TPID_CMP_USER_dft 0x00009100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_TPID_CMP_USER_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HELLO_PKT_ENABLE_DA_LOW 0xf4301118
#define L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HELLO_PKT_ENABLE_DA_HI 0xf430111c
#define L2FE_PP_HELLO_PKT_ENABLE_DA_HI_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HELLO_PKT_DA_LOW 0xf4301120
#define L2FE_PP_HELLO_PKT_DA_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HELLO_PKT_DA_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HELLO_PKT_DA_HI 0xf4301124
#define L2FE_PP_HELLO_PKT_DA_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HELLO_PKT_DA_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_ENABLE_DA_0_LOW 0xf4301128
#define L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_ENABLE_DA_0_HI 0xf430112c
#define L2FE_PP_SPECIAL_ENABLE_DA_0_HI_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_DA_0_LOW 0xf4301130
#define L2FE_PP_SPECIAL_DA_0_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_DA_0_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_DA_0_HI 0xf4301134
#define L2FE_PP_SPECIAL_DA_0_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_DA_0_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_EV2PT 0xf4301138
#define L2FE_PP_SPECIAL_EV2PT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ev2pt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_EV2PT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_ENABLE_DA_1_LOW 0xf430113c
#define L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_ENABLE_DA_1_HI 0xf4301140
#define L2FE_PP_SPECIAL_ENABLE_DA_1_HI_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_DA_1_LOW 0xf4301144
#define L2FE_PP_SPECIAL_DA_1_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_DA_1_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_DA_1_HI 0xf4301148
#define L2FE_PP_SPECIAL_DA_1_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_DA_1_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_VLAN 0xf430114c
#define L2FE_PP_SPECIAL_VLAN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vlan : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_VLAN_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MY_MAC_LOW 0xf4301150
#define L2FE_PP_MY_MAC_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MY_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MY_MAC_HI 0xf4301154
#define L2FE_PP_MY_MAC_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MY_MAC_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MY_MAC_ENABLE_LOW 0xf4301158
#define L2FE_PP_MY_MAC_ENABLE_LOW_dft 0x00ffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MY_MAC_ENABLE_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MY_MAC_LOW_1 0xf430115c
#define L2FE_PP_MY_MAC_LOW_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MY_MAC_LOW_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MY_MAC_HI_1 0xf4301160
#define L2FE_PP_MY_MAC_HI_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MY_MAC_HI_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MY_MAC_ENABLE_LOW_1 0xf4301164
#define L2FE_PP_MY_MAC_ENABLE_LOW_1_dft 0x00ffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MY_MAC_ENABLE_LOW_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_RSV_MAC_MC_LOW 0xf4301168
#define L2FE_PP_RSV_MAC_MC_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_RSV_MAC_MC_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_RSV_MAC_MC_HI 0xf430116c
#define L2FE_PP_RSV_MAC_MC_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_RSV_MAC_MC_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_RSV_ENABLE_MC_LOW 0xf4301170
#define L2FE_PP_RSV_ENABLE_MC_LOW_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_RSV_ENABLE_MC_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_RSV_ENABLE_MC_HI 0xf4301174
#define L2FE_PP_RSV_ENABLE_MC_HI_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_RSV_ENABLE_MC_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_RSV_GROUP_MAC_LOW 0xf4301178
#define L2FE_PP_RSV_GROUP_MAC_LOW_dft 0xc2000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_RSV_GROUP_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_RSV_GROUP_MAC_HI 0xf430117c
#define L2FE_PP_RSV_GROUP_MAC_HI_dft 0x00000180

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_RSV_GROUP_MAC_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_RSV_GROUP_ENABLE_LOW 0xf4301180
#define L2FE_PP_RSV_GROUP_ENABLE_LOW_dft 0xfffffff0

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_RSV_GROUP_ENABLE_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_RSV_GROUP_ENABLE_HI 0xf4301184
#define L2FE_PP_RSV_GROUP_ENABLE_HI_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t enable : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_RSV_GROUP_ENABLE_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MEF_OAM_MAC_0_LOW 0xf4301188
#define L2FE_PP_MEF_OAM_MAC_0_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MEF_OAM_MAC_0_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MEF_OAM_MAC_0_HI 0xf430118c
#define L2FE_PP_MEF_OAM_MAC_0_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MEF_OAM_MAC_0_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MEF_OAM_TYPE_0 0xf4301190
#define L2FE_PP_MEF_OAM_TYPE_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MEF_OAM_TYPE_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MEF_OAM_MAC_1_LOW 0xf4301194
#define L2FE_PP_MEF_OAM_MAC_1_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MEF_OAM_MAC_1_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MEF_OAM_MAC_1_HI 0xf4301198
#define L2FE_PP_MEF_OAM_MAC_1_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MEF_OAM_MAC_1_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_MEF_OAM_TYPE_1 0xf430119c
#define L2FE_PP_MEF_OAM_TYPE_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_MEF_OAM_TYPE_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_L7_OFFSET 0xf43011a0
#define L2FE_PP_L7_OFFSET_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t offset : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_L7_OFFSET_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_NI_INTF_ERR_STTS_0 0xf43011a4
#define L2FE_PP_NI_INTF_ERR_STTS_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sop_eop_mismatch_0 : 1; /* bits 0:0 */
		ca_uint32_t sop_eop_mismatch_1 : 1; /* bits 1:1 */
		ca_uint32_t sop_eop_mismatch_2 : 1; /* bits 2:2 */
		ca_uint32_t sop_eop_mismatch_3 : 1; /* bits 3:3 */
		ca_uint32_t sop_eop_mismatch_4 : 1; /* bits 4:4 */
		ca_uint32_t sop_eop_mismatch_5 : 1; /* bits 5:5 */
		ca_uint32_t sop_eop_mismatch_6 : 1; /* bits 6:6 */
		ca_uint32_t sop_eop_mismatch_7 : 1; /* bits 7:7 */
		ca_uint32_t sop_eop_mismatch_8 : 1; /* bits 8:8 */
		ca_uint32_t sop_eop_mismatch_9 : 1; /* bits 9:9 */
		ca_uint32_t sop_eop_mismatch_10 : 1; /* bits 10:10 */
		ca_uint32_t sop_eop_mismatch_11 : 1; /* bits 11:11 */
		ca_uint32_t sop_eop_mismatch_12 : 1; /* bits 12:12 */
		ca_uint32_t sop_eop_mismatch_13 : 1; /* bits 13:13 */
		ca_uint32_t sop_eop_mismatch_14 : 1; /* bits 14:14 */
		ca_uint32_t sop_eop_mismatch_15 : 1; /* bits 15:15 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_NI_INTF_ERR_STTS_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_NI_INTF_ERR_STTS_1 0xf43011a8
#define L2FE_PP_NI_INTF_ERR_STTS_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t runt_l2_pkt_0 : 1; /* bits 0:0 */
		ca_uint32_t runt_l2_pkt_1 : 1; /* bits 1:1 */
		ca_uint32_t runt_l2_pkt_2 : 1; /* bits 2:2 */
		ca_uint32_t runt_l2_pkt_3 : 1; /* bits 3:3 */
		ca_uint32_t runt_l2_pkt_4 : 1; /* bits 4:4 */
		ca_uint32_t runt_l2_pkt_5 : 1; /* bits 5:5 */
		ca_uint32_t runt_l2_pkt_6 : 1; /* bits 6:6 */
		ca_uint32_t runt_l2_pkt_7 : 1; /* bits 7:7 */
		ca_uint32_t runt_l2_pkt_8 : 1; /* bits 8:8 */
		ca_uint32_t runt_l2_pkt_9 : 1; /* bits 9:9 */
		ca_uint32_t runt_l2_pkt_10 : 1; /* bits 10:10 */
		ca_uint32_t runt_l2_pkt_11 : 1; /* bits 11:11 */
		ca_uint32_t runt_l2_pkt_12 : 1; /* bits 12:12 */
		ca_uint32_t runt_l2_pkt_13 : 1; /* bits 13:13 */
		ca_uint32_t runt_l2_pkt_14 : 1; /* bits 14:14 */
		ca_uint32_t runt_l2_pkt_15 : 1; /* bits 15:15 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_NI_INTF_ERR_STTS_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_NI_INTF_ERR_STTS_2 0xf43011ac
#define L2FE_PP_NI_INTF_ERR_STTS_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sob_eob_mismatch_0 : 1; /* bits 0:0 */
		ca_uint32_t sob_eob_mismatch_1 : 1; /* bits 1:1 */
		ca_uint32_t sob_eob_mismatch_2 : 1; /* bits 2:2 */
		ca_uint32_t sob_eob_mismatch_3 : 1; /* bits 3:3 */
		ca_uint32_t sob_eob_mismatch_4 : 1; /* bits 4:4 */
		ca_uint32_t sob_eob_mismatch_5 : 1; /* bits 5:5 */
		ca_uint32_t sob_eob_mismatch_6 : 1; /* bits 6:6 */
		ca_uint32_t sob_eob_mismatch_7 : 1; /* bits 7:7 */
		ca_uint32_t sob_eob_mismatch_8 : 1; /* bits 8:8 */
		ca_uint32_t sob_eob_mismatch_9 : 1; /* bits 9:9 */
		ca_uint32_t sob_eob_mismatch_10 : 1; /* bits 10:10 */
		ca_uint32_t sob_eob_mismatch_11 : 1; /* bits 11:11 */
		ca_uint32_t sob_eob_mismatch_12 : 1; /* bits 12:12 */
		ca_uint32_t sob_eob_mismatch_13 : 1; /* bits 13:13 */
		ca_uint32_t sob_eob_mismatch_14 : 1; /* bits 14:14 */
		ca_uint32_t sob_eob_mismatch_15 : 1; /* bits 15:15 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_NI_INTF_ERR_STTS_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_NI_INTF_ERR_STTS_3 0xf43011b0
#define L2FE_PP_NI_INTF_ERR_STTS_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sop_2_sop_gap : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_NI_INTF_ERR_STTS_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_PINGPONG_STS 0xf43011b4
#define L2FE_PP_PINGPONG_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ovfl : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_NI_INTF_STS 0xf43011b8
#define L2FE_PP_NI_INTF_STS_dft 0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdy : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_NI_INTF_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_NI_INTF_DROP_CNT 0xf43011bc
#define L2FE_PP_NI_INTF_DROP_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t drop : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_NI_INTF_DROP_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_NI_INTF_PKT_CNT 0xf43011c0
#define L2FE_PP_NI_INTF_PKT_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t eop : 16; /* bits 15:0 */
		ca_uint32_t sop : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_NI_INTF_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HEADER_A_LOW 0xf43011c4
#define L2FE_PP_HEADER_A_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HEADER_A_MID 0xf43011c8
#define L2FE_PP_HEADER_A_MID_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HEADER_A_MID_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HEADER_A_HI 0xf43011cc
#define L2FE_PP_HEADER_A_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_PARSER_CTRL 0xf43011d0
#define L2FE_PP_PARSER_CTRL_dft 0xa03b2400

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 10;
		ca_uint32_t arp_ipv6_en : 1; /* bits 10:10 */
		ca_uint32_t vlan_ext_mode : 1; /* bits 11:11 */
		ca_uint32_t my_mac_det_range_mode : 1; /* bits 12:12 */
		ca_uint32_t arp_op_filter_dis : 1; /* bits 13:13 */
		ca_uint32_t use_ip_addr_mc : 1; /* bits 14:14 */
		ca_uint32_t l3fe_to_l2fe_lrn_ctrl : 1; /* bits 15:15 */
		ca_uint32_t egr_ptp_pkt_no_drop_set : 1; /* bits 16:16 */
		ca_uint32_t ipv4_checksum_check_enable : 1; /* bits 17:17 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t detect_oam_subtype : 1; /* bits 19:19 */
		ca_uint32_t oam_subtype : 8; /* bits 27:20 */
		ca_uint32_t udf0_det_en : 1; /* bits 28:28 */
		ca_uint32_t udf0_det_type_en : 1; /* bits 29:29 */
		ca_uint32_t udf1_det_en : 1; /* bits 30:30 */
		ca_uint32_t udf1_det_vlan_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_PARSER_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPECIAL_PKT 0xf43011d4
#define L2FE_PP_SPECIAL_PKT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPECIAL_PKT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_DEBUG_BUS 0xf43011d8
#define L2FE_PP_DEBUG_BUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 4; /* bits 3:0 */
		ca_uint32_t ni2fe_pkt_cnt_wrap_en : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_IPPB_ACCESS 0xf43011dc
#define L2FE_PP_IPPB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_IPPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_IPPB_DATA 0xf43011e0
#define L2FE_PP_IPPB_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lspid : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_IPPB_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_ILPB_ACCESS 0xf43011e4
#define L2FE_PP_ILPB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_ILPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_ILPB_DATA4 0xf43011e8
#define L2FE_PP_ILPB_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ilpb_unkwn_pol_mode : 1; /* bits 0:0 */
		ca_uint32_t ilpb_well_known_mc_idx : 5; /* bits 5:1 */
		ca_uint32_t ilpb_well_known_mc_det_en : 1; /* bits 6:6 */
		ca_uint32_t ilpb_rxqos_idx : 3; /* bits 9:7 */
		ca_uint32_t ilpb_wan_ind : 1; /* bits 10:10 */
		ca_uint32_t ilpb_reserved : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_ILPB_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_ILPB_DATA3 0xf43011ec
#define L2FE_PP_ILPB_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ilpb_vlan_cmd_sel_bm : 2; /* bits 1:0 */
		ca_uint32_t ilpb_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t ilpb_default_vlanid : 12; /* bits 14:3 */
		ca_uint32_t ilpb_unkwn_pol_idx : 3; /* bits 17:15 */
		ca_uint32_t ilpb_flowid_as_gemid : 1; /* bits 18:18 */
		ca_uint32_t ilpb_gemid_dynamic_mode : 1; /* bits 19:19 */
		ca_uint32_t ilpb_reserved_1 : 12; /* bits 31:20 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_ILPB_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_ILPB_DATA2 0xf43011f0
#define L2FE_PP_ILPB_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ilpb_stp_mode : 2; /* bits 1:0 */
		ca_uint32_t ilpb_other_tpid_match : 4; /* bits 5:2 */
		ca_uint32_t ilpb_inner_c_tpid_enable : 1; /* bits 6:6 */
		ca_uint32_t ilpb_inner_s_tpid_enable : 1; /* bits 7:7 */
		ca_uint32_t ilpb_top_c_tpid_enable : 1; /* bits 8:8 */
		ca_uint32_t ilpb_top_s_tpid_enable : 1; /* bits 9:9 */
		ca_uint32_t ilpb_c_tpid_match : 4; /* bits 13:10 */
		ca_uint32_t ilpb_s_tpid_match : 4; /* bits 17:14 */
		ca_uint32_t ilpb_drop_doubletagged_packet : 1; /* bits 18:18 */
		ca_uint32_t ilpb_drop_prytagged_packet : 1; /* bits 19:19 */
		ca_uint32_t ilpb_drop_untagged_packet : 1; /* bits 20:20 */
		ca_uint32_t ilpb_drop_ctag_packet : 1; /* bits 21:21 */
		ca_uint32_t ilpb_drop_stag_packet : 1; /* bits 22:22 */
		ca_uint32_t ilpb_drop_singletagged_packet : 1; /* bits 23:23 */
		ca_uint32_t ilpb_default_noninnertag_cmd : 1; /* bits 24:24 */
		ca_uint32_t ilpb_inner_vlan_cmd : 2; /* bits 26:25 */
		ca_uint32_t ilpb_inner_vid_sel_bm : 2; /* bits 28:27 */
		ca_uint32_t ilpb_default_untag_cmd : 1; /* bits 29:29 */
		ca_uint32_t ilpb_default_top_vlan_cmd : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_ILPB_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_ILPB_DATA1 0xf43011f4
#define L2FE_PP_ILPB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ilpb_802_1p_mark_control_bm : 3; /* bits 2:0 */
		ca_uint32_t ilpb_change_1p_if_pop : 1; /* bits 3:3 */
		ca_uint32_t ilpb_top_802_1p_mode_sel : 2; /* bits 5:4 */
		ca_uint32_t ilpb_flowid_sel_bm : 3; /* bits 8:6 */
		ca_uint32_t ilpb_cls_length : 6; /* bits 14:9 */
		ca_uint32_t ilpb_cls_start : 8; /* bits 22:15 */
		ca_uint32_t ilpb_igr_cls_lookup_en : 1; /* bits 23:23 */
		ca_uint32_t ilpb_spcl_pkt_idx : 4; /* bits 27:24 */
		ca_uint32_t ilpb_da_sa_swap_en : 1; /* bits 28:28 */
		ca_uint32_t ilpb_loop_enable : 1; /* bits 29:29 */
		ca_uint32_t ilpb_sa_move_dis_fwd : 1; /* bits 30:30 */
		ca_uint32_t ilpb_station_move_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_ILPB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_ILPB_DATA0 0xf43011f8
#define L2FE_PP_ILPB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ilpb_dflt_premark : 1; /* bits 0:0 */
		ca_uint32_t ilpb_color_src_sel : 2; /* bits 2:1 */
		ca_uint32_t ilpb_ing_fltr_ena : 1; /* bits 3:3 */
		ca_uint32_t ilpb_default_cos : 3; /* bits 6:4 */
		ca_uint32_t ilpb_cos_control_bm : 3; /* bits 9:7 */
		ca_uint32_t ilpb_cos_mode_sel : 3; /* bits 12:10 */
		ca_uint32_t ilpb_default_dscp : 6; /* bits 18:13 */
		ca_uint32_t ilpb_dscp_mark_control_bm : 4; /* bits 22:19 */
		ca_uint32_t ilpb_dscp_mode_sel : 2; /* bits 24:23 */
		ca_uint32_t ilpb_dscp_markdown_en : 1; /* bits 25:25 */
		ca_uint32_t ilpb_default_802_1p : 3; /* bits 28:26 */
		ca_uint32_t ilpb_inner_802_1p_mode_sel : 2; /* bits 30:29 */
		ca_uint32_t ilpb_802_1p_mark_control_bm : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_ILPB_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_DPB_ACCESS 0xf43011fc
#define L2FE_PP_DPB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_DPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_DPB_DATA 0xf4301200
#define L2FE_PP_DPB_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cos : 3; /* bits 2:0 */
		ca_uint32_t ldpid : 6; /* bits 8:3 */
		ca_uint32_t bypass : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_DPB_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPKTP_ACCESS 0xf4301204
#define L2FE_PP_SPKTP_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 25;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPKTP_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_SPKTP_DATA 0xf4301208
#define L2FE_PP_SPKTP_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t encode : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_SPKTP_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HTTP_LINK_0 0xf430120c
#define L2FE_PP_HTTP_LINK_0_dft 0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rule_l4_pid : 16; /* bits 15:0 */
		ca_uint32_t rule_l4_pid_sel : 1; /* bits 16:16 */
		ca_uint32_t rule_l4_type : 2; /* bits 18:17 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rule_lspid : 6; /* bits 25:20 */
		ca_uint32_t rule_lspid_msk : 1; /* bits 26:26 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t rule_vld : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HTTP_LINK_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HTTP_LINK_1 0xf4301210
#define L2FE_PP_HTTP_LINK_1_dft 0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rule_l4_pid : 16; /* bits 15:0 */
		ca_uint32_t rule_l4_pid_sel : 1; /* bits 16:16 */
		ca_uint32_t rule_l4_type : 2; /* bits 18:17 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rule_lspid : 6; /* bits 25:20 */
		ca_uint32_t rule_lspid_msk : 1; /* bits 26:26 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t rule_vld : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HTTP_LINK_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_HTTP_LINK_2 0xf4301214
#define L2FE_PP_HTTP_LINK_2_dft 0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rule_l4_pid : 16; /* bits 15:0 */
		ca_uint32_t rule_l4_pid_sel : 1; /* bits 16:16 */
		ca_uint32_t rule_l4_type : 2; /* bits 18:17 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rule_lspid : 6; /* bits 25:20 */
		ca_uint32_t rule_lspid_msk : 1; /* bits 26:26 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t rule_vld : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_HTTP_LINK_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_ARP_FILTER_ADDR 0xf4301218
#define L2FE_PP_ARP_FILTER_ADDR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tip : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_ARP_FILTER_ADDR_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PP_ARP_FILTER_MSK 0xf430121c
#define L2FE_PP_ARP_FILTER_MSK_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t en : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PP_ARP_FILTER_MSK_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PP */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_PP_PPID_ATTR_CFG_t PPID_ATTR_CFG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_PP_DPB_CTRL_t DPB_CTRL; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_PP_TPID_CMP_S_t TPID_CMP_S; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_PP_TPID_CMP_C_t TPID_CMP_C; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_PP_TPID_CMP_O_t TPID_CMP_O; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_PP_TPID_CMP_USER_t TPID_CMP_USER; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t
	  HELLO_PKT_ENABLE_DA_LOW; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t
	  HELLO_PKT_ENABLE_DA_HI; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_PP_HELLO_PKT_DA_LOW_t HELLO_PKT_DA_LOW; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_PP_HELLO_PKT_DA_HI_t HELLO_PKT_DA_HI; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t
	  SPECIAL_ENABLE_DA_0_LOW; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t
	  SPECIAL_ENABLE_DA_0_HI; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_PP_SPECIAL_DA_0_LOW_t SPECIAL_DA_0_LOW; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_PP_SPECIAL_DA_0_HI_t SPECIAL_DA_0_HI; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_PP_SPECIAL_EV2PT_t SPECIAL_EV2PT; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t
	  SPECIAL_ENABLE_DA_1_LOW; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t
	  SPECIAL_ENABLE_DA_1_HI; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_PP_SPECIAL_DA_1_LOW_t SPECIAL_DA_1_LOW; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_PP_SPECIAL_DA_1_HI_t SPECIAL_DA_1_HI; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_PP_SPECIAL_VLAN_t SPECIAL_VLAN; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_PP_MY_MAC_LOW_t MY_MAC_LOW; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2FE_PP_MY_MAC_HI_t MY_MAC_HI; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2FE_PP_MY_MAC_ENABLE_LOW_t MY_MAC_ENABLE_LOW; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L2FE_PP_MY_MAC_LOW_1_t MY_MAC_LOW_1; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L2FE_PP_MY_MAC_HI_1_t MY_MAC_HI_1; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L2FE_PP_MY_MAC_ENABLE_LOW_1_t MY_MAC_ENABLE_LOW_1; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L2FE_PP_RSV_MAC_MC_LOW_t RSV_MAC_MC_LOW; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L2FE_PP_RSV_MAC_MC_HI_t RSV_MAC_MC_HI; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L2FE_PP_RSV_ENABLE_MC_LOW_t RSV_ENABLE_MC_LOW; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L2FE_PP_RSV_ENABLE_MC_HI_t RSV_ENABLE_MC_HI; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L2FE_PP_RSV_GROUP_MAC_LOW_t RSV_GROUP_MAC_LOW; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L2FE_PP_RSV_GROUP_MAC_HI_t RSV_GROUP_MAC_HI; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L2FE_PP_RSV_GROUP_ENABLE_LOW_t RSV_GROUP_ENABLE_LOW; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L2FE_PP_RSV_GROUP_ENABLE_HI_t RSV_GROUP_ENABLE_HI; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L2FE_PP_MEF_OAM_MAC_0_LOW_t MEF_OAM_MAC_0_LOW; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L2FE_PP_MEF_OAM_MAC_0_HI_t MEF_OAM_MAC_0_HI; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	L2FE_PP_MEF_OAM_TYPE_0_t MEF_OAM_TYPE_0; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	L2FE_PP_MEF_OAM_MAC_1_LOW_t MEF_OAM_MAC_1_LOW; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	L2FE_PP_MEF_OAM_MAC_1_HI_t MEF_OAM_MAC_1_HI; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	L2FE_PP_MEF_OAM_TYPE_1_t MEF_OAM_TYPE_1; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	L2FE_PP_L7_OFFSET_t L7_OFFSET; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	L2FE_PP_NI_INTF_ERR_STTS_0_t NI_INTF_ERR_STTS_0; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	L2FE_PP_NI_INTF_ERR_STTS_1_t NI_INTF_ERR_STTS_1; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd43[3];
	L2FE_PP_NI_INTF_ERR_STTS_2_t NI_INTF_ERR_STTS_2; /* addr: 0x000000ac */
	ca_uint32_t rsrvd44[3];
	L2FE_PP_NI_INTF_ERR_STTS_3_t NI_INTF_ERR_STTS_3; /* addr: 0x000000b0 */
	ca_uint32_t rsrvd45[3];
	L2FE_PP_PINGPONG_STS_t PINGPONG_STS; /* addr: 0x000000b4 */
	ca_uint32_t rsrvd46[3];
	L2FE_PP_NI_INTF_STS_t NI_INTF_STS; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd47[3];
	L2FE_PP_NI_INTF_DROP_CNT_t NI_INTF_DROP_CNT; /* addr: 0x000000bc */
	ca_uint32_t rsrvd48[3];
	L2FE_PP_NI_INTF_PKT_CNT_t NI_INTF_PKT_CNT; /* addr: 0x000000c0 */
	ca_uint32_t rsrvd49[3];
	L2FE_PP_HEADER_A_LOW_t HEADER_A_LOW; /* addr: 0x000000c4 */
	ca_uint32_t rsrvd50[3];
	L2FE_PP_HEADER_A_MID_t HEADER_A_MID; /* addr: 0x000000c8 */
	ca_uint32_t rsrvd51[3];
	L2FE_PP_HEADER_A_HI_t HEADER_A_HI; /* addr: 0x000000cc */
	ca_uint32_t rsrvd52[3];
	L2FE_PP_PARSER_CTRL_t PARSER_CTRL; /* addr: 0x000000d0 */
	ca_uint32_t rsrvd53[3];
	L2FE_PP_SPECIAL_PKT_t SPECIAL_PKT; /* addr: 0x000000d4 */
	ca_uint32_t rsrvd54[3];
	L2FE_PP_DEBUG_BUS_t DEBUG_BUS; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd55[3];
	L2FE_PP_IPPB_ACCESS_t IPPB_ACCESS; /* addr: 0x000000dc */
	ca_uint32_t rsrvd56[3];
	L2FE_PP_IPPB_DATA_t IPPB_DATA; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd57[3];
	L2FE_PP_ILPB_ACCESS_t ILPB_ACCESS; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd58[3];
	L2FE_PP_ILPB_DATA4_t ILPB_DATA4; /* addr: 0x000000e8 */
	ca_uint32_t rsrvd59[3];
	L2FE_PP_ILPB_DATA3_t ILPB_DATA3; /* addr: 0x000000ec */
	ca_uint32_t rsrvd60[3];
	L2FE_PP_ILPB_DATA2_t ILPB_DATA2; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd61[3];
	L2FE_PP_ILPB_DATA1_t ILPB_DATA1; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd62[3];
	L2FE_PP_ILPB_DATA0_t ILPB_DATA0; /* addr: 0x000000f8 */
	ca_uint32_t rsrvd63[3];
	L2FE_PP_DPB_ACCESS_t DPB_ACCESS; /* addr: 0x000000fc */
	ca_uint32_t rsrvd64[3];
	L2FE_PP_DPB_DATA_t DPB_DATA; /* addr: 0x00000100 */
	ca_uint32_t rsrvd65[3];
	L2FE_PP_SPKTP_ACCESS_t SPKTP_ACCESS; /* addr: 0x00000104 */
	ca_uint32_t rsrvd66[3];
	L2FE_PP_SPKTP_DATA_t SPKTP_DATA; /* addr: 0x00000108 */
	ca_uint32_t rsrvd67[3];
	L2FE_PP_HTTP_LINK_0_t HTTP_LINK_0; /* addr: 0x0000010c */
	ca_uint32_t rsrvd68[3];
	L2FE_PP_HTTP_LINK_1_t HTTP_LINK_1; /* addr: 0x00000110 */
	ca_uint32_t rsrvd69[3];
	L2FE_PP_HTTP_LINK_2_t HTTP_LINK_2; /* addr: 0x00000114 */
	ca_uint32_t rsrvd70[3];
	L2FE_PP_ARP_FILTER_ADDR_t ARP_FILTER_ADDR; /* addr: 0x00000118 */
	ca_uint32_t rsrvd71[3];
	L2FE_PP_ARP_FILTER_MSK_t ARP_FILTER_MSK; /* addr: 0x0000011c */
} APB0_L2FE_PP_t;
#endif /* !__ASSEMBLER__ */

/*
 * PLA
 */

#define L2FE_PLA_DEBUG_BUS 0xf4301300
#define L2FE_PLA_DEBUG_BUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 2; /* bits 1:0 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLA_EV2_PT_CNVT_ACCESS 0xf4301304
#define L2FE_PLA_EV2_PT_CNVT_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 25;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_EV2_PT_CNVT_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLA_EV2_PT_CNVT_DATA 0xf4301308
#define L2FE_PLA_EV2_PT_CNVT_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ev2_pt_cnvt_encoded_value : 5; /* bits 4:0 */
		ca_uint32_t ev2_pt_cnvt_ethertype : 16; /* bits 20:5 */
		ca_uint32_t rsrvd1 : 11;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_EV2_PT_CNVT_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLA_SPB_ACCESS 0xf430130c
#define L2FE_PLA_SPB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_SPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLA_SPB_DATA 0xf4301310
#define L2FE_PLA_SPB_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t spb_pkt_no_edit : 1; /* bits 0:0 */
		ca_uint32_t spb_keep_ts : 1; /* bits 1:1 */
		ca_uint32_t spb_bypass_sa_lrn_chk : 1; /* bits 2:2 */
		ca_uint32_t spb_limit_fwd_permit : 1; /* bits 3:3 */
		ca_uint32_t spb_learn_dis : 1; /* bits 4:4 */
		ca_uint32_t spb_dscp_mark_down : 1; /* bits 5:5 */
		ca_uint32_t spb_flowid : 12; /* bits 17:6 */
		ca_uint32_t spb_flow_en : 1; /* bits 18:18 */
		ca_uint32_t spb_rate_limit_bypass : 1; /* bits 19:19 */
		ca_uint32_t spb_cos : 3; /* bits 22:20 */
		ca_uint32_t spb_ldpid : 6; /* bits 28:23 */
		ca_uint32_t spb_spcl_fwd : 1; /* bits 29:29 */
		ca_uint32_t spb_pkt_no_drop : 1; /* bits 30:30 */
		ca_uint32_t spb_hash_cllsn_fwd_permit : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_SPB_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLA_DOT1P_MAP_ACCESS 0xf4301314
#define L2FE_PLA_DOT1P_MAP_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_DOT1P_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLA_DOT1P_MAP_DATA 0xf4301318
#define L2FE_PLA_DOT1P_MAP_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dot1p_map_mapped_premark : 1; /* bits 0:0 */
		ca_uint32_t dot1p_map_mapped_cos : 3; /* bits 3:1 */
		ca_uint32_t dot1p_map_mapped_1p : 3; /* bits 6:4 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_DOT1P_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLA_DSCP_MAP_ACCESS 0xf430131c
#define L2FE_PLA_DSCP_MAP_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_DSCP_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLA_DSCP_MAP_DATA 0xf4301320
#define L2FE_PLA_DSCP_MAP_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mapped_premark : 1; /* bits 0:0 */
		ca_uint32_t dscp_map_mapped_cos : 3; /* bits 3:1 */
		ca_uint32_t dscp_map_marked_flag : 1; /* bits 4:4 */
		ca_uint32_t dscp_map_mapped_dscp : 6; /* bits 10:5 */
		ca_uint32_t rsrvd1 : 21;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLA_DSCP_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLA */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_PLA_DEBUG_BUS_t DEBUG_BUS; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_PLA_EV2_PT_CNVT_ACCESS_t EV2_PT_CNVT_ACCESS; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_PLA_EV2_PT_CNVT_DATA_t EV2_PT_CNVT_DATA; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_PLA_SPB_ACCESS_t SPB_ACCESS; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_PLA_SPB_DATA_t SPB_DATA; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_PLA_DOT1P_MAP_ACCESS_t DOT1P_MAP_ACCESS; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_PLA_DOT1P_MAP_DATA_t DOT1P_MAP_DATA; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_PLA_DSCP_MAP_ACCESS_t DSCP_MAP_ACCESS; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_PLA_DSCP_MAP_DATA_t DSCP_MAP_DATA; /* addr: 0x00000020 */
} APB0_L2FE_PLA_t;
#endif /* !__ASSEMBLER__ */

/*
 * PLC
 */

#define L2FE_PLC_HASH_CTRL 0xf4301400
#define L2FE_PLC_HASH_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lan_sa_hashing_vid_sel : 1; /* bits 0:0 */
		ca_uint32_t lan_da_hashing_vid_sel : 1; /* bits 1:1 */
		ca_uint32_t lan_sa_learning_vid_sel : 1; /* bits 2:2 */
		ca_uint32_t wan_sa_hashing_vid_sel : 1; /* bits 3:3 */
		ca_uint32_t wan_da_hashing_vid_sel : 1; /* bits 4:4 */
		ca_uint32_t wan_sa_learning_vid_sel : 1; /* bits 5:5 */
		ca_uint32_t use_dot1p_l2e : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_HASH_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_DPID_FWD_CTRL 0xf4301404
#define L2FE_PLC_DPID_FWD_CTRL_dft 0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vid_fff_fwd : 1; /* bits 0:0 */
		ca_uint32_t unkvlan_fwd : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_DPID_FWD_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_LRN_FWD_CTRL_0 0xf4301408
#define L2FE_PLC_LRN_FWD_CTRL_0_dft 0x02000210

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2_mac_sw_lrn_ldpid : 6; /* bits 5:0 */
		ca_uint32_t l2_mac_sw_lrn_cos : 3; /* bits 8:6 */
		ca_uint32_t l2_mac_sw_lrn_keep_old_wan : 1; /* bits 9:9 */
		ca_uint32_t l2_mac_sw_lrn_keep_old_lan : 1; /* bits 10:10 */
		ca_uint32_t rsrvd1 : 14;
		ca_uint32_t sa_miss_fwd : 1; /* bits 25:25 */
		ca_uint32_t nonstd_sa_all_zero_fwd : 1; /* bits 26:26 */
		ca_uint32_t nonstd_sa_all_one_fwd : 1; /* bits 27:27 */
		ca_uint32_t nonstd_sa_b40_is_one_fwd : 1; /* bits 28:28 */
		ca_uint32_t sm_static_entry_fwd : 1; /* bits 29:29 */
		ca_uint32_t sm_tmp_entry_fwd : 1; /* bits 30:30 */
		ca_uint32_t sm_sm_entry_fwd : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_LRN_FWD_CTRL_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_LRN_FWD_CTRL_1 0xf430140c
#define L2FE_PLC_LRN_FWD_CTRL_1_dft 0x08100810

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sa_limit_excd_ldpid : 6; /* bits 5:0 */
		ca_uint32_t sa_limit_excd_cos : 3; /* bits 8:6 */
		ca_uint32_t sa_limit_excd_fwd_ctrl : 2; /* bits 10:9 */
		ca_uint32_t sa_limit_excd_keep_old_wan : 1; /* bits 11:11 */
		ca_uint32_t sa_limit_excd_keep_old_lan : 1; /* bits 12:12 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t sa_hash_cllsn_ldpid : 6; /* bits 21:16 */
		ca_uint32_t sa_hash_cllsn_cos : 3; /* bits 24:22 */
		ca_uint32_t sa_hash_cllsn_fwd_ctrl : 2; /* bits 26:25 */
		ca_uint32_t sa_hash_cllsn_keep_old_wan : 1; /* bits 27:27 */
		ca_uint32_t sa_hash_cllsn_keep_old_lan : 1; /* bits 28:28 */
		ca_uint32_t swlrn_othr_pkt_fwd : 1; /* bits 29:29 */
		ca_uint32_t rsrvd2 : 2;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_LRN_FWD_CTRL_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_L2_LEARNING_CTRL 0xf4301410
#define L2FE_PLC_L2_LEARNING_CTRL_dft 0x00000046

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t unkvlan_learn : 1; /* bits 0:0 */
		ca_uint32_t unk_ethtype_no_learn : 1; /* bits 1:1 */
		ca_uint32_t igr_dropped_pkt_no_learn : 1; /* bits 2:2 */
		ca_uint32_t non_std_sa_all_zero_learn : 1; /* bits 3:3 */
		ca_uint32_t non_std_sa_all_one_learn : 1; /* bits 4:4 */
		ca_uint32_t non_std_sa_b40_is_one_learn : 1; /* bits 5:5 */
		ca_uint32_t loop_pkt_no_learn : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_L2_LEARNING_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_VLAN_MODE_CTRL 0xf4301414
#define L2FE_PLC_VLAN_MODE_CTRL_dft 0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2e_glb_vlan_mode : 1; /* bits 0:0 */
		ca_uint32_t en_fdb_vlan_pre_rslt : 1; /* bits 1:1 */
		ca_uint32_t en_egr_ptag_lkup_egr_ve : 1; /* bits 2:2 */
		ca_uint32_t en_mc_pkt_lkup_elpb : 1; /* bits 3:3 */
		ca_uint32_t lan_src_usel2_vlan : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_VLAN_MODE_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_SA_CHK_CTL 0xf4301418
#define L2FE_PLC_SA_CHK_CTL_dft 0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t skip_sa_chk : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_SA_CHK_CTL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_DEBUG 0xf430141c
#define L2FE_PLC_DEBUG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bus_sel : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_DEBUG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_ELPB_ACCESS 0xf4301420
#define L2FE_PLC_ELPB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_ELPB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_ELPB_DATA1 0xf4301424
#define L2FE_PLC_ELPB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t elpb_802_1p_mark_control_bm : 3; /* bits 2:0 */
		ca_uint32_t elpb_change_1p_if_pop : 1; /* bits 3:3 */
		ca_uint32_t elpb_top_802_1p_mode_sel : 2; /* bits 5:4 */
		ca_uint32_t elpb_802_1p_ctrl_sel : 1; /* bits 6:6 */
		ca_uint32_t elpb_use_tx_vlan_lkup_acl : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_ELPB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLC_ELPB_DATA0 0xf4301428
#define L2FE_PLC_ELPB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t elpb_egr_vlan_aware_mode : 1; /* bits 0:0 */
		ca_uint32_t elpb_egr_port_stp_status : 1; /* bits 1:1 */
		ca_uint32_t elpb_egr_ve_srch_en : 1; /* bits 2:2 */
		ca_uint32_t elpb_egr_dest_wan : 1; /* bits 3:3 */
		ca_uint32_t elpb_egr_cls_length : 6; /* bits 9:4 */
		ca_uint32_t elpb_egr_cls_start : 8; /* bits 17:10 */
		ca_uint32_t elpb_egr_cls_lookup_en : 1; /* bits 18:18 */
		ca_uint32_t elpb_egr_cls_flowid_sel : 1; /* bits 19:19 */
		ca_uint32_t elpb_egr_cls_cos_sel : 1; /* bits 20:20 */
		ca_uint32_t elpb_dscp_mark_control_bm : 4; /* bits 24:21 */
		ca_uint32_t elpb_dscp_mode_sel : 2; /* bits 26:25 */
		ca_uint32_t elpb_dscp_ctrl_sel : 1; /* bits 27:27 */
		ca_uint32_t elpb_dscp_markdown_en : 1; /* bits 28:28 */
		ca_uint32_t elpb_inner_802_1p_mode_sel : 2; /* bits 30:29 */
		ca_uint32_t elpb_802_1p_mark_control_bm : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLC_ELPB_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLC */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_PLC_HASH_CTRL_t HASH_CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_PLC_DPID_FWD_CTRL_t DPID_FWD_CTRL; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_PLC_LRN_FWD_CTRL_0_t LRN_FWD_CTRL_0; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_PLC_LRN_FWD_CTRL_1_t LRN_FWD_CTRL_1; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_PLC_L2_LEARNING_CTRL_t L2_LEARNING_CTRL; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_PLC_VLAN_MODE_CTRL_t VLAN_MODE_CTRL; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_PLC_SA_CHK_CTL_t SA_CHK_CTL; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_PLC_DEBUG_t DEBUG; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_PLC_ELPB_ACCESS_t ELPB_ACCESS; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_PLC_ELPB_DATA1_t ELPB_DATA1; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_PLC_ELPB_DATA0_t ELPB_DATA0; /* addr: 0x00000028 */
} APB0_L2FE_PLC_t;
#endif /* !__ASSEMBLER__ */

/*
 * PLE
 */

#define L2FE_PLE_CTL_REG 0xf4301500
#define L2FE_PLE_CTL_REG_dft 0x00000260

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txvlan_membshp_chk_en_lan : 1; /* bits 0:0 */
		ca_uint32_t txvlan_membshp_chk_en_wan : 1; /* bits 1:1 */
		ca_uint32_t cos_l3_only : 1; /* bits 2:2 */
		ca_uint32_t skip_port_lpbk_chk : 1; /* bits 3:3 */
		ca_uint32_t pon_mode : 1; /* bits 4:4 */
		ca_uint32_t igr_fltr_chk_ldpid : 1; /* bits 5:5 */
		ca_uint32_t egr_fltr_chk_lspid : 1; /* bits 6:6 */
		ca_uint32_t use_gemid_mapped_from_txdot1p : 1; /* bits 7:7 */
		ca_uint32_t wan_dst_acl_vlan_en : 1; /* bits 8:8 */
		ca_uint32_t use_rx_dscp_map_cos : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_CTL_REG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_DEFAULT_REG 0xf4301504
#define L2FE_PLE_DEFAULT_REG_dft 0x001b0000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dflt_flow_en : 1; /* bits 0:0 */
		ca_uint32_t dflt_flowid : 12; /* bits 12:1 */
		ca_uint32_t dflt_markdown_en : 1; /* bits 13:13 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t dflt_mc_pid : 6; /* bits 21:16 */
		ca_uint32_t rsrvd2 : 10;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_DEFAULT_REG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_RX_UNKWN_VLAN_DFT 0xf4301508
#define L2FE_PLE_RX_UNKWN_VLAN_DFT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t memshp_bm : 16; /* bits 15:0 */
		ca_uint32_t vl_grp_id : 10; /* bits 25:16 */
		ca_uint32_t rsrvd1 : 6;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_RX_UNKWN_VLAN_DFT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TX_UNKWN_VLAN_DFT_1 0xf430150c
#define L2FE_PLE_TX_UNKWN_VLAN_DFT_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t stp_mode : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TX_UNKWN_VLAN_DFT_2 0xf4301510
#define L2FE_PLE_TX_UNKWN_VLAN_DFT_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t memshp_bm : 16; /* bits 15:0 */
		ca_uint32_t untag_bm : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TRUNK_GRP_CTRL_0 0xf4301514
#define L2FE_PLE_TRUNK_GRP_CTRL_0_dft 0x00000012

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t trunk_hash_field_sel_mac_sa : 1; /* bits 0:0 */
		ca_uint32_t trunk_hash_field_sel_mac_da : 1; /* bits 1:1 */
		ca_uint32_t trunk_hash_field_sel_tx_top_vid : 1; /* bits 2:2 */
		ca_uint32_t trunk_hash_field_sel_ip_sa : 1; /* bits 3:3 */
		ca_uint32_t trunk_hash_field_sel_ip_da : 1; /* bits 4:4 */
		ca_uint32_t trunk_hash_field_sel_l4_sp : 1; /* bits 5:5 */
		ca_uint32_t trunk_hash_field_sel_l4_dp : 1; /* bits 6:6 */
		ca_uint32_t trunk_hash_field_sel_cos : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TRUNK_GRP_CTRL_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TRUNK_GRP_0_MEMBER_0 0xf4301518
#define L2FE_PLE_TRUNK_GRP_0_MEMBER_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t valid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TRUNK_GRP_0_MEMBER_1 0xf430151c
#define L2FE_PLE_TRUNK_GRP_0_MEMBER_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t valid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TRUNK_GRP_CTRL_1 0xf4301520
#define L2FE_PLE_TRUNK_GRP_CTRL_1_dft 0x00000012

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t trunk_hash_field_sel_mac_sa : 1; /* bits 0:0 */
		ca_uint32_t trunk_hash_field_sel_mac_da : 1; /* bits 1:1 */
		ca_uint32_t trunk_hash_field_sel_tx_top_vid : 1; /* bits 2:2 */
		ca_uint32_t trunk_hash_field_sel_ip_sa : 1; /* bits 3:3 */
		ca_uint32_t trunk_hash_field_sel_ip_da : 1; /* bits 4:4 */
		ca_uint32_t trunk_hash_field_sel_l4_sp : 1; /* bits 5:5 */
		ca_uint32_t trunk_hash_field_sel_l4_dp : 1; /* bits 6:6 */
		ca_uint32_t trunk_hash_field_sel_cos : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TRUNK_GRP_CTRL_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TRUNK_GRP_1_MEMBER_0 0xf4301524
#define L2FE_PLE_TRUNK_GRP_1_MEMBER_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t valid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TRUNK_GRP_1_MEMBER_1 0xf4301528
#define L2FE_PLE_TRUNK_GRP_1_MEMBER_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t valid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_HD_FF_CTL_REG 0xf430152c
#define L2FE_PLE_HD_FF_CTL_REG_dft 0x00000610

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t low_thr : 6; /* bits 5:0 */
		ca_uint32_t high_thr : 6; /* bits 11:6 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_HD_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_HD_FF_STS_REG 0xf4301530
#define L2FE_PLE_HD_FF_STS_REG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t overflow_ind : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_HD_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_HD_FF_HDR_CNT 0xf4301534
#define L2FE_PLE_HD_FF_HDR_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_HD_FF_HDR_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_MC_WELL_KNOWN_IP_CTRL 0xf4301538
#define L2FE_PLE_MC_WELL_KNOWN_IP_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ipv6_sub_mask : 8; /* bits 7:0 */
		ca_uint32_t ipv6_prog_addr_vld : 1; /* bits 8:8 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t ipv4_sub_mask : 6; /* bits 21:16 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t ipv4_prog_addr_vld : 1; /* bits 23:23 */
		ca_uint32_t rsrvd3 : 8;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_MC_WELL_KNOWN_IP_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_MC_WELL_KNOWN_IPV4 0xf430153c
#define L2FE_PLE_MC_WELL_KNOWN_IPV4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_MC_WELL_KNOWN_IPV4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_MC_WELL_KNOWN_IPV6_3 0xf4301540
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_MC_WELL_KNOWN_IPV6_2 0xf4301544
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_MC_WELL_KNOWN_IPV6_1 0xf4301548
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_MC_WELL_KNOWN_IPV6_0 0xf430154c
#define L2FE_PLE_MC_WELL_KNOWN_IPV6_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_MC_WELL_KNOWN_IPV6_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_DEBUG_BUS 0xf4301550
#define L2FE_PLE_DEBUG_BUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TX_DSCP_MAP_ACCESS 0xf4301554
#define L2FE_PLE_TX_DSCP_MAP_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TX_DSCP_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TX_DSCP_MAP_DATA 0xf4301558
#define L2FE_PLE_TX_DSCP_MAP_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txdscp_map_mapped_cos : 3; /* bits 2:0 */
		ca_uint32_t txdscp_map_mapped_1p : 3; /* bits 5:3 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TX_DSCP_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TX_DOT1P_MAP_ACCESS 0xf430155c
#define L2FE_PLE_TX_DOT1P_MAP_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 27;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TX_DOT1P_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TX_DOT1P_MAP_DATA 0xf4301560
#define L2FE_PLE_TX_DOT1P_MAP_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txdot1p_map_mapped_cos : 3; /* bits 2:0 */
		ca_uint32_t txdot1p_map_mapped_cos_wan : 3; /* bits 5:3 */
		ca_uint32_t gem_id_vld_wan : 1; /* bits 6:6 */
		ca_uint32_t gem_id_wan : 7; /* bits 13:7 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TX_DOT1P_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_DFT_FWD_ACCESS 0xf4301564
#define L2FE_PLE_DFT_FWD_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_DFT_FWD_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_DFT_FWD_DATA 0xf4301568
#define L2FE_PLE_DFT_FWD_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dft_fwd_deny : 1; /* bits 0:0 */
		ca_uint32_t dft_fwd_mc_group_id : 10; /* bits 10:1 */
		ca_uint32_t dft_fwd_redir_en : 1; /* bits 11:11 */
		ca_uint32_t dft_fwd_mc_group_id_valid : 1; /* bits 12:12 */
		ca_uint32_t rsrvd1 : 19;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_DFT_FWD_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS 0xf430156c
#define L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_MMSHP_CHK_ID_MAP_DATA 0xf4301570
#define L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mmshp_chk_id_map_chk_id : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_PORT_MMSHP_CHK_ACCESS 0xf4301574
#define L2FE_PLE_PORT_MMSHP_CHK_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_PORT_MMSHP_CHK_DATA1 0xf4301578
#define L2FE_PLE_PORT_MMSHP_CHK_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid_bm : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_PORT_MMSHP_CHK_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_PORT_MMSHP_CHK_DATA0 0xf430157c
#define L2FE_PLE_PORT_MMSHP_CHK_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid_bm : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_PORT_MMSHP_CHK_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS 0xf4301580
#define L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA 0xf4301584
#define L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLE */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_PLE_CTL_REG_t CTL_REG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_PLE_DEFAULT_REG_t DEFAULT_REG; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_PLE_RX_UNKWN_VLAN_DFT_t RX_UNKWN_VLAN_DFT; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t TX_UNKWN_VLAN_DFT_1; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t TX_UNKWN_VLAN_DFT_2; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_PLE_TRUNK_GRP_CTRL_0_t TRUNK_GRP_CTRL_0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t TRUNK_GRP_0_MEMBER_0; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t TRUNK_GRP_0_MEMBER_1; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_PLE_TRUNK_GRP_CTRL_1_t TRUNK_GRP_CTRL_1; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t TRUNK_GRP_1_MEMBER_0; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t TRUNK_GRP_1_MEMBER_1; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_PLE_HD_FF_CTL_REG_t HD_FF_CTL_REG; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_PLE_HD_FF_STS_REG_t HD_FF_STS_REG; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_PLE_HD_FF_HDR_CNT_t HD_FF_HDR_CNT; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_PLE_MC_WELL_KNOWN_IP_CTRL_t MC_WELL_KNOWN_IP_CTRL; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_PLE_MC_WELL_KNOWN_IPV4_t MC_WELL_KNOWN_IPV4; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_PLE_MC_WELL_KNOWN_IPV6_3_t MC_WELL_KNOWN_IPV6_3; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_PLE_MC_WELL_KNOWN_IPV6_2_t MC_WELL_KNOWN_IPV6_2; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_PLE_MC_WELL_KNOWN_IPV6_1_t MC_WELL_KNOWN_IPV6_1; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_PLE_MC_WELL_KNOWN_IPV6_0_t MC_WELL_KNOWN_IPV6_0; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_PLE_DEBUG_BUS_t DEBUG_BUS; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2FE_PLE_TX_DSCP_MAP_ACCESS_t TX_DSCP_MAP_ACCESS; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2FE_PLE_TX_DSCP_MAP_DATA_t TX_DSCP_MAP_DATA; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L2FE_PLE_TX_DOT1P_MAP_ACCESS_t TX_DOT1P_MAP_ACCESS; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L2FE_PLE_TX_DOT1P_MAP_DATA_t TX_DOT1P_MAP_DATA; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L2FE_PLE_DFT_FWD_ACCESS_t DFT_FWD_ACCESS; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L2FE_PLE_DFT_FWD_DATA_t DFT_FWD_DATA; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t
	  MMSHP_CHK_ID_MAP_ACCESS; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t MMSHP_CHK_ID_MAP_DATA; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t PORT_MMSHP_CHK_ACCESS; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L2FE_PLE_PORT_MMSHP_CHK_DATA1_t PORT_MMSHP_CHK_DATA1; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L2FE_PLE_PORT_MMSHP_CHK_DATA0_t PORT_MMSHP_CHK_DATA0; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t
	  TRUNK_DEST_MAP_TBL_ACCESS; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t
	  TRUNK_DEST_MAP_TBL_DATA; /* addr: 0x00000084 */
} APB0_L2FE_PLE_t;
#endif /* !__ASSEMBLER__ */

/*
 * ARB
 */

#define L2FE_ARB_ARB_CTRL 0xf4301600
#define L2FE_ARB_ARB_CTRL_dft 0x09c71d80

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t drop_redir_keep_old : 1; /* bits 0:0 */
		ca_uint32_t dbuf_sel : 1; /* bits 1:1 */
		ca_uint32_t ip_ecn_en : 1; /* bits 2:2 */
		ca_uint32_t mc_idx_copy_en : 1; /* bits 3:3 */
		ca_uint32_t dbuf_dpid : 4; /* bits 7:4 */
		ca_uint32_t use_hdr_a_dbuf_en : 1; /* bits 8:8 */
		ca_uint32_t dst_wan_dync_buf_sel : 1; /* bits 9:9 */
		ca_uint32_t wan_lpid : 6; /* bits 15:10 */
		ca_uint32_t wan_ext_lpid : 6; /* bits 21:16 */
		ca_uint32_t tm_wan_dpid : 4; /* bits 25:22 */
		ca_uint32_t tqm_port7_empty_wait_cnt_h : 5; /* bits 30:26 */
		ca_uint32_t keep_o_lspid_en_for_mc : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_ARB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_PER_COS_DONT_MARK_CTRL 0xf4301604
#define L2FE_ARB_PER_COS_DONT_MARK_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bitmap_dst_lan : 8; /* bits 7:0 */
		ca_uint32_t bitmap_dst_wan : 8; /* bits 15:8 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_PER_COS_DONT_MARK_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_ARB_TTL_TRAP 0xf4301608
#define L2FE_ARB_ARB_TTL_TRAP_dft 0x00000280

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cos : 3; /* bits 2:0 */
		ca_uint32_t ldpid : 6; /* bits 8:3 */
		ca_uint32_t keep_old : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_ARB_TTL_TRAP_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_ARB_CTRL_EXT 0xf430160c
#define L2FE_ARB_ARB_CTRL_EXT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mc_pkt_port_mmshp_chk_en : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_ARB_CTRL_EXT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_ARB_DEBUG 0xf4301610
#define L2FE_ARB_ARB_DEBUG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_ARB_DEBUG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS 0xf4301614
#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA 0xf4301618
#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdir_cos_vld : 1; /* bits 0:0 */
		ca_uint32_t rdir_cos : 3; /* bits 3:1 */
		ca_uint32_t rdir_ldpid : 6; /* bits 9:4 */
		ca_uint32_t rdir_en : 1; /* bits 10:10 */
		ca_uint32_t rdir_wan_dst : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS 0xf430161c
#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 25;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA 0xf4301620
#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdir_cos_vld : 1; /* bits 0:0 */
		ca_uint32_t rdir_cos : 3; /* bits 3:1 */
		ca_uint32_t rdir_ldpid : 6; /* bits 9:4 */
		ca_uint32_t rdir_en : 1; /* bits 10:10 */
		ca_uint32_t rdir_wan_dst : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS 0xf4301624
#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 25;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA 0xf4301628
#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flooding_pol_id : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS 0xf430162c
#define L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_DSCP_TE_MARK_TBL_DATA 0xf4301630
#define L2FE_ARB_DSCP_TE_MARK_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mark_value : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_MC_FIB_TBL_ACCESS 0xf4301634
#define L2FE_ARB_MC_FIB_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_MC_FIB_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_MC_FIB_TBL_DATA3 0xf4301638
#define L2FE_ARB_MC_FIB_TBL_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pol_en : 1; /* bits 0:0 */
		ca_uint32_t cos : 3; /* bits 3:1 */
		ca_uint32_t ldpid : 6; /* bits 9:4 */
		ca_uint32_t mac_sa_sel : 3; /* bits 12:10 */
		ca_uint32_t mac_sa_cmd : 1; /* bits 13:13 */
		ca_uint32_t permit_spid_en : 1; /* bits 14:14 */
		ca_uint32_t wan_dst : 1; /* bits 15:15 */
		ca_uint32_t cos_cmd : 1; /* bits 16:16 */
		ca_uint32_t keep_o_lspid : 1; /* bits 17:17 */
		ca_uint32_t ip_ttl_dec_cmd : 1; /* bits 18:18 */
		ca_uint32_t ip_ttl_zero_fwd_ctrl : 2; /* bits 20:19 */
		ca_uint32_t reserved : 1; /* bits 21:21 */
		ca_uint32_t rsrvd1 : 10;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_MC_FIB_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_MC_FIB_TBL_DATA2 0xf430163c
#define L2FE_ARB_MC_FIB_TBL_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vid : 5; /* bits 4:0 */
		ca_uint32_t vlan_cmd : 3; /* bits 7:5 */
		ca_uint32_t vlan_fltr_en : 1; /* bits 8:8 */
		ca_uint32_t mcgid : 10; /* bits 18:9 */
		ca_uint32_t mcgid_en : 1; /* bits 19:19 */
		ca_uint32_t pol_id : 9; /* bits 28:20 */
		ca_uint32_t pol_grp_id : 3; /* bits 31:29 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_MC_FIB_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_MC_FIB_TBL_DATA1 0xf4301640
#define L2FE_ARB_MC_FIB_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_da : 16; /* bits 15:0 */
		ca_uint32_t mac_cmd : 1; /* bits 16:16 */
		ca_uint32_t dei : 1; /* bits 17:17 */
		ca_uint32_t dei_cmd : 1; /* bits 18:18 */
		ca_uint32_t dot1p : 3; /* bits 21:19 */
		ca_uint32_t dot1p_cmd : 2; /* bits 23:22 */
		ca_uint32_t sc_ind : 1; /* bits 24:24 */
		ca_uint32_t vid : 7; /* bits 31:25 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_MC_FIB_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_MC_FIB_TBL_DATA0 0xf4301644
#define L2FE_ARB_MC_FIB_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_da : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_MC_FIB_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_FLOW_DBUF_TBL_ACCESS 0xf4301648
#define L2FE_ARB_FLOW_DBUF_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_FLOW_DBUF_TBL_DATA 0xf430164c
#define L2FE_ARB_FLOW_DBUF_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dbuf_flg_0 : 1; /* bits 0:0 */
		ca_uint32_t dbuf_flg_1 : 1; /* bits 1:1 */
		ca_uint32_t dbuf_flg_2 : 1; /* bits 2:2 */
		ca_uint32_t dbuf_flg_3 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_FLOW_DBUF_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_PORT_DBUF_TBL_ACCESS 0xf4301650
#define L2FE_ARB_PORT_DBUF_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 27;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_PORT_DBUF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_PORT_DBUF_TBL_DATA 0xf4301654
#define L2FE_ARB_PORT_DBUF_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dbuf_flg : 1; /* bits 0:0 */
		ca_uint32_t ldpid_vld : 1; /* bits 1:1 */
		ca_uint32_t ldpid : 6; /* bits 7:2 */
		ca_uint32_t lspid_vld : 1; /* bits 8:8 */
		ca_uint32_t lspid : 6; /* bits 14:9 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_PORT_DBUF_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_PDPID_MAP_TBL_ACCESS 0xf4301658
#define L2FE_ARB_PDPID_MAP_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_PDPID_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_ARB_PDPID_MAP_TBL_DATA 0xf430165c
#define L2FE_ARB_PDPID_MAP_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pdpid : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_ARB_PDPID_MAP_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ARB */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_ARB_ARB_CTRL_t ARB_CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_ARB_PER_COS_DONT_MARK_CTRL_t
	  PER_COS_DONT_MARK_CTRL; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_ARB_ARB_TTL_TRAP_t ARB_TTL_TRAP; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_ARB_ARB_CTRL_EXT_t ARB_CTRL_EXT; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_ARB_ARB_DEBUG_t ARB_DEBUG; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t
	  REDIR_LDPID_CONFIG_TBL_ACCESS; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t
	  REDIR_LDPID_CONFIG_TBL_DATA; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t
	  REDIR_DROP_SRC_CONFIG_TBL_ACCESS; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t
	  REDIR_DROP_SRC_CONFIG_TBL_DATA; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t
	  NON_KNOWN_POL_MAP_TBL_ACCESS; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t
	  NON_KNOWN_POL_MAP_TBL_DATA; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t
	  DSCP_TE_MARK_TBL_ACCESS; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t DSCP_TE_MARK_TBL_DATA; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_ARB_MC_FIB_TBL_ACCESS_t MC_FIB_TBL_ACCESS; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_ARB_MC_FIB_TBL_DATA3_t MC_FIB_TBL_DATA3; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_ARB_MC_FIB_TBL_DATA2_t MC_FIB_TBL_DATA2; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_ARB_MC_FIB_TBL_DATA1_t MC_FIB_TBL_DATA1; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_ARB_MC_FIB_TBL_DATA0_t MC_FIB_TBL_DATA0; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t FLOW_DBUF_TBL_ACCESS; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_ARB_FLOW_DBUF_TBL_DATA_t FLOW_DBUF_TBL_DATA; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_ARB_PORT_DBUF_TBL_ACCESS_t PORT_DBUF_TBL_ACCESS; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2FE_ARB_PORT_DBUF_TBL_DATA_t PORT_DBUF_TBL_DATA; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2FE_ARB_PDPID_MAP_TBL_ACCESS_t PDPID_MAP_TBL_ACCESS; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L2FE_ARB_PDPID_MAP_TBL_DATA_t PDPID_MAP_TBL_DATA; /* addr: 0x0000005c */
} APB0_L2FE_ARB_t;
#endif /* !__ASSEMBLER__ */

/*
 * PE
 */

#define L2FE_PE_CTRL 0xf4301700
#define L2FE_PE_CTRL_dft 0x000000f0

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2_padding_dis : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t wan_top_dei_keep_old : 1; /* bits 4:4 */
		ca_uint32_t lan_top_dei_keep_old : 1; /* bits 5:5 */
		ca_uint32_t wan_inner_dei_keep_old : 1; /* bits 6:6 */
		ca_uint32_t lan_inner_dei_keep_old : 1; /* bits 7:7 */
		ca_uint32_t enhance_tpid_mode : 1; /* bits 8:8 */
		ca_uint32_t rsrvd2 : 23;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_CFG_VLAN_TPID_A 0xf4301704
#define L2FE_PE_CFG_VLAN_TPID_A_dft 0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_CFG_VLAN_TPID_A_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_CFG_VLAN_TPID_B 0xf4301708
#define L2FE_PE_CFG_VLAN_TPID_B_dft 0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_CFG_VLAN_TPID_B_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_CFG_VLAN_TPID_C 0xf430170c
#define L2FE_PE_CFG_VLAN_TPID_C_dft 0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_CFG_VLAN_TPID_C_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_CFG_VLAN_TPID_D 0xf4301710
#define L2FE_PE_CFG_VLAN_TPID_D_dft 0x00008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_CFG_VLAN_TPID_D_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_LOW_0 0xf4301714
#define L2FE_PE_MY_MAC_LOW_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_LOW_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_HIGH_0 0xf4301718
#define L2FE_PE_MY_MAC_HIGH_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_HIGH_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_LOW_1 0xf430171c
#define L2FE_PE_MY_MAC_LOW_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_LOW_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_HIGH_1 0xf4301720
#define L2FE_PE_MY_MAC_HIGH_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_HIGH_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_LOW_2 0xf4301724
#define L2FE_PE_MY_MAC_LOW_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_LOW_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_HIGH_2 0xf4301728
#define L2FE_PE_MY_MAC_HIGH_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_HIGH_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_LOW_3 0xf430172c
#define L2FE_PE_MY_MAC_LOW_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_LOW_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_HIGH_3 0xf4301730
#define L2FE_PE_MY_MAC_HIGH_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_HIGH_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_LOW_4 0xf4301734
#define L2FE_PE_MY_MAC_LOW_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_LOW_4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_HIGH_4 0xf4301738
#define L2FE_PE_MY_MAC_HIGH_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_HIGH_4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_LOW_5 0xf430173c
#define L2FE_PE_MY_MAC_LOW_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_LOW_5_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_HIGH_5 0xf4301740
#define L2FE_PE_MY_MAC_HIGH_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_HIGH_5_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_LOW_6 0xf4301744
#define L2FE_PE_MY_MAC_LOW_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_LOW_6_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_HIGH_6 0xf4301748
#define L2FE_PE_MY_MAC_HIGH_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_HIGH_6_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_LOW_7 0xf430174c
#define L2FE_PE_MY_MAC_LOW_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_LOW_7_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_MY_MAC_HIGH_7 0xf4301750
#define L2FE_PE_MY_MAC_HIGH_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_MY_MAC_HIGH_7_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_CMD_FF_CTL_REG 0xf4301754
#define L2FE_PE_CMD_FF_CTL_REG_dft 0x00004343

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t low_thr_mir : 4; /* bits 3:0 */
		ca_uint32_t high_thr_mir : 4; /* bits 7:4 */
		ca_uint32_t low_thr_ppl : 4; /* bits 11:8 */
		ca_uint32_t high_thr_ppl : 4; /* bits 15:12 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_CMD_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_CMD_FF_STS_REG 0xf4301758
#define L2FE_PE_CMD_FF_STS_REG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t overflow_ind_mir : 1; /* bits 0:0 */
		ca_uint32_t overflow_ind_ppl : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_CMD_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_CMD_FF_CMD_CNT 0xf430175c
#define L2FE_PE_CMD_FF_CMD_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num_mir : 4; /* bits 3:0 */
		ca_uint32_t num_ppl : 4; /* bits 7:4 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_CMD_FF_CMD_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_TM_INTERFACE_PKT_CNT 0xf4301760
#define L2FE_PE_TM_INTERFACE_PKT_CNT_dft 0x80000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_TM_INTERFACE_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_DROP_CNT_TBL_CLR 0xf4301764
#define L2FE_PE_DROP_CNT_TBL_CLR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t set : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_DROP_CNT_TBL_CLR_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_HEADER_A_LOW 0xf4301768
#define L2FE_PE_HEADER_A_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_HEADER_A_MID 0xf430176c
#define L2FE_PE_HEADER_A_MID_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_HEADER_A_MID_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_HEADER_A_HI 0xf4301770
#define L2FE_PE_HEADER_A_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_DROP_CNT_GEAR_FF_CNT 0xf4301774
#define L2FE_PE_DROP_CNT_GEAR_FF_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_DROP_CNT_GEAR_FF_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_DROP_CNT_GEAR_FF_STS 0xf4301778
#define L2FE_PE_DROP_CNT_GEAR_FF_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ovfl : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_DROP_CNT_GEAR_FF_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_DEBUG 0xf430177c
#define L2FE_PE_DEBUG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bus_sel : 4; /* bits 3:0 */
		ca_uint32_t fe2tm_pkt_cnt_wrap_en : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_DEBUG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_DROP_STTS_ACCESS 0xf4301780
#define L2FE_PE_DROP_STTS_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_DROP_STTS_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_DROP_STTS_DATA 0xf4301784
#define L2FE_PE_DROP_STTS_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_DROP_STTS_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS 0xf4301788
#define L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_PE_TPID_SEL_CONFIG_TBL_DATA 0xf430178c
#define L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctag : 2; /* bits 1:0 */
		ca_uint32_t stag : 2; /* bits 3:2 */
		ca_uint32_t inner_ctag : 2; /* bits 5:4 */
		ca_uint32_t inner_stag : 2; /* bits 7:6 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_PE_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_PE_CFG_VLAN_TPID_A_t CFG_VLAN_TPID_A; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_PE_CFG_VLAN_TPID_B_t CFG_VLAN_TPID_B; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_PE_CFG_VLAN_TPID_C_t CFG_VLAN_TPID_C; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_PE_CFG_VLAN_TPID_D_t CFG_VLAN_TPID_D; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_PE_MY_MAC_LOW_0_t MY_MAC_LOW_0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_PE_MY_MAC_HIGH_0_t MY_MAC_HIGH_0; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_PE_MY_MAC_LOW_1_t MY_MAC_LOW_1; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_PE_MY_MAC_HIGH_1_t MY_MAC_HIGH_1; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_PE_MY_MAC_LOW_2_t MY_MAC_LOW_2; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_PE_MY_MAC_HIGH_2_t MY_MAC_HIGH_2; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_PE_MY_MAC_LOW_3_t MY_MAC_LOW_3; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_PE_MY_MAC_HIGH_3_t MY_MAC_HIGH_3; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_PE_MY_MAC_LOW_4_t MY_MAC_LOW_4; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_PE_MY_MAC_HIGH_4_t MY_MAC_HIGH_4; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_PE_MY_MAC_LOW_5_t MY_MAC_LOW_5; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_PE_MY_MAC_HIGH_5_t MY_MAC_HIGH_5; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_PE_MY_MAC_LOW_6_t MY_MAC_LOW_6; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_PE_MY_MAC_HIGH_6_t MY_MAC_HIGH_6; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_PE_MY_MAC_LOW_7_t MY_MAC_LOW_7; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_PE_MY_MAC_HIGH_7_t MY_MAC_HIGH_7; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2FE_PE_CMD_FF_CTL_REG_t CMD_FF_CTL_REG; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2FE_PE_CMD_FF_STS_REG_t CMD_FF_STS_REG; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L2FE_PE_CMD_FF_CMD_CNT_t CMD_FF_CMD_CNT; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L2FE_PE_TM_INTERFACE_PKT_CNT_t TM_INTERFACE_PKT_CNT; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L2FE_PE_DROP_CNT_TBL_CLR_t DROP_CNT_TBL_CLR; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L2FE_PE_HEADER_A_LOW_t HEADER_A_LOW; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L2FE_PE_HEADER_A_MID_t HEADER_A_MID; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L2FE_PE_HEADER_A_HI_t HEADER_A_HI; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L2FE_PE_DROP_CNT_GEAR_FF_CNT_t DROP_CNT_GEAR_FF_CNT; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L2FE_PE_DROP_CNT_GEAR_FF_STS_t DROP_CNT_GEAR_FF_STS; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L2FE_PE_DEBUG_t DEBUG; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L2FE_PE_DROP_STTS_ACCESS_t DROP_STTS_ACCESS; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L2FE_PE_DROP_STTS_DATA_t DROP_STTS_DATA; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t
	  TPID_SEL_CONFIG_TBL_ACCESS; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t
	  TPID_SEL_CONFIG_TBL_DATA; /* addr: 0x0000008c */
} APB0_L2FE_PE_t;
#endif /* !__ASSEMBLER__ */

/*
 * LF
 */

#define L2FE_LF_THRESHOLD 0xf4301900
#define L2FE_LF_THRESHOLD_dft 0x0001d8b4

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t low : 9; /* bits 8:0 */
		ca_uint32_t high : 9; /* bits 17:9 */
		ca_uint32_t rsrvd1 : 14;
	} bf;
	ca_uint32_t wrd;
} L2FE_LF_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_LF_CNT 0xf4301904
#define L2FE_LF_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t entry_cnt : 9; /* bits 8:0 */
		ca_uint32_t seg_cnt : 7; /* bits 15:9 */
		ca_uint32_t extra_store_cnt : 2; /* bits 17:16 */
		ca_uint32_t data_ltched : 1; /* bits 18:18 */
		ca_uint32_t rsrvd1 : 13;
	} bf;
	ca_uint32_t wrd;
} L2FE_LF_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_LF_STS 0xf4301908
#define L2FE_LF_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ovfl : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_LF_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_LF_DEBUG 0xf430190c
#define L2FE_LF_DEBUG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_LF_DEBUG_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LF */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_LF_THRESHOLD_t THRESHOLD; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_LF_CNT_t CNT; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_LF_STS_t STS; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_LF_DEBUG_t DEBUG; /* addr: 0x0000000c */
} APB0_L2FE_LF_t;
#endif /* !__ASSEMBLER__ */

/*
 * VE
 */

#define L2FE_VE_DEBUG_BUS 0xf4301a00
#define L2FE_VE_DEBUG_BUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 2; /* bits 1:0 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_SVL_IDX_ACCESS 0xf4301a04
#define L2FE_VE_WAN_SVL_IDX_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 18;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_SVL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_SVL_IDX_DATA 0xf4301a08
#define L2FE_VE_WAN_SVL_IDX_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_svl_idx_entry_vld : 1; /* bits 0:0 */
		ca_uint32_t wan_svl_idx_fib_idx : 7; /* bits 7:1 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_SVL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_SVL_FIB_ACCESS 0xf4301a0c
#define L2FE_VE_WAN_SVL_FIB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_SVL_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_SVL_FIB_DATA3 0xf4301a10
#define L2FE_VE_WAN_SVL_FIB_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_svl_fib_vid : 8; /* bits 7:0 */
		ca_uint32_t wan_svl_fib_do_inner_vid_lookup : 1; /* bits 8:8 */
		ca_uint32_t wan_svl_fib_reserved : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_SVL_FIB_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_SVL_FIB_DATA2 0xf4301a14
#define L2FE_VE_WAN_SVL_FIB_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_svl_fib_dscp : 6; /* bits 5:0 */
		ca_uint32_t wan_svl_fib_802_1p : 3; /* bits 8:6 */
		ca_uint32_t wan_svl_fib_ldpid_vld : 1; /* bits 9:9 */
		ca_uint32_t wan_svl_fib_ldpid : 6; /* bits 15:10 */
		ca_uint32_t wan_svl_fib_mc_vlan_ind : 1; /* bits 16:16 */
		ca_uint32_t wan_svl_fib_stp_mode : 2; /* bits 18:17 */
		ca_uint32_t wan_svl_fib_inner_cmd_valid : 1; /* bits 19:19 */
		ca_uint32_t wan_svl_fib_innervid_usel2 : 1; /* bits 20:20 */
		ca_uint32_t wan_svl_fib_inner_vlan_cmd : 2; /* bits 22:21 */
		ca_uint32_t wan_svl_fib_top_cmd_valid : 1; /* bits 23:23 */
		ca_uint32_t wan_svl_fib_topvid_usel2 : 1; /* bits 24:24 */
		ca_uint32_t wan_svl_fib_top_vlan_cmd : 2; /* bits 26:25 */
		ca_uint32_t wan_svl_fib_sc_ind : 1; /* bits 27:27 */
		ca_uint32_t wan_svl_fib_vid : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_SVL_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_SVL_FIB_DATA1 0xf4301a18
#define L2FE_VE_WAN_SVL_FIB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_svl_fib_vl_group_id : 10; /* bits 9:0 */
		ca_uint32_t wan_svl_fib_da_sa_swap : 1; /* bits 10:10 */
		ca_uint32_t wan_svl_fib_permit : 1; /* bits 11:11 */
		ca_uint32_t wan_svl_fib_markdown_en : 1; /* bits 12:12 */
		ca_uint32_t wan_svl_fib_flowid_valid : 1; /* bits 13:13 */
		ca_uint32_t wan_svl_fib_flowid : 12; /* bits 25:14 */
		ca_uint32_t wan_svl_fib_cos_valid : 1; /* bits 26:26 */
		ca_uint32_t wan_svl_fib_dscp_valid : 1; /* bits 27:27 */
		ca_uint32_t wan_svl_fib_802_1p_valid : 1; /* bits 28:28 */
		ca_uint32_t wan_svl_fib_cos : 3; /* bits 31:29 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_SVL_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_SVL_FIB_DATA0 0xf4301a1c
#define L2FE_VE_WAN_SVL_FIB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_svl_fib_egress_top_untag_bm : 16; /* bits 15:0 */
		ca_uint32_t wan_svl_fib_membership_bm : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_SVL_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_CVL_IDX_ACCESS 0xf4301a20
#define L2FE_VE_WAN_CVL_IDX_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 18;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_CVL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_CVL_IDX_DATA 0xf4301a24
#define L2FE_VE_WAN_CVL_IDX_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_cvl_idx_entry_vld : 1; /* bits 0:0 */
		ca_uint32_t wan_cvl_idx_fib_idx : 7; /* bits 7:1 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_CVL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_CVL_FIB_ACCESS 0xf4301a28
#define L2FE_VE_WAN_CVL_FIB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_CVL_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_CVL_FIB_DATA3 0xf4301a2c
#define L2FE_VE_WAN_CVL_FIB_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_cvl_fib_vid : 8; /* bits 7:0 */
		ca_uint32_t wan_cvl_fib_reserved : 2; /* bits 9:8 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_CVL_FIB_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_CVL_FIB_DATA2 0xf4301a30
#define L2FE_VE_WAN_CVL_FIB_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_cvl_fib_dscp : 6; /* bits 5:0 */
		ca_uint32_t wan_cvl_fib_802_1p : 3; /* bits 8:6 */
		ca_uint32_t wan_cvl_fib_ldpid_vld : 1; /* bits 9:9 */
		ca_uint32_t wan_cvl_fib_ldpid : 6; /* bits 15:10 */
		ca_uint32_t wan_cvl_fib_mc_vlan_ind : 1; /* bits 16:16 */
		ca_uint32_t wan_cvl_fib_stp_mode : 2; /* bits 18:17 */
		ca_uint32_t wan_cvl_fib_inner_cmd_valid : 1; /* bits 19:19 */
		ca_uint32_t wan_cvl_fib_innervid_usel2 : 1; /* bits 20:20 */
		ca_uint32_t wan_cvl_fib_inner_vlan_cmd : 2; /* bits 22:21 */
		ca_uint32_t wan_cvl_fib_top_cmd_valid : 1; /* bits 23:23 */
		ca_uint32_t wan_cvl_fib_topvid_usel2 : 1; /* bits 24:24 */
		ca_uint32_t wan_cvl_fib_top_vlan_cmd : 2; /* bits 26:25 */
		ca_uint32_t wan_cvl_fib_sc_ind : 1; /* bits 27:27 */
		ca_uint32_t wan_cvl_fib_vid : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_CVL_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_CVL_FIB_DATA1 0xf4301a34
#define L2FE_VE_WAN_CVL_FIB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_cvl_fib_vl_group_id : 10; /* bits 9:0 */
		ca_uint32_t wan_cvl_fib_da_sa_swap : 1; /* bits 10:10 */
		ca_uint32_t wan_cvl_fib_permit : 1; /* bits 11:11 */
		ca_uint32_t wan_cvl_fib_markdown_en : 1; /* bits 12:12 */
		ca_uint32_t wan_cvl_fib_flowid_valid : 1; /* bits 13:13 */
		ca_uint32_t wan_cvl_fib_flowid : 12; /* bits 25:14 */
		ca_uint32_t wan_cvl_fib_cos_valid : 1; /* bits 26:26 */
		ca_uint32_t wan_cvl_fib_dscp_valid : 1; /* bits 27:27 */
		ca_uint32_t wan_cvl_fib_802_1p_valid : 1; /* bits 28:28 */
		ca_uint32_t wan_cvl_fib_cos : 3; /* bits 31:29 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_CVL_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_WAN_CVL_FIB_DATA0 0xf4301a38
#define L2FE_VE_WAN_CVL_FIB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wan_cvl_fib_egress_top_untag_bm : 16; /* bits 15:0 */
		ca_uint32_t wan_cvl_fib_membership_bm : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_WAN_CVL_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_LAN_VL_IDX_ACCESS 0xf4301a3c
#define L2FE_VE_LAN_VL_IDX_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 18;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_LAN_VL_IDX_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_LAN_VL_IDX_DATA 0xf4301a40
#define L2FE_VE_LAN_VL_IDX_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lan_vl_idx_entry_vld : 1; /* bits 0:0 */
		ca_uint32_t lan_vl_idx_fib_idx : 7; /* bits 7:1 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_LAN_VL_IDX_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_LAN_VL_FIB_ACCESS 0xf4301a44
#define L2FE_VE_LAN_VL_FIB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_LAN_VL_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_LAN_VL_FIB_DATA3 0xf4301a48
#define L2FE_VE_LAN_VL_FIB_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lan_vl_fib_vid : 6; /* bits 5:0 */
		ca_uint32_t lan_vl_fib_reserved : 4; /* bits 9:6 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_LAN_VL_FIB_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_LAN_VL_FIB_DATA2 0xf4301a4c
#define L2FE_VE_LAN_VL_FIB_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lan_vl_fib_dscp : 6; /* bits 5:0 */
		ca_uint32_t lan_vl_fib_802_1p : 3; /* bits 8:6 */
		ca_uint32_t lan_vl_fib_ldpid_vld : 1; /* bits 9:9 */
		ca_uint32_t lan_vl_fib_ldpid : 6; /* bits 15:10 */
		ca_uint32_t lan_vl_fib_mc_vlan_ind : 1; /* bits 16:16 */
		ca_uint32_t lan_vl_fib_stp_mode : 2; /* bits 18:17 */
		ca_uint32_t lan_vl_fib_inner_cmd_valid : 1; /* bits 19:19 */
		ca_uint32_t lan_vl_fib_inner_vlan_cmd : 2; /* bits 21:20 */
		ca_uint32_t lan_vl_fib_top_cmd_valid : 1; /* bits 22:22 */
		ca_uint32_t lan_vl_fib_top_vlan_cmd : 2; /* bits 24:23 */
		ca_uint32_t lan_vl_fib_sc_ind : 1; /* bits 25:25 */
		ca_uint32_t lan_vl_fib_vid : 6; /* bits 31:26 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_LAN_VL_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_LAN_VL_FIB_DATA1 0xf4301a50
#define L2FE_VE_LAN_VL_FIB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lan_vl_fib_vl_group_id : 10; /* bits 9:0 */
		ca_uint32_t lan_vl_fib_da_sa_swap : 1; /* bits 10:10 */
		ca_uint32_t lan_vl_fib_permit : 1; /* bits 11:11 */
		ca_uint32_t lan_vl_fib_markdown_en : 1; /* bits 12:12 */
		ca_uint32_t lan_vl_fib_flowid_valid : 1; /* bits 13:13 */
		ca_uint32_t lan_vl_fib_flowid : 12; /* bits 25:14 */
		ca_uint32_t lan_vl_fib_cos_valid : 1; /* bits 26:26 */
		ca_uint32_t lan_vl_fib_dscp_valid : 1; /* bits 27:27 */
		ca_uint32_t lan_vl_fib_802_1p_valid : 1; /* bits 28:28 */
		ca_uint32_t lan_vl_fib_cos : 3; /* bits 31:29 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_LAN_VL_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_VE_LAN_VL_FIB_DATA0 0xf4301a54
#define L2FE_VE_LAN_VL_FIB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lan_vl_fib_egress_top_untag_bm : 16; /* bits 15:0 */
		ca_uint32_t lan_vl_fib_membership_bm : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2FE_VE_LAN_VL_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* VE */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_VE_DEBUG_BUS_t DEBUG_BUS; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_VE_WAN_SVL_IDX_ACCESS_t WAN_SVL_IDX_ACCESS; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_VE_WAN_SVL_IDX_DATA_t WAN_SVL_IDX_DATA; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_VE_WAN_SVL_FIB_ACCESS_t WAN_SVL_FIB_ACCESS; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_VE_WAN_SVL_FIB_DATA3_t WAN_SVL_FIB_DATA3; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_VE_WAN_SVL_FIB_DATA2_t WAN_SVL_FIB_DATA2; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_VE_WAN_SVL_FIB_DATA1_t WAN_SVL_FIB_DATA1; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_VE_WAN_SVL_FIB_DATA0_t WAN_SVL_FIB_DATA0; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_VE_WAN_CVL_IDX_ACCESS_t WAN_CVL_IDX_ACCESS; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_VE_WAN_CVL_IDX_DATA_t WAN_CVL_IDX_DATA; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_VE_WAN_CVL_FIB_ACCESS_t WAN_CVL_FIB_ACCESS; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_VE_WAN_CVL_FIB_DATA3_t WAN_CVL_FIB_DATA3; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_VE_WAN_CVL_FIB_DATA2_t WAN_CVL_FIB_DATA2; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_VE_WAN_CVL_FIB_DATA1_t WAN_CVL_FIB_DATA1; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_VE_WAN_CVL_FIB_DATA0_t WAN_CVL_FIB_DATA0; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_VE_LAN_VL_IDX_ACCESS_t LAN_VL_IDX_ACCESS; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_VE_LAN_VL_IDX_DATA_t LAN_VL_IDX_DATA; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_VE_LAN_VL_FIB_ACCESS_t LAN_VL_FIB_ACCESS; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_VE_LAN_VL_FIB_DATA3_t LAN_VL_FIB_DATA3; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_VE_LAN_VL_FIB_DATA2_t LAN_VL_FIB_DATA2; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_VE_LAN_VL_FIB_DATA1_t LAN_VL_FIB_DATA1; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2FE_VE_LAN_VL_FIB_DATA0_t LAN_VL_FIB_DATA0; /* addr: 0x00000054 */
} APB0_L2FE_VE_t;
#endif /* !__ASSEMBLER__ */

/*
 * CLE
 */

#define L2FE_CLE_CTRL 0xf4301b00
#define L2FE_CLE_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t igr_use_frst_hit : 1; /* bits 0:0 */
		ca_uint32_t egr_use_frst_hit : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_CONFG_STTS1 0xf4301b04
#define L2FE_CLE_CONFG_STTS1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t igr_configured_length_over_size : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_CONFG_STTS1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_CONFG_STTS2 0xf4301b08
#define L2FE_CLE_CONFG_STTS2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t egr_configured_length_over_size : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_CONFG_STTS2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_DEBUG 0xf4301b0c
#define L2FE_CLE_DEBUG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t igr_cls_bus_sel : 2; /* bits 1:0 */
		ca_uint32_t egr_cls_bus_sel : 2; /* bits 3:2 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_DEBUG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_ACCESS 0xf4301b10
#define L2FE_CLE_IGR_KEY_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA12 0xf4301b14
#define L2FE_CLE_IGR_KEY_DATA12_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_reserved : 8; /* bits 7:0 */
		ca_uint32_t cl_key_orhr_ipv6_valid : 1; /* bits 8:8 */
		ca_uint32_t cl_key_entry_type : 2; /* bits 10:9 */
		ca_uint32_t cl_key_valid : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 20;
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_l4_ext_flags : 2; /* bits 1:0 */
		ca_uint32_t cl_key_orhr_ipv6e_tos_mask_l : 3; /* bits 4:2 */
		ca_uint32_t cl_key_orhr_ipv6e_reserved : 3; /* bits 7:5 */
		ca_uint32_t cl_key_orhr_ipv6e_idle_field : 4; /* bits 11:8 */
		ca_uint32_t rsrvd1 : 20;
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_reserved : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_rule_type_1 : 2; /* bits 5:4 */
		ca_uint32_t cl_key_tre_rule_type_0 : 2; /* bits 7:6 */
		ca_uint32_t cl_key_tre_rule_hinge : 1; /* bits 8:8 */
		ca_uint32_t cl_key_tre_rule_idle_field : 3; /* bits 11:9 */
		ca_uint32_t rsrvd1 : 20;
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_reserved : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l2rl3r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_reserved : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l2rcmr_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_ext_flags : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_l3rl2r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_ext_flags : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_l3rl3r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_ext_flags : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_l3rcmr_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_tos_mask_l : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_cmrl2r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_tos_mask_l : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_cmrl3r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_tos_mask_l : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_cmrcmr_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_rule15_valid : 1; /* bits 0:0 */
		ca_uint32_t cl_key_stre_rule1_0_ctrl : 1; /* bits 1:1 */
		ca_uint32_t cl_key_stre_rule3_2_ctrl : 1; /* bits 2:2 */
		ca_uint32_t cl_key_stre_rule5_4_ctrl : 1; /* bits 3:3 */
		ca_uint32_t cl_key_stre_rule7_6_ctrl : 1; /* bits 4:4 */
		ca_uint32_t cl_key_stre_rule9_8_ctrl : 1; /* bits 5:5 */
		ca_uint32_t cl_key_stre_rule11_10_ctrl : 1; /* bits 6:6 */
		ca_uint32_t cl_key_stre_rule13_12_ctrl : 1; /* bits 7:7 */
		ca_uint32_t cl_key_stre_rule15_14_ctrl : 1; /* bits 8:8 */
		ca_uint32_t cl_key_stre_idle_field : 3; /* bits 11:9 */
		ca_uint32_t rsrvd1 : 20;
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA12_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA11 0xf4301b18
#define L2FE_CLE_IGR_KEY_DATA11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_mac_da : 8; /* bits 7:0 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn_mask : 1; /* bits 8:8 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn : 2; /* bits 10:9 */
		ca_uint32_t cl_key_orhr_ipv4e_pol_id_abbr_mask : 1; /* bits 11:11 */
		ca_uint32_t cl_key_orhr_ipv4e_pol_id_abbr : 9; /* bits 20:12 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_dei_mask : 1; /* bits 21:21 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_dei : 1; /* bits 22:22 */
		ca_uint32_t cl_key_orhr_ipv4e_top_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_orhr_ipv4e_top_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_flags_op : 1; /* bits 25:25 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_ext_flags : 3; /* bits 28:26 */
		ca_uint32_t cl_key_orhr_ipv4e_tos_mask_l : 3; /* bits 31:29 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 27; /* bits 26:0 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn_mask : 1; /* bits 27:27 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn : 2; /* bits 29:28 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_flags_op : 1; /* bits 30:30 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_ext_flags : 1; /* bits 31:31 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 24; /* bits 23:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_pol_id_use_inner_vid : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_dei_mask : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_dei : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rl2r_1_reserved : 3; /* bits 31:29 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 24; /* bits 23:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_pol_id_use_inner_vid : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_dei_mask : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_dei : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rl3r_1_reserved : 3; /* bits 31:29 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 24; /* bits 23:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_pol_id_use_inner_vid : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_dei_mask : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_dei : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rcmr_1_reserved : 3; /* bits 31:29 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_l3rl2r_1_pol_id_use_inner_vid : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_dei_mask : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_dei : 1; /* bits 29:29 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags_op : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_ext_flags : 1; /* bits 31:31 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_l3rl3r_1_pol_id_use_inner_vid : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_dei_mask : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_dei : 1; /* bits 29:29 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags_op : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_ext_flags : 1; /* bits 31:31 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_l3rcmr_1_pol_id_use_inner_vid : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_dei_mask : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_dei : 1; /* bits 29:29 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags_op : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_ext_flags : 1; /* bits 31:31 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags_op : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_ext_flags : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_tos_mask_l : 1; /* bits 31:31 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags_op : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_ext_flags : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_tos_mask_l : 1; /* bits 31:31 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags_op : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_ext_flags : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_tos_mask_l : 1; /* bits 31:31 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_14_sc_ind : 1; /* bits 0:0 */
		ca_uint32_t cl_key_stre_vlanid_14 : 12; /* bits 12:1 */
		ca_uint32_t cl_key_stre_rule14_valid : 1; /* bits 13:13 */
		ca_uint32_t cl_key_stre_mask_15 : 2; /* bits 15:14 */
		ca_uint32_t cl_key_stre_dot1p_15 : 3; /* bits 18:16 */
		ca_uint32_t cl_key_stre_vlanid_15_sc_ind : 1; /* bits 19:19 */
		ca_uint32_t cl_key_stre_vlanid_15 : 12; /* bits 31:20 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA11_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA10 0xf4301b1c
#define L2FE_CLE_IGR_KEY_DATA10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_mac_da : 32; /* bits 31:0 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 8; /* bits 7:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 24; /* bits 31:8 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 8; /* bits 7:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 24; /* bits 31:8 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 8; /* bits 7:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 24; /* bits 31:8 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 10; /* bits 31:22 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 10; /* bits 31:22 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 10; /* bits 31:22 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 26; /* bits 31:6 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 26; /* bits 31:6 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 26; /* bits 31:6 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_12 : 7; /* bits 6:0 */
		ca_uint32_t cl_key_stre_rule12_valid : 1; /* bits 7:7 */
		ca_uint32_t cl_key_stre_mask_13 : 2; /* bits 9:8 */
		ca_uint32_t cl_key_stre_dot1p_13 : 3; /* bits 12:10 */
		ca_uint32_t cl_key_stre_vlanid_13_sc_ind : 1; /* bits 13:13 */
		ca_uint32_t cl_key_stre_vlanid_13 : 12; /* bits 25:14 */
		ca_uint32_t cl_key_stre_rule13_valid : 1; /* bits 26:26 */
		ca_uint32_t cl_key_stre_mask_14 : 2; /* bits 28:27 */
		ca_uint32_t cl_key_stre_dot1p_14 : 3; /* bits 31:29 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA10_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA9 0xf4301b20
#define L2FE_CLE_IGR_KEY_DATA9_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24; /* bits 23:0 */
		ca_uint32_t cl_key_orhr_ipv4e_mac_da : 8; /* bits 31:24 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 32; /* bits 31:0 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 32; /* bits 31:0 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 32; /* bits 31:0 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags : 3; /* bits 5:3 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_fragment : 1; /* bits 6:6 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_option : 1; /* bits 7:7 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ip_tos : 6; /* bits 13:8 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ip_pt : 8; /* bits 21:14 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 10; /* bits 31:22 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags : 3; /* bits 5:3 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_fragment : 1; /* bits 6:6 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_option : 1; /* bits 7:7 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ip_tos : 6; /* bits 13:8 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ip_pt : 8; /* bits 21:14 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 10; /* bits 31:22 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags : 3; /* bits 5:3 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_fragment : 1; /* bits 6:6 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_option : 1; /* bits 7:7 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ip_tos : 6; /* bits 13:8 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ip_pt : 8; /* bits 21:14 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 10; /* bits 31:22 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 26; /* bits 31:6 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 26; /* bits 31:6 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 26; /* bits 31:6 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_10 : 1; /* bits 0:0 */
		ca_uint32_t cl_key_stre_rule10_valid : 1; /* bits 1:1 */
		ca_uint32_t cl_key_stre_mask_11 : 2; /* bits 3:2 */
		ca_uint32_t cl_key_stre_dot1p_11 : 3; /* bits 6:4 */
		ca_uint32_t cl_key_stre_vlanid_11_sc_ind : 1; /* bits 7:7 */
		ca_uint32_t cl_key_stre_vlanid_11 : 12; /* bits 19:8 */
		ca_uint32_t cl_key_stre_rule11_valid : 1; /* bits 20:20 */
		ca_uint32_t cl_key_stre_mask_12 : 2; /* bits 22:21 */
		ca_uint32_t cl_key_stre_dot1p_12 : 3; /* bits 25:23 */
		ca_uint32_t cl_key_stre_vlanid_12_sc_ind : 1; /* bits 26:26 */
		ca_uint32_t cl_key_stre_vlanid_12 : 5; /* bits 31:27 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA9_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA8 0xf4301b24
#define L2FE_CLE_IGR_KEY_DATA8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_top_vid : 8; /* bits 7:0 */
		ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24; /* bits 31:8 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid : 11; /* bits 10:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_sc_ind : 1; /* bits 11:11 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_vid : 12; /* bits 23:12 */
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 8; /* bits 31:24 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid : 11; /* bits 10:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_sc_ind : 1; /* bits 11:11 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_vid : 12; /* bits 23:12 */
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 8; /* bits 31:24 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid : 11; /* bits 10:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_sc_ind : 1; /* bits 11:11 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_vid : 12; /* bits 23:12 */
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 8; /* bits 31:24 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_802_1p : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_sc_ind : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_vid : 12; /* bits 16:5 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_sc_ind : 1; /* bits 17:17 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_vid : 12; /* bits 29:18 */
		ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code : 2; /* bits 31:30 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_802_1p : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_sc_ind : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_vid : 12; /* bits 16:5 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_sc_ind : 1; /* bits 17:17 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_vid : 12; /* bits 29:18 */
		ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code : 2; /* bits 31:30 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_802_1p : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_sc_ind : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_vid : 12; /* bits 16:5 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_sc_ind : 1; /* bits 17:17 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_vid : 12; /* bits 29:18 */
		ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code : 2; /* bits 31:30 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_vid : 12; /* bits 13:2 */
		ca_uint32_t cl_key_tre_cmrl2r_1_special_pkt_code : 5; /* bits 18:14 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags : 3; /* bits 21:19 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_fragment : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_option : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ip_tos : 6; /* bits 29:24 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt : 2; /* bits 31:30 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_vid : 12; /* bits 13:2 */
		ca_uint32_t cl_key_tre_cmrl3r_1_special_pkt_code : 5; /* bits 18:14 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags : 3; /* bits 21:19 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_fragment : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_option : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ip_tos : 6; /* bits 29:24 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt : 2; /* bits 31:30 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_vid : 12; /* bits 13:2 */
		ca_uint32_t cl_key_tre_cmrcmr_1_special_pkt_code : 5; /* bits 18:14 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags : 3; /* bits 21:19 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_fragment : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_option : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ip_tos : 6; /* bits 29:24 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt : 2; /* bits 31:30 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_dot1p_9 : 1; /* bits 0:0 */
		ca_uint32_t cl_key_stre_vlanid_9_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t cl_key_stre_vlanid_9 : 12; /* bits 13:2 */
		ca_uint32_t cl_key_stre_rule9_valid : 1; /* bits 14:14 */
		ca_uint32_t cl_key_stre_mask_10 : 2; /* bits 16:15 */
		ca_uint32_t cl_key_stre_dot1p_10 : 3; /* bits 19:17 */
		ca_uint32_t cl_key_stre_vlanid_10_sc_ind : 1; /* bits 20:20 */
		ca_uint32_t cl_key_stre_vlanid_10 : 11; /* bits 31:21 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA8_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA7 0xf4301b28
#define L2FE_CLE_IGR_KEY_DATA7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_ev2_pt : 5; /* bits 5:1 */
		ca_uint32_t cl_key_orhr_ipv4e_tag_num : 2; /* bits 7:6 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_802_1p : 3; /* bits 10:8 */
		ca_uint32_t cl_key_orhr_ipv4e_top_802_1p : 3; /* bits 13:11 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_sc_ind : 1; /* bits 14:14 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_vid : 12; /* bits 26:15 */
		ca_uint32_t cl_key_orhr_ipv4e_top_sc_ind : 1; /* bits 27:27 */
		ca_uint32_t cl_key_orhr_ipv4e_top_vid : 4; /* bits 31:28 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 27; /* bits 26:0 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 5; /* bits 31:27 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp : 16; /* bits 16:1 */
		ca_uint32_t cl_key_tre_l2rl2r_1_ev2_pt : 5; /* bits 21:17 */
		ca_uint32_t cl_key_tre_l2rl2r_1_tag_num : 2; /* bits 23:22 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_802_1p : 3; /* bits 26:24 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_802_1p : 3; /* bits 29:27 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_sc_ind : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid : 1; /* bits 31:31 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp : 16; /* bits 16:1 */
		ca_uint32_t cl_key_tre_l2rl3r_1_ev2_pt : 5; /* bits 21:17 */
		ca_uint32_t cl_key_tre_l2rl3r_1_tag_num : 2; /* bits 23:22 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_802_1p : 3; /* bits 26:24 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_802_1p : 3; /* bits 29:27 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_sc_ind : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid : 1; /* bits 31:31 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp : 16; /* bits 16:1 */
		ca_uint32_t cl_key_tre_l2rcmr_1_ev2_pt : 5; /* bits 21:17 */
		ca_uint32_t cl_key_tre_l2rcmr_1_tag_num : 2; /* bits 23:22 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_802_1p : 3; /* bits 26:24 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_802_1p : 3; /* bits 29:27 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_sc_ind : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid : 1; /* bits 31:31 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_l3rl2r_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p : 2; /* bits 31:30 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_l3rl3r_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p : 2; /* bits 31:30 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_l3rcmr_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p : 2; /* bits 31:30 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_cmrl2r_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p : 2; /* bits 31:30 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_cmrl3r_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p : 2; /* bits 31:30 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_cmrcmr_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p : 2; /* bits 31:30 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_7 : 8; /* bits 7:0 */
		ca_uint32_t cl_key_stre_rule7_valid : 1; /* bits 8:8 */
		ca_uint32_t cl_key_stre_mask_8 : 2; /* bits 10:9 */
		ca_uint32_t cl_key_stre_dot1p_8 : 3; /* bits 13:11 */
		ca_uint32_t cl_key_stre_vlanid_8_sc_ind : 1; /* bits 14:14 */
		ca_uint32_t cl_key_stre_vlanid_8 : 12; /* bits 26:15 */
		ca_uint32_t cl_key_stre_rule8_valid : 1; /* bits 27:27 */
		ca_uint32_t cl_key_stre_mask_9 : 2; /* bits 29:28 */
		ca_uint32_t cl_key_stre_dot1p_9 : 2; /* bits 31:30 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA7_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA6 0xf4301b2c
#define L2FE_CLE_IGR_KEY_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 31; /* bits 31:1 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l2rl2r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l2rl2r_1_mask : 2; /* bits 7:6 */
		ca_uint32_t cl_key_tre_l2rl2r_1_l4_ctrl : 3; /* bits 10:8 */
		ca_uint32_t cl_key_tre_l2rl2r_1_dot1p_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l2rl2r_1_vid_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 15; /* bits 31:17 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l2rl3r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l2rl3r_1_mask : 2; /* bits 7:6 */
		ca_uint32_t cl_key_tre_l2rl3r_1_l4_ctrl : 3; /* bits 10:8 */
		ca_uint32_t cl_key_tre_l2rl3r_1_dot1p_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l2rl3r_1_vid_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 15; /* bits 31:17 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l2rcmr_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l2rcmr_1_mask : 2; /* bits 7:6 */
		ca_uint32_t cl_key_tre_l2rcmr_1_l4_ctrl : 3; /* bits 10:8 */
		ca_uint32_t cl_key_tre_l2rcmr_1_dot1p_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l2rcmr_1_vid_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 15; /* bits 31:17 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l3rl2r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l3rl2r_1_mask : 8; /* bits 13:6 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_ctrl : 3; /* bits 16:14 */
		ca_uint32_t cl_key_tre_l3rl2r_1_dot1p_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l3rl2r_1_vid_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ip_ctrl : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp : 9; /* bits 31:23 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l3rl3r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l3rl3r_1_mask : 8; /* bits 13:6 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_ctrl : 3; /* bits 16:14 */
		ca_uint32_t cl_key_tre_l3rl3r_1_dot1p_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l3rl3r_1_vid_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ip_ctrl : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp : 9; /* bits 31:23 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l3rcmr_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l3rcmr_1_mask : 8; /* bits 13:6 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_ctrl : 3; /* bits 16:14 */
		ca_uint32_t cl_key_tre_l3rcmr_1_dot1p_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l3rcmr_1_vid_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ip_ctrl : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp : 9; /* bits 31:23 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_cmrl2r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_cmrl2r_1_mask : 12; /* bits 17:6 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_ctrl : 3; /* bits 20:18 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr_sel : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr_sel : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp : 9; /* bits 31:23 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_cmrl3r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_cmrl3r_1_mask : 12; /* bits 17:6 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_ctrl : 3; /* bits 20:18 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr_sel : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr_sel : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp : 9; /* bits 31:23 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_cmrcmr_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_cmrcmr_1_mask : 12; /* bits 17:6 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_ctrl : 3; /* bits 20:18 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr_sel : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr_sel : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp : 9; /* bits 31:23 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_5 : 2; /* bits 1:0 */
		ca_uint32_t cl_key_stre_rule5_valid : 1; /* bits 2:2 */
		ca_uint32_t cl_key_stre_mask_6 : 2; /* bits 4:3 */
		ca_uint32_t cl_key_stre_dot1p_6 : 3; /* bits 7:5 */
		ca_uint32_t cl_key_stre_vlanid_6_sc_ind : 1; /* bits 8:8 */
		ca_uint32_t cl_key_stre_vlanid_6 : 12; /* bits 20:9 */
		ca_uint32_t cl_key_stre_rule6_valid : 1; /* bits 21:21 */
		ca_uint32_t cl_key_stre_mask_7 : 2; /* bits 23:22 */
		ca_uint32_t cl_key_stre_dot1p_7 : 3; /* bits 26:24 */
		ca_uint32_t cl_key_stre_vlanid_7_sc_ind : 1; /* bits 27:27 */
		ca_uint32_t cl_key_stre_vlanid_7 : 4; /* bits 31:28 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA5 0xf4301b30
#define L2FE_CLE_IGR_KEY_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_ip_pt : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 31; /* bits 31:1 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_pol_id_use_inner_vid : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rl2r_2_reserved : 5; /* bits 31:27 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l2rl3r_2_pol_id_use_inner_vid : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_dei_mask : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_dei : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags_op : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_ext_flags : 3; /* bits 31:29 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l2rcmr_2_top_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l2rcmr_2_top_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags_op : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_ext_flags : 3; /* bits 28:26 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_tos_mask_l : 3; /* bits 31:29 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_pol_id_use_inner_vid : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rl2r_2_reserved : 5; /* bits 31:27 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rl3r_2_pol_id_use_inner_vid : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_dei_mask : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_dei : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags_op : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_ext_flags : 3; /* bits 31:29 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rcmr_2_top_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l3rcmr_2_top_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags_op : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_ext_flags : 3; /* bits 28:26 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_tos_mask_l : 3; /* bits 31:29 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_pol_id_use_inner_vid : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrl2r_2_reserved : 5; /* bits 31:27 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_cmrl3r_2_pol_id_use_inner_vid : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_dei_mask : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_dei : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags_op : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_ext_flags : 3; /* bits 31:29 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_cmrcmr_2_top_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrcmr_2_top_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags_op : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_ext_flags : 3; /* bits 28:26 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_tos_mask_l : 3; /* bits 31:29 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_dot1p_4 : 2; /* bits 1:0 */
		ca_uint32_t cl_key_stre_vlanid_4_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t cl_key_stre_vlanid_4 : 12; /* bits 14:3 */
		ca_uint32_t cl_key_stre_rule4_valid : 1; /* bits 15:15 */
		ca_uint32_t cl_key_stre_mask_5 : 2; /* bits 17:16 */
		ca_uint32_t cl_key_stre_dot1p_5 : 3; /* bits 20:18 */
		ca_uint32_t cl_key_stre_vlanid_5_sc_ind : 1; /* bits 21:21 */
		ca_uint32_t cl_key_stre_vlanid_5 : 10; /* bits 31:22 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA4 0xf4301b34
#define L2FE_CLE_IGR_KEY_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_dp_high : 16; /* bits 16:1 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_fragment : 1; /* bits 17:17 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_option : 1; /* bits 18:18 */
		ca_uint32_t cl_key_orhr_ipv4e_ip_tos : 6; /* bits 24:19 */
		ca_uint32_t cl_key_orhr_ipv4e_ip_pt : 7; /* bits 31:25 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 26; /* bits 31:6 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 12; /* bits 31:20 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 28; /* bits 31:4 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 26; /* bits 31:6 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 12; /* bits 31:20 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 28; /* bits 31:4 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 26; /* bits 31:6 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 12; /* bits 31:20 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 28; /* bits 31:4 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_2 : 9; /* bits 8:0 */
		ca_uint32_t cl_key_stre_rule2_valid : 1; /* bits 9:9 */
		ca_uint32_t cl_key_stre_mask_3 : 2; /* bits 11:10 */
		ca_uint32_t cl_key_stre_dot1p_3 : 3; /* bits 14:12 */
		ca_uint32_t cl_key_stre_vlanid_3_sc_ind : 1; /* bits 15:15 */
		ca_uint32_t cl_key_stre_vlanid_3 : 12; /* bits 27:16 */
		ca_uint32_t cl_key_stre_rule3_valid : 1; /* bits 28:28 */
		ca_uint32_t cl_key_stre_mask_4 : 2; /* bits 30:29 */
		ca_uint32_t cl_key_stre_dot1p_4 : 1; /* bits 31:31 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA3 0xf4301b38
#define L2FE_CLE_IGR_KEY_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_sp_high : 16; /* bits 16:1 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 15; /* bits 31:17 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ip_tos : 5; /* bits 4:0 */
		ca_uint32_t cl_key_orhr_ipv6e_ip_pt : 8; /* bits 12:5 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_mask : 14; /* bits 26:13 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 5; /* bits 31:27 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 32; /* bits 31:0 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_fragment : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_option : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ip_tos : 6; /* bits 11:6 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ip_pt : 8; /* bits 19:12 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 12; /* bits 31:20 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 28; /* bits 31:4 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 32; /* bits 31:0 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_fragment : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_option : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ip_tos : 6; /* bits 11:6 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ip_pt : 8; /* bits 19:12 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 12; /* bits 31:20 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 28; /* bits 31:4 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 32; /* bits 31:0 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_fragment : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_option : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ip_tos : 6; /* bits 11:6 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ip_pt : 8; /* bits 19:12 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 12; /* bits 31:20 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 28; /* bits 31:4 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_0 : 3; /* bits 2:0 */
		ca_uint32_t cl_key_stre_rule0_valid : 1; /* bits 3:3 */
		ca_uint32_t cl_key_stre_mask_1 : 2; /* bits 5:4 */
		ca_uint32_t cl_key_stre_dot1p_1 : 3; /* bits 8:6 */
		ca_uint32_t cl_key_stre_vlanid_1_sc_ind : 1; /* bits 9:9 */
		ca_uint32_t cl_key_stre_vlanid_1 : 12; /* bits 21:10 */
		ca_uint32_t cl_key_stre_rule1_valid : 1; /* bits 22:22 */
		ca_uint32_t cl_key_stre_mask_2 : 2; /* bits 24:23 */
		ca_uint32_t cl_key_stre_dot1p_2 : 3; /* bits 27:25 */
		ca_uint32_t cl_key_stre_vlanid_2_sc_ind : 1; /* bits 28:28 */
		ca_uint32_t cl_key_stre_vlanid_2 : 3; /* bits 31:29 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA2 0xf4301b3c
#define L2FE_CLE_IGR_KEY_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_global_key : 9; /* bits 8:0 */
		ca_uint32_t cl_key_orhr_ipv4e_special_pkt_code : 5; /* bits 13:9 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_flags : 3; /* bits 16:14 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 15; /* bits 31:17 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_orhr_ipv6e_tag_num : 2; /* bits 6:5 */
		ca_uint32_t cl_key_orhr_ipv6e_top_802_1p : 3; /* bits 9:7 */
		ca_uint32_t cl_key_orhr_ipv6e_top_sc_ind : 1; /* bits 10:10 */
		ca_uint32_t cl_key_orhr_ipv6e_top_vid : 12; /* bits 22:11 */
		ca_uint32_t cl_key_orhr_ipv6e_special_pkt_code : 5; /* bits 27:23 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_flags : 3; /* bits 30:28 */
		ca_uint32_t cl_key_orhr_ipv6e_ip_tos : 1; /* bits 31:31 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid : 9; /* bits 8:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_sc_ind : 1; /* bits 9:9 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_vid : 12; /* bits 21:10 */
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 10; /* bits 31:22 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_vid : 12; /* bits 14:3 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_sc_ind : 1; /* bits 15:15 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_vid : 12; /* bits 27:16 */
		ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code : 4; /* bits 31:28 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_top_vid : 12; /* bits 11:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_special_pkt_code : 5; /* bits 16:12 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags : 3; /* bits 19:17 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_fragment : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_option : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ip_tos : 6; /* bits 27:22 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt : 4; /* bits 31:28 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid : 9; /* bits 8:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_sc_ind : 1; /* bits 9:9 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_vid : 12; /* bits 21:10 */
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 10; /* bits 31:22 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_vid : 12; /* bits 14:3 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_sc_ind : 1; /* bits 15:15 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_vid : 12; /* bits 27:16 */
		ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code : 4; /* bits 31:28 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_top_vid : 12; /* bits 11:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_special_pkt_code : 5; /* bits 16:12 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags : 3; /* bits 19:17 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_fragment : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_option : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ip_tos : 6; /* bits 27:22 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt : 4; /* bits 31:28 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid : 9; /* bits 8:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_sc_ind : 1; /* bits 9:9 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_vid : 12; /* bits 21:10 */
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 10; /* bits 31:22 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_vid : 12; /* bits 14:3 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_sc_ind : 1; /* bits 15:15 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_vid : 12; /* bits 27:16 */
		ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code : 4; /* bits 31:28 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_top_vid : 12; /* bits 11:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_special_pkt_code : 5; /* bits 16:12 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags : 3; /* bits 19:17 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_fragment : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_option : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ip_tos : 6; /* bits 27:22 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt : 4; /* bits 31:28 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_reserved : 9; /* bits 8:0 */
		ca_uint32_t cl_key_stre_grp_1_prcd : 3; /* bits 11:9 */
		ca_uint32_t cl_key_stre_grp_0_prcd : 3; /* bits 14:12 */
		ca_uint32_t cl_key_stre_grp_1_dscp_mode : 1; /* bits 15:15 */
		ca_uint32_t cl_key_stre_grp_0_dscp_mode : 1; /* bits 16:16 */
		ca_uint32_t cl_key_stre_mask_0 : 2; /* bits 18:17 */
		ca_uint32_t cl_key_stre_dot1p_0 : 3; /* bits 21:19 */
		ca_uint32_t cl_key_stre_vlanid_0_sc_ind : 1; /* bits 22:22 */
		ca_uint32_t cl_key_stre_vlanid_0 : 9; /* bits 31:23 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA1 0xf4301b40
#define L2FE_CLE_IGR_KEY_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_ip_ctrl : 3; /* bits 2:0 */
		ca_uint32_t cl_key_orhr_ipv4e_dot1p_ctrl : 2; /* bits 4:3 */
		ca_uint32_t cl_key_orhr_ipv4e_vid_ctrl : 2; /* bits 6:5 */
		ca_uint32_t cl_key_orhr_ipv4e_mac_ctrl : 2; /* bits 8:7 */
		ca_uint32_t cl_key_orhr_ipv4e_global_key : 23; /* bits 31:9 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_flow_label : 5; /* bits 4:0 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_sp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 11; /* bits 31:21 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 15; /* bits 14:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_ev2_pt : 5; /* bits 19:15 */
		ca_uint32_t cl_key_tre_l2rl2r_2_tag_num : 2; /* bits 21:20 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_802_1p : 3; /* bits 24:22 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_802_1p : 3; /* bits 27:25 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_sc_ind : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid : 3; /* bits 31:29 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_l2rl3r_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p : 1; /* bits 31:31 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_l2rcmr_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_l2rcmr_2_top_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_l2rcmr_2_top_sc_ind : 1; /* bits 31:31 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 15; /* bits 14:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_ev2_pt : 5; /* bits 19:15 */
		ca_uint32_t cl_key_tre_l3rl2r_2_tag_num : 2; /* bits 21:20 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_802_1p : 3; /* bits 24:22 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_802_1p : 3; /* bits 27:25 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_sc_ind : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid : 3; /* bits 31:29 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_l3rl3r_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p : 1; /* bits 31:31 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_l3rcmr_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_l3rcmr_2_top_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_l3rcmr_2_top_sc_ind : 1; /* bits 31:31 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 15; /* bits 14:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_ev2_pt : 5; /* bits 19:15 */
		ca_uint32_t cl_key_tre_cmrl2r_2_tag_num : 2; /* bits 21:20 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_802_1p : 3; /* bits 24:22 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_802_1p : 3; /* bits 27:25 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_sc_ind : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid : 3; /* bits 31:29 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_cmrl3r_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p : 1; /* bits 31:31 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_cmrcmr_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_cmrcmr_2_top_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrcmr_2_top_sc_ind : 1; /* bits 31:31 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_reserved : 32; /* bits 31:0 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_KEY_DATA0 0xf4301b44
#define L2FE_CLE_IGR_KEY_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_orhr_ipv4e_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_orhr_ipv4e_mask : 22; /* bits 25:4 */
		ca_uint32_t cl_key_orhr_ipv4e_l7_ctrl : 2; /* bits 27:26 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_sp_ctrl : 2; /* bits 29:28 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_dp_ctrl : 2; /* bits 31:30 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_orhr_ipv6e_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_orhr_ipv6e_mask : 8; /* bits 11:4 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_ctrl : 3; /* bits 14:12 */
		ca_uint32_t cl_key_orhr_ipv6e_ip_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_orhr_ipv6e_flow_label : 15; /* bits 31:17 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l2rl2r_2_mask : 2; /* bits 5:4 */
		ca_uint32_t cl_key_tre_l2rl2r_2_l4_ctrl : 3; /* bits 8:6 */
		ca_uint32_t cl_key_tre_l2rl2r_2_dot1p_ctrl : 2; /* bits 10:9 */
		ca_uint32_t cl_key_tre_l2rl2r_2_vid_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l2rl2r_2_l4_sp : 16; /* bits 30:15 */
		ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 1; /* bits 31:31 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l2rl3r_2_mask : 8; /* bits 11:4 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_ctrl : 3; /* bits 14:12 */
		ca_uint32_t cl_key_tre_l2rl3r_2_dot1p_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l2rl3r_2_vid_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ip_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 11; /* bits 31:21 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l2rcmr_2_mask : 12; /* bits 15:4 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_ctrl : 3; /* bits 18:16 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr_sel : 1; /* bits 19:19 */
		ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr_sel : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 11; /* bits 31:21 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l3rl2r_2_mask : 2; /* bits 5:4 */
		ca_uint32_t cl_key_tre_l3rl2r_2_l4_ctrl : 3; /* bits 8:6 */
		ca_uint32_t cl_key_tre_l3rl2r_2_dot1p_ctrl : 2; /* bits 10:9 */
		ca_uint32_t cl_key_tre_l3rl2r_2_vid_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l3rl2r_2_l4_sp : 16; /* bits 30:15 */
		ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 1; /* bits 31:31 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l3rl3r_2_mask : 8; /* bits 11:4 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_ctrl : 3; /* bits 14:12 */
		ca_uint32_t cl_key_tre_l3rl3r_2_dot1p_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l3rl3r_2_vid_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ip_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 11; /* bits 31:21 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l3rcmr_2_mask : 12; /* bits 15:4 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_ctrl : 3; /* bits 18:16 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr_sel : 1; /* bits 19:19 */
		ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr_sel : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 11; /* bits 31:21 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_cmrl2r_2_mask : 2; /* bits 5:4 */
		ca_uint32_t cl_key_tre_cmrl2r_2_l4_ctrl : 3; /* bits 8:6 */
		ca_uint32_t cl_key_tre_cmrl2r_2_dot1p_ctrl : 2; /* bits 10:9 */
		ca_uint32_t cl_key_tre_cmrl2r_2_vid_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_cmrl2r_2_l4_sp : 16; /* bits 30:15 */
		ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 1; /* bits 31:31 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_cmrl3r_2_mask : 8; /* bits 11:4 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_ctrl : 3; /* bits 14:12 */
		ca_uint32_t cl_key_tre_cmrl3r_2_dot1p_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_cmrl3r_2_vid_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ip_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 11; /* bits 31:21 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_cmrcmr_2_mask : 12; /* bits 15:4 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_ctrl : 3; /* bits 18:16 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr_sel : 1; /* bits 19:19 */
		ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr_sel : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 11; /* bits 31:21 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_reserved : 32; /* bits 31:0 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_KEY_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_ACCESS 0xf4301b48
#define L2FE_CLE_EGR_KEY_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA12 0xf4301b4c
#define L2FE_CLE_EGR_KEY_DATA12_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_reserved : 8; /* bits 7:0 */
		ca_uint32_t cl_key_orhr_ipv6_valid : 1; /* bits 8:8 */
		ca_uint32_t cl_key_entry_type : 2; /* bits 10:9 */
		ca_uint32_t cl_key_valid : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 20;
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_l4_ext_flags : 2; /* bits 1:0 */
		ca_uint32_t cl_key_orhr_ipv6e_tos_mask_l : 3; /* bits 4:2 */
		ca_uint32_t cl_key_orhr_ipv6e_reserved : 3; /* bits 7:5 */
		ca_uint32_t cl_key_orhr_ipv6e_idle_field : 4; /* bits 11:8 */
		ca_uint32_t rsrvd1 : 20;
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_reserved : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_rule_type_1 : 2; /* bits 5:4 */
		ca_uint32_t cl_key_tre_rule_type_0 : 2; /* bits 7:6 */
		ca_uint32_t cl_key_tre_rule_hinge : 1; /* bits 8:8 */
		ca_uint32_t cl_key_tre_rule_idle_field : 3; /* bits 11:9 */
		ca_uint32_t rsrvd1 : 20;
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_reserved : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l2rl3r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_reserved : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l2rcmr_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_ext_flags : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_l3rl2r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_ext_flags : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_l3rl3r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_ext_flags : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_l3rcmr_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_tos_mask_l : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_cmrl2r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_tos_mask_l : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_cmrl3r_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_tos_mask_l : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_reserved : 2; /* bits 3:2 */
		ca_uint32_t cl_key_tre_cmrcmr_idle_field : 8; /* bits 11:4 */
		ca_uint32_t rsrvd1 : 20;
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_rule15_valid : 1; /* bits 0:0 */
		ca_uint32_t cl_key_stre_rule1_0_ctrl : 1; /* bits 1:1 */
		ca_uint32_t cl_key_stre_rule3_2_ctrl : 1; /* bits 2:2 */
		ca_uint32_t cl_key_stre_rule5_4_ctrl : 1; /* bits 3:3 */
		ca_uint32_t cl_key_stre_rule7_6_ctrl : 1; /* bits 4:4 */
		ca_uint32_t cl_key_stre_rule9_8_ctrl : 1; /* bits 5:5 */
		ca_uint32_t cl_key_stre_rule11_10_ctrl : 1; /* bits 6:6 */
		ca_uint32_t cl_key_stre_rule13_12_ctrl : 1; /* bits 7:7 */
		ca_uint32_t cl_key_stre_rule15_14_ctrl : 1; /* bits 8:8 */
		ca_uint32_t cl_key_stre_idle_field : 3; /* bits 11:9 */
		ca_uint32_t rsrvd1 : 20;
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA12_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA11 0xf4301b50
#define L2FE_CLE_EGR_KEY_DATA11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_mac_da : 8; /* bits 7:0 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn_mask : 1; /* bits 8:8 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn : 2; /* bits 10:9 */
		ca_uint32_t cl_key_orhr_ipv4e_pol_id_abbr_mask : 1; /* bits 11:11 */
		ca_uint32_t cl_key_orhr_ipv4e_pol_id_abbr : 9; /* bits 20:12 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_dei_mask : 1; /* bits 21:21 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_dei : 1; /* bits 22:22 */
		ca_uint32_t cl_key_orhr_ipv4e_top_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_orhr_ipv4e_top_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_flags_op : 1; /* bits 25:25 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_ext_flags : 3; /* bits 28:26 */
		ca_uint32_t cl_key_orhr_ipv4e_tos_mask_l : 3; /* bits 31:29 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 27; /* bits 26:0 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn_mask : 1; /* bits 27:27 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn : 2; /* bits 29:28 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_flags_op : 1; /* bits 30:30 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_ext_flags : 1; /* bits 31:31 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 24; /* bits 23:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_pol_id_use_inner_vid : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_dei_mask : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_dei : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rl2r_1_reserved : 3; /* bits 31:29 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 24; /* bits 23:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_pol_id_use_inner_vid : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_dei_mask : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_dei : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rl3r_1_reserved : 3; /* bits 31:29 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 24; /* bits 23:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_pol_id_use_inner_vid : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_dei_mask : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_dei : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rcmr_1_reserved : 3; /* bits 31:29 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_l3rl2r_1_pol_id_use_inner_vid : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_dei_mask : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_dei : 1; /* bits 29:29 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags_op : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_ext_flags : 1; /* bits 31:31 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_l3rl3r_1_pol_id_use_inner_vid : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_dei_mask : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_dei : 1; /* bits 29:29 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags_op : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_ext_flags : 1; /* bits 31:31 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_l3rcmr_1_pol_id_use_inner_vid : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_dei_mask : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_dei : 1; /* bits 29:29 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags_op : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_ext_flags : 1; /* bits 31:31 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags_op : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_ext_flags : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_tos_mask_l : 1; /* bits 31:31 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags_op : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_ext_flags : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_tos_mask_l : 1; /* bits 31:31 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ecn_mask : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ecn : 2; /* bits 24:23 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags_op : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_ext_flags : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_tos_mask_l : 1; /* bits 31:31 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_14_sc_ind : 1; /* bits 0:0 */
		ca_uint32_t cl_key_stre_vlanid_14 : 12; /* bits 12:1 */
		ca_uint32_t cl_key_stre_rule14_valid : 1; /* bits 13:13 */
		ca_uint32_t cl_key_stre_mask_15 : 2; /* bits 15:14 */
		ca_uint32_t cl_key_stre_dot1p_15 : 3; /* bits 18:16 */
		ca_uint32_t cl_key_stre_vlanid_15_sc_ind : 1; /* bits 19:19 */
		ca_uint32_t cl_key_stre_vlanid_15 : 12; /* bits 31:20 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA11_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA10 0xf4301b54
#define L2FE_CLE_EGR_KEY_DATA10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_mac_da : 32; /* bits 31:0 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 8; /* bits 7:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 24; /* bits 31:8 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 8; /* bits 7:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 24; /* bits 31:8 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 8; /* bits 7:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 24; /* bits 31:8 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 10; /* bits 31:22 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 10; /* bits 31:22 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 10; /* bits 31:22 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 26; /* bits 31:6 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 26; /* bits 31:6 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 26; /* bits 31:6 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_12 : 7; /* bits 6:0 */
		ca_uint32_t cl_key_stre_rule12_valid : 1; /* bits 7:7 */
		ca_uint32_t cl_key_stre_mask_13 : 2; /* bits 9:8 */
		ca_uint32_t cl_key_stre_dot1p_13 : 3; /* bits 12:10 */
		ca_uint32_t cl_key_stre_vlanid_13_sc_ind : 1; /* bits 13:13 */
		ca_uint32_t cl_key_stre_vlanid_13 : 12; /* bits 25:14 */
		ca_uint32_t cl_key_stre_rule13_valid : 1; /* bits 26:26 */
		ca_uint32_t cl_key_stre_mask_14 : 2; /* bits 28:27 */
		ca_uint32_t cl_key_stre_dot1p_14 : 3; /* bits 31:29 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA10_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA9 0xf4301b58
#define L2FE_CLE_EGR_KEY_DATA9_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24; /* bits 23:0 */
		ca_uint32_t cl_key_orhr_ipv4e_mac_da : 8; /* bits 31:24 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 32; /* bits 31:0 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 32; /* bits 31:0 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 32; /* bits 31:0 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags : 3; /* bits 5:3 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_fragment : 1; /* bits 6:6 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_option : 1; /* bits 7:7 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ip_tos : 6; /* bits 13:8 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ip_pt : 8; /* bits 21:14 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 10; /* bits 31:22 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags : 3; /* bits 5:3 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_fragment : 1; /* bits 6:6 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_option : 1; /* bits 7:7 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ip_tos : 6; /* bits 13:8 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ip_pt : 8; /* bits 21:14 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 10; /* bits 31:22 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags : 3; /* bits 5:3 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_fragment : 1; /* bits 6:6 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_option : 1; /* bits 7:7 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ip_tos : 6; /* bits 13:8 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ip_pt : 8; /* bits 21:14 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 10; /* bits 31:22 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 26; /* bits 31:6 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 26; /* bits 31:6 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 26; /* bits 31:6 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_10 : 1; /* bits 0:0 */
		ca_uint32_t cl_key_stre_rule10_valid : 1; /* bits 1:1 */
		ca_uint32_t cl_key_stre_mask_11 : 2; /* bits 3:2 */
		ca_uint32_t cl_key_stre_dot1p_11 : 3; /* bits 6:4 */
		ca_uint32_t cl_key_stre_vlanid_11_sc_ind : 1; /* bits 7:7 */
		ca_uint32_t cl_key_stre_vlanid_11 : 12; /* bits 19:8 */
		ca_uint32_t cl_key_stre_rule11_valid : 1; /* bits 20:20 */
		ca_uint32_t cl_key_stre_mask_12 : 2; /* bits 22:21 */
		ca_uint32_t cl_key_stre_dot1p_12 : 3; /* bits 25:23 */
		ca_uint32_t cl_key_stre_vlanid_12_sc_ind : 1; /* bits 26:26 */
		ca_uint32_t cl_key_stre_vlanid_12 : 5; /* bits 31:27 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA9_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA8 0xf4301b5c
#define L2FE_CLE_EGR_KEY_DATA8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_top_vid : 8; /* bits 7:0 */
		ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24; /* bits 31:8 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid : 11; /* bits 10:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_sc_ind : 1; /* bits 11:11 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_vid : 12; /* bits 23:12 */
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 8; /* bits 31:24 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid : 11; /* bits 10:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_sc_ind : 1; /* bits 11:11 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_vid : 12; /* bits 23:12 */
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 8; /* bits 31:24 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid : 11; /* bits 10:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_sc_ind : 1; /* bits 11:11 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_vid : 12; /* bits 23:12 */
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 8; /* bits 31:24 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_802_1p : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_sc_ind : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_vid : 12; /* bits 16:5 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_sc_ind : 1; /* bits 17:17 */
		ca_uint32_t cl_key_tre_l3rl2r_1_top_vid : 12; /* bits 29:18 */
		ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code : 2; /* bits 31:30 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_802_1p : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_sc_ind : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_vid : 12; /* bits 16:5 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_sc_ind : 1; /* bits 17:17 */
		ca_uint32_t cl_key_tre_l3rl3r_1_top_vid : 12; /* bits 29:18 */
		ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code : 2; /* bits 31:30 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_802_1p : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_sc_ind : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_vid : 12; /* bits 16:5 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_sc_ind : 1; /* bits 17:17 */
		ca_uint32_t cl_key_tre_l3rcmr_1_top_vid : 12; /* bits 29:18 */
		ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code : 2; /* bits 31:30 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_vid : 12; /* bits 13:2 */
		ca_uint32_t cl_key_tre_cmrl2r_1_special_pkt_code : 5; /* bits 18:14 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags : 3; /* bits 21:19 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_fragment : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_option : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ip_tos : 6; /* bits 29:24 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt : 2; /* bits 31:30 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_vid : 12; /* bits 13:2 */
		ca_uint32_t cl_key_tre_cmrl3r_1_special_pkt_code : 5; /* bits 18:14 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags : 3; /* bits 21:19 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_fragment : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_option : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ip_tos : 6; /* bits 29:24 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt : 2; /* bits 31:30 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_vid : 12; /* bits 13:2 */
		ca_uint32_t cl_key_tre_cmrcmr_1_special_pkt_code : 5; /* bits 18:14 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags : 3; /* bits 21:19 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_fragment : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_option : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ip_tos : 6; /* bits 29:24 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt : 2; /* bits 31:30 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_dot1p_9 : 1; /* bits 0:0 */
		ca_uint32_t cl_key_stre_vlanid_9_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t cl_key_stre_vlanid_9 : 12; /* bits 13:2 */
		ca_uint32_t cl_key_stre_rule9_valid : 1; /* bits 14:14 */
		ca_uint32_t cl_key_stre_mask_10 : 2; /* bits 16:15 */
		ca_uint32_t cl_key_stre_dot1p_10 : 3; /* bits 19:17 */
		ca_uint32_t cl_key_stre_vlanid_10_sc_ind : 1; /* bits 20:20 */
		ca_uint32_t cl_key_stre_vlanid_10 : 11; /* bits 31:21 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA8_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA7 0xf4301b60
#define L2FE_CLE_EGR_KEY_DATA7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_ev2_pt : 5; /* bits 5:1 */
		ca_uint32_t cl_key_orhr_ipv4e_tag_num : 2; /* bits 7:6 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_802_1p : 3; /* bits 10:8 */
		ca_uint32_t cl_key_orhr_ipv4e_top_802_1p : 3; /* bits 13:11 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_sc_ind : 1; /* bits 14:14 */
		ca_uint32_t cl_key_orhr_ipv4e_inner_vid : 12; /* bits 26:15 */
		ca_uint32_t cl_key_orhr_ipv4e_top_sc_ind : 1; /* bits 27:27 */
		ca_uint32_t cl_key_orhr_ipv4e_top_vid : 4; /* bits 31:28 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 27; /* bits 26:0 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 5; /* bits 31:27 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp : 16; /* bits 16:1 */
		ca_uint32_t cl_key_tre_l2rl2r_1_ev2_pt : 5; /* bits 21:17 */
		ca_uint32_t cl_key_tre_l2rl2r_1_tag_num : 2; /* bits 23:22 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_802_1p : 3; /* bits 26:24 */
		ca_uint32_t cl_key_tre_l2rl2r_1_top_802_1p : 3; /* bits 29:27 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_sc_ind : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid : 1; /* bits 31:31 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp : 16; /* bits 16:1 */
		ca_uint32_t cl_key_tre_l2rl3r_1_ev2_pt : 5; /* bits 21:17 */
		ca_uint32_t cl_key_tre_l2rl3r_1_tag_num : 2; /* bits 23:22 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_802_1p : 3; /* bits 26:24 */
		ca_uint32_t cl_key_tre_l2rl3r_1_top_802_1p : 3; /* bits 29:27 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_sc_ind : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid : 1; /* bits 31:31 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp : 16; /* bits 16:1 */
		ca_uint32_t cl_key_tre_l2rcmr_1_ev2_pt : 5; /* bits 21:17 */
		ca_uint32_t cl_key_tre_l2rcmr_1_tag_num : 2; /* bits 23:22 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_802_1p : 3; /* bits 26:24 */
		ca_uint32_t cl_key_tre_l2rcmr_1_top_802_1p : 3; /* bits 29:27 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_sc_ind : 1; /* bits 30:30 */
		ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid : 1; /* bits 31:31 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_l3rl2r_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p : 2; /* bits 31:30 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_l3rl3r_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p : 2; /* bits 31:30 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_l3rcmr_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p : 2; /* bits 31:30 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_cmrl2r_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p : 2; /* bits 31:30 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_cmrl3r_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p : 2; /* bits 31:30 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp : 7; /* bits 6:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_dp : 16; /* bits 22:7 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ev2_pt : 5; /* bits 27:23 */
		ca_uint32_t cl_key_tre_cmrcmr_1_tag_num : 2; /* bits 29:28 */
		ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p : 2; /* bits 31:30 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_7 : 8; /* bits 7:0 */
		ca_uint32_t cl_key_stre_rule7_valid : 1; /* bits 8:8 */
		ca_uint32_t cl_key_stre_mask_8 : 2; /* bits 10:9 */
		ca_uint32_t cl_key_stre_dot1p_8 : 3; /* bits 13:11 */
		ca_uint32_t cl_key_stre_vlanid_8_sc_ind : 1; /* bits 14:14 */
		ca_uint32_t cl_key_stre_vlanid_8 : 12; /* bits 26:15 */
		ca_uint32_t cl_key_stre_rule8_valid : 1; /* bits 27:27 */
		ca_uint32_t cl_key_stre_mask_9 : 2; /* bits 29:28 */
		ca_uint32_t cl_key_stre_dot1p_9 : 2; /* bits 31:30 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA7_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA6 0xf4301b64
#define L2FE_CLE_EGR_KEY_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 31; /* bits 31:1 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l2rl2r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l2rl2r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l2rl2r_1_mask : 2; /* bits 7:6 */
		ca_uint32_t cl_key_tre_l2rl2r_1_l4_ctrl : 3; /* bits 10:8 */
		ca_uint32_t cl_key_tre_l2rl2r_1_dot1p_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l2rl2r_1_vid_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l2rl2r_1_mac_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 15; /* bits 31:17 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l2rl3r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l2rl3r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l2rl3r_1_mask : 2; /* bits 7:6 */
		ca_uint32_t cl_key_tre_l2rl3r_1_l4_ctrl : 3; /* bits 10:8 */
		ca_uint32_t cl_key_tre_l2rl3r_1_dot1p_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l2rl3r_1_vid_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l2rl3r_1_mac_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 15; /* bits 31:17 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l2rcmr_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l2rcmr_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l2rcmr_1_mask : 2; /* bits 7:6 */
		ca_uint32_t cl_key_tre_l2rcmr_1_l4_ctrl : 3; /* bits 10:8 */
		ca_uint32_t cl_key_tre_l2rcmr_1_dot1p_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l2rcmr_1_vid_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l2rcmr_1_mac_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 15; /* bits 31:17 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl2r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l3rl2r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l3rl2r_1_mask : 8; /* bits 13:6 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_ctrl : 3; /* bits 16:14 */
		ca_uint32_t cl_key_tre_l3rl2r_1_dot1p_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l3rl2r_1_vid_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l3rl2r_1_ip_ctrl : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp : 9; /* bits 31:23 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl3r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l3rl3r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l3rl3r_1_mask : 8; /* bits 13:6 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_ctrl : 3; /* bits 16:14 */
		ca_uint32_t cl_key_tre_l3rl3r_1_dot1p_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l3rl3r_1_vid_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l3rl3r_1_ip_ctrl : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp : 9; /* bits 31:23 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rcmr_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_l3rcmr_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l3rcmr_1_mask : 8; /* bits 13:6 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_ctrl : 3; /* bits 16:14 */
		ca_uint32_t cl_key_tre_l3rcmr_1_dot1p_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l3rcmr_1_vid_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l3rcmr_1_ip_ctrl : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp : 9; /* bits 31:23 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl2r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_cmrl2r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_cmrl2r_1_mask : 12; /* bits 17:6 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_ctrl : 3; /* bits 20:18 */
		ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr_sel : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr_sel : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp : 9; /* bits 31:23 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl3r_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_cmrl3r_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_cmrl3r_1_mask : 12; /* bits 17:6 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_ctrl : 3; /* bits 20:18 */
		ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr_sel : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr_sel : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp : 9; /* bits 31:23 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_reserved : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrcmr_1_prcd : 3; /* bits 4:2 */
		ca_uint32_t cl_key_tre_cmrcmr_1_fields_operator : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_cmrcmr_1_mask : 12; /* bits 17:6 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_ctrl : 3; /* bits 20:18 */
		ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr_sel : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr_sel : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp : 9; /* bits 31:23 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_5 : 2; /* bits 1:0 */
		ca_uint32_t cl_key_stre_rule5_valid : 1; /* bits 2:2 */
		ca_uint32_t cl_key_stre_mask_6 : 2; /* bits 4:3 */
		ca_uint32_t cl_key_stre_dot1p_6 : 3; /* bits 7:5 */
		ca_uint32_t cl_key_stre_vlanid_6_sc_ind : 1; /* bits 8:8 */
		ca_uint32_t cl_key_stre_vlanid_6 : 12; /* bits 20:9 */
		ca_uint32_t cl_key_stre_rule6_valid : 1; /* bits 21:21 */
		ca_uint32_t cl_key_stre_mask_7 : 2; /* bits 23:22 */
		ca_uint32_t cl_key_stre_dot1p_7 : 3; /* bits 26:24 */
		ca_uint32_t cl_key_stre_vlanid_7_sc_ind : 1; /* bits 27:27 */
		ca_uint32_t cl_key_stre_vlanid_7 : 4; /* bits 31:28 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA5 0xf4301b68
#define L2FE_CLE_EGR_KEY_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_ip_pt : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 31; /* bits 31:1 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_pol_id_use_inner_vid : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rl2r_2_reserved : 5; /* bits 31:27 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l2rl3r_2_pol_id_use_inner_vid : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_dei_mask : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_dei : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags_op : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_ext_flags : 3; /* bits 31:29 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l2rcmr_2_top_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l2rcmr_2_top_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags_op : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_ext_flags : 3; /* bits 28:26 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_tos_mask_l : 3; /* bits 31:29 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_pol_id_use_inner_vid : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rl2r_2_reserved : 5; /* bits 31:27 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rl3r_2_pol_id_use_inner_vid : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_dei_mask : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_dei : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags_op : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_ext_flags : 3; /* bits 31:29 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_l3rcmr_2_top_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_l3rcmr_2_top_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags_op : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_ext_flags : 3; /* bits 28:26 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_tos_mask_l : 3; /* bits 31:29 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 22; /* bits 21:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_pol_id_use_inner_vid : 1; /* bits 22:22 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_dei_mask : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_dei : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrl2r_2_reserved : 5; /* bits 31:27 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_cmrl3r_2_pol_id_use_inner_vid : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_dei_mask : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_dei : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_dei_mask : 1; /* bits 26:26 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_dei : 1; /* bits 27:27 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags_op : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_ext_flags : 3; /* bits 31:29 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ecn_mask : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ecn : 2; /* bits 22:21 */
		ca_uint32_t cl_key_tre_cmrcmr_2_top_dei_mask : 1; /* bits 23:23 */
		ca_uint32_t cl_key_tre_cmrcmr_2_top_dei : 1; /* bits 24:24 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags_op : 1; /* bits 25:25 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_ext_flags : 3; /* bits 28:26 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_tos_mask_l : 3; /* bits 31:29 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_dot1p_4 : 2; /* bits 1:0 */
		ca_uint32_t cl_key_stre_vlanid_4_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t cl_key_stre_vlanid_4 : 12; /* bits 14:3 */
		ca_uint32_t cl_key_stre_rule4_valid : 1; /* bits 15:15 */
		ca_uint32_t cl_key_stre_mask_5 : 2; /* bits 17:16 */
		ca_uint32_t cl_key_stre_dot1p_5 : 3; /* bits 20:18 */
		ca_uint32_t cl_key_stre_vlanid_5_sc_ind : 1; /* bits 21:21 */
		ca_uint32_t cl_key_stre_vlanid_5 : 10; /* bits 31:22 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA4 0xf4301b6c
#define L2FE_CLE_EGR_KEY_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_dp_high : 16; /* bits 16:1 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_fragment : 1; /* bits 17:17 */
		ca_uint32_t cl_key_orhr_ipv4e_ipv4_option : 1; /* bits 18:18 */
		ca_uint32_t cl_key_orhr_ipv4e_ip_tos : 6; /* bits 24:19 */
		ca_uint32_t cl_key_orhr_ipv4e_ip_pt : 7; /* bits 31:25 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32; /* bits 31:0 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 26; /* bits 31:6 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 12; /* bits 31:20 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 28; /* bits 31:4 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 26; /* bits 31:6 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 12; /* bits 31:20 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 28; /* bits 31:4 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 6; /* bits 5:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 26; /* bits 31:6 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 20; /* bits 19:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 12; /* bits 31:20 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 28; /* bits 31:4 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_2 : 9; /* bits 8:0 */
		ca_uint32_t cl_key_stre_rule2_valid : 1; /* bits 9:9 */
		ca_uint32_t cl_key_stre_mask_3 : 2; /* bits 11:10 */
		ca_uint32_t cl_key_stre_dot1p_3 : 3; /* bits 14:12 */
		ca_uint32_t cl_key_stre_vlanid_3_sc_ind : 1; /* bits 15:15 */
		ca_uint32_t cl_key_stre_vlanid_3 : 12; /* bits 27:16 */
		ca_uint32_t cl_key_stre_rule3_valid : 1; /* bits 28:28 */
		ca_uint32_t cl_key_stre_mask_4 : 2; /* bits 30:29 */
		ca_uint32_t cl_key_stre_dot1p_4 : 1; /* bits 31:31 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA3 0xf4301b70
#define L2FE_CLE_EGR_KEY_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 1; /* bits 0:0 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_sp_high : 16; /* bits 16:1 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 15; /* bits 31:17 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_ip_tos : 5; /* bits 4:0 */
		ca_uint32_t cl_key_orhr_ipv6e_ip_pt : 8; /* bits 12:5 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_mask : 14; /* bits 26:13 */
		ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 5; /* bits 31:27 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 32; /* bits 31:0 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_fragment : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_option : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ip_tos : 6; /* bits 11:6 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ip_pt : 8; /* bits 19:12 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 12; /* bits 31:20 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 28; /* bits 31:4 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 32; /* bits 31:0 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_fragment : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_option : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ip_tos : 6; /* bits 11:6 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ip_pt : 8; /* bits 19:12 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 12; /* bits 31:20 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 28; /* bits 31:4 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 32; /* bits 31:0 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code : 1; /* bits 0:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags : 3; /* bits 3:1 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_fragment : 1; /* bits 4:4 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_option : 1; /* bits 5:5 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ip_tos : 6; /* bits 11:6 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ip_pt : 8; /* bits 19:12 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 12; /* bits 31:20 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt : 4; /* bits 3:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 28; /* bits 31:4 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_vlanid_0 : 3; /* bits 2:0 */
		ca_uint32_t cl_key_stre_rule0_valid : 1; /* bits 3:3 */
		ca_uint32_t cl_key_stre_mask_1 : 2; /* bits 5:4 */
		ca_uint32_t cl_key_stre_dot1p_1 : 3; /* bits 8:6 */
		ca_uint32_t cl_key_stre_vlanid_1_sc_ind : 1; /* bits 9:9 */
		ca_uint32_t cl_key_stre_vlanid_1 : 12; /* bits 21:10 */
		ca_uint32_t cl_key_stre_rule1_valid : 1; /* bits 22:22 */
		ca_uint32_t cl_key_stre_mask_2 : 2; /* bits 24:23 */
		ca_uint32_t cl_key_stre_dot1p_2 : 3; /* bits 27:25 */
		ca_uint32_t cl_key_stre_vlanid_2_sc_ind : 1; /* bits 28:28 */
		ca_uint32_t cl_key_stre_vlanid_2 : 3; /* bits 31:29 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA2 0xf4301b74
#define L2FE_CLE_EGR_KEY_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_global_key : 9; /* bits 8:0 */
		ca_uint32_t cl_key_orhr_ipv4e_special_pkt_code : 5; /* bits 13:9 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_flags : 3; /* bits 16:14 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 15; /* bits 31:17 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_orhr_ipv6e_tag_num : 2; /* bits 6:5 */
		ca_uint32_t cl_key_orhr_ipv6e_top_802_1p : 3; /* bits 9:7 */
		ca_uint32_t cl_key_orhr_ipv6e_top_sc_ind : 1; /* bits 10:10 */
		ca_uint32_t cl_key_orhr_ipv6e_top_vid : 12; /* bits 22:11 */
		ca_uint32_t cl_key_orhr_ipv6e_special_pkt_code : 5; /* bits 27:23 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_flags : 3; /* bits 30:28 */
		ca_uint32_t cl_key_orhr_ipv6e_ip_tos : 1; /* bits 31:31 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid : 9; /* bits 8:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_sc_ind : 1; /* bits 9:9 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_vid : 12; /* bits 21:10 */
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 10; /* bits 31:22 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_vid : 12; /* bits 14:3 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_sc_ind : 1; /* bits 15:15 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_vid : 12; /* bits 27:16 */
		ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code : 4; /* bits 31:28 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_top_vid : 12; /* bits 11:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_special_pkt_code : 5; /* bits 16:12 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags : 3; /* bits 19:17 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_fragment : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_option : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ip_tos : 6; /* bits 27:22 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt : 4; /* bits 31:28 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid : 9; /* bits 8:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_sc_ind : 1; /* bits 9:9 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_vid : 12; /* bits 21:10 */
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 10; /* bits 31:22 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_vid : 12; /* bits 14:3 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_sc_ind : 1; /* bits 15:15 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_vid : 12; /* bits 27:16 */
		ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code : 4; /* bits 31:28 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_top_vid : 12; /* bits 11:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_special_pkt_code : 5; /* bits 16:12 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags : 3; /* bits 19:17 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_fragment : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_option : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ip_tos : 6; /* bits 27:22 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt : 4; /* bits 31:28 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid : 9; /* bits 8:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_sc_ind : 1; /* bits 9:9 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_vid : 12; /* bits 21:10 */
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 10; /* bits 31:22 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p : 2; /* bits 1:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_sc_ind : 1; /* bits 2:2 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_vid : 12; /* bits 14:3 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_sc_ind : 1; /* bits 15:15 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_vid : 12; /* bits 27:16 */
		ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code : 4; /* bits 31:28 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_top_vid : 12; /* bits 11:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_special_pkt_code : 5; /* bits 16:12 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags : 3; /* bits 19:17 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_fragment : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_option : 1; /* bits 21:21 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ip_tos : 6; /* bits 27:22 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt : 4; /* bits 31:28 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_reserved : 9; /* bits 8:0 */
		ca_uint32_t cl_key_stre_grp_1_prcd : 3; /* bits 11:9 */
		ca_uint32_t cl_key_stre_grp_0_prcd : 3; /* bits 14:12 */
		ca_uint32_t cl_key_stre_grp_1_dscp_mode : 1; /* bits 15:15 */
		ca_uint32_t cl_key_stre_grp_0_dscp_mode : 1; /* bits 16:16 */
		ca_uint32_t cl_key_stre_mask_0 : 2; /* bits 18:17 */
		ca_uint32_t cl_key_stre_dot1p_0 : 3; /* bits 21:19 */
		ca_uint32_t cl_key_stre_vlanid_0_sc_ind : 1; /* bits 22:22 */
		ca_uint32_t cl_key_stre_vlanid_0 : 9; /* bits 31:23 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA1 0xf4301b78
#define L2FE_CLE_EGR_KEY_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_ip_ctrl : 3; /* bits 2:0 */
		ca_uint32_t cl_key_orhr_ipv4e_dot1p_ctrl : 2; /* bits 4:3 */
		ca_uint32_t cl_key_orhr_ipv4e_vid_ctrl : 2; /* bits 6:5 */
		ca_uint32_t cl_key_orhr_ipv4e_mac_ctrl : 2; /* bits 8:7 */
		ca_uint32_t cl_key_orhr_ipv4e_global_key : 23; /* bits 31:9 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_flow_label : 5; /* bits 4:0 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_sp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 11; /* bits 31:21 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 15; /* bits 14:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_ev2_pt : 5; /* bits 19:15 */
		ca_uint32_t cl_key_tre_l2rl2r_2_tag_num : 2; /* bits 21:20 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_802_1p : 3; /* bits 24:22 */
		ca_uint32_t cl_key_tre_l2rl2r_2_top_802_1p : 3; /* bits 27:25 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_sc_ind : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid : 3; /* bits 31:29 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_l2rl3r_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_l2rl3r_2_inner_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p : 1; /* bits 31:31 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_l2rcmr_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_l2rcmr_2_top_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_l2rcmr_2_top_sc_ind : 1; /* bits 31:31 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 15; /* bits 14:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_ev2_pt : 5; /* bits 19:15 */
		ca_uint32_t cl_key_tre_l3rl2r_2_tag_num : 2; /* bits 21:20 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_802_1p : 3; /* bits 24:22 */
		ca_uint32_t cl_key_tre_l3rl2r_2_top_802_1p : 3; /* bits 27:25 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_sc_ind : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid : 3; /* bits 31:29 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_l3rl3r_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_l3rl3r_2_inner_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p : 1; /* bits 31:31 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_l3rcmr_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_l3rcmr_2_top_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_l3rcmr_2_top_sc_ind : 1; /* bits 31:31 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 15; /* bits 14:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_ev2_pt : 5; /* bits 19:15 */
		ca_uint32_t cl_key_tre_cmrl2r_2_tag_num : 2; /* bits 21:20 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_802_1p : 3; /* bits 24:22 */
		ca_uint32_t cl_key_tre_cmrl2r_2_top_802_1p : 3; /* bits 27:25 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_sc_ind : 1; /* bits 28:28 */
		ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid : 3; /* bits 31:29 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_cmrl3r_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_cmrl3r_2_inner_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p : 1; /* bits 31:31 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 5; /* bits 4:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_dp : 16; /* bits 20:5 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ev2_pt : 5; /* bits 25:21 */
		ca_uint32_t cl_key_tre_cmrcmr_2_tag_num : 2; /* bits 27:26 */
		ca_uint32_t cl_key_tre_cmrcmr_2_top_802_1p : 3; /* bits 30:28 */
		ca_uint32_t cl_key_tre_cmrcmr_2_top_sc_ind : 1; /* bits 31:31 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_reserved : 32; /* bits 31:0 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_KEY_DATA0 0xf4301b7c
#define L2FE_CLE_EGR_KEY_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_key_orhr_ipv4e_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_orhr_ipv4e_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_orhr_ipv4e_mask : 22; /* bits 25:4 */
		ca_uint32_t cl_key_orhr_ipv4e_l7_ctrl : 2; /* bits 27:26 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_sp_ctrl : 2; /* bits 29:28 */
		ca_uint32_t cl_key_orhr_ipv4e_l4_dp_ctrl : 2; /* bits 31:30 */
	} bf0;
	struct {
		ca_uint32_t cl_key_orhr_ipv6e_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_orhr_ipv6e_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_orhr_ipv6e_mask : 8; /* bits 11:4 */
		ca_uint32_t cl_key_orhr_ipv6e_l4_ctrl : 3; /* bits 14:12 */
		ca_uint32_t cl_key_orhr_ipv6e_ip_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_orhr_ipv6e_flow_label : 15; /* bits 31:17 */
	} bf1;
	struct {
		ca_uint32_t cl_key_tre_l2rl2r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l2rl2r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l2rl2r_2_mask : 2; /* bits 5:4 */
		ca_uint32_t cl_key_tre_l2rl2r_2_l4_ctrl : 3; /* bits 8:6 */
		ca_uint32_t cl_key_tre_l2rl2r_2_dot1p_ctrl : 2; /* bits 10:9 */
		ca_uint32_t cl_key_tre_l2rl2r_2_vid_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l2rl2r_2_mac_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l2rl2r_2_l4_sp : 16; /* bits 30:15 */
		ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 1; /* bits 31:31 */
	} bf2;
	struct {
		ca_uint32_t cl_key_tre_l2rl3r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l2rl3r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l2rl3r_2_mask : 8; /* bits 11:4 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_ctrl : 3; /* bits 14:12 */
		ca_uint32_t cl_key_tre_l2rl3r_2_dot1p_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l2rl3r_2_vid_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l2rl3r_2_ip_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 11; /* bits 31:21 */
	} bf3;
	struct {
		ca_uint32_t cl_key_tre_l2rcmr_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l2rcmr_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l2rcmr_2_mask : 12; /* bits 15:4 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_ctrl : 3; /* bits 18:16 */
		ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr_sel : 1; /* bits 19:19 */
		ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr_sel : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 11; /* bits 31:21 */
	} bf4;
	struct {
		ca_uint32_t cl_key_tre_l3rl2r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rl2r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l3rl2r_2_mask : 2; /* bits 5:4 */
		ca_uint32_t cl_key_tre_l3rl2r_2_l4_ctrl : 3; /* bits 8:6 */
		ca_uint32_t cl_key_tre_l3rl2r_2_dot1p_ctrl : 2; /* bits 10:9 */
		ca_uint32_t cl_key_tre_l3rl2r_2_vid_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_l3rl2r_2_mac_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_l3rl2r_2_l4_sp : 16; /* bits 30:15 */
		ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 1; /* bits 31:31 */
	} bf5;
	struct {
		ca_uint32_t cl_key_tre_l3rl3r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rl3r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l3rl3r_2_mask : 8; /* bits 11:4 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_ctrl : 3; /* bits 14:12 */
		ca_uint32_t cl_key_tre_l3rl3r_2_dot1p_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_l3rl3r_2_vid_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_l3rl3r_2_ip_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 11; /* bits 31:21 */
	} bf6;
	struct {
		ca_uint32_t cl_key_tre_l3rcmr_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_l3rcmr_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_l3rcmr_2_mask : 12; /* bits 15:4 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_ctrl : 3; /* bits 18:16 */
		ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr_sel : 1; /* bits 19:19 */
		ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr_sel : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 11; /* bits 31:21 */
	} bf7;
	struct {
		ca_uint32_t cl_key_tre_cmrl2r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_cmrl2r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_cmrl2r_2_mask : 2; /* bits 5:4 */
		ca_uint32_t cl_key_tre_cmrl2r_2_l4_ctrl : 3; /* bits 8:6 */
		ca_uint32_t cl_key_tre_cmrl2r_2_dot1p_ctrl : 2; /* bits 10:9 */
		ca_uint32_t cl_key_tre_cmrl2r_2_vid_ctrl : 2; /* bits 12:11 */
		ca_uint32_t cl_key_tre_cmrl2r_2_mac_ctrl : 2; /* bits 14:13 */
		ca_uint32_t cl_key_tre_cmrl2r_2_l4_sp : 16; /* bits 30:15 */
		ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 1; /* bits 31:31 */
	} bf8;
	struct {
		ca_uint32_t cl_key_tre_cmrl3r_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_cmrl3r_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_cmrl3r_2_mask : 8; /* bits 11:4 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_ctrl : 3; /* bits 14:12 */
		ca_uint32_t cl_key_tre_cmrl3r_2_dot1p_ctrl : 2; /* bits 16:15 */
		ca_uint32_t cl_key_tre_cmrl3r_2_vid_ctrl : 2; /* bits 18:17 */
		ca_uint32_t cl_key_tre_cmrl3r_2_ip_ctrl : 2; /* bits 20:19 */
		ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 11; /* bits 31:21 */
	} bf9;
	struct {
		ca_uint32_t cl_key_tre_cmrcmr_2_prcd : 3; /* bits 2:0 */
		ca_uint32_t cl_key_tre_cmrcmr_2_fields_operator : 1; /* bits 3:3 */
		ca_uint32_t cl_key_tre_cmrcmr_2_mask : 12; /* bits 15:4 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_ctrl : 3; /* bits 18:16 */
		ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr_sel : 1; /* bits 19:19 */
		ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr_sel : 1; /* bits 20:20 */
		ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 11; /* bits 31:21 */
	} bf10;
	struct {
		ca_uint32_t cl_key_stre_reserved : 32; /* bits 31:0 */
	} bf11;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_KEY_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_FIB_ACCESS 0xf4301b80
#define L2FE_CLE_IGR_FIB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_FIB_DATA4 0xf4301b84
#define L2FE_CLE_IGR_FIB_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_inner_vid_0 : 10; /* bits 9:0 */
		ca_uint32_t cl_fib_xr_top_cmd_valid_0 : 1; /* bits 10:10 */
		ca_uint32_t cl_fib_xr_top_vlan_cmd_0 : 2; /* bits 12:11 */
		ca_uint32_t cl_fib_xr_top_sc_ind_0 : 1; /* bits 13:13 */
		ca_uint32_t cl_fib_xr_top_vid_0 : 12; /* bits 25:14 */
		ca_uint32_t cl_fib_xr_pkt_no_drop_0 : 1; /* bits 26:26 */
		ca_uint32_t cl_fib_xr_reserved_0 : 1; /* bits 27:27 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_FIB_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_FIB_DATA3 0xf4301b88
#define L2FE_CLE_IGR_FIB_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_flowid_0 : 1; /* bits 0:0 */
		ca_uint32_t cl_fib_xr_dp_valid_0 : 1; /* bits 1:1 */
		ca_uint32_t cl_fib_xr_ldpid_0 : 9; /* bits 10:2 */
		ca_uint32_t cl_fib_xr_cos_valid_0 : 1; /* bits 11:11 */
		ca_uint32_t cl_fib_xr_dscp_valid_0 : 1; /* bits 12:12 */
		ca_uint32_t cl_fib_xr_802_1p_valid_0 : 1; /* bits 13:13 */
		ca_uint32_t cl_fib_xr_cos_0 : 3; /* bits 16:14 */
		ca_uint32_t cl_fib_xr_dscp_0 : 6; /* bits 22:17 */
		ca_uint32_t cl_fib_xr_802_1p_0 : 3; /* bits 25:23 */
		ca_uint32_t cl_fib_xr_inner_cmd_valid_0 : 1; /* bits 26:26 */
		ca_uint32_t cl_fib_xr_inner_vlan_cmd_0 : 2; /* bits 28:27 */
		ca_uint32_t cl_fib_xr_inner_sc_ind_0 : 1; /* bits 29:29 */
		ca_uint32_t cl_fib_xr_inner_vid_0 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_FIB_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_FIB_DATA2 0xf4301b8c
#define L2FE_CLE_IGR_FIB_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_top_vid_1 : 12; /* bits 11:0 */
		ca_uint32_t cl_fib_xr_pkt_no_drop_1 : 1; /* bits 12:12 */
		ca_uint32_t cl_fib_xr_reserved_1 : 1; /* bits 13:13 */
		ca_uint32_t cl_fib_xr_stp_mode_0 : 2; /* bits 15:14 */
		ca_uint32_t cl_fib_xr_permit_valid_0 : 1; /* bits 16:16 */
		ca_uint32_t cl_fib_xr_permit_0 : 1; /* bits 17:17 */
		ca_uint32_t cl_fib_xr_premarked_0 : 1; /* bits 18:18 */
		ca_uint32_t cl_fib_xr_dscp_markdown_0 : 1; /* bits 19:19 */
		ca_uint32_t cl_fib_xr_mark_en_0 : 1; /* bits 20:20 */
		ca_uint32_t cl_fib_xr_flowid_0 : 11; /* bits 31:21 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_FIB_DATA1 0xf4301b90
#define L2FE_CLE_IGR_FIB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_cos_1 : 3; /* bits 2:0 */
		ca_uint32_t cl_fib_xr_dscp_1 : 6; /* bits 8:3 */
		ca_uint32_t cl_fib_xr_802_1p_1 : 3; /* bits 11:9 */
		ca_uint32_t cl_fib_xr_inner_cmd_valid_1 : 1; /* bits 12:12 */
		ca_uint32_t cl_fib_xr_inner_vlan_cmd_1 : 2; /* bits 14:13 */
		ca_uint32_t cl_fib_xr_inner_sc_ind_1 : 1; /* bits 15:15 */
		ca_uint32_t cl_fib_xr_inner_vid_1 : 12; /* bits 27:16 */
		ca_uint32_t cl_fib_xr_top_cmd_valid_1 : 1; /* bits 28:28 */
		ca_uint32_t cl_fib_xr_top_vlan_cmd_1 : 2; /* bits 30:29 */
		ca_uint32_t cl_fib_xr_top_sc_ind_1 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_IGR_FIB_DATA0 0xf4301b94
#define L2FE_CLE_IGR_FIB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_stp_mode_1 : 2; /* bits 1:0 */
		ca_uint32_t cl_fib_xr_permit_valid_1 : 1; /* bits 2:2 */
		ca_uint32_t cl_fib_xr_permit_1 : 1; /* bits 3:3 */
		ca_uint32_t cl_fib_xr_premarked_1 : 1; /* bits 4:4 */
		ca_uint32_t cl_fib_xr_dscp_markdown_1 : 1; /* bits 5:5 */
		ca_uint32_t cl_fib_xr_mark_en_1 : 1; /* bits 6:6 */
		ca_uint32_t cl_fib_xr_flowid_1 : 12; /* bits 18:7 */
		ca_uint32_t cl_fib_xr_dp_valid_1 : 1; /* bits 19:19 */
		ca_uint32_t cl_fib_xr_ldpid_1 : 9; /* bits 28:20 */
		ca_uint32_t cl_fib_xr_cos_valid_1 : 1; /* bits 29:29 */
		ca_uint32_t cl_fib_xr_dscp_valid_1 : 1; /* bits 30:30 */
		ca_uint32_t cl_fib_xr_802_1p_valid_1 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_IGR_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_FIB_ACCESS 0xf4301b98
#define L2FE_CLE_EGR_FIB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_FIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_FIB_DATA4 0xf4301b9c
#define L2FE_CLE_EGR_FIB_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_inner_vid_0 : 10; /* bits 9:0 */
		ca_uint32_t cl_fib_xr_top_cmd_valid_0 : 1; /* bits 10:10 */
		ca_uint32_t cl_fib_xr_top_vlan_cmd_0 : 2; /* bits 12:11 */
		ca_uint32_t cl_fib_xr_top_sc_ind_0 : 1; /* bits 13:13 */
		ca_uint32_t cl_fib_xr_top_vid_0 : 12; /* bits 25:14 */
		ca_uint32_t cl_fib_xr_pkt_no_drop_0 : 1; /* bits 26:26 */
		ca_uint32_t cl_fib_xr_reserved_0 : 1; /* bits 27:27 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_FIB_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_FIB_DATA3 0xf4301ba0
#define L2FE_CLE_EGR_FIB_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_flowid_0 : 1; /* bits 0:0 */
		ca_uint32_t cl_fib_xr_dp_valid_0 : 1; /* bits 1:1 */
		ca_uint32_t cl_fib_xr_ldpid_0 : 9; /* bits 10:2 */
		ca_uint32_t cl_fib_xr_cos_valid_0 : 1; /* bits 11:11 */
		ca_uint32_t cl_fib_xr_dscp_valid_0 : 1; /* bits 12:12 */
		ca_uint32_t cl_fib_xr_802_1p_valid_0 : 1; /* bits 13:13 */
		ca_uint32_t cl_fib_xr_cos_0 : 3; /* bits 16:14 */
		ca_uint32_t cl_fib_xr_dscp_0 : 6; /* bits 22:17 */
		ca_uint32_t cl_fib_xr_802_1p_0 : 3; /* bits 25:23 */
		ca_uint32_t cl_fib_xr_inner_cmd_valid_0 : 1; /* bits 26:26 */
		ca_uint32_t cl_fib_xr_inner_vlan_cmd_0 : 2; /* bits 28:27 */
		ca_uint32_t cl_fib_xr_inner_sc_ind_0 : 1; /* bits 29:29 */
		ca_uint32_t cl_fib_xr_inner_vid_0 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_FIB_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_FIB_DATA2 0xf4301ba4
#define L2FE_CLE_EGR_FIB_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_top_vid_1 : 12; /* bits 11:0 */
		ca_uint32_t cl_fib_xr_pkt_no_drop_1 : 1; /* bits 12:12 */
		ca_uint32_t cl_fib_xr_reserved_1 : 1; /* bits 13:13 */
		ca_uint32_t cl_fib_xr_stp_mode_0 : 2; /* bits 15:14 */
		ca_uint32_t cl_fib_xr_permit_valid_0 : 1; /* bits 16:16 */
		ca_uint32_t cl_fib_xr_permit_0 : 1; /* bits 17:17 */
		ca_uint32_t cl_fib_xr_premarked_0 : 1; /* bits 18:18 */
		ca_uint32_t cl_fib_xr_dscp_markdown_0 : 1; /* bits 19:19 */
		ca_uint32_t cl_fib_xr_mark_en_0 : 1; /* bits 20:20 */
		ca_uint32_t cl_fib_xr_flowid_0 : 11; /* bits 31:21 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_FIB_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_FIB_DATA1 0xf4301ba8
#define L2FE_CLE_EGR_FIB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_cos_1 : 3; /* bits 2:0 */
		ca_uint32_t cl_fib_xr_dscp_1 : 6; /* bits 8:3 */
		ca_uint32_t cl_fib_xr_802_1p_1 : 3; /* bits 11:9 */
		ca_uint32_t cl_fib_xr_inner_cmd_valid_1 : 1; /* bits 12:12 */
		ca_uint32_t cl_fib_xr_inner_vlan_cmd_1 : 2; /* bits 14:13 */
		ca_uint32_t cl_fib_xr_inner_sc_ind_1 : 1; /* bits 15:15 */
		ca_uint32_t cl_fib_xr_inner_vid_1 : 12; /* bits 27:16 */
		ca_uint32_t cl_fib_xr_top_cmd_valid_1 : 1; /* bits 28:28 */
		ca_uint32_t cl_fib_xr_top_vlan_cmd_1 : 2; /* bits 30:29 */
		ca_uint32_t cl_fib_xr_top_sc_ind_1 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_FIB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_CLE_EGR_FIB_DATA0 0xf4301bac
#define L2FE_CLE_EGR_FIB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_fib_xr_stp_mode_1 : 2; /* bits 1:0 */
		ca_uint32_t cl_fib_xr_permit_valid_1 : 1; /* bits 2:2 */
		ca_uint32_t cl_fib_xr_permit_1 : 1; /* bits 3:3 */
		ca_uint32_t cl_fib_xr_premarked_1 : 1; /* bits 4:4 */
		ca_uint32_t cl_fib_xr_dscp_markdown_1 : 1; /* bits 5:5 */
		ca_uint32_t cl_fib_xr_mark_en_1 : 1; /* bits 6:6 */
		ca_uint32_t cl_fib_xr_flowid_1 : 12; /* bits 18:7 */
		ca_uint32_t cl_fib_xr_dp_valid_1 : 1; /* bits 19:19 */
		ca_uint32_t cl_fib_xr_ldpid_1 : 9; /* bits 28:20 */
		ca_uint32_t cl_fib_xr_cos_valid_1 : 1; /* bits 29:29 */
		ca_uint32_t cl_fib_xr_dscp_valid_1 : 1; /* bits 30:30 */
		ca_uint32_t cl_fib_xr_802_1p_valid_1 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_CLE_EGR_FIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLE */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_CLE_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_CLE_CONFG_STTS1_t CONFG_STTS1; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_CLE_CONFG_STTS2_t CONFG_STTS2; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_CLE_DEBUG_t DEBUG; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_CLE_IGR_KEY_ACCESS_t IGR_KEY_ACCESS; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_CLE_IGR_KEY_DATA12_t IGR_KEY_DATA12; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_CLE_IGR_KEY_DATA11_t IGR_KEY_DATA11; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_CLE_IGR_KEY_DATA10_t IGR_KEY_DATA10; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_CLE_IGR_KEY_DATA9_t IGR_KEY_DATA9; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_CLE_IGR_KEY_DATA8_t IGR_KEY_DATA8; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_CLE_IGR_KEY_DATA7_t IGR_KEY_DATA7; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_CLE_IGR_KEY_DATA6_t IGR_KEY_DATA6; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_CLE_IGR_KEY_DATA5_t IGR_KEY_DATA5; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_CLE_IGR_KEY_DATA4_t IGR_KEY_DATA4; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_CLE_IGR_KEY_DATA3_t IGR_KEY_DATA3; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_CLE_IGR_KEY_DATA2_t IGR_KEY_DATA2; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_CLE_IGR_KEY_DATA1_t IGR_KEY_DATA1; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_CLE_IGR_KEY_DATA0_t IGR_KEY_DATA0; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_CLE_EGR_KEY_ACCESS_t EGR_KEY_ACCESS; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_CLE_EGR_KEY_DATA12_t EGR_KEY_DATA12; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_CLE_EGR_KEY_DATA11_t EGR_KEY_DATA11; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2FE_CLE_EGR_KEY_DATA10_t EGR_KEY_DATA10; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2FE_CLE_EGR_KEY_DATA9_t EGR_KEY_DATA9; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L2FE_CLE_EGR_KEY_DATA8_t EGR_KEY_DATA8; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L2FE_CLE_EGR_KEY_DATA7_t EGR_KEY_DATA7; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L2FE_CLE_EGR_KEY_DATA6_t EGR_KEY_DATA6; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L2FE_CLE_EGR_KEY_DATA5_t EGR_KEY_DATA5; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L2FE_CLE_EGR_KEY_DATA4_t EGR_KEY_DATA4; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L2FE_CLE_EGR_KEY_DATA3_t EGR_KEY_DATA3; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L2FE_CLE_EGR_KEY_DATA2_t EGR_KEY_DATA2; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L2FE_CLE_EGR_KEY_DATA1_t EGR_KEY_DATA1; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L2FE_CLE_EGR_KEY_DATA0_t EGR_KEY_DATA0; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L2FE_CLE_IGR_FIB_ACCESS_t IGR_FIB_ACCESS; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L2FE_CLE_IGR_FIB_DATA4_t IGR_FIB_DATA4; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L2FE_CLE_IGR_FIB_DATA3_t IGR_FIB_DATA3; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L2FE_CLE_IGR_FIB_DATA2_t IGR_FIB_DATA2; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	L2FE_CLE_IGR_FIB_DATA1_t IGR_FIB_DATA1; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	L2FE_CLE_IGR_FIB_DATA0_t IGR_FIB_DATA0; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	L2FE_CLE_EGR_FIB_ACCESS_t EGR_FIB_ACCESS; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	L2FE_CLE_EGR_FIB_DATA4_t EGR_FIB_DATA4; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	L2FE_CLE_EGR_FIB_DATA3_t EGR_FIB_DATA3; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	L2FE_CLE_EGR_FIB_DATA2_t EGR_FIB_DATA2; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	L2FE_CLE_EGR_FIB_DATA1_t EGR_FIB_DATA1; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd43[3];
	L2FE_CLE_EGR_FIB_DATA0_t EGR_FIB_DATA0; /* addr: 0x000000ac */
} APB0_L2FE_CLE_t;
#endif /* !__ASSEMBLER__ */

/*
 * L2E
 */

#define L2FE_L2E_CTRL 0xf4301c00
#define L2FE_L2E_CTRL_dft 0x1ca00ff9

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aging_en : 1; /* bits 0:0 */
		ca_uint32_t tmp_entry_aging_dis : 1; /* bits 1:1 */
		ca_uint32_t aging_mode : 1; /* bits 2:2 */
		ca_uint32_t aging_start_val : 8; /* bits 10:3 */
		ca_uint32_t st_move_en : 1; /* bits 11:11 */
		ca_uint32_t sw_age_entry_scan : 1; /* bits 12:12 */
		ca_uint32_t st_mv_window : 9; /* bits 21:13 */
		ca_uint32_t lrn_dis : 1; /* bits 22:22 */
		ca_uint32_t lrn_mode : 2; /* bits 24:23 */
		ca_uint32_t hash_collision_overwrite : 1; /* bits 25:25 */
		ca_uint32_t hashing_mode : 2; /* bits 27:26 */
		ca_uint32_t da_deny_dnt_lrn : 1; /* bits 28:28 */
		ca_uint32_t ovfl_entries_rcyc_en : 1; /* bits 29:29 */
		ca_uint32_t info_ff_init : 1; /* bits 30:30 */
		ca_uint32_t cpu_opt_mode : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_AGING_CTRL 0xf4301c04
#define L2FE_L2E_AGING_CTRL_dft 0x77b0012c

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t aging_out_time : 19; /* bits 18:0 */
		ca_uint32_t cnt_to_1s : 13; /* bits 31:19 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_AGING_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_SW_AGING_CPT_ENTRY_3 0xf4301c08
#define L2FE_L2E_SW_AGING_CPT_ENTRY_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_SW_AGING_CPT_ENTRY_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_SW_AGING_CPT_ENTRY_2 0xf4301c0c
#define L2FE_L2E_SW_AGING_CPT_ENTRY_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_SW_AGING_CPT_ENTRY_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_SW_AGING_CPT_ENTRY_1 0xf4301c10
#define L2FE_L2E_SW_AGING_CPT_ENTRY_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_SW_AGING_CPT_ENTRY_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_SW_AGING_CPT_ENTRY_0 0xf4301c14
#define L2FE_L2E_SW_AGING_CPT_ENTRY_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_SW_AGING_CPT_ENTRY_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_CPU_CMD_WORD4 0xf4301c18
#define L2FE_L2E_FDB_CPU_CMD_WORD4_dft 0x00007fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t word : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_CPU_CMD_WORD4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_CPU_CMD_WORD3 0xf4301c1c
#define L2FE_L2E_FDB_CPU_CMD_WORD3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t word : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_CPU_CMD_WORD3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_CPU_CMD_WORD2 0xf4301c20
#define L2FE_L2E_FDB_CPU_CMD_WORD2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t word : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_CPU_CMD_WORD2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_CPU_CMD_WORD1 0xf4301c24
#define L2FE_L2E_FDB_CPU_CMD_WORD1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t word : 27; /* bits 26:0 */
		ca_uint32_t rsrvd1 : 5;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_CPU_CMD_WORD1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_CPU_CMD_WORD0 0xf4301c28
#define L2FE_L2E_FDB_CPU_CMD_WORD0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t word : 27; /* bits 26:0 */
		ca_uint32_t rsrvd1 : 5;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_CPU_CMD_WORD0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_CMD_RETURN 0xf4301c2c
#define L2FE_L2E_FDB_CMD_RETURN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t status : 4; /* bits 3:0 */
		ca_uint32_t ext_status : 13; /* bits 16:4 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_CMD_RETURN_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_CNT_CMD_RETURN 0xf4301c30
#define L2FE_L2E_CNT_CMD_RETURN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t status : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_CNT_CMD_RETURN_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_PORT_MAC_CNT_STTS_0 0xf4301c34
#define L2FE_L2E_PORT_MAC_CNT_STTS_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t underflow_0 : 1; /* bits 0:0 */
		ca_uint32_t underflow_1 : 1; /* bits 1:1 */
		ca_uint32_t underflow_2 : 1; /* bits 2:2 */
		ca_uint32_t underflow_3 : 1; /* bits 3:3 */
		ca_uint32_t underflow_4 : 1; /* bits 4:4 */
		ca_uint32_t underflow_5 : 1; /* bits 5:5 */
		ca_uint32_t underflow_6 : 1; /* bits 6:6 */
		ca_uint32_t underflow_7 : 1; /* bits 7:7 */
		ca_uint32_t underflow_8 : 1; /* bits 8:8 */
		ca_uint32_t underflow_9 : 1; /* bits 9:9 */
		ca_uint32_t underflow_10 : 1; /* bits 10:10 */
		ca_uint32_t underflow_11 : 1; /* bits 11:11 */
		ca_uint32_t underflow_12 : 1; /* bits 12:12 */
		ca_uint32_t underflow_13 : 1; /* bits 13:13 */
		ca_uint32_t underflow_14 : 1; /* bits 14:14 */
		ca_uint32_t underflow_15 : 1; /* bits 15:15 */
		ca_uint32_t underflow_16 : 1; /* bits 16:16 */
		ca_uint32_t underflow_17 : 1; /* bits 17:17 */
		ca_uint32_t underflow_18 : 1; /* bits 18:18 */
		ca_uint32_t underflow_19 : 1; /* bits 19:19 */
		ca_uint32_t underflow_20 : 1; /* bits 20:20 */
		ca_uint32_t underflow_21 : 1; /* bits 21:21 */
		ca_uint32_t underflow_22 : 1; /* bits 22:22 */
		ca_uint32_t underflow_23 : 1; /* bits 23:23 */
		ca_uint32_t underflow_24 : 1; /* bits 24:24 */
		ca_uint32_t underflow_25 : 1; /* bits 25:25 */
		ca_uint32_t underflow_26 : 1; /* bits 26:26 */
		ca_uint32_t underflow_27 : 1; /* bits 27:27 */
		ca_uint32_t underflow_28 : 1; /* bits 28:28 */
		ca_uint32_t underflow_29 : 1; /* bits 29:29 */
		ca_uint32_t underflow_30 : 1; /* bits 30:30 */
		ca_uint32_t underflow_31 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_PORT_MAC_CNT_STTS_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_PORT_MAC_CNT_STTS_1 0xf4301c38
#define L2FE_L2E_PORT_MAC_CNT_STTS_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t underflow_0 : 1; /* bits 0:0 */
		ca_uint32_t underflow_1 : 1; /* bits 1:1 */
		ca_uint32_t underflow_2 : 1; /* bits 2:2 */
		ca_uint32_t underflow_3 : 1; /* bits 3:3 */
		ca_uint32_t underflow_4 : 1; /* bits 4:4 */
		ca_uint32_t underflow_5 : 1; /* bits 5:5 */
		ca_uint32_t underflow_6 : 1; /* bits 6:6 */
		ca_uint32_t underflow_7 : 1; /* bits 7:7 */
		ca_uint32_t underflow_8 : 1; /* bits 8:8 */
		ca_uint32_t underflow_9 : 1; /* bits 9:9 */
		ca_uint32_t underflow_10 : 1; /* bits 10:10 */
		ca_uint32_t underflow_11 : 1; /* bits 11:11 */
		ca_uint32_t underflow_12 : 1; /* bits 12:12 */
		ca_uint32_t underflow_13 : 1; /* bits 13:13 */
		ca_uint32_t underflow_14 : 1; /* bits 14:14 */
		ca_uint32_t underflow_15 : 1; /* bits 15:15 */
		ca_uint32_t underflow_16 : 1; /* bits 16:16 */
		ca_uint32_t underflow_17 : 1; /* bits 17:17 */
		ca_uint32_t underflow_18 : 1; /* bits 18:18 */
		ca_uint32_t underflow_19 : 1; /* bits 19:19 */
		ca_uint32_t underflow_20 : 1; /* bits 20:20 */
		ca_uint32_t underflow_21 : 1; /* bits 21:21 */
		ca_uint32_t underflow_22 : 1; /* bits 22:22 */
		ca_uint32_t underflow_23 : 1; /* bits 23:23 */
		ca_uint32_t underflow_24 : 1; /* bits 24:24 */
		ca_uint32_t underflow_25 : 1; /* bits 25:25 */
		ca_uint32_t underflow_26 : 1; /* bits 26:26 */
		ca_uint32_t underflow_27 : 1; /* bits 27:27 */
		ca_uint32_t underflow_28 : 1; /* bits 28:28 */
		ca_uint32_t underflow_29 : 1; /* bits 29:29 */
		ca_uint32_t underflow_30 : 1; /* bits 30:30 */
		ca_uint32_t underflow_31 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_PORT_MAC_CNT_STTS_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0 0xf4301c3c
#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t excd_0 : 1; /* bits 0:0 */
		ca_uint32_t excd_1 : 1; /* bits 1:1 */
		ca_uint32_t excd_2 : 1; /* bits 2:2 */
		ca_uint32_t excd_3 : 1; /* bits 3:3 */
		ca_uint32_t excd_4 : 1; /* bits 4:4 */
		ca_uint32_t excd_5 : 1; /* bits 5:5 */
		ca_uint32_t excd_6 : 1; /* bits 6:6 */
		ca_uint32_t excd_7 : 1; /* bits 7:7 */
		ca_uint32_t excd_8 : 1; /* bits 8:8 */
		ca_uint32_t excd_9 : 1; /* bits 9:9 */
		ca_uint32_t excd_10 : 1; /* bits 10:10 */
		ca_uint32_t excd_11 : 1; /* bits 11:11 */
		ca_uint32_t excd_12 : 1; /* bits 12:12 */
		ca_uint32_t excd_13 : 1; /* bits 13:13 */
		ca_uint32_t excd_14 : 1; /* bits 14:14 */
		ca_uint32_t excd_15 : 1; /* bits 15:15 */
		ca_uint32_t excd_16 : 1; /* bits 16:16 */
		ca_uint32_t excd_17 : 1; /* bits 17:17 */
		ca_uint32_t excd_18 : 1; /* bits 18:18 */
		ca_uint32_t excd_19 : 1; /* bits 19:19 */
		ca_uint32_t excd_20 : 1; /* bits 20:20 */
		ca_uint32_t excd_21 : 1; /* bits 21:21 */
		ca_uint32_t excd_22 : 1; /* bits 22:22 */
		ca_uint32_t excd_23 : 1; /* bits 23:23 */
		ca_uint32_t excd_24 : 1; /* bits 24:24 */
		ca_uint32_t excd_25 : 1; /* bits 25:25 */
		ca_uint32_t excd_26 : 1; /* bits 26:26 */
		ca_uint32_t excd_27 : 1; /* bits 27:27 */
		ca_uint32_t excd_28 : 1; /* bits 28:28 */
		ca_uint32_t excd_29 : 1; /* bits 29:29 */
		ca_uint32_t excd_30 : 1; /* bits 30:30 */
		ca_uint32_t excd_31 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1 0xf4301c40
#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t excd_0 : 1; /* bits 0:0 */
		ca_uint32_t excd_1 : 1; /* bits 1:1 */
		ca_uint32_t excd_2 : 1; /* bits 2:2 */
		ca_uint32_t excd_3 : 1; /* bits 3:3 */
		ca_uint32_t excd_4 : 1; /* bits 4:4 */
		ca_uint32_t excd_5 : 1; /* bits 5:5 */
		ca_uint32_t excd_6 : 1; /* bits 6:6 */
		ca_uint32_t excd_7 : 1; /* bits 7:7 */
		ca_uint32_t excd_8 : 1; /* bits 8:8 */
		ca_uint32_t excd_9 : 1; /* bits 9:9 */
		ca_uint32_t excd_10 : 1; /* bits 10:10 */
		ca_uint32_t excd_11 : 1; /* bits 11:11 */
		ca_uint32_t excd_12 : 1; /* bits 12:12 */
		ca_uint32_t excd_13 : 1; /* bits 13:13 */
		ca_uint32_t excd_14 : 1; /* bits 14:14 */
		ca_uint32_t excd_15 : 1; /* bits 15:15 */
		ca_uint32_t excd_16 : 1; /* bits 16:16 */
		ca_uint32_t excd_17 : 1; /* bits 17:17 */
		ca_uint32_t excd_18 : 1; /* bits 18:18 */
		ca_uint32_t excd_19 : 1; /* bits 19:19 */
		ca_uint32_t excd_20 : 1; /* bits 20:20 */
		ca_uint32_t excd_21 : 1; /* bits 21:21 */
		ca_uint32_t excd_22 : 1; /* bits 22:22 */
		ca_uint32_t excd_23 : 1; /* bits 23:23 */
		ca_uint32_t excd_24 : 1; /* bits 24:24 */
		ca_uint32_t excd_25 : 1; /* bits 25:25 */
		ca_uint32_t excd_26 : 1; /* bits 26:26 */
		ca_uint32_t excd_27 : 1; /* bits 27:27 */
		ca_uint32_t excd_28 : 1; /* bits 28:28 */
		ca_uint32_t excd_29 : 1; /* bits 29:29 */
		ca_uint32_t excd_30 : 1; /* bits 30:30 */
		ca_uint32_t excd_31 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_HASH_CLLSN_STTS 0xf4301c44
#define L2FE_L2E_HASH_CLLSN_STTS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cllsn_det : 1; /* bits 0:0 */
		ca_uint32_t cllsn_addr : 9; /* bits 9:1 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_HASH_CLLSN_STTS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_L2E_LRN_STS 0xf4301c48
#define L2FE_L2E_L2E_LRN_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t loop_det : 1; /* bits 0:0 */
		ca_uint32_t hit_tmp_entry_sm : 1; /* bits 1:1 */
		ca_uint32_t hit_static_entry_sm : 1; /* bits 2:2 */
		ca_uint32_t hit_sm_entry_sm : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_L2E_LRN_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_SW_AGING_REPORT_FIFO_STTS 0xf4301c4c
#define L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cpt_entry_flg : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t cnt : 4; /* bits 7:4 */
		ca_uint32_t rsrvd2 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_POINTER_FF_STS_REG 0xf4301c50
#define L2FE_L2E_POINTER_FF_STS_REG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t overflow_ind : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_POINTER_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_POINTER_FF_CNT 0xf4301c54
#define L2FE_L2E_POINTER_FF_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_POINTER_FF_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_STS_REG 0xf4301c58
#define L2FE_L2E_INFO_FF_STS_REG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t overflow_ind : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_0 0xf4301c5c
#define L2FE_L2E_INFO_FF_CNT_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_1 0xf4301c60
#define L2FE_L2E_INFO_FF_CNT_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_2 0xf4301c64
#define L2FE_L2E_INFO_FF_CNT_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_3 0xf4301c68
#define L2FE_L2E_INFO_FF_CNT_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_4 0xf4301c6c
#define L2FE_L2E_INFO_FF_CNT_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_5 0xf4301c70
#define L2FE_L2E_INFO_FF_CNT_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_5_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_6 0xf4301c74
#define L2FE_L2E_INFO_FF_CNT_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_6_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_7 0xf4301c78
#define L2FE_L2E_INFO_FF_CNT_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_7_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_8 0xf4301c7c
#define L2FE_L2E_INFO_FF_CNT_8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_8_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_9 0xf4301c80
#define L2FE_L2E_INFO_FF_CNT_9_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_9_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_10 0xf4301c84
#define L2FE_L2E_INFO_FF_CNT_10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_10_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_11 0xf4301c88
#define L2FE_L2E_INFO_FF_CNT_11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_11_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_12 0xf4301c8c
#define L2FE_L2E_INFO_FF_CNT_12_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_12_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_13 0xf4301c90
#define L2FE_L2E_INFO_FF_CNT_13_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_13_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_14 0xf4301c94
#define L2FE_L2E_INFO_FF_CNT_14_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_14_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_INFO_FF_CNT_15 0xf4301c98
#define L2FE_L2E_INFO_FF_CNT_15_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_INFO_FF_CNT_15_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_L3FE_RFSH_STS 0xf4301c9c
#define L2FE_L2E_L3FE_RFSH_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rfsh_entry_ovfl : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_L3FE_RFSH_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_DEBUG_BUS 0xf4301ca0
#define L2FE_L2E_DEBUG_BUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_DEBUG_BUS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_ACCESS 0xf4301ca4
#define L2FE_L2E_FDB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 21; /* bits 20:0 */
		ca_uint32_t rsrvd1 : 9;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_DATA3 0xf4301ca8
#define L2FE_L2E_FDB_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_addr : 3; /* bits 2:0 */
		ca_uint32_t lrned_tag_vld : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_DATA2 0xf4301cac
#define L2FE_L2E_FDB_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_addr : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_DATA1 0xf4301cb0
#define L2FE_L2E_FDB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lrned_vid : 3; /* bits 2:0 */
		ca_uint32_t key_dot1p : 3; /* bits 5:3 */
		ca_uint32_t key_scind : 1; /* bits 6:6 */
		ca_uint32_t key_vid : 12; /* bits 18:7 */
		ca_uint32_t mac_addr : 13; /* bits 31:19 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_FDB_DATA0 0xf4301cb4
#define L2FE_L2E_FDB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mcgid : 10; /* bits 9:0 */
		ca_uint32_t mc_flag : 1; /* bits 10:10 */
		ca_uint32_t aging_sts : 8; /* bits 18:11 */
		ca_uint32_t is_static : 1; /* bits 19:19 */
		ca_uint32_t da_permit : 1; /* bits 20:20 */
		ca_uint32_t sa_permit : 1; /* bits 21:21 */
		ca_uint32_t lrned_scind : 1; /* bits 22:22 */
		ca_uint32_t lrned_vid : 9; /* bits 31:23 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_FDB_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS 0xf4301cb8
#define L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_PORT_MAC_CNT_LMT_DATA 0xf4301cbc
#define L2FE_L2E_PORT_MAC_CNT_LMT_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t val : 13; /* bits 12:0 */
		ca_uint32_t rsrvd1 : 19;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_L2E_AGING_CTRL_EXT 0xf4301cc0
#define L2FE_L2E_AGING_CTRL_EXT_dft 0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sw_lrn_aging_start_val : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_L2E_AGING_CTRL_EXT_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2E */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_L2E_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_L2E_AGING_CTRL_t AGING_CTRL; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_L2E_SW_AGING_CPT_ENTRY_3_t SW_AGING_CPT_ENTRY_3; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_L2E_SW_AGING_CPT_ENTRY_2_t SW_AGING_CPT_ENTRY_2; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_L2E_SW_AGING_CPT_ENTRY_1_t SW_AGING_CPT_ENTRY_1; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_L2E_SW_AGING_CPT_ENTRY_0_t SW_AGING_CPT_ENTRY_0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_L2E_FDB_CPU_CMD_WORD4_t FDB_CPU_CMD_WORD4; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_L2E_FDB_CPU_CMD_WORD3_t FDB_CPU_CMD_WORD3; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_L2E_FDB_CPU_CMD_WORD2_t FDB_CPU_CMD_WORD2; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_L2E_FDB_CPU_CMD_WORD1_t FDB_CPU_CMD_WORD1; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_L2E_FDB_CPU_CMD_WORD0_t FDB_CPU_CMD_WORD0; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_L2E_FDB_CMD_RETURN_t FDB_CMD_RETURN; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_L2E_CNT_CMD_RETURN_t CNT_CMD_RETURN; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_L2E_PORT_MAC_CNT_STTS_0_t PORT_MAC_CNT_STTS_0; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_L2E_PORT_MAC_CNT_STTS_1_t PORT_MAC_CNT_STTS_1; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t
	  PORT_MAC_LMT_CHK_STTS_0; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t
	  PORT_MAC_LMT_CHK_STTS_1; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_L2E_HASH_CLLSN_STTS_t HASH_CLLSN_STTS; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_L2E_L2E_LRN_STS_t L2E_LRN_STS; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t
	  SW_AGING_REPORT_FIFO_STTS; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_L2E_POINTER_FF_STS_REG_t POINTER_FF_STS_REG; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2FE_L2E_POINTER_FF_CNT_t POINTER_FF_CNT; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2FE_L2E_INFO_FF_STS_REG_t INFO_FF_STS_REG; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L2FE_L2E_INFO_FF_CNT_0_t INFO_FF_CNT_0; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L2FE_L2E_INFO_FF_CNT_1_t INFO_FF_CNT_1; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L2FE_L2E_INFO_FF_CNT_2_t INFO_FF_CNT_2; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L2FE_L2E_INFO_FF_CNT_3_t INFO_FF_CNT_3; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L2FE_L2E_INFO_FF_CNT_4_t INFO_FF_CNT_4; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L2FE_L2E_INFO_FF_CNT_5_t INFO_FF_CNT_5; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L2FE_L2E_INFO_FF_CNT_6_t INFO_FF_CNT_6; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L2FE_L2E_INFO_FF_CNT_7_t INFO_FF_CNT_7; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L2FE_L2E_INFO_FF_CNT_8_t INFO_FF_CNT_8; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L2FE_L2E_INFO_FF_CNT_9_t INFO_FF_CNT_9; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L2FE_L2E_INFO_FF_CNT_10_t INFO_FF_CNT_10; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L2FE_L2E_INFO_FF_CNT_11_t INFO_FF_CNT_11; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L2FE_L2E_INFO_FF_CNT_12_t INFO_FF_CNT_12; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	L2FE_L2E_INFO_FF_CNT_13_t INFO_FF_CNT_13; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	L2FE_L2E_INFO_FF_CNT_14_t INFO_FF_CNT_14; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	L2FE_L2E_INFO_FF_CNT_15_t INFO_FF_CNT_15; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	L2FE_L2E_L3FE_RFSH_STS_t L3FE_RFSH_STS; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	L2FE_L2E_DEBUG_BUS_t DEBUG_BUS; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	L2FE_L2E_FDB_ACCESS_t FDB_ACCESS; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	L2FE_L2E_FDB_DATA3_t FDB_DATA3; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd43[3];
	L2FE_L2E_FDB_DATA2_t FDB_DATA2; /* addr: 0x000000ac */
	ca_uint32_t rsrvd44[3];
	L2FE_L2E_FDB_DATA1_t FDB_DATA1; /* addr: 0x000000b0 */
	ca_uint32_t rsrvd45[3];
	L2FE_L2E_FDB_DATA0_t FDB_DATA0; /* addr: 0x000000b4 */
	ca_uint32_t rsrvd46[3];
	L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t
	  PORT_MAC_CNT_LMT_ACCESS; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd47[3];
	L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t PORT_MAC_CNT_LMT_DATA; /* addr: 0x000000bc */
	ca_uint32_t rsrvd48[3];
	L2FE_L2E_AGING_CTRL_EXT_t AGING_CTRL_EXT; /* addr: 0x000000c0 */
} APB0_L2FE_L2E_t;
#endif /* !__ASSEMBLER__ */

/*
 * IM3E
 */

#define L2FE_IM3E_CTRL 0xf4301e00
#define L2FE_IM3E_CTRL_dft 0x000000e4

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t da_use_l2_addr : 1; /* bits 0:0 */
		ca_uint32_t sa_use_l2_addr : 1; /* bits 1:1 */
		ca_uint32_t use_l3mc_lkup : 1; /* bits 2:2 */
		ca_uint32_t igmp_no_vlan_srch : 1; /* bits 3:3 */
		ca_uint32_t mld_no_vlan_srch : 1; /* bits 4:4 */
		ca_uint32_t mcu_oprt_mode : 1; /* bits 5:5 */
		ca_uint32_t igmp_no_port_src_srch : 1; /* bits 6:6 */
		ca_uint32_t mld_no_port_src_srch : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS 0xf4301e04
#define L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vld_entries_num : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS 0xf4301e08
#define L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vld_entries_num : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_STTS1 0xf4301e0c
#define L2FE_IM3E_STTS1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t da_cmd_oprt_incmpted : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_STTS1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_STTS2 0xf4301e10
#define L2FE_IM3E_STTS2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sa_cmd_oprt_incmpted : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_STTS2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_DEBUG 0xf4301e14
#define L2FE_IM3E_DEBUG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bus_sel : 2; /* bits 1:0 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_DEBUG_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDDA_ACCESS 0xf4301e18
#define L2FE_IM3E_MLDDA_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDDA_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDDA_DATA5 0xf4301e1c
#define L2FE_IM3E_MLDDA_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vid : 1; /* bits 0:0 */
		ca_uint32_t vlan_sc_ind : 1; /* bits 1:1 */
		ca_uint32_t wan_ind : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDDA_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDDA_DATA4 0xf4301e20
#define L2FE_IM3E_MLDDA_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ip_da : 20; /* bits 19:0 */
		ca_uint32_t ipv6_flg : 1; /* bits 20:20 */
		ca_uint32_t vid : 11; /* bits 31:21 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDDA_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDDA_DATA3 0xf4301e24
#define L2FE_IM3E_MLDDA_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ip_da : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDDA_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDDA_DATA2 0xf4301e28
#define L2FE_IM3E_MLDDA_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ip_da : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDDA_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDDA_DATA1 0xf4301e2c
#define L2FE_IM3E_MLDDA_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ip_da : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDDA_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDDA_DATA0 0xf4301e30
#define L2FE_IM3E_MLDDA_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t entry_valid : 1; /* bits 0:0 */
		ca_uint32_t mc_group_id : 10; /* bits 10:1 */
		ca_uint32_t v3_ind : 1; /* bits 11:11 */
		ca_uint32_t connection_id : 8; /* bits 19:12 */
		ca_uint32_t ip_da : 12; /* bits 31:20 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDDA_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDSA_ACCESS 0xf4301e34
#define L2FE_IM3E_MLDSA_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDSA_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDSA_DATA4 0xf4301e38
#define L2FE_IM3E_MLDSA_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ipv6_sa : 11; /* bits 10:0 */
		ca_uint32_t connection_id : 8; /* bits 18:11 */
		ca_uint32_t rsrvd1 : 13;
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDSA_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDSA_DATA3 0xf4301e3c
#define L2FE_IM3E_MLDSA_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ipv6_sa : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDSA_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDSA_DATA2 0xf4301e40
#define L2FE_IM3E_MLDSA_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ipv6_sa : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDSA_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDSA_DATA1 0xf4301e44
#define L2FE_IM3E_MLDSA_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ipv6_sa : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDSA_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_IM3E_MLDSA_DATA0 0xf4301e48
#define L2FE_IM3E_MLDSA_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t entry_valid : 1; /* bits 0:0 */
		ca_uint32_t mc_group_id : 10; /* bits 10:1 */
		ca_uint32_t ipv6_sa : 21; /* bits 31:11 */
	} bf;
	ca_uint32_t wrd;
} L2FE_IM3E_MLDSA_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* IM3E */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_IM3E_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_t
	  MLDDA_TBL_INDRCT_ACCESS; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_t
	  MLDSA_TBL_INDRCT_ACCESS; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_IM3E_STTS1_t STTS1; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_IM3E_STTS2_t STTS2; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_IM3E_DEBUG_t DEBUG; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_IM3E_MLDDA_ACCESS_t MLDDA_ACCESS; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_IM3E_MLDDA_DATA5_t MLDDA_DATA5; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_IM3E_MLDDA_DATA4_t MLDDA_DATA4; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_IM3E_MLDDA_DATA3_t MLDDA_DATA3; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_IM3E_MLDDA_DATA2_t MLDDA_DATA2; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_IM3E_MLDDA_DATA1_t MLDDA_DATA1; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_IM3E_MLDDA_DATA0_t MLDDA_DATA0; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_IM3E_MLDSA_ACCESS_t MLDSA_ACCESS; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_IM3E_MLDSA_DATA4_t MLDSA_DATA4; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_IM3E_MLDSA_DATA3_t MLDSA_DATA3; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_IM3E_MLDSA_DATA2_t MLDSA_DATA2; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_IM3E_MLDSA_DATA1_t MLDSA_DATA1; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_IM3E_MLDSA_DATA0_t MLDSA_DATA0; /* addr: 0x00000048 */
} APB0_L2FE_IM3E_t;
#endif /* !__ASSEMBLER__ */

/*
 * MIRE
 */

#define L2FE_MIRE_MIR_CTRL 0xf4301f00
#define L2FE_MIRE_MIR_CTRL_dft 0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_drop_src_mir_en : 1; /* bits 0:0 */
		ca_uint32_t pkt_keep_old : 1; /* bits 1:1 */
		ca_uint32_t lspid_remap : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_RULE_SSID_0 0xf4301f04
#define L2FE_MIRE_MIR_RULE_SSID_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flowid : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ldpid : 6; /* bits 15:10 */
		ca_uint32_t lspid : 6; /* bits 21:16 */
		ca_uint32_t mode : 3; /* bits 24:22 */
		ca_uint32_t rsrvd2 : 7;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_RULE_SSID_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_RULE_SSID_1 0xf4301f08
#define L2FE_MIRE_MIR_RULE_SSID_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flowid : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ldpid : 6; /* bits 15:10 */
		ca_uint32_t lspid : 6; /* bits 21:16 */
		ca_uint32_t mode : 3; /* bits 24:22 */
		ca_uint32_t rsrvd2 : 7;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_RULE_SSID_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_RULE_SSID_2 0xf4301f0c
#define L2FE_MIRE_MIR_RULE_SSID_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flowid : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ldpid : 6; /* bits 15:10 */
		ca_uint32_t lspid : 6; /* bits 21:16 */
		ca_uint32_t mode : 3; /* bits 24:22 */
		ca_uint32_t rsrvd2 : 7;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_RULE_SSID_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_RULE_SSID_3 0xf4301f10
#define L2FE_MIRE_MIR_RULE_SSID_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flowid : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ldpid : 6; /* bits 15:10 */
		ca_uint32_t lspid : 6; /* bits 21:16 */
		ca_uint32_t mode : 3; /* bits 24:22 */
		ca_uint32_t rsrvd2 : 7;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_RULE_SSID_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_ACT_0_SSID_0 0xf4301f14
#define L2FE_MIRE_MIR_ACT_0_SSID_0_dft 0x0000433a

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lspid : 6; /* bits 5:0 */
		ca_uint32_t pspid : 4; /* bits 9:6 */
		ca_uint32_t ldpid : 6; /* bits 15:10 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_ACT_0_SSID_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_ACT_0_SSID_1 0xf4301f18
#define L2FE_MIRE_MIR_ACT_0_SSID_1_dft 0x0000437b

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lspid : 6; /* bits 5:0 */
		ca_uint32_t pspid : 4; /* bits 9:6 */
		ca_uint32_t ldpid : 6; /* bits 15:10 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_ACT_0_SSID_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_ACT_0_SSID_2 0xf4301f1c
#define L2FE_MIRE_MIR_ACT_0_SSID_2_dft 0x000043bc

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lspid : 6; /* bits 5:0 */
		ca_uint32_t pspid : 4; /* bits 9:6 */
		ca_uint32_t ldpid : 6; /* bits 15:10 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_ACT_0_SSID_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_ACT_0_SSID_3 0xf4301f20
#define L2FE_MIRE_MIR_ACT_0_SSID_3_dft 0x000043fd

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lspid : 6; /* bits 5:0 */
		ca_uint32_t pspid : 4; /* bits 9:6 */
		ca_uint32_t ldpid : 6; /* bits 15:10 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_ACT_0_SSID_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_ACT_1_SSID_0 0xf4301f24
#define L2FE_MIRE_MIR_ACT_1_SSID_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dot1p : 3; /* bits 2:0 */
		ca_uint32_t sc_ind : 1; /* bits 3:3 */
		ca_uint32_t vid : 12; /* bits 15:4 */
		ca_uint32_t vlan_cmd : 1; /* bits 16:16 */
		ca_uint32_t cos_vld : 1; /* bits 17:17 */
		ca_uint32_t cos : 3; /* bits 20:18 */
		ca_uint32_t sv_tpid_sel : 2; /* bits 22:21 */
		ca_uint32_t cv_tpid_sel : 2; /* bits 24:23 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_ACT_1_SSID_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_ACT_1_SSID_1 0xf4301f28
#define L2FE_MIRE_MIR_ACT_1_SSID_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dot1p : 3; /* bits 2:0 */
		ca_uint32_t sc_ind : 1; /* bits 3:3 */
		ca_uint32_t vid : 12; /* bits 15:4 */
		ca_uint32_t vlan_cmd : 1; /* bits 16:16 */
		ca_uint32_t cos_vld : 1; /* bits 17:17 */
		ca_uint32_t cos : 3; /* bits 20:18 */
		ca_uint32_t sv_tpid_sel : 2; /* bits 22:21 */
		ca_uint32_t cv_tpid_sel : 2; /* bits 24:23 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_ACT_1_SSID_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_ACT_1_SSID_2 0xf4301f2c
#define L2FE_MIRE_MIR_ACT_1_SSID_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dot1p : 3; /* bits 2:0 */
		ca_uint32_t sc_ind : 1; /* bits 3:3 */
		ca_uint32_t vid : 12; /* bits 15:4 */
		ca_uint32_t vlan_cmd : 1; /* bits 16:16 */
		ca_uint32_t cos_vld : 1; /* bits 17:17 */
		ca_uint32_t cos : 3; /* bits 20:18 */
		ca_uint32_t sv_tpid_sel : 2; /* bits 22:21 */
		ca_uint32_t cv_tpid_sel : 2; /* bits 24:23 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_ACT_1_SSID_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_ACT_1_SSID_3 0xf4301f30
#define L2FE_MIRE_MIR_ACT_1_SSID_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dot1p : 3; /* bits 2:0 */
		ca_uint32_t sc_ind : 1; /* bits 3:3 */
		ca_uint32_t vid : 12; /* bits 15:4 */
		ca_uint32_t vlan_cmd : 1; /* bits 16:16 */
		ca_uint32_t cos_vld : 1; /* bits 17:17 */
		ca_uint32_t cos : 3; /* bits 20:18 */
		ca_uint32_t sv_tpid_sel : 2; /* bits 22:21 */
		ca_uint32_t cv_tpid_sel : 2; /* bits 24:23 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_ACT_1_SSID_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_STTS_0 0xf4301f34
#define L2FE_MIRE_MIR_STTS_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pspid_vld : 1; /* bits 0:0 */
		ca_uint32_t pspid : 4; /* bits 4:1 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_STTS_0_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_STTS_1 0xf4301f38
#define L2FE_MIRE_MIR_STTS_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pspid_vld : 1; /* bits 0:0 */
		ca_uint32_t pspid : 4; /* bits 4:1 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_STTS_1_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_STTS_2 0xf4301f3c
#define L2FE_MIRE_MIR_STTS_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pspid_vld : 1; /* bits 0:0 */
		ca_uint32_t pspid : 4; /* bits 4:1 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_STTS_2_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_MIR_STTS_3 0xf4301f40
#define L2FE_MIRE_MIR_STTS_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pspid_vld : 1; /* bits 0:0 */
		ca_uint32_t pspid : 4; /* bits 4:1 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_MIR_STTS_3_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_PINGPONG_STS 0xf4301f44
#define L2FE_MIRE_PINGPONG_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ovfl : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_DATA_FIFO_CNT 0xf4301f48
#define L2FE_MIRE_DATA_FIFO_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t entry_cnt : 7; /* bits 6:0 */
		ca_uint32_t seg_cnt : 4; /* bits 10:7 */
		ca_uint32_t rsrvd1 : 5;
		ca_uint32_t extra_store_cnt : 2; /* bits 17:16 */
		ca_uint32_t data_ltched : 1; /* bits 18:18 */
		ca_uint32_t rsrvd2 : 13;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_DATA_FIFO_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_DATA_FIFO_STTS 0xf4301f4c
#define L2FE_MIRE_DATA_FIFO_STTS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ovfl : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_DATA_FIFO_STTS_t;
#endif /* !__ASSEMBLER__ */

#define L2FE_MIRE_DEBUG 0xf4301f50
#define L2FE_MIRE_DEBUG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2FE_MIRE_DEBUG_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* MIRE */
#ifndef __ASSEMBLER__
typedef struct {
	L2FE_MIRE_MIR_CTRL_t MIR_CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2FE_MIRE_MIR_RULE_SSID_0_t MIR_RULE_SSID_0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2FE_MIRE_MIR_RULE_SSID_1_t MIR_RULE_SSID_1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2FE_MIRE_MIR_RULE_SSID_2_t MIR_RULE_SSID_2; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2FE_MIRE_MIR_RULE_SSID_3_t MIR_RULE_SSID_3; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2FE_MIRE_MIR_ACT_0_SSID_0_t MIR_ACT_0_SSID_0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2FE_MIRE_MIR_ACT_0_SSID_1_t MIR_ACT_0_SSID_1; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2FE_MIRE_MIR_ACT_0_SSID_2_t MIR_ACT_0_SSID_2; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2FE_MIRE_MIR_ACT_0_SSID_3_t MIR_ACT_0_SSID_3; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2FE_MIRE_MIR_ACT_1_SSID_0_t MIR_ACT_1_SSID_0; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2FE_MIRE_MIR_ACT_1_SSID_1_t MIR_ACT_1_SSID_1; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2FE_MIRE_MIR_ACT_1_SSID_2_t MIR_ACT_1_SSID_2; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2FE_MIRE_MIR_ACT_1_SSID_3_t MIR_ACT_1_SSID_3; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2FE_MIRE_MIR_STTS_0_t MIR_STTS_0; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2FE_MIRE_MIR_STTS_1_t MIR_STTS_1; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2FE_MIRE_MIR_STTS_2_t MIR_STTS_2; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2FE_MIRE_MIR_STTS_3_t MIR_STTS_3; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2FE_MIRE_PINGPONG_STS_t PINGPONG_STS; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2FE_MIRE_DATA_FIFO_CNT_t DATA_FIFO_CNT; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2FE_MIRE_DATA_FIFO_STTS_t DATA_FIFO_STTS; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2FE_MIRE_DEBUG_t DEBUG; /* addr: 0x00000050 */
} APB0_L2FE_MIRE_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2FE */

#ifndef __ASSEMBLER__
typedef struct {
	APB0_L2FE_GLB_t GLB; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[211];
	APB0_L2FE_PP_t PP; /* addr: 0x00000100 */
	ca_uint32_t rsrvd2[369];
	APB0_L2FE_PLA_t PLA; /* addr: 0x00000300 */
	ca_uint32_t rsrvd3[239];
	APB0_L2FE_PLC_t PLC; /* addr: 0x00000400 */
	ca_uint32_t rsrvd4[235];
	APB0_L2FE_PLE_t PLE; /* addr: 0x00000500 */
	ca_uint32_t rsrvd5[189];
	APB0_L2FE_ARB_t ARB; /* addr: 0x00000600 */
	ca_uint32_t rsrvd6[209];
	APB0_L2FE_PE_t PE; /* addr: 0x00000700 */
	ca_uint32_t rsrvd7[441];
	APB0_L2FE_LF_t LF; /* addr: 0x00000900 */
	ca_uint32_t rsrvd8[249];
	APB0_L2FE_VE_t VE; /* addr: 0x00000a00 */
	ca_uint32_t rsrvd9[213];
	APB0_L2FE_CLE_t CLE; /* addr: 0x00000b00 */
	ca_uint32_t rsrvd10[169];
	APB0_L2FE_L2E_t L2E; /* addr: 0x00000c00 */
	ca_uint32_t rsrvd11[415];
	APB0_L2FE_IM3E_t IM3E; /* addr: 0x00000e00 */
	ca_uint32_t rsrvd12[219];
	APB0_L2FE_MIRE_t MIRE; /* addr: 0x00000f00 */
} APB0_L2FE_t;
#endif /* !__ASSEMBLER__ */

/*
 * L2TM
 */

/*
 * l2tm_glb
 */

#define L2TM_L2TM_GLB_REV_ID 0xf4302000
#define L2TM_L2TM_GLB_REV_ID_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t minor : 16; /* bits 15:0 */
		ca_uint32_t major : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_REV_ID_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_GLB_INT 0xf4302004
#define L2TM_L2TM_GLB_INT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bm : 1; /* bits 0:0 */
		ca_uint32_t qm : 1; /* bits 1:1 */
		ca_uint32_t bm1 : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_INT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_GLB_INTE 0xf4302008
#define L2TM_L2TM_GLB_INTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bmE : 1; /* bits 0:0 */
		ca_uint32_t qmE : 1; /* bits 1:1 */
		ca_uint32_t bm1E : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_GLB_STS 0xf430200c
#define L2TM_L2TM_GLB_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 14;
		ca_uint32_t voqinfo_ram_init_done : 1; /* bits 14:14 */
		ca_uint32_t freeq_ram_init_done : 1; /* bits 15:15 */
		ca_uint32_t rsrvd2 : 14;
		ca_uint32_t idle : 1; /* bits 30:30 */
		ca_uint32_t init_done : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_GLB_CTRL 0xf4302010
#define L2TM_L2TM_GLB_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 31;
		ca_uint32_t cntrcfg_clear_on_read : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_GLB_SPARE_CFG 0xf4302014
#define L2TM_L2TM_GLB_SPARE_CFG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t spare : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_SPARE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_GLB_SPARE_STS 0xf4302018
#define L2TM_L2TM_GLB_SPARE_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t spare : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_SPARE_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_GLB_SRAM_TEST_CONTROL_0 0xf430201c
#define L2TM_L2TM_GLB_SRAM_TEST_CONTROL_0_dft 0x00000202

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm0 : 2; /* bits 1:0 */
		ca_uint32_t rme0 : 1; /* bits 2:2 */
		ca_uint32_t test0 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rm1 : 2; /* bits 9:8 */
		ca_uint32_t rme1 : 1; /* bits 10:10 */
		ca_uint32_t test1 : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 20;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_SRAM_TEST_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_GLB_SRAM_LS_CONTROL 0xf4302020
#define L2TM_L2TM_GLB_SRAM_LS_CONTROL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2te1_sramls : 8; /* bits 7:0 */
		ca_uint32_t l2te2_sramls : 6; /* bits 13:8 */
		ca_uint32_t l2te3_sramls : 8; /* bits 21:14 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t l2tm2a_sramls : 1; /* bits 23:23 */
		ca_uint32_t l2tm_repair1_sramls : 1; /* bits 24:24 */
		ca_uint32_t rsrvd2 : 7;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_GLB_SRAM_LS_CONTROL_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_glb */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TM_GLB_REV_ID_t REV_ID; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TM_GLB_INT_t INT; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TM_GLB_INTE_t INTE; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TM_GLB_STS_t STS; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TM_GLB_CTRL_t CTRL; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TM_GLB_SPARE_CFG_t SPARE_CFG; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TM_GLB_SPARE_STS_t SPARE_STS; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TM_GLB_SRAM_TEST_CONTROL_0_t
	  SRAM_TEST_CONTROL_0; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TM_GLB_SRAM_LS_CONTROL_t SRAM_LS_CONTROL; /* addr: 0x00000020 */
} APB0_L2TM_L2TM_GLB_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2tm_bm
 */

#define L2TM_L2TM_BM_INT 0xf4302100
#define L2TM_L2TM_BM_INT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sb_drop : 1; /* bits 0:0 */
		ca_uint32_t hdr_drop : 1; /* bits 1:1 */
		ca_uint32_t te_drop : 1; /* bits 2:2 */
		ca_uint32_t wvoqid : 1; /* bits 3:3 */
		ca_uint32_t szerr : 1; /* bits 4:4 */
		ca_uint32_t seglenerr : 1; /* bits 5:5 */
		ca_uint32_t seq_err : 1; /* bits 6:6 */
		ca_uint32_t fc_mirror_drop : 1; /* bits 7:7 */
		ca_uint32_t dq_sb_drop : 1; /* bits 8:8 */
		ca_uint32_t dq_hdr_drop : 1; /* bits 9:9 */
		ca_uint32_t dq_wvoqid : 1; /* bits 10:10 */
		ca_uint32_t dq_szerr : 1; /* bits 11:11 */
		ca_uint32_t dq_seglenerr : 1; /* bits 12:12 */
		ca_uint32_t dq_seq_err : 1; /* bits 13:13 */
		ca_uint32_t dq_ff_undrflo : 1; /* bits 14:14 */
		ca_uint32_t dq_ff_ovrflo : 1; /* bits 15:15 */
		ca_uint32_t dq_pack_ff_undrflo : 1; /* bits 16:16 */
		ca_uint32_t dq_pack_ff_ovrflo : 1; /* bits 17:17 */
		ca_uint32_t fe_ff_undrflo : 1; /* bits 18:18 */
		ca_uint32_t fe_ff_ovrflo : 1; /* bits 19:19 */
		ca_uint32_t pack_ff_undrflo : 1; /* bits 20:20 */
		ca_uint32_t pack_ff_ovrflo : 1; /* bits 21:21 */
		ca_uint32_t wdat_ff_undrflo : 1; /* bits 22:22 */
		ca_uint32_t wdat_ff_ovrflo : 1; /* bits 23:23 */
		ca_uint32_t wcmd_ff_undrflo : 1; /* bits 24:24 */
		ca_uint32_t wcmd_ff_ovrflo : 1; /* bits 25:25 */
		ca_uint32_t rdat_ff_undrflo : 1; /* bits 26:26 */
		ca_uint32_t rdat_ff_ovrflo : 1; /* bits 27:27 */
		ca_uint32_t rcmd_ff_undrflo : 1; /* bits 28:28 */
		ca_uint32_t rcmd_ff_ovrflo : 1; /* bits 29:29 */
		ca_uint32_t rcyc_ff_undrflo : 1; /* bits 30:30 */
		ca_uint32_t rcyc_ff_ovrflo : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_INT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_INTE 0xf4302104
#define L2TM_L2TM_BM_INTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sb_dropE : 1; /* bits 0:0 */
		ca_uint32_t hdr_dropE : 1; /* bits 1:1 */
		ca_uint32_t te_dropE : 1; /* bits 2:2 */
		ca_uint32_t wvoqidE : 1; /* bits 3:3 */
		ca_uint32_t szerrE : 1; /* bits 4:4 */
		ca_uint32_t seglenerrE : 1; /* bits 5:5 */
		ca_uint32_t seq_errE : 1; /* bits 6:6 */
		ca_uint32_t fc_mirror_dropE : 1; /* bits 7:7 */
		ca_uint32_t dq_sb_dropE : 1; /* bits 8:8 */
		ca_uint32_t dq_hdr_dropE : 1; /* bits 9:9 */
		ca_uint32_t dq_wvoqidE : 1; /* bits 10:10 */
		ca_uint32_t dq_szerrE : 1; /* bits 11:11 */
		ca_uint32_t dq_seglenerrE : 1; /* bits 12:12 */
		ca_uint32_t dq_seq_errE : 1; /* bits 13:13 */
		ca_uint32_t dq_ff_undrfloE : 1; /* bits 14:14 */
		ca_uint32_t dq_ff_ovrfloE : 1; /* bits 15:15 */
		ca_uint32_t dq_pack_ff_undrfloE : 1; /* bits 16:16 */
		ca_uint32_t dq_pack_ff_ovrfloE : 1; /* bits 17:17 */
		ca_uint32_t fe_ff_undrfloE : 1; /* bits 18:18 */
		ca_uint32_t fe_ff_ovrfloE : 1; /* bits 19:19 */
		ca_uint32_t pack_ff_undrfloE : 1; /* bits 20:20 */
		ca_uint32_t pack_ff_ovrfloE : 1; /* bits 21:21 */
		ca_uint32_t wdat_ff_undrfloE : 1; /* bits 22:22 */
		ca_uint32_t wdat_ff_ovrfloE : 1; /* bits 23:23 */
		ca_uint32_t wcmd_ff_undrfloE : 1; /* bits 24:24 */
		ca_uint32_t wcmd_ff_ovrfloE : 1; /* bits 25:25 */
		ca_uint32_t rdat_ff_undrfloE : 1; /* bits 26:26 */
		ca_uint32_t rdat_ff_ovrfloE : 1; /* bits 27:27 */
		ca_uint32_t rcmd_ff_undrfloE : 1; /* bits 28:28 */
		ca_uint32_t rcmd_ff_ovrfloE : 1; /* bits 29:29 */
		ca_uint32_t rcyc_ff_undrfloE : 1; /* bits 30:30 */
		ca_uint32_t rcyc_ff_ovrfloE : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_INTE_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_INT1 0xf4302108
#define L2TM_L2TM_BM_INT1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t abr_flush_cos0 : 1; /* bits 0:0 */
		ca_uint32_t abr_flush_cos1 : 1; /* bits 1:1 */
		ca_uint32_t abr_flush_cos2 : 1; /* bits 2:2 */
		ca_uint32_t abr_flush_cos3 : 1; /* bits 3:3 */
		ca_uint32_t abr_flush_cos4 : 1; /* bits 4:4 */
		ca_uint32_t abr_flush_cos5 : 1; /* bits 5:5 */
		ca_uint32_t abr_flush_cos6 : 1; /* bits 6:6 */
		ca_uint32_t abr_flush_cos7 : 1; /* bits 7:7 */
		ca_uint32_t abr_drop_cos0 : 1; /* bits 8:8 */
		ca_uint32_t abr_drop_cos1 : 1; /* bits 9:9 */
		ca_uint32_t abr_drop_cos2 : 1; /* bits 10:10 */
		ca_uint32_t abr_drop_cos3 : 1; /* bits 11:11 */
		ca_uint32_t abr_drop_cos4 : 1; /* bits 12:12 */
		ca_uint32_t abr_drop_cos5 : 1; /* bits 13:13 */
		ca_uint32_t abr_drop_cos6 : 1; /* bits 14:14 */
		ca_uint32_t abr_drop_cos7 : 1; /* bits 15:15 */
		ca_uint32_t dq_abr_drop_cos0 : 1; /* bits 16:16 */
		ca_uint32_t dq_abr_drop_cos1 : 1; /* bits 17:17 */
		ca_uint32_t dq_abr_drop_cos2 : 1; /* bits 18:18 */
		ca_uint32_t dq_abr_drop_cos3 : 1; /* bits 19:19 */
		ca_uint32_t dq_abr_drop_cos4 : 1; /* bits 20:20 */
		ca_uint32_t dq_abr_drop_cos5 : 1; /* bits 21:21 */
		ca_uint32_t dq_abr_drop_cos6 : 1; /* bits 22:22 */
		ca_uint32_t dq_abr_drop_cos7 : 1; /* bits 23:23 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_INT1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_INT1E 0xf430210c
#define L2TM_L2TM_BM_INT1E_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t abr_flush_cos0E : 1; /* bits 0:0 */
		ca_uint32_t abr_flush_cos1E : 1; /* bits 1:1 */
		ca_uint32_t abr_flush_cos2E : 1; /* bits 2:2 */
		ca_uint32_t abr_flush_cos3E : 1; /* bits 3:3 */
		ca_uint32_t abr_flush_cos4E : 1; /* bits 4:4 */
		ca_uint32_t abr_flush_cos5E : 1; /* bits 5:5 */
		ca_uint32_t abr_flush_cos6E : 1; /* bits 6:6 */
		ca_uint32_t abr_flush_cos7E : 1; /* bits 7:7 */
		ca_uint32_t abr_drop_cos0E : 1; /* bits 8:8 */
		ca_uint32_t abr_drop_cos1E : 1; /* bits 9:9 */
		ca_uint32_t abr_drop_cos2E : 1; /* bits 10:10 */
		ca_uint32_t abr_drop_cos3E : 1; /* bits 11:11 */
		ca_uint32_t abr_drop_cos4E : 1; /* bits 12:12 */
		ca_uint32_t abr_drop_cos5E : 1; /* bits 13:13 */
		ca_uint32_t abr_drop_cos6E : 1; /* bits 14:14 */
		ca_uint32_t abr_drop_cos7E : 1; /* bits 15:15 */
		ca_uint32_t dq_abr_drop_cos0E : 1; /* bits 16:16 */
		ca_uint32_t dq_abr_drop_cos1E : 1; /* bits 17:17 */
		ca_uint32_t dq_abr_drop_cos2E : 1; /* bits 18:18 */
		ca_uint32_t dq_abr_drop_cos3E : 1; /* bits 19:19 */
		ca_uint32_t dq_abr_drop_cos4E : 1; /* bits 20:20 */
		ca_uint32_t dq_abr_drop_cos5E : 1; /* bits 21:21 */
		ca_uint32_t dq_abr_drop_cos6E : 1; /* bits 22:22 */
		ca_uint32_t dq_abr_drop_cos7E : 1; /* bits 23:23 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_INT1E_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_CTRL 0xf4302110
#define L2TM_L2TM_BM_CTRL_dft 0xc0000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_drop_cos : 3; /* bits 2:0 */
		ca_uint32_t rx_drop_pid : 4; /* bits 6:3 */
		ca_uint32_t rx_drop_en : 2; /* bits 8:7 */
		ca_uint32_t sb_drop_dis : 1; /* bits 9:9 */
		ca_uint32_t hdr_drop_code_upd_en : 1; /* bits 10:10 */
		ca_uint32_t rsrvd1 : 13;
		ca_uint32_t min_pktlen : 7; /* bits 30:24 */
		ca_uint32_t rx_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP 0xf4302114
#define L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_dft 0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qsel_0 : 3; /* bits 2:0 */
		ca_uint32_t flag_0 : 1; /* bits 3:3 */
		ca_uint32_t qsel_1 : 3; /* bits 6:4 */
		ca_uint32_t flag_1 : 1; /* bits 7:7 */
		ca_uint32_t qsel_2 : 3; /* bits 10:8 */
		ca_uint32_t flag_2 : 1; /* bits 11:11 */
		ca_uint32_t qsel_3 : 3; /* bits 14:12 */
		ca_uint32_t flag_3 : 1; /* bits 15:15 */
		ca_uint32_t qsel_4 : 3; /* bits 18:16 */
		ca_uint32_t flag_4 : 1; /* bits 19:19 */
		ca_uint32_t qsel_5 : 3; /* bits 22:20 */
		ca_uint32_t flag_5 : 1; /* bits 23:23 */
		ca_uint32_t qsel_6 : 3; /* bits 26:24 */
		ca_uint32_t flag_6 : 1; /* bits 27:27 */
		ca_uint32_t qsel_7 : 3; /* bits 30:28 */
		ca_uint32_t flag_7 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP 0xf4302118
#define L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_dft 0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qsel_0 : 3; /* bits 2:0 */
		ca_uint32_t flag_0 : 1; /* bits 3:3 */
		ca_uint32_t qsel_1 : 3; /* bits 6:4 */
		ca_uint32_t flag_1 : 1; /* bits 7:7 */
		ca_uint32_t qsel_2 : 3; /* bits 10:8 */
		ca_uint32_t flag_2 : 1; /* bits 11:11 */
		ca_uint32_t qsel_3 : 3; /* bits 14:12 */
		ca_uint32_t flag_3 : 1; /* bits 15:15 */
		ca_uint32_t qsel_4 : 3; /* bits 18:16 */
		ca_uint32_t flag_4 : 1; /* bits 19:19 */
		ca_uint32_t qsel_5 : 3; /* bits 22:20 */
		ca_uint32_t flag_5 : 1; /* bits 23:23 */
		ca_uint32_t qsel_6 : 3; /* bits 26:24 */
		ca_uint32_t flag_6 : 1; /* bits 27:27 */
		ca_uint32_t qsel_7 : 3; /* bits 30:28 */
		ca_uint32_t flag_7 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP 0xf430211c
#define L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_dft 0x00000076

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qsel_0 : 3; /* bits 2:0 */
		ca_uint32_t flag_0 : 1; /* bits 3:3 */
		ca_uint32_t qsel_1 : 3; /* bits 6:4 */
		ca_uint32_t flag_1 : 1; /* bits 7:7 */
		ca_uint32_t rxpfc_0 : 1; /* bits 8:8 */
		ca_uint32_t rxpfc_1 : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP 0xf4302120
#define L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_dft 0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qsel_0 : 3; /* bits 2:0 */
		ca_uint32_t flag_0 : 1; /* bits 3:3 */
		ca_uint32_t qsel_1 : 3; /* bits 6:4 */
		ca_uint32_t flag_1 : 1; /* bits 7:7 */
		ca_uint32_t qsel_2 : 3; /* bits 10:8 */
		ca_uint32_t flag_2 : 1; /* bits 11:11 */
		ca_uint32_t qsel_3 : 3; /* bits 14:12 */
		ca_uint32_t flag_3 : 1; /* bits 15:15 */
		ca_uint32_t qsel_4 : 3; /* bits 18:16 */
		ca_uint32_t flag_4 : 1; /* bits 19:19 */
		ca_uint32_t qsel_5 : 3; /* bits 22:20 */
		ca_uint32_t flag_5 : 1; /* bits 23:23 */
		ca_uint32_t qsel_6 : 3; /* bits 26:24 */
		ca_uint32_t flag_6 : 1; /* bits 27:27 */
		ca_uint32_t qsel_7 : 3; /* bits 30:28 */
		ca_uint32_t flag_7 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP 0xf4302124
#define L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_dft 0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qsel_0 : 3; /* bits 2:0 */
		ca_uint32_t flag_0 : 1; /* bits 3:3 */
		ca_uint32_t qsel_1 : 3; /* bits 6:4 */
		ca_uint32_t flag_1 : 1; /* bits 7:7 */
		ca_uint32_t qsel_2 : 3; /* bits 10:8 */
		ca_uint32_t flag_2 : 1; /* bits 11:11 */
		ca_uint32_t qsel_3 : 3; /* bits 14:12 */
		ca_uint32_t flag_3 : 1; /* bits 15:15 */
		ca_uint32_t qsel_4 : 3; /* bits 18:16 */
		ca_uint32_t flag_4 : 1; /* bits 19:19 */
		ca_uint32_t qsel_5 : 3; /* bits 22:20 */
		ca_uint32_t flag_5 : 1; /* bits 23:23 */
		ca_uint32_t qsel_6 : 3; /* bits 26:24 */
		ca_uint32_t flag_6 : 1; /* bits 27:27 */
		ca_uint32_t qsel_7 : 3; /* bits 30:28 */
		ca_uint32_t flag_7 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP 0xf4302128
#define L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_dft 0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tm_dpid_sel_0 : 4; /* bits 3:0 */
		ca_uint32_t tm_dpid_sel_1 : 4; /* bits 7:4 */
		ca_uint32_t tm_dpid_sel_2 : 4; /* bits 11:8 */
		ca_uint32_t tm_dpid_sel_3 : 4; /* bits 15:12 */
		ca_uint32_t tm_dpid_sel_4 : 4; /* bits 19:16 */
		ca_uint32_t tm_dpid_sel_5 : 4; /* bits 23:20 */
		ca_uint32_t tm_dpid_sel_6 : 4; /* bits 27:24 */
		ca_uint32_t tm_dpid_sel_7 : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_DQ_PCNT 0xf430212c
#define L2TM_L2TM_BM_RX_DQ_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_DQ_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_DQ_DPCNT 0xf4302130
#define L2TM_L2TM_BM_RX_DQ_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_DQ_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_DQ_ABR_DPCNT 0xf4302134
#define L2TM_L2TM_BM_RX_DQ_ABR_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_DQ_ABR_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_PCNT 0xf4302138
#define L2TM_L2TM_BM_RX_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_TX_PCNT 0xf430213c
#define L2TM_L2TM_BM_TX_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_TX_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_SB_DPCNT 0xf4302140
#define L2TM_L2TM_BM_SB_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_SB_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_HDR_DPCNT 0xf4302144
#define L2TM_L2TM_BM_HDR_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_HDR_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_TE_DPCNT 0xf4302148
#define L2TM_L2TM_BM_TE_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_TE_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_ERR_DPCNT 0xf430214c
#define L2TM_L2TM_BM_ERR_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_ERR_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_FC_MIRROR0_DPCNT 0xf4302150
#define L2TM_L2TM_BM_FC_MIRROR0_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_FC_MIRROR1_DPCNT 0xf4302154
#define L2TM_L2TM_BM_FC_MIRROR1_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_FC_MIRROR2_DPCNT 0xf4302158
#define L2TM_L2TM_BM_FC_MIRROR2_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_FC_MIRROR3_DPCNT 0xf430215c
#define L2TM_L2TM_BM_FC_MIRROR3_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_DPCNT 0xf4302160
#define L2TM_L2TM_BM_RX_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_ABR_DPCNT 0xf4302164
#define L2TM_L2TM_BM_RX_ABR_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_ABR_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_NOBUF_DPCNT 0xf4302168
#define L2TM_L2TM_BM_NOBUF_DPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_NOBUF_DPCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_FE_HEADER_31_0 0xf430216c
#define L2TM_L2TM_BM_RX_FE_HEADER_31_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_FE_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_FE_HEADER_63_32 0xf4302170
#define L2TM_L2TM_BM_RX_FE_HEADER_63_32_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_FE_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_NI_HEADER_31_0 0xf4302174
#define L2TM_L2TM_BM_RX_NI_HEADER_31_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_NI_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_RX_NI_HEADER_63_32 0xf4302178
#define L2TM_L2TM_BM_RX_NI_HEADER_63_32_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_RX_NI_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_TX_NI_HEADER_31_0 0xf430217c
#define L2TM_L2TM_BM_TX_NI_HEADER_31_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_TX_NI_HEADER_31_0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_TX_NI_HEADER_63_32 0xf4302180
#define L2TM_L2TM_BM_TX_NI_HEADER_63_32_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_TX_NI_HEADER_63_32_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_STS 0xf4302184
#define L2TM_L2TM_BM_STS_dft 0xff80000a

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t fe_tm_vld : 1; /* bits 0:0 */
		ca_uint32_t tm_fe_rdy : 1; /* bits 1:1 */
		ca_uint32_t ni_tm_vld : 1; /* bits 2:2 */
		ca_uint32_t tm_ni_rdy : 1; /* bits 3:3 */
		ca_uint32_t tm_ni_vld : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 18;
		ca_uint32_t dq_ff_empty : 1; /* bits 23:23 */
		ca_uint32_t dq_pack_ff_empty : 1; /* bits 24:24 */
		ca_uint32_t fe_ff_empty : 1; /* bits 25:25 */
		ca_uint32_t pack_ff_empty : 1; /* bits 26:26 */
		ca_uint32_t wdat_ff_empty : 1; /* bits 27:27 */
		ca_uint32_t wcmd_ff_empty : 1; /* bits 28:28 */
		ca_uint32_t rdat_ff_empty : 1; /* bits 29:29 */
		ca_uint32_t rcmd_ff_empty : 1; /* bits 30:30 */
		ca_uint32_t rcyc_ff_empty : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_ACCESS 0xf4302188
#define L2TM_L2TM_BM_PKT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_DATA7 0xf430218c
#define L2TM_L2TM_BM_PKT_MEM_DATA7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_DATA6 0xf4302190
#define L2TM_L2TM_BM_PKT_MEM_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_DATA5 0xf4302194
#define L2TM_L2TM_BM_PKT_MEM_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_DATA4 0xf4302198
#define L2TM_L2TM_BM_PKT_MEM_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_DATA3 0xf430219c
#define L2TM_L2TM_BM_PKT_MEM_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_DATA2 0xf43021a0
#define L2TM_L2TM_BM_PKT_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_DATA1 0xf43021a4
#define L2TM_L2TM_BM_PKT_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_BM_PKT_MEM_DATA0 0xf43021a8
#define L2TM_L2TM_BM_PKT_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_BM_PKT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_bm */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TM_BM_INT_t INT; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TM_BM_INTE_t INTE; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TM_BM_INT1_t INT1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TM_BM_INT1E_t INT1E; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TM_BM_CTRL_t CTRL; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t
	  TM_TO_9THQ_QUEUE_MAP; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t
	  TM_TO_CPUQ_QUEUE_MAP; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t
	  TM_TO_CPU256Q_QUEUE_MAP; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t TM_TO_DQ_QUEUE_MAP; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t DQ_TO_TM_QUEUE_MAP; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t DQ_TO_TM_PORT_MAP; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2TM_L2TM_BM_RX_DQ_PCNT_t RX_DQ_PCNT; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TM_BM_RX_DQ_DPCNT_t RX_DQ_DPCNT; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TM_BM_RX_DQ_ABR_DPCNT_t RX_DQ_ABR_DPCNT; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2TM_L2TM_BM_RX_PCNT_t RX_PCNT; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2TM_L2TM_BM_TX_PCNT_t TX_PCNT; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2TM_L2TM_BM_SB_DPCNT_t SB_DPCNT; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2TM_L2TM_BM_HDR_DPCNT_t HDR_DPCNT; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2TM_L2TM_BM_TE_DPCNT_t TE_DPCNT; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2TM_L2TM_BM_ERR_DPCNT_t ERR_DPCNT; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t FC_MIRROR0_DPCNT; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t FC_MIRROR1_DPCNT; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t FC_MIRROR2_DPCNT; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t FC_MIRROR3_DPCNT; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L2TM_L2TM_BM_RX_DPCNT_t RX_DPCNT; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L2TM_L2TM_BM_RX_ABR_DPCNT_t RX_ABR_DPCNT; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L2TM_L2TM_BM_NOBUF_DPCNT_t NOBUF_DPCNT; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L2TM_L2TM_BM_RX_FE_HEADER_31_0_t RX_FE_HEADER_31_0; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L2TM_L2TM_BM_RX_FE_HEADER_63_32_t RX_FE_HEADER_63_32; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L2TM_L2TM_BM_RX_NI_HEADER_31_0_t RX_NI_HEADER_31_0; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L2TM_L2TM_BM_RX_NI_HEADER_63_32_t RX_NI_HEADER_63_32; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L2TM_L2TM_BM_TX_NI_HEADER_31_0_t TX_NI_HEADER_31_0; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L2TM_L2TM_BM_TX_NI_HEADER_63_32_t TX_NI_HEADER_63_32; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L2TM_L2TM_BM_STS_t STS; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L2TM_L2TM_BM_PKT_MEM_ACCESS_t PKT_MEM_ACCESS; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L2TM_L2TM_BM_PKT_MEM_DATA7_t PKT_MEM_DATA7; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	L2TM_L2TM_BM_PKT_MEM_DATA6_t PKT_MEM_DATA6; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	L2TM_L2TM_BM_PKT_MEM_DATA5_t PKT_MEM_DATA5; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	L2TM_L2TM_BM_PKT_MEM_DATA4_t PKT_MEM_DATA4; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	L2TM_L2TM_BM_PKT_MEM_DATA3_t PKT_MEM_DATA3; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	L2TM_L2TM_BM_PKT_MEM_DATA2_t PKT_MEM_DATA2; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	L2TM_L2TM_BM_PKT_MEM_DATA1_t PKT_MEM_DATA1; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	L2TM_L2TM_BM_PKT_MEM_DATA0_t PKT_MEM_DATA0; /* addr: 0x000000a8 */
} APB0_L2TM_L2TM_BM_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2tm_qm
 */

#define L2TM_L2TM_QM_INT 0xf4302200
#define L2TM_L2TM_QM_INT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t freeq_ecc_correctederr : 1; /* bits 0:0 */
		ca_uint32_t freeq_ecc_err : 1; /* bits 1:1 */
		ca_uint32_t voqinfo_cnt_dec_with_novalid : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t nobuf_drop : 1; /* bits 4:4 */
		ca_uint32_t bid_out_of_range : 1; /* bits 5:5 */
		ca_uint32_t wr_race_err : 1; /* bits 6:6 */
		ca_uint32_t rsrvd2 : 9;
		ca_uint32_t eq0_stack_err : 1; /* bits 16:16 */
		ca_uint32_t eq1_stack_err : 1; /* bits 17:17 */
		ca_uint32_t enq_ff_undrflo : 1; /* bits 18:18 */
		ca_uint32_t enq_ff_ovrflo : 1; /* bits 19:19 */
		ca_uint32_t deq_ff_undrflo : 1; /* bits 20:20 */
		ca_uint32_t deq_ff_ovrflo : 1; /* bits 21:21 */
		ca_uint32_t rsrvd3 : 10;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_INT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_INTE 0xf4302204
#define L2TM_L2TM_QM_INTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t freeq_ecc_correctederrE : 1; /* bits 0:0 */
		ca_uint32_t freeq_ecc_errE : 1; /* bits 1:1 */
		ca_uint32_t voqinfo_cnt_dec_with_novalidE : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t nobuf_dropE : 1; /* bits 4:4 */
		ca_uint32_t bid_out_of_rangeE : 1; /* bits 5:5 */
		ca_uint32_t wr_race_errE : 1; /* bits 6:6 */
		ca_uint32_t rsrvd2 : 9;
		ca_uint32_t eq0_stack_errE : 1; /* bits 16:16 */
		ca_uint32_t eq1_stack_errE : 1; /* bits 17:17 */
		ca_uint32_t enq_ff_undrfloE : 1; /* bits 18:18 */
		ca_uint32_t enq_ff_ovrfloE : 1; /* bits 19:19 */
		ca_uint32_t deq_ff_undrfloE : 1; /* bits 20:20 */
		ca_uint32_t deq_ff_ovrfloE : 1; /* bits 21:21 */
		ca_uint32_t rsrvd3 : 10;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_INTE_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ_CFG 0xf4302208
#define L2TM_L2TM_QM_EQ_CFG_dft 0x00040008

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t eq0_bufnum : 5; /* bits 4:0 */
		ca_uint32_t eq0_prvt : 11; /* bits 15:5 */
		ca_uint32_t eq1_bufnum : 4; /* bits 19:16 */
		ca_uint32_t eq1_prvt : 10; /* bits 29:20 */
		ca_uint32_t eq0_en : 1; /* bits 30:30 */
		ca_uint32_t eq1_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ_CFG1 0xf430220c
#define L2TM_L2TM_QM_EQ_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t eq0_buffer_weight : 1; /* bits 0:0 */
		ca_uint32_t eq1_buffer_weight : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_GLOB_BUF_CFG 0xf4302210
#define L2TM_L2TM_QM_GLOB_BUF_CFG_dft 0x90000020

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t nodrop : 15; /* bits 14:0 */
		ca_uint32_t drop_en : 1; /* bits 15:15 */
		ca_uint32_t noncong : 15; /* bits 30:16 */
		ca_uint32_t fe_bp_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_GLOB_BUF_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_GLOB_BUF_CFG1 0xf4302214
#define L2TM_L2TM_QM_GLOB_BUF_CFG1_dft 0x00000010

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t fe_bp_th : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_GLOB_BUF_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_PRVT_PROFILE0 0xf4302218
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE0_dft 0x00100000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_even : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t cnt_odd : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_PRVT_PROFILE1 0xf430221c
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE1_dft 0x00400020

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_even : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t cnt_odd : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_PRVT_PROFILE2 0xf4302220
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE2_dft 0x00c00080

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_even : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t cnt_odd : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_PRVT_PROFILE3 0xf4302224
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE3_dft 0x01400100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_even : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t cnt_odd : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_PRVT_SELECT0 0xf4302228
#define L2TM_L2TM_QM_PORT_PRVT_SELECT0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port0 : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t port1 : 3; /* bits 6:4 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t port2 : 3; /* bits 10:8 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t port3 : 3; /* bits 14:12 */
		ca_uint32_t rsrvd4 : 1;
		ca_uint32_t port4 : 3; /* bits 18:16 */
		ca_uint32_t rsrvd5 : 1;
		ca_uint32_t port5 : 3; /* bits 22:20 */
		ca_uint32_t rsrvd6 : 1;
		ca_uint32_t port6 : 3; /* bits 26:24 */
		ca_uint32_t rsrvd7 : 1;
		ca_uint32_t port7 : 3; /* bits 30:28 */
		ca_uint32_t rsrvd8 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_PRVT_SELECT0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_PRVT_SELECT1 0xf430222c
#define L2TM_L2TM_QM_PORT_PRVT_SELECT1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port0 : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t port1 : 3; /* bits 6:4 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t port2 : 3; /* bits 10:8 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t port3 : 3; /* bits 14:12 */
		ca_uint32_t rsrvd4 : 1;
		ca_uint32_t port4 : 3; /* bits 18:16 */
		ca_uint32_t rsrvd5 : 1;
		ca_uint32_t port5 : 3; /* bits 22:20 */
		ca_uint32_t rsrvd6 : 1;
		ca_uint32_t port6 : 3; /* bits 26:24 */
		ca_uint32_t rsrvd7 : 1;
		ca_uint32_t port7 : 3; /* bits 30:28 */
		ca_uint32_t rsrvd8 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_PRVT_SELECT1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_NO_PRVT_STS 0xf4302230
#define L2TM_L2TM_QM_PORT_NO_PRVT_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pid : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_NO_PRVT_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ_GLB_FREECNT 0xf4302234
#define L2TM_L2TM_QM_EQ_GLB_FREECNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sum_of_eqcnt : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ_GLB_FREECNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ_COS0_BUFCNT 0xf4302238
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_STRIDE 4
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_COUNT 8
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sum_of_eqcnt : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ_COS0_BUFCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS 0xf4302258
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA 0xf430225c
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ_FREECNT 0xf4302260
#define L2TM_L2TM_QM_EQ_FREECNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t eq0 : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t eq1 : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ_FREECNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ_HEAD 0xf4302264
#define L2TM_L2TM_QM_EQ_HEAD_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t eq0 : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t eq1 : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ_HEAD_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ0_STACK_CFG 0xf4302268
#define L2TM_L2TM_QM_EQ0_STACK_CFG_dft 0x00302010

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t low_ths : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t mid_ths : 6; /* bits 13:8 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t high_ths : 6; /* bits 21:16 */
		ca_uint32_t rsrvd3 : 10;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ0_STACK_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ0_STACK_CTRL 0xf430226c
#define L2TM_L2TM_QM_EQ0_STACK_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t stack_unfill : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ0_STACK_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ0_STACK_STS 0xf4302270
#define L2TM_L2TM_QM_EQ0_STACK_STS_dft 0x00000007

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t stack_unfill_done : 1; /* bits 0:0 */
		ca_uint32_t stack_idle : 1; /* bits 1:1 */
		ca_uint32_t stack_empty : 1; /* bits 2:2 */
		ca_uint32_t stack_full : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 12;
		ca_uint32_t stack_cntr : 6; /* bits 21:16 */
		ca_uint32_t rsrvd2 : 10;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ0_STACK_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ1_STACK_CFG 0xf4302274
#define L2TM_L2TM_QM_EQ1_STACK_CFG_dft 0x00302010

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t low_ths : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t mid_ths : 6; /* bits 13:8 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t high_ths : 6; /* bits 21:16 */
		ca_uint32_t rsrvd3 : 10;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ1_STACK_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ1_STACK_CTRL 0xf4302278
#define L2TM_L2TM_QM_EQ1_STACK_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t stack_unfill : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ1_STACK_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_EQ1_STACK_STS 0xf430227c
#define L2TM_L2TM_QM_EQ1_STACK_STS_dft 0x00000007

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t stack_unfill_done : 1; /* bits 0:0 */
		ca_uint32_t stack_idle : 1; /* bits 1:1 */
		ca_uint32_t stack_empty : 1; /* bits 2:2 */
		ca_uint32_t stack_full : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 12;
		ca_uint32_t stack_cntr : 6; /* bits 21:16 */
		ca_uint32_t rsrvd2 : 10;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_EQ1_STACK_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_CTRL 0xf4302280
#define L2TM_L2TM_QM_CTRL_dft 0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pcnt_dec_with_novalid_allow : 1; /* bits 0:0 */
		ca_uint32_t ack_upd_at_same_time : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 29;
		ca_uint32_t force_init_done : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_STS 0xf4302284
#define L2TM_L2TM_QM_STS_dft 0x000c0000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t plm_nempty : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t enq_ff_empty : 1; /* bits 18:18 */
		ca_uint32_t deq_ff_empty : 1; /* bits 19:19 */
		ca_uint32_t rsrvd2 : 12;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_STS1 0xf4302288
#define L2TM_L2TM_QM_STS1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t init_adr : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t init_data : 8; /* bits 23:16 */
		ca_uint32_t freeq_cs : 3; /* bits 26:24 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t sm_reset : 1; /* bits 30:30 */
		ca_uint32_t init_done : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_STS1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_FREEQ_MEM_ACCESS 0xf430228c
#define L2TM_L2TM_QM_FREEQ_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_FREEQ_MEM_DATA1 0xf4302290
#define L2TM_L2TM_QM_FREEQ_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ecc : 2; /* bits 1:0 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_FREEQ_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_FREEQ_MEM_DATA0 0xf4302294
#define L2TM_L2TM_QM_FREEQ_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t blen : 7; /* bits 6:0 */
		ca_uint32_t eqid : 1; /* bits 7:7 */
		ca_uint32_t eop : 1; /* bits 8:8 */
		ca_uint32_t sop : 1; /* bits 9:9 */
		ca_uint32_t cpu : 1; /* bits 10:10 */
		ca_uint32_t prvt : 1; /* bits 11:11 */
		ca_uint32_t nxt_ptr : 15; /* bits 26:12 */
		ca_uint32_t ecc : 5; /* bits 31:27 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_FREEQ_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_VOQINFO_MEM_ACCESS 0xf4302298
#define L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_VOQINFO_MEM_DATA1 0xf430229c
#define L2TM_L2TM_QM_VOQINFO_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tail_ptr : 10; /* bits 9:0 */
		ca_uint32_t vallid : 1; /* bits 10:10 */
		ca_uint32_t rsrvd1 : 21;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_VOQINFO_MEM_DATA0 0xf43022a0
#define L2TM_L2TM_QM_VOQINFO_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t blen : 7; /* bits 6:0 */
		ca_uint32_t eqid : 1; /* bits 7:7 */
		ca_uint32_t eop : 1; /* bits 8:8 */
		ca_uint32_t sop : 1; /* bits 9:9 */
		ca_uint32_t cpu : 1; /* bits 10:10 */
		ca_uint32_t prvt : 1; /* bits 11:11 */
		ca_uint32_t head_ptr : 15; /* bits 26:12 */
		ca_uint32_t tail_ptr : 5; /* bits 31:27 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS 0xf43022a4
#define L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA 0xf43022a8
#define L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_qm */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TM_QM_INT_t INT; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TM_QM_INTE_t INTE; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TM_QM_EQ_CFG_t EQ_CFG; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TM_QM_EQ_CFG1_t EQ_CFG1; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TM_QM_GLOB_BUF_CFG_t GLOB_BUF_CFG; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TM_QM_GLOB_BUF_CFG1_t GLOB_BUF_CFG1; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t PORT_PRVT_PROFILE0; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t PORT_PRVT_PROFILE1; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t PORT_PRVT_PROFILE2; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t PORT_PRVT_PROFILE3; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TM_QM_PORT_PRVT_SELECT0_t PORT_PRVT_SELECT0; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2TM_L2TM_QM_PORT_PRVT_SELECT1_t PORT_PRVT_SELECT1; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TM_QM_PORT_NO_PRVT_STS_t PORT_NO_PRVT_STS; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TM_QM_EQ_GLB_FREECNT_t EQ_GLB_FREECNT; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2TM_L2TM_QM_EQ_COS0_BUFCNT_t EQ_COS0_BUFCNT; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[31];
	L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t
	  PORT_PRVT_BUFCNT_MEM_ACCESS; /* addr: 0x00000058 */
	ca_uint32_t rsrvd16[3];
	L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t
	  PORT_PRVT_BUFCNT_MEM_DATA; /* addr: 0x0000005c */
	ca_uint32_t rsrvd17[3];
	L2TM_L2TM_QM_EQ_FREECNT_t EQ_FREECNT; /* addr: 0x00000060 */
	ca_uint32_t rsrvd18[3];
	L2TM_L2TM_QM_EQ_HEAD_t EQ_HEAD; /* addr: 0x00000064 */
	ca_uint32_t rsrvd19[3];
	L2TM_L2TM_QM_EQ0_STACK_CFG_t EQ0_STACK_CFG; /* addr: 0x00000068 */
	ca_uint32_t rsrvd20[3];
	L2TM_L2TM_QM_EQ0_STACK_CTRL_t EQ0_STACK_CTRL; /* addr: 0x0000006c */
	ca_uint32_t rsrvd21[3];
	L2TM_L2TM_QM_EQ0_STACK_STS_t EQ0_STACK_STS; /* addr: 0x00000070 */
	ca_uint32_t rsrvd22[3];
	L2TM_L2TM_QM_EQ1_STACK_CFG_t EQ1_STACK_CFG; /* addr: 0x00000074 */
	ca_uint32_t rsrvd23[3];
	L2TM_L2TM_QM_EQ1_STACK_CTRL_t EQ1_STACK_CTRL; /* addr: 0x00000078 */
	ca_uint32_t rsrvd24[3];
	L2TM_L2TM_QM_EQ1_STACK_STS_t EQ1_STACK_STS; /* addr: 0x0000007c */
	ca_uint32_t rsrvd25[3];
	L2TM_L2TM_QM_CTRL_t CTRL; /* addr: 0x00000080 */
	ca_uint32_t rsrvd26[3];
	L2TM_L2TM_QM_STS_t STS; /* addr: 0x00000084 */
	ca_uint32_t rsrvd27[3];
	L2TM_L2TM_QM_STS1_t STS1; /* addr: 0x00000088 */
	ca_uint32_t rsrvd28[3];
	L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t FREEQ_MEM_ACCESS; /* addr: 0x0000008c */
	ca_uint32_t rsrvd29[3];
	L2TM_L2TM_QM_FREEQ_MEM_DATA1_t FREEQ_MEM_DATA1; /* addr: 0x00000090 */
	ca_uint32_t rsrvd30[3];
	L2TM_L2TM_QM_FREEQ_MEM_DATA0_t FREEQ_MEM_DATA0; /* addr: 0x00000094 */
	ca_uint32_t rsrvd31[3];
	L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t VOQINFO_MEM_ACCESS; /* addr: 0x00000098 */
	ca_uint32_t rsrvd32[3];
	L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t VOQINFO_MEM_DATA1; /* addr: 0x0000009c */
	ca_uint32_t rsrvd33[3];
	L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t VOQINFO_MEM_DATA0; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd34[3];
	L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t VOQ_PCNT_MEM_ACCESS; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd35[3];
	L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t VOQ_PCNT_MEM_DATA; /* addr: 0x000000a8 */
} APB0_L2TM_L2TM_QM_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2tm_es
 */

#define L2TM_L2TM_ES_CTRL 0xf4302300
#define L2TM_L2TM_ES_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_port0_en : 1; /* bits 0:0 */
		ca_uint32_t tx_port1_en : 1; /* bits 1:1 */
		ca_uint32_t tx_port2_en : 1; /* bits 2:2 */
		ca_uint32_t tx_port3_en : 1; /* bits 3:3 */
		ca_uint32_t tx_port4_en : 1; /* bits 4:4 */
		ca_uint32_t tx_port5_en : 1; /* bits 5:5 */
		ca_uint32_t tx_port6_en : 1; /* bits 6:6 */
		ca_uint32_t tx_port7_en : 1; /* bits 7:7 */
		ca_uint32_t tx_port8_en : 1; /* bits 8:8 */
		ca_uint32_t tx_port9_en : 1; /* bits 9:9 */
		ca_uint32_t tx_port10_en : 1; /* bits 10:10 */
		ca_uint32_t tx_port11_en : 1; /* bits 11:11 */
		ca_uint32_t tx_port12_en : 1; /* bits 12:12 */
		ca_uint32_t tx_port13_en : 1; /* bits 13:13 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t tx_port15_en : 1; /* bits 15:15 */
		ca_uint32_t rsrvd2 : 10;
		ca_uint32_t ni_port_rdy_10_deglitch : 1; /* bits 26:26 */
		ca_uint32_t rsrvd3 : 2;
		ca_uint32_t ni_port_rdy_13_deglitch : 1; /* bits 29:29 */
		ca_uint32_t rsrvd4 : 1;
		ca_uint32_t tx_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_SCH_CFG0 0xf4302304
#define L2TM_L2TM_ES_SCH_CFG0_STRIDE 12
#define L2TM_L2TM_ES_SCH_CFG0_COUNT 15
#define L2TM_L2TM_ES_SCH_CFG0_dft 0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq_en : 8; /* bits 7:0 */
		ca_uint32_t flush_voqid : 3; /* bits 10:8 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t flush_en : 1; /* bits 15:15 */
		ca_uint32_t speed : 8; /* bits 23:16 */
		ca_uint32_t rsrvd2 : 8;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_SCH_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0 0xf4302308
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_STRIDE 12
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_COUNT 15
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq0 : 8; /* bits 7:0 */
		ca_uint32_t voq1 : 8; /* bits 15:8 */
		ca_uint32_t voq2 : 8; /* bits 23:16 */
		ca_uint32_t voq3 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0 0xf430230c
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_STRIDE 12
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_COUNT 15
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq4 : 8; /* bits 7:0 */
		ca_uint32_t voq5 : 8; /* bits 15:8 */
		ca_uint32_t voq6 : 8; /* bits 23:16 */
		ca_uint32_t voq7 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG 0xf43023b8
#define L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port0 : 8; /* bits 7:0 */
		ca_uint32_t port1 : 8; /* bits 15:8 */
		ca_uint32_t port2 : 8; /* bits 23:16 */
		ca_uint32_t port3 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG 0xf43023bc
#define L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port4 : 8; /* bits 7:0 */
		ca_uint32_t port5 : 8; /* bits 15:8 */
		ca_uint32_t port6 : 8; /* bits 23:16 */
		ca_uint32_t port7 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG 0xf43023c0
#define L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_dft 0x01010101

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port8 : 8; /* bits 7:0 */
		ca_uint32_t port9 : 8; /* bits 15:8 */
		ca_uint32_t port10 : 8; /* bits 23:16 */
		ca_uint32_t port11 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG 0xf43023c4
#define L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_dft 0x01000101

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port12 : 8; /* bits 7:0 */
		ca_uint32_t port13 : 8; /* bits 15:8 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t port15 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_DRR_WEIGHT_BASE 0xf43023c8
#define L2TM_L2TM_ES_DRR_WEIGHT_BASE_dft 0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t w_rate : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t base_select : 3; /* bits 10:8 */
		ca_uint32_t rsrvd2 : 5;
		ca_uint32_t dwrr_unit : 1; /* bits 16:16 */
		ca_uint32_t rsrvd3 : 15;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_DRR_WEIGHT_BASE_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_CFG 0xf43023cc
#define L2TM_L2TM_ES_CFG_dft 0x00000740

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sch_ack_len : 8; /* bits 7:0 */
		ca_uint32_t sch_sync_upd : 1; /* bits 8:8 */
		ca_uint32_t sch_rr_grant : 1; /* bits 9:9 */
		ca_uint32_t sch_ack_solo : 1; /* bits 10:10 */
		ca_uint32_t rsrvd1 : 21;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_STS 0xf43023d0
#define L2TM_L2TM_ES_STS_dft 0x00003fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni_port_rdy : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ_STS0 0xf43023d4
#define L2TM_L2TM_ES_VOQ_STS0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ_STS0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ_STS1 0xf43023d8
#define L2TM_L2TM_ES_VOQ_STS1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ_STS1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ_STS2 0xf43023dc
#define L2TM_L2TM_ES_VOQ_STS2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ_STS2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ_STS3 0xf43023e0
#define L2TM_L2TM_ES_VOQ_STS3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ_STS3_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ_OK_STS0 0xf43023e4
#define L2TM_L2TM_ES_VOQ_OK_STS0_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ_OK_STS0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ_OK_STS1 0xf43023e8
#define L2TM_L2TM_ES_VOQ_OK_STS1_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ_OK_STS1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ_OK_STS2 0xf43023ec
#define L2TM_L2TM_ES_VOQ_OK_STS2_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ_OK_STS2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_VOQ_OK_STS3 0xf43023f0
#define L2TM_L2TM_ES_VOQ_OK_STS3_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_VOQ_OK_STS3_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_PORT_OK_STS 0xf43023f4
#define L2TM_L2TM_ES_PORT_OK_STS_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pid : 16; /* bits 15:0 */
		ca_uint32_t voq_grp : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_PORT_OK_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_ABR_STS 0xf43023f8
#define L2TM_L2TM_ES_ABR_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port7_voq_abr_drop_sts : 8; /* bits 7:0 */
		ca_uint32_t port7_abr_ovthrsh : 1; /* bits 8:8 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_ABR_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TM_ES_ABR_FLUSH_PCNT 0xf43023fc
#define L2TM_L2TM_ES_ABR_FLUSH_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TM_ES_ABR_FLUSH_PCNT_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_es */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TM_ES_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TM_ES_SCH_CFG0_t SCH_CFG0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t
	  VOQ3_0_WEIGHT_RATIO_CFG0; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t
	  VOQ7_4_WEIGHT_RATIO_CFG0; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[171];
	L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t
	  PORT3_0_WEIGHT_RATIO_CFG; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t
	  PORT7_4_WEIGHT_RATIO_CFG; /* addr: 0x000000bc */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t
	  PORT11_8_WEIGHT_RATIO_CFG; /* addr: 0x000000c0 */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t
	  PORT15_12_WEIGHT_RATIO_CFG; /* addr: 0x000000c4 */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TM_ES_DRR_WEIGHT_BASE_t DRR_WEIGHT_BASE; /* addr: 0x000000c8 */
	ca_uint32_t rsrvd9[3];
	L2TM_L2TM_ES_CFG_t CFG; /* addr: 0x000000cc */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TM_ES_STS_t STS; /* addr: 0x000000d0 */
	ca_uint32_t rsrvd11[3];
	L2TM_L2TM_ES_VOQ_STS0_t VOQ_STS0; /* addr: 0x000000d4 */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TM_ES_VOQ_STS1_t VOQ_STS1; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TM_ES_VOQ_STS2_t VOQ_STS2; /* addr: 0x000000dc */
	ca_uint32_t rsrvd14[3];
	L2TM_L2TM_ES_VOQ_STS3_t VOQ_STS3; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd15[3];
	L2TM_L2TM_ES_VOQ_OK_STS0_t VOQ_OK_STS0; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd16[3];
	L2TM_L2TM_ES_VOQ_OK_STS1_t VOQ_OK_STS1; /* addr: 0x000000e8 */
	ca_uint32_t rsrvd17[3];
	L2TM_L2TM_ES_VOQ_OK_STS2_t VOQ_OK_STS2; /* addr: 0x000000ec */
	ca_uint32_t rsrvd18[3];
	L2TM_L2TM_ES_VOQ_OK_STS3_t VOQ_OK_STS3; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd19[3];
	L2TM_L2TM_ES_PORT_OK_STS_t PORT_OK_STS; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd20[3];
	L2TM_L2TM_ES_ABR_STS_t ABR_STS; /* addr: 0x000000f8 */
	ca_uint32_t rsrvd21[3];
	L2TM_L2TM_ES_ABR_FLUSH_PCNT_t ABR_FLUSH_PCNT; /* addr: 0x000000fc */
} APB0_L2TM_L2TM_ES_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2te_glb
 */

#define L2TM_L2TE_GLB_REV_ID 0xf4302400
#define L2TM_L2TE_GLB_REV_ID_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t minor : 16; /* bits 15:0 */
		ca_uint32_t major : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_REV_ID_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_CTRL 0xf4302404
#define L2TM_L2TE_GLB_CTRL_dft 0x07000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pol_en : 1; /* bits 0:0 */
		ca_uint32_t shp_en : 1; /* bits 1:1 */
		ca_uint32_t taildrop_en : 1; /* bits 2:2 */
		ca_uint32_t wred_en : 1; /* bits 3:3 */
		ca_uint32_t mark_ecn_en : 1; /* bits 4:4 */
		ca_uint32_t pol_ecn_en : 1; /* bits 5:5 */
		ca_uint32_t wred_ecn_en : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t port8_empty_sel : 1; /* bits 14:14 */
		ca_uint32_t snoop_l3_voq_taildrop_dis : 1; /* bits 15:15 */
		ca_uint32_t glb_deepq_port_rdy_en : 8; /* bits 23:16 */
		ca_uint32_t glb_deepq_port_rdy_id : 3; /* bits 26:24 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t puc_tqm_voqbp_7_0_dis : 1; /* bits 29:29 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t force_init_done : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_INT 0xf4302408
#define L2TM_L2TE_GLB_INT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pol_mark : 1; /* bits 0:0 */
		ca_uint32_t pol_drop : 1; /* bits 1:1 */
		ca_uint32_t tail_drop : 1; /* bits 2:2 */
		ca_uint32_t wred_y_drop : 1; /* bits 3:3 */
		ca_uint32_t wred_g_drop : 1; /* bits 4:4 */
		ca_uint32_t ecn : 1; /* bits 5:5 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t feio : 1; /* bits 14:14 */
		ca_uint32_t tmio : 1; /* bits 15:15 */
		ca_uint32_t cb : 1; /* bits 16:16 */
		ca_uint32_t fc : 1; /* bits 17:17 */
		ca_uint32_t rsrvd2 : 14;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_INT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_INTE 0xf430240c
#define L2TM_L2TE_GLB_INTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pol_markE : 1; /* bits 0:0 */
		ca_uint32_t pol_dropE : 1; /* bits 1:1 */
		ca_uint32_t tail_dropE : 1; /* bits 2:2 */
		ca_uint32_t wred_y_dropE : 1; /* bits 3:3 */
		ca_uint32_t wred_g_dropE : 1; /* bits 4:4 */
		ca_uint32_t ecnE : 1; /* bits 5:5 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t feioE : 1; /* bits 14:14 */
		ca_uint32_t tmioE : 1; /* bits 15:15 */
		ca_uint32_t cbE : 1; /* bits 16:16 */
		ca_uint32_t fcE : 1; /* bits 17:17 */
		ca_uint32_t rsrvd2 : 14;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_STS 0xf4302410
#define L2TM_L2TE_GLB_STS_dft 0x07000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pol_fifo_ovrn : 1; /* bits 0:0 */
		ca_uint32_t l2io_fifo_ovrn : 1; /* bits 1:1 */
		ca_uint32_t qmio_enq_ovrn : 1; /* bits 2:2 */
		ca_uint32_t qmio_deq_ovrn : 1; /* bits 3:3 */
		ca_uint32_t qmio_shp_ovrn : 1; /* bits 4:4 */
		ca_uint32_t te_qm_nrdy : 1; /* bits 5:5 */
		ca_uint32_t ptp_fifo_err : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 5;
		ca_uint32_t pol_init_done : 1; /* bits 12:12 */
		ca_uint32_t shp_init_done : 1; /* bits 13:13 */
		ca_uint32_t cb_init_done : 1; /* bits 14:14 */
		ca_uint32_t wred_init_done : 1; /* bits 15:15 */
		ca_uint32_t feio_sm : 4; /* bits 19:16 */
		ca_uint32_t fe_te_req : 1; /* bits 20:20 */
		ca_uint32_t te_fe_ack : 1; /* bits 21:21 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t l2io_idle : 1; /* bits 24:24 */
		ca_uint32_t qmio_idle : 1; /* bits 25:25 */
		ca_uint32_t ptp_fifo_idle : 1; /* bits 26:26 */
		ca_uint32_t rsrvd3 : 4;
		ca_uint32_t init_done : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_PTP_CFG 0xf4302414
#define L2TM_L2TE_GLB_PTP_CFG_dft 0x000007ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pol_id : 8; /* bits 7:0 */
		ca_uint32_t pol_grp_id : 3; /* bits 10:8 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t pol_en : 1; /* bits 12:12 */
		ca_uint32_t pol_grp_en : 1; /* bits 13:13 */
		ca_uint32_t rsrvd2 : 18;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_PTP_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_SPARE_CFG 0xf4302418
#define L2TM_L2TE_GLB_SPARE_CFG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t spare : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_SPARE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_SPARE_STS 0xf430241c
#define L2TM_L2TE_GLB_SPARE_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t spare : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_SPARE_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_0 0xf4302420
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_0_dft 0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm0 : 2; /* bits 1:0 */
		ca_uint32_t rme0 : 1; /* bits 2:2 */
		ca_uint32_t test0 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rm1 : 2; /* bits 9:8 */
		ca_uint32_t rme1 : 1; /* bits 10:10 */
		ca_uint32_t test1 : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t rm2 : 2; /* bits 17:16 */
		ca_uint32_t rme2 : 1; /* bits 18:18 */
		ca_uint32_t test2 : 1; /* bits 19:19 */
		ca_uint32_t rsrvd3 : 4;
		ca_uint32_t rm3 : 2; /* bits 25:24 */
		ca_uint32_t rme3 : 1; /* bits 26:26 */
		ca_uint32_t test3 : 1; /* bits 27:27 */
		ca_uint32_t rsrvd4 : 4;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_1 0xf4302424
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_1_dft 0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm0 : 2; /* bits 1:0 */
		ca_uint32_t rme0 : 1; /* bits 2:2 */
		ca_uint32_t test0 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rm1 : 2; /* bits 9:8 */
		ca_uint32_t rme1 : 1; /* bits 10:10 */
		ca_uint32_t test1 : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t rm2 : 2; /* bits 17:16 */
		ca_uint32_t rme2 : 1; /* bits 18:18 */
		ca_uint32_t test2 : 1; /* bits 19:19 */
		ca_uint32_t rsrvd3 : 4;
		ca_uint32_t rm3 : 2; /* bits 25:24 */
		ca_uint32_t rme3 : 1; /* bits 26:26 */
		ca_uint32_t test3 : 1; /* bits 27:27 */
		ca_uint32_t rsrvd4 : 4;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_2 0xf4302428
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_2_dft 0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm0 : 2; /* bits 1:0 */
		ca_uint32_t rme0 : 1; /* bits 2:2 */
		ca_uint32_t test0 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rm1 : 2; /* bits 9:8 */
		ca_uint32_t rme1 : 1; /* bits 10:10 */
		ca_uint32_t test1 : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t rm2 : 2; /* bits 17:16 */
		ca_uint32_t rme2 : 1; /* bits 18:18 */
		ca_uint32_t test2 : 1; /* bits 19:19 */
		ca_uint32_t rsrvd3 : 4;
		ca_uint32_t rm3 : 2; /* bits 25:24 */
		ca_uint32_t rme3 : 1; /* bits 26:26 */
		ca_uint32_t test3 : 1; /* bits 27:27 */
		ca_uint32_t rsrvd4 : 4;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_3 0xf430242c
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_3_dft 0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm0 : 2; /* bits 1:0 */
		ca_uint32_t rme0 : 1; /* bits 2:2 */
		ca_uint32_t test0 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rm1 : 2; /* bits 9:8 */
		ca_uint32_t rme1 : 1; /* bits 10:10 */
		ca_uint32_t test1 : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t rm2 : 2; /* bits 17:16 */
		ca_uint32_t rme2 : 1; /* bits 18:18 */
		ca_uint32_t test2 : 1; /* bits 19:19 */
		ca_uint32_t rsrvd3 : 4;
		ca_uint32_t rm3 : 2; /* bits 25:24 */
		ca_uint32_t rme3 : 1; /* bits 26:26 */
		ca_uint32_t test3 : 1; /* bits 27:27 */
		ca_uint32_t rsrvd4 : 4;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_3_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_4 0xf4302430
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_4_dft 0x02020202

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm0 : 2; /* bits 1:0 */
		ca_uint32_t rme0 : 1; /* bits 2:2 */
		ca_uint32_t test0 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rm1 : 2; /* bits 9:8 */
		ca_uint32_t rme1 : 1; /* bits 10:10 */
		ca_uint32_t test1 : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t rm2 : 2; /* bits 17:16 */
		ca_uint32_t rme2 : 1; /* bits 18:18 */
		ca_uint32_t test2 : 1; /* bits 19:19 */
		ca_uint32_t rsrvd3 : 4;
		ca_uint32_t rm3 : 2; /* bits 25:24 */
		ca_uint32_t rme3 : 1; /* bits 26:26 */
		ca_uint32_t test3 : 1; /* bits 27:27 */
		ca_uint32_t rsrvd4 : 4;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_4_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_5 0xf4302434
#define L2TM_L2TE_GLB_SRAM_TEST_CONTROL_5_dft 0x00000202

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm0 : 2; /* bits 1:0 */
		ca_uint32_t rme0 : 1; /* bits 2:2 */
		ca_uint32_t test0 : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rm1 : 2; /* bits 9:8 */
		ca_uint32_t rme1 : 1; /* bits 10:10 */
		ca_uint32_t test1 : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 20;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_GLB_SRAM_TEST_CONTROL_5_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_glb */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TE_GLB_REV_ID_t REV_ID; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TE_GLB_CTRL_t CTRL; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TE_GLB_INT_t INT; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TE_GLB_INTE_t INTE; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TE_GLB_STS_t STS; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TE_GLB_PTP_CFG_t PTP_CFG; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TE_GLB_SPARE_CFG_t SPARE_CFG; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TE_GLB_SPARE_STS_t SPARE_STS; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TE_GLB_SRAM_TEST_CONTROL_0_t
	  SRAM_TEST_CONTROL_0; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2TM_L2TE_GLB_SRAM_TEST_CONTROL_1_t
	  SRAM_TEST_CONTROL_1; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TE_GLB_SRAM_TEST_CONTROL_2_t
	  SRAM_TEST_CONTROL_2; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2TM_L2TE_GLB_SRAM_TEST_CONTROL_3_t
	  SRAM_TEST_CONTROL_3; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TE_GLB_SRAM_TEST_CONTROL_4_t
	  SRAM_TEST_CONTROL_4; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TE_GLB_SRAM_TEST_CONTROL_5_t
	  SRAM_TEST_CONTROL_5; /* addr: 0x00000034 */
} APB0_L2TM_L2TE_GLB_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2te_pol
 */

#define L2TM_L2TE_POL_PKT_TYPE_CTRL0 0xf4302500
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_STRIDE 4
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_COUNT 16
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_dft 0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type : 3; /* bits 2:0 */
		ca_uint32_t color_blind : 1; /* bits 3:3 */
		ca_uint32_t pkt_mode : 1; /* bits 4:4 */
		ca_uint32_t egr_len_sel : 1; /* bits 5:5 */
		ca_uint32_t ipg : 5; /* bits 10:6 */
		ca_uint32_t bypass_yellow : 1; /* bits 11:11 */
		ca_uint32_t bypass_red : 1; /* bits 12:12 */
		ca_uint32_t update_mode : 1; /* bits 13:13 */
		ca_uint32_t nest_level : 2; /* bits 15:14 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PKT_TYPE_CTRL0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS 0xf4302540
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2 0xf4302544
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t peak_bs : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1 0xf4302548
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_bs : 6; /* bits 5:0 */
		ca_uint32_t peak_rate_k : 10; /* bits 15:6 */
		ca_uint32_t peak_rate_m : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0 0xf430254c
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_rate_k : 10; /* bits 9:0 */
		ca_uint32_t committed_rate_m : 16; /* bits 25:10 */
		ca_uint32_t committed_bs : 6; /* bits 31:26 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS 0xf4302550
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1 0xf4302554
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t peak_tbc : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0 0xf4302558
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_tbc : 21; /* bits 20:0 */
		ca_uint32_t peak_tbc : 11; /* bits 31:21 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PORT_CTRL0 0xf430255c
#define L2TM_L2TE_POL_PORT_CTRL0_STRIDE 4
#define L2TM_L2TE_POL_PORT_CTRL0_COUNT 16
#define L2TM_L2TE_POL_PORT_CTRL0_dft 0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type : 3; /* bits 2:0 */
		ca_uint32_t color_blind : 1; /* bits 3:3 */
		ca_uint32_t pkt_mode : 1; /* bits 4:4 */
		ca_uint32_t egr_len_sel : 1; /* bits 5:5 */
		ca_uint32_t ipg : 5; /* bits 10:6 */
		ca_uint32_t bypass_yellow : 1; /* bits 11:11 */
		ca_uint32_t bypass_red : 1; /* bits 12:12 */
		ca_uint32_t update_mode : 1; /* bits 13:13 */
		ca_uint32_t nest_level : 2; /* bits 15:14 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PORT_CTRL0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS 0xf430259c
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2 0xf43025a0
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t peak_bs : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1 0xf43025a4
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_bs : 6; /* bits 5:0 */
		ca_uint32_t peak_rate_k : 10; /* bits 15:6 */
		ca_uint32_t peak_rate_m : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0 0xf43025a8
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_rate_k : 10; /* bits 9:0 */
		ca_uint32_t committed_rate_m : 16; /* bits 25:10 */
		ca_uint32_t committed_bs : 6; /* bits 31:26 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS 0xf43025ac
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1 0xf43025b0
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t peak_tbc : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0 0xf43025b4
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_tbc : 21; /* bits 20:0 */
		ca_uint32_t peak_tbc : 11; /* bits 31:21 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_FLOW_GRP_CTRL0 0xf43025b8
#define L2TM_L2TE_POL_FLOW_GRP_CTRL0_STRIDE 4
#define L2TM_L2TE_POL_FLOW_GRP_CTRL0_COUNT 8
#define L2TM_L2TE_POL_FLOW_GRP_CTRL0_dft 0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type : 3; /* bits 2:0 */
		ca_uint32_t color_blind : 1; /* bits 3:3 */
		ca_uint32_t pkt_mode : 1; /* bits 4:4 */
		ca_uint32_t egr_len_sel : 1; /* bits 5:5 */
		ca_uint32_t ipg : 5; /* bits 10:6 */
		ca_uint32_t bypass_yellow : 1; /* bits 11:11 */
		ca_uint32_t bypass_red : 1; /* bits 12:12 */
		ca_uint32_t update_mode : 1; /* bits 13:13 */
		ca_uint32_t nest_level : 2; /* bits 15:14 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_FLOW_GRP_CTRL0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS 0xf43025d8
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2 0xf43025dc
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t peak_bs : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1 0xf43025e0
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_bs : 6; /* bits 5:0 */
		ca_uint32_t peak_rate_k : 10; /* bits 15:6 */
		ca_uint32_t peak_rate_m : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0 0xf43025e4
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_rate_k : 10; /* bits 9:0 */
		ca_uint32_t committed_rate_m : 16; /* bits 25:10 */
		ca_uint32_t committed_bs : 6; /* bits 31:26 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS 0xf43025e8
#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1 0xf43025ec
#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t peak_tbc : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0 0xf43025f0
#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_tbc : 21; /* bits 20:0 */
		ca_uint32_t peak_tbc : 11; /* bits 31:21 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_AGRFLOW_CTRL0 0xf43025f4
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_STRIDE 4
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_COUNT 8
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_dft 0x00000500

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type : 3; /* bits 2:0 */
		ca_uint32_t color_blind : 1; /* bits 3:3 */
		ca_uint32_t pkt_mode : 1; /* bits 4:4 */
		ca_uint32_t egr_len_sel : 1; /* bits 5:5 */
		ca_uint32_t ipg : 5; /* bits 10:6 */
		ca_uint32_t bypass_yellow : 1; /* bits 11:11 */
		ca_uint32_t bypass_red : 1; /* bits 12:12 */
		ca_uint32_t update_mode : 1; /* bits 13:13 */
		ca_uint32_t nest_level : 2; /* bits 15:14 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_AGRFLOW_CTRL0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS 0xf4302614
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 27;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2 0xf4302618
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t peak_bs : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1 0xf430261c
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_bs : 6; /* bits 5:0 */
		ca_uint32_t peak_rate_k : 10; /* bits 15:6 */
		ca_uint32_t peak_rate_m : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0 0xf4302620
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_rate_k : 10; /* bits 9:0 */
		ca_uint32_t committed_rate_m : 16; /* bits 25:10 */
		ca_uint32_t committed_bs : 6; /* bits 31:26 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS 0xf4302624
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 27;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1 0xf4302628
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t peak_tbc : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0 0xf430262c
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t committed_tbc : 21; /* bits 20:0 */
		ca_uint32_t peak_tbc : 11; /* bits 31:21 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_TB_CTRL 0xf4302630
#define L2TM_L2TE_POL_TB_CTRL_dft 0x2ff3e723

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addtok_en : 1; /* bits 0:0 */
		ca_uint32_t subtok_en : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t upd_cnt_lmt : 4; /* bits 7:4 */
		ca_uint32_t cyc_cnt_lmt : 12; /* bits 19:8 */
		ca_uint32_t last_upd_cyc : 12; /* bits 31:20 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_TB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_POL_TB_CTRL1 0xf4302634
#define L2TM_L2TE_POL_TB_CTRL1_dft 0x000001f3

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t k_cnt_lmt : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_POL_TB_CTRL1_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_pol */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TE_POL_PKT_TYPE_CTRL0_t PKT_TYPE_CTRL0; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[63];
	L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t
	  PKT_TYPE_PROFILE_MEM_ACCESS; /* addr: 0x00000040 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t
	  PKT_TYPE_PROFILE_MEM_DATA2; /* addr: 0x00000044 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t
	  PKT_TYPE_PROFILE_MEM_DATA1; /* addr: 0x00000048 */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t
	  PKT_TYPE_PROFILE_MEM_DATA0; /* addr: 0x0000004c */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t
	  PKT_TYPE_COUNTER_MEM_ACCESS; /* addr: 0x00000050 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t
	  PKT_TYPE_COUNTER_MEM_DATA1; /* addr: 0x00000054 */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t
	  PKT_TYPE_COUNTER_MEM_DATA0; /* addr: 0x00000058 */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TE_POL_PORT_CTRL0_t PORT_CTRL0; /* addr: 0x0000005c */
	ca_uint32_t rsrvd9[63];
	L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t
	  PORT_PROFILE_MEM_ACCESS; /* addr: 0x0000009c */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t
	  PORT_PROFILE_MEM_DATA2; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd11[3];
	L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t
	  PORT_PROFILE_MEM_DATA1; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t
	  PORT_PROFILE_MEM_DATA0; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t
	  PORT_COUNTER_MEM_ACCESS; /* addr: 0x000000ac */
	ca_uint32_t rsrvd14[3];
	L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t
	  PORT_COUNTER_MEM_DATA1; /* addr: 0x000000b0 */
	ca_uint32_t rsrvd15[3];
	L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t
	  PORT_COUNTER_MEM_DATA0; /* addr: 0x000000b4 */
	ca_uint32_t rsrvd16[3];
	L2TM_L2TE_POL_FLOW_GRP_CTRL0_t FLOW_GRP_CTRL0; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd17[31];
	L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_t
	  FLOW_PROFILE_MEM_ACCESS; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd18[3];
	L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_t
	  FLOW_PROFILE_MEM_DATA2; /* addr: 0x000000dc */
	ca_uint32_t rsrvd19[3];
	L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_t
	  FLOW_PROFILE_MEM_DATA1; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd20[3];
	L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_t
	  FLOW_PROFILE_MEM_DATA0; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd21[3];
	L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_t
	  FLOW_COUNTER_MEM_ACCESS; /* addr: 0x000000e8 */
	ca_uint32_t rsrvd22[3];
	L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_t
	  FLOW_COUNTER_MEM_DATA1; /* addr: 0x000000ec */
	ca_uint32_t rsrvd23[3];
	L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_t
	  FLOW_COUNTER_MEM_DATA0; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd24[3];
	L2TM_L2TE_POL_AGRFLOW_CTRL0_t AGRFLOW_CTRL0; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd25[31];
	L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t
	  AGRFLOW_PROFILE_MEM_ACCESS; /* addr: 0x00000114 */
	ca_uint32_t rsrvd26[3];
	L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t
	  AGRFLOW_PROFILE_MEM_DATA2; /* addr: 0x00000118 */
	ca_uint32_t rsrvd27[3];
	L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t
	  AGRFLOW_PROFILE_MEM_DATA1; /* addr: 0x0000011c */
	ca_uint32_t rsrvd28[3];
	L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t
	  AGRFLOW_PROFILE_MEM_DATA0; /* addr: 0x00000120 */
	ca_uint32_t rsrvd29[3];
	L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t
	  AGRFLOW_COUNTER_MEM_ACCESS; /* addr: 0x00000124 */
	ca_uint32_t rsrvd30[3];
	L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t
	  AGRFLOW_COUNTER_MEM_DATA1; /* addr: 0x00000128 */
	ca_uint32_t rsrvd31[3];
	L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t
	  AGRFLOW_COUNTER_MEM_DATA0; /* addr: 0x0000012c */
	ca_uint32_t rsrvd32[3];
	L2TM_L2TE_POL_TB_CTRL_t TB_CTRL; /* addr: 0x00000130 */
	ca_uint32_t rsrvd33[3];
	L2TM_L2TE_POL_TB_CTRL1_t TB_CTRL1; /* addr: 0x00000134 */
} APB0_L2TM_L2TE_POL_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2te_shp
 */

#define L2TM_L2TE_SHP_IPG_PROFILE 0xf4302700
#define L2TM_L2TE_SHP_IPG_PROFILE_dft 0x14141414

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ipg0 : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t ipg1 : 5; /* bits 12:8 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t ipg2 : 5; /* bits 20:16 */
		ca_uint32_t rsrvd3 : 3;
		ca_uint32_t ipg3 : 5; /* bits 28:24 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_IPG_PROFILE_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_PORT_IPG_SELECT0 0xf4302704
#define L2TM_L2TE_SHP_PORT_IPG_SELECT0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pid0 : 2; /* bits 1:0 */
		ca_uint32_t pid1 : 2; /* bits 3:2 */
		ca_uint32_t pid2 : 2; /* bits 5:4 */
		ca_uint32_t pid3 : 2; /* bits 7:6 */
		ca_uint32_t pid4 : 2; /* bits 9:8 */
		ca_uint32_t pid5 : 2; /* bits 11:10 */
		ca_uint32_t pid6 : 2; /* bits 13:12 */
		ca_uint32_t pid7 : 2; /* bits 15:14 */
		ca_uint32_t pid8 : 2; /* bits 17:16 */
		ca_uint32_t pid9 : 2; /* bits 19:18 */
		ca_uint32_t pid10 : 2; /* bits 21:20 */
		ca_uint32_t pid11 : 2; /* bits 23:22 */
		ca_uint32_t pid12 : 2; /* bits 25:24 */
		ca_uint32_t pid13 : 2; /* bits 27:26 */
		ca_uint32_t pid14 : 2; /* bits 29:28 */
		ca_uint32_t pid15 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_PORT_IPG_SELECT0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_SRP_CONFIG0 0xf4302708
#define L2TM_L2TE_SHP_SRP_CONFIG0_STRIDE 4
#define L2TM_L2TE_SHP_SRP_CONFIG0_COUNT 2
#define L2TM_L2TE_SHP_SRP_CONFIG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cfg0_enb : 1; /* bits 0:0 */
		ca_uint32_t cfg0_cos : 3; /* bits 3:1 */
		ca_uint32_t rsrvd1 : 11;
		ca_uint32_t cfg0_class_b : 1; /* bits 15:15 */
		ca_uint32_t cfg1_enb : 1; /* bits 16:16 */
		ca_uint32_t cfg1_cos : 3; /* bits 19:17 */
		ca_uint32_t rsrvd2 : 11;
		ca_uint32_t cfg1_class_b : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_SRP_CONFIG0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_SRP_CONFIG_EN 0xf4302710
#define L2TM_L2TE_SHP_SRP_CONFIG_EN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pid0 : 4; /* bits 3:0 */
		ca_uint32_t pid1 : 4; /* bits 7:4 */
		ca_uint32_t pid2 : 4; /* bits 11:8 */
		ca_uint32_t pid3 : 4; /* bits 15:12 */
		ca_uint32_t pid4 : 4; /* bits 19:16 */
		ca_uint32_t pid5 : 4; /* bits 23:20 */
		ca_uint32_t pid6 : 4; /* bits 27:24 */
		ca_uint32_t pid7 : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_SRP_CONFIG_EN_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_CTRL 0xf4302714
#define L2TM_L2TE_SHP_CTRL_dft 0x0000007c

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_mode_class0_cnt : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t pkt_mode_class1_cnt : 7; /* bits 14:8 */
		ca_uint32_t rsrvd2 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS 0xf4302718
#define L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1 0xf430271c
#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bs : 6; /* bits 5:0 */
		ca_uint32_t enb : 2; /* bits 7:6 */
		ca_uint32_t mode : 1; /* bits 8:8 */
		ca_uint32_t tbc : 21; /* bits 29:9 */
		ca_uint32_t pkt_mode_class_sel : 1; /* bits 30:30 */
		ca_uint32_t rsrvd1 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0 0xf4302720
#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rate_k : 10; /* bits 9:0 */
		ca_uint32_t rate_m : 16; /* bits 25:10 */
		ca_uint32_t bs : 6; /* bits 31:26 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS 0xf4302724
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1 0xf4302728
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bs : 6; /* bits 5:0 */
		ca_uint32_t enb : 2; /* bits 7:6 */
		ca_uint32_t mode : 1; /* bits 8:8 */
		ca_uint32_t tbc : 21; /* bits 29:9 */
		ca_uint32_t pkt_mode_class_sel : 1; /* bits 30:30 */
		ca_uint32_t rsrvd1 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0 0xf430272c
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rate_k : 10; /* bits 9:0 */
		ca_uint32_t rate_m : 16; /* bits 25:10 */
		ca_uint32_t bs : 6; /* bits 31:26 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS 0xf4302730
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1 0xf4302734
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bs : 6; /* bits 5:0 */
		ca_uint32_t enb : 2; /* bits 7:6 */
		ca_uint32_t mode : 1; /* bits 8:8 */
		ca_uint32_t tbc : 21; /* bits 29:9 */
		ca_uint32_t pkt_mode_class_sel : 1; /* bits 30:30 */
		ca_uint32_t rsrvd1 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0 0xf4302738
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rate_k : 10; /* bits 9:0 */
		ca_uint32_t rate_m : 16; /* bits 25:10 */
		ca_uint32_t bs : 6; /* bits 31:26 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_AGR_SHP_CFG 0xf430273c
#define L2TM_L2TE_SHP_AGR_SHP_CFG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port_agr_bitmap : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_AGR_SHP_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_AGR_SHP_CTRL1 0xf4302740
#define L2TM_L2TE_SHP_AGR_SHP_CTRL1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cbs : 10; /* bits 9:0 */
		ca_uint32_t enb : 2; /* bits 11:10 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_AGR_SHP_CTRL1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_AGR_SHP_CTRL0 0xf4302744
#define L2TM_L2TE_SHP_AGR_SHP_CTRL0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rate_k : 10; /* bits 9:0 */
		ca_uint32_t rate_m : 16; /* bits 25:10 */
		ca_uint32_t rsrvd1 : 6;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_AGR_SHP_CTRL0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_AGR_SHP_STS 0xf4302748
#define L2TM_L2TE_SHP_AGR_SHP_STS_dft 0x00100000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tbc : 21; /* bits 20:0 */
		ca_uint32_t rsrvd1 : 11;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_AGR_SHP_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_TB_CTRL 0xf430274c
#define L2TM_L2TE_SHP_TB_CTRL_dft 0x2ff3e723

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addtok_en : 1; /* bits 0:0 */
		ca_uint32_t subtok_en : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t upd_cnt_lmt : 4; /* bits 7:4 */
		ca_uint32_t cyc_cnt_lmt : 12; /* bits 19:8 */
		ca_uint32_t last_upd_cyc : 12; /* bits 31:20 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_TB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_SHP_TB_CTRL1 0xf4302750
#define L2TM_L2TE_SHP_TB_CTRL1_dft 0x000001f3

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t k_cnt_lmt : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_SHP_TB_CTRL1_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_shp */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TE_SHP_IPG_PROFILE_t IPG_PROFILE; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TE_SHP_PORT_IPG_SELECT0_t PORT_IPG_SELECT0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TE_SHP_SRP_CONFIG0_t SRP_CONFIG0; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[7];
	L2TM_L2TE_SHP_SRP_CONFIG_EN_t SRP_CONFIG_EN; /* addr: 0x00000010 */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TE_SHP_CTRL_t CTRL; /* addr: 0x00000014 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t
	  PORT_TBC_MEM_ACCESS; /* addr: 0x00000018 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t PORT_TBC_MEM_DATA1; /* addr: 0x0000001c */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t PORT_TBC_MEM_DATA0; /* addr: 0x00000020 */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t
	  GROUP_TBC_MEM_ACCESS; /* addr: 0x00000024 */
	ca_uint32_t rsrvd9[3];
	L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t
	  GROUP_TBC_MEM_DATA1; /* addr: 0x00000028 */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t
	  GROUP_TBC_MEM_DATA0; /* addr: 0x0000002c */
	ca_uint32_t rsrvd11[3];
	L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t VOQ_TBC_MEM_ACCESS; /* addr: 0x00000030 */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t VOQ_TBC_MEM_DATA1; /* addr: 0x00000034 */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t VOQ_TBC_MEM_DATA0; /* addr: 0x00000038 */
	ca_uint32_t rsrvd14[3];
	L2TM_L2TE_SHP_AGR_SHP_CFG_t AGR_SHP_CFG; /* addr: 0x0000003c */
	ca_uint32_t rsrvd15[3];
	L2TM_L2TE_SHP_AGR_SHP_CTRL1_t AGR_SHP_CTRL1; /* addr: 0x00000040 */
	ca_uint32_t rsrvd16[3];
	L2TM_L2TE_SHP_AGR_SHP_CTRL0_t AGR_SHP_CTRL0; /* addr: 0x00000044 */
	ca_uint32_t rsrvd17[3];
	L2TM_L2TE_SHP_AGR_SHP_STS_t AGR_SHP_STS; /* addr: 0x00000048 */
	ca_uint32_t rsrvd18[3];
	L2TM_L2TE_SHP_TB_CTRL_t TB_CTRL; /* addr: 0x0000004c */
	ca_uint32_t rsrvd19[3];
	L2TM_L2TE_SHP_TB_CTRL1_t TB_CTRL1; /* addr: 0x00000050 */
} APB0_L2TM_L2TE_SHP_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2te_wred
 */

#define L2TM_L2TE_WRED_CTRL 0xf4302800
#define L2TM_L2TE_WRED_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t fast_decay : 1; /* bits 2:2 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t afgs_weight : 4; /* bits 7:4 */
		ca_uint32_t rsrvd3 : 24;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_AFGS_MEM_ACCESS 0xf4302804
#define L2TM_L2TE_WRED_AFGS_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 29;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_AFGS_MEM_DATA 0xf4302808
#define L2TM_L2TE_WRED_AFGS_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t depth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_AFGS_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_ACCESS 0xf430280c
#define L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 25;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_DATA7 0xf4302810
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data_rsvd : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_DATA6 0xf4302814
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t unmark_idx : 4; /* bits 3:0 */
		ca_uint32_t mark_idx : 4; /* bits 7:4 */
		ca_uint32_t data_rsvd : 24; /* bits 31:8 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_DATA5 0xf4302818
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mark_dps : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_DATA4 0xf430281c
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mark_dps : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_DATA3 0xf4302820
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mark_dps : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_DATA2 0xf4302824
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t unmark_dps : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_DATA1 0xf4302828
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t unmark_dps : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_MEM_DATA0 0xf430282c
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t unmark_dps : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS 0xf4302830
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 25;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1 0xf4302834
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel6 : 3; /* bits 2:0 */
		ca_uint32_t sel7 : 5; /* bits 7:3 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0 0xf4302838
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel0 : 5; /* bits 4:0 */
		ca_uint32_t sel1 : 5; /* bits 9:5 */
		ca_uint32_t sel2 : 5; /* bits 14:10 */
		ca_uint32_t sel3 : 5; /* bits 19:15 */
		ca_uint32_t sel4 : 5; /* bits 24:20 */
		ca_uint32_t sel5 : 5; /* bits 29:25 */
		ca_uint32_t sel6 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_wred */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TE_WRED_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t AFGS_MEM_ACCESS; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TE_WRED_AFGS_MEM_DATA_t AFGS_MEM_DATA; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t PROFILE_MEM_ACCESS; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t PROFILE_MEM_DATA7; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t PROFILE_MEM_DATA6; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t PROFILE_MEM_DATA5; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t PROFILE_MEM_DATA4; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t PROFILE_MEM_DATA3; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t PROFILE_MEM_DATA2; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t PROFILE_MEM_DATA1; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t PROFILE_MEM_DATA0; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t
	  PROFILE_SELECT_MEM_ACCESS; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t
	  PROFILE_SELECT_MEM_DATA1; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t
	  PROFILE_SELECT_MEM_DATA0; /* addr: 0x00000038 */
} APB0_L2TM_L2TE_WRED_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2te_fc_glb
 */

#define L2TM_L2TE_FC_GLB_INT 0xf4302900
#define L2TM_L2TE_FC_GLB_INT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rxflowcntl0 : 1; /* bits 0:0 */
		ca_uint32_t rxflowcntl1 : 1; /* bits 1:1 */
		ca_uint32_t rxflowcntl2 : 1; /* bits 2:2 */
		ca_uint32_t rxflowcntl3 : 1; /* bits 3:3 */
		ca_uint32_t rxflowcntl4 : 1; /* bits 4:4 */
		ca_uint32_t rxflowcntl5 : 1; /* bits 5:5 */
		ca_uint32_t rxflowcntl6 : 1; /* bits 6:6 */
		ca_uint32_t rxflowcntl7 : 1; /* bits 7:7 */
		ca_uint32_t rxflowcntl8 : 1; /* bits 8:8 */
		ca_uint32_t rxflowcntl9 : 1; /* bits 9:9 */
		ca_uint32_t rxflowcntl10 : 1; /* bits 10:10 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t rxflowcntl13 : 1; /* bits 13:13 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t txflowcntl0 : 1; /* bits 16:16 */
		ca_uint32_t txflowcntl1 : 1; /* bits 17:17 */
		ca_uint32_t txflowcntl2 : 1; /* bits 18:18 */
		ca_uint32_t txflowcntl3 : 1; /* bits 19:19 */
		ca_uint32_t txflowcntl4 : 1; /* bits 20:20 */
		ca_uint32_t txflowcntl5 : 1; /* bits 21:21 */
		ca_uint32_t txflowcntl6 : 1; /* bits 22:22 */
		ca_uint32_t txflowcntl7 : 1; /* bits 23:23 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t txflowcntl9 : 1; /* bits 25:25 */
		ca_uint32_t rsrvd4 : 1;
		ca_uint32_t txflowcntl11 : 1; /* bits 27:27 */
		ca_uint32_t txflowcntl12 : 1; /* bits 28:28 */
		ca_uint32_t txflowcntl13 : 1; /* bits 29:29 */
		ca_uint32_t txflowcntl14 : 1; /* bits 30:30 */
		ca_uint32_t txflowcntl15 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_GLB_INT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_FC_GLB_INTE 0xf4302904
#define L2TM_L2TE_FC_GLB_INTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rxflowcntl0E : 1; /* bits 0:0 */
		ca_uint32_t rxflowcntl1E : 1; /* bits 1:1 */
		ca_uint32_t rxflowcntl2E : 1; /* bits 2:2 */
		ca_uint32_t rxflowcntl3E : 1; /* bits 3:3 */
		ca_uint32_t rxflowcntl4E : 1; /* bits 4:4 */
		ca_uint32_t rxflowcntl5E : 1; /* bits 5:5 */
		ca_uint32_t rxflowcntl6E : 1; /* bits 6:6 */
		ca_uint32_t rxflowcntl7E : 1; /* bits 7:7 */
		ca_uint32_t rxflowcntl8E : 1; /* bits 8:8 */
		ca_uint32_t rxflowcntl9E : 1; /* bits 9:9 */
		ca_uint32_t rxflowcntl10E : 1; /* bits 10:10 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t rxflowcntl13E : 1; /* bits 13:13 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t txflowcntl0E : 1; /* bits 16:16 */
		ca_uint32_t txflowcntl1E : 1; /* bits 17:17 */
		ca_uint32_t txflowcntl2E : 1; /* bits 18:18 */
		ca_uint32_t txflowcntl3E : 1; /* bits 19:19 */
		ca_uint32_t txflowcntl4E : 1; /* bits 20:20 */
		ca_uint32_t txflowcntl5E : 1; /* bits 21:21 */
		ca_uint32_t txflowcntl6E : 1; /* bits 22:22 */
		ca_uint32_t txflowcntl7E : 1; /* bits 23:23 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t txflowcntl9E : 1; /* bits 25:25 */
		ca_uint32_t rsrvd4 : 1;
		ca_uint32_t txflowcntl11E : 1; /* bits 27:27 */
		ca_uint32_t txflowcntl12E : 1; /* bits 28:28 */
		ca_uint32_t txflowcntl13E : 1; /* bits 29:29 */
		ca_uint32_t txflowcntl14E : 1; /* bits 30:30 */
		ca_uint32_t txflowcntl15E : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_GLB_INTE_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_FC_GLB_CTRL 0xf4302908
#define L2TM_L2TE_FC_GLB_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t deepq_rxpfc_en : 8; /* bits 7:0 */
		ca_uint32_t cpu_rxpfc_en : 8; /* bits 15:8 */
		ca_uint32_t l3fewan_rxpfc_en : 8; /* bits 23:16 */
		ca_uint32_t l3felan_rxpfc_en : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_GLB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_FC_GLB_STS 0xf430290c
#define L2TM_L2TE_FC_GLB_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t deepq_rxpfc : 8; /* bits 7:0 */
		ca_uint32_t cpu_rxpfc : 8; /* bits 15:8 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_GLB_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_FC_GLB_TIMER 0xf4302910
#define L2TM_L2TE_FC_GLB_TIMER_dft 0x000073ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num_of_cycles : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t cycle_unit : 3; /* bits 14:12 */
		ca_uint32_t rsrvd2 : 16;
		ca_uint32_t enable : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_GLB_TIMER_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_FC_GLB_PFC_CTRL0 0xf4302914
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_STRIDE 8
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_COUNT 2
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cos_bmap : 8; /* bits 7:0 */
		ca_uint32_t port_bmap : 8; /* bits 15:8 */
		ca_uint32_t rxpfc_en : 1; /* bits 16:16 */
		ca_uint32_t txpfc_en : 1; /* bits 17:17 */
		ca_uint32_t rsrvd1 : 14;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_GLB_PFC_CTRL0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_FC_GLB_PFC_CNT0 0xf4302918
#define L2TM_L2TE_FC_GLB_PFC_CNT0_STRIDE 8
#define L2TM_L2TE_FC_GLB_PFC_CNT0_COUNT 2
#define L2TM_L2TE_FC_GLB_PFC_CNT0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_GLB_PFC_CNT0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_fc_glb */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TE_FC_GLB_INT_t INT; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TE_FC_GLB_INTE_t INTE; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TE_FC_GLB_CTRL_t CTRL; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TE_FC_GLB_STS_t STS; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TE_FC_GLB_TIMER_t TIMER; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TE_FC_GLB_PFC_CTRL0_t PFC_CTRL0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TE_FC_GLB_PFC_CNT0_t PFC_CNT0; /* addr: 0x00000018 */
} APB0_L2TM_L2TE_FC_GLB_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2te_fc[0..13]
 */

#define L2TM_L2TE_FC_CTRL 0xf4302980
#define L2TM_L2TE_FC_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_en : 1; /* bits 0:0 */
		ca_uint32_t tx_en : 1; /* bits 1:1 */
		ca_uint32_t src_rate_enforce : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t stat_pri_sel : 3; /* bits 6:4 */
		ca_uint32_t rsrvd2 : 25;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_FC_STS 0xf4302984
#define L2TM_L2TE_FC_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rxpfc : 8; /* bits 7:0 */
		ca_uint32_t txpfc : 8; /* bits 15:8 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_FC_STAT 0xf4302988
#define L2TM_L2TE_FC_STAT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flag_num : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t voq : 7; /* bits 10:4 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t qm_voq : 9; /* bits 20:12 */
		ca_uint32_t rsrvd3 : 9;
		ca_uint32_t txpfc : 1; /* bits 30:30 */
		ca_uint32_t rxpfc : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_FC_STAT_t;
#endif /* !__ASSEMBLER__ */

#define APB0_L2TM_L2TE_FC_STRIDE 64
#define APB0_L2TM_L2TE_FC_COUNT 14

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_fc */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TE_FC_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TE_FC_STS_t STS; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TE_FC_STAT_t STAT; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[55];
} APB0_L2TM_L2TE_FC_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2te_cb
 */

#define L2TM_L2TE_CB_INT 0xf4302d00
#define L2TM_L2TE_CB_INT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq_bufcnt_udfl : 1; /* bits 0:0 */
		ca_uint32_t voq_bufcnt_ovfl : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t port_freecnt_udfl : 1; /* bits 4:4 */
		ca_uint32_t port_freecnt_ovfl : 1; /* bits 5:5 */
		ca_uint32_t rsrvd2 : 26;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_INT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_INTE 0xf4302d04
#define L2TM_L2TE_CB_INTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq_bufcnt_udflE : 1; /* bits 0:0 */
		ca_uint32_t voq_bufcnt_ovflE : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t port_freecnt_udflE : 1; /* bits 4:4 */
		ca_uint32_t port_freecnt_ovflE : 1; /* bits 5:5 */
		ca_uint32_t rsrvd2 : 26;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_INTE_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_ERR_INFO 0xf4302d08
#define L2TM_L2TE_CB_ERR_INFO_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq_of_buferr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_ERR_INFO_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_CTRL 0xf4302d0c
#define L2TM_L2TE_CB_CTRL_dft 0x0003ff03

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t scan_cycle_per_run : 8; /* bits 7:0 */
		ca_uint32_t scan_cycle_unit : 10; /* bits 17:8 */
		ca_uint32_t rsrvd1 : 12;
		ca_uint32_t cnt_udfl_allow : 1; /* bits 30:30 */
		ca_uint32_t scan_enable : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0 0xf4302d10
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_STRIDE 4
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_COUNT 2
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dqid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0 0xf4302d18
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_STRIDE 4
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_COUNT 2
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dqid : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_TM_TAILDROP_STS0 0xf4302d20
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_STRIDE 4
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_COUNT 4
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_TM_TAILDROP_STS0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_QM_TAILDROP_STS0 0xf4302d30
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_STRIDE 4
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_COUNT 12
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_QM_TAILDROP_STS0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_GLOB_TD_STS 0xf4302d60
#define L2TM_L2TE_CB_GLOB_TD_STS_dft 0x0020ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t per_port_prvt_avl : 16; /* bits 15:0 */
		ca_uint32_t noncong_buf_avl : 1; /* bits 16:16 */
		ca_uint32_t common_buf_avl : 1; /* bits 17:17 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t fc_buf_usg_l : 1; /* bits 21:21 */
		ca_uint32_t fc_buf_usg_m : 1; /* bits 22:22 */
		ca_uint32_t fc_buf_usg_h : 1; /* bits 23:23 */
		ca_uint32_t pfc : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_GLOB_TD_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_PORT_TD_STS 0xf4302d64
#define L2TM_L2TE_CB_PORT_TD_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port : 16; /* bits 15:0 */
		ca_uint32_t src_port : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_PORT_TD_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_TD_STS0 0xf4302d68
#define L2TM_L2TE_CB_VOQ_TD_STS0_STRIDE 4
#define L2TM_L2TE_CB_VOQ_TD_STS0_COUNT 4
#define L2TM_L2TE_CB_VOQ_TD_STS0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t voq : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_TD_STS0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC_PRI_TD_STS 0xf4302d78
#define L2TM_L2TE_CB_SRC_PRI_TD_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t src_pri : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC_PRI_TD_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0 0xf4302d7c
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_STRIDE 8
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0 0xf4302d80
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_STRIDE 8
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t grplth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t grphth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_PORT_THRSH_SELECT 0xf4302d9c
#define L2TM_L2TE_CB_PORT_THRSH_SELECT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t thsel0 : 2; /* bits 1:0 */
		ca_uint32_t thsel1 : 2; /* bits 3:2 */
		ca_uint32_t thsel2 : 2; /* bits 5:4 */
		ca_uint32_t thsel3 : 2; /* bits 7:6 */
		ca_uint32_t thsel4 : 2; /* bits 9:8 */
		ca_uint32_t thsel5 : 2; /* bits 11:10 */
		ca_uint32_t thsel6 : 2; /* bits 13:12 */
		ca_uint32_t thsel7 : 2; /* bits 15:14 */
		ca_uint32_t thsel8 : 2; /* bits 17:16 */
		ca_uint32_t thsel9 : 2; /* bits 19:18 */
		ca_uint32_t thsel10 : 2; /* bits 21:20 */
		ca_uint32_t thsel11 : 2; /* bits 23:22 */
		ca_uint32_t thsel12 : 2; /* bits 25:24 */
		ca_uint32_t thsel13 : 2; /* bits 27:26 */
		ca_uint32_t thsel14 : 2; /* bits 29:28 */
		ca_uint32_t thsel15 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS 0xf4302da0
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 27;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1 0xf4302da4
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t grplth : 13; /* bits 12:0 */
		ca_uint32_t grphth : 15; /* bits 27:13 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0 0xf4302da8
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t hth : 15; /* bits 29:15 */
		ca_uint32_t grplth : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS 0xf4302dac
#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA 0xf4302db0
#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS 0xf4302db4
#define L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA 0xf4302db8
#define L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 15; /* bits 14:0 */
		ca_uint32_t cnt0_msb : 1; /* bits 15:15 */
		ca_uint32_t cnt1 : 15; /* bits 30:16 */
		ca_uint32_t cnt1_msb : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS 0xf4302dbc
#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA 0xf4302dc0
#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 15; /* bits 14:0 */
		ca_uint32_t cnt0_rsvd : 1; /* bits 15:15 */
		ca_uint32_t cnt1 : 15; /* bits 30:16 */
		ca_uint32_t cnt1_rsvd : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS 0xf4302dc4
#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA 0xf4302dc8
#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_GLB_THRSH 0xf4302dcc
#define L2TM_L2TE_CB_GLB_THRSH_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_GLB_THRSH_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_GLB_PRI_THRSH0 0xf4302dd0
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_STRIDE 4
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_COUNT 8
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_GLB_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC_CTRL 0xf4302df0
#define L2TM_L2TE_CB_SRC_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t src0_pri_nspid : 3; /* bits 2:0 */
		ca_uint32_t src0_pri_en : 1; /* bits 3:3 */
		ca_uint32_t src1_pri_nspid : 3; /* bits 6:4 */
		ca_uint32_t src1_pri_en : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0 0xf4302df4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_STRIDE 4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT 0xf4302e04
#define L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t thsel0 : 2; /* bits 1:0 */
		ca_uint32_t thsel1 : 2; /* bits 3:2 */
		ca_uint32_t thsel2 : 2; /* bits 5:4 */
		ca_uint32_t thsel3 : 2; /* bits 7:6 */
		ca_uint32_t thsel4 : 2; /* bits 9:8 */
		ca_uint32_t thsel5 : 2; /* bits 11:10 */
		ca_uint32_t thsel6 : 2; /* bits 13:12 */
		ca_uint32_t thsel7 : 2; /* bits 15:14 */
		ca_uint32_t thsel8 : 2; /* bits 17:16 */
		ca_uint32_t thsel9 : 2; /* bits 19:18 */
		ca_uint32_t thsel10 : 2; /* bits 21:20 */
		ca_uint32_t thsel11 : 2; /* bits 23:22 */
		ca_uint32_t thsel12 : 2; /* bits 25:24 */
		ca_uint32_t thsel13 : 2; /* bits 27:26 */
		ca_uint32_t thsel14 : 2; /* bits 29:28 */
		ca_uint32_t thsel15 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC0_PRI_THRSH0 0xf4302e08
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_STRIDE 4
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_COUNT 8
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC0_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC1_PRI_THRSH0 0xf4302e28
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_STRIDE 4
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_COUNT 8
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC1_PRI_THRSH0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS 0xf4302e48
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA 0xf4302e4c
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS 0xf4302e50
#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA 0xf4302e54
#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0 0xf4302e58
#define L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_dft 0x00007fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t th0 : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0 0xf4302e5c
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_STRIDE 4
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT 0xf4302e6c
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t thsel0 : 2; /* bits 1:0 */
		ca_uint32_t thsel1 : 2; /* bits 3:2 */
		ca_uint32_t thsel2 : 2; /* bits 5:4 */
		ca_uint32_t thsel3 : 2; /* bits 7:6 */
		ca_uint32_t thsel4 : 2; /* bits 9:8 */
		ca_uint32_t thsel5 : 2; /* bits 11:10 */
		ca_uint32_t thsel6 : 2; /* bits 13:12 */
		ca_uint32_t thsel7 : 2; /* bits 15:14 */
		ca_uint32_t thsel8 : 2; /* bits 17:16 */
		ca_uint32_t thsel9 : 2; /* bits 19:18 */
		ca_uint32_t thsel10 : 2; /* bits 21:20 */
		ca_uint32_t thsel11 : 2; /* bits 23:22 */
		ca_uint32_t thsel12 : 2; /* bits 25:24 */
		ca_uint32_t thsel13 : 2; /* bits 27:26 */
		ca_uint32_t thsel14 : 2; /* bits 29:28 */
		ca_uint32_t thsel15 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS 0xf4302e70
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 27;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA 0xf4302e74
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t hth : 15; /* bits 29:15 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS 0xf4302e78
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA 0xf4302e7c
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_WIFI_CTRL 0xf4302e80
#define L2TM_L2TE_CB_WIFI_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t backpressure_en : 1; /* bits 0:0 */
		ca_uint32_t wred_taildrop_dis : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_WIFI_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_WIFI_STS 0xf4302e84
#define L2TM_L2TE_CB_WIFI_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t eq_profile_ov_threshold : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t buffer_ov_threshold : 1; /* bits 8:8 */
		ca_uint32_t rsrvd2 : 22;
		ca_uint32_t wifi_backpressure_on : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_WIFI_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_WIFI_BUFCNT 0xf4302e88
#define L2TM_L2TE_CB_WIFI_BUFCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_WIFI_BUFCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_WIFI_BUF_THRSH 0xf4302e8c
#define L2TM_L2TE_CB_WIFI_BUF_THRSH_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_WIFI_BUF_THRSH_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH 0xf4302e90
#define L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t rsrvd2 : 1;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_CB_ABR_CTRL 0xf4302e94
#define L2TM_L2TE_CB_ABR_CTRL_dft 0x7fff7fff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lth : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t hth : 15; /* bits 30:16 */
		ca_uint32_t drop_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_CB_ABR_CTRL_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_cb */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TE_CB_INT_t INT; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TE_CB_INTE_t INTE; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TE_CB_ERR_INFO_t ERR_INFO; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TE_CB_CTRL_t CTRL; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t
	  TM_DQSCH_HI_BUF_USG0; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[7];
	L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t
	  TM_DQSCH_MID_BUF_USG0; /* addr: 0x00000018 */
	ca_uint32_t rsrvd6[7];
	L2TM_L2TE_CB_TM_TAILDROP_STS0_t TM_TAILDROP_STS0; /* addr: 0x00000020 */
	ca_uint32_t rsrvd7[15];
	L2TM_L2TE_CB_QM_TAILDROP_STS0_t QM_TAILDROP_STS0; /* addr: 0x00000030 */
	ca_uint32_t rsrvd8[47];
	L2TM_L2TE_CB_GLOB_TD_STS_t GLOB_TD_STS; /* addr: 0x00000060 */
	ca_uint32_t rsrvd9[3];
	L2TM_L2TE_CB_PORT_TD_STS_t PORT_TD_STS; /* addr: 0x00000064 */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TE_CB_VOQ_TD_STS0_t VOQ_TD_STS0; /* addr: 0x00000068 */
	ca_uint32_t rsrvd11[15];
	L2TM_L2TE_CB_SRC_PRI_TD_STS_t SRC_PRI_TD_STS; /* addr: 0x00000078 */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t PORT_THRSH_PROFILE0; /* addr: 0x0000007c */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t
	  PORT_GRPTHRSH_PROFILE0; /* addr: 0x00000080 */
	ca_uint32_t rsrvd14[27];
	L2TM_L2TE_CB_PORT_THRSH_SELECT_t PORT_THRSH_SELECT; /* addr: 0x0000009c */
	ca_uint32_t rsrvd15[3];
	L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t
	  VOQ_THRSH_PROFILE_MEM_ACCESS; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd16[3];
	L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t
	  VOQ_THRSH_PROFILE_MEM_DATA1; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd17[3];
	L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t
	  VOQ_THRSH_PROFILE_MEM_DATA0; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd18[3];
	L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t
	  VOQ_THRSH_SELECT_MEM_ACCESS; /* addr: 0x000000ac */
	ca_uint32_t rsrvd19[3];
	L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t
	  VOQ_THRSH_SELECT_MEM_DATA; /* addr: 0x000000b0 */
	ca_uint32_t rsrvd20[3];
	L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t
	  PORT_FREECNT_MEM_ACCESS; /* addr: 0x000000b4 */
	ca_uint32_t rsrvd21[3];
	L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t
	  PORT_FREECNT_MEM_DATA; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd22[3];
	L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t
	  VOQ_BUFCNT_MEM_ACCESS; /* addr: 0x000000bc */
	ca_uint32_t rsrvd23[3];
	L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t VOQ_BUFCNT_MEM_DATA; /* addr: 0x000000c0 */
	ca_uint32_t rsrvd24[3];
	L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t
	  VOQ_MAX_BUFCNT_MEM_ACCESS; /* addr: 0x000000c4 */
	ca_uint32_t rsrvd25[3];
	L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t
	  VOQ_MAX_BUFCNT_MEM_DATA; /* addr: 0x000000c8 */
	ca_uint32_t rsrvd26[3];
	L2TM_L2TE_CB_GLB_THRSH_t GLB_THRSH; /* addr: 0x000000cc */
	ca_uint32_t rsrvd27[3];
	L2TM_L2TE_CB_GLB_PRI_THRSH0_t GLB_PRI_THRSH0; /* addr: 0x000000d0 */
	ca_uint32_t rsrvd28[31];
	L2TM_L2TE_CB_SRC_CTRL_t SRC_CTRL; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd29[3];
	L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t
	  SRC_PORT_THRSH_PROFILE0; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd30[15];
	L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t
	  SRC_PORT_THRSH_SELECT; /* addr: 0x00000104 */
	ca_uint32_t rsrvd31[3];
	L2TM_L2TE_CB_SRC0_PRI_THRSH0_t SRC0_PRI_THRSH0; /* addr: 0x00000108 */
	ca_uint32_t rsrvd32[31];
	L2TM_L2TE_CB_SRC1_PRI_THRSH0_t SRC1_PRI_THRSH0; /* addr: 0x00000128 */
	ca_uint32_t rsrvd33[31];
	L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t
	  SRC_PORT_BUFCNT_MEM_ACCESS; /* addr: 0x00000148 */
	ca_uint32_t rsrvd34[3];
	L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t
	  SRC_PORT_BUFCNT_MEM_DATA; /* addr: 0x0000014c */
	ca_uint32_t rsrvd35[3];
	L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t
	  SRC_PRI_BUFCNT_MEM_ACCESS; /* addr: 0x00000150 */
	ca_uint32_t rsrvd36[3];
	L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t
	  SRC_PRI_BUFCNT_MEM_DATA; /* addr: 0x00000154 */
	ca_uint32_t rsrvd37[3];
	L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t
	  DQSCH_EQ_PROFILE_THRSH0; /* addr: 0x00000158 */
	ca_uint32_t rsrvd38[3];
	L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t
	  DQSCH_PORT_THRSH_PROFILE0; /* addr: 0x0000015c */
	ca_uint32_t rsrvd39[15];
	L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t
	  DQSCH_PORT_THRSH_SELECT; /* addr: 0x0000016c */
	ca_uint32_t rsrvd40[3];
	L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t
	  DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS; /* addr: 0x00000170 */
	ca_uint32_t rsrvd41[3];
	L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t
	  DQSCH_VOQ_THRSH_PROFILE_MEM_DATA; /* addr: 0x00000174 */
	ca_uint32_t rsrvd42[3];
	L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t
	  DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS; /* addr: 0x00000178 */
	ca_uint32_t rsrvd43[3];
	L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t
	  DQSCH_VOQ_THRSH_SELECT_MEM_DATA; /* addr: 0x0000017c */
	ca_uint32_t rsrvd44[3];
	L2TM_L2TE_CB_WIFI_CTRL_t WIFI_CTRL; /* addr: 0x00000180 */
	ca_uint32_t rsrvd45[3];
	L2TM_L2TE_CB_WIFI_STS_t WIFI_STS; /* addr: 0x00000184 */
	ca_uint32_t rsrvd46[3];
	L2TM_L2TE_CB_WIFI_BUFCNT_t WIFI_BUFCNT; /* addr: 0x00000188 */
	ca_uint32_t rsrvd47[3];
	L2TM_L2TE_CB_WIFI_BUF_THRSH_t WIFI_BUF_THRSH; /* addr: 0x0000018c */
	ca_uint32_t rsrvd48[3];
	L2TM_L2TE_CB_WIFI_EQ_PROFILE_THRSH_t
	  WIFI_EQ_PROFILE_THRSH; /* addr: 0x00000190 */
	ca_uint32_t rsrvd49[3];
	L2TM_L2TE_CB_ABR_CTRL_t ABR_CTRL; /* addr: 0x00000194 */
} APB0_L2TM_L2TE_CB_t;
#endif /* !__ASSEMBLER__ */

/*
 * l2te_pm
 */

#define L2TM_L2TE_PM_CTRL 0xf4302f00
#define L2TM_L2TE_PM_CTRL_dft 0x00000ca0

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_saturate : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t mem_saturate : 1; /* bits 4:4 */
		ca_uint32_t mem_auto_clr_on_read : 1; /* bits 5:5 */
		ca_uint32_t mem_init : 1; /* bits 6:6 */
		ca_uint32_t mem_disable : 1; /* bits 7:7 */
		ca_uint32_t cnt0_mem_event_sel : 1; /* bits 8:8 */
		ca_uint32_t cnt0_mem_id_sel : 1; /* bits 9:9 */
		ca_uint32_t cnt1_mem_event_sel : 1; /* bits 10:10 */
		ca_uint32_t cnt1_mem_id_sel : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 20;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_EVENT_CFG_0 0xf4302f04
#define L2TM_L2TE_PM_EVENT_CFG_0_dft 0x33445550

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0_lo : 4; /* bits 3:0 */
		ca_uint32_t cnt0_hi : 4; /* bits 7:4 */
		ca_uint32_t cnt1_lo : 4; /* bits 11:8 */
		ca_uint32_t cnt1_hi : 4; /* bits 15:12 */
		ca_uint32_t cnt2_lo : 4; /* bits 19:16 */
		ca_uint32_t cnt2_hi : 4; /* bits 23:20 */
		ca_uint32_t cnt3_lo : 4; /* bits 27:24 */
		ca_uint32_t cnt3_hi : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_EVENT_CFG_0_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_EVENT_CFG_1 0xf4302f08
#define L2TM_L2TE_PM_EVENT_CFG_1_dft 0x33445550

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0_lo : 4; /* bits 3:0 */
		ca_uint32_t cnt0_hi : 4; /* bits 7:4 */
		ca_uint32_t cnt1_lo : 4; /* bits 11:8 */
		ca_uint32_t cnt1_hi : 4; /* bits 15:12 */
		ca_uint32_t cnt2_lo : 4; /* bits 19:16 */
		ca_uint32_t cnt2_hi : 4; /* bits 23:20 */
		ca_uint32_t cnt3_lo : 4; /* bits 27:24 */
		ca_uint32_t cnt3_hi : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_EVENT_CFG_1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_STS 0xf4302f0c
#define L2TM_L2TE_PM_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pcnt0_init_done : 1; /* bits 0:0 */
		ca_uint32_t pcnt1_init_done : 1; /* bits 1:1 */
		ca_uint32_t bcnt0_init_done : 1; /* bits 2:2 */
		ca_uint32_t bcnt1_init_done : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_STS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_PCNT 0xf4302f10
#define L2TM_L2TE_PM_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_PRE_MARK_PCNT 0xf4302f14
#define L2TM_L2TE_PM_PRE_MARK_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_PRE_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_POL_DROP_PCNT 0xf4302f18
#define L2TM_L2TE_PM_POL_DROP_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_POL_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_TAIL_DROP_PCNT 0xf4302f1c
#define L2TM_L2TE_PM_TAIL_DROP_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_TAIL_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_WRED_Y_DROP_PCNT 0xf4302f20
#define L2TM_L2TE_PM_WRED_Y_DROP_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_WRED_G_DROP_PCNT 0xf4302f24
#define L2TM_L2TE_PM_WRED_G_DROP_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_WRED_G_DROP_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_MARK_PCNT 0xf4302f28
#define L2TM_L2TE_PM_MARK_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_POL_MARK_PCNT 0xf4302f2c
#define L2TM_L2TE_PM_POL_MARK_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_POL_MARK_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_BYPASS_PCNT 0xf4302f30
#define L2TM_L2TE_PM_BYPASS_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_BYPASS_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_BYPASS_FLOW_PCNT 0xf4302f34
#define L2TM_L2TE_PM_BYPASS_FLOW_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CE_PCNT 0xf4302f38
#define L2TM_L2TE_PM_CE_PCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CE_PCNT_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_ACCESS 0xf4302f3c
#define L2TM_L2TE_PM_CNT_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA8 0xf4302f40
#define L2TM_L2TE_PM_CNT_MEM_DATA8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt7 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA8_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA7 0xf4302f44
#define L2TM_L2TE_PM_CNT_MEM_DATA7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt6 : 12; /* bits 11:0 */
		ca_uint32_t cnt7 : 20; /* bits 31:12 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA7_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA6 0xf4302f48
#define L2TM_L2TE_PM_CNT_MEM_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt5 : 8; /* bits 7:0 */
		ca_uint32_t cnt6 : 24; /* bits 31:8 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA5 0xf4302f4c
#define L2TM_L2TE_PM_CNT_MEM_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt4 : 4; /* bits 3:0 */
		ca_uint32_t cnt5 : 28; /* bits 31:4 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA4 0xf4302f50
#define L2TM_L2TE_PM_CNT_MEM_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt4 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA3 0xf4302f54
#define L2TM_L2TE_PM_CNT_MEM_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt3 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA2 0xf4302f58
#define L2TM_L2TE_PM_CNT_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA1 0xf4302f5c
#define L2TM_L2TE_PM_CNT_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L2TM_L2TE_PM_CNT_MEM_DATA0 0xf4302f60
#define L2TM_L2TE_PM_CNT_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L2TM_L2TE_PM_CNT_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_pm */
#ifndef __ASSEMBLER__
typedef struct {
	L2TM_L2TE_PM_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L2TM_L2TE_PM_EVENT_CFG_0_t EVENT_CFG_0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L2TM_L2TE_PM_EVENT_CFG_1_t EVENT_CFG_1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L2TM_L2TE_PM_STS_t STS; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L2TM_L2TE_PM_PCNT_t PCNT; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L2TM_L2TE_PM_PRE_MARK_PCNT_t PRE_MARK_PCNT; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L2TM_L2TE_PM_POL_DROP_PCNT_t POL_DROP_PCNT; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L2TM_L2TE_PM_TAIL_DROP_PCNT_t TAIL_DROP_PCNT; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t WRED_Y_DROP_PCNT; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L2TM_L2TE_PM_WRED_G_DROP_PCNT_t WRED_G_DROP_PCNT; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L2TM_L2TE_PM_MARK_PCNT_t MARK_PCNT; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L2TM_L2TE_PM_POL_MARK_PCNT_t POL_MARK_PCNT; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L2TM_L2TE_PM_BYPASS_PCNT_t BYPASS_PCNT; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t BYPASS_FLOW_PCNT; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L2TM_L2TE_PM_CE_PCNT_t CE_PCNT; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L2TM_L2TE_PM_CNT_MEM_ACCESS_t CNT_MEM_ACCESS; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L2TM_L2TE_PM_CNT_MEM_DATA8_t CNT_MEM_DATA8; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L2TM_L2TE_PM_CNT_MEM_DATA7_t CNT_MEM_DATA7; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L2TM_L2TE_PM_CNT_MEM_DATA6_t CNT_MEM_DATA6; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L2TM_L2TE_PM_CNT_MEM_DATA5_t CNT_MEM_DATA5; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L2TM_L2TE_PM_CNT_MEM_DATA4_t CNT_MEM_DATA4; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L2TM_L2TE_PM_CNT_MEM_DATA3_t CNT_MEM_DATA3; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L2TM_L2TE_PM_CNT_MEM_DATA2_t CNT_MEM_DATA2; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L2TM_L2TE_PM_CNT_MEM_DATA1_t CNT_MEM_DATA1; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L2TM_L2TE_PM_CNT_MEM_DATA0_t CNT_MEM_DATA0; /* addr: 0x00000060 */
} APB0_L2TM_L2TE_PM_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2TM */

#ifndef __ASSEMBLER__
typedef struct {
	APB0_L2TM_L2TM_GLB_t l2tm_glb; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[239];
	APB0_L2TM_L2TM_BM_t l2tm_bm; /* addr: 0x00000100 */
	ca_uint32_t rsrvd2[171];
	APB0_L2TM_L2TM_QM_t l2tm_qm; /* addr: 0x00000200 */
	ca_uint32_t rsrvd3[171];
	APB0_L2TM_L2TM_ES_t l2tm_es; /* addr: 0x00000300 */
	ca_uint32_t rsrvd4[129];
	APB0_L2TM_L2TE_GLB_t l2te_glb; /* addr: 0x00000400 */
	ca_uint32_t rsrvd5[229];
	APB0_L2TM_L2TE_POL_t l2te_pol; /* addr: 0x00000500 */
	ca_uint32_t rsrvd6[357];
	APB0_L2TM_L2TE_SHP_t l2te_shp; /* addr: 0x00000700 */
	ca_uint32_t rsrvd7[215];
	APB0_L2TM_L2TE_WRED_t l2te_wred; /* addr: 0x00000800 */
	ca_uint32_t rsrvd8[227];
	APB0_L2TM_L2TE_FC_GLB_t l2te_fc_glb; /* addr: 0x00000900 */
	ca_uint32_t rsrvd9[111];
	APB0_L2TM_L2TE_FC_t l2te_fc[14]; /* addr: 0x00000980 */
	APB0_L2TM_L2TE_CB_t l2te_cb; /* addr: 0x00000d00 */
	ca_uint32_t rsrvd10[309];
	APB0_L2TM_L2TE_PM_t l2te_pm; /* addr: 0x00000f00 */
} APB0_L2TM_t;
#endif /* !__ASSEMBLER__ */

/*
 * L3FE
 */

/*
 * GLB
 */

#define L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS 0xf4303000
#define L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA3 0xf4303004
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t LDPID : 2; /* bits 1:0 */
		ca_uint32_t DEEP_Q : 1; /* bits 2:2 */
		ca_uint32_t STAGE3_CTRL_VLD : 1; /* bits 3:3 */
		ca_uint32_t STAGE3_CTRL : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA2 0xf4303008
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t PPPOE_SESSION_ID : 15; /* bits 14:0 */
		ca_uint32_t MAC_DA_VLD : 1; /* bits 15:15 */
		ca_uint32_t MAC_DA_AN_SEL : 4; /* bits 19:16 */
		ca_uint32_t MAC_SA_VLD : 1; /* bits 20:20 */
		ca_uint32_t MAC_SA_AN_SEL : 4; /* bits 24:21 */
		ca_uint32_t L2_FORMAT_VLD : 1; /* bits 25:25 */
		ca_uint32_t L2_FORMAT : 1; /* bits 26:26 */
		ca_uint32_t LDPID_VLD : 1; /* bits 27:27 */
		ca_uint32_t LDPID : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA1 0xf430300c
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t INNER_TPID_SEL : 1; /* bits 0:0 */
		ca_uint32_t INNER_TPID_ENC : 3; /* bits 3:1 */
		ca_uint32_t TOP_DEI_SEL : 2; /* bits 5:4 */
		ca_uint32_t TOP_DEI : 1; /* bits 6:6 */
		ca_uint32_t TOP_VID : 12; /* bits 18:7 */
		ca_uint32_t TOP_TPID_SEL : 2; /* bits 20:19 */
		ca_uint32_t TOP_TPID_ENC : 3; /* bits 23:21 */
		ca_uint32_t INNER_VLAN_CMD : 2; /* bits 25:24 */
		ca_uint32_t VLAN_CNT : 2; /* bits 27:26 */
		ca_uint32_t VLAN_VLD : 1; /* bits 28:28 */
		ca_uint32_t PPPOE_SET : 1; /* bits 29:29 */
		ca_uint32_t PPPOE_VLD : 1; /* bits 30:30 */
		ca_uint32_t PPPOE_SESSION_ID : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA0 0xf4303010
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t MTU_VLD : 1; /* bits 0:0 */
		ca_uint32_t MTU_ENC : 2; /* bits 2:1 */
		ca_uint32_t INNER_802_1P_SEL : 3; /* bits 5:3 */
		ca_uint32_t INNER_802_1P : 3; /* bits 8:6 */
		ca_uint32_t TOP_802_1P_SEL : 3; /* bits 11:9 */
		ca_uint32_t TOP_802_1P : 3; /* bits 14:12 */
		ca_uint32_t QOS_802_1P_TABLE_SEL : 1; /* bits 15:15 */
		ca_uint32_t INNER_DEI_SEL : 2; /* bits 17:16 */
		ca_uint32_t INNER_DEI : 1; /* bits 18:18 */
		ca_uint32_t INNER_VID : 12; /* bits 30:19 */
		ca_uint32_t INNER_TPID_SEL : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DSCP_MAP_TBL_ACCESS 0xf4303014
#define L3FE_GLB_DSCP_MAP_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DSCP_MAP_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DSCP_MAP_TBL_DATA1 0xf4303018
#define L3FE_GLB_DSCP_MAP_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dscp_2_pf1_dscp : 2; /* bits 1:0 */
		ca_uint32_t dscp_2_pf1_cos : 4; /* bits 5:2 */
		ca_uint32_t dscp_2_pf1_pol_id : 9; /* bits 14:6 */
		ca_uint32_t dscp_2_pf1_pol_grp_id : 3; /* bits 17:15 */
		ca_uint32_t rsrvd1 : 14;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DSCP_MAP_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DSCP_MAP_TBL_DATA0 0xf430301c
#define L3FE_GLB_DSCP_MAP_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dscp_2_pf0_dot1p : 3; /* bits 2:0 */
		ca_uint32_t dscp_2_pf0_dscp : 6; /* bits 8:3 */
		ca_uint32_t dscp_2_pf0_cos : 4; /* bits 12:9 */
		ca_uint32_t dscp_2_pf0_pol_id : 9; /* bits 21:13 */
		ca_uint32_t dscp_2_pf0_pol_grp_id : 3; /* bits 24:22 */
		ca_uint32_t dscp_2_pf1_dot1p : 3; /* bits 27:25 */
		ca_uint32_t dscp_2_pf1_dscp : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DSCP_MAP_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_0_0 0xf4303020
#define L3FE_GLB_DOT1P_MAPPING_0_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_0_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_1_0 0xf4303024
#define L3FE_GLB_DOT1P_MAPPING_1_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_1_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_0_1 0xf4303028
#define L3FE_GLB_DOT1P_MAPPING_0_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_0_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_1_1 0xf430302c
#define L3FE_GLB_DOT1P_MAPPING_1_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_1_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_0_2 0xf4303030
#define L3FE_GLB_DOT1P_MAPPING_0_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_0_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_1_2 0xf4303034
#define L3FE_GLB_DOT1P_MAPPING_1_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_1_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_0_3 0xf4303038
#define L3FE_GLB_DOT1P_MAPPING_0_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_0_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_1_3 0xf430303c
#define L3FE_GLB_DOT1P_MAPPING_1_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_1_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_0_4 0xf4303040
#define L3FE_GLB_DOT1P_MAPPING_0_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_0_4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_1_4 0xf4303044
#define L3FE_GLB_DOT1P_MAPPING_1_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_1_4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_0_5 0xf4303048
#define L3FE_GLB_DOT1P_MAPPING_0_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_0_5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_1_5 0xf430304c
#define L3FE_GLB_DOT1P_MAPPING_1_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_1_5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_0_6 0xf4303050
#define L3FE_GLB_DOT1P_MAPPING_0_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_0_6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_1_6 0xf4303054
#define L3FE_GLB_DOT1P_MAPPING_1_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_1_6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_0_7 0xf4303058
#define L3FE_GLB_DOT1P_MAPPING_0_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_0_7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DOT1P_MAPPING_1_7 0xf430305c
#define L3FE_GLB_DOT1P_MAPPING_1_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DOT1P_MAPPING_1_7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_0_0 0xf4303060
#define L3FE_GLB_COS_MAPPING_0_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_0_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_1_0 0xf4303064
#define L3FE_GLB_COS_MAPPING_1_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_1_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_0_1 0xf4303068
#define L3FE_GLB_COS_MAPPING_0_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_0_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_1_1 0xf430306c
#define L3FE_GLB_COS_MAPPING_1_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_1_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_0_2 0xf4303070
#define L3FE_GLB_COS_MAPPING_0_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_0_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_1_2 0xf4303074
#define L3FE_GLB_COS_MAPPING_1_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_1_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_0_3 0xf4303078
#define L3FE_GLB_COS_MAPPING_0_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_0_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_1_3 0xf430307c
#define L3FE_GLB_COS_MAPPING_1_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_1_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_0_4 0xf4303080
#define L3FE_GLB_COS_MAPPING_0_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_0_4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_1_4 0xf4303084
#define L3FE_GLB_COS_MAPPING_1_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_1_4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_0_5 0xf4303088
#define L3FE_GLB_COS_MAPPING_0_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_0_5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_1_5 0xf430308c
#define L3FE_GLB_COS_MAPPING_1_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_1_5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_0_6 0xf4303090
#define L3FE_GLB_COS_MAPPING_0_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_0_6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_1_6 0xf4303094
#define L3FE_GLB_COS_MAPPING_1_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_1_6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_0_7 0xf4303098
#define L3FE_GLB_COS_MAPPING_0_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_0_7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_COS_MAPPING_1_7 0xf430309c
#define L3FE_GLB_COS_MAPPING_1_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_COS_MAPPING_1_7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_FWD_CTRL_0 0xf43030a0
#define L3FE_GLB_FWD_CTRL_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t change_to_llc : 1; /* bits 0:0 */
		ca_uint32_t ipv4_change_ipv6 : 1; /* bits 1:1 */
		ca_uint32_t llc_raw8023_change : 1; /* bits 2:2 */
		ca_uint32_t nonip_change_ip : 1; /* bits 3:3 */
		ca_uint32_t nonip_add_pppoe : 1; /* bits 4:4 */
		ca_uint32_t nonl4_change_l4 : 1; /* bits 5:5 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_FWD_CTRL_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_FWD_CTRL_1 0xf43030a4
#define L3FE_GLB_FWD_CTRL_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t change_to_llc : 1; /* bits 0:0 */
		ca_uint32_t ipv4_change_ipv6 : 1; /* bits 1:1 */
		ca_uint32_t llc_raw8023_change : 1; /* bits 2:2 */
		ca_uint32_t nonip_change_ip : 1; /* bits 3:3 */
		ca_uint32_t nonip_add_pppoe : 1; /* bits 4:4 */
		ca_uint32_t nonl4_change_l4 : 1; /* bits 5:5 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_FWD_CTRL_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_FWD_CTRL_2 0xf43030a8
#define L3FE_GLB_FWD_CTRL_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t change_to_llc : 1; /* bits 0:0 */
		ca_uint32_t ipv4_change_ipv6 : 1; /* bits 1:1 */
		ca_uint32_t llc_raw8023_change : 1; /* bits 2:2 */
		ca_uint32_t nonip_change_ip : 1; /* bits 3:3 */
		ca_uint32_t nonip_add_pppoe : 1; /* bits 4:4 */
		ca_uint32_t nonl4_change_l4 : 1; /* bits 5:5 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_FWD_CTRL_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_FWD_CTRL_3 0xf43030ac
#define L3FE_GLB_FWD_CTRL_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t change_to_llc : 1; /* bits 0:0 */
		ca_uint32_t ipv4_change_ipv6 : 1; /* bits 1:1 */
		ca_uint32_t llc_raw8023_change : 1; /* bits 2:2 */
		ca_uint32_t nonip_change_ip : 1; /* bits 3:3 */
		ca_uint32_t nonip_add_pppoe : 1; /* bits 4:4 */
		ca_uint32_t nonl4_change_l4 : 1; /* bits 5:5 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_FWD_CTRL_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_GLB_CFG 0xf43030b0
#define L3FE_GLB_GLB_CFG_dft 0x0001b000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3fe_port_mmship_chk_en : 1; /* bits 0:0 */
		ca_uint32_t use_o_lspid_for_mmshp_chk : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t spcl_port : 6; /* bits 11:6 */
		ca_uint32_t mc_port : 6; /* bits 17:12 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t ni_fe_12_bv : 1; /* bits 21:21 */
		ca_uint32_t pl_mode : 2; /* bits 23:22 */
		ca_uint32_t rsrvd3 : 7;
		ca_uint32_t l3fe_pon_mode : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_GLB_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_LF_CFG 0xf43030b4
#define L3FE_GLB_LF_CFG_dft 0x004641f4

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hi_threshold : 10; /* bits 9:0 */
		ca_uint32_t low_threshold : 10; /* bits 19:10 */
		ca_uint32_t wr_fifo_threshold : 4; /* bits 23:20 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_LF_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ILPB_01 0xf43030b8
#define L3FE_GLB_ILPB_01_STRIDE 8
#define L3FE_GLB_ILPB_01_COUNT 4
#define L3FE_GLB_ILPB_01_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t entry1 : 15; /* bits 14:0 */
		ca_uint32_t rsrvd1 : 17;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ILPB_01_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ILPB_00 0xf43030bc
#define L3FE_GLB_ILPB_00_STRIDE 8
#define L3FE_GLB_ILPB_00_COUNT 4
#define L3FE_GLB_ILPB_00_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t entry0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ILPB_00_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ILPB_LDPID 0xf43030d8
#define L3FE_GLB_ILPB_LDPID_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t valid0 : 1; /* bits 0:0 */
		ca_uint32_t ldpid0 : 6; /* bits 6:1 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t valid1 : 1; /* bits 8:8 */
		ca_uint32_t ldpid1 : 6; /* bits 14:9 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t valid2 : 1; /* bits 16:16 */
		ca_uint32_t ldpid2 : 6; /* bits 22:17 */
		ca_uint32_t valid3 : 1; /* bits 23:23 */
		ca_uint32_t rsrvd3 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ILPB_LDPID_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ELPB1 0xf43030dc
#define L3FE_GLB_ELPB1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t entry1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ELPB1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ELPB0 0xf43030e0
#define L3FE_GLB_ELPB0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t entry0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ELPB0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ELPB_DEEPQ_VLD1 0xf43030e4
#define L3FE_GLB_ELPB_DEEPQ_VLD1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ELPB_DEEPQ_VLD1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ELPB_DEEPQ_VLD0 0xf43030e8
#define L3FE_GLB_ELPB_DEEPQ_VLD0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ELPB_DEEPQ_VLD0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ELPB_DEEPQ1 0xf43030ec
#define L3FE_GLB_ELPB_DEEPQ1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ELPB_DEEPQ1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_ELPB_DEEPQ0 0xf43030f0
#define L3FE_GLB_ELPB_DEEPQ0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_ELPB_DEEPQ0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_L3FE_L2FE_LDPID 0xf43030f4
#define L3FE_GLB_L3FE_L2FE_LDPID_dft 0x00000019

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_L3FE_L2FE_LDPID_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_VE 0xf43030f8
#define L3FE_GLB_VE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t stag_tpid_enc : 3; /* bits 2:0 */
		ca_uint32_t ctag_tpid_enc : 3; /* bits 5:3 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_VE_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_T5_OPTION 0xf43030fc
#define L3FE_GLB_T5_OPTION_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_T5_OPTION_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_T5_TO_CPU 0xf4303100
#define L3FE_GLB_T5_TO_CPU_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ldpid_cpu : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t r2p2_cpu_en : 1; /* bits 8:8 */
		ca_uint32_t r2p3_cpu_en : 1; /* bits 9:9 */
		ca_uint32_t r2p4_cpu_en : 1; /* bits 10:10 */
		ca_uint32_t r2p2_cpu_keep_org_pkt : 1; /* bits 11:11 */
		ca_uint32_t r2p3_cpu_keep_org_pkt : 1; /* bits 12:12 */
		ca_uint32_t r2p4_cpu_keep_org_pkt : 1; /* bits 13:13 */
		ca_uint32_t r2p2_cpu_l2_pkt_type : 3; /* bits 16:14 */
		ca_uint32_t r2p3_cpu_l2_pkt_type : 3; /* bits 19:17 */
		ca_uint32_t r2p4_cpu_l2_pkt_type : 3; /* bits 22:20 */
		ca_uint32_t rsrvd2 : 9;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_T5_TO_CPU_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_TE_OPTION 0xf4303104
#define L3FE_GLB_TE_OPTION_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_TE_OPTION_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_CLS_STG_MONITOR_CTRL 0xf4303108
#define L3FE_GLB_CLS_STG_MONITOR_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bus_sel : 8; /* bits 7:0 */
		ca_uint32_t enable : 1; /* bits 8:8 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_CLS_STG_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_CLS_STG_MONITOR_RETURN 0xf430310c
#define L3FE_GLB_CLS_STG_MONITOR_RETURN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_CLS_STG_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DBG_IDX 0xf4303110
#define L3FE_GLB_DBG_IDX_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t idx : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DBG_IDX_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_DBG_DAT 0xf4303114
#define L3FE_GLB_DBG_DAT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dat : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_DBG_DAT_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_L3FE_MONITOR_TRIG 0xf4303118
#define L3FE_GLB_L3FE_MONITOR_TRIG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t en : 1; /* bits 0:0 */
		ca_uint32_t mode : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_L3FE_MONITOR_TRIG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_L3FE_MONITOR_CTRL 0xf430311c
#define L3FE_GLB_L3FE_MONITOR_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bus_sel : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_L3FE_MONITOR_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_L3FE_MONITOR_RETURN 0xf4303120
#define L3FE_GLB_L3FE_MONITOR_RETURN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_L3FE_MONITOR_RETURN_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_RES_CTRL 0xf4303124
#define L3FE_GLB_RES_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ttl_0_cpu_en : 1; /* bits 0:0 */
		ca_uint32_t ttl_0_cpu_ldpid : 6; /* bits 6:1 */
		ca_uint32_t ttl_0_cpu_deepq : 1; /* bits 7:7 */
		ca_uint32_t ttl_0_cpu_deepq_vld : 1; /* bits 8:8 */
		ca_uint32_t ttl_0_cpu_keep_org_pkt : 1; /* bits 9:9 */
		ca_uint32_t ttl_0_cpu_keep_org_pkt_vld : 1; /* bits 10:10 */
		ca_uint32_t ttl_0_cpu_ctrl_bypass : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_RES_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_nhop1 0xf4303128
#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_nhop1_dft 0x00222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sramtest : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_WRAP_l3fe_nhop1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_nhop2 0xf430312c
#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_nhop2_dft 0x02222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sramtest : 28; /* bits 27:0 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_WRAP_l3fe_nhop2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_lpm1 0xf4303130
#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_lpm1_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sramtest : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_WRAP_l3fe_lpm1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_nat1 0xf4303134
#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_nat1_dft 0x00002222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sramtest1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_WRAP_l3fe_nat1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_nat0 0xf4303138
#define L3FE_GLB_SRAM_TEST_WRAP_l3fe_nat0_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sramtest0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_WRAP_l3fe_nat0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_CONTROL_0 0xf430313c
#define L3FE_GLB_SRAM_TEST_CONTROL_0_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_CONTROL_1 0xf4303140
#define L3FE_GLB_SRAM_TEST_CONTROL_1_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_CONTROL_2 0xf4303144
#define L3FE_GLB_SRAM_TEST_CONTROL_2_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_CONTROL_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_CONTROL_3 0xf4303148
#define L3FE_GLB_SRAM_TEST_CONTROL_3_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm7 : 2; /* bits 1:0 */
		ca_uint32_t rme7 : 1; /* bits 2:2 */
		ca_uint32_t test7 : 1; /* bits 3:3 */
		ca_uint32_t rm6 : 2; /* bits 5:4 */
		ca_uint32_t rme6 : 1; /* bits 6:6 */
		ca_uint32_t test6 : 1; /* bits 7:7 */
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_CONTROL_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_TEST_CONTROL_4 0xf430314c
#define L3FE_GLB_SRAM_TEST_CONTROL_4_dft 0x22222200

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t rm5 : 2; /* bits 9:8 */
		ca_uint32_t rme5 : 1; /* bits 10:10 */
		ca_uint32_t test5 : 1; /* bits 11:11 */
		ca_uint32_t rm4 : 2; /* bits 13:12 */
		ca_uint32_t rme4 : 1; /* bits 14:14 */
		ca_uint32_t test4 : 1; /* bits 15:15 */
		ca_uint32_t rm3 : 2; /* bits 17:16 */
		ca_uint32_t rme3 : 1; /* bits 18:18 */
		ca_uint32_t test3 : 1; /* bits 19:19 */
		ca_uint32_t rm2 : 2; /* bits 21:20 */
		ca_uint32_t rme2 : 1; /* bits 22:22 */
		ca_uint32_t test2 : 1; /* bits 23:23 */
		ca_uint32_t rm1 : 2; /* bits 25:24 */
		ca_uint32_t rme1 : 1; /* bits 26:26 */
		ca_uint32_t test1 : 1; /* bits 27:27 */
		ca_uint32_t rm0 : 2; /* bits 29:28 */
		ca_uint32_t rme0 : 1; /* bits 30:30 */
		ca_uint32_t test0 : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_TEST_CONTROL_4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_LS_CONTROL_0 0xf4303150
#define L3FE_GLB_SRAM_LS_CONTROL_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3fe1_sramls : 9; /* bits 8:0 */
		ca_uint32_t l3fe2a_sramls : 12; /* bits 20:9 */
		ca_uint32_t rsrvd1 : 11;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_LS_CONTROL_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_LS_CONTROL_1 0xf4303154
#define L3FE_GLB_SRAM_LS_CONTROL_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3fe2b_sramls : 12; /* bits 11:0 */
		ca_uint32_t l3fe3_sramls : 5; /* bits 16:12 */
		ca_uint32_t l3fe_lpm1_sramls : 8; /* bits 24:17 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_LS_CONTROL_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_LS_CONTROL_2 0xf4303158
#define L3FE_GLB_SRAM_LS_CONTROL_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3fe_lpm2_sramls : 8; /* bits 7:0 */
		ca_uint32_t l3fe_lpm3_sramls : 8; /* bits 15:8 */
		ca_uint32_t l3fe_lpm4_sramls : 8; /* bits 23:16 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_LS_CONTROL_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_GLB_SRAM_LS_CONTROL_3 0xf430315c
#define L3FE_GLB_SRAM_LS_CONTROL_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3fe_nat_sramls : 12; /* bits 11:0 */
		ca_uint32_t l3fe_nhop1_sramls : 6; /* bits 17:12 */
		ca_uint32_t l3fe_nhop2_sramls : 7; /* bits 24:18 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} L3FE_GLB_SRAM_LS_CONTROL_3_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t
	  EGRESS_L3_IF_TBL_ACCESS; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_GLB_EGRESS_L3_IF_TBL_DATA3_t
	  EGRESS_L3_IF_TBL_DATA3; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_t
	  EGRESS_L3_IF_TBL_DATA2; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_t
	  EGRESS_L3_IF_TBL_DATA1; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_t
	  EGRESS_L3_IF_TBL_DATA0; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L3FE_GLB_DSCP_MAP_TBL_ACCESS_t DSCP_MAP_TBL_ACCESS; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L3FE_GLB_DSCP_MAP_TBL_DATA1_t DSCP_MAP_TBL_DATA1; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L3FE_GLB_DSCP_MAP_TBL_DATA0_t DSCP_MAP_TBL_DATA0; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L3FE_GLB_DOT1P_MAPPING_0_0_t DOT1P_MAPPING_0_0; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L3FE_GLB_DOT1P_MAPPING_1_0_t DOT1P_MAPPING_1_0; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L3FE_GLB_DOT1P_MAPPING_0_1_t DOT1P_MAPPING_0_1; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L3FE_GLB_DOT1P_MAPPING_1_1_t DOT1P_MAPPING_1_1; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L3FE_GLB_DOT1P_MAPPING_0_2_t DOT1P_MAPPING_0_2; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L3FE_GLB_DOT1P_MAPPING_1_2_t DOT1P_MAPPING_1_2; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L3FE_GLB_DOT1P_MAPPING_0_3_t DOT1P_MAPPING_0_3; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L3FE_GLB_DOT1P_MAPPING_1_3_t DOT1P_MAPPING_1_3; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L3FE_GLB_DOT1P_MAPPING_0_4_t DOT1P_MAPPING_0_4; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L3FE_GLB_DOT1P_MAPPING_1_4_t DOT1P_MAPPING_1_4; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L3FE_GLB_DOT1P_MAPPING_0_5_t DOT1P_MAPPING_0_5; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L3FE_GLB_DOT1P_MAPPING_1_5_t DOT1P_MAPPING_1_5; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L3FE_GLB_DOT1P_MAPPING_0_6_t DOT1P_MAPPING_0_6; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L3FE_GLB_DOT1P_MAPPING_1_6_t DOT1P_MAPPING_1_6; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L3FE_GLB_DOT1P_MAPPING_0_7_t DOT1P_MAPPING_0_7; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L3FE_GLB_DOT1P_MAPPING_1_7_t DOT1P_MAPPING_1_7; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L3FE_GLB_COS_MAPPING_0_0_t COS_MAPPING_0_0; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L3FE_GLB_COS_MAPPING_1_0_t COS_MAPPING_1_0; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L3FE_GLB_COS_MAPPING_0_1_t COS_MAPPING_0_1; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L3FE_GLB_COS_MAPPING_1_1_t COS_MAPPING_1_1; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L3FE_GLB_COS_MAPPING_0_2_t COS_MAPPING_0_2; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L3FE_GLB_COS_MAPPING_1_2_t COS_MAPPING_1_2; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L3FE_GLB_COS_MAPPING_0_3_t COS_MAPPING_0_3; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L3FE_GLB_COS_MAPPING_1_3_t COS_MAPPING_1_3; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L3FE_GLB_COS_MAPPING_0_4_t COS_MAPPING_0_4; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L3FE_GLB_COS_MAPPING_1_4_t COS_MAPPING_1_4; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L3FE_GLB_COS_MAPPING_0_5_t COS_MAPPING_0_5; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L3FE_GLB_COS_MAPPING_1_5_t COS_MAPPING_1_5; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	L3FE_GLB_COS_MAPPING_0_6_t COS_MAPPING_0_6; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	L3FE_GLB_COS_MAPPING_1_6_t COS_MAPPING_1_6; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	L3FE_GLB_COS_MAPPING_0_7_t COS_MAPPING_0_7; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	L3FE_GLB_COS_MAPPING_1_7_t COS_MAPPING_1_7; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	L3FE_GLB_FWD_CTRL_0_t FWD_CTRL_0; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	L3FE_GLB_FWD_CTRL_1_t FWD_CTRL_1; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	L3FE_GLB_FWD_CTRL_2_t FWD_CTRL_2; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd43[3];
	L3FE_GLB_FWD_CTRL_3_t FWD_CTRL_3; /* addr: 0x000000ac */
	ca_uint32_t rsrvd44[3];
	L3FE_GLB_GLB_CFG_t GLB_CFG; /* addr: 0x000000b0 */
	ca_uint32_t rsrvd45[3];
	L3FE_GLB_LF_CFG_t LF_CFG; /* addr: 0x000000b4 */
	ca_uint32_t rsrvd46[3];
	L3FE_GLB_ILPB_01_t ILPB_01; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd47[3];
	L3FE_GLB_ILPB_00_t ILPB_00; /* addr: 0x000000bc */
	ca_uint32_t rsrvd48[27];
	L3FE_GLB_ILPB_LDPID_t ILPB_LDPID; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd49[3];
	L3FE_GLB_ELPB1_t ELPB1; /* addr: 0x000000dc */
	ca_uint32_t rsrvd50[3];
	L3FE_GLB_ELPB0_t ELPB0; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd51[3];
	L3FE_GLB_ELPB_DEEPQ_VLD1_t ELPB_DEEPQ_VLD1; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd52[3];
	L3FE_GLB_ELPB_DEEPQ_VLD0_t ELPB_DEEPQ_VLD0; /* addr: 0x000000e8 */
	ca_uint32_t rsrvd53[3];
	L3FE_GLB_ELPB_DEEPQ1_t ELPB_DEEPQ1; /* addr: 0x000000ec */
	ca_uint32_t rsrvd54[3];
	L3FE_GLB_ELPB_DEEPQ0_t ELPB_DEEPQ0; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd55[3];
	L3FE_GLB_L3FE_L2FE_LDPID_t L3FE_L2FE_LDPID; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd56[3];
	L3FE_GLB_VE_t VE; /* addr: 0x000000f8 */
	ca_uint32_t rsrvd57[3];
	L3FE_GLB_T5_OPTION_t T5_OPTION; /* addr: 0x000000fc */
	ca_uint32_t rsrvd58[3];
	L3FE_GLB_T5_TO_CPU_t T5_TO_CPU; /* addr: 0x00000100 */
	ca_uint32_t rsrvd59[3];
	L3FE_GLB_TE_OPTION_t TE_OPTION; /* addr: 0x00000104 */
	ca_uint32_t rsrvd60[3];
	L3FE_GLB_CLS_STG_MONITOR_CTRL_t CLS_STG_MONITOR_CTRL; /* addr: 0x00000108 */
	ca_uint32_t rsrvd61[3];
	L3FE_GLB_CLS_STG_MONITOR_RETURN_t
	  CLS_STG_MONITOR_RETURN; /* addr: 0x0000010c */
	ca_uint32_t rsrvd62[3];
	L3FE_GLB_DBG_IDX_t DBG_IDX; /* addr: 0x00000110 */
	ca_uint32_t rsrvd63[3];
	L3FE_GLB_DBG_DAT_t DBG_DAT; /* addr: 0x00000114 */
	ca_uint32_t rsrvd64[3];
	L3FE_GLB_L3FE_MONITOR_TRIG_t L3FE_MONITOR_TRIG; /* addr: 0x00000118 */
	ca_uint32_t rsrvd65[3];
	L3FE_GLB_L3FE_MONITOR_CTRL_t L3FE_MONITOR_CTRL; /* addr: 0x0000011c */
	ca_uint32_t rsrvd66[3];
	L3FE_GLB_L3FE_MONITOR_RETURN_t L3FE_MONITOR_RETURN; /* addr: 0x00000120 */
	ca_uint32_t rsrvd67[3];
	L3FE_GLB_RES_CTRL_t RES_CTRL; /* addr: 0x00000124 */
	ca_uint32_t rsrvd68[3];
	L3FE_GLB_SRAM_TEST_WRAP_l3fe_nhop1_t
	  SRAM_TEST_WRAP_l3fe_nhop1; /* addr: 0x00000128 */
	ca_uint32_t rsrvd69[3];
	L3FE_GLB_SRAM_TEST_WRAP_l3fe_nhop2_t
	  SRAM_TEST_WRAP_l3fe_nhop2; /* addr: 0x0000012c */
	ca_uint32_t rsrvd70[3];
	L3FE_GLB_SRAM_TEST_WRAP_l3fe_lpm1_t
	  SRAM_TEST_WRAP_l3fe_lpm1; /* addr: 0x00000130 */
	ca_uint32_t rsrvd71[3];
	L3FE_GLB_SRAM_TEST_WRAP_l3fe_nat1_t
	  SRAM_TEST_WRAP_l3fe_nat1; /* addr: 0x00000134 */
	ca_uint32_t rsrvd72[3];
	L3FE_GLB_SRAM_TEST_WRAP_l3fe_nat0_t
	  SRAM_TEST_WRAP_l3fe_nat0; /* addr: 0x00000138 */
	ca_uint32_t rsrvd73[3];
	L3FE_GLB_SRAM_TEST_CONTROL_0_t SRAM_TEST_CONTROL_0; /* addr: 0x0000013c */
	ca_uint32_t rsrvd74[3];
	L3FE_GLB_SRAM_TEST_CONTROL_1_t SRAM_TEST_CONTROL_1; /* addr: 0x00000140 */
	ca_uint32_t rsrvd75[3];
	L3FE_GLB_SRAM_TEST_CONTROL_2_t SRAM_TEST_CONTROL_2; /* addr: 0x00000144 */
	ca_uint32_t rsrvd76[3];
	L3FE_GLB_SRAM_TEST_CONTROL_3_t SRAM_TEST_CONTROL_3; /* addr: 0x00000148 */
	ca_uint32_t rsrvd77[3];
	L3FE_GLB_SRAM_TEST_CONTROL_4_t SRAM_TEST_CONTROL_4; /* addr: 0x0000014c */
	ca_uint32_t rsrvd78[3];
	L3FE_GLB_SRAM_LS_CONTROL_0_t SRAM_LS_CONTROL_0; /* addr: 0x00000150 */
	ca_uint32_t rsrvd79[3];
	L3FE_GLB_SRAM_LS_CONTROL_1_t SRAM_LS_CONTROL_1; /* addr: 0x00000154 */
	ca_uint32_t rsrvd80[3];
	L3FE_GLB_SRAM_LS_CONTROL_2_t SRAM_LS_CONTROL_2; /* addr: 0x00000158 */
	ca_uint32_t rsrvd81[3];
	L3FE_GLB_SRAM_LS_CONTROL_3_t SRAM_LS_CONTROL_3; /* addr: 0x0000015c */
} APB0_L3FE_GLB_t;
#endif /* !__ASSEMBLER__ */

/*
 * PP
 */

#define L3FE_PP_FIELD_CAM_ACCESS 0xf4303200
#define L3FE_PP_FIELD_CAM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 20; /* bits 19:0 */
		ca_uint32_t rsrvd1 : 10;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_FIELD_CAM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_FIELD_CAM_DATA4 0xf4303204
#define L3FE_PP_FIELD_CAM_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_FIELD_CAM_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_FIELD_CAM_DATA3 0xf4303208
#define L3FE_PP_FIELD_CAM_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_FIELD_CAM_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_FIELD_CAM_DATA2 0xf430320c
#define L3FE_PP_FIELD_CAM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_FIELD_CAM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_FIELD_CAM_DATA1 0xf4303210
#define L3FE_PP_FIELD_CAM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_FIELD_CAM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_FIELD_CAM_DATA0 0xf4303214
#define L3FE_PP_FIELD_CAM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_FIELD_CAM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_SPCL_PKT_DETECTION_CFG 0xf4303218
#define L3FE_PP_SPCL_PKT_DETECTION_CFG_dft 0x0739dc24

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t check_arp_target_ip : 1; /* bits 0:0 */
		ca_uint32_t mpcp_opcode_en : 1; /* bits 1:1 */
		ca_uint32_t my_mac_enable : 1; /* bits 2:2 */
		ca_uint32_t type_0_en : 1; /* bits 3:3 */
		ca_uint32_t type_1_en : 1; /* bits 4:4 */
		ca_uint32_t udp_lite_enable : 1; /* bits 5:5 */
		ca_uint32_t user_def_spcl_0_en : 1; /* bits 6:6 */
		ca_uint32_t user_def_spcl_1_en : 1; /* bits 7:7 */
		ca_uint32_t user_def_spcl_2_en : 1; /* bits 8:8 */
		ca_uint32_t user_def_spcl_3_en : 1; /* bits 9:9 */
		ca_uint32_t l2_spcl_hdr_en : 1; /* bits 10:10 */
		ca_uint32_t l3_spcl_hdr_en : 1; /* bits 11:11 */
		ca_uint32_t l4_spcl_hdr_en : 1; /* bits 12:12 */
		ca_uint32_t user_define_hi_pri : 1; /* bits 13:13 */
		ca_uint32_t rdp_v1_detection_en : 1; /* bits 14:14 */
		ca_uint32_t ipv4_chksum_chk_enable : 1; /* bits 15:15 */
		ca_uint32_t l4_chksum_chk_enable : 1; /* bits 16:16 */
		ca_uint32_t l4_chksum_rh_chk_enable : 1; /* bits 17:17 */
		ca_uint32_t chksum_err_drop : 6; /* bits 23:18 */
		ca_uint32_t bpdu_mac_08_en : 1; /* bits 24:24 */
		ca_uint32_t subtype_en : 1; /* bits 25:25 */
		ca_uint32_t rdp_l4_msgs_det_en : 1; /* bits 26:26 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t drop_udp_ov_ip6_cs_zero_en : 1; /* bits 28:28 */
		ca_uint32_t ni2fe_pkt_cnt_wrap_en : 1; /* bits 29:29 */
		ca_uint32_t use_mdata_high_6bits_as_spcl_enc : 1; /* bits 30:30 */
		ca_uint32_t arp_ipv6_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_SPCL_PKT_DETECTION_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_IPNIP_SPCL_PKT_DET_EN 0xf430321c
#define L3FE_PP_IPNIP_SPCL_PKT_DET_EN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dhcpv4 : 1; /* bits 0:0 */
		ca_uint32_t dhcpv6 : 1; /* bits 1:1 */
		ca_uint32_t l4ptp : 1; /* bits 2:2 */
		ca_uint32_t dns : 1; /* bits 3:3 */
		ca_uint32_t rip : 1; /* bits 4:4 */
		ca_uint32_t ssdp : 1; /* bits 5:5 */
		ca_uint32_t l4_msgs : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_OFFSET_HDR 0xf4303220
#define L3FE_PP_OFFSET_HDR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t offset : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t l3_prog_offset : 9; /* bits 24:16 */
		ca_uint32_t rsrvd2 : 7;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_OFFSET_HDR_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_L7_PROG_OFFSET_HDR_0 0xf4303224
#define L3FE_PP_L7_PROG_OFFSET_HDR_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l7_prog_offset : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_L7_PROG_OFFSET_HDR_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_L7_PROG_OFFSET_HDR_1 0xf4303228
#define L3FE_PP_L7_PROG_OFFSET_HDR_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l7_prog_offset : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_L7_PROG_OFFSET_HDR_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_L7_PROG_OFFSET_HDR_2 0xf430322c
#define L3FE_PP_L7_PROG_OFFSET_HDR_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l7_prog_offset : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_L7_PROG_OFFSET_HDR_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_L7_PROG_OFFSET_HDR_3 0xf4303230
#define L3FE_PP_L7_PROG_OFFSET_HDR_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l7_prog_offset : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_L7_PROG_OFFSET_HDR_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_PARSING_LMT 0xf4303234
#define L3FE_PP_PARSING_LMT_dft 0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t offset : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_PARSING_LMT_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_PARSING_STTS_0 0xf4303238
#define L3FE_PP_PARSING_STTS_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t parsing_err : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_PARSING_STTS_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_PARSING_STTS_1 0xf430323c
#define L3FE_PP_PARSING_STTS_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t parsing_err : 20; /* bits 19:0 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_PARSING_STTS_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_PARSING_ERR_FWD_0 0xf4303240
#define L3FE_PP_PARSING_ERR_FWD_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 10;
		ca_uint32_t ipv4_hdr_cs_err : 2; /* bits 11:10 */
		ca_uint32_t pkt_l2_size_err : 2; /* bits 13:12 */
		ca_uint32_t pkt_l3_total_len_err : 2; /* bits 15:14 */
		ca_uint32_t ip_hdr_err : 2; /* bits 17:16 */
		ca_uint32_t ipv4_total_len_err : 2; /* bits 19:18 */
		ca_uint32_t tcp_data_offset_err : 2; /* bits 21:20 */
		ca_uint32_t udp_total_len_err : 2; /* bits 23:22 */
		ca_uint32_t udp_lite_cs_cvrg_err : 2; /* bits 25:24 */
		ca_uint32_t rdp_hdr_len_err : 2; /* bits 27:26 */
		ca_uint32_t offset_l3_excd_255_err : 2; /* bits 29:28 */
		ca_uint32_t offset_l4_excd_255_err : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_PARSING_ERR_FWD_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_PARSING_ERR_FWD_1 0xf4303244
#define L3FE_PP_PARSING_ERR_FWD_1_dft 0x00005000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_inner_ip_hdr_cs_err : 2; /* bits 1:0 */
		ca_uint32_t pkt_inner_l3_total_len_err : 2; /* bits 3:2 */
		ca_uint32_t inner_ip_hdr_err : 2; /* bits 5:4 */
		ca_uint32_t dsl_inner_ipv4_total_len_err : 2; /* bits 7:6 */
		ca_uint32_t offset_l3_inner_excd_255_err : 2; /* bits 9:8 */
		ca_uint32_t udp_zero_chksum_err : 2; /* bits 11:10 */
		ca_uint32_t more_than_2_vlan_tags_flg : 2; /* bits 13:12 */
		ca_uint32_t l2tp_hdr_err : 2; /* bits 15:14 */
		ca_uint32_t rdp_ver_err : 2; /* bits 17:16 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t parsing_err_trap_pol_id : 9; /* bits 27:19 */
		ca_uint32_t parsing_err_trap_pol_grp_id : 3; /* bits 30:28 */
		ca_uint32_t parsing_err_trap_pol_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_PARSING_ERR_FWD_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_PARSING_ERR_TRAP 0xf4303248
#define L3FE_PP_PARSING_ERR_TRAP_dft 0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdir_ldpid : 6; /* bits 5:0 */
		ca_uint32_t rdir_cos : 3; /* bits 8:6 */
		ca_uint32_t keep_orig_pkt : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t t0_ctrl : 1; /* bits 11:11 */
		ca_uint32_t t1_ctrl : 4; /* bits 15:12 */
		ca_uint32_t t2_ctrl : 4; /* bits 19:16 */
		ca_uint32_t t3_ctrl : 4; /* bits 23:20 */
		ca_uint32_t t4_ctrl : 4; /* bits 27:24 */
		ca_uint32_t t5_ctrl : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_PARSING_ERR_TRAP_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_PARSING_OVER_VLAN_FWD_CTL 0xf430324c
#define L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_dft 0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdir_ldpid : 6; /* bits 5:0 */
		ca_uint32_t rdir_cos : 3; /* bits 8:6 */
		ca_uint32_t keep_orig_pkt : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t t0_ctrl : 1; /* bits 11:11 */
		ca_uint32_t t1_ctrl : 4; /* bits 15:12 */
		ca_uint32_t t2_ctrl : 4; /* bits 19:16 */
		ca_uint32_t t3_ctrl : 4; /* bits 23:20 */
		ca_uint32_t t4_ctrl : 4; /* bits 27:24 */
		ca_uint32_t t5_ctrl : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_TYPE_0 0xf4303250
#define L3FE_PP_USER_TYPE_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_type_0 : 16; /* bits 15:0 */
		ca_uint32_t user_type_1 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_TYPE_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_TYPE_1 0xf4303254
#define L3FE_PP_USER_TYPE_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_type_2 : 16; /* bits 15:0 */
		ca_uint32_t user_type_3 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_TYPE_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_MAC_0_LOW 0xf4303258
#define L3FE_PP_USER_MAC_0_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_mac_0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_MAC_0_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_MAC_0_HI 0xf430325c
#define L3FE_PP_USER_MAC_0_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_mac_0 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_MAC_0_HI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_MAC_1_LOW 0xf4303260
#define L3FE_PP_USER_MAC_1_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_mac_1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_MAC_1_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_MAC_1_HI 0xf4303264
#define L3FE_PP_USER_MAC_1_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_mac_1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_MAC_1_HI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_MAC_0_MASK_LOW 0xf4303268
#define L3FE_PP_USER_MAC_0_MASK_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_mac_mask_0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_MAC_0_MASK_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_MAC_0_MASK_HI 0xf430326c
#define L3FE_PP_USER_MAC_0_MASK_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_mac_mask_0 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_MAC_0_MASK_HI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_MAC_1_MASK_LOW 0xf4303270
#define L3FE_PP_USER_MAC_1_MASK_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_mac_mask_1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_MAC_1_MASK_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_USER_MAC_1_MASK_HI 0xf4303274
#define L3FE_PP_USER_MAC_1_MASK_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user_mac_mask_1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_USER_MAC_1_MASK_HI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_TPID_0 0xf4303278
#define L3FE_PP_TPID_0_dft 0x88a88100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid_0 : 16; /* bits 15:0 */
		ca_uint32_t tpid_1 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_TPID_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_TPID_1 0xf430327c
#define L3FE_PP_TPID_1_dft 0x92009100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpid_2 : 16; /* bits 15:0 */
		ca_uint32_t tpid_3 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_TPID_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_TPID_CTRL 0xf4303280
#define L3FE_PP_TPID_CTRL_dft 0x00000077

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t top_vlan_en : 4; /* bits 3:0 */
		ca_uint32_t inner_vlan_en : 4; /* bits 7:4 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_TPID_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_ARP_TARGET_IP 0xf4303284
#define L3FE_PP_ARP_TARGET_IP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t target_ip : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_ARP_TARGET_IP_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_OAM 0xf4303288
#define L3FE_PP_OAM_dft 0x00000803

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t subtype : 8; /* bits 7:0 */
		ca_uint32_t mymdlvl : 3; /* bits 10:8 */
		ca_uint32_t mymdlvl_det_en : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_OAM_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HELLO_MAC_LOW 0xf430328c
#define L3FE_PP_HELLO_MAC_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HELLO_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HELLO_MAC_HI 0xf4303290
#define L3FE_PP_HELLO_MAC_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HELLO_MAC_HI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_MY_MAC_LOW 0xf4303294
#define L3FE_PP_MY_MAC_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mymac : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_MY_MAC_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_MY_MAC_HI 0xf4303298
#define L3FE_PP_MY_MAC_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mymac : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_MY_MAC_HI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_MC_MAC_HI_RNG 0xf430329c
#define L3FE_PP_MC_MAC_HI_RNG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hi_rng_mac_low : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_MC_MAC_HI_RNG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_MC_MAC_LOW_RNG 0xf43032a0
#define L3FE_PP_MC_MAC_LOW_RNG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t low_rng_mac_low : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_MC_MAC_LOW_RNG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_MC_MAC_RNG 0xf43032a4
#define L3FE_PP_MC_MAC_RNG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t low_rng_mac_hi : 16; /* bits 15:0 */
		ca_uint32_t hi_rng_mac_hi : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_MC_MAC_RNG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HTTP_LINK_0 0xf43032a8
#define L3FE_PP_HTTP_LINK_0_dft 0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rule_l4_pid : 16; /* bits 15:0 */
		ca_uint32_t rule_l4_pid_sel : 1; /* bits 16:16 */
		ca_uint32_t rule_l4_type : 3; /* bits 19:17 */
		ca_uint32_t rule_lspid : 6; /* bits 25:20 */
		ca_uint32_t rule_lspid_msk : 1; /* bits 26:26 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rule_vld : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HTTP_LINK_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HTTP_LINK_1 0xf43032ac
#define L3FE_PP_HTTP_LINK_1_dft 0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rule_l4_pid : 16; /* bits 15:0 */
		ca_uint32_t rule_l4_pid_sel : 1; /* bits 16:16 */
		ca_uint32_t rule_l4_type : 3; /* bits 19:17 */
		ca_uint32_t rule_lspid : 6; /* bits 25:20 */
		ca_uint32_t rule_lspid_msk : 1; /* bits 26:26 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rule_vld : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HTTP_LINK_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HTTP_LINK_2 0xf43032b0
#define L3FE_PP_HTTP_LINK_2_dft 0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rule_l4_pid : 16; /* bits 15:0 */
		ca_uint32_t rule_l4_pid_sel : 1; /* bits 16:16 */
		ca_uint32_t rule_l4_type : 3; /* bits 19:17 */
		ca_uint32_t rule_lspid : 6; /* bits 25:20 */
		ca_uint32_t rule_lspid_msk : 1; /* bits 26:26 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rule_vld : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HTTP_LINK_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HTTP_LINK_3 0xf43032b4
#define L3FE_PP_HTTP_LINK_3_dft 0x04000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rule_l4_pid : 16; /* bits 15:0 */
		ca_uint32_t rule_l4_pid_sel : 1; /* bits 16:16 */
		ca_uint32_t rule_l4_type : 3; /* bits 19:17 */
		ca_uint32_t rule_lspid : 6; /* bits 25:20 */
		ca_uint32_t rule_lspid_msk : 1; /* bits 26:26 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t rule_vld : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HTTP_LINK_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_PINGPONG_STS 0xf43032b8
#define L3FE_PP_PINGPONG_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ovfl : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_PINGPONG_STS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_NI_INTF_ERR_STTS_0 0xf43032bc
#define L3FE_PP_NI_INTF_ERR_STTS_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sop_eop_mismatch : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_NI_INTF_ERR_STTS_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_NI_INTF_ERR_STTS_1 0xf43032c0
#define L3FE_PP_NI_INTF_ERR_STTS_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t runt_l2_pkt : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_NI_INTF_ERR_STTS_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_NI_INTF_STS 0xf43032c4
#define L3FE_PP_NI_INTF_STS_dft 0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdy : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_NI_INTF_STS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_NI_INTF_PKT_CNT 0xf43032c8
#define L3FE_PP_NI_INTF_PKT_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t eop : 16; /* bits 15:0 */
		ca_uint32_t sop : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_NI_INTF_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_L4_CS_ERR 0xf43032cc
#define L3FE_PP_L4_CS_ERR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_L4_CS_ERR_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HEADER_A_LOW 0xf43032d0
#define L3FE_PP_HEADER_A_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HEADER_A_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HEADER_A_HI 0xf43032d4
#define L3FE_PP_HEADER_A_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HEADER_A_HI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HEADER_CPU_LOW 0xf43032d8
#define L3FE_PP_HEADER_CPU_LOW_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HEADER_CPU_LOW_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_HEADER_CPU_HI 0xf43032dc
#define L3FE_PP_HEADER_CPU_HI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t header : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_HEADER_CPU_HI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_NI2FE_INTF_FF_STS 0xf43032e0
#define L3FE_PP_NI2FE_INTF_FF_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ovfl : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_NI2FE_INTF_FF_STS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_ARP_FILTER_MSK 0xf43032e4
#define L3FE_PP_ARP_FILTER_MSK_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t en : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_ARP_FILTER_MSK_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_0 0xf43032e8
#define L3FE_PP_DOS_ATK_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_1 0xf43032ec
#define L3FE_PP_DOS_ATK_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_2 0xf43032f0
#define L3FE_PP_DOS_ATK_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_3 0xf43032f4
#define L3FE_PP_DOS_ATK_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_4 0xf43032f8
#define L3FE_PP_DOS_ATK_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_5 0xf43032fc
#define L3FE_PP_DOS_ATK_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_6 0xf4303300
#define L3FE_PP_DOS_ATK_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_7 0xf4303304
#define L3FE_PP_DOS_ATK_7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_8 0xf4303308
#define L3FE_PP_DOS_ATK_8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_8_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_FLOOD_CNT 0xf430330c
#define L3FE_PP_DOS_ATK_FLOOD_CNT_dft 0x0000029a

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_FLOOD_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_EVENT_TRAP 0xf4303310
#define L3FE_PP_DOS_ATK_EVENT_TRAP_dft 0xfffffa10

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdir_ldpid : 6; /* bits 5:0 */
		ca_uint32_t rdir_cos : 3; /* bits 8:6 */
		ca_uint32_t keep_orig_pkt : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t t0_ctrl : 1; /* bits 11:11 */
		ca_uint32_t t1_ctrl : 4; /* bits 15:12 */
		ca_uint32_t t2_ctrl : 4; /* bits 19:16 */
		ca_uint32_t t3_ctrl : 4; /* bits 23:20 */
		ca_uint32_t t4_ctrl : 4; /* bits 27:24 */
		ca_uint32_t t5_ctrl : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_EVENT_TRAP_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_DOS_ATK_EVENT_DROP 0xf4303314
#define L3FE_PP_DOS_ATK_EVENT_DROP_dft 0xfffffa1f

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdir_ldpid : 6; /* bits 5:0 */
		ca_uint32_t rdir_cos : 3; /* bits 8:6 */
		ca_uint32_t keep_orig_pkt : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t t0_ctrl : 1; /* bits 11:11 */
		ca_uint32_t t1_ctrl : 4; /* bits 15:12 */
		ca_uint32_t t2_ctrl : 4; /* bits 19:16 */
		ca_uint32_t t3_ctrl : 4; /* bits 23:20 */
		ca_uint32_t t4_ctrl : 4; /* bits 27:24 */
		ca_uint32_t t5_ctrl : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_DOS_ATK_EVENT_DROP_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_SPKTP_ACCESS 0xf4303318
#define L3FE_PP_SPKTP_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_SPKTP_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PP_SPKTP_DATA 0xf430331c
#define L3FE_PP_SPKTP_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t encode : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_PP_SPKTP_DATA_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PP */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_PP_FIELD_CAM_ACCESS_t FIELD_CAM_ACCESS; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_PP_FIELD_CAM_DATA4_t FIELD_CAM_DATA4; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_PP_FIELD_CAM_DATA3_t FIELD_CAM_DATA3; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_PP_FIELD_CAM_DATA2_t FIELD_CAM_DATA2; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L3FE_PP_FIELD_CAM_DATA1_t FIELD_CAM_DATA1; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L3FE_PP_FIELD_CAM_DATA0_t FIELD_CAM_DATA0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L3FE_PP_SPCL_PKT_DETECTION_CFG_t
	  SPCL_PKT_DETECTION_CFG; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t IPNIP_SPCL_PKT_DET_EN; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L3FE_PP_OFFSET_HDR_t OFFSET_HDR; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L3FE_PP_L7_PROG_OFFSET_HDR_0_t L7_PROG_OFFSET_HDR_0; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L3FE_PP_L7_PROG_OFFSET_HDR_1_t L7_PROG_OFFSET_HDR_1; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L3FE_PP_L7_PROG_OFFSET_HDR_2_t L7_PROG_OFFSET_HDR_2; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L3FE_PP_L7_PROG_OFFSET_HDR_3_t L7_PROG_OFFSET_HDR_3; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L3FE_PP_PARSING_LMT_t PARSING_LMT; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L3FE_PP_PARSING_STTS_0_t PARSING_STTS_0; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L3FE_PP_PARSING_STTS_1_t PARSING_STTS_1; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L3FE_PP_PARSING_ERR_FWD_0_t PARSING_ERR_FWD_0; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L3FE_PP_PARSING_ERR_FWD_1_t PARSING_ERR_FWD_1; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L3FE_PP_PARSING_ERR_TRAP_t PARSING_ERR_TRAP; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t
	  PARSING_OVER_VLAN_FWD_CTL; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L3FE_PP_USER_TYPE_0_t USER_TYPE_0; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L3FE_PP_USER_TYPE_1_t USER_TYPE_1; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L3FE_PP_USER_MAC_0_LOW_t USER_MAC_0_LOW; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L3FE_PP_USER_MAC_0_HI_t USER_MAC_0_HI; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L3FE_PP_USER_MAC_1_LOW_t USER_MAC_1_LOW; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L3FE_PP_USER_MAC_1_HI_t USER_MAC_1_HI; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L3FE_PP_USER_MAC_0_MASK_LOW_t USER_MAC_0_MASK_LOW; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L3FE_PP_USER_MAC_0_MASK_HI_t USER_MAC_0_MASK_HI; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L3FE_PP_USER_MAC_1_MASK_LOW_t USER_MAC_1_MASK_LOW; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L3FE_PP_USER_MAC_1_MASK_HI_t USER_MAC_1_MASK_HI; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L3FE_PP_TPID_0_t TPID_0; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L3FE_PP_TPID_1_t TPID_1; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L3FE_PP_TPID_CTRL_t TPID_CTRL; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L3FE_PP_ARP_TARGET_IP_t ARP_TARGET_IP; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L3FE_PP_OAM_t OAM; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L3FE_PP_HELLO_MAC_LOW_t HELLO_MAC_LOW; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	L3FE_PP_HELLO_MAC_HI_t HELLO_MAC_HI; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	L3FE_PP_MY_MAC_LOW_t MY_MAC_LOW; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	L3FE_PP_MY_MAC_HI_t MY_MAC_HI; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	L3FE_PP_MC_MAC_HI_RNG_t MC_MAC_HI_RNG; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	L3FE_PP_MC_MAC_LOW_RNG_t MC_MAC_LOW_RNG; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	L3FE_PP_MC_MAC_RNG_t MC_MAC_RNG; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	L3FE_PP_HTTP_LINK_0_t HTTP_LINK_0; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd43[3];
	L3FE_PP_HTTP_LINK_1_t HTTP_LINK_1; /* addr: 0x000000ac */
	ca_uint32_t rsrvd44[3];
	L3FE_PP_HTTP_LINK_2_t HTTP_LINK_2; /* addr: 0x000000b0 */
	ca_uint32_t rsrvd45[3];
	L3FE_PP_HTTP_LINK_3_t HTTP_LINK_3; /* addr: 0x000000b4 */
	ca_uint32_t rsrvd46[3];
	L3FE_PP_PINGPONG_STS_t PINGPONG_STS; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd47[3];
	L3FE_PP_NI_INTF_ERR_STTS_0_t NI_INTF_ERR_STTS_0; /* addr: 0x000000bc */
	ca_uint32_t rsrvd48[3];
	L3FE_PP_NI_INTF_ERR_STTS_1_t NI_INTF_ERR_STTS_1; /* addr: 0x000000c0 */
	ca_uint32_t rsrvd49[3];
	L3FE_PP_NI_INTF_STS_t NI_INTF_STS; /* addr: 0x000000c4 */
	ca_uint32_t rsrvd50[3];
	L3FE_PP_NI_INTF_PKT_CNT_t NI_INTF_PKT_CNT; /* addr: 0x000000c8 */
	ca_uint32_t rsrvd51[3];
	L3FE_PP_L4_CS_ERR_t L4_CS_ERR; /* addr: 0x000000cc */
	ca_uint32_t rsrvd52[3];
	L3FE_PP_HEADER_A_LOW_t HEADER_A_LOW; /* addr: 0x000000d0 */
	ca_uint32_t rsrvd53[3];
	L3FE_PP_HEADER_A_HI_t HEADER_A_HI; /* addr: 0x000000d4 */
	ca_uint32_t rsrvd54[3];
	L3FE_PP_HEADER_CPU_LOW_t HEADER_CPU_LOW; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd55[3];
	L3FE_PP_HEADER_CPU_HI_t HEADER_CPU_HI; /* addr: 0x000000dc */
	ca_uint32_t rsrvd56[3];
	L3FE_PP_NI2FE_INTF_FF_STS_t NI2FE_INTF_FF_STS; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd57[3];
	L3FE_PP_ARP_FILTER_MSK_t ARP_FILTER_MSK; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd58[3];
	L3FE_PP_DOS_ATK_0_t DOS_ATK_0; /* addr: 0x000000e8 */
	ca_uint32_t rsrvd59[3];
	L3FE_PP_DOS_ATK_1_t DOS_ATK_1; /* addr: 0x000000ec */
	ca_uint32_t rsrvd60[3];
	L3FE_PP_DOS_ATK_2_t DOS_ATK_2; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd61[3];
	L3FE_PP_DOS_ATK_3_t DOS_ATK_3; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd62[3];
	L3FE_PP_DOS_ATK_4_t DOS_ATK_4; /* addr: 0x000000f8 */
	ca_uint32_t rsrvd63[3];
	L3FE_PP_DOS_ATK_5_t DOS_ATK_5; /* addr: 0x000000fc */
	ca_uint32_t rsrvd64[3];
	L3FE_PP_DOS_ATK_6_t DOS_ATK_6; /* addr: 0x00000100 */
	ca_uint32_t rsrvd65[3];
	L3FE_PP_DOS_ATK_7_t DOS_ATK_7; /* addr: 0x00000104 */
	ca_uint32_t rsrvd66[3];
	L3FE_PP_DOS_ATK_8_t DOS_ATK_8; /* addr: 0x00000108 */
	ca_uint32_t rsrvd67[3];
	L3FE_PP_DOS_ATK_FLOOD_CNT_t DOS_ATK_FLOOD_CNT; /* addr: 0x0000010c */
	ca_uint32_t rsrvd68[3];
	L3FE_PP_DOS_ATK_EVENT_TRAP_t DOS_ATK_EVENT_TRAP; /* addr: 0x00000110 */
	ca_uint32_t rsrvd69[3];
	L3FE_PP_DOS_ATK_EVENT_DROP_t DOS_ATK_EVENT_DROP; /* addr: 0x00000114 */
	ca_uint32_t rsrvd70[3];
	L3FE_PP_SPKTP_ACCESS_t SPKTP_ACCESS; /* addr: 0x00000118 */
	ca_uint32_t rsrvd71[3];
	L3FE_PP_SPKTP_DATA_t SPKTP_DATA; /* addr: 0x0000011c */
} APB0_L3FE_PP_t;
#endif /* !__ASSEMBLER__ */

/*
 * CLS
 */

#define L3FE_CLS_KEY_TBL_ACCESS 0xf4303380
#define L3FE_CLS_KEY_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA10 0xf4303384
#define L3FE_CLS_KEY_TBL_DATA10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 17; /* bits 16:0 */
		ca_uint32_t cl_entry_mode : 1; /* bits 17:17 */
		ca_uint32_t cl_pri : 4; /* bits 21:18 */
		ca_uint32_t cl_rslt_type : 2; /* bits 23:22 */
		ca_uint32_t cl_key_type : 3; /* bits 26:24 */
		ca_uint32_t cl_key_valid : 4; /* bits 30:27 */
		ca_uint32_t rsrvd1 : 1;
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA10_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA9 0xf4303388
#define L3FE_CLS_KEY_TBL_DATA9_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA9_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA8 0xf430338c
#define L3FE_CLS_KEY_TBL_DATA8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA8_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA7 0xf4303390
#define L3FE_CLS_KEY_TBL_DATA7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA6 0xf4303394
#define L3FE_CLS_KEY_TBL_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA5 0xf4303398
#define L3FE_CLS_KEY_TBL_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA4 0xf430339c
#define L3FE_CLS_KEY_TBL_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA3 0xf43033a0
#define L3FE_CLS_KEY_TBL_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA2 0xf43033a4
#define L3FE_CLS_KEY_TBL_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA1 0xf43033a8
#define L3FE_CLS_KEY_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_KEY_TBL_DATA0 0xf43033ac
#define L3FE_CLS_KEY_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_KEY_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_FIB_TBL_ACCESS 0xf43033b0
#define L3FE_CLS_FIB_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_FIB_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_FIB_TBL_DATA6 0xf43033b4
#define L3FE_CLS_FIB_TBL_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 26; /* bits 25:0 */
		ca_uint32_t rsrvd1 : 6;
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_FIB_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_FIB_TBL_DATA5 0xf43033b8
#define L3FE_CLS_FIB_TBL_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_FIB_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_FIB_TBL_DATA4 0xf43033bc
#define L3FE_CLS_FIB_TBL_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_FIB_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_FIB_TBL_DATA3 0xf43033c0
#define L3FE_CLS_FIB_TBL_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_FIB_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_FIB_TBL_DATA2 0xf43033c4
#define L3FE_CLS_FIB_TBL_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_FIB_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_FIB_TBL_DATA1 0xf43033c8
#define L3FE_CLS_FIB_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_FIB_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_CLS_FIB_TBL_DATA0 0xf43033cc
#define L3FE_CLS_FIB_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cl_entry : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_CLS_FIB_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLS */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_CLS_KEY_TBL_ACCESS_t KEY_TBL_ACCESS; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_CLS_KEY_TBL_DATA10_t KEY_TBL_DATA10; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_CLS_KEY_TBL_DATA9_t KEY_TBL_DATA9; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_CLS_KEY_TBL_DATA8_t KEY_TBL_DATA8; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L3FE_CLS_KEY_TBL_DATA7_t KEY_TBL_DATA7; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L3FE_CLS_KEY_TBL_DATA6_t KEY_TBL_DATA6; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L3FE_CLS_KEY_TBL_DATA5_t KEY_TBL_DATA5; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L3FE_CLS_KEY_TBL_DATA4_t KEY_TBL_DATA4; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L3FE_CLS_KEY_TBL_DATA3_t KEY_TBL_DATA3; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L3FE_CLS_KEY_TBL_DATA2_t KEY_TBL_DATA2; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L3FE_CLS_KEY_TBL_DATA1_t KEY_TBL_DATA1; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L3FE_CLS_KEY_TBL_DATA0_t KEY_TBL_DATA0; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L3FE_CLS_FIB_TBL_ACCESS_t FIB_TBL_ACCESS; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L3FE_CLS_FIB_TBL_DATA6_t FIB_TBL_DATA6; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L3FE_CLS_FIB_TBL_DATA5_t FIB_TBL_DATA5; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L3FE_CLS_FIB_TBL_DATA4_t FIB_TBL_DATA4; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L3FE_CLS_FIB_TBL_DATA3_t FIB_TBL_DATA3; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L3FE_CLS_FIB_TBL_DATA2_t FIB_TBL_DATA2; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L3FE_CLS_FIB_TBL_DATA1_t FIB_TBL_DATA1; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L3FE_CLS_FIB_TBL_DATA0_t FIB_TBL_DATA0; /* addr: 0x0000004c */
} APB0_L3FE_CLS_t;
#endif /* !__ASSEMBLER__ */

/*
 * STG0
 */

#define L3FE_STG0_CTRL 0xf4303400
#define L3FE_STG0_CTRL_dft 0x00147c7e

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lpb_idx_mode : 1; /* bits 0:0 */
		ca_uint32_t mac_fltr_fail_pkt_mru_chk_en : 1; /* bits 1:1 */
		ca_uint32_t mru_chk_fail_pkt_l2_lkup_dis : 1; /* bits 2:2 */
		ca_uint32_t other_mac_pkt_keep_lspid_en : 1; /* bits 3:3 */
		ca_uint32_t wan_lspid : 6; /* bits 9:4 */
		ca_uint32_t use_lspid_ovwr_o_lspid : 1; /* bits 10:10 */
		ca_uint32_t spcl_pkt_keep_old : 1; /* bits 11:11 */
		ca_uint32_t wan_lspid_1 : 6; /* bits 17:12 */
		ca_uint32_t msk_my_mac_match_en_for_lspid_upd : 1; /* bits 18:18 */
		ca_uint32_t keep_lspid_unchange : 1; /* bits 19:19 */
		ca_uint32_t my_mac_fail_pkt_bypass_cls : 1; /* bits 20:20 */
		ca_uint32_t chk_mymac_for_lan : 1; /* bits 21:21 */
		ca_uint32_t rsrvd1 : 10;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LDPID_MAP 0xf4303404
#define L3FE_STG0_LDPID_MAP_dft 0x03591807

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rule_0 : 6; /* bits 5:0 */
		ca_uint32_t lpb_idx_0 : 2; /* bits 7:6 */
		ca_uint32_t rule_1 : 6; /* bits 13:8 */
		ca_uint32_t lpb_idx_1 : 2; /* bits 15:14 */
		ca_uint32_t rule_2 : 6; /* bits 21:16 */
		ca_uint32_t lpb_idx_2 : 2; /* bits 23:22 */
		ca_uint32_t lpb_idx_3 : 2; /* bits 25:24 */
		ca_uint32_t rsrvd1 : 6;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LDPID_MAP_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_LOW_0 0xf4303408
#define L3FE_STG0_LPB_TBL_LOW_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_LOW_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_MID_0 0xf430340c
#define L3FE_STG0_LPB_TBL_MID_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_MID_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_HIGH_0 0xf4303410
#define L3FE_STG0_LPB_TBL_HIGH_0_dft 0x18000190

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_HIGH_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_LOW_1 0xf4303414
#define L3FE_STG0_LPB_TBL_LOW_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_LOW_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_MID_1 0xf4303418
#define L3FE_STG0_LPB_TBL_MID_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_MID_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_HIGH_1 0xf430341c
#define L3FE_STG0_LPB_TBL_HIGH_1_dft 0x19000070

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_HIGH_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_LOW_2 0xf4303420
#define L3FE_STG0_LPB_TBL_LOW_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_LOW_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_MID_2 0xf4303424
#define L3FE_STG0_LPB_TBL_MID_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_MID_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_HIGH_2 0xf4303428
#define L3FE_STG0_LPB_TBL_HIGH_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_HIGH_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_LOW_3 0xf430342c
#define L3FE_STG0_LPB_TBL_LOW_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_LOW_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_MID_3 0xf4303430
#define L3FE_STG0_LPB_TBL_MID_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_MID_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_TBL_HIGH_3 0xf4303434
#define L3FE_STG0_LPB_TBL_HIGH_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_TBL_HIGH_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_IDX_TBL_ACCESS 0xf4303438
#define L3FE_STG0_LPB_IDX_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_IDX_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_LPB_IDX_TBL_DATA 0xf430343c
#define L3FE_STG0_LPB_IDX_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t idx : 2; /* bits 1:0 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_LPB_IDX_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_SPB_TBL_ACCESS 0xf4303440
#define L3FE_STG0_SPB_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_SPB_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG0_SPB_TBL_DATA 0xf4303444
#define L3FE_STG0_SPB_TBL_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 28; /* bits 27:0 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG0_SPB_TBL_DATA_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* STG0 */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_STG0_CTRL_t CTRL; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_STG0_LDPID_MAP_t LDPID_MAP; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_STG0_LPB_TBL_LOW_0_t LPB_TBL_LOW_0; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_STG0_LPB_TBL_MID_0_t LPB_TBL_MID_0; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L3FE_STG0_LPB_TBL_HIGH_0_t LPB_TBL_HIGH_0; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L3FE_STG0_LPB_TBL_LOW_1_t LPB_TBL_LOW_1; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L3FE_STG0_LPB_TBL_MID_1_t LPB_TBL_MID_1; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L3FE_STG0_LPB_TBL_HIGH_1_t LPB_TBL_HIGH_1; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L3FE_STG0_LPB_TBL_LOW_2_t LPB_TBL_LOW_2; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L3FE_STG0_LPB_TBL_MID_2_t LPB_TBL_MID_2; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L3FE_STG0_LPB_TBL_HIGH_2_t LPB_TBL_HIGH_2; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L3FE_STG0_LPB_TBL_LOW_3_t LPB_TBL_LOW_3; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L3FE_STG0_LPB_TBL_MID_3_t LPB_TBL_MID_3; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L3FE_STG0_LPB_TBL_HIGH_3_t LPB_TBL_HIGH_3; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L3FE_STG0_LPB_IDX_TBL_ACCESS_t LPB_IDX_TBL_ACCESS; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L3FE_STG0_LPB_IDX_TBL_DATA_t LPB_IDX_TBL_DATA; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L3FE_STG0_SPB_TBL_ACCESS_t SPB_TBL_ACCESS; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L3FE_STG0_SPB_TBL_DATA_t SPB_TBL_DATA; /* addr: 0x00000044 */
} APB0_L3FE_STG0_t;
#endif /* !__ASSEMBLER__ */

/*
 * STG1
 */

#define L3FE_STG1_IPNIP_CTRL_REG 0xf4303480
#define L3FE_STG1_IPNIP_CTRL_REG_dft 0x0f010e00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sixrd_ecn_keep_outer : 1; /* bits 0:0 */
		ca_uint32_t sixrd_dscp_keep_outer : 1; /* bits 1:1 */
		ca_uint32_t sixrd_ttl_keep_outer : 1; /* bits 2:2 */
		ca_uint32_t dsl_ecn_keep_outer : 1; /* bits 3:3 */
		ca_uint32_t dsl_dscp_keep_outer : 1; /* bits 4:4 */
		ca_uint32_t dsl_ttl_keep_outer : 1; /* bits 5:5 */
		ca_uint32_t dsl_rpf_chk_en : 1; /* bits 6:6 */
		ca_uint32_t dsl_ipmc_addr_consistency_chk_en : 1; /* bits 7:7 */
		ca_uint32_t dsl_ipmc_addr_prfx_chk_en : 1; /* bits 8:8 */
		ca_uint32_t dsl_ipmc_ext_det_en : 1; /* bits 9:9 */
		ca_uint32_t dsl_ipmc_ilg_chk_en : 1; /* bits 10:10 */
		ca_uint32_t sixrd_ipmc_ilg_chk_en : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t ecn_chk_fail_fwd_ctl : 1; /* bits 16:16 */
		ca_uint32_t intf_chk_fail_fwd_ctl : 2; /* bits 18:17 */
		ca_uint32_t sixrd_decap_chk_fail_fwd_ctl : 2; /* bits 20:19 */
		ca_uint32_t dsl_decap_chk_fail_fwd_ctl : 2; /* bits 22:21 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t sixrd_ipmc_fwd_ctl : 1; /* bits 24:24 */
		ca_uint32_t dsl_ipmc_fwd_ctl : 1; /* bits 25:25 */
		ca_uint32_t sixrd_ipmc_new_mac_en : 1; /* bits 26:26 */
		ca_uint32_t dsl_ipmc_new_mac_en : 1; /* bits 27:27 */
		ca_uint32_t rsrvd3 : 4;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_IPNIP_CTRL_REG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_ECN_FAIL_FWD_CTRL 0xf4303484
#define L3FE_STG1_ECN_FAIL_FWD_CTRL_dft 0x02f8ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t t2_ctrl : 4; /* bits 3:0 */
		ca_uint32_t t3_ctrl : 4; /* bits 7:4 */
		ca_uint32_t t4_ctrl : 4; /* bits 11:8 */
		ca_uint32_t t5_ctrl : 4; /* bits 15:12 */
		ca_uint32_t cos : 3; /* bits 18:16 */
		ca_uint32_t ldpid : 6; /* bits 24:19 */
		ca_uint32_t keep_orig_pkt : 1; /* bits 25:25 */
		ca_uint32_t rsrvd1 : 6;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_ECN_FAIL_FWD_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_IPNIP_FAIL_FWD_CTRL 0xf4303488
#define L3FE_STG1_IPNIP_FAIL_FWD_CTRL_dft 0x02f8ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t t2_ctrl : 4; /* bits 3:0 */
		ca_uint32_t t3_ctrl : 4; /* bits 7:4 */
		ca_uint32_t t4_ctrl : 4; /* bits 11:8 */
		ca_uint32_t t5_ctrl : 4; /* bits 15:12 */
		ca_uint32_t cos : 3; /* bits 18:16 */
		ca_uint32_t ldpid : 6; /* bits 24:19 */
		ca_uint32_t keep_orig_pkt : 1; /* bits 25:25 */
		ca_uint32_t rsrvd1 : 6;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_IPNIP_FAIL_FWD_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_SIXRD_IPMC_FWD_CTRL 0xf430348c
#define L3FE_STG1_SIXRD_IPMC_FWD_CTRL_dft 0x02c8ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t t2_ctrl : 4; /* bits 3:0 */
		ca_uint32_t t3_ctrl : 4; /* bits 7:4 */
		ca_uint32_t t4_ctrl : 4; /* bits 11:8 */
		ca_uint32_t t5_ctrl : 4; /* bits 15:12 */
		ca_uint32_t cos : 3; /* bits 18:16 */
		ca_uint32_t ldpid : 6; /* bits 24:19 */
		ca_uint32_t keep_orig_pkt : 1; /* bits 25:25 */
		ca_uint32_t rsrvd1 : 6;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_SIXRD_IPMC_FWD_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_DSL_IPMC_FWD_CTRL 0xf4303490
#define L3FE_STG1_DSL_IPMC_FWD_CTRL_dft 0x02c8ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t t2_ctrl : 4; /* bits 3:0 */
		ca_uint32_t t3_ctrl : 4; /* bits 7:4 */
		ca_uint32_t t4_ctrl : 4; /* bits 11:8 */
		ca_uint32_t t5_ctrl : 4; /* bits 15:12 */
		ca_uint32_t cos : 3; /* bits 18:16 */
		ca_uint32_t ldpid : 6; /* bits 24:19 */
		ca_uint32_t keep_orig_pkt : 1; /* bits 25:25 */
		ca_uint32_t rsrvd1 : 6;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_DSL_IPMC_FWD_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_SIXRD_IPMC_NEW_MAC_DA 0xf4303494
#define L3FE_STG1_SIXRD_IPMC_NEW_MAC_DA_dft 0x00003333

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_prfx : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_SIXRD_IPMC_NEW_MAC_DA_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_DSL_IPMC_NEW_MAC_DA 0xf4303498
#define L3FE_STG1_DSL_IPMC_NEW_MAC_DA_dft 0x000200bc

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr_prfx : 25; /* bits 24:0 */
		ca_uint32_t rsrvd1 : 7;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_DSL_IPMC_NEW_MAC_DA_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_INTF_FF_CTL_REG 0xf430349c
#define L3FE_STG1_INTF_FF_CTL_REG_dft 0x00000032

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t low_thr : 4; /* bits 3:0 */
		ca_uint32_t high_thr : 4; /* bits 7:4 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_INTF_FF_CTL_REG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_INTF_FF_STS_REG 0xf43034a0
#define L3FE_STG1_INTF_FF_STS_REG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ovfl_ind : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_INTF_FF_STS_REG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_STG1_INTF_FF_HDR_CNT 0xf43034a4
#define L3FE_STG1_INTF_FF_HDR_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t num : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} L3FE_STG1_INTF_FF_HDR_CNT_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* STG1 */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_STG1_IPNIP_CTRL_REG_t IPNIP_CTRL_REG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_STG1_ECN_FAIL_FWD_CTRL_t ECN_FAIL_FWD_CTRL; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_STG1_IPNIP_FAIL_FWD_CTRL_t IPNIP_FAIL_FWD_CTRL; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_STG1_SIXRD_IPMC_FWD_CTRL_t SIXRD_IPMC_FWD_CTRL; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L3FE_STG1_DSL_IPMC_FWD_CTRL_t DSL_IPMC_FWD_CTRL; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L3FE_STG1_SIXRD_IPMC_NEW_MAC_DA_t
	  SIXRD_IPMC_NEW_MAC_DA; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L3FE_STG1_DSL_IPMC_NEW_MAC_DA_t DSL_IPMC_NEW_MAC_DA; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L3FE_STG1_INTF_FF_CTL_REG_t INTF_FF_CTL_REG; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L3FE_STG1_INTF_FF_STS_REG_t INTF_FF_STS_REG; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L3FE_STG1_INTF_FF_HDR_CNT_t INTF_FF_HDR_CNT; /* addr: 0x00000024 */
} APB0_L3FE_STG1_t;
#endif /* !__ASSEMBLER__ */

/*
 * PE
 */

#define L3FE_PE_PPPOE_CFG 0xf4303500
#define L3FE_PE_PPPOE_CFG_dft 0x00000011

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sess_ver_type : 8; /* bits 7:0 */
		ca_uint32_t pppoe_code : 8; /* bits 15:8 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PPPOE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PPPOE_PROT_CFG 0xf4303504
#define L3FE_PE_PPPOE_PROT_CFG_dft 0x00570021

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ipv4_protocol : 16; /* bits 15:0 */
		ca_uint32_t ipv6_protocol : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PPPOE_PROT_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_MIB_CFG 0xf4303508
#define L3FE_PE_MIB_CFG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t counter_wrap_around : 13; /* bits 12:0 */
		ca_uint32_t rsrvd1 : 19;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_MIB_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DROP_SRC_PKT_CLR 0xf430350c
#define L3FE_PE_DROP_SRC_PKT_CLR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clear : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DROP_SRC_PKT_CLR_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DROP_SRC_BYTE_CLR 0xf4303510
#define L3FE_PE_DROP_SRC_BYTE_CLR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clear : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DROP_SRC_BYTE_CLR_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CLR 0xf4303514
#define L3FE_PE_RX_IFID_CLR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clear : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CLR_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CLR 0xf4303518
#define L3FE_PE_TX_IFID_CLR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clear : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CLR_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PE_CFG 0xf430351c
#define L3FE_PE_PE_CFG_dft 0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t stomp_crc : 1; /* bits 0:0 */
		ca_uint32_t bypass_crc_update : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ignore_tqm_fe_rdy : 1; /* bits 3:3 */
		ca_uint32_t ldpid_base : 6; /* bits 9:4 */
		ca_uint32_t gemid_map : 1; /* bits 10:10 */
		ca_uint32_t rsrvd2 : 21;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_XRD_CLR 0xf4303520
#define L3FE_PE_XRD_CLR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clear : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_XRD_CLR_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_CLR 0xf4303524
#define L3FE_PE_DSL_CLR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clear : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_CLR_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_0 0xf4303528
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_0_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_0 0xf430352c
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_1_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_0 0xf4303530
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_2_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_1 0xf4303534
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_0_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_1 0xf4303538
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_1_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_1 0xf430353c
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_2_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_2 0xf4303540
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_0_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_2 0xf4303544
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_1_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_2 0xf4303548
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_2_2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_3 0xf430354c
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_0_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_3 0xf4303550
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_1_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_3 0xf4303554
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t vct : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_2_3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_MTU_SIZE_0 0xf4303558
#define L3FE_PE_MTU_SIZE_0_dft 0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mtu_0 : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t mtu_1 : 14; /* bits 29:16 */
		ca_uint32_t rsrvd2 : 2;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_MTU_SIZE_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_MTU_SIZE_1 0xf430355c
#define L3FE_PE_MTU_SIZE_1_dft 0x05dc05dc

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mtu_2 : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t mtu_3 : 14; /* bits 29:16 */
		ca_uint32_t rsrvd2 : 2;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_MTU_SIZE_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_6RD_ENCAP_CFG 0xf4303560
#define L3FE_PE_DSL_6RD_ENCAP_CFG_dft 0x00002904

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t nh_dsl_encap : 8; /* bits 7:0 */
		ca_uint32_t prot_6rd_encap : 8; /* bits 15:8 */
		ca_uint32_t df_6rd_encap : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_6RD_ENCAP_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_6RD_ENCAP_TYPE 0xf4303564
#define L3FE_PE_DSL_6RD_ENCAP_TYPE_dft 0x080086dd

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t etype_dsl_encap : 16; /* bits 15:0 */
		ca_uint32_t etype_6rd_encap : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_6RD_ENCAP_TYPE_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_6RD_DECAP_TYPE 0xf4303568
#define L3FE_PE_DSL_6RD_DECAP_TYPE_dft 0x86dd0800

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t etype_dsl_decap : 16; /* bits 15:0 */
		ca_uint32_t etype_6rd_decap : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_6RD_DECAP_TYPE_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_MIRROR_CFG 0xf430356c
#define L3FE_PE_MIRROR_CFG_dft 0x000000ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mirr_fifo_high_threshold : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t mirr_cos : 3; /* bits 18:16 */
		ca_uint32_t mirr_ldpid : 6; /* bits 24:19 */
		ca_uint32_t rsrvd2 : 7;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_MIRROR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_MIRROR_LEN_CFG 0xf4303570
#define L3FE_PE_MIRROR_LEN_CFG_dft 0x00000080

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mirr_len : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_MIRROR_LEN_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_SIXRD_TBL_ACCESS 0xf4303574
#define L3FE_PE_SIXRD_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_SIXRD_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_SIXRD_TBL_DATA6 0xf4303578
#define L3FE_PE_SIXRD_TBL_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t six_rd_ce_v4_ip : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_SIXRD_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_SIXRD_TBL_DATA5 0xf430357c
#define L3FE_PE_SIXRD_TBL_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t six_rd_v4_msk_len : 3; /* bits 2:0 */
		ca_uint32_t six_rd_ce_v4_ip : 29; /* bits 31:3 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_SIXRD_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_SIXRD_TBL_DATA4 0xf4303580
#define L3FE_PE_SIXRD_TBL_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t six_rd_v6_prfx : 22; /* bits 21:0 */
		ca_uint32_t six_rd_v6_prfx_len : 7; /* bits 28:22 */
		ca_uint32_t six_rd_v4_msk_len : 3; /* bits 31:29 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_SIXRD_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_SIXRD_TBL_DATA3 0xf4303584
#define L3FE_PE_SIXRD_TBL_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t six_rd_v6_prfx : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_SIXRD_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_SIXRD_TBL_DATA2 0xf4303588
#define L3FE_PE_SIXRD_TBL_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t six_rd_br_v4_ip : 22; /* bits 21:0 */
		ca_uint32_t six_rd_v6_prfx : 10; /* bits 31:22 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_SIXRD_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_SIXRD_TBL_DATA1 0xf430358c
#define L3FE_PE_SIXRD_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t six_rd_id_start : 4; /* bits 3:0 */
		ca_uint32_t six_rd_ttl_en : 1; /* bits 4:4 */
		ca_uint32_t six_rd_ttl : 8; /* bits 12:5 */
		ca_uint32_t six_rd_tos_en : 1; /* bits 13:13 */
		ca_uint32_t six_rd_tos : 8; /* bits 21:14 */
		ca_uint32_t six_rd_br_v4_ip : 10; /* bits 31:22 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_SIXRD_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_SIXRD_TBL_DATA0 0xf4303590
#define L3FE_PE_SIXRD_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t six_rd_valid : 1; /* bits 0:0 */
		ca_uint32_t six_rd_ingr_chk_en : 1; /* bits 1:1 */
		ca_uint32_t six_rd_br_only : 1; /* bits 2:2 */
		ca_uint32_t six_rd_ipsa_mtch : 1; /* bits 3:3 */
		ca_uint32_t six_rd_id_end : 16; /* bits 19:4 */
		ca_uint32_t six_rd_id_start : 12; /* bits 31:20 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_SIXRD_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_ACCESS 0xf4303594
#define L3FE_PE_DSL_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA9 0xf4303598
#define L3FE_PE_DSL_TBL_DATA9_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_b4_ip : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA9_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA8 0xf430359c
#define L3FE_PE_DSL_TBL_DATA8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_b4_ip : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA8_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA7 0xf43035a0
#define L3FE_PE_DSL_TBL_DATA7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_b4_ip : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA6 0xf43035a4
#define L3FE_PE_DSL_TBL_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_b4_ip : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA5 0xf43035a8
#define L3FE_PE_DSL_TBL_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_aftr_ip : 8; /* bits 7:0 */
		ca_uint32_t dsl_b4_ip : 24; /* bits 31:8 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA4 0xf43035ac
#define L3FE_PE_DSL_TBL_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_aftr_ip : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA3 0xf43035b0
#define L3FE_PE_DSL_TBL_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_aftr_ip : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA2 0xf43035b4
#define L3FE_PE_DSL_TBL_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_aftr_ip : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA1 0xf43035b8
#define L3FE_PE_DSL_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_tc : 8; /* bits 7:0 */
		ca_uint32_t dsl_aftr_ip : 24; /* bits 31:8 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DSL_TBL_DATA0 0xf43035bc
#define L3FE_PE_DSL_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dsl_valid : 1; /* bits 0:0 */
		ca_uint32_t dsl_mc : 1; /* bits 1:1 */
		ca_uint32_t dsl_flwlabel : 20; /* bits 21:2 */
		ca_uint32_t dsl_hoplimit_en : 1; /* bits 22:22 */
		ca_uint32_t dsl_hoplimit : 8; /* bits 30:23 */
		ca_uint32_t dsl_tc_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DSL_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS 0xf43035c0
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1 0xf43035c4
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0 0xf43035c8
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS 0xf43035cc
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 24;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1 0xf43035d0
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0 0xf43035d4
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_ACCESS 0xf43035d8
#define L3FE_PE_RX_IFID_CNT_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_DATA7 0xf43035dc
#define L3FE_PE_RX_IFID_CNT_TBL_DATA7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_DATA7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_DATA6 0xf43035e0
#define L3FE_PE_RX_IFID_CNT_TBL_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_DATA5 0xf43035e4
#define L3FE_PE_RX_IFID_CNT_TBL_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_DATA4 0xf43035e8
#define L3FE_PE_RX_IFID_CNT_TBL_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_DATA3 0xf43035ec
#define L3FE_PE_RX_IFID_CNT_TBL_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_DATA2 0xf43035f0
#define L3FE_PE_RX_IFID_CNT_TBL_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_DATA1 0xf43035f4
#define L3FE_PE_RX_IFID_CNT_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_RX_IFID_CNT_TBL_DATA0 0xf43035f8
#define L3FE_PE_RX_IFID_CNT_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_RX_IFID_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CNT_TBL_ACCESS 0xf43035fc
#define L3FE_PE_TX_IFID_CNT_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CNT_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CNT_TBL_DATA6 0xf4303600
#define L3FE_PE_TX_IFID_CNT_TBL_DATA6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CNT_TBL_DATA6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CNT_TBL_DATA5 0xf4303604
#define L3FE_PE_TX_IFID_CNT_TBL_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CNT_TBL_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CNT_TBL_DATA4 0xf4303608
#define L3FE_PE_TX_IFID_CNT_TBL_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CNT_TBL_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CNT_TBL_DATA3 0xf430360c
#define L3FE_PE_TX_IFID_CNT_TBL_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CNT_TBL_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CNT_TBL_DATA2 0xf4303610
#define L3FE_PE_TX_IFID_CNT_TBL_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CNT_TBL_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CNT_TBL_DATA1 0xf4303614
#define L3FE_PE_TX_IFID_CNT_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CNT_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_PE_TX_IFID_CNT_TBL_DATA0 0xf4303618
#define L3FE_PE_TX_IFID_CNT_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_PE_TX_IFID_CNT_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_PE_PPPOE_CFG_t PPPOE_CFG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_PE_PPPOE_PROT_CFG_t PPPOE_PROT_CFG; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_PE_MIB_CFG_t MIB_CFG; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_PE_DROP_SRC_PKT_CLR_t DROP_SRC_PKT_CLR; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L3FE_PE_DROP_SRC_BYTE_CLR_t DROP_SRC_BYTE_CLR; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L3FE_PE_RX_IFID_CLR_t RX_IFID_CLR; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L3FE_PE_TX_IFID_CLR_t TX_IFID_CLR; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L3FE_PE_PE_CFG_t PE_CFG; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L3FE_PE_XRD_CLR_t XRD_CLR; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L3FE_PE_DSL_CLR_t DSL_CLR; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_0_0_t
	  PORT_EGRESS_BEHAVIOR_0_0; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_1_0_t
	  PORT_EGRESS_BEHAVIOR_1_0; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_2_0_t
	  PORT_EGRESS_BEHAVIOR_2_0; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_0_1_t
	  PORT_EGRESS_BEHAVIOR_0_1; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_1_1_t
	  PORT_EGRESS_BEHAVIOR_1_1; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_2_1_t
	  PORT_EGRESS_BEHAVIOR_2_1; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_0_2_t
	  PORT_EGRESS_BEHAVIOR_0_2; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_1_2_t
	  PORT_EGRESS_BEHAVIOR_1_2; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_2_2_t
	  PORT_EGRESS_BEHAVIOR_2_2; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_0_3_t
	  PORT_EGRESS_BEHAVIOR_0_3; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_1_3_t
	  PORT_EGRESS_BEHAVIOR_1_3; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L3FE_PE_PORT_EGRESS_BEHAVIOR_2_3_t
	  PORT_EGRESS_BEHAVIOR_2_3; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L3FE_PE_MTU_SIZE_0_t MTU_SIZE_0; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L3FE_PE_MTU_SIZE_1_t MTU_SIZE_1; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L3FE_PE_DSL_6RD_ENCAP_CFG_t DSL_6RD_ENCAP_CFG; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L3FE_PE_DSL_6RD_ENCAP_TYPE_t DSL_6RD_ENCAP_TYPE; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L3FE_PE_DSL_6RD_DECAP_TYPE_t DSL_6RD_DECAP_TYPE; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L3FE_PE_MIRROR_CFG_t MIRROR_CFG; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L3FE_PE_MIRROR_LEN_CFG_t MIRROR_LEN_CFG; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L3FE_PE_SIXRD_TBL_ACCESS_t SIXRD_TBL_ACCESS; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L3FE_PE_SIXRD_TBL_DATA6_t SIXRD_TBL_DATA6; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L3FE_PE_SIXRD_TBL_DATA5_t SIXRD_TBL_DATA5; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L3FE_PE_SIXRD_TBL_DATA4_t SIXRD_TBL_DATA4; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L3FE_PE_SIXRD_TBL_DATA3_t SIXRD_TBL_DATA3; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L3FE_PE_SIXRD_TBL_DATA2_t SIXRD_TBL_DATA2; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L3FE_PE_SIXRD_TBL_DATA1_t SIXRD_TBL_DATA1; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	L3FE_PE_SIXRD_TBL_DATA0_t SIXRD_TBL_DATA0; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	L3FE_PE_DSL_TBL_ACCESS_t DSL_TBL_ACCESS; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	L3FE_PE_DSL_TBL_DATA9_t DSL_TBL_DATA9; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	L3FE_PE_DSL_TBL_DATA8_t DSL_TBL_DATA8; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	L3FE_PE_DSL_TBL_DATA7_t DSL_TBL_DATA7; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	L3FE_PE_DSL_TBL_DATA6_t DSL_TBL_DATA6; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	L3FE_PE_DSL_TBL_DATA5_t DSL_TBL_DATA5; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd43[3];
	L3FE_PE_DSL_TBL_DATA4_t DSL_TBL_DATA4; /* addr: 0x000000ac */
	ca_uint32_t rsrvd44[3];
	L3FE_PE_DSL_TBL_DATA3_t DSL_TBL_DATA3; /* addr: 0x000000b0 */
	ca_uint32_t rsrvd45[3];
	L3FE_PE_DSL_TBL_DATA2_t DSL_TBL_DATA2; /* addr: 0x000000b4 */
	ca_uint32_t rsrvd46[3];
	L3FE_PE_DSL_TBL_DATA1_t DSL_TBL_DATA1; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd47[3];
	L3FE_PE_DSL_TBL_DATA0_t DSL_TBL_DATA0; /* addr: 0x000000bc */
	ca_uint32_t rsrvd48[3];
	L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_t
	  DROP_SRC_PKT_CNT_TBL_ACCESS; /* addr: 0x000000c0 */
	ca_uint32_t rsrvd49[3];
	L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_t
	  DROP_SRC_PKT_CNT_TBL_DATA1; /* addr: 0x000000c4 */
	ca_uint32_t rsrvd50[3];
	L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_t
	  DROP_SRC_PKT_CNT_TBL_DATA0; /* addr: 0x000000c8 */
	ca_uint32_t rsrvd51[3];
	L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_t
	  DROP_SRC_BYTE_CNT_TBL_ACCESS; /* addr: 0x000000cc */
	ca_uint32_t rsrvd52[3];
	L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_t
	  DROP_SRC_BYTE_CNT_TBL_DATA1; /* addr: 0x000000d0 */
	ca_uint32_t rsrvd53[3];
	L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_t
	  DROP_SRC_BYTE_CNT_TBL_DATA0; /* addr: 0x000000d4 */
	ca_uint32_t rsrvd54[3];
	L3FE_PE_RX_IFID_CNT_TBL_ACCESS_t
	  RX_IFID_CNT_TBL_ACCESS; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd55[3];
	L3FE_PE_RX_IFID_CNT_TBL_DATA7_t RX_IFID_CNT_TBL_DATA7; /* addr: 0x000000dc */
	ca_uint32_t rsrvd56[3];
	L3FE_PE_RX_IFID_CNT_TBL_DATA6_t RX_IFID_CNT_TBL_DATA6; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd57[3];
	L3FE_PE_RX_IFID_CNT_TBL_DATA5_t RX_IFID_CNT_TBL_DATA5; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd58[3];
	L3FE_PE_RX_IFID_CNT_TBL_DATA4_t RX_IFID_CNT_TBL_DATA4; /* addr: 0x000000e8 */
	ca_uint32_t rsrvd59[3];
	L3FE_PE_RX_IFID_CNT_TBL_DATA3_t RX_IFID_CNT_TBL_DATA3; /* addr: 0x000000ec */
	ca_uint32_t rsrvd60[3];
	L3FE_PE_RX_IFID_CNT_TBL_DATA2_t RX_IFID_CNT_TBL_DATA2; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd61[3];
	L3FE_PE_RX_IFID_CNT_TBL_DATA1_t RX_IFID_CNT_TBL_DATA1; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd62[3];
	L3FE_PE_RX_IFID_CNT_TBL_DATA0_t RX_IFID_CNT_TBL_DATA0; /* addr: 0x000000f8 */
	ca_uint32_t rsrvd63[3];
	L3FE_PE_TX_IFID_CNT_TBL_ACCESS_t
	  TX_IFID_CNT_TBL_ACCESS; /* addr: 0x000000fc */
	ca_uint32_t rsrvd64[3];
	L3FE_PE_TX_IFID_CNT_TBL_DATA6_t TX_IFID_CNT_TBL_DATA6; /* addr: 0x00000100 */
	ca_uint32_t rsrvd65[3];
	L3FE_PE_TX_IFID_CNT_TBL_DATA5_t TX_IFID_CNT_TBL_DATA5; /* addr: 0x00000104 */
	ca_uint32_t rsrvd66[3];
	L3FE_PE_TX_IFID_CNT_TBL_DATA4_t TX_IFID_CNT_TBL_DATA4; /* addr: 0x00000108 */
	ca_uint32_t rsrvd67[3];
	L3FE_PE_TX_IFID_CNT_TBL_DATA3_t TX_IFID_CNT_TBL_DATA3; /* addr: 0x0000010c */
	ca_uint32_t rsrvd68[3];
	L3FE_PE_TX_IFID_CNT_TBL_DATA2_t TX_IFID_CNT_TBL_DATA2; /* addr: 0x00000110 */
	ca_uint32_t rsrvd69[3];
	L3FE_PE_TX_IFID_CNT_TBL_DATA1_t TX_IFID_CNT_TBL_DATA1; /* addr: 0x00000114 */
	ca_uint32_t rsrvd70[3];
	L3FE_PE_TX_IFID_CNT_TBL_DATA0_t TX_IFID_CNT_TBL_DATA0; /* addr: 0x00000118 */
} APB0_L3FE_PE_t;
#endif /* !__ASSEMBLER__ */

/*
 * FE_L3E_HS
 */

#define L3FE_FE_L3E_HS_PROFILE0_INI 0xf4303700
#define L3FE_FE_L3E_HS_PROFILE0_INI_STRIDE 44
#define L3FE_FE_L3E_HS_PROFILE0_INI_COUNT 7
#define L3FE_FE_L3E_HS_PROFILE0_INI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpl_num : 4; /* bits 3:0 */
		ca_uint32_t default_sel_0e : 5; /* bits 8:4 */
		ca_uint32_t default_sel_0a : 5; /* bits 13:9 */
		ca_uint32_t default_sel_1e : 5; /* bits 18:14 */
		ca_uint32_t default_sel_1a : 5; /* bits 23:19 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_PROFILE0_INI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0 0xf4303704
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_STRIDE 44
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_COUNT 7
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t maskptr : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t pri : 3; /* bits 10:8 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t type : 1; /* bits 12:12 */
		ca_uint32_t rsrvd3 : 19;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_PROFILE0_TUPLE0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION 0xf4303724
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_STRIDE 44
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_COUNT 7
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t a_mask : 24; /* bits 23:0 */
		ca_uint32_t fetch_sz : 3; /* bits 26:24 */
		ca_uint32_t rsrvd1 : 5;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_HASH_INI 0xf4303834
#define L3FE_FE_L3E_HS_HASH_INI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hb_size : 2; /* bits 1:0 */
		ca_uint32_t ht_size : 3; /* bits 4:2 */
		ca_uint32_t ha_width : 3; /* bits 7:5 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_HASH_INI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_MH1 0xf4303838
#define L3FE_FE_L3E_HS_BA_MH1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ba1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_MH1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_MH0 0xf430383c
#define L3FE_FE_L3E_HS_BA_MH0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t ba0 : 25; /* bits 31:7 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_MH0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_MA1 0xf4303840
#define L3FE_FE_L3E_HS_BA_MA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ba1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_MA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_MA0 0xf4303844
#define L3FE_FE_L3E_HS_BA_MA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t ba0 : 25; /* bits 31:7 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_MA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_OVERFLOW_INI 0xf4303848
#define L3FE_FE_L3E_HS_OVERFLOW_INI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t oa_width : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_OVERFLOW_INI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_OA1 0xf430384c
#define L3FE_FE_L3E_HS_BA_OA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ba1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_OA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_OA0 0xf4303850
#define L3FE_FE_L3E_HS_BA_OA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t ba0 : 25; /* bits 31:7 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_OA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_DEFAULT_INI 0xf4303854
#define L3FE_FE_L3E_HS_DEFAULT_INI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t da_width : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_DEFAULT_INI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_DA1 0xf4303858
#define L3FE_FE_L3E_HS_BA_DA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ba1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_DA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_DA0 0xf430385c
#define L3FE_FE_L3E_HS_BA_DA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t ba0 : 25; /* bits 31:7 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_DA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0 0xf4303860
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_STRIDE 4
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_COUNT 32
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t a_mask : 24; /* bits 23:0 */
		ca_uint32_t fetch_sz : 3; /* bits 26:24 */
		ca_uint32_t rsrvd1 : 5;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_DEFAULT_ACTION_0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_INI 0xf43038e0
#define L3FE_FE_L3E_HS_CACHE_INI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ct_size : 3; /* bits 2:0 */
		ca_uint32_t rsrvd1 : 5;
		ca_uint32_t ca_width : 3; /* bits 10:8 */
		ca_uint32_t rsrvd2 : 21;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_INI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_CA1 0xf43038e4
#define L3FE_FE_L3E_HS_BA_CA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ba1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_CA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_BA_CA0 0xf43038e8
#define L3FE_FE_L3E_HS_BA_CA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t ba0 : 25; /* bits 31:7 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_BA_CA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_CTRL 0xf43038ec
#define L3FE_FE_L3E_HS_CACHE_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t slot : 5; /* bits 4:0 */
		ca_uint32_t crc16 : 16; /* bits 20:5 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t loc : 1; /* bits 24:24 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t age : 2; /* bits 27:26 */
		ca_uint32_t pri : 2; /* bits 29:28 */
		ca_uint32_t cmd : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_CTRL_REQ 0xf43038f0
#define L3FE_FE_L3E_HS_CACHE_CTRL_REQ_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t req_sts : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_CTRL_REQ_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_CTRL_STS 0xf43038f4
#define L3FE_FE_L3E_HS_CACHE_CTRL_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bsy : 1; /* bits 0:0 */
		ca_uint32_t err_hash : 1; /* bits 1:1 */
		ca_uint32_t err_free : 1; /* bits 2:2 */
		ca_uint32_t err_nch : 1; /* bits 3:3 */
		ca_uint32_t sts_match : 1; /* bits 4:4 */
		ca_uint32_t sts_match_loc : 1; /* bits 5:5 */
		ca_uint32_t sts_evict : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_CTRL_STS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_AGE10 0xf43038f8
#define L3FE_FE_L3E_HS_CACHE_AGE10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ut_t0 : 16; /* bits 15:0 */
		ca_uint32_t ut_t1 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_AGE10_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_AGE32 0xf43038fc
#define L3FE_FE_L3E_HS_CACHE_AGE32_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ut_t2 : 16; /* bits 15:0 */
		ca_uint32_t ut_t3 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_AGE32_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_CNT 0xf4303900
#define L3FE_FE_L3E_HS_CACHE_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ut_cnt : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_CNT_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_MISC 0xf4303904
#define L3FE_FE_L3E_HS_CACHE_MISC_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 26;
		ca_uint32_t s2_ra_en : 1; /* bits 26:26 */
		ca_uint32_t s2_ra_pri : 2; /* bits 28:27 */
		ca_uint32_t crep_en : 1; /* bits 29:29 */
		ca_uint32_t s3_loc_n : 1; /* bits 30:30 */
		ca_uint32_t s3_ra_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_MISC_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_AXI_CTRL_1 0xf4303908
#define L3FE_FE_L3E_HS_AXI_CTRL_1_STRIDE 4
#define L3FE_FE_L3E_HS_AXI_CTRL_1_COUNT 4
#define L3FE_FE_L3E_HS_AXI_CTRL_1_dft 0x02000f00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t user : 25; /* bits 24:0 */
		ca_uint32_t id : 4; /* bits 28:25 */
		ca_uint32_t ace : 1; /* bits 29:29 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_AXI_CTRL_1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_SWO_IDX 0xf4303918
#define L3FE_FE_L3E_HS_SWO_IDX_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t idx : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_SWO_IDX_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_SWO_DAT 0xf430391c
#define L3FE_FE_L3E_HS_SWO_DAT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dat : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_SWO_DAT_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_SWO_CTRL 0xf4303920
#define L3FE_FE_L3E_HS_SWO_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cmd_sts : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_SWO_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_HASH_ACCESS 0xf4303924
#define L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 11; /* bits 10:0 */
		ca_uint32_t rsrvd1 : 19;
		ca_uint32_t r0w1 : 1; /* bits 30:30 */
		ca_uint32_t status : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_HASH_DATA1 0xf4303928
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t crc16 : 13; /* bits 12:0 */
		ca_uint32_t slot : 5; /* bits 17:13 */
		ca_uint32_t location : 1; /* bits 18:18 */
		ca_uint32_t pri : 2; /* bits 20:19 */
		ca_uint32_t age : 2; /* bits 22:21 */
		ca_uint32_t rsrvd1 : 9;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CACHE_HASH_DATA0 0xf430392c
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t crc32 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS 0xf4303930
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t r0w1 : 1; /* bits 30:30 */
		ca_uint32_t status : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1 0xf4303934
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t crc16 : 16; /* bits 15:0 */
		ca_uint32_t profile : 4; /* bits 19:16 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0 0xf4303938
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t crc32 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_MASK_MEM_ACCESS 0xf430393c
#define L3FE_FE_L3E_HS_MASK_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 23;
		ca_uint32_t r0w1 : 1; /* bits 30:30 */
		ca_uint32_t status : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_MASK_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_MASK_MEM_MASK3 0xf4303940
#define L3FE_FE_L3E_HS_MASK_MEM_MASK3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_MASK_MEM_MASK3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_MASK_MEM_MASK2 0xf4303944
#define L3FE_FE_L3E_HS_MASK_MEM_MASK2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_MASK_MEM_MASK2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_MASK_MEM_MASK1 0xf4303948
#define L3FE_FE_L3E_HS_MASK_MEM_MASK1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_MASK_MEM_MASK1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_MASK_MEM_MASK0 0xf430394c
#define L3FE_FE_L3E_HS_MASK_MEM_MASK0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_MASK_MEM_MASK0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_AGING_GRANULARITY 0xf4303950
#define L3FE_FE_L3E_HS_AGING_GRANULARITY_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t timer : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_AGING_GRANULARITY_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS 0xf4303954
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 18;
		ca_uint32_t r0w1 : 1; /* bits 30:30 */
		ca_uint32_t age : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3 0xf4303958
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2 0xf430395c
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1 0xf4303960
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0 0xf4303964
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_MEM_INI 0xf4303968
#define L3FE_FE_L3E_HS_MEM_INI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t req_sts : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_MEM_INI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_CHK_FAIL_CTRL 0xf430396c
#define L3FE_FE_L3E_HS_CHK_FAIL_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type0 : 8; /* bits 7:0 */
		ca_uint32_t type1 : 8; /* bits 15:8 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_CHK_FAIL_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_RSV0 0xf4303970
#define L3FE_FE_L3E_HS_RSV0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsv : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_RSV0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_RSV1 0xf4303974
#define L3FE_FE_L3E_HS_RSV1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsv : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_RSV1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_PF_0_KEY 0xf4303978
#define L3FE_FE_L3E_HS_PF_0_KEY_STRIDE 20
#define L3FE_FE_L3E_HS_PF_0_KEY_COUNT 7
#define L3FE_FE_L3E_HS_PF_0_KEY_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 6; /* bits 5:0 */
		ca_uint32_t rsrvd1 : 26;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_PF_0_KEY_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_PF_0_TPL_SP 0xf430397c
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_STRIDE 20
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_COUNT 7
#define L3FE_FE_L3E_HS_PF_0_TPL_SP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 20; /* bits 19:0 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_PF_0_TPL_SP_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_PF_0_TPL_DP 0xf4303980
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_STRIDE 20
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_COUNT 7
#define L3FE_FE_L3E_HS_PF_0_TPL_DP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 20; /* bits 19:0 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_PF_0_TPL_DP_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_PF_0_TPL_SIP 0xf4303984
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_STRIDE 20
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_COUNT 7
#define L3FE_FE_L3E_HS_PF_0_TPL_SIP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_PF_0_TPL_SIP_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_PF_0_TPL_DIP 0xf4303988
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_STRIDE 20
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_COUNT 7
#define L3FE_FE_L3E_HS_PF_0_TPL_DIP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_PF_0_TPL_DIP_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FE_L3E_HS */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_FE_L3E_HS_PROFILE0_INI_t PROFILE0_INI; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_FE_L3E_HS_PROFILE0_TUPLE0_t PROFILE0_TUPLE0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[31];
	L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_t
	  PROFILE0_TYPE0_ACTION; /* addr: 0x00000024 */
	ca_uint32_t rsrvd3[271];
	L3FE_FE_L3E_HS_HASH_INI_t HASH_INI; /* addr: 0x00000134 */
	ca_uint32_t rsrvd4[3];
	L3FE_FE_L3E_HS_BA_MH1_t BA_MH1; /* addr: 0x00000138 */
	ca_uint32_t rsrvd5[3];
	L3FE_FE_L3E_HS_BA_MH0_t BA_MH0; /* addr: 0x0000013c */
	ca_uint32_t rsrvd6[3];
	L3FE_FE_L3E_HS_BA_MA1_t BA_MA1; /* addr: 0x00000140 */
	ca_uint32_t rsrvd7[3];
	L3FE_FE_L3E_HS_BA_MA0_t BA_MA0; /* addr: 0x00000144 */
	ca_uint32_t rsrvd8[3];
	L3FE_FE_L3E_HS_OVERFLOW_INI_t OVERFLOW_INI; /* addr: 0x00000148 */
	ca_uint32_t rsrvd9[3];
	L3FE_FE_L3E_HS_BA_OA1_t BA_OA1; /* addr: 0x0000014c */
	ca_uint32_t rsrvd10[3];
	L3FE_FE_L3E_HS_BA_OA0_t BA_OA0; /* addr: 0x00000150 */
	ca_uint32_t rsrvd11[3];
	L3FE_FE_L3E_HS_DEFAULT_INI_t DEFAULT_INI; /* addr: 0x00000154 */
	ca_uint32_t rsrvd12[3];
	L3FE_FE_L3E_HS_BA_DA1_t BA_DA1; /* addr: 0x00000158 */
	ca_uint32_t rsrvd13[3];
	L3FE_FE_L3E_HS_BA_DA0_t BA_DA0; /* addr: 0x0000015c */
	ca_uint32_t rsrvd14[3];
	L3FE_FE_L3E_HS_DEFAULT_ACTION_0_t DEFAULT_ACTION_0; /* addr: 0x00000160 */
	ca_uint32_t rsrvd15[127];
	L3FE_FE_L3E_HS_CACHE_INI_t CACHE_INI; /* addr: 0x000001e0 */
	ca_uint32_t rsrvd16[3];
	L3FE_FE_L3E_HS_BA_CA1_t BA_CA1; /* addr: 0x000001e4 */
	ca_uint32_t rsrvd17[3];
	L3FE_FE_L3E_HS_BA_CA0_t BA_CA0; /* addr: 0x000001e8 */
	ca_uint32_t rsrvd18[3];
	L3FE_FE_L3E_HS_CACHE_CTRL_t CACHE_CTRL; /* addr: 0x000001ec */
	ca_uint32_t rsrvd19[3];
	L3FE_FE_L3E_HS_CACHE_CTRL_REQ_t CACHE_CTRL_REQ; /* addr: 0x000001f0 */
	ca_uint32_t rsrvd20[3];
	L3FE_FE_L3E_HS_CACHE_CTRL_STS_t CACHE_CTRL_STS; /* addr: 0x000001f4 */
	ca_uint32_t rsrvd21[3];
	L3FE_FE_L3E_HS_CACHE_AGE10_t CACHE_AGE10; /* addr: 0x000001f8 */
	ca_uint32_t rsrvd22[3];
	L3FE_FE_L3E_HS_CACHE_AGE32_t CACHE_AGE32; /* addr: 0x000001fc */
	ca_uint32_t rsrvd23[3];
	L3FE_FE_L3E_HS_CACHE_CNT_t CACHE_CNT; /* addr: 0x00000200 */
	ca_uint32_t rsrvd24[3];
	L3FE_FE_L3E_HS_CACHE_MISC_t CACHE_MISC; /* addr: 0x00000204 */
	ca_uint32_t rsrvd25[3];
	L3FE_FE_L3E_HS_AXI_CTRL_1_t AXI_CTRL_1; /* addr: 0x00000208 */
	ca_uint32_t rsrvd26[15];
	L3FE_FE_L3E_HS_SWO_IDX_t SWO_IDX; /* addr: 0x00000218 */
	ca_uint32_t rsrvd27[3];
	L3FE_FE_L3E_HS_SWO_DAT_t SWO_DAT; /* addr: 0x0000021c */
	ca_uint32_t rsrvd28[3];
	L3FE_FE_L3E_HS_SWO_CTRL_t SWO_CTRL; /* addr: 0x00000220 */
	ca_uint32_t rsrvd29[3];
	L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_t CACHE_HASH_ACCESS; /* addr: 0x00000224 */
	ca_uint32_t rsrvd30[3];
	L3FE_FE_L3E_HS_CACHE_HASH_DATA1_t CACHE_HASH_DATA1; /* addr: 0x00000228 */
	ca_uint32_t rsrvd31[3];
	L3FE_FE_L3E_HS_CACHE_HASH_DATA0_t CACHE_HASH_DATA0; /* addr: 0x0000022c */
	ca_uint32_t rsrvd32[3];
	L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_t
	  OVERFLOW_HASH_ACCESS; /* addr: 0x00000230 */
	ca_uint32_t rsrvd33[3];
	L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_t
	  OVERFLOW_HASH_DATA1; /* addr: 0x00000234 */
	ca_uint32_t rsrvd34[3];
	L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_t
	  OVERFLOW_HASH_DATA0; /* addr: 0x00000238 */
	ca_uint32_t rsrvd35[3];
	L3FE_FE_L3E_HS_MASK_MEM_ACCESS_t MASK_MEM_ACCESS; /* addr: 0x0000023c */
	ca_uint32_t rsrvd36[3];
	L3FE_FE_L3E_HS_MASK_MEM_MASK3_t MASK_MEM_MASK3; /* addr: 0x00000240 */
	ca_uint32_t rsrvd37[3];
	L3FE_FE_L3E_HS_MASK_MEM_MASK2_t MASK_MEM_MASK2; /* addr: 0x00000244 */
	ca_uint32_t rsrvd38[3];
	L3FE_FE_L3E_HS_MASK_MEM_MASK1_t MASK_MEM_MASK1; /* addr: 0x00000248 */
	ca_uint32_t rsrvd39[3];
	L3FE_FE_L3E_HS_MASK_MEM_MASK0_t MASK_MEM_MASK0; /* addr: 0x0000024c */
	ca_uint32_t rsrvd40[3];
	L3FE_FE_L3E_HS_AGING_GRANULARITY_t AGING_GRANULARITY; /* addr: 0x00000250 */
	ca_uint32_t rsrvd41[3];
	L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_t
	  HASH_AGE_MEM_ACCESS; /* addr: 0x00000254 */
	ca_uint32_t rsrvd42[3];
	L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_t HASH_AGE_MEM_DATA3; /* addr: 0x00000258 */
	ca_uint32_t rsrvd43[3];
	L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_t HASH_AGE_MEM_DATA2; /* addr: 0x0000025c */
	ca_uint32_t rsrvd44[3];
	L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_t HASH_AGE_MEM_DATA1; /* addr: 0x00000260 */
	ca_uint32_t rsrvd45[3];
	L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_t HASH_AGE_MEM_DATA0; /* addr: 0x00000264 */
	ca_uint32_t rsrvd46[3];
	L3FE_FE_L3E_HS_MEM_INI_t MEM_INI; /* addr: 0x00000268 */
	ca_uint32_t rsrvd47[3];
	L3FE_FE_L3E_HS_CHK_FAIL_CTRL_t CHK_FAIL_CTRL; /* addr: 0x0000026c */
	ca_uint32_t rsrvd48[3];
	L3FE_FE_L3E_HS_RSV0_t RSV0; /* addr: 0x00000270 */
	ca_uint32_t rsrvd49[3];
	L3FE_FE_L3E_HS_RSV1_t RSV1; /* addr: 0x00000274 */
	ca_uint32_t rsrvd50[3];
	L3FE_FE_L3E_HS_PF_0_KEY_t PF_0_KEY; /* addr: 0x00000278 */
	ca_uint32_t rsrvd51[3];
	L3FE_FE_L3E_HS_PF_0_TPL_SP_t PF_0_TPL_SP; /* addr: 0x0000027c */
	ca_uint32_t rsrvd52[3];
	L3FE_FE_L3E_HS_PF_0_TPL_DP_t PF_0_TPL_DP; /* addr: 0x00000280 */
	ca_uint32_t rsrvd53[3];
	L3FE_FE_L3E_HS_PF_0_TPL_SIP_t PF_0_TPL_SIP; /* addr: 0x00000284 */
	ca_uint32_t rsrvd54[3];
	L3FE_FE_L3E_HS_PF_0_TPL_DIP_t PF_0_TPL_DIP; /* addr: 0x00000288 */
} APB0_L3FE_FE_L3E_HS_t;
#endif /* !__ASSEMBLER__ */

/*
 * AXIM2
 */

#define L3FE_AXIM2_CONFIG 0xf4303c80
#define L3FE_AXIM2_CONFIG_dft 0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t axi_write_outtrans_num : 4; /* bits 3:0 */
		ca_uint32_t axi_read_outtrans_num : 4; /* bits 7:4 */
		ca_uint32_t axi_xbus_len : 3; /* bits 10:8 */
		ca_uint32_t write_cacheline_trans_en : 1; /* bits 11:11 */
		ca_uint32_t write_cacheline_trans_size : 1; /* bits 12:12 */
		ca_uint32_t read_cacheline_trans_en : 1; /* bits 13:13 */
		ca_uint32_t read_cacheline_trans_size : 1; /* bits 14:14 */
		ca_uint32_t arcache_eos_en : 1; /* bits 15:15 */
		ca_uint32_t awcache_eos_en : 1; /* bits 16:16 */
		ca_uint32_t reserved : 15; /* bits 31:17 */
	} bf;
	ca_uint32_t wrd;
} L3FE_AXIM2_CONFIG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_AXIM2_TIMEOUT_THRESHOLD 0xf4303c84
#define L3FE_AXIM2_TIMEOUT_THRESHOLD_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t read_channel_threshold : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t write_channel_threshold : 1; /* bits 4:4 */
		ca_uint32_t rsrvd2 : 27;
	} bf;
	ca_uint32_t wrd;
} L3FE_AXIM2_TIMEOUT_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_AXIM2_INTERRUPT_STATUS 0xf4303c88
#define L3FE_AXIM2_INTERRUPT_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t read_trans_resp_timeout_int : 1; /* bits 0:0 */
		ca_uint32_t read_trans_resp_err_int : 1; /* bits 1:1 */
		ca_uint32_t write_trans_resp_timeout_int : 1; /* bits 2:2 */
		ca_uint32_t write_trans_resp_err_int : 1; /* bits 3:3 */
		ca_uint32_t read_trans_resp_ace_err_int : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L3FE_AXIM2_INTERRUPT_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_AXIM2_INTERRUPT_ENABLE 0xf4303c8c
#define L3FE_AXIM2_INTERRUPT_ENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t read_trans_resp_timeout_int_en : 1; /* bits 0:0 */
		ca_uint32_t read_trans_resp_err_int_en : 1; /* bits 1:1 */
		ca_uint32_t write_trans_resp_timeout_int_en : 1; /* bits 2:2 */
		ca_uint32_t write_trans_resp_err_int_en : 1; /* bits 3:3 */
		ca_uint32_t read_trans_resp_ace_err_int_en : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} L3FE_AXIM2_INTERRUPT_ENABLE_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* AXIM2 */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_AXIM2_CONFIG_t CONFIG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_AXIM2_TIMEOUT_THRESHOLD_t TIMEOUT_THRESHOLD; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_AXIM2_INTERRUPT_STATUS_t INTERRUPT_STATUS; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_AXIM2_INTERRUPT_ENABLE_t INTERRUPT_ENABLE; /* addr: 0x0000000c */
} APB0_L3FE_AXIM2_t;
#endif /* !__ASSEMBLER__ */

/*
 * FE_L3E_HS_LIGHT
 */

#define L3FE_FE_L3E_HS_LIGHT_CFG 0xf4303d00
#define L3FE_FE_L3E_HS_LIGHT_CFG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ht_size : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t indexed_if_en : 1; /* bits 8:8 */
		ca_uint32_t rsrvd2 : 23;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_CFG_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN 0xf4303d04
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_STRIDE 12
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_COUNT 6
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tpl_num : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t tpl_type : 8; /* bits 15:8 */
		ca_uint32_t default_sel_0e : 4; /* bits 19:16 */
		ca_uint32_t default_sel_0a : 4; /* bits 23:20 */
		ca_uint32_t default_sel_1e : 4; /* bits 27:24 */
		ca_uint32_t default_sel_1a : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1 0xf4303d08
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_STRIDE 12
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_COUNT 6
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t maskptr41 : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t maskptr51 : 5; /* bits 12:8 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t maskptr61 : 5; /* bits 20:16 */
		ca_uint32_t rsrvd3 : 3;
		ca_uint32_t maskptr71 : 5; /* bits 28:24 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0 0xf4303d0c
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_STRIDE 12
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_COUNT 6
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t maskptr00 : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t maskptr10 : 5; /* bits 12:8 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t maskptr20 : 5; /* bits 20:16 */
		ca_uint32_t rsrvd3 : 3;
		ca_uint32_t maskptr30 : 5; /* bits 28:24 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION 0xf4303d4c
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_STRIDE 4
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_COUNT 6
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t act_mask_hit : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1 0xf4303d64
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_STRIDE 4
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_COUNT 6
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t act_mask_hit : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_PROFILE14_ACTION 0xf4303d7c
#define L3FE_FE_L3E_HS_LIGHT_PROFILE14_ACTION_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t act_mask : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_PROFILE14_ACTION_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0 0xf4303d80
#define L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_STRIDE 4
#define L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_COUNT 16
#define L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t act_mask_dft : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_AGING_GRANULARITY 0xf4303dc0
#define L3FE_FE_L3E_HS_LIGHT_AGING_GRANULARITY_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t timer : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_AGING_GRANULARITY_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_IND_X_ACCESS 0xf4303dc4
#define L3FE_FE_L3E_HS_LIGHT_IND_X_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 14;
		ca_uint32_t r0w1 : 1; /* bits 30:30 */
		ca_uint32_t status : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_IND_X_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA5 0xf4303dc8
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA4 0xf4303dcc
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA3 0xf4303dd0
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA2 0xf4303dd4
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA1 0xf4303dd8
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA0 0xf4303ddc
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_MEM_INI 0xf4303de0
#define L3FE_FE_L3E_HS_LIGHT_MEM_INI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t req_sts : 2; /* bits 1:0 */
		ca_uint32_t rsrvd1 : 30;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_MEM_INI_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_CHK_FAIL_CTRL 0xf4303de4
#define L3FE_FE_L3E_HS_LIGHT_CHK_FAIL_CTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t type0 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_CHK_FAIL_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_HS_LIGHT_RSV0 0xf4303de8
#define L3FE_FE_L3E_HS_LIGHT_RSV0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsv : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_HS_LIGHT_RSV0_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FE_L3E_HS_LIGHT */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_FE_L3E_HS_LIGHT_CFG_t CFG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_t PROFILE0_EN; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_t
	  PROFILE0_MASKPTR1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_t
	  PROFILE0_MASKPTR0; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[63];
	L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_t PROFILE0_ACTION; /* addr: 0x0000004c */
	ca_uint32_t rsrvd5[23];
	L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_t
	  PROFILE0_ACTION_TYPE1; /* addr: 0x00000064 */
	ca_uint32_t rsrvd6[23];
	L3FE_FE_L3E_HS_LIGHT_PROFILE14_ACTION_t
	  PROFILE14_ACTION; /* addr: 0x0000007c */
	ca_uint32_t rsrvd7[3];
	L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_t
	  DEFAULT_ACTION_MASK0; /* addr: 0x00000080 */
	ca_uint32_t rsrvd8[63];
	L3FE_FE_L3E_HS_LIGHT_AGING_GRANULARITY_t
	  AGING_GRANULARITY; /* addr: 0x000000c0 */
	ca_uint32_t rsrvd9[3];
	L3FE_FE_L3E_HS_LIGHT_IND_X_ACCESS_t IND_X_ACCESS; /* addr: 0x000000c4 */
	ca_uint32_t rsrvd10[3];
	L3FE_FE_L3E_HS_LIGHT_IND_X_DATA5_t IND_X_DATA5; /* addr: 0x000000c8 */
	ca_uint32_t rsrvd11[3];
	L3FE_FE_L3E_HS_LIGHT_IND_X_DATA4_t IND_X_DATA4; /* addr: 0x000000cc */
	ca_uint32_t rsrvd12[3];
	L3FE_FE_L3E_HS_LIGHT_IND_X_DATA3_t IND_X_DATA3; /* addr: 0x000000d0 */
	ca_uint32_t rsrvd13[3];
	L3FE_FE_L3E_HS_LIGHT_IND_X_DATA2_t IND_X_DATA2; /* addr: 0x000000d4 */
	ca_uint32_t rsrvd14[3];
	L3FE_FE_L3E_HS_LIGHT_IND_X_DATA1_t IND_X_DATA1; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd15[3];
	L3FE_FE_L3E_HS_LIGHT_IND_X_DATA0_t IND_X_DATA0; /* addr: 0x000000dc */
	ca_uint32_t rsrvd16[3];
	L3FE_FE_L3E_HS_LIGHT_MEM_INI_t MEM_INI; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd17[3];
	L3FE_FE_L3E_HS_LIGHT_CHK_FAIL_CTRL_t CHK_FAIL_CTRL; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd18[3];
	L3FE_FE_L3E_HS_LIGHT_RSV0_t RSV0; /* addr: 0x000000e8 */
} APB0_L3FE_FE_L3E_HS_LIGHT_t;
#endif /* !__ASSEMBLER__ */

/*
 * FE_L3E_LPM
 */

#define L3FE_FE_L3E_LPM_CTRL_PF0 0xf4303f00
#define L3FE_FE_L3E_LPM_CTRL_PF0_dft 0x1f001c03

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t v4_inc_last_row : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t v6_dec_last_row : 5; /* bits 12:8 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t v4_inc_1st_row : 5; /* bits 20:16 */
		ca_uint32_t rsrvd3 : 3;
		ca_uint32_t v6_dec_1st_row : 5; /* bits 28:24 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_CTRL_PF0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_CTRL_PF1 0xf4303f04
#define L3FE_FE_L3E_LPM_CTRL_PF1_dft 0x1b041807

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t v4_inc_last_row : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t v6_dec_last_row : 5; /* bits 12:8 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t v4_inc_1st_row : 5; /* bits 20:16 */
		ca_uint32_t rsrvd3 : 3;
		ca_uint32_t v6_dec_1st_row : 5; /* bits 28:24 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_CTRL_PF1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_CTRL_PF2 0xf4303f08
#define L3FE_FE_L3E_LPM_CTRL_PF2_dft 0x1708140b

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t v4_inc_last_row : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t v6_dec_last_row : 5; /* bits 12:8 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t v4_inc_1st_row : 5; /* bits 20:16 */
		ca_uint32_t rsrvd3 : 3;
		ca_uint32_t v6_dec_1st_row : 5; /* bits 28:24 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_CTRL_PF2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_CTRL_PF3 0xf4303f0c
#define L3FE_FE_L3E_LPM_CTRL_PF3_dft 0x130c100f

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t v4_inc_last_row : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t v6_dec_last_row : 5; /* bits 12:8 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t v4_inc_1st_row : 5; /* bits 20:16 */
		ca_uint32_t rsrvd3 : 3;
		ca_uint32_t v6_dec_1st_row : 5; /* bits 28:24 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_CTRL_PF3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL1 0xf4303f10
#define L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t t4_ctrl_01 : 4; /* bits 3:0 */
		ca_uint32_t t4_ctrl_11 : 4; /* bits 7:4 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL0 0xf4303f14
#define L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t default_idx0 : 12; /* bits 11:0 */
		ca_uint32_t default_ctrl0 : 4; /* bits 15:12 */
		ca_uint32_t default_dpid0 : 6; /* bits 21:16 */
		ca_uint32_t default_dpid_vld0 : 1; /* bits 22:22 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t default_stg0 : 2; /* bits 25:24 */
		ca_uint32_t default_stg_ud0 : 2; /* bits 27:26 */
		ca_uint32_t rsrvd2 : 4;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL1 0xf4303f18
#define L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t t4_ctrl_01 : 4; /* bits 3:0 */
		ca_uint32_t t4_ctrl_11 : 4; /* bits 7:4 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL0 0xf4303f1c
#define L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t default_idx0 : 12; /* bits 11:0 */
		ca_uint32_t default_ctrl0 : 4; /* bits 15:12 */
		ca_uint32_t default_dpid0 : 6; /* bits 21:16 */
		ca_uint32_t default_dpid_vld0 : 1; /* bits 22:22 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t default_stg0 : 2; /* bits 25:24 */
		ca_uint32_t default_stg_ud0 : 2; /* bits 27:26 */
		ca_uint32_t rsrvd2 : 4;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS31 0xf4303f20
#define L3FE_FE_L3E_LPM_STS31_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits31 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS31_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS30 0xf4303f24
#define L3FE_FE_L3E_LPM_STS30_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits30 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS30_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS29 0xf4303f28
#define L3FE_FE_L3E_LPM_STS29_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits29 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS29_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS28 0xf4303f2c
#define L3FE_FE_L3E_LPM_STS28_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits28 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS28_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS27 0xf4303f30
#define L3FE_FE_L3E_LPM_STS27_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits27 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS27_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS26 0xf4303f34
#define L3FE_FE_L3E_LPM_STS26_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits26 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS26_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS25 0xf4303f38
#define L3FE_FE_L3E_LPM_STS25_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits25 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS25_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS24 0xf4303f3c
#define L3FE_FE_L3E_LPM_STS24_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits24 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS24_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS23 0xf4303f40
#define L3FE_FE_L3E_LPM_STS23_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits23 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS23_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS22 0xf4303f44
#define L3FE_FE_L3E_LPM_STS22_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits22 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS22_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS21 0xf4303f48
#define L3FE_FE_L3E_LPM_STS21_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits21 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS21_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS20 0xf4303f4c
#define L3FE_FE_L3E_LPM_STS20_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits20 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS20_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS19 0xf4303f50
#define L3FE_FE_L3E_LPM_STS19_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits19 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS19_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS18 0xf4303f54
#define L3FE_FE_L3E_LPM_STS18_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits18 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS18_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS17 0xf4303f58
#define L3FE_FE_L3E_LPM_STS17_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits17 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS17_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS16 0xf4303f5c
#define L3FE_FE_L3E_LPM_STS16_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits16 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS16_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS15 0xf4303f60
#define L3FE_FE_L3E_LPM_STS15_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits15 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS15_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS14 0xf4303f64
#define L3FE_FE_L3E_LPM_STS14_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits14 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS14_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS13 0xf4303f68
#define L3FE_FE_L3E_LPM_STS13_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits13 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS13_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS12 0xf4303f6c
#define L3FE_FE_L3E_LPM_STS12_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits12 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS12_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS11 0xf4303f70
#define L3FE_FE_L3E_LPM_STS11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits11 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS11_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS10 0xf4303f74
#define L3FE_FE_L3E_LPM_STS10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits10 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS10_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS9 0xf4303f78
#define L3FE_FE_L3E_LPM_STS9_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits9 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS9_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS8 0xf4303f7c
#define L3FE_FE_L3E_LPM_STS8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits8 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS8_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS7 0xf4303f80
#define L3FE_FE_L3E_LPM_STS7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits7 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS7_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS6 0xf4303f84
#define L3FE_FE_L3E_LPM_STS6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits6 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS6_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS5 0xf4303f88
#define L3FE_FE_L3E_LPM_STS5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits5 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS5_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS4 0xf4303f8c
#define L3FE_FE_L3E_LPM_STS4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits4 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS4_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS3 0xf4303f90
#define L3FE_FE_L3E_LPM_STS3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits3 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS3_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS2 0xf4303f94
#define L3FE_FE_L3E_LPM_STS2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS2_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS1 0xf4303f98
#define L3FE_FE_L3E_LPM_STS1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_STS0 0xf4303f9c
#define L3FE_FE_L3E_LPM_STS0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_STS0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_DBG0 0xf4303fa0
#define L3FE_FE_L3E_LPM_DBG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t bits : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_DBG0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_TBL_ACCESS 0xf4303fa4
#define L3FE_FE_L3E_LPM_TBL_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t r0w1 : 1; /* bits 30:30 */
		ca_uint32_t status : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_TBL_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_TBL_DATA1 0xf4303fa8
#define L3FE_FE_L3E_LPM_TBL_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mask : 6; /* bits 5:0 */
		ca_uint32_t attr : 2; /* bits 7:6 */
		ca_uint32_t rst_idx : 12; /* bits 19:8 */
		ca_uint32_t rst_ctrl : 1; /* bits 20:20 */
		ca_uint32_t valid : 1; /* bits 21:21 */
		ca_uint32_t rsrvd1 : 10;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_TBL_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_TBL_DATA0 0xf4303fac
#define L3FE_FE_L3E_LPM_TBL_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t data : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_TBL_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define L3FE_FE_L3E_LPM_MEM_INI 0xf4303fb0
#define L3FE_FE_L3E_LPM_MEM_INI_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t req_sts : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} L3FE_FE_L3E_LPM_MEM_INI_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FE_L3E_LPM */
#ifndef __ASSEMBLER__
typedef struct {
	L3FE_FE_L3E_LPM_CTRL_PF0_t CTRL_PF0; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	L3FE_FE_L3E_LPM_CTRL_PF1_t CTRL_PF1; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	L3FE_FE_L3E_LPM_CTRL_PF2_t CTRL_PF2; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	L3FE_FE_L3E_LPM_CTRL_PF3_t CTRL_PF3; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL1_t IPV4_ACTION_CTRL1; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL0_t IPV4_ACTION_CTRL0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL1_t IPV6_ACTION_CTRL1; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL0_t IPV6_ACTION_CTRL0; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	L3FE_FE_L3E_LPM_STS31_t STS31; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	L3FE_FE_L3E_LPM_STS30_t STS30; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	L3FE_FE_L3E_LPM_STS29_t STS29; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	L3FE_FE_L3E_LPM_STS28_t STS28; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	L3FE_FE_L3E_LPM_STS27_t STS27; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	L3FE_FE_L3E_LPM_STS26_t STS26; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	L3FE_FE_L3E_LPM_STS25_t STS25; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	L3FE_FE_L3E_LPM_STS24_t STS24; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	L3FE_FE_L3E_LPM_STS23_t STS23; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	L3FE_FE_L3E_LPM_STS22_t STS22; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	L3FE_FE_L3E_LPM_STS21_t STS21; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	L3FE_FE_L3E_LPM_STS20_t STS20; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	L3FE_FE_L3E_LPM_STS19_t STS19; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	L3FE_FE_L3E_LPM_STS18_t STS18; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	L3FE_FE_L3E_LPM_STS17_t STS17; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	L3FE_FE_L3E_LPM_STS16_t STS16; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	L3FE_FE_L3E_LPM_STS15_t STS15; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	L3FE_FE_L3E_LPM_STS14_t STS14; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	L3FE_FE_L3E_LPM_STS13_t STS13; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	L3FE_FE_L3E_LPM_STS12_t STS12; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	L3FE_FE_L3E_LPM_STS11_t STS11; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	L3FE_FE_L3E_LPM_STS10_t STS10; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	L3FE_FE_L3E_LPM_STS9_t STS9; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	L3FE_FE_L3E_LPM_STS8_t STS8; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	L3FE_FE_L3E_LPM_STS7_t STS7; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	L3FE_FE_L3E_LPM_STS6_t STS6; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	L3FE_FE_L3E_LPM_STS5_t STS5; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[3];
	L3FE_FE_L3E_LPM_STS4_t STS4; /* addr: 0x0000008c */
	ca_uint32_t rsrvd36[3];
	L3FE_FE_L3E_LPM_STS3_t STS3; /* addr: 0x00000090 */
	ca_uint32_t rsrvd37[3];
	L3FE_FE_L3E_LPM_STS2_t STS2; /* addr: 0x00000094 */
	ca_uint32_t rsrvd38[3];
	L3FE_FE_L3E_LPM_STS1_t STS1; /* addr: 0x00000098 */
	ca_uint32_t rsrvd39[3];
	L3FE_FE_L3E_LPM_STS0_t STS0; /* addr: 0x0000009c */
	ca_uint32_t rsrvd40[3];
	L3FE_FE_L3E_LPM_DBG0_t DBG0; /* addr: 0x000000a0 */
	ca_uint32_t rsrvd41[3];
	L3FE_FE_L3E_LPM_TBL_ACCESS_t TBL_ACCESS; /* addr: 0x000000a4 */
	ca_uint32_t rsrvd42[3];
	L3FE_FE_L3E_LPM_TBL_DATA1_t TBL_DATA1; /* addr: 0x000000a8 */
	ca_uint32_t rsrvd43[3];
	L3FE_FE_L3E_LPM_TBL_DATA0_t TBL_DATA0; /* addr: 0x000000ac */
	ca_uint32_t rsrvd44[3];
	L3FE_FE_L3E_LPM_MEM_INI_t MEM_INI; /* addr: 0x000000b0 */
} APB0_L3FE_FE_L3E_LPM_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L3FE */

#ifndef __ASSEMBLER__
typedef struct {
	APB0_L3FE_GLB_t GLB; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[337];
	APB0_L3FE_PP_t PP; /* addr: 0x00000200 */
	ca_uint32_t rsrvd2[241];
	APB0_L3FE_CLS_t CLS; /* addr: 0x00000380 */
	ca_uint32_t rsrvd3[89];
	APB0_L3FE_STG0_t STG0; /* addr: 0x00000400 */
	ca_uint32_t rsrvd4[93];
	APB0_L3FE_STG1_t STG1; /* addr: 0x00000480 */
	ca_uint32_t rsrvd5[109];
	APB0_L3FE_PE_t PE; /* addr: 0x00000500 */
	ca_uint32_t rsrvd6[371];
	APB0_L3FE_FE_L3E_HS_t FE_L3E_HS; /* addr: 0x00000700 */
	ca_uint32_t rsrvd7[1023];
	APB0_L3FE_AXIM2_t AXIM2; /* addr: 0x00000c80 */
	ca_uint32_t rsrvd8[121];
	APB0_L3FE_FE_L3E_HS_LIGHT_t FE_L3E_HS_LIGHT; /* addr: 0x00000d00 */
	ca_uint32_t rsrvd9[395];
	APB0_L3FE_FE_L3E_LPM_t FE_L3E_LPM; /* addr: 0x00000f00 */
} APB0_L3FE_t;
#endif /* !__ASSEMBLER__ */

/*
 * NI_HV
 */

/*
 * GLB
 */

#define NI_HV_GLB_REVISION 0xf4304000
#define NI_HV_GLB_REVISION_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t minor : 16; /* bits 15:0 */
		ca_uint32_t major : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_REVISION_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_INIT_DONE 0xf4304004
#define NI_HV_GLB_INIT_DONE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ni_init_done : 1; /* bits 1:1 */
		ca_uint32_t rsrvd2 : 30;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_INIT_DONE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_INTF_RST_CONFIG 0xf4304008
#define NI_HV_GLB_INTF_RST_CONFIG_dft 0x000fffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t intf_rst_p0 : 1; /* bits 0:0 */
		ca_uint32_t intf_rst_p1 : 1; /* bits 1:1 */
		ca_uint32_t intf_rst_p2 : 1; /* bits 2:2 */
		ca_uint32_t intf_rst_p3 : 1; /* bits 3:3 */
		ca_uint32_t intf_rst_p4 : 1; /* bits 4:4 */
		ca_uint32_t mac_rx_rst_p0 : 1; /* bits 5:5 */
		ca_uint32_t mac_rx_rst_p1 : 1; /* bits 6:6 */
		ca_uint32_t mac_rx_rst_p2 : 1; /* bits 7:7 */
		ca_uint32_t mac_rx_rst_p3 : 1; /* bits 8:8 */
		ca_uint32_t mac_rx_rst_p4 : 1; /* bits 9:9 */
		ca_uint32_t mac_tx_rst_p0 : 1; /* bits 10:10 */
		ca_uint32_t mac_tx_rst_p1 : 1; /* bits 11:11 */
		ca_uint32_t mac_tx_rst_p2 : 1; /* bits 12:12 */
		ca_uint32_t mac_tx_rst_p3 : 1; /* bits 13:13 */
		ca_uint32_t mac_tx_rst_p4 : 1; /* bits 14:14 */
		ca_uint32_t port_rst_p5 : 1; /* bits 15:15 */
		ca_uint32_t pcs_rst_p6 : 1; /* bits 16:16 */
		ca_uint32_t pcs_rst_p5 : 1; /* bits 17:17 */
		ca_uint32_t mac_rst_p6 : 1; /* bits 18:18 */
		ca_uint32_t mac_rst_p5 : 1; /* bits 19:19 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_INTF_RST_CONFIG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_STATIC_CFG 0xf430400c
#define NI_HV_GLB_STATIC_CFG_dft 0x3ae0012f

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port_to_cpu : 4; /* bits 3:0 */
		ca_uint32_t mgmt_pt_to_fe_also : 1; /* bits 4:4 */
		ca_uint32_t txcrc_chk_en : 1; /* bits 5:5 */
		ca_uint32_t p4_rgmii_tx_clk_phase : 2; /* bits 7:6 */
		ca_uint32_t p4_rgmii_tx_data_order : 1; /* bits 8:8 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t port0_qxgmii_sel : 1; /* bits 12:12 */
		ca_uint32_t port1_qxgmii_sel : 1; /* bits 13:13 */
		ca_uint32_t port2_qxgmii_sel : 1; /* bits 14:14 */
		ca_uint32_t port3_qxgmii_sel : 1; /* bits 15:15 */
		ca_uint32_t rxmib_mode : 1; /* bits 16:16 */
		ca_uint32_t txmib_mode : 1; /* bits 17:17 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t rxaui_mode : 2; /* bits 21:20 */
		ca_uint32_t rxaui_sigdet : 2; /* bits 23:22 */
		ca_uint32_t cnt_op_mode : 3; /* bits 26:24 */
		ca_uint32_t saturn_p7_tx_crc32_add : 1; /* bits 27:27 */
		ca_uint32_t venus_p6_tx_crc32_add : 1; /* bits 28:28 */
		ca_uint32_t venus_p5_tx_crc32_add : 1; /* bits 29:29 */
		ca_uint32_t rsrvd3 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_STATIC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_VENUS_CORESEC10_CFG 0xf4304010
#define NI_HV_GLB_VENUS_CORESEC10_CFG_dft 0x40000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 9;
		ca_uint32_t xgmii_rx_macsec_on : 1; /* bits 9:9 */
		ca_uint32_t xgmii_tx_macsec_on : 1; /* bits 10:10 */
		ca_uint32_t p6_txmac_in_sel : 1; /* bits 11:11 */
		ca_uint32_t p7_xfi_in_sel : 1; /* bits 12:12 */
		ca_uint32_t macsec_enc_in_sel : 1; /* bits 13:13 */
		ca_uint32_t macsec_dec_in_sel : 1; /* bits 14:14 */
		ca_uint32_t p6_nirx_in_sel : 1; /* bits 15:15 */
		ca_uint32_t p7_nirx_in_sel : 1; /* bits 16:16 */
		ca_uint32_t macsec_decrypt_en : 1; /* bits 17:17 */
		ca_uint32_t macsec_encrypt_en : 1; /* bits 18:18 */
		ca_uint32_t enc_all : 1; /* bits 19:19 */
		ca_uint32_t macsec_sectag_type : 1; /* bits 20:20 */
		ca_uint32_t rsrvd2 : 9;
		ca_uint32_t macsec_enc_fifo_threshold : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_VENUS_CORESEC10_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_MAC_ADDR_CFG0 0xf4304014
#define NI_HV_GLB_MAC_ADDR_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_addr0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_MAC_ADDR_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_MAC_ADDR_CFG1 0xf4304018
#define NI_HV_GLB_MAC_ADDR_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_addr1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_MAC_ADDR_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_WOL_PASSWD_0 0xf430401c
#define NI_HV_GLB_WOL_PASSWD_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wol_passwd0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_WOL_PASSWD_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_WOL_PASSWD_1 0xf4304020
#define NI_HV_GLB_WOL_PASSWD_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wol_passwd1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_WOL_PASSWD_1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PKT_LEN_CFG 0xf4304024
#define NI_HV_GLB_PKT_LEN_CFG_dft 0x004023f1

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t max_pkt_size : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t min_pkt_size : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PKT_LEN_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PKT_STOR_LEN_CFG 0xf4304028
#define NI_HV_GLB_PKT_STOR_LEN_CFG_dft 0x00002454

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t max_stor_pkt_len : 14; /* bits 13:0 */
		ca_uint32_t rsrvd1 : 18;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PKT_STOR_LEN_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_P5_BYPASS_CFG 0xf430402c
#define NI_HV_GLB_P5_BYPASS_CFG_dft 0x00000008

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t byp_cos : 3; /* bits 2:0 */
		ca_uint32_t byp_dpq : 1; /* bits 3:3 */
		ca_uint32_t byp_dpid : 6; /* bits 9:4 */
		ca_uint32_t byp_mir : 1; /* bits 10:10 */
		ca_uint32_t byp_ndrp : 1; /* bits 11:11 */
		ca_uint32_t byp_en : 1; /* bits 12:12 */
		ca_uint32_t rsrvd1 : 19;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_P5_BYPASS_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_BYPASS_CFG 0xf4304030
#define NI_HV_GLB_XGE_BYPASS_CFG_dft 0x00000008

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t p6_byp_cos : 3; /* bits 2:0 */
		ca_uint32_t p6_byp_dpq : 1; /* bits 3:3 */
		ca_uint32_t p6_byp_dpid : 6; /* bits 9:4 */
		ca_uint32_t p6_byp_mir : 1; /* bits 10:10 */
		ca_uint32_t p6_byp_ndrp : 1; /* bits 11:11 */
		ca_uint32_t p6_byp_en : 1; /* bits 12:12 */
		ca_uint32_t rsrvd1 : 16;
		ca_uint32_t p6_ts_fifo_rst : 1; /* bits 29:29 */
		ca_uint32_t rsrvd2 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_BYPASS_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_RXPAUSE_CFG 0xf4304034
#define NI_HV_GLB_XGE6_RXPAUSE_CFG_dft 0x0004b064

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t thre_lo : 10; /* bits 9:0 */
		ca_uint32_t thre_hi : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_RXPAUSE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE7_RXFIFO_THRESHOLD 0xf4304038
#define NI_HV_GLB_XGE7_RXFIFO_THRESHOLD_dft 0x00032014

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t free_buf_thre_lo : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t free_buf_thre_hi : 9; /* bits 18:10 */
		ca_uint32_t rsrvd2 : 13;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE7_RXFIFO_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_MAC_CFG1 0xf430403c
#define NI_HV_GLB_XGE6_MAC_CFG1_dft 0x00000200

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_MAC_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_MAC_CFG0 0xf4304040
#define NI_HV_GLB_XGE6_MAC_CFG0_dft 0x00000002

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_MAC_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_FLOW_CONTROL_CFG 0xf4304044
#define NI_HV_GLB_XGE6_FLOW_CONTROL_CFG_dft 0xc4ff011c

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t qbb_tx_en : 1; /* bits 0:0 */
		ca_uint32_t qbb_rx_en : 1; /* bits 1:1 */
		ca_uint32_t pau_tx_en : 1; /* bits 2:2 */
		ca_uint32_t pau_rx_en : 1; /* bits 3:3 */
		ca_uint32_t adjust_pause_cnt : 12; /* bits 15:4 */
		ca_uint32_t qbb_qen : 8; /* bits 23:16 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t tx_sw_pause_en : 1; /* bits 25:25 */
		ca_uint32_t rx_drp_pau_en : 1; /* bits 26:26 */
		ca_uint32_t tx_sw_pausereq : 1; /* bits 27:27 */
		ca_uint32_t internal_txstop_sel : 1; /* bits 28:28 */
		ca_uint32_t tx_remheader_dis : 1; /* bits 29:29 */
		ca_uint32_t rx_pausereq_sel : 1; /* bits 30:30 */
		ca_uint32_t te_pausereq_sel : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_FLOW_CONTROL_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_TX_REPEAT_CNT 0xf4304048
#define NI_HV_GLB_XGE6_TX_REPEAT_CNT_dft 0x00008000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t repeat_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_TX_REPEAT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_TX_QUANTA0 0xf430404c
#define NI_HV_GLB_XGE6_TX_QUANTA0_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta0 : 16; /* bits 15:0 */
		ca_uint32_t pause_quanta1 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_TX_QUANTA0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_TX_QUANTA1 0xf4304050
#define NI_HV_GLB_XGE6_TX_QUANTA1_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta2 : 16; /* bits 15:0 */
		ca_uint32_t pause_quanta3 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_TX_QUANTA1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_TX_QUANTA2 0xf4304054
#define NI_HV_GLB_XGE6_TX_QUANTA2_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta4 : 16; /* bits 15:0 */
		ca_uint32_t pause_quanta5 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_TX_QUANTA2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_TX_QUANTA3 0xf4304058
#define NI_HV_GLB_XGE6_TX_QUANTA3_dft 0xffffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta6 : 16; /* bits 15:0 */
		ca_uint32_t pause_quanta7 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_TX_QUANTA3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_QBB_WAIT_TIME 0xf430405c
#define NI_HV_GLB_XGE6_QBB_WAIT_TIME_dft 0x00000005

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wait_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_QBB_WAIT_TIME_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT 0xf4304060
#define NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT 0xf4304064
#define NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t err_paus_pkt_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT 0xf4304068
#define NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG1 0xf430406c
#define NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG1_dft 0xe4e4e4e4

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t int_cal1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG0 0xf4304070
#define NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG0_dft 0xe4e4e4e4

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t int_cal0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_CTRL_CFG 0xf4304074
#define NI_HV_GLB_RXMUX_CTRL_CFG_dft 0x100a09ba

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3fe_pspid : 4; /* bits 3:0 */
		ca_uint32_t mce_pspid : 4; /* bits 7:4 */
		ca_uint32_t dma_pspid : 4; /* bits 11:8 */
		ca_uint32_t err_pkt_ok : 1; /* bits 12:12 */
		ca_uint32_t calendar_en : 1; /* bits 13:13 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t next_sop_delay : 12; /* bits 27:16 */
		ca_uint32_t dbg_sel : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_CTRL_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_LAST_HDR_A2 0xf4304078
#define NI_HV_GLB_RXMUX_LAST_HDR_A2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdra2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_LAST_HDR_A2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_LAST_HDR_A1 0xf430407c
#define NI_HV_GLB_RXMUX_LAST_HDR_A1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdra1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_LAST_HDR_A1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_LAST_HDR_A0 0xf4304080
#define NI_HV_GLB_RXMUX_LAST_HDR_A0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdra0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_LAST_HDR_A0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_PKTCNT 0xf4304084
#define NI_HV_GLB_RXMUX_PKTCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dbg_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_PKTCNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG 0xf4304088
#define NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_STRIDE 4
#define NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_COUNT 12
#define NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_dft 0x0000a014

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t thre_lo : 10; /* bits 9:0 */
		ca_uint32_t thre_hi : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040b8
#define NI_HV_GLB_RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000fffc0

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040bc
#define NI_HV_GLB_RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000eff80

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040c0
#define NI_HV_GLB_RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000dff40

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040c4
#define NI_HV_GLB_RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000cff00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040c8
#define NI_HV_GLB_RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000bfe00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040cc
#define NI_HV_GLB_RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0007fd80

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040d0
#define NI_HV_GLB_RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0005fd40

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040d4
#define NI_HV_GLB_RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0004fd00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040d8
#define NI_HV_GLB_RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0003fcc0

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040dc
#define NI_HV_GLB_RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0002fc80

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040e0
#define NI_HV_GLB_RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0001fc40

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040e4
#define NI_HV_GLB_RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0000fc00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_ptr : 10; /* bits 9:0 */
		ca_uint32_t top_ptr : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_SEG_BUFSIZE_UPDATE 0xf43040e8
#define NI_HV_GLB_RX_SEG_BUFSIZE_UPDATE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t load : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_SEG_BUFSIZE_UPDATE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_SEG_VLAN_TAG_INSERT_CFG 0xf43040ec
#define NI_HV_GLB_RX_SEG_VLAN_TAG_INSERT_CFG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t p0_vlan_tag_num : 2; /* bits 1:0 */
		ca_uint32_t p1_vlan_tag_num : 2; /* bits 3:2 */
		ca_uint32_t p2_vlan_tag_num : 2; /* bits 5:4 */
		ca_uint32_t p3_vlan_tag_num : 2; /* bits 7:6 */
		ca_uint32_t p4_vlan_tag_num : 2; /* bits 9:8 */
		ca_uint32_t p5_vlan_tag_num : 2; /* bits 11:10 */
		ca_uint32_t p6_vlan_tag_num : 2; /* bits 13:12 */
		ca_uint32_t p7_vlan_tag_num : 2; /* bits 15:14 */
		ca_uint32_t p8_vlan_tag_num : 2; /* bits 17:16 */
		ca_uint32_t p9_vlan_tag_num : 2; /* bits 19:18 */
		ca_uint32_t p10_vlan_tag_num : 2; /* bits 21:20 */
		ca_uint32_t p11_vlan_tag_num : 2; /* bits 23:22 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_SEG_VLAN_TAG_INSERT_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_HDR_BUF_STATUS 0xf43040f0
#define NI_HV_GLB_RXMUX_HDR_BUF_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_buf_empty : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_HDR_BUF_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_DATA_BUF_STATUS 0xf43040f4
#define NI_HV_GLB_RXMUX_DATA_BUF_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t seg_buf_empty : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t seg_buf_full : 12; /* bits 27:16 */
		ca_uint32_t l2fe_ni_rdy : 1; /* bits 28:28 */
		ca_uint32_t rsrvd2 : 3;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_DATA_BUF_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_DBG_CFG 0xf43040f8
#define NI_HV_GLB_RXMUX_DBG_CFG_dft 0x00000021

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0_sel : 4; /* bits 3:0 */
		ca_uint32_t cnt1_sel : 4; /* bits 7:4 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_DBG_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_OUT_CNT0 0xf43040fc
#define NI_HV_GLB_RXMUX_OUT_CNT0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_OUT_CNT0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_OUT_CNT1 0xf4304100
#define NI_HV_GLB_RXMUX_OUT_CNT1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_OUT_CNT1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_OUT_DRPCNT0 0xf4304104
#define NI_HV_GLB_RXMUX_OUT_DRPCNT0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_OUT_DRPCNT0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMUX_OUT_DRPCNT1 0xf4304108
#define NI_HV_GLB_RXMUX_OUT_DRPCNT1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMUX_OUT_DRPCNT1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_XRAM_STS 0xf430410c
#define NI_HV_GLB_NIRX_XRAM_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sts : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_XRAM_STS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3QM_STS 0xf4304110
#define NI_HV_GLB_NIRX_L3QM_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sts : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3QM_STS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_STS 0xf4304114
#define NI_HV_GLB_NIRX_L3FE_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sts : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_STS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_P0_RX_DROPCNT 0xf4304118
#define NI_HV_GLB_P0_RX_DROPCNT_STRIDE 4
#define NI_HV_GLB_P0_RX_DROPCNT_COUNT 7
#define NI_HV_GLB_P0_RX_DROPCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t CNT : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_P0_RX_DROPCNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_P0_TX_SHARE_FIFO_BASE_CFG 0xf4304134
#define NI_HV_GLB_P0_TX_SHARE_FIFO_BASE_CFG_dft 0x007f0000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t max : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_P0_TX_SHARE_FIFO_BASE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_P1_TX_SHARE_FIFO_BASE_CFG 0xf4304138
#define NI_HV_GLB_P1_TX_SHARE_FIFO_BASE_CFG_dft 0x007f0080

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t max : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_P1_TX_SHARE_FIFO_BASE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_P2_TX_SHARE_FIFO_BASE_CFG 0xf430413c
#define NI_HV_GLB_P2_TX_SHARE_FIFO_BASE_CFG_dft 0x007f0100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t max : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_P2_TX_SHARE_FIFO_BASE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_P3_TX_SHARE_FIFO_BASE_CFG 0xf4304140
#define NI_HV_GLB_P3_TX_SHARE_FIFO_BASE_CFG_dft 0x007f0180

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t max : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_P3_TX_SHARE_FIFO_BASE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_P4_TX_SHARE_FIFO_BASE_CFG 0xf4304144
#define NI_HV_GLB_P4_TX_SHARE_FIFO_BASE_CFG_dft 0x007f0200

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t max : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_P4_TX_SHARE_FIFO_BASE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_MCE_TX_SHARE_FIFO_BASE_CFG 0xf4304148
#define NI_HV_GLB_MCE_TX_SHARE_FIFO_BASE_CFG_dft 0x007f0280

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t base_addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t max : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_MCE_TX_SHARE_FIFO_BASE_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PG_DA_CFG0 0xf430414c
#define NI_HV_GLB_PG_DA_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_addr0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PG_DA_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PG_DA_CFG1 0xf4304150
#define NI_HV_GLB_PG_DA_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_addr1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PG_DA_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PG_SA_CFG0 0xf4304154
#define NI_HV_GLB_PG_SA_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_addr0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PG_SA_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PG_SA_CFG1 0xf4304158
#define NI_HV_GLB_PG_SA_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mac_addr1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PG_SA_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PG_CFG0 0xf430415c
#define NI_HV_GLB_PG_CFG0_dft 0x00648064

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pg_len : 11; /* bits 10:0 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t pg_len_data : 1; /* bits 15:15 */
		ca_uint32_t pg_frm_cnt : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PG_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PG_CFG1 0xf4304160
#define NI_HV_GLB_PG_CFG1_dft 0x81008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pg_vlan1_tpid : 16; /* bits 15:0 */
		ca_uint32_t pg_vlan2_tpid : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PG_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PG_FXPT_CFG 0xf4304164
#define NI_HV_GLB_PG_FXPT_CFG_dft 0xaaaa5555

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pg_fxpat : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PG_FXPT_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC_DA1 0xf4304168
#define NI_HV_GLB_PC_DA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_da4 : 8; /* bits 7:0 */
		ca_uint32_t pc_da3 : 8; /* bits 15:8 */
		ca_uint32_t pc_da2 : 8; /* bits 23:16 */
		ca_uint32_t pc_da1 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC_DA1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC_DA2 0xf430416c
#define NI_HV_GLB_PC_DA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_da5 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC_DA2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC_SA1 0xf4304170
#define NI_HV_GLB_PC_SA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_sa4 : 8; /* bits 7:0 */
		ca_uint32_t pc_sa3 : 8; /* bits 15:8 */
		ca_uint32_t pc_sa2 : 8; /* bits 23:16 */
		ca_uint32_t pc_sa1 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC_SA1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC_SA2 0xf4304174
#define NI_HV_GLB_PC_SA2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_sa5 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC_SA2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC_CFG0 0xf4304178
#define NI_HV_GLB_PC_CFG0_dft 0x00000064

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_len : 11; /* bits 10:0 */
		ca_uint32_t rsrvd1 : 21;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC_CFG1 0xf430417c
#define NI_HV_GLB_PC_CFG1_dft 0x81008100

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_vlan1_tpid : 16; /* bits 15:0 */
		ca_uint32_t pc_vlan2_tpid : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC_FXPT 0xf4304180
#define NI_HV_GLB_PC_FXPT_dft 0xaaaa5555

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_fxpat : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC_FXPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RM_CFG 0xf4304184
#define NI_HV_GLB_RM_CFG_dft 0x2100000a

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm_en : 1; /* bits 0:0 */
		ca_uint32_t rm_pid : 4; /* bits 4:1 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t rm_cntpkts : 1; /* bits 8:8 */
		ca_uint32_t rm_clrcnt : 1; /* bits 9:9 */
		ca_uint32_t rm_clrtb : 1; /* bits 10:10 */
		ca_uint32_t debug_mode : 1; /* bits 11:11 */
		ca_uint32_t rsrvd2 : 12;
		ca_uint32_t rm_tbinc : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RM_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RM_TBMAX 0xf4304188
#define NI_HV_GLB_RM_TBMAX_dft 0x00ffffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm_tbmax : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RM_TBMAX_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RM_CNTR 0xf430418c
#define NI_HV_GLB_RM_CNTR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RM_CNTR_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RM_LASTCNTR 0xf4304190
#define NI_HV_GLB_RM_LASTCNTR_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rm_lastcnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RM_LASTCNTR_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMIB_ACCESS 0xf4304194
#define NI_HV_GLB_RXMIB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t counter_id : 5; /* bits 4:0 */
		ca_uint32_t port_id : 3; /* bits 7:5 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t debug_mode : 1; /* bits 16:16 */
		ca_uint32_t rsrvd2 : 11;
		ca_uint32_t op_code : 2; /* bits 29:28 */
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define counter_id_RxUCPktCnt 0x0
#define counter_id_RxMCFrmCnt 0x1
#define counter_id_RxBCFrmCnt 0x2
#define counter_id_RxOAMFrmCnt 0x3
#define counter_id_RxJumboFrmCnt 0x4
#define counter_id_RxPauseFrmCnt 0x5
#define counter_id_RxPFCFrmCnt 0x6
#define counter_id_RxUnKnownOCFrmCnt 0x7
#define counter_id_RxCrcErrFrmCnt 0x8
#define counter_id_RxUndersizeFrmCnt 0x9
#define counter_id_RxRuntFrmCnt 0xa
#define counter_id_RxOvSizeFrmCnt 0xb
#define counter_id_RxJabberFrmCnt 0xc
#define counter_id_RxInvalidFrmCnt 0xd
#define counter_id_RxInvalidFlowFrmCnt 0xe
#define counter_id_RxStatsFrm64Oct 0xf
#define counter_id_RxStatsFrm65to127Oct 0x10
#define counter_id_RxStatsFrm128to255Oct 0x11
#define counter_id_RxStatsFrm256to511Oct 0x12
#define counter_id_RxStatsFrm512to1023Oct 0x13
#define counter_id_RxStatsFrm1024to1518Oct 0x14
#define counter_id_RxStatsFrm1519to2100Oct 0x15
#define counter_id_RxStatsFrm2101to9200Oct 0x16
#define counter_id_RxStatsFrm9201toMaxOct 0x17
#define counter_id_RxByteCount_Lo 0x18
#define counter_id_RxByteCount_Hi 0x19

#define NI_HV_GLB_RXMIB_DATA1 0xf4304198
#define NI_HV_GLB_RXMIB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_val_hi : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMIB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXMIB_DATA0 0xf430419c
#define NI_HV_GLB_RXMIB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_val_lo : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXMIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXMIB_ACCESS 0xf43041a0
#define NI_HV_GLB_TXMIB_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t counter_id : 5; /* bits 4:0 */
		ca_uint32_t port_id : 3; /* bits 7:5 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t debug_mode : 1; /* bits 16:16 */
		ca_uint32_t rsrvd2 : 11;
		ca_uint32_t op_code : 2; /* bits 29:28 */
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXMIB_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define counter_id_TxUCPktCnt 0x0
#define counter_id_TxMCFrmCnt 0x1
#define counter_id_TxBCFrmCnt 0x2
#define counter_id_TxOAMFrmCnt 0x3
#define counter_id_TxJumboFrmCnt 0x4
#define counter_id_TxPauseFrmCnt 0x5
#define counter_id_TxPFCFrmCnt 0x6
#define counter_id_TxCrcErrFrmCnt 0x7
#define counter_id_TxOvSizeFrmCnt 0x8
#define counter_id_TxSingleColFrm 0x9
#define counter_id_TxMultiColFrm 0xa
#define counter_id_TxLateColFrm 0xb
#define counter_id_TxExessColFrm 0xd
#define counter_id_TxStatsFrm64Oct 0xe
#define counter_id_TxStatsFrm65to127Oct 0xf
#define counter_id_TxStatsFrm128to255Oct 0x10
#define counter_id_TxStatsFrm256to511Oct 0x11
#define counter_id_TxStatsFrm512to1023Oct 0x12
#define counter_id_TxStatsFrm1024to1518Oct 0x13
#define counter_id_TxStatsFrm1519to2100Oct 0x14
#define counter_id_TxStatsFrm2101to9200Oct 0x15
#define counter_id_TxStatsFrm9201toMaxOct 0x16
#define counter_id_TxByteCount_Lo 0x18
#define counter_id_TxByteCount_Hi 0x19

#define NI_HV_GLB_TXMIB_DATA1 0xf43041a4
#define NI_HV_GLB_TXMIB_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_val_hi : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXMIB_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXMIB_DATA0 0xf43041a8
#define NI_HV_GLB_TXMIB_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt_val_lo : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXMIB_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_INTERNAL_PORT_ID_CFG 0xf43041ac
#define NI_HV_GLB_INTERNAL_PORT_ID_CFG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3qmrx_demux_sel : 8; /* bits 7:0 */
		ca_uint32_t mrr_dsel : 2; /* bits 9:8 */
		ca_uint32_t mrr_ldpid : 6; /* bits 15:10 */
		ca_uint32_t mrr_cos : 3; /* bits 18:16 */
		ca_uint32_t mrr_fe_bypass : 1; /* bits 19:19 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t egr_mrr_sel : 1; /* bits 21:21 */
		ca_uint32_t wan_rxsel : 2; /* bits 23:22 */
		ca_uint32_t dma_to_l3fe : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_INTERNAL_PORT_ID_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_INTERNAL_PORT_ID_CFG2 0xf43041b0
#define NI_HV_GLB_INTERNAL_PORT_ID_CFG2_dft 0x0024009b

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mce_lspid : 6; /* bits 5:0 */
		ca_uint32_t mce_dpq : 1; /* bits 6:6 */
		ca_uint32_t mce_fe_bypass : 1; /* bits 7:7 */
		ca_uint32_t mrr_pol_id : 8; /* bits 15:8 */
		ca_uint32_t mrr_dpq : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rx_cpu : 6; /* bits 23:18 */
		ca_uint32_t rsrvd2 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_INTERNAL_PORT_ID_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_PORT_ID_CFG 0xf43041b4
#define NI_HV_GLB_RX_PORT_ID_CFG_dft 0x040c2040

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port0_id : 6; /* bits 5:0 */
		ca_uint32_t port1_id : 6; /* bits 11:6 */
		ca_uint32_t port2_id : 6; /* bits 17:12 */
		ca_uint32_t port3_id : 6; /* bits 23:18 */
		ca_uint32_t port4_id : 6; /* bits 29:24 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_PORT_ID_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RX_PORT_ID_CFG2 0xf43041b8
#define NI_HV_GLB_RX_PORT_ID_CFG2_dft 0x00007185

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port5_id : 6; /* bits 5:0 */
		ca_uint32_t port6_id : 6; /* bits 11:6 */
		ca_uint32_t port7_id : 6; /* bits 17:12 */
		ca_uint32_t rsrvd1 : 14;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RX_PORT_ID_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG3 0xf43041bc
#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG3_dft 0xaaaaaaaa

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t demux_id3 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_DEMUX_CFG3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG2 0xf43041c0
#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG2_dft 0xaaaaaaaa

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t demux_id2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_DEMUX_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG1 0xf43041c4
#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG1_dft 0xaaaaaaaa

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t demux_id1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_DEMUX_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG0 0xf43041c8
#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG0_dft 0xaaaaaaaa

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t demux_id0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_DEMUX_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG3 0xf43041cc
#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t demux_id3 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG2 0xf43041d0
#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t demux_id2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG1 0xf43041d4
#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t demux_id1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG0 0xf43041d8
#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t demux_id0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NITX_MISC_CFG 0xf43041dc
#define NI_HV_GLB_NITX_MISC_CFG_dft 0x00078ffc

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xge6_hdrA_tx_en : 1; /* bits 0:0 */
		ca_uint32_t xge7_hdrA_tx_en : 1; /* bits 1:1 */
		ca_uint32_t xge6_tx_rd_thre_en : 1; /* bits 2:2 */
		ca_uint32_t xge7_tx_rd_thre_en : 1; /* bits 3:3 */
		ca_uint32_t xaui_tx_rd_thre_en : 1; /* bits 4:4 */
		ca_uint32_t l3qm_tx_rd_thre_en0 : 1; /* bits 5:5 */
		ca_uint32_t l3qm_tx_rd_thre_en1 : 1; /* bits 6:6 */
		ca_uint32_t l3qm_tx_rd_thre_en3 : 1; /* bits 7:7 */
		ca_uint32_t l3fe_tx_rd_thre_en0 : 1; /* bits 8:8 */
		ca_uint32_t l3fe_tx_rd_thre_en1 : 1; /* bits 9:9 */
		ca_uint32_t l3fe_tx_rd_thre_en2 : 1; /* bits 10:10 */
		ca_uint32_t l3fe_tx_rd_thre_en3 : 1; /* bits 11:11 */
		ca_uint32_t xge6_link_fault_halt_tx_en : 1; /* bits 12:12 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t time_base_cnt : 6; /* bits 19:14 */
		ca_uint32_t xge6_tx_drain : 1; /* bits 20:20 */
		ca_uint32_t xge7_tx_drain : 1; /* bits 21:21 */
		ca_uint32_t xaui5_tx_drain : 1; /* bits 22:22 */
		ca_uint32_t rsrvd2 : 9;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NITX_MISC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_MISC_CFG 0xf43041e0
#define NI_HV_GLB_NIRX_MISC_CFG_dft 0x00010080

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3fe_to_l2fe_deepq_csr0 : 1; /* bits 0:0 */
		ca_uint32_t l3fe_to_l2fe_deepq_csr1 : 1; /* bits 1:1 */
		ca_uint32_t l3fe_to_l2fe_deepq_csr2 : 1; /* bits 2:2 */
		ca_uint32_t l3fe_to_l3qm_l4cs_err_en : 1; /* bits 3:3 */
		ca_uint32_t l3fe_to_l2tm_l4cs_err_en : 1; /* bits 4:4 */
		ca_uint32_t l3fe_l3qm_to_l2tm_sel : 1; /* bits 5:5 */
		ca_uint32_t l3fe_l3qm_to_l2tm_bp_en : 1; /* bits 6:6 */
		ca_uint32_t l3fe_l3qm_to_l2tm_arb_en : 1; /* bits 7:7 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t l2te_ni_mc_rdy_en : 1; /* bits 9:9 */
		ca_uint32_t l2te_ni_l3fewan_port_rdy_en : 1; /* bits 10:10 */
		ca_uint32_t l2te_ni_l3felan_port_rdy_en : 1; /* bits 11:11 */
		ca_uint32_t l2te_ni_txdma_l2fe_rdy_en : 1; /* bits 12:12 */
		ca_uint32_t l2te_ni_txdma_l3fe_rdy_en : 1; /* bits 13:13 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t xge6_rx_errpkt_drp_en : 1; /* bits 16:16 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t l3fe_to_wan_l4cs_err_en : 1; /* bits 18:18 */
		ca_uint32_t l3fe_to_l2fe_l4cs_err_en : 1; /* bits 19:19 */
		ca_uint32_t use_p0_as_wan_port_en : 1; /* bits 20:20 */
		ca_uint32_t p0_as_wan_encap_decap_en : 1; /* bits 21:21 */
		ca_uint32_t rsrvd4 : 10;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_MISC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TX_PORT_ID_CFG 0xf43041e4
#define NI_HV_GLB_TX_PORT_ID_CFG_dft 0x76543210

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port0_id : 4; /* bits 3:0 */
		ca_uint32_t port1_id : 4; /* bits 7:4 */
		ca_uint32_t port2_id : 4; /* bits 11:8 */
		ca_uint32_t port3_id : 4; /* bits 15:12 */
		ca_uint32_t port4_id : 4; /* bits 19:16 */
		ca_uint32_t port5_id : 4; /* bits 23:20 */
		ca_uint32_t port6_id : 4; /* bits 27:24 */
		ca_uint32_t port7_id : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TX_PORT_ID_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG 0xf43041e8
#define NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG_dft 0x00cbda98

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3qm_tx_dpid0 : 4; /* bits 3:0 */
		ca_uint32_t l3qm_tx_dpid1 : 4; /* bits 7:4 */
		ca_uint32_t l3fe_tx_dpid0 : 4; /* bits 11:8 */
		ca_uint32_t l3fe_tx_dpid1 : 4; /* bits 15:12 */
		ca_uint32_t mce_tx_dpid : 4; /* bits 19:16 */
		ca_uint32_t oam_tx_dpid : 4; /* bits 23:20 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG2 0xf43041ec
#define NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG2_dft 0x7000da98

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3qm_tx_spid0 : 4; /* bits 3:0 */
		ca_uint32_t l3qm_tx_spid1 : 4; /* bits 7:4 */
		ca_uint32_t l3fe_tx_spid0 : 4; /* bits 11:8 */
		ca_uint32_t l3fe_tx_spid1 : 4; /* bits 15:12 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t l3fe_tx_spid2 : 4; /* bits 27:24 */
		ca_uint32_t l3fe_tx_spid3 : 4; /* bits 31:28 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NITX_CRCE_CNT 0xf43041f0
#define NI_HV_GLB_NITX_CRCE_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t crce_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NITX_CRCE_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NITX_P5_DRAINCNT 0xf43041f4
#define NI_HV_GLB_NITX_P5_DRAINCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t drain_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NITX_P5_DRAINCNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NITX_P6_DRAINCNT 0xf43041f8
#define NI_HV_GLB_NITX_P6_DRAINCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t drain_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NITX_P6_DRAINCNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NITX_P7_DRAINCNT 0xf43041fc
#define NI_HV_GLB_NITX_P7_DRAINCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t drain_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NITX_P7_DRAINCNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NITX_OAMERR_CNT 0xf4304200
#define NI_HV_GLB_NITX_OAMERR_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t oame_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NITX_OAMERR_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_READ_THRESHOLD 0xf4304204
#define NI_HV_GLB_TXFIFO_READ_THRESHOLD_dft 0x64503c28

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rxaui_txfifo_lo : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rxaui_txfifo_hi : 7; /* bits 14:8 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t xge6_txfifo_lo : 7; /* bits 22:16 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t xge6_txfifo_hi : 7; /* bits 30:24 */
		ca_uint32_t rsrvd4 : 1;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_READ_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG1 0xf4304208
#define NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG1_dft 0x780c7864

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t from_l3fe_txfifo_lo : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t from_l3fe_txfifo_hi : 7; /* bits 14:8 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t from_l3qm_txfifo_lo : 7; /* bits 22:16 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t from_l3qm_txfifo_hi : 7; /* bits 30:24 */
		ca_uint32_t rsrvd4 : 1;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG2 0xf430420c
#define NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG2_dft 0x78a3e8c8

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rd_thre_txfifo_lo : 9; /* bits 8:0 */
		ca_uint32_t rd_thre_txfifo_hi : 9; /* bits 17:9 */
		ca_uint32_t from_tm_txfifo_lo : 7; /* bits 24:18 */
		ca_uint32_t from_tm_txfifo_hi : 7; /* bits 31:25 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG1 0xf4304210
#define NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG1_dft 0x60506050

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t from_tm9_txfifo_lo : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t from_tm9_txfifo_hi : 7; /* bits 14:8 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t from_tm8_txfifo_lo : 7; /* bits 22:16 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t from_tm8_txfifo_hi : 7; /* bits 30:24 */
		ca_uint32_t rsrvd4 : 1;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG2 0xf4304214
#define NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG2_dft 0x00006050

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t from_l3fe_txfifo_lo : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t from_l3fe_txfifo_hi : 7; /* bits 14:8 */
		ca_uint32_t rsrvd2 : 17;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG1 0xf4304218
#define NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG1_dft 0xaa6c6b6a

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t from_wan_txfifo_lo : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t from_wan_txfifo_hi : 7; /* bits 14:8 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t from_tm_txfifo_lo : 8; /* bits 23:16 */
		ca_uint32_t from_tm_txfifo_hi : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG2 0xf430421c
#define NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG2_dft 0x0400f06e

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t from_dma_txfifo_lo : 8; /* bits 7:0 */
		ca_uint32_t from_dma_txfifo_hi : 8; /* bits 15:8 */
		ca_uint32_t tm2_shared_fifo_lo : 6; /* bits 21:16 */
		ca_uint32_t tm2_shared_fifo_hi : 6; /* bits 27:22 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG 0xf4304220
#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG_dft 0x3c280000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 16;
		ca_uint32_t oam_from_tm_txfifo_lo : 7; /* bits 22:16 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t oam_from_tm_txfifo_hi : 7; /* bits 30:24 */
		ca_uint32_t rsrvd3 : 1;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG2 0xf4304224
#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG2_dft 0x50285028

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txfifo_l3qm_path0_lo : 8; /* bits 7:0 */
		ca_uint32_t txfifo_l3qm_path0_hi : 8; /* bits 15:8 */
		ca_uint32_t txfifo_l3qm_path1_lo : 8; /* bits 23:16 */
		ca_uint32_t txfifo_l3qm_path1_hi : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG3 0xf4304228
#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG3_dft 0x00005028

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txfifo_l3qm_path2_lo : 8; /* bits 7:0 */
		ca_uint32_t txfifo_l3qm_path2_hi : 8; /* bits 15:8 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXFIFO_MCE_THRESHOLD_CFG 0xf430422c
#define NI_HV_GLB_TXFIFO_MCE_THRESHOLD_CFG_dft 0x00019028

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mce_from_tm_txfifo_lo : 10; /* bits 9:0 */
		ca_uint32_t mce_from_tm_txfifo_hi : 10; /* bits 19:10 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXFIFO_MCE_THRESHOLD_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXFIFO_THRESHOLD_MISC_CFG 0xf4304230
#define NI_HV_GLB_RXFIFO_THRESHOLD_MISC_CFG_dft 0x780a780a

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l3fe_rxfifo_lo : 7; /* bits 6:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t l3fe_rxfifo_hi : 7; /* bits 14:8 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t l3qm_rxfifo_lo : 7; /* bits 22:16 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t l3qm_rxfifo_hi : 7; /* bits 30:24 */
		ca_uint32_t rsrvd4 : 1;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXFIFO_THRESHOLD_MISC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_RXFIFO_XGE6_THRESHOLD_CFG 0xf4304234
#define NI_HV_GLB_RXFIFO_XGE6_THRESHOLD_CFG_dft 0x0003c00a

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t thre_lo : 9; /* bits 8:0 */
		ca_uint32_t thre_hi : 9; /* bits 17:9 */
		ca_uint32_t rsrvd1 : 14;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_RXFIFO_XGE6_THRESHOLD_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIRX_L3QM_THRESHOLD_CFG 0xf4304238
#define NI_HV_GLB_NIRX_L3QM_THRESHOLD_CFG_dft 0x00008080

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t l2tm_fifo_thre : 8; /* bits 7:0 */
		ca_uint32_t wan_fifo_thre : 8; /* bits 15:8 */
		ca_uint32_t dis_fifo_thre : 1; /* bits 16:16 */
		ca_uint32_t rsrvd1 : 15;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIRX_L3QM_THRESHOLD_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PTP_TX_CFG 0xf430423c
#define NI_HV_GLB_PTP_TX_CFG_dft 0x0000007f

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t p0_ptp_tx_en : 1; /* bits 0:0 */
		ca_uint32_t p1_ptp_tx_en : 1; /* bits 1:1 */
		ca_uint32_t p2_ptp_tx_en : 1; /* bits 2:2 */
		ca_uint32_t p3_ptp_tx_en : 1; /* bits 3:3 */
		ca_uint32_t p4_ptp_tx_en : 1; /* bits 4:4 */
		ca_uint32_t p5_ptp_tx_en : 1; /* bits 5:5 */
		ca_uint32_t p6_ptp_tx_en : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t p0_ptp_tx_bypass : 1; /* bits 8:8 */
		ca_uint32_t p1_ptp_tx_bypass : 1; /* bits 9:9 */
		ca_uint32_t p2_ptp_tx_bypass : 1; /* bits 10:10 */
		ca_uint32_t p3_ptp_tx_bypass : 1; /* bits 11:11 */
		ca_uint32_t p4_ptp_tx_bypass : 1; /* bits 12:12 */
		ca_uint32_t p5_ptp_tx_bypass : 1; /* bits 13:13 */
		ca_uint32_t p6_ptp_tx_bypass : 1; /* bits 14:14 */
		ca_uint32_t rsrvd2 : 17;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PTP_TX_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_GE_PTP_ASYM_CFG_01 0xf4304240
#define NI_HV_GLB_GE_PTP_ASYM_CFG_01_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_01 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_GE_PTP_ASYM_CFG_01_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_GE_PTP_ASYM_CFG_00 0xf4304244
#define NI_HV_GLB_GE_PTP_ASYM_CFG_00_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_00 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_GE_PTP_ASYM_CFG_00_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_GE_PTP_ASYM_CFG_11 0xf4304248
#define NI_HV_GLB_GE_PTP_ASYM_CFG_11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_11 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_GE_PTP_ASYM_CFG_11_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_GE_PTP_ASYM_CFG_10 0xf430424c
#define NI_HV_GLB_GE_PTP_ASYM_CFG_10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_10 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_GE_PTP_ASYM_CFG_10_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_GE_PTP_ASYM_CFG_21 0xf4304250
#define NI_HV_GLB_GE_PTP_ASYM_CFG_21_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_21 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_GE_PTP_ASYM_CFG_21_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_GE_PTP_ASYM_CFG_20 0xf4304254
#define NI_HV_GLB_GE_PTP_ASYM_CFG_20_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_20 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_GE_PTP_ASYM_CFG_20_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_GE_PTP_ASYM_CFG_31 0xf4304258
#define NI_HV_GLB_GE_PTP_ASYM_CFG_31_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_31 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_GE_PTP_ASYM_CFG_31_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_GE_PTP_ASYM_CFG_30 0xf430425c
#define NI_HV_GLB_GE_PTP_ASYM_CFG_30_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_30 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_GE_PTP_ASYM_CFG_30_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_01 0xf4304260
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_01_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_01 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_01_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_00 0xf4304264
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_00_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_00 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_00_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_11 0xf4304268
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_11 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_11_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_10 0xf430426c
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_10 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_10_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_21 0xf4304270
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_21_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_21 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_21_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_20 0xf4304274
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_20_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_20 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_20_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_31 0xf4304278
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_31_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_31 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_31_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_30 0xf430427c
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_30_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_30 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_30_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_PTP_ASYM_CFG_01 0xf4304280
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_01_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_01 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_01_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_PTP_ASYM_CFG_00 0xf4304284
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_00_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_00 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_00_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_PTP_ASYM_CFG_11 0xf4304288
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_11 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_11_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_PTP_ASYM_CFG_10 0xf430428c
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_10 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_10_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_PTP_ASYM_CFG_21 0xf4304290
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_21_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_21 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_21_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_PTP_ASYM_CFG_20 0xf4304294
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_20_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_20 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_20_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_PTP_ASYM_CFG_31 0xf4304298
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_31_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_31 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_31_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_XGE_PTP_ASYM_CFG_30 0xf430429c
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_30_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t asym_cfg_30 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_30_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_P0_PTP_TX_TIMESTAMP 0xf43042a0
#define NI_HV_GLB_P0_PTP_TX_TIMESTAMP_STRIDE 4
#define NI_HV_GLB_P0_PTP_TX_TIMESTAMP_COUNT 7
#define NI_HV_GLB_P0_PTP_TX_TIMESTAMP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_ts : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_P0_PTP_TX_TIMESTAMP_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NITX_STS 0xf43042bc
#define NI_HV_GLB_NITX_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sts : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NITX_STS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SPARE 0xf43042c0
#define NI_HV_GLB_SPARE_dft 0x0000ff00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t VALUE : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SPARE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_MISC_STS 0xf43042c4
#define NI_HV_GLB_MISC_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xge6_link_fault : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_MISC_STS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SPARESAMPLE 0xf43042c8
#define NI_HV_GLB_SPARESAMPLE_dft 0x0000ff00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t VALUE : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SPARESAMPLE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PORT_0_INTERRUPT 0xf43042cc
#define NI_HV_GLB_PORT_0_INTERRUPT_STRIDE 8
#define NI_HV_GLB_PORT_0_INTERRUPT_COUNT 5
#define NI_HV_GLB_PORT_0_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t link_stat_chgI : 1; /* bits 0:0 */
		ca_uint32_t txfifo_underrunI : 1; /* bits 1:1 */
		ca_uint32_t txfifo_overrunI : 1; /* bits 2:2 */
		ca_uint32_t rxcntrl_overrunI : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rxmib_cntmsb_setI : 1; /* bits 5:5 */
		ca_uint32_t txmib_cntmsb_setI : 1; /* bits 6:6 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t lpi_assert_stat_chgI : 1; /* bits 9:9 */
		ca_uint32_t rx_lpi_stat_chgI : 1; /* bits 10:10 */
		ca_uint32_t rsrvd3 : 2;
		ca_uint32_t ni_wol_int : 1; /* bits 13:13 */
		ca_uint32_t rsrvd4 : 18;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PORT_0_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PORT_0_INTERRUPTE 0xf43042d0
#define NI_HV_GLB_PORT_0_INTERRUPTE_STRIDE 8
#define NI_HV_GLB_PORT_0_INTERRUPTE_COUNT 5
#define NI_HV_GLB_PORT_0_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t link_stat_chgIE : 1; /* bits 0:0 */
		ca_uint32_t txfifo_underrunIE : 1; /* bits 1:1 */
		ca_uint32_t txfifo_overrunIE : 1; /* bits 2:2 */
		ca_uint32_t rxcntrl_overrunIE : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rxmib_cntmsb_setIE : 1; /* bits 5:5 */
		ca_uint32_t txmib_cntmsb_setIE : 1; /* bits 6:6 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t lpi_assert_stat_chgIE : 1; /* bits 9:9 */
		ca_uint32_t rx_lpi_stat_chgIE : 1; /* bits 10:10 */
		ca_uint32_t rsrvd3 : 2;
		ca_uint32_t ni_wol_intE : 1; /* bits 13:13 */
		ca_uint32_t rsrvd4 : 18;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PORT_0_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PORT_5_INTERRUPT 0xf43042f4
#define NI_HV_GLB_PORT_5_INTERRUPT_STRIDE 8
#define NI_HV_GLB_PORT_5_INTERRUPT_COUNT 3
#define NI_HV_GLB_PORT_5_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t rxcntrl_overrunI : 1; /* bits 3:3 */
		ca_uint32_t rsrvd2 : 28;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PORT_5_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PORT_5_INTERRUPTE 0xf43042f8
#define NI_HV_GLB_PORT_5_INTERRUPTE_STRIDE 8
#define NI_HV_GLB_PORT_5_INTERRUPTE_COUNT 3
#define NI_HV_GLB_PORT_5_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t rxcntrl_overrunIE : 1; /* bits 3:3 */
		ca_uint32_t rsrvd2 : 28;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PORT_5_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PORT_8_INTERRUPT 0xf430430c
#define NI_HV_GLB_PORT_8_INTERRUPT_STRIDE 8
#define NI_HV_GLB_PORT_8_INTERRUPT_COUNT 4
#define NI_HV_GLB_PORT_8_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t rxcntrl_overrunI : 1; /* bits 3:3 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t rxmib_cntmsb_setI : 1; /* bits 5:5 */
		ca_uint32_t txmib_cntmsb_setI : 1; /* bits 6:6 */
		ca_uint32_t rsrvd3 : 25;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PORT_8_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PORT_8_INTERRUPTE 0xf4304310
#define NI_HV_GLB_PORT_8_INTERRUPTE_STRIDE 8
#define NI_HV_GLB_PORT_8_INTERRUPTE_COUNT 4
#define NI_HV_GLB_PORT_8_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t rxcntrl_overrunIE : 1; /* bits 3:3 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t rxmib_cntmsb_setIE : 1; /* bits 5:5 */
		ca_uint32_t txmib_cntmsb_setIE : 1; /* bits 6:6 */
		ca_uint32_t rsrvd3 : 25;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PORT_8_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIFIFO_INTERRUPT 0xf430432c
#define NI_HV_GLB_NIFIFO_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t p0_nitx_fifo_under_run_setI : 1; /* bits 0:0 */
		ca_uint32_t p0_nitx_fifo_over_run_setI : 1; /* bits 1:1 */
		ca_uint32_t p1_nitx_fifo_under_run_setI : 1; /* bits 2:2 */
		ca_uint32_t p1_nitx_fifo_over_run_setI : 1; /* bits 3:3 */
		ca_uint32_t p2_nitx_fifo_under_run_setI : 1; /* bits 4:4 */
		ca_uint32_t p2_nitx_fifo_over_run_setI : 1; /* bits 5:5 */
		ca_uint32_t p3_nitx_fifo_under_run_setI : 1; /* bits 6:6 */
		ca_uint32_t p3_nitx_fifo_over_run_setI : 1; /* bits 7:7 */
		ca_uint32_t p4_nitx_fifo_under_run_setI : 1; /* bits 8:8 */
		ca_uint32_t p4_nitx_fifo_over_run_setI : 1; /* bits 9:9 */
		ca_uint32_t p5_nitx_fifo_under_run_setI : 1; /* bits 10:10 */
		ca_uint32_t p5_nitx_fifo_over_run_setI : 1; /* bits 11:11 */
		ca_uint32_t p6_nitx_fifo_under_run_setI : 1; /* bits 12:12 */
		ca_uint32_t p6_nitx_fifo_over_run_setI : 1; /* bits 13:13 */
		ca_uint32_t p7_nitx_fifo_under_run_setI : 1; /* bits 14:14 */
		ca_uint32_t p7_nitx_fifo_over_run_setI : 1; /* bits 15:15 */
		ca_uint32_t p8_nitx_fifo_under_run_setI : 1; /* bits 16:16 */
		ca_uint32_t p8_nitx_fifo_over_run_setI : 1; /* bits 17:17 */
		ca_uint32_t p9_nitx_fifo_under_run_setI : 1; /* bits 18:18 */
		ca_uint32_t p9_nitx_fifo_over_run_setI : 1; /* bits 19:19 */
		ca_uint32_t p10_nitx_fifo_under_run_setI : 1; /* bits 20:20 */
		ca_uint32_t p10_nitx_fifo_over_run_setI : 1; /* bits 21:21 */
		ca_uint32_t p11_nitx_fifo_under_run_setI : 1; /* bits 22:22 */
		ca_uint32_t p11_nitx_fifo_over_run_setI : 1; /* bits 23:23 */
		ca_uint32_t p12_nitx_fifo_under_run_setI : 1; /* bits 24:24 */
		ca_uint32_t p12_nitx_fifo_over_run_setI : 1; /* bits 25:25 */
		ca_uint32_t p13_nitx_fifo_under_run_setI : 1; /* bits 26:26 */
		ca_uint32_t p13_nitx_fifo_over_run_setI : 1; /* bits 27:27 */
		ca_uint32_t l3qm_nirx_fifo_under_run_setI : 1; /* bits 28:28 */
		ca_uint32_t l3qm_nirx_fifo_over_run_setI : 1; /* bits 29:29 */
		ca_uint32_t l3fe_nirx_fifo_under_run_setI : 1; /* bits 30:30 */
		ca_uint32_t l3fe_nirx_fifo_over_run_setI : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIFIFO_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_NIFIFO_INTERRUPTE 0xf4304330
#define NI_HV_GLB_NIFIFO_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t p0_nitx_fifo_under_run_setIE : 1; /* bits 0:0 */
		ca_uint32_t p0_nitx_fifo_over_run_setIE : 1; /* bits 1:1 */
		ca_uint32_t p1_nitx_fifo_under_run_setIE : 1; /* bits 2:2 */
		ca_uint32_t p1_nitx_fifo_over_run_setIE : 1; /* bits 3:3 */
		ca_uint32_t p2_nitx_fifo_under_run_setIE : 1; /* bits 4:4 */
		ca_uint32_t p2_nitx_fifo_over_run_setIE : 1; /* bits 5:5 */
		ca_uint32_t p3_nitx_fifo_under_run_setIE : 1; /* bits 6:6 */
		ca_uint32_t p3_nitx_fifo_over_run_setIE : 1; /* bits 7:7 */
		ca_uint32_t p4_nitx_fifo_under_run_setIE : 1; /* bits 8:8 */
		ca_uint32_t p4_nitx_fifo_over_run_setIE : 1; /* bits 9:9 */
		ca_uint32_t p5_nitx_fifo_under_run_setIE : 1; /* bits 10:10 */
		ca_uint32_t p5_nitx_fifo_over_run_setIE : 1; /* bits 11:11 */
		ca_uint32_t p6_nitx_fifo_under_run_setIE : 1; /* bits 12:12 */
		ca_uint32_t p6_nitx_fifo_over_run_setIE : 1; /* bits 13:13 */
		ca_uint32_t p7_nitx_fifo_under_run_setIE : 1; /* bits 14:14 */
		ca_uint32_t p7_nitx_fifo_over_run_setIE : 1; /* bits 15:15 */
		ca_uint32_t p8_nitx_fifo_under_run_setIE : 1; /* bits 16:16 */
		ca_uint32_t p8_nitx_fifo_over_run_setIE : 1; /* bits 17:17 */
		ca_uint32_t p9_nitx_fifo_under_run_setIE : 1; /* bits 18:18 */
		ca_uint32_t p9_nitx_fifo_over_run_setIE : 1; /* bits 19:19 */
		ca_uint32_t p10_nitx_fifo_under_run_setIE : 1; /* bits 20:20 */
		ca_uint32_t p10_nitx_fifo_over_run_setIE : 1; /* bits 21:21 */
		ca_uint32_t p11_nitx_fifo_under_run_setIE : 1; /* bits 22:22 */
		ca_uint32_t p11_nitx_fifo_over_run_setIE : 1; /* bits 23:23 */
		ca_uint32_t p12_nitx_fifo_under_run_setIE : 1; /* bits 24:24 */
		ca_uint32_t p12_nitx_fifo_over_run_setIE : 1; /* bits 25:25 */
		ca_uint32_t p13_nitx_fifo_under_run_setIE : 1; /* bits 26:26 */
		ca_uint32_t p13_nitx_fifo_over_run_setIE : 1; /* bits 27:27 */
		ca_uint32_t l3qm_nirx_fifo_under_run_setIE : 1; /* bits 28:28 */
		ca_uint32_t l3qm_nirx_fifo_over_run_setIE : 1; /* bits 29:29 */
		ca_uint32_t l3fe_nirx_fifo_under_run_setIE : 1; /* bits 30:30 */
		ca_uint32_t l3fe_nirx_fifo_over_run_setIE : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_NIFIFO_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_MISC_INTERRUPT 0xf4304334
#define NI_HV_GLB_MISC_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xge6_link_faultI : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t l2tm_nitx_overrunI : 1; /* bits 2:2 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t c10_dec_asm_fifo_overflowI : 1; /* bits 4:4 */
		ca_uint32_t c10_dec_sep_fifo_overflowI : 1; /* bits 5:5 */
		ca_uint32_t c10_dec_hdr_fifo_overflowI : 1; /* bits 6:6 */
		ca_uint32_t rsrvd3 : 25;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_MISC_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_MISC_INTERRUPTE 0xf4304338
#define NI_HV_GLB_MISC_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xge6_link_faultIE : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t l2tm_nitx_overrunIE : 1; /* bits 2:2 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t c10_dec_asm_fifo_overflowIE : 1; /* bits 4:4 */
		ca_uint32_t c10_dec_sep_fifo_overflowIE : 1; /* bits 5:5 */
		ca_uint32_t c10_dec_hdr_fifo_overflowIE : 1; /* bits 6:6 */
		ca_uint32_t rsrvd3 : 25;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_MISC_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXEM_INTERRUPT 0xf430433c
#define NI_HV_GLB_TXEM_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txem_ififo_ovfI : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t txrm_cntovfI : 1; /* bits 2:2 */
		ca_uint32_t txmib_fifo_ovfI : 1; /* bits 3:3 */
		ca_uint32_t rxmib_fifo_ovfI : 1; /* bits 4:4 */
		ca_uint32_t txem_ptp_voqchg_errI : 1; /* bits 5:5 */
		ca_uint32_t txem_ptp_cachevoq_errI : 1; /* bits 6:6 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t txem_ptp_v6csum0_errI : 1; /* bits 9:9 */
		ca_uint32_t txrm_timerexpI : 1; /* bits 10:10 */
		ca_uint32_t nitx_crc_errI : 1; /* bits 11:11 */
		ca_uint32_t rsrvd3 : 20;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXEM_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_TXEM_INTERRUPTE 0xf4304340
#define NI_HV_GLB_TXEM_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txem_ififo_ovfIE : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t txrm_cntovfIE : 1; /* bits 2:2 */
		ca_uint32_t txmib_fifo_ovfIE : 1; /* bits 3:3 */
		ca_uint32_t rxmib_fifo_ovfIE : 1; /* bits 4:4 */
		ca_uint32_t txem_ptp_voqchg_errIE : 1; /* bits 5:5 */
		ca_uint32_t txem_ptp_cachevoq_errIE : 1; /* bits 6:6 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t txem_ptp_v6csum0_errIE : 1; /* bits 9:9 */
		ca_uint32_t txrm_timerexpIE : 1; /* bits 10:10 */
		ca_uint32_t nitx_crc_errIE : 1; /* bits 11:11 */
		ca_uint32_t rsrvd3 : 20;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_TXEM_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC0_INTERRUPT 0xf4304344
#define NI_HV_GLB_PC0_INTERRUPT_STRIDE 8
#define NI_HV_GLB_PC0_INTERRUPT_COUNT 5
#define NI_HV_GLB_PC0_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dchkoutofsyncI : 1; /* bits 0:0 */
		ca_uint32_t dstaddrmismatchI : 1; /* bits 1:1 */
		ca_uint32_t srcaddrmismatchI : 1; /* bits 2:2 */
		ca_uint32_t vlan1fieldmismatchI : 1; /* bits 3:3 */
		ca_uint32_t vlan2fieldmismatchI : 1; /* bits 4:4 */
		ca_uint32_t typefieldmismatchI : 1; /* bits 5:5 */
		ca_uint32_t seqnummismatchI : 1; /* bits 6:6 */
		ca_uint32_t datamismatchI : 1; /* bits 7:7 */
		ca_uint32_t framelenmismatchI : 1; /* bits 8:8 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC0_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PC0_INTERRUPTE 0xf4304348
#define NI_HV_GLB_PC0_INTERRUPTE_STRIDE 8
#define NI_HV_GLB_PC0_INTERRUPTE_COUNT 5
#define NI_HV_GLB_PC0_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dchkoutofsyncIE : 1; /* bits 0:0 */
		ca_uint32_t dstaddrmismatchIE : 1; /* bits 1:1 */
		ca_uint32_t srcaddrmismatchIE : 1; /* bits 2:2 */
		ca_uint32_t vlan1fieldmismatchIE : 1; /* bits 3:3 */
		ca_uint32_t vlan2fieldmismatchIE : 1; /* bits 4:4 */
		ca_uint32_t typefieldmismatchIE : 1; /* bits 5:5 */
		ca_uint32_t seqnummismatchIE : 1; /* bits 6:6 */
		ca_uint32_t datamismatchIE : 1; /* bits 7:7 */
		ca_uint32_t framelenmismatchIE : 1; /* bits 8:8 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PC0_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPUXRAM_CNTR_INTERRUPT 0xf430436c
#define NI_HV_GLB_CPUXRAM_CNTR_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_drop_err_0_cntmsb_setI : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 9;
		ca_uint32_t pkt_to_xram_0_cntmsb_setI : 1; /* bits 10:10 */
		ca_uint32_t rsrvd2 : 9;
		ca_uint32_t byt_to_xram_0_cntmsb_setI : 1; /* bits 20:20 */
		ca_uint32_t rsrvd3 : 8;
		ca_uint32_t dma_pkt_to_cpu_cntmsb_setI : 1; /* bits 29:29 */
		ca_uint32_t dma_byte_to_cpu_cntmsb_setI : 1; /* bits 30:30 */
		ca_uint32_t rsrvd4 : 1;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPUXRAM_CNTR_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPUXRAM_CNTR_INTERRUPTE 0xf4304370
#define NI_HV_GLB_CPUXRAM_CNTR_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_drop_err_0_cntmsb_setIE : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 9;
		ca_uint32_t pkt_to_xram_0_cntmsb_setIE : 1; /* bits 10:10 */
		ca_uint32_t rsrvd2 : 9;
		ca_uint32_t byt_to_xram_0_cntmsb_setIE : 1; /* bits 20:20 */
		ca_uint32_t rsrvd3 : 8;
		ca_uint32_t dma_pkt_to_cpu_cntmsb_setIE : 1; /* bits 29:29 */
		ca_uint32_t dma_byte_to_cpu_cntmsb_setIE : 1; /* bits 30:30 */
		ca_uint32_t rsrvd4 : 1;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPUXRAM_CNTR_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPUXRAM_ERR_INTERRUPT 0xf4304374
#define NI_HV_GLB_CPUXRAM_ERR_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xram_rx_0_ptrbkupI : 1; /* bits 0:0 */
		ca_uint32_t xram_rx_no_hdrAI : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t xram_rx_mgmtfifo_overrunI : 1; /* bits 22:22 */
		ca_uint32_t dma_fifo_overrunI : 1; /* bits 23:23 */
		ca_uint32_t rsrvd2 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPUXRAM_ERR_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPUXRAM_ERR_INTERRUPTE 0xf4304378
#define NI_HV_GLB_CPUXRAM_ERR_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xram_rx_0_ptrbkupIE : 1; /* bits 0:0 */
		ca_uint32_t xram_rx_no_hdrAIE : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 20;
		ca_uint32_t xram_rx_mgmtfifo_overrunIE : 1; /* bits 22:22 */
		ca_uint32_t dma_fifo_overrunIE : 1; /* bits 23:23 */
		ca_uint32_t rsrvd2 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPUXRAM_ERR_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PTP_INTERRUPT 0xf430437c
#define NI_HV_GLB_PTP_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port0_tx_timestamp_rdy_intI : 1; /* bits 0:0 */
		ca_uint32_t port1_tx_timestamp_rdy_intI : 1; /* bits 1:1 */
		ca_uint32_t port2_tx_timestamp_rdy_intI : 1; /* bits 2:2 */
		ca_uint32_t port3_tx_timestamp_rdy_intI : 1; /* bits 3:3 */
		ca_uint32_t port4_tx_timestamp_rdy_intI : 1; /* bits 4:4 */
		ca_uint32_t port5_tx_timestamp_rdy_intI : 1; /* bits 5:5 */
		ca_uint32_t port6_tx_timestamp_rdy_intI : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t port0_tx_ptpfifo_overflow_intI : 1; /* bits 8:8 */
		ca_uint32_t port1_tx_ptpfifo_overflow_intI : 1; /* bits 9:9 */
		ca_uint32_t port2_tx_ptpfifo_overflow_intI : 1; /* bits 10:10 */
		ca_uint32_t port3_tx_ptpfifo_overflow_intI : 1; /* bits 11:11 */
		ca_uint32_t port4_tx_ptpfifo_overflow_intI : 1; /* bits 12:12 */
		ca_uint32_t port5_tx_ptpfifo_overflow_intI : 1; /* bits 13:13 */
		ca_uint32_t port6_tx_ptpfifo_overflow_intI : 1; /* bits 14:14 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t port0_tx_ptpfifo_underflow_intI : 1; /* bits 16:16 */
		ca_uint32_t port1_tx_ptpfifo_underflow_intI : 1; /* bits 17:17 */
		ca_uint32_t port2_tx_ptpfifo_underflow_intI : 1; /* bits 18:18 */
		ca_uint32_t port3_tx_ptpfifo_underflow_intI : 1; /* bits 19:19 */
		ca_uint32_t port4_tx_ptpfifo_underflow_intI : 1; /* bits 20:20 */
		ca_uint32_t port5_tx_ptpfifo_underflow_intI : 1; /* bits 21:21 */
		ca_uint32_t port6_tx_ptpfifo_underflow_intI : 1; /* bits 22:22 */
		ca_uint32_t rsrvd3 : 6;
		ca_uint32_t timer_rollover_intI : 1; /* bits 29:29 */
		ca_uint32_t pps_event_intI : 1; /* bits 30:30 */
		ca_uint32_t pps_out_falledge_intI : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PTP_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_PTP_INTERRUPTE 0xf4304380
#define NI_HV_GLB_PTP_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port0_tx_timestamp_rdy_intIE : 1; /* bits 0:0 */
		ca_uint32_t port1_tx_timestamp_rdy_intIE : 1; /* bits 1:1 */
		ca_uint32_t port2_tx_timestamp_rdy_intIE : 1; /* bits 2:2 */
		ca_uint32_t port3_tx_timestamp_rdy_intIE : 1; /* bits 3:3 */
		ca_uint32_t port4_tx_timestamp_rdy_intIE : 1; /* bits 4:4 */
		ca_uint32_t port5_tx_timestamp_rdy_intIE : 1; /* bits 5:5 */
		ca_uint32_t port6_tx_timestamp_rdy_intIE : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t port0_tx_ptpfifo_overflow_intIE : 1; /* bits 8:8 */
		ca_uint32_t port1_tx_ptpfifo_overflow_intIE : 1; /* bits 9:9 */
		ca_uint32_t port2_tx_ptpfifo_overflow_intIE : 1; /* bits 10:10 */
		ca_uint32_t port3_tx_ptpfifo_overflow_intIE : 1; /* bits 11:11 */
		ca_uint32_t port4_tx_ptpfifo_overflow_intIE : 1; /* bits 12:12 */
		ca_uint32_t port5_tx_ptpfifo_overflow_intIE : 1; /* bits 13:13 */
		ca_uint32_t port6_tx_ptpfifo_overflow_intIE : 1; /* bits 14:14 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t port0_tx_ptpfifo_underflow_intIE : 1; /* bits 16:16 */
		ca_uint32_t port1_tx_ptpfifo_underflow_intIE : 1; /* bits 17:17 */
		ca_uint32_t port2_tx_ptpfifo_underflow_intIE : 1; /* bits 18:18 */
		ca_uint32_t port3_tx_ptpfifo_underflow_intIE : 1; /* bits 19:19 */
		ca_uint32_t port4_tx_ptpfifo_underflow_intIE : 1; /* bits 20:20 */
		ca_uint32_t port5_tx_ptpfifo_underflow_intIE : 1; /* bits 21:21 */
		ca_uint32_t port6_tx_ptpfifo_underflow_intIE : 1; /* bits 22:22 */
		ca_uint32_t rsrvd3 : 6;
		ca_uint32_t timer_rollover_intIE : 1; /* bits 29:29 */
		ca_uint32_t pps_event_intIE : 1; /* bits 30:30 */
		ca_uint32_t pps_out_falledge_intIE : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_PTP_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPT 0xf4304384
#define NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xram_rx_doneI : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPTE 0xf4304388
#define NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xram_rx_doneIE : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPT 0xf430438c
#define NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xram_tx_0_doneI : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPTE 0xf4304390
#define NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xram_tx_0_doneIE : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_MC_INTERRUPT 0xf4304394
#define NI_HV_GLB_MC_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t mc_ff_full_drop_intI : 1; /* bits 1:1 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t bitmap_zero_drop_intI : 1; /* bits 3:3 */
		ca_uint32_t rsrvd3 : 28;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_MC_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_MC_INTERRUPTE 0xf4304398
#define NI_HV_GLB_MC_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t mc_ff_full_drop_intIE : 1; /* bits 1:1 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t bitmap_zero_drop_intIE : 1; /* bits 3:3 */
		ca_uint32_t rsrvd3 : 28;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_MC_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_INTERRUPT 0xf430439c
#define NI_HV_GLB_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t int_stat_pspid_0 : 1; /* bits 0:0 */
		ca_uint32_t int_stat_pspid_1 : 1; /* bits 1:1 */
		ca_uint32_t int_stat_pspid_2 : 1; /* bits 2:2 */
		ca_uint32_t int_stat_pspid_3 : 1; /* bits 3:3 */
		ca_uint32_t int_stat_pspid_4 : 1; /* bits 4:4 */
		ca_uint32_t int_stat_pspid_5 : 1; /* bits 5:5 */
		ca_uint32_t int_stat_pspid_6 : 1; /* bits 6:6 */
		ca_uint32_t int_stat_pspid_7 : 1; /* bits 7:7 */
		ca_uint32_t int_stat_pspid_8 : 1; /* bits 8:8 */
		ca_uint32_t int_stat_pspid_9 : 1; /* bits 9:9 */
		ca_uint32_t int_stat_pspid_10 : 1; /* bits 10:10 */
		ca_uint32_t int_stat_pspid_11 : 1; /* bits 11:11 */
		ca_uint32_t macsec_de_int : 1; /* bits 12:12 */
		ca_uint32_t xge6_int : 1; /* bits 13:13 */
		ca_uint32_t xaui_int : 1; /* bits 14:14 */
		ca_uint32_t macsec_en_int : 1; /* bits 15:15 */
		ca_uint32_t int_stat_txem : 1; /* bits 16:16 */
		ca_uint32_t int_stat_pc0 : 1; /* bits 17:17 */
		ca_uint32_t int_stat_pc1 : 1; /* bits 18:18 */
		ca_uint32_t int_stat_pc2 : 1; /* bits 19:19 */
		ca_uint32_t int_stat_pc3 : 1; /* bits 20:20 */
		ca_uint32_t int_stat_pc4 : 1; /* bits 21:21 */
		ca_uint32_t sxgmii6_int : 1; /* bits 22:22 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t misc : 1; /* bits 24:24 */
		ca_uint32_t cpuxram_int_stat_cntr : 1; /* bits 25:25 */
		ca_uint32_t cpuxram_int_stat_err : 1; /* bits 26:26 */
		ca_uint32_t int_stat_ptp : 1; /* bits 27:27 */
		ca_uint32_t int_stat_mceng : 1; /* bits 28:28 */
		ca_uint32_t cpuxram_rxpkt : 1; /* bits 29:29 */
		ca_uint32_t cpuxram_txpkt : 1; /* bits 30:30 */
		ca_uint32_t ni_fifo : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_INTERRUPTE 0xf43043a0
#define NI_HV_GLB_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t int_stat_pspid_0E : 1; /* bits 0:0 */
		ca_uint32_t int_stat_pspid_1E : 1; /* bits 1:1 */
		ca_uint32_t int_stat_pspid_2E : 1; /* bits 2:2 */
		ca_uint32_t int_stat_pspid_3E : 1; /* bits 3:3 */
		ca_uint32_t int_stat_pspid_4E : 1; /* bits 4:4 */
		ca_uint32_t int_stat_pspid_5E : 1; /* bits 5:5 */
		ca_uint32_t int_stat_pspid_6E : 1; /* bits 6:6 */
		ca_uint32_t int_stat_pspid_7E : 1; /* bits 7:7 */
		ca_uint32_t int_stat_pspid_8E : 1; /* bits 8:8 */
		ca_uint32_t int_stat_pspid_9E : 1; /* bits 9:9 */
		ca_uint32_t int_stat_pspid_10E : 1; /* bits 10:10 */
		ca_uint32_t int_stat_pspid_11E : 1; /* bits 11:11 */
		ca_uint32_t macsec_de_intE : 1; /* bits 12:12 */
		ca_uint32_t xge6_intE : 1; /* bits 13:13 */
		ca_uint32_t xaui_intE : 1; /* bits 14:14 */
		ca_uint32_t macsec_en_intE : 1; /* bits 15:15 */
		ca_uint32_t int_stat_txemE : 1; /* bits 16:16 */
		ca_uint32_t int_stat_pc0E : 1; /* bits 17:17 */
		ca_uint32_t int_stat_pc1E : 1; /* bits 18:18 */
		ca_uint32_t int_stat_pc2E : 1; /* bits 19:19 */
		ca_uint32_t int_stat_pc3E : 1; /* bits 20:20 */
		ca_uint32_t int_stat_pc4E : 1; /* bits 21:21 */
		ca_uint32_t sxgmii6_intE : 1; /* bits 22:22 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t miscE : 1; /* bits 24:24 */
		ca_uint32_t cpuxram_int_stat_cntrE : 1; /* bits 25:25 */
		ca_uint32_t cpuxram_int_stat_errE : 1; /* bits 26:26 */
		ca_uint32_t int_stat_ptpE : 1; /* bits 27:27 */
		ca_uint32_t int_stat_mcengE : 1; /* bits 28:28 */
		ca_uint32_t cpuxram_rxpktE : 1; /* bits 29:29 */
		ca_uint32_t cpuxram_txpktE : 1; /* bits 30:30 */
		ca_uint32_t ni_fifoE : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_ETH_TX_MISC_CFG 0xf43043a4
#define NI_HV_GLB_ETH_TX_MISC_CFG_dft 0x00002020

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rdy_low_thld_ge : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rdy_high_thld_ge : 9; /* bits 18:10 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t rdy_low_thld_fe : 5; /* bits 24:20 */
		ca_uint32_t rsrvd3 : 2;
		ca_uint32_t rdy_high_thld_fe : 5; /* bits 31:27 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_ETH_TX_MISC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_DEBUG_2 0xf43043a8
#define NI_HV_GLB_DEBUG_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dbg_ptp_hw_cnt : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ptp_hw_cnt_dbg : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_DEBUG_2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_DEBUG_3 0xf43043ac
#define NI_HV_GLB_DEBUG_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sel : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_DEBUG_3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_VENUS_MISC_CFG 0xf43043b0
#define NI_HV_GLB_VENUS_MISC_CFG_dft 0x00000010

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xge7_rxfifo_almost_full_thre : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t xge7_cpu_tag_tx_en : 1; /* bits 10:10 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t xge7_cpu_tag_cfg_sel : 1; /* bits 12:12 */
		ca_uint32_t xge6_cpu_tag_tx_en : 1; /* bits 13:13 */
		ca_uint32_t xge6_cpu_tag_rx_en : 1; /* bits 14:14 */
		ca_uint32_t xge6_cpu_tag_cfg_sel : 1; /* bits 15:15 */
		ca_uint32_t sxgmii_dbg_sel : 4; /* bits 19:16 */
		ca_uint32_t top_dbg_sel : 2; /* bits 21:20 */
		ca_uint32_t rsrvd3 : 10;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_VENUS_MISC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG_CFG 0xf43043b4
#define NI_HV_GLB_CPU_TAG_CFG_dft 0x00048899

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rtk_tag : 16; /* bits 15:0 */
		ca_uint32_t protocol : 8; /* bits 23:16 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_PORT_ID1 0xf43043b8
#define NI_HV_GLB_CPU_TAG0_PORT_ID1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pid1 : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_PORT_ID1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_PORT_ID0 0xf43043bc
#define NI_HV_GLB_CPU_TAG0_PORT_ID0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pid0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_PORT_ID0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_PORT_MASK1 0xf43043c0
#define NI_HV_GLB_CPU_TAG0_PORT_MASK1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port_msk1 : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_PORT_MASK1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_PORT_MASK0 0xf43043c4
#define NI_HV_GLB_CPU_TAG0_PORT_MASK0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port_msk0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_PORT_MASK0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A15 0xf43043c8
#define NI_HV_GLB_CPU_TAG0_HDR_A15_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a15 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A15_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A14 0xf43043cc
#define NI_HV_GLB_CPU_TAG0_HDR_A14_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a14 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A14_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A13 0xf43043d0
#define NI_HV_GLB_CPU_TAG0_HDR_A13_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a13 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A13_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A12 0xf43043d4
#define NI_HV_GLB_CPU_TAG0_HDR_A12_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a12 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A12_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A11 0xf43043d8
#define NI_HV_GLB_CPU_TAG0_HDR_A11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a11 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A11_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A10 0xf43043dc
#define NI_HV_GLB_CPU_TAG0_HDR_A10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a10 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A10_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A9 0xf43043e0
#define NI_HV_GLB_CPU_TAG0_HDR_A9_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a9 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A9_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A8 0xf43043e4
#define NI_HV_GLB_CPU_TAG0_HDR_A8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a8 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A8_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A7 0xf43043e8
#define NI_HV_GLB_CPU_TAG0_HDR_A7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a7 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A7_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A6 0xf43043ec
#define NI_HV_GLB_CPU_TAG0_HDR_A6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a6 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A6_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A5 0xf43043f0
#define NI_HV_GLB_CPU_TAG0_HDR_A5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a5 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A4 0xf43043f4
#define NI_HV_GLB_CPU_TAG0_HDR_A4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a4 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A3 0xf43043f8
#define NI_HV_GLB_CPU_TAG0_HDR_A3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a3 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A2 0xf43043fc
#define NI_HV_GLB_CPU_TAG0_HDR_A2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A1 0xf4304400
#define NI_HV_GLB_CPU_TAG0_HDR_A1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG0_HDR_A0 0xf4304404
#define NI_HV_GLB_CPU_TAG0_HDR_A0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG0_HDR_A0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_PORT_ID1 0xf4304408
#define NI_HV_GLB_CPU_TAG1_PORT_ID1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pid1 : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_PORT_ID1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_PORT_ID0 0xf430440c
#define NI_HV_GLB_CPU_TAG1_PORT_ID0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pid0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_PORT_ID0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_PORT_MASK1 0xf4304410
#define NI_HV_GLB_CPU_TAG1_PORT_MASK1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port_msk1 : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_PORT_MASK1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_PORT_MASK0 0xf4304414
#define NI_HV_GLB_CPU_TAG1_PORT_MASK0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t port_msk0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_PORT_MASK0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A15 0xf4304418
#define NI_HV_GLB_CPU_TAG1_HDR_A15_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a15 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A15_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A14 0xf430441c
#define NI_HV_GLB_CPU_TAG1_HDR_A14_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a14 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A14_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A13 0xf4304420
#define NI_HV_GLB_CPU_TAG1_HDR_A13_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a13 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A13_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A12 0xf4304424
#define NI_HV_GLB_CPU_TAG1_HDR_A12_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a12 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A12_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A11 0xf4304428
#define NI_HV_GLB_CPU_TAG1_HDR_A11_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a11 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A11_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A10 0xf430442c
#define NI_HV_GLB_CPU_TAG1_HDR_A10_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a10 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A10_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A9 0xf4304430
#define NI_HV_GLB_CPU_TAG1_HDR_A9_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a9 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A9_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A8 0xf4304434
#define NI_HV_GLB_CPU_TAG1_HDR_A8_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a8 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A8_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A7 0xf4304438
#define NI_HV_GLB_CPU_TAG1_HDR_A7_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a7 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A7_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A6 0xf430443c
#define NI_HV_GLB_CPU_TAG1_HDR_A6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a6 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A6_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A5 0xf4304440
#define NI_HV_GLB_CPU_TAG1_HDR_A5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a5 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A4 0xf4304444
#define NI_HV_GLB_CPU_TAG1_HDR_A4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a4 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A3 0xf4304448
#define NI_HV_GLB_CPU_TAG1_HDR_A3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a3 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A2 0xf430444c
#define NI_HV_GLB_CPU_TAG1_HDR_A2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A1 0xf4304450
#define NI_HV_GLB_CPU_TAG1_HDR_A1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG1_HDR_A0 0xf4304454
#define NI_HV_GLB_CPU_TAG1_HDR_A0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr_a0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG1_HDR_A0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG_P5_DEFAULT_HEADER_CFG1 0xf4304458
#define NI_HV_GLB_CPU_TAG_P5_DEFAULT_HEADER_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t default_hdr_a1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG_P5_DEFAULT_HEADER_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG_P5_DEFAULT_HEADER_CFG0 0xf430445c
#define NI_HV_GLB_CPU_TAG_P5_DEFAULT_HEADER_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t default_hdr_a0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG_P5_DEFAULT_HEADER_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG_P6_DEFAULT_HEADER_CFG1 0xf4304460
#define NI_HV_GLB_CPU_TAG_P6_DEFAULT_HEADER_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t default_hdr_a1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG_P6_DEFAULT_HEADER_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CPU_TAG_P6_DEFAULT_HEADER_CFG0 0xf4304464
#define NI_HV_GLB_CPU_TAG_P6_DEFAULT_HEADER_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t default_hdr_a0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CPU_TAG_P6_DEFAULT_HEADER_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG11 0xf4304468
#define NI_HV_GLB_SRAMTEST_CFG11_dft 0x00002222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni1_ctl1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG11_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG10 0xf430446c
#define NI_HV_GLB_SRAMTEST_CFG10_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni1_ctl0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG10_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG21 0xf4304470
#define NI_HV_GLB_SRAMTEST_CFG21_dft 0x00000022

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni2_ctl1 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG21_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG20 0xf4304474
#define NI_HV_GLB_SRAMTEST_CFG20_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni2_ctl0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG20_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG32 0xf4304478
#define NI_HV_GLB_SRAMTEST_CFG32_dft 0x00000022

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni3_ctl2 : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 24;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG32_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG31 0xf430447c
#define NI_HV_GLB_SRAMTEST_CFG31_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni3_ctl1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG31_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG30 0xf4304480
#define NI_HV_GLB_SRAMTEST_CFG30_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni3_ctl0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG30_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG4 0xf4304484
#define NI_HV_GLB_SRAMTEST_CFG4_dft 0x00222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni4_ctl : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG5 0xf4304488
#define NI_HV_GLB_SRAMTEST_CFG5_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni5_ctl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG6 0xf430448c
#define NI_HV_GLB_SRAMTEST_CFG6_dft 0x22222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni6_ctl : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG6_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG7 0xf4304490
#define NI_HV_GLB_SRAMTEST_CFG7_dft 0x00222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni_xaui1_ctl : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG7_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMTEST_CFG8 0xf4304494
#define NI_HV_GLB_SRAMTEST_CFG8_dft 0x00222222

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni_xram_ctl : 8; /* bits 7:0 */
		ca_uint32_t ni_xaui2_ctl : 16; /* bits 23:8 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMTEST_CFG8_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMLS_CFG0 0xf4304498
#define NI_HV_GLB_SRAMLS_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni1_sramls : 6; /* bits 5:0 */
		ca_uint32_t ni2_sramls : 5; /* bits 10:6 */
		ca_uint32_t ni3_sramls : 9; /* bits 19:11 */
		ca_uint32_t ni4_sramls : 6; /* bits 25:20 */
		ca_uint32_t ni5_sramls : 4; /* bits 29:26 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMLS_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_SRAMLS_CFG1 0xf430449c
#define NI_HV_GLB_SRAMLS_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ni6_sramls : 4; /* bits 3:0 */
		ca_uint32_t ni_xaui1_sramls : 3; /* bits 6:4 */
		ca_uint32_t ni_xaui2_sramls : 4; /* bits 10:7 */
		ca_uint32_t ni_xram_sramls : 1; /* bits 11:11 */
		ca_uint32_t rsrvd1 : 20;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_SRAMLS_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_THROTTLE_CNTL 0xf43044a0
#define NI_HV_GLB_CLK_THROTTLE_CNTL_dft 0x00000014

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t max_period : 5; /* bits 4:0 */
		ca_uint32_t lpf_mode : 2; /* bits 6:5 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t sw_thresh : 21; /* bits 31:11 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_THROTTLE_CNTL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_LUT_0 0xf43044a4
#define NI_HV_GLB_CLK_LUT_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lut_vec_0 : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_LUT_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_LUT_1 0xf43044a8
#define NI_HV_GLB_CLK_LUT_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lut_vec_1 : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_LUT_1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_LUT_2 0xf43044ac
#define NI_HV_GLB_CLK_LUT_2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lut_vec_2 : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_LUT_2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_LUT_3 0xf43044b0
#define NI_HV_GLB_CLK_LUT_3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lut_vec_3 : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_LUT_3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_LUT_4 0xf43044b4
#define NI_HV_GLB_CLK_LUT_4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lut_vec_4 : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_LUT_4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_LUT_5 0xf43044b8
#define NI_HV_GLB_CLK_LUT_5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lut_vec_5 : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_LUT_5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_LUT_6 0xf43044bc
#define NI_HV_GLB_CLK_LUT_6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lut_vec_6 : 30; /* bits 29:0 */
		ca_uint32_t rsrvd1 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_LUT_6_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_DIV_0 0xf43044c0
#define NI_HV_GLB_CLK_DIV_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t div_setting_0 : 7; /* bits 6:0 */
		ca_uint32_t div_setting_1 : 7; /* bits 13:7 */
		ca_uint32_t div_setting_2 : 7; /* bits 20:14 */
		ca_uint32_t div_setting_3 : 7; /* bits 27:21 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_DIV_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_DIV_1 0xf43044c4
#define NI_HV_GLB_CLK_DIV_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t div_setting_4 : 7; /* bits 6:0 */
		ca_uint32_t div_setting_5 : 7; /* bits 13:7 */
		ca_uint32_t div_setting_6 : 7; /* bits 20:14 */
		ca_uint32_t div_setting_7 : 7; /* bits 27:21 */
		ca_uint32_t rsrvd1 : 4;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_DIV_1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_CLK_MAX_TRAP 0xf43044c8
#define NI_HV_GLB_CLK_MAX_TRAP_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t max_trap : 21; /* bits 20:0 */
		ca_uint32_t rsrvd1 : 11;
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_CLK_MAX_TRAP_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_GLB_C10_DEC_IN_RATE_CFG 0xf43044cc
#define NI_HV_GLB_C10_DEC_IN_RATE_CFG_dft 0xa8aa8aa8

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rate : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_GLB_C10_DEC_IN_RATE_CFG_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
#ifndef __ASSEMBLER__
typedef struct {
	NI_HV_GLB_REVISION_t REVISION; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	NI_HV_GLB_INIT_DONE_t INIT_DONE; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	NI_HV_GLB_INTF_RST_CONFIG_t INTF_RST_CONFIG; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	NI_HV_GLB_STATIC_CFG_t STATIC_CFG; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	NI_HV_GLB_VENUS_CORESEC10_CFG_t VENUS_CORESEC10_CFG; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	NI_HV_GLB_MAC_ADDR_CFG0_t MAC_ADDR_CFG0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	NI_HV_GLB_MAC_ADDR_CFG1_t MAC_ADDR_CFG1; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	NI_HV_GLB_WOL_PASSWD_0_t WOL_PASSWD_0; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	NI_HV_GLB_WOL_PASSWD_1_t WOL_PASSWD_1; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	NI_HV_GLB_PKT_LEN_CFG_t PKT_LEN_CFG; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	NI_HV_GLB_PKT_STOR_LEN_CFG_t PKT_STOR_LEN_CFG; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	NI_HV_GLB_P5_BYPASS_CFG_t P5_BYPASS_CFG; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	NI_HV_GLB_XGE_BYPASS_CFG_t XGE_BYPASS_CFG; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	NI_HV_GLB_XGE6_RXPAUSE_CFG_t XGE6_RXPAUSE_CFG; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	NI_HV_GLB_XGE7_RXFIFO_THRESHOLD_t
	  XGE7_RXFIFO_THRESHOLD; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	NI_HV_GLB_XGE6_MAC_CFG1_t XGE6_MAC_CFG1; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	NI_HV_GLB_XGE6_MAC_CFG0_t XGE6_MAC_CFG0; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	NI_HV_GLB_XGE6_FLOW_CONTROL_CFG_t
	  XGE6_FLOW_CONTROL_CFG; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	NI_HV_GLB_XGE6_TX_REPEAT_CNT_t XGE6_TX_REPEAT_CNT; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	NI_HV_GLB_XGE6_TX_QUANTA0_t XGE6_TX_QUANTA0; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	NI_HV_GLB_XGE6_TX_QUANTA1_t XGE6_TX_QUANTA1; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	NI_HV_GLB_XGE6_TX_QUANTA2_t XGE6_TX_QUANTA2; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	NI_HV_GLB_XGE6_TX_QUANTA3_t XGE6_TX_QUANTA3; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	NI_HV_GLB_XGE6_QBB_WAIT_TIME_t XGE6_QBB_WAIT_TIME; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT_t
	  XGE6_RX_FLOW_CTRL_PKT_CNT; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT_t
	  XGE6_RX_FAKE_PAUS_PKT_CNT; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT_t
	  XGE6_TX_FLOW_CTRL_PKT_CNT; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG1_t
	  RXMUX_INTPT_CALENDAR_CFG1; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG0_t
	  RXMUX_INTPT_CALENDAR_CFG0; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[3];
	NI_HV_GLB_RXMUX_CTRL_CFG_t RXMUX_CTRL_CFG; /* addr: 0x00000074 */
	ca_uint32_t rsrvd30[3];
	NI_HV_GLB_RXMUX_LAST_HDR_A2_t RXMUX_LAST_HDR_A2; /* addr: 0x00000078 */
	ca_uint32_t rsrvd31[3];
	NI_HV_GLB_RXMUX_LAST_HDR_A1_t RXMUX_LAST_HDR_A1; /* addr: 0x0000007c */
	ca_uint32_t rsrvd32[3];
	NI_HV_GLB_RXMUX_LAST_HDR_A0_t RXMUX_LAST_HDR_A0; /* addr: 0x00000080 */
	ca_uint32_t rsrvd33[3];
	NI_HV_GLB_RXMUX_PKTCNT_t RXMUX_PKTCNT; /* addr: 0x00000084 */
	ca_uint32_t rsrvd34[3];
	NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_t
	  RXMUX_PORT0_FC_THRESHOLD_CFG; /* addr: 0x00000088 */
	ca_uint32_t rsrvd35[47];
	NI_HV_GLB_RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000b8 */
	ca_uint32_t rsrvd36[3];
	NI_HV_GLB_RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000bc */
	ca_uint32_t rsrvd37[3];
	NI_HV_GLB_RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000c0 */
	ca_uint32_t rsrvd38[3];
	NI_HV_GLB_RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000c4 */
	ca_uint32_t rsrvd39[3];
	NI_HV_GLB_RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000c8 */
	ca_uint32_t rsrvd40[3];
	NI_HV_GLB_RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000cc */
	ca_uint32_t rsrvd41[3];
	NI_HV_GLB_RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000d0 */
	ca_uint32_t rsrvd42[3];
	NI_HV_GLB_RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000d4 */
	ca_uint32_t rsrvd43[3];
	NI_HV_GLB_RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000d8 */
	ca_uint32_t rsrvd44[3];
	NI_HV_GLB_RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000dc */
	ca_uint32_t rsrvd45[3];
	NI_HV_GLB_RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000e0 */
	ca_uint32_t rsrvd46[3];
	NI_HV_GLB_RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t
	  RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000e4 */
	ca_uint32_t rsrvd47[3];
	NI_HV_GLB_RX_SEG_BUFSIZE_UPDATE_t
	  RX_SEG_BUFSIZE_UPDATE; /* addr: 0x000000e8 */
	ca_uint32_t rsrvd48[3];
	NI_HV_GLB_RX_SEG_VLAN_TAG_INSERT_CFG_t
	  RX_SEG_VLAN_TAG_INSERT_CFG; /* addr: 0x000000ec */
	ca_uint32_t rsrvd49[3];
	NI_HV_GLB_RXMUX_HDR_BUF_STATUS_t RXMUX_HDR_BUF_STATUS; /* addr: 0x000000f0 */
	ca_uint32_t rsrvd50[3];
	NI_HV_GLB_RXMUX_DATA_BUF_STATUS_t
	  RXMUX_DATA_BUF_STATUS; /* addr: 0x000000f4 */
	ca_uint32_t rsrvd51[3];
	NI_HV_GLB_RXMUX_DBG_CFG_t RXMUX_DBG_CFG; /* addr: 0x000000f8 */
	ca_uint32_t rsrvd52[3];
	NI_HV_GLB_RXMUX_OUT_CNT0_t RXMUX_OUT_CNT0; /* addr: 0x000000fc */
	ca_uint32_t rsrvd53[3];
	NI_HV_GLB_RXMUX_OUT_CNT1_t RXMUX_OUT_CNT1; /* addr: 0x00000100 */
	ca_uint32_t rsrvd54[3];
	NI_HV_GLB_RXMUX_OUT_DRPCNT0_t RXMUX_OUT_DRPCNT0; /* addr: 0x00000104 */
	ca_uint32_t rsrvd55[3];
	NI_HV_GLB_RXMUX_OUT_DRPCNT1_t RXMUX_OUT_DRPCNT1; /* addr: 0x00000108 */
	ca_uint32_t rsrvd56[3];
	NI_HV_GLB_NIRX_XRAM_STS_t NIRX_XRAM_STS; /* addr: 0x0000010c */
	ca_uint32_t rsrvd57[3];
	NI_HV_GLB_NIRX_L3QM_STS_t NIRX_L3QM_STS; /* addr: 0x00000110 */
	ca_uint32_t rsrvd58[3];
	NI_HV_GLB_NIRX_L3FE_STS_t NIRX_L3FE_STS; /* addr: 0x00000114 */
	ca_uint32_t rsrvd59[3];
	NI_HV_GLB_P0_RX_DROPCNT_t P0_RX_DROPCNT; /* addr: 0x00000118 */
	ca_uint32_t rsrvd60[27];
	NI_HV_GLB_P0_TX_SHARE_FIFO_BASE_CFG_t
	  P0_TX_SHARE_FIFO_BASE_CFG; /* addr: 0x00000134 */
	ca_uint32_t rsrvd61[3];
	NI_HV_GLB_P1_TX_SHARE_FIFO_BASE_CFG_t
	  P1_TX_SHARE_FIFO_BASE_CFG; /* addr: 0x00000138 */
	ca_uint32_t rsrvd62[3];
	NI_HV_GLB_P2_TX_SHARE_FIFO_BASE_CFG_t
	  P2_TX_SHARE_FIFO_BASE_CFG; /* addr: 0x0000013c */
	ca_uint32_t rsrvd63[3];
	NI_HV_GLB_P3_TX_SHARE_FIFO_BASE_CFG_t
	  P3_TX_SHARE_FIFO_BASE_CFG; /* addr: 0x00000140 */
	ca_uint32_t rsrvd64[3];
	NI_HV_GLB_P4_TX_SHARE_FIFO_BASE_CFG_t
	  P4_TX_SHARE_FIFO_BASE_CFG; /* addr: 0x00000144 */
	ca_uint32_t rsrvd65[3];
	NI_HV_GLB_MCE_TX_SHARE_FIFO_BASE_CFG_t
	  MCE_TX_SHARE_FIFO_BASE_CFG; /* addr: 0x00000148 */
	ca_uint32_t rsrvd66[3];
	NI_HV_GLB_PG_DA_CFG0_t PG_DA_CFG0; /* addr: 0x0000014c */
	ca_uint32_t rsrvd67[3];
	NI_HV_GLB_PG_DA_CFG1_t PG_DA_CFG1; /* addr: 0x00000150 */
	ca_uint32_t rsrvd68[3];
	NI_HV_GLB_PG_SA_CFG0_t PG_SA_CFG0; /* addr: 0x00000154 */
	ca_uint32_t rsrvd69[3];
	NI_HV_GLB_PG_SA_CFG1_t PG_SA_CFG1; /* addr: 0x00000158 */
	ca_uint32_t rsrvd70[3];
	NI_HV_GLB_PG_CFG0_t PG_CFG0; /* addr: 0x0000015c */
	ca_uint32_t rsrvd71[3];
	NI_HV_GLB_PG_CFG1_t PG_CFG1; /* addr: 0x00000160 */
	ca_uint32_t rsrvd72[3];
	NI_HV_GLB_PG_FXPT_CFG_t PG_FXPT_CFG; /* addr: 0x00000164 */
	ca_uint32_t rsrvd73[3];
	NI_HV_GLB_PC_DA1_t PC_DA1; /* addr: 0x00000168 */
	ca_uint32_t rsrvd74[3];
	NI_HV_GLB_PC_DA2_t PC_DA2; /* addr: 0x0000016c */
	ca_uint32_t rsrvd75[3];
	NI_HV_GLB_PC_SA1_t PC_SA1; /* addr: 0x00000170 */
	ca_uint32_t rsrvd76[3];
	NI_HV_GLB_PC_SA2_t PC_SA2; /* addr: 0x00000174 */
	ca_uint32_t rsrvd77[3];
	NI_HV_GLB_PC_CFG0_t PC_CFG0; /* addr: 0x00000178 */
	ca_uint32_t rsrvd78[3];
	NI_HV_GLB_PC_CFG1_t PC_CFG1; /* addr: 0x0000017c */
	ca_uint32_t rsrvd79[3];
	NI_HV_GLB_PC_FXPT_t PC_FXPT; /* addr: 0x00000180 */
	ca_uint32_t rsrvd80[3];
	NI_HV_GLB_RM_CFG_t RM_CFG; /* addr: 0x00000184 */
	ca_uint32_t rsrvd81[3];
	NI_HV_GLB_RM_TBMAX_t RM_TBMAX; /* addr: 0x00000188 */
	ca_uint32_t rsrvd82[3];
	NI_HV_GLB_RM_CNTR_t RM_CNTR; /* addr: 0x0000018c */
	ca_uint32_t rsrvd83[3];
	NI_HV_GLB_RM_LASTCNTR_t RM_LASTCNTR; /* addr: 0x00000190 */
	ca_uint32_t rsrvd84[3];
	NI_HV_GLB_RXMIB_ACCESS_t RXMIB_ACCESS; /* addr: 0x00000194 */
	ca_uint32_t rsrvd85[3];
	NI_HV_GLB_RXMIB_DATA1_t RXMIB_DATA1; /* addr: 0x00000198 */
	ca_uint32_t rsrvd86[3];
	NI_HV_GLB_RXMIB_DATA0_t RXMIB_DATA0; /* addr: 0x0000019c */
	ca_uint32_t rsrvd87[3];
	NI_HV_GLB_TXMIB_ACCESS_t TXMIB_ACCESS; /* addr: 0x000001a0 */
	ca_uint32_t rsrvd88[3];
	NI_HV_GLB_TXMIB_DATA1_t TXMIB_DATA1; /* addr: 0x000001a4 */
	ca_uint32_t rsrvd89[3];
	NI_HV_GLB_TXMIB_DATA0_t TXMIB_DATA0; /* addr: 0x000001a8 */
	ca_uint32_t rsrvd90[3];
	NI_HV_GLB_INTERNAL_PORT_ID_CFG_t INTERNAL_PORT_ID_CFG; /* addr: 0x000001ac */
	ca_uint32_t rsrvd91[3];
	NI_HV_GLB_INTERNAL_PORT_ID_CFG2_t
	  INTERNAL_PORT_ID_CFG2; /* addr: 0x000001b0 */
	ca_uint32_t rsrvd92[3];
	NI_HV_GLB_RX_PORT_ID_CFG_t RX_PORT_ID_CFG; /* addr: 0x000001b4 */
	ca_uint32_t rsrvd93[3];
	NI_HV_GLB_RX_PORT_ID_CFG2_t RX_PORT_ID_CFG2; /* addr: 0x000001b8 */
	ca_uint32_t rsrvd94[3];
	NI_HV_GLB_NIRX_L3FE_DEMUX_CFG3_t NIRX_L3FE_DEMUX_CFG3; /* addr: 0x000001bc */
	ca_uint32_t rsrvd95[3];
	NI_HV_GLB_NIRX_L3FE_DEMUX_CFG2_t NIRX_L3FE_DEMUX_CFG2; /* addr: 0x000001c0 */
	ca_uint32_t rsrvd96[3];
	NI_HV_GLB_NIRX_L3FE_DEMUX_CFG1_t NIRX_L3FE_DEMUX_CFG1; /* addr: 0x000001c4 */
	ca_uint32_t rsrvd97[3];
	NI_HV_GLB_NIRX_L3FE_DEMUX_CFG0_t NIRX_L3FE_DEMUX_CFG0; /* addr: 0x000001c8 */
	ca_uint32_t rsrvd98[3];
	NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG3_t
	  NIRX_L3FE_DPQ_DEMUX_CFG3; /* addr: 0x000001cc */
	ca_uint32_t rsrvd99[3];
	NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG2_t
	  NIRX_L3FE_DPQ_DEMUX_CFG2; /* addr: 0x000001d0 */
	ca_uint32_t rsrvd100[3];
	NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG1_t
	  NIRX_L3FE_DPQ_DEMUX_CFG1; /* addr: 0x000001d4 */
	ca_uint32_t rsrvd101[3];
	NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG0_t
	  NIRX_L3FE_DPQ_DEMUX_CFG0; /* addr: 0x000001d8 */
	ca_uint32_t rsrvd102[3];
	NI_HV_GLB_NITX_MISC_CFG_t NITX_MISC_CFG; /* addr: 0x000001dc */
	ca_uint32_t rsrvd103[3];
	NI_HV_GLB_NIRX_MISC_CFG_t NIRX_MISC_CFG; /* addr: 0x000001e0 */
	ca_uint32_t rsrvd104[3];
	NI_HV_GLB_TX_PORT_ID_CFG_t TX_PORT_ID_CFG; /* addr: 0x000001e4 */
	ca_uint32_t rsrvd105[3];
	NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG_t
	  TX_INTERNAL_PORT_ID_CFG; /* addr: 0x000001e8 */
	ca_uint32_t rsrvd106[3];
	NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG2_t
	  TX_INTERNAL_PORT_ID_CFG2; /* addr: 0x000001ec */
	ca_uint32_t rsrvd107[3];
	NI_HV_GLB_NITX_CRCE_CNT_t NITX_CRCE_CNT; /* addr: 0x000001f0 */
	ca_uint32_t rsrvd108[3];
	NI_HV_GLB_NITX_P5_DRAINCNT_t NITX_P5_DRAINCNT; /* addr: 0x000001f4 */
	ca_uint32_t rsrvd109[3];
	NI_HV_GLB_NITX_P6_DRAINCNT_t NITX_P6_DRAINCNT; /* addr: 0x000001f8 */
	ca_uint32_t rsrvd110[3];
	NI_HV_GLB_NITX_P7_DRAINCNT_t NITX_P7_DRAINCNT; /* addr: 0x000001fc */
	ca_uint32_t rsrvd111[3];
	NI_HV_GLB_NITX_OAMERR_CNT_t NITX_OAMERR_CNT; /* addr: 0x00000200 */
	ca_uint32_t rsrvd112[3];
	NI_HV_GLB_TXFIFO_READ_THRESHOLD_t
	  TXFIFO_READ_THRESHOLD; /* addr: 0x00000204 */
	ca_uint32_t rsrvd113[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG1_t
	  TXFIFO_THRESHOLD_XGE7_CFG1; /* addr: 0x00000208 */
	ca_uint32_t rsrvd114[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG2_t
	  TXFIFO_THRESHOLD_XGE7_CFG2; /* addr: 0x0000020c */
	ca_uint32_t rsrvd115[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG1_t
	  TXFIFO_THRESHOLD_L3QM_CFG1; /* addr: 0x00000210 */
	ca_uint32_t rsrvd116[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG2_t
	  TXFIFO_THRESHOLD_L3QM_CFG2; /* addr: 0x00000214 */
	ca_uint32_t rsrvd117[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG1_t
	  TXFIFO_THRESHOLD_L3FE_CFG1; /* addr: 0x00000218 */
	ca_uint32_t rsrvd118[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG2_t
	  TXFIFO_THRESHOLD_L3FE_CFG2; /* addr: 0x0000021c */
	ca_uint32_t rsrvd119[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG_t
	  TXFIFO_THRESHOLD_MISC_CFG; /* addr: 0x00000220 */
	ca_uint32_t rsrvd120[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG2_t
	  TXFIFO_THRESHOLD_MISC_CFG2; /* addr: 0x00000224 */
	ca_uint32_t rsrvd121[3];
	NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG3_t
	  TXFIFO_THRESHOLD_MISC_CFG3; /* addr: 0x00000228 */
	ca_uint32_t rsrvd122[3];
	NI_HV_GLB_TXFIFO_MCE_THRESHOLD_CFG_t
	  TXFIFO_MCE_THRESHOLD_CFG; /* addr: 0x0000022c */
	ca_uint32_t rsrvd123[3];
	NI_HV_GLB_RXFIFO_THRESHOLD_MISC_CFG_t
	  RXFIFO_THRESHOLD_MISC_CFG; /* addr: 0x00000230 */
	ca_uint32_t rsrvd124[3];
	NI_HV_GLB_RXFIFO_XGE6_THRESHOLD_CFG_t
	  RXFIFO_XGE6_THRESHOLD_CFG; /* addr: 0x00000234 */
	ca_uint32_t rsrvd125[3];
	NI_HV_GLB_NIRX_L3QM_THRESHOLD_CFG_t
	  NIRX_L3QM_THRESHOLD_CFG; /* addr: 0x00000238 */
	ca_uint32_t rsrvd126[3];
	NI_HV_GLB_PTP_TX_CFG_t PTP_TX_CFG; /* addr: 0x0000023c */
	ca_uint32_t rsrvd127[3];
	NI_HV_GLB_GE_PTP_ASYM_CFG_01_t GE_PTP_ASYM_CFG_01; /* addr: 0x00000240 */
	ca_uint32_t rsrvd128[3];
	NI_HV_GLB_GE_PTP_ASYM_CFG_00_t GE_PTP_ASYM_CFG_00; /* addr: 0x00000244 */
	ca_uint32_t rsrvd129[3];
	NI_HV_GLB_GE_PTP_ASYM_CFG_11_t GE_PTP_ASYM_CFG_11; /* addr: 0x00000248 */
	ca_uint32_t rsrvd130[3];
	NI_HV_GLB_GE_PTP_ASYM_CFG_10_t GE_PTP_ASYM_CFG_10; /* addr: 0x0000024c */
	ca_uint32_t rsrvd131[3];
	NI_HV_GLB_GE_PTP_ASYM_CFG_21_t GE_PTP_ASYM_CFG_21; /* addr: 0x00000250 */
	ca_uint32_t rsrvd132[3];
	NI_HV_GLB_GE_PTP_ASYM_CFG_20_t GE_PTP_ASYM_CFG_20; /* addr: 0x00000254 */
	ca_uint32_t rsrvd133[3];
	NI_HV_GLB_GE_PTP_ASYM_CFG_31_t GE_PTP_ASYM_CFG_31; /* addr: 0x00000258 */
	ca_uint32_t rsrvd134[3];
	NI_HV_GLB_GE_PTP_ASYM_CFG_30_t GE_PTP_ASYM_CFG_30; /* addr: 0x0000025c */
	ca_uint32_t rsrvd135[3];
	NI_HV_GLB_XAUI_PTP_ASYM_CFG_01_t XAUI_PTP_ASYM_CFG_01; /* addr: 0x00000260 */
	ca_uint32_t rsrvd136[3];
	NI_HV_GLB_XAUI_PTP_ASYM_CFG_00_t XAUI_PTP_ASYM_CFG_00; /* addr: 0x00000264 */
	ca_uint32_t rsrvd137[3];
	NI_HV_GLB_XAUI_PTP_ASYM_CFG_11_t XAUI_PTP_ASYM_CFG_11; /* addr: 0x00000268 */
	ca_uint32_t rsrvd138[3];
	NI_HV_GLB_XAUI_PTP_ASYM_CFG_10_t XAUI_PTP_ASYM_CFG_10; /* addr: 0x0000026c */
	ca_uint32_t rsrvd139[3];
	NI_HV_GLB_XAUI_PTP_ASYM_CFG_21_t XAUI_PTP_ASYM_CFG_21; /* addr: 0x00000270 */
	ca_uint32_t rsrvd140[3];
	NI_HV_GLB_XAUI_PTP_ASYM_CFG_20_t XAUI_PTP_ASYM_CFG_20; /* addr: 0x00000274 */
	ca_uint32_t rsrvd141[3];
	NI_HV_GLB_XAUI_PTP_ASYM_CFG_31_t XAUI_PTP_ASYM_CFG_31; /* addr: 0x00000278 */
	ca_uint32_t rsrvd142[3];
	NI_HV_GLB_XAUI_PTP_ASYM_CFG_30_t XAUI_PTP_ASYM_CFG_30; /* addr: 0x0000027c */
	ca_uint32_t rsrvd143[3];
	NI_HV_GLB_XGE_PTP_ASYM_CFG_01_t XGE_PTP_ASYM_CFG_01; /* addr: 0x00000280 */
	ca_uint32_t rsrvd144[3];
	NI_HV_GLB_XGE_PTP_ASYM_CFG_00_t XGE_PTP_ASYM_CFG_00; /* addr: 0x00000284 */
	ca_uint32_t rsrvd145[3];
	NI_HV_GLB_XGE_PTP_ASYM_CFG_11_t XGE_PTP_ASYM_CFG_11; /* addr: 0x00000288 */
	ca_uint32_t rsrvd146[3];
	NI_HV_GLB_XGE_PTP_ASYM_CFG_10_t XGE_PTP_ASYM_CFG_10; /* addr: 0x0000028c */
	ca_uint32_t rsrvd147[3];
	NI_HV_GLB_XGE_PTP_ASYM_CFG_21_t XGE_PTP_ASYM_CFG_21; /* addr: 0x00000290 */
	ca_uint32_t rsrvd148[3];
	NI_HV_GLB_XGE_PTP_ASYM_CFG_20_t XGE_PTP_ASYM_CFG_20; /* addr: 0x00000294 */
	ca_uint32_t rsrvd149[3];
	NI_HV_GLB_XGE_PTP_ASYM_CFG_31_t XGE_PTP_ASYM_CFG_31; /* addr: 0x00000298 */
	ca_uint32_t rsrvd150[3];
	NI_HV_GLB_XGE_PTP_ASYM_CFG_30_t XGE_PTP_ASYM_CFG_30; /* addr: 0x0000029c */
	ca_uint32_t rsrvd151[3];
	NI_HV_GLB_P0_PTP_TX_TIMESTAMP_t P0_PTP_TX_TIMESTAMP; /* addr: 0x000002a0 */
	ca_uint32_t rsrvd152[27];
	NI_HV_GLB_NITX_STS_t NITX_STS; /* addr: 0x000002bc */
	ca_uint32_t rsrvd153[3];
	NI_HV_GLB_SPARE_t SPARE; /* addr: 0x000002c0 */
	ca_uint32_t rsrvd154[3];
	NI_HV_GLB_MISC_STS_t MISC_STS; /* addr: 0x000002c4 */
	ca_uint32_t rsrvd155[3];
	NI_HV_GLB_SPARESAMPLE_t SPARESAMPLE; /* addr: 0x000002c8 */
	ca_uint32_t rsrvd156[3];
	NI_HV_GLB_PORT_0_INTERRUPT_t PORT_0_INTERRUPT; /* addr: 0x000002cc */
	ca_uint32_t rsrvd157[3];
	NI_HV_GLB_PORT_0_INTERRUPTE_t PORT_0_INTERRUPTE; /* addr: 0x000002d0 */
	ca_uint32_t rsrvd158[35];
	NI_HV_GLB_PORT_5_INTERRUPT_t PORT_5_INTERRUPT; /* addr: 0x000002f4 */
	ca_uint32_t rsrvd159[3];
	NI_HV_GLB_PORT_5_INTERRUPTE_t PORT_5_INTERRUPTE; /* addr: 0x000002f8 */
	ca_uint32_t rsrvd160[19];
	NI_HV_GLB_PORT_8_INTERRUPT_t PORT_8_INTERRUPT; /* addr: 0x0000030c */
	ca_uint32_t rsrvd161[3];
	NI_HV_GLB_PORT_8_INTERRUPTE_t PORT_8_INTERRUPTE; /* addr: 0x00000310 */
	ca_uint32_t rsrvd162[27];
	NI_HV_GLB_NIFIFO_INTERRUPT_t NIFIFO_INTERRUPT; /* addr: 0x0000032c */
	ca_uint32_t rsrvd163[3];
	NI_HV_GLB_NIFIFO_INTERRUPTE_t NIFIFO_INTERRUPTE; /* addr: 0x00000330 */
	ca_uint32_t rsrvd164[3];
	NI_HV_GLB_MISC_INTERRUPT_t MISC_INTERRUPT; /* addr: 0x00000334 */
	ca_uint32_t rsrvd165[3];
	NI_HV_GLB_MISC_INTERRUPTE_t MISC_INTERRUPTE; /* addr: 0x00000338 */
	ca_uint32_t rsrvd166[3];
	NI_HV_GLB_TXEM_INTERRUPT_t TXEM_INTERRUPT; /* addr: 0x0000033c */
	ca_uint32_t rsrvd167[3];
	NI_HV_GLB_TXEM_INTERRUPTE_t TXEM_INTERRUPTE; /* addr: 0x00000340 */
	ca_uint32_t rsrvd168[3];
	NI_HV_GLB_PC0_INTERRUPT_t PC0_INTERRUPT; /* addr: 0x00000344 */
	ca_uint32_t rsrvd169[3];
	NI_HV_GLB_PC0_INTERRUPTE_t PC0_INTERRUPTE; /* addr: 0x00000348 */
	ca_uint32_t rsrvd170[35];
	NI_HV_GLB_CPUXRAM_CNTR_INTERRUPT_t
	  CPUXRAM_CNTR_INTERRUPT; /* addr: 0x0000036c */
	ca_uint32_t rsrvd171[3];
	NI_HV_GLB_CPUXRAM_CNTR_INTERRUPTE_t
	  CPUXRAM_CNTR_INTERRUPTE; /* addr: 0x00000370 */
	ca_uint32_t rsrvd172[3];
	NI_HV_GLB_CPUXRAM_ERR_INTERRUPT_t
	  CPUXRAM_ERR_INTERRUPT; /* addr: 0x00000374 */
	ca_uint32_t rsrvd173[3];
	NI_HV_GLB_CPUXRAM_ERR_INTERRUPTE_t
	  CPUXRAM_ERR_INTERRUPTE; /* addr: 0x00000378 */
	ca_uint32_t rsrvd174[3];
	NI_HV_GLB_PTP_INTERRUPT_t PTP_INTERRUPT; /* addr: 0x0000037c */
	ca_uint32_t rsrvd175[3];
	NI_HV_GLB_PTP_INTERRUPTE_t PTP_INTERRUPTE; /* addr: 0x00000380 */
	ca_uint32_t rsrvd176[3];
	NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPT_t
	  CPUXRAM_RXPKT_INTERRUPT; /* addr: 0x00000384 */
	ca_uint32_t rsrvd177[3];
	NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPTE_t
	  CPUXRAM_RXPKT_INTERRUPTE; /* addr: 0x00000388 */
	ca_uint32_t rsrvd178[3];
	NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPT_t
	  CPUXRAM_TXPKT_INTERRUPT; /* addr: 0x0000038c */
	ca_uint32_t rsrvd179[3];
	NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPTE_t
	  CPUXRAM_TXPKT_INTERRUPTE; /* addr: 0x00000390 */
	ca_uint32_t rsrvd180[3];
	NI_HV_GLB_MC_INTERRUPT_t MC_INTERRUPT; /* addr: 0x00000394 */
	ca_uint32_t rsrvd181[3];
	NI_HV_GLB_MC_INTERRUPTE_t MC_INTERRUPTE; /* addr: 0x00000398 */
	ca_uint32_t rsrvd182[3];
	NI_HV_GLB_INTERRUPT_t INTERRUPT; /* addr: 0x0000039c */
	ca_uint32_t rsrvd183[3];
	NI_HV_GLB_INTERRUPTE_t INTERRUPTE; /* addr: 0x000003a0 */
	ca_uint32_t rsrvd184[3];
	NI_HV_GLB_ETH_TX_MISC_CFG_t ETH_TX_MISC_CFG; /* addr: 0x000003a4 */
	ca_uint32_t rsrvd185[3];
	NI_HV_GLB_DEBUG_2_t DEBUG_2; /* addr: 0x000003a8 */
	ca_uint32_t rsrvd186[3];
	NI_HV_GLB_DEBUG_3_t DEBUG_3; /* addr: 0x000003ac */
	ca_uint32_t rsrvd187[3];
	NI_HV_GLB_VENUS_MISC_CFG_t VENUS_MISC_CFG; /* addr: 0x000003b0 */
	ca_uint32_t rsrvd188[3];
	NI_HV_GLB_CPU_TAG_CFG_t CPU_TAG_CFG; /* addr: 0x000003b4 */
	ca_uint32_t rsrvd189[3];
	NI_HV_GLB_CPU_TAG0_PORT_ID1_t CPU_TAG0_PORT_ID1; /* addr: 0x000003b8 */
	ca_uint32_t rsrvd190[3];
	NI_HV_GLB_CPU_TAG0_PORT_ID0_t CPU_TAG0_PORT_ID0; /* addr: 0x000003bc */
	ca_uint32_t rsrvd191[3];
	NI_HV_GLB_CPU_TAG0_PORT_MASK1_t CPU_TAG0_PORT_MASK1; /* addr: 0x000003c0 */
	ca_uint32_t rsrvd192[3];
	NI_HV_GLB_CPU_TAG0_PORT_MASK0_t CPU_TAG0_PORT_MASK0; /* addr: 0x000003c4 */
	ca_uint32_t rsrvd193[3];
	NI_HV_GLB_CPU_TAG0_HDR_A15_t CPU_TAG0_HDR_A15; /* addr: 0x000003c8 */
	ca_uint32_t rsrvd194[3];
	NI_HV_GLB_CPU_TAG0_HDR_A14_t CPU_TAG0_HDR_A14; /* addr: 0x000003cc */
	ca_uint32_t rsrvd195[3];
	NI_HV_GLB_CPU_TAG0_HDR_A13_t CPU_TAG0_HDR_A13; /* addr: 0x000003d0 */
	ca_uint32_t rsrvd196[3];
	NI_HV_GLB_CPU_TAG0_HDR_A12_t CPU_TAG0_HDR_A12; /* addr: 0x000003d4 */
	ca_uint32_t rsrvd197[3];
	NI_HV_GLB_CPU_TAG0_HDR_A11_t CPU_TAG0_HDR_A11; /* addr: 0x000003d8 */
	ca_uint32_t rsrvd198[3];
	NI_HV_GLB_CPU_TAG0_HDR_A10_t CPU_TAG0_HDR_A10; /* addr: 0x000003dc */
	ca_uint32_t rsrvd199[3];
	NI_HV_GLB_CPU_TAG0_HDR_A9_t CPU_TAG0_HDR_A9; /* addr: 0x000003e0 */
	ca_uint32_t rsrvd200[3];
	NI_HV_GLB_CPU_TAG0_HDR_A8_t CPU_TAG0_HDR_A8; /* addr: 0x000003e4 */
	ca_uint32_t rsrvd201[3];
	NI_HV_GLB_CPU_TAG0_HDR_A7_t CPU_TAG0_HDR_A7; /* addr: 0x000003e8 */
	ca_uint32_t rsrvd202[3];
	NI_HV_GLB_CPU_TAG0_HDR_A6_t CPU_TAG0_HDR_A6; /* addr: 0x000003ec */
	ca_uint32_t rsrvd203[3];
	NI_HV_GLB_CPU_TAG0_HDR_A5_t CPU_TAG0_HDR_A5; /* addr: 0x000003f0 */
	ca_uint32_t rsrvd204[3];
	NI_HV_GLB_CPU_TAG0_HDR_A4_t CPU_TAG0_HDR_A4; /* addr: 0x000003f4 */
	ca_uint32_t rsrvd205[3];
	NI_HV_GLB_CPU_TAG0_HDR_A3_t CPU_TAG0_HDR_A3; /* addr: 0x000003f8 */
	ca_uint32_t rsrvd206[3];
	NI_HV_GLB_CPU_TAG0_HDR_A2_t CPU_TAG0_HDR_A2; /* addr: 0x000003fc */
	ca_uint32_t rsrvd207[3];
	NI_HV_GLB_CPU_TAG0_HDR_A1_t CPU_TAG0_HDR_A1; /* addr: 0x00000400 */
	ca_uint32_t rsrvd208[3];
	NI_HV_GLB_CPU_TAG0_HDR_A0_t CPU_TAG0_HDR_A0; /* addr: 0x00000404 */
	ca_uint32_t rsrvd209[3];
	NI_HV_GLB_CPU_TAG1_PORT_ID1_t CPU_TAG1_PORT_ID1; /* addr: 0x00000408 */
	ca_uint32_t rsrvd210[3];
	NI_HV_GLB_CPU_TAG1_PORT_ID0_t CPU_TAG1_PORT_ID0; /* addr: 0x0000040c */
	ca_uint32_t rsrvd211[3];
	NI_HV_GLB_CPU_TAG1_PORT_MASK1_t CPU_TAG1_PORT_MASK1; /* addr: 0x00000410 */
	ca_uint32_t rsrvd212[3];
	NI_HV_GLB_CPU_TAG1_PORT_MASK0_t CPU_TAG1_PORT_MASK0; /* addr: 0x00000414 */
	ca_uint32_t rsrvd213[3];
	NI_HV_GLB_CPU_TAG1_HDR_A15_t CPU_TAG1_HDR_A15; /* addr: 0x00000418 */
	ca_uint32_t rsrvd214[3];
	NI_HV_GLB_CPU_TAG1_HDR_A14_t CPU_TAG1_HDR_A14; /* addr: 0x0000041c */
	ca_uint32_t rsrvd215[3];
	NI_HV_GLB_CPU_TAG1_HDR_A13_t CPU_TAG1_HDR_A13; /* addr: 0x00000420 */
	ca_uint32_t rsrvd216[3];
	NI_HV_GLB_CPU_TAG1_HDR_A12_t CPU_TAG1_HDR_A12; /* addr: 0x00000424 */
	ca_uint32_t rsrvd217[3];
	NI_HV_GLB_CPU_TAG1_HDR_A11_t CPU_TAG1_HDR_A11; /* addr: 0x00000428 */
	ca_uint32_t rsrvd218[3];
	NI_HV_GLB_CPU_TAG1_HDR_A10_t CPU_TAG1_HDR_A10; /* addr: 0x0000042c */
	ca_uint32_t rsrvd219[3];
	NI_HV_GLB_CPU_TAG1_HDR_A9_t CPU_TAG1_HDR_A9; /* addr: 0x00000430 */
	ca_uint32_t rsrvd220[3];
	NI_HV_GLB_CPU_TAG1_HDR_A8_t CPU_TAG1_HDR_A8; /* addr: 0x00000434 */
	ca_uint32_t rsrvd221[3];
	NI_HV_GLB_CPU_TAG1_HDR_A7_t CPU_TAG1_HDR_A7; /* addr: 0x00000438 */
	ca_uint32_t rsrvd222[3];
	NI_HV_GLB_CPU_TAG1_HDR_A6_t CPU_TAG1_HDR_A6; /* addr: 0x0000043c */
	ca_uint32_t rsrvd223[3];
	NI_HV_GLB_CPU_TAG1_HDR_A5_t CPU_TAG1_HDR_A5; /* addr: 0x00000440 */
	ca_uint32_t rsrvd224[3];
	NI_HV_GLB_CPU_TAG1_HDR_A4_t CPU_TAG1_HDR_A4; /* addr: 0x00000444 */
	ca_uint32_t rsrvd225[3];
	NI_HV_GLB_CPU_TAG1_HDR_A3_t CPU_TAG1_HDR_A3; /* addr: 0x00000448 */
	ca_uint32_t rsrvd226[3];
	NI_HV_GLB_CPU_TAG1_HDR_A2_t CPU_TAG1_HDR_A2; /* addr: 0x0000044c */
	ca_uint32_t rsrvd227[3];
	NI_HV_GLB_CPU_TAG1_HDR_A1_t CPU_TAG1_HDR_A1; /* addr: 0x00000450 */
	ca_uint32_t rsrvd228[3];
	NI_HV_GLB_CPU_TAG1_HDR_A0_t CPU_TAG1_HDR_A0; /* addr: 0x00000454 */
	ca_uint32_t rsrvd229[3];
	NI_HV_GLB_CPU_TAG_P5_DEFAULT_HEADER_CFG1_t
	  CPU_TAG_P5_DEFAULT_HEADER_CFG1; /* addr: 0x00000458 */
	ca_uint32_t rsrvd230[3];
	NI_HV_GLB_CPU_TAG_P5_DEFAULT_HEADER_CFG0_t
	  CPU_TAG_P5_DEFAULT_HEADER_CFG0; /* addr: 0x0000045c */
	ca_uint32_t rsrvd231[3];
	NI_HV_GLB_CPU_TAG_P6_DEFAULT_HEADER_CFG1_t
	  CPU_TAG_P6_DEFAULT_HEADER_CFG1; /* addr: 0x00000460 */
	ca_uint32_t rsrvd232[3];
	NI_HV_GLB_CPU_TAG_P6_DEFAULT_HEADER_CFG0_t
	  CPU_TAG_P6_DEFAULT_HEADER_CFG0; /* addr: 0x00000464 */
	ca_uint32_t rsrvd233[3];
	NI_HV_GLB_SRAMTEST_CFG11_t SRAMTEST_CFG11; /* addr: 0x00000468 */
	ca_uint32_t rsrvd234[3];
	NI_HV_GLB_SRAMTEST_CFG10_t SRAMTEST_CFG10; /* addr: 0x0000046c */
	ca_uint32_t rsrvd235[3];
	NI_HV_GLB_SRAMTEST_CFG21_t SRAMTEST_CFG21; /* addr: 0x00000470 */
	ca_uint32_t rsrvd236[3];
	NI_HV_GLB_SRAMTEST_CFG20_t SRAMTEST_CFG20; /* addr: 0x00000474 */
	ca_uint32_t rsrvd237[3];
	NI_HV_GLB_SRAMTEST_CFG32_t SRAMTEST_CFG32; /* addr: 0x00000478 */
	ca_uint32_t rsrvd238[3];
	NI_HV_GLB_SRAMTEST_CFG31_t SRAMTEST_CFG31; /* addr: 0x0000047c */
	ca_uint32_t rsrvd239[3];
	NI_HV_GLB_SRAMTEST_CFG30_t SRAMTEST_CFG30; /* addr: 0x00000480 */
	ca_uint32_t rsrvd240[3];
	NI_HV_GLB_SRAMTEST_CFG4_t SRAMTEST_CFG4; /* addr: 0x00000484 */
	ca_uint32_t rsrvd241[3];
	NI_HV_GLB_SRAMTEST_CFG5_t SRAMTEST_CFG5; /* addr: 0x00000488 */
	ca_uint32_t rsrvd242[3];
	NI_HV_GLB_SRAMTEST_CFG6_t SRAMTEST_CFG6; /* addr: 0x0000048c */
	ca_uint32_t rsrvd243[3];
	NI_HV_GLB_SRAMTEST_CFG7_t SRAMTEST_CFG7; /* addr: 0x00000490 */
	ca_uint32_t rsrvd244[3];
	NI_HV_GLB_SRAMTEST_CFG8_t SRAMTEST_CFG8; /* addr: 0x00000494 */
	ca_uint32_t rsrvd245[3];
	NI_HV_GLB_SRAMLS_CFG0_t SRAMLS_CFG0; /* addr: 0x00000498 */
	ca_uint32_t rsrvd246[3];
	NI_HV_GLB_SRAMLS_CFG1_t SRAMLS_CFG1; /* addr: 0x0000049c */
	ca_uint32_t rsrvd247[3];
	NI_HV_GLB_CLK_THROTTLE_CNTL_t CLK_THROTTLE_CNTL; /* addr: 0x000004a0 */
	ca_uint32_t rsrvd248[3];
	NI_HV_GLB_CLK_LUT_0_t CLK_LUT_0; /* addr: 0x000004a4 */
	ca_uint32_t rsrvd249[3];
	NI_HV_GLB_CLK_LUT_1_t CLK_LUT_1; /* addr: 0x000004a8 */
	ca_uint32_t rsrvd250[3];
	NI_HV_GLB_CLK_LUT_2_t CLK_LUT_2; /* addr: 0x000004ac */
	ca_uint32_t rsrvd251[3];
	NI_HV_GLB_CLK_LUT_3_t CLK_LUT_3; /* addr: 0x000004b0 */
	ca_uint32_t rsrvd252[3];
	NI_HV_GLB_CLK_LUT_4_t CLK_LUT_4; /* addr: 0x000004b4 */
	ca_uint32_t rsrvd253[3];
	NI_HV_GLB_CLK_LUT_5_t CLK_LUT_5; /* addr: 0x000004b8 */
	ca_uint32_t rsrvd254[3];
	NI_HV_GLB_CLK_LUT_6_t CLK_LUT_6; /* addr: 0x000004bc */
	ca_uint32_t rsrvd255[3];
	NI_HV_GLB_CLK_DIV_0_t CLK_DIV_0; /* addr: 0x000004c0 */
	ca_uint32_t rsrvd256[3];
	NI_HV_GLB_CLK_DIV_1_t CLK_DIV_1; /* addr: 0x000004c4 */
	ca_uint32_t rsrvd257[3];
	NI_HV_GLB_CLK_MAX_TRAP_t CLK_MAX_TRAP; /* addr: 0x000004c8 */
	ca_uint32_t rsrvd258[3];
	NI_HV_GLB_C10_DEC_IN_RATE_CFG_t C10_DEC_IN_RATE_CFG; /* addr: 0x000004cc */
} APB0_NI_HV_GLB_t;
#endif /* !__ASSEMBLER__ */

/*
 * PT[0..4]
 */

#define NI_HV_PT_PORT_STATIC_CFG 0xf4304600
#define NI_HV_PT_PORT_STATIC_CFG_dft 0x00000203

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t int_cfg : 4; /* bits 3:0 */
		ca_uint32_t phy_mode : 1; /* bits 4:4 */
		ca_uint32_t rmii_clksrc : 1; /* bits 5:5 */
		ca_uint32_t inv_clk_in : 1; /* bits 6:6 */
		ca_uint32_t inv_clk_out : 1; /* bits 7:7 */
		ca_uint32_t inv_rxclk_out : 1; /* bits 8:8 */
		ca_uint32_t tx_use_gefifo : 1; /* bits 9:9 */
		ca_uint32_t smii_tx_stat : 1; /* bits 10:10 */
		ca_uint32_t crs_polarity : 1; /* bits 11:11 */
		ca_uint32_t lpbk_mode : 2; /* bits 13:12 */
		ca_uint32_t gmii_like_half_duplex_en : 1; /* bits 14:14 */
		ca_uint32_t sup_tx_to_rx_lpbk_data : 1; /* bits 15:15 */
		ca_uint32_t cpu_tag_rx_en : 1; /* bits 16:16 */
		ca_uint32_t cpu_tag_tx_en : 1; /* bits 17:17 */
		ca_uint32_t cpu_tag_cfg_sel : 1; /* bits 18:18 */
		ca_uint32_t rsrvd1 : 5;
		ca_uint32_t mac_addr6 : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PORT_STATIC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define int_cfg_GMII_GE 0x0
#define int_cfg_MII 0x1
#define int_cfg_RGMII_GE 0x2
#define int_cfg_RGMII_FE 0x3

#define NI_HV_PT_PORT_GLB_CFG 0xf4304604
#define NI_HV_PT_PORT_GLB_CFG_dft 0x00000004

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t speed : 1; /* bits 0:0 */
		ca_uint32_t duplex : 1; /* bits 1:1 */
		ca_uint32_t link_status : 1; /* bits 2:2 */
		ca_uint32_t link_stat_mask : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t power_dwn_rx : 1; /* bits 11:11 */
		ca_uint32_t power_dwn_tx : 1; /* bits 12:12 */
		ca_uint32_t tx_intf_lp_time : 1; /* bits 13:13 */
		ca_uint32_t rsrvd2 : 18;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PORT_GLB_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_RXMAC_CFG 0xf4304608
#define NI_HV_PT_RXMAC_CFG_dft 0x00000101

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_en : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t rx_flow_disable : 1; /* bits 8:8 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t rx_flow_to_tx_en : 1; /* bits 12:12 */
		ca_uint32_t rx_pfc_disable : 1; /* bits 13:13 */
		ca_uint32_t rsrvd3 : 15;
		ca_uint32_t send_pg_data : 1; /* bits 29:29 */
		ca_uint32_t rsrvd4 : 2;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_RXMAC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_RXMAC_WOL_CFG 0xf430460c
#define NI_HV_PT_RXMAC_WOL_CFG_dft 0x00000f00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t wol_pkt_det_en : 1; /* bits 0:0 */
		ca_uint32_t wol_chk_da : 2; /* bits 2:1 */
		ca_uint32_t wol_ign_err : 1; /* bits 3:3 */
		ca_uint32_t wol_secure_on : 1; /* bits 4:4 */
		ca_uint32_t wol_passwd_cnt : 1; /* bits 5:5 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t wol_mac_adr_cnt : 6; /* bits 13:8 */
		ca_uint32_t rsrvd2 : 2;
		ca_uint32_t wol_passwd6 : 8; /* bits 23:16 */
		ca_uint32_t rsrvd3 : 7;
		ca_uint32_t wol_wake_on_any_pkt : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_RXMAC_WOL_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_MAC_STATUS 0xf4304610
#define NI_HV_PT_MAC_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rcv_speed : 2; /* bits 1:0 */
		ca_uint32_t rcv_duplex : 1; /* bits 2:2 */
		ca_uint32_t rcv_lnk_stat : 1; /* bits 3:3 */
		ca_uint32_t rx_lpi_detect : 1; /* bits 4:4 */
		ca_uint32_t lpi_assert : 1; /* bits 5:5 */
		ca_uint32_t lpi_mac_dis : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 25;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_MAC_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_TXMAC_CFG 0xf4304614
#define NI_HV_PT_TXMAC_CFG_dft 0x04019901

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_en : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t mac_crc_calc_en : 1; /* bits 8:8 */
		ca_uint32_t tx_ipg_sel : 3; /* bits 11:9 */
		ca_uint32_t tx_flow_disable : 1; /* bits 12:12 */
		ca_uint32_t tx_drain : 1; /* bits 13:13 */
		ca_uint32_t tx_pfc_disable : 1; /* bits 14:14 */
		ca_uint32_t tx_pau_sel : 2; /* bits 16:15 */
		ca_uint32_t force_xon_stream : 1; /* bits 17:17 */
		ca_uint32_t rsrvd2 : 8;
		ca_uint32_t tx_auto_xon : 1; /* bits 26:26 */
		ca_uint32_t rsrvd3 : 1;
		ca_uint32_t pass_thru_hdr : 1; /* bits 28:28 */
		ca_uint32_t rsrvd4 : 3;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_TXMAC_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG0 0xf4304618
#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG0_dft 0x00ff00ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txpfc_time_0 : 16; /* bits 15:0 */
		ca_uint32_t txpfc_time_1 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG1 0xf430461c
#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG1_dft 0x00ff00ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txpfc_time_2 : 16; /* bits 15:0 */
		ca_uint32_t txpfc_time_3 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG2 0xf4304620
#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG2_dft 0x00ff00ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txpfc_time_4 : 16; /* bits 15:0 */
		ca_uint32_t txpfc_time_5 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG3 0xf4304624
#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG3_dft 0x00ff00ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txpfc_time_6 : 16; /* bits 15:0 */
		ca_uint32_t txpfc_time_7 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_EEE_LPI_CFG0 0xf4304628
#define NI_HV_PT_EEE_LPI_CFG0_dft 0x01387000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_eee_enable : 1; /* bits 0:0 */
		ca_uint32_t cpu_lpi_deassert : 1; /* bits 1:1 */
		ca_uint32_t stop_txclk_on_lpi : 1; /* bits 2:2 */
		ca_uint32_t lpi_data_mode : 1; /* bits 3:3 */
		ca_uint32_t lpi_mode_te : 1; /* bits 4:4 */
		ca_uint32_t rsrvd1 : 7;
		ca_uint32_t txfifo_empty_cnt : 20; /* bits 31:12 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_EEE_LPI_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_EEE_LPI_CFG1 0xf430462c
#define NI_HV_PT_EEE_LPI_CFG1_dft 0x0000071b

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lpi_min_assert_cnt : 20; /* bits 19:0 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_EEE_LPI_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_EEE_LPI_CFG2 0xf4304630
#define NI_HV_PT_EEE_LPI_CFG2_dft 0x000000a4

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lpi_min_wakeup_cnt : 20; /* bits 19:0 */
		ca_uint32_t rsrvd1 : 12;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_EEE_LPI_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_EEE_LPI_CFG3 0xf4304634
#define NI_HV_PT_EEE_LPI_CFG3_dft 0x0f000005

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t lpi_mac_dis_wait_cnt : 12; /* bits 11:0 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t stop_txclk_en_cnt : 12; /* bits 31:20 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_EEE_LPI_CFG3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_RX_CNTRL_CFG 0xf4304638
#define NI_HV_PT_RX_CNTRL_CFG_dft 0x08000400

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t ff_overrun_drop_dis : 1; /* bits 2:2 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t crc_drop_dis : 1; /* bits 4:4 */
		ca_uint32_t ovr_drop_dis : 1; /* bits 5:5 */
		ca_uint32_t runt_drop_dis : 1; /* bits 6:6 */
		ca_uint32_t flow_drop_dis : 1; /* bits 7:7 */
		ca_uint32_t ukopcode_drop_dis : 1; /* bits 8:8 */
		ca_uint32_t oam_drop_dis : 1; /* bits 9:9 */
		ca_uint32_t linkstat_drop_dis : 1; /* bits 10:10 */
		ca_uint32_t pfc_drop_dis : 1; /* bits 11:11 */
		ca_uint32_t rsrvd3 : 4;
		ca_uint32_t rxctrl_byp_dpid : 6; /* bits 21:16 */
		ca_uint32_t rsrvd4 : 2;
		ca_uint32_t rxctrl_byp_cos : 3; /* bits 26:24 */
		ca_uint32_t rxctrl_byp_dpq : 1; /* bits 27:27 */
		ca_uint32_t rxctrl_byp_en : 1; /* bits 28:28 */
		ca_uint32_t rsrvd5 : 1;
		ca_uint32_t rxctrl_byp_mir : 1; /* bits 30:30 */
		ca_uint32_t rxctrl_byp_ndrp : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_RX_CNTRL_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_TXFIFO_THLD_CFG 0xf430463c
#define NI_HV_PT_TXFIFO_THLD_CFG_dft 0x00280064

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t high_thld : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t low_thld : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_TXFIFO_THLD_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_PG_CFG0 0xf4304640
#define NI_HV_PT_PG_CFG0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pg_da6 : 8; /* bits 7:0 */
		ca_uint32_t pg_sa6 : 8; /* bits 15:8 */
		ca_uint32_t pg_type : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PG_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_PG_CFG1 0xf4304644
#define NI_HV_PT_PG_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pg_vlan1 : 16; /* bits 15:0 */
		ca_uint32_t pg_vlan2 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PG_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_PG_CNTRL_CFG 0xf4304648
#define NI_HV_PT_PG_CNTRL_CFG_dft 0x08018000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pg_en : 1; /* bits 0:0 */
		ca_uint32_t pg_fixedcount : 1; /* bits 1:1 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t pg_fixedlen : 1; /* bits 4:4 */
		ca_uint32_t pg_insvlan2 : 1; /* bits 5:5 */
		ca_uint32_t pg_insvlan1 : 1; /* bits 6:6 */
		ca_uint32_t pg_instype : 1; /* bits 7:7 */
		ca_uint32_t pg_insseqnum : 1; /* bits 8:8 */
		ca_uint32_t pg_invpat : 1; /* bits 9:9 */
		ca_uint32_t pg_insfixpattern : 1; /* bits 10:10 */
		ca_uint32_t rsrvd2 : 4;
		ca_uint32_t pg_linerate : 9; /* bits 23:15 */
		ca_uint32_t pg_ipg : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PG_CNTRL_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_PC_CFG1 0xf430464c
#define NI_HV_PT_PC_CFG1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_da6 : 8; /* bits 7:0 */
		ca_uint32_t pc_sa6 : 8; /* bits 15:8 */
		ca_uint32_t pc_type : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PC_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_PC_CFG2 0xf4304650
#define NI_HV_PT_PC_CFG2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_vlan1 : 16; /* bits 15:0 */
		ca_uint32_t pc_vlan2 : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PC_CFG2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_PC_CNTRL 0xf4304654
#define NI_HV_PT_PC_CNTRL_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_en : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t pc_fixedlen : 1; /* bits 4:4 */
		ca_uint32_t pc_expvlan2 : 1; /* bits 5:5 */
		ca_uint32_t pc_expvlan1 : 1; /* bits 6:6 */
		ca_uint32_t pc_exptype : 1; /* bits 7:7 */
		ca_uint32_t pc_expseqnum : 1; /* bits 8:8 */
		ca_uint32_t pc_invpat : 1; /* bits 9:9 */
		ca_uint32_t pc_expfixpattern : 1; /* bits 10:10 */
		ca_uint32_t rsrvd2 : 21;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PC_CNTRL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_PC_STAT 0xf4304658
#define NI_HV_PT_PC_STAT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pc_dchkstatus : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_PC_STAT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_DEBUG_1 0xf430465c
#define NI_HV_PT_DEBUG_1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hd_backoff_cnt : 10; /* bits 9:0 */
		ca_uint32_t hd_backoff_dbg : 1; /* bits 10:10 */
		ca_uint32_t rsrvd1 : 21;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_DEBUG_1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_TX_DRAINCNT 0xf4304660
#define NI_HV_PT_TX_DRAINCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t CNT : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_TX_DRAINCNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_CPU_TAG_DEFAULT_HEADER_CFG1 0xf4304664
#define NI_HV_PT_CPU_TAG_DEFAULT_HEADER_CFG1_dft 0xffff0000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t default_hdr_a1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_CPU_TAG_DEFAULT_HEADER_CFG1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_CPU_TAG_DEFAULT_HEADER_CFG0 0xf4304668
#define NI_HV_PT_CPU_TAG_DEFAULT_HEADER_CFG0_dft 0xffff0000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t default_hdr_a0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_CPU_TAG_DEFAULT_HEADER_CFG0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_SPARE 0xf430466c
#define NI_HV_PT_SPARE_dft 0x0000ff00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t VALUE : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_SPARE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_PT_SPARESAMPLE 0xf4304670
#define NI_HV_PT_SPARESAMPLE_dft 0x0000ff00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t VALUE : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_PT_SPARESAMPLE_t;
#endif /* !__ASSEMBLER__ */

#define APB0_NI_HV_PT_STRIDE 160
#define APB0_NI_HV_PT_COUNT 5

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PT */
#ifndef __ASSEMBLER__
typedef struct {
	NI_HV_PT_PORT_STATIC_CFG_t PORT_STATIC_CFG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	NI_HV_PT_PORT_GLB_CFG_t PORT_GLB_CFG; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	NI_HV_PT_RXMAC_CFG_t RXMAC_CFG; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	NI_HV_PT_RXMAC_WOL_CFG_t RXMAC_WOL_CFG; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	NI_HV_PT_MAC_STATUS_t MAC_STATUS; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	NI_HV_PT_TXMAC_CFG_t TXMAC_CFG; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG0_t
	  ETH_TXMAC_PAUSE_TIMER_CFG0; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG1_t
	  ETH_TXMAC_PAUSE_TIMER_CFG1; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG2_t
	  ETH_TXMAC_PAUSE_TIMER_CFG2; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG3_t
	  ETH_TXMAC_PAUSE_TIMER_CFG3; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	NI_HV_PT_EEE_LPI_CFG0_t EEE_LPI_CFG0; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	NI_HV_PT_EEE_LPI_CFG1_t EEE_LPI_CFG1; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	NI_HV_PT_EEE_LPI_CFG2_t EEE_LPI_CFG2; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	NI_HV_PT_EEE_LPI_CFG3_t EEE_LPI_CFG3; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	NI_HV_PT_RX_CNTRL_CFG_t RX_CNTRL_CFG; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	NI_HV_PT_TXFIFO_THLD_CFG_t TXFIFO_THLD_CFG; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	NI_HV_PT_PG_CFG0_t PG_CFG0; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	NI_HV_PT_PG_CFG1_t PG_CFG1; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	NI_HV_PT_PG_CNTRL_CFG_t PG_CNTRL_CFG; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	NI_HV_PT_PC_CFG1_t PC_CFG1; /* addr: 0x0000004c */
	ca_uint32_t rsrvd20[3];
	NI_HV_PT_PC_CFG2_t PC_CFG2; /* addr: 0x00000050 */
	ca_uint32_t rsrvd21[3];
	NI_HV_PT_PC_CNTRL_t PC_CNTRL; /* addr: 0x00000054 */
	ca_uint32_t rsrvd22[3];
	NI_HV_PT_PC_STAT_t PC_STAT; /* addr: 0x00000058 */
	ca_uint32_t rsrvd23[3];
	NI_HV_PT_DEBUG_1_t DEBUG_1; /* addr: 0x0000005c */
	ca_uint32_t rsrvd24[3];
	NI_HV_PT_TX_DRAINCNT_t TX_DRAINCNT; /* addr: 0x00000060 */
	ca_uint32_t rsrvd25[3];
	NI_HV_PT_CPU_TAG_DEFAULT_HEADER_CFG1_t
	  CPU_TAG_DEFAULT_HEADER_CFG1; /* addr: 0x00000064 */
	ca_uint32_t rsrvd26[3];
	NI_HV_PT_CPU_TAG_DEFAULT_HEADER_CFG0_t
	  CPU_TAG_DEFAULT_HEADER_CFG0; /* addr: 0x00000068 */
	ca_uint32_t rsrvd27[3];
	NI_HV_PT_SPARE_t SPARE; /* addr: 0x0000006c */
	ca_uint32_t rsrvd28[3];
	NI_HV_PT_SPARESAMPLE_t SPARESAMPLE; /* addr: 0x00000070 */
	ca_uint32_t rsrvd29[47];
} APB0_NI_HV_PT_t;
#endif /* !__ASSEMBLER__ */

/*
 * INTPT[0..3]
 */

#define NI_HV_INTPT_RX_CNTRL_CFG 0xf4304920
#define NI_HV_INTPT_RX_CNTRL_CFG_dft 0x00028000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 14;
		ca_uint32_t rx_rate : 8; /* bits 21:14 */
		ca_uint32_t rsrvd2 : 10;
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_RX_CNTRL_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_RX_MISSING_SOP_EOP_CNT 0xf4304924
#define NI_HV_INTPT_RX_MISSING_SOP_EOP_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_missing_eop_pkt_cnt : 16; /* bits 15:0 */
		ca_uint32_t rx_missing_sop_pkt_cnt : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_RX_MISSING_SOP_EOP_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_RX_SHORT_ERR_CNT 0xf4304928
#define NI_HV_INTPT_RX_SHORT_ERR_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_err_pkt_cnt : 16; /* bits 15:0 */
		ca_uint32_t rx_short_pkt_cnt : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_RX_SHORT_ERR_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_RX_PKT_CNT 0xf430492c
#define NI_HV_INTPT_RX_PKT_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_RX_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_RX_PKT_BYTE_HI_CNT 0xf4304930
#define NI_HV_INTPT_RX_PKT_BYTE_HI_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_RX_PKT_BYTE_HI_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_RX_PKT_BYTE_LO_CNT 0xf4304934
#define NI_HV_INTPT_RX_PKT_BYTE_LO_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_RX_PKT_BYTE_LO_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_TX_MISSING_SOP_EOP_CNT 0xf4304938
#define NI_HV_INTPT_TX_MISSING_SOP_EOP_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_missing_eop_pkt_cnt : 16; /* bits 15:0 */
		ca_uint32_t tx_missing_sop_pkt_cnt : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_TX_MISSING_SOP_EOP_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_TX_SHORT_ERR_CNT 0xf430493c
#define NI_HV_INTPT_TX_SHORT_ERR_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_err_pkt_cnt : 16; /* bits 15:0 */
		ca_uint32_t tx_short_pkt_cnt : 16; /* bits 31:16 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_TX_SHORT_ERR_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_TX_PKT_CNT 0xf4304940
#define NI_HV_INTPT_TX_PKT_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_TX_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_TX_PKT_BYTE_HI_CNT 0xf4304944
#define NI_HV_INTPT_TX_PKT_BYTE_HI_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_TX_PKT_BYTE_HI_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_INTPT_TX_PKT_BYTE_LO_CNT 0xf4304948
#define NI_HV_INTPT_TX_PKT_BYTE_LO_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_pkt_cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_INTPT_TX_PKT_BYTE_LO_CNT_t;
#endif /* !__ASSEMBLER__ */

#define APB0_NI_HV_INTPT_STRIDE 64
#define APB0_NI_HV_INTPT_COUNT 4

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* INTPT */
#ifndef __ASSEMBLER__
typedef struct {
	NI_HV_INTPT_RX_CNTRL_CFG_t RX_CNTRL_CFG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	NI_HV_INTPT_RX_MISSING_SOP_EOP_CNT_t
	  RX_MISSING_SOP_EOP_CNT; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	NI_HV_INTPT_RX_SHORT_ERR_CNT_t RX_SHORT_ERR_CNT; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	NI_HV_INTPT_RX_PKT_CNT_t RX_PKT_CNT; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	NI_HV_INTPT_RX_PKT_BYTE_HI_CNT_t RX_PKT_BYTE_HI_CNT; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	NI_HV_INTPT_RX_PKT_BYTE_LO_CNT_t RX_PKT_BYTE_LO_CNT; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	NI_HV_INTPT_TX_MISSING_SOP_EOP_CNT_t
	  TX_MISSING_SOP_EOP_CNT; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	NI_HV_INTPT_TX_SHORT_ERR_CNT_t TX_SHORT_ERR_CNT; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	NI_HV_INTPT_TX_PKT_CNT_t TX_PKT_CNT; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	NI_HV_INTPT_TX_PKT_BYTE_HI_CNT_t TX_PKT_BYTE_HI_CNT; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	NI_HV_INTPT_TX_PKT_BYTE_LO_CNT_t TX_PKT_BYTE_LO_CNT; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[23];
} APB0_NI_HV_INTPT_t;
#endif /* !__ASSEMBLER__ */

/*
 * XRAM
 */

#define NI_HV_XRAM_CPUXRAM_ADRCFG_RX 0xf4304a20
#define NI_HV_XRAM_CPUXRAM_ADRCFG_RX_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_base_addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t rx_top_addr : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_ADRCFG_RX_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_ADRCFG_TX_0 0xf4304a24
#define NI_HV_XRAM_CPUXRAM_ADRCFG_TX_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_base_addr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t tx_top_addr : 10; /* bits 25:16 */
		ca_uint32_t rsrvd2 : 6;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_ADRCFG_TX_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_CFG 0xf4304a28
#define NI_HV_XRAM_CPUXRAM_CFG_dft 0x0000c001

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx_0_cpu_pkt_dis : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 8;
		ca_uint32_t tx_0_cpu_pkt_dis : 1; /* bits 9:9 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t rx_x_drop_err_pkt : 1; /* bits 11:11 */
		ca_uint32_t xram_mgmt_dis_drop_ovsz_pkt : 1; /* bits 12:12 */
		ca_uint32_t xram_mgmt_term_large_pkt : 1; /* bits 13:13 */
		ca_uint32_t xram_mgmt_promisc_mode : 2; /* bits 15:14 */
		ca_uint32_t xram_cntr_debug_mode : 1; /* bits 16:16 */
		ca_uint32_t xram_cntr_op_code : 2; /* bits 18:17 */
		ca_uint32_t rsrvd3 : 2;
		ca_uint32_t xram_rx_mgmtfifo_srst : 1; /* bits 21:21 */
		ca_uint32_t xram_dma_fifo_srst : 1; /* bits 22:22 */
		ca_uint32_t rsrvd4 : 9;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_CPU_CFG_RX_0 0xf4304a2c
#define NI_HV_XRAM_CPUXRAM_CPU_CFG_RX_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_rd_ptr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_CPU_CFG_RX_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_CPU_STA_RX_0 0xf4304a30
#define NI_HV_XRAM_CPUXRAM_CPU_STA_RX_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_wr_ptr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 5;
		ca_uint32_t int_colsc_thresh_reached : 1; /* bits 15:15 */
		ca_uint32_t rsrvd2 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_CPU_STA_RX_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_INT_COLSC_CFG_0 0xf4304a34
#define NI_HV_XRAM_CPUXRAM_INT_COLSC_CFG_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t int_colsc_dly_time : 20; /* bits 19:0 */
		ca_uint32_t int_colsc_pkt : 10; /* bits 29:20 */
		ca_uint32_t int_colsc_first_en : 1; /* bits 30:30 */
		ca_uint32_t int_colsc_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_INT_COLSC_CFG_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_PKT_CNT_0 0xf4304a38
#define NI_HV_XRAM_CPUXRAM_PKT_CNT_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_to_xram : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_PKT_CNT_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_BYT_CNT_0 0xf4304a3c
#define NI_HV_XRAM_CPUXRAM_BYT_CNT_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t byt_to_xram : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_BYT_CNT_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_PKT_ERR_DRP_0 0xf4304a40
#define NI_HV_XRAM_CPUXRAM_PKT_ERR_DRP_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_drop_err : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_PKT_ERR_DRP_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_CPU_CFG_TX_0 0xf4304a44
#define NI_HV_XRAM_CPUXRAM_CPU_CFG_TX_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_wr_ptr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_CPU_CFG_TX_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_CPUXRAM_CPU_STAT_TX_0 0xf4304a48
#define NI_HV_XRAM_CPUXRAM_CPU_STAT_TX_0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_rd_ptr : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_CPUXRAM_CPU_STAT_TX_0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_DMA_PKT_CNT 0xf4304a4c
#define NI_HV_XRAM_DMA_PKT_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dma_pkt_to_cpu : 24; /* bits 23:0 */
		ca_uint32_t rsrvd1 : 8;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_DMA_PKT_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XRAM_DMA_BYTE_CNT 0xf4304a50
#define NI_HV_XRAM_DMA_BYTE_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t dma_byte_to_cpu : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XRAM_DMA_BYTE_CNT_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XRAM */
#ifndef __ASSEMBLER__
typedef struct {
	NI_HV_XRAM_CPUXRAM_ADRCFG_RX_t CPUXRAM_ADRCFG_RX; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	NI_HV_XRAM_CPUXRAM_ADRCFG_TX_0_t CPUXRAM_ADRCFG_TX_0; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	NI_HV_XRAM_CPUXRAM_CFG_t CPUXRAM_CFG; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	NI_HV_XRAM_CPUXRAM_CPU_CFG_RX_0_t CPUXRAM_CPU_CFG_RX_0; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	NI_HV_XRAM_CPUXRAM_CPU_STA_RX_0_t CPUXRAM_CPU_STA_RX_0; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	NI_HV_XRAM_CPUXRAM_INT_COLSC_CFG_0_t
	  CPUXRAM_INT_COLSC_CFG_0; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	NI_HV_XRAM_CPUXRAM_PKT_CNT_0_t CPUXRAM_PKT_CNT_0; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	NI_HV_XRAM_CPUXRAM_BYT_CNT_0_t CPUXRAM_BYT_CNT_0; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	NI_HV_XRAM_CPUXRAM_PKT_ERR_DRP_0_t
	  CPUXRAM_PKT_ERR_DRP_0; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	NI_HV_XRAM_CPUXRAM_CPU_CFG_TX_0_t CPUXRAM_CPU_CFG_TX_0; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	NI_HV_XRAM_CPUXRAM_CPU_STAT_TX_0_t
	  CPUXRAM_CPU_STAT_TX_0; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	NI_HV_XRAM_DMA_PKT_CNT_t DMA_PKT_CNT; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	NI_HV_XRAM_DMA_BYTE_CNT_t DMA_BYTE_CNT; /* addr: 0x00000030 */
} APB0_NI_HV_XRAM_t;
#endif /* !__ASSEMBLER__ */

/*
 * MCE
 */

#define NI_HV_MCE_CTL_REG 0xf4304a60
#define NI_HV_MCE_CTL_REG_dft 0x0002f0ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ff_thrshd : 10; /* bits 9:0 */
		ca_uint32_t min_pktsize : 6; /* bits 15:10 */
		ca_uint32_t crc_err_drop_en : 1; /* bits 16:16 */
		ca_uint32_t cp_lspid_to_pol_id_en : 1; /* bits 17:17 */
		ca_uint32_t buf_flush_en : 1; /* bits 18:18 */
		ca_uint32_t rsrvd1 : 13;
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_CTL_REG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_INDX_LKUP_ACCESS 0xf4304a64
#define NI_HV_MCE_INDX_LKUP_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t addr : 8; /* bits 7:0 */
		ca_uint32_t rsrvd1 : 22;
		ca_uint32_t rbw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_INDX_LKUP_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_INDX_LKUP_DATA1 0xf4304a68
#define NI_HV_MCE_INDX_LKUP_DATA1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mc_vec : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_INDX_LKUP_DATA1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_INDX_LKUP_DATA0 0xf4304a6c
#define NI_HV_MCE_INDX_LKUP_DATA0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t mc_vec : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_INDX_LKUP_DATA0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_ZERO_BITMAP_DROP_CNT 0xf4304a70
#define NI_HV_MCE_ZERO_BITMAP_DROP_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_ZERO_BITMAP_DROP_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_INGRESS_CNT 0xf4304a74
#define NI_HV_MCE_INGRESS_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_INGRESS_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_EGRESS_CNT 0xf4304a78
#define NI_HV_MCE_EGRESS_CNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_EGRESS_CNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_LAST_IN_HDR2 0xf4304a7c
#define NI_HV_MCE_LAST_IN_HDR2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_LAST_IN_HDR2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_LAST_IN_HDR1 0xf4304a80
#define NI_HV_MCE_LAST_IN_HDR1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_LAST_IN_HDR1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_LAST_IN_HDR0 0xf4304a84
#define NI_HV_MCE_LAST_IN_HDR0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_LAST_IN_HDR0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_LAST_OUT_HDR2 0xf4304a88
#define NI_HV_MCE_LAST_OUT_HDR2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr2 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_LAST_OUT_HDR2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_LAST_OUT_HDR1 0xf4304a8c
#define NI_HV_MCE_LAST_OUT_HDR1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr1 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_LAST_OUT_HDR1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_LAST_OUT_HDR0 0xf4304a90
#define NI_HV_MCE_LAST_OUT_HDR0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t hdr0 : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_LAST_OUT_HDR0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_ERROR_STS 0xf4304a94
#define NI_HV_MCE_ERROR_STS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flag : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_ERROR_STS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_ERROR_STS1 0xf4304a98
#define NI_HV_MCE_ERROR_STS1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flag : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_ERROR_STS1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_MCE_ERROR_STS2 0xf4304a9c
#define NI_HV_MCE_ERROR_STS2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flag : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_MCE_ERROR_STS2_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* MCE */
#ifndef __ASSEMBLER__
typedef struct {
	NI_HV_MCE_CTL_REG_t CTL_REG; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	NI_HV_MCE_INDX_LKUP_ACCESS_t INDX_LKUP_ACCESS; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	NI_HV_MCE_INDX_LKUP_DATA1_t INDX_LKUP_DATA1; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	NI_HV_MCE_INDX_LKUP_DATA0_t INDX_LKUP_DATA0; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	NI_HV_MCE_ZERO_BITMAP_DROP_CNT_t ZERO_BITMAP_DROP_CNT; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	NI_HV_MCE_INGRESS_CNT_t INGRESS_CNT; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	NI_HV_MCE_EGRESS_CNT_t EGRESS_CNT; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	NI_HV_MCE_LAST_IN_HDR2_t LAST_IN_HDR2; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	NI_HV_MCE_LAST_IN_HDR1_t LAST_IN_HDR1; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	NI_HV_MCE_LAST_IN_HDR0_t LAST_IN_HDR0; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	NI_HV_MCE_LAST_OUT_HDR2_t LAST_OUT_HDR2; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	NI_HV_MCE_LAST_OUT_HDR1_t LAST_OUT_HDR1; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	NI_HV_MCE_LAST_OUT_HDR0_t LAST_OUT_HDR0; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	NI_HV_MCE_ERROR_STS_t ERROR_STS; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	NI_HV_MCE_ERROR_STS1_t ERROR_STS1; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	NI_HV_MCE_ERROR_STS2_t ERROR_STS2; /* addr: 0x0000003c */
} APB0_NI_HV_MCE_t;
#endif /* !__ASSEMBLER__ */

/*
 * XAUI
 */

/*
 * XGXS_TOP
 */

/*
 * xgxs_rx
 */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl0 0xf4304f00
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_rx_mode : 2; /* bits 1:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t xgxs_rx_random_6 : 1; /* bits 3:3 */
		ca_uint32_t xgxs_rx_err_inj : 4; /* bits 7:4 */
		ca_uint32_t xgxs_fpat_sel : 8; /* bits 15:8 */
		ca_uint32_t rsrvd2 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl0_t;
#endif /* !__ASSEMBLER__ */

#define xgxs_fpat_sel_Register 0x0
#define xgxs_fpat_sel_High 0x1
#define xgxs_fpat_sel_Low 0x2
#define xgxs_fpat_sel_Mixed 0x3
#define xgxs_rx_mode_Data 0x0
#define xgxs_rx_mode_Frequency 0x1
#define xgxs_rx_mode_Random 0x2
#define xgxs_rx_mode_Jitter 0x3

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl1 0xf4304f04
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_fpat_0 : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl2 0xf4304f08
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_fpat_1 : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl3 0xf4304f0c
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_fpat_2 : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl4 0xf4304f10
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_fpat_3 : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl5 0xf4304f14
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_rx_phase : 4; /* bits 3:0 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t xgxs_rx_fzero : 4; /* bits 11:8 */
		ca_uint32_t xgxs_rx_fone : 4; /* bits 15:12 */
		ca_uint32_t rsrvd2 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTSTAT 0xf4304f18
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTSTAT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ErrorPktSat : 1; /* bits 1:1 */
		ca_uint32_t GoodPktSat : 1; /* bits 2:2 */
		ca_uint32_t rsrvd2 : 29;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTSTAT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTERRUPT 0xf4304f1c
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ErrorPktI : 1; /* bits 0:0 */
		ca_uint32_t ErrorPktSatI : 1; /* bits 1:1 */
		ca_uint32_t GoodPktSatI : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTENABLE 0xf4304f20
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ErrorPkte : 1; /* bits 0:0 */
		ca_uint32_t ErrorPktSate : 1; /* bits 1:1 */
		ca_uint32_t GoodPktSate : 1; /* bits 2:2 */
		ca_uint32_t rsrvd1 : 29;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTENABLE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_GoodPkt 0xf4304f24
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_GoodPkt_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t good_pkt_rx : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_GoodPkt_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_ErrPkt 0xf4304f28
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_ErrPkt_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t err_pkt_rx : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_ErrPkt_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_SCRATCH 0xf4304f2c
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_SCRATCH_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t scratch : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_SCRATCH_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgxs_rx */
#ifndef __ASSEMBLER__
typedef struct {
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl0_t RxCntrl0; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl1_t RxCntrl1; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl2_t RxCntrl2; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl3_t RxCntrl3; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl4_t RxCntrl4; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl5_t RxCntrl5; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTSTAT_t RX_INTSTAT; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTERRUPT_t
	  RX_INTERRUPT; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTENABLE_t
	  RX_INTENABLE; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_GoodPkt_t GoodPkt; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_ErrPkt_t ErrPkt; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_RX_SCRATCH_t SCRATCH; /* addr: 0x0000002c */
} APB0_NI_HV_XAUI_XGXS_TOP_XGXS_RX_t;
#endif /* !__ASSEMBLER__ */

/*
 * xgxs_tx
 */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl0 0xf4304f40
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_tx_mode : 2; /* bits 1:0 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t xgxs_lf_enable : 1; /* bits 3:3 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t xgxs_ddsa_enable : 1; /* bits 7:7 */
		ca_uint32_t xgxs_fpat_sel : 8; /* bits 15:8 */
		ca_uint32_t rsrvd3 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl0_t;
#endif /* !__ASSEMBLER__ */

#define xgxs_tx_mode_Data 0x0
#define xgxs_tx_mode_Frequency 0x1
#define xgxs_tx_mode_Random 0x2
#define xgxs_tx_mode_Jitter 0x3

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl1 0xf4304f44
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_fpat_0 : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl2 0xf4304f48
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_fpat_1 : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl3 0xf4304f4c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_fpat_2 : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl4 0xf4304f50
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_fpat_3 : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl5 0xf4304f54
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl5_dft 0x00000a00

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rxaui_cgalign_ena_mode : 2; /* bits 1:0 */
		ca_uint32_t rxaui_a_column_ena_mode : 2; /* bits 3:2 */
		ca_uint32_t rxaui_a_column_verify_mode : 1; /* bits 4:4 */
		ca_uint32_t rxaui_lane_swap_01 : 1; /* bits 5:5 */
		ca_uint32_t rxaui_lane_swap_23 : 1; /* bits 6:6 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t rxaui_comma_thresh : 6; /* bits 13:8 */
		ca_uint32_t rsrvd2 : 18;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTSTAT 0xf4304f58
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTSTAT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t ErrorPktSat : 1; /* bits 1:1 */
		ca_uint32_t GoodPktSat : 1; /* bits 2:2 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t InvCodeSat : 1; /* bits 4:4 */
		ca_uint32_t xgxs_comma_found_0 : 1; /* bits 5:5 */
		ca_uint32_t PatErrSat : 1; /* bits 6:6 */
		ca_uint32_t xgxs_comma_found_1 : 1; /* bits 7:7 */
		ca_uint32_t SyncDet0 : 1; /* bits 8:8 */
		ca_uint32_t SyncDet1 : 1; /* bits 9:9 */
		ca_uint32_t SyncDet2 : 1; /* bits 10:10 */
		ca_uint32_t SyncDet3 : 1; /* bits 11:11 */
		ca_uint32_t xgxs_align_det : 1; /* bits 12:12 */
		ca_uint32_t xgxs_cpat_lock : 1; /* bits 13:13 */
		ca_uint32_t xgxs_A_column_found_0 : 1; /* bits 14:14 */
		ca_uint32_t xgxs_A_column_found_1 : 1; /* bits 15:15 */
		ca_uint32_t rsrvd3 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTSTAT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTERRUPT 0xf4304f5c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ErrorPktI : 1; /* bits 0:0 */
		ca_uint32_t ErrorPktSatI : 1; /* bits 1:1 */
		ca_uint32_t GoodPktSatI : 1; /* bits 2:2 */
		ca_uint32_t InvCodeI : 1; /* bits 3:3 */
		ca_uint32_t InvCodeSatI : 1; /* bits 4:4 */
		ca_uint32_t PatErrI : 1; /* bits 5:5 */
		ca_uint32_t PatErrSatI : 1; /* bits 6:6 */
		ca_uint32_t comma_foundI : 1; /* bits 7:7 */
		ca_uint32_t SyncDet0I : 1; /* bits 8:8 */
		ca_uint32_t SyncDet1I : 1; /* bits 9:9 */
		ca_uint32_t SyncDet2I : 1; /* bits 10:10 */
		ca_uint32_t SyncDet3I : 1; /* bits 11:11 */
		ca_uint32_t AlignDetI : 1; /* bits 12:12 */
		ca_uint32_t PatLockDetI : 1; /* bits 13:13 */
		ca_uint32_t A_column_found0I : 1; /* bits 14:14 */
		ca_uint32_t A_column_found1I : 1; /* bits 15:15 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTENABLE 0xf4304f60
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTENABLE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ErrorPkte : 1; /* bits 0:0 */
		ca_uint32_t ErrorPktSate : 1; /* bits 1:1 */
		ca_uint32_t GoodPktSate : 1; /* bits 2:2 */
		ca_uint32_t InvCodee : 1; /* bits 3:3 */
		ca_uint32_t InvCodeSate : 1; /* bits 4:4 */
		ca_uint32_t PatErre : 1; /* bits 5:5 */
		ca_uint32_t PatErrSate : 1; /* bits 6:6 */
		ca_uint32_t CommaFounde : 1; /* bits 7:7 */
		ca_uint32_t SyncDet0e : 1; /* bits 8:8 */
		ca_uint32_t SyncDet1e : 1; /* bits 9:9 */
		ca_uint32_t SyncDet2e : 1; /* bits 10:10 */
		ca_uint32_t SyncDet3e : 1; /* bits 11:11 */
		ca_uint32_t AlignDete : 1; /* bits 12:12 */
		ca_uint32_t PatLockDete : 1; /* bits 13:13 */
		ca_uint32_t A_column_found0e : 1; /* bits 14:14 */
		ca_uint32_t A_column_found1e : 1; /* bits 15:15 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTENABLE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_GoodPkt 0xf4304f64
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_GoodPkt_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t good_pkt_tx : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_GoodPkt_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ErrPkt 0xf4304f68
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ErrPkt_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t err_pkt_tx : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ErrPkt_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC0 0xf4304f6c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_icc_0 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC1 0xf4304f70
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_icc_1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC2 0xf4304f74
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_icc_2 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC3 0xf4304f78
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_icc_3 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC0 0xf4304f7c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_pec_0 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC1 0xf4304f80
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_pec_1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC2 0xf4304f84
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_pec_2 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC3 0xf4304f88
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xgxs_pec_3 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_SCRATCH 0xf4304f8c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_SCRATCH_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t scratch : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_SCRATCH_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgxs_tx */
#ifndef __ASSEMBLER__
typedef struct {
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl0_t TxCntrl0; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl1_t TxCntrl1; /* addr: 0x00000004 */
	ca_uint32_t rsrvd2[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl2_t TxCntrl2; /* addr: 0x00000008 */
	ca_uint32_t rsrvd3[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl3_t TxCntrl3; /* addr: 0x0000000c */
	ca_uint32_t rsrvd4[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl4_t TxCntrl4; /* addr: 0x00000010 */
	ca_uint32_t rsrvd5[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl5_t TxCntrl5; /* addr: 0x00000014 */
	ca_uint32_t rsrvd6[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTSTAT_t TX_INTSTAT; /* addr: 0x00000018 */
	ca_uint32_t rsrvd7[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTERRUPT_t
	  TX_INTERRUPT; /* addr: 0x0000001c */
	ca_uint32_t rsrvd8[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTENABLE_t
	  TX_INTENABLE; /* addr: 0x00000020 */
	ca_uint32_t rsrvd9[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_GoodPkt_t GoodPkt; /* addr: 0x00000024 */
	ca_uint32_t rsrvd10[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_ErrPkt_t ErrPkt; /* addr: 0x00000028 */
	ca_uint32_t rsrvd11[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC0_t ICC0; /* addr: 0x0000002c */
	ca_uint32_t rsrvd12[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC1_t ICC1; /* addr: 0x00000030 */
	ca_uint32_t rsrvd13[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC2_t ICC2; /* addr: 0x00000034 */
	ca_uint32_t rsrvd14[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC3_t ICC3; /* addr: 0x00000038 */
	ca_uint32_t rsrvd15[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC0_t PEC0; /* addr: 0x0000003c */
	ca_uint32_t rsrvd16[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC1_t PEC1; /* addr: 0x00000040 */
	ca_uint32_t rsrvd17[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC2_t PEC2; /* addr: 0x00000044 */
	ca_uint32_t rsrvd18[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC3_t PEC3; /* addr: 0x00000048 */
	ca_uint32_t rsrvd19[3];
	NI_HV_XAUI_XGXS_TOP_XGXS_TX_SCRATCH_t SCRATCH; /* addr: 0x0000004c */
} APB0_NI_HV_XAUI_XGXS_TOP_XGXS_TX_t;
#endif /* !__ASSEMBLER__ */

/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XGXS_TOP */

#ifndef __ASSEMBLER__
typedef struct {
	APB0_NI_HV_XAUI_XGXS_TOP_XGXS_RX_t xgxs_rx; /* addr: 0x00000000 */
	ca_uint32_t rsrvd1[41];
	APB0_NI_HV_XAUI_XGXS_TOP_XGXS_TX_t xgxs_tx; /* addr: 0x00000040 */
} APB0_NI_HV_XAUI_XGXS_TOP_t;
#endif /* !__ASSEMBLER__ */

/*
 * xaui_mac
 */

/*
 * ctrl
 */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPT 0xf4304fa0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rc_ffoverrun_intI : 1; /* bits 0:0 */
		ca_uint32_t tc_espkterr_intI : 1; /* bits 1:1 */
		ca_uint32_t rxestore0_intI : 1; /* bits 2:2 */
		ca_uint32_t rxestore1_intI : 1; /* bits 3:3 */
		ca_uint32_t rxestore2_intI : 1; /* bits 4:4 */
		ca_uint32_t rxestore3_intI : 1; /* bits 5:5 */
		ca_uint32_t txestore0_intI : 1; /* bits 6:6 */
		ca_uint32_t txestore1_intI : 1; /* bits 7:7 */
		ca_uint32_t txestore2_intI : 1; /* bits 8:8 */
		ca_uint32_t txestore3_intI : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t rc_ptp_pkt_intI : 1; /* bits 16:16 */
		ca_uint32_t tc_ptp_pkt_intI : 1; /* bits 17:17 */
		ca_uint32_t rsrvd2 : 6;
		ca_uint32_t tc_ffoverrun_intI : 1; /* bits 24:24 */
		ca_uint32_t tx_asyncff_underrun_intI : 1; /* bits 25:25 */
		ca_uint32_t tx_asyncff_overrun_intI : 1; /* bits 26:26 */
		ca_uint32_t rsrvd3 : 5;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPTE 0xf4304fa4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPTE_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rc_ffoverrun_intIE : 1; /* bits 0:0 */
		ca_uint32_t tc_espkterr_intIE : 1; /* bits 1:1 */
		ca_uint32_t rxestore0_intIE : 1; /* bits 2:2 */
		ca_uint32_t rxestore1_intIE : 1; /* bits 3:3 */
		ca_uint32_t rxestore2_intIE : 1; /* bits 4:4 */
		ca_uint32_t rxestore3_intIE : 1; /* bits 5:5 */
		ca_uint32_t txestore0_intIE : 1; /* bits 6:6 */
		ca_uint32_t txestore1_intIE : 1; /* bits 7:7 */
		ca_uint32_t txestore2_intIE : 1; /* bits 8:8 */
		ca_uint32_t txestore3_intIE : 1; /* bits 9:9 */
		ca_uint32_t rsrvd1 : 6;
		ca_uint32_t rc_ptp_pkt_intIE : 1; /* bits 16:16 */
		ca_uint32_t tc_ptp_pkt_intIE : 1; /* bits 17:17 */
		ca_uint32_t rsrvd2 : 6;
		ca_uint32_t tc_ffoverrun_intIE : 1; /* bits 24:24 */
		ca_uint32_t tx_asyncff_underrun_intIE : 1; /* bits 25:25 */
		ca_uint32_t tx_asyncff_overrun_intIE : 1; /* bits 26:26 */
		ca_uint32_t rsrvd3 : 5;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPTE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_CFG 0xf4304fa8
#define NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_CFG_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rx2tx_lpbk_en : 1; /* bits 0:0 */
		ca_uint32_t tx2rx_lpbk_en : 1; /* bits 1:1 */
		ca_uint32_t rs_locfault_en : 1; /* bits 2:2 */
		ca_uint32_t rs_rmtfault_en : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_CFG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_BRIGE_CTRL 0xf4304fac
#define NI_HV_XAUI_XAUI_MAC_CTRL_BRIGE_CTRL_dft 0xe4e40000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t flip_sds_xgxs_rx_en : 1; /* bits 0:0 */
		ca_uint32_t flip_sds_xgxs_tx_en : 1; /* bits 1:1 */
		ca_uint32_t pcs_line_swap_txd_en : 1; /* bits 2:2 */
		ca_uint32_t pcs_line_swap_rxd_en : 1; /* bits 3:3 */
		ca_uint32_t rx_invert_ctl : 1; /* bits 4:4 */
		ca_uint32_t tx_invert_ctl : 1; /* bits 5:5 */
		ca_uint32_t rx_data_resync0 : 1; /* bits 6:6 */
		ca_uint32_t rx_data_resync1 : 1; /* bits 7:7 */
		ca_uint32_t rx_data_resync2 : 1; /* bits 8:8 */
		ca_uint32_t rx_data_resync3 : 1; /* bits 9:9 */
		ca_uint32_t tx_data_resync0 : 1; /* bits 10:10 */
		ca_uint32_t tx_data_resync1 : 1; /* bits 11:11 */
		ca_uint32_t tx_data_resync2 : 1; /* bits 12:12 */
		ca_uint32_t tx_data_resync3 : 1; /* bits 13:13 */
		ca_uint32_t tx_scramble : 1; /* bits 14:14 */
		ca_uint32_t rx_scramble : 1; /* bits 15:15 */
		ca_uint32_t rxswap0 : 2; /* bits 17:16 */
		ca_uint32_t rxswap1 : 2; /* bits 19:18 */
		ca_uint32_t rxswap2 : 2; /* bits 21:20 */
		ca_uint32_t rxswap3 : 2; /* bits 23:22 */
		ca_uint32_t txswap0 : 2; /* bits 25:24 */
		ca_uint32_t txswap1 : 2; /* bits 27:26 */
		ca_uint32_t txswap2 : 2; /* bits 29:28 */
		ca_uint32_t txswap3 : 2; /* bits 31:30 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_BRIGE_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_H 0xf4304fb0
#define NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_H_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_H_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_L 0xf4304fb4
#define NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_L_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t address : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_L_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_MODE 0xf4304fb8
#define NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_MODE_dft 0x40003601

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ctrl_mode_en : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 3;
		ca_uint32_t flush_pkt_en : 5; /* bits 8:4 */
		ca_uint32_t flush_pkt_en1 : 1; /* bits 9:9 */
		ca_uint32_t flush_pkt_sdid : 1; /* bits 10:10 */
		ca_uint32_t rsrvd2 : 1;
		ca_uint32_t pkt_tocsport_en : 1; /* bits 12:12 */
		ca_uint32_t pkt_toupport_en : 1; /* bits 13:13 */
		ca_uint32_t pkt_tocsport_toup : 1; /* bits 14:14 */
		ca_uint32_t pkt_toupport_tocs : 1; /* bits 15:15 */
		ca_uint32_t flush_touplink_pkt : 1; /* bits 16:16 */
		ca_uint32_t rsrvd3 : 13;
		ca_uint32_t mask_nop_en : 1; /* bits 30:30 */
		ca_uint32_t mask_ddbm_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_MODE_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_CTL 0xf4304fbc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_CTL_dft 0x0007b800

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t clr_rcffoverrun : 1; /* bits 0:0 */
		ca_uint32_t drop_ptp_pkt_type : 10; /* bits 10:1 */
		ca_uint32_t qbb_pause_drop_en : 1; /* bits 11:11 */
		ca_uint32_t frame_error_drop_en : 1; /* bits 12:12 */
		ca_uint32_t frame_fcs_error_drop_en : 1; /* bits 13:13 */
		ca_uint32_t frame_bytecnt_drop_en : 1; /* bits 14:14 */
		ca_uint32_t frame_pause_drop_en : 1; /* bits 15:15 */
		ca_uint32_t frame_runt_drop_en : 1; /* bits 16:16 */
		ca_uint32_t frame_oversize_drop_en : 1; /* bits 17:17 */
		ca_uint32_t frame_ffoverflow_drop_en : 1; /* bits 18:18 */
		ca_uint32_t frame_management_drop_en : 1; /* bits 19:19 */
		ca_uint32_t frame_nomanagement_drop_en : 1; /* bits 20:20 */
		ca_uint32_t rsrvd1 : 2;
		ca_uint32_t qbb_pause_det_en : 1; /* bits 23:23 */
		ca_uint32_t bypass : 1; /* bits 24:24 */
		ca_uint32_t ptp_ing_ts_cmp : 5; /* bits 29:25 */
		ca_uint32_t rx_pkt_clr : 1; /* bits 30:30 */
		ca_uint32_t ptp_da_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_CTL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_HI 0xf4304fc0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_HI_dft 0x00000180

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_da : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_HI_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_LO 0xf4304fc4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_LO_dft 0xc2000001

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_da : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_LO_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE0 0xf4304fc8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE0_dft 0x00008809

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_type0 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t det_type0_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE1 0xf4304fcc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE1_dft 0x00008808

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_type1 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t det_type1_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE2 0xf4304fd0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE2_dft 0x00008863

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_type2 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t det_type2_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE3 0xf4304fd4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE3_dft 0x00008864

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_type3 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t det_type3_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE4 0xf4304fd8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE4_dft 0x0000888e

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_type4 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t det_type4_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE5 0xf4304fdc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE5_dft 0x00000806

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_type5 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t det_type5_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE6 0xf4304fe0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE6_dft 0x0000814c

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_type6 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t det_type6_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE6_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE7 0xf4304fe4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE7_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t management_type7 : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 15;
		ca_uint32_t det_type7_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE7_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWON_CTL 0xf4304fe8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWON_CTL_dft 0x000001ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xon_threshold : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWON_CTL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWOFF_CTL 0xf4304fec
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWOFF_CTL_dft 0x000002ff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t xoff_threshold : 10; /* bits 9:0 */
		ca_uint32_t rsrvd1 : 22;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWOFF_CTL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_CTL 0xf4304ff0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_CTL_dft 0x00ff0000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pau_flow_en : 1; /* bits 0:0 */
		ca_uint32_t tx_remheader_dis : 1; /* bits 1:1 */
		ca_uint32_t tx_pkt_clr : 1; /* bits 2:2 */
		ca_uint32_t tx_pad_en : 1; /* bits 3:3 */
		ca_uint32_t loopback : 1; /* bits 4:4 */
		ca_uint32_t ptp_eg_ts_comp : 5; /* bits 9:5 */
		ca_uint32_t external_pausereq_pol : 1; /* bits 10:10 */
		ca_uint32_t rsrvd1 : 4;
		ca_uint32_t qbb_flow_en : 1; /* bits 15:15 */
		ca_uint32_t qbb_qen : 8; /* bits 23:16 */
		ca_uint32_t rsrvd2 : 3;
		ca_uint32_t external_txstop_sel : 1; /* bits 27:27 */
		ca_uint32_t internal_txstop_sel : 1; /* bits 28:28 */
		ca_uint32_t external_pausereq_sel : 1; /* bits 29:29 */
		ca_uint32_t rx_pausereq_sel : 1; /* bits 30:30 */
		ca_uint32_t te_pfcreq_sel : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_CTL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA 0xf4304ff4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA_dft 0x7f0dffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta : 16; /* bits 15:0 */
		ca_uint32_t adjust_qbb_cnt : 8; /* bits 23:16 */
		ca_uint32_t adjust_1g_qbb_cnt : 8; /* bits 31:24 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA1 0xf4304ff8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA1_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA2 0xf4304ffc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA2_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA3 0xf4305000
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA3_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA4 0xf4305004
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA4_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA5 0xf4305008
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA5_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA6 0xf430500c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA6_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA6_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA7 0xf4305010
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA7_dft 0x0000ffff

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pause_quanta : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA7_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_FF_THRESHOLD 0xf4305014
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_FF_THRESHOLD_dft 0x803f01fa

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t txff_wrff_threshold : 6; /* bits 5:0 */
		ca_uint32_t txff_rdff_threshold : 6; /* bits 11:6 */
		ca_uint32_t txctl_wrff_threshold : 9; /* bits 20:12 */
		ca_uint32_t rd_thre_en : 1; /* bits 21:21 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t txctl_rdff_threshold : 9; /* bits 31:23 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_FF_THRESHOLD_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS0 0xf4305018
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rcdrop_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS1 0xf430501c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t rcff_pktnum : 11; /* bits 10:0 */
		ca_uint32_t rs_locfault : 1; /* bits 11:11 */
		ca_uint32_t rs_rmtfault : 1; /* bits 12:12 */
		ca_uint32_t rsrvd1 : 19;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS2 0xf4305020
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS2_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_torxmux_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS2_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS3 0xf4305024
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_tocstxmux_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS4 0xf4305028
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_touptxmux_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS5 0xf430502c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS5_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_tocstxmux_errcnt : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS5_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS6 0xf4305030
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS6_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t pkt_cs_flushcnt : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 27;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS6_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS0 0xf4305034
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS0_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tcdrop_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS0_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS1 0xf4305038
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS1_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tcff_pktnum : 9; /* bits 8:0 */
		ca_uint32_t rsrvd1 : 23;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS1_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS3 0xf430503c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS3_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t length_mismatch : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS3_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS4 0xf4305040
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS4_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t es_runt_pkt : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS4_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FF_STATUS 0xf4305044
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FF_STATUS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t tx_ffempty : 1; /* bits 0:0 */
		ca_uint32_t tx_fffull : 1; /* bits 1:1 */
		ca_uint32_t rx_ffempty : 1; /* bits 2:2 */
		ca_uint32_t rx_fffull : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FF_STATUS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_BP_CTRL 0xf4305048
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_BP_CTRL_dft 0x00ffd200

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cascade_bp_en : 1; /* bits 0:0 */
		ca_uint32_t external_stoptx_en : 1; /* bits 1:1 */
		ca_uint32_t external_pausereq_en : 1; /* bits 2:2 */
		ca_uint32_t external_pausereq_pol : 1; /* bits 3:3 */
		ca_uint32_t cascade_ff_threshold : 10; /* bits 13:4 */
		ca_uint32_t external_pausereq_oen_sel : 1; /* bits 14:14 */
		ca_uint32_t external_pausereq_oen : 1; /* bits 15:15 */
		ca_uint32_t xaui_die_tx_threshold : 9; /* bits 24:16 */
		ca_uint32_t external_stop_lcl_en : 1; /* bits 25:25 */
		ca_uint32_t uplink_lcl_pol : 1; /* bits 26:26 */
		ca_uint32_t rsrvd1 : 1;
		ca_uint32_t dbg_sel : 3; /* bits 30:28 */
		ca_uint32_t die_cascade_bp_en : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_BP_CTRL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_SLD_ERRCNT 0xf430504c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_SLD_ERRCNT_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t sld_crc8_err_cnt : 16; /* bits 15:0 */
		ca_uint32_t rsrvd1 : 16;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_SLD_ERRCNT_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RAM_STATUS_REG 0xf4305050
#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RAM_STATUS_REG_dft 0x00000001

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ram_initdone : 1; /* bits 0:0 */
		ca_uint32_t rsrvd1 : 31;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RAM_STATUS_REG_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_CTL 0xf4305054
#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_CTL_dft 0x00000009

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t ram_clr_en : 1; /* bits 0:0 */
		ca_uint32_t ram_sw_initial : 1; /* bits 1:1 */
		ca_uint32_t dbg_sel : 1; /* bits 2:2 */
		ca_uint32_t term_dbg_en : 1; /* bits 3:3 */
		ca_uint32_t rsrvd1 : 28;
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_MIB_CTL_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_ACCESS 0xf4305058
#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Addr : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 25;
		ca_uint32_t rw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_DATA 0xf430505c
#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_DATA_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t cnt : 32; /* bits 31:0 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_DATA_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_ACCESS 0xf4305060
#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_ACCESS_dft 0x00000000

#ifndef __ASSEMBLER__
typedef volatile union {
	struct {
		ca_uint32_t Addr : 5; /* bits 4:0 */
		ca_uint32_t rsrvd1 : 25;
		ca_uint32_t rw : 1; /* bits 30:30 */
		ca_uint32_t access : 1; /* bits 31:31 */
	} bf;
	ca_uint32_t wrd;
} NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_ACCESS_t;
#endif /* !__ASSEMBLER__ */

#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_DATA 0xf4305064
#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_DATA_dft 0x00000000

#ifndef __ASSEM