#ifndef _RTL8195A_SPI_FLASH_BIT_H
#define _RTL8195A_SPI_FLASH_BIT_H

#define CPU_OPT_WIDTH 0x1F

//2 REG_NOT_VALID

//2 REG_SPIC_CTRLR0

#define BIT_SHIFT_CK_MTIMES 21
#define BIT_MASK_CK_MTIMES 0x1f
#define BIT_CK_MTIMES(x) (((x) & BIT_MASK_CK_MTIMES) << BIT_SHIFT_CK_MTIMES)

#define BIT_FAST_RD BIT(20)

#define BIT_SHIFT_DATA_CH 18
#define BIT_MASK_DATA_CH 0x3
#define BIT_DATA_CH(x) (((x) & BIT_MASK_DATA_CH) << BIT_SHIFT_DATA_CH)


#define BIT_SHIFT_ADDR_CH 16
#define BIT_MASK_ADDR_CH 0x3
#define BIT_ADDR_CH(x) (((x) & BIT_MASK_ADDR_CH) << BIT_SHIFT_ADDR_CH)


#define BIT_SHIFT_TMOD 8
#define BIT_MASK_TMOD 0x3
#define BIT_TMOD(x) (((x) & BIT_MASK_TMOD) << BIT_SHIFT_TMOD)

#define BIT_SCPOL BIT(7)
#define BIT_SCPH BIT(6)

//2 REG_SPIC_CTRLR1

#define BIT_SHIFT_NDF 0
#define BIT_MASK_NDF 0xfff
#define BIT_NDF(x) (((x) & BIT_MASK_NDF) << BIT_SHIFT_NDF)


//2 REG_SPIC_SSIENR
#define BIT_ATCK_CMD BIT(1)
#define BIT_SPIC_EN BIT(0)

//2 REG_SPIC_MWCR

//2 REG_SPIC_SER
#define BIT_SER BIT(0)

//2 REG_SPIC_BAUDR

#define BIT_SHIFT_SCKDV 0
#define BIT_MASK_SCKDV 0xffff
#define BIT_SCKDV(x) (((x) & BIT_MASK_SCKDV) << BIT_SHIFT_SCKDV)


//2 REG_SPIC_TXFTLR

#define BIT_SHIFT_TFT 0
#define BIT_MASK_TFT 0x1f
#define BIT_TFT(x) (((x) & BIT_MASK_TFT) << BIT_SHIFT_TFT)


//2 REG_SPIC_RXFTLR

#define BIT_SHIFT_RFT 0
#define BIT_MASK_RFT 0x1f
#define BIT_RFT(x) (((x) & BIT_MASK_RFT) << BIT_SHIFT_RFT)


//2 REG_SPIC_TXFLR

#define BIT_SHIFT_TXFL 0
#define BIT_MASK_TXFL 0x3f
#define BIT_TXFL(x) (((x) & BIT_MASK_TXFL) << BIT_SHIFT_TXFL)


//2 REG_SPIC_RXFLR

#define BIT_SHIFT_RXFL 0
#define BIT_MASK_RXFL 0x3f
#define BIT_RXFL(x) (((x) & BIT_MASK_RXFL) << BIT_SHIFT_RXFL)


//2 REG_SPIC_SR
#define BIT_TXE BIT(5)
#define BIT_RFF BIT(4)
#define BIT_RFNE BIT(3)
#define BIT_TFE BIT(2)
#define BIT_TFNF BIT(1)
#define BIT_BUSY BIT(0)

//2 REG_SPIC_IMR
#define BIT_TXSIM BIT(6)
#define BIT_MSTIM BIT(5)
#define BIT_RXFIM BIT(4)
#define BIT_RXOIM BIT(3)
#define BIT_RXUIM BIT(2)
#define BIT_TXOIM BIT(1)
#define BIT_TXEIM BIT(0)

//2 REG_SPIC_ISR
#define BIT_TXSIS BIT(6)
#define BIT_MSTIS BIT(5)
#define BIT_RXFIS BIT(4)
#define BIT_RXOIS BIT(3)
#define BIT_RXUIS BIT(2)
#define BIT_TXOIS BIT(1)
#define BIT_TXEIS BIT(0)

//2 REG_SPIC_RISR
#define BIT_MSTIS BIT(5)
#define BIT_RXFIS BIT(4)
#define BIT_RXOIS BIT(3)
#define BIT_RXUIS BIT(2)
#define BIT_TXOIS BIT(1)
#define BIT_TXEIS BIT(0)

//2 REG_SPIC_TXOICR
#define BIT_TXOICR BIT(0)

//2 REG_SPIC_RXOICR
#define BIT_RXOCIR BIT(0)

//2 REG_SPC_RXUICR
#define BIT_RXUICR BIT(0)

//2 REG_SPIC_MSTICR
#define BIT_MSTICR BIT(0)

//2 REG_SPIC_ICR

#define BIT_SHIFT_ICR 0
#define BIT_MASK_ICR 0xff
#define BIT_ICR(x) (((x) & BIT_MASK_ICR) << BIT_SHIFT_ICR)


//2 REG_SPIC_DMACR

//2 REG_SPIC_DMATDLR0

//2 REG_SPIC_DMATDLR1

//2 REG_SPIC_IDR

#define BIT_SHIFT_IDCODE 0
#define BIT_MASK_IDCODE 0xffffffffL
#define BIT_IDCODE(x) (((x) & BIT_MASK_IDCODE) << BIT_SHIFT_IDCODE)


//2 REG_SPIC_VERSION

#define BIT_SHIFT_SPIC_VERSION 0
#define BIT_MASK_SPIC_VERSION 0xff
#define BIT_SPIC_VERSION(x) (((x) & BIT_MASK_SPIC_VERSION) << BIT_SHIFT_SPIC_VERSION)


//2 REG_SPIC_DR0

#define BIT_SHIFT_DR0 0
#define BIT_MASK_DR0 0xffffffffL
#define BIT_DR0(x) (((x) & BIT_MASK_DR0) << BIT_SHIFT_DR0)


//2 REG_SPIC_DR1

#define BIT_SHIFT_DR1 0
#define BIT_MASK_DR1 0xffffffffL
#define BIT_DR1(x) (((x) & BIT_MASK_DR1) << BIT_SHIFT_DR1)


//2 REG_SPIC_DR2

#define BIT_SHIFT_DR2 0
#define BIT_MASK_DR2 0xffffffffL
#define BIT_DR2(x) (((x) & BIT_MASK_DR2) << BIT_SHIFT_DR2)


//2 REG_SPIC_DR3

#define BIT_SHIFT_DR3 0
#define BIT_MASK_DR3 0xffffffffL
#define BIT_DR3(x) (((x) & BIT_MASK_DR3) << BIT_SHIFT_DR3)


//2 REG_SPIC_DR4

#define BIT_SHIFT_DR4 0
#define BIT_MASK_DR4 0xffffffffL
#define BIT_DR4(x) (((x) & BIT_MASK_DR4) << BIT_SHIFT_DR4)


//2 REG_SPIC_DR5

#define BIT_SHIFT_DR5 0
#define BIT_MASK_DR5 0xffffffffL
#define BIT_DR5(x) (((x) & BIT_MASK_DR5) << BIT_SHIFT_DR5)


//2 REG_SPIC_DR6

#define BIT_SHIFT_DR6 0
#define BIT_MASK_DR6 0xffffffffL
#define BIT_DR6(x) (((x) & BIT_MASK_DR6) << BIT_SHIFT_DR6)


//2 REG_SPIC_DR7

#define BIT_SHIFT_DR7 0
#define BIT_MASK_DR7 0xffffffffL
#define BIT_DR7(x) (((x) & BIT_MASK_DR7) << BIT_SHIFT_DR7)


//2 REG_SPIC_DR8

#define BIT_SHIFT_DR8 0
#define BIT_MASK_DR8 0xffffffffL
#define BIT_DR8(x) (((x) & BIT_MASK_DR8) << BIT_SHIFT_DR8)


//2 REG_SPIC_DR9

#define BIT_SHIFT_DR9 0
#define BIT_MASK_DR9 0xffffffffL
#define BIT_DR9(x) (((x) & BIT_MASK_DR9) << BIT_SHIFT_DR9)


//2 REG_SPIC_DR10

#define BIT_SHIFT_DR10 0
#define BIT_MASK_DR10 0xffffffffL
#define BIT_DR10(x) (((x) & BIT_MASK_DR10) << BIT_SHIFT_DR10)


//2 REG_SPIC_DR11

#define BIT_SHIFT_DR11 0
#define BIT_MASK_DR11 0xffffffffL
#define BIT_DR11(x) (((x) & BIT_MASK_DR11) << BIT_SHIFT_DR11)


//2 REG_SPIC_DR12

#define BIT_SHIFT_DR12 0
#define BIT_MASK_DR12 0xffffffffL
#define BIT_DR12(x) (((x) & BIT_MASK_DR12) << BIT_SHIFT_DR12)


//2 REG_SPIC_DR13

#define BIT_SHIFT_DR13 0
#define BIT_MASK_DR13 0xffffffffL
#define BIT_DR13(x) (((x) & BIT_MASK_DR13) << BIT_SHIFT_DR13)


//2 REG_SPIC_DR14

#define BIT_SHIFT_DR14 0
#define BIT_MASK_DR14 0xffffffffL
#define BIT_DR14(x) (((x) & BIT_MASK_DR14) << BIT_SHIFT_DR14)


//2 REG_SPIC_DR15

#define BIT_SHIFT_DR15 0
#define BIT_MASK_DR15 0xffffffffL
#define BIT_DR15(x) (((x) & BIT_MASK_DR15) << BIT_SHIFT_DR15)


//2 REG_SPIC_DR16

#define BIT_SHIFT_DR16 0
#define BIT_MASK_DR16 0xffffffffL
#define BIT_DR16(x) (((x) & BIT_MASK_DR16) << BIT_SHIFT_DR16)


//2 REG_SPIC_DR17

#define BIT_SHIFT_DR17 0
#define BIT_MASK_DR17 0xffffffffL
#define BIT_DR17(x) (((x) & BIT_MASK_DR17) << BIT_SHIFT_DR17)


//2 REG_SPIC_DR18

#define BIT_SHIFT_DR18 0
#define BIT_MASK_DR18 0xffffffffL
#define BIT_DR18(x) (((x) & BIT_MASK_DR18) << BIT_SHIFT_DR18)


//2 REG_SPIC_DR19

#define BIT_SHIFT_DR19 0
#define BIT_MASK_DR19 0xffffffffL
#define BIT_DR19(x) (((x) & BIT_MASK_DR19) << BIT_SHIFT_DR19)


//2 REG_SPIC_DR20

#define BIT_SHIFT_DR20 0
#define BIT_MASK_DR20 0xffffffffL
#define BIT_DR20(x) (((x) & BIT_MASK_DR20) << BIT_SHIFT_DR20)


//2 REG_SPIC_DR21

#define BIT_SHIFT_DR21 0
#define BIT_MASK_DR21 0xffffffffL
#define BIT_DR21(x) (((x) & BIT_MASK_DR21) << BIT_SHIFT_DR21)


//2 REG_SPIC_DR22

#define BIT_SHIFT_DR22 0
#define BIT_MASK_DR22 0xffffffffL
#define BIT_DR22(x) (((x) & BIT_MASK_DR22) << BIT_SHIFT_DR22)


//2 REG_SPIC_DR23

#define BIT_SHIFT_DR23 0
#define BIT_MASK_DR23 0xffffffffL
#define BIT_DR23(x) (((x) & BIT_MASK_DR23) << BIT_SHIFT_DR23)


//2 REG_SPIC_DR24

#define BIT_SHIFT_DR24 0
#define BIT_MASK_DR24 0xffffffffL
#define BIT_DR24(x) (((x) & BIT_MASK_DR24) << BIT_SHIFT_DR24)


//2 REG_SPIC_DR25

#define BIT_SHIFT_DR25 0
#define BIT_MASK_DR25 0xffffffffL
#define BIT_DR25(x) (((x) & BIT_MASK_DR25) << BIT_SHIFT_DR25)


//2 REG_SPIC_DR26

#define BIT_SHIFT_DR26 0
#define BIT_MASK_DR26 0xffffffffL
#define BIT_DR26(x) (((x) & BIT_MASK_DR26) << BIT_SHIFT_DR26)


//2 REG_SPIC_DR27

#define BIT_SHIFT_DR27 0
#define BIT_MASK_DR27 0xffffffffL
#define BIT_DR27(x) (((x) & BIT_MASK_DR27) << BIT_SHIFT_DR27)


//2 REG_SPIC_DR28

#define BIT_SHIFT_DR28 0
#define BIT_MASK_DR28 0xffffffffL
#define BIT_DR28(x) (((x) & BIT_MASK_DR28) << BIT_SHIFT_DR28)


//2 REG_SPIC_DR29

#define BIT_SHIFT_DR29 0
#define BIT_MASK_DR29 0xffffffffL
#define BIT_DR29(x) (((x) & BIT_MASK_DR29) << BIT_SHIFT_DR29)


//2 REG_SPIC_DR30

#define BIT_SHIFT_DR30 0
#define BIT_MASK_DR30 0xffffffffL
#define BIT_DR30(x) (((x) & BIT_MASK_DR30) << BIT_SHIFT_DR30)


//2 REG_SPIC_DR31

#define BIT_SHIFT_DR31 0
#define BIT_MASK_DR31 0xffffffffL
#define BIT_DR31(x) (((x) & BIT_MASK_DR31) << BIT_SHIFT_DR31)


//2 REG_SPIC_READ_FAST_SINGLE

#define BIT_SHIFT_FRD_CMD 0
#define BIT_MASK_FRD_CMD 0xff
#define BIT_FRD_CMD(x) (((x) & BIT_MASK_FRD_CMD) << BIT_SHIFT_FRD_CMD)


//2 REG_SPIC_READ_DUAL_DATA

#define BIT_SHIFT_RD_DUAL_O_CMD 0
#define BIT_MASK_RD_DUAL_O_CMD 0xff
#define BIT_RD_DUAL_O_CMD(x) (((x) & BIT_MASK_RD_DUAL_O_CMD) << BIT_SHIFT_RD_DUAL_O_CMD)


//2 REG_SPIC_READ_DUAL_ADDR_DATA

#define BIT_SHIFT_RD_DUAL_IO_CMD 0
#define BIT_MASK_RD_DUAL_IO_CMD 0xff
#define BIT_RD_DUAL_IO_CMD(x) (((x) & BIT_MASK_RD_DUAL_IO_CMD) << BIT_SHIFT_RD_DUAL_IO_CMD)


//2 REG_SPIC_READ_QUAD_DATA

#define BIT_SHIFT_RD_QUAD_O_CMD 0
#define BIT_MASK_RD_QUAD_O_CMD 0xff
#define BIT_RD_QUAD_O_CMD(x) (((x) & BIT_MASK_RD_QUAD_O_CMD) << BIT_SHIFT_RD_QUAD_O_CMD)


//2 REG_SPIC_READ_QUAD_ADDR_DATA

#define BIT_SHIFT_RD_QUAD_IO_CMD 0
#define BIT_MASK_RD_QUAD_IO_CMD 0xff
#define BIT_RD_QUAD_IO_CMD(x) (((x) & BIT_MASK_RD_QUAD_IO_CMD) << BIT_SHIFT_RD_QUAD_IO_CMD)


//2 REG_SPIC_WRITE_SIGNLE

#define BIT_SHIFT_WR_CMD 0
#define BIT_MASK_WR_CMD 0xff
#define BIT_WR_CMD(x) (((x) & BIT_MASK_WR_CMD) << BIT_SHIFT_WR_CMD)


//2 REG_SPIC_WRITE_DUAL_DATA

#define BIT_SHIFT_WR_DUAL_I_CMD 0
#define BIT_MASK_WR_DUAL_I_CMD 0xff
#define BIT_WR_DUAL_I_CMD(x) (((x) & BIT_MASK_WR_DUAL_I_CMD) << BIT_SHIFT_WR_DUAL_I_CMD)


//2 REG_SPIC_WRITE_DUAL_ADDR_DATA

#define BIT_SHIFT_WR_DUAL_II_CMD 0
#define BIT_MASK_WR_DUAL_II_CMD 0xff
#define BIT_WR_DUAL_II_CMD(x) (((x) & BIT_MASK_WR_DUAL_II_CMD) << BIT_SHIFT_WR_DUAL_II_CMD)


//2 REG_SPIC_WRITE_QUAD_DATA

#define BIT_SHIFT_WR_QUAD_I_CMD 0
#define BIT_MASK_WR_QUAD_I_CMD 0xff
#define BIT_WR_QUAD_I_CMD(x) (((x) & BIT_MASK_WR_QUAD_I_CMD) << BIT_SHIFT_WR_QUAD_I_CMD)


//2 REG_SPIC_WRITE_QUAD_ADDR_DATA

#define BIT_SHIFT_WR_QUAD_II_CMD 0
#define BIT_MASK_WR_QUAD_II_CMD 0xff
#define BIT_WR_QUAD_II_CMD(x) (((x) & BIT_MASK_WR_QUAD_II_CMD) << BIT_SHIFT_WR_QUAD_II_CMD)


//2 REG_SPIC_WRITE_ENABLE

#define BIT_SHIFT_WR_EN_CMD 0
#define BIT_MASK_WR_EN_CMD 0xff
#define BIT_WR_EN_CMD(x) (((x) & BIT_MASK_WR_EN_CMD) << BIT_SHIFT_WR_EN_CMD)


//2 REG_SPIC_READ_STATUS

#define BIT_SHIFT_RD_ST_CMD 0
#define BIT_MASK_RD_ST_CMD 0xff
#define BIT_RD_ST_CMD(x) (((x) & BIT_MASK_RD_ST_CMD) << BIT_SHIFT_RD_ST_CMD)


//2 REG_SPIC_CTRLR2

#define BIT_SHIFT_FIFO_ENTRY 4
#define BIT_MASK_FIFO_ENTRY 0xf
#define BIT_FIFO_ENTRY(x) (((x) & BIT_MASK_FIFO_ENTRY) << BIT_SHIFT_FIFO_ENTRY)

#define BIT_WR_SEQ BIT(3)
#define BIT_WPN_DNUM BIT(2)
#define BIT_WPN_SET BIT(1)
#define BIT_SO_DUM BIT(0)

//2 REG_SPIC_FBAUDR

#define BIT_SHIFT_FSCKDV 0
#define BIT_MASK_FSCKDV 0xfff
#define BIT_FSCKDV(x) (((x) & BIT_MASK_FSCKDV) << BIT_SHIFT_FSCKDV)


//2 REG_SPIC_ADDR_LENGTH

#define BIT_SHIFT_ADDR_PHASE_LENGTH 0
#define BIT_MASK_ADDR_PHASE_LENGTH 0x3
#define BIT_ADDR_PHASE_LENGTH(x) (((x) & BIT_MASK_ADDR_PHASE_LENGTH) << BIT_SHIFT_ADDR_PHASE_LENGTH)


//2 REG_SPIC_AUTO_LENGTH

#define BIT_SHIFT_CS_H_WR_DUM_LEN 28
#define BIT_MASK_CS_H_WR_DUM_LEN 0xf
#define BIT_CS_H_WR_DUM_LEN(x) (((x) & BIT_MASK_CS_H_WR_DUM_LEN) << BIT_SHIFT_CS_H_WR_DUM_LEN)


#define BIT_SHIFT_CS_H_RD_DUM_LEN 26
#define BIT_MASK_CS_H_RD_DUM_LEN 0x3
#define BIT_CS_H_RD_DUM_LEN(x) (((x) & BIT_MASK_CS_H_RD_DUM_LEN) << BIT_SHIFT_CS_H_RD_DUM_LEN)


#define BIT_SHIFT_AUTO_DUM_LEN 18
#define BIT_MASK_AUTO_DUM_LEN 0xff
#define BIT_AUTO_DUM_LEN(x) (((x) & BIT_MASK_AUTO_DUM_LEN) << BIT_SHIFT_AUTO_DUM_LEN)


#define BIT_SHIFT_AUTO_ADDR__LENGTH 16
#define BIT_MASK_AUTO_ADDR__LENGTH 0x3
#define BIT_AUTO_ADDR__LENGTH(x) (((x) & BIT_MASK_AUTO_ADDR__LENGTH) << BIT_SHIFT_AUTO_ADDR__LENGTH)


#define BIT_SHIFT_RD_DUMMY_LENGTH 0
#define BIT_MASK_RD_DUMMY_LENGTH 0xffff
#define BIT_RD_DUMMY_LENGTH(x) (((x) & BIT_MASK_RD_DUMMY_LENGTH) << BIT_SHIFT_RD_DUMMY_LENGTH)


//2 REG_SPIC_VALID_CMD
#define BIT_WR_BLOCKING BIT(9)
#define BIT_WR_QUAD_II BIT(8)
#define BIT_WR_QUAD_I BIT(7)
#define BIT_WR_DUAL_II BIT(6)
#define BIT_WR_DUAL_I BIT(5)
#define BIT_RD_QUAD_IO BIT(4)
#define BIT_RD_QUAD_O BIT(3)
#define BIT_RD_DUAL_IO BIT(2)
#define BIT_RD_DUAL_I BIT(1)
#define BIT_FRD_SINGEL BIT(0)

//2 REG_SPIC_FLASE_SIZE

#define BIT_SHIFT_FLASE_SIZE 0
#define BIT_MASK_FLASE_SIZE 0xf
#define BIT_FLASE_SIZE(x) (((x) & BIT_MASK_FLASE_SIZE) << BIT_SHIFT_FLASE_SIZE)


//2 REG_SPIC_FLUSH_FIFO
#define BIT_FLUSH_FIFO BIT(0)

#endif
