#ifndef __INC_RTL8195A_PERI_ON_H
#define __INC_RTL8195A_PERI_ON_H

#define CPU_OPT_WIDTH 0x1F

//2 REG_NOT_VALID

//2 REG_PEON_PWR_CTRL
#define BIT_SOC_UAHV_EN BIT(2)
#define BIT_SOC_UALV_EN BIT(1)
#define BIT_SOC_USBD_EN BIT(0)

//2 REG_PON_ISO_CTRL

//2 REG_NOT_VALID
#define BIT_ISO_OSC32K_EN BIT(4)
//#define BIT_ISO_USBA_EN BIT(1)
//#define BIT_ISO_USBD_EN BIT(0)

//2 REG_RSVD

//2 REG_RSVD

//2 REG_NOT_VALID

//2 REG_SOC_FUNC_EN
#define BIT_SOC_SECURITY_ENGINE_EN BIT(20)
#define BIT_SOC_GTIMER_EN BIT(16)
#define BIT_SOC_GDMA1_EN BIT(14)
#define BIT_SOC_GDMA0_EN BIT(13)
#define BIT_SOC_LOG_UART_EN BIT(12)
#define BIT_SOC_CPU_EN BIT(8)
#define BIT_SOC_MEM_CTRL_EN BIT(6)
#define BIT_SOC_FLASH_EN BIT(4)
#define BIT_SOC_LXBUS_EN BIT(2)
#define BIT_SOC_OCP_EN BIT(1)
#define BiT_SOC_FUN_EN BIT(0)

//2 REG_SOC_HCI_COM_FUNC_EN
#define BIT_SOC_HCI_WL_MACON_EN BIT(16)
#define BIT_SOC_HCI_SM_SEL BIT(13)
#define BIT_SOC_HCI_MII_EN BIT(12)
#define BIT_SOC_HCI_OTG_RST_MUX BIT(5)
#define BIT_SOC_HCI_OTG_EN BIT(4)
#define BIT_SOC_HCI_SDIOD_ON_RST_MUX BIT(3)
#define BIT_SOC_HCI_SDIOH_EN BIT(2)
#define BIT_SOC_HCI_SDIOD_OFF_EN BIT(1)
#define BIT_SOC_HCI_SDIOD_ON_EN BIT(0)

//2 REG_SOC_PERI_FUNC0_EN
#define BIT_PERI_PCM1_EN BIT(29)
#define BIT_PERI_PCM0_EN BIT(28)
#define BIT_PERI_I2S1_EN BIT(25)
#define BIT_PERI_I2S0_EN BIT(24)
#define BIT_PERI_I2C3_EN BIT(19)
#define BIT_PERI_I2C2_EN BIT(18)
#define BIT_PERI_I2C1_EN BIT(17)
#define BIT_PERI_I2C0_EN BIT(16)
#define BIT_PERI_SPI2_EN BIT(10)
#define BIT_PERI_SPI1_EN BIT(9)
#define BIT_PERI_SPI0_EN BIT(8)
#define BIT_PERI_UART2_EN BIT(2)
#define BIT_PERI_UART1_EN BIT(1)
#define BIT_PERI_UART0_EN BIT(0)

//2 REG_SOC_PERI_FUNC1_EN
#define BIT_PERI_GPIO_EN BIT(8)
#define BIT_PERI_DAC1_EN BIT(5)
#define BIT_PERI_DAC0_EN BIT(4)
#define BIT_PERI_ADC0_EN BIT(0)

//2 REG_SOC_PERI_BD_FUNC0_EN
#define BIT_PERI_UART2_BD_EN BIT(2)
#define BIT_PERI_UART1_BD_EN BIT(1)
#define BIT_PERI_UART0_BD_EN BIT(0)

//2 REG_RSVD

//2 REG_RSVD

//2 REG_NOT_VALID

//2 REG_RSVD

//2 REG_PESOC_CLK_CTRL
#define BIT_SOC_SLPCK_BTCMD_EN BIT(29)
#define BIT_SOC_ACTCK_BTCMD_EN BIT(28)
#define BIT_SOC_SLPCK_GPIO_EN BIT(25)
#define BIT_SOC_ACTCK_GPIO_EN BIT(24)
#define BIT_SOC_SLPCK_GDMA1_EN BIT(19)
#define BIT_SOC_ACTCK_GDMA1_EN BIT(18)
#define BIT_SOC_SLPCK_GDMA0_EN BIT(17)
#define BIT_SOC_ACTCK_GDMA0_EN BIT(16)
#define BIT_SOC_SLPCK_TIMER_EN BIT(15)
#define BIT_SOC_ACTCK_TIMER_EN BIT(14)
#define BIT_SOC_SLPCK_LOG_UART_EN BIT(13)
#define BIT_SOC_ACTCK_LOG_UART_EN BIT(12)
#define BIT_SOC_SLPCK_SDR_EN BIT(11)
#define BIT_SOC_ACTCK_SDR_EN BIT(10)
#define BIT_SOC_SLPCK_FLASH_EN BIT(9)
#define BIT_SOC_ACTCK_FLASH_EN BIT(8)
#define BIT_SOC_SLPCK_VENDOR_REG_EN BIT(7)
#define BIT_SOC_ACTCK_VENDOR_REG_EN BIT(6)
#define BIT_SOC_SLPCK_TRACE_EN BIT(5)
#define BIT_SOC_ACTCK_TRACE_EN BIT(4)
#define BIT_SOC_CKE_PLFM BIT(2)
#define BIT_SOC_CKE_OCP BIT(0)

//2 REG_PESOC_PERI_CLK_CTRL0
#define BIT_SOC_SLPCK_SPI2_EN BIT(21)
#define BIT_SOC_ACTCK_SPI2_EN BIT(20)
#define BIT_SOC_SLPCK_SPI1_EN BIT(19)
#define BIT_SOC_ACTCK_SPI1_EN BIT(18)
#define BIT_SOC_SLPCK_SPI0_EN BIT(17)
#define BIT_SOC_ACTCK_SPI0_EN BIT(16)
#define BIT_SOC_SLPCK_UART2_EN BIT(5)
#define BIT_SOC_ACTCK_UART2_EN BIT(4)
#define BIT_SOC_SLPCK_UART1_EN BIT(3)
#define BIT_SOC_ACTCK_UART1_EN BIT(2)
#define BIT_SOC_SLPCK_UART0_EN BIT(1)
#define BIT_SOC_ACTCK_UART0_EN BIT(0)

//2 REG_PESOC_PERI_CLK_CTRL1
#define BIT_SOC_SLPCK_DAC_EN BIT(29)
#define BIT_SOC_ACTCK_DAC_EN BIT(28)
#define BIT_SOC_SLPCK_ADC_EN BIT(25)
#define BIT_SOC_ACTCK_ADC_EN BIT(24)
#define BIT_SOC_SLPCK_PCM_EN BIT(21)
#define BIT_SOC_ACTCK_PCM_EN BIT(20)
#define BIT_SOC_SLPCK_I2S_EN BIT(17)
#define BIT_SOC_ACTCK_I2S_EN BIT(16)
#define BIT_SOC_SLPCK_I2C3_EN BIT(7)
#define BIT_SOC_ACTCK_I2C3_EN BIT(6)
#define BIT_SOC_SLPCK_I2C2_EN BIT(5)
#define BIT_SOC_ACTCK_I2C2_EN BIT(4)
#define BIT_SOC_SLPCK_I2C1_EN BIT(3)
#define BIT_SOC_ACTCK_I2C1_EN BIT(2)
#define BIT_SOC_SLPCK_I2C0_EN BIT(1)
#define BIT_SOC_ACTCK_I2C0_EN BIT(0)

//2 REG_PESOC_CLK_CTRL3

//2 REG_PESOC_HCI_CLK_CTRL0
#define BIT_SOC_SLPCK_MII_MPHY_EN BIT(25)
#define BIT_SOC_ACTCK_MII_MPHY_EN BIT(24)
#define BIT_SOC_SLPCK_OTG_EN BIT(5)
#define BIT_SOC_ACTCK_OTG_EN BIT(4)
#define BIT_SOC_SLPCK_SDIO_HST_EN BIT(3)
#define BIT_SOC_ACTCK_SDIO_HST_EN BIT(2)
#define BIT_SOC_SLPCK_SDIO_DEV_EN BIT(1)
#define BIT_SOC_ACTCK_SDIO_DEV_EN BIT(0)

//2 REG_PESOC_COM_CLK_CTRL1
#define BIT_SOC_NFC_CAL_EN BIT(18)
#define BIT_SOC_SLPCK_NFC_EN BIT(17)
#define BIT_SOC_ACTCK_NFC_EN BIT(16)
#define BIT_SOC_SLPCK_SECURITY_ENG_EN BIT(5)
#define BIT_SOC_ACTCK_SECURITY_ENG_EN BIT(4)
#define BIT_SOC_SLPCK_WL_EN BIT(1)
#define BIT_SOC_ACTCK_WL_EN BIT(0)

//2 REG_PESOC_HW_ENG_CLK_CTRL

//2 REG_RSVD

//2 REG_PESOC_CLK_SEL
#define BIT_PESOC_SPI1_SCLK_SEL BIT(18)

#define BIT_SHIFT_PESOC_PERI_SCLK_SEL 16
#define BIT_MASK_PESOC_PERI_SCLK_SEL 0x3
#define BIT_PESOC_PERI_SCLK_SEL(x) (((x) & BIT_MASK_PESOC_PERI_SCLK_SEL) << BIT_SHIFT_PESOC_PERI_SCLK_SEL)


#define BIT_SHIFT_PESOC_SDR_CK_SEL 10
#define BIT_MASK_PESOC_SDR_CK_SEL 0x3
#define BIT_PESOC_SDR_CK_SEL(x) (((x) & BIT_MASK_PESOC_SDR_CK_SEL) << BIT_SHIFT_PESOC_SDR_CK_SEL)


#define BIT_SHIFT_PESOC_FLASH_CK_SEL 8
#define BIT_MASK_PESOC_FLASH_CK_SEL 0x3
#define BIT_PESOC_FLASH_CK_SEL(x) (((x) & BIT_MASK_PESOC_FLASH_CK_SEL) << BIT_SHIFT_PESOC_FLASH_CK_SEL)


#define BIT_SHIFT_PESOC_TRACE_CK_SEL 4
#define BIT_MASK_PESOC_TRACE_CK_SEL 0x3
#define BIT_PESOC_TRACE_CK_SEL(x) (((x) & BIT_MASK_PESOC_TRACE_CK_SEL) << BIT_SHIFT_PESOC_TRACE_CK_SEL)


//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_SYS_ANACK_CAL_CTRL
#define BIT_SYS_ANACK_CAL_CMD BIT(15)
#define BIT_SYS_ANACK_CAL_SEL BIT(14)

#define BIT_SHIFT_SYS_ANACK_CAL_RPT 0
#define BIT_MASK_SYS_ANACK_CAL_RPT 0x3fff
#define BIT_SYS_ANACK_CAL_RPT(x) (((x) & BIT_MASK_SYS_ANACK_CAL_RPT) << BIT_SHIFT_SYS_ANACK_CAL_RPT)


//2 REG_OSC32K_CTRL

#define BIT_SHIFT_32K_BIAS_CURRENT 16
#define BIT_MASK_32K_BIAS_CURRENT 0xffff
#define BIT_32K_BIAS_CURRENT(x) (((x) & BIT_MASK_32K_BIAS_CURRENT) << BIT_SHIFT_32K_BIAS_CURRENT)


#define BIT_SHIFT_32K_RESISTOR_COM 2
#define BIT_MASK_32K_RESISTOR_COM 0x3
#define BIT_32K_RESISTOR_COM(x) (((x) & BIT_MASK_32K_RESISTOR_COM) << BIT_SHIFT_32K_RESISTOR_COM)

#define BIT_32K_DBG_SEL BIT(1)
#define BIT_32K_POW_CKGEN_EN BIT(0)

//2 REG_OSC32K_REG_CTRL0
#define BIT_32K_REG_INDIRT_CMD BIT(23)

#define BIT_SHIFT_32K_REG_INDIRT_ADDR 16
#define BIT_MASK_32K_REG_INDIRT_ADDR 0x3f
#define BIT_32K_REG_INDIRT_ADDR(x) (((x) & BIT_MASK_32K_REG_INDIRT_ADDR) << BIT_SHIFT_32K_REG_INDIRT_ADDR)


#define BIT_SHIFT_32K_REG_INDIRT_WDATA 0
#define BIT_MASK_32K_REG_INDIRT_WDATA 0xffff
#define BIT_32K_REG_INDIRT_WDATA(x) (((x) & BIT_MASK_32K_REG_INDIRT_WDATA) << BIT_SHIFT_32K_REG_INDIRT_WDATA)


//2 REG_OSC32K_REG_CTRL1

#define BIT_SHIFT_32K_REG_INDIRT_RDATA 0
#define BIT_MASK_32K_REG_INDIRT_RDATA 0xffff
#define BIT_32K_REG_INDIRT_RDATA(x) (((x) & BIT_MASK_32K_REG_INDIRT_RDATA) << BIT_SHIFT_32K_REG_INDIRT_RDATA)


//2 REG_THERMAL_METER_CTRL

#define BIT_SHIFT_TEMP_VALUE 24
#define BIT_MASK_TEMP_VALUE 0x3f
#define BIT_TEMP_VALUE(x) (((x) & BIT_MASK_TEMP_VALUE) << BIT_SHIFT_TEMP_VALUE)


#define BIT_SHIFT_TEMP_DELTA 16
#define BIT_MASK_TEMP_DELTA 0x3f
#define BIT_TEMP_DELTA(x) (((x) & BIT_MASK_TEMP_DELTA) << BIT_SHIFT_TEMP_DELTA)

#define BIT_THERMAL_METER_EN BIT(15)
#define BIT_THERMAL_METER_VALID BIT(14)

#define BIT_SHIFT_THERMAL_METER_TIMER 0
#define BIT_MASK_THERMAL_METER_TIMER 0xfff
#define BIT_THERMAL_METER_TIMER(x) (((x) & BIT_MASK_THERMAL_METER_TIMER) << BIT_SHIFT_THERMAL_METER_TIMER)


//2 REG_UART_MUX_CTRL

#define BIT_SHIFT_UART2_PIN_SEL 9
#define BIT_MASK_UART2_PIN_SEL 0x7
#define BIT_UART2_PIN_SEL(x) (((x) & BIT_MASK_UART2_PIN_SEL) << BIT_SHIFT_UART2_PIN_SEL)

#define BIT_UART2_PIN_EN BIT(8)

#define BIT_SHIFT_UART1_PIN_SEL 5
#define BIT_MASK_UART1_PIN_SEL 0x7
#define BIT_UART1_PIN_SEL(x) (((x) & BIT_MASK_UART1_PIN_SEL) << BIT_SHIFT_UART1_PIN_SEL)

#define BIT_UART1_PIN_EN BIT(4)

#define BIT_SHIFT_UART0_PIN_SEL 1
#define BIT_MASK_UART0_PIN_SEL 0x7
#define BIT_UART0_PIN_SEL(x) (((x) & BIT_MASK_UART0_PIN_SEL) << BIT_SHIFT_UART0_PIN_SEL)

#define BIT_UART0_PIN_EN BIT(0)

//2 REG_SPI_MUX_CTRL
#define BIT_SPI0_MULTI_CS_EN BIT(28)

#define BIT_SHIFT_SPI2_PIN_SEL 9
#define BIT_MASK_SPI2_PIN_SEL 0x7
#define BIT_SPI2_PIN_SEL(x) (((x) & BIT_MASK_SPI2_PIN_SEL) << BIT_SHIFT_SPI2_PIN_SEL)

#define BIT_SPI2_PIN_EN BIT(8)

#define BIT_SHIFT_SPI1_PIN_SEL 5
#define BIT_MASK_SPI1_PIN_SEL 0x7
#define BIT_SPI1_PIN_SEL(x) (((x) & BIT_MASK_SPI1_PIN_SEL) << BIT_SHIFT_SPI1_PIN_SEL)

#define BIT_SPI1_PIN_EN BIT(4)

#define BIT_SHIFT_SPI0_PIN_SEL 1
#define BIT_MASK_SPI0_PIN_SEL 0x7
#define BIT_SPI0_PIN_SEL(x) (((x) & BIT_MASK_SPI0_PIN_SEL) << BIT_SHIFT_SPI0_PIN_SEL)

#define BIT_SPI0_PIN_EN BIT(0)

//2 REG_I2C_MUX_CTRL

#define BIT_SHIFT_I2C3_PIN_SEL 13
#define BIT_MASK_I2C3_PIN_SEL 0x7
#define BIT_I2C3_PIN_SEL(x) (((x) & BIT_MASK_I2C3_PIN_SEL) << BIT_SHIFT_I2C3_PIN_SEL)

#define BIT_I2C3_PIN_EN BIT(12)

#define BIT_SHIFT_I2C2_PIN_SEL 9
#define BIT_MASK_I2C2_PIN_SEL 0x7
#define BIT_I2C2_PIN_SEL(x) (((x) & BIT_MASK_I2C2_PIN_SEL) << BIT_SHIFT_I2C2_PIN_SEL)

#define BIT_I2C2_PIN_EN BIT(8)

#define BIT_SHIFT_I2C1_PIN_SEL 5
#define BIT_MASK_I2C1_PIN_SEL 0x7
#define BIT_I2C1_PIN_SEL(x) (((x) & BIT_MASK_I2C1_PIN_SEL) << BIT_SHIFT_I2C1_PIN_SEL)

#define BIT_I2C1_PIN_EN BIT(4)

#define BIT_SHIFT_I2C0_PIN_SEL 1
#define BIT_MASK_I2C0_PIN_SEL 0x7
#define BIT_I2C0_PIN_SEL(x) (((x) & BIT_MASK_I2C0_PIN_SEL) << BIT_SHIFT_I2C0_PIN_SEL)

#define BIT_I2C0_PIN_EN BIT(0)

//2 REG_I2S_MUX_CTRL/ REG_PCM_MUX_CTRL

//2 REG_NOT_VALID

#define BIT_SHIFT_PCM1_PIN_SEL 21
#define BIT_MASK_PCM1_PIN_SEL 0x7
#define BIT_PCM1_PIN_SEL(x) (((x) & BIT_MASK_PCM1_PIN_SEL) << BIT_SHIFT_PCM1_PIN_SEL)

#define BIT_PCM1_PIN_EN BIT(20)

#define BIT_SHIFT_PCM0_PIN_SEL 17
#define BIT_MASK_PCM0_PIN_SEL 0x7
#define BIT_PCM0_PIN_SEL(x) (((x) & BIT_MASK_PCM0_PIN_SEL) << BIT_SHIFT_PCM0_PIN_SEL)

#define BIT_PCM0_PIN_EN BIT(16)

//2 REG_NOT_VALID

#define BIT_SHIFT_I2S1_PIN_SEL 6
#define BIT_MASK_I2S1_PIN_SEL 0x3
#define BIT_I2S1_PIN_SEL(x) (((x) & BIT_MASK_I2S1_PIN_SEL) << BIT_SHIFT_I2S1_PIN_SEL)

#define BIT_I2S1_MCK_EN BIT(5)
#define BIT_I2S1_PIN_EN BIT(4)

#define BIT_SHIFT_I2S0_PIN_SEL 2
#define BIT_MASK_I2S0_PIN_SEL 0x3
#define BIT_I2S0_PIN_SEL(x) (((x) & BIT_MASK_I2S0_PIN_SEL) << BIT_SHIFT_I2S0_PIN_SEL)

#define BIT_I2S0_MCK_EN BIT(1)
#define BIT_I2S0_PIN_EN BIT(0)

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_HCI_PINMUX_CTRL
#define BIT_HCI_MII_PIN_EN BIT(24)
#define BIT_HCI_SDIOH_PIN_EN BIT(1)
#define BIT_HCI_SDIOD_PIN_EN BIT(0)

//2 REG_WL_PINMUX_CTRL
#define BIT_NFC_PIN_EN BIT(16)
#define BIT_WL_BTCMD_PIN_EN BIT(13)
#define BIT_WL_BTCOEX_PIN_EN BIT(12)
#define BIT_WL_ANT1_PIN_EN BIT(9)
#define BIT_WL_ANT0_PIN_EN BIT(8)

#define BIT_SHIFT_WL_LED_PIN_SEL 1
#define BIT_MASK_WL_LED_PIN_SEL 0x3
#define BIT_WL_LED_PIN_SEL(x) (((x) & BIT_MASK_WL_LED_PIN_SEL) << BIT_SHIFT_WL_LED_PIN_SEL)

#define BIT_WL_LED_PIN_EN BIT(0)

//2 REG_BT_PINMUX_CTRL

//2 REG_PWM_PINMUX_CTRL

#define BIT_SHIFT_ETE3_PIN_SEL 29
#define BIT_MASK_ETE3_PIN_SEL 0x3
#define BIT_ETE3_PIN_SEL(x) (((x) & BIT_MASK_ETE3_PIN_SEL) << BIT_SHIFT_ETE3_PIN_SEL)

#define BIT_ETE3_PIN_EN BIT(28)

#define BIT_SHIFT_ETE2_PIN_SEL 25
#define BIT_MASK_ETE2_PIN_SEL 0x3
#define BIT_ETE2_PIN_SEL(x) (((x) & BIT_MASK_ETE2_PIN_SEL) << BIT_SHIFT_ETE2_PIN_SEL)

#define BIT_ETE2_PIN_EN BIT(24)

#define BIT_SHIFT_ETE1_PIN_SEL 21
#define BIT_MASK_ETE1_PIN_SEL 0x3
#define BIT_ETE1_PIN_SEL(x) (((x) & BIT_MASK_ETE1_PIN_SEL) << BIT_SHIFT_ETE1_PIN_SEL)

#define BIT_ETE1_PIN_EN BIT(20)

#define BIT_SHIFT_ETE0_PIN_SEL 17
#define BIT_MASK_ETE0_PIN_SEL 0x3
#define BIT_ETE0_PIN_SEL(x) (((x) & BIT_MASK_ETE0_PIN_SEL) << BIT_SHIFT_ETE0_PIN_SEL)

#define BIT_ETE0_PIN_EN BIT(16)

#define BIT_SHIFT_PWM3_PIN_SEL 13
#define BIT_MASK_PWM3_PIN_SEL 0x3
#define BIT_PWM3_PIN_SEL(x) (((x) & BIT_MASK_PWM3_PIN_SEL) << BIT_SHIFT_PWM3_PIN_SEL)

#define BIT_PWM3_PIN_EN BIT(12)

#define BIT_SHIFT_PWM2_PIN_SEL 9
#define BIT_MASK_PWM2_PIN_SEL 0x3
#define BIT_PWM2_PIN_SEL(x) (((x) & BIT_MASK_PWM2_PIN_SEL) << BIT_SHIFT_PWM2_PIN_SEL)

#define BIT_PWM2_PIN_EN BIT(8)

#define BIT_SHIFT_PWM1_PIN_SEL 5
#define BIT_MASK_PWM1_PIN_SEL 0x3
#define BIT_PWM1_PIN_SEL(x) (((x) & BIT_MASK_PWM1_PIN_SEL) << BIT_SHIFT_PWM1_PIN_SEL)

#define BIT_PWM1_PIN_EN BIT(4)

#define BIT_SHIFT_PWM0_PIN_SEL 1
#define BIT_MASK_PWM0_PIN_SEL 0x3
#define BIT_PWM0_PIN_SEL(x) (((x) & BIT_MASK_PWM0_PIN_SEL) << BIT_SHIFT_PWM0_PIN_SEL)

#define BIT_PWM0_PIN_EN BIT(0)

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_CPU_PERIPHERAL_CTRL

#define BIT_SHIFT_LOG_UART_PIN_SEL 22
#define BIT_MASK_LOG_UART_PIN_SEL 0x3
#define BIT_LOG_UART_PIN_SEL(x) (((x) & BIT_MASK_LOG_UART_PIN_SEL) << BIT_SHIFT_LOG_UART_PIN_SEL)

#define BIT_LOG_UART_IR_EN BIT(21)
#define BIT_LOG_UART_PIN_EN BIT(20)
#define BIT_TRACE_PIN_EN BIT(17)
#define BIT_SDR_PIN_EN BIT(4)

#define BIT_SHIFT_SPI_FLSH_PIN_SEL 1
#define BIT_MASK_SPI_FLSH_PIN_SEL 0x3
#define BIT_SPI_FLSH_PIN_SEL(x) (((x) & BIT_MASK_SPI_FLSH_PIN_SEL) << BIT_SHIFT_SPI_FLSH_PIN_SEL)

#define BIT_SPI_FLSH_PIN_EN BIT(0)

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_RSVD

//2 REG_HCI_CTRL_STATUS_0

//2 REG_HCI_CTRL_STATUS_1

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_PESOC_MEM_CTRL

#define BIT_SHIFT_PESOC_SDR_DDL_CTRL 16
#define BIT_MASK_PESOC_SDR_DDL_CTRL 0xff
#define BIT_PESOC_SDR_DDL_CTRL(x) (((x) & BIT_MASK_PESOC_SDR_DDL_CTRL) << BIT_SHIFT_PESOC_SDR_DDL_CTRL)


#define BIT_SHIFT_PESOC_FLASH_DDL_CTRL 0
#define BIT_MASK_PESOC_FLASH_DDL_CTRL 0xff
#define BIT_PESOC_FLASH_DDL_CTRL(x) (((x) & BIT_MASK_PESOC_FLASH_DDL_CTRL) << BIT_SHIFT_PESOC_FLASH_DDL_CTRL)


//2 REG_PESOC_SOC_CTRL

#define BIT_SHIFT_PESOC_GDMA_CFG 16
#define BIT_MASK_PESOC_GDMA_CFG 0x1fff
#define BIT_PESOC_GDMA_CFG(x) (((x) & BIT_MASK_PESOC_GDMA_CFG) << BIT_SHIFT_PESOC_GDMA_CFG)

#define BIT_PESOC_MII_LX_SLV_SWAP_SEL BIT(13)
#define BIT_PESOC_MII_LX_MST_SWAP_SEL BIT(12)
#define BIT_PESOC_MII_LX_WRAPPER_EN BIT(11)
#define BIT_PESOC_LX_SLV_SWAP_SEL BIT(10)
#define BIT_PESOC_LX_MST_SWAP_SEL BIT(9)
#define BIT_PESOC_LX_WL_SWAP_SEL BIT(8)

#define BIT_SHIFT_PESOC_SRAM_MUX_CFG 0
#define BIT_MASK_PESOC_SRAM_MUX_CFG 0x7
#define BIT_PESOC_SRAM_MUX_CFG(x) (((x) & BIT_MASK_PESOC_SRAM_MUX_CFG) << BIT_SHIFT_PESOC_SRAM_MUX_CFG)


//2 REG_PESOC_PERI_CTRL
#define BIT_SOC_FUNC_SPI_RN BIT(8)

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID
#define BIT_FW_CTRL_INT0 BIT(24)

//2 REG_NOT_VALID

//2 REG_GPIO_SHTDN_CTRL
#define BIT_GPIO_GPK_SHTDN_N BIT(10)
#define BIT_GPIO_GPJ_SHTDN_N BIT(9)
#define BIT_GPIO_GPI_SHTDN_N BIT(8)
#define BIT_GPIO_GPH_SHTDN_N BIT(7)
#define BIT_GPIO_GPG_SHTDN_N BIT(6)
#define BIT_GPIO_GPF_SHTDN_N BIT(5)
#define BIT_GPIO_GPE_SHTDN_N BIT(4)
#define BIT_GPIO_GPD_SHTDN_N BIT(3)
#define BIT_GPIO_GPC_SHTDN_N BIT(2)
#define BIT_GPIO_GPB_SHTDN_N BIT(1)
#define BIT_GPIO_GPA_SHTDN_N BIT(0)

//2 REG_GPIO_DRIVING_CTRL
#define BIT_GPIO_GPK_DRV_SEL BIT(20)
#define BIT_GPIO_GPJ_DRV_SEL BIT(18)
#define BIT_GPIO_GPI_DRV_SEL BIT(16)
#define BIT_GPIO_GPH_DRV_SEL BIT(14)
#define BIT_GPIO_GPG_DRV_SEL BIT(12)
#define BIT_GPIO_GPF_DRV_SEL BIT(10)
#define BIT_GPIO_GPE_DRV_SEL BIT(8)
#define BIT_GPIO_GPD_DRV_SEL BIT(6)
#define BIT_GPIO_GPC_DRV_SEL BIT(4)
#define BIT_GPIO_GPB_DRV_SEL BIT(2)
#define BIT_GPIO_GPA_DRV_SEL BIT(0)

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_GPIO_PULL_CTRL0

#define BIT_SHIFT_GPIO_GPB7_PULL_CTRL 30
#define BIT_MASK_GPIO_GPB7_PULL_CTRL 0x3
#define BIT_GPIO_GPB7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPB7_PULL_CTRL) << BIT_SHIFT_GPIO_GPB7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPB6_PULL_CTRL 28
#define BIT_MASK_GPIO_GPB6_PULL_CTRL 0x3
#define BIT_GPIO_GPB6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPB6_PULL_CTRL) << BIT_SHIFT_GPIO_GPB6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPB5_PULL_CTRL 26
#define BIT_MASK_GPIO_GPB5_PULL_CTRL 0x3
#define BIT_GPIO_GPB5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPB5_PULL_CTRL) << BIT_SHIFT_GPIO_GPB5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPB4_PULL_CTRL 24
#define BIT_MASK_GPIO_GPB4_PULL_CTRL 0x3
#define BIT_GPIO_GPB4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPB4_PULL_CTRL) << BIT_SHIFT_GPIO_GPB4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPB3_PULL_CTRL 22
#define BIT_MASK_GPIO_GPB3_PULL_CTRL 0x3
#define BIT_GPIO_GPB3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPB3_PULL_CTRL) << BIT_SHIFT_GPIO_GPB3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPB2_PULL_CTRL 20
#define BIT_MASK_GPIO_GPB2_PULL_CTRL 0x3
#define BIT_GPIO_GPB2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPB2_PULL_CTRL) << BIT_SHIFT_GPIO_GPB2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPB1_PULL_CTRL 18
#define BIT_MASK_GPIO_GPB1_PULL_CTRL 0x3
#define BIT_GPIO_GPB1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPB1_PULL_CTRL) << BIT_SHIFT_GPIO_GPB1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPB0_PULL_CTRL 16
#define BIT_MASK_GPIO_GPB0_PULL_CTRL 0x3
#define BIT_GPIO_GPB0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPB0_PULL_CTRL) << BIT_SHIFT_GPIO_GPB0_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPA7_PULL_CTRL 14
#define BIT_MASK_GPIO_GPA7_PULL_CTRL 0x3
#define BIT_GPIO_GPA7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPA7_PULL_CTRL) << BIT_SHIFT_GPIO_GPA7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPA6_PULL_CTRL 12
#define BIT_MASK_GPIO_GPA6_PULL_CTRL 0x3
#define BIT_GPIO_GPA6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPA6_PULL_CTRL) << BIT_SHIFT_GPIO_GPA6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPA5_PULL_CTRL 10
#define BIT_MASK_GPIO_GPA5_PULL_CTRL 0x3
#define BIT_GPIO_GPA5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPA5_PULL_CTRL) << BIT_SHIFT_GPIO_GPA5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPA4_PULL_CTRL 8
#define BIT_MASK_GPIO_GPA4_PULL_CTRL 0x3
#define BIT_GPIO_GPA4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPA4_PULL_CTRL) << BIT_SHIFT_GPIO_GPA4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPA3_PULL_CTRL 6
#define BIT_MASK_GPIO_GPA3_PULL_CTRL 0x3
#define BIT_GPIO_GPA3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPA3_PULL_CTRL) << BIT_SHIFT_GPIO_GPA3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPA2_PULL_CTRL 4
#define BIT_MASK_GPIO_GPA2_PULL_CTRL 0x3
#define BIT_GPIO_GPA2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPA2_PULL_CTRL) << BIT_SHIFT_GPIO_GPA2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPA1_PULL_CTRL 2
#define BIT_MASK_GPIO_GPA1_PULL_CTRL 0x3
#define BIT_GPIO_GPA1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPA1_PULL_CTRL) << BIT_SHIFT_GPIO_GPA1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPA0_PULL_CTRL 0
#define BIT_MASK_GPIO_GPA0_PULL_CTRL 0x3
#define BIT_GPIO_GPA0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPA0_PULL_CTRL) << BIT_SHIFT_GPIO_GPA0_PULL_CTRL)


//2 REG_GPIO_PULL_CTRL1

#define BIT_SHIFT_GPIO_GPD7_PULL_CTRL 29
#define BIT_MASK_GPIO_GPD7_PULL_CTRL 0x7
#define BIT_GPIO_GPD7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD7_PULL_CTRL) << BIT_SHIFT_GPIO_GPD7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPD6_PULL_CTRL 28
#define BIT_MASK_GPIO_GPD6_PULL_CTRL 0x3
#define BIT_GPIO_GPD6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD6_PULL_CTRL) << BIT_SHIFT_GPIO_GPD6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPD5_PULL_CTRL 26
#define BIT_MASK_GPIO_GPD5_PULL_CTRL 0x3
#define BIT_GPIO_GPD5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD5_PULL_CTRL) << BIT_SHIFT_GPIO_GPD5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPD4_PULL_CTRL 24
#define BIT_MASK_GPIO_GPD4_PULL_CTRL 0x3
#define BIT_GPIO_GPD4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD4_PULL_CTRL) << BIT_SHIFT_GPIO_GPD4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPD3_PULL_CTRL 22
#define BIT_MASK_GPIO_GPD3_PULL_CTRL 0x3
#define BIT_GPIO_GPD3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD3_PULL_CTRL) << BIT_SHIFT_GPIO_GPD3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPD2_PULL_CTRL 20
#define BIT_MASK_GPIO_GPD2_PULL_CTRL 0x3
#define BIT_GPIO_GPD2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD2_PULL_CTRL) << BIT_SHIFT_GPIO_GPD2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPD1_PULL_CTRL 18
#define BIT_MASK_GPIO_GPD1_PULL_CTRL 0x3
#define BIT_GPIO_GPD1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD1_PULL_CTRL) << BIT_SHIFT_GPIO_GPD1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPD0_PULL_CTRL 16
#define BIT_MASK_GPIO_GPD0_PULL_CTRL 0x3
#define BIT_GPIO_GPD0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD0_PULL_CTRL) << BIT_SHIFT_GPIO_GPD0_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC7_PULL_CTRL 14
#define BIT_MASK_GPIO_GPC7_PULL_CTRL 0x3
#define BIT_GPIO_GPC7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC7_PULL_CTRL) << BIT_SHIFT_GPIO_GPC7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC6_PULL_CTRL 12
#define BIT_MASK_GPIO_GPC6_PULL_CTRL 0x3
#define BIT_GPIO_GPC6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC6_PULL_CTRL) << BIT_SHIFT_GPIO_GPC6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC5_PULL_CTRL 10
#define BIT_MASK_GPIO_GPC5_PULL_CTRL 0x3
#define BIT_GPIO_GPC5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC5_PULL_CTRL) << BIT_SHIFT_GPIO_GPC5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC4_PULL_CTRL 8
#define BIT_MASK_GPIO_GPC4_PULL_CTRL 0x3
#define BIT_GPIO_GPC4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC4_PULL_CTRL) << BIT_SHIFT_GPIO_GPC4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC3_PULL_CTRL 6
#define BIT_MASK_GPIO_GPC3_PULL_CTRL 0x3
#define BIT_GPIO_GPC3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC3_PULL_CTRL) << BIT_SHIFT_GPIO_GPC3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC2_PULL_CTRL 4
#define BIT_MASK_GPIO_GPC2_PULL_CTRL 0x3
#define BIT_GPIO_GPC2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC2_PULL_CTRL) << BIT_SHIFT_GPIO_GPC2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC1_PULL_CTRL 2
#define BIT_MASK_GPIO_GPC1_PULL_CTRL 0x3
#define BIT_GPIO_GPC1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC1_PULL_CTRL) << BIT_SHIFT_GPIO_GPC1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC0_PULL_CTRL 0
#define BIT_MASK_GPIO_GPC0_PULL_CTRL 0x3
#define BIT_GPIO_GPC0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC0_PULL_CTRL) << BIT_SHIFT_GPIO_GPC0_PULL_CTRL)


//2 REG_GPIO_PULL_CTRL2

#define BIT_SHIFT_GPIO_GPF5_PULL_CTRL 26
#define BIT_MASK_GPIO_GPF5_PULL_CTRL 0x3
#define BIT_GPIO_GPF5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPF5_PULL_CTRL) << BIT_SHIFT_GPIO_GPF5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPF4_PULL_CTRL 24
#define BIT_MASK_GPIO_GPF4_PULL_CTRL 0x3
#define BIT_GPIO_GPF4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPF4_PULL_CTRL) << BIT_SHIFT_GPIO_GPF4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPF3_PULL_CTRL 22
#define BIT_MASK_GPIO_GPF3_PULL_CTRL 0x3
#define BIT_GPIO_GPF3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPF3_PULL_CTRL) << BIT_SHIFT_GPIO_GPF3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPF2_PULL_CTRL 20
#define BIT_MASK_GPIO_GPF2_PULL_CTRL 0x3
#define BIT_GPIO_GPF2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPF2_PULL_CTRL) << BIT_SHIFT_GPIO_GPF2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPF1_PULL_CTRL 18
#define BIT_MASK_GPIO_GPF1_PULL_CTRL 0x3
#define BIT_GPIO_GPF1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPF1_PULL_CTRL) << BIT_SHIFT_GPIO_GPF1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPF0_PULL_CTRL 16
#define BIT_MASK_GPIO_GPF0_PULL_CTRL 0x3
#define BIT_GPIO_GPF0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPF0_PULL_CTRL) << BIT_SHIFT_GPIO_GPF0_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE7_PULL_CTRL 14
#define BIT_MASK_GPIO_GPE7_PULL_CTRL 0x3
#define BIT_GPIO_GPE7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE7_PULL_CTRL) << BIT_SHIFT_GPIO_GPE7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE6_PULL_CTRL 12
#define BIT_MASK_GPIO_GPE6_PULL_CTRL 0x3
#define BIT_GPIO_GPE6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE6_PULL_CTRL) << BIT_SHIFT_GPIO_GPE6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE5_PULL_CTRL 10
#define BIT_MASK_GPIO_GPE5_PULL_CTRL 0x3
#define BIT_GPIO_GPE5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE5_PULL_CTRL) << BIT_SHIFT_GPIO_GPE5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE4_PULL_CTRL 8
#define BIT_MASK_GPIO_GPE4_PULL_CTRL 0x3
#define BIT_GPIO_GPE4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE4_PULL_CTRL) << BIT_SHIFT_GPIO_GPE4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE3_PULL_CTRL 6
#define BIT_MASK_GPIO_GPE3_PULL_CTRL 0x3
#define BIT_GPIO_GPE3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE3_PULL_CTRL) << BIT_SHIFT_GPIO_GPE3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE2_PULL_CTRL 4
#define BIT_MASK_GPIO_GPE2_PULL_CTRL 0x3
#define BIT_GPIO_GPE2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE2_PULL_CTRL) << BIT_SHIFT_GPIO_GPE2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE1_PULL_CTRL 2
#define BIT_MASK_GPIO_GPE1_PULL_CTRL 0x3
#define BIT_GPIO_GPE1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE1_PULL_CTRL) << BIT_SHIFT_GPIO_GPE1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE0_PULL_CTRL 0
#define BIT_MASK_GPIO_GPE0_PULL_CTRL 0x3
#define BIT_GPIO_GPE0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE0_PULL_CTRL) << BIT_SHIFT_GPIO_GPE0_PULL_CTRL)


//2 REG_NOT_VALID

#define BIT_SHIFT_GPIO_GPH7_PULL_CTRL 30
#define BIT_MASK_GPIO_GPH7_PULL_CTRL 0x3
#define BIT_GPIO_GPH7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPH7_PULL_CTRL) << BIT_SHIFT_GPIO_GPH7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPH6_PULL_CTRL 28
#define BIT_MASK_GPIO_GPH6_PULL_CTRL 0x3
#define BIT_GPIO_GPH6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPH6_PULL_CTRL) << BIT_SHIFT_GPIO_GPH6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPH5_PULL_CTRL 26
#define BIT_MASK_GPIO_GPH5_PULL_CTRL 0x3
#define BIT_GPIO_GPH5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPH5_PULL_CTRL) << BIT_SHIFT_GPIO_GPH5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPH4_PULL_CTRL 24
#define BIT_MASK_GPIO_GPH4_PULL_CTRL 0x3
#define BIT_GPIO_GPH4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPH4_PULL_CTRL) << BIT_SHIFT_GPIO_GPH4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPH3_PULL_CTRL 22
#define BIT_MASK_GPIO_GPH3_PULL_CTRL 0x3
#define BIT_GPIO_GPH3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPH3_PULL_CTRL) << BIT_SHIFT_GPIO_GPH3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPH2_PULL_CTRL 20
#define BIT_MASK_GPIO_GPH2_PULL_CTRL 0x3
#define BIT_GPIO_GPH2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPH2_PULL_CTRL) << BIT_SHIFT_GPIO_GPH2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPH1_PULL_CTRL 18
#define BIT_MASK_GPIO_GPH1_PULL_CTRL 0x3
#define BIT_GPIO_GPH1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPH1_PULL_CTRL) << BIT_SHIFT_GPIO_GPH1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPH0_PULL_CTRL 16
#define BIT_MASK_GPIO_GPH0_PULL_CTRL 0x3
#define BIT_GPIO_GPH0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPH0_PULL_CTRL) << BIT_SHIFT_GPIO_GPH0_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPG7_PULL_CTRL 14
#define BIT_MASK_GPIO_GPG7_PULL_CTRL 0x3
#define BIT_GPIO_GPG7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPG7_PULL_CTRL) << BIT_SHIFT_GPIO_GPG7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPG6_PULL_CTRL 12
#define BIT_MASK_GPIO_GPG6_PULL_CTRL 0x3
#define BIT_GPIO_GPG6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPG6_PULL_CTRL) << BIT_SHIFT_GPIO_GPG6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPG5_PULL_CTRL 10
#define BIT_MASK_GPIO_GPG5_PULL_CTRL 0x3
#define BIT_GPIO_GPG5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPG5_PULL_CTRL) << BIT_SHIFT_GPIO_GPG5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPG4_PULL_CTRL 8
#define BIT_MASK_GPIO_GPG4_PULL_CTRL 0x3
#define BIT_GPIO_GPG4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPG4_PULL_CTRL) << BIT_SHIFT_GPIO_GPG4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPG3_PULL_CTRL 6
#define BIT_MASK_GPIO_GPG3_PULL_CTRL 0x3
#define BIT_GPIO_GPG3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPG3_PULL_CTRL) << BIT_SHIFT_GPIO_GPG3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPG2_PULL_CTRL 4
#define BIT_MASK_GPIO_GPG2_PULL_CTRL 0x3
#define BIT_GPIO_GPG2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPG2_PULL_CTRL) << BIT_SHIFT_GPIO_GPG2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPG1_PULL_CTRL 2
#define BIT_MASK_GPIO_GPG1_PULL_CTRL 0x3
#define BIT_GPIO_GPG1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPG1_PULL_CTRL) << BIT_SHIFT_GPIO_GPG1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPG0_PULL_CTRL 0
#define BIT_MASK_GPIO_GPG0_PULL_CTRL 0x3
#define BIT_GPIO_GPG0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPG0_PULL_CTRL) << BIT_SHIFT_GPIO_GPG0_PULL_CTRL)


//2 REG_GPIO_PULL_CTRL4

#define BIT_SHIFT_GPIO_GPJ6_PULL_CTRL 28
#define BIT_MASK_GPIO_GPJ6_PULL_CTRL 0x3
#define BIT_GPIO_GPJ6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPJ6_PULL_CTRL) << BIT_SHIFT_GPIO_GPJ6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPJ5_PULL_CTRL 26
#define BIT_MASK_GPIO_GPJ5_PULL_CTRL 0x3
#define BIT_GPIO_GPJ5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPJ5_PULL_CTRL) << BIT_SHIFT_GPIO_GPJ5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPJ4_PULL_CTRL 24
#define BIT_MASK_GPIO_GPJ4_PULL_CTRL 0x3
#define BIT_GPIO_GPJ4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPJ4_PULL_CTRL) << BIT_SHIFT_GPIO_GPJ4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPJ3_PULL_CTRL 22
#define BIT_MASK_GPIO_GPJ3_PULL_CTRL 0x3
#define BIT_GPIO_GPJ3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPJ3_PULL_CTRL) << BIT_SHIFT_GPIO_GPJ3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPJ2_PULL_CTRL 20
#define BIT_MASK_GPIO_GPJ2_PULL_CTRL 0x3
#define BIT_GPIO_GPJ2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPJ2_PULL_CTRL) << BIT_SHIFT_GPIO_GPJ2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPJ1_PULL_CTRL 18
#define BIT_MASK_GPIO_GPJ1_PULL_CTRL 0x3
#define BIT_GPIO_GPJ1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPJ1_PULL_CTRL) << BIT_SHIFT_GPIO_GPJ1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPJ0_PULL_CTRL 16
#define BIT_MASK_GPIO_GPJ0_PULL_CTRL 0x3
#define BIT_GPIO_GPJ0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPJ0_PULL_CTRL) << BIT_SHIFT_GPIO_GPJ0_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPI7_PULL_CTRL 14
#define BIT_MASK_GPIO_GPI7_PULL_CTRL 0x3
#define BIT_GPIO_GPI7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPI7_PULL_CTRL) << BIT_SHIFT_GPIO_GPI7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPI6_PULL_CTRL 12
#define BIT_MASK_GPIO_GPI6_PULL_CTRL 0x3
#define BIT_GPIO_GPI6_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPI6_PULL_CTRL) << BIT_SHIFT_GPIO_GPI6_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPI5_PULL_CTRL 10
#define BIT_MASK_GPIO_GPI5_PULL_CTRL 0x3
#define BIT_GPIO_GPI5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPI5_PULL_CTRL) << BIT_SHIFT_GPIO_GPI5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPI4_PULL_CTRL 8
#define BIT_MASK_GPIO_GPI4_PULL_CTRL 0x3
#define BIT_GPIO_GPI4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPI4_PULL_CTRL) << BIT_SHIFT_GPIO_GPI4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPI3_PULL_CTRL 6
#define BIT_MASK_GPIO_GPI3_PULL_CTRL 0x3
#define BIT_GPIO_GPI3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPI3_PULL_CTRL) << BIT_SHIFT_GPIO_GPI3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPI2_PULL_CTRL 4
#define BIT_MASK_GPIO_GPI2_PULL_CTRL 0x3
#define BIT_GPIO_GPI2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPI2_PULL_CTRL) << BIT_SHIFT_GPIO_GPI2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPI1_PULL_CTRL 2
#define BIT_MASK_GPIO_GPI1_PULL_CTRL 0x3
#define BIT_GPIO_GPI1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPI1_PULL_CTRL) << BIT_SHIFT_GPIO_GPI1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPI0_PULL_CTRL 0
#define BIT_MASK_GPIO_GPI0_PULL_CTRL 0x3
#define BIT_GPIO_GPI0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPI0_PULL_CTRL) << BIT_SHIFT_GPIO_GPI0_PULL_CTRL)


//2 REG_GPIO_PULL_CTRL5

#define BIT_SHIFT_GPIO_GPEA_PULL_CTRL 20
#define BIT_MASK_GPIO_GPEA_PULL_CTRL 0x3
#define BIT_GPIO_GPEA_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPEA_PULL_CTRL) << BIT_SHIFT_GPIO_GPEA_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE9_PULL_CTRL 18
#define BIT_MASK_GPIO_GPE9_PULL_CTRL 0x3
#define BIT_GPIO_GPE9_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE9_PULL_CTRL) << BIT_SHIFT_GPIO_GPE9_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPE8_PULL_CTRL 16
#define BIT_MASK_GPIO_GPE8_PULL_CTRL 0x3
#define BIT_GPIO_GPE8_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPE8_PULL_CTRL) << BIT_SHIFT_GPIO_GPE8_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPK7_PULL_CTRL 12
#define BIT_MASK_GPIO_GPK7_PULL_CTRL 0x3
#define BIT_GPIO_GPK7_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPK7_PULL_CTRL) << BIT_SHIFT_GPIO_GPK7_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPK5_PULL_CTRL 10
#define BIT_MASK_GPIO_GPK5_PULL_CTRL 0x3
#define BIT_GPIO_GPK5_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPK5_PULL_CTRL) << BIT_SHIFT_GPIO_GPK5_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPK4_PULL_CTRL 8
#define BIT_MASK_GPIO_GPK4_PULL_CTRL 0x3
#define BIT_GPIO_GPK4_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPK4_PULL_CTRL) << BIT_SHIFT_GPIO_GPK4_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPK3_PULL_CTRL 6
#define BIT_MASK_GPIO_GPK3_PULL_CTRL 0x3
#define BIT_GPIO_GPK3_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPK3_PULL_CTRL) << BIT_SHIFT_GPIO_GPK3_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPK2_PULL_CTRL 4
#define BIT_MASK_GPIO_GPK2_PULL_CTRL 0x3
#define BIT_GPIO_GPK2_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPK2_PULL_CTRL) << BIT_SHIFT_GPIO_GPK2_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPK1_PULL_CTRL 2
#define BIT_MASK_GPIO_GPK1_PULL_CTRL 0x3
#define BIT_GPIO_GPK1_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPK1_PULL_CTRL) << BIT_SHIFT_GPIO_GPK1_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPK0_PULL_CTRL 0
#define BIT_MASK_GPIO_GPK0_PULL_CTRL 0x3
#define BIT_GPIO_GPK0_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPK0_PULL_CTRL) << BIT_SHIFT_GPIO_GPK0_PULL_CTRL)


//2 REG_GPIO_PULL_CTRL6

#define BIT_SHIFT_GPIO_GPD9_PULL_CTRL 18
#define BIT_MASK_GPIO_GPD9_PULL_CTRL 0x3
#define BIT_GPIO_GPD9_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD9_PULL_CTRL) << BIT_SHIFT_GPIO_GPD9_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPD8_PULL_CTRL 16
#define BIT_MASK_GPIO_GPD8_PULL_CTRL 0x3
#define BIT_GPIO_GPD8_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPD8_PULL_CTRL) << BIT_SHIFT_GPIO_GPD8_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC9_PULL_CTRL 2
#define BIT_MASK_GPIO_GPC9_PULL_CTRL 0x3
#define BIT_GPIO_GPC9_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC9_PULL_CTRL) << BIT_SHIFT_GPIO_GPC9_PULL_CTRL)


#define BIT_SHIFT_GPIO_GPC8_PULL_CTRL 0
#define BIT_MASK_GPIO_GPC8_PULL_CTRL 0x3
#define BIT_GPIO_GPC8_PULL_CTRL(x) (((x) & BIT_MASK_GPIO_GPC8_PULL_CTRL) << BIT_SHIFT_GPIO_GPC8_PULL_CTRL)


//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_NOT_VALID

//2 REG_PERI_PWM0_CTRL
#define BIT_PERI_PWM0_EN BIT(31)

#define BIT_SHIFT_PERI_PWM0_GT_SEL 24
#define BIT_MASK_PERI_PWM0_GT_SEL 0xf
#define BIT_PERI_PWM0_GT_SEL(x) (((x) & BIT_MASK_PERI_PWM0_GT_SEL) << BIT_SHIFT_PERI_PWM0_GT_SEL)


#define BIT_SHIFT_PERI_PWM0_DUTY 12
#define BIT_MASK_PERI_PWM0_DUTY 0x3ff
#define BIT_PERI_PWM0_DUTY(x) (((x) & BIT_MASK_PERI_PWM0_DUTY) << BIT_SHIFT_PERI_PWM0_DUTY)


#define BIT_SHIFT_PERI_PWM0_PERIOD 0
#define BIT_MASK_PERI_PWM0_PERIOD 0x3ff
#define BIT_PERI_PWM0_PERIOD(x) (((x) & BIT_MASK_PERI_PWM0_PERIOD) << BIT_SHIFT_PERI_PWM0_PERIOD)


//2 REG_PERI_PWM1_CTRL
#define BIT_PERI_PWM1_EN BIT(31)

#define BIT_SHIFT_PERI_PWM1_GT_SEL 24
#define BIT_MASK_PERI_PWM1_GT_SEL 0xf
#define BIT_PERI_PWM1_GT_SEL(x) (((x) & BIT_MASK_PERI_PWM1_GT_SEL) << BIT_SHIFT_PERI_PWM1_GT_SEL)


#define BIT_SHIFT_PERI_PWM1_DUTY 12
#define BIT_MASK_PERI_PWM1_DUTY 0x3ff
#define BIT_PERI_PWM1_DUTY(x) (((x) & BIT_MASK_PERI_PWM1_DUTY) << BIT_SHIFT_PERI_PWM1_DUTY)


#define BIT_SHIFT_PERI_PWM1_PERIOD 0
#define BIT_MASK_PERI_PWM1_PERIOD 0x3ff
#define BIT_PERI_PWM1_PERIOD(x) (((x) & BIT_MASK_PERI_PWM1_PERIOD) << BIT_SHIFT_PERI_PWM1_PERIOD)


//2 REG_PERI_PWM2_CTRL
#define BIT_PERI_PWM2_EN BIT(31)

#define BIT_SHIFT_PERI_PWM2_GT_SEL 24
#define BIT_MASK_PERI_PWM2_GT_SEL 0xf
#define BIT_PERI_PWM2_GT_SEL(x) (((x) & BIT_MASK_PERI_PWM2_GT_SEL) << BIT_SHIFT_PERI_PWM2_GT_SEL)


#define BIT_SHIFT_PERI_PWM2_DUTY 12
#define BIT_MASK_PERI_PWM2_DUTY 0x3ff
#define BIT_PERI_PWM2_DUTY(x) (((x) & BIT_MASK_PERI_PWM2_DUTY) << BIT_SHIFT_PERI_PWM2_DUTY)


#define BIT_SHIFT_PERI_PWM2_PERIOD 0
#define BIT_MASK_PERI_PWM2_PERIOD 0x3ff
#define BIT_PERI_PWM2_PERIOD(x) (((x) & BIT_MASK_PERI_PWM2_PERIOD) << BIT_SHIFT_PERI_PWM2_PERIOD)


//2 REG_PERI_PWM3_CTRL
#define BIT_PERI_PWM3_EN BIT(31)

#define BIT_SHIFT_PERI_PWM3_GT_SEL 24
#define BIT_MASK_PERI_PWM3_GT_SEL 0xf
#define BIT_PERI_PWM3_GT_SEL(x) (((x) & BIT_MASK_PERI_PWM3_GT_SEL) << BIT_SHIFT_PERI_PWM3_GT_SEL)


#define BIT_SHIFT_PERI_PWM3_DUTY 12
#define BIT_MASK_PERI_PWM3_DUTY 0x3ff
#define BIT_PERI_PWM3_DUTY(x) (((x) & BIT_MASK_PERI_PWM3_DUTY) << BIT_SHIFT_PERI_PWM3_DUTY)


#define BIT_SHIFT_PERI_PWM3_PERIOD 0
#define BIT_MASK_PERI_PWM3_PERIOD 0x3ff
#define BIT_PERI_PWM3_PERIOD(x) (((x) & BIT_MASK_PERI_PWM3_PERIOD) << BIT_SHIFT_PERI_PWM3_PERIOD)


//2 REG_PERI_TIM_EVT_CTRL
#define BIT_PERI_GT_EVT3_EN BIT(31)

#define BIT_SHIFT_PERI_GT_EVT3_SRC_SEL 28
#define BIT_MASK_PERI_GT_EVT3_SRC_SEL 0x7
#define BIT_PERI_GT_EVT3_SRC_SEL(x) (((x) & BIT_MASK_PERI_GT_EVT3_SRC_SEL) << BIT_SHIFT_PERI_GT_EVT3_SRC_SEL)


#define BIT_SHIFT_PERI_GT_EVT3_PULSE_DUR 24
#define BIT_MASK_PERI_GT_EVT3_PULSE_DUR 0xf
#define BIT_PERI_GT_EVT3_PULSE_DUR(x) (((x) & BIT_MASK_PERI_GT_EVT3_PULSE_DUR) << BIT_SHIFT_PERI_GT_EVT3_PULSE_DUR)

#define BIT_PERI_GT_EVT2_EN BIT(23)

#define BIT_SHIFT_PERI_GT_EVT2_SRC_SEL 20
#define BIT_MASK_PERI_GT_EVT2_SRC_SEL 0x7
#define BIT_PERI_GT_EVT2_SRC_SEL(x) (((x) & BIT_MASK_PERI_GT_EVT2_SRC_SEL) << BIT_SHIFT_PERI_GT_EVT2_SRC_SEL)


#define BIT_SHIFT_PERI_GT_EVT2_PULSE_DUR 16
#define BIT_MASK_PERI_GT_EVT2_PULSE_DUR 0xf
#define BIT_PERI_GT_EVT2_PULSE_DUR(x) (((x) & BIT_MASK_PERI_GT_EVT2_PULSE_DUR) << BIT_SHIFT_PERI_GT_EVT2_PULSE_DUR)

#define BIT_PERI_GT_EVT1_EN BIT(15)

#define BIT_SHIFT_PERI_GT_EVT1_SRC_SEL 12
#define BIT_MASK_PERI_GT_EVT1_SRC_SEL 0x7
#define BIT_PERI_GT_EVT1_SRC_SEL(x) (((x) & BIT_MASK_PERI_GT_EVT1_SRC_SEL) << BIT_SHIFT_PERI_GT_EVT1_SRC_SEL)


#define BIT_SHIFT_PERI_GT_EVT1_PULSE_DUR 8
#define BIT_MASK_PERI_GT_EVT1_PULSE_DUR 0xf
#define BIT_PERI_GT_EVT1_PULSE_DUR(x) (((x) & BIT_MASK_PERI_GT_EVT1_PULSE_DUR) << BIT_SHIFT_PERI_GT_EVT1_PULSE_DUR)

#define BIT_PERI_GT_EVT0_EN BIT(7)

#define BIT_SHIFT_PERI_GT_EVT0_SRC_SEL 4
#define BIT_MASK_PERI_GT_EVT0_SRC_SEL 0x7
#define BIT_PERI_GT_EVT0_SRC_SEL(x) (((x) & BIT_MASK_PERI_GT_EVT0_SRC_SEL) << BIT_SHIFT_PERI_GT_EVT0_SRC_SEL)


#define BIT_SHIFT_PERI_GT_EVT0_PULSE_DUR 0
#define BIT_MASK_PERI_GT_EVT0_PULSE_DUR 0xf
#define BIT_PERI_GT_EVT0_PULSE_DUR(x) (((x) & BIT_MASK_PERI_GT_EVT0_PULSE_DUR) << BIT_SHIFT_PERI_GT_EVT0_PULSE_DUR)


//2 REG_PERI_EGTIM_CTRL

#define BIT_SHIFT_PERI_EGTIM_PIN_GROUP2_OPT_SEL 12
#define BIT_MASK_PERI_EGTIM_PIN_GROUP2_OPT_SEL 0x3
#define BIT_PERI_EGTIM_PIN_GROUP2_OPT_SEL(x) (((x) & BIT_MASK_PERI_EGTIM_PIN_GROUP2_OPT_SEL) << BIT_SHIFT_PERI_EGTIM_PIN_GROUP2_OPT_SEL)


#define BIT_SHIFT_PERI_EGTIM_PIN_GROUP1_OPT_SEL 10
#define BIT_MASK_PERI_EGTIM_PIN_GROUP1_OPT_SEL 0x3
#define BIT_PERI_EGTIM_PIN_GROUP1_OPT_SEL(x) (((x) & BIT_MASK_PERI_EGTIM_PIN_GROUP1_OPT_SEL) << BIT_SHIFT_PERI_EGTIM_PIN_GROUP1_OPT_SEL)


#define BIT_SHIFT_PERI_EGTIM_PIN_GROUP0_OPT_SEL 8
#define BIT_MASK_PERI_EGTIM_PIN_GROUP0_OPT_SEL 0x3
#define BIT_PERI_EGTIM_PIN_GROUP0_OPT_SEL(x) (((x) & BIT_MASK_PERI_EGTIM_PIN_GROUP0_OPT_SEL) << BIT_SHIFT_PERI_EGTIM_PIN_GROUP0_OPT_SEL)


//2 REG_NOT_VALID

#define BIT_SHIFT_PERI_EGTIM_REF_SIG_SEL 4
#define BIT_MASK_PERI_EGTIM_REF_SIG_SEL 0x3
#define BIT_PERI_EGTIM_REF_SIG_SEL(x) (((x) & BIT_MASK_PERI_EGTIM_REF_SIG_SEL) << BIT_SHIFT_PERI_EGTIM_REF_SIG_SEL)

#define BIT_PERI_EGTIM_EN BIT(0)

//2 REG_NOT_VALID

//2 REG_PEON_CFG

//2 REG_PEON_STATUS
#define BIT_PEON_SDIO_ALDN BIT(0)


//========== Register Address Definition ==================//
#define REG_PEON_PWR_CTRL 0x0200
#define REG_PON_ISO_CTRL 0x0204
#define REG_SOC_FUNC_EN 0x0210
#define REG_SOC_HCI_COM_FUNC_EN 0x0214
#define REG_SOC_PERI_FUNC0_EN 0x0218
#define REG_SOC_PERI_FUNC1_EN 0x021C
#define REG_SOC_PERI_BD_FUNC0_EN 0x0220
#define REG_PESOC_CLK_CTRL 0x0230
#define REG_PESOC_PERI_CLK_CTRL0 0x0234
#define REG_PESOC_PERI_CLK_CTRL1 0x0238
#define REG_PESOC_CLK_CTRL3 0x023C
#define REG_PESOC_HCI_CLK_CTRL0 0x0240
#define REG_PESOC_COM_CLK_CTRL1 0x0244
#define REG_PESOC_HW_ENG_CLK_CTRL 0x0248
#define REG_PESOC_CLK_SEL 0x0250
#define REG_SYS_ANACK_CAL_CTRL 0x026C
#define REG_OSC32K_CTRL 0x0270
#define REG_OSC32K_REG_CTRL0 0x0274
#define REG_OSC32K_REG_CTRL1 0x0278
#define REG_THERMAL_METER_CTRL 0x027C
#define REG_UART_MUX_CTRL 0x0280
#define REG_SPI_MUX_CTRL 0x0284
#define REG_I2C_MUX_CTRL 0x0288
#define REG_I2S_MUX_CTRL 0x028C
#define REG_HCI_PINMUX_CTRL 0x02A0
#define REG_WL_PINMUX_CTRL 0x02A4
#define REG_BT_PINMUX_CTRL 0x02A8
#define REG_PWM_PINMUX_CTRL 0x02AC
#define REG_CPU_PERIPHERAL_CTRL 0x02C0
#define REG_HCI_CTRL_STATUS_0 0x02E0
#define REG_HCI_CTRL_STATUS_1 0x02E4
#define REG_PESOC_MEM_CTRL 0x0300
#define REG_PESOC_SOC_CTRL 0x0304
#define REG_PESOC_PERI_CTRL 0x0308
#define REG_GPIO_SHTDN_CTRL 0x0320
#define REG_GPIO_DRIVING_CTRL 0x0324
#define REG_GPIO_PULL_CTRL0 0x0330
#define REG_GPIO_PULL_CTRL1 0x0334
#define REG_GPIO_PULL_CTRL2 0x0338
#define REG_GPIO_PULL_CTRL3 0x033C
#define REG_GPIO_PULL_CTRL4 0x0340
#define REG_GPIO_PULL_CTRL5 0x0344
#define REG_GPIO_PULL_CTRL6 0x0348
#define REG_PERI_PWM0_CTRL 0x0360
#define REG_PERI_PWM1_CTRL 0x0364
#define REG_PERI_PWM2_CTRL 0x0368
#define REG_PERI_PWM3_CTRL 0x036C
#define REG_PERI_TIM_EVT_CTRL 0x0370
#define REG_PERI_EGTIM_CTRL 0x0374
#define REG_PEON_CFG 0x03F0
#define REG_PEON_STATUS 0x03F4


#endif  // end of "#ifndef __INC_RTL8195A_PERI_ON_H"
