#ifndef __CRYPTO_SIM_AES_H__
#define __CRYPTO_SIM_AES_H__

/*************** des.h ***************/

// ------------- des.h --------------------
/* must be 32bit quantity */
#define DES_LONG u32

typedef uint8_t des_cblock[8];
typedef struct des_ks_struct
  {
  union {
    des_cblock _;
    /* make sure things are correct size on machines with
     * 8 byte longs */
    DES_LONG pad[2];
    } ks;
#undef _
#define _ ks._
  } des_key_schedule[16];

#define DES_KEY_SZ  (sizeof(des_cblock))
#define DES_SCHEDULE_SZ (sizeof(des_key_schedule))

#define DES_ENCRYPT 1
#define DES_DECRYPT 0

#define DES_CBC_MODE  0
#define DES_PCBC_MODE 1

extern int32_t des_check_key; /* defaults to false */

char *des_options (void);
void des_ecb_encrypt (des_cblock *, des_cblock *,
  des_key_schedule, int32_t);
void des_encrypt (DES_LONG *, des_key_schedule, int32_t);
void des_encrypt2 (DES_LONG *, des_key_schedule, int32_t);

void des_set_odd_parity (uint8_t *);
int des_is_weak_key (const u8 *);
int32_t des_set_key (const u8* key, des_key_schedule);
int des_key_sched (u8 *, des_key_schedule);
void des_ecb3_encrypt( des_cblock *input, des_cblock *output,
          des_key_schedule *ks1, des_key_schedule *ks2,
          des_key_schedule *ks3,
       int enc);
void des_ncbc_encrypt(const u8 *in, u8 *out, long length,
         des_key_schedule *_schedule, des_cblock *ivec, int enc);
void des_ede3_cbc_encrypt(const unsigned char *input, unsigned char *output,
        long length, des_key_schedule *ks1,
        des_key_schedule *ks2, des_key_schedule *ks3,
        des_cblock *ivec, int enc);
//void des_ede3_cbcm_encrypt(const unsigned char *in, unsigned char *out,
//             long length, des_key_schedule ks1, des_key_schedule ks2,
//             des_key_schedule ks3, des_cblock *ivec1, des_cblock *ivec2,
//             int enc);
//void des_xcbc_encrypt( des_cblock *_in,des_cblock *_out,
//                      long length, des_key_schedule schedule,
//                      des_cblock *ivec, des_cblock *inw,
//                      des_cblock *outw, int enc);

#define des_ecb2_encrypt(i,o,k1,k2,e) \
  des_ecb3_encrypt((i),(o),(k1),(k2),(k1),(e))
  
int desSim_ecb_encrypt(const u8 *input, u8 * output, const u32 len, const u8 * key, const u8 encrypt);
int desSim_ede_ecb_encrypt(const u8 *input, u8 * output, const u32 len, const u8 * key, const u8 encrypt);
int desSim_cbc_encrypt(const u8 *input, u8 * output, const u32 len, const u8 * key, const u8 * iv, const u8 encrypt);
int desSim_ede_cbc_encrypt(const u8 *input, u8 * output, const u32 len, const u8 * key, const u8 * iv, const u8 encrypt);

//-----------------des_locl.h------------

#undef DES_PTR

#ifdef __STDC__
#undef NOPROTO
#endif

#define ITERATIONS 16
#define HALF_ITERATIONS 8

/* used in des_read and des_write */
#define MAXWRITE  (1024*16)
#define BSIZE   (MAXWRITE+4)

#define c2l(c,l)  (l =((DES_LONG)(*((c)++)))    , \
       l|=((DES_LONG)(*((c)++)))<< 8L, \
       l|=((DES_LONG)(*((c)++)))<<16L, \
       l|=((DES_LONG)(*((c)++)))<<24L)

/* NOTE - c is not incremented as per c2l */
#define c2ln(c,l1,l2,n) { \
      c+=n; \
      l1=l2=0; \
      switch (n) { \
      case 8: l2 =((DES_LONG)(*(--(c))))<<24L; \
      case 7: l2|=((DES_LONG)(*(--(c))))<<16L; \
      case 6: l2|=((DES_LONG)(*(--(c))))<< 8L; \
      case 5: l2|=((DES_LONG)(*(--(c))));     \
      case 4: l1 =((DES_LONG)(*(--(c))))<<24L; \
      case 3: l1|=((DES_LONG)(*(--(c))))<<16L; \
      case 2: l1|=((DES_LONG)(*(--(c))))<< 8L; \
      case 1: l1|=((DES_LONG)(*(--(c))));     \
        } \
      }

#define l2c(l,c)  (*((c)++)=(unsigned char)(((l)     )&0xff), \
       *((c)++)=(unsigned char)(((l)>> 8L)&0xff), \
       *((c)++)=(unsigned char)(((l)>>16L)&0xff), \
       *((c)++)=(unsigned char)(((l)>>24L)&0xff))

/* replacements for htonl and ntohl since I have no idea what to do
 * when faced with machines with 8 byte longs. */
#define HDRSIZE 4

#define n2l(c,l)  (l =((DES_LONG)(*((c)++)))<<24L, \
       l|=((DES_LONG)(*((c)++)))<<16L, \
       l|=((DES_LONG)(*((c)++)))<< 8L, \
       l|=((DES_LONG)(*((c)++))))

#define l2n(l,c)  (*((c)++)=(unsigned char)(((l)>>24L)&0xff), \
       *((c)++)=(unsigned char)(((l)>>16L)&0xff), \
       *((c)++)=(unsigned char)(((l)>> 8L)&0xff), \
       *((c)++)=(unsigned char)(((l)     )&0xff))

/* NOTE - c is not incremented as per l2c */
#define l2cn(l1,l2,c,n) { \
      c+=n; \
      switch (n) { \
      case 8: *(--(c))=(unsigned char)(((l2)>>24L)&0xff); \
      case 7: *(--(c))=(unsigned char)(((l2)>>16L)&0xff); \
      case 6: *(--(c))=(unsigned char)(((l2)>> 8L)&0xff); \
      case 5: *(--(c))=(unsigned char)(((l2)     )&0xff); \
      case 4: *(--(c))=(unsigned char)(((l1)>>24L)&0xff); \
      case 3: *(--(c))=(unsigned char)(((l1)>>16L)&0xff); \
      case 2: *(--(c))=(unsigned char)(((l1)>> 8L)&0xff); \
      case 1: *(--(c))=(unsigned char)(((l1)     )&0xff); \
        } \
      }

#define ROTATE(a,n) (((a)>>(n))+((a)<<(32-(n))))

/* The changes to this macro may help or hinder, depending on the
 * compiler and the achitecture.  gcc2 always seems to do well :-).
 * Inspired by Dana How <how@isl.stanford.edu>
 * DO NOT use the alternative version on machines with 8 byte longs.
 * It does not seem to work on the Alpha, even when DES_LONG is 4
 * bytes, probably an issue of accessing non-word aligned objects :-( */
#ifdef DES_PTR

#define D_ENCRYPT(L,R,S) { \
  u=((R^s[S  ])<<2);  \
  t= R^s[S+1]; \
  t=ROTATE(t,2); \
  L^= (\
  *(DES_LONG *)((unsigned char *)des_SP+0x100+((t    )&0xfc))+ \
  *(DES_LONG *)((unsigned char *)des_SP+0x300+((t>> 8)&0xfc))+ \
  *(DES_LONG *)((unsigned char *)des_SP+0x500+((t>>16)&0xfc))+ \
  *(DES_LONG *)((unsigned char *)des_SP+0x700+((t>>24)&0xfc))+ \
  *(DES_LONG *)((unsigned char *)des_SP      +((u    )&0xfc))+ \
  *(DES_LONG *)((unsigned char *)des_SP+0x200+((u>> 8)&0xfc))+ \
  *(DES_LONG *)((unsigned char *)des_SP+0x400+((u>>16)&0xfc))+ \
  *(DES_LONG *)((unsigned char *)des_SP+0x600+((u>>24)&0xfc))); }
#else /* original version */
#ifdef undef
#define D_ENCRYPT(L,R,S)  \
  U.l=R^s[S+1]; \
  T.s[0]=((U.s[0]>>4)|(U.s[1]<<12))&0x3f3f; \
  T.s[1]=((U.s[1]>>4)|(U.s[0]<<12))&0x3f3f; \
  U.l=(R^s[S  ])&0x3f3f3f3fL; \
  L^= des_SPtrans[1][(T.c[0])]| \
    des_SPtrans[3][(T.c[1])]| \
    des_SPtrans[5][(T.c[2])]| \
    des_SPtrans[7][(T.c[3])]| \
    des_SPtrans[0][(U.c[0])]| \
    des_SPtrans[2][(U.c[1])]| \
    des_SPtrans[4][(U.c[2])]| \
    des_SPtrans[6][(U.c[3])];
#else
#define D_ENCRYPT(Q,R,S) {\
  u=(R^s[S  ]); \
  t=R^s[S+1]; \
  t=ROTATE(t,4); \
  Q^= des_SPtrans[1][(t     )&0x3f]| \
    des_SPtrans[3][(t>> 8L)&0x3f]| \
    des_SPtrans[5][(t>>16L)&0x3f]| \
    des_SPtrans[7][(t>>24L)&0x3f]| \
    des_SPtrans[0][(u     )&0x3f]| \
    des_SPtrans[2][(u>> 8L)&0x3f]| \
    des_SPtrans[4][(u>>16L)&0x3f]| \
    des_SPtrans[6][(u>>24L)&0x3f]; }
#endif
#endif

  /* IP and FP
   * The problem is more of a geometric problem that random bit fiddling.
   0  1  2  3  4  5  6  7      62 54 46 38 30 22 14  6
   8  9 10 11 12 13 14 15      60 52 44 36 28 20 12  4
  16 17 18 19 20 21 22 23      58 50 42 34 26 18 10  2
  24 25 26 27 28 29 30 31  to  56 48 40 32 24 16  8  0

  32 33 34 35 36 37 38 39      63 55 47 39 31 23 15  7
  40 41 42 43 44 45 46 47      61 53 45 37 29 21 13  5
  48 49 50 51 52 53 54 55      59 51 43 35 27 19 11  3
  56 57 58 59 60 61 62 63      57 49 41 33 25 17  9  1

  The output has been subject to swaps of the form
  0 1 -> 3 1 but the odd and even bits have been put into
  2 3    2 0
  different words.  The main trick is to remember that
  t=((l>>size)^r)&(mask);
  r^=t;
  l^=(t<<size);
  can be used to swap and move bits between words.

  So l =  0  1  2  3  r = 16 17 18 19
          4  5  6  7      20 21 22 23
          8  9 10 11      24 25 26 27
         12 13 14 15      28 29 30 31
  becomes (for size == 2 and mask == 0x3333)
     t =   2^16  3^17 -- --   l =  0  1 16 17  r =  2  3 18 19
     6^20  7^21 -- --        4  5 20 21       6  7 22 23
    10^24 11^25 -- --        8  9 24 25      10 11 24 25
    14^28 15^29 -- --       12 13 28 29      14 15 28 29

  Thanks for hints from Richard Outerbridge - he told me IP&FP
  could be done in 15 xor, 10 shifts and 5 ands.
  When I finally started to think of the problem in 2D
  I first got ~42 operations without xors.  When I remembered
  how to use xors :-) I got it to its final state.
  */
#define PERM_OP(a,b,t,n,m) ((t)=((((a)>>(n))^(b))&(m)),\
  (b)^=(t),\
  (a)^=((t)<<(n)))

#define IP(l,r) \
  { \
  register DES_LONG tt; \
  PERM_OP(r,l,tt, 4,0x0f0f0f0fL); \
  PERM_OP(l,r,tt,16,0x0000ffffL); \
  PERM_OP(r,l,tt, 2,0x33333333L); \
  PERM_OP(l,r,tt, 8,0x00ff00ffL); \
  PERM_OP(r,l,tt, 1,0x55555555L); \
  }

#define FP(l,r) \
  { \
  register DES_LONG tt; \
  PERM_OP(l,r,tt, 1,0x55555555L); \
  PERM_OP(r,l,tt, 8,0x00ff00ffL); \
  PERM_OP(l,r,tt, 2,0x33333333L); \
  PERM_OP(r,l,tt,16,0x0000ffffL); \
  PERM_OP(l,r,tt, 4,0x0f0f0f0fL); \
  }
 
// ----------------- podd.h --------------
static const uint8_t odd_parity[256]={
  1,  1,  2,  2,  4,  4,  7,  7,  8,  8, 11, 11, 13, 13, 14, 14,
 16, 16, 19, 19, 21, 21, 22, 22, 25, 25, 26, 26, 28, 28, 31, 31,
 32, 32, 35, 35, 37, 37, 38, 38, 41, 41, 42, 42, 44, 44, 47, 47,
 49, 49, 50, 50, 52, 52, 55, 55, 56, 56, 59, 59, 61, 61, 62, 62,
 64, 64, 67, 67, 69, 69, 70, 70, 73, 73, 74, 74, 76, 76, 79, 79,
 81, 81, 82, 82, 84, 84, 87, 87, 88, 88, 91, 91, 93, 93, 94, 94,
 97, 97, 98, 98,100,100,103,103,104,104,107,107,109,109,110,110,
112,112,115,115,117,117,118,118,121,121,122,122,124,124,127,127,
128,128,131,131,133,133,134,134,137,137,138,138,140,140,143,143,
145,145,146,146,148,148,151,151,152,152,155,155,157,157,158,158,
161,161,162,162,164,164,167,167,168,168,171,171,173,173,174,174,
176,176,179,179,181,181,182,182,185,185,186,186,188,188,191,191,
193,193,194,194,196,196,199,199,200,200,203,203,205,205,206,206,
208,208,211,211,213,213,214,214,217,217,218,218,220,220,223,223,
224,224,227,227,229,229,230,230,233,233,234,234,236,236,239,239,
241,241,242,242,244,244,247,247,248,248,251,251,253,253,254,254};

// ------------------ sk.h ---------------
static const DES_LONG des_skb[8][64]={
{
/* for C bits (numbered as per FIPS 46) 1 2 3 4 5 6 */
0x00000000L,0x00000010L,0x20000000L,0x20000010L,
0x00010000L,0x00010010L,0x20010000L,0x20010010L,
0x00000800L,0x00000810L,0x20000800L,0x20000810L,
0x00010800L,0x00010810L,0x20010800L,0x20010810L,
0x00000020L,0x00000030L,0x20000020L,0x20000030L,
0x00010020L,0x00010030L,0x20010020L,0x20010030L,
0x00000820L,0x00000830L,0x20000820L,0x20000830L,
0x00010820L,0x00010830L,0x20010820L,0x20010830L,
0x00080000L,0x00080010L,0x20080000L,0x20080010L,
0x00090000L,0x00090010L,0x20090000L,0x20090010L,
0x00080800L,0x00080810L,0x20080800L,0x20080810L,
0x00090800L,0x00090810L,0x20090800L,0x20090810L,
0x00080020L,0x00080030L,0x20080020L,0x20080030L,
0x00090020L,0x00090030L,0x20090020L,0x20090030L,
0x00080820L,0x00080830L,0x20080820L,0x20080830L,
0x00090820L,0x00090830L,0x20090820L,0x20090830L,
},{
/* for C bits (numbered as per FIPS 46) 7 8 10 11 12 13 */
0x00000000L,0x02000000L,0x00002000L,0x02002000L,
0x00200000L,0x02200000L,0x00202000L,0x02202000L,
0x00000004L,0x02000004L,0x00002004L,0x02002004L,
0x00200004L,0x02200004L,0x00202004L,0x02202004L,
0x00000400L,0x02000400L,0x00002400L,0x02002400L,
0x00200400L,0x02200400L,0x00202400L,0x02202400L,
0x00000404L,0x02000404L,0x00002404L,0x02002404L,
0x00200404L,0x02200404L,0x00202404L,0x02202404L,
0x10000000L,0x12000000L,0x10002000L,0x12002000L,
0x10200000L,0x12200000L,0x10202000L,0x12202000L,
0x10000004L,0x12000004L,0x10002004L,0x12002004L,
0x10200004L,0x12200004L,0x10202004L,0x12202004L,
0x10000400L,0x12000400L,0x10002400L,0x12002400L,
0x10200400L,0x12200400L,0x10202400L,0x12202400L,
0x10000404L,0x12000404L,0x10002404L,0x12002404L,
0x10200404L,0x12200404L,0x10202404L,0x12202404L,
},{
/* for C bits (numbered as per FIPS 46) 14 15 16 17 19 20 */
0x00000000L,0x00000001L,0x00040000L,0x00040001L,
0x01000000L,0x01000001L,0x01040000L,0x01040001L,
0x00000002L,0x00000003L,0x00040002L,0x00040003L,
0x01000002L,0x01000003L,0x01040002L,0x01040003L,
0x00000200L,0x00000201L,0x00040200L,0x00040201L,
0x01000200L,0x01000201L,0x01040200L,0x01040201L,
0x00000202L,0x00000203L,0x00040202L,0x00040203L,
0x01000202L,0x01000203L,0x01040202L,0x01040203L,
0x08000000L,0x08000001L,0x08040000L,0x08040001L,
0x09000000L,0x09000001L,0x09040000L,0x09040001L,
0x08000002L,0x08000003L,0x08040002L,0x08040003L,
0x09000002L,0x09000003L,0x09040002L,0x09040003L,
0x08000200L,0x08000201L,0x08040200L,0x08040201L,
0x09000200L,0x09000201L,0x09040200L,0x09040201L,
0x08000202L,0x08000203L,0x08040202L,0x08040203L,
0x09000202L,0x09000203L,0x09040202L,0x09040203L,
},{
/* for C bits (numbered as per FIPS 46) 21 23 24 26 27 28 */
0x00000000L,0x00100000L,0x00000100L,0x00100100L,
0x00000008L,0x00100008L,0x00000108L,0x00100108L,
0x00001000L,0x00101000L,0x00001100L,0x00101100L,
0x00001008L,0x00101008L,0x00001108L,0x00101108L,
0x04000000L,0x04100000L,0x04000100L,0x04100100L,
0x04000008L,0x04100008L,0x04000108L,0x04100108L,
0x04001000L,0x04101000L,0x04001100L,0x04101100L,
0x04001008L,0x04101008L,0x04001108L,0x04101108L,
0x00020000L,0x00120000L,0x00020100L,0x00120100L,
0x00020008L,0x00120008L,0x00020108L,0x00120108L,
0x00021000L,0x00121000L,0x00021100L,0x00121100L,
0x00021008L,0x00121008L,0x00021108L,0x00121108L,
0x04020000L,0x04120000L,0x04020100L,0x04120100L,
0x04020008L,0x04120008L,0x04020108L,0x04120108L,
0x04021000L,0x04121000L,0x04021100L,0x04121100L,
0x04021008L,0x04121008L,0x04021108L,0x04121108L,
},{
/* for D bits (numbered as per FIPS 46) 1 2 3 4 5 6 */
0x00000000L,0x10000000L,0x00010000L,0x10010000L,
0x00000004L,0x10000004L,0x00010004L,0x10010004L,
0x20000000L,0x30000000L,0x20010000L,0x30010000L,
0x20000004L,0x30000004L,0x20010004L,0x30010004L,
0x00100000L,0x10100000L,0x00110000L,0x10110000L,
0x00100004L,0x10100004L,0x00110004L,0x10110004L,
0x20100000L,0x30100000L,0x20110000L,0x30110000L,
0x20100004L,0x30100004L,0x20110004L,0x30110004L,
0x00001000L,0x10001000L,0x00011000L,0x10011000L,
0x00001004L,0x10001004L,0x00011004L,0x10011004L,
0x20001000L,0x30001000L,0x20011000L,0x30011000L,
0x20001004L,0x30001004L,0x20011004L,0x30011004L,
0x00101000L,0x10101000L,0x00111000L,0x10111000L,
0x00101004L,0x10101004L,0x00111004L,0x10111004L,
0x20101000L,0x30101000L,0x20111000L,0x30111000L,
0x20101004L,0x30101004L,0x20111004L,0x30111004L,
},{
/* for D bits (numbered as per FIPS 46) 8 9 11 12 13 14 */
0x00000000L,0x08000000L,0x00000008L,0x08000008L,
0x00000400L,0x08000400L,0x00000408L,0x08000408L,
0x00020000L,0x08020000L,0x00020008L,0x08020008L,
0x00020400L,0x08020400L,0x00020408L,0x08020408L,
0x00000001L,0x08000001L,0x00000009L,0x08000009L,
0x00000401L,0x08000401L,0x00000409L,0x08000409L,
0x00020001L,0x08020001L,0x00020009L,0x08020009L,
0x00020401L,0x08020401L,0x00020409L,0x08020409L,
0x02000000L,0x0A000000L,0x02000008L,0x0A000008L,
0x02000400L,0x0A000400L,0x02000408L,0x0A000408L,
0x02020000L,0x0A020000L,0x02020008L,0x0A020008L,
0x02020400L,0x0A020400L,0x02020408L,0x0A020408L,
0x02000001L,0x0A000001L,0x02000009L,0x0A000009L,
0x02000401L,0x0A000401L,0x02000409L,0x0A000409L,
0x02020001L,0x0A020001L,0x02020009L,0x0A020009L,
0x02020401L,0x0A020401L,0x02020409L,0x0A020409L,
},{
/* for D bits (numbered as per FIPS 46) 16 17 18 19 20 21 */
0x00000000L,0x00000100L,0x00080000L,0x00080100L,
0x01000000L,0x01000100L,0x01080000L,0x01080100L,
0x00000010L,0x00000110L,0x00080010L,0x00080110L,
0x01000010L,0x01000110L,0x01080010L,0x01080110L,
0x00200000L,0x00200100L,0x00280000L,0x00280100L,
0x01200000L,0x01200100L,0x01280000L,0x01280100L,
0x00200010L,0x00200110L,0x00280010L,0x00280110L,
0x01200010L,0x01200110L,0x01280010L,0x01280110L,
0x00000200L,0x00000300L,0x00080200L,0x00080300L,
0x01000200L,0x01000300L,0x01080200L,0x01080300L,
0x00000210L,0x00000310L,0x00080210L,0x00080310L,
0x01000210L,0x01000310L,0x01080210L,0x01080310L,
0x00200200L,0x00200300L,0x00280200L,0x00280300L,
0x01200200L,0x01200300L,0x01280200L,0x01280300L,
0x00200210L,0x00200310L,0x00280210L,0x00280310L,
0x01200210L,0x01200310L,0x01280210L,0x01280310L,
},{
/* for D bits (numbered as per FIPS 46) 22 23 24 25 27 28 */
0x00000000L,0x04000000L,0x00040000L,0x04040000L,
0x00000002L,0x04000002L,0x00040002L,0x04040002L,
0x00002000L,0x04002000L,0x00042000L,0x04042000L,
0x00002002L,0x04002002L,0x00042002L,0x04042002L,
0x00000020L,0x04000020L,0x00040020L,0x04040020L,
0x00000022L,0x04000022L,0x00040022L,0x04040022L,
0x00002020L,0x04002020L,0x00042020L,0x04042020L,
0x00002022L,0x04002022L,0x00042022L,0x04042022L,
0x00000800L,0x04000800L,0x00040800L,0x04040800L,
0x00000802L,0x04000802L,0x00040802L,0x04040802L,
0x00002800L,0x04002800L,0x00042800L,0x04042800L,
0x00002802L,0x04002802L,0x00042802L,0x04042802L,
0x00000820L,0x04000820L,0x00040820L,0x04040820L,
0x00000822L,0x04000822L,0x00040822L,0x04040822L,
0x00002820L,0x04002820L,0x00042820L,0x04042820L,
0x00002822L,0x04002822L,0x00042822L,0x04042822L,
}};

// -------------------------- spr.h ---------------


static const DES_LONG des_SPtrans[8][64]={
{
/* nibble 0 */
0x00820200L, 0x00020000L, 0x80800000L, 0x80820200L,
0x00800000L, 0x80020200L, 0x80020000L, 0x80800000L,
0x80020200L, 0x00820200L, 0x00820000L, 0x80000200L,
0x80800200L, 0x00800000L, 0x00000000L, 0x80020000L,
0x00020000L, 0x80000000L, 0x00800200L, 0x00020200L,
0x80820200L, 0x00820000L, 0x80000200L, 0x00800200L,
0x80000000L, 0x00000200L, 0x00020200L, 0x80820000L,
0x00000200L, 0x80800200L, 0x80820000L, 0x00000000L,
0x00000000L, 0x80820200L, 0x00800200L, 0x80020000L,
0x00820200L, 0x00020000L, 0x80000200L, 0x00800200L,
0x80820000L, 0x00000200L, 0x00020200L, 0x80800000L,
0x80020200L, 0x80000000L, 0x80800000L, 0x00820000L,
0x80820200L, 0x00020200L, 0x00820000L, 0x80800200L,
0x00800000L, 0x80000200L, 0x80020000L, 0x00000000L,
0x00020000L, 0x00800000L, 0x80800200L, 0x00820200L,
0x80000000L, 0x80820000L, 0x00000200L, 0x80020200L,
},{
/* nibble 1 */
0x10042004L, 0x00000000L, 0x00042000L, 0x10040000L,
0x10000004L, 0x00002004L, 0x10002000L, 0x00042000L,
0x00002000L, 0x10040004L, 0x00000004L, 0x10002000L,
0x00040004L, 0x10042000L, 0x10040000L, 0x00000004L,
0x00040000L, 0x10002004L, 0x10040004L, 0x00002000L,
0x00042004L, 0x10000000L, 0x00000000L, 0x00040004L,
0x10002004L, 0x00042004L, 0x10042000L, 0x10000004L,
0x10000000L, 0x00040000L, 0x00002004L, 0x10042004L,
0x00040004L, 0x10042000L, 0x10002000L, 0x00042004L,
0x10042004L, 0x00040004L, 0x10000004L, 0x00000000L,
0x10000000L, 0x00002004L, 0x00040000L, 0x10040004L,
0x00002000L, 0x10000000L, 0x00042004L, 0x10002004L,
0x10042000L, 0x00002000L, 0x00000000L, 0x10000004L,
0x00000004L, 0x10042004L, 0x00042000L, 0x10040000L,
0x10040004L, 0x00040000L, 0x00002004L, 0x10002000L,
0x10002004L, 0x00000004L, 0x10040000L, 0x00042000L,
},{
/* nibble 2 */
0x41000000L, 0x01010040L, 0x00000040L, 0x41000040L,
0x40010000L, 0x01000000L, 0x41000040L, 0x00010040L,
0x01000040L, 0x00010000L, 0x01010000L, 0x40000000L,
0x41010040L, 0x40000040L, 0x40000000L, 0x41010000L,
0x00000000L, 0x40010000L, 0x01010040L, 0x00000040L,
0x40000040L, 0x41010040L, 0x00010000L, 0x41000000L,
0x41010000L, 0x01000040L, 0x40010040L, 0x01010000L,
0x00010040L, 0x00000000L, 0x01000000L, 0x40010040L,
0x01010040L, 0x00000040L, 0x40000000L, 0x00010000L,
0x40000040L, 0x40010000L, 0x01010000L, 0x41000040L,
0x00000000L, 0x01010040L, 0x00010040L, 0x41010000L,
0x40010000L, 0x01000000L, 0x41010040L, 0x40000000L,
0x40010040L, 0x41000000L, 0x01000000L, 0x41010040L,
0x00010000L, 0x01000040L, 0x41000040L, 0x00010040L,
0x01000040L, 0x00000000L, 0x41010000L, 0x40000040L,
0x41000000L, 0x40010040L, 0x00000040L, 0x01010000L,
},{
/* nibble 3 */
0x00100402L, 0x04000400L, 0x00000002L, 0x04100402L,
0x00000000L, 0x04100000L, 0x04000402L, 0x00100002L,
0x04100400L, 0x04000002L, 0x04000000L, 0x00000402L,
0x04000002L, 0x00100402L, 0x00100000L, 0x04000000L,
0x04100002L, 0x00100400L, 0x00000400L, 0x00000002L,
0x00100400L, 0x04000402L, 0x04100000L, 0x00000400L,
0x00000402L, 0x00000000L, 0x00100002L, 0x04100400L,
0x04000400L, 0x04100002L, 0x04100402L, 0x00100000L,
0x04100002L, 0x00000402L, 0x00100000L, 0x04000002L,
0x00100400L, 0x04000400L, 0x00000002L, 0x04100000L,
0x04000402L, 0x00000000L, 0x00000400L, 0x00100002L,
0x00000000L, 0x04100002L, 0x04100400L, 0x00000400L,
0x04000000L, 0x04100402L, 0x00100402L, 0x00100000L,
0x04100402L, 0x00000002L, 0x04000400L, 0x00100402L,
0x00100002L, 0x00100400L, 0x04100000L, 0x04000402L,
0x00000402L, 0x04000000L, 0x04000002L, 0x04100400L,
},{
/* nibble 4 */
0x02000000L, 0x00004000L, 0x00000100L, 0x02004108L,
0x02004008L, 0x02000100L, 0x00004108L, 0x02004000L,
0x00004000L, 0x00000008L, 0x02000008L, 0x00004100L,
0x02000108L, 0x02004008L, 0x02004100L, 0x00000000L,
0x00004100L, 0x02000000L, 0x00004008L, 0x00000108L,
0x02000100L, 0x00004108L, 0x00000000L, 0x02000008L,
0x00000008L, 0x02000108L, 0x02004108L, 0x00004008L,
0x02004000L, 0x00000100L, 0x00000108L, 0x02004100L,
0x02004100L, 0x02000108L, 0x00004008L, 0x02004000L,
0x00004000L, 0x00000008L, 0x02000008L, 0x02000100L,
0x02000000L, 0x00004100L, 0x02004108L, 0x00000000L,
0x00004108L, 0x02000000L, 0x00000100L, 0x00004008L,
0x02000108L, 0x00000100L, 0x00000000L, 0x02004108L,
0x02004008L, 0x02004100L, 0x00000108L, 0x00004000L,
0x00004100L, 0x02004008L, 0x02000100L, 0x00000108L,
0x00000008L, 0x00004108L, 0x02004000L, 0x02000008L,
},{
/* nibble 5 */
0x20000010L, 0x00080010L, 0x00000000L, 0x20080800L,
0x00080010L, 0x00000800L, 0x20000810L, 0x00080000L,
0x00000810L, 0x20080810L, 0x00080800L, 0x20000000L,
0x20000800L, 0x20000010L, 0x20080000L, 0x00080810L,
0x00080000L, 0x20000810L, 0x20080010L, 0x00000000L,
0x00000800L, 0x00000010L, 0x20080800L, 0x20080010L,
0x20080810L, 0x20080000L, 0x20000000L, 0x00000810L,
0x00000010L, 0x00080800L, 0x00080810L, 0x20000800L,
0x00000810L, 0x20000000L, 0x20000800L, 0x00080810L,
0x20080800L, 0x00080010L, 0x00000000L, 0x20000800L,
0x20000000L, 0x00000800L, 0x20080010L, 0x00080000L,
0x00080010L, 0x20080810L, 0x00080800L, 0x00000010L,
0x20080810L, 0x00080800L, 0x00080000L, 0x20000810L,
0x20000010L, 0x20080000L, 0x00080810L, 0x00000000L,
0x00000800L, 0x20000010L, 0x20000810L, 0x20080800L,
0x20080000L, 0x00000810L, 0x00000010L, 0x20080010L,
},{
/* nibble 6 */
0x00001000L, 0x00000080L, 0x00400080L, 0x00400001L,
0x00401081L, 0x00001001L, 0x00001080L, 0x00000000L,
0x00400000L, 0x00400081L, 0x00000081L, 0x00401000L,
0x00000001L, 0x00401080L, 0x00401000L, 0x00000081L,
0x00400081L, 0x00001000L, 0x00001001L, 0x00401081L,
0x00000000L, 0x00400080L, 0x00400001L, 0x00001080L,
0x00401001L, 0x00001081L, 0x00401080L, 0x00000001L,
0x00001081L, 0x00401001L, 0x00000080L, 0x00400000L,
0x00001081L, 0x00401000L, 0x00401001L, 0x00000081L,
0x00001000L, 0x00000080L, 0x00400000L, 0x00401001L,
0x00400081L, 0x00001081L, 0x00001080L, 0x00000000L,
0x00000080L, 0x00400001L, 0x00000001L, 0x00400080L,
0x00000000L, 0x00400081L, 0x00400080L, 0x00001080L,
0x00000081L, 0x00001000L, 0x00401081L, 0x00400000L,
0x00401080L, 0x00000001L, 0x00001001L, 0x00401081L,
0x00400001L, 0x00401080L, 0x00401000L, 0x00001001L,
},{
/* nibble 7 */
0x08200020L, 0x08208000L, 0x00008020L, 0x00000000L,
0x08008000L, 0x00200020L, 0x08200000L, 0x08208020L,
0x00000020L, 0x08000000L, 0x00208000L, 0x00008020L,
0x00208020L, 0x08008020L, 0x08000020L, 0x08200000L,
0x00008000L, 0x00208020L, 0x00200020L, 0x08008000L,
0x08208020L, 0x08000020L, 0x00000000L, 0x00208000L,
0x08000000L, 0x00200000L, 0x08008020L, 0x08200020L,
0x00200000L, 0x00008000L, 0x08208000L, 0x00000020L,
0x00200000L, 0x00008000L, 0x08000020L, 0x08208020L,
0x00008020L, 0x08000000L, 0x00000000L, 0x00208000L,
0x08200020L, 0x08008020L, 0x08008000L, 0x00200020L,
0x08208000L, 0x00000020L, 0x00200020L, 0x08008000L,
0x08208020L, 0x00200000L, 0x08200000L, 0x08000020L,
0x00208000L, 0x00008020L, 0x08008020L, 0x08200000L,
0x00000020L, 0x08208000L, 0x00208020L, 0x00000000L,
0x08000000L, 0x08200020L, 0x00008000L, 0x00208020L,
}};

/*************** ??? ***************/

/*--------------------Define -------------------------------------------*/
#define MBEDTLS_CIPHER_WRAP_H
#define MBEDTLS_GCM_C

#if defined(MBEDTLS_GCM_C) || defined(MBEDTLS_CCM_C)
#define MBEDTLS_CIPHER_MODE_AEAD
#endif

#define MBEDTLS_ERR_CIPHER_FEATURE_UNAVAILABLE            -0x6080  /**< The selected feature is not available. */
#define MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA                 -0x6100  /**< Bad input parameters to function. */
#define MBEDTLS_ERR_CIPHER_ALLOC_FAILED                   -0x6180  /**< Failed to allocate memory. */
#define MBEDTLS_ERR_CIPHER_INVALID_PADDING                -0x6200  /**< Input data contains invalid padding and is rejected. */
#define MBEDTLS_ERR_CIPHER_FULL_BLOCK_EXPECTED            -0x6280  /**< Decryption of block requires a full block. */
#define MBEDTLS_ERR_CIPHER_AUTH_FAILED                    -0x6300  /**< Authentication failed (for AEAD modes). */
#define MBEDTLS_ERR_CIPHER_INVALID_CONTEXT              -0x6380  /**< The context is invalid, eg because it was free()ed. */

#define MBEDTLS_CIPHER_VARIABLE_IV_LEN     0x01    /**< Cipher accepts IVs of variable length */
#define MBEDTLS_CIPHER_VARIABLE_KEY_LEN    0x02    /**< Cipher accepts keys of variable length */

/** Maximum length of any IV, in bytes */
#define MBEDTLS_MAX_IV_LENGTH      16
/** Maximum block size of any cipher, in bytes */
#define MBEDTLS_MAX_BLOCK_LENGTH   16




//mode cipher,same as hal_crypto.h define
//#define CRYPTO_CIPHER_DES_ECB             0x0
//#define CRYPTO_CIPHER_DES_CBC             0x1
//#define CRYPTO_CIPHER_3DES_ECB            0x10
//#define CRYPTO_CIPHER_3DES_CBC            0x11
#define CRYPTO_CIPHER_AES_ECB             0x20
#define CRYPTO_CIPHER_AES_CBC             0x21
#define CRYPTO_CIPHER_AES_CFB             0x22
#define CRYPTO_CIPHER_AES_OFB             0x23
#define CRYPTO_CIPHER_AES_CTR             0x24
#define CRYPTO_CIPHER_AES_GCTR            0x25
#define CRYPTO_CIPHER_AES_GMAC            0x26
#define CRYPTO_CIPHER_AES_GHASH           0x27
#define CRYPTO_CIPHER_AES_GCM             0x28
#define CRYPTO_CIPHER_AES_CMAC            0x29
#define CRYPTO_CIPHER_AES_CMAC_K1         0x2A
#define CRYPTO_CIPHER_AES_CMAC_K2         0x2B

#define CRYPTO_CIPHER_RC4_BASIC           0x40
#define CRYPTO_CIPHER_RC4_RFC4345         0x41

#define CRYPTO_CIPHER_MICHAEL             0x50
#define CRYPTO_CIPHER_KEY_WRAP            0x60


//#define CRYPTO_CIPHER_CHACHA_POLY1305     0x30
//#define CRYPTO_CIPHER_CHACHA              0x31

//#define CRYPTO_MIX_MODE_SW_SSH_ENC             0x11
//#define CRYPTO_MIX_MODE_SW_SSH_DEC             0x01
//#define CRYPTO_MIX_MODE_SW_ESP_ENC             0x12
//#define CRYPTO_MIX_MODE_SW_ESP_DEC             0x02
//#define CRYPTO_MIX_MODE_SW_SSL_TLS_ENC         0x13
//#define CRYPTO_MIX_MODE_SW_MASK_TYPE           0x03    //SSH/ESP/SSL
//#define CRYPTO_MIX_MODE_SW_MASK_FUNC           0x10

/* padlock.c and aesni.c rely on these values! */
#define MBEDTLS_AES_ENCRYPT     1
#define MBEDTLS_AES_DECRYPT     0

#define MBEDTLS_ERR_AES_INVALID_KEY_LENGTH                -0x0020  /**< Invalid key length. */
#define MBEDTLS_ERR_AES_INVALID_INPUT_LENGTH              -0x0022  /**< Invalid data input length. */



//DES
//#define SWDECRYPT_ECB_DES           0x00
//#define SWDECRYPT_CBC_DES           0x01
//#define SWDECRYPT_ECB_3DES          0x10
//#define SWDECRYPT_CBC_3DES          0x11

//#define SWENCRYPT_ECB_DES           0x80
//#define SWENCRYPT_CBC_DES           0x81
//#define SWENCRYPT_ECB_3DES          0x90
//#define SWENCRYPT_CBC_3DES          0x91

#if 0
//AES
#define SWDECRYPT_ECB_AES           0x20
#define SWDECRYPT_CBC_AES           0x21
#define SWDECRYPT_CFB_AES           0x22
#define SWDECRYPT_OFB_AES           0x23
#define SWDECRYPT_CTR_AES           0x24
#define SWDECRYPT_GCTR_AES          0x25
#define SWDECRYPT_GCM_AES           0x28

#define SWENCRYPT_ECB_AES           0xa0
#define SWENCRYPT_CBC_AES           0xa1
#define SWENCRYPT_CFB_AES           0xa2
#define SWENCRYPT_OFB_AES           0xa3
#define SWENCRYPT_CTR_AES           0xa4
#define SWENCRYPT_GCTR_AES          0xa5
#define SWENCRYPT_GCM_AES           0xa8
#endif

//CHACHA
//#define SWDECRYPT_CHACHA            0x31
//#define SWENCRYPT_CHACHA            0xb1

//CHACHA_POLY1305
//#define SWDECRYPT_CHACHA_POLY1305   0x30
//#define SWENCRYPT_CHACHA_POLY1305   0xb0

#define MBEDTLS_AES_C

#define MBEDTLS_GCM_ENCRYPT     1
#define MBEDTLS_GCM_DECRYPT     0

#define MBEDTLS_ERR_GCM_AUTH_FAILED                       -0x0012  /**< Authenticated decryption failed. */
#define MBEDTLS_ERR_GCM_BAD_INPUT                         -0x0014  /**< Bad input parameters to function. */

#define AES_BLOCK_SIZE 16

/*--------------------Define Enum---------------------------------------*/
typedef enum {
    MBEDTLS_CIPHER_ID_NONE = 0,
    MBEDTLS_CIPHER_ID_NULL,
    MBEDTLS_CIPHER_ID_AES,
    MBEDTLS_CIPHER_ID_DES,
    MBEDTLS_CIPHER_ID_3DES,
    MBEDTLS_CIPHER_ID_CAMELLIA,
    MBEDTLS_CIPHER_ID_BLOWFISH,
    MBEDTLS_CIPHER_ID_ARC4,
} mbedtls_cipher_id_t;

typedef enum {
    MBEDTLS_CIPHER_NONE = 0,
    MBEDTLS_CIPHER_NULL,
    MBEDTLS_CIPHER_AES_128_ECB,
    MBEDTLS_CIPHER_AES_192_ECB,
    MBEDTLS_CIPHER_AES_256_ECB,
    MBEDTLS_CIPHER_AES_128_CBC,
    MBEDTLS_CIPHER_AES_192_CBC,
    MBEDTLS_CIPHER_AES_256_CBC,
    MBEDTLS_CIPHER_AES_128_CFB128,
    MBEDTLS_CIPHER_AES_192_CFB128,
    MBEDTLS_CIPHER_AES_256_CFB128,
    MBEDTLS_CIPHER_AES_128_CTR,
    MBEDTLS_CIPHER_AES_192_CTR,
    MBEDTLS_CIPHER_AES_256_CTR,
    MBEDTLS_CIPHER_AES_128_GCM,
    MBEDTLS_CIPHER_AES_192_GCM,
    MBEDTLS_CIPHER_AES_256_GCM,
    MBEDTLS_CIPHER_CAMELLIA_128_ECB,
    MBEDTLS_CIPHER_CAMELLIA_192_ECB,
    MBEDTLS_CIPHER_CAMELLIA_256_ECB,
    MBEDTLS_CIPHER_CAMELLIA_128_CBC,
    MBEDTLS_CIPHER_CAMELLIA_192_CBC,
    MBEDTLS_CIPHER_CAMELLIA_256_CBC,
    MBEDTLS_CIPHER_CAMELLIA_128_CFB128,
    MBEDTLS_CIPHER_CAMELLIA_192_CFB128,
    MBEDTLS_CIPHER_CAMELLIA_256_CFB128,
    MBEDTLS_CIPHER_CAMELLIA_128_CTR,
    MBEDTLS_CIPHER_CAMELLIA_192_CTR,
    MBEDTLS_CIPHER_CAMELLIA_256_CTR,
    MBEDTLS_CIPHER_CAMELLIA_128_GCM,
    MBEDTLS_CIPHER_CAMELLIA_192_GCM,
    MBEDTLS_CIPHER_CAMELLIA_256_GCM,
    MBEDTLS_CIPHER_DES_ECB,
    MBEDTLS_CIPHER_DES_CBC,
    MBEDTLS_CIPHER_DES_EDE_ECB,
    MBEDTLS_CIPHER_DES_EDE_CBC,
    MBEDTLS_CIPHER_DES_EDE3_ECB,
    MBEDTLS_CIPHER_DES_EDE3_CBC,
    MBEDTLS_CIPHER_BLOWFISH_ECB,
    MBEDTLS_CIPHER_BLOWFISH_CBC,
    MBEDTLS_CIPHER_BLOWFISH_CFB64,
    MBEDTLS_CIPHER_BLOWFISH_CTR,
    MBEDTLS_CIPHER_ARC4_128,
    MBEDTLS_CIPHER_AES_128_CCM,
    MBEDTLS_CIPHER_AES_192_CCM,
    MBEDTLS_CIPHER_AES_256_CCM,
    MBEDTLS_CIPHER_CAMELLIA_128_CCM,
    MBEDTLS_CIPHER_CAMELLIA_192_CCM,
    MBEDTLS_CIPHER_CAMELLIA_256_CCM,
} mbedtls_cipher_type_t;

typedef enum {
    MBEDTLS_MODE_NONE = 0,
    MBEDTLS_MODE_ECB,
    MBEDTLS_MODE_CBC,
    MBEDTLS_MODE_CFB,
    MBEDTLS_MODE_OFB, /* Unused! */
    MBEDTLS_MODE_CTR,
    MBEDTLS_MODE_GCM,
    MBEDTLS_MODE_STREAM,
    MBEDTLS_MODE_CCM,
} mbedtls_cipher_mode_t;

typedef enum {
    MBEDTLS_PADDING_PKCS7 = 0,     /**< PKCS7 padding (default)        */
    MBEDTLS_PADDING_ONE_AND_ZEROS, /**< ISO/IEC 7816-4 padding         */
    MBEDTLS_PADDING_ZEROS_AND_LEN, /**< ANSI X.923 padding             */
    MBEDTLS_PADDING_ZEROS,         /**< zero padding (not reversible!) */
    MBEDTLS_PADDING_NONE,          /**< never pad (full blocks only)   */
} mbedtls_cipher_padding_t;

typedef enum {
    MBEDTLS_OPERATION_NONE = -1,
    MBEDTLS_DECRYPT = 0,
    MBEDTLS_ENCRYPT,
} mbedtls_operation_t;

enum {
    /** Undefined key length */
    MBEDTLS_KEY_LENGTH_NONE = 0,
    /** Key length, in bits (including parity), for DES keys */
    MBEDTLS_KEY_LENGTH_DES  = 64,
    /** Key length, in bits (including parity), for DES in two key EDE */
    MBEDTLS_KEY_LENGTH_DES_EDE = 128,
    /** Key length, in bits (including parity), for DES in three-key EDE */
    MBEDTLS_KEY_LENGTH_DES_EDE3 = 192,
};

/*--------------------Define MACRO--------------------------------------*/

/*--------------------Define Struct-------------------------------------*/
/**
 * Base cipher information. The non-mode specific functions and values.
 */
struct mbedtls_cipher_base_t {
    /** Base Cipher type (e.g. MBEDTLS_CIPHER_ID_AES) */
    mbedtls_cipher_id_t cipher;

    /** Encrypt using ECB */
    s32(*ecb_func)(void *ctx, mbedtls_operation_t mode,
                   const u8 *input, u8 *output);
#if 0
#if defined(MBEDTLS_CIPHER_MODE_CBC)
    /** Encrypt using CBC */
    s32(*cbc_func)(void *ctx, mbedtls_operation_t mode, u32 length,
                   u8 *iv, const u8 *input,
                   u8 *output);
#endif

#if defined(MBEDTLS_CIPHER_MODE_CFB)
    /** Encrypt using CFB (Full length) */
    s32(*cfb_func)(void *ctx, mbedtls_operation_t mode, u32 length, size_t *iv_off,
                   u8 *iv, const u8 *input,
                   u8 *output);
#endif

#if defined(MBEDTLS_CIPHER_MODE_CTR)
    /** Encrypt using CTR */
    s32(*ctr_func)(void *ctx, u32 length, u32 *nc_off,
                   u8 *nonce_counter, u8 *stream_block,
                   const u8 *input, u8 *output);
#endif

#if defined(MBEDTLS_CIPHER_MODE_STREAM)
    /** Encrypt using STREAM */
    s32(*stream_func)(void *ctx, u32 length,
                      const u8 *input, u8 *output);
#endif
#endif
    /** Set key for encryption purposes */
    s32(*setkey_enc_func)(void *ctx, const u8 *key,
                          u32 key_bitlen);

    /** Set key for decryption purposes */
    s32(*setkey_dec_func)(void *ctx, const u8 *key,
                          u32 key_bitlen);

    /** Allocate a new context */
    void *(*ctx_alloc_func)(void);

    /** Free the given context */
    void (*ctx_free_func)(void *ctx);

};

/**
 * Base cipher information (opaque struct).
 */
typedef struct mbedtls_cipher_base_t mbedtls_cipher_base_t;

/**
 * CMAC context (opaque struct).
 */
typedef struct mbedtls_cmac_context_t mbedtls_cmac_context_t;

/**
 * Cipher information. Allows cipher functions to be called in a generic way.
 */
typedef struct {
    /** Full cipher identifier (e.g. MBEDTLS_CIPHER_AES_256_CBC) */
    mbedtls_cipher_type_t type;

    /** Cipher mode (e.g. MBEDTLS_MODE_CBC) */
    mbedtls_cipher_mode_t mode;

    /** Cipher key length, in bits (default length for variable sized ciphers)
     *  (Includes parity bits for ciphers like DES) */
    u32 key_bitlen;

    /** Name of the cipher */
    const char *name;

    /** IV/NONCE size, in bytes.
     *  For cipher that accept many sizes: recommended size */
    u32 iv_size;

    /** Flags for variable IV size, variable key size, etc. */
    s32 flags;

    /** block size, in bytes */
    u32 block_size;

    /** Base cipher information and functions */
    const mbedtls_cipher_base_t *base;

} mbedtls_cipher_info_t;

typedef struct {
    mbedtls_cipher_type_t type;
    const mbedtls_cipher_info_t *info;
} mbedtls_cipher_definition_t;

extern const mbedtls_cipher_definition_t mbedtls_cipher_definitions[];

extern s32 mbedtls_cipher_supported[];

/**
 * Generic cipher context.
 */
typedef struct {
    /** Information about the associated cipher */
    const mbedtls_cipher_info_t *cipher_info;

    /** Key length to use */
    s32 key_bitlen;

    /** Operation that the context's key has been initialised for */
    mbedtls_operation_t operation;

#if defined(MBEDTLS_CIPHER_MODE_WITH_PADDING)
    /** Padding functions to use, if relevant for cipher mode */
    void (*add_padding)(u8 *output, u32 olen, u32 data_len);
    s32(*get_padding)(u8 *input, u32 ilen, u32 *data_len);
#endif

    /** Buffer for data that hasn't been encrypted yet */
    u8 unprocessed_data[MBEDTLS_MAX_BLOCK_LENGTH];

    /** Number of bytes that still need processing */
    u32 unprocessed_len;

    /** Current IV or NONCE_COUNTER for CTR-mode */
    u8 iv[MBEDTLS_MAX_IV_LENGTH];

    /** IV size in bytes (for ciphers with variable-length IVs) */
    u32 iv_size;

    /** Cipher-specific context */
    void *cipher_ctx;

#if defined(MBEDTLS_CMAC_C)
    /** CMAC Specific context */
    mbedtls_cmac_context_t *cmac_ctx;
#endif
} mbedtls_cipher_context_t;

/**
 * \brief          AES context structure
 *
 * \note           buf is able to hold 32 extra bytes, which can be used:
 *                 - for alignment purposes if VIA padlock is used, and/or
 *                 - to simplify key expansion in the 256-bit case by
 *                 generating an extra round key
 */
typedef struct {
    s32 nr;                     /*!<  number of rounds  */
    u32 *rk;               /*!<  AES round keys    */
    u32 buf[68];           /*!<  unaligned data    */
}
mbedtls_aes_context;

/**
 * \brief          GCM context structure
 */
typedef struct {
    mbedtls_cipher_context_t cipher_ctx;/*!< cipher context used */
    u64 HL[16];            /*!< Precalculated HTable */
    u64 HH[16];            /*!< Precalculated HTable */
    u64 len;               /*!< Total data length */
    u64 add_len;           /*!< Total add length */
    u8 base_ectr[16];/*!< First ECTR for tag */
    u8 y[16];        /*!< Y working value */
    u8 buf[16];      /*!< buf working value */
    s32 mode;                   /*!< Encrypt or Decrypt */
} mbedtls_gcm_context;

#if defined(MBEDTLS_AES_C)

typedef struct {
    u8 used;
    mbedtls_aes_context *aes_ctx;
} aes_gcm_alloc_ctx;
#endif

/*--------------------Export global variable----------------------------*/

/*--------------------Function declaration------------------------------*/

#if 0
/**
 * \brief Returns the list of ciphers supported by the generic cipher module.
 *
 * \return              a statically allocated array of ciphers, the last entry
 *                      is 0.
 */
const s32 *mbedtls_cipher_list(void);

/**
 * \brief               Returns the cipher information structure associated
 *                      with the given cipher name.
 *
 * \param cipher_name   Name of the cipher to search for.
 *
 * \return              the cipher information structure associated with the
 *                      given cipher_name, or NULL if not found.
 */
const mbedtls_cipher_info_t *mbedtls_cipher_info_from_string(const char *cipher_name);

/**
 * \brief               Returns the cipher information structure associated
 *                      with the given cipher type.
 *
 * \param cipher_type   Type of the cipher to search for.
 *
 * \return              the cipher information structure associated with the
 *                      given cipher_type, or NULL if not found.
 */
const mbedtls_cipher_info_t *mbedtls_cipher_info_from_type(const mbedtls_cipher_type_t cipher_type);
#endif

/**
 * \brief               Returns the cipher information structure associated
 *                      with the given cipher id, key size and mode.
 *
 * \param cipher_id     Id of the cipher to search for
 *                      (e.g. MBEDTLS_CIPHER_ID_AES)
 * \param key_bitlen    Length of the key in bits
 * \param mode          Cipher mode (e.g. MBEDTLS_MODE_CBC)
 *
 * \return              the cipher information structure associated with the
 *                      given cipher_type, or NULL if not found.
 */
const mbedtls_cipher_info_t *mbedtls_cipher_info_from_values(const mbedtls_cipher_id_t cipher_id,
        s32 key_bitlen,
        const mbedtls_cipher_mode_t mode);
#if 0
/**
 * \brief               Initialize a cipher_context (as NONE)
 */
void mbedtls_cipher_init(mbedtls_cipher_context_t *ctx);
#endif

/**
 * \brief               Free and clear the cipher-specific context of ctx.
 *                      Freeing ctx itself remains the responsibility of the
 *                      caller.
 */
void mbedtls_cipher_free(mbedtls_cipher_context_t *ctx);

/**
 * \brief               Initialises and fills the cipher context structure with
 *                      the appropriate values.
 *
 * \note                Currently also clears structure. In future versions you
 *                      will be required to call mbedtls_cipher_init() on the structure
 *                      first.
 *
 * \param ctx           context to initialise. May not be NULL.
 * \param cipher_info   cipher to use.
 *
 * \return              0 on success,
 *                      MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA on parameter failure,
 *                      MBEDTLS_ERR_CIPHER_ALLOC_FAILED if allocation of the
 *                      cipher-specific context failed.
 */
s32 mbedtls_cipher_setup(mbedtls_cipher_context_t *ctx, const mbedtls_cipher_info_t *cipher_info);

/**
 * \brief               Returns the block size of the given cipher.
 *
 * \param ctx           cipher's context. Must have been initialised.
 *
 * \return              size of the cipher's blocks, or 0 if ctx has not been
 *                      initialised.
 */
//#
//static inline u32 mbedtls_cipher_get_block_size( const mbedtls_cipher_context_t *ctx );
//{
//    if( NULL == ctx || NULL == ctx->cipher_info )
//        return 0;
//
//    return ctx->cipher_info->block_size;
//}

#if 0
/**
 * \brief               Returns the mode of operation for the cipher.
 *                      (e.g. MBEDTLS_MODE_CBC)
 *
 * \param ctx           cipher's context. Must have been initialised.
 *
 * \return              mode of operation, or MBEDTLS_MODE_NONE if ctx
 *                      has not been initialised.
 */
static inline mbedtls_cipher_mode_t mbedtls_cipher_get_cipher_mode(const mbedtls_cipher_context_t *ctx)
{
    if (NULL == ctx || NULL == ctx->cipher_info)
        return MBEDTLS_MODE_NONE;

    return ctx->cipher_info->mode;
}

/**
 * \brief               Returns the size of the cipher's IV/NONCE in bytes.
 *
 * \param ctx           cipher's context. Must have been initialised.
 *
 * \return              If IV has not been set yet: (recommended) IV size
 *                      (0 for ciphers not using IV/NONCE).
 *                      If IV has already been set: actual size.
 */
static inline s32 mbedtls_cipher_get_iv_size(const mbedtls_cipher_context_t *ctx)
{
    if (NULL == ctx || NULL == ctx->cipher_info)
        return 0;

    if (ctx->iv_size != 0)
        return (s32) ctx->iv_size;

    return (s32) ctx->cipher_info->iv_size;
}


/**
 * \brief               Returns the type of the given cipher.
 *
 * \param ctx           cipher's context. Must have been initialised.
 *
 * \return              type of the cipher, or MBEDTLS_CIPHER_NONE if ctx has
 *                      not been initialised.
 */
static inline mbedtls_cipher_type_t mbedtls_cipher_get_type(const mbedtls_cipher_context_t *ctx)
{
    if (NULL == ctx || NULL == ctx->cipher_info)
        return MBEDTLS_CIPHER_NONE;

    return ctx->cipher_info->type;
}

/**
 * \brief               Returns the name of the given cipher, as a string.
 *
 * \param ctx           cipher's context. Must have been initialised.
 *
 * \return              name of the cipher, or NULL if ctx was not initialised.
 */
static inline const char *mbedtls_cipher_get_name(const mbedtls_cipher_context_t *ctx)
{
    if (NULL == ctx || NULL == ctx->cipher_info)
        return 0;

    return ctx->cipher_info->name;
}

/**
 * \brief               Returns the key length of the cipher.
 *
 * \param ctx           cipher's context. Must have been initialised.
 *
 * \return              cipher's key length, in bits, or
 *                      MBEDTLS_KEY_LENGTH_NONE if ctx has not been
 *                      initialised.
 */
static inline s32 mbedtls_cipher_get_key_bitlen(const mbedtls_cipher_context_t *ctx)
{
    if (NULL == ctx || NULL == ctx->cipher_info)
        return MBEDTLS_KEY_LENGTH_NONE;

    return (s32) ctx->cipher_info->key_bitlen;
}

/**
 * \brief               Returns the operation of the given cipher.
 *
 * \param ctx           cipher's context. Must have been initialised.
 *
 * \return              operation (MBEDTLS_ENCRYPT or MBEDTLS_DECRYPT),
 *                      or MBEDTLS_OPERATION_NONE if ctx has not been
 *                      initialised.
 */
static inline mbedtls_operation_t mbedtls_cipher_get_operation(const mbedtls_cipher_context_t *ctx)
{
    if (NULL == ctx || NULL == ctx->cipher_info)
        return MBEDTLS_OPERATION_NONE;

    return ctx->operation;
}
#endif

/**
 * \brief               Set the key to use with the given context.
 *
 * \param ctx           generic cipher context. May not be NULL. Must have been
 *                      initialised using cipher_context_from_type or
 *                      cipher_context_from_string.
 * \param key           The key to use.
 * \param key_bitlen    key length to use, in bits.
 * \param operation     Operation that the key will be used for, either
 *                      MBEDTLS_ENCRYPT or MBEDTLS_DECRYPT.
 *
 * \returns             0 on success, MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA if
 *                      parameter verification fails or a cipher specific
 *                      error code.
 */
s32 mbedtls_cipher_setkey(mbedtls_cipher_context_t *ctx, const u8 *key,
                          s32 key_bitlen, const mbedtls_operation_t operation);

#if 0
#if defined(MBEDTLS_CIPHER_MODE_WITH_PADDING)
/**
 * \brief               Set padding mode, for cipher modes that use padding.
 *                      (Default: PKCS7 padding.)
 *
 * \param ctx           generic cipher context
 * \param mode          padding mode
 *
 * \returns             0 on success, MBEDTLS_ERR_CIPHER_FEATURE_UNAVAILABLE
 *                      if selected padding mode is not supported, or
 *                      MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA if the cipher mode
 *                      does not support padding.
 */
s32 mbedtls_cipher_set_padding_mode(mbedtls_cipher_context_t *ctx, mbedtls_cipher_padding_t mode);
#endif /* MBEDTLS_CIPHER_MODE_WITH_PADDING */

/**
 * \brief               Set the initialization vector (IV) or nonce
 *
 * \param ctx           generic cipher context
 * \param iv            IV to use (or NONCE_COUNTER for CTR-mode ciphers)
 * \param iv_len        IV length for ciphers with variable-size IV;
 *                      discarded by ciphers with fixed-size IV.
 *
 * \returns             0 on success, or MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA
 *
 * \note                Some ciphers don't use IVs nor NONCE. For these
 *                      ciphers, this function has no effect.
 */
s32 mbedtls_cipher_set_iv(mbedtls_cipher_context_t *ctx,
                          const u8 *iv, u32 iv_len);

/**
 * \brief               Finish preparation of the given context
 *
 * \param ctx           generic cipher context
 *
 * \returns             0 on success, MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA
 *                      if parameter verification fails.
 */
s32 mbedtls_cipher_reset(mbedtls_cipher_context_t *ctx);

#if defined(MBEDTLS_GCM_C)
/**
 * \brief               Add additional data (for AEAD ciphers).
 *                      Currently only supported with GCM.
 *                      Must be called exactly once, after mbedtls_cipher_reset().
 *
 * \param ctx           generic cipher context
 * \param ad            Additional data to use.
 * \param ad_len        Length of ad.
 *
 * \return              0 on success, or a specific error code.
 */
s32 mbedtls_cipher_update_ad(mbedtls_cipher_context_t *ctx,
                             const u8 *ad, u32 ad_len);
#endif /* MBEDTLS_GCM_C */
#endif

/**
 * \brief               Generic cipher update function. Encrypts/decrypts
 *                      using the given cipher context. Writes as many block
 *                      size'd blocks of data as possible to output. Any data
 *                      that cannot be written immediately will either be added
 *                      to the next block, or flushed when cipher_final is
 *                      called.
 *                      Exception: for MBEDTLS_MODE_ECB, expects single block
 *                                 in size (e.g. 16 bytes for AES)
 *
 * \param ctx           generic cipher context
 * \param input         buffer holding the input data
 * \param ilen          length of the input data
 * \param output        buffer for the output data. Should be able to hold at
 *                      least ilen + block_size. Cannot be the same buffer as
 *                      input!
 * \param olen          length of the output data, will be filled with the
 *                      actual number of bytes written.
 *
 * \returns             0 on success, MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA if
 *                      parameter verification fails,
 *                      MBEDTLS_ERR_CIPHER_FEATURE_UNAVAILABLE on an
 *                      unsupported mode for a cipher or a cipher specific
 *                      error code.
 *
 * \note                If the underlying cipher is GCM, all calls to this
 *                      function, except the last one before mbedtls_cipher_finish(),
 *                      must have ilen a multiple of the block size.
 */
s32 mbedtls_cipher_update(mbedtls_cipher_context_t *ctx, const u8 *input,
                          u32 ilen, u8 *output, u32 *olen);
#if 0
/**
 * \brief               Generic cipher finalisation function. If data still
 *                      needs to be flushed from an incomplete block, data
 *                      contained within it will be padded with the size of
 *                      the last block, and written to the output buffer.
 *
 * \param ctx           Generic cipher context
 * \param output        buffer to write data to. Needs block_size available.
 * \param olen          length of the data written to the output buffer.
 *
 * \returns             0 on success, MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA if
 *                      parameter verification fails,
 *                      MBEDTLS_ERR_CIPHER_FULL_BLOCK_EXPECTED if decryption
 *                      expected a full block but was not provided one,
 *                      MBEDTLS_ERR_CIPHER_INVALID_PADDING on invalid padding
 *                      while decrypting or a cipher specific error code.
 */
s32 mbedtls_cipher_finish(mbedtls_cipher_context_t *ctx,
                          u8 *output, u32 *olen);
#endif

#if 0
#if defined(MBEDTLS_GCM_C)
/**
 * \brief               Write tag for AEAD ciphers.
 *                      Currently only supported with GCM.
 *                      Must be called after mbedtls_cipher_finish().
 *
 * \param ctx           Generic cipher context
 * \param tag           buffer to write the tag
 * \param tag_len       Length of the tag to write
 *
 * \return              0 on success, or a specific error code.
 */
s32 mbedtls_cipher_write_tag(mbedtls_cipher_context_t *ctx,
                             u8 *tag, u32 tag_len);

/**
 * \brief               Check tag for AEAD ciphers.
 *                      Currently only supported with GCM.
 *                      Must be called after mbedtls_cipher_finish().
 *
 * \param ctx           Generic cipher context
 * \param tag           Buffer holding the tag
 * \param tag_len       Length of the tag to check
 *
 * \return              0 on success, or a specific error code.
 */
s32 mbedtls_cipher_check_tag(mbedtls_cipher_context_t *ctx,
                             const u8 *tag, u32 tag_len);
#endif /* MBEDTLS_GCM_C */

/**
 * \brief               Generic all-in-one encryption/decryption
 *                      (for all ciphers except AEAD constructs).
 *
 * \param ctx           generic cipher context
 * \param iv            IV to use (or NONCE_COUNTER for CTR-mode ciphers)
 * \param iv_len        IV length for ciphers with variable-size IV;
 *                      discarded by ciphers with fixed-size IV.
 * \param input         buffer holding the input data
 * \param ilen          length of the input data
 * \param output        buffer for the output data. Should be able to hold at
 *                      least ilen + block_size. Cannot be the same buffer as
 *                      input!
 * \param olen          length of the output data, will be filled with the
 *                      actual number of bytes written.
 *
 * \note                Some ciphers don't use IVs nor NONCE. For these
 *                      ciphers, use iv = NULL and iv_len = 0.
 *
 * \returns             0 on success, or
 *                      MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA, or
 *                      MBEDTLS_ERR_CIPHER_FULL_BLOCK_EXPECTED if decryption
 *                      expected a full block but was not provided one, or
 *                      MBEDTLS_ERR_CIPHER_INVALID_PADDING on invalid padding
 *                      while decrypting, or
 *                      a cipher specific error code.
 */
s32 mbedtls_cipher_crypt(mbedtls_cipher_context_t *ctx,
                         const u8 *iv, u32 iv_len,
                         const u8 *input, u32 ilen,
                         u8 *output, u32 *olen);

#if defined(MBEDTLS_CIPHER_MODE_AEAD)
/**
 * \brief               Generic autenticated encryption (AEAD ciphers).
 *
 * \param ctx           generic cipher context
 * \param iv            IV to use (or NONCE_COUNTER for CTR-mode ciphers)
 * \param iv_len        IV length for ciphers with variable-size IV;
 *                      discarded by ciphers with fixed-size IV.
 * \param ad            Additional data to authenticate.
 * \param ad_len        Length of ad.
 * \param input         buffer holding the input data
 * \param ilen          length of the input data
 * \param output        buffer for the output data.
 *                      Should be able to hold at least ilen.
 * \param olen          length of the output data, will be filled with the
 *                      actual number of bytes written.
 * \param tag           buffer for the authentication tag
 * \param tag_len       desired tag length
 *
 * \returns             0 on success, or
 *                      MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA, or
 *                      a cipher specific error code.
 */
s32 mbedtls_cipher_auth_encrypt(mbedtls_cipher_context_t *ctx,
                                const u8 *iv, u32 iv_len,
                                const u8 *ad, u32 ad_len,
                                const u8 *input, u32 ilen,
                                u8 *output, u32 *olen,
                                u8 *tag, u32 tag_len);

/**
 * \brief               Generic autenticated decryption (AEAD ciphers).
 *
 * \param ctx           generic cipher context
 * \param iv            IV to use (or NONCE_COUNTER for CTR-mode ciphers)
 * \param iv_len        IV length for ciphers with variable-size IV;
 *                      discarded by ciphers with fixed-size IV.
 * \param ad            Additional data to be authenticated.
 * \param ad_len        Length of ad.
 * \param input         buffer holding the input data
 * \param ilen          length of the input data
 * \param output        buffer for the output data.
 *                      Should be able to hold at least ilen.
 * \param olen          length of the output data, will be filled with the
 *                      actual number of bytes written.
 * \param tag           buffer holding the authentication tag
 * \param tag_len       length of the authentication tag
 *
 * \returns             0 on success, or
 *                      MBEDTLS_ERR_CIPHER_BAD_INPUT_DATA, or
 *                      MBEDTLS_ERR_CIPHER_AUTH_FAILED if data isn't authentic,
 *                      or a cipher specific error code.
 *
 * \note                If the data is not authentic, then the output buffer
 *                      is zeroed out to prevent the unauthentic plas32ext to
 *                      be used by mistake, making this s32erface safer.
 */
s32 mbedtls_cipher_auth_decrypt(mbedtls_cipher_context_t *ctx,
                                const u8 *iv, u32 iv_len,
                                const u8 *ad, u32 ad_len,
                                const u8 *input, u32 ilen,
                                u8 *output, u32 *olen,
                                const u8 *tag, u32 tag_len);
#endif /* MBEDTLS_CIPHER_MODE_AEAD */
#endif


/**
 * \brief          Initialize AES context
 *
 * \param ctx      AES context to be initialized
 */
void mbedtls_aes_init(mbedtls_aes_context *ctx);

/**
 * \brief          Clear AES context
 *
 * \param ctx      AES context to be cleared
 */
void mbedtls_aes_free(mbedtls_aes_context *ctx);

/**
 * \brief          AES key schedule (encryption)
 *
 * \param ctx      AES context to be initialized
 * \param key      encryption key
 * \param keybits  must be 128, 192 or 256
 *
 * \return         0 if successful, or MBEDTLS_ERR_AES_INVALID_KEY_LENGTH
 */
s32 mbedtls_aes_setkey_enc(mbedtls_aes_context *ctx, const u8 *key,
                           u32 keybits);

/**
 * \brief          AES key schedule (decryption)
 *
 * \param ctx      AES context to be initialized
 * \param key      decryption key
 * \param keybits  must be 128, 192 or 256
 *
 * \return         0 if successful, or MBEDTLS_ERR_AES_INVALID_KEY_LENGTH
 */
s32 mbedtls_aes_setkey_dec(mbedtls_aes_context *ctx, const u8 *key,
                           u32 keybits);

/**
 * \brief          AES-ECB block encryption/decryption
 *
 * \param ctx      AES context
 * \param mode     MBEDTLS_AES_ENCRYPT or MBEDTLS_AES_DECRYPT
 * \param input    16-byte input block
 * \param output   16-byte output block
 *
 * \return         0 if successful
 */
s32 mbedtls_aes_crypt_ecb(mbedtls_aes_context *ctx,
                          s32 mode,
                          const u8 input[16],
                          u8 output[16]);

/**
 * \brief          AES-CBC buffer encryption/decryption
 *                 Length should be a multiple of the block
 *                 size (16 bytes)
 *
 * \note           Upon exit, the content of the IV is updated so that you can
 *                 call the function same function again on the following
 *                 block(s) of data and get the same result as if it was
 *                 encrypted in one call. This allows a "streaming" usage.
 *                 If on the other hand you need to retain the contents of the
 *                 IV, you should either save it manually or use the cipher
 *                 module instead.
 *
 * \param ctx      AES context
 * \param mode     MBEDTLS_AES_ENCRYPT or MBEDTLS_AES_DECRYPT
 * \param length   length of the input data
 * \param iv       initialization vector (updated after use)
 * \param input    buffer holding the input data
 * \param output   buffer holding the output data
 *
 * \return         0 if successful, or MBEDTLS_ERR_AES_INVALID_INPUT_LENGTH
 */
s32 mbedtls_aes_crypt_cbc(mbedtls_aes_context *ctx,
                          s32 mode,
                          u32 length,
                          u8 iv[16],
                          const u8 *input,
                          u8 *output);

/**
 * \brief          AES-CFB128 buffer encryption/decryption.
 *
 * Note: Due to the nature of CFB you should use the same key schedule for
 * both encryption and decryption. So a context initialized with
 * mbedtls_aes_setkey_enc() for both MBEDTLS_AES_ENCRYPT and MBEDTLS_AES_DECRYPT.
 *
 * \note           Upon exit, the content of the IV is updated so that you can
 *                 call the function same function again on the following
 *                 block(s) of data and get the same result as if it was
 *                 encrypted in one call. This allows a "streaming" usage.
 *                 If on the other hand you need to retain the contents of the
 *                 IV, you should either save it manually or use the cipher
 *                 module instead.
 *
 * \param ctx      AES context
 * \param mode     MBEDTLS_AES_ENCRYPT or MBEDTLS_AES_DECRYPT
 * \param length   length of the input data
 * \param iv_off   offset in IV (updated after use)
 * \param iv       initialization vector (updated after use)
 * \param input    buffer holding the input data
 * \param output   buffer holding the output data
 *
 * \return         0 if successful
 */
s32 mbedtls_aes_crypt_cfb128(mbedtls_aes_context *ctx,
                             s32 mode,
                             size_t length,
                             size_t *iv_off,
                             u8 iv[16],
                             const u8 *input,
                             u8 *output);

/**
 * \brief          AES-CFB8 buffer encryption/decryption.
 *
 * Note: Due to the nature of CFB you should use the same key schedule for
 * both encryption and decryption. So a context initialized with
 * mbedtls_aes_setkey_enc() for both MBEDTLS_AES_ENCRYPT and MBEDTLS_AES_DECRYPT.
 *
 * \note           Upon exit, the content of the IV is updated so that you can
 *                 call the function same function again on the following
 *                 block(s) of data and get the same result as if it was
 *                 encrypted in one call. This allows a "streaming" usage.
 *                 If on the other hand you need to retain the contents of the
 *                 IV, you should either save it manually or use the cipher
 *                 module instead.
 *
 * \param ctx      AES context
 * \param mode     MBEDTLS_AES_ENCRYPT or MBEDTLS_AES_DECRYPT
 * \param length   length of the input data
 * \param iv       initialization vector (updated after use)
 * \param input    buffer holding the input data
 * \param output   buffer holding the output data
 *
 * \return         0 if successful
 */
#if 0
s32 mbedtls_aes_crypt_cfb8(mbedtls_aes_context *ctx,
                           s32 mode,
                           u32 length,
                           u8 iv[16],
                           const u8 *input,
                           u8 *output);
#endif
/**
 * \brief          AES-OFB128 buffer encryption/decryption.
 *
 * Note: Due to the nature of OFB you should use the same key schedule for
 * both encryption and decryption. So a context initialized with
 * mbedtls_aes_setkey_enc() for both MBEDTLS_AES_ENCRYPT and MBEDTLS_AES_DECRYPT.
 *
 * \note           Upon exit, the content of the IV is updated so that you can
 *                 call the function same function again on the following
 *                 block(s) of data and get the same result as if it was
 *                 encrypted in one call. This allows a "streaming" usage.
 *                 If on the other hand you need to retain the contents of the
 *                 IV, you should either save it manually or use the cipher
 *                 module instead.
 *
 * \param ctx      AES context
 * \param length   length of the input data
 * \param iv_off   offset in IV (updated after use)
 * \param iv       initialization vector (updated after use)
 * \param input    buffer holding the input data
 * \param output   buffer holding the output data
 *
 * \return         0 if successful
 */
s32 mbedtls_aes_crypt_ofb128(mbedtls_aes_context *ctx,
                             u32 length,
                             size_t *iv_off,
                             u8 iv[16],
                             const u8 *input,
                             u8 *output);

/**
 * \brief               AES-CTR buffer encryption/decryption
 *
 * Warning: You have to keep the maximum use of your counter in mind!
 *
 * Note: Due to the nature of CTR you should use the same key schedule for
 * both encryption and decryption. So a context initialized with
 * mbedtls_aes_setkey_enc() for both MBEDTLS_AES_ENCRYPT and MBEDTLS_AES_DECRYPT.
 *
 * \param ctx           AES context
 * \param length        The length of the data
 * \param nc_off        The offset in the current stream_block (for resuming
 *                      within current cipher stream). The offset pos32er to
 *                      should be 0 at the start of a stream.
 * \param nonce_counter The 128-bit nonce and counter.
 * \param stream_block  The saved stream-block for resuming. Is overwritten
 *                      by the function.
 * \param input         The input data stream
 * \param output        The output data stream
 *
 * \return         0 if successful
 */
s32 mbedtls_aes_crypt_ctr(mbedtls_aes_context *ctx,
                          size_t length,
                          size_t *nc_off,
                          u8 nonce_counter[16],
                          u8 stream_block[16],
                          const u8 *input,
                          u8 *output);

/**
 * \brief           Internal AES block encryption function
 *                  (Only exposed to allow overriding it,
 *                  see MBEDTLS_AES_ENCRYPT_ALT)
 *
 * \param ctx       AES context
 * \param input     Plas32ext block
 * \param output    Output (ciphertext) block
 *
 * \return          0 if successful
 */
#if 0
s32 mbedtls_internal_aes_encrypt(mbedtls_aes_context *ctx,
                                 const u8 input[16],
                                 u8 output[16]);
#endif
/**
 * \brief           Internal AES block decryption function
 *                  (Only exposed to allow overriding it,
 *                  see MBEDTLS_AES_DECRYPT_ALT)
 *
 * \param ctx       AES context
 * \param input     Ciphertext block
 * \param output    Output (plas32ext) block
 *
 * \return          0 if successful
 */
#if 0
s32 mbedtls_internal_aes_decrypt(mbedtls_aes_context *ctx,
                                 const u8 input[16],
                                 u8 output[16]);
#endif
/**
 * \brief           Internal AES block encryption function
 *                  (Only exposed to allow overriding it,
 *                  see MBEDTLS_AES_ENCRYPT_ALT)
 *
 * \deprecated      Superseded by mbedtls_aes_encrypt_ext() in 2.5.0
 *
 * \param ctx       AES context
 * \param input     Plas32ext block
 * \param output    Output (ciphertext) block
 */
#if 0
static inline void mbedtls_aes_encrypt(
    mbedtls_aes_context *ctx,
    const u8 input[16],
    u8 output[16])
{
    mbedtls_internal_aes_encrypt(ctx, input, output);
}
#endif
/**
 * \brief           Internal AES block decryption function
 *                  (Only exposed to allow overriding it,
 *                  see MBEDTLS_AES_DECRYPT_ALT)
 *
 * \deprecated      Superseded by mbedtls_aes_decrypt_ext() in 2.5.0
 *
 * \param ctx       AES context
 * \param input     Ciphertext block
 * \param output    Output (plas32ext) block
 */
#if 0
static inline void mbedtls_aes_decrypt(
    mbedtls_aes_context *ctx,
    const u8 input[16],
    u8 output[16])
{
    mbedtls_internal_aes_decrypt(ctx, input, output);
}
#endif
/**
 * \brief          Checkup routine
 *
 * \return         0 if successful, or 1 if the test failed
 */
#if 0
s32 mbedtls_aes_self_test(s32 verbose);
#endif

/* ------------------------------ GCM ------------------------------ */

/**
 * \brief           Initialize GCM context (just makes references valid)
 *                  Makes the context ready for mbedtls_gcm_setkey() or
 *                  mbedtls_gcm_free().
 *
 * \param ctx       GCM context to initialize
 */
void mbedtls_gcm_init(mbedtls_gcm_context *ctx);

/**
 * \brief           GCM initialization (encryption)
 *
 * \param ctx       GCM context to be initialized
 * \param cipher    cipher to use (a 128-bit block cipher)
 * \param key       encryption key
 * \param keybits   must be 128, 192 or 256
 *
 * \return          0 if successful, or a cipher specific error code
 */
s32 mbedtls_gcm_setkey(mbedtls_gcm_context *ctx,
                       mbedtls_cipher_id_t cipher,
                       const u8 *key,
                       u32 keybits);

/**
 * \brief           GCM buffer encryption/decryption using a block cipher
 *
 * \note On encryption, the output buffer can be the same as the input buffer.
 *       On decryption, the output buffer cannot be the same as input buffer.
 *       If buffers overlap, the output buffer must trail at least 8 bytes
 *       behind the input buffer.
 *
 * \param ctx       GCM context
 * \param mode      MBEDTLS_GCM_ENCRYPT or MBEDTLS_GCM_DECRYPT
 * \param length    length of the input data
 * \param iv        initialization vector
 * \param iv_len    length of IV
 * \param add       additional data
 * \param add_len   length of additional data
 * \param input     buffer holding the input data
 * \param output    buffer for holding the output data
 * \param tag_len   length of the tag to generate
 * \param tag       buffer for holding the tag
 *
 * \return         0 if successful
 */
s32 mbedtls_gcm_crypt_and_tag(mbedtls_gcm_context *ctx,
                              s32 mode,
                              u32 length,
                              const u8 *iv,
                              u32 iv_len,
                              const u8 *add,
                              u32 add_len,
                              const u8 *input,
                              u8 *output,
                              u32 tag_len,
                              u8 *tag);
#if 0
/**
 * \brief           GCM buffer authenticated decryption using a block cipher
 *
 * \note On decryption, the output buffer cannot be the same as input buffer.
 *       If buffers overlap, the output buffer must trail at least 8 bytes
 *       behind the input buffer.
 *
 * \param ctx       GCM context
 * \param length    length of the input data
 * \param iv        initialization vector
 * \param iv_len    length of IV
 * \param add       additional data
 * \param add_len   length of additional data
 * \param tag       buffer holding the tag
 * \param tag_len   length of the tag
 * \param input     buffer holding the input data
 * \param output    buffer for holding the output data
 *
 * \return         0 if successful and authenticated,
 *                 MBEDTLS_ERR_GCM_AUTH_FAILED if tag does not match
 */
s32 mbedtls_gcm_auth_decrypt(mbedtls_gcm_context *ctx,
                             u32 length,
                             const u8 *iv,
                             u32 iv_len,
                             const u8 *add,
                             u32 add_len,
                             const u8 *tag,
                             u32 tag_len,
                             const u8 *input,
                             u8 *output);
#endif

/**
 * \brief           Generic GCM stream start function
 *
 * \param ctx       GCM context
 * \param mode      MBEDTLS_GCM_ENCRYPT or MBEDTLS_GCM_DECRYPT
 * \param iv        initialization vector
 * \param iv_len    length of IV
 * \param add       additional data (or NULL if length is 0)
 * \param add_len   length of additional data
 *
 * \return         0 if successful
 */
s32 mbedtls_gcm_starts(mbedtls_gcm_context *ctx,
                       s32 mode,
                       const u8 *iv,
                       u32 iv_len,
                       const u8 *add,
                       u32 add_len);

/**
 * \brief           Generic GCM update function. Encrypts/decrypts using the
 *                  given GCM context. Expects input to be a multiple of 16
 *                  bytes! Only the last call before mbedtls_gcm_finish() can be less
 *                  than 16 bytes!
 *
 * \note On decryption, the output buffer cannot be the same as input buffer.
 *       If buffers overlap, the output buffer must trail at least 8 bytes
 *       behind the input buffer.
 *
 * \param ctx       GCM context
 * \param length    length of the input data
 * \param input     buffer holding the input data
 * \param output    buffer for holding the output data
 *
 * \return         0 if successful or MBEDTLS_ERR_GCM_BAD_INPUT
 */
s32 mbedtls_gcm_update(mbedtls_gcm_context *ctx,
                       u32 length,
                       const u8 *input,
                       u8 *output);

/**
 * \brief           Generic GCM finalisation function. Wraps up the GCM stream
 *                  and generates the tag. The tag can have a maximum length of
 *                  16 bytes.
 *
 * \param ctx       GCM context
 * \param tag       buffer for holding the tag
 * \param tag_len   length of the tag to generate (must be at least 4)
 *
 * \return          0 if successful or MBEDTLS_ERR_GCM_BAD_INPUT
 */
s32 mbedtls_gcm_finish(mbedtls_gcm_context *ctx,
                       u8 *tag,
                       u32 tag_len);

/**
 * \brief           Free a GCM context and underlying cipher sub-context
 *
 * \param ctx       GCM context to free
 */
void mbedtls_gcm_free(mbedtls_gcm_context *ctx);

#if 0
/**
 * \brief          Checkup routine
 *
 * \return         0 if successful, or 1 if the test failed
 */
s32 mbedtls_gcm_self_test(s32 verbose);
#endif

s32 aes_ghash_swvrf(const u8 *key, u32 key_len, const u8 *plain, u32 plain_len, u8 *tag);
s32 aes_gctr_swvrf(const u8 *key, u32 key_len, const u8 *iv, const u8 *plain, u32 plain_len, u8 *crypt);
s32 aes_gmac_swvrf(const u8 *key, u32 key_len, const u8 *iv, const u8 *plain, u32 plain_len,
                   const u8 *aad, u32 aad_len, u8 *tag);

s32 rtl_crypto_cipher_swvrf(const u32 cipher_type,
                            const u8 *pKey, const s32 keylen, const u8 *pIv, const s32 ivLen, const s32 init_count,
                            const u8 *pAAD, const s32 aadLen, const u8 *pText, const s32 textlen,
                            u8 *pResult, u8 *pTag);

#define const_Bsize 16

void aes_cmac(u8 *in, u32 length, u8 *out, u8 *key);

#endif // _SYSCOMM_CRYPTO_CIPHER_H_