


/* mbed TLS headers */
#include <mbedtls/memory_buffer_alloc.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>

//#include "mbedtls/rsa.h"
#include "mbedtls/pk.h"

#include <asm/mipsregs.h>

#define  CAUSEB_DC              27
#define  CAUSEF_DC              (_ULCAST_(1)   << 27)



/*
 * mbed TLS heap
 */
#if (MBEDTLS_KEY_ALG_ID == MBEDTLS_ECDSA)
#ifdef MBEDTLS_ECP_DP_SECP256R1_ENABLED
#define MBEDTLS_HEAP_SIZE		(14*1024)
#define MBEDTLS_ECDSA_LENGTH	256
#endif
#ifdef MBEDTLS_ECP_DP_SECP384R1_ENABLED
#define MBEDTLS_HEAP_SIZE		(28*1024)
#define MBEDTLS_ECDSA_LENGTH	384
#endif
#ifdef MBEDTLS_ECP_DP_SECP521R1_ENABLED
#define MBEDTLS_HEAP_SIZE		(38*1024)
#define MBEDTLS_ECDSA_LENGTH	521
#endif
#elif (MBEDTLS_KEY_ALG_ID == MBEDTLS_RSA)
#if (MBEDTLS_RSA_LENGTH!=512)
#define MBEDTLS_HEAP_SIZE		(8*1024) //for 2048, 3072 is good
#else
#define MBEDTLS_HEAP_SIZE		(16*1024)
#endif
#endif
static unsigned char heap[MBEDTLS_HEAP_SIZE];


/*
 * mbed TLS initialization function
 */
void mbedtls_init(void)
{
        static int ready;

        if (!ready)
        {
                /* Initialize the mbed TLS heap */
                mbedtls_memory_buffer_alloc_init(heap, MBEDTLS_HEAP_SIZE);
                ready = 1;
        }
}


	mbedtls_pk_context pk;

	const mbedtls_md_info_t *md_info;

char sha_256_input[131072];
	
int rtl_mbedtls_test(int argc, char *argv[])
{
	int ret = 0;
#if (MBEDTLS_KEY_ALG_ID == MBEDTLS_ECDSA)
#ifdef MBEDTLS_ECP_DP_SECP256R1_ENABLED   //256bit ecdsa
unsigned char public_der[] = {
  0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
  0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
  0x42, 0x00, 0x04, 0x0e, 0x91, 0xe8, 0xf1, 0xa9, 0xd7, 0x76, 0xf3, 0x53,
  0x6b, 0x4c, 0x82, 0xc2, 0xa6, 0xb8, 0x6a, 0x41, 0xb0, 0x94, 0x6c, 0xc2,
  0xa9, 0x0f, 0xbf, 0x2a, 0x42, 0x77, 0xf1, 0x94, 0x56, 0x80, 0x60, 0xfc,
  0x8d, 0x16, 0xfc, 0x1f, 0x8a, 0x58, 0xfc, 0xca, 0x2e, 0x61, 0xef, 0xf4,
  0x2d, 0xc4, 0x9f, 0xdc, 0x8c, 0x97, 0x45, 0xdb, 0xf4, 0xcc, 0x29, 0x43,
  0xe7, 0x25, 0x50, 0x2e, 0xbb, 0x1d, 0x76
};
unsigned int public_der_len = 121;

unsigned char signature_bin[] = {
  0x30, 0x45, 0x02, 0x21, 0x00, 0xc4, 0x88, 0xd9, 0x4d, 0x0f, 0x12, 0x71,
  0x89, 0x7c, 0x1d, 0xec, 0xb9, 0x20, 0xd8, 0xb7, 0x42, 0x62, 0xb2, 0xc5,
  0x6b, 0xc3, 0xd6, 0x8d, 0x84, 0x22, 0xc5, 0x9e, 0x8f, 0xbb, 0x16, 0xf7,
  0xe1, 0x02, 0x20, 0x0c, 0x6b, 0xd8, 0xd1, 0x4e, 0x28, 0xa1, 0x76, 0xa8,
  0x92, 0xff, 0xf5, 0x40, 0xda, 0x3d, 0xc7, 0xae, 0x46, 0x6f, 0xde, 0x54,
  0xa8, 0x5c, 0x36, 0x9e, 0x84, 0xec, 0x11, 0x1d, 0x93, 0x15, 0xbc
};
unsigned int signature_bin_len = 71;
#endif
#ifdef MBEDTLS_ECP_DP_SECP384R1_ENABLED  //ecdsa384
unsigned char public_der[] = {
  0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
  0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
  0xef, 0xaf, 0x81, 0xc0, 0xe8, 0xb9, 0x38, 0xa7, 0x99, 0xa4, 0x70, 0x53,
  0xf3, 0xa3, 0x84, 0xc8, 0x26, 0x5d, 0xfd, 0x18, 0x90, 0x69, 0x7d, 0xab,
  0x57, 0x4c, 0x59, 0x78, 0x1e, 0x87, 0x86, 0xee, 0xd0, 0xfe, 0xa7, 0x65,
  0xfb, 0xf4, 0xaa, 0x16, 0x49, 0x8a, 0xca, 0x87, 0xfc, 0x4b, 0xf0, 0x17,
  0x98, 0xdf, 0x2f, 0x6c, 0x7f, 0x4d, 0x06, 0x4f, 0x7b, 0xb1, 0x7e, 0x9f,
  0x53, 0x8a, 0x38, 0x1b, 0xac, 0xc9, 0xe6, 0x05, 0x13, 0xea, 0x6f, 0x3f,
  0x42, 0x9e, 0xc3, 0xbb, 0x39, 0xe0, 0x5a, 0x8b, 0xca, 0x69, 0xee, 0xc8,
  0xda, 0xa7, 0x19, 0x87, 0x2a, 0x9e, 0x36, 0xb2, 0xde, 0xad, 0xf5, 0x3c
};
unsigned int public_der_len = 120;

unsigned char signature_bin[] = {
  0x30, 0x64, 0x02, 0x30, 0x52, 0xd7, 0x8b, 0x34, 0x87, 0xc0, 0x99, 0x43,
  0x32, 0x99, 0x98, 0xce, 0xcd, 0x5e, 0xf7, 0x6f, 0xe4, 0xd8, 0xc3, 0xa5,
  0x53, 0xb1, 0x84, 0xa5, 0x05, 0x3d, 0x47, 0x62, 0xee, 0x89, 0x97, 0x37,
  0xfa, 0x03, 0xcb, 0xda, 0xc1, 0xbc, 0x0f, 0xdb, 0xaf, 0x4b, 0xd6, 0x7a,
  0x92, 0x1a, 0x3c, 0xcb, 0x02, 0x30, 0x6a, 0x58, 0x71, 0x7d, 0xaa, 0x2a,
  0x0b, 0x84, 0xc3, 0x6e, 0x7f, 0x38, 0x7b, 0xa1, 0x58, 0x4f, 0x99, 0x39,
  0xb2, 0x51, 0x01, 0x53, 0x9f, 0xd5, 0xd4, 0xeb, 0x05, 0x2a, 0x81, 0xe8,
  0x96, 0x71, 0x42, 0x8d, 0x12, 0xa1, 0x26, 0xd5, 0x4d, 0x6d, 0xb6, 0x6b,
  0x3a, 0x3f, 0x59, 0x92, 0xdd, 0xef
};
unsigned int signature_bin_len = 102;
#endif

#ifdef MBEDTLS_ECP_DP_SECP521R1_ENABLED  //ecdsa 521
unsigned char public_der[] = {
  0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
  0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
  0x00, 0x04, 0x00, 0xa0, 0x71, 0xd7, 0x47, 0xab, 0xa4, 0xa2, 0x43, 0xb0,
  0xd0, 0x4c, 0x56, 0x6a, 0x80, 0x99, 0x0e, 0x2b, 0x9c, 0x44, 0xa9, 0xb6,
  0xc8, 0xbe, 0x6f, 0x91, 0x91, 0x89, 0xcf, 0xa2, 0x1c, 0xad, 0x85, 0x83,
  0x19, 0x64, 0xc1, 0x59, 0x12, 0x95, 0x4a, 0x37, 0x42, 0xfb, 0xed, 0x00,
  0x4e, 0xe0, 0x09, 0x84, 0x5e, 0xc9, 0x13, 0x3e, 0x9c, 0xd3, 0xd3, 0x5e,
  0x9b, 0xcd, 0xcd, 0xa8, 0xb3, 0xc5, 0xaf, 0xb9, 0x00, 0xb9, 0x37, 0xfd,
  0x24, 0x91, 0x03, 0xbc, 0xb7, 0xab, 0xab, 0xa3, 0x2f, 0x71, 0x54, 0xbd,
  0x76, 0xad, 0xa6, 0xfc, 0xe1, 0x34, 0x8c, 0xb1, 0x55, 0x44, 0x80, 0x1f,
  0x7a, 0x02, 0x72, 0x00, 0x75, 0xde, 0xc1, 0xdf, 0x00, 0x67, 0x48, 0x31,
  0x77, 0x13, 0xf9, 0xe6, 0x63, 0xd7, 0x17, 0x93, 0xe5, 0xd2, 0x12, 0x3f,
  0xed, 0xe0, 0x82, 0x63, 0x6d, 0x09, 0x98, 0xa0, 0x7c, 0x99, 0x5c, 0xba,
  0x9c, 0x60
};
unsigned int public_der_len = 158;
unsigned char signature_bin[] = {
  0x30, 0x81, 0x87, 0x02, 0x41, 0x76, 0xbd, 0x9e, 0x23, 0x36, 0xae, 0x4c,
  0x6c, 0x3c, 0x00, 0x50, 0x6d, 0xba, 0xc7, 0x4a, 0x44, 0xf1, 0xcf, 0x1a,
  0x89, 0x07, 0x6b, 0xe3, 0x92, 0x8d, 0x12, 0x0d, 0xb5, 0x50, 0xcb, 0x4f,
  0xe5, 0x09, 0xf4, 0xcd, 0x83, 0x34, 0xd6, 0x6c, 0x72, 0x71, 0xfe, 0x61,
  0x7e, 0xcf, 0xb3, 0x4c, 0x4d, 0xde, 0x88, 0x86, 0x91, 0x3d, 0xb4, 0x2c,
  0x0e, 0xf3, 0x36, 0x8c, 0x93, 0xca, 0xce, 0x35, 0xff, 0xf2, 0x02, 0x42,
  0x01, 0xb2, 0x93, 0xbe, 0x7c, 0x77, 0x40, 0x02, 0x05, 0x70, 0x47, 0xfa,
  0xd3, 0xaf, 0xf5, 0x38, 0xc6, 0x4d, 0xee, 0x0d, 0xb3, 0xf1, 0x82, 0x38,
  0x64, 0x90, 0xa3, 0xb2, 0x0f, 0x4f, 0x5a, 0xda, 0x5f, 0x0b, 0x74, 0x02,
  0xd5, 0x2c, 0x22, 0xdd, 0xe2, 0xea, 0x4b, 0x31, 0x5f, 0xbc, 0x71, 0x1e,
  0xf0, 0xe7, 0x53, 0x3d, 0x7f, 0x5d, 0x0c, 0xd9, 0xc2, 0x53, 0xd7, 0xf3,
  0x88, 0xd1, 0xb8, 0x81, 0x73, 0xc1
};
unsigned int signature_bin_len = 138;

#endif

#else
#if (MBEDTLS_RSA_LENGTH == 256)
unsigned char public_der[] = {
	0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
	0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00,
	0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xca, 0xda, 0x2d,
	0x11, 0x1f, 0xb5, 0xcd, 0x23, 0xcd, 0x75, 0x62, 0x10, 0xf4, 0x09, 0xba,
	0x85, 0xd1, 0x0d, 0x52, 0x33, 0x6b, 0xbd, 0x88, 0x6f, 0xf4, 0x48, 0xe5,
	0x4f, 0x5e, 0x18, 0x52, 0xc6, 0x6d, 0xb3, 0xf1, 0xc2, 0xa0, 0x68, 0x63,
	0x6d, 0x4b, 0xcd, 0x39, 0xcc, 0xe8, 0xe7, 0x18, 0x09, 0x40, 0x70, 0xea,
	0xf4, 0x33, 0xf6, 0x8f, 0xd7, 0x40, 0xad, 0x1b, 0x66, 0x44, 0x99, 0x80,
	0xb5, 0x14, 0x53, 0xa5, 0x44, 0xe6, 0xeb, 0xee, 0x9a, 0x38, 0xae, 0xbc,
	0xe7, 0x4a, 0x01, 0x82, 0xad, 0xaa, 0x35, 0xbb, 0x19, 0x4b, 0xc3, 0x05,
	0xc2, 0x71, 0x47, 0x6f, 0xcc, 0xeb, 0x2e, 0x2a, 0x99, 0x04, 0xcb, 0xc7,
	0xa1, 0x37, 0x2d, 0x92, 0x0e, 0xfc, 0xca, 0xe3, 0x88, 0x1a, 0xc0, 0x17,
	0x53, 0xc2, 0xb6, 0x75, 0xfc, 0x16, 0x78, 0x01, 0x51, 0xdd, 0xb3, 0xa5,
	0x75, 0xe9, 0x8e, 0x30, 0xd1, 0x4f, 0x35, 0x97, 0xa2, 0xb4, 0x7c, 0x32,
	0x38, 0x56, 0x2a, 0xf5, 0x58, 0x69, 0xce, 0xad, 0x09, 0x96, 0xaa, 0x59,
	0x35, 0x9f, 0x1f, 0x8a, 0xec, 0x23, 0x7b, 0x24, 0x03, 0xf7, 0x11, 0xf4,
	0x81, 0x8f, 0xfc, 0x97, 0x44, 0xe1, 0x56, 0x13, 0xd3, 0x9d, 0xfa, 0x29,
	0xb0, 0x47, 0x6d, 0xbe, 0x19, 0x51, 0x55, 0xd6, 0x2b, 0x60, 0x1d, 0x1c,
	0xa2, 0xc0, 0xc7, 0x74, 0xcc, 0x7f, 0xfe, 0x2b, 0x8c, 0x6d, 0x73, 0x54,
	0x9a, 0xa1, 0x4c, 0xca, 0x86, 0x8d, 0x61, 0x12, 0xe2, 0x9c, 0xcf, 0x63,
	0x41, 0xf5, 0x20, 0x4f, 0xa6, 0xd1, 0x84, 0x5e, 0x2f, 0x25, 0x83, 0x18,
	0x37, 0xde, 0x73, 0x0a, 0xd8, 0xe5, 0x16, 0x40, 0x56, 0x75, 0x16, 0x51,
	0x0d, 0x69, 0xd8, 0xab, 0x18, 0x5d, 0x28, 0x1a, 0x59, 0x71, 0x39, 0x9f,
	0xc9, 0x06, 0x8c, 0x9f, 0x48, 0x6a, 0x90, 0xd5, 0xac, 0xa0, 0x21, 0x52,
	0xcd, 0x02, 0x03, 0x01, 0x00, 0x01
};
unsigned int public_der_len = 294;

unsigned char signature_bin[] = {
  0x00, 0xf9, 0x42, 0xde, 0xaf, 0xa9, 0x3e, 0x28, 0xf9, 0x1f, 0xa2, 0x3d,
  0x51, 0x69, 0x98, 0xad, 0x49, 0x22, 0xc1, 0x31, 0x1c, 0x65, 0x09, 0xdd,
  0x8c, 0x43, 0xf2, 0x9d, 0xff, 0xeb, 0xbd, 0x34, 0xb6, 0x74, 0xe7, 0xc5,
  0x47, 0x1b, 0x74, 0x35, 0x1e, 0xa2, 0x8f, 0x2c, 0x3d, 0xed, 0x95, 0xda,
  0x21, 0x4b, 0x76, 0x09, 0xaf, 0x11, 0xa8, 0xbd, 0x31, 0xcb, 0x04, 0x64,
  0x02, 0x29, 0x33, 0x72, 0x72, 0xcf, 0xd6, 0x81, 0x3e, 0xf7, 0x00, 0x98,
  0x7d, 0x82, 0xe6, 0xa7, 0xeb, 0x6b, 0xfb, 0x48, 0x1a, 0x38, 0x05, 0xab,
  0xc7, 0xcc, 0x0f, 0xff, 0x01, 0xe1, 0x1a, 0x80, 0x96, 0x78, 0xdc, 0xf8,
  0x4d, 0xe4, 0xad, 0x54, 0xfe, 0xa7, 0xfe, 0xba, 0x19, 0xe0, 0xa3, 0x13,
  0xe0, 0x5c, 0x3b, 0xf9, 0xbc, 0x15, 0x15, 0x96, 0xe0, 0x35, 0x77, 0xb6,
  0x87, 0x65, 0x3b, 0x05, 0xc8, 0xc8, 0x98, 0x6b, 0x5e, 0x32, 0x22, 0x1a,
  0xac, 0x8b, 0x2a, 0x16, 0x66, 0x88, 0x0f, 0x57, 0xf5, 0x50, 0x5e, 0xeb,
  0xc8, 0xcd, 0xf7, 0x47, 0x1c, 0x16, 0xa6, 0x4e, 0x90, 0x7d, 0x51, 0x4f,
  0x8b, 0xb3, 0x26, 0x4d, 0xaf, 0x7f, 0x21, 0x9e, 0x02, 0x4d, 0x33, 0xe3,
  0xbc, 0xf2, 0x68, 0xa0, 0x3e, 0x69, 0x01, 0x16, 0x12, 0x63, 0xde, 0x8b,
  0x62, 0x0b, 0x13, 0xa7, 0x29, 0x3a, 0xfb, 0x6e, 0x91, 0x71, 0x40, 0xba,
  0xf7, 0xa2, 0xdd, 0xbf, 0x78, 0x90, 0xbf, 0xc9, 0xfd, 0x7b, 0x7a, 0x75,
  0x02, 0xbe, 0x03, 0xa4, 0x59, 0xef, 0xdb, 0xfd, 0x6d, 0xfe, 0x19, 0xf7,
  0xcd, 0xb3, 0x81, 0x9f, 0xa6, 0xd4, 0x91, 0xec, 0x62, 0x99, 0x5f, 0x01,
  0x87, 0x5e, 0x9b, 0x0d, 0xd9, 0x5f, 0xcb, 0x8a, 0x1c, 0xf6, 0x86, 0x01,
  0x12, 0x7e, 0x31, 0xe2, 0xab, 0x12, 0x1a, 0x8f, 0x6f, 0xa2, 0x8d, 0xdc,
  0x50, 0x68, 0xfc, 0x07
};
unsigned int signature_bin_len = 256;

#elif (MBEDTLS_RSA_LENGTH == 384)

	unsigned char public_der[] = {
  0x30, 0x82, 0x01, 0xa2, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
  0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x8f, 0x00,
  0x30, 0x82, 0x01, 0x8a, 0x02, 0x82, 0x01, 0x81, 0x00, 0xc6, 0x3a, 0xbb,
  0x58, 0x9a, 0xed, 0x61, 0x9b, 0x22, 0x96, 0x36, 0x81, 0xac, 0x2d, 0x9d,
  0x18, 0xf4, 0x53, 0x59, 0x18, 0x6c, 0x01, 0xd5, 0x4c, 0x01, 0x79, 0x8a,
  0x5a, 0xba, 0xa2, 0x3c, 0x0d, 0x3f, 0xdc, 0x4b, 0xde, 0x70, 0x20, 0x75,
  0x0c, 0x7b, 0xdc, 0x59, 0xde, 0x2a, 0xa8, 0x7c, 0xf0, 0x16, 0x79, 0x9c,
  0x46, 0xf0, 0x8b, 0x4f, 0xa7, 0xea, 0xd4, 0xfb, 0x12, 0x71, 0x94, 0xe0,
  0x42, 0x80, 0x08, 0x46, 0xd4, 0x75, 0xe4, 0x78, 0x63, 0x20, 0x8d, 0xcf,
  0xf2, 0x8d, 0xa1, 0x4f, 0xda, 0xbd, 0x37, 0x2f, 0x5a, 0x52, 0x26, 0xf2,
  0x24, 0x40, 0x05, 0xc1, 0x26, 0x71, 0xf8, 0x8b, 0x5d, 0xb6, 0x40, 0x1d,
  0x09, 0xd6, 0x6a, 0x55, 0x9d, 0xa2, 0x09, 0xcd, 0x5e, 0x1f, 0xf8, 0x61,
  0x94, 0xc0, 0x9a, 0x4c, 0x61, 0xf3, 0x0b, 0x50, 0x9c, 0xc9, 0xb4, 0x78,
  0x21, 0x96, 0xa7, 0x67, 0x6c, 0x91, 0xec, 0xbe, 0x14, 0x9e, 0x52, 0x0a,
  0xdf, 0xd3, 0xe1, 0xe6, 0x08, 0x6f, 0x9e, 0x56, 0x88, 0x2f, 0x1b, 0x9b,
  0x2f, 0xe8, 0x44, 0xe2, 0xbd, 0x3d, 0x19, 0x65, 0xc4, 0xa2, 0x18, 0x5b,
  0x9f, 0x09, 0x84, 0xc0, 0x6f, 0x36, 0xd8, 0x75, 0xe3, 0x5e, 0xa8, 0xa9,
  0x12, 0x1a, 0x3e, 0xa8, 0xa0, 0x94, 0x69, 0x34, 0x86, 0x17, 0xe7, 0x8c,
  0x2a, 0x32, 0x7a, 0x8a, 0xab, 0x87, 0xa2, 0xa9, 0x26, 0xcf, 0x4b, 0x7b,
  0xf6, 0xca, 0x8e, 0xa6, 0xc5, 0x5f, 0xf6, 0xf0, 0xf1, 0xce, 0x10, 0x19,
  0xed, 0x52, 0xe8, 0xdc, 0xff, 0xda, 0x57, 0xe1, 0x2e, 0x7b, 0x95, 0x33,
  0x19, 0xd3, 0xc2, 0x60, 0xed, 0x8e, 0x99, 0xbd, 0x34, 0xca, 0x6b, 0xa8,
  0xf3, 0xd6, 0xb9, 0x8b, 0x9e, 0x4b, 0x90, 0x7e, 0x9d, 0xb7, 0x6f, 0xce,
  0xa0, 0x3b, 0x40, 0xb9, 0x71, 0x0f, 0xf8, 0x65, 0xd2, 0x3d, 0xf2, 0x10,
  0x61, 0x2c, 0xca, 0x9a, 0xea, 0x9a, 0xd5, 0x62, 0x06, 0xdf, 0xf2, 0x96,
  0x71, 0x4b, 0x3b, 0x58, 0x56, 0xb9, 0x3f, 0x2e, 0x06, 0xdd, 0xba, 0x40,
  0xdb, 0x88, 0x55, 0x53, 0x6b, 0x84, 0xa9, 0xe7, 0xbf, 0xfc, 0xa7, 0x3e,
  0x1d, 0x43, 0x82, 0x0a, 0x84, 0xf3, 0xc0, 0x45, 0x59, 0xbe, 0xc1, 0x3c,
  0xde, 0x4d, 0x53, 0xd5, 0xba, 0xf7, 0xcc, 0xd0, 0x98, 0x35, 0x05, 0x17,
  0xce, 0xcb, 0xf1, 0x11, 0x60, 0xd8, 0x09, 0xaf, 0xdc, 0x58, 0xec, 0xa9,
  0xea, 0x8d, 0xef, 0xb4, 0xaa, 0x7f, 0xe8, 0xaa, 0xbc, 0x2e, 0x34, 0xc6,
  0x23, 0xe3, 0x12, 0x8c, 0xce, 0x0e, 0xed, 0xb1, 0x03, 0x9a, 0xb2, 0xfc,
  0x0a, 0xcb, 0x0a, 0x27, 0x23, 0x8b, 0x98, 0xe1, 0x76, 0xd4, 0x44, 0x86,
  0x59, 0xd2, 0xea, 0xda, 0x3a, 0xa5, 0x2b, 0x58, 0x16, 0x62, 0x01, 0x40,
  0xab, 0xcb, 0x18, 0x21, 0xf1, 0xb1, 0x78, 0x1a, 0x59, 0x02, 0x03, 0x01,
  0x00, 0x01
};
unsigned int public_der_len = 422;

unsigned char signature_bin[] = {
  0xbe, 0xe2, 0xaf, 0x69, 0xa3, 0x55, 0x50, 0xad, 0xae, 0x95, 0x72, 0xf9,
  0x82, 0x50, 0x23, 0xbb, 0xbd, 0xf8, 0x92, 0x2f, 0x52, 0xfc, 0x62, 0xc9,
  0x37, 0xc3, 0xd0, 0x50, 0xb2, 0x97, 0xd6, 0xdb, 0x8e, 0xc8, 0xd0, 0x59,
  0xf7, 0xb4, 0xcc, 0x0b, 0xa2, 0xb3, 0x77, 0xeb, 0x60, 0xa8, 0xed, 0x65,
  0x56, 0x2f, 0x8e, 0x4e, 0x66, 0xdb, 0x09, 0x7e, 0x6b, 0x4e, 0xd3, 0xfa,
  0x50, 0x3d, 0x05, 0x8a, 0x29, 0x16, 0x1f, 0x4b, 0xb6, 0x9c, 0x40, 0x60,
  0xd0, 0x16, 0x24, 0x32, 0xa5, 0x01, 0x01, 0x0c, 0x46, 0x76, 0xaf, 0x53,
  0x94, 0xe7, 0xc7, 0x1b, 0x68, 0xf9, 0x72, 0xc7, 0x78, 0xe3, 0xa4, 0xde,
  0xad, 0x40, 0x5b, 0x76, 0x94, 0x20, 0x91, 0xd1, 0x35, 0x31, 0x89, 0xf1,
  0x3a, 0x27, 0x83, 0x2f, 0x2d, 0x9c, 0x68, 0x1e, 0xd2, 0xd2, 0xe4, 0xa5,
  0x00, 0x56, 0x8e, 0xaa, 0x26, 0xf0, 0x93, 0xf8, 0x35, 0xea, 0xa9, 0x4a,
  0xb2, 0x27, 0xba, 0x55, 0xdd, 0x9d, 0xcf, 0x75, 0xde, 0x54, 0x39, 0x4f,
  0x87, 0x11, 0x41, 0xe0, 0x01, 0xc6, 0xac, 0x7e, 0xde, 0x06, 0x63, 0x2b,
  0x1a, 0xe4, 0x95, 0xdc, 0x2b, 0xe8, 0x18, 0x84, 0x11, 0x31, 0xbe, 0x9e,
  0x6d, 0xf9, 0x2c, 0xa8, 0x29, 0xbe, 0x6e, 0x82, 0x57, 0xde, 0xa4, 0xeb,
  0x22, 0xe1, 0x01, 0xc3, 0xde, 0xdd, 0x56, 0x69, 0x86, 0x1a, 0x06, 0xfd,
  0x87, 0xc4, 0x7a, 0x4c, 0xf6, 0x68, 0x76, 0xf1, 0xe5, 0xc2, 0xa4, 0xc5,
  0x3e, 0x0b, 0x16, 0x56, 0x93, 0xac, 0x60, 0x1a, 0x83, 0xab, 0xab, 0xd8,
  0x76, 0x67, 0x94, 0xcc, 0xb5, 0x9e, 0xf5, 0x21, 0xe8, 0x0c, 0x87, 0xed,
  0xea, 0xcf, 0xee, 0xb2, 0x6e, 0x5d, 0xda, 0xbe, 0xba, 0x25, 0x84, 0x0b,
  0x87, 0xcb, 0xd8, 0x38, 0xdc, 0xf3, 0xc9, 0x43, 0x41, 0x7a, 0x21, 0x79,
  0xf3, 0x23, 0xc9, 0x06, 0xb7, 0x61, 0x85, 0xba, 0x1e, 0x64, 0x8d, 0x71,
  0x78, 0xfc, 0xf4, 0x03, 0xe3, 0x0c, 0xa6, 0xb0, 0xb0, 0x9c, 0xbb, 0x5f,
  0x9d, 0xe0, 0x4c, 0x8d, 0x1f, 0xad, 0x8f, 0x30, 0x7d, 0xef, 0xfa, 0x79,
  0x3a, 0x94, 0x17, 0x68, 0xd1, 0x63, 0xa5, 0x8b, 0xb6, 0xc4, 0xbe, 0x67,
  0xb6, 0xe2, 0x24, 0x83, 0x4d, 0xff, 0x6a, 0x34, 0x90, 0x9f, 0x73, 0xa9,
  0xbd, 0x2f, 0xee, 0x68, 0xf9, 0xf1, 0xf9, 0x13, 0x5c, 0x0f, 0xe7, 0x44,
  0xb6, 0xc6, 0x33, 0xa1, 0xf4, 0xa3, 0x08, 0x00, 0xe1, 0x20, 0x70, 0xfe,
  0x20, 0x5e, 0xf7, 0xb6, 0xe3, 0x0f, 0x0a, 0x18, 0xb7, 0xbc, 0xf4, 0x63,
  0x2e, 0x64, 0x99, 0xe0, 0x19, 0x44, 0x59, 0x6b, 0x16, 0x07, 0x36, 0x91,
  0x5c, 0x00, 0x89, 0x9a, 0x0e, 0x26, 0xa1, 0x45, 0x13, 0xf8, 0x10, 0x82,
  0xb2, 0x0c, 0x8d, 0x49, 0x86, 0x1c, 0x9e, 0x55, 0x47, 0xc6, 0xbc, 0x6a
};
unsigned int signature_bin_len = 384;

#elif (MBEDTLS_RSA_LENGTH == 512)
unsigned char public_der[] = {
  0x30, 0x82, 0x02, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
  0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0f, 0x00,
  0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x02, 0x01, 0x00, 0xb7, 0x9c, 0xa0,
  0xd5, 0x96, 0xaf, 0x4f, 0x5f, 0x63, 0x9e, 0x68, 0x97, 0x78, 0x60, 0x02,
  0x9a, 0xb7, 0xea, 0x2c, 0xe6, 0x58, 0x1a, 0x20, 0xd6, 0xcf, 0x27, 0x0b,
  0x6a, 0xbf, 0xc0, 0x26, 0x1b, 0xd4, 0x5b, 0x3d, 0x27, 0x07, 0x25, 0x83,
  0x0a, 0x63, 0xe7, 0x05, 0xf5, 0x08, 0x83, 0xf4, 0x0a, 0x58, 0x13, 0xe2,
  0x15, 0x30, 0x37, 0xd5, 0x0a, 0x47, 0xb0, 0xeb, 0x8f, 0x20, 0x85, 0x9b,
  0xda, 0x0c, 0xcb, 0xe5, 0xce, 0xb6, 0x23, 0x11, 0xa5, 0xd9, 0x27, 0x01,
  0x31, 0x8f, 0x12, 0xe1, 0x88, 0xa7, 0x3a, 0x17, 0x81, 0x69, 0x53, 0x75,
  0x16, 0x8a, 0xf0, 0xb1, 0xf1, 0x1b, 0xcb, 0x59, 0x72, 0x12, 0x6b, 0xf1,
  0xa4, 0x1f, 0x94, 0xaf, 0xcc, 0xf5, 0xdb, 0x40, 0xd0, 0xf3, 0x9f, 0x18,
  0x54, 0xe8, 0xf2, 0x9b, 0x22, 0x77, 0xda, 0x05, 0x20, 0xd0, 0x12, 0x28,
  0xc2, 0x43, 0xa6, 0x30, 0x6c, 0xce, 0x74, 0x73, 0xaf, 0xd8, 0xa4, 0xf0,
  0x80, 0x70, 0x99, 0xe7, 0xfa, 0x95, 0x17, 0x61, 0x55, 0x37, 0xc4, 0x2c,
  0x2c, 0xc0, 0x27, 0xee, 0x35, 0x40, 0x45, 0x56, 0x24, 0x7b, 0xc9, 0x01,
  0x1e, 0x4f, 0xef, 0xfc, 0xe2, 0x5c, 0x07, 0x88, 0x14, 0xd3, 0x3e, 0xd5,
  0x57, 0x30, 0xf6, 0xf3, 0x0c, 0x36, 0x69, 0xa4, 0xc7, 0x52, 0x65, 0xd2,
  0x41, 0x48, 0x76, 0xaa, 0x39, 0x15, 0x46, 0x19, 0x1b, 0x82, 0x9b, 0x96,
  0xff, 0x71, 0xaf, 0x5c, 0x23, 0xf4, 0x62, 0x32, 0xf0, 0x7c, 0xaa, 0x16,
  0x91, 0x5a, 0x62, 0x14, 0x9f, 0x14, 0x66, 0xf2, 0x34, 0x7b, 0xbf, 0x34,
  0x5c, 0x1a, 0x3b, 0x4d, 0x2d, 0x95, 0x57, 0x7c, 0x35, 0x0b, 0x62, 0xac,
  0xd2, 0xe4, 0x1f, 0xfe, 0x9d, 0x4f, 0x53, 0x57, 0x9c, 0x48, 0x92, 0xc4,
  0x29, 0xbc, 0x4f, 0x71, 0x01, 0xb9, 0x73, 0xe1, 0x7d, 0x4f, 0x21, 0x77,
  0xde, 0x47, 0x56, 0x94, 0x17, 0xdc, 0x69, 0x70, 0x46, 0xb3, 0x1f, 0x2b,
  0x3d, 0x23, 0x8a, 0x7f, 0x70, 0x25, 0xba, 0x4f, 0xf7, 0x79, 0x56, 0x0f,
  0x5c, 0x8b, 0x0b, 0x8b, 0x92, 0x3e, 0xd3, 0x49, 0xb1, 0x4c, 0xee, 0xe2,
  0xf6, 0x1d, 0x2c, 0x61, 0x25, 0x93, 0xe9, 0x7c, 0x34, 0x29, 0xd4, 0x0a,
  0x0f, 0x47, 0xd6, 0xfc, 0x03, 0x2d, 0xbc, 0xa4, 0x42, 0xcc, 0x98, 0xce,
  0xcf, 0xbb, 0x8b, 0xdc, 0x82, 0x3c, 0x37, 0xa5, 0xe5, 0x94, 0x04, 0xe6,
  0xdc, 0xf1, 0xc4, 0x60, 0xb1, 0xf3, 0x54, 0x7c, 0x84, 0x10, 0x73, 0xca,
  0xee, 0x65, 0xde, 0x32, 0xc6, 0x58, 0x0a, 0xa0, 0x7c, 0x08, 0x23, 0x84,
  0xa3, 0xbd, 0xda, 0xdb, 0x42, 0x25, 0x12, 0xaf, 0x5b, 0x53, 0x28, 0xac,
  0x25, 0xf9, 0x36, 0x3b, 0x71, 0xa3, 0x0f, 0xc2, 0x27, 0xa9, 0x8e, 0x05,
  0xf1, 0x24, 0x55, 0x1e, 0xc6, 0x52, 0x52, 0x4e, 0x09, 0xc1, 0xc2, 0xae,
  0xaf, 0xb7, 0x1c, 0x2b, 0x7c, 0x12, 0xdf, 0x7a, 0x0e, 0xf8, 0x0a, 0x9d,
  0x82, 0x12, 0x42, 0x3d, 0x35, 0xe1, 0x38, 0xdd, 0x2d, 0x94, 0x38, 0x1b,
  0xbb, 0x17, 0xb2, 0x54, 0xe5, 0x32, 0x27, 0x1f, 0xfc, 0x33, 0xfe, 0x5e,
  0x19, 0xc7, 0xc1, 0x4f, 0x44, 0x39, 0xba, 0xdd, 0xc9, 0x2e, 0x9d, 0x16,
  0xcf, 0xcb, 0x87, 0x1f, 0x62, 0xbc, 0x05, 0xea, 0xbe, 0x1c, 0x08, 0xe4,
  0x50, 0x30, 0x37, 0x03, 0xc9, 0x7f, 0xd6, 0x94, 0xf3, 0xdb, 0x6c, 0x0b,
  0xc9, 0x65, 0x79, 0xf6, 0xd4, 0xdc, 0x96, 0x95, 0xcc, 0xb6, 0x8e, 0xca,
  0x92, 0x4b, 0x35, 0xc5, 0x67, 0x17, 0xd7, 0xc9, 0x53, 0x72, 0xd7, 0x58,
  0xd3, 0x3f, 0x19, 0x93, 0xc7, 0x4e, 0x69, 0xa3, 0x68, 0x5b, 0x54, 0x7b,
  0xc7, 0x2d, 0x62, 0xd7, 0xfa, 0x33, 0xee, 0xbb, 0x3e, 0xd7, 0xb3, 0x26,
  0x05, 0xb1, 0x5f, 0x89, 0x2f, 0x02, 0x03, 0x01, 0x00, 0x01
};
unsigned int public_der_len = 550;	

unsigned char signature_bin[] = {
  0x3a, 0x73, 0x6a, 0x30, 0x91, 0x0e, 0xbb, 0xff, 0xc0, 0x0a, 0x4c, 0x50,
  0x61, 0xae, 0x69, 0xc8, 0x95, 0xca, 0x28, 0xa2, 0x21, 0x4e, 0x90, 0xf5,
  0xdb, 0xa5, 0x81, 0xa0, 0xf3, 0x86, 0x4d, 0xbe, 0x06, 0x9e, 0x79, 0xd3,
  0x4d, 0xbb, 0x6e, 0xb4, 0x6c, 0x1a, 0x9b, 0xca, 0x1f, 0x2d, 0x69, 0xae,
  0x0f, 0xeb, 0x58, 0x07, 0x45, 0x80, 0x69, 0xce, 0xe1, 0x54, 0xbc, 0xbe,
  0x98, 0x90, 0x92, 0xe1, 0x94, 0xa2, 0x7a, 0x99, 0x46, 0x3e, 0xb1, 0xec,
  0xb4, 0x91, 0xcd, 0xa0, 0x35, 0x92, 0xf6, 0xa0, 0xe8, 0x5a, 0x53, 0xc8,
  0x40, 0x61, 0x13, 0x61, 0x47, 0xa7, 0xf7, 0xca, 0xde, 0xb9, 0x10, 0xa1,
  0x14, 0xd6, 0xca, 0x1f, 0x4a, 0x0c, 0x4b, 0x6c, 0xe2, 0x84, 0xee, 0x6d,
  0xa1, 0xb0, 0x1e, 0x4d, 0x88, 0x07, 0x7c, 0x3c, 0x6a, 0x42, 0x06, 0x65,
  0xec, 0xbd, 0xcd, 0x81, 0xc9, 0x7f, 0x4c, 0x9d, 0xbf, 0x7f, 0x71, 0x28,
  0x30, 0xad, 0x5d, 0x43, 0x85, 0x37, 0xc1, 0x45, 0x38, 0xfe, 0x56, 0xcd,
  0x65, 0xd3, 0x37, 0x30, 0x19, 0x0d, 0x5d, 0x7e, 0x65, 0x14, 0x97, 0xd0,
  0x9e, 0x58, 0x0b, 0x08, 0x58, 0x81, 0xef, 0x40, 0x20, 0xf5, 0x01, 0x99,
  0x49, 0xa8, 0xb1, 0x96, 0x09, 0xb8, 0x9c, 0xc2, 0x8a, 0xdd, 0xe3, 0x61,
  0x66, 0xb5, 0x17, 0xeb, 0x08, 0x20, 0xe4, 0xe0, 0x12, 0x72, 0x5d, 0x39,
  0x5a, 0xfe, 0xb7, 0x90, 0x3a, 0x0a, 0xfd, 0xfc, 0xc6, 0x2a, 0xe0, 0xa6,
  0xa4, 0xa0, 0xe3, 0xcf, 0x44, 0x13, 0x94, 0x12, 0xf1, 0x51, 0xd8, 0x3f,
  0x3b, 0x12, 0xe1, 0xb6, 0x92, 0x90, 0xef, 0xf9, 0x32, 0xbf, 0xbd, 0xd5,
  0x50, 0xe5, 0x05, 0xf9, 0xef, 0x65, 0x58, 0xdf, 0xbc, 0x5f, 0xcc, 0xd7,
  0x4e, 0xac, 0xda, 0x36, 0x87, 0x1b, 0xad, 0xd1, 0x5b, 0xa5, 0x4f, 0xae,
  0xad, 0xf9, 0xe3, 0x7c, 0xd1, 0x91, 0xb6, 0x05, 0x30, 0xe9, 0x1a, 0x90,
  0xa2, 0xcf, 0x0d, 0x5f, 0xee, 0xe6, 0xb0, 0x93, 0x4a, 0xf0, 0x5a, 0x8b,
  0x7d, 0xd2, 0xc7, 0xc7, 0x2e, 0x34, 0xc2, 0x1e, 0xad, 0xe5, 0x2e, 0x25,
  0x58, 0x2e, 0x34, 0x53, 0x51, 0xa0, 0x24, 0x9e, 0x4b, 0xd6, 0xd5, 0x0e,
  0x2a, 0xf9, 0xe4, 0x6a, 0xbe, 0xdc, 0xab, 0x43, 0xee, 0x56, 0x7c, 0x01,
  0x8d, 0x8d, 0x4c, 0xf3, 0x86, 0x79, 0x60, 0x08, 0x6c, 0x2a, 0xc6, 0x9b,
  0xcf, 0xcd, 0x56, 0x68, 0x5c, 0xe5, 0x0a, 0x43, 0xf1, 0xfd, 0x29, 0x36,
  0xb9, 0xa2, 0x95, 0xe2, 0x20, 0x09, 0xb7, 0x1b, 0xd1, 0x1d, 0x0a, 0xef,
  0x77, 0x80, 0xeb, 0x25, 0xd3, 0x2c, 0xaf, 0x89, 0x72, 0xaf, 0x51, 0x51,
  0x1c, 0xa5, 0xae, 0xe8, 0x8c, 0xb5, 0xf8, 0xad, 0x9f, 0x5c, 0xe7, 0x9f,
  0xc6, 0x68, 0xe3, 0x63, 0xca, 0x86, 0xa6, 0xb8, 0x0e, 0x50, 0xa8, 0xe3,
  0xeb, 0xcb, 0xc7, 0x29, 0x17, 0xbf, 0x8b, 0x33, 0xbf, 0xe5, 0xd0, 0x2e,
  0xa5, 0x61, 0xe2, 0x4c, 0x8f, 0x73, 0x89, 0x61, 0x42, 0xc4, 0x9c, 0x78,
  0xb2, 0x0c, 0xf5, 0x74, 0xbd, 0xd6, 0xe6, 0x9f, 0xc0, 0x34, 0xf5, 0xc9,
  0xcc, 0x3d, 0x5c, 0x02, 0x6c, 0xf4, 0xda, 0x02, 0x9c, 0x8e, 0x77, 0x75,
  0x23, 0xb8, 0x59, 0xb4, 0x89, 0x8f, 0xe7, 0xfc, 0x5f, 0x31, 0x7f, 0x14,
  0x80, 0xa4, 0x73, 0x11, 0x09, 0xb0, 0x8a, 0xe5, 0xed, 0x54, 0x1c, 0x7b,
  0x77, 0x1b, 0xd5, 0xde, 0x8e, 0x17, 0xbf, 0x86, 0x94, 0xcd, 0xf0, 0xd8,
  0x45, 0x2b, 0x87, 0x97, 0xc7, 0x55, 0x89, 0x89, 0x91, 0xcb, 0x80, 0x86,
  0x0f, 0xc8, 0xcf, 0x0a, 0x8d, 0xa2, 0xce, 0x60, 0x60, 0x33, 0x84, 0x38,
  0xea, 0x30, 0xa5, 0x24, 0xd8, 0x54, 0x3b, 0x1c, 0xf0, 0x8f, 0x71, 0x16,
  0x46, 0x4a, 0x36, 0x0f, 0x6c, 0x93, 0xf0, 0x02
};
unsigned int signature_bin_len = 512;

#else
#error "dddd"
#endif

#endif

unsigned char	fwimg[12] = "ILoveRealtek";

unsigned char myhash[32];

unsigned char myhash_256[32];
#if 0
	unsigned char pkbuf[65] = "\x04\x0a\x97\x5a\x3d\x61\xec\xd5\x07\xf2\x6b\x9d\x13\xd0\x76" \
                                 "\x1b\x71\x6e\xdf\x9c\x9e\xba\xff\xd3\xdf\x47\xe3\x78\xc5\x12" \
                                 "\x5d\x75\xce\x51\xb8\xfe\x83\x9d\x8e\x75\x90\x86\xec\xa9\x70" \
                                 "\xee\x10\xb6\x4f\xf9\xb0\xb5\xe2\xe6\x7e\x2e\x1f\xde\x5a\x73" \
                                 "\x74\x71\xed\xa7\x09";
	unsigned char rsa_n[2048/8]; //(The public modulus. )
	unsigned char rsa_e[2048/8];  //The public exponent. 

	
	
	unsigned char hash[32]="\xe3\xb0\xc4\x42\x98\xfc\x1c\x14\x9a\xfb\xf4\xc8\x99\x6f\xb9\x24" \
"\x27\xae\x41\xe4\x64\x9b\x93\x4c\xa4\x95\x99\x1b\x78\x52\xb8\x55" ;
	//bad hash
	//unsigned char hash[32]="\xff\xb0\xc4\x42\x98\xfc\x1c\x14\x9a\xfb\xf4\xc8\x99\x6f\xb9\x24" \
"\x27\xae\x41\xe4\x64\x9b\x93\x4c\xa4\x95\x99\x1b\x78\x52\xb8\x55" ;
	unsigned char sig[0x46]="\x30\x44\x02\x20\x5f\x92\xfd\x18\x35\xb7\xd7\xe2\x6c\x5b\xba\x3a" \
"\xa0\x00\xd2\x79\x14\x7a\x42\xf2\x5f\xad\xf8\xba\xa1\x7b\x1a\xa3" \
"\xa8\xf9\x72\x41\x02\x20\x6a\xe6\x1b\xd1\xf3\x18\x81\xfb\xc2\x29" \
"\xaf\xb5\x77\x27\x43\x86\xe6\x88\xaa\x3d\x74\x4d\x72\xfd\x3f\xaf" \
"\xce\x0d\xfa\x53\x53\x1f";

	int sig_len=0x46;
#endif
	int i;
	int sha256_cycle;
	int rsa_cycle;

	#if 1	
#if (MBEDTLS_KEY_ALG_ID == MBEDTLS_ECDSA)
	printf("start test, ecdsa test mode = %d.\n", MBEDTLS_ECDSA_LENGTH);
#else
	printf("start test, test rsa lengh=%d\n", MBEDTLS_RSA_LENGTH);
#endif
	mbedtls_init();
	
		set_c0_cause(CAUSEF_DC);
		write_c0_count(0);
		clear_c0_cause(CAUSEF_DC);
	mbedtls_sha256(sha_256_input, 131072, myhash_256, 0);
	sha256_cycle = read_c0_count()*2;
			set_c0_cause(CAUSEF_DC);
	mbedtls_sha256(fwimg, sizeof(fwimg), myhash, 0);
	
	printf("my hash : \n");
	for (i=0 ; i<32 ; i++)
	{
		printf("%x, ", myhash[i]);
	}

		printf("my hash_256 : \n");
	for (i=0 ; i<32 ; i++)
	{
		printf("%x, ", myhash_256[i]);
	}
	
	printf("\n(line=%d)\n", __LINE__);
	
	mbedtls_pk_init( &pk );
printf("\n(line=%d)\n", __LINE__);

    if ( (i=mbedtls_pk_parse_public_key(&pk, public_der, public_der_len)) !=0 )
	{
		printf("mbedtls_pk_parse_subpubkey error, %d\n", i);
		
	}
printf("\n(line=%d)\n", __LINE__);
#if (MBEDTLS_KEY_ALG_ID == MBEDTLS_ECDSA)
	if ( !mbedtls_pk_can_do( &pk, MBEDTLS_PK_ECDSA ) )
	{
		printf("mbedtls_pk_can_do error\n");
	}
#else
	if ( !mbedtls_pk_can_do( &pk, MBEDTLS_PK_RSA ) )
	{
		printf("mbedtls_pk_can_do error\n");
	}
#endif
printf("\n(line=%d)\n", __LINE__);

#if (MBEDTLS_KEY_ALG_ID != MBEDTLS_ECDSA)
	mbedtls_rsa_set_padding( mbedtls_pk_rsa( pk ), MBEDTLS_RSA_PKCS_V21, MBEDTLS_MD_SHA256);
#endif
printf("\n(line=%d)\n", __LINE__);
		write_c0_count(0);
		clear_c0_cause(CAUSEF_DC);
	ret = mbedtls_pk_verify( &pk, MBEDTLS_MD_SHA256, myhash, 0, signature_bin, signature_bin_len);
	rsa_cycle = read_c0_count()*2;

	//mbedtls_rsa_init( &rsa, MBEDTLS_RSA_PKCS_V21, 0);
	
    //mbedtls_mpi_read_binary(&rsa.N, rsa_n, );

	//mbedtls_mpi_read_binary(&rsa.E, rsa_e, );
	
	//mbedtls_ecp_point_read_binary(&ecdsa.grp, &ecdsa.Q, pkbuf, sizeof(pkbuf));
	
	//md_info = mbedtls_md_info_from_type(MBEDTLS_MD_SHA256);
	
	//mbedtls_md(md_info, data, data_len, hash_out);
	
	//ret = mbedtls_rsa_pkcs1_verify(&rsa, NULL, NULL, MBEDTLS_RSA_PUBLIC, MBEDTLS_MD_SHA256, 20, hash, buf);

	printf("ret=%d.\n", ret);

	mbedtls_pk_free( &pk );

	
	printf("sha256cycle=%d, rsacyelc=%d\n", sha256_cycle, rsa_cycle);
	
#endif
	return 0;
}


void exit(int input)
{
	
	printf("(%d)", input);
	
}



