/*
 *  Routines to access hardware
 *
 *  Copyright (c) 2014 Realtek Semiconductor Corp.
 *
 *  This module is a confidential and proprietary property of RealTek and
 *  possession or use of this module requires written permission of RealTek.
 */

#ifndef _DW_PCIE_BASE_BIT_H_
#define _DW_PCIE_BASE_BIT_H_


/* Type 0 Configuration Space */
//2 REG_DW_PCIE_DEVICE_ID_VENDOR_ID												0x00
// used by type0 & type 1 
#define BIT_SHIFT_DW_PCIE_VENDOR_ID					0
#define BIT_MASK_DW_PCIE_VENDOR_ID					0xffff

#define BIT_SHIFT_DW_PCIE_DEVICE_ID					16
#define BIT_MASK_DW_PCIE_DEVICE_ID					0xffff

//2 REG_DW_PCIE_STATUS_COMMAND													0x04
// used by type0 & type 1
#define BIT_SHIFT_DW_PCIE_IO_EN						0
#define BIT_DW_PCIE_IO_EN							BIT(BIT_SHIFT_DW_PCIE_IO_EN)
#define BIT_MASK_DW_PCIE_IO_EN						0x1
#define BIT_CTRL_DW_PCIE_IO_EN(x)					(((x) & BIT_MASK_DW_PCIE_IO_EN) << BIT_SHIFT_DW_PCIE_IO_EN)

#define BIT_SHIFT_DW_PCIE_MSE						1
#define BIT_DW_PCIE_MSE								BIT(BIT_SHIFT_DW_PCIE_MSE)
#define BIT_MASK_DW_PCIE_MSE						0x1
#define BIT_CTRL_DW_PCIE_MSE(x)						(((x) & BIT_MASK_DW_PCIE_MSE) << BIT_SHIFT_DW_PCIE_MSE)

#define BIT_SHIFT_DW_PCIE_BME						2
#define BIT_DW_PCIE_BME								BIT(BIT_SHIFT_DW_PCIE_BME)
#define BIT_MASK_DW_PCIE_BME						0x1
#define BIT_CTRL_DW_PCIE_BME(x)						(((x) & BIT_MASK_DW_PCIE_BME) << BIT_SHIFT_DW_PCIE_BME)

#define BIT_SHIFT_DW_PCIE_INT_STATUS				19
#define BIT_DW_PCIE_INT_STATUS						BIT(BIT_SHIFT_DW_PCIE_INT_STATUS)
#define BIT_MASK_DW_PCIE_INT_STATUS					0x1
#define BIT_CTRL_DW_PCIE_INT_STATUS(x)				(((x) & BIT_MASK_DW_PCIE_INT_STATUS) << BIT_SHIFT_DW_PCIE_INT_STATUS)

#define BIT_SHIFT_DW_PCIE_CAP_LIST					20
#define BIT_DW_PCIE_CAP_LIST						BIT(BIT_SHIFT_DW_PCIE_CAP_LIST)
#define BIT_MASK_DW_PCIE_CAP_LIST					0x1
#define BIT_CTRL_DW_PCIE_CAP_LIST(x)				(((x) & BIT_MASK_DW_PCIE_CAP_LIST) << BIT_SHIFT_DW_PCIE_CAP_LIST)

//2 REG_DW_PCIE_CLASS_CODE_REVISION_ID											0x08
// used by type0 & type 1 
#define BIT_SHIFT_DW_PCIE_REVISION_ID				0
#define BIT_MASK_DW_PCIE_REVISION_ID				0xff

#define BIT_SHIFT_DW_PCIE_CLASS_CODE				8
#define BIT_MASK_DW_PCIE_CLASS_CODE					0xffffff

//2 REG_DW_PCIE_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE					0x0c
// used by type0 & type 1 
#define BIT_SHIFT_DW_PCIE_CACHE_LINE_SIZE			0
#define BIT_MASK_DW_PCIE_CACHE_LINE_SIZE			0xff

#define BIT_SHIFT_DW_PCIE_LATENCY_MASTER_TIMER		8
#define BIT_MASK_DW_PCIE_LATENCY_MASTER_TIMER		0xff

#define BIT_SHIFT_DW_PCIE_HEADER_TYPE				16
#define BIT_MASK_DW_PCIE_HEADER_TYPE				0x7f

#define BIT_SHIFT_DW_PCIE_BIST						24
#define BIT_MASK_DW_PCIE_BIST						0xff

//2 REG_DW_PCIE_BAR0																0x10
#define BIT_SHIFT_DW_PCIE_BAR0_MEM_IO				0
#define BIT_DW_PCIE_BAR0_MEM_IO						BIT(BIT_SHIFT_DW_PCIE_BAR0_MEM_IO)
#define BIT_MASK_DW_PCIE_BAR0_MEM_IO				0x1
#define BIT_CTRL_DW_PCIE_BAR0_MEM_IO(x)				(((x) & BIT_MASK_DW_PCIE_BAR0_MEM_IO) << BIT_SHIFT_DW_PCIE_BAR0_MEM_IO)

#define BIT_SHIFT_DW_PCIE_BAR0_TYPE					1
#define BIT_DW_PCIE_BAR0_TYPE						BIT(BIT_SHIFT_DW_PCIE_BAR0_TYPE)
#define BIT_MASK_DW_PCIE_BAR0_TYPE					0x3
#define BIT_CTRL_DW_PCIE_BAR0_TYPE(x)				(((x) & BIT_MASK_DW_PCIE_BAR0_TYPE) << BIT_SHIFT_DW_PCIE_BAR0_TYPE)

//2 REG_DW_PCIE_BAR1																0x14

//2 REG_DW_PCIE_BAR2																0x18
#define BIT_SHIFT_DW_PCIE_BAR2_MEM_IO				0
#define BIT_DW_PCIE_BAR2_MEM_IO						BIT(BIT_SHIFT_DW_PCIE_BAR2_MEM_IO)
#define BIT_MASK_DW_PCIE_BAR2_MEM_IO				0x1
#define BIT_CTRL_DW_PCIE_BAR2_MEM_IO(x)				(((x) & BIT_MASK_DW_PCIE_BAR2_MEM_IO) << BIT_SHIFT_DW_PCIE_BAR2_MEM_IO)

#define BIT_SHIFT_DW_PCIE_BAR2_TYPE					1
#define BIT_DW_PCIE_BAR2_TYPE						BIT(BIT_SHIFT_DW_PCIE_BAR2_TYPE)
#define BIT_MASK_DW_PCIE_BAR2_TYPE					0x3
#define BIT_CTRL_DW_PCIE_BAR2_TYPE(x)				(((x) & BIT_MASK_DW_PCIE_BAR2_TYPE) << BIT_SHIFT_DW_PCIE_BAR2_TYPE)

//2 REG_DW_PCIE_BAR3																0x1c

//2 REG_DW_PCIE_BAR4																0x20

//2 REG_DW_PCIE_BAR5																0x24

//2 REG_DW_PCIE_CARDBUS_CIS_PTR													0x28
#define BIT_SHIFT_DW_PCIE_CARDBUS_CIS_POINTER		0
#define BIT_MASK_DW_PCIE_CARDBUS_CIS_POINTER		0xffffffff

//2 REG_DW_PCIE_SUBSYSTEM_ID_SUBSYSTEM_VENDOR_ID							0x2c
#define BIT_SHIFT_DW_PCIE_SUBSYS_VENDOR_ID			0
#define BIT_MASK_DW_PCIE_SUBSYS_VENDOR_ID			0xffff

#define BIT_SHIFT_DW_PCIE_SUBSYS_DEV_ID				16
#define BIT_MASK_DW_PCIE_SUBSYS_DEV_ID				0xffff

//2 REG_DW_PCIE_EXP_ROM_BASE_ADDR												0x30

//2 REG_DW_PCIE_PCI_CAP_PTR														0x34
// used by type0 & type 1 
#define BIT_SHIFT_DW_PCIE_CAP_POINTER				0
#define BIT_MASK_DW_PCIE_CAP_POINTER				0xff

//2 REG_DW_PCIE_MAX_LATENCY_MIN_GRANT_INTERRUPT_PIN_INTERRUPT_LINE		0x3c
// used by type0 & type 1 
#define BIT_SHIFT_DW_PCIE_INT_LINE					0
#define BIT_MASK_DW_PCIE_INT_LINE					0xff

#define BIT_SHIFT_DW_PCIE_INT_PIN					8
#define BIT_MASK_DW_PCIE_INT_PIN					0xff



/* Type 1 Configuration Space */
//2 REG_DW_PCIE_TYPE1_DEV_ID_VEND_ID								0x00

//2 REG_DW_PCIE_TYPE1_STATUS_COMMAND							0x04

//2 REG_DW_PCIE_TYPE1_CLASS_CODE_REV_ID						0x08

//2 REG_DW_PCIE_TYPE1_BIST_HDR_TYPE_LAT_CACHE_LINE_SIZE		0x0c

//2 REG_DW_PCIE_SEC_LAT_TIMER_SUB_BUS_SEC_BUS_PRI_BUS		0x18
#define BIT_SHIFT_DW_PCIE_PRIM_BUS					0
#define BIT_MASK_DW_PCIE_PRIM_BUS					0xff

#define BIT_SHIFT_DW_PCIE_SEC_BUS					8
#define BIT_MASK_DW_PCIE_SEC_BUS					0xff

#define BIT_SHIFT_DW_PCIE_SUB_BUS					16
#define BIT_MASK_DW_PCIE_SUB_BUS					0xff

#define BIT_SHIFT_DW_PCIE_SEC_LAT_TIMER				24
#define BIT_MASK_DW_PCIE_SEC_LAT_TIMER				0xff

//2 REG_DW_PCIE_SEC_STAT_IO_LIMIT_IO_BASE						0x1c
#define BIT_SHIFT_DW_PCIE_IO_BASE					0
#define BIT_MASK_DW_PCIE_IO_BASE					0xff

#define BIT_SHIFT_DW_PCIE_IO_LIMIT					8
#define BIT_MASK_DW_PCIE_IO_LIMIT					0xff

#define BIT_SHIFT_DW_PCIE_SEC_STAT					16
#define BIT_MASK_DW_PCIE_SEC_STAT					0xffff

//2 REG_DW_PCIE_MEM_LIMIT_MEM_BASE								0x20
#define BIT_SHIFT_DW_PCIE_MEM_BASE					0
#define BIT_MASK_DW_PCIE_MEM_BASE					0xffff

#define BIT_SHIFT_DW_PCIE_MEM_LIMIT					16
#define BIT_MASK_DW_PCIE_MEM_LIMIT					0xffff

//2 REG_DW_PCIE_PREF_MEM_LIMIT_PREF_MEM_BASE				0x24
#define BIT_SHIFT_DW_PCIE_PREF_MEM_BASE				0
#define BIT_MASK_DW_PCIE_PREF_MEM_BASE				0xffff

#define BIT_SHIFT_DW_PCIE_PREF_MEM_LIMIT			16
#define BIT_MASK_DW_PCIE_PREF_MEM_LIMIT				0xffff

//2 REG_DW_PCIE_PREF_BASE_UPPER									0x28

//2 REG_DW_PCIE_PREF_LIMIT_UPPER									0x2c

//2 REG_DW_PCIE_IO_LIMIT_UPPER_IO_BASE_UPPER					0x30
#define BIT_SHIFT_DW_PCIE_IO_BASE_UPPER				0
#define BIT_MASK_DW_PCIE_IO_BASE_UPPER				0xffff

#define BIT_SHIFT_DW_PCIE_IO_LIMIT_UPPER			16
#define BIT_MASK_DW_PCIE_IO_LIMIT_UPPER				0xffff

//2 REG_DW_PCIE_TYPE1_CAP_PTR									0x34

//2 REG_DW_PCIE_TYPE1_EXP_ROM_BASE								0x38

//2  REG_DW_PCIE_BRIDGE_CTRL_INT_PIN_INT_LINE					0x3c
#define BIT_SHIFT_DW_PCIE_BRIDGE_CTRL				16
#define BIT_MASK_DW_PCIE_BRIDGE_CTRL				0xffff

#define BIT_SHIFT_DW_PCIE_BRIDGE_CTRL_SBR			22
#define BIT_DW_PCIE_BRIDGE_CTRL_SBR				BIT(BIT_SHIFT_DW_PCIE_BRIDGE_CTRL_SBR)
#define BIT_MASK_DW_PCIE_BRIDGE_CTRL_SBR			0x1



//2 REG_DW_PCIE_CON_STATUS						0x44
#define BIT_SHIFT_DW_PCIE_POWER_STATE				0
#define BIT_DW_PCIE_POWER_STATE						BIT(BIT_SHIFT_DW_PCIE_POWER_STATE)
#define BIT_MASK_DW_PCIE_POWER_STATE				0x3
#define BIT_CTRL_DW_PCIE_POWER_STATE(x)				(((x) & BIT_MASK_DW_PCIE_POWER_STATE) << BIT_SHIFT_DW_PCIE_POWER_STATE)

typedef enum _DW_PCIE_POWER_STATE_ {
	DW_PCIE_POWER_STATE_D0 		= 0,
	DW_PCIE_POWER_STATE_D1 		= 1,
	DW_PCIE_POWER_STATE_D2 		= 2,
	DW_PCIE_POWER_STATE_D3HOT 	= 3
}DW_PCIE_POWER_STATE, *PDW_PCIE_POWER_STATE;


//2 REG_DW_PCIE_DEVICE_CONTROL_DEVICE_STATUS							0x78
#define BIT_SHIFT_DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS		5
#define BIT_DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS			BIT(BIT_SHIFT_DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS)
#define BIT_MASK_DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS		0x7
#define BIT_CTRL_DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS(x)	(((x) & BIT_MASK_DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS) << BIT_SHIFT_DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS)

typedef enum _DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_ {
	DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_128		= 0,
	DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_256		= 1,
	DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_512		= 2,
	DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_1024		= 3,
	DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_2048		= 4,
	DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_4096		= 5,
	DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_RESERVE_6	= 6,
	DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_RESERVE_7	= 7
}DW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS, *PDW_PCIE_PCIE_CAP_MAX_PAYLOAD_SIZE_CS;


#define BIT_SHIFT_DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE		12
#define BIT_DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE				BIT(BIT_SHIFT_DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE)
#define BIT_MASK_DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE			0x7
#define BIT_CTRL_DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE(x)		(((x) & BIT_MASK_DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE) << BIT_SHIFT_DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE)

typedef enum _DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_ {
	DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_128			= 0,
	DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_256			= 1,
	DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_512			= 2,
	DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_1024			= 3,
	DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_2048			= 4,
	DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_4096			= 5,
	DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_RESERVE_6	= 6,
	DW_PCIE_PCIE_CAP_MAX_READ_REQ_SIZE_RESERVE_7	= 7
}PCIE_CAP_MAX_READ_REQ_SIZE, *PPCIE_CAP_MAX_READ_REQ_SIZE;


//2 REG_DW_PCIE_LINK_CONTROL_LINK_STATUS								0x80
#define BIT_SHIFT_DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL			0
#define BIT_DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL				BIT(BIT_SHIFT_DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL)
#define BIT_MASK_DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL			0x3
#define BIT_CTRL_DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL(x)		(((x) & BIT_MASK_DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL) << BIT_SHIFT_DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL)

typedef enum _DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL_ {
	DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL_DISABLE		= 0,
	DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL_L0S			= 1,
	DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL_L1			= 2,
	DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL_L0S_L1		= 3
}DW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL, *PDW_PCIE_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL;


#define BIT_SHIFT_DW_PCIE_PCIE_CAP_EN_CLK_POWER_MAN						8
#define BIT_DW_PCIE_PCIE_CAP_EN_CLK_POWER_MAN							BIT(BIT_SHIFT_DW_PCIE_PCIE_CAP_EN_CLK_POWER_MAN)
#define BIT_MASK_DW_PCIE_PCIE_CAP_EN_CLK_POWER_MAN						0x1
#define BIT_CTRL_DW_PCIE_PCIE_CAP_EN_CLK_POWER_MAN(x)					(((x) & BIT_MASK_DW_PCIE_PCIE_CAP_EN_CLK_POWER_MAN) << BIT_SHIFT_DW_PCIE_PCIE_CAP_EN_CLK_POWER_MAN)

#define BIT_SHIFT_DW_PCIE_PCIE_CAP_LINK_SPEED			                                16
#define BIT_DW_PCIE_PCIE_CAP_LINK_SPEED				                                BIT(BIT_SHIFT_DW_PCIE_PCIE_CAP_LINK_SPEED)
#define BIT_MASK_DW_PCIE_PCIE_CAP_LINK_SPEED			                                0xf
#define BIT_CTRL_DW_PCIE_PCIE_CAP_LINK_SPEED(x)		                                        (((x) & BIT_MASK_DW_PCIE_PCIE_CAP_LINK_SPEED) << BIT_SHIFT_DW_PCIE_PCIE_CAP_LINK_SPEED)


/* PCIE Extended Configuration space */
//2 REG_DW_PCIE_ACK_F_ASPM_CTRL							0x70c
#define BIT_SHIFT_DW_PCIE_L0S_ENTRANCE_LATENCY							24
#define BIT_DW_PCIE_L0S_ENTRANCE_LATENCY								BIT(BIT_SHIFT_DW_PCIE_L0S_ENTRANCE_LATENCY)
#define BIT_MASK_DW_PCIE_L0S_ENTRANCE_LATENCY							0x7
#define BIT_CTRL_DW_PCIE_L0S_ENTRANCE_LATENCY(x)						(((x) & BIT_MASK_DW_PCIE_L0S_ENTRANCE_LATENCY) << BIT_SHIFT_DW_PCIE_L0S_ENTRANCE_LATENCY)

typedef enum _DW_PCIE_L0S_ENTRANCE_LATENCY_ {
	DW_PCIE_L0S_ENTRANCE_LATENCY_1US			= 0,
	DW_PCIE_L0S_ENTRANCE_LATENCY_2US			= 1,
	DW_PCIE_L0S_ENTRANCE_LATENCY_3US			= 2,
	DW_PCIE_L0S_ENTRANCE_LATENCY_4US			= 3,
	DW_PCIE_L0S_ENTRANCE_LATENCY_5US			= 4,
	DW_PCIE_L0S_ENTRANCE_LATENCY_6US			= 5,
	DW_PCIE_L0S_ENTRANCE_LATENCY_7US			= 6
}DW_PCIE_L0S_ENTRANCE_LATENCY, *PDW_PCIE_L0S_ENTRANCE_LATENCY;


#define BIT_SHIFT_DW_PCIE_L1_ENTRANCE_LATENCY							27
#define BIT_DW_PCIE_L1_ENTRANCE_LATENCY									BIT(BIT_SHIFT_DW_PCIE_L1_ENTRANCE_LATENCY)
#define BIT_MASK_DW_PCIE_L1_ENTRANCE_LATENCY							0x7
#define BIT_CTRL_DW_PCIE_L1_ENTRANCE_LATENCY(x)							(((x) & BIT_MASK_DW_PCIE_L1_ENTRANCE_LATENCY) << BIT_SHIFT_DW_PCIE_L1_ENTRANCE_LATENCY)

typedef enum _DW_PCIE_L1_ENTRANCE_LATENCY_ {
	DW_PCIE_L1_ENTRANCE_LATENCY_1US				= 0,
	DW_PCIE_L1_ENTRANCE_LATENCY_2US				= 1,
	DW_PCIE_L1_ENTRANCE_LATENCY_4US				= 2,
	DW_PCIE_L1_ENTRANCE_LATENCY_8US				= 3,
	DW_PCIE_L1_ENTRANCE_LATENCY_16US			= 4,
	DW_PCIE_L1_ENTRANCE_LATENCY_32US			= 5,
	DW_PCIE_L1_ENTRANCE_LATENCY_64US			= 6
}PCI_L1_ENTRANCE_LATENCY, *PPCI_L1_ENTRANCE_LATENCY;


/* PCIE Extended Register */
//2 REG_DW_PCIE_EXTENDED_REG_MDIO				0x00
#define BIT_SHIFT_DW_PCIE_MDIO_RDWR					0
#define BIT_DW_PCIE_MDIO_RDWR						BIT(BIT_SHIFT_DW_PCIE_MDIO_RDWR)
#define BIT_MASK_DW_PCIE_MDIO_RDWR					0x1
#define BIT_CTRL_DW_PCIE_MDIO_RDWR(x)				(((x) & BIT_MASK_DW_PCIE_MDIO_RDWR) << BIT_SHIFT_DW_PCIE_MDIO_RDWR)

#define BIT_SHIFT_DW_PCIE_MDIO_REGADDR				8
#define BIT_DW_PCIE_MDIO_REGADDR					BIT(BIT_SHIFT_DW_PCIE_MDIO_REGADDR)
#define BIT_MASK_DW_PCIE_MDIO_REGADDR				0x1f
#define BIT_CTRL_DW_PCIE_MDIO_REGADDR(x)			(((x) & BIT_MASK_DW_PCIE_MDIO_REGADDR) << BIT_SHIFT_DW_PCIE_MDIO_REGADDR)

#define BIT_SHIFT_DW_PCIE_MDIO_DATA					16
#define BIT_DW_PCIE_MDIO_DATA						BIT(BIT_SHIFT_DW_PCIE_MDIO_DATA)
#define BIT_MASK_DW_PCIE_MDIO_DATA					0xffff
#define BIT_CTRL_DW_PCIE_MDIO_DATA(x)				(((x) & BIT_MASK_DW_PCIE_MDIO_DATA) << BIT_SHIFT_DW_PCIE_MDIO_DATA)


//2 REG_DW_PCIE_EXTENDED_REG_PWRCR				0x08
#define BIT_SHIFT_DW_PCIE_APP_LTSSM_EN				0
#define BIT_DW_PCIE_APP_LTSSM_EN					BIT(BIT_SHIFT_DW_PCIE_APP_LTSSM_EN)
#define BIT_MASK_DW_PCIE_APP_LTSSM_EN				0x1
#define BIT_CTRL_DW_PCIE_APP_LTSSM_EN(x)			(((x) & BIT_MASK_DW_PCIE_APP_LTSSM_EN) << BIT_SHIFT_DW_PCIE_APP_LTSSM_EN)

#define BIT_SHIFT_DW_PCIE_PHY_SRST_N				7
#define BIT_DW_PCIE_PHY_SRST_N						BIT(BIT_SHIFT_DW_PCIE_PHY_SRST_N)
#define BIT_MASK_DW_PCIE_PHY_SRST_N					0x1
#define BIT_CTRL_DW_PCIE_PHY_SRST_N(x)				(((x) & BIT_MASK_DW_PCIE_PHY_SRST_N) << BIT_SHIFT_DW_PCIE_PHY_SRST_N)


#define BIT_SHIFT_DW_PCIE_APPS_PM_XMT_TURNOFF		9
#define BIT_DW_PCIE_APPS_PM_XMT_TURNOFF				BIT(BIT_SHIFT_DW_PCIE_APPS_PM_XMT_TURNOFF)
#define BIT_MASK_DW_PCIE_APPS_PM_XMT_TURNOFF		0x1
#define BIT_CTRL_DW_PCIE_APPS_PM_XMT_TURNOFF(x)		(((x) & BIT_MASK_DW_PCIE_APPS_PM_XMT_TURNOFF) << BIT_SHIFT_DW_PCIE_APPS_PM_XMT_TURNOFF)


//2 REG_DW_PCIE_EXTENDED_REG_IPCFG				0x0c
#define BIT_SHIFT_DW_PCIE_FUN_NUM					0
#define BIT_DW_PCIE_FUN_NUM							BIT(BIT_SHIFT_DW_PCIE_FUN_NUM)
#define BIT_MASK_DW_PCIE_FUN_NUM					0x7
#define BIT_CTRL_DW_PCIE_FUN_NUM(x)					(((x) & BIT_MASK_DW_PCIE_FUN_NUM) << BIT_SHIFT_DW_PCIE_FUN_NUM)

#define	BIT_SHIFT_DW_PCIE_DEV_NUM					3
#define BIT_DW_PCIE_DEV_NUM							BIT(BIT_SHIFT_DW_PCIE_DEV_NUM)
#define BIT_MASK_DW_PCIE_DEV_NUM					0x1f
#define BIT_CTRL_DW_PCIE_DEV_NUM(x)					(((x) & BIT_MASK_DW_PCIE_DEV_NUM) << BIT_SHIFT_DW_PCIE_DEV_NUM)

#define	BIT_SHIFT_DW_PCIE_BUS_NUM					8
#define BIT_DW_PCIE_BUS_NUM							BIT(BIT_SHIFT_DW_PCIE_BUS_NUM)
#define BIT_MASK_DW_PCIE_BUS_NUM					0xff
#define BIT_CTRL_DW_PCIE_BUS_NUM(x)					(((x) & BIT_MASK_DW_PCIE_BUS_NUM) << BIT_SHIFT_DW_PCIE_BUS_NUM)



typedef enum _DW_PCIE_BAR_MEM_IO_ {
	DW_PCIE_BAR_MEM_IO_MEM	= 0,
	DW_PCIE_BAR_MEM_IO_IO	= 1
}DW_PCIE_BAR_MEM_IO, *PDW_PCIE_BAR_MEM_IO;

typedef enum _DW_PCIE_BAR_TYPE_ {
	DW_PCIE_BAR_TYPE_32BIT_ADDRESS	= 0,
	DW_PCIE_BAR_TYPE_RESERVE_1		= 1,
	DW_PCIE_BAR_TYPE_64BIT_ADDRESS	= 2,
	DW_PCIE_BAR_TYPE_RESERVE_3		= 3
}DW_PCIE_BAR_TYPE, *PDW_PCIE_BAR_TYPE;


#endif //_PCIE_BASE_BIT_H_


