/*
 *  Routines to access hardware
 *
 *  Copyright (c) 2013 Realtek Semiconductor Corp.
 *
 *  This module is a confidential and proprietary property of RealTek and
 *  possession or use of this module requires written permission of RealTek.
 */

#ifndef _RTK_PWM_BIT_H_
#define _RTK_PWM_BIT_H_

//3 PWM control
#define BIT_PWM_EN			BIT(31)
#define BIT_SHIFT_PWM_EN 	31
#define BIT_MASK_PWM_EN 	0x1
#define BIT_CTRL_PWM_EN(x)	(((x) & BIT_MASK_PWM_EN) << BIT_SHIFT_PWM_EN)

#define BIT_PWM_GT_SEL		(((x) & BIT_MASK_PWM_GT_SEL) << BIT_SHIFT_PWM_GT_SEL)
#define BIT_SHIFT_PWM_GT_SEL 	24
#define BIT_MASK_PWM_GT_SEL 	0x7
#define BIT_CTRL_PWM_GT_SEL(x)	(((x) & BIT_MASK_PWM_GT_SEL) << BIT_SHIFT_PWM_GT_SEL)

#define BIT_PWM_DUTY			(((x) & BIT_MASK_PWM_DUTY) << BIT_SHIFT_PWM_DUTY)
#define BIT_SHIFT_PWM_DUTY 		12
#define BIT_MASK_PWM_DUTY		0x3FF
#define BIT_CTRL_PWM_DUTY(x)	(((x) & BIT_MASK_PWM_DUTY) << BIT_SHIFT_PWM_DUTY)

#define BIT_PWM_PERIOD			(((x) & BIT_MASK_PWM_PERIOD) << BIT_SHIFT_PWM_PERIOD)
#define BIT_SHIFT_PWM_PERIOD 	0
#define BIT_MASK_PWM_PERIOD		0x3FF
#define BIT_CTRL_PWM_PERIOD(x)	(((x) & BIT_MASK_PWM_PERIOD) << BIT_SHIFT_PWM_PERIOD)


//3 Timer event control
#if 0 //HAL API handled some repeated bit action
#define BIT_GT_EVT3_EN			BIT(31)
#define BIT_SHIFT_GT_EVT3_EN 	31
#define BIT_MASK_GT_EVT3_END	0x1
#define BIT_CTRL_GT_EVT3_EN(x)	((x) & BIT_MASK_GT_EVT3_END) << BIT_SHIFT_GT_EVT3_EN)

#define BIT_GT_EVT3_SRC_SEL			((x) & BIT_MASK_GT_EVT3_SRC_SEL) << BIT_SHIFT_GT_EVT3_SRC_SEL)
#define BIT_SHIFT_GT_EVT3_SRC_SEL 	28
#define BIT_MASK_GT_EVT3_SRC_SEL	0x7
#define BIT_CTRL_GT_EVT3_SRC_SEL(x)	((x) & BIT_MASK_GT_EVT3_SRC_SEL) << BIT_SHIFT_GT_EVT3_SRC_SEL)

#define BIT_GT_EVT3_PULSE_DUR			((x) & BIT_MASK_GT_EVT3_PULSE_DUR) << BIT_SHIFT_GT_EVT3_PULSE_DUR)
#define BIT_SHIFT_GT_EVT3_PULSE_DUR 	24
#define BIT_MASK_GT_EVT3_PULSE_DUR		0xF
#define BIT_CTRL_GT_EVT3_PULSE_DUR(x)	((x) & BIT_MASK_GT_EVT3_PULSE_DUR) << BIT_SHIFT_GT_EVT3_PULSE_DUR)

#define BIT_GT_EVT2_EN			BIT(23)
#define BIT_SHIFT_GT_EVT2_EN 	23
#define BIT_MASK_GT_EVT2_EN		0x1
#define BIT_CTRL_GT_EVT2_EN(x)	((x) & BIT_MASK_GT_EVT2_EN) << BIT_SHIFT_GT_EVT2_EN)

#define BIT_GT_EVT2_SRC_SEL			((x) & BIT_MASK_GT_EVT2_SRC_SEL) << BIT_SHIFT_GT_EVT2_SRC_SEL)
#define BIT_SHIFT_GT_EVT2_SRC_SEL 	20
#define BIT_MASK_GT_EVT2_SRC_SEL	0x7
#define BIT_CTRL_GT_EVT2_SRC_SEL(x)	((x) & BIT_MASK_GT_EVT2_SRC_SEL) << BIT_SHIFT_GT_EVT2_SRC_SEL)

#define BIT_GT_EVT2_PULSE_DUR			((x) & BIT_MASK_GT_EVT2_PULSE_DUR) << BIT_SHIFT_GT_EVT2_PULSE_DUR)
#define BIT_SHIFT_GT_EVT2_PULSE_DUR 	16
#define BIT_MASK_GT_EVT2_PULSE_DUR		0xF
#define BIT_CTRL_GT_EVT2_PULSE_DUR(x)	((x) & BIT_MASK_GT_EVT2_PULSE_DUR) << BIT_SHIFT_GT_EVT2_PULSE_DUR)

#define BIT_GT_EVT1_EN			BIT(15)
#define BIT_SHIFT_GT_EVT1_EN 	15
#define BIT_MASK_GT_EVT1_EN		0x1
#define BIT_CTRL_GT_EVT1_EN(x)	((x) & BIT_MASK_GT_EVT1_EN) << BIT_SHIFT_GT_EVT1_EN)

#define BIT_GT_EVT1_SRC_SEL			((x) & BIT_MASK_GT_EVT1_SRC_SEL) << BIT_SHIFT_GT_EVT1_SRC_SEL)
#define BIT_SHIFT_GT_EVT1_SRC_SEL 	12
#define BIT_MASK_GT_EVT1_SRC_SEL	0x7
#define BIT_CTRL_GT_EVT1_SRC_SEL(x)	((x) & BIT_MASK_GT_EVT1_SRC_SEL) << BIT_SHIFT_GT_EVT1_SRC_SEL)

#define BIT_GT_EVT1_PULSE_DUR			((x) & BIT_MASK_GT_EVT1_PULSE_DUR) << BIT_SHIFT_GT_EVT1_PULSE_DUR)
#define BIT_SHIFT_GT_EVT1_PULSE_DUR 	8
#define BIT_MASK_GT_EVT1_PULSE_DUR		0xF
#define BIT_CTRL_GT_EVT1_PULSE_DUR(x)	((x) & BIT_MASK_GT_EVT1_PULSE_DUR) << BIT_SHIFT_GT_EVT1_PULSE_DUR)

#define BIT_GT_EVT0_EN			BIT(7)
#define BIT_SHIFT_GT_EVT0_EN 	7
#define BIT_MASK_GT_EVT0_EN		0x1
#define BIT_CTRL_GT_EVT0_EN(x)	((x) & BIT_MASK_GT_EVT0_EN) << BIT_SHIFT_GT_EVT0_EN)

#define BIT_GT_EVT0_SRC_SEL			((x) & BIT_MASK_GT_EVT0_SRC_SEL) << BIT_SHIFT_GT_EVT0_SRC_SEL)
#define BIT_SHIFT_GT_EVT0_SRC_SEL 	4
#define BIT_MASK_GT_EVT0_SRC_SEL	0x7
#define BIT_CTRL_GT_EVT0_SRC_SEL(x)	((x) & BIT_MASK_GT_EVT0_SRC_SEL) << BIT_SHIFT_GT_EVT0_SRC_SEL)

#define BIT_GT_EVT0_PULSE_DUR			((x) & BIT_MASK_GT_EVT0_PULSE_DUR) << BIT_SHIFT_GT_EVT0_PULSE_DUR)
#define BIT_SHIFT_GT_EVT0_PULSE_DUR 	0
#define BIT_MASK_GT_EVT0_PULSE_DUR		0xF
#define BIT_CTRL_GT_EVT0_PULSE_DUR(x)	((x) & BIT_MASK_GT_EVT0_PULSE_DUR) << BIT_SHIFT_GT_EVT0_PULSE_DUR)

#endif


#define BIT_GT_EVT_EN			BIT(7)
#define BIT_SHIFT_GT_EVT_EN 	7
#define BIT_MASK_GT_EVT_EN		0x1
#define BIT_CTRL_GT_EVT_EN(x)	(((x) & BIT_MASK_GT_EVT_EN) << BIT_SHIFT_GT_EVT_EN)

#define BIT_GT_EVT_SRC_SEL			(((x) & BIT_MASK_GT_EVT_SRC_SEL) << BIT_SHIFT_GT_EVT_SRC_SEL)
#define BIT_SHIFT_GT_EVT_SRC_SEL 	4
#define BIT_MASK_GT_EVT_SRC_SEL	0x7
#define BIT_CTRL_GT_EVT_SRC_SEL(x)	(((x) & BIT_MASK_GT_EVT_SRC_SEL) << BIT_SHIFT_GT_EVT_SRC_SEL)

#define BIT_GT_EVT_PULSE_DUR			(((x) & BIT_MASK_GT_EVT_PULSE_DUR) << BIT_SHIFT_GT_EVT_PULSE_DUR)
#define BIT_SHIFT_GT_EVT_PULSE_DUR 	0
#define BIT_MASK_GT_EVT_PULSE_DUR		0xF
#define BIT_CTRL_GT_EVT_PULSE_DUR(x)	(((x) & BIT_MASK_GT_EVT_PULSE_DUR) << BIT_SHIFT_GT_EVT_PULSE_DUR)


#endif

