#ifndef __SCFG_H__
#define __SCFG_H__

#include "ca_types.h"

#define NEED_INIT   1
//#define scfg_debug    1

#define CA_SCFG_DEF         "/rom/config/scfg.txt"
#define CA_SCFG_CUR         "/config/scfg.txt"
#define CA_SCFG_FILENAME_LEN        (32)
#define CA_SCFG_VERSION         (1)
#define CA_SCFG_ASCII_CHECK_LEN     (16)

#define CFG_ID_STRING_LEN       (256)   /*KEY_STRING_LEN_MAX */
#define CFG_ID_VALUE_LEN        (512)   /*KEY_VALUE_LEN_MAX */
#define CFG_ID_PHY_BASE_ADDR_LEN    (7)
#define CFG_ID_PHY_INTERFACE_LEN    (7)
#define CFG_ID_UNI_CONNECTION_LEN   (7)
#define CFG_ID_LPID_CPU_PORT_OWNER_LEN  (8)
#define CFG_ID_L3QM_EQ_PROFILE_A53_ID_PORTS_LEN     (6)
#define CFG_ID_L3QM_EQ_PROFILE_DQ_ID_PORTS_LEN      (6)
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_ID_PORTS_LEN  (16)
#define CFG_ID_L3QM_EQ_CFG3_VALUES_LEN          (16)
#define CFG_ID_L3QM_EQ_CFG4_VALUES_LEN          (16)
#define CFG_ID_L3QM_AXI_ATTRIB_EQ_VALUES_LEN        (16)
#define CFG_ID_L3QM_AXI_ATTRIB_CPU256_EPP_VALUES_LEN    (32)
#define CFG_ID_L3QM_AXI_ATTRIB_A53_EPP_VALUES_LEN   (8)
#define CFG_ID_FLOODING_DOMAIN_LEN          (8)
#define CFG_ID_FAKE_WAN_MC_VID_LEN          (16)
#define CFG_ID_L3TE_PROFILE_THRSH_VALUES_LEN        (2)
#define CFG_ID_NE_INTF_PORTS_LEN            (8)
#define CFG_ID_NE_RX_LDPID_LEN              (8)
#define CFG_ID_NE_TX_LDPID_LEN              (8)
#define CFG_ID_LOID_LEN                 (24)
#define CFG_ID_PASSWD_LEN               (12)
#define CFG_ID_GPON_VERSION_LEN             (14)
#define CFG_ID_PON_VENDOR_ID_LEN        (4)
#define CFG_ID_GPON_REG_ID_LEN          (32)
#define CFG_ID_GPON_EQ_ID_LEN               (20)
#define CFG_ID_ISP_TYPE_LEN                 (20)
#define CFG_ID_L2FE_VLAN_IS_S_LEN           (32)
#define CFG_ID_OLT_TYPE_LEN                 (32)
#define CFG_ID_NE_DMA_TO_L3FE_LEN           (8)
#define CFG_ID_ETH_ADMIN_LAYER_LEN          (3)


/* API document CFG ID */
#define CFG_ID_DEV_MODE                 "CFG_ID_DEV_MODE"
#define CFG_ID_MAC_ADDRESS              "CFG_ID_MAC_ADDRESS"
#define CFG_ID_PHY_BASE_ADDR                "CFG_ID_PHY_BASE_ADDR"
#define CFG_ID_PHY_INTERFACE                "CFG_ID_PHY_INTERFACE"
#define CFG_ID_UNI_CONNECTION               "CFG_ID_UNI_CONNECTION"
#define CFG_ID_LPID_CPU_PORT_OWNER          "CFG_ID_LPID_CPU_PORT_OWNER"
#define CFG_ID_WAN_PORT_ID              "CFG_ID_WAN_PORT_ID"
#define CFG_ID_FAKE_WAN_MC_VID              "CFG_ID_FAKE_WAN_MC_VID"
#define CFG_ID_GPIO_VALID               "CFG_ID_GPIO_VALID"
#define CFG_ID_GPIO_INTPIN              "CFG_ID_GPIO_INTPIN"
#define CFG_ID_GPIO_INTLVL              "CFG_ID_GPIO_INTLVL"
#define CFG_ID_GPIO_CONFIG              "CFG_ID_GPIO_CONFIG"
#define CFG_ID_GPIO_OUTVAL              "CFG_ID_GPIO_OUTVAL"
#define CFG_ID_L3QM_USE_FBM             "CFG_ID_L3QM_USE_FBM"
#define CFG_ID_DATAPATH_MODE                "CFG_ID_DATAPATH_MODE"
#define CFG_ID_API_VERSION              "CFG_ID_API_VERSION"

#ifndef CONFIG_CORTINA_BOARD_SATURN_SFU_TITAN
#define CFG_ID_NE_NUM_INTF              "CFG_ID_NE_NUM_INTF"
#define CFG_ID_NE_MAC_ADDR0             "CFG_ID_NE_MAC_ADDR0"
#define CFG_ID_NE_MAC_ADDR1             "CFG_ID_NE_MAC_ADDR1"
#define CFG_ID_NE_MAC_ADDR2             "CFG_ID_NE_MAC_ADDR2"
#define CFG_ID_NE_MAC_ADDR3             "CFG_ID_NE_MAC_ADDR3"
#define CFG_ID_NE_MAC_ADDR4             "CFG_ID_NE_MAC_ADDR4"
#define CFG_ID_NE_MAC_ADDR5             "CFG_ID_NE_MAC_ADDR5"
#define CFG_ID_NE_MAC_ADDR6             "CFG_ID_NE_MAC_ADDR6"
#define CFG_ID_NE_MAC_ADDR7             "CFG_ID_NE_MAC_ADDR7"
#define CFG_ID_NE_INTF_PORTS0               "CFG_ID_NE_INTF_PORTS0"
#define CFG_ID_NE_INTF_PORTS1               "CFG_ID_NE_INTF_PORTS1"
#define CFG_ID_NE_INTF_PORTS2               "CFG_ID_NE_INTF_PORTS2"
#define CFG_ID_NE_INTF_PORTS3               "CFG_ID_NE_INTF_PORTS3"
#define CFG_ID_NE_INTF_PORTS4               "CFG_ID_NE_INTF_PORTS4"
#define CFG_ID_NE_INTF_PORTS5               "CFG_ID_NE_INTF_PORTS5"
#define CFG_ID_NE_INTF_PORTS6               "CFG_ID_NE_INTF_PORTS6"
#define CFG_ID_NE_INTF_PORTS7               "CFG_ID_NE_INTF_PORTS7"
#define CFG_ID_NE_RX_LDPID              "CFG_ID_NE_RX_LDPID"
#define CFG_ID_NE_TX_LDPID              "CFG_ID_NE_TX_LDPID"

#define CFG_ID_NE_SRAM_PHY_BASE             "CFG_ID_NE_SRAM_PHY_BASE"
#define CFG_ID_NE_DDR_COHERENT_PHY_BASE         "CFG_ID_NE_DDR_COHERENT_PHY_BASE"
#define CFG_ID_NE_DDR_NONCACHE_PHY_BASE         "CFG_ID_NE_DDR_NONCACHE_PHY_BASE"
#define CFG_ID_NE_SRAM_RESERVED_SIZE            "CFG_ID_NE_SRAM_RESERVED_SIZE"
#define CFG_ID_NE_DDR_COHERENT_RESERVED_SIZE        "CFG_ID_NE_DDR_COHERENT_RESERVED_SIZE"
#define CFG_ID_NE_DDR_NONCACHE_RESERVED_SIZE        "CFG_ID_NE_DDR_NONCACHE_RESERVED_SIZE"

#define CFG_ID_HASHLITE_HT_SIZE             "CFG_ID_HASHLITE_HT_SIZE"
#define CFG_ID_NAT_AGING_TIME               "CFG_ID_NAT_AGING_TIME"
#define CFG_ID_NEXTHOP_AGING_TIME           "CFG_ID_NEXTHOP_AGING_TIME"

#define CFG_ID_LPM_IPV4_PROFILE_0_START         "CFG_ID_LPM_IPV4_PROFILE_0_START"
#define CFG_ID_LPM_IPV4_PROFILE_0_END           "CFG_ID_LPM_IPV4_PROFILE_0_END"
#define CFG_ID_LPM_IPV4_PROFILE_1_START         "CFG_ID_LPM_IPV4_PROFILE_1_START"
#define CFG_ID_LPM_IPV4_PROFILE_1_END           "CFG_ID_LPM_IPV4_PROFILE_1_END"
#define CFG_ID_LPM_IPV4_PROFILE_2_START         "CFG_ID_LPM_IPV4_PROFILE_2_START"
#define CFG_ID_LPM_IPV4_PROFILE_2_END           "CFG_ID_LPM_IPV4_PROFILE_2_END"
#define CFG_ID_LPM_IPV4_PROFILE_3_START         "CFG_ID_LPM_IPV4_PROFILE_3_START"
#define CFG_ID_LPM_IPV4_PROFILE_3_END           "CFG_ID_LPM_IPV4_PROFILE_3_END"
#define CFG_ID_LPM_IPV6_PROFILE_0_START         "CFG_ID_LPM_IPV6_PROFILE_0_START"
#define CFG_ID_LPM_IPV6_PROFILE_0_END           "CFG_ID_LPM_IPV6_PROFILE_0_END"
#define CFG_ID_LPM_IPV6_PROFILE_1_START         "CFG_ID_LPM_IPV6_PROFILE_1_START"
#define CFG_ID_LPM_IPV6_PROFILE_1_END           "CFG_ID_LPM_IPV6_PROFILE_1_END"
#define CFG_ID_LPM_IPV6_PROFILE_2_START         "CFG_ID_LPM_IPV6_PROFILE_2_START"
#define CFG_ID_LPM_IPV6_PROFILE_2_END           "CFG_ID_LPM_IPV6_PROFILE_2_END"
#define CFG_ID_LPM_IPV6_PROFILE_3_START         "CFG_ID_LPM_IPV6_PROFILE_3_START"
#define CFG_ID_LPM_IPV6_PROFILE_3_END           "CFG_ID_LPM_IPV6_PROFILE_3_END"
#define CFG_ID_LPM_IPV4_DEFAULT_T4CTRL_0        "CFG_ID_LPM_IPV4_DEFAULT_T4CTRL_0"
#define CFG_ID_LPM_IPV4_DEFAULT_T4CTRL_1        "CFG_ID_LPM_IPV4_DEFAULT_T4CTRL_1"
#define CFG_ID_LPM_IPV6_DEFAULT_T4CTRL_0        "CFG_ID_LPM_IPV6_DEFAULT_T4CTRL_0"
#define CFG_ID_LPM_IPV6_DEFAULT_T4CTRL_1        "CFG_ID_LPM_IPV6_DEFAULT_T4CTRL_1"

#define CFG_ID_L3QM_MAGIC_MARKER_LEN            "CFG_ID_L3QM_MAGIC_MARKER_LEN"
#define CFG_ID_L3QM_DESC_SIZE               "CFG_ID_L3QM_DESC_SIZE"
#define CFG_ID_L3QM_DESC_PER_EPP            "CFG_ID_L3QM_DESC_PER_EPP"
#define CFG_ID_L3QM_PE0_1_PORT_COUNT            "CFG_ID_L3QM_PE0_1_PORT_COUNT"
#define CFG_ID_L3QM_PE0_1_VOQ_PER_PORT          "CFG_ID_L3QM_PE0_1_VOQ_PER_PORT"
#define CFG_ID_L3QM_PE0_1_EPP_PER_VOQ           "CFG_ID_L3QM_PE0_1_EPP_PER_VOQ"
#define CFG_ID_L3QM_PE0_1_POOL_BID_COUNT        "CFG_ID_L3QM_PE0_1_POOL_BID_COUNT"
#define CFG_ID_L3QM_CPU256_PORT_COUNT           "CFG_ID_L3QM_CPU256_PORT_COUNT"
#define CFG_ID_L3QM_CPU256_VOQ_PER_PORT         "CFG_ID_L3QM_CPU256_VOQ_PER_PORT"
#define CFG_ID_L3QM_CPU256_EPP_PER_VOQ          "CFG_ID_L3QM_CPU256_EPP_PER_VOQ"
#define CFG_ID_L3QM_CPU256_POOL_BID_COUNT       "CFG_ID_L3QM_CPU256_POOL_BID_COUNT"
#define CFG_ID_L3QM_A53_PORT_COUNT          "CFG_ID_L3QM_A53_PORT_COUNT"
#define CFG_ID_L3QM_A53_VOQ_PER_PORT            "CFG_ID_L3QM_A53_VOQ_PER_PORT"
#define CFG_ID_L3QM_A53_EPP_PER_VOQ         "CFG_ID_L3QM_A53_EPP_PER_VOQ"
#define CFG_ID_L3QM_A53_POOL_BID_COUNT          "CFG_ID_L3QM_A53_POOL_BID_COUNT"
#define CFG_ID_L3QM_DEEPQ_POOL_BID_COUNT        "CFG_ID_L3QM_DEEPQ_POOL_BID_COUNT"
#define CFG_ID_L3QM_A53_CACHE_LINE_SIZE         "CFG_ID_L3QM_A53_CACHE_LINE_SIZE"
#define CFG_ID_L3QM_PE_BUFFER_ALIGN_SIZE        "CFG_ID_L3QM_PE_BUFFER_ALIGN_SIZE"
#define CFG_ID_L3QM_EQ_BUFFER_ALIGN_SIZE        "CFG_ID_L3QM_EQ_BUFFER_ALIGN_SIZE"

#define CFG_ID_L3QM_EQ_PROFILE_PE0_ID           "CFG_ID_L3QM_EQ_PROFILE_PE0_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_RULE         "CFG_ID_L3QM_EQ_PROFILE_PE0_RULE"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_USE_FBM      "CFG_ID_L3QM_EQ_PROFILE_PE0_USE_FBM"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_EQ_ID      "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BUF_COUNT  "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BID_START  "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BUF_SZ     "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_LOCATION   "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_FBM_POOL_ID    "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_EQ_ID      "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BUF_COUNT  "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BID_START  "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BUF_SZ     "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_LOCATION   "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_FBM_POOL_ID    "CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE0_ID_PORTS     "CFG_ID_L3QM_EQ_PROFILE_PE0_ID_PORTS"
#define CFG_ID_L3QM_EPP_PROFILE_PE0_ID          "CFG_ID_L3QM_EPP_PROFILE_PE0_ID"
#define CFG_ID_L3QM_EPP_PROFILE_PE0_SZ          "CFG_ID_L3QM_EPP_PROFILE_PE0_SZ"
#define CFG_ID_L3QM_EPP_PROFILE_PE0_CN          "CFG_ID_L3QM_EPP_PROFILE_PE0_CN"
#define CFG_ID_L3QM_EPP_PROFILE_PE0_MAP_MODE        "CFG_ID_L3QM_EPP_PROFILE_PE0_MAP_MODE"

#define CFG_ID_L3QM_EQ_PROFILE_PE1_ID           "CFG_ID_L3QM_EQ_PROFILE_PE1_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_RULE         "CFG_ID_L3QM_EQ_PROFILE_PE1_RULE"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_USE_FBM      "CFG_ID_L3QM_EQ_PROFILE_PE1_USE_FBM"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_EQ_ID      "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BUF_COUNT  "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BID_START  "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BUF_SZ     "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_LOCATION   "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_FBM_POOL_ID    "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_EQ_ID      "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BUF_COUNT  "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BID_START  "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BUF_SZ     "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_LOCATION   "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_FBM_POOL_ID    "CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_PE1_ID_PORTS     "CFG_ID_L3QM_EQ_PROFILE_PE1_ID_PORTS"
#define CFG_ID_L3QM_EPP_PROFILE_PE1_ID          "CFG_ID_L3QM_EPP_PROFILE_PE1_ID"
#define CFG_ID_L3QM_EPP_PROFILE_PE1_SZ          "CFG_ID_L3QM_EPP_PROFILE_PE1_SZ"
#define CFG_ID_L3QM_EPP_PROFILE_PE1_CN          "CFG_ID_L3QM_EPP_PROFILE_PE1_CN"
#define CFG_ID_L3QM_EPP_PROFILE_PE1_MAP_MODE        "CFG_ID_L3QM_EPP_PROFILE_PE1_MAP_MODE"

#define CFG_ID_L3QM_EQ_PROFILE_A53_ID           "CFG_ID_L3QM_EQ_PROFILE_A53_ID"
#define CFG_ID_L3QM_EQ_PROFILE_A53_RULE         "CFG_ID_L3QM_EQ_PROFILE_A53_RULE"
#define CFG_ID_L3QM_EQ_PROFILE_A53_USE_FBM      "CFG_ID_L3QM_EQ_PROFILE_A53_USE_FBM"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_EQ_ID      "CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BUF_COUNT  "CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BID_START  "CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BUF_SZ     "CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_LOCATION   "CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_FBM_POOL_ID    "CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_EQ_ID      "CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BUF_COUNT  "CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BID_START  "CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BUF_SZ     "CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_LOCATION   "CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_FBM_POOL_ID    "CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_A53_ID_PORTS     "CFG_ID_L3QM_EQ_PROFILE_A53_ID_PORTS"
#define CFG_ID_L3QM_EPP_PROFILE_A53_ID          "CFG_ID_L3QM_EPP_PROFILE_A53_ID"
#define CFG_ID_L3QM_EPP_PROFILE_A53_SZ          "CFG_ID_L3QM_EPP_PROFILE_A53_SZ"
#define CFG_ID_L3QM_EPP_PROFILE_A53_CN          "CFG_ID_L3QM_EPP_PROFILE_A53_CN"
#define CFG_ID_L3QM_EPP_PROFILE_A53_MAP_MODE        "CFG_ID_L3QM_EPP_PROFILE_A53_MAP_MODE"

#define CFG_ID_L3QM_EQ_PROFILE_DQ_ID            "CFG_ID_L3QM_EQ_PROFILE_DQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_RULE          "CFG_ID_L3QM_EQ_PROFILE_DQ_RULE"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_USE_FBM       "CFG_ID_L3QM_EQ_PROFILE_DQ_USE_FBM"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_EQ_ID       "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BUF_COUNT   "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BID_START   "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BUF_SZ      "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_LOCATION    "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_FBM_POOL_ID "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_EQ_ID       "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BUF_COUNT   "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BID_START   "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BUF_SZ      "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_LOCATION    "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_FBM_POOL_ID "CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_DQ_ID_PORTS      "CFG_ID_L3QM_EQ_PROFILE_DQ_ID_PORTS"
#define CFG_ID_L3QM_EPP_PROFILE_DQ_ID           "CFG_ID_L3QM_EPP_PROFILE_DQ_ID"
#define CFG_ID_L3QM_EPP_PROFILE_DQ_SZ           "CFG_ID_L3QM_EPP_PROFILE_DQ_SZ"

#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_ID         "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_RULE           "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_RULE"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_USE_FBM        "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_USE_FBM"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_EQ_ID        "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BUF_COUNT    "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BID_START    "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BUF_SZ       "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_LOCATION     "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_FBM_POOL_ID  "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_EQ_ID        "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BUF_COUNT    "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BID_START    "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BUF_SZ       "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_LOCATION     "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_FBM_POOL_ID  "CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_ID_PORTS          "CFG_ID_L3QM_EQ_PROFILE_CPU256_ID_PORTS"
#define CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_ID            "CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_ID"
#define CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_SZ            "CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_SZ"
#define CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_CN            "CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_CN"
#define CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_MAP_MODE      "CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_MAP_MODE"

#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_ID         "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_RULE           "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_RULE"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_USE_FBM        "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_USE_FBM"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_EQ_ID        "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BUF_COUNT    "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BID_START    "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BUF_SZ       "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_LOCATION     "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_FBM_POOL_ID  "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_FBM_POOL_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_EQ_ID        "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_EQ_ID"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BUF_COUNT    "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BUF_COUNT"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BID_START    "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BID_START"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BUF_SZ       "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BUF_SZ"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_LOCATION     "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_LOCATION"
#define CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_FBM_POOL_ID  "CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_FBM_POOL_ID"
#define CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_ID            "CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_ID"
#define CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_SZ            "CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_SZ"
#define CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_CN            "CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_CN"
#define CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_MAP_MODE      "CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_MAP_MODE"

#define CFG_ID_L3FE_MAIN_HASH_OVERFLOW_FIB_LENGTH       "CFG_ID_L3FE_MAIN_HASH_OVERFLOW_FIB_LENGTH"
#define CFG_ID_L3FE_MAIN_HASH_OVERFLOW_FIB_COUNT        "CFG_ID_L3FE_MAIN_HASH_OVERFLOW_FIB_COUNT"
#define CFG_ID_L3FE_MAIN_HASH_DEFAULT_HASH_FIB_LENGTH       "CFG_ID_L3FE_MAIN_HASH_DEFAULT_HASH_FIB_LENGTH"
#define CFG_ID_L3FE_MAIN_HASH_DEFAULT_HASH_FIB_COUNT        "CFG_ID_L3FE_MAIN_HASH_DEFAULT_HASH_FIB_COUNT"
#define CFG_ID_L3FE_MAIN_HASH_ACTION_CACHE_FIB_LENGTH       "CFG_ID_L3FE_MAIN_HASH_ACTION_CACHE_FIB_LENGTH"
#define CFG_ID_L3FE_MAIN_HASH_ACTION_CACHE_FIB_COUNT        "CFG_ID_L3FE_MAIN_HASH_ACTION_CACHE_FIB_COUNT"
#define CFG_ID_L3FE_MAIN_HASH_TABLE_ENTRY_LENGTH        "CFG_ID_L3FE_MAIN_HASH_TABLE_ENTRY_LENGTH"
#define CFG_ID_L3FE_MAIN_HASH_TABLE_ENTRY_COUNT         "CFG_ID_L3FE_MAIN_HASH_TABLE_ENTRY_COUNT"
#define CFG_ID_L3FE_MAIN_HASH_ACTION_TABLE_ENTRY_LENGTH     "CFG_ID_L3FE_MAIN_HASH_ACTION_TABLE_ENTRY_LENGTH"
#define CFG_ID_L3FE_MAIN_HASH_ACTION_TABLE_ENTRY_COUNT      "CFG_ID_L3FE_MAIN_HASH_ACTION_TABLE_ENTRY_COUNT"

#define CFG_ID_L3FE_T5_CTRL_SUPPORT             "CFG_ID_L3FE_T5_CTRL_SUPPORT"

#define CFG_ID_L3QM_NI_P0_7_DEEP_Q_EN           "CFG_ID_L3QM_NI_P0_7_DEEP_Q_EN"
#define CFG_ID_L3QM_ACP_ENABLE              "CFG_ID_L3QM_ACP_ENABLE"

#define CFG_ID_L3QM_CCI0_START_ADDR         "CFG_ID_L3QM_CCI0_START_ADDR"
#define CFG_ID_L3QM_CCI1_START_ADDR         "CFG_ID_L3QM_CCI1_START_ADDR"
#define CFG_ID_L3QM_SRAM_START_ADDR         "CFG_ID_L3QM_SRAM_START_ADDR"
#define CFG_ID_L3QM_DDR_CACHE_COHERENT_START_ADDR   "CFG_ID_L3QM_DDR_CACHE_COHERENT_START_ADDR"
#define CFG_ID_L3QM_DDR_NON_CACHE_START_ADDR        "CFG_ID_L3QM_DDR_NON_CACHE_START_ADDR"
#define CFG_ID_L3QM_EQ_AXI_TOP8_BITS            "CFG_ID_L3QM_EQ_AXI_TOP8_BITS"
#define CFG_ID_L3QM_EPP_AXI_TOP8_BITS           "CFG_ID_L3QM_EPP_AXI_TOP8_BITS"

#define CFG_ID_L3QM_CPU_PORT_HEAD_ROOM_FIRST        "CFG_ID_L3QM_CPU_PORT_HEAD_ROOM_FIRST"

#define CFG_ID_L3QM_EQ_CFG3_VALUES          "CFG_ID_L3QM_EQ_CFG3_VALUES"
#define CFG_ID_L3QM_EQ_CFG4_VALUES          "CFG_ID_L3QM_EQ_CFG4_VALUES"
#define CFG_ID_L3QM_AXI_ATTRIB_EQ_VALUES        "CFG_ID_L3QM_AXI_ATTRIB_EQ_VALUES"
#define CFG_ID_L3QM_AXI_ATTRIB_CPU256_EPP_VALUES    "CFG_ID_L3QM_AXI_ATTRIB_CPU256_EPP_VALUES"
#define CFG_ID_L3QM_AXI_ATTRIB_A53_EPP_VALUES       "CFG_ID_L3QM_AXI_ATTRIB_A53_EPP_VALUES"

#define CFG_ID_FLOODING_DOMAIN_1            "CFG_ID_FLOODING_DOMAIN_1"
#define CFG_ID_FLOODING_DOMAIN_2            "CFG_ID_FLOODING_DOMAIN_2"

#define CFG_ID_L3_CLASSIFIER_PROFILE_WAN        "CFG_ID_L3_CLASSIFIER_PROFILE_WAN"
#define CFG_ID_L3_CLASSIFIER_PROFILE_LAN        "CFG_ID_L3_CLASSIFIER_PROFILE_LAN"
#define CFG_ID_L3_MAIN_HASH_PROFILE_WAN         "CFG_ID_L3_MAIN_HASH_PROFILE_WAN"
#define CFG_ID_L3_MAIN_HASH_PROFILE_LAN         "CFG_ID_L3_MAIN_HASH_PROFILE_LAN"
#define CFG_ID_L3_MAIN_HASH_PROFILE_MC          "CFG_ID_L3_MAIN_HASH_PROFILE_MC"
#define CFG_ID_L3_MAIN_HASH_PROFILE_CLASS       "CFG_ID_L3_MAIN_HASH_PROFILE_CLASS"
#define CFG_ID_L3_HASH_LITE_PROFILE         "CFG_ID_L3_HASH_LITE_PROFILE"
#define CFG_ID_NAT_ENABLE               "CFG_ID_NAT_ENABLE"
#define CFG_ID_FLOW_SUPPORT             "CFG_ID_FLOW_SUPPORT"

#define CFG_ID_L3QM_DEEPQ_TEST_WITH_SRAM        "CFG_ID_L3QM_DEEPQ_TEST_WITH_SRAM"
#define CFG_ID_L3QM_ACE_TEST                "CFG_ID_L3QM_ACE_TEST"
#define CFG_ID_DMA_LSO_ACE_TEST             "CFG_ID_DMA_LSO_ACE_TEST"
#define CFG_ID_MAIN_HASH_BM_TEST            "CFG_ID_MAIN_HASH_BM_TEST"
#define CFG_ID_MAIN_HASH_BUCKET_SIZE            "CFG_ID_MAIN_HASH_BUCKET_SIZE"

#define CFG_ID_L2TE_GLB_THRSH_THL           "CFG_ID_L2TE_GLB_THRSH_THL"
#define CFG_ID_L2TE_GLB_THRSH_THH           "CFG_ID_L2TE_GLB_THRSH_THH"

#define CFG_ID_L2TE_GLB_PRI_THRSH0_THL          "CFG_ID_L2TE_GLB_PRI_THRSH0_THL"
#define CFG_ID_L2TE_GLB_PRI_THRSH1_THL          "CFG_ID_L2TE_GLB_PRI_THRSH1_THL"
#define CFG_ID_L2TE_GLB_PRI_THRSH2_THL          "CFG_ID_L2TE_GLB_PRI_THRSH2_THL"
#define CFG_ID_L2TE_GLB_PRI_THRSH3_THL          "CFG_ID_L2TE_GLB_PRI_THRSH3_THL"
#define CFG_ID_L2TE_GLB_PRI_THRSH4_THL          "CFG_ID_L2TE_GLB_PRI_THRSH4_THL"
#define CFG_ID_L2TE_GLB_PRI_THRSH5_THL          "CFG_ID_L2TE_GLB_PRI_THRSH5_THL"
#define CFG_ID_L2TE_GLB_PRI_THRSH6_THL          "CFG_ID_L2TE_GLB_PRI_THRSH6_THL"
#define CFG_ID_L2TE_GLB_PRI_THRSH7_THL          "CFG_ID_L2TE_GLB_PRI_THRSH7_THL"

#define CFG_ID_L2TE_GLB_PRI_THRSH0_THH          "CFG_ID_L2TE_GLB_PRI_THRSH0_THH"
#define CFG_ID_L2TE_GLB_PRI_THRSH1_THH          "CFG_ID_L2TE_GLB_PRI_THRSH1_THH"
#define CFG_ID_L2TE_GLB_PRI_THRSH2_THH          "CFG_ID_L2TE_GLB_PRI_THRSH2_THH"
#define CFG_ID_L2TE_GLB_PRI_THRSH3_THH          "CFG_ID_L2TE_GLB_PRI_THRSH3_THH"
#define CFG_ID_L2TE_GLB_PRI_THRSH4_THH          "CFG_ID_L2TE_GLB_PRI_THRSH4_THH"
#define CFG_ID_L2TE_GLB_PRI_THRSH5_THH          "CFG_ID_L2TE_GLB_PRI_THRSH5_THH"
#define CFG_ID_L2TE_GLB_PRI_THRSH6_THH          "CFG_ID_L2TE_GLB_PRI_THRSH6_THH"
#define CFG_ID_L2TE_GLB_PRI_THRSH7_THH          "CFG_ID_L2TE_GLB_PRI_THRSH7_THH"

#define CFG_ID_L2TE_PORT_THRSH_PROFILE_0_THL        "CFG_ID_L2TE_PORT_THRSH_PROFILE_0_THL"
#define CFG_ID_L2TE_PORT_THRSH_PROFILE_1_THL        "CFG_ID_L2TE_PORT_THRSH_PROFILE_1_THL"
#define CFG_ID_L2TE_PORT_THRSH_PROFILE_2_THL        "CFG_ID_L2TE_PORT_THRSH_PROFILE_2_THL"
#define CFG_ID_L2TE_PORT_THRSH_PROFILE_3_THL        "CFG_ID_L2TE_PORT_THRSH_PROFILE_3_THL"

#define CFG_ID_L2TE_PORT_THRSH_PROFILE_0_THH        "CFG_ID_L2TE_PORT_THRSH_PROFILE_0_THH"
#define CFG_ID_L2TE_PORT_THRSH_PROFILE_1_THH        "CFG_ID_L2TE_PORT_THRSH_PROFILE_1_THH"
#define CFG_ID_L2TE_PORT_THRSH_PROFILE_2_THH        "CFG_ID_L2TE_PORT_THRSH_PROFILE_2_THH"
#define CFG_ID_L2TE_PORT_THRSH_PROFILE_3_THH        "CFG_ID_L2TE_PORT_THRSH_PROFILE_3_THH"

#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_0_THL     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_0_THL"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_1_THL     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_1_THL"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_2_THL     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_2_THL"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_3_THL     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_3_THL"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_4_THL     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_4_THL"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_5_THL     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_5_THL"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_6_THL     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_6_THL"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_7_THL     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_7_THL"

#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_0_THH     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_0_THH"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_1_THH     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_1_THH"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_2_THH     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_2_THH"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_3_THH     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_3_THH"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_4_THH     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_4_THH"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_5_THH     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_5_THH"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_6_THH     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_6_THH"
#define CFG_ID_L2TE_VOQ_THRSH_PROFILE_7_THH     "CFG_ID_L2TE_VOQ_THRSH_PROFILE_7_THH"

#define CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_0_THL    "CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_0_THL"
#define CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_1_THL    "CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_1_THL"
#define CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_2_THL    "CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_2_THL"
#define CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_3_THL    "CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_3_THL"

#define CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_0_THH    "CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_0_THH"
#define CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_1_THH    "CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_1_THH"
#define CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_2_THH    "CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_2_THH"
#define CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_3_THH    "CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_3_THH"

#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS0_THL "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS0_THL"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS1_THL "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS1_THL"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS2_THL "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS2_THL"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS3_THL "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS3_THL"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS4_THL "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS4_THL"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS5_THL "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS5_THL"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS6_THL "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS6_THL"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS7_THL "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS7_THL"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS0_THL "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS0_THL"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS1_THL "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS1_THL"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS2_THL "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS2_THL"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS3_THL "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS3_THL"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS4_THL "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS4_THL"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS5_THL "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS5_THL"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS6_THL "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS6_THL"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS7_THL "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS7_THL"

#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS0_THH "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS0_THH"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS1_THH "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS1_THH"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS2_THH "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS2_THH"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS3_THH "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS3_THH"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS4_THH "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS4_THH"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS5_THH "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS5_THH"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS6_THH "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS6_THH"
#define CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS7_THH "CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS7_THH"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS0_THH "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS0_THH"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS1_THH "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS1_THH"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS2_THH "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS2_THH"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS3_THH "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS3_THH"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS4_THH "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS4_THH"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS5_THH "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS5_THH"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS6_THH "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS6_THH"
#define CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS7_THH "CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS7_THH"

#define CFG_ID_L2TE_DQSCH_EQ_PROFILE_THRSH0_THL     "CFG_ID_L2TE_DQSCH_EQ_PROFILE_THRSH0_THL"
#define CFG_ID_L2TE_DQSCH_EQ_PROFILE_THRSH0_THH     "CFG_ID_L2TE_DQSCH_EQ_PROFILE_THRSH0_THH"

#define CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_0_THL  "CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_0_THL"
#define CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_1_THL  "CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_1_THL"
#define CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_2_THL  "CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_2_THL"
#define CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_3_THL  "CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_3_THL"

#define CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_0_THH  "CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_0_THH"
#define CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_1_THH  "CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_1_THH"
#define CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_2_THH  "CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_2_THH"
#define CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_3_THH  "CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_3_THH"

#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_0_THL   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_0_THL"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_1_THL   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_1_THL"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_2_THL   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_2_THL"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_3_THL   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_3_THL"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_4_THL   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_4_THL"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_5_THL   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_5_THL"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_6_THL   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_6_THL"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_7_THL   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_7_THL"

#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_0_THH   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_0_THH"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_1_THH   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_1_THH"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_2_THH   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_2_THH"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_3_THH   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_3_THH"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_4_THH   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_4_THH"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_5_THH   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_5_THH"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_6_THH   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_6_THH"
#define CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_7_THH   "CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_7_THH"

#define CFG_ID_L3TE_PROFILE_THRSH_EQ0_TH0       "CFG_ID_L3TE_PROFILE_THRSH_EQ0_TH0"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ1_TH0       "CFG_ID_L3TE_PROFILE_THRSH_EQ1_TH0"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ2_TH0       "CFG_ID_L3TE_PROFILE_THRSH_EQ2_TH0"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ3_TH0       "CFG_ID_L3TE_PROFILE_THRSH_EQ3_TH0"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ4_TH0       "CFG_ID_L3TE_PROFILE_THRSH_EQ4_TH0"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ5_TH0       "CFG_ID_L3TE_PROFILE_THRSH_EQ5_TH0"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ6_TH0       "CFG_ID_L3TE_PROFILE_THRSH_EQ6_TH0"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ7_TH0       "CFG_ID_L3TE_PROFILE_THRSH_EQ7_TH0"

#define CFG_ID_L3TE_PROFILE_THRSH_EQ0_TH1       "CFG_ID_L3TE_PROFILE_THRSH_EQ0_TH1"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ1_TH1       "CFG_ID_L3TE_PROFILE_THRSH_EQ1_TH1"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ2_TH1       "CFG_ID_L3TE_PROFILE_THRSH_EQ2_TH1"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ3_TH1       "CFG_ID_L3TE_PROFILE_THRSH_EQ3_TH1"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ4_TH1       "CFG_ID_L3TE_PROFILE_THRSH_EQ4_TH1"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ5_TH1       "CFG_ID_L3TE_PROFILE_THRSH_EQ5_TH1"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ6_TH1       "CFG_ID_L3TE_PROFILE_THRSH_EQ6_TH1"
#define CFG_ID_L3TE_PROFILE_THRSH_EQ7_TH1       "CFG_ID_L3TE_PROFILE_THRSH_EQ7_TH1"

#define CFG_ID_L3TE_PORT_THRSH_PROFILE_0_LTH        "CFG_ID_L3TE_PORT_THRSH_PROFILE_0_LTH"
#define CFG_ID_L3TE_PORT_THRSH_PROFILE_1_LTH        "CFG_ID_L3TE_PORT_THRSH_PROFILE_1_LTH"
#define CFG_ID_L3TE_PORT_THRSH_PROFILE_2_LTH        "CFG_ID_L3TE_PORT_THRSH_PROFILE_2_LTH"
#define CFG_ID_L3TE_PORT_THRSH_PROFILE_3_LTH        "CFG_ID_L3TE_PORT_THRSH_PROFILE_3_LTH"

#define CFG_ID_L3TE_PORT_THRSH_PROFILE_0_HTH        "CFG_ID_L3TE_PORT_THRSH_PROFILE_0_HTH"
#define CFG_ID_L3TE_PORT_THRSH_PROFILE_1_HTH        "CFG_ID_L3TE_PORT_THRSH_PROFILE_1_HTH"
#define CFG_ID_L3TE_PORT_THRSH_PROFILE_2_HTH        "CFG_ID_L3TE_PORT_THRSH_PROFILE_2_HTH"
#define CFG_ID_L3TE_PORT_THRSH_PROFILE_3_HTH        "CFG_ID_L3TE_PORT_THRSH_PROFILE_3_HTH"

#define CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_0_LTH  "CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_0_LTH"
#define CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_1_LTH  "CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_1_LTH"
#define CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_2_LTH  "CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_2_LTH"
#define CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_3_LTH  "CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_3_LTH"

#define CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_0_HTH  "CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_0_HTH"
#define CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_1_HTH  "CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_1_HTH"
#define CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_2_HTH  "CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_2_HTH"
#define CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_3_HTH  "CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_3_HTH"

#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_0_THL     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_0_THL"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_1_THL     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_1_THL"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_2_THL     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_2_THL"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_3_THL     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_3_THL"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_4_THL     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_4_THL"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_5_THL     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_5_THL"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_6_THL     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_6_THL"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_7_THL     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_7_THL"

#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_0_THH     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_0_THH"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_1_THH     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_1_THH"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_2_THH     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_2_THH"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_3_THH     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_3_THH"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_4_THH     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_4_THH"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_5_THH     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_5_THH"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_6_THH     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_6_THH"
#define CFG_ID_L3TE_VOQ_THRSH_PROFILE_7_THH     "CFG_ID_L3TE_VOQ_THRSH_PROFILE_7_THH"

#define CFG_ID_L3TE_SRC_PORT_THRSH_0_THL        "CFG_ID_L3TE_SRC_PORT_THRSH_0_THL"
#define CFG_ID_L3TE_SRC_PORT_THRSH_1_THL        "CFG_ID_L3TE_SRC_PORT_THRSH_1_THL"

#define CFG_ID_L3TE_SRC_PORT_THRSH_0_THH        "CFG_ID_L3TE_SRC_PORT_THRSH_0_THH"
#define CFG_ID_L3TE_SRC_PORT_THRSH_1_THH        "CFG_ID_L3TE_SRC_PORT_THRSH_1_THH"

#define CFG_ID_L3TE_SRC_PRI_THRSH_0_THL         "CFG_ID_L3TE_SRC_PRI_THRSH_0_THL"
#define CFG_ID_L3TE_SRC_PRI_THRSH_1_THL         "CFG_ID_L3TE_SRC_PRI_THRSH_1_THL"
#define CFG_ID_L3TE_SRC_PRI_THRSH_2_THL         "CFG_ID_L3TE_SRC_PRI_THRSH_2_THL"
#define CFG_ID_L3TE_SRC_PRI_THRSH_3_THL         "CFG_ID_L3TE_SRC_PRI_THRSH_3_THL"
#define CFG_ID_L3TE_SRC_PRI_THRSH_4_THL         "CFG_ID_L3TE_SRC_PRI_THRSH_4_THL"
#define CFG_ID_L3TE_SRC_PRI_THRSH_5_THL         "CFG_ID_L3TE_SRC_PRI_THRSH_5_THL"
#define CFG_ID_L3TE_SRC_PRI_THRSH_6_THL         "CFG_ID_L3TE_SRC_PRI_THRSH_6_THL"
#define CFG_ID_L3TE_SRC_PRI_THRSH_7_THL         "CFG_ID_L3TE_SRC_PRI_THRSH_7_THL"

#define CFG_ID_L3TE_SRC_PRI_THRSH_0_THH         "CFG_ID_L3TE_SRC_PRI_THRSH_0_THH"
#define CFG_ID_L3TE_SRC_PRI_THRSH_1_THH         "CFG_ID_L3TE_SRC_PRI_THRSH_1_THH"
#define CFG_ID_L3TE_SRC_PRI_THRSH_2_THH         "CFG_ID_L3TE_SRC_PRI_THRSH_2_THH"
#define CFG_ID_L3TE_SRC_PRI_THRSH_3_THH         "CFG_ID_L3TE_SRC_PRI_THRSH_3_THH"
#define CFG_ID_L3TE_SRC_PRI_THRSH_4_THH         "CFG_ID_L3TE_SRC_PRI_THRSH_4_THH"
#define CFG_ID_L3TE_SRC_PRI_THRSH_5_THH         "CFG_ID_L3TE_SRC_PRI_THRSH_5_THH"
#define CFG_ID_L3TE_SRC_PRI_THRSH_6_THH         "CFG_ID_L3TE_SRC_PRI_THRSH_6_THH"
#define CFG_ID_L3TE_SRC_PRI_THRSH_7_THH         "CFG_ID_L3TE_SRC_PRI_THRSH_7_THH"

#define CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_0      "CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_0"
#define CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_1      "CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_1"
#define CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_2      "CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_2"
#define CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_3      "CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_3"

#define CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_0       "CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_0"
#define CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_1       "CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_1"
#define CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_2       "CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_2"
#define CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_3       "CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_3"
#define CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_4       "CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_4"
#define CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_5       "CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_5"
#define CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_6       "CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_6"
#define CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_7       "CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_7"

#define CFG_ID_L3TE_PORT00_FREE_BUF_CNT         "CFG_ID_L3TE_PORT00_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT01_FREE_BUF_CNT         "CFG_ID_L3TE_PORT01_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT02_FREE_BUF_CNT         "CFG_ID_L3TE_PORT02_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT03_FREE_BUF_CNT         "CFG_ID_L3TE_PORT03_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT04_FREE_BUF_CNT         "CFG_ID_L3TE_PORT04_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT05_FREE_BUF_CNT         "CFG_ID_L3TE_PORT05_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT06_FREE_BUF_CNT         "CFG_ID_L3TE_PORT06_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT07_FREE_BUF_CNT         "CFG_ID_L3TE_PORT07_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT08_FREE_BUF_CNT         "CFG_ID_L3TE_PORT08_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT09_FREE_BUF_CNT         "CFG_ID_L3TE_PORT09_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT10_FREE_BUF_CNT         "CFG_ID_L3TE_PORT10_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT11_FREE_BUF_CNT         "CFG_ID_L3TE_PORT11_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT12_FREE_BUF_CNT         "CFG_ID_L3TE_PORT12_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT13_FREE_BUF_CNT         "CFG_ID_L3TE_PORT13_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT14_FREE_BUF_CNT         "CFG_ID_L3TE_PORT14_FREE_BUF_CNT"
#define CFG_ID_L3TE_PORT15_FREE_BUF_CNT         "CFG_ID_L3TE_PORT15_FREE_BUF_CNT"

#define CFG_ID_L2TE_PORT00_FREE_BUF_CNT         "CFG_ID_L2TE_PORT00_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT01_FREE_BUF_CNT         "CFG_ID_L2TE_PORT01_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT02_FREE_BUF_CNT         "CFG_ID_L2TE_PORT02_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT03_FREE_BUF_CNT         "CFG_ID_L2TE_PORT03_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT04_FREE_BUF_CNT         "CFG_ID_L2TE_PORT04_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT05_FREE_BUF_CNT         "CFG_ID_L2TE_PORT05_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT06_FREE_BUF_CNT         "CFG_ID_L2TE_PORT06_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT07_FREE_BUF_CNT         "CFG_ID_L2TE_PORT07_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT08_FREE_BUF_CNT         "CFG_ID_L2TE_PORT08_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT09_FREE_BUF_CNT         "CFG_ID_L2TE_PORT09_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT10_FREE_BUF_CNT         "CFG_ID_L2TE_PORT10_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT11_FREE_BUF_CNT         "CFG_ID_L2TE_PORT11_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT12_FREE_BUF_CNT         "CFG_ID_L2TE_PORT12_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT13_FREE_BUF_CNT         "CFG_ID_L2TE_PORT13_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT14_FREE_BUF_CNT         "CFG_ID_L2TE_PORT14_FREE_BUF_CNT"
#define CFG_ID_L2TE_PORT15_FREE_BUF_CNT         "CFG_ID_L2TE_PORT15_FREE_BUF_CNT"

#define CFG_ID_IP_ECN_SUPPORT               "CFG_ID_IP_ECN_SUPPORT"
#define CFG_ID_NO_BUFFER_BEHAVIOR           "CFG_ID_NO_BUFFER_BEHAVIOR"

#define CFG_ID_PORT_NI7_ROLE                "CFG_ID_PORT_NI7_ROLE"

#define CFG_ID_PORT_L2VLAN_OUTER_IS_S       "CFG_ID_PORT_L2VLAN_OUTER_IS_S"
#define CFG_ID_PORT_L2VLAN_INNER_IS_S       "CFG_ID_PORT_L2VLAN_INNER_IS_S"

#endif

#define CFG_ID_KERNEL_HOOK_ENABLE           "CFG_ID_KERNEL_HOOK_ENABLE"

#if defined(CONFIG_ARCH_CORTINA_SATURN_SFU) || defined(CONFIG_CORTINA_BOARD_SATURN_SFU_TITAN) || defined(CONFIG_ARCH_CORTINA_G3HGU)
#define CFG_ID_PON_MAC_MODE                 "CFG_ID_PON_MAC_MODE"
#define CFG_ID_PON_VENDOR_ID                "CFG_ID_PON_VENDOR_ID"
#define CFG_ID_PON_VSSN                     "CFG_ID_PON_VSSN"
#define CFG_ID_PON_REGISTRATION_ID0         "CFG_ID_PON_REGISTRATION_ID0"
#define CFG_ID_PON_REGISTRATION_ID1         "CFG_ID_PON_REGISTRATION_ID1"
#define CFG_ID_PON_REGISTRATION_ID2         "CFG_ID_PON_REGISTRATION_ID2"
#define CFG_ID_PON_REGISTRATION_ID3         "CFG_ID_PON_REGISTRATION_ID3"
#define CFG_ID_PON_REGISTRATION_ID4         "CFG_ID_PON_REGISTRATION_ID4"
#define CFG_ID_PON_REGISTRATION_ID5         "CFG_ID_PON_REGISTRATION_ID5"
#define CFG_ID_PON_REGISTRATION_ID6         "CFG_ID_PON_REGISTRATION_ID6"
#define CFG_ID_PON_REGISTRATION_ID7         "CFG_ID_PON_REGISTRATION_ID7"
#define CFG_ID_PON_REGISTRATION_ID8         "CFG_ID_PON_REGISTRATION_ID8"
#define CFG_ID_PON_DS_MAP_ENABLE            "CFG_ID_PON_DS_MAP_ENABLE"
#define CFG_ID_PON_NGPON2_DEFAULT_CHAN      "CFG_ID_PON_NGPON2_DEFAULT_CHAN"
#define CFG_ID_PON_NGPON2_PROTECTION_CHAN   "CFG_ID_PON_NGPON2_PROTECTION_CHAN"
#define CFG_ID_PON_NGPON2_CHAN_PARTITION_INDEX  "CFG_ID_PON_NGPON2_CHAN_PARTITION_INDEX"
#define CFG_ID_XGPN_ACTP_TOZ                "CFG_ID_XGPN_ACTP_TOZ"
#define CFG_ID_XGPN_ACTP_TO23               "CFG_ID_XGPN_ACTP_TO23"
#define CFG_ID_XGPN_ACTP_TO4                "CFG_ID_XGPN_ACTP_TO4"
#define CFG_ID_XGPN_ACTP_TO5                "CFG_ID_XGPN_ACTP_TO5"
#define CFG_ID_PON_LLID_MODE                "CFG_ID_PON_LLID_MODE"
#define CFG_ID_PON_VOQ_MODE                 "CFG_ID_PON_VOQ_MODE"
#define CFG_ID_PON_OLT_TYPE                 "CFG_ID_PON_OLT_TYPE"
#define CFG_ID_PON_PORT_NUM                 "CFG_ID_PON_PORT_NUM"
#define CFG_ID_GE_PORT_NUM                  "CFG_ID_GE_PORT_NUM"
#define CFG_ID_XGE_PORT_NUM                 "CFG_ID_XGE_PORT_NUM"
#define CFG_ID_POTS_PORT_NUM                "CFG_ID_POTS_PORT_NUM"
#define CFG_ID_BATTERY_BACKUP               "CFG_ID_BATTERY_BACKUP"
#define CFG_ID_IPV6_FLAG                    "CFG_ID_IPV6_FLAG"
#define CFG_ID_LOID                         "CFG_ID_LOID"
#define CFG_ID_PASSWD                       "CFG_ID_PASSWD"
#define CFG_ID_GPON_IPHOST_NUM              "CFG_ID_GPON_IPHOST_NUM"
#define CFG_ID_GPON_VEIP_NUM                "CFG_ID_GPON_VEIP_NUM"
#define CFG_ID_GPON_PON_SLOT                "CFG_ID_GPON_PON_SLOT"
#define CFG_ID_GPON_GE_SLOT                 "CFG_ID_GPON_GE_SLOT"
#define CFG_ID_GPON_XGE_SLOT                "CFG_ID_GPON_XGE_SLOT"
#define CFG_ID_GPON_IPHOST_SLOT             "CFG_ID_GPON_IPHOST_SLOT"
#define CFG_ID_GPON_POTS_SLOT               "CFG_ID_GPON_POTS_SLOT"
#define CFG_ID_GPON_VEIP_SLOT               "CFG_ID_GPON_VEIP_SLOT"
#define CFG_ID_GPON_REMOTE_DEBUG            "CFG_ID_GPON_REMOTE_DEBUG"
#define CFG_ID_GPON_POWER_CSV_MODE          "CFG_ID_GPON_POWER_CSV_MODE"
#define CFG_ID_GPON_VEIP_INDEPEND           "CFG_ID_GPON_VEIP_INDEPEND"
#define CFG_ID_GPON_VERSION                 "CFG_ID_GPON_VERSION"
#define CFG_ID_GPON_EQID                    "CFG_ID_GPON_EQID"
#define CFG_ID_ISP_TYPE                     "CFG_ID_ISP_TYPE"
#endif

#define CFG_ID_WAN_PORT_TYPE_IS_L3          "CFG_ID_WAN_PORT_TYPE_IS_L3"
#define CFG_ID_L2FP_CPU_PORT_START          "CFG_ID_L2FP_CPU_PORT_START"
#define CFG_ID_L2FP_CPU_PORT_END            "CFG_ID_L2FP_CPU_PORT_END"

#define CFG_ID_SW_SHAPER_ENABLE         "CFG_ID_SW_SHAPER_ENABLE"
#define CFG_ID_MAX_SW_SHAPERS_SUPPORTED     "CFG_ID_MAX_SW_SHAPERS_SUPPORTED"
#define CFG_ID_SW_SHAPER_MAX_RATE       "CFG_ID_SW_SHAPER_MAX_RATE"

#define CFG_ID_L3FE_TO_WAN_PORT         "CFG_ID_L3FE_TO_WAN_PORT"
#define CFG_ID_INTERFACE_DEEP_Q         "CFG_ID_INTERFACE_DEEP_Q"
#define CFG_ID_NE_NAPI_BUDGET           "CFG_ID_NE_NAPI_BUDGET"
#define CFG_ID_NE_USE_QM_EQ_REFILL_INT      "CFG_ID_NE_USE_QM_EQ_REFILL_INT"

#define CFG_ID_US_RATE_MANAGER_MAX_RATE     "CFG_ID_US_RATE_MANAGER_MAX_RATE"
#define CFG_ID_US_RATE_MANAGER_DEFAULT_RATE "CFG_ID_US_RATE_MANAGER_DEFAULT_RATE"

#define CFG_ID_NE_A53_CPU_PORT_COUNT        "CFG_ID_NE_A53_CPU_PORT_COUNT"
#define CFG_ID_NE_DMA_TO_L3FE           "CFG_ID_NE_DMA_TO_L3FE"
#define CFG_ID_NE_DEFAULT_FLOW       "CFG_ID_NE_DEFAULT_FLOW"
#define CFG_ID_ETH_PORTS_BMP        "CFG_ID_ETH_PORTS_BMP"
#define CFG_ID_PON_PORTS_BMP        "CFG_ID_PON_PORTS_BMP"
#define CFG_ID_ETH_ADMIN_LAYER      "CFG_ID_ETH_ADMIN_LAYER"

typedef enum ca_cfg_id_enum {
    CA_CFG_ID_DEV_MODE,
    CA_CFG_ID_MAC_ADDRESS,
    CA_CFG_ID_PHY_BASE_ADDR,
    CA_CFG_ID_PHY_INTERFACE,
    CA_CFG_ID_UNI_CONNECTION,
    CA_CFG_ID_LPID_CPU_PORT_OWNER,
    CA_CFG_ID_WAN_PORT_ID,
    CA_CFG_ID_FAKE_WAN_MC_VID,
    CA_CFG_ID_GPIO_VALID,
    CA_CFG_ID_GPIO_INTPIN,
    CA_CFG_ID_GPIO_INTLVL,
    CA_CFG_ID_GPIO_CONFIG,
    CA_CFG_ID_GPIO_OUTVAL,
    CA_CFG_ID_L3QM_USE_FBM,
    CA_CFG_ID_DATAPATH_MODE,
    CA_CFG_ID_API_VERSION,

#ifndef CONFIG_CORTINA_BOARD_SATURN_SFU_TITAN
    CA_CFG_ID_NE_NUM_INTF,
    CA_CFG_ID_NE_MAC_ADDR0,
    CA_CFG_ID_NE_MAC_ADDR1,
    CA_CFG_ID_NE_MAC_ADDR2,
    CA_CFG_ID_NE_MAC_ADDR3,
    CA_CFG_ID_NE_MAC_ADDR4,
    CA_CFG_ID_NE_MAC_ADDR5,
    CA_CFG_ID_NE_MAC_ADDR6,
    CA_CFG_ID_NE_MAC_ADDR7,
    CA_CFG_ID_NE_INTF_PORTS0,
    CA_CFG_ID_NE_INTF_PORTS1,
    CA_CFG_ID_NE_INTF_PORTS2,
    CA_CFG_ID_NE_INTF_PORTS3,
    CA_CFG_ID_NE_INTF_PORTS4,
    CA_CFG_ID_NE_INTF_PORTS5,
    CA_CFG_ID_NE_INTF_PORTS6,
    CA_CFG_ID_NE_INTF_PORTS7,
    CA_CFG_ID_NE_RX_LDPID,
    CA_CFG_ID_NE_TX_LDPID,

    CA_CFG_ID_NE_SRAM_PHY_BASE,
    CA_CFG_ID_NE_DDR_COHERENT_PHY_BASE,
    CA_CFG_ID_NE_DDR_NONCACHE_PHY_BASE,
    CA_CFG_ID_NE_SRAM_RESERVED_SIZE,
    CA_CFG_ID_NE_DDR_COHERENT_RESERVED_SIZE,
    CA_CFG_ID_NE_DDR_NONCACHE_RESERVED_SIZE,
    CA_CFG_ID_HASHLITE_HT_SIZE,
    CA_CFG_ID_NAT_AGING_TIME,
    CA_CFG_ID_NEXTHOP_AGING_TIME,

    CA_CFG_ID_LPM_IPV4_PROFILE_0_START,
    CA_CFG_ID_LPM_IPV4_PROFILE_0_END,
    CA_CFG_ID_LPM_IPV4_PROFILE_1_START,
    CA_CFG_ID_LPM_IPV4_PROFILE_1_END,
    CA_CFG_ID_LPM_IPV4_PROFILE_2_START,
    CA_CFG_ID_LPM_IPV4_PROFILE_2_END,
    CA_CFG_ID_LPM_IPV4_PROFILE_3_START,
    CA_CFG_ID_LPM_IPV4_PROFILE_3_END,
    CA_CFG_ID_LPM_IPV6_PROFILE_0_START,
    CA_CFG_ID_LPM_IPV6_PROFILE_0_END,
    CA_CFG_ID_LPM_IPV6_PROFILE_1_START,
    CA_CFG_ID_LPM_IPV6_PROFILE_1_END,
    CA_CFG_ID_LPM_IPV6_PROFILE_2_START,
    CA_CFG_ID_LPM_IPV6_PROFILE_2_END,
    CA_CFG_ID_LPM_IPV6_PROFILE_3_START,
    CA_CFG_ID_LPM_IPV6_PROFILE_3_END,
    CA_CFG_ID_LPM_IPV4_DEFAULT_T4CTRL_0,
    CA_CFG_ID_LPM_IPV4_DEFAULT_T4CTRL_1,
    CA_CFG_ID_LPM_IPV6_DEFAULT_T4CTRL_0,
    CA_CFG_ID_LPM_IPV6_DEFAULT_T4CTRL_1,

    CA_CFG_ID_L3QM_MAGIC_MARKER_LEN,
    CA_CFG_ID_L3QM_DESC_SIZE,
    CA_CFG_ID_L3QM_DESC_PER_EPP,
    CA_CFG_ID_L3QM_PE0_1_PORT_COUNT,
    CA_CFG_ID_L3QM_PE0_1_VOQ_PER_PORT,
    CA_CFG_ID_L3QM_PE0_1_EPP_PER_VOQ,
    CA_CFG_ID_L3QM_PE0_1_POOL_BID_COUNT,
    CA_CFG_ID_L3QM_CPU256_PORT_COUNT,
    CA_CFG_ID_L3QM_CPU256_VOQ_PER_PORT,
    CA_CFG_ID_L3QM_CPU256_EPP_PER_VOQ,
    CA_CFG_ID_L3QM_CPU256_POOL_BID_COUNT,
    CA_CFG_ID_L3QM_A53_PORT_COUNT,
    CA_CFG_ID_L3QM_A53_VOQ_PER_PORT,
    CA_CFG_ID_L3QM_A53_EPP_PER_VOQ,
    CA_CFG_ID_L3QM_A53_POOL_BID_COUNT,
    CA_CFG_ID_L3QM_DEEPQ_POOL_BID_COUNT,
    CA_CFG_ID_L3QM_A53_CACHE_LINE_SIZE,
    CA_CFG_ID_L3QM_PE_BUFFER_ALIGN_SIZE,
    CA_CFG_ID_L3QM_EQ_BUFFER_ALIGN_SIZE,

    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_RULE,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_USE_FBM,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL0_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_POOL1_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE0_ID_PORTS,
    CA_CFG_ID_L3QM_EPP_PROFILE_PE0_ID,
    CA_CFG_ID_L3QM_EPP_PROFILE_PE0_SZ,
    CA_CFG_ID_L3QM_EPP_PROFILE_PE0_CN,
    CA_CFG_ID_L3QM_EPP_PROFILE_PE0_MAP_MODE,

    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_RULE,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_USE_FBM,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL0_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_POOL1_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_PE1_ID_PORTS,
    CA_CFG_ID_L3QM_EPP_PROFILE_PE1_ID,
    CA_CFG_ID_L3QM_EPP_PROFILE_PE1_SZ,
    CA_CFG_ID_L3QM_EPP_PROFILE_PE1_CN,
    CA_CFG_ID_L3QM_EPP_PROFILE_PE1_MAP_MODE,

    CA_CFG_ID_L3QM_EQ_PROFILE_A53_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_RULE,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_USE_FBM,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL0_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_POOL1_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_A53_ID_PORTS,
    CA_CFG_ID_L3QM_EPP_PROFILE_A53_ID,
    CA_CFG_ID_L3QM_EPP_PROFILE_A53_SZ,
    CA_CFG_ID_L3QM_EPP_PROFILE_A53_CN,
    CA_CFG_ID_L3QM_EPP_PROFILE_A53_MAP_MODE,

    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_RULE,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_USE_FBM,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL0_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_POOL1_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_DQ_ID_PORTS,
    CA_CFG_ID_L3QM_EPP_PROFILE_DQ_ID,
    CA_CFG_ID_L3QM_EPP_PROFILE_DQ_SZ,

    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_RULE,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_USE_FBM,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL0_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_HI_POOL1_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_ID_PORTS,
    CA_CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_ID,
    CA_CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_SZ,
    CA_CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_CN,
    CA_CFG_ID_L3QM_EPP_PROFILE_CPU256_HI_MAP_MODE,

    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_RULE,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_USE_FBM,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL0_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_EQ_ID,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BUF_COUNT,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BID_START,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_BUF_SZ,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_LOCATION,
    CA_CFG_ID_L3QM_EQ_PROFILE_CPU256_LO_POOL1_FBM_POOL_ID,
    CA_CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_ID,
    CA_CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_SZ,
    CA_CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_CN,
    CA_CFG_ID_L3QM_EPP_PROFILE_CPU256_LO_MAP_MODE,

    CA_CFG_ID_L3FE_MAIN_HASH_OVERFLOW_FIB_LENGTH,
    CA_CFG_ID_L3FE_MAIN_HASH_OVERFLOW_FIB_COUNT,
    CA_CFG_ID_L3FE_MAIN_HASH_DEFAULT_HASH_FIB_LENGTH,
    CA_CFG_ID_L3FE_MAIN_HASH_DEFAULT_HASH_FIB_COUNT,
    CA_CFG_ID_L3FE_MAIN_HASH_ACTION_CACHE_FIB_LENGTH,
    CA_CFG_ID_L3FE_MAIN_HASH_ACTION_CACHE_FIB_COUNT,
    CA_CFG_ID_L3FE_MAIN_HASH_TABLE_ENTRY_LENGTH,
    CA_CFG_ID_L3FE_MAIN_HASH_TABLE_ENTRY_COUNT,
    CA_CFG_ID_L3FE_MAIN_HASH_ACTION_TABLE_ENTRY_LENGTH,
    CA_CFG_ID_L3FE_MAIN_HASH_ACTION_TABLE_ENTRY_COUNT,

    CA_CFG_ID_L3FE_T5_CTRL_SUPPORT,

    CA_CFG_ID_L3QM_NI_P0_7_DEEP_Q_EN,
    CA_CFG_ID_L3QM_ACP_ENABLE,

    CA_CFG_ID_L3QM_CCI0_START_ADDR,
    CA_CFG_ID_L3QM_CCI1_START_ADDR,
    CA_CFG_ID_L3QM_SRAM_START_ADDR,
    CA_CFG_ID_L3QM_DDR_CACHE_COHERENT_START_ADDR,
    CA_CFG_ID_L3QM_DDR_NON_CACHE_START_ADDR,
    CA_CFG_ID_L3QM_EQ_AXI_TOP8_BITS,
    CA_CFG_ID_L3QM_EPP_AXI_TOP8_BITS,

    CA_CFG_ID_L3QM_CPU_PORT_HEAD_ROOM_FIRST,

    CA_CFG_ID_L3QM_EQ_CFG3_VALUES,
    CA_CFG_ID_L3QM_EQ_CFG4_VALUES,
    CA_CFG_ID_L3QM_AXI_ATTRIB_EQ_VALUES,
    CA_CFG_ID_L3QM_AXI_ATTRIB_CPU256_EPP_VALUES,
    CA_CFG_ID_L3QM_AXI_ATTRIB_A53_EPP_VALUES,
    CA_CFG_ID_FLOODING_DOMAIN_1,
    CA_CFG_ID_FLOODING_DOMAIN_2,

    CA_CFG_ID_L3_CLASSIFIER_PROFILE_WAN,
    CA_CFG_ID_L3_CLASSIFIER_PROFILE_LAN,
    CA_CFG_ID_L3_MAIN_HASH_PROFILE_WAN,
    CA_CFG_ID_L3_MAIN_HASH_PROFILE_LAN,
    CA_CFG_ID_L3_MAIN_HASH_PROFILE_MC,
    CA_CFG_ID_L3_MAIN_HASH_PROFILE_CLASS,
    CA_CFG_ID_L3_HASH_LITE_PROFILE,
    CA_CFG_ID_NAT_ENABLE,
    CA_CFG_ID_FLOW_SUPPORT,

    CA_CFG_ID_L3QM_DEEPQ_TEST_WITH_SRAM,
    CA_CFG_ID_L3QM_ACE_TEST,
    CA_CFG_ID_DMA_LSO_ACE_TEST,
    CA_CFG_ID_MAIN_HASH_BM_TEST,
    CA_CFG_ID_MAIN_HASH_BUCKET_SIZE,

    CA_CFG_ID_L2TE_GLB_THRSH_THL,
    CA_CFG_ID_L2TE_GLB_THRSH_THH,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH0_THL,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH1_THL,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH2_THL,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH3_THL,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH4_THL,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH5_THL,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH6_THL,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH7_THL,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH0_THH,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH1_THH,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH2_THH,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH3_THH,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH4_THH,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH5_THH,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH6_THH,
    CA_CFG_ID_L2TE_GLB_PRI_THRSH7_THH,
    CA_CFG_ID_L2TE_PORT_THRSH_PROFILE_0_THL,
    CA_CFG_ID_L2TE_PORT_THRSH_PROFILE_1_THL,
    CA_CFG_ID_L2TE_PORT_THRSH_PROFILE_2_THL,
    CA_CFG_ID_L2TE_PORT_THRSH_PROFILE_3_THL,
    CA_CFG_ID_L2TE_PORT_THRSH_PROFILE_0_THH,
    CA_CFG_ID_L2TE_PORT_THRSH_PROFILE_1_THH,
    CA_CFG_ID_L2TE_PORT_THRSH_PROFILE_2_THH,
    CA_CFG_ID_L2TE_PORT_THRSH_PROFILE_3_THH,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_0_THL,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_1_THL,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_2_THL,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_3_THL,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_4_THL,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_5_THL,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_6_THL,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_7_THL,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_0_THH,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_1_THH,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_2_THH,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_3_THH,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_4_THH,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_5_THH,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_6_THH,
    CA_CFG_ID_L2TE_VOQ_THRSH_PROFILE_7_THH,
    CA_CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_0_THL,
    CA_CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_1_THL,
    CA_CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_2_THL,
    CA_CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_3_THL,
    CA_CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_0_THH,
    CA_CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_1_THH,
    CA_CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_2_THH,
    CA_CFG_ID_L2TE_SRC_PORT_THRSH_PROFILE_3_THH,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS0_THL,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS1_THL,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS2_THL,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS3_THL,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS4_THL,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS5_THL,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS6_THL,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS7_THL,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS0_THH,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS1_THH,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS2_THH,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS3_THH,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS4_THH,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS5_THH,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS6_THH,
    CA_CFG_ID_L2TE_SRC0_PRI_THRSH_PROFILE_CoS7_THH,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS0_THL,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS1_THL,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS2_THL,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS3_THL,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS4_THL,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS5_THL,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS6_THL,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS7_THL,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS0_THH,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS1_THH,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS2_THH,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS3_THH,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS4_THH,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS5_THH,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS6_THH,
    CA_CFG_ID_L2TE_SRC1_PRI_THRSH_PROFILE_CoS7_THH,
    CA_CFG_ID_L2TE_DQSCH_EQ_PROFILE_THRSH0_THL,
    CA_CFG_ID_L2TE_DQSCH_EQ_PROFILE_THRSH0_THH,
    CA_CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_0_THL,
    CA_CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_1_THL,
    CA_CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_2_THL,
    CA_CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_3_THL,
    CA_CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_0_THH,
    CA_CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_1_THH,
    CA_CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_2_THH,
    CA_CFG_ID_L2TE_DQSCH_PORT_THRSH_PROFILE_3_THH,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_0_THL,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_1_THL,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_2_THL,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_3_THL,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_4_THL,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_5_THL,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_6_THL,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_7_THL,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_0_THH,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_1_THH,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_2_THH,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_3_THH,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_4_THH,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_5_THH,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_6_THH,
    CA_CFG_ID_L2TE_DQSCH_VOQ_THRSH_PROFILE_7_THH,

    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ0_TH0,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ1_TH0,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ2_TH0,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ3_TH0,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ4_TH0,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ5_TH0,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ6_TH0,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ7_TH0,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ0_TH1,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ1_TH1,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ2_TH1,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ3_TH1,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ4_TH1,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ5_TH1,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ6_TH1,
    CA_CFG_ID_L3TE_PROFILE_THRSH_EQ7_TH1,
    CA_CFG_ID_L3TE_PORT_THRSH_PROFILE_0_LTH,
    CA_CFG_ID_L3TE_PORT_THRSH_PROFILE_1_LTH,
    CA_CFG_ID_L3TE_PORT_THRSH_PROFILE_2_LTH,
    CA_CFG_ID_L3TE_PORT_THRSH_PROFILE_3_LTH,
    CA_CFG_ID_L3TE_PORT_THRSH_PROFILE_0_HTH,
    CA_CFG_ID_L3TE_PORT_THRSH_PROFILE_1_HTH,
    CA_CFG_ID_L3TE_PORT_THRSH_PROFILE_2_HTH,
    CA_CFG_ID_L3TE_PORT_THRSH_PROFILE_3_HTH,
    CA_CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_0_LTH,
    CA_CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_1_LTH,
    CA_CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_2_LTH,
    CA_CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_3_LTH,
    CA_CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_0_HTH,
    CA_CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_1_HTH,
    CA_CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_2_HTH,
    CA_CFG_ID_L3TE_CB_PORT_GRPTHRSH_PROFILE_3_HTH,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_0_THL,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_1_THL,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_2_THL,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_3_THL,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_4_THL,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_5_THL,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_6_THL,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_7_THL,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_0_THH,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_1_THH,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_2_THH,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_3_THH,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_4_THH,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_5_THH,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_6_THH,
    CA_CFG_ID_L3TE_VOQ_THRSH_PROFILE_7_THH,
    CA_CFG_ID_L3TE_SRC_PORT_THRSH_0_THL,
    CA_CFG_ID_L3TE_SRC_PORT_THRSH_1_THL,
    CA_CFG_ID_L3TE_SRC_PORT_THRSH_0_THH,
    CA_CFG_ID_L3TE_SRC_PORT_THRSH_1_THH,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_0_THL,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_1_THL,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_2_THL,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_3_THL,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_4_THL,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_5_THL,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_6_THL,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_7_THL,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_0_THH,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_1_THH,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_2_THH,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_3_THH,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_4_THH,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_5_THH,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_6_THH,
    CA_CFG_ID_L3TE_SRC_PRI_THRSH_7_THH,
    CA_CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_0,
    CA_CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_1,
    CA_CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_2,
    CA_CFG_ID_L3TE_DQSCH_PORT_THRSH_PROFILE_3,
    CA_CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_0,
    CA_CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_1,
    CA_CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_2,
    CA_CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_3,
    CA_CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_4,
    CA_CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_5,
    CA_CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_6,
    CA_CFG_ID_L3TE_DQSCH_VOQ_THRSH_PROFILE_7,

    CA_CFG_ID_L3TE_PORT00_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT01_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT02_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT03_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT04_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT05_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT06_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT07_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT08_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT09_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT10_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT11_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT12_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT13_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT14_FREE_BUF_CNT,
    CA_CFG_ID_L3TE_PORT15_FREE_BUF_CNT,

    CA_CFG_ID_L2TE_PORT00_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT01_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT02_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT03_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT04_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT05_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT06_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT07_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT08_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT09_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT10_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT11_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT12_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT13_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT14_FREE_BUF_CNT,
    CA_CFG_ID_L2TE_PORT15_FREE_BUF_CNT,
    CA_CFG_ID_IP_ECN_SUPPORT,

    CA_CFG_ID_NO_BUFFER_BEHAVIOR,
    CA_CFG_ID_PORT_NI7_ROLE,
#endif
    CA_CFG_ID_KERNEL_HOOK_ENABLE,

#if defined(CONFIG_ARCH_CORTINA_SATURN_SFU) || defined(CONFIG_CORTINA_BOARD_SATURN_SFU_TITAN) || defined(CONFIG_ARCH_CORTINA_G3HGU)
    CA_CFG_ID_PON_MAC_MODE,
    CA_CFG_ID_PON_VENDOR_ID,
    CA_CFG_ID_PON_VSSN,
    CA_CFG_ID_PON_REGISTRATION_ID0,
    CA_CFG_ID_PON_REGISTRATION_ID1,
    CA_CFG_ID_PON_REGISTRATION_ID2,
    CA_CFG_ID_PON_REGISTRATION_ID3,
    CA_CFG_ID_PON_REGISTRATION_ID4,
    CA_CFG_ID_PON_REGISTRATION_ID5,
    CA_CFG_ID_PON_REGISTRATION_ID6,
    CA_CFG_ID_PON_REGISTRATION_ID7,
    CA_CFG_ID_PON_REGISTRATION_ID8,
    CA_CFG_ID_PON_DS_MAP_ENABLE,
    CA_CFG_ID_PON_NGPON2_DEFAULT_CHAN,
    CA_CFG_ID_PON_NGPON2_PROTECTION_CHAN,
    CA_CFG_ID_PON_NGPON2_CHAN_PARTITION_INDEX,
    CA_CFG_ID_XGPN_ACTP_TOZ,
    CA_CFG_ID_XGPN_ACTP_TO23,
    CA_CFG_ID_XGPN_ACTP_TO4,
    CA_CFG_ID_XGPN_ACTP_TO5,
    CA_CFG_ID_PON_LLID_MODE,
    CA_CFG_ID_PON_VOQ_MODE,
    CA_CFG_ID_PON_OLT_TYPE ,
    CA_CFG_ID_PON_PORT_NUM,
    CA_CFG_ID_GE_PORT_NUM,
    CA_CFG_ID_XGE_PORT_NUM,
    CA_CFG_ID_POTS_PORT_NUM,
    CA_CFG_ID_BATTERY_BACKUP,
    CA_CFG_ID_IPV6_FLAG,
    CA_CFG_ID_LOID,
    CA_CFG_ID_PASSWD,
    CA_CFG_ID_GPON_IPHOST_NUM,
    CA_CFG_ID_GPON_VEIP_NUM,
    CA_CFG_ID_GPON_PON_SLOT,
    CA_CFG_ID_GPON_GE_SLOT,
    CA_CFG_ID_GPON_XGE_SLOT,
    CA_CFG_ID_GPON_IPHOST_SLOT,
    CA_CFG_ID_GPON_POTS_SLOT,
    CA_CFG_ID_GPON_VEIP_SLOT,
    CA_CFG_ID_GPON_REMOTE_DEBUG,
    CA_CFG_ID_GPON_POWER_CSV_MODE,
    CA_CFG_ID_GPON_VEIP_INDEPEND,
    CA_CFG_ID_GPON_VERSION,
    CA_CFG_ID_GPON_EQID,
    CA_CFG_ID_ISP_TYPE,
#endif

#ifndef CONFIG_CORTINA_BOARD_SATURN_SFU_TITAN
    CA_CFG_ID_WAN_PORT_TYPE_IS_L3,
    CA_CFG_ID_L2FP_CPU_PORT_START,
    CA_CFG_ID_L2FP_CPU_PORT_END,

    CA_CFG_ID_SW_SHAPER_ENABLE,
    CA_CFG_ID_MAX_SW_SHAPERS_SUPPORTED,
    CA_CFG_ID_SW_SHAPER_MAX_RATE,

    CA_CFG_ID_L3FE_TO_WAN_PORT,
    CA_CFG_ID_INTERFACE_DEEP_Q,
    CA_CFG_ID_NE_NAPI_BUDGET,
    CA_CFG_ID_NE_USE_QM_EQ_REFILL_INT,

    CA_CFG_ID_PORT_L2VLAN_OUTER_IS_S,
    CA_CFG_ID_PORT_L2VLAN_INNER_IS_S,

    CA_CFG_ID_US_RATE_MANAGER_MAX_RATE,
    CA_CFG_ID_US_RATE_MANAGER_DEFAULT_RATE,

    CA_CFG_ID_NE_A53_CPU_PORT_COUNT,
    CA_CFG_ID_NE_DMA_TO_L3FE,

    CA_CFG_ID_NE_DEFAULT_FLOW,
    CA_CFG_ID_ETH_PORTS_BMP,
    CA_CFG_ID_PON_PORTS_BMP,
    CA_CFG_ID_ETH_ADMIN_LAYER,
#endif

    CA_CFG_ID_MAX,      /* MUST BE LAST ONE */
} ca_cfg_id_en;

typedef enum {
    SCFG_GPIO_INVALID   = 0,
    SCFG_GPIO_INPUT     = 1,
    SCFG_GPIO_OUTPUT    = 2,
    SCFG_GPIO_TRIGGER   = 3,
} ca_scfg_GpioPinType_t;

#if defined(CONFIG_ARCH_CORTINA_SATURN_SFU) || defined(CONFIG_CORTINA_BOARD_SATURN_SFU_TITAN) || defined(CONFIG_ARCH_CORTINA_G3HGU)
typedef enum {
    ONU_PON_MAC_EPON_1G   = 0,   /* 1G Down, 1G Up, EPON  */
    ONU_PON_MAC_EPON_D10G = 1,   /* 10G Down, 1G Up, EPON  */
    ONU_PON_MAC_EPON_BI10G= 2,   /* 10G Down, 10G Up, 10G-EPON */
    ONU_PON_MAC_GPON      = 3,   /* 2.5G Down, 1G Up, GPON */
    ONU_PON_MAC_XGPON1    = 4,   /* 10G Down, 2.5G Up, XG-PON1 */
    ONU_PON_MAC_XGSPON    = 5,   /* 10G Down, 10G Up, XGS-PON */
    ONU_PON_MAC_NGPON2    = 6,   /* 10G Down, 10G Up, NG-PON2 with multiple wavelength support*/
    ONU_PON_MAC_ETHERNET  = 7,   /* 10G Ethernet */
    ONU_PON_MAC_MAX
} ca_scfg_pon_mac_mode_t;

#define CA_PON_MODE_IS_EPON_FAMILY(mode) ((mode) >= ONU_PON_MAC_EPON_1G && (mode) <= ONU_PON_MAC_EPON_BI10G)
#define CA_PON_MODE_IS_GPON_FAMILY(mode) ((mode) >= ONU_PON_MAC_GPON && (mode) <= ONU_PON_MAC_NGPON2)
#define CA_PON_MODE_IS_ETHERNET(mode) ((mode) == ONU_PON_MAC_ETHERNET )

typedef enum
{
    CA_OLT_TYPE_CALIX           = 0,
    CA_OLT_TYPE_ADTRAN          = 1,
    CA_OLT_TYPE_ZTE             = 2,
    CA_OLT_TYPE_SUMITOMO        = 3,
    CA_OLT_TYPE_CORTINA         = 4,
    CA_OLT_TYPE_UNKNOWN         = 5
}ca_scfg_olt_type_t;



#if 0
#define AAL_XGPON_VENDOR_ID_ZTE   0x5a544547    /*ZTEG*/
#define AAL_XGPON_VENDOR_ID_ADTRAN  0x4144544e    /*ADTN*/
#define AAL_XGPON_VENDOR_ID_DEFAULT   0x434f5254    /*CORT*/
#endif
#endif

typedef enum ca_scfg_ecode_enum {
    SCFG_OK,
    SCFG_ERR,
    SCFG_PARAM_ERR,
    SCFG_MALLOC_ERR,
    SCFG_FNAME_ERR,
    SCFG_FOPEN_ERR,
    SCFG_MKDIR_ERR,
    SCFG_MUTEX_ERR,
    SCFG_MERGE_ERR,
    SCFG_PARSE_ERR,
    SCFG_FILEOP_ERR,
    SCFG_FILEFT_ERR,
    SCFG_ERR_MAX
} ca_scfg_ecode_en;

typedef enum parse_key_enum {
    PARSE_KEY_CHAR,
    PARSE_KEY_SHORT,
    PARSE_KEY_INT,
    PARSE_KEY_STR,
    PARSE_KEY_BLN,
    PARSE_KEY_IP,
    PARSE_KEY_MAC,
    PARSE_KEY_CHAR_ARRAY,
    PARSE_KEY_SHORT_ARRAY,
    PARSE_KEY_INT_ARRAY,
    PARSE_KEY_MAX
} parse_key_en_t;

typedef struct {/*CODEGEN_IGNORE_TAG */
    ca_uint32_t idx;
    ca_uint8_t  scfg_id[CFG_ID_STRING_LEN];
    ca_uint8_t *pscfg_val;
    ca_uint32_t scfg_len;
    parse_key_en_t parse_key_type;
} ca_cfg_id_item_t;

#define CA_DEVICE_CONFIG_TLV_MAX_LEN        128

typedef struct {
    ca_uint32_t type;
    ca_uint32_t len;
    ca_uint8_t value[CA_DEVICE_CONFIG_TLV_MAX_LEN];
} ca_device_config_tlv_t;

#define SCFG_LOG(/*CODEGEN_IGNORE_TAG*/arg, ...) ca_printf(arg, ##__VA_ARGS__)

#define SCFG_DBG(/*CODEGEN_IGNORE_TAG*/arg, ...) ca_printf("dbg:%s(): "arg, __FUNCTION__, ##__VA_ARGS__)

#define SCFG_ERR(/*CODEGEN_IGNORE_TAG*/err, arg, ...) ca_printf("err:%s():err[%d] "arg, __FUNCTION__, err, ##__VA_ARGS__)

#define SCFG_ERR_RET(/*CODEGEN_IGNORE_TAG*/err, arg, ...)  do{ SCFG_ERR(err, "line _%d_ failure, "arg, __LINE__, ##__VA_ARGS__);return(err);}while(0)

#define SCFG_ERR_RET0(/*CODEGEN_IGNORE_TAG*/err, arg, ...)  do{ SCFG_ERR(err, "line _%d_ failure, "arg, __LINE__, ##__VA_ARGS__); return; }while(0)

#define SCFG_RET(/*CODEGEN_IGNORE_TAG*/arg, ...)  do{ SCFG_LOG("line _%d_ failure, "arg, __LINE__, ##__VA_ARGS__); return SCFG_OK; }while(0)

ca_uint32 scfg_read(/*CODEGEN_IGNORE_TAG*/
    CA_IN ca_device_id_t device_id,
    CA_IN ca_int8_t *scfg_id/*[32:32]*/,
    CA_IN ca_uint32_t len,
    CA_OUT ca_uint8_t *pbuf/*[len:130]*/);

ca_uint32 scfg_write(/*CODEGEN_IGNORE_TAG*/
    CA_IN ca_device_id_t device_id,
    CA_IN ca_int8_t *scfg_id/*[32:32]*/,
    CA_IN ca_uint32_t len,
    CA_IN ca_uint8_t *pbuf/*[len:130]*/);

ca_status_t ca_device_config_init(
    CA_IN       ca_device_id_t    device_id,
    CA_IN       ca_uchar8_t      *p_file_name);

ca_status_t ca_device_config_delete(
    CA_IN       ca_device_id_t   device_id,
    CA_IN       ca_uchar8_t     *p_file_name);

ca_status_t ca_device_config_tlv_add(
    CA_IN       ca_device_id_t      device_id,
    CA_IN_OUT   ca_device_config_tlv_t  *p_tlv);

ca_status_t ca_device_config_tlv_get(
    CA_IN       ca_device_id_t      device_id,
    CA_IN_OUT   ca_device_config_tlv_t  *p_tlv);

ca_status_t ca_device_config_tlv_delete(
    CA_IN       ca_device_id_t      device_id,
    CA_IN_OUT   ca_device_config_tlv_t  *p_tlv);
#endif
