/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef _MAC_AX_FW_CMD_INTF_H_
#define _MAC_AX_FW_CMD_INTF_H_

#define FWCMD_HDR_LEN		8

#define H2C_CMD_LEN		64
#define H2C_DATA_LEN		256
#define H2C_LONG_DATA_LEN	2048

/* hdr0 field -H2C and C2H use the same layout */
#define FWCMD_HDR_TYPE_MSK	0xF
#define FWCMD_HDR_TYPE_SH	16
#define FWCMD_HDR_CAT_MSK	0x3
#define FWCMD_HDR_CAT_SH	0
#define FWCMD_HDR_CLASS_MSK	0x3F
#define FWCMD_HDR_CLASS_SH	2
#define FWCMD_HDR_FUNC_MSK	0xFF
#define FWCMD_HDR_FUNC_SH	8

/* hdr1 field - H2C */
#define H2C_HDR_LEN_MSK		0x3FFF
#define H2C_HDR_LEN_SH		0
#define H2C_HDR_RACK_EN		BIT(14)
#define H2C_HDR_DACK_EN		BIT(15)
#define H2C_HDR_SEQ_VALID	BIT(16)
#define H2C_HDR_SEQ_MSK		0x7
#define H2C_HDR_SEQ_SH		17
#define H2C_HDR_SEQ_STOP	BIT(20)

/* hdr1 field - C2H */
#define C2H_HDR_LEN_MSK		0x3FFF
#define C2H_HDR_LEN_SH		0

#define SET_FWCMD_ID(_t, _ca, _cl, _f)                                         \
		(SET_WORD(_t, FWCMD_HDR_TYPE) | SET_WORD(_ca, FWCMD_HDR_CAT) | \
		 SET_WORD(_cl, FWCMD_HDR_CLASS) | SET_WORD(_f, FWCMD_HDR_FUNC))
#define GET_FWCMD_TYPE(id)	(GET_FIELD(id, FWCMD_HDR_TYPE))
#define GET_FWCMD_CAT(id)	(GET_FIELD(id, FWCMD_HDR_CAT))
#define GET_FWCMD_CLASS(id)	(GET_FIELD(id, FWCMD_HDR_CLASS))
#define GET_FWCMD_FUNC(id)	(GET_FIELD(id, FWCMD_HDR_FUNC))

struct fwcmd_hdr {
	u32 hdr0;
	u32 hdr1;
};

#define FWCMD_TYPE_H2C	0
#define FWCMD_TYPE_C2H	1

/* === H2C packets === */
/* cat: system */
#define FWCMD_H2C_CAT_SYS	0
/* class: command path */
#define FWCMD_H2C_CL_CMD_PATH	0x0
#define FWCMD_H2C_FUNC_CMD_LB	0x0

/* cat: MAC */
#define FWCMD_H2C_CAT_MAC	1
/* class: FWDL */
#define FWCMD_H2C_CL_FWDL	0x3
#define FWCMD_H2C_FUNC_FWDL	0x0
/* class: Table update */
#define FWCMD_H2C_CL_TBLUD	0x5
#define FWCMD_H2C_FUNC_TBLUD	0x0

/* cat: PHY */
#define FWCMD_H2C_CAT_PHY	2

#define FWCMD_H2C_CL_NULL	0xFF
#define FWCMD_H2C_FUNC_NULL	0xFF

/* === C2CH packets === */
#define FWCMD_C2H_CAT_SYS	0
#define FWCMD_C2H_CL_CMD_PATH	0x0
#define FWCMD_C2H_FUNC_CMD_LB	0x0

/* cat: MAC */
#define FWCMD_C2H_CAT_MAC	1

/* cat: PHY */
#define FWCMD_C2H_CAT_PHY	2

#define FWCMD_C2H_CL_NULL	0xFF
#define FWCMD_C2H_FUNC_NULL	0xFF

struct fwcmd_dlru_fixtbl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
};

struct fwcmd_ulru_fixtbl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
};

struct fwcmd_dlru_grptbl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_ulru_grptbl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_ru_stainfo {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_ba_infotbl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_mu_fixinfo {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_test_para {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u16 dword6;
	u16 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
};

struct fwcmd_ul_fixinfo {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u16 word4;
	u16 word5;
	u16 word6;
	u16 word7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
};

/* H2C table header */
#define FWCMD_TBLHDR_RW_SH	0
#define FWCMD_TBLHDR_RW_MSK	0x1
#define FWCMD_TBLHDR_IDX_SH	1
#define FWCMD_TBLHDR_IDX_MSK	0x7F
#define FWCMD_TBLHDR_OFFSET_SH	8
#define FWCMD_TBLHDR_OFFSET_MSK	0x1F
#define FWCMD_TBLHDR_LEN_SH	13
#define FWCMD_TBLHDR_LEN_MSK	0x3FF
#define FWCMD_TBLHDR_TYPE_SH	23
#define FWCMD_TBLHDR_TYPE_MSK	0x1
#define FWCMD_TBLHDR_CLASS_SH	24
#define FWCMD_TBLHDR_CLASS_MSK	0xFF

/* DL RU fixed table*/
#define FWCMD_DLRU_FIXTBL_MAXSTA_SH	0
#define FWCMD_DLRU_FIXTBL_MAXSTA_MSK	0x7
#define FWCMD_DLRU_FIXTBL_MINSTA_SH	3
#define FWCMD_DLRU_FIXTBL_MINSTA_MSK	0x7
#define FWCMD_DLRU_FIXTBL_DPLR_SH	8
#define FWCMD_DLRU_FIXTBL_DPLR_MSK	0x1
#define FWCMD_DLRU_FIXTBL_STBC_SH	9
#define FWCMD_DLRU_FIXTBL_STBC_MSK	0x1
#define FWCMD_DLRU_FIXTBL_GILTF_SH	10
#define FWCMD_DLRU_FIXTBL_GILTF_MSK	0x7
#define FWCMD_DLRU_FIXTBL_MA_TYPE_SH	13
#define FWCMD_DLRU_FIXTBL_MA_TYPE_MSK	0x1
#define FWCMD_DLRU_FIXTBL_FIXRU_SH	14
#define FWCMD_DLRU_FIXTBL_FIXRU_MSK	0x1

#define FWCMD_DL_FIXSTA_MACID_SH	0
#define FWCMD_DL_FIXSTA_MACID_MSK	0xff
#define FWCMD_DL_FIXSTA_RU_POS0_SH	8
#define FWCMD_DL_FIXSTA_RU_POS0_MSK	0xff
#define FWCMD_DL_FIXSTA_RU_POS1_SH	16
#define FWCMD_DL_FIXSTA_RU_POS1_MSK	0xff
#define FWCMD_DL_FIXSTA_RU_POS2_SH	24
#define FWCMD_DL_FIXSTA_RU_POS2_MSK	0xff

#define FWCMD_DL_FIXSTA_FIXRATE_SH	0
#define FWCMD_DL_FIXSTA_FIXRATE_MSK	0x1
#define FWCMD_DL_FIXSTA_FIXCODE_SH	1
#define FWCMD_DL_FIXSTA_FIXCODE_MSK	0x1
#define FWCMD_DL_FIXSTA_FIXTXBF_SH	2
#define FWCMD_DL_FIXSTA_FIXTXBF_MSK	0x1
#define FWCMD_DL_FIXSTA_FIXPWRFAC_SH	3
#define FWCMD_DL_FIXSTA_FIXPWRFAC_MSK	0x1
#define FWCMD_FIXSTA_DL_RATE_DCM_SH	8
#define FWCMD_FIXSTA_DL_RATE_DCM_MSK	0x1
#define FWCMD_FIXSTA_DL_RATE_SS_SH	9
#define FWCMD_FIXSTA_DL_RATE_SS_MSK	0x7
#define FWCMD_FIXSTA_DL_RATE_MCS_SH	12
#define FWCMD_FIXSTA_DL_RATE_MCS_MSK	0xF
#define FWCMD_DL_FIXSTA_TXBF_SH		16
#define FWCMD_DL_FIXSTA_TXBF_MSK	0x1
#define FWCMD_DL_FIXSTA_CODING_SH	17
#define FWCMD_DL_FIXSTA_CODING_MSK	0x1
#define FWCMD_DL_FIXSTA_PWR_FAC_SH	18
#define FWCMD_DL_FIXSTA_PWR_FAC_MSK	0x1F

/* DL RU grouping table*/
#define FWCMD_DLRU_GRPTBL_PPDUBW_SH	0
#define FWCMD_DLRU_GRPTBL_PPDUBW_MSK	0x3
#define FWCMD_DLRU_GRPTBL_TXPWR_SH	2
#define FWCMD_DLRU_GRPTBL_TXPWR_MSK	0x3FF
#define FWCMD_DLRU_GRPTBL_PWRFAC_SH	11
#define FWCMD_DLRU_GRPTBL_PWRFAC_MSK	0x1F
#define FWCMD_DLRU_GRPTBL_FIXFLAG_SH	16
#define FWCMD_DLRU_GRPTBL_FIXFLAG_MSK	0x1

#define FWCMD_GRPTBL_TFBA_FIXBA_SH	0
#define FWCMD_GRPTBL_TFBA_FIXBA_MSK	0x1
#define FWCMD_GRPTBL_TFBA_RUPSD_SH	1
#define FWCMD_GRPTBL_TFBA_RUPSD_MSK	0x1FF
#define FWCMD_GRPTBL_TFBA_RATE_SH	10
#define FWCMD_GRPTBL_TFBA_RATE_MSK	0x1FF
#define FWCMD_GRPTBL_TFBA_RFGFIX_SH	19
#define FWCMD_GRPTBL_TFBA_RFGFIX_MSK	0x1
#define FWCMD_GRPTBL_TFBA_RFGIDX_SH	20
#define FWCMD_GRPTBL_TFBA_RFGIDX_MSK	0x3FF
#define FWCMD_GRPTBL_TFBA_TBBW_SH	30
#define FWCMD_GRPTBL_TFBA_TBBW_MSK	0x3

#define FWCMD_DLRU_GRPTBL_RATE_DCM_SH	0
#define FWCMD_DLRU_GRPTBL_RATE_DCM_MSK	0x1
#define FWCMD_DLRU_GRPTBL_RATE_SS_SH	1
#define FWCMD_DLRU_GRPTBL_RATE_SS_MSK	0x7
#define FWCMD_DLRU_GRPTBL_RATE_MCS_SH	4
#define FWCMD_DLRU_GRPTBL_RATE_MCS_MSK	0xF

#define FWCMD_GRPTBL_TFBA_GILTF_SH	8
#define FWCMD_GRPTBL_TFBA_GILTF_MSK	0x7
#define FWCMD_GRPTBL_TFBA_DPLR_SH	11
#define FWCMD_GRPTBL_TFBA_DPLR_MSK	0x1
#define FWCMD_GRPTBL_TFBA_STBC_SH	12
#define FWCMD_GRPTBL_TFBA_STBC_MSK	0x1
#define FWCMD_GRPTBL_TFBA_CODING_SH	13
#define FWCMD_GRPTBL_TFBA_CODING_MSK	0x1
#define FWCMD_GRPTBL_TFBA_TB_NOM_SH	14
#define FWCMD_GRPTBL_TFBA_TB_NOM_MSK	0x3
#define FWCMD_GRPTBL_TFBA_PR20BW_SH	16
#define FWCMD_GRPTBL_TFBA_PR20BW_MSK	0x1

/* UL RU fixed table*/
#define FWCMD_ULRU_FIXTBL_MAXSTA_SH	0
#define FWCMD_ULRU_FIXTBL_MAXSTA_MSK	0x7
#define FWCMD_ULRU_FIXTBL_MINSTA_SH	3
#define FWCMD_ULRU_FIXTBL_MINSTA_MSK	0x7
#define FWCMD_ULRU_FIXTBL_DPLR_SH	6
#define FWCMD_ULRU_FIXTBL_DPLR_MSK	0x1
#define FWCMD_ULRU_FIXTBL_MA_TYPE_SH	7
#define FWCMD_ULRU_FIXTBL_MA_TYPE_MSK	0x1
#define FWCMD_ULRU_FIXTBL_GILTF_SH	8
#define FWCMD_ULRU_FIXTBL_GILTF_MSK	0x7
#define FWCMD_ULRU_FIXTBL_STBC_SH	11
#define FWCMD_ULRU_FIXTBL_STBC_MSK	0x1
#define FWCMD_ULRU_FIXTBL_FIX_NOM_SH	12
#define FWCMD_ULRU_FIXTBL_FIX_NOM_MSK	0x1
#define FWCMD_ULRU_FIXTBL_TB_NOM_SH	13
#define FWCMD_ULRU_FIXTBL_TB_NOM_MSK	0x3
#define FWCMD_ULRU_FIXTBL_FIXRU_SH	15
#define FWCMD_ULRU_FIXTBL_FIXRU_MSK	0x1

#define FWCMD_UL_FIXSTA_MACID_SH	0
#define FWCMD_UL_FIXSTA_MACID_MSK	0xff
#define FWCMD_UL_FIXSTA_RU_POS0_SH	8
#define FWCMD_UL_FIXSTA_RU_POS0_MSK	0xff
#define FWCMD_UL_FIXSTA_RU_POS1_SH	16
#define FWCMD_UL_FIXSTA_RU_POS1_MSK	0xff
#define FWCMD_UL_FIXSTA_RU_POS2_SH	24
#define FWCMD_UL_FIXSTA_RU_POS2_MSK	0xff

#define FWCMD_UL_FIXSTA_TGT_RSSI0_SH	0
#define FWCMD_UL_FIXSTA_TGT_RSSI0_MSK	0xff
#define FWCMD_UL_FIXSTA_TGT_RSSI1_SH	8
#define FWCMD_UL_FIXSTA_TGT_RSSI1_MSK	0xff
#define FWCMD_UL_FIXSTA_TGT_RSSI2_SH	16
#define FWCMD_UL_FIXSTA_TGT_RSSI2_MSK	0xff
#define FWCMD_UL_FIXSTA_FIX_RSSI_SH	24
#define FWCMD_UL_FIXSTA_FIX_RSSI_MSK	0x1
#define FWCMD_UL_FIXSTA_FIXRATE_SH	25
#define FWCMD_UL_FIXSTA_FIXRATE_MSK	0x1
#define FWCMD_UL_FIXSTA_FIXCODE_SH	26
#define FWCMD_UL_FIXSTA_FIXCODE_MSK	0x1
#define FWCMD_UL_FIXSTA_CODING_SH	27
#define FWCMD_UL_FIXSTA_CODING_MSK	0x1

#define FWCMD_FIXSTA_UL_RATE_DCM_SH	0
#define FWCMD_FIXSTA_UL_RATE_DCM_MSK	0x1
#define FWCMD_FIXSTA_UL_RATE_SS_SH	1
#define FWCMD_FIXSTA_UL_RATE_SS_MSK	0x7
#define FWCMD_FIXSTA_UL_RATE_MCS_SH	4
#define FWCMD_FIXSTA_UL_RATE_MCS_MSK	0xF

/* UL RU grouping table*/
#define FWCMD_ULRU_GRPTBL_PSDMAX_SH	0
#define FWCMD_ULRU_GRPTBL_PSDMAX_MSK	0x1FF
#define FWCMD_ULRU_GRPTBL_PSDMIN_SH	9
#define FWCMD_ULRU_GRPTBL_PSDMIN_MSK	0x1FF
#define FWCMD_ULRU_GRPTBL_TFRATE_SH	18
#define FWCMD_ULRU_GRPTBL_TFRATE_MSK	0x1FF
#define FWCMD_ULRU_GRPTBL_FIXTFR_SH	27
#define FWCMD_ULRU_GRPTBL_FIXTFR_MSK	0x1

#define FWCMD_ULRU_GRPTBL_PPDUBW_SH	0
#define FWCMD_ULRU_GRPTBL_PPDUBW_MSK	0x3
#define FWCMD_ULRU_GRPTBL_RFGFIX_SH	2
#define FWCMD_ULRU_GRPTBL_RFGFIX_MSK	0x1
#define FWCMD_ULRU_GRPTBL_RFGIDX_SH	3
#define FWCMD_ULRU_GRPTBL_RFGIDX_MSK	0x3FF
#define FWCMD_ULRU_GRPTBL_FIXFLAG_SH	13
#define FWCMD_ULRU_GRPTBL_FIXFLAG_MSK	0x1

/* BB sta info*/
//sta capability
#define FWCMD_GILTF_48SPT_SH		0
#define FWCMD_GILTF_48SPT_MSK		0x1
#define FWCMD_GILTF_18SPT_SH		1
#define FWCMD_GILTF_18SPT_MSK		0x1
//downlink su
#define FWCMD_DLSU_INFO_EN_SH		8
#define FWCMD_DLSU_INFO_EN_MSK		0x1
#define FWCMD_DLSU_BW_SH		9
#define FWCMD_DLSU_BW_MSK		0x3
#define FWCMD_DLSU_GILTF_SH		11
#define FWCMD_DLSU_GILTF_MSK		0x7
#define FWCMD_DLSU_DOOPLER_CTRL_SH	14
#define FWCMD_DLSU_DOOPLER_CTRL_MSK	0x3
#define FWCMD_DLSU_CODING_SH		16
#define FWCMD_DLSU_CODING_MSK		0x1
#define FWCMD_DLSU_TXBF_SH		17
#define FWCMD_DLSU_TXBF_MSK		0x1
#define FWCMD_DLSU_STBC_SH		18
#define FWCMD_DLSU_STBC_MSK		0x1
#define FWCMD_DL_FWCQI_FLAG_SH		19
#define FWCMD_DL_FWCQI_FLAG_MSK		0x1
#define FWCMD_DLRU_RATETBL_RIDX_SH	20
#define FWCMD_DLRU_RATETBL_RIDX_MSK	0xF
#define FWCMD_CSIINFO_BITMAP_SH		24
#define FWCMD_CSIINFO_BITMAP_MSK	0xF

#define FWCMD_DL_SWGRP_BITMAP_SH	0
#define FWCMD_DL_SWGRP_BITMAP_MSK	0xFFFFFFFF

#define FWCMD_DLSU_DCM_SH		0
#define FWCMD_DLSU_DCM_MSK		0x1
#define FWCMD_DLSU_RATE_SH		7
#define FWCMD_DLSU_RATE_MSK		0x1FF
#define FWCMD_DLSU_PWR_SH		16
#define FWCMD_DLSU_PWR_MSK		0x3F

//uplink su
#define FWCMD_ULSU_INFO_EN_SH		0
#define FWCMD_ULSU_INFO_EN_MSK		0x1
#define FWCMD_ULSU_BW_SH		1
#define FWCMD_ULSU_BW_MSK		0x3
#define FWCMD_ULSU_GILTF_SH		3
#define FWCMD_ULSU_GILTF_MSK		0x7
#define FWCMD_ULSU_DOOPLER_CTRL_SH	6
#define FWCMD_ULSU_DOOPLER_CTRL_MSK	0x3
#define FWCMD_ULSU_DCM_SH		8
#define FWCMD_ULSU_DCM_MSK		0x1
#define FWCMD_ULSU_SS_SH		9
#define FWCMD_ULSU_SS_MSK		0x7
#define FWCMD_ULSU_MCS_SH		12
#define FWCMD_ULSU_MCS_MSK		0xF
#define FWCMD_UL_FWCQI_FLAG_SH		16
#define FWCMD_UL_FWCQI_FLAG_MSK		0x1
#define FWCMD_ULRU_RATETBL_RIDX_SH	17
#define FWCMD_ULRU_RATETBL_RIDX_MSK	0xF
#define FWCMD_ULSU_STBC_SH		21
#define FWCMD_ULSU_STBC_MSK		0x1
#define FWCMD_ULSU_CODING_SH		22
#define FWCMD_ULSU_CODING_MSK		0x1
#define FWCMD_ULSU_RSSI_M_SH		23
#define FWCMD_ULSU_RSSI_M_MSK		0x1FF

#define FWCMD_UL_SWGRP_BITMAP_SH	0
#define FWCMD_UL_SWGRP_BITMAP_MSK	0xFFFFFFFF

/* mu fixinfo*/
#define FWCMD_MUINFO_THOLDEN_SH		0
#define FWCMD_MUINFO_THOLDEN_MSK	0x1
#define FWCMD_MUINFO_THOLD_SH		1
#define FWCMD_MUINFO_THOLD_MSK		0x3FFFFFFF
#define FWCMD_BYPASS_THOLD_SH		31
#define FWCMD_BYPASS_THOLD_MSK		0x1

#define FWCMD_MUINFO_FIXMU_EN_SH	0
#define FWCMD_MUINFO_FIXMU_EN_MSK	0x1
#define FWCMD_MUINFO_FIXMU_ID_SH	1
#define FWCMD_MUINFO_FIXMU_ID_MSK	0x7F

/* ul fixinfo for Fixed RUA*/
#define FWCMD_ULINFO_NDPADUR_SH		0
#define FWCMD_ULINFO_NDPADUR_MSK	0xFFFF
#define FWCMD_ULINFO_TFTYPE_SH		16
#define FWCMD_ULINFO_TFTYPE_MSK		0x7
#define FWCMD_ULINFO_SIGEN_SH		19
#define FWCMD_ULINFO_SIGEN_MSK		0x1
#define FWCMD_ULINFO_SIGSC_SH		20
#define FWCMD_ULINFO_SIGSC_MSK		0xF
#define FWCMD_ULINFO_MURTS_SH		24
#define FWCMD_ULINFO_MURTS_MSK		0x1
#define FWCMD_ULINFO_NDPA_SH		25
#define FWCMD_ULINFO_NDPA_MSK		0x3
#define FWCMD_ULINFO_SNDPKT_SH		27
#define FWCMD_ULINFO_SNDPKT_MSK		0x3
#define FWCMD_ULINFO_GI_LTF_SH		29
#define FWCMD_ULINFO_GI_LTF_MSK		0x7

#define FWCMD_ULINFO_DATART_SH		0
#define FWCMD_ULINFO_DATART_MSK		0x1FF
#define FWCMD_ULINFO_DATAER_SH		9
#define FWCMD_ULINFO_DATAER_MSK		0x1
#define FWCMD_ULINFO_DATABW_SH		10
#define FWCMD_ULINFO_DATABW_MSK		0x3
#define FWCMD_ULINFO_STBC_SH		12
#define FWCMD_ULINFO_STBC_MSK		0x3
#define FWCMD_ULINFO_LDPC_SH		14
#define FWCMD_ULINFO_LDPC_MSK		0x1
#define FWCMD_ULINFO_DATADCM_SH		15
#define FWCMD_ULINFO_DATADCM_MSK	0x1
#define FWCMD_ULINFO_APEPLEN_SH		16
#define FWCMD_ULINFO_APEPLEN_MSK	0xFFF
#define FWCMD_ULINFO_MORETF_SH		28
#define FWCMD_ULINFO_MORETF_MSK		0x1
#define FWCMD_ULINFO_DATA_BWER_SH	29
#define FWCMD_ULINFO_DATA_BWER_MSK	0x1

#define FWCMD_ULINFO_MULPORT_SH		0
#define FWCMD_ULINFO_MULPORT_MSK	0x7
#define FWCMD_ULINFO_MBSSID_SH		3
#define FWCMD_ULINFO_MBSSID_MSK		0xF
#define FWCMD_ULINFO_TXPWR_MODE_SH	7
#define FWCMD_ULINFO_TXPWR_MODE_MSK	0x7

#define FWCMD_ULINFO_MACID_SH		0
#define FWCMD_ULINFO_MACID_MSK		0xFF
#define FWCMD_ULINFO_PREF_AC_SH		8
#define FWCMD_ULINFO_PREF_AC_MSK	0x3

#define FWCMD_ULRUA_RU2SU_SH		0
#define FWCMD_ULRUA_RU2SU_MSK		0x1
#define FWCMD_ULRUA_PPDW_BW_SH		1
#define FWCMD_ULRUA_PPDW_BW_MSK		0x3
#define FWCMD_ULRUA_GI_LTF_SH		3
#define FWCMD_ULRUA_GI_LTF_MSK		0x7
#define FWCMD_ULRUA_STBC_SH		6
#define FWCMD_ULRUA_STBC_MSK		0x1
#define FWCMD_ULRUA_DPLR_SH		7
#define FWCMD_ULRUA_DPLR_MSK		0x1
#define FWCMD_ULRUA_RFGFIX_SH		8
#define FWCMD_ULRUA_RFGFIX_MSK		0x1
#define FWCMD_ULRUA_RFGIDX_SH		9
#define FWCMD_ULRUA_RFGIDX_MSK		0x3FF
#define FWCMD_ULRUA_TB_NOM_SH		19
#define FWCMD_ULRUA_TB_NOM_MSK		0x3
#define FWCMD_ULRUA_LTF_MA_SH		24
#define FWCMD_ULRUA_LTF_MA_MSK		0x7
#define FWCMD_ULRUA_STANUM_SH		27
#define FWCMD_ULRUA_STANUM_MSK		0xF

#define FWCMD_ULRUA_GRPMODE_SH		0
#define FWCMD_ULRUA_GRPMODE_MSK		0x1
#define FWCMD_ULRUA_GRPID_SH		1
#define FWCMD_ULRUA_GRPID_MSK		0x3F
#define FWCMD_ULRUA_FIXMODE_SH		7
#define FWCMD_ULRUA_FIXMODE_MSK		0x1

#define FWCMD_ULRUA_DROP_SH		0
#define FWCMD_ULRUA_DROP_MSK		0x1
#define FWCMD_ULRUA_TGT_RSSI_SH		1
#define FWCMD_ULRUA_TGT_RSSI_MSK	0x7F
#define FWCMD_ULRUA_MACID_SH		8
#define FWCMD_ULRUA_MACID_MSK		0xFF
#define FWCMD_ULRUA_RUPOS_SH		16
#define FWCMD_ULRUA_RUPOS_MSK		0xFF
#define FWCMD_ULRUA_CODE_SH		24
#define FWCMD_ULRUA_CODE_MSK		0x1
#define FWCMD_ULRUA_VIP_SH		25
#define FWCMD_ULRUA_VIP_MSK		0x1

#define FWCMD_ULRUA_DCM_SH		0
#define FWCMD_ULRUA_DCM_MSK		0x1
#define FWCMD_ULRUA_SS_SH		1
#define FWCMD_ULRUA_SS_MSK		0x7
#define FWCMD_ULRUA_MCS_SH		4
#define FWCMD_ULRUA_MCS_MSK		0xF
#define FWCMD_ULRUA_RT_TBLCOL_SH	8
#define FWCMD_ULRUA_RT_TBLCOL_MSK	0x3F
#define FWCMD_ULRUA_PRTL_ALLOC_SH	14
#define FWCMD_ULRUA_PRTL_ALLOC_MSK	0x1
#define FWCMD_ULRUA_RATE_CHG_SH		15
#define FWCMD_ULRUA_RATE_CHG_MSK	0x1
#endif
